#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
static int32_t SUB_ID_SPVM__Unicode__uchar = - 1;
static int32_t SUB_ID_SPVM__Util__E = - 1;
static int32_t SUB_ID_SPVM__Util__PI = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__INT8_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__chomp_crlf = - 1;
static int32_t SUB_ID_SPVM__Util__chomp_lf = - 1;
static int32_t SUB_ID_SPVM__Util__contains = - 1;
static int32_t SUB_ID_SPVM__Util__copy_barray = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__copy_darray = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__copy_farray = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__copy_iarray = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__copy_larray = - 1;
static int32_t SUB_ID_SPVM__Int__new = - 1;
static int32_t SUB_ID_SPVM__Util__copy_oarray = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MIN = - 1;
static int32_t SUB_ID_SPVM__Util__copy_sarray = - 1;
static int32_t SUB_ID_SPVM__Util__copy_str = - 1;
static int32_t SUB_ID_SPVM__Util__copy_strarray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_barray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_darray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_farray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_iarray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_larray = - 1;
static int32_t SUB_ID_TestCase__Minimal__new = - 1;
static int32_t SUB_ID_SPVM__Util__equals_oarray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_sarray = - 1;
static int32_t SUB_ID_SPVM__Util__equals_strarray = - 1;
static int32_t SUB_ID_SPVM__Util__get_type_name = - 1;
static int32_t SUB_ID_SPVM__Util__index = - 1;
static int32_t SUB_ID_SPVM__Util__INT32_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__is_perl_space = - 1;
static int32_t SUB_ID_SPVM__Util__is_perl_word = - 1;
static int32_t SUB_ID_SPVM__Util__isalnum = - 1;
static int32_t SUB_ID_SPVM__Util__isalpha = - 1;
static int32_t SUB_ID_SPVM__Util__isblank = - 1;
static int32_t SUB_ID_SPVM__Util__iscntrl = - 1;
static int32_t SUB_ID_SPVM__Util__isdigit = - 1;
static int32_t SUB_ID_SPVM__Util__isgraph = - 1;
static int32_t SUB_ID_SPVM__Util__islower = - 1;
static int32_t SUB_ID_SPVM__Util__isprint = - 1;
static int32_t SUB_ID_SPVM__Util__ispunct = - 1;
static int32_t SUB_ID_SPVM__Util__isspace = - 1;
static int32_t SUB_ID_SPVM__Util__isupper = - 1;
static int32_t SUB_ID_SPVM__Util__isxdigit = - 1;
static int32_t SUB_ID_SPVM__Util__join = - 1;
static int32_t SUB_ID_SPVM__Util__joinb = - 1;
static int32_t SUB_ID_SPVM__Util__joind = - 1;
static int32_t SUB_ID_SPVM__Util__joinf = - 1;
static int32_t SUB_ID_SPVM__Util__joini = - 1;
static int32_t SUB_ID_SPVM__Util__joinl = - 1;
static int32_t SUB_ID_TestCase__Minimal__newp = - 1;
static int32_t SUB_ID_SPVM__Util__joino = - 1;
static int32_t SUB_ID_SPVM__Util__joins = - 1;
static int32_t SUB_ID_SPVM__Util__lc = - 1;
static int32_t SUB_ID_SPVM__Util__lcfirst = - 1;
static int32_t SUB_ID_SPVM__Util__INT64_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__memcpyb = - 1;
static int32_t SUB_ID_SPVM__Util__memmoveb = - 1;
static int32_t SUB_ID_SPVM__Util__new_object_array_proto = - 1;
static int32_t SUB_ID_SPVM__Time__time = - 1;
static int32_t SUB_ID_SPVM__Util__rand = - 1;
static int32_t SUB_ID_SPVM__Util__random = - 1;
static int32_t SUB_ID_SPVM__Util__replace = - 1;
static int32_t SUB_ID_SPVM__Util__replace_all = - 1;
static int32_t SUB_ID_SPVM__Util__reverseb = - 1;
static int32_t SUB_ID_SPVM__Util__DBL_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__reversed = - 1;
static int32_t SUB_ID_SPVM__Util__FLT_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__reversef = - 1;
static int32_t SUB_ID_SPVM__Util__reversei = - 1;
static int32_t SUB_ID_SPVM__Util__reversel = - 1;
static int32_t SUB_ID_SPVM__Util__reverseo = - 1;
static int32_t SUB_ID_SPVM__EqualityChecker__SameObject__new = - 1;
static int32_t SUB_ID_SPVM__Util__INT16_MAX = - 1;
static int32_t SUB_ID_SPVM__Util__reverses = - 1;
static int32_t SUB_ID_SPVM__Util__rindex = - 1;
static int32_t SUB_ID_SPVM__Util__sliceb = - 1;
static int32_t SUB_ID_SPVM__Util__sliced = - 1;
static int32_t SUB_ID_SPVM__Util__slicef = - 1;
static int32_t SUB_ID_SPVM__Util__slicei = - 1;
static int32_t SUB_ID_SPVM__Util__slicel = - 1;
static int32_t SUB_ID_SPVM__Util__sliceo = - 1;
static int32_t SUB_ID_SPVM__Util__slices = - 1;
static int32_t SUB_ID_SPVM__Util__split = - 1;
static int32_t SUB_ID_TestCase__Lib__SPVM__Util___first_uchar = - 1;
static int32_t SUB_ID_SPVM__Util__sprintf = - 1;
static int32_t SUB_ID_SPVM__Util__strtod = - 1;
static int32_t SUB_ID_SPVM__Util__strtof = - 1;
static int32_t SUB_ID_SPVM__Util__strtoi = - 1;
static int32_t SUB_ID_SPVM__Util__strtol = - 1;
static int32_t SUB_ID_SPVM__Util__tolower = - 1;
static int32_t SUB_ID_SPVM__Util__toupper = - 1;
static int32_t SUB_ID_SPVM__Util__uc = - 1;
static int32_t SUB_ID_SPVM__Util__ucfirst = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_double = -1;
static int32_t BASIC_TYPE_ID_float = -1;
static int32_t BASIC_TYPE_ID_int = -1;
static int32_t BASIC_TYPE_ID_long = -1;
static int32_t BASIC_TYPE_ID_object = -1;
static int32_t BASIC_TYPE_ID_anon1 = -1;
static int32_t BASIC_TYPE_ID_short = -1;
static int32_t BASIC_TYPE_ID_TestCase__Minimal = -1;
static int32_t BASIC_TYPE_ID_anon0 = -1;
static int32_t BASIC_TYPE_ID_anon2 = -1;
// Function Declarations
// [SIG]int(string)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util___first_uchar(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_E(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_PI(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_byte_constant(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_chomp_crlf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_chomp_lf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_contains(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_barray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_darray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_farray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_iarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_larray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_oarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_sarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_str(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_strarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_barray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_darray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_farray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_iarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_larray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_oarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_sarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_strarray(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_get_type_name(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_index(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_int_constant(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_is_perl_space(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_is_perl_word(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isalnum(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isalpha(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isblank(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_iscntrl(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isdigit(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isgraph(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_islower(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isprint(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_ispunct(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isspace(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isupper(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isxdigit(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_join(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joinb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joind(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joinf(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joini(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joinl(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joino(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joins(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_lc(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_lcfirst(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_long_constant(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_memcpyb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_memmoveb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_new_object_array_proto(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_rand(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_random(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_replace(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_replace_all(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reverseb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversed(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversei(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversel(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reverseo(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reverses(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_rindex(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_short_constant(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sliceb(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sliced(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_slicef(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_slicei(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_slicel(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sliceo(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_slices(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_split(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_U(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_all(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_c(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_d(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_f(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_ld(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_percent(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_sprintf_s(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_strtod(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_strtof(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_strtoi(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_strtol(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_tolower(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_toupper(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_uc(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_ucfirst(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util___first_uchar(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  void* ref_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L3: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[1];
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // PUSH_ARG_REF
  *(void**)&stack[1] = ref_vars[0];
L6: // CALL_SUB_INT
  // SPVM::Unicode->uchar
  {
    if (SUB_ID_SPVM__Unicode__uchar < 0) {
      SUB_ID_SPVM__Unicode__uchar = env->get_sub_id(env, "SPVM::Unicode", "uchar", "int(string,&int)");
      if (SUB_ID_SPVM__Unicode__uchar < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Unicode uchar");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Unicode__uchar;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "_first_uchar";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L11;
  }
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L11;
L9: // INIT_INT
  int_vars[5] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L11;
L11: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L12: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_E(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->E
  {
    if (SUB_ID_SPVM__Util__E < 0) {
      SUB_ID_SPVM__Util__E = env->get_sub_id(env, "SPVM::Util", "E", "double()");
      if (SUB_ID_SPVM__Util__E < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util E");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__E;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_E";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.7182818284590451;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_PI(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_DOUBLE
  // SPVM::Util->PI
  {
    if (SUB_ID_SPVM__Util__PI < 0) {
      SUB_ID_SPVM__Util__PI = env->get_sub_id(env, "SPVM::Util", "PI", "double()");
      if (SUB_ID_SPVM__Util__PI < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util PI");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__PI;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_PI";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2395;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L14;
  }
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.1415926535897931;
L4: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_NE_ZERO
  if (int_vars[0]) { goto L10; }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L14;
L9: // GOTO
  goto L10;
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L14;
L12: // INIT_INT
  int_vars[6] = 0;
L13: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L14;
L14: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_byte_constant(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_byte_constant";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1877;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L3: // CONVERT_BYTE_TO_INT
  int_vars[1] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[2] = -128;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[2];
L6: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[1];
L7: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[3]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L23; }
L10: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_byte_constant";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1878;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L27;
  }
L12: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 127;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L15: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L16: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[4]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L27;
L21: // GOTO
  goto L22;
L22: // GOTO
  goto L23;
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L27;
L25: // INIT_INT
  int_vars[6] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L27;
L27: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_chomp_crlf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x0D\x0A", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_crlf
  {
    if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
      SUB_ID_SPVM__Util__chomp_crlf = env->get_sub_id(env, "SPVM::Util", "chomp_crlf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_crlf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_crlf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 597;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L9: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 598;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L20: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_crlf
  {
    if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
      SUB_ID_SPVM__Util__chomp_crlf = env->get_sub_id(env, "SPVM::Util", "chomp_crlf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_crlf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_crlf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 604;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L27: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 605;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L34: // GOTO
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "", 0));
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_crlf
  {
    if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
      SUB_ID_SPVM__Util__chomp_crlf = env->get_sub_id(env, "SPVM::Util", "chomp_crlf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_crlf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_crlf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 611;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "", 0));
L45: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61", 1));
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L59: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_crlf
  {
    if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
      SUB_ID_SPVM__Util__chomp_crlf = env->get_sub_id(env, "SPVM::Util", "chomp_crlf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_crlf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_crlf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_crlf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 618;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L62: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61", 1));
L63: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_crlf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 619;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L70: // GOTO
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L77;
L75: // INIT_INT
  int_vars[6] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L77;
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_chomp_lf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x0A", 4));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L9: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L20: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 579;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L27: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L34: // GOTO
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "", 0));
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // CALL_SUB_OBJECT
  // SPVM::Util->chomp_lf
  {
    if (SUB_ID_SPVM__Util__chomp_lf < 0) {
      SUB_ID_SPVM__Util__chomp_lf = env->get_sub_id(env, "SPVM::Util", "chomp_lf", "string(string)");
      if (SUB_ID_SPVM__Util__chomp_lf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util chomp_lf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__chomp_lf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 586;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "", 0));
L45: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_chomp_lf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[6] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L59;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_contains(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63\x64", 3));
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L7: // CALL_SUB_INT
  // SPVM::Util->contains
  {
    if (SUB_ID_SPVM__Util__contains < 0) {
      SUB_ID_SPVM__Util__contains = env->get_sub_id(env, "SPVM::Util", "contains", "int(string,string)");
      if (SUB_ID_SPVM__Util__contains < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util contains");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__contains;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_contains";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1775;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L9: // BOOL_INT
  int_vars[0] = int_vars[2];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L33;
L13: // GOTO
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L18: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x70\x70\x70", 3));
L19: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L21: // CALL_SUB_INT
  // SPVM::Util->contains
  {
    if (SUB_ID_SPVM__Util__contains < 0) {
      SUB_ID_SPVM__Util__contains = env->get_sub_id(env, "SPVM::Util", "contains", "int(string,string)");
      if (SUB_ID_SPVM__Util__contains < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util contains");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__contains;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_contains";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1784;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L23: // BOOL_INT
  int_vars[0] = int_vars[2];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L26: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L33;
L27: // GOTO
  goto L28;
L28: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_barray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L15: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // CALL_SUB_OBJECT
  // SPVM::Util->copy_barray
  {
    if (SUB_ID_SPVM__Util__copy_barray < 0) {
      SUB_ID_SPVM__Util__copy_barray = env->get_sub_id(env, "SPVM::Util", "copy_barray", "byte[](byte[])");
      if (SUB_ID_SPVM__Util__copy_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2427;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L30: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2431;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L41: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L43: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L50: // ARRAY_FETCH_BYTE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        byte_vars[0] = ((int8_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L52: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L53: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[1] = *(int8_t*)&stack[0];
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L55: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[1];
L56: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L61: // GOTO
  goto L62;
L62: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2439;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L65: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L70: // GOTO
  goto L71;
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L75;
L73: // INIT_INT
  int_vars[6] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L75;
L75: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L76: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_darray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L6: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L10: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 0.25;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L14: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L17: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_OBJECT
  // SPVM::Util->copy_darray
  {
    if (SUB_ID_SPVM__Util__copy_darray < 0) {
      SUB_ID_SPVM__Util__copy_darray = env->get_sub_id(env, "SPVM::Util", "copy_darray", "double[](double[])");
      if (SUB_ID_SPVM__Util__copy_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2540;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L29: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L30: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2546;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L39: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L40: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L47: // ARRAY_FETCH_DOUBLE
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        double_vars[0] = ((double*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2550;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L49: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[1] = *(double*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2550;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L51: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L56: // GOTO
  goto L57;
L57: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L60: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L65: // GOTO
  goto L66;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L70;
L68: // INIT_INT
  int_vars[6] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L70;
L70: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L71: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_farray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[2];
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L5: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L6: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L10: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 0.25;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L12: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L14: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L17: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_OBJECT
  // SPVM::Util->copy_farray
  {
    if (SUB_ID_SPVM__Util__copy_farray < 0) {
      SUB_ID_SPVM__Util__copy_farray = env->get_sub_id(env, "SPVM::Util", "copy_farray", "float[](float[])");
      if (SUB_ID_SPVM__Util__copy_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2517;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2519;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L29: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L30: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.5;
L31: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_NE_ZERO
  if (int_vars[0]) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L72;
L36: // GOTO
  goto L37;
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2523;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L40: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L41: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 0.25;
L42: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L43: // BOOL_INT
  int_vars[0] = int_vars[0];
L44: // IF_NE_ZERO
  if (int_vars[0]) { goto L48; }
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L72;
L47: // GOTO
  goto L48;
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L49: // ARRAY_FETCH_FLOAT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        float_vars[0] = ((float*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L51: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[1] = *(float*)&stack[0];
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2527;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L53: // EQ_FLOAT
  int_vars[0] = (float_vars[0] == float_vars[1]);
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L59; }
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L72;
L58: // GOTO
  goto L59;
L59: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2531;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L62: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L72;
L67: // GOTO
  goto L68;
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L72;
L70: // INIT_INT
  int_vars[6] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_iarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L17: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_OBJECT
  // SPVM::Util->copy_iarray
  {
    if (SUB_ID_SPVM__Util__copy_iarray < 0) {
      SUB_ID_SPVM__Util__copy_iarray = env->get_sub_id(env, "SPVM::Util", "copy_iarray", "int[](int[])");
      if (SUB_ID_SPVM__Util__copy_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2471;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[3] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2473;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L35: // GOTO
  goto L36;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2477;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L40: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L47: // ARRAY_FETCH_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        int_vars[5] = ((int32_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L49: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2481;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L51: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L56: // GOTO
  goto L57;
L57: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2485;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L70;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L60: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L70;
L65: // GOTO
  goto L66;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L70;
L68: // INIT_INT
  int_vars[6] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L70;
L70: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L71: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_larray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2493;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // CALL_SUB_OBJECT
  // SPVM::Util->copy_larray
  {
    if (SUB_ID_SPVM__Util__copy_larray < 0) {
      SUB_ID_SPVM__Util__copy_larray = env->get_sub_id(env, "SPVM::Util", "copy_larray", "long[](long[])");
      if (SUB_ID_SPVM__Util__copy_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2496;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L31: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[3];
L32: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L73;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L42: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L43: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L73;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L50: // ARRAY_FETCH_LONG
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        long_vars[0] = ((int64_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L52: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[1] = *(int64_t*)&stack[0];
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2504;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L54: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L55: // BOOL_INT
  int_vars[0] = int_vars[0];
L56: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L73;
L59: // GOTO
  goto L60;
L60: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L73;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L63: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L73;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L73;
L71: // INIT_INT
  int_vars[6] = 0;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L73;
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_oarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[18];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L8: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L18: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L19: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L22: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L24: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L27: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[6];
L28: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L31: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 152;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L34: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L41: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon1 < 0) {
      BASIC_TYPE_ID_anon1 = env->get_basic_type_id(env, "anon1");
      if (BASIC_TYPE_ID_anon1 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon1");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon1;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object);
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L45: // CALL_SUB_OBJECT
  // SPVM::Util->copy_oarray
  {
    if (SUB_ID_SPVM__Util__copy_oarray < 0) {
      SUB_ID_SPVM__Util__copy_oarray = env->get_sub_id(env, "SPVM::Util", "copy_oarray", "object[](object[],SPVM::Cloner)");
      if (SUB_ID_SPVM__Util__copy_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 153;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L48: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L50: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L54: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L56: // EQ_OBJECT
  int_vars[0] = (object_vars[0] == object_vars[2]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L64; }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L60: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L63: // GOTO
  goto L64;
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L67: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L71: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 163;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L73: // EQ_OBJECT
  int_vars[0] = (object_vars[0] == object_vars[2]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L84: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 167;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L87: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L88: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 167;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L90: // EQ_OBJECT
  int_vars[0] = (object_vars[0] == object_vars[2]);
L91: // BOOL_INT
  int_vars[0] = int_vars[0];
L92: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L94: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L97: // GOTO
  goto L98;
L98: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L100: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L101: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L103: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 171;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L105: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L106: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L107: // BOOL_INT
  int_vars[0] = int_vars[0];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L109: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L112: // GOTO
  goto L113;
L113: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L114: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L115: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L116: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 175;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L118: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 175;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L121: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L128; }
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L127: // GOTO
  goto L128;
L128: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L130: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L131: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], object); 
      } 
    } 
  } 
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L133: // CONVERT_INT_OBJECT_TO_INT
  {
    void* object = object_vars[0];
    if (object == NULL) {
      void* exception = env->new_string_raw(env, "Can't convert undef value.");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == (intptr_t)(void*)env->int_object_basic_type_id && object_type_dimension_id == 0) {
        SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
        
int_vars[5] = *(int32_t*)&fields[0];
      }
      else {
        void* exception = env->new_string_raw(env, "Can't convert imcompatible object type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L134: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L135: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 179;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L137: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L138: // BOOL_INT
  int_vars[0] = int_vars[0];
L139: // IF_NE_ZERO
  if (int_vars[0]) { goto L144; }
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L141: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L142: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L143: // GOTO
  goto L144;
L144: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L145: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 183;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L147: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L148: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L149: // BOOL_INT
  int_vars[0] = int_vars[0];
L150: // IF_NE_ZERO
  if (int_vars[0]) { goto L154; }
L151: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L152: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L153: // GOTO
  goto L154;
L154: // NE_OBJECT
  int_vars[0] = (object_vars[5] != object_vars[1]);
L155: // BOOL_INT
  int_vars[0] = int_vars[0];
L156: // IF_NE_ZERO
  if (int_vars[0]) { goto L160; }
L157: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L158: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L159: // GOTO
  goto L160;
L160: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L164;
L162: // INIT_INT
  int_vars[6] = 0;
L163: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L164;
L164: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L165: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_sarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2447;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L25: // CALL_SUB_OBJECT
  // SPVM::Util->copy_sarray
  {
    if (SUB_ID_SPVM__Util__copy_sarray < 0) {
      SUB_ID_SPVM__Util__copy_sarray = env->get_sub_id(env, "SPVM::Util", "copy_sarray", "short[](short[])");
      if (SUB_ID_SPVM__Util__copy_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2448;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L28: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2450;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L30: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L31: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L32: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L37: // GOTO
  goto L38;
L38: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L39: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L41: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L42: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L43: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L44: // BOOL_INT
  int_vars[0] = int_vars[0];
L45: // IF_NE_ZERO
  if (int_vars[0]) { goto L49; }
L46: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L47: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L48: // GOTO
  goto L49;
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L50: // ARRAY_FETCH_SHORT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        short_vars[0] = ((int16_t*)((intptr_t)array + object_header_byte_size))[index];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2458;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L52: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L53: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[1] = *(int16_t*)&stack[0];
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2458;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L55: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[1];
L56: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L62; }
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L60: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L61: // GOTO
  goto L62;
L62: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L75;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L65: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L75;
L70: // GOTO
  goto L71;
L71: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L72: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L75;
L73: // INIT_INT
  int_vars[6] = 0;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L75;
L75: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L76: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_str(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Util->copy_str
  {
    if (SUB_ID_SPVM__Util__copy_str < 0) {
      SUB_ID_SPVM__Util__copy_str = env->get_sub_id(env, "SPVM::Util", "copy_str", "string(string)");
      if (SUB_ID_SPVM__Util__copy_str < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_str");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_str;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_str";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2414;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L9: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_str";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2416;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L22;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L22;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L22;
L20: // INIT_INT
  int_vars[6] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L22;
L22: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_copy_strarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[13];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x64\x65\x66", 3));
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x68\x69\x6A", 3));
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2562;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L28: // CALL_SUB_OBJECT
  // SPVM::Util->copy_strarray
  {
    if (SUB_ID_SPVM__Util__copy_strarray < 0) {
      SUB_ID_SPVM__Util__copy_strarray = env->get_sub_id(env, "SPVM::Util", "copy_strarray", "string[](string[])");
      if (SUB_ID_SPVM__Util__copy_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util copy_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__copy_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2563;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L32: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L38: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2565;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L46: // GOTO
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L50: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L54: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L56: // EQ_OBJECT
  int_vars[0] = (object_vars[1] == object_vars[2]);
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L60: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L63: // GOTO
  goto L64;
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L67: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L71: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L73: // EQ_OBJECT
  int_vars[0] = (object_vars[1] == object_vars[2]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L81; }
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L77: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L78: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L79: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L80: // GOTO
  goto L81;
L81: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L82: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[4] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_copy_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L85: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L86: // BOOL_INT
  int_vars[0] = int_vars[0];
L87: // IF_NE_ZERO
  if (int_vars[0]) { goto L91; }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L90: // GOTO
  goto L91;
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L95;
L93: // INIT_INT
  int_vars[6] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_barray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L15: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2191;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L25: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L33: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L34: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L35: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L37: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L40: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L43: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L47: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L52: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L55: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L57: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L60: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L64: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L67: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L69: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L72: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L74: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L77: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[7];
L78: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L79: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L82: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L86: // CALL_SUB_INT
  // SPVM::Util->equals_barray
  {
    if (SUB_ID_SPVM__Util__equals_barray < 0) {
      SUB_ID_SPVM__Util__equals_barray = env->get_sub_id(env, "SPVM::Util", "equals_barray", "int(byte[],byte[])");
      if (SUB_ID_SPVM__Util__equals_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L88: // BOOL_INT
  int_vars[0] = int_vars[2];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L92: // GOTO
  goto L93;
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L95: // CALL_SUB_INT
  // SPVM::Util->equals_barray
  {
    if (SUB_ID_SPVM__Util__equals_barray < 0) {
      SUB_ID_SPVM__Util__equals_barray = env->get_sub_id(env, "SPVM::Util", "equals_barray", "int(byte[],byte[])");
      if (SUB_ID_SPVM__Util__equals_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L97: // BOOL_INT
  int_vars[0] = int_vars[2];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L101: // GOTO
  goto L102;
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L104: // CALL_SUB_INT
  // SPVM::Util->equals_barray
  {
    if (SUB_ID_SPVM__Util__equals_barray < 0) {
      SUB_ID_SPVM__Util__equals_barray = env->get_sub_id(env, "SPVM::Util", "equals_barray", "int(byte[],byte[])");
      if (SUB_ID_SPVM__Util__equals_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_barray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2208;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L106: // BOOL_INT
  int_vars[0] = int_vars[2];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L111; }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L110: // GOTO
  goto L111;
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L115;
L113: // INIT_INT
  int_vars[6] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L115;
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_darray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  double double_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.5;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L13: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L16: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L25: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L29: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.5;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L33: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MIN
  {
    if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
      SUB_ID_SPVM__Util__DBL_MIN = env->get_sub_id(env, "SPVM::Util", "DBL_MIN", "double()");
      if (SUB_ID_SPVM__Util__DBL_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L36: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L39: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L45: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L47: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L49: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 1.5;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L51: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2334;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L54: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L55: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L58: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L60: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.0;
L61: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L65: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 1.5;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L67: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L69: // MOVE_CONSTANT_DOUBLE
  double_vars[3] = 0.5;
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L71: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2335;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L74: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L77: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L78: // CALL_SUB_INT
  // SPVM::Util->equals_darray
  {
    if (SUB_ID_SPVM__Util__equals_darray < 0) {
      SUB_ID_SPVM__Util__equals_darray = env->get_sub_id(env, "SPVM::Util", "equals_darray", "int(double[],double[])");
      if (SUB_ID_SPVM__Util__equals_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2338;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L80: // BOOL_INT
  int_vars[0] = int_vars[2];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L107;
L84: // GOTO
  goto L85;
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L87: // CALL_SUB_INT
  // SPVM::Util->equals_darray
  {
    if (SUB_ID_SPVM__Util__equals_darray < 0) {
      SUB_ID_SPVM__Util__equals_darray = env->get_sub_id(env, "SPVM::Util", "equals_darray", "int(double[],double[])");
      if (SUB_ID_SPVM__Util__equals_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2344;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[2];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L107;
L93: // GOTO
  goto L94;
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L96: // CALL_SUB_INT
  // SPVM::Util->equals_darray
  {
    if (SUB_ID_SPVM__Util__equals_darray < 0) {
      SUB_ID_SPVM__Util__equals_darray = env->get_sub_id(env, "SPVM::Util", "equals_darray", "int(double[],double[])");
      if (SUB_ID_SPVM__Util__equals_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_darray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L98: // BOOL_INT
  int_vars[0] = int_vars[2];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L107;
L102: // GOTO
  goto L103;
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_farray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  float float_vars[4];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L5: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L9: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.5;
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L11: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L13: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L16: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2304;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L18: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L19: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L25: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L29: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.5;
L30: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L31: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L33: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MIN
  {
    if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
      SUB_ID_SPVM__Util__FLT_MIN = env->get_sub_id(env, "SPVM::Util", "FLT_MIN", "float()");
      if (SUB_ID_SPVM__Util__FLT_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L36: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L39: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L45: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L47: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L49: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 1.5;
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L51: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2306;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L54: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L55: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L56: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L58: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L60: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.0;
L61: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L65: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 1.5;
L66: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L67: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L69: // MOVE_CONSTANT_FLOAT
  float_vars[3] = 0.5;
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L71: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2307;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L74: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L77: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L78: // CALL_SUB_INT
  // SPVM::Util->equals_farray
  {
    if (SUB_ID_SPVM__Util__equals_farray < 0) {
      SUB_ID_SPVM__Util__equals_farray = env->get_sub_id(env, "SPVM::Util", "equals_farray", "int(float[],float[])");
      if (SUB_ID_SPVM__Util__equals_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2310;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L80: // BOOL_INT
  int_vars[0] = int_vars[2];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L85; }
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L83: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L107;
L84: // GOTO
  goto L85;
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L87: // CALL_SUB_INT
  // SPVM::Util->equals_farray
  {
    if (SUB_ID_SPVM__Util__equals_farray < 0) {
      SUB_ID_SPVM__Util__equals_farray = env->get_sub_id(env, "SPVM::Util", "equals_farray", "int(float[],float[])");
      if (SUB_ID_SPVM__Util__equals_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2316;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[2];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L107;
L93: // GOTO
  goto L94;
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L96: // CALL_SUB_INT
  // SPVM::Util->equals_farray
  {
    if (SUB_ID_SPVM__Util__equals_farray < 0) {
      SUB_ID_SPVM__Util__equals_farray = env->get_sub_id(env, "SPVM::Util", "equals_farray", "int(float[],float[])");
      if (SUB_ID_SPVM__Util__equals_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_farray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2322;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L107;
  }
L98: // BOOL_INT
  int_vars[0] = int_vars[2];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L107;
L102: // GOTO
  goto L103;
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L107;
L105: // INIT_INT
  int_vars[6] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L107;
L107: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L108: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_iarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L17: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L27: // MOVE_INT
  int_vars[4] = int_vars[3];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L29: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L32: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L33: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L35: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L38: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L45: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // MOVE_INT
  int_vars[4] = int_vars[3];
L49: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L50: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L53: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L54: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L57: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L61: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L64: // MOVE_INT
  int_vars[4] = int_vars[3];
L65: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L66: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L69: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L70: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L73: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L74: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L77: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L78: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L79: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L81: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2254;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L83: // BOOL_INT
  int_vars[0] = int_vars[2];
L84: // IF_NE_ZERO
  if (int_vars[0]) { goto L88; }
L85: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L110;
L87: // GOTO
  goto L88;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L89: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L90: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L92: // BOOL_INT
  int_vars[0] = int_vars[2];
L93: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L94: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L110;
L96: // GOTO
  goto L97;
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L98: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L99: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_iarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2266;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L110;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[2];
L102: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L110;
L105: // GOTO
  goto L106;
L106: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L107: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L110;
L108: // INIT_INT
  int_vars[6] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L110;
L110: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L111: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_larray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int64_t long_vars[3];
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2276;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L25: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L33: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L34: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L35: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L37: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L40: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L43: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L47: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L52: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L55: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L57: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2278;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L60: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L64: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L67: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[3];
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L69: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L72: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[5];
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L74: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L77: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[7];
L78: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L79: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2279;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L82: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L86: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2282;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L88: // BOOL_INT
  int_vars[0] = int_vars[2];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L92: // GOTO
  goto L93;
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L95: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2288;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L97: // BOOL_INT
  int_vars[0] = int_vars[2];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L101: // GOTO
  goto L102;
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L104: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_larray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2294;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L106: // BOOL_INT
  int_vars[0] = int_vars[2];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L111; }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L110: // GOTO
  goto L111;
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L115;
L113: // INIT_INT
  int_vars[6] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L115;
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_oarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[11] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[17];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 101;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 102;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 103;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L11: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 104;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L15: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L24: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L27: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[4]);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L31: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L37: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L40: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L43: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[4]);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L47: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L53: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L56: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[4]);
L57: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L60: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L63: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L66: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L69: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 108;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L72: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[4]);
L73: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L76: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L77: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L79: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[0]);
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L82: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[9]
        );
      }
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L85: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L88: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 109;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L90: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L91: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], object_vars[4]);
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], NULL);
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L95: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon0 < 0) {
      BASIC_TYPE_ID_anon0 = env->get_basic_type_id(env, "anon0");
      if (BASIC_TYPE_ID_anon0 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon0");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon0;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object);
  }
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L98: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[4];
L99: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L101: // BOOL_INT
  int_vars[0] = int_vars[2];
L102: // IF_NE_ZERO
  if (int_vars[0]) { goto L106; }
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L105: // GOTO
  goto L106;
L106: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L107: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[7];
L108: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[4];
L109: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L110: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 130;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L111: // BOOL_INT
  int_vars[0] = int_vars[2];
L112: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L116; }
L113: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L115: // GOTO
  goto L116;
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L118: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[4];
L119: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L120: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 136;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L121: // BOOL_INT
  int_vars[0] = int_vars[2];
L122: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L126; }
L123: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L125: // GOTO
  goto L126;
L126: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L127: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[10];
L128: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[4];
L129: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_oarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 142;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L131: // BOOL_INT
  int_vars[0] = int_vars[2];
L132: // IF_NE_ZERO
  if (int_vars[0]) { goto L136; }
L133: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L140;
L135: // GOTO
  goto L136;
L136: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L138: // INIT_INT
  int_vars[6] = 0;
L139: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L140;
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_sarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2218;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L25: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L28: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L30: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L33: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L34: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L35: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L37: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L40: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2219;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L43: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L45: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L47: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L50: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L51: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L52: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L55: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L56: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L57: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2220;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L60: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L64: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L67: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L69: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L70: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L71: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L72: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[5];
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L74: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L77: // CONVERT_INT_TO_SHORT
  short_vars[2] = (int16_t)int_vars[7];
L78: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L79: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2221;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L81: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L82: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L86: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2224;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L88: // BOOL_INT
  int_vars[0] = int_vars[2];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L92: // GOTO
  goto L93;
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L94: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L95: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2231;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L97: // BOOL_INT
  int_vars[0] = int_vars[2];
L98: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L99: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L101: // GOTO
  goto L102;
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L104: // CALL_SUB_INT
  // SPVM::Util->equals_sarray
  {
    if (SUB_ID_SPVM__Util__equals_sarray < 0) {
      SUB_ID_SPVM__Util__equals_sarray = env->get_sub_id(env, "SPVM::Util", "equals_sarray", "int(short[],short[])");
      if (SUB_ID_SPVM__Util__equals_sarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_sarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_sarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_sarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2238;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L115;
  }
L106: // BOOL_INT
  int_vars[0] = int_vars[2];
L107: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L111; }
L108: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L109: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L115;
L110: // GOTO
  goto L111;
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L115;
L113: // INIT_INT
  int_vars[6] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L115;
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_equals_strarray(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[20];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x64\x65\x66", 3));
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x67\x68\x69", 3));
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L36: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x64\x65\x66", 3));
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L41: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x67\x68\x69", 3));
L42: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L43: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L46: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L53: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L57: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L58: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L61: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x64\x65\x66", 3));
L62: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L63: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L66: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L69: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L70: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L72: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L75: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L76: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L77: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L80: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x64\x65\x66", 3));
L81: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L82: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L84: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L85: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], env->new_string_len_raw(env, "\x78\x78\x78", 3));
L86: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L87: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L90: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[0]);
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L92: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L93: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L94: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L95: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L97: // CALL_SUB_INT
  // SPVM::Util->equals_strarray
  {
    if (SUB_ID_SPVM__Util__equals_strarray < 0) {
      SUB_ID_SPVM__Util__equals_strarray = env->get_sub_id(env, "SPVM::Util", "equals_strarray", "int(string[],string[])");
      if (SUB_ID_SPVM__Util__equals_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L99: // BOOL_INT
  int_vars[0] = int_vars[2];
L100: // IF_NE_ZERO
  if (int_vars[0]) { goto L104; }
L101: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L126;
L103: // GOTO
  goto L104;
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L105: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L106: // CALL_SUB_INT
  // SPVM::Util->equals_strarray
  {
    if (SUB_ID_SPVM__Util__equals_strarray < 0) {
      SUB_ID_SPVM__Util__equals_strarray = env->get_sub_id(env, "SPVM::Util", "equals_strarray", "int(string[],string[])");
      if (SUB_ID_SPVM__Util__equals_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2372;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L108: // BOOL_INT
  int_vars[0] = int_vars[2];
L109: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L126;
L112: // GOTO
  goto L113;
L113: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[7];
L115: // CALL_SUB_INT
  // SPVM::Util->equals_strarray
  {
    if (SUB_ID_SPVM__Util__equals_strarray < 0) {
      SUB_ID_SPVM__Util__equals_strarray = env->get_sub_id(env, "SPVM::Util", "equals_strarray", "int(string[],string[])");
      if (SUB_ID_SPVM__Util__equals_strarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_strarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_strarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_equals_strarray";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2378;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L126;
  }
L117: // BOOL_INT
  int_vars[0] = int_vars[2];
L118: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L122; }
L119: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L126;
L121: // GOTO
  goto L122;
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L123: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L126;
L124: // INIT_INT
  int_vars[6] = 0;
L125: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_get_type_name(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // TestCase::Minimal->new
  {
    if (SUB_ID_TestCase__Minimal__new < 0) {
      SUB_ID_TestCase__Minimal__new = env->get_sub_id(env, "TestCase::Minimal", "new", "TestCase::Minimal()");
      if (SUB_ID_TestCase__Minimal__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_get_type_name";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L4: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L5: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L6: // CALL_SUB_OBJECT
  // SPVM::Util->get_type_name
  {
    if (SUB_ID_SPVM__Util__get_type_name < 0) {
      SUB_ID_SPVM__Util__get_type_name = env->get_sub_id(env, "SPVM::Util", "get_type_name", "string(object)");
      if (SUB_ID_SPVM__Util__get_type_name < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util get_type_name");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__get_type_name;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_get_type_name";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2403;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L9: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x54\x65\x73\x74\x43\x61\x73\x65\x3A\x3A\x4D\x69\x6E\x69\x6D\x61\x6C", 17));
L10: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_get_type_name";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2405;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L14: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L17: // GOTO
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_index(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63\x64", 3));
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L9: // CALL_SUB_INT
  // SPVM::Util->index
  {
    if (SUB_ID_SPVM__Util__index < 0) {
      SUB_ID_SPVM__Util__index = env->get_sub_id(env, "SPVM::Util", "index", "int(string,string,int)");
      if (SUB_ID_SPVM__Util__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1684;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L12: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L16: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L17: // GOTO
  goto L18;
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L20: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63\x64", 3));
L23: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L24: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L26: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L27: // CALL_SUB_INT
  // SPVM::Util->index
  {
    if (SUB_ID_SPVM__Util__index < 0) {
      SUB_ID_SPVM__Util__index = env->get_sub_id(env, "SPVM::Util", "index", "int(string,string,int)");
      if (SUB_ID_SPVM__Util__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1693;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L30: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_NE_ZERO
  if (int_vars[0]) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L35: // GOTO
  goto L36;
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63\x64", 3));
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L42: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L44: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L45: // CALL_SUB_INT
  // SPVM::Util->index
  {
    if (SUB_ID_SPVM__Util__index < 0) {
      SUB_ID_SPVM__Util__index = env->get_sub_id(env, "SPVM::Util", "index", "int(string,string,int)");
      if (SUB_ID_SPVM__Util__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1702;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L48: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L58: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x70\x71", 2));
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L60: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L62: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L63: // CALL_SUB_INT
  // SPVM::Util->index
  {
    if (SUB_ID_SPVM__Util__index < 0) {
      SUB_ID_SPVM__Util__index = env->get_sub_id(env, "SPVM::Util", "index", "int(string,string,int)");
      if (SUB_ID_SPVM__Util__index < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util index");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__index;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_index";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1711;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L77;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L66: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L67: // BOOL_INT
  int_vars[0] = int_vars[0];
L68: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L77;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L74: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L77;
L75: // INIT_INT
  int_vars[6] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L77;
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_int_constant(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[1] = *(int32_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_int_constant";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1897;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // MOVE_CONSTANT_INT
  int_vars[2] = INT32_MIN;
L4: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L7: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_int_constant";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1898;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 2147483647;
L10: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_is_perl_space(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L92;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x20';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[5];
L12: // GOTO
  goto L23;
L13: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x0D';
L14: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L15: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[5];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[6];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // GOTO
  goto L38;
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x0A';
L29: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L30: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L34: // BOOL_INT
  int_vars[0] = int_vars[5];
L35: // GOTO
  goto L38;
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L37: // BOOL_INT
  int_vars[0] = int_vars[6];
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L41: // BOOL_INT
  int_vars[0] = int_vars[5];
L42: // GOTO
  goto L53;
L43: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x09';
L44: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L45: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[5];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[6];
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L56: // BOOL_INT
  int_vars[0] = int_vars[5];
L57: // GOTO
  goto L68;
L58: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x0C';
L59: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L60: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L64: // BOOL_INT
  int_vars[0] = int_vars[5];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[6];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L70: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L71: // CALL_SUB_INT
  // SPVM::Util->is_perl_space
  {
    if (SUB_ID_SPVM__Util__is_perl_space < 0) {
      SUB_ID_SPVM__Util__is_perl_space = env->get_sub_id(env, "SPVM::Util", "is_perl_space", "int(int)");
      if (SUB_ID_SPVM__Util__is_perl_space < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util is_perl_space");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__is_perl_space;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_is_perl_space";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1012;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L74: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L75: // BOOL_INT
  int_vars[0] = int_vars[0];
L76: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L77: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L78: // GOTO
  goto L79;
L79: // GOTO
  goto L89;
L80: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L81: // CALL_SUB_INT
  // SPVM::Util->is_perl_space
  {
    if (SUB_ID_SPVM__Util__is_perl_space < 0) {
      SUB_ID_SPVM__Util__is_perl_space = env->get_sub_id(env, "SPVM::Util", "is_perl_space", "int(int)");
      if (SUB_ID_SPVM__Util__is_perl_space < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util is_perl_space");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__is_perl_space;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_is_perl_space";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1018;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L84: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L85: // BOOL_INT
  int_vars[0] = int_vars[0];
L86: // IF_NE_ZERO
  if (int_vars[0]) { goto L89; }
L87: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L88: // GOTO
  goto L89;
L89: // MOVE_INT
  int_vars[4] = int_vars[3];
L90: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L91: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L93: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L94: // BOOL_INT
  int_vars[0] = int_vars[0];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L96: // BOOL_INT
  int_vars[0] = int_vars[1];
L97: // IF_NE_ZERO
  if (int_vars[0]) { goto L101; }
L98: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L99: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L105;
L100: // GOTO
  goto L101;
L101: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L102: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L105;
L103: // INIT_INT
  int_vars[7] = 0;
L104: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L105;
L105: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_is_perl_word(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L122;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x7A';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // GOTO
  goto L53;
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x41';
L29: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L30: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L33: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x5A';
L34: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L35: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[5];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[6];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[7];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[5];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[6];
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L56: // BOOL_INT
  int_vars[0] = int_vars[5];
L57: // GOTO
  goto L68;
L58: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x5F';
L59: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L60: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L66; }
L63: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L64: // BOOL_INT
  int_vars[0] = int_vars[5];
L65: // GOTO
  goto L68;
L66: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L67: // BOOL_INT
  int_vars[0] = int_vars[6];
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L73; }
L70: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L71: // BOOL_INT
  int_vars[0] = int_vars[5];
L72: // GOTO
  goto L98;
L73: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x30';
L74: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L75: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L89; }
L78: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x39';
L79: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L80: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L81: // BOOL_INT
  int_vars[0] = int_vars[0];
L82: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L84: // BOOL_INT
  int_vars[0] = int_vars[5];
L85: // GOTO
  goto L88;
L86: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L87: // BOOL_INT
  int_vars[0] = int_vars[6];
L88: // GOTO
  goto L91;
L89: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L90: // BOOL_INT
  int_vars[0] = int_vars[7];
L91: // BOOL_INT
  int_vars[0] = int_vars[0];
L92: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L93: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L94: // BOOL_INT
  int_vars[0] = int_vars[5];
L95: // GOTO
  goto L98;
L96: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L97: // BOOL_INT
  int_vars[0] = int_vars[6];
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L110; }
L100: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L101: // CALL_SUB_INT
  // SPVM::Util->is_perl_word
  {
    if (SUB_ID_SPVM__Util__is_perl_word < 0) {
      SUB_ID_SPVM__Util__is_perl_word = env->get_sub_id(env, "SPVM::Util", "is_perl_word", "int(int)");
      if (SUB_ID_SPVM__Util__is_perl_word < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util is_perl_word");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__is_perl_word;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_is_perl_word";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1039;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L104: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L105: // BOOL_INT
  int_vars[0] = int_vars[0];
L106: // IF_NE_ZERO
  if (int_vars[0]) { goto L109; }
L107: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L108: // GOTO
  goto L109;
L109: // GOTO
  goto L119;
L110: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L111: // CALL_SUB_INT
  // SPVM::Util->is_perl_word
  {
    if (SUB_ID_SPVM__Util__is_perl_word < 0) {
      SUB_ID_SPVM__Util__is_perl_word = env->get_sub_id(env, "SPVM::Util", "is_perl_word", "int(int)");
      if (SUB_ID_SPVM__Util__is_perl_word < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util is_perl_word");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__is_perl_word;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_is_perl_word";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1045;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L135;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L114: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L115: // BOOL_INT
  int_vars[0] = int_vars[0];
L116: // IF_NE_ZERO
  if (int_vars[0]) { goto L119; }
L117: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L118: // GOTO
  goto L119;
L119: // MOVE_INT
  int_vars[4] = int_vars[3];
L120: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L121: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L122: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L123: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L124: // BOOL_INT
  int_vars[0] = int_vars[0];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L126: // BOOL_INT
  int_vars[0] = int_vars[1];
L127: // IF_NE_ZERO
  if (int_vars[0]) { goto L131; }
L128: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L129: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L135;
L130: // GOTO
  goto L131;
L131: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L132: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L135;
L133: // INIT_INT
  int_vars[7] = 0;
L134: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L135;
L135: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isalnum(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L107;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x41';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x5A';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // GOTO
  goto L53;
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L29: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L30: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L33: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x7A';
L34: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L35: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[5];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[6];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[7];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[5];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[6];
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L56: // BOOL_INT
  int_vars[0] = int_vars[5];
L57: // GOTO
  goto L83;
L58: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x30';
L59: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L60: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L63: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x39';
L64: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L65: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // BOOL_INT
  int_vars[0] = int_vars[5];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L72: // BOOL_INT
  int_vars[0] = int_vars[6];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[7];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[5];
L80: // GOTO
  goto L83;
L81: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L82: // BOOL_INT
  int_vars[0] = int_vars[6];
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L85: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L86: // CALL_SUB_INT
  // SPVM::Util->isalnum
  {
    if (SUB_ID_SPVM__Util__isalnum < 0) {
      SUB_ID_SPVM__Util__isalnum = env->get_sub_id(env, "SPVM::Util", "isalnum", "int(int)");
      if (SUB_ID_SPVM__Util__isalnum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isalnum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isalnum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isalnum";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 634;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L89: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L94; }
L92: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L104;
L95: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L96: // CALL_SUB_INT
  // SPVM::Util->isalnum
  {
    if (SUB_ID_SPVM__Util__isalnum < 0) {
      SUB_ID_SPVM__Util__isalnum = env->get_sub_id(env, "SPVM::Util", "isalnum", "int(int)");
      if (SUB_ID_SPVM__Util__isalnum < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isalnum");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isalnum;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isalnum";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L99: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L100: // BOOL_INT
  int_vars[0] = int_vars[0];
L101: // IF_NE_ZERO
  if (int_vars[0]) { goto L104; }
L102: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L103: // GOTO
  goto L104;
L104: // MOVE_INT
  int_vars[4] = int_vars[3];
L105: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L106: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L108: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L111: // BOOL_INT
  int_vars[0] = int_vars[1];
L112: // IF_NE_ZERO
  if (int_vars[0]) { goto L116; }
L113: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L120;
L115: // GOTO
  goto L116;
L116: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L120;
L118: // INIT_INT
  int_vars[7] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L120;
L120: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isalpha(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L77;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x41';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x5A';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // GOTO
  goto L53;
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L29: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L30: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L33: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x7A';
L34: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L35: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[5];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[6];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[7];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[5];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[6];
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L55: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L56: // CALL_SUB_INT
  // SPVM::Util->isalpha
  {
    if (SUB_ID_SPVM__Util__isalpha < 0) {
      SUB_ID_SPVM__Util__isalpha = env->get_sub_id(env, "SPVM::Util", "isalpha", "int(int)");
      if (SUB_ID_SPVM__Util__isalpha < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isalpha");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isalpha;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isalpha";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 661;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L59: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_NE_ZERO
  if (int_vars[0]) { goto L64; }
L62: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L63: // GOTO
  goto L64;
L64: // GOTO
  goto L74;
L65: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L66: // CALL_SUB_INT
  // SPVM::Util->isalpha
  {
    if (SUB_ID_SPVM__Util__isalpha < 0) {
      SUB_ID_SPVM__Util__isalpha = env->get_sub_id(env, "SPVM::Util", "isalpha", "int(int)");
      if (SUB_ID_SPVM__Util__isalpha < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isalpha");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isalpha;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isalpha";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L90;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L69: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L74; }
L72: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L73: // GOTO
  goto L74;
L74: // MOVE_INT
  int_vars[4] = int_vars[3];
L75: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L76: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L77: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L78: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L79: // BOOL_INT
  int_vars[0] = int_vars[0];
L80: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L81: // BOOL_INT
  int_vars[0] = int_vars[1];
L82: // IF_NE_ZERO
  if (int_vars[0]) { goto L86; }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L90;
L85: // GOTO
  goto L86;
L86: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L90;
L88: // INIT_INT
  int_vars[7] = 0;
L89: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L90;
L90: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isblank(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L47;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x20';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L13; }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L11: // BOOL_INT
  int_vars[0] = int_vars[5];
L12: // GOTO
  goto L23;
L13: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x09';
L14: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L15: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[6]);
L16: // BOOL_INT
  int_vars[0] = int_vars[0];
L17: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // BOOL_INT
  int_vars[0] = int_vars[5];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[6];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L26: // CALL_SUB_INT
  // SPVM::Util->isblank
  {
    if (SUB_ID_SPVM__Util__isblank < 0) {
      SUB_ID_SPVM__Util__isblank = env->get_sub_id(env, "SPVM::Util", "isblank", "int(int)");
      if (SUB_ID_SPVM__Util__isblank < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isblank");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isblank;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isblank";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L29: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L32: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L33: // GOTO
  goto L34;
L34: // GOTO
  goto L44;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L36: // CALL_SUB_INT
  // SPVM::Util->isblank
  {
    if (SUB_ID_SPVM__Util__isblank < 0) {
      SUB_ID_SPVM__Util__isblank = env->get_sub_id(env, "SPVM::Util", "isblank", "int(int)");
      if (SUB_ID_SPVM__Util__isblank < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isblank");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isblank;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isblank";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 694;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L39: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L42: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L43: // GOTO
  goto L44;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L46: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L48: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L51: // BOOL_INT
  int_vars[0] = int_vars[1];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L60;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L60;
L58: // INIT_INT
  int_vars[7] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L60;
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_iscntrl(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L59;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L6: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 31;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L17: // BOOL_INT
  int_vars[0] = int_vars[6];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[7];
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[5];
L25: // GOTO
  goto L35;
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 127;
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[5];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[6];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L38: // CALL_SUB_INT
  // SPVM::Util->iscntrl
  {
    if (SUB_ID_SPVM__Util__iscntrl < 0) {
      SUB_ID_SPVM__Util__iscntrl = env->get_sub_id(env, "SPVM::Util", "iscntrl", "int(int)");
      if (SUB_ID_SPVM__Util__iscntrl < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util iscntrl");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__iscntrl;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_iscntrl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 715;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L44: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L45: // GOTO
  goto L46;
L46: // GOTO
  goto L56;
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L48: // CALL_SUB_INT
  // SPVM::Util->iscntrl
  {
    if (SUB_ID_SPVM__Util__iscntrl < 0) {
      SUB_ID_SPVM__Util__iscntrl = env->get_sub_id(env, "SPVM::Util", "iscntrl", "int(int)");
      if (SUB_ID_SPVM__Util__iscntrl < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util iscntrl");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__iscntrl;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_iscntrl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 721;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L51: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L54: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L55: // GOTO
  goto L56;
L56: // MOVE_INT
  int_vars[4] = int_vars[3];
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L58: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L60: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L63: // BOOL_INT
  int_vars[0] = int_vars[1];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L72;
L67: // GOTO
  goto L68;
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L72;
L70: // INIT_INT
  int_vars[7] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L72;
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isdigit(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L47;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x30';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x39';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L26: // CALL_SUB_INT
  // SPVM::Util->isdigit
  {
    if (SUB_ID_SPVM__Util__isdigit < 0) {
      SUB_ID_SPVM__Util__isdigit = env->get_sub_id(env, "SPVM::Util", "isdigit", "int(int)");
      if (SUB_ID_SPVM__Util__isdigit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isdigit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isdigit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isdigit";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 742;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L29: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L32: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L33: // GOTO
  goto L34;
L34: // GOTO
  goto L44;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L36: // CALL_SUB_INT
  // SPVM::Util->isdigit
  {
    if (SUB_ID_SPVM__Util__isdigit < 0) {
      SUB_ID_SPVM__Util__isdigit = env->get_sub_id(env, "SPVM::Util", "isdigit", "int(int)");
      if (SUB_ID_SPVM__Util__isdigit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isdigit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isdigit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isdigit";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 748;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L39: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L42: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L43: // GOTO
  goto L44;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L46: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L48: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L51: // BOOL_INT
  int_vars[0] = int_vars[1];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L60;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L60;
L58: // INIT_INT
  int_vars[7] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L60;
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isgraph(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L45;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 33;
L6: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 126;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L17: // BOOL_INT
  int_vars[0] = int_vars[6];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[7];
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L23: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L24: // CALL_SUB_INT
  // SPVM::Util->isgraph
  {
    if (SUB_ID_SPVM__Util__isgraph < 0) {
      SUB_ID_SPVM__Util__isgraph = env->get_sub_id(env, "SPVM::Util", "isgraph", "int(int)");
      if (SUB_ID_SPVM__Util__isgraph < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isgraph");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isgraph;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isgraph";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 769;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L27: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L30: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L31: // GOTO
  goto L32;
L32: // GOTO
  goto L42;
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L34: // CALL_SUB_INT
  // SPVM::Util->isgraph
  {
    if (SUB_ID_SPVM__Util__isgraph < 0) {
      SUB_ID_SPVM__Util__isgraph = env->get_sub_id(env, "SPVM::Util", "isgraph", "int(int)");
      if (SUB_ID_SPVM__Util__isgraph < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isgraph");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isgraph;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isgraph";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 775;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L37: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L40: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L41: // GOTO
  goto L42;
L42: // MOVE_INT
  int_vars[4] = int_vars[3];
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L44: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L46: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L49: // BOOL_INT
  int_vars[0] = int_vars[1];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L58;
L53: // GOTO
  goto L54;
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L58;
L56: // INIT_INT
  int_vars[7] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L58;
L58: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_islower(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L47;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x7A';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L26: // CALL_SUB_INT
  // SPVM::Util->islower
  {
    if (SUB_ID_SPVM__Util__islower < 0) {
      SUB_ID_SPVM__Util__islower = env->get_sub_id(env, "SPVM::Util", "islower", "int(int)");
      if (SUB_ID_SPVM__Util__islower < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util islower");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__islower;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_islower";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 796;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L29: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L32: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L33: // GOTO
  goto L34;
L34: // GOTO
  goto L44;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L36: // CALL_SUB_INT
  // SPVM::Util->islower
  {
    if (SUB_ID_SPVM__Util__islower < 0) {
      SUB_ID_SPVM__Util__islower = env->get_sub_id(env, "SPVM::Util", "islower", "int(int)");
      if (SUB_ID_SPVM__Util__islower < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util islower");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__islower;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_islower";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 802;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L39: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L42: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L43: // GOTO
  goto L44;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L46: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L48: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L51: // BOOL_INT
  int_vars[0] = int_vars[1];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L60;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L60;
L58: // INIT_INT
  int_vars[7] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L60;
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isprint(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L45;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 32;
L6: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 126;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L17: // BOOL_INT
  int_vars[0] = int_vars[6];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[7];
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L23: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L24: // CALL_SUB_INT
  // SPVM::Util->isprint
  {
    if (SUB_ID_SPVM__Util__isprint < 0) {
      SUB_ID_SPVM__Util__isprint = env->get_sub_id(env, "SPVM::Util", "isprint", "int(int)");
      if (SUB_ID_SPVM__Util__isprint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isprint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isprint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isprint";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 823;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L27: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_NE_ZERO
  if (int_vars[0]) { goto L32; }
L30: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L31: // GOTO
  goto L32;
L32: // GOTO
  goto L42;
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L34: // CALL_SUB_INT
  // SPVM::Util->isprint
  {
    if (SUB_ID_SPVM__Util__isprint < 0) {
      SUB_ID_SPVM__Util__isprint = env->get_sub_id(env, "SPVM::Util", "isprint", "int(int)");
      if (SUB_ID_SPVM__Util__isprint < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isprint");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isprint;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isprint";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 829;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L58;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L37: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L42; }
L40: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L41: // GOTO
  goto L42;
L42: // MOVE_INT
  int_vars[4] = int_vars[3];
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L44: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L46: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L49: // BOOL_INT
  int_vars[0] = int_vars[1];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L58;
L53: // GOTO
  goto L54;
L54: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L58;
L56: // INIT_INT
  int_vars[7] = 0;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L58;
L58: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_ispunct(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L129;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 33;
L6: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 47;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L17: // BOOL_INT
  int_vars[0] = int_vars[6];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[7];
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[5];
L25: // GOTO
  goto L49;
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 58;
L27: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L30: // MOVE_CONSTANT_INT
  int_vars[5] = 64;
L31: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L32: // BOOL_INT
  int_vars[0] = int_vars[0];
L33: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L35: // BOOL_INT
  int_vars[0] = int_vars[5];
L36: // GOTO
  goto L39;
L37: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L38: // BOOL_INT
  int_vars[0] = int_vars[6];
L39: // GOTO
  goto L42;
L40: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L41: // BOOL_INT
  int_vars[0] = int_vars[7];
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L44: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L45: // BOOL_INT
  int_vars[0] = int_vars[5];
L46: // GOTO
  goto L49;
L47: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L48: // BOOL_INT
  int_vars[0] = int_vars[6];
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L54; }
L51: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L52: // BOOL_INT
  int_vars[0] = int_vars[5];
L53: // GOTO
  goto L77;
L54: // MOVE_CONSTANT_INT
  int_vars[6] = 91;
L55: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L58: // MOVE_CONSTANT_INT
  int_vars[5] = 96;
L59: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L65; }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L63: // BOOL_INT
  int_vars[0] = int_vars[5];
L64: // GOTO
  goto L67;
L65: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L66: // BOOL_INT
  int_vars[0] = int_vars[6];
L67: // GOTO
  goto L70;
L68: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L69: // BOOL_INT
  int_vars[0] = int_vars[7];
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L73: // BOOL_INT
  int_vars[0] = int_vars[5];
L74: // GOTO
  goto L77;
L75: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[6];
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L80: // BOOL_INT
  int_vars[0] = int_vars[5];
L81: // GOTO
  goto L105;
L82: // MOVE_CONSTANT_INT
  int_vars[6] = 123;
L83: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L84: // BOOL_INT
  int_vars[0] = int_vars[0];
L85: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L86: // MOVE_CONSTANT_INT
  int_vars[5] = 126;
L87: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L91: // BOOL_INT
  int_vars[0] = int_vars[5];
L92: // GOTO
  goto L95;
L93: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L94: // BOOL_INT
  int_vars[0] = int_vars[6];
L95: // GOTO
  goto L98;
L96: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L97: // BOOL_INT
  int_vars[0] = int_vars[7];
L98: // BOOL_INT
  int_vars[0] = int_vars[0];
L99: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L100: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L101: // BOOL_INT
  int_vars[0] = int_vars[5];
L102: // GOTO
  goto L105;
L103: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L104: // BOOL_INT
  int_vars[0] = int_vars[6];
L105: // BOOL_INT
  int_vars[0] = int_vars[0];
L106: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L117; }
L107: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L108: // CALL_SUB_INT
  // SPVM::Util->ispunct
  {
    if (SUB_ID_SPVM__Util__ispunct < 0) {
      SUB_ID_SPVM__Util__ispunct = env->get_sub_id(env, "SPVM::Util", "ispunct", "int(int)");
      if (SUB_ID_SPVM__Util__ispunct < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util ispunct");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__ispunct;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_ispunct";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 850;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L142;
  }
L110: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L111: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L112: // BOOL_INT
  int_vars[0] = int_vars[0];
L113: // IF_NE_ZERO
  if (int_vars[0]) { goto L116; }
L114: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L115: // GOTO
  goto L116;
L116: // GOTO
  goto L126;
L117: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L118: // CALL_SUB_INT
  // SPVM::Util->ispunct
  {
    if (SUB_ID_SPVM__Util__ispunct < 0) {
      SUB_ID_SPVM__Util__ispunct = env->get_sub_id(env, "SPVM::Util", "ispunct", "int(int)");
      if (SUB_ID_SPVM__Util__ispunct < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util ispunct");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__ispunct;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_ispunct";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 856;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L142;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L121: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L122: // BOOL_INT
  int_vars[0] = int_vars[0];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L124: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L125: // GOTO
  goto L126;
L126: // MOVE_INT
  int_vars[4] = int_vars[3];
L127: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L128: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L130: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L131: // BOOL_INT
  int_vars[0] = int_vars[0];
L132: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L133: // BOOL_INT
  int_vars[0] = int_vars[1];
L134: // IF_NE_ZERO
  if (int_vars[0]) { goto L138; }
L135: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L136: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L142;
L137: // GOTO
  goto L138;
L138: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L139: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L142;
L140: // INIT_INT
  int_vars[7] = 0;
L141: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L142;
L142: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isspace(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L59;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 9;
L6: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L19; }
L9: // MOVE_CONSTANT_INT
  int_vars[5] = 13;
L10: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L14: // BOOL_INT
  int_vars[0] = int_vars[5];
L15: // GOTO
  goto L18;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L17: // BOOL_INT
  int_vars[0] = int_vars[6];
L18: // GOTO
  goto L21;
L19: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L20: // BOOL_INT
  int_vars[0] = int_vars[7];
L21: // BOOL_INT
  int_vars[0] = int_vars[0];
L22: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L26; }
L23: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L24: // BOOL_INT
  int_vars[0] = int_vars[5];
L25: // GOTO
  goto L35;
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 32;
L27: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[6]);
L28: // BOOL_INT
  int_vars[0] = int_vars[0];
L29: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L30: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L31: // BOOL_INT
  int_vars[0] = int_vars[5];
L32: // GOTO
  goto L35;
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L34: // BOOL_INT
  int_vars[0] = int_vars[6];
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L47; }
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L38: // CALL_SUB_INT
  // SPVM::Util->isspace
  {
    if (SUB_ID_SPVM__Util__isspace < 0) {
      SUB_ID_SPVM__Util__isspace = env->get_sub_id(env, "SPVM::Util", "isspace", "int(int)");
      if (SUB_ID_SPVM__Util__isspace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isspace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isspace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isspace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 877;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L41: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L42: // BOOL_INT
  int_vars[0] = int_vars[0];
L43: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L44: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L45: // GOTO
  goto L46;
L46: // GOTO
  goto L56;
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L48: // CALL_SUB_INT
  // SPVM::Util->isspace
  {
    if (SUB_ID_SPVM__Util__isspace < 0) {
      SUB_ID_SPVM__Util__isspace = env->get_sub_id(env, "SPVM::Util", "isspace", "int(int)");
      if (SUB_ID_SPVM__Util__isspace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isspace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isspace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isspace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 883;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L72;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L51: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L52: // BOOL_INT
  int_vars[0] = int_vars[0];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L54: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L55: // GOTO
  goto L56;
L56: // MOVE_INT
  int_vars[4] = int_vars[3];
L57: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L58: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L59: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L60: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L63: // BOOL_INT
  int_vars[0] = int_vars[1];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L72;
L67: // GOTO
  goto L68;
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L72;
L70: // INIT_INT
  int_vars[7] = 0;
L71: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L72;
L72: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isupper(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L47;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x41';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x5A';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L26: // CALL_SUB_INT
  // SPVM::Util->isupper
  {
    if (SUB_ID_SPVM__Util__isupper < 0) {
      SUB_ID_SPVM__Util__isupper = env->get_sub_id(env, "SPVM::Util", "isupper", "int(int)");
      if (SUB_ID_SPVM__Util__isupper < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isupper");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isupper;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isupper";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 904;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L28: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L29: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L34; }
L32: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L33: // GOTO
  goto L34;
L34: // GOTO
  goto L44;
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L36: // CALL_SUB_INT
  // SPVM::Util->isupper
  {
    if (SUB_ID_SPVM__Util__isupper < 0) {
      SUB_ID_SPVM__Util__isupper = env->get_sub_id(env, "SPVM::Util", "isupper", "int(int)");
      if (SUB_ID_SPVM__Util__isupper < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isupper");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isupper;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isupper";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 910;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L60;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L39: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L40: // BOOL_INT
  int_vars[0] = int_vars[0];
L41: // IF_NE_ZERO
  if (int_vars[0]) { goto L44; }
L42: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L43: // GOTO
  goto L44;
L44: // MOVE_INT
  int_vars[4] = int_vars[3];
L45: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L46: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L48: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L51: // BOOL_INT
  int_vars[0] = int_vars[1];
L52: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L53: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L60;
L55: // GOTO
  goto L56;
L56: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L57: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L60;
L58: // INIT_INT
  int_vars[7] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L60;
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_isxdigit(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L3: // GOTO
  goto L107;
L4: // MOVE_INT
  int_vars[4] = int_vars[3];
L5: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x41';
L6: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L7: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[5]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L21; }
L10: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x46';
L11: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L12: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L16: // BOOL_INT
  int_vars[0] = int_vars[5];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[6];
L20: // GOTO
  goto L23;
L21: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L22: // BOOL_INT
  int_vars[0] = int_vars[7];
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L28; }
L25: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L26: // BOOL_INT
  int_vars[0] = int_vars[5];
L27: // GOTO
  goto L53;
L28: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x61';
L29: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L30: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L33: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x66';
L34: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L35: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L36: // BOOL_INT
  int_vars[0] = int_vars[0];
L37: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // BOOL_INT
  int_vars[0] = int_vars[5];
L40: // GOTO
  goto L43;
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L42: // BOOL_INT
  int_vars[0] = int_vars[6];
L43: // GOTO
  goto L46;
L44: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L45: // BOOL_INT
  int_vars[0] = int_vars[7];
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L51; }
L48: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L49: // BOOL_INT
  int_vars[0] = int_vars[5];
L50: // GOTO
  goto L53;
L51: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L52: // BOOL_INT
  int_vars[0] = int_vars[6];
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L58; }
L55: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L56: // BOOL_INT
  int_vars[0] = int_vars[5];
L57: // GOTO
  goto L83;
L58: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x30';
L59: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L60: // GE_INT
  int_vars[0] = (int_vars[4] >= int_vars[6]);
L61: // BOOL_INT
  int_vars[0] = int_vars[0];
L62: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L74; }
L63: // MOVE_CONSTANT_BYTE
  byte_vars[0] = '\x39';
L64: // CONVERT_BYTE_TO_INT
  int_vars[5] = (int32_t)byte_vars[0];
L65: // LE_INT
  int_vars[0] = (int_vars[4] <= int_vars[5]);
L66: // BOOL_INT
  int_vars[0] = int_vars[0];
L67: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L71; }
L68: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L69: // BOOL_INT
  int_vars[0] = int_vars[5];
L70: // GOTO
  goto L73;
L71: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L72: // BOOL_INT
  int_vars[0] = int_vars[6];
L73: // GOTO
  goto L76;
L74: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L75: // BOOL_INT
  int_vars[0] = int_vars[7];
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L81; }
L78: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L79: // BOOL_INT
  int_vars[0] = int_vars[5];
L80: // GOTO
  goto L83;
L81: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L82: // BOOL_INT
  int_vars[0] = int_vars[6];
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L95; }
L85: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L86: // CALL_SUB_INT
  // SPVM::Util->isxdigit
  {
    if (SUB_ID_SPVM__Util__isxdigit < 0) {
      SUB_ID_SPVM__Util__isxdigit = env->get_sub_id(env, "SPVM::Util", "isxdigit", "int(int)");
      if (SUB_ID_SPVM__Util__isxdigit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isxdigit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isxdigit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isxdigit";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 931;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L89: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L90: // BOOL_INT
  int_vars[0] = int_vars[0];
L91: // IF_NE_ZERO
  if (int_vars[0]) { goto L94; }
L92: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L93: // GOTO
  goto L94;
L94: // GOTO
  goto L104;
L95: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L96: // CALL_SUB_INT
  // SPVM::Util->isxdigit
  {
    if (SUB_ID_SPVM__Util__isxdigit < 0) {
      SUB_ID_SPVM__Util__isxdigit = env->get_sub_id(env, "SPVM::Util", "isxdigit", "int(int)");
      if (SUB_ID_SPVM__Util__isxdigit < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util isxdigit");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__isxdigit;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_isxdigit";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 937;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L120;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L99: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L100: // BOOL_INT
  int_vars[0] = int_vars[0];
L101: // IF_NE_ZERO
  if (int_vars[0]) { goto L104; }
L102: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L103: // GOTO
  goto L104;
L104: // MOVE_INT
  int_vars[4] = int_vars[3];
L105: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L106: // ADD_INT
  int_vars[3] = int_vars[4] + int_vars[5];
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 128;
L108: // LT_INT
  int_vars[0] = (int_vars[3] < int_vars[4]);
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L4; }
L111: // BOOL_INT
  int_vars[0] = int_vars[1];
L112: // IF_NE_ZERO
  if (int_vars[0]) { goto L116; }
L113: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L120;
L115: // GOTO
  goto L116;
L116: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L117: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L120;
L118: // INIT_INT
  int_vars[7] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L120;
L120: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_join(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_join";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_join";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x64\x65\x66", 3));
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_join";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L15: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L16: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x68\x69\x6A", 3));
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L18: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_join";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1794;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L29: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L31: // CALL_SUB_OBJECT
  // SPVM::Util->join
  {
    if (SUB_ID_SPVM__Util__join < 0) {
      SUB_ID_SPVM__Util__join = env->get_sub_id(env, "SPVM::Util", "join", "string(string,string[])");
      if (SUB_ID_SPVM__Util__join < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util join");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__join;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_join";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1796;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L35: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x2C\x64\x65\x66\x2C\x68\x69\x6A", 11));
L36: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_join";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1798;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L49;
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L44; }
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L49;
L43: // GOTO
  goto L44;
L44: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L46: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L49;
L47: // INIT_INT
  int_vars[6] = 0;
L48: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L49;
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joinb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L15: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MIN
  {
    if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
      SUB_ID_SPVM__Util__INT8_MIN = env->get_sub_id(env, "SPVM::Util", "INT8_MIN", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1806;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L28: // CALL_SUB_OBJECT
  // SPVM::Util->joinb
  {
    if (SUB_ID_SPVM__Util__joinb < 0) {
      SUB_ID_SPVM__Util__joinb = env->get_sub_id(env, "SPVM::Util", "joinb", "string(string,byte[])");
      if (SUB_ID_SPVM__Util__joinb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joinb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joinb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1808;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L32: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x2C\x32\x2C\x2D\x31\x32\x38", 8));
L33: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1810;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L40: // GOTO
  goto L41;
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joind(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joind";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1865;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joind";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1865;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joind";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1865;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L15: // MOVE_CONSTANT_DOUBLE
  double_vars[2] = 2.4500000000000002;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L17: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joind";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1865;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L27: // CALL_SUB_OBJECT
  // SPVM::Util->joind
  {
    if (SUB_ID_SPVM__Util__joind < 0) {
      SUB_ID_SPVM__Util__joind = env->get_sub_id(env, "SPVM::Util", "joind", "string(string,double[])");
      if (SUB_ID_SPVM__Util__joind < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joind");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joind;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joind";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1867;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x2C\x32\x2C\x32\x2E\x34\x35", 8));
L32: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joind";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1869;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L45;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joinf(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L15: // MOVE_CONSTANT_FLOAT
  float_vars[2] = 2.45000005;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L17: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1854;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L27: // CALL_SUB_OBJECT
  // SPVM::Util->joinf
  {
    if (SUB_ID_SPVM__Util__joinf < 0) {
      SUB_ID_SPVM__Util__joinf = env->get_sub_id(env, "SPVM::Util", "joinf", "string(string,float[])");
      if (SUB_ID_SPVM__Util__joinf < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joinf");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joinf;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1856;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x2C\x32\x2C\x32\x2E\x34\x35", 8));
L32: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinf";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1858;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L45;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joini(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MIN
  {
    if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
      SUB_ID_SPVM__Util__INT32_MIN = env->get_sub_id(env, "SPVM::Util", "INT32_MIN", "int()");
      if (SUB_ID_SPVM__Util__INT32_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L17: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1830;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L27: // CALL_SUB_OBJECT
  // SPVM::Util->joini
  {
    if (SUB_ID_SPVM__Util__joini < 0) {
      SUB_ID_SPVM__Util__joini = env->get_sub_id(env, "SPVM::Util", "joini", "string(string,int[])");
      if (SUB_ID_SPVM__Util__joini < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joini");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joini;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1832;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x2C\x32\x2C\x2D\x32\x31\x34\x37\x34\x38\x33\x36\x34\x38", 15));
L32: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joini";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1834;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L45;
  }
L34: // BOOL_INT
  int_vars[0] = int_vars[0];
L35: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L40; }
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L45;
L39: // GOTO
  goto L40;
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L45;
L43: // INIT_INT
  int_vars[6] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L45;
L45: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L46: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joinl(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1842;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1842;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1842;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1842;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1842;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L28: // CALL_SUB_OBJECT
  // SPVM::Util->joinl
  {
    if (SUB_ID_SPVM__Util__joinl < 0) {
      SUB_ID_SPVM__Util__joinl = env->get_sub_id(env, "SPVM::Util", "joinl", "string(string,long[])");
      if (SUB_ID_SPVM__Util__joinl < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joinl");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joinl;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1844;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L32: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x2C\x32\x2C\x2D\x39\x32\x32\x33\x33\x37\x32\x30\x33\x36\x38\x35\x34\x37\x37\x35\x38\x30\x38", 24));
L33: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joinl";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1846;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L40: // GOTO
  goto L41;
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joino(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L10: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L13: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L16: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L19: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[6];
L20: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[8] = 5;
L26: // MOVE_CONSTANT_INT
  int_vars[9] = 6;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L28: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[8];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[9];
L30: // CALL_SUB_OBJECT
  // TestCase::Minimal->newp
  {
    if (SUB_ID_TestCase__Minimal__newp < 0) {
      SUB_ID_TestCase__Minimal__newp = env->get_sub_id(env, "TestCase::Minimal", "newp", "TestCase::Minimal(int,int)");
      if (SUB_ID_TestCase__Minimal__newp < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Minimal newp");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Minimal__newp;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L32: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L33: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L36: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L42: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L44: // NEW_OBJECT
  {
    if (BASIC_TYPE_ID_anon2 < 0) {
      BASIC_TYPE_ID_anon2 = env->get_basic_type_id(env, "anon2");
      if (BASIC_TYPE_ID_anon2 < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found anon2");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_anon2;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[1];
L49: // CALL_SUB_OBJECT
  // SPVM::Util->joino
  {
    if (SUB_ID_SPVM__Util__joino < 0) {
      SUB_ID_SPVM__Util__joino = env->get_sub_id(env, "SPVM::Util", "joino", "string(string,oarray,SPVM::Stringer)");
      if (SUB_ID_SPVM__Util__joino < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joino");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joino;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L54: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x28\x31\x2C\x32\x29\x2C\x28\x33\x2C\x34\x29\x2C\x28\x35\x2C\x36\x29", 17));
L55: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joino";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 210;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L68;
  }
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L68;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L65: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L68;
L66: // INIT_INT
  int_vars[6] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_joins(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[3];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_SHORT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_short_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L11: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L15: // CALL_SUB_SHORT
  // SPVM::Util->INT16_MIN
  {
    if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
      SUB_ID_SPVM__Util__INT16_MIN = env->get_sub_id(env, "SPVM::Util", "INT16_MIN", "short()");
      if (SUB_ID_SPVM__Util__INT16_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT16_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT16_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      short_vars[2] = *(int16_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_SHORT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int16_t*)((intptr_t)array + object_header_byte_size))[index]
 = short_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1818;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L24: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x2C", 1));
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L28: // CALL_SUB_OBJECT
  // SPVM::Util->joins
  {
    if (SUB_ID_SPVM__Util__joins < 0) {
      SUB_ID_SPVM__Util__joins = env->get_sub_id(env, "SPVM::Util", "joins", "string(string,short[])");
      if (SUB_ID_SPVM__Util__joins < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util joins");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__joins;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1820;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L32: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31\x2C\x32\x2C\x2D\x33\x32\x37\x36\x38", 10));
L33: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_joins";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1822;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L35: // BOOL_INT
  int_vars[0] = int_vars[0];
L36: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L40: // GOTO
  goto L41;
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_lc(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x40\x5B\x41\x50\x5A\x5B", 6));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Util->lc
  {
    if (SUB_ID_SPVM__Util__lc < 0) {
      SUB_ID_SPVM__Util__lc = env->get_sub_id(env, "SPVM::Util", "lc", "string(string)");
      if (SUB_ID_SPVM__Util__lc < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util lc");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__lc;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lc";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1443;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x40\x5B\x61\x70\x7A\x5B", 6));
L9: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lc";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1444;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L23;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_lcfirst(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x40\x41\x42\x43", 4));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L5: // CALL_SUB_OBJECT
  // SPVM::Util->lcfirst
  {
    if (SUB_ID_SPVM__Util__lcfirst < 0) {
      SUB_ID_SPVM__Util__lcfirst = env->get_sub_id(env, "SPVM::Util", "lcfirst", "string(string)");
      if (SUB_ID_SPVM__Util__lcfirst < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util lcfirst");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__lcfirst;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1454;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x40\x41\x42\x43", 4));
L9: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L13: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L16: // GOTO
  goto L17;
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L20: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5B\x41\x42\x43", 4));
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L23: // CALL_SUB_OBJECT
  // SPVM::Util->lcfirst
  {
    if (SUB_ID_SPVM__Util__lcfirst < 0) {
      SUB_ID_SPVM__Util__lcfirst = env->get_sub_id(env, "SPVM::Util", "lcfirst", "string(string)");
      if (SUB_ID_SPVM__Util__lcfirst < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util lcfirst");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__lcfirst;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1461;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x5B\x41\x42\x43", 4));
L27: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L34: // GOTO
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x41\x41\x42\x43", 4));
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L41: // CALL_SUB_OBJECT
  // SPVM::Util->lcfirst
  {
    if (SUB_ID_SPVM__Util__lcfirst < 0) {
      SUB_ID_SPVM__Util__lcfirst = env->get_sub_id(env, "SPVM::Util", "lcfirst", "string(string)");
      if (SUB_ID_SPVM__Util__lcfirst < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util lcfirst");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__lcfirst;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x41\x42\x43", 4));
L45: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1470;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L56: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x50\x41\x42\x43", 4));
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L59: // CALL_SUB_OBJECT
  // SPVM::Util->lcfirst
  {
    if (SUB_ID_SPVM__Util__lcfirst < 0) {
      SUB_ID_SPVM__Util__lcfirst = env->get_sub_id(env, "SPVM::Util", "lcfirst", "string(string)");
      if (SUB_ID_SPVM__Util__lcfirst < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util lcfirst");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__lcfirst;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1477;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L62: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x70\x41\x42\x43", 4));
L63: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1478;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_NE_ZERO
  if (int_vars[0]) { goto L71; }
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L69: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L70: // GOTO
  goto L71;
L71: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L74: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x5A\x41\x42\x43", 4));
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L77: // CALL_SUB_OBJECT
  // SPVM::Util->lcfirst
  {
    if (SUB_ID_SPVM__Util__lcfirst < 0) {
      SUB_ID_SPVM__Util__lcfirst = env->get_sub_id(env, "SPVM::Util", "lcfirst", "string(string)");
      if (SUB_ID_SPVM__Util__lcfirst < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util lcfirst");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__lcfirst;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1485;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L80: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x7A\x41\x42\x43", 4));
L81: // STRING_EQ
  {
    void* object1 = object_vars[1];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_lcfirst";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L95;
  }
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_NE_ZERO
  if (int_vars[0]) { goto L89; }
L85: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L86: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L87: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L95;
L88: // GOTO
  goto L89;
L89: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L90: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L95;
L93: // INIT_INT
  int_vars[6] = 0;
L94: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_long_constant(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Util->INT64_MIN
  {
    if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
      SUB_ID_SPVM__Util__INT64_MIN = env->get_sub_id(env, "SPVM::Util", "INT64_MIN", "long()");
      if (SUB_ID_SPVM__Util__INT64_MIN < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MIN");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MIN;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_long_constant";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1907;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L3: // MOVE_CONSTANT_LONG
  long_vars[1] = INT64_MIN;
L4: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L7: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_long_constant";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1908;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L21;
  }
L9: // MOVE_CONSTANT_LONG
  long_vars[1] = 9223372036854775807LL;
L10: // EQ_LONG
  int_vars[0] = (long_vars[0] == long_vars[1]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L21;
L15: // GOTO
  goto L16;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L21;
L19: // INIT_INT
  int_vars[6] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L21;
L21: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_memcpyb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[16];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L15: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L17: // CALL_SUB_VOID
  // SPVM::Util->memcpyb
  {
    if (SUB_ID_SPVM__Util__memcpyb < 0) {
      SUB_ID_SPVM__Util__memcpyb = env->get_sub_id(env, "SPVM::Util", "memcpyb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memcpyb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memcpyb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memcpyb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memcpyb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L22: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43\x64\x65", 5));
L23: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memcpyb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1613;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L101;
L30: // GOTO
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L38: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L45: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L49: // CALL_SUB_VOID
  // SPVM::Util->memcpyb
  {
    if (SUB_ID_SPVM__Util__memcpyb < 0) {
      SUB_ID_SPVM__Util__memcpyb = env->get_sub_id(env, "SPVM::Util", "memcpyb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memcpyb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memcpyb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memcpyb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memcpyb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1621;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L54: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x41\x42\x43", 5));
L55: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memcpyb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1622;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L101;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L66: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L68: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L70: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L73: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L77: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L78: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L79: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L80: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L81: // CALL_SUB_VOID
  // SPVM::Util->memcpyb
  {
    if (SUB_ID_SPVM__Util__memcpyb < 0) {
      SUB_ID_SPVM__Util__memcpyb = env->get_sub_id(env, "SPVM::Util", "memcpyb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memcpyb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memcpyb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memcpyb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memcpyb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L86: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x41\x42\x43", 5));
L87: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memcpyb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1631;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L101;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L101;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L101;
L99: // INIT_INT
  int_vars[6] = 0;
L100: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L101;
L101: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L102: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_memmoveb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[20];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L9: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L10: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L14: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L15: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L17: // CALL_SUB_VOID
  // SPVM::Util->memmoveb
  {
    if (SUB_ID_SPVM__Util__memmoveb < 0) {
      SUB_ID_SPVM__Util__memmoveb = env->get_sub_id(env, "SPVM::Util", "memmoveb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memmoveb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memmoveb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memmoveb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L22: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43\x64\x65", 5));
L23: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L25: // BOOL_INT
  int_vars[0] = int_vars[0];
L26: // IF_NE_ZERO
  if (int_vars[0]) { goto L31; }
L27: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L28: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L29: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L30: // GOTO
  goto L31;
L31: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L32: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L36: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L38: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L39: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L42: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L45: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L49: // CALL_SUB_VOID
  // SPVM::Util->memmoveb
  {
    if (SUB_ID_SPVM__Util__memmoveb < 0) {
      SUB_ID_SPVM__Util__memmoveb = env->get_sub_id(env, "SPVM::Util", "memmoveb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memmoveb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memmoveb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memmoveb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1653;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L54: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x41\x42\x43", 5));
L55: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1654;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L57: // BOOL_INT
  int_vars[0] = int_vars[0];
L58: // IF_NE_ZERO
  if (int_vars[0]) { goto L63; }
L59: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L60: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L62: // GOTO
  goto L63;
L63: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L64: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L66: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L67: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L68: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x41\x42\x43", 3));
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L70: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L71: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L72: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L73: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L77: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L78: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L79: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L80: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L81: // CALL_SUB_VOID
  // SPVM::Util->memmoveb
  {
    if (SUB_ID_SPVM__Util__memmoveb < 0) {
      SUB_ID_SPVM__Util__memmoveb = env->get_sub_id(env, "SPVM::Util", "memmoveb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memmoveb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memmoveb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memmoveb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L83: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L85: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L86: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x61\x62\x41\x42\x43", 5));
L87: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[2];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1663;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L98: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L99: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L100: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L101: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L102: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L103: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[0]);
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L105: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L106: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L107: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L108: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L109: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L110: // PUSH_ARG_INT
  *(int32_t*)&stack[4] = int_vars[4];
L111: // CALL_SUB_VOID
  // SPVM::Util->memmoveb
  {
    if (SUB_ID_SPVM__Util__memmoveb < 0) {
      SUB_ID_SPVM__Util__memmoveb = env->get_sub_id(env, "SPVM::Util", "memmoveb", "void(byte[],int,byte[],int,int)");
      if (SUB_ID_SPVM__Util__memmoveb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util memmoveb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__memmoveb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1670;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L113: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L114: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L115: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L116: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x64\x63\x64\x65", 5));
L117: // STRING_EQ
  {
    void* object1 = object_vars[0];
    void* object2 = object_vars[1];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L118: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_memmoveb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1671;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L119: // BOOL_INT
  int_vars[0] = int_vars[0];
L120: // IF_NE_ZERO
  if (int_vars[0]) { goto L125; }
L121: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L122: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L123: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L124: // GOTO
  goto L125;
L125: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L131;
L129: // INIT_INT
  int_vars[6] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L131;
L131: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L132: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_new_object_array_proto(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_new_object_array_proto";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1917;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Util->new_object_array_proto
  {
    if (SUB_ID_SPVM__Util__new_object_array_proto < 0) {
      SUB_ID_SPVM__Util__new_object_array_proto = env->get_sub_id(env, "SPVM::Util", "new_object_array_proto", "oarray(oarray,int)");
      if (SUB_ID_SPVM__Util__new_object_array_proto < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util new_object_array_proto");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__new_object_array_proto;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_new_object_array_proto";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1919;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L11: // IS_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L12: // BOOL_INT
  int_vars[0] = int_vars[0];
L13: // IF_NE_ZERO
  if (int_vars[0]) { goto L17; }
L14: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L15: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L16: // GOTO
  goto L17;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L18: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
      BASIC_TYPE_ID_TestCase__Minimal = env->get_basic_type_id(env, "TestCase::Minimal");
      if (BASIC_TYPE_ID_TestCase__Minimal < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found TestCase::Minimal");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_TestCase__Minimal;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_new_object_array_proto";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1923;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L20: // ARRAY_LENGTH
  if (object_vars[2] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[2] + (intptr_t)env->object_length_offset);
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_new_object_array_proto";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1924;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L33;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L23: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L33;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L33;
L31: // INIT_INT
  int_vars[6] = 0;
L32: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L33;
L33: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L34: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_rand(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  void* ref_vars[1] = {0};
  int64_t long_vars[1];
  int32_t int_vars[29];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Time->time
  {
    if (SUB_ID_SPVM__Time__time < 0) {
      SUB_ID_SPVM__Time__time = env->get_sub_id(env, "SPVM::Time", "time", "long()");
      if (SUB_ID_SPVM__Time__time < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time time");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__time;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1331;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L3: // CONVERT_LONG_TO_INT
  int_vars[1] = (int32_t)long_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L6: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1332;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1333;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L12: // MOVE_INT
  int_vars[3] = int_vars[1];
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L14: // GOTO
  goto L37;
L15: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[3];
L16: // PUSH_ARG_REF
  *(void**)&stack[0] = ref_vars[0];
L17: // CALL_SUB_INT
  // SPVM::Util->rand
  {
    if (SUB_ID_SPVM__Util__rand < 0) {
      SUB_ID_SPVM__Util__rand = env->get_sub_id(env, "SPVM::Util", "rand", "int(&int)");
      if (SUB_ID_SPVM__Util__rand < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util rand");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__rand;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1336;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 10;
L20: // REMAINDER_INT
  if (__builtin_expect(int_vars[5] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[6] = int_vars[3] % /* REMAINDER */ int_vars[5];
  }
L21: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1338;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L23: // LT_INT
  int_vars[0] = (int_vars[6] < int_vars[5]);
L24: // BOOL_INT
  int_vars[0] = int_vars[0];
L25: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L31; }
L26: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L27: // NEGATE_INT
  int_vars[7] = -int_vars[6];
L28: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1340;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L30: // GOTO
  goto L34;
L31: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L32: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L34: // MOVE_INT
  int_vars[5] = int_vars[4];
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L36: // ADD_INT
  int_vars[4] = int_vars[5] + int_vars[6];
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 100000;
L38: // LT_INT
  int_vars[0] = (int_vars[4] < int_vars[5]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L15; }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 10;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L43: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L44: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L46: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L47: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L50: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L51: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L54: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L55: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L57: // MOVE_CONSTANT_INT
  int_vars[12] = 1;
L58: // MOVE_CONSTANT_INT
  int_vars[13] = 3;
L59: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[12];
      } 
    } 
  } 
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[14] = 1;
L62: // MOVE_CONSTANT_INT
  int_vars[15] = 4;
L63: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[14];
      } 
    } 
  } 
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[16] = 1;
L66: // MOVE_CONSTANT_INT
  int_vars[17] = 5;
L67: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[17];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[16];
      } 
    } 
  } 
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[18] = 1;
L70: // MOVE_CONSTANT_INT
  int_vars[19] = 6;
L71: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[19];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[18];
      } 
    } 
  } 
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L73: // MOVE_CONSTANT_INT
  int_vars[20] = 1;
L74: // MOVE_CONSTANT_INT
  int_vars[21] = 7;
L75: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[21];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[20];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L77: // MOVE_CONSTANT_INT
  int_vars[22] = 1;
L78: // MOVE_CONSTANT_INT
  int_vars[23] = 8;
L79: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[23];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[22];
      } 
    } 
  } 
L80: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[24] = 1;
L82: // MOVE_CONSTANT_INT
  int_vars[25] = 9;
L83: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[25];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[24];
      } 
    } 
  } 
L84: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L86: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L87: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[26] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1347;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[26];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L155;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // MOVE_CONSTANT_INT
  int_vars[6] = 10;
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L98: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[6];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L101: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L102: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L105: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L106: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[9];
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[11] = 1;
L109: // MOVE_CONSTANT_INT
  int_vars[12] = 2;
L110: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[12];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[11];
      } 
    } 
  } 
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[13] = 1;
L113: // MOVE_CONSTANT_INT
  int_vars[14] = 3;
L114: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[14];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[13];
      } 
    } 
  } 
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L116: // MOVE_CONSTANT_INT
  int_vars[15] = 1;
L117: // MOVE_CONSTANT_INT
  int_vars[16] = 4;
L118: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[16];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[15];
      } 
    } 
  } 
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[17] = 1;
L121: // MOVE_CONSTANT_INT
  int_vars[18] = 5;
L122: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[18];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[17];
      } 
    } 
  } 
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L124: // MOVE_CONSTANT_INT
  int_vars[19] = 1;
L125: // MOVE_CONSTANT_INT
  int_vars[20] = 6;
L126: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[20];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[19];
      } 
    } 
  } 
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L128: // MOVE_CONSTANT_INT
  int_vars[21] = 1;
L129: // MOVE_CONSTANT_INT
  int_vars[22] = 7;
L130: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[22];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[21];
      } 
    } 
  } 
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L132: // MOVE_CONSTANT_INT
  int_vars[23] = 1;
L133: // MOVE_CONSTANT_INT
  int_vars[24] = 8;
L134: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[24];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[23];
      } 
    } 
  } 
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[25] = 1;
L137: // MOVE_CONSTANT_INT
  int_vars[26] = 9;
L138: // ARRAY_STORE_INT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[26];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[25];
      } 
    } 
  } 
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L140: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L141: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L142: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[27] = *(int32_t*)&stack[0];
    }
  }
L143: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_rand";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L155;
  }
L144: // BOOL_INT
  int_vars[0] = int_vars[27];
L145: // IF_NE_ZERO
  if (int_vars[0]) { goto L150; }
L146: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L147: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L148: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L155;
L149: // GOTO
  goto L150;
L150: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L151: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L152: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L155;
L153: // INIT_INT
  int_vars[8] = 0;
L154: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L155;
L155: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L156: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_random(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  void* ref_vars[1] = {0};
  double double_vars[3];
  int64_t long_vars[1];
  int32_t int_vars[48];
  int32_t exception_flag = 0;
  int32_t mortal_stack[3];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // CALL_SUB_LONG
  // SPVM::Time->time
  {
    if (SUB_ID_SPVM__Time__time < 0) {
      SUB_ID_SPVM__Time__time = env->get_sub_id(env, "SPVM::Time", "time", "long()");
      if (SUB_ID_SPVM__Time__time < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Time time");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Time__time;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L2: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1359;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L3: // CONVERT_LONG_TO_INT
  int_vars[1] = (int32_t)long_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 20;
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L6: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[3];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L7: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1360;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L8: // MOVE_INT
  int_vars[3] = int_vars[1];
L9: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L10: // GOTO
  goto L28;
L11: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[3];
L12: // PUSH_ARG_REF
  *(void**)&stack[0] = ref_vars[0];
L13: // CALL_SUB_INT
  // SPVM::Util->rand
  {
    if (SUB_ID_SPVM__Util__rand < 0) {
      SUB_ID_SPVM__Util__rand = env->get_sub_id(env, "SPVM::Util", "rand", "int(&int)");
      if (SUB_ID_SPVM__Util__rand < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util rand");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__rand;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L15: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[3];
L16: // CALL_SUB_DOUBLE
  // SPVM::Util->random
  {
    if (SUB_ID_SPVM__Util__random < 0) {
      SUB_ID_SPVM__Util__random = env->get_sub_id(env, "SPVM::Util", "random", "double(int)");
      if (SUB_ID_SPVM__Util__random < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util random");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__random;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1365;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 20;
L19: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[5];
L20: // MULTIPLY_DOUBLE
  double_vars[2] = double_vars[0] * double_vars[1];
L21: // CONVERT_DOUBLE_TO_INT
  int_vars[6] = (int32_t)double_vars[2];
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1366;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L25: // MOVE_INT
  int_vars[5] = int_vars[4];
L26: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L27: // ADD_INT
  int_vars[4] = int_vars[5] + int_vars[6];
L28: // MOVE_CONSTANT_INT
  int_vars[5] = 100000;
L29: // LT_INT
  int_vars[0] = (int_vars[4] < int_vars[5]);
L30: // BOOL_INT
  int_vars[0] = int_vars[0];
L31: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L32: // MOVE_CONSTANT_INT
  int_vars[4] = 20;
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L34: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L37: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L38: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L41: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L42: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L45: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L46: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L48: // MOVE_CONSTANT_INT
  int_vars[12] = 1;
L49: // MOVE_CONSTANT_INT
  int_vars[13] = 3;
L50: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[12];
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[14] = 1;
L53: // MOVE_CONSTANT_INT
  int_vars[15] = 4;
L54: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[15];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[14];
      } 
    } 
  } 
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[16] = 1;
L57: // MOVE_CONSTANT_INT
  int_vars[17] = 5;
L58: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[17];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[16];
      } 
    } 
  } 
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[18] = 1;
L61: // MOVE_CONSTANT_INT
  int_vars[19] = 6;
L62: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[19];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[18];
      } 
    } 
  } 
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[20] = 1;
L65: // MOVE_CONSTANT_INT
  int_vars[21] = 7;
L66: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[21];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[20];
      } 
    } 
  } 
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[22] = 1;
L69: // MOVE_CONSTANT_INT
  int_vars[23] = 8;
L70: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[23];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[22];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[24] = 1;
L73: // MOVE_CONSTANT_INT
  int_vars[25] = 9;
L74: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[25];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[24];
      } 
    } 
  } 
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[26] = 1;
L77: // MOVE_CONSTANT_INT
  int_vars[27] = 10;
L78: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[27];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[26];
      } 
    } 
  } 
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[28] = 1;
L81: // MOVE_CONSTANT_INT
  int_vars[29] = 11;
L82: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[29];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[28];
      } 
    } 
  } 
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[30] = 1;
L85: // MOVE_CONSTANT_INT
  int_vars[31] = 12;
L86: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[31];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[30];
      } 
    } 
  } 
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[32] = 1;
L89: // MOVE_CONSTANT_INT
  int_vars[33] = 13;
L90: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[33];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[32];
      } 
    } 
  } 
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L92: // MOVE_CONSTANT_INT
  int_vars[34] = 1;
L93: // MOVE_CONSTANT_INT
  int_vars[35] = 14;
L94: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[35];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[34];
      } 
    } 
  } 
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L96: // MOVE_CONSTANT_INT
  int_vars[36] = 1;
L97: // MOVE_CONSTANT_INT
  int_vars[37] = 15;
L98: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[37];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[36];
      } 
    } 
  } 
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[38] = 1;
L101: // MOVE_CONSTANT_INT
  int_vars[39] = 16;
L102: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[39];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[38];
      } 
    } 
  } 
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[40] = 1;
L105: // MOVE_CONSTANT_INT
  int_vars[41] = 17;
L106: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[41];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[40];
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[42] = 1;
L109: // MOVE_CONSTANT_INT
  int_vars[43] = 18;
L110: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[43];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[42];
      } 
    } 
  } 
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L112: // MOVE_CONSTANT_INT
  int_vars[44] = 1;
L113: // MOVE_CONSTANT_INT
  int_vars[45] = 19;
L114: // ARRAY_STORE_INT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[45];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[44];
      } 
    } 
  } 
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L118: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[46] = *(int32_t*)&stack[0];
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_random";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1370;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L120: // BOOL_INT
  int_vars[0] = int_vars[46];
L121: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L122: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L123: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L131;
L125: // GOTO
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L131;
L129: // INIT_INT
  int_vars[8] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L131;
L131: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L132: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_replace(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  void* ref_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[30];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63\x64", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42", 2));
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L9: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L14: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L15: // PUSH_ARG_REF
  *(void**)&stack[4] = ref_vars[0];
L16: // CALL_SUB_OBJECT
  // SPVM::Util->replace
  {
    if (SUB_ID_SPVM__Util__replace < 0) {
      SUB_ID_SPVM__Util__replace = env->get_sub_id(env, "SPVM::Util", "replace", "string(string,string,string,int,&int)");
      if (SUB_ID_SPVM__Util__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1524;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L19: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L25; }
L22: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L24: // GOTO
  goto L25;
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L26: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x41\x42\x65", 4));
L27: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_NE_ZERO
  if (int_vars[0]) { goto L35; }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L34: // GOTO
  goto L35;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63\x64", 3));
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L42: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42", 2));
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L45: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L48: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L50: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L51: // PUSH_ARG_REF
  *(void**)&stack[4] = ref_vars[0];
L52: // CALL_SUB_OBJECT
  // SPVM::Util->replace
  {
    if (SUB_ID_SPVM__Util__replace < 0) {
      SUB_ID_SPVM__Util__replace = env->get_sub_id(env, "SPVM::Util", "replace", "string(string,string,string,int,&int)");
      if (SUB_ID_SPVM__Util__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1538;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L55: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L56: // BOOL_INT
  int_vars[0] = int_vars[0];
L57: // IF_NE_ZERO
  if (int_vars[0]) { goto L61; }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L60: // GOTO
  goto L61;
L61: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[0];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1542;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L63: // BOOL_INT
  int_vars[0] = int_vars[0];
L64: // IF_NE_ZERO
  if (int_vars[0]) { goto L68; }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L67: // GOTO
  goto L68;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L70: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L71: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L72: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L74: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43\x44", 4));
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L77: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L79: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L82: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L83: // PUSH_ARG_REF
  *(void**)&stack[4] = ref_vars[0];
L84: // CALL_SUB_OBJECT
  // SPVM::Util->replace
  {
    if (SUB_ID_SPVM__Util__replace < 0) {
      SUB_ID_SPVM__Util__replace = env->get_sub_id(env, "SPVM::Util", "replace", "string(string,string,string,int,&int)");
      if (SUB_ID_SPVM__Util__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1552;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L87: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_NE_ZERO
  if (int_vars[0]) { goto L93; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L91: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L92: // GOTO
  goto L93;
L93: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L94: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x41\x42\x43\x44\x64\x65", 6));
L95: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1556;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L97: // BOOL_INT
  int_vars[0] = int_vars[0];
L98: // IF_NE_ZERO
  if (int_vars[0]) { goto L103; }
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L100: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L101: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L102: // GOTO
  goto L103;
L103: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L104: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L105: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L106: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x65", 5));
L107: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L108: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x64\x65", 3));
L109: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L110: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42\x43\x44", 4));
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L112: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L113: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L114: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L115: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L116: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L118: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L119: // PUSH_ARG_REF
  *(void**)&stack[4] = ref_vars[0];
L120: // CALL_SUB_OBJECT
  // SPVM::Util->replace
  {
    if (SUB_ID_SPVM__Util__replace < 0) {
      SUB_ID_SPVM__Util__replace = env->get_sub_id(env, "SPVM::Util", "replace", "string(string,string,string,int,&int)");
      if (SUB_ID_SPVM__Util__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L121: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1566;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L123: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L124: // BOOL_INT
  int_vars[0] = int_vars[0];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L129; }
L126: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L127: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L128: // GOTO
  goto L129;
L129: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L130: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x41\x42\x43\x44", 6));
L131: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1570;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L133: // BOOL_INT
  int_vars[0] = int_vars[0];
L134: // IF_NE_ZERO
  if (int_vars[0]) { goto L139; }
L135: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L136: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L138: // GOTO
  goto L139;
L139: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L142: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64\x63\x64", 6));
L143: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L144: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x63\x64", 2));
L145: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L146: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41", 1));
L147: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L148: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L149: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L150: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L151: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L152: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L153: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L154: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L155: // PUSH_ARG_REF
  *(void**)&stack[4] = ref_vars[0];
L156: // CALL_SUB_OBJECT
  // SPVM::Util->replace
  {
    if (SUB_ID_SPVM__Util__replace < 0) {
      SUB_ID_SPVM__Util__replace = env->get_sub_id(env, "SPVM::Util", "replace", "string(string,string,string,int,&int)");
      if (SUB_ID_SPVM__Util__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L157: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L158: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L159: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L160: // BOOL_INT
  int_vars[0] = int_vars[0];
L161: // IF_NE_ZERO
  if (int_vars[0]) { goto L165; }
L162: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L163: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L164: // GOTO
  goto L165;
L165: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L166: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x62\x63\x64\x41", 5));
L167: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L168: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1584;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L169: // BOOL_INT
  int_vars[0] = int_vars[0];
L170: // IF_NE_ZERO
  if (int_vars[0]) { goto L175; }
L171: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L172: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L173: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L174: // GOTO
  goto L175;
L175: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L176: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L177: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L178: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x61\x62\x63\x64", 4));
L179: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L180: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x63", 2));
L181: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L182: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "", 0));
L183: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L184: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L185: // REF_INT
  *(void**)&ref_vars[0] = &int_vars[2];
L186: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L187: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L188: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L189: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L190: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L191: // PUSH_ARG_REF
  *(void**)&stack[4] = ref_vars[0];
L192: // CALL_SUB_OBJECT
  // SPVM::Util->replace
  {
    if (SUB_ID_SPVM__Util__replace < 0) {
      SUB_ID_SPVM__Util__replace = env->get_sub_id(env, "SPVM::Util", "replace", "string(string,string,string,int,&int)");
      if (SUB_ID_SPVM__Util__replace < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L193: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1594;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L194: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L195: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L196: // BOOL_INT
  int_vars[0] = int_vars[0];
L197: // IF_NE_ZERO
  if (int_vars[0]) { goto L201; }
L198: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L199: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L200: // GOTO
  goto L201;
L201: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L202: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x61\x64", 2));
L203: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L217;
  }
L205: // BOOL_INT
  int_vars[0] = int_vars[0];
L206: // IF_NE_ZERO
  if (int_vars[0]) { goto L211; }
L207: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L208: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L209: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L217;
L210: // GOTO
  goto L211;
L211: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L212: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L213: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L214: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L217;
L215: // INIT_INT
  int_vars[6] = 0;
L216: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L217;
L217: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L218: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_replace_all(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[11];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x6F\x6F\x20\x62\x61\x72\x20\x66\x6F\x6F\x20\x62\x61\x72\x20\x66\x6F\x6F", 19));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x61\x72", 3));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x42", 2));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L9: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L10: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L11: // CALL_SUB_OBJECT
  // SPVM::Util->replace_all
  {
    if (SUB_ID_SPVM__Util__replace_all < 0) {
      SUB_ID_SPVM__Util__replace_all = env->get_sub_id(env, "SPVM::Util", "replace_all", "string(string,string,string)");
      if (SUB_ID_SPVM__Util__replace_all < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace_all");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace_all;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace_all";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1498;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L14: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x66\x6F\x6F\x20\x41\x42\x20\x66\x6F\x6F\x20\x41\x42\x20\x66\x6F\x6F", 17));
L15: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace_all";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1499;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L23; }
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L22: // GOTO
  goto L23;
L23: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L26: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x66\x6F\x6F\x62\x61\x72\x66\x6F\x6F\x62\x61\x72\x66\x6F\x6F", 15));
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L28: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x62\x61\x72", 3));
L29: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L30: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "", 0));
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[2];
L35: // CALL_SUB_OBJECT
  // SPVM::Util->replace_all
  {
    if (SUB_ID_SPVM__Util__replace_all < 0) {
      SUB_ID_SPVM__Util__replace_all = env->get_sub_id(env, "SPVM::Util", "replace_all", "string(string,string,string)");
      if (SUB_ID_SPVM__Util__replace_all < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util replace_all");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__replace_all;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace_all";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L38: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x66\x6F\x6F\x66\x6F\x6F\x66\x6F\x6F", 9));
L39: // STRING_EQ
  {
    void* object1 = object_vars[3];
    void* object2 = object_vars[4];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_replace_all";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 1509;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L53;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[0];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L47; }
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L44: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L53;
L46: // GOTO
  goto L47;
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L49: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L53;
L51: // INIT_INT
  int_vars[6] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reverseb(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[5];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L15: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[2] = *(int8_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2069;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_VOID
  // SPVM::Util->reverseb
  {
    if (SUB_ID_SPVM__Util__reverseb < 0) {
      SUB_ID_SPVM__Util__reverseb = env->get_sub_id(env, "SPVM::Util", "reverseb", "void(byte[])");
      if (SUB_ID_SPVM__Util__reverseb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reverseb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reverseb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2070;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2071;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L30: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2071;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L32: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2071;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L37: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[4];
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2071;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L42: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[6];
L43: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L44: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[3];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2071;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L48: // CALL_SUB_INT
  // SPVM::Util->equals_barray
  {
    if (SUB_ID_SPVM__Util__equals_barray < 0) {
      SUB_ID_SPVM__Util__equals_barray = env->get_sub_id(env, "SPVM::Util", "equals_barray", "int(byte[],byte[])");
      if (SUB_ID_SPVM__Util__equals_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2071;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L50: // BOOL_INT
  int_vars[0] = int_vars[8];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L55: // GOTO
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L60: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2076;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L63: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L65: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[0];
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2076;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L68: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[7];
L69: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L70: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2076;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L73: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[9];
L74: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L75: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2076;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L77: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[3] = *(int8_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2076;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L80: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[3];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2076;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // CALL_SUB_VOID
  // SPVM::Util->reverseb
  {
    if (SUB_ID_SPVM__Util__reverseb < 0) {
      SUB_ID_SPVM__Util__reverseb = env->get_sub_id(env, "SPVM::Util", "reverseb", "void(byte[])");
      if (SUB_ID_SPVM__Util__reverseb < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reverseb");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reverseb;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2077;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L90: // NEW_BYTE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_byte_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L92: // CALL_SUB_BYTE
  // SPVM::Util->INT8_MAX
  {
    if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
      SUB_ID_SPVM__Util__INT8_MAX = env->get_sub_id(env, "SPVM::Util", "INT8_MAX", "byte()");
      if (SUB_ID_SPVM__Util__INT8_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT8_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT8_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      byte_vars[0] = *(int8_t*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L94: // MOVE_BYTE
  byte_vars[1] = byte_vars[0];
L95: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L96: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[1];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L99: // CONVERT_INT_TO_BYTE
  byte_vars[2] = (int8_t)int_vars[4];
L100: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L101: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[2];
      } 
    } 
  } 
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L104: // CONVERT_INT_TO_BYTE
  byte_vars[3] = (int8_t)int_vars[6];
L105: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L106: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[3];
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L109: // CONVERT_INT_TO_BYTE
  byte_vars[4] = (int8_t)int_vars[8];
L110: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L111: // ARRAY_STORE_BYTE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int8_t*)((intptr_t)array + object_header_byte_size))[index]
 = byte_vars[4];
      } 
    } 
  } 
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L113: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L115: // CALL_SUB_INT
  // SPVM::Util->equals_barray
  {
    if (SUB_ID_SPVM__Util__equals_barray < 0) {
      SUB_ID_SPVM__Util__equals_barray = env->get_sub_id(env, "SPVM::Util", "equals_barray", "int(byte[],byte[])");
      if (SUB_ID_SPVM__Util__equals_barray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_barray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_barray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[10] = *(int32_t*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reverseb";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2078;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L117: // BOOL_INT
  int_vars[0] = int_vars[10];
L118: // IF_NE_ZERO
  if (int_vars[0]) { goto L123; }
L119: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L120: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L121: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L122: // GOTO
  goto L123;
L123: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L124: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L129;
L127: // INIT_INT
  int_vars[6] = 0;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L129;
L129: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L130: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversed(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  double double_vars[5];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L15: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[2] = *(double*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2159;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_VOID
  // SPVM::Util->reversed
  {
    if (SUB_ID_SPVM__Util__reversed < 0) {
      SUB_ID_SPVM__Util__reversed = env->get_sub_id(env, "SPVM::Util", "reversed", "void(double[])");
      if (SUB_ID_SPVM__Util__reversed < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversed");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversed;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L30: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L32: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L37: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L42: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[6];
L43: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L44: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L48: // CALL_SUB_INT
  // SPVM::Util->equals_darray
  {
    if (SUB_ID_SPVM__Util__equals_darray < 0) {
      SUB_ID_SPVM__Util__equals_darray = env->get_sub_id(env, "SPVM::Util", "equals_darray", "int(double[],double[])");
      if (SUB_ID_SPVM__Util__equals_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L50: // BOOL_INT
  int_vars[0] = int_vars[8];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L55: // GOTO
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L60: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L63: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[5];
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L65: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[0];
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L68: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[7];
L69: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L70: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L73: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[9];
L74: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L75: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L77: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[3] = *(double*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L80: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2166;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // CALL_SUB_VOID
  // SPVM::Util->reversed
  {
    if (SUB_ID_SPVM__Util__reversed < 0) {
      SUB_ID_SPVM__Util__reversed = env->get_sub_id(env, "SPVM::Util", "reversed", "void(double[])");
      if (SUB_ID_SPVM__Util__reversed < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversed");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversed;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2167;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L90: // NEW_DOUBLE_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_double_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L92: // CALL_SUB_DOUBLE
  // SPVM::Util->DBL_MAX
  {
    if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
      SUB_ID_SPVM__Util__DBL_MAX = env->get_sub_id(env, "SPVM::Util", "DBL_MAX", "double()");
      if (SUB_ID_SPVM__Util__DBL_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util DBL_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__DBL_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      double_vars[0] = *(double*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L94: // MOVE_DOUBLE
  double_vars[1] = double_vars[0];
L95: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L96: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[1];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L99: // CONVERT_INT_TO_DOUBLE
  double_vars[2] = (double)int_vars[4];
L100: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L101: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[2];
      } 
    } 
  } 
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L104: // CONVERT_INT_TO_DOUBLE
  double_vars[3] = (double)int_vars[6];
L105: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L106: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[3];
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L109: // CONVERT_INT_TO_DOUBLE
  double_vars[4] = (double)int_vars[8];
L110: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L111: // ARRAY_STORE_DOUBLE
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((double*)((intptr_t)array + object_header_byte_size))[index]
 = double_vars[4];
      } 
    } 
  } 
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L113: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L115: // CALL_SUB_INT
  // SPVM::Util->equals_darray
  {
    if (SUB_ID_SPVM__Util__equals_darray < 0) {
      SUB_ID_SPVM__Util__equals_darray = env->get_sub_id(env, "SPVM::Util", "equals_darray", "int(double[],double[])");
      if (SUB_ID_SPVM__Util__equals_darray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_darray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_darray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[10] = *(int32_t*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversed";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L117: // BOOL_INT
  int_vars[0] = int_vars[10];
L118: // IF_NE_ZERO
  if (int_vars[0]) { goto L123; }
L119: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L120: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L121: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L122: // GOTO
  goto L123;
L123: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L124: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L129;
L127: // INIT_INT
  int_vars[6] = 0;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L129;
L129: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L130: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversef(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  float float_vars[5];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L15: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[2] = *(float*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2141;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_VOID
  // SPVM::Util->reversef
  {
    if (SUB_ID_SPVM__Util__reversef < 0) {
      SUB_ID_SPVM__Util__reversef = env->get_sub_id(env, "SPVM::Util", "reversef", "void(float[])");
      if (SUB_ID_SPVM__Util__reversef < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversef");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversef;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2142;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L30: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L32: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L37: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L42: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[6];
L43: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L44: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L48: // CALL_SUB_INT
  // SPVM::Util->equals_farray
  {
    if (SUB_ID_SPVM__Util__equals_farray < 0) {
      SUB_ID_SPVM__Util__equals_farray = env->get_sub_id(env, "SPVM::Util", "equals_farray", "int(float[],float[])");
      if (SUB_ID_SPVM__Util__equals_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2143;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L50: // BOOL_INT
  int_vars[0] = int_vars[8];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L55: // GOTO
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L60: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L63: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[5];
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L65: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[0];
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L68: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[7];
L69: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L70: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L73: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[9];
L74: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L75: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L77: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[3] = *(float*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L80: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2148;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // CALL_SUB_VOID
  // SPVM::Util->reversef
  {
    if (SUB_ID_SPVM__Util__reversef < 0) {
      SUB_ID_SPVM__Util__reversef = env->get_sub_id(env, "SPVM::Util", "reversef", "void(float[])");
      if (SUB_ID_SPVM__Util__reversef < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversef");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversef;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2149;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L90: // NEW_FLOAT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_float_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L92: // CALL_SUB_FLOAT
  // SPVM::Util->FLT_MAX
  {
    if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
      SUB_ID_SPVM__Util__FLT_MAX = env->get_sub_id(env, "SPVM::Util", "FLT_MAX", "float()");
      if (SUB_ID_SPVM__Util__FLT_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util FLT_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__FLT_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      float_vars[0] = *(float*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L94: // MOVE_FLOAT
  float_vars[1] = float_vars[0];
L95: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L96: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[1];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L99: // CONVERT_INT_TO_FLOAT
  float_vars[2] = (float)int_vars[4];
L100: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L101: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[2];
      } 
    } 
  } 
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L103: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L104: // CONVERT_INT_TO_FLOAT
  float_vars[3] = (float)int_vars[6];
L105: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L106: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[3];
      } 
    } 
  } 
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L108: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L109: // CONVERT_INT_TO_FLOAT
  float_vars[4] = (float)int_vars[8];
L110: // MOVE_CONSTANT_INT
  int_vars[9] = 3;
L111: // ARRAY_STORE_FLOAT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((float*)((intptr_t)array + object_header_byte_size))[index]
 = float_vars[4];
      } 
    } 
  } 
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L113: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L115: // CALL_SUB_INT
  // SPVM::Util->equals_farray
  {
    if (SUB_ID_SPVM__Util__equals_farray < 0) {
      SUB_ID_SPVM__Util__equals_farray = env->get_sub_id(env, "SPVM::Util", "equals_farray", "int(float[],float[])");
      if (SUB_ID_SPVM__Util__equals_farray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_farray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_farray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[10] = *(int32_t*)&stack[0];
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversef";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2150;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L117: // BOOL_INT
  int_vars[0] = int_vars[10];
L118: // IF_NE_ZERO
  if (int_vars[0]) { goto L123; }
L119: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L120: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L121: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L122: // GOTO
  goto L123;
L123: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L124: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L125: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L129;
L127: // INIT_INT
  int_vars[6] = 0;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L129;
L129: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L130: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversei(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[14];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // MOVE_INT
  int_vars[3] = int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L8: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[3];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[5] = 3;
L11: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L12: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[5];
      } 
    } 
  } 
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L14: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[8] = 2;
L17: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[7];
      } 
    } 
  } 
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L20: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L21: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L22: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L23: // CALL_SUB_VOID
  // SPVM::Util->reversei
  {
    if (SUB_ID_SPVM__Util__reversei < 0) {
      SUB_ID_SPVM__Util__reversei = env->get_sub_id(env, "SPVM::Util", "reversei", "void(int[])");
      if (SUB_ID_SPVM__Util__reversei < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversei");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversei;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2106;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L25: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L27: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L29: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L31: // MOVE_INT
  int_vars[4] = int_vars[3];
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L33: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L36: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L37: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L39: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L40: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L41: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L45: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[10] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2107;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[10];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L121;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L57: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L59: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L60: // MOVE_INT
  int_vars[6] = int_vars[5];
L61: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L62: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L64: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L65: // MOVE_CONSTANT_INT
  int_vars[9] = 1;
L66: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[10] = 5;
L69: // MOVE_CONSTANT_INT
  int_vars[11] = 2;
L70: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L72: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[12] = *(int32_t*)&stack[0];
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L74: // MOVE_CONSTANT_INT
  int_vars[13] = 3;
L75: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[13];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[12];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L77: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L78: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L81: // CALL_SUB_VOID
  // SPVM::Util->reversei
  {
    if (SUB_ID_SPVM__Util__reversei < 0) {
      SUB_ID_SPVM__Util__reversei = env->get_sub_id(env, "SPVM::Util", "reversei", "void(int[])");
      if (SUB_ID_SPVM__Util__reversei < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversei");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversei;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L84: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L85: // NEW_INT_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_int_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L87: // CALL_SUB_INT
  // SPVM::Util->INT32_MAX
  {
    if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
      SUB_ID_SPVM__Util__INT32_MAX = env->get_sub_id(env, "SPVM::Util", "INT32_MAX", "int()");
      if (SUB_ID_SPVM__Util__INT32_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT32_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT32_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L89: // MOVE_INT
  int_vars[4] = int_vars[3];
L90: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L91: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[4];
      } 
    } 
  } 
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[6] = 5;
L94: // MOVE_CONSTANT_INT
  int_vars[7] = 1;
L95: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[6];
      } 
    } 
  } 
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L98: // MOVE_CONSTANT_INT
  int_vars[9] = 2;
L99: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[8];
      } 
    } 
  } 
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L102: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L103: // ARRAY_STORE_INT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int32_t*)((intptr_t)array + object_header_byte_size))[index]
 = int_vars[10];
      } 
    } 
  } 
L104: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L105: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L106: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L107: // CALL_SUB_INT
  // SPVM::Util->equals_iarray
  {
    if (SUB_ID_SPVM__Util__equals_iarray < 0) {
      SUB_ID_SPVM__Util__equals_iarray = env->get_sub_id(env, "SPVM::Util", "equals_iarray", "int(int[],int[])");
      if (SUB_ID_SPVM__Util__equals_iarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_iarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_iarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[12] = *(int32_t*)&stack[0];
    }
  }
L108: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversei";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L121;
  }
L109: // BOOL_INT
  int_vars[0] = int_vars[12];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L115; }
L111: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L112: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L113: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L121;
L114: // GOTO
  goto L115;
L115: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L116: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L117: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L121;
L119: // INIT_INT
  int_vars[6] = 0;
L120: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L121;
L121: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L122: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__Util__test_reversel(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int64_t long_vars[5];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[7];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[2];
L7: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L8: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L10: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L11: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[4];
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L15: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[2] = *(int64_t*)&stack[0];
    }
  }
L16: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L17: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L18: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2122;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L22: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L24: // CALL_SUB_VOID
  // SPVM::Util->reversel
  {
    if (SUB_ID_SPVM__Util__reversel < 0) {
      SUB_ID_SPVM__Util__reversel = env->get_sub_id(env, "SPVM::Util", "reversel", "void(long[])");
      if (SUB_ID_SPVM__Util__reversel < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversel");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversel;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2123;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L30: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L32: // MOVE_LONG
  long_vars[1] = long_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L34: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L37: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L38: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L39: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L42: // CONVERT_INT_TO_LONG
  long_vars[3] = (int64_t)int_vars[6];
L43: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L44: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L47: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L48: // CALL_SUB_INT
  // SPVM::Util->equals_larray
  {
    if (SUB_ID_SPVM__Util__equals_larray < 0) {
      SUB_ID_SPVM__Util__equals_larray = env->get_sub_id(env, "SPVM::Util", "equals_larray", "int(long[],long[])");
      if (SUB_ID_SPVM__Util__equals_larray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_larray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_larray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2124;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L50: // BOOL_INT
  int_vars[0] = int_vars[8];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L129;
L55: // GOTO
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L60: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L62: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L63: // CONVERT_INT_TO_LONG
  long_vars[0] = (int64_t)int_vars[5];
L64: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L65: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[0];
      } 
    } 
  } 
L66: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L67: // MOVE_CONSTANT_INT
  int_vars[7] = 3;
L68: // CONVERT_INT_TO_LONG
  long_vars[1] = (int64_t)int_vars[7];
L69: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L70: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[9] = 5;
L73: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[9];
L74: // MOVE_CONSTANT_INT
  int_vars[10] = 2;
L75: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[10];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[2];
      } 
    } 
  } 
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L77: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[3] = *(int64_t*)&stack[0];
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[11] = 3;
L80: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[11];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[3];
      } 
    } 
  } 
L81: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2129;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
L84: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L85: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L86: // CALL_SUB_VOID
  // SPVM::Util->reversel
  {
    if (SUB_ID_SPVM__Util__reversel < 0) {
      SUB_ID_SPVM__Util__reversel = env->get_sub_id(env, "SPVM::Util", "reversel", "void(long[])");
      if (SUB_ID_SPVM__Util__reversel < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util reversel");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__reversel;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L87: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2130;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L90: // NEW_LONG_ARRAY
  {
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_long_array_raw(env, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L92: // CALL_SUB_LONG
  // SPVM::Util->INT64_MAX
  {
    if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
      SUB_ID_SPVM__Util__INT64_MAX = env->get_sub_id(env, "SPVM::Util", "INT64_MAX", "long()");
      if (SUB_ID_SPVM__Util__INT64_MAX < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util INT64_MAX");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__INT64_MAX;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      long_vars[0] = *(int64_t*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L94: // MOVE_LONG
  long_vars[1] = long_vars[0];
L95: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L96: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
((int64_t*)((intptr_t)array + object_header_byte_size))[index]
 = long_vars[1];
      } 
    } 
  } 
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::Util";
    const char* sub_name = "test_reversel";
    const char* file = "TestCase/Lib/SPVM/Util.spvm";
    int32_t line = 2131;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L129;
  }
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L99: // CONVERT_INT_TO_LONG
  long_vars[2] = (int64_t)int_vars[4];
L100: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L101: // ARRAY_STORE_LONG
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env