#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
static int32_t FIELD_ID_SPVM__ObjectList__capacity = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity = -1;
static int32_t FIELD_ID_SPVM__ObjectList__length = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__ObjectList__length = -1;
static int32_t FIELD_ID_SPVM__Int__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Int__val = -1;
static int32_t FIELD_ID_SPVM__Double__val = -1;
static int32_t FIELD_BYTE_OFFSET_SPVM__Double__val = -1;
// Sub id declarations
static int32_t SUB_ID_SPVM__ObjectList__capacity = - 1;
static int32_t SUB_ID_SPVM__ObjectList__length = - 1;
static int32_t SUB_ID_SPVM__ObjectList__get = - 1;
static int32_t SUB_ID_SPVM__ObjectList__newa = - 1;
static int32_t SUB_ID_SPVM__ObjectList__insert = - 1;
static int32_t SUB_ID_SPVM__ObjectList__to_array = - 1;
static int32_t SUB_ID_SPVM__EqualityChecker__SameObject__new = - 1;
static int32_t SUB_ID_SPVM__Util__equals_oarray = - 1;
static int32_t SUB_ID_SPVM__ObjectList__remove = - 1;
static int32_t SUB_ID_SPVM__ObjectList__new = - 1;
static int32_t SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = - 1;
static int32_t SUB_ID_SPVM__Int__new = - 1;
static int32_t SUB_ID_SPVM__ObjectList__new_capacity = - 1;
static int32_t SUB_ID_SPVM__Int__val = - 1;
static int32_t SUB_ID_SPVM__ObjectList__push = - 1;
static int32_t SUB_ID_SPVM__ObjectList__shift = - 1;
static int32_t SUB_ID_SPVM__ObjectList__unshift = - 1;
static int32_t SUB_ID_SPVM__ObjectList__pop = - 1;
static int32_t SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = - 1;
static int32_t SUB_ID_SPVM__ObjectList__set = - 1;
static int32_t SUB_ID_SPVM__ObjectList__splice = - 1;
static int32_t SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = - 1;
static int32_t SUB_ID_SPVM__Double__val = - 1;
// Basic type id declarations
static int32_t BASIC_TYPE_ID_object = -1;
static int32_t BASIC_TYPE_ID_byte = -1;
static int32_t BASIC_TYPE_ID_SPVM__Int = -1;
static int32_t BASIC_TYPE_ID_SPVM__Double = -1;
// Function Declarations
// [SIG]int(SPVM::ObjectList,int,int,int)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(object[],object[])
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int(SPVM::ObjectList,SPVM::ObjectList)
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__insert(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__remove(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_ctor_default(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_ctor_with_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_ctor_with_capacity(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_get(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_length(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_offset_by_alternate_push_and_shift(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_offset_by_alternate_unshift_and_pop(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_pop(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_push(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_set(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_shift(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice_no_reallocation(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice_offset_is_valid_when_appended(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice_offset_is_valid_when_removed(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_to_array(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_unshift(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[20] = {0};
  int32_t int_vars[14];
  int32_t exception_flag = 0;
  int32_t mortal_stack[21];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  int_vars[1] = *(int32_t*)&stack[1];
  int_vars[2] = *(int32_t*)&stack[2];
  int_vars[3] = *(int32_t*)&stack[3];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__capacity < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__capacity = env->get_field_id(env, "SPVM::ObjectList", "capacity", "int");
      if (FIELD_ID_SPVM__ObjectList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__capacity);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L4: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[1]);
L5: // BOOL_INT
  int_vars[0] = int_vars[0];
L6: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L18; }
L7: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 158;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L9: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L10: // BOOL_INT
  int_vars[0] = int_vars[0];
L11: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L15; }
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[5];
L14: // GOTO
  goto L17;
L15: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L16: // BOOL_INT
  int_vars[0] = int_vars[6];
L17: // GOTO
  goto L20;
L18: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L19: // BOOL_INT
  int_vars[0] = int_vars[7];
L20: // BOOL_INT
  int_vars[0] = int_vars[0];
L21: // IF_NE_ZERO
  if (int_vars[0]) { goto L77; }
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L23: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x4C\x69\x73\x74\x20\x66\x69\x65\x6C\x64\x73\x20\x6D\x69\x73\x6D\x61\x74\x63\x68\x2E\x0A\x09\x67\x6F\x74\x3A\x20\x20\x20\x20\x20\x20\x28\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 44));
L24: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__capacity < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__capacity = env->get_field_id(env, "SPVM::ObjectList", "capacity", "int");
      if (FIELD_ID_SPVM__ObjectList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__capacity);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[5] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L27: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[5]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], string);
  }
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L29: // CONCAT
  {
    void* string1 = object_vars[1];
    void* string2 = object_vars[2];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string3);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L32: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x2C\x20\x6C\x65\x6E\x67\x74\x68\x3A\x20", 10));
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L34: // CONCAT
  {
    void* string1 = object_vars[3];
    void* string2 = object_vars[4];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], string3);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L36: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[6] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L38: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L39: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[6]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string);
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L41: // CONCAT
  {
    void* string1 = object_vars[5];
    void* string2 = object_vars[6];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string3);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L44: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], env->new_string_len_raw(env, "\x29\x0A\x09", 3));
L45: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L46: // CONCAT
  {
    void* string1 = object_vars[7];
    void* string2 = object_vars[8];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], string3);
    }
  }
L47: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L49: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], env->new_string_len_raw(env, "\x65\x78\x70\x65\x63\x74\x65\x64\x3A\x20\x28\x63\x61\x70\x61\x63\x69\x74\x79\x3A\x20", 21));
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L51: // CONCAT
  {
    void* string1 = object_vars[9];
    void* string2 = object_vars[10];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], string3);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 160;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L54: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[1]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], string);
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 13;
  mortal_stack_top++;
L56: // CONCAT
  {
    void* string1 = object_vars[11];
    void* string2 = object_vars[12];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[13], string3);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 14;
  mortal_stack_top++;
L59: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[14], env->new_string_len_raw(env, "\x2C\x20\x6C\x65\x6E\x67\x74\x68\x3A\x20", 10));
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 15;
  mortal_stack_top++;
L61: // CONCAT
  {
    void* string1 = object_vars[13];
    void* string2 = object_vars[14];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[15], string3);
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 16;
  mortal_stack_top++;
L64: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[16], string);
  }
L65: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 17;
  mortal_stack_top++;
L66: // CONCAT
  {
    void* string1 = object_vars[15];
    void* string2 = object_vars[16];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[17], string3);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L68: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 18;
  mortal_stack_top++;
L69: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[18], env->new_string_len_raw(env, "\x29", 1));
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 19;
  mortal_stack_top++;
L71: // CONCAT
  {
    void* string1 = object_vars[17];
    void* string2 = object_vars[18];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[19], string3);
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "check_fields";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 161;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L73: // WARN
  {
    void* object = object_vars[19];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 159);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 159);
    }
  }
L74: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L75: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L83;
L76: // GOTO
  goto L78;
L77: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[10] = 1;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L83;
L81: // INIT_INT
  int_vars[12] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[12];
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[1] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L5: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 188;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L7: // NE_INT
  int_vars[0] = (int_vars[1] != int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L35; }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x72\x72\x61\x79\x20\x73\x69\x7A\x65\x20\x6D\x69\x73\x6D\x61\x74\x63\x68\x2E\x20\x67\x6F\x74\x3A\x20", 26));
L12: // ARRAY_LENGTH
  if (object_vars[0] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset);
  }
L13: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L14: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L15: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[2]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L17: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L20: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], env->new_string_len_raw(env, "\x2C\x20\x65\x78\x70\x65\x63\x74\x65\x64\x3A\x20", 12));
L21: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L22: // CONCAT
  {
    void* string1 = object_vars[4];
    void* string2 = object_vars[5];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], string3);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L24: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[3] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L27: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[3]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], string);
  }
L28: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L29: // CONCAT
  {
    void* string1 = object_vars[6];
    void* string2 = object_vars[7];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], string3);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 189;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L31: // WARN
  {
    void* object = object_vars[8];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 189);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 189);
    }
  }
L32: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L33: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L87;
L34: // GOTO
  goto L36;
L35: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L36: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L38: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L39: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L40: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L43: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L44: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L45: // GOTO
  goto L77;
L46: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L47: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object); 
      } 
    } 
  } 
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L50: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object); 
      } 
    } 
  } 
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 193;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L52: // NE_OBJECT
  int_vars[0] = (object_vars[2] != object_vars[3]);
L53: // BOOL_INT
  int_vars[0] = int_vars[0];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L68; }
L55: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L58: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x41\x72\x72\x61\x79\x20\x63\x6F\x6E\x74\x65\x6E\x74\x20\x6D\x69\x73\x6D\x61\x74\x63\x68\x2E\x20\x73\x75\x62\x73\x63\x72\x69\x70\x74\x20", 34));
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L60: // CONVERT_INT_TO_STRING
  {
    sprintf(convert_string_buffer, "%" PRId32, int_vars[7]);
    int32_t string_length = strlen(convert_string_buffer);
    void* string = env->new_string_len_raw(env, convert_string_buffer, string_length);
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], string);
  }
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L62: // CONCAT
  {
    void* string1 = object_vars[2];
    void* string2 = object_vars[3];
    if (string1 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater left value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else if (string2 == NULL) {
      void* exception = env->new_string_raw(env, "\".\" operater right value must be defined");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
    else {
      void* string3 = env->concat_raw(env, string1, string2);
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], string3);
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L64: // WARN
  {
    void* object = object_vars[4];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 194);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 194);
    }
  }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L87;
L67: // GOTO
  goto L69;
L68: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L69: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L70: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L71: // MOVE_INT
  int_vars[5] = int_vars[7];
L72: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L73: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L76: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L77: // ARRAY_LENGTH
  if (object_vars[1] == NULL) {
    env->set_exception(env, env->new_string_raw(env, "Can't get array length of undef value."));
    exception_flag = 1;
  }
  else {
    int_vars[2] = *(int32_t*)((intptr_t)object_vars[1] + (intptr_t)env->object_length_offset);
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 192;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L87;
  }
L79: // LT_INT
  int_vars[0] = (int_vars[7] < int_vars[2]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L82: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L83: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L84: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L87;
L85: // INIT_INT
  int_vars[5] = 0;
L86: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L87;
L87: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L88: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];
  // Copy arguments to variables
  object_vars[0] = *(void**)&stack[0];
  if (object_vars[0] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[0]); }
  object_vars[1] = *(void**)&stack[1];
  if (object_vars[1] != NULL) { SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object_vars[1]); }

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L3: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_list_deeply";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L5: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_list_deeply";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 168;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L7: // EQ_INT
  int_vars[0] = (int_vars[1] == int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x4C\x65\x6E\x67\x74\x68\x20\x6D\x69\x73\x6D\x61\x74\x63\x68\x2E\x20\x54\x72\x79\x20\x63\x68\x65\x63\x6B\x5F\x66\x69\x65\x6C\x64\x73\x28\x29\x20\x66\x69\x72\x73\x74", 41));
L12: // WARN
  {
    void* object = object_vars[2];
    int32_t empty_or_undef = 0;
    if (object) {
      const char* bytes = (const char*)env->get_elems_byte(env, object);
      int32_t string_length = env->length(env, object);
      if (string_length > 0) {
        size_t ret = fwrite(bytes, 1, string_length, stderr);
        int32_t add_line_file;
        if (bytes[string_length - 1] != '\n') {
          fprintf(stderr, " at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 169);
        }
      }
      else {
        empty_or_undef = 1;
      }
    }
    else {
      empty_or_undef = 1;
    }
    if (empty_or_undef) {
        fprintf(stderr, "Warning: something's wrong at %s line %d\n", "TestCase/Lib/SPVM/ObjectList.spvm", 169);
    }
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L59;
L15: // GOTO
  goto L17;
L16: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L17: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L19: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L20: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L21: // GOTO
  goto L44;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L23: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L24: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L25: // CALL_SUB_OBJECT
  // SPVM::ObjectList->get
  {
    if (SUB_ID_SPVM__ObjectList__get < 0) {
      SUB_ID_SPVM__ObjectList__get = env->get_sub_id(env, "SPVM::ObjectList", "get", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_list_deeply";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // CALL_SUB_OBJECT
  // SPVM::ObjectList->get
  {
    if (SUB_ID_SPVM__ObjectList__get < 0) {
      SUB_ID_SPVM__ObjectList__get = env->get_sub_id(env, "SPVM::ObjectList", "get", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_list_deeply";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 174;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L32: // EQ_OBJECT
  int_vars[0] = (object_vars[2] == object_vars[3]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_NE_ZERO
  if (int_vars[0]) { goto L39; }
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L38: // GOTO
  goto L39;
L39: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L40: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L41: // MOVE_INT
  int_vars[3] = int_vars[2];
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // ADD_INT
  int_vars[2] = int_vars[3] + int_vars[4];
L44: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "equals_list_deeply";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 173;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L59;
  }
L46: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // BOOL_INT
  int_vars[0] = int_vars[5];
L51: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L55; }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L59;
L54: // GOTO
  goto L57;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L56: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L59;
L57: // INIT_INT
  int_vars[7] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L59;
L59: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L60: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__insert(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[54];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L11: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L14: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L22: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L26: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 15;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L33: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L34: // CALL_SUB_VOID
  // SPVM::ObjectList->insert
  {
    if (SUB_ID_SPVM__ObjectList__insert < 0) {
      SUB_ID_SPVM__ObjectList__insert = env->get_sub_id(env, "SPVM::ObjectList", "insert", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 16;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L36: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L37: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L38: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L41: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L42: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L45: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L48: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L51: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L54: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L57: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L60: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[7];
L62: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 17;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[7];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L74: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L75: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L77: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L78: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L79: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L81: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L82: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L84: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L87: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L88: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L89: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L90: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L91: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L92: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L94: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L95: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L97: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L98: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L99: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 29;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L101: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L103: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L105: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L106: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L107: // CALL_SUB_VOID
  // SPVM::ObjectList->insert
  {
    if (SUB_ID_SPVM__ObjectList__insert < 0) {
      SUB_ID_SPVM__ObjectList__insert = env->get_sub_id(env, "SPVM::ObjectList", "insert", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L108: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 30;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L109: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L110: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L111: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L112: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L113: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L114: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L115: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L116: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L117: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L118: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L121: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L122: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L123: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L124: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L126: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L127: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L129: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L130: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L132: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L133: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L134: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[7];
L135: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 31;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L137: // BOOL_INT
  int_vars[0] = int_vars[7];
L138: // IF_NE_ZERO
  if (int_vars[0]) { goto L145; }
L139: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L141: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L142: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L143: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L144: // GOTO
  goto L145;
L145: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L146: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L147: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L148: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L149: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L150: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L151: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L152: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L153: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L154: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L155: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L156: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L157: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L158: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L159: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L160: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L161: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L162: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L163: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L164: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L165: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L167: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L168: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L170: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L171: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L172: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 43;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L174: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L175: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L176: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L177: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L178: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L179: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L180: // CALL_SUB_VOID
  // SPVM::ObjectList->insert
  {
    if (SUB_ID_SPVM__ObjectList__insert < 0) {
      SUB_ID_SPVM__ObjectList__insert = env->get_sub_id(env, "SPVM::ObjectList", "insert", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L181: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 44;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L182: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L183: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L184: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L185: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L186: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L187: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L188: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L190: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L191: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L192: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L193: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L194: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L195: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L196: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L197: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L198: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L199: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L200: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L201: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L202: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L203: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L204: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L205: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L206: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L207: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[7];
L208: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 45;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L210: // BOOL_INT
  int_vars[0] = int_vars[7];
L211: // IF_NE_ZERO
  if (int_vars[0]) { goto L218; }
L212: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L213: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L214: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L215: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L216: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L217: // GOTO
  goto L218;
L218: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L219: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L220: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L221: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L222: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L223: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L224: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L225: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L226: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L227: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L228: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L229: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L230: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L231: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L232: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L233: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L234: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L235: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L236: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L237: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L238: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L239: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L240: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L241: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L242: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L243: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L244: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L245: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L246: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 57;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L247: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L248: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L249: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L250: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L251: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L252: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[3];
L253: // CALL_SUB_VOID
  // SPVM::ObjectList->insert
  {
    if (SUB_ID_SPVM__ObjectList__insert < 0) {
      SUB_ID_SPVM__ObjectList__insert = env->get_sub_id(env, "SPVM::ObjectList", "insert", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L254: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 58;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L255: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__capacity < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__capacity = env->get_field_id(env, "SPVM::ObjectList", "capacity", "int");
      if (FIELD_ID_SPVM__ObjectList__capacity < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__capacity);
    };
    void* object = object_vars[6];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__capacity);
    }
  }
L256: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 59;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L371;
  }
L257: // MOVE_CONSTANT_INT
  int_vars[3] = 6;
L258: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L259: // BOOL_INT
  int_vars[0] = int_vars[0];
L260: // IF_NE_ZERO
  if (int_vars[0]) { goto L264; }
L261: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L262: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L263: // GOTO
  goto L264;
L264: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L265: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L266: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L267: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L268: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L269: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 66;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L305;
  }
L270: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L271: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x31", 1));
L272: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L273: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L274: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L275: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L276: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 66;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L305;
  }
L277: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L278: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x32", 1));
L279: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L280: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L281: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 66;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L305;
  }
L282: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L283: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x33", 1));
L284: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L285: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L286: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 66;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L305;
  }
L287: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L288: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L289: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L290: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 66;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L305;
  }
L291: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L292: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L293: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L294: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L295: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L296: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L297: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L298: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x32", 1));
L299: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L300: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L301: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[0];
L302: // CALL_SUB_VOID
  // SPVM::ObjectList->insert
  {
    if (SUB_ID_SPVM__ObjectList__insert < 0) {
      SUB_ID_SPVM__ObjectList__insert = env->get_sub_id(env, "SPVM::ObjectList", "insert", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L303: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 67;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L305;
  }
L304: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L305: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L306: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L307: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L308: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L309: // IF_NE_ZERO
  if (int_vars[0]) { goto L314; }
L310: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L311: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L312: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L313: // GOTO
  goto L314;
L314: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L315: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L316: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L317: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L318: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L319: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L320: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 76;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L356;
  }
L321: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L322: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x31", 1));
L323: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L324: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L325: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L326: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L327: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 76;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L356;
  }
L328: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L329: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x32", 1));
L330: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L331: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L332: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 76;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L356;
  }
L333: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L334: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x33", 1));
L335: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L336: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L337: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 76;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L356;
  }
L338: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L339: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L340: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L341: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 76;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L356;
  }
L342: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L343: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L344: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L345: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L346: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L347: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L348: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L349: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x32", 1));
L350: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L351: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L352: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[0];
L353: // CALL_SUB_VOID
  // SPVM::ObjectList->insert
  {
    if (SUB_ID_SPVM__ObjectList__insert < 0) {
      SUB_ID_SPVM__ObjectList__insert = env->get_sub_id(env, "SPVM::ObjectList", "insert", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__insert < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList insert");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__insert;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L354: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "insert";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 77;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L356;
  }
L355: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L356: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L357: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L358: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L359: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L360: // IF_NE_ZERO
  if (int_vars[0]) { goto L365; }
L361: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L362: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L363: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L364: // GOTO
  goto L365;
L365: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L366: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L367: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L368: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L371;
L369: // INIT_INT
  int_vars[4] = 0;
L370: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L371;
L371: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L372: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__remove(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[50];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L3: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L4: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L8: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L11: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L14: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L15: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L19: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L22: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L25: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L29: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 95;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L36: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L37: // CALL_SUB_OBJECT
  // SPVM::ObjectList->remove
  {
    if (SUB_ID_SPVM__ObjectList__remove < 0) {
      SUB_ID_SPVM__ObjectList__remove = env->get_sub_id(env, "SPVM::ObjectList", "remove", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 96;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L41: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L45: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L48: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L51: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L53: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L54: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L56: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L57: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L58: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L59: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L60: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[7];
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[8];
L62: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 97;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[6];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L72; }
L66: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L67: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L68: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L69: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L70: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L71: // GOTO
  goto L72;
L72: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L73: // EQ_OBJECT
  int_vars[0] = (object_vars[4] == object_vars[1]);
L74: // BOOL_INT
  int_vars[0] = int_vars[0];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L78: // GOTO
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L81: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L82: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L83: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L84: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L85: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L87: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L88: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L90: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L92: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L93: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L94: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L95: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L98: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L101: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L103: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L105: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 112;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L107: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L108: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L110: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L111: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L112: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L113: // CALL_SUB_OBJECT
  // SPVM::ObjectList->remove
  {
    if (SUB_ID_SPVM__ObjectList__remove < 0) {
      SUB_ID_SPVM__ObjectList__remove = env->get_sub_id(env, "SPVM::ObjectList", "remove", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L114: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 113;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L115: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L116: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L117: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L118: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L120: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L121: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L122: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L124: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L125: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L128: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L129: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L130: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L131: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L133: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L134: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L135: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[7];
L136: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L137: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 114;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L138: // BOOL_INT
  int_vars[0] = int_vars[5];
L139: // IF_NE_ZERO
  if (int_vars[0]) { goto L146; }
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L141: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L142: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L143: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L144: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L145: // GOTO
  goto L146;
L146: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L147: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L149: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->new_string_len_raw(env, "\x31", 1));
L150: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L151: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x32", 1));
L152: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L153: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], env->new_string_len_raw(env, "\x33", 1));
L154: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L155: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x34", 1));
L156: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L157: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L158: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L159: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L160: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L161: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[0]);
L162: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L163: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L164: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L166: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L167: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L168: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L169: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L170: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L171: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L172: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L173: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L174: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 126;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L175: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L176: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L177: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L178: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L179: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L180: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L181: // CALL_SUB_OBJECT
  // SPVM::ObjectList->remove
  {
    if (SUB_ID_SPVM__ObjectList__remove < 0) {
      SUB_ID_SPVM__ObjectList__remove = env->get_sub_id(env, "SPVM::ObjectList", "remove", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 127;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L183: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L184: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L185: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L186: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L187: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L188: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L189: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L190: // NEW_MULTI_ARRAY
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_byte;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_muldim_array_raw(env, basic_type_id, 1, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L192: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L193: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L195: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L196: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L197: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L198: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L199: // CALL_SUB_OBJECT
  // SPVM::EqualityChecker::SameObject->new
  {
    if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
      SUB_ID_SPVM__EqualityChecker__SameObject__new = env->get_sub_id(env, "SPVM::EqualityChecker::SameObject", "new", "SPVM::EqualityChecker::SameObject()");
      if (SUB_ID_SPVM__EqualityChecker__SameObject__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::EqualityChecker::SameObject new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__EqualityChecker__SameObject__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L201: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L202: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L203: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[7];
L204: // CALL_SUB_INT
  // SPVM::Util->equals_oarray
  {
    if (SUB_ID_SPVM__Util__equals_oarray < 0) {
      SUB_ID_SPVM__Util__equals_oarray = env->get_sub_id(env, "SPVM::Util", "equals_oarray", "int(oarray,oarray,SPVM::EqualityChecker)");
      if (SUB_ID_SPVM__Util__equals_oarray < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Util equals_oarray");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Util__equals_oarray;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L205: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 128;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L318;
  }
L206: // BOOL_INT
  int_vars[0] = int_vars[5];
L207: // IF_NE_ZERO
  if (int_vars[0]) { goto L214; }
L208: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L209: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L210: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L211: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L212: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L213: // GOTO
  goto L214;
L214: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L215: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L216: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L217: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L218: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L219: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L220: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 135;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L221: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L222: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x31", 1));
L223: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L224: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L225: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L226: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L227: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 135;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L228: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L229: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x32", 1));
L230: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L231: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L232: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 135;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L233: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L234: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x33", 1));
L235: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L236: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L237: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 135;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L238: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L239: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L240: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L241: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 135;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L242: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L243: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L244: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L245: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L246: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L247: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L248: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L249: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L250: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L251: // CALL_SUB_OBJECT
  // SPVM::ObjectList->remove
  {
    if (SUB_ID_SPVM__ObjectList__remove < 0) {
      SUB_ID_SPVM__ObjectList__remove = env->get_sub_id(env, "SPVM::ObjectList", "remove", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L252: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 136;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L254;
  }
L253: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L254: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L255: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L256: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L257: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L258: // IF_NE_ZERO
  if (int_vars[0]) { goto L263; }
L259: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L260: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L261: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L262: // GOTO
  goto L263;
L263: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L264: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L265: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L266: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L267: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L268: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L269: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 145;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L303;
  }
L270: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L271: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x31", 1));
L272: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L273: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L274: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L275: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L276: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 145;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L303;
  }
L277: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L278: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x32", 1));
L279: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L280: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L281: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 145;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L303;
  }
L282: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L283: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], env->new_string_len_raw(env, "\x33", 1));
L284: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L285: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L286: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 145;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L303;
  }
L287: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L288: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L289: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L290: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 145;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L303;
  }
L291: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L292: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L293: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L294: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L295: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L296: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L297: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L298: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L299: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L300: // CALL_SUB_OBJECT
  // SPVM::ObjectList->remove
  {
    if (SUB_ID_SPVM__ObjectList__remove < 0) {
      SUB_ID_SPVM__ObjectList__remove = env->get_sub_id(env, "SPVM::ObjectList", "remove", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__remove < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList remove");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__remove;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L301: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "remove";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 146;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L303;
  }
L302: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L303: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L304: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L305: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L306: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L307: // IF_NE_ZERO
  if (int_vars[0]) { goto L312; }
L308: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L309: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L310: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L311: // GOTO
  goto L312;
L312: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L313: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L314: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L315: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L318;
L316: // INIT_INT
  int_vars[4] = 0;
L317: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L318;
L318: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L319: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_ctor_default(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[2];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new
  {
    if (SUB_ID_SPVM__ObjectList__new < 0) {
      SUB_ID_SPVM__ObjectList__new = env->get_sub_id(env, "SPVM::ObjectList", "new", "SPVM::ObjectList()");
      if (SUB_ID_SPVM__ObjectList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_default";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L4: // MOVE_CONSTANT_INT
  int_vars[1] = 16;
L5: // MOVE_CONSTANT_INT
  int_vars[2] = -16;
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L7: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[1];
L9: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[2];
L10: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[3];
L11: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_default";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L15: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L18: // GOTO
  goto L19;
L19: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L25: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_ctor_with_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[9];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L7: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 230;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L9: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L10: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L11: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L13: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L14: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L15: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L16: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L17: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 231;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L19: // BOOL_INT
  int_vars[0] = int_vars[5];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L26: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L29: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 235;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L32: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L33: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L34: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L36: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L37: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L38: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L39: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L40: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 236;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L41: // BOOL_INT
  int_vars[0] = int_vars[5];
L42: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L45: // GOTO
  goto L46;
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L49: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L50: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 240;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L52: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L53: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L54: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L55: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L56: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[0]);
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L59: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 241;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L61: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L62: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[2]);
L63: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L64: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L66: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 242;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L69: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L70: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L71: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L72: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L73: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L74: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L75: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L76: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 243;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L77: // BOOL_INT
  int_vars[0] = int_vars[5];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L82; }
L79: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L81: // GOTO
  goto L82;
L82: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L84: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L85: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 247;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L87: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L88: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 248;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L91: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 249;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L93: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L94: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 250;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L97: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L98: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 251;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L99: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L100: // MOVE_CONSTANT_INT
  int_vars[3] = -4;
L101: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L103: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L104: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L105: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L106: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 252;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L117;
  }
L108: // BOOL_INT
  int_vars[0] = int_vars[5];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L113; }
L110: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L111: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L117;
L112: // GOTO
  goto L113;
L113: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L114: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L117;
L115: // INIT_INT
  int_vars[6] = 0;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L117;
L117: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L118: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_ctor_with_capacity(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[1] = {0};
  int32_t int_vars[7];
  int32_t exception_flag = 0;
  int32_t mortal_stack[6];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 20000;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_capacity";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 20000;
L7: // MOVE_CONSTANT_INT
  int_vars[3] = -20000;
L8: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L9: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L10: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L11: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L12: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L13: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_capacity";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 209;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L62;
  }
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L21; }
L17: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L18: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L19: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L62;
L20: // GOTO
  goto L21;
L21: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L22: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L23: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L25: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L26: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_capacity";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 213;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L29;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L29: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L31: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L32: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L33: // IF_NE_ZERO
  if (int_vars[0]) { goto L38; }
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L35: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L36: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L62;
L37: // GOTO
  goto L38;
L38: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L39: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L40: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L41: // MOVE_CONSTANT_INT
  int_vars[2] = -1;
L42: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L43: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L44: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L45: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_ctor_with_capacity";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 220;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L47;
  }
L46: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L47: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L49: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L50: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L51: // IF_NE_ZERO
  if (int_vars[0]) { goto L56; }
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L54: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L62;
L55: // GOTO
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L59: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L62;
L60: // INIT_INT
  int_vars[4] = 0;
L61: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L62;
L62: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L63: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_get(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L8: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[4] < 0 || int_vars[4]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 451;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L30: // CALL_SUB_OBJECT
  // SPVM::ObjectList->get
  {
    if (SUB_ID_SPVM__ObjectList__get < 0) {
      SUB_ID_SPVM__ObjectList__get = env->get_sub_id(env, "SPVM::ObjectList", "get", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L31: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L33: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L34: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L35: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 452;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L38: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_NE_ZERO
  if (int_vars[0]) { goto L46; }
L41: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L42: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L44: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L65;
L45: // GOTO
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L48: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L49: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L50: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L51: // CALL_SUB_OBJECT
  // SPVM::ObjectList->get
  {
    if (SUB_ID_SPVM__ObjectList__get < 0) {
      SUB_ID_SPVM__ObjectList__get = env->get_sub_id(env, "SPVM::ObjectList", "get", "object(self,int)");
      if (SUB_ID_SPVM__ObjectList__get < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList get");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__get;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L52: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_get";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 455;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L65;
  }
L53: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_NE_ZERO
  if (int_vars[0]) { goto L60; }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L57: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L58: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L65;
L59: // GOTO
  goto L60;
L60: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L62: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L65;
L63: // INIT_INT
  int_vars[6] = 0;
L64: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L65;
L65: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L66: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_length(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[3] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[5];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L2: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new
  {
    if (SUB_ID_SPVM__ObjectList__new < 0) {
      SUB_ID_SPVM__ObjectList__new = env->get_sub_id(env, "SPVM::ObjectList", "new", "SPVM::ObjectList()");
      if (SUB_ID_SPVM__ObjectList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L3: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L4: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[0];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[1] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 260;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // NE_INT
  int_vars[0] = (int_vars[1] != int_vars[2]);
L8: // BOOL_INT
  int_vars[0] = int_vars[0];
L9: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L14; }
L10: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L13: // GOTO
  goto L14;
L14: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L17: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L21: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[5];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L22: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L23: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L24: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L25: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L29: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__ObjectList__length < 0, 0)) {
      FIELD_ID_SPVM__ObjectList__length = env->get_field_id(env, "SPVM::ObjectList", "length", "int");
      if (FIELD_ID_SPVM__ObjectList__length < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::ObjectList length");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__ObjectList__length = env->get_field_offset(env, FIELD_ID_SPVM__ObjectList__length);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[7] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__ObjectList__length);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_length";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 263;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L46;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[8] = 1;
L32: // NE_INT
  int_vars[0] = (int_vars[7] != int_vars[8]);
L33: // BOOL_INT
  int_vars[0] = int_vars[0];
L34: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L41; }
L35: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L36: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L37: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L46;
L40: // GOTO
  goto L41;
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L43: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L46;
L44: // INIT_INT
  int_vars[6] = 0;
L45: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L46;
L46: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L47: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_offset_by_alternate_push_and_shift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[13];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_push_and_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 409;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // GOTO
  goto L45;
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_push_and_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 411;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L15: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L18: // CALL_SUB_OBJECT
  // SPVM::ObjectList->shift
  {
    if (SUB_ID_SPVM__ObjectList__shift < 0) {
      SUB_ID_SPVM__ObjectList__shift = env->get_sub_id(env, "SPVM::ObjectList", "shift", "object(self)");
      if (SUB_ID_SPVM__ObjectList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_push_and_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 412;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L23: // ADD_INT
  int_vars[5] = int_vars[2] + int_vars[4];
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L25: // REMAINDER_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[7] = int_vars[5] % /* REMAINDER */ int_vars[6];
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_push_and_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L27: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L28: // SUBTRACT_INT
  int_vars[9] = int_vars[7] - int_vars[8];
L29: // MOVE_CONSTANT_INT
  int_vars[10] = 0;
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L31: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L32: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[9];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[10];
L34: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[11] = *(int32_t*)&stack[0];
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_push_and_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 413;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L54;
  }
L36: // BOOL_INT
  int_vars[0] = int_vars[11];
L37: // IF_NE_ZERO
  if (int_vars[0]) { goto L41; }
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L39: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L54;
L40: // GOTO
  goto L41;
L41: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L42: // MOVE_INT
  int_vars[5] = int_vars[2];
L43: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L44: // ADD_INT
  int_vars[2] = int_vars[5] + int_vars[6];
L45: // MOVE_CONSTANT_INT
  int_vars[3] = 16;
L46: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L47: // BOOL_INT
  int_vars[0] = int_vars[0];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L8; }
L49: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L54;
L52: // INIT_INT
  int_vars[5] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_offset_by_alternate_unshift_and_pop(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[2] = {0};
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[4];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 4;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_unshift_and_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 421;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L7: // GOTO
  goto L47;
L8: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L9: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L10: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object);
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_unshift_and_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 423;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L15: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L16: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L18: // CALL_SUB_OBJECT
  // SPVM::ObjectList->pop
  {
    if (SUB_ID_SPVM__ObjectList__pop < 0) {
      SUB_ID_SPVM__ObjectList__pop = env->get_sub_id(env, "SPVM::ObjectList", "pop", "object(self)");
      if (SUB_ID_SPVM__ObjectList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_unshift_and_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 424;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L20: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L21: // MOVE_CONSTANT_INT
  int_vars[3] = 4;
L22: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L23: // SUBTRACT_INT
  int_vars[5] = int_vars[4] - int_vars[2];
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 16;
L25: // ADD_INT
  int_vars[7] = int_vars[5] + int_vars[6];
L26: // MOVE_CONSTANT_INT
  int_vars[8] = 4;
L27: // REMAINDER_INT
  if (__builtin_expect(int_vars[8] == 0, 0)) {
    void* exception = env->new_string_raw(env, "0 division");
    env->set_exception(env, exception);
    exception_flag = 1;
  }
  else {
    int_vars[9] = int_vars[7] % /* REMAINDER */ int_vars[8];
  }
L28: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_unshift_and_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L29: // MOVE_CONSTANT_INT
  int_vars[10] = 4;
L30: // SUBTRACT_INT
  int_vars[11] = int_vars[9] - int_vars[10];
L31: // MOVE_CONSTANT_INT
  int_vars[12] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[3];
L34: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[11];
L35: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[12];
L36: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[13] = *(int32_t*)&stack[0];
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_offset_by_alternate_unshift_and_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 425;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L56;
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[13];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[3];
  goto L56;
L42: // GOTO
  goto L43;
L43: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L44: // MOVE_INT
  int_vars[5] = int_vars[2];
L45: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L46: // ADD_INT
  int_vars[2] = int_vars[5] + int_vars[6];
L47: // MOVE_CONSTANT_INT
  int_vars[3] = 16;
L48: // LT_INT
  int_vars[0] = (int_vars[2] < int_vars[3]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_NE_ZERO
  if (int_vars[0]) { goto L8; }
L51: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 1;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L56;
L54: // INIT_INT
  int_vars[5] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L56;
L56: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L57: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_pop(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[14];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L8: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[4] < 0 || int_vars[4]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L21: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L22: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L25: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L29: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 313;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L37: // CALL_SUB_OBJECT
  // SPVM::ObjectList->pop
  {
    if (SUB_ID_SPVM__ObjectList__pop < 0) {
      SUB_ID_SPVM__ObjectList__pop = env->get_sub_id(env, "SPVM::ObjectList", "pop", "object(self)");
      if (SUB_ID_SPVM__ObjectList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L42: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 314;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L45: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L56: // CALL_SUB_OBJECT
  // SPVM::ObjectList->pop
  {
    if (SUB_ID_SPVM__ObjectList__pop < 0) {
      SUB_ID_SPVM__ObjectList__pop = env->get_sub_id(env, "SPVM::ObjectList", "pop", "object(self)");
      if (SUB_ID_SPVM__ObjectList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 317;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L58: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L64: // GOTO
  goto L65;
L65: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L68: // CALL_SUB_OBJECT
  // SPVM::ObjectList->pop
  {
    if (SUB_ID_SPVM__ObjectList__pop < 0) {
      SUB_ID_SPVM__ObjectList__pop = env->get_sub_id(env, "SPVM::ObjectList", "pop", "object(self)");
      if (SUB_ID_SPVM__ObjectList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L71: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L73: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 320;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L76: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L86: // MOVE_CONSTANT_INT
  int_vars[5] = -3;
L87: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L89: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L90: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L91: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L92: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 323;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L94: // BOOL_INT
  int_vars[0] = int_vars[7];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L98: // GOTO
  goto L99;
L99: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L100: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new
  {
    if (SUB_ID_SPVM__ObjectList__new < 0) {
      SUB_ID_SPVM__ObjectList__new = env->get_sub_id(env, "SPVM::ObjectList", "new", "SPVM::ObjectList()");
      if (SUB_ID_SPVM__ObjectList__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L101: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 326;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L102: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[0];
L104: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L105: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 326;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L134;
  }
L106: // BOOL_INT
  int_vars[0] = int_vars[4];
L107: // IF_NE_ZERO
  if (int_vars[0]) { goto L112; }
L108: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L109: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L110: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L111: // GOTO
  goto L112;
L112: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L113: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L114: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L115: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L116: // CALL_SUB_OBJECT
  // SPVM::ObjectList->pop
  {
    if (SUB_ID_SPVM__ObjectList__pop < 0) {
      SUB_ID_SPVM__ObjectList__pop = env->get_sub_id(env, "SPVM::ObjectList", "pop", "object(self)");
      if (SUB_ID_SPVM__ObjectList__pop < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList pop");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__pop;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L117: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_pop";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 330;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L118: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L121: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L122: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L123: // IF_NE_ZERO
  if (int_vars[0]) { goto L128; }
L124: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L125: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L126: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L127: // GOTO
  goto L128;
L128: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L129: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L130: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L131: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L134;
L132: // INIT_INT
  int_vars[4] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L134;
L134: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L135: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_push(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[8] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[18];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 270;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 272;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 273;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L20: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L21: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L22: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 274;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[5];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L31: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[2], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L34: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object_vars[1]);
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L37: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[2];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[2];
L41: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L45: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 277;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[6];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L55; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L52: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L53: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L54: // GOTO
  goto L55;
L55: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 2;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L56: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L58: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L59: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 281;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L61: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L62: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L63: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 282;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L66: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L67: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L68: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L69: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L70: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L71: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L72: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L73: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 283;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L74: // BOOL_INT
  int_vars[0] = int_vars[5];
L75: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L78: // GOTO
  goto L79;
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L80: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L81: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L84: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[1]);
L85: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L86: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L87: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L89: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L90: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L92: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L93: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L94: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L95: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L96: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L97: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L98: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 286;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L100: // BOOL_INT
  int_vars[0] = int_vars[7];
L101: // IF_NE_ZERO
  if (int_vars[0]) { goto L108; }
L102: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L103: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L104: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L105: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L106: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L107: // GOTO
  goto L108;
L108: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 3;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L109: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L110: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L111: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L112: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 290;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L115: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L116: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 291;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L118: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L119: // MOVE_CONSTANT_INT
  int_vars[3] = -4;
L120: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L121: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L122: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L123: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L124: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L125: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L126: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 292;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L127: // BOOL_INT
  int_vars[0] = int_vars[5];
L128: // IF_NE_ZERO
  if (int_vars[0]) { goto L132; }
L129: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L131: // GOTO
  goto L132;
L132: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L133: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L134: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L136: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L137: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[1]);
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L140: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L141: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L142: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L143: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L144: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L145: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L146: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L147: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L148: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L149: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L150: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L151: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L152: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L153: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L154: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L155: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 295;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L156: // BOOL_INT
  int_vars[0] = int_vars[8];
L157: // IF_NE_ZERO
  if (int_vars[0]) { goto L164; }
L158: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L159: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L160: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L161: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L162: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L163: // GOTO
  goto L164;
L164: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L165: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L166: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L167: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L168: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 300;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L170: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L171: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L172: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L173: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 301;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L174: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L175: // MOVE_CONSTANT_INT
  int_vars[3] = -4;
L176: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L177: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L178: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L179: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L180: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L181: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L182: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 302;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L183: // BOOL_INT
  int_vars[0] = int_vars[5];
L184: // IF_NE_ZERO
  if (int_vars[0]) { goto L188; }
L185: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L186: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L187: // GOTO
  goto L188;
L188: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L189: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L190: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L191: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L192: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L193: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[1]);
L194: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L195: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L196: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L197: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L198: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L199: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L200: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L201: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L202: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L203: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L204: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L205: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L207: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L208: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L209: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L210: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L211: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L212: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[7];
L213: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L214: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_push";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 305;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L228;
  }
L215: // BOOL_INT
  int_vars[0] = int_vars[9];
L216: // IF_NE_ZERO
  if (int_vars[0]) { goto L223; }
L217: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L218: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L219: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L220: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L221: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L228;
L222: // GOTO
  goto L223;
L223: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L224: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L225: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L228;
L226: // INIT_INT
  int_vars[6] = 0;
L227: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L228;
L228: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L229: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_set(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[4] = {0};
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[8];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L8: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[4] < 0 || int_vars[4]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 433;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L23: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L24: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L25: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L28: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L29: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 435;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L32: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L34: // PUSH_ARG_UNDEF
  *(void**)&stack[2] = NULL;
L35: // CALL_SUB_VOID
  // SPVM::ObjectList->set
  {
    if (SUB_ID_SPVM__ObjectList__set < 0) {
      SUB_ID_SPVM__ObjectList__set = env->get_sub_id(env, "SPVM::ObjectList", "set", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 436;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L38: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L39: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L40: // PUSH_ARG_OBJECT
  *(void**)&stack[2] = object_vars[0];
L41: // CALL_SUB_VOID
  // SPVM::ObjectList->set
  {
    if (SUB_ID_SPVM__ObjectList__set < 0) {
      SUB_ID_SPVM__ObjectList__set = env->get_sub_id(env, "SPVM::ObjectList", "set", "void(self,int,object)");
      if (SUB_ID_SPVM__ObjectList__set < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList set");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__set;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 437;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L44: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L45: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L46: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L47: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L48: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L49: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L50: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L51: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 438;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L52: // BOOL_INT
  int_vars[0] = int_vars[5];
L53: // IF_NE_ZERO
  if (int_vars[0]) { goto L57; }
L54: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L55: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L56: // GOTO
  goto L57;
L57: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L58: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L59: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[1], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 441;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L62: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[1];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[0]
        );
      }
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 442;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L64: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L65: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[1];
L66: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 443;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L68: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L69: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L70: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[2] = *(int32_t*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_set";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 443;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L83;
  }
L72: // BOOL_INT
  int_vars[0] = int_vars[2];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L78; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L75: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L76: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L83;
L77: // GOTO
  goto L78;
L78: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L79: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L80: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L83;
L81: // INIT_INT
  int_vars[6] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L83;
L83: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L84: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_shift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[5] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L6: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L7: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L8: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L9: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L10: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L11: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L12: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L13: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L14: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // ARRAY_STORE_UNDEF
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(object_vars[0] == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(int_vars[4] < 0 || int_vars[4]  >= *(int32_t*)((intptr_t)object_vars[0] + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else {
        void* object_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          object_address,
          NULL        );
      }
    }
  }
L18: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L19: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L21: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[5];
L22: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L25: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L26: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L28: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L29: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 381;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L33: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L34: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L35: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L36: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L37: // CALL_SUB_OBJECT
  // SPVM::ObjectList->shift
  {
    if (SUB_ID_SPVM__ObjectList__shift < 0) {
      SUB_ID_SPVM__ObjectList__shift = env->get_sub_id(env, "SPVM::ObjectList", "shift", "object(self)");
      if (SUB_ID_SPVM__ObjectList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L38: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L39: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L40: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L41: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L42: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[2] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L43: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 382;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L44: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L45: // EQ_INT
  int_vars[0] = (int_vars[2] == int_vars[3]);
L46: // BOOL_INT
  int_vars[0] = int_vars[0];
L47: // IF_NE_ZERO
  if (int_vars[0]) { goto L53; }
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L50: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L51: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L52: // GOTO
  goto L53;
L53: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L55: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L56: // CALL_SUB_OBJECT
  // SPVM::ObjectList->shift
  {
    if (SUB_ID_SPVM__ObjectList__shift < 0) {
      SUB_ID_SPVM__ObjectList__shift = env->get_sub_id(env, "SPVM::ObjectList", "shift", "object(self)");
      if (SUB_ID_SPVM__ObjectList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 385;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L58: // IS_UNDEF
  int_vars[0] = object_vars[0] == NULL;
L59: // BOOL_INT
  int_vars[0] = int_vars[0];
L60: // IF_NE_ZERO
  if (int_vars[0]) { goto L65; }
L61: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L62: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L63: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L64: // GOTO
  goto L65;
L65: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L66: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L67: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L68: // CALL_SUB_OBJECT
  // SPVM::ObjectList->shift
  {
    if (SUB_ID_SPVM__ObjectList__shift < 0) {
      SUB_ID_SPVM__ObjectList__shift = env->get_sub_id(env, "SPVM::ObjectList", "shift", "object(self)");
      if (SUB_ID_SPVM__ObjectList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L71: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[0];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object_vars[0]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L73: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[1];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[4] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 388;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L75: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L76: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_NE_ZERO
  if (int_vars[0]) { goto L84; }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L82: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L83: // GOTO
  goto L84;
L84: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L85: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L86: // MOVE_CONSTANT_INT
  int_vars[5] = -3;
L87: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L88: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L89: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L90: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L91: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L92: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 391;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L94: // BOOL_INT
  int_vars[0] = int_vars[7];
L95: // IF_NE_ZERO
  if (int_vars[0]) { goto L99; }
L96: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L98: // GOTO
  goto L99;
L99: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L100: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L101: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L102: // CALL_SUB_OBJECT
  // SPVM::ObjectList->shift
  {
    if (SUB_ID_SPVM__ObjectList__shift < 0) {
      SUB_ID_SPVM__ObjectList__shift = env->get_sub_id(env, "SPVM::ObjectList", "shift", "object(self)");
      if (SUB_ID_SPVM__ObjectList__shift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList shift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__shift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L103: // IF_EXCEPTION_CATCH
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 395;
    exception_flag = 0;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L105;
  }
L104: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L105: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L106: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L107: // GET_EXCEPTION_VAR
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], env->get_exception(env));
L108: // BOOL_OBJECT
  int_vars[0] = !!object_vars[0];
L109: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L110: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L113: // GOTO
  goto L114;
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // SET_EXCEPTION_UNDEF
  env->set_exception(env, NULL);
L116: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L117: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L118: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L119: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L120: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L121: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L122: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L124: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L125: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L126: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_shift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 402;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L140;
  }
L128: // BOOL_INT
  int_vars[0] = int_vars[3];
L129: // IF_NE_ZERO
  if (int_vars[0]) { goto L135; }
L130: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L131: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L132: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L133: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L140;
L134: // GOTO
  goto L135;
L135: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 5;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L137: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L140;
L138: // INIT_INT
  int_vars[6] = 0;
L139: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L140;
L140: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L141: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[13] = {0};
  int32_t int_vars[11];
  int32_t exception_flag = 0;
  int32_t mortal_stack[66];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 462;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 463;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L14: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 464;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L18: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L19: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 465;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L23: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L24: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 466;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L27: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L28: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L29: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L30: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 467;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L31: // MOVE_CONSTANT_INT
  int_vars[2] = 11;
L32: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L33: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L34: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L35: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 468;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L36: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L38: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[5]);
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L44: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L47: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 469;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 9;
  mortal_stack_top++;
L50: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[9], object_vars[7]);
L51: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L52: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L53: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L54: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L55: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L57: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L58: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L59: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L60: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L61: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L64: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L66: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L67: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L68: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L69: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L70: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L72: // MOVE_CONSTANT_INT
  int_vars[7] = 4;
L73: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L74: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L75: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L76: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L77: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 472;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L79: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L80: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L81: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L83: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L85: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L86: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L87: // PUSH_ARG_UNDEF
  *(void**)&stack[3] = NULL;
L88: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L89: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 473;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L90: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L91: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L92: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L94: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L95: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[1]);
L96: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L97: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L98: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L99: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L100: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L101: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L105: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 474;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L107: // BOOL_INT
  int_vars[0] = int_vars[5];
L108: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L109: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L110: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L113: // GOTO
  goto L114;
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L116: // MOVE_CONSTANT_INT
  int_vars[5] = -5;
L117: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L118: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L119: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L120: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L121: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L122: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L123: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 477;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L124: // BOOL_INT
  int_vars[0] = int_vars[7];
L125: // IF_NE_ZERO
  if (int_vars[0]) { goto L129; }
L126: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L127: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L128: // GOTO
  goto L129;
L129: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L130: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L131: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L132: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L133: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L134: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[0]);
L135: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L136: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L137: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L139: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L140: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L141: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L142: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L143: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L144: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L145: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L146: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L147: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], stack[0].oval);
    }
  }
L148: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L149: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L150: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[12];
L151: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L152: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 480;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L153: // BOOL_INT
  int_vars[0] = int_vars[8];
L154: // IF_NE_ZERO
  if (int_vars[0]) { goto L161; }
L155: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], NULL);
L156: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L157: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L158: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L159: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L160: // GOTO
  goto L161;
L161: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L162: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L163: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L164: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L165: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L166: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L167: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L168: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L169: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L170: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L171: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L172: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L173: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L174: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L175: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L176: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L177: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L178: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L179: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L180: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L181: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L182: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L183: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L184: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L185: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L186: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L187: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L188: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 486;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L189: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L190: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L191: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L192: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L193: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L194: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L195: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L196: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L197: // PUSH_ARG_UNDEF
  *(void**)&stack[3] = NULL;
L198: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L199: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 487;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L200: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L201: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L202: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L203: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L204: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L205: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[2]);
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L207: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L208: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L209: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L210: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L211: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L212: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L213: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L214: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L215: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L216: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 488;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L217: // BOOL_INT
  int_vars[0] = int_vars[5];
L218: // IF_NE_ZERO
  if (int_vars[0]) { goto L224; }
L219: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L220: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L221: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L222: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L223: // GOTO
  goto L224;
L224: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L225: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L226: // MOVE_CONSTANT_INT
  int_vars[5] = -5;
L227: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L228: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L229: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L230: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L231: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L232: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L233: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 491;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L234: // BOOL_INT
  int_vars[0] = int_vars[7];
L235: // IF_NE_ZERO
  if (int_vars[0]) { goto L239; }
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L237: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L238: // GOTO
  goto L239;
L239: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L240: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L241: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L242: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L243: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L244: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[0]);
L245: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L246: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L247: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L248: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L249: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L250: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L251: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L252: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L253: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L254: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L255: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L256: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L257: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], stack[0].oval);
    }
  }
L258: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L259: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L260: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[12];
L261: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L262: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 494;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L263: // BOOL_INT
  int_vars[0] = int_vars[8];
L264: // IF_NE_ZERO
  if (int_vars[0]) { goto L271; }
L265: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], NULL);
L266: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L267: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L268: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L269: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L270: // GOTO
  goto L271;
L271: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L272: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L273: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L274: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L275: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L276: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L277: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L278: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L279: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L280: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L281: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L282: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L283: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L284: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L285: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L286: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L287: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L288: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L289: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 500;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L290: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L291: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L292: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L293: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L294: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L295: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L296: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L297: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L298: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[9];
L299: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L300: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 501;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L301: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L302: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L303: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L304: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L305: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L306: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[0]);
L307: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L308: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L309: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L310: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L311: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L312: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L313: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L314: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 502;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L315: // BOOL_INT
  int_vars[0] = int_vars[4];
L316: // IF_NE_ZERO
  if (int_vars[0]) { goto L322; }
L317: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L318: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L319: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L320: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L321: // GOTO
  goto L322;
L322: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L323: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L324: // MOVE_CONSTANT_INT
  int_vars[5] = -3;
L325: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L326: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L327: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L328: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L329: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L330: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L331: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 505;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L332: // BOOL_INT
  int_vars[0] = int_vars[7];
L333: // IF_NE_ZERO
  if (int_vars[0]) { goto L337; }
L334: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L335: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L336: // GOTO
  goto L337;
L337: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L338: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L339: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L340: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L341: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L342: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[5]);
L343: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L344: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L345: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L346: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L347: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L348: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L349: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L350: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L351: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L352: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L353: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L354: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L355: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], stack[0].oval);
    }
  }
L356: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L357: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L358: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[12];
L359: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L360: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 508;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L361: // BOOL_INT
  int_vars[0] = int_vars[8];
L362: // IF_NE_ZERO
  if (int_vars[0]) { goto L369; }
L363: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], NULL);
L364: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L365: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L366: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L367: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L368: // GOTO
  goto L369;
L369: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L370: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L371: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L372: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L373: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L374: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L375: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L376: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L377: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L378: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L379: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L380: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L381: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L382: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L383: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L384: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L385: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L386: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L387: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 514;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L388: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L389: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L390: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L391: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L392: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L393: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L394: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L395: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L396: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[9];
L397: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L398: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 515;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L399: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L400: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L401: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L402: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L403: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L404: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[1]);
L405: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L406: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L407: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L408: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L409: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L410: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L411: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L412: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 516;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L413: // BOOL_INT
  int_vars[0] = int_vars[4];
L414: // IF_NE_ZERO
  if (int_vars[0]) { goto L420; }
L415: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L416: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L417: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L418: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L419: // GOTO
  goto L420;
L420: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L421: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L422: // MOVE_CONSTANT_INT
  int_vars[5] = -3;
L423: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L424: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L425: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L426: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L427: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L428: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L429: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 519;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L430: // BOOL_INT
  int_vars[0] = int_vars[7];
L431: // IF_NE_ZERO
  if (int_vars[0]) { goto L435; }
L432: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L433: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L434: // GOTO
  goto L435;
L435: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L436: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L437: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L438: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L439: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L440: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[0]);
L441: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L442: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L443: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L444: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L445: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L446: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L447: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L448: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L449: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L450: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L451: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L452: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L453: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], stack[0].oval);
    }
  }
L454: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L455: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L456: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[12];
L457: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L458: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 522;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L459: // BOOL_INT
  int_vars[0] = int_vars[8];
L460: // IF_NE_ZERO
  if (int_vars[0]) { goto L467; }
L461: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], NULL);
L462: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L463: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L464: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L465: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L466: // GOTO
  goto L467;
L467: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L468: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L469: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L470: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L471: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L472: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L473: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L474: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L475: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L476: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L477: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L478: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L479: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L480: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L481: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L482: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L483: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L484: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L485: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L486: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L487: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L488: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L489: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L490: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L491: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L492: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L493: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L494: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 528;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L495: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L496: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L497: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L498: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L499: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L500: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L501: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L502: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L503: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[9];
L504: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L505: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 529;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L506: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L507: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L508: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L509: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L510: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L511: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[1]);
L512: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L513: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L514: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L515: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L516: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L517: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L518: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L519: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L520: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L521: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L522: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L523: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L524: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L525: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 530;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L526: // BOOL_INT
  int_vars[0] = int_vars[6];
L527: // IF_NE_ZERO
  if (int_vars[0]) { goto L533; }
L528: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L529: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L530: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L531: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L532: // GOTO
  goto L533;
L533: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L534: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L535: // MOVE_CONSTANT_INT
  int_vars[5] = -5;
L536: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L537: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L538: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L539: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L540: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L541: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L542: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 533;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L543: // BOOL_INT
  int_vars[0] = int_vars[7];
L544: // IF_NE_ZERO
  if (int_vars[0]) { goto L548; }
L545: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L546: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L547: // GOTO
  goto L548;
L548: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L549: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L550: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L551: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L552: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L553: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L554: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L555: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L556: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L557: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L558: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L559: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L560: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L561: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L562: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L563: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L564: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L565: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 539;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L566: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L567: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L568: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L569: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L570: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L571: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L572: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L573: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L574: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[9];
L575: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L576: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 540;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L577: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L578: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L579: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L580: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L581: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L582: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L583: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L584: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 541;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L585: // BOOL_INT
  int_vars[0] = int_vars[3];
L586: // IF_NE_ZERO
  if (int_vars[0]) { goto L591; }
L587: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L588: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L589: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L590: // GOTO
  goto L591;
L591: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L592: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L593: // MOVE_CONSTANT_INT
  int_vars[5] = -4;
L594: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L595: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L596: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L597: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L598: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L599: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L600: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 544;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L601: // BOOL_INT
  int_vars[0] = int_vars[7];
L602: // IF_NE_ZERO
  if (int_vars[0]) { goto L606; }
L603: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L604: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L605: // GOTO
  goto L606;
L606: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L607: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L608: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L609: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L610: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 11;
  mortal_stack_top++;
L611: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], object_vars[0]);
L612: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L613: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L614: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[11]
        );
      }
    }
  }
L615: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L616: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L617: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L618: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L619: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L620: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L621: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L622: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L623: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[8];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L624: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L625: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 12;
  mortal_stack_top++;
L626: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[8];
L627: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], stack[0].oval);
    }
  }
L628: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L629: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L630: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[12];
L631: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[9] = *(int32_t*)&stack[0];
    }
  }
L632: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 547;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L633: // BOOL_INT
  int_vars[0] = int_vars[9];
L634: // IF_NE_ZERO
  if (int_vars[0]) { goto L641; }
L635: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[12], NULL);
L636: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[11], NULL);
L637: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L638: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L639: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L640: // GOTO
  goto L641;
L641: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L642: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L643: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L644: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L645: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[7], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L646: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L647: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L648: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], object_vars[0]);
L649: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L650: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L651: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[8]
        );
      }
    }
  }
L652: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L653: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L654: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[7];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L655: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L656: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 10;
  mortal_stack_top++;
L657: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L658: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[10], stack[0].oval);
    }
  }
L659: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 553;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L660: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L661: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L662: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L663: // MOVE_CONSTANT_INT
  int_vars[3] = 10;
L664: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L665: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L666: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L667: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L668: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[9];
L669: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L670: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 554;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L671: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L672: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L673: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[8], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L674: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L675: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L676: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L677: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L678: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 555;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L679: // BOOL_INT
  int_vars[0] = int_vars[3];
L680: // IF_NE_ZERO
  if (int_vars[0]) { goto L685; }
L681: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L682: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L683: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L684: // GOTO
  goto L685;
L685: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 14;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L686: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L687: // MOVE_CONSTANT_INT
  int_vars[5] = -4;
L688: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L689: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[10];
L690: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L691: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L692: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L693: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L694: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 558;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L705;
  }
L695: // BOOL_INT
  int_vars[0] = int_vars[7];
L696: // IF_NE_ZERO
  if (int_vars[0]) { goto L700; }
L697: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L698: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L705;
L699: // GOTO
  goto L700;
L700: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L701: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L702: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L705;
L703: // INIT_INT
  int_vars[6] = 0;
L704: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L705;
L705: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L706: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice_no_reallocation(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[51];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 566;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 567;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 10;
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L14: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 568;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L18: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L20: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L21: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[2]);
L22: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L23: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L24: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 569;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L27: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[3]);
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L30: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L31: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L32: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L35: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L37: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L38: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L41: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L43: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L45: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 572;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L47: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L48: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L51: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L52: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L53: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L54: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L55: // PUSH_ARG_UNDEF
  *(void**)&stack[3] = NULL;
L56: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 573;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L60: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L63: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[0]);
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L68: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L69: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L70: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 574;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L72: // BOOL_INT
  int_vars[0] = int_vars[4];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L78: // GOTO
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L81: // MOVE_CONSTANT_INT
  int_vars[5] = -2;
L82: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L84: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L85: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L86: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L87: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 577;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[7];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L95: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L96: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L99: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[1]);
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L102: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L104: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L105: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L106: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L107: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L108: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L109: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L110: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L111: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 580;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L112: // BOOL_INT
  int_vars[0] = int_vars[6];
L113: // IF_NE_ZERO
  if (int_vars[0]) { goto L120; }
L114: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L115: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L116: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L117: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L119: // GOTO
  goto L120;
L120: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L121: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L122: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L123: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L124: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L125: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L126: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L127: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L128: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L129: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L130: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L131: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L132: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L133: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L134: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L135: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L136: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L137: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L138: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 585;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L139: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L140: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L141: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L142: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L143: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L144: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L145: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L146: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L147: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[5];
L148: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L149: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 586;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L150: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L151: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L152: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L153: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L154: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L155: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[0]);
L156: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L157: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L158: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L159: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L160: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L161: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L162: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L163: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 587;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L164: // BOOL_INT
  int_vars[0] = int_vars[4];
L165: // IF_NE_ZERO
  if (int_vars[0]) { goto L171; }
L166: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L167: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L168: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L169: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L170: // GOTO
  goto L171;
L171: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L172: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L173: // MOVE_CONSTANT_INT
  int_vars[5] = -2;
L174: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L175: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L176: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L177: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L178: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L179: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L180: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 590;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L181: // BOOL_INT
  int_vars[0] = int_vars[7];
L182: // IF_NE_ZERO
  if (int_vars[0]) { goto L186; }
L183: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L184: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L185: // GOTO
  goto L186;
L186: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L187: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L188: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L189: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L190: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L191: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[2]);
L192: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L193: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L194: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L195: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L196: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L197: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L198: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L199: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L200: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L201: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L202: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L203: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L204: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L205: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L206: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 593;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L207: // BOOL_INT
  int_vars[0] = int_vars[7];
L208: // IF_NE_ZERO
  if (int_vars[0]) { goto L215; }
L209: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L210: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L211: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L212: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L213: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L214: // GOTO
  goto L215;
L215: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L216: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L217: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L218: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L219: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L220: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L221: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L222: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L223: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L224: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L225: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L226: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L227: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L228: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L229: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L230: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L231: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L232: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L233: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 599;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L234: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L235: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L236: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L237: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L238: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L239: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L240: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L241: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L242: // PUSH_ARG_UNDEF
  *(void**)&stack[3] = NULL;
L243: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L244: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 600;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L245: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L246: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L247: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L248: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L249: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L250: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[1]);
L251: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L252: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L253: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L254: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L255: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L256: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L257: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L258: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 601;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L259: // BOOL_INT
  int_vars[0] = int_vars[4];
L260: // IF_NE_ZERO
  if (int_vars[0]) { goto L266; }
L261: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L262: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L263: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L264: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L265: // GOTO
  goto L266;
L266: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L267: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L268: // MOVE_CONSTANT_INT
  int_vars[5] = -2;
L269: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L270: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L271: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L272: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L273: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L274: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L275: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 604;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L276: // BOOL_INT
  int_vars[0] = int_vars[7];
L277: // IF_NE_ZERO
  if (int_vars[0]) { goto L281; }
L278: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L279: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L280: // GOTO
  goto L281;
L281: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L282: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L283: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L284: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L285: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L286: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[0]);
L287: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L288: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L289: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L290: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L291: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L292: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L293: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L294: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L295: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L296: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L297: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L298: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 607;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L299: // BOOL_INT
  int_vars[0] = int_vars[6];
L300: // IF_NE_ZERO
  if (int_vars[0]) { goto L307; }
L301: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L302: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L303: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L304: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L305: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L306: // GOTO
  goto L307;
L307: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L308: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L309: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L310: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L311: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L312: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L313: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L314: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L315: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L316: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L317: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L318: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L319: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L320: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L321: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L322: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L323: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L324: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L325: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 612;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L326: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L327: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L328: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L329: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L330: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L331: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L332: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L333: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L334: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[5];
L335: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L336: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 613;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L337: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L338: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L339: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L340: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L341: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L342: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[1]);
L343: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L344: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L345: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L346: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L347: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L348: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L349: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L350: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 614;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L351: // BOOL_INT
  int_vars[0] = int_vars[4];
L352: // IF_NE_ZERO
  if (int_vars[0]) { goto L358; }
L353: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L354: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L355: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L356: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L357: // GOTO
  goto L358;
L358: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L359: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L360: // MOVE_CONSTANT_INT
  int_vars[5] = -2;
L361: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L362: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L363: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L364: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L365: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L366: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L367: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 617;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L368: // BOOL_INT
  int_vars[0] = int_vars[7];
L369: // IF_NE_ZERO
  if (int_vars[0]) { goto L373; }
L370: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L371: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L372: // GOTO
  goto L373;
L373: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L374: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L375: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L376: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L377: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L378: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[0]);
L379: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L380: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L381: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L382: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L383: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L384: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L385: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L386: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L387: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L388: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L389: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L390: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L391: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L392: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L393: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 620;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L394: // BOOL_INT
  int_vars[0] = int_vars[7];
L395: // IF_NE_ZERO
  if (int_vars[0]) { goto L402; }
L396: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L397: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L398: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L399: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L400: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L401: // GOTO
  goto L402;
L402: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L403: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L404: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L405: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L406: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[3], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L407: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L408: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L409: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object_vars[0]);
L410: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L411: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L412: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L413: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L414: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L415: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[3];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L416: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L417: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L418: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L419: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L420: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 625;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L421: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L422: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L423: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L424: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L425: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L426: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L427: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L428: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L429: // PUSH_ARG_UNDEF
  *(void**)&stack[3] = NULL;
L430: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L431: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 626;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L432: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L433: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L434: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L435: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 627;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L436: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L437: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L438: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[3] = *(int32_t*)&stack[0];
    }
  }
L439: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 627;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L440: // BOOL_INT
  int_vars[0] = int_vars[3];
L441: // IF_NE_ZERO
  if (int_vars[0]) { goto L446; }
L442: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L443: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L444: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L445: // GOTO
  goto L446;
L446: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L447: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L448: // MOVE_CONSTANT_INT
  int_vars[5] = -2;
L449: // MOVE_CONSTANT_INT
  int_vars[6] = 2;
L450: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L451: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L452: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L453: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L454: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L455: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 630;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L456: // BOOL_INT
  int_vars[0] = int_vars[7];
L457: // IF_NE_ZERO
  if (int_vars[0]) { goto L461; }
L458: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L459: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L460: // GOTO
  goto L461;
L461: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L462: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L463: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L464: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L465: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L466: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[0]);
L467: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L468: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L469: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L470: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L471: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L472: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L473: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L474: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L475: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L476: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L477: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L478: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L479: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L480: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L481: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_no_reallocation";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 633;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L495;
  }
L482: // BOOL_INT
  int_vars[0] = int_vars[7];
L483: // IF_NE_ZERO
  if (int_vars[0]) { goto L490; }
L484: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L485: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L486: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L487: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L488: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L495;
L489: // GOTO
  goto L490;
L490: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L491: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L492: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L495;
L493: // INIT_INT
  int_vars[6] = 0;
L494: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L495;
L495: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L496: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice_offset_is_valid_when_appended(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[10];
  int32_t exception_flag = 0;
  int32_t mortal_stack[14];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 659;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 660;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L14: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 661;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L17: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L18: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L19: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L20: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 662;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L22: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L23: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L24: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L25: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 663;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L26: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L28: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 664;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L30: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L31: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L32: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 665;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L34: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L35: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L36: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L38: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L40: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L41: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[3]);
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L44: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L47: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L48: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L49: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L50: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L51: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L52: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L53: // PUSH_ARG_OBJECT
  *(void**)&stack[3] = object_vars[5];
L54: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], stack[0].oval);
    }
  }
L55: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 666;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L57: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L58: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L59: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L60: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L61: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L62: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L63: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[1]);
L64: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L65: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L66: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L68: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[7];
L69: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L70: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L71: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 667;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L72: // BOOL_INT
  int_vars[0] = int_vars[4];
L73: // IF_NE_ZERO
  if (int_vars[0]) { goto L79; }
L74: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L75: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L76: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L77: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L78: // GOTO
  goto L79;
L79: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L80: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L81: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L82: // MOVE_CONSTANT_INT
  int_vars[6] = 3;
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L84: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L85: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L86: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L87: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 670;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L89: // BOOL_INT
  int_vars[0] = int_vars[7];
L90: // IF_NE_ZERO
  if (int_vars[0]) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L95: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L96: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[5], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L97: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L98: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L99: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], object_vars[3]);
L100: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L101: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L102: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[6]
        );
      }
    }
  }
L103: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L104: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L105: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L108: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[5];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L109: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L110: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L111: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L112: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L113: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L114: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L115: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L116: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[8] = *(int32_t*)&stack[0];
    }
  }
L117: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_appended";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 673;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L131;
  }
L118: // BOOL_INT
  int_vars[0] = int_vars[8];
L119: // IF_NE_ZERO
  if (int_vars[0]) { goto L126; }
L120: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L121: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L122: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L123: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L124: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L131;
L125: // GOTO
  goto L126;
L126: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 8;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L127: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L128: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L131;
L129: // INIT_INT
  int_vars[6] = 0;
L130: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L131;
L131: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L132: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_splice_offset_is_valid_when_removed(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[7] = {0};
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 640;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 641;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L12: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L13: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L14: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L15: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 642;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L16: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L17: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L18: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L19: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 643;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L20: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L21: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L22: // CALL_SUB_VOID
  // SPVM::ObjectList->push
  {
    if (SUB_ID_SPVM__ObjectList__push < 0) {
      SUB_ID_SPVM__ObjectList__push = env->get_sub_id(env, "SPVM::ObjectList", "push", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__push < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList push");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__push;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 644;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L25: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L26: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L27: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L28: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L29: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L30: // PUSH_ARG_UNDEF
  *(void**)&stack[3] = NULL;
L31: // CALL_SUB_OBJECT
  // SPVM::ObjectList->splice
  {
    if (SUB_ID_SPVM__ObjectList__splice < 0) {
      SUB_ID_SPVM__ObjectList__splice = env->get_sub_id(env, "SPVM::ObjectList", "splice", "object[](self,int,int,object[])");
      if (SUB_ID_SPVM__ObjectList__splice < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList splice");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__splice;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L32: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 645;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L33: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L34: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L35: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[2];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L37: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L38: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[1]);
L39: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L40: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L41: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[3];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L42: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L43: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[3];
L44: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L45: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_array
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_array", "int(object[],object[])");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_array;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_array(env, stack);
    if (!exception_flag) {
      int_vars[4] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 646;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[4];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L54; }
L49: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L50: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L51: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L52: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L100;
L53: // GOTO
  goto L54;
L54: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L56: // MOVE_CONSTANT_INT
  int_vars[5] = -1;
L57: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L59: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[4];
L60: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[5];
L61: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[6];
L62: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[7] = *(int32_t*)&stack[0];
    }
  }
L63: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 649;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L64: // BOOL_INT
  int_vars[0] = int_vars[7];
L65: // IF_NE_ZERO
  if (int_vars[0]) { goto L69; }
L66: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L67: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L100;
L68: // GOTO
  goto L69;
L69: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L70: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L71: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[4], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L72: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L73: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L74: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], object_vars[2]);
L75: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L76: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L77: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[4];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[5]
        );
      }
    }
  }
L78: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L79: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[4];
L81: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], stack[0].oval);
    }
  }
L82: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L83: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L84: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[6];
L85: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[6] = *(int32_t*)&stack[0];
    }
  }
L86: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_splice_offset_is_valid_when_removed";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 652;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L100;
  }
L87: // BOOL_INT
  int_vars[0] = int_vars[6];
L88: // IF_NE_ZERO
  if (int_vars[0]) { goto L95; }
L89: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L90: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], NULL);
L91: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L92: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L93: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L100;
L94: // GOTO
  goto L95;
L95: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 4;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L96: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L100;
L98: // INIT_INT
  int_vars[6] = 0;
L99: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L100;
L100: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L101: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_to_array(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[6] = {0};
  double double_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[15];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 3;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[1];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[0], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L5: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L6: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L8: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L13: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L14: // CONVERT_INT_TO_INT_OBJECT
  {
    int32_t value = int_vars[3];
    int32_t basic_type_id = (intptr_t)(void*)env->int_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(int32_t*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], object);
  }
L15: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L16: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L18: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 3.1400000000000001;
L19: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L20: // CONVERT_DOUBLE_TO_DOUBLE_OBJECT
  {
    double value = double_vars[0];
    int32_t basic_type_id = (intptr_t)(void*)env->double_object_basic_type_id;
    void* object = env->new_object_raw(env, basic_type_id);
    SPVM_VALUE* fields = (SPVM_VALUE*)((intptr_t)object + object_header_byte_size);
    *(double*)&fields[0] = value;
    SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], object);
  }
L21: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L22: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L24: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L25: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L26: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L27: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 680;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L28: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], NULL);
L29: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L30: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L31: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L32: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], NULL);
L33: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[5];
L35: // CALL_SUB_OBJECT
  // SPVM::ObjectList->to_array
  {
    if (SUB_ID_SPVM__ObjectList__to_array < 0) {
      SUB_ID_SPVM__ObjectList__to_array = env->get_sub_id(env, "SPVM::ObjectList", "to_array", "object[](self)");
      if (SUB_ID_SPVM__ObjectList__to_array < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList to_array");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__to_array;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L36: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 681;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L37: // IS_TYPE
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_object;
    int32_t check_type_dimension = 1;
    void* object = object_vars[0];
    if (object) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
int_vars[0]      = env->is_type(env, object, check_basic_type_id, check_type_dimension);
    }
    else {
int_vars[0]      = 0;
    }
  }
L38: // BOOL_INT
  int_vars[0] = int_vars[0];
L39: // IF_NE_ZERO
  if (int_vars[0]) { goto L43; }
L40: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L41: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L44: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L45: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[4];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L47: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L48: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_byte < 0) {
      BASIC_TYPE_ID_byte = env->get_basic_type_id(env, "byte");
      if (BASIC_TYPE_ID_byte < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found byte");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_byte;
    int32_t check_type_dimension = 1;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L49: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L50: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L51: // NEW_STRING
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], env->new_string_len_raw(env, "\x61\x62\x63", 3));
L52: // STRING_EQ
  {
    void* object1 = object_vars[2];
    void* object2 = object_vars[3];
    if (__builtin_expect(object1 == NULL || object2 == NULL, 0)) {
int_vars[0] = 0;
      env->set_exception(env, env->new_string_raw(env, "Use of uninitialized value in string comparison operator")); 
      exception_flag = 1;
    }
    else {
      int32_t length1 = *(int32_t*)((intptr_t)object1 + (intptr_t)env->object_length_offset);
      int32_t lenght2 = *(int32_t*)((intptr_t)object2 + (intptr_t)env->object_length_offset);
      int8_t* bytes1 = env->get_elems_byte(env, object1);
      int8_t* bytes2 = env->get_elems_byte(env, object2);
      int32_t short_string_length = length1 < lenght2 ? length1 : lenght2;
      int32_t retval = memcmp(bytes1, bytes2, short_string_length);
      int32_t cmp;
      if (retval) {
        cmp = retval < 0 ? -1 : 1;
      } else if (length1 == lenght2) {
        cmp = 0;
      } else {
        cmp = length1 < lenght2 ? -1 : 1;
      }
  int_vars[0] = (cmp == 0);
    }
  }
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 687;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L54: // BOOL_INT
  int_vars[0] = int_vars[0];
L55: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L80; }
L56: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], NULL);
L57: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L58: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L59: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L60: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L61: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L62: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L63: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L64: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Int < 0) {
      BASIC_TYPE_ID_SPVM__Int = env->get_basic_type_id(env, "SPVM::Int");
      if (BASIC_TYPE_ID_SPVM__Int < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Int");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Int;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L65: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L66: // GET_FIELD_INT
  {
    if (__builtin_expect(FIELD_ID_SPVM__Int__val < 0, 0)) {
      FIELD_ID_SPVM__Int__val = env->get_field_id(env, "SPVM::Int", "val", "int");
      if (FIELD_ID_SPVM__Int__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Int val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Int__val = env->get_field_offset(env, FIELD_ID_SPVM__Int__val);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      int_vars[3] = *(int32_t*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Int__val);
    }
  }
L67: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 688;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L68: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L69: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[4]);
L70: // BOOL_INT
  int_vars[0] = int_vars[0];
L71: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L77; }
L72: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L73: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L74: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L75: // BOOL_INT
  int_vars[0] = int_vars[2];
L76: // GOTO
  goto L79;
L77: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L78: // BOOL_INT
  int_vars[0] = int_vars[3];
L79: // GOTO
  goto L83;
L80: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L81: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L82: // BOOL_INT
  int_vars[0] = int_vars[4];
L83: // BOOL_INT
  int_vars[0] = int_vars[0];
L84: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L106; }
L85: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L86: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L87: // ARRAY_FETCH_OBJECT
  {
    void* array = object_vars[0];
    int32_t index = int_vars[2];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
        env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
        exception_flag = 1;
      } 
      else { 
        void* object = ((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], object); 
      } 
    } 
  } 
L88: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L89: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L90: // CHECK_OBJECT_TYPE
  {
    if (BASIC_TYPE_ID_SPVM__Double < 0) {
      BASIC_TYPE_ID_SPVM__Double = env->get_basic_type_id(env, "SPVM::Double");
      if (BASIC_TYPE_ID_SPVM__Double < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found SPVM::Double");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t check_basic_type_id = BASIC_TYPE_ID_SPVM__Double;
    int32_t check_type_dimension = 0;
    void* object = object_vars[1];
    if (object != NULL) {
      int32_t object_basic_type_id = *(int32_t*)((intptr_t)object + (intptr_t)env->object_basic_type_id_offset);
      int32_t object_type_dimension_id = *(uint8_t*)((intptr_t)object + (intptr_t)env->object_type_dimension_offset);
      if (object_basic_type_id == check_basic_type_id && object_type_dimension_id == check_type_dimension) {
        SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], object_vars[1]);
      }
      else {
        void* exception = env->new_string_raw(env, "Can't cast uncompatible type.");
        env->set_exception(env, exception);
        exception_flag = 1;
      }
    }
  }
L91: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L92: // GET_FIELD_DOUBLE
  {
    if (__builtin_expect(FIELD_ID_SPVM__Double__val < 0, 0)) {
      FIELD_ID_SPVM__Double__val = env->get_field_id(env, "SPVM::Double", "val", "double");
      if (FIELD_ID_SPVM__Double__val < 0) {
        void* exception = env->new_string_raw(env, "Field not found SPVM::Double val");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
      FIELD_BYTE_OFFSET_SPVM__Double__val = env->get_field_offset(env, FIELD_ID_SPVM__Double__val);
    };
    void* object = object_vars[2];
    if (__builtin_expect(object == NULL, 0)) {
      env->set_exception(env, env->new_string_raw(env, "Object must be not undef."));
      exception_flag = 1;
    }
    else {
      double_vars[0] = *(double*)((intptr_t)object + object_header_byte_size + FIELD_BYTE_OFFSET_SPVM__Double__val);
    }
  }
L93: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_to_array";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 689;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L119;
  }
L94: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 3.1400000000000001;
L95: // EQ_DOUBLE
  int_vars[0] = (double_vars[0] == double_vars[1]);
L96: // BOOL_INT
  int_vars[0] = int_vars[0];
L97: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L98: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], NULL);
L99: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], NULL);
L100: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L101: // BOOL_INT
  int_vars[0] = int_vars[2];
L102: // GOTO
  goto L105;
L103: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L104: // BOOL_INT
  int_vars[0] = int_vars[3];
L105: // GOTO
  goto L109;
L106: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 10;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L108: // BOOL_INT
  int_vars[0] = int_vars[4];
L109: // BOOL_INT
  int_vars[0] = int_vars[0];
L110: // IF_NE_ZERO
  if (int_vars[0]) { goto L114; }
L111: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L112: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L119;
L113: // GOTO
  goto L114;
L114: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 7;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L115: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L116: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L119;
L117: // INIT_INT
  int_vars[6] = 0;
L118: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L119;
L119: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L120: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__test_unshift(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  void* object_vars[9] = {0};
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[10];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L2: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 0;
  mortal_stack_top++;
L3: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[1];
L4: // CALL_SUB_OBJECT
  // SPVM::ObjectList->new_capacity
  {
    if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
      SUB_ID_SPVM__ObjectList__new_capacity = env->get_sub_id(env, "SPVM::ObjectList", "new_capacity", "SPVM::ObjectList(int)");
      if (SUB_ID_SPVM__ObjectList__new_capacity < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList new_capacity");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__new_capacity;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[0], stack[0].oval);
    }
  }
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 341;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L7: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 1;
  mortal_stack_top++;
L8: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[2];
L9: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[1], stack[0].oval);
    }
  }
L10: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 343;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L11: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L12: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[1];
L13: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L14: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 344;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L15: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L16: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L17: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L18: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L19: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L20: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L21: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L22: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 345;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L24: // BOOL_INT
  int_vars[0] = int_vars[5];
L25: // IF_NE_ZERO
  if (int_vars[0]) { goto L29; }
L26: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L28: // GOTO
  goto L29;
L29: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L30: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 2;
  mortal_stack_top++;
L31: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L32: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[2], stack[0].oval);
    }
  }
L33: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 349;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L34: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L35: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[2];
L36: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 350;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L39: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L40: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L41: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L42: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L43: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L44: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L45: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L46: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 351;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L47: // BOOL_INT
  int_vars[0] = int_vars[5];
L48: // IF_NE_ZERO
  if (int_vars[0]) { goto L52; }
L49: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L50: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L51: // GOTO
  goto L52;
L52: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L53: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 3;
  mortal_stack_top++;
L54: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L55: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[3], stack[0].oval);
    }
  }
L56: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 355;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L57: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L58: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[3];
L59: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L60: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 356;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L61: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L62: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L63: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L64: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L65: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L66: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L67: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L68: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L69: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 357;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L70: // BOOL_INT
  int_vars[0] = int_vars[5];
L71: // IF_NE_ZERO
  if (int_vars[0]) { goto L75; }
L72: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L73: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L74: // GOTO
  goto L75;
L75: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L76: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 4;
  mortal_stack_top++;
L77: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L78: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[4], stack[0].oval);
    }
  }
L79: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 361;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L80: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L81: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[4];
L82: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L83: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 362;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L84: // MOVE_CONSTANT_INT
  int_vars[2] = 4;
L85: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L86: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L87: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L88: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L89: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L90: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L91: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L92: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 363;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L93: // BOOL_INT
  int_vars[0] = int_vars[5];
L94: // IF_NE_ZERO
  if (int_vars[0]) { goto L98; }
L95: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L96: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L97: // GOTO
  goto L98;
L98: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L99: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 5;
  mortal_stack_top++;
L100: // PUSH_ARG_INT
  *(int32_t*)&stack[0] = int_vars[4];
L101: // CALL_SUB_OBJECT
  // SPVM::Int->new
  {
    if (SUB_ID_SPVM__Int__new < 0) {
      SUB_ID_SPVM__Int__new = env->get_sub_id(env, "SPVM::Int", "new", "SPVM::Int(int)");
      if (SUB_ID_SPVM__Int__new < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::Int new");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__Int__new;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[5], stack[0].oval);
    }
  }
L102: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 367;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L103: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L104: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[5];
L105: // CALL_SUB_VOID
  // SPVM::ObjectList->unshift
  {
    if (SUB_ID_SPVM__ObjectList__unshift < 0) {
      SUB_ID_SPVM__ObjectList__unshift = env->get_sub_id(env, "SPVM::ObjectList", "unshift", "void(self,object)");
      if (SUB_ID_SPVM__ObjectList__unshift < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList unshift");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__unshift;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
    }
  }
L106: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 368;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L107: // MOVE_CONSTANT_INT
  int_vars[2] = 8;
L108: // MOVE_CONSTANT_INT
  int_vars[3] = -1;
L109: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L110: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L111: // PUSH_ARG_INT
  *(int32_t*)&stack[1] = int_vars[2];
L112: // PUSH_ARG_INT
  *(int32_t*)&stack[2] = int_vars[3];
L113: // PUSH_ARG_INT
  *(int32_t*)&stack[3] = int_vars[4];
L114: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->check_fields
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "check_fields", "int(SPVM::ObjectList,int,int,int)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList check_fields");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__check_fields;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__check_fields(env, stack);
    if (!exception_flag) {
      int_vars[5] = *(int32_t*)&stack[0];
    }
  }
L115: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 369;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L116: // BOOL_INT
  int_vars[0] = int_vars[5];
L117: // IF_NE_ZERO
  if (int_vars[0]) { goto L121; }
L118: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L119: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L120: // GOTO
  goto L121;
L121: // MOVE_CONSTANT_INT
  int_vars[4] = 5;
L122: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 6;
  mortal_stack_top++;
L123: // NEW_OBJECT_ARRAY
  {
    if (BASIC_TYPE_ID_object < 0) {
      BASIC_TYPE_ID_object = env->get_basic_type_id(env, "object");
      if (BASIC_TYPE_ID_object < 0) {
        void* exception = env->new_string_raw(env, "Basic type not found object");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t basic_type_id = BASIC_TYPE_ID_object;
    int32_t length = *(int32_t*)&int_vars[4];
    if (length >= 0) {
      void* object = env->new_object_array_raw(env, basic_type_id, length);
      SPVM_RUNTIME_API_OBJECT_ASSIGN((void**)&object_vars[6], object);
    }
    else {
      void* exception = env->new_string_raw(env, "Array length must be more than or equal to 0");
      env->set_exception(env, exception);
      exception_flag = 1;
    }
  }
L124: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L125: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 7;
  mortal_stack_top++;
L126: // MOVE_OBJECT
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], object_vars[5]);
L127: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L128: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L129: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[5];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[7]
        );
      }
    }
  }
L130: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L131: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L132: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[6];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[4]
        );
      }
    }
  }
L133: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L134: // MOVE_CONSTANT_INT
  int_vars[7] = 2;
L135: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[7];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[3]
        );
      }
    }
  }
L136: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L137: // MOVE_CONSTANT_INT
  int_vars[8] = 3;
L138: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[8];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[2]
        );
      }
    }
  }
L139: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L140: // MOVE_CONSTANT_INT
  int_vars[9] = 4;
L141: // ARRAY_STORE_OBJECT
  {
    void* array = object_vars[6];
    int32_t index = int_vars[9];
    if (__builtin_expect(array == NULL, 0)) { 
      env->set_exception(env, env->new_string_raw(env, "Array must not be undef")); 
      exception_flag = 1;
    } 
    else { 
      if (__builtin_expect(index < 0 || index >= *(int32_t*)((intptr_t)array + (intptr_t)env->object_length_offset), 0)) { 
          env->set_exception(env, env->new_string_raw(env, "Index is out of range")); 
          exception_flag = 1;
      } 
      else {
        void** element_address = &((void**)((intptr_t)array + object_header_byte_size))[index];
        SPVM_RUNTIME_API_OBJECT_ASSIGN(
          element_address,         object_vars[1]
        );
      }
    }
  }
L142: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L143: // PUSH_MORTAL
  mortal_stack[mortal_stack_top] = 8;
  mortal_stack_top++;
L144: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[6];
L145: // CALL_SUB_OBJECT
  // SPVM::ObjectList->newa
  {
    if (SUB_ID_SPVM__ObjectList__newa < 0) {
      SUB_ID_SPVM__ObjectList__newa = env->get_sub_id(env, "SPVM::ObjectList", "newa", "SPVM::ObjectList(object[])");
      if (SUB_ID_SPVM__ObjectList__newa < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found SPVM::ObjectList newa");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_SPVM__ObjectList__newa;
    exception_flag = env->call_sub(env, call_sub_id, stack);
    if (!exception_flag) {
      SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], stack[0].oval);
    }
  }
L146: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L147: // PUSH_ARG_OBJECT
  *(void**)&stack[0] = object_vars[0];
L148: // PUSH_ARG_OBJECT
  *(void**)&stack[1] = object_vars[8];
L149: // CALL_SUB_INT
  // TestCase::Lib::SPVM::ObjectList->equals_list_deeply
  {
    if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
      SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply = env->get_sub_id(env, "TestCase::Lib::SPVM::ObjectList", "equals_list_deeply", "int(SPVM::ObjectList,SPVM::ObjectList)");
      if (SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply < 0) {
        void* exception = env->new_string_raw(env, "Subroutine not found TestCase::Lib::SPVM::ObjectList equals_list_deeply");
        env->set_exception(env, exception);
        return SPVM_EXCEPTION;
      }
    }
    int32_t call_sub_id = SUB_ID_TestCase__Lib__SPVM__ObjectList__equals_list_deeply;
    exception_flag = SPPRECOMPILE__TestCase__Lib__SPVM__ObjectList__equals_list_deeply(env, stack);
    if (!exception_flag) {
      int_vars[10] = *(int32_t*)&stack[0];
    }
  }
L150: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Lib::SPVM::ObjectList";
    const char* sub_name = "test_unshift";
    const char* file = "TestCase/Lib/SPVM/ObjectList.spvm";
    int32_t line = 373;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L164;
  }
L151: // BOOL_INT
  int_vars[0] = int_vars[10];
L152: // IF_NE_ZERO
  if (int_vars[0]) { goto L159; }
L153: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[8], NULL);
L154: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[7], NULL);
L155: // INIT_UNDEF
  SPVM_RUNTIME_API_OBJECT_ASSIGN(&object_vars[6], NULL);
L156: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L157: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L164;
L158: // GOTO
  goto L159;
L159: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 6;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L160: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L161: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L164;
L162: // INIT_INT
  int_vars[6] = 0;
L163: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L164;
L164: // LEAVE_SCOPE
  {
    int32_t original_mortal_stack_top = 0;
    {
      int32_t mortal_stack_index;
      for (mortal_stack_index = original_mortal_stack_top; mortal_stack_index < mortal_stack_top; mortal_stack_index++) {
        int32_t var_index = mortal_stack[mortal_stack_index];
        void** object_address = (void**)&object_vars[var_index];
        if (*object_address != NULL) {
          if (SPVM_RUNTIME_API_GET_REF_COUNT(*object_address) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*object_address); }
          else { env->dec_ref_count(env, *object_address); }
          *object_address = NULL;
        }
      }
    }
    mortal_stack_top = original_mortal_stack_top;
  }
L165: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


