#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_byte_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_double_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_double_double_big(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_float_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_int_byte(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_int_double(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_int_float(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_int_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_int_short(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_long_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_short_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__Divide__divide_short_short(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__Divide__divide(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[11];
  float float_vars[9];
  int32_t int_vars[15];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L3: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L4: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[3] / int_vars[4];
  } 
L5: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 194;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L6: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L7: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L8: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L9: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L10: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[7] = int_vars[4] / int_vars[6];
  } 
L11: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 195;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L12: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L13: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L15: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[0];
L16: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[8] = int_vars[3] / int_vars[6];
  } 
L17: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 196;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L18: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L20: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L22: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[9] = int_vars[4] / int_vars[6];
  } 
L23: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 197;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L24: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 4;
L26: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L27: // CONVERT_SHORT_TO_INT
  int_vars[6] = (int32_t)short_vars[0];
L28: // DIVIDE_INT
  if (__builtin_expect(int_vars[6] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[10] = int_vars[3] / int_vars[6];
  } 
L29: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 198;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L30: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L31: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L32: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L34: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L35: // CONVERT_BYTE_TO_INT
  int_vars[11] = (int32_t)byte_vars[1];
L36: // DIVIDE_INT
  if (__builtin_expect(int_vars[11] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[12] = int_vars[4] / int_vars[11];
  } 
L37: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 199;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L38: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L39: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[3];
L40: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[0];
L41: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L42: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L43: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[1];
L44: // DIVIDE_INT
  if (__builtin_expect(int_vars[11] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[13] = int_vars[4] / int_vars[11];
  } 
L45: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 200;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L46: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L47: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L48: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L49: // MOVE_CONSTANT_INT
  int_vars[6] = 4;
L50: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[6];
L51: // CONVERT_SHORT_TO_INT
  int_vars[11] = (int32_t)short_vars[0];
L52: // DIVIDE_INT
  if (__builtin_expect(int_vars[11] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[14] = int_vars[4] / int_vars[11];
  } 
L53: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 201;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L54: // MOVE_CONSTANT_INT
  int_vars[3] = 8;
L55: // MOVE_CONSTANT_INT
  int_vars[4] = 3;
L56: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[6] = int_vars[3] / int_vars[4];
  } 
L57: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 202;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L300;
  }
L58: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L59: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[3]);
L60: // BOOL_INT
  int_vars[0] = int_vars[0];
L61: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L104; }
L62: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L63: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[3]);
L64: // BOOL_INT
  int_vars[0] = int_vars[0];
L65: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L103; }
L66: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L67: // EQ_INT
  int_vars[0] = (int_vars[8] == int_vars[3]);
L68: // BOOL_INT
  int_vars[0] = int_vars[0];
L69: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L102; }
L70: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L71: // EQ_INT
  int_vars[0] = (int_vars[9] == int_vars[3]);
L72: // BOOL_INT
  int_vars[0] = int_vars[0];
L73: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L101; }
L74: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L75: // EQ_INT
  int_vars[0] = (int_vars[10] == int_vars[3]);
L76: // BOOL_INT
  int_vars[0] = int_vars[0];
L77: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L100; }
L78: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L79: // EQ_INT
  int_vars[0] = (int_vars[12] == int_vars[3]);
L80: // BOOL_INT
  int_vars[0] = int_vars[0];
L81: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L99; }
L82: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L83: // EQ_INT
  int_vars[0] = (int_vars[13] == int_vars[3]);
L84: // BOOL_INT
  int_vars[0] = int_vars[0];
L85: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L98; }
L86: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L87: // EQ_INT
  int_vars[0] = (int_vars[14] == int_vars[3]);
L88: // BOOL_INT
  int_vars[0] = int_vars[0];
L89: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L97; }
L90: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L91: // EQ_INT
  int_vars[0] = (int_vars[6] == int_vars[3]);
L92: // BOOL_INT
  int_vars[0] = int_vars[0];
L93: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L96; }
L94: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L95: // GOTO
  goto L96;
L96: // GOTO
  goto L97;
L97: // GOTO
  goto L98;
L98: // GOTO
  goto L99;
L99: // GOTO
  goto L100;
L100: // GOTO
  goto L101;
L101: // GOTO
  goto L102;
L102: // GOTO
  goto L103;
L103: // GOTO
  goto L104;
L104: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L105: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L106: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L107: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L108: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L109: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L110: // CONVERT_BYTE_TO_FLOAT
  float_vars[0] = (float)byte_vars[0];
L111: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L112: // DIVIDE_FLOAT
  float_vars[3] = float_vars[0] / float_vars[1];
L113: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L114: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L115: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[4];
L116: // CONVERT_BYTE_TO_FLOAT
  float_vars[1] = (float)byte_vars[0];
L117: // DIVIDE_FLOAT
  float_vars[4] = float_vars[0] / float_vars[1];
L118: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L119: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L120: // CONVERT_SHORT_TO_FLOAT
  float_vars[0] = (float)short_vars[0];
L121: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L122: // DIVIDE_FLOAT
  float_vars[5] = float_vars[0] / float_vars[1];
L123: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L124: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L125: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L126: // CONVERT_SHORT_TO_FLOAT
  float_vars[1] = (float)short_vars[0];
L127: // DIVIDE_FLOAT
  float_vars[6] = float_vars[0] / float_vars[1];
L128: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L129: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[4];
L130: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.0;
L131: // DIVIDE_FLOAT
  float_vars[7] = float_vars[0] / float_vars[1];
L132: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L133: // MOVE_CONSTANT_INT
  int_vars[4] = 2;
L134: // CONVERT_INT_TO_FLOAT
  float_vars[1] = (float)int_vars[4];
L135: // DIVIDE_FLOAT
  float_vars[8] = float_vars[0] / float_vars[1];
L136: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L137: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L138: // BOOL_INT
  int_vars[0] = int_vars[0];
L139: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L172; }
L140: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L141: // EQ_FLOAT
  int_vars[0] = (float_vars[3] == float_vars[0]);
L142: // BOOL_INT
  int_vars[0] = int_vars[0];
L143: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L171; }
L144: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L145: // EQ_FLOAT
  int_vars[0] = (float_vars[4] == float_vars[0]);
L146: // BOOL_INT
  int_vars[0] = int_vars[0];
L147: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L170; }
L148: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L149: // EQ_FLOAT
  int_vars[0] = (float_vars[5] == float_vars[0]);
L150: // BOOL_INT
  int_vars[0] = int_vars[0];
L151: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L169; }
L152: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L153: // EQ_FLOAT
  int_vars[0] = (float_vars[6] == float_vars[0]);
L154: // BOOL_INT
  int_vars[0] = int_vars[0];
L155: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L168; }
L156: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L157: // EQ_FLOAT
  int_vars[0] = (float_vars[7] == float_vars[0]);
L158: // BOOL_INT
  int_vars[0] = int_vars[0];
L159: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L167; }
L160: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L161: // EQ_FLOAT
  int_vars[0] = (float_vars[8] == float_vars[0]);
L162: // BOOL_INT
  int_vars[0] = int_vars[0];
L163: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L166; }
L164: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L165: // GOTO
  goto L166;
L166: // GOTO
  goto L167;
L167: // GOTO
  goto L168;
L168: // GOTO
  goto L169;
L169: // GOTO
  goto L170;
L170: // GOTO
  goto L171;
L171: // GOTO
  goto L172;
L172: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L173: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L174: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L175: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L176: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L177: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L178: // CONVERT_BYTE_TO_DOUBLE
  double_vars[0] = (double)byte_vars[0];
L179: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L180: // DIVIDE_DOUBLE
  double_vars[3] = double_vars[0] / double_vars[1];
L181: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L182: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L183: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[5];
L184: // CONVERT_BYTE_TO_DOUBLE
  double_vars[1] = (double)byte_vars[0];
L185: // DIVIDE_DOUBLE
  double_vars[4] = double_vars[0] / double_vars[1];
L186: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L187: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L188: // CONVERT_SHORT_TO_DOUBLE
  double_vars[0] = (double)short_vars[0];
L189: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L190: // DIVIDE_DOUBLE
  double_vars[5] = double_vars[0] / double_vars[1];
L191: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L192: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L193: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[5];
L194: // CONVERT_SHORT_TO_DOUBLE
  double_vars[1] = (double)short_vars[0];
L195: // DIVIDE_DOUBLE
  double_vars[6] = double_vars[0] / double_vars[1];
L196: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L197: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[5];
L198: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L199: // DIVIDE_DOUBLE
  double_vars[7] = double_vars[0] / double_vars[1];
L200: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L201: // MOVE_CONSTANT_INT
  int_vars[5] = 2;
L202: // CONVERT_INT_TO_DOUBLE
  double_vars[1] = (double)int_vars[5];
L203: // DIVIDE_DOUBLE
  double_vars[8] = double_vars[0] / double_vars[1];
L204: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.0;
L205: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L206: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[1] = (double)float_vars[0];
L207: // DIVIDE_DOUBLE
  double_vars[9] = double_vars[0] / double_vars[1];
L208: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 1.0;
L209: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L210: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L211: // DIVIDE_DOUBLE
  double_vars[10] = double_vars[0] / double_vars[1];
L212: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L213: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L214: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L215: // BOOL_INT
  int_vars[0] = int_vars[0];
L216: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L267; }
L217: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L218: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L219: // EQ_DOUBLE
  int_vars[0] = (double_vars[3] == double_vars[0]);
L220: // BOOL_INT
  int_vars[0] = int_vars[0];
L221: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L266; }
L222: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L223: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L224: // EQ_DOUBLE
  int_vars[0] = (double_vars[4] == double_vars[0]);
L225: // BOOL_INT
  int_vars[0] = int_vars[0];
L226: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L265; }
L227: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L228: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L229: // EQ_DOUBLE
  int_vars[0] = (double_vars[5] == double_vars[0]);
L230: // BOOL_INT
  int_vars[0] = int_vars[0];
L231: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L264; }
L232: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L233: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L234: // EQ_DOUBLE
  int_vars[0] = (double_vars[6] == double_vars[0]);
L235: // BOOL_INT
  int_vars[0] = int_vars[0];
L236: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L263; }
L237: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L238: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L239: // EQ_DOUBLE
  int_vars[0] = (double_vars[7] == double_vars[0]);
L240: // BOOL_INT
  int_vars[0] = int_vars[0];
L241: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L262; }
L242: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L243: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L244: // EQ_DOUBLE
  int_vars[0] = (double_vars[8] == double_vars[0]);
L245: // BOOL_INT
  int_vars[0] = int_vars[0];
L246: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L261; }
L247: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L248: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L249: // EQ_DOUBLE
  int_vars[0] = (double_vars[9] == double_vars[0]);
L250: // BOOL_INT
  int_vars[0] = int_vars[0];
L251: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L260; }
L252: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 0.5;
L253: // CONVERT_FLOAT_TO_DOUBLE
  double_vars[0] = (double)float_vars[0];
L254: // EQ_DOUBLE
  int_vars[0] = (double_vars[10] == double_vars[0]);
L255: // BOOL_INT
  int_vars[0] = int_vars[0];
L256: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L259; }
L257: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L258: // GOTO
  goto L259;
L259: // GOTO
  goto L260;
L260: // GOTO
  goto L261;
L261: // GOTO
  goto L262;
L262: // GOTO
  goto L263;
L263: // GOTO
  goto L264;
L264: // GOTO
  goto L265;
L265: // GOTO
  goto L266;
L266: // GOTO
  goto L267;
L267: // BOOL_INT
  int_vars[0] = int_vars[1];
L268: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L277; }
L269: // BOOL_INT
  int_vars[0] = int_vars[3];
L270: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L274; }
L271: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L272: // BOOL_INT
  int_vars[0] = int_vars[5];
L273: // GOTO
  goto L276;
L274: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L275: // BOOL_INT
  int_vars[0] = int_vars[6];
L276: // GOTO
  goto L279;
L277: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L278: // BOOL_INT
  int_vars[0] = int_vars[7];
L279: // BOOL_INT
  int_vars[0] = int_vars[0];
L280: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L289; }
L281: // BOOL_INT
  int_vars[0] = int_vars[4];
L282: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L286; }
L283: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L284: // BOOL_INT
  int_vars[0] = int_vars[5];
L285: // GOTO
  goto L288;
L286: // MOVE_CONSTANT_INT
  int_vars[6] = 0;
L287: // BOOL_INT
  int_vars[0] = int_vars[6];
L288: // GOTO
  goto L291;
L289: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L290: // BOOL_INT
  int_vars[0] = int_vars[7];
L291: // BOOL_INT
  int_vars[0] = int_vars[0];
L292: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L296; }
L293: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L294: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L300;
L295: // GOTO
  goto L296;
L296: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L297: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L300;
L298: // INIT_INT
  int_vars[9] = 0;
L299: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[9];
  goto L300;
L300: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_byte_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[3];
L6: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[1];
L7: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[2] / int_vars[4];
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_byte_byte";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 7;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L10: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // MOVE_INT
  int_vars[0] = int_vars[0];
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_byte_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // CONVERT_BYTE_TO_INT
  int_vars[2] = (int32_t)byte_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = -2;
L5: // DIVIDE_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[4] = int_vars[2] / int_vars[3];
  } 
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_byte_int";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 63;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = -5;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_double_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1.25;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.5;
L3: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 0.5;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_double_double_big(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 1000000000.5;
L2: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.0;
L3: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L4: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 500000000.25;
L5: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_float_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 20.0;
L2: // MOVE_CONSTANT_FLOAT
  float_vars[1] = -2.5;
L3: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L4: // MOVE_CONSTANT_FLOAT
  float_vars[0] = -8.0;
L5: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_NE_ZERO
  if (int_vars[0]) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L10: // GOTO
  goto L11;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L12: // BOOL_INT
  int_vars[0] = int_vars[4];
L13: // MOVE_INT
  int_vars[0] = int_vars[0];
L14: // BOOL_INT
  int_vars[0] = int_vars[0];
L15: // IF_NE_ZERO
  if (int_vars[0]) { goto L19; }
L16: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L17: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L23;
L18: // GOTO
  goto L19;
L19: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L23;
L21: // INIT_INT
  int_vars[6] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L23;
L23: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_int_byte(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int8_t byte_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 12;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[2];
L4: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L5: // DIVIDE_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[4] = int_vars[1] / int_vars[3];
  } 
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_int_byte";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 35;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_int_double(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  double double_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // CONVERT_INT_TO_DOUBLE
  double_vars[0] = (double)int_vars[1];
L3: // MOVE_CONSTANT_DOUBLE
  double_vars[1] = 2.5;
L4: // DIVIDE_DOUBLE
  double_vars[2] = double_vars[0] / double_vars[1];
L5: // MOVE_CONSTANT_DOUBLE
  double_vars[0] = 4.0;
L6: // EQ_DOUBLE
  int_vars[0] = (double_vars[2] == double_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_int_float(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  float float_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 5;
L2: // CONVERT_INT_TO_FLOAT
  float_vars[0] = (float)int_vars[1];
L3: // MOVE_CONSTANT_FLOAT
  float_vars[1] = 2.5;
L4: // DIVIDE_FLOAT
  float_vars[2] = float_vars[0] / float_vars[1];
L5: // MOVE_CONSTANT_FLOAT
  float_vars[0] = 2.0;
L6: // EQ_FLOAT
  int_vars[0] = (float_vars[2] == float_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_int_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1000000000;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = -2;
L3: // DIVIDE_INT
  if (__builtin_expect(int_vars[2] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[3] = int_vars[1] / int_vars[2];
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_int_int";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 91;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_INT
  int_vars[2] = 500000000;
L6: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[5];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L24;
L22: // INIT_INT
  int_vars[7] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_int_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 7;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 3;
L3: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L4: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L5: // DIVIDE_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[4] = int_vars[1] / int_vars[3];
  } 
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_int_short";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 49;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_long_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -100000000000LL;
L2: // MOVE_CONSTANT_LONG
  long_vars[1] = -2LL;
L3: // DIVIDE_LONG
  if (__builtin_expect(long_vars[1] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    long_vars[2] = long_vars[0] / long_vars[1];
  } 
L4: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_long_long";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 105;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L24;
  }
L5: // MOVE_CONSTANT_LONG
  long_vars[0] = 50000000000LL;
L6: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L7: // BOOL_INT
  int_vars[0] = int_vars[0];
L8: // IF_NE_ZERO
  if (int_vars[0]) { goto L12; }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L10: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L11: // GOTO
  goto L12;
L12: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L13: // BOOL_INT
  int_vars[0] = int_vars[4];
L14: // MOVE_INT
  int_vars[0] = int_vars[0];
L15: // BOOL_INT
  int_vars[0] = int_vars[0];
L16: // IF_NE_ZERO
  if (int_vars[0]) { goto L20; }
L17: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L18: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L24;
L19: // GOTO
  goto L20;
L20: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L21: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L24;
L22: // INIT_INT
  int_vars[6] = 0;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L24;
L24: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_short_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[1];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -7;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 3;
L5: // DIVIDE_INT
  if (__builtin_expect(int_vars[3] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[4] = int_vars[2] / int_vars[3];
  } 
L6: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_short_int";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 77;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L26;
  }
L7: // MOVE_CONSTANT_INT
  int_vars[2] = -2;
L8: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[2]);
L9: // BOOL_INT
  int_vars[0] = int_vars[0];
L10: // IF_NE_ZERO
  if (int_vars[0]) { goto L14; }
L11: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L13: // GOTO
  goto L14;
L14: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L15: // BOOL_INT
  int_vars[0] = int_vars[5];
L16: // MOVE_INT
  int_vars[0] = int_vars[0];
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_NE_ZERO
  if (int_vars[0]) { goto L22; }
L19: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L20: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L26;
L21: // GOTO
  goto L22;
L22: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L23: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L26;
L24: // INIT_INT
  int_vars[7] = 0;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L26;
L26: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__Divide__divide_short_short(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 10;
L2: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[1];
L3: // CONVERT_SHORT_TO_INT
  int_vars[2] = (int32_t)short_vars[0];
L4: // MOVE_CONSTANT_INT
  int_vars[3] = 2;
L5: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[3];
L6: // CONVERT_SHORT_TO_INT
  int_vars[4] = (int32_t)short_vars[1];
L7: // DIVIDE_INT
  if (__builtin_expect(int_vars[4] == 0, 0)) { 
    env->set_exception(env, env->new_string_raw(env, "0 division"));
    exception_flag = 1;
  } else {
    int_vars[5] = int_vars[2] / int_vars[4];
  } 
L8: // IF_EXCEPTION_RETURN
  if (exception_flag) {
    const char* sub_package_name = "TestCase::Divide";
    const char* sub_name = "divide_short_short";
    const char* file = "TestCase/Divide.spvm";
    int32_t line = 21;
    env->set_exception(env, env->new_stack_trace_raw(env, env->get_exception(env), sub_package_name, sub_name, file, line));
    goto L28;
  }
L9: // MOVE_CONSTANT_INT
  int_vars[2] = 5;
L10: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[2]);
L11: // BOOL_INT
  int_vars[0] = int_vars[0];
L12: // IF_NE_ZERO
  if (int_vars[0]) { goto L16; }
L13: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L15: // GOTO
  goto L16;
L16: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L17: // BOOL_INT
  int_vars[0] = int_vars[4];
L18: // MOVE_INT
  int_vars[0] = int_vars[0];
L19: // BOOL_INT
  int_vars[0] = int_vars[0];
L20: // IF_NE_ZERO
  if (int_vars[0]) { goto L24; }
L21: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L22: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L28;
L23: // GOTO
  goto L24;
L24: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L25: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L28;
L26: // INIT_INT
  int_vars[7] = 0;
L27: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L28;
L28: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


