#ifndef SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#define SPVM_CSOURCE_BUILDER_PRECOMPILE_H
#include <spvm_native.h>

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <inttypes.h>
#define SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(object) ((void*)((intptr_t)object & ~(intptr_t)1))
#define SPVM_RUNTIME_API_GET_REF_COUNT(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset)))
#define SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))++)
#define SPVM_RUNTIME_API_INC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(object);\
  }\
} while (0)\

#define SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object) ((*(int32_t*)((intptr_t)object + (intptr_t)env->object_ref_count_offset))--)
#define SPVM_RUNTIME_API_DEC_REF_COUNT(object)\
do {\
  if (object != NULL) {\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(object) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(object); }\
    else { env->dec_ref_count(env, object); }\
  }\
} while (0)\

#define SPVM_RUNTIME_API_ISWEAK(dist_address) (((intptr_t)*(void**)dist_address) & 1)

#define SPVM_RUNTIME_API_OBJECT_ASSIGN(dist_address, src_object) \
do {\
  void* tmp_object = SPVM_RUNTIME_API_GET_OBJECT_NO_WEAKEN_ADDRESS(src_object);\
  if (tmp_object != NULL) {\
    SPVM_RUNTIME_API_INC_REF_COUNT_ONLY(tmp_object);\
  }\
  if (*(void**)(dist_address) != NULL) {\
    if (__builtin_expect(SPVM_RUNTIME_API_ISWEAK(dist_address), 0)) { env->unweaken(env, dist_address); }\
    if (SPVM_RUNTIME_API_GET_REF_COUNT(*(void**)(dist_address)) > 1) { SPVM_RUNTIME_API_DEC_REF_COUNT_ONLY(*(void**)(dist_address)); }\
    else { env->dec_ref_count(env, *(void**)(dist_address)); }\
  }\
  *(void**)(dist_address) = tmp_object;\
} while (0)\

#endif
// Package variable id declarations
// Field id and index declarations
// Sub id declarations
// Basic type id declarations
// Function Declarations
// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_and(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_or(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_int_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_long_max(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_logical_int(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_logical_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_long(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_xor(SPVM_ENV* env, SPVM_VALUE* stack);

// [SIG]int()
int32_t SPPRECOMPILE__TestCase__BitOperator__complement(SPVM_ENV* env, SPVM_VALUE* stack);


// Function Implementations
int32_t SPPRECOMPILE__TestCase__BitOperator__bit_and(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L4: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 15;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L7: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[1];
L8: // BIT_AND_INT
  int_vars[7] = int_vars[4] & int_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L10: // BIT_AND_INT
  int_vars[4] = int_vars[7] & int_vars[3];
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 15;
L12: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L15: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 65280;
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L20: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 61680;
L22: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L23: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L24: // BIT_AND_INT
  int_vars[8] = int_vars[5] & int_vars[7];
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 65535;
L26: // BIT_AND_INT
  int_vars[5] = int_vars[8] & int_vars[4];
L27: // MOVE_CONSTANT_INT
  int_vars[6] = 61440;
L28: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 65280;
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 61680;
L36: // BIT_AND_INT
  int_vars[7] = int_vars[5] & int_vars[6];
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 61440;
L38: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[5]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L44: // MOVE_CONSTANT_LONG
  long_vars[0] = 4278255360LL;
L45: // MOVE_CONSTANT_LONG
  long_vars[1] = 4042322160LL;
L46: // BIT_AND_LONG
  long_vars[2] = long_vars[0] & long_vars[1];
L47: // MOVE_CONSTANT_LONG
  long_vars[0] = 4026593280LL;
L48: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L51: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L52: // GOTO
  goto L53;
L53: // BOOL_INT
  int_vars[0] = int_vars[1];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L58: // BOOL_INT
  int_vars[0] = int_vars[6];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[7];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[8];
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L70: // BOOL_INT
  int_vars[0] = int_vars[6];
L71: // GOTO
  goto L74;
L72: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L73: // BOOL_INT
  int_vars[0] = int_vars[7];
L74: // GOTO
  goto L77;
L75: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[8];
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L79: // BOOL_INT
  int_vars[0] = int_vars[5];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L82: // BOOL_INT
  int_vars[0] = int_vars[6];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[7];
L86: // GOTO
  goto L89;
L87: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L88: // BOOL_INT
  int_vars[0] = int_vars[8];
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L98;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L98;
L96: // INIT_INT
  int_vars[10] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L98;
L98: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_or(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 240;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L4: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 255;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L7: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[1];
L8: // BIT_OR_INT
  int_vars[7] = int_vars[4] | int_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L10: // BIT_AND_INT
  int_vars[4] = int_vars[7] & int_vars[3];
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 255;
L12: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L15: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 65280;
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L20: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 61680;
L22: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L23: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L24: // BIT_OR_INT
  int_vars[8] = int_vars[5] | int_vars[7];
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 65535;
L26: // BIT_AND_INT
  int_vars[5] = int_vars[8] & int_vars[4];
L27: // MOVE_CONSTANT_INT
  int_vars[6] = 65520;
L28: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 65280;
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 61680;
L36: // BIT_OR_INT
  int_vars[7] = int_vars[5] | int_vars[6];
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 65520;
L38: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[5]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L44: // MOVE_CONSTANT_LONG
  long_vars[0] = 4278255360LL;
L45: // MOVE_CONSTANT_LONG
  long_vars[1] = 4042322160LL;
L46: // BIT_OR_LONG
  long_vars[2] = long_vars[0] | long_vars[1];
L47: // MOVE_CONSTANT_LONG
  long_vars[0] = 4293984240LL;
L48: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L51: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L52: // GOTO
  goto L53;
L53: // BOOL_INT
  int_vars[0] = int_vars[1];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L58: // BOOL_INT
  int_vars[0] = int_vars[6];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[7];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[8];
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L70: // BOOL_INT
  int_vars[0] = int_vars[6];
L71: // GOTO
  goto L74;
L72: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L73: // BOOL_INT
  int_vars[0] = int_vars[7];
L74: // GOTO
  goto L77;
L75: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[8];
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L79: // BOOL_INT
  int_vars[0] = int_vars[5];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L82: // BOOL_INT
  int_vars[0] = int_vars[6];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[7];
L86: // GOTO
  goto L89;
L87: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L88: // BOOL_INT
  int_vars[0] = int_vars[8];
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L98;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L98;
L96: // INIT_INT
  int_vars[10] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L98;
L98: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 805306368;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // LEFT_SHIFT_INT
  int_vars[3] = (int_vars[1] << int_vars[2]);
L4: // MOVE_CONSTANT_INT
  int_vars[2] = -1073741824;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_int_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 1073741824;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // LEFT_SHIFT_INT
  int_vars[3] = (int_vars[1] << int_vars[2]);
L4: // MOVE_CONSTANT_INT
  int_vars[2] = INT32_MIN;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_int_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = INT32_MIN;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L3: // LEFT_SHIFT_INT
  int_vars[3] = (int_vars[1] << int_vars[2]);
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 0;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 3458764513820540928LL;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L3: // LEFT_SHIFT_LONG
  long_vars[1] = (long_vars[0] << int_vars[1]);
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = -4611686018427387904LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_long_max(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = 4611686018427387904LL;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // LEFT_SHIFT_LONG
  long_vars[1] = (long_vars[0] << int_vars[1]);
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = INT64_MIN;
L5: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_left_long_overflow(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = INT64_MIN;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L3: // LEFT_SHIFT_LONG
  long_vars[1] = (long_vars[0] << int_vars[1]);
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = 0LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1073741823;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // RIGHT_ARITHMETIC_SHIFT_INT
  int_vars[3] = (int_vars[1] >> int_vars[2]);
L4: // MOVE_CONSTANT_INT
  int_vars[2] = -268435456;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_logical_int(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int32_t int_vars[9];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = -1073741823;
L2: // MOVE_CONSTANT_INT
  int_vars[2] = 2;
L3: // RIGHT_LOGICAL_SHIFT_INT
  int_vars[3] = ((int32_t)((uint32_t)int_vars[1] >> int_vars[2]));
L4: // MOVE_CONSTANT_INT
  int_vars[2] = 805306368;
L5: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[2]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[5];
  goto L15;
L13: // INIT_INT
  int_vars[7] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[7];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_logical_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -4611686018427387903LL;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L3: // RIGHT_LOGICAL_SHIFT_LONG
  long_vars[1] = ((int64_t)((uint64_t)long_vars[0] >> int_vars[1]));
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = 3458764513820540928LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_shift_right_long(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[2];
  int32_t int_vars[8];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_LONG
  long_vars[0] = -4611686018427387903LL;
L2: // MOVE_CONSTANT_INT
  int_vars[1] = 2;
L3: // RIGHT_ARITHMETIC_SHIFT_LONG
  long_vars[1] = (long_vars[0] >> int_vars[1]);
L4: // MOVE_CONSTANT_LONG
  long_vars[0] = -1152921504606846976LL;
L5: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[0]);
L6: // BOOL_INT
  int_vars[0] = int_vars[0];
L7: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L11; }
L8: // MOVE_CONSTANT_INT
  int_vars[2] = 1;
L9: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[2];
  goto L15;
L10: // GOTO
  goto L13;
L11: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L12: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[4];
  goto L15;
L13: // INIT_INT
  int_vars[6] = 0;
L14: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L15;
L15: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__bit_xor(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 0;
L2: // MOVE_CONSTANT_INT
  int_vars[3] = 240;
L3: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[3];
L4: // CONVERT_BYTE_TO_INT
  int_vars[4] = (int32_t)byte_vars[0];
L5: // MOVE_CONSTANT_INT
  int_vars[5] = 15;
L6: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[5];
L7: // CONVERT_BYTE_TO_INT
  int_vars[6] = (int32_t)byte_vars[1];
L8: // BIT_XOR_INT
  int_vars[7] = int_vars[4] ^ int_vars[6];
L9: // MOVE_CONSTANT_INT
  int_vars[3] = 255;
L10: // BIT_AND_INT
  int_vars[4] = int_vars[7] & int_vars[3];
L11: // MOVE_CONSTANT_INT
  int_vars[5] = 255;
L12: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[5]);
L13: // BOOL_INT
  int_vars[0] = int_vars[0];
L14: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L17; }
L15: // MOVE_CONSTANT_INT
  int_vars[1] = 1;
L16: // GOTO
  goto L17;
L17: // MOVE_CONSTANT_INT
  int_vars[3] = 0;
L18: // MOVE_CONSTANT_INT
  int_vars[4] = 65280;
L19: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[4];
L20: // CONVERT_SHORT_TO_INT
  int_vars[5] = (int32_t)short_vars[0];
L21: // MOVE_CONSTANT_INT
  int_vars[6] = 61680;
L22: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L23: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L24: // BIT_XOR_INT
  int_vars[8] = int_vars[5] ^ int_vars[7];
L25: // MOVE_CONSTANT_INT
  int_vars[4] = 65535;
L26: // BIT_AND_INT
  int_vars[5] = int_vars[8] & int_vars[4];
L27: // MOVE_CONSTANT_INT
  int_vars[6] = 4080;
L28: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[6]);
L29: // BOOL_INT
  int_vars[0] = int_vars[0];
L30: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L33; }
L31: // MOVE_CONSTANT_INT
  int_vars[3] = 1;
L32: // GOTO
  goto L33;
L33: // MOVE_CONSTANT_INT
  int_vars[4] = 0;
L34: // MOVE_CONSTANT_INT
  int_vars[5] = 65280;
L35: // MOVE_CONSTANT_INT
  int_vars[6] = 61680;
L36: // BIT_XOR_INT
  int_vars[7] = int_vars[5] ^ int_vars[6];
L37: // MOVE_CONSTANT_INT
  int_vars[5] = 4080;
L38: // EQ_INT
  int_vars[0] = (int_vars[7] == int_vars[5]);
L39: // BOOL_INT
  int_vars[0] = int_vars[0];
L40: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L43; }
L41: // MOVE_CONSTANT_INT
  int_vars[4] = 1;
L42: // GOTO
  goto L43;
L43: // MOVE_CONSTANT_INT
  int_vars[5] = 0;
L44: // MOVE_CONSTANT_LONG
  long_vars[0] = 4278255360LL;
L45: // MOVE_CONSTANT_LONG
  long_vars[1] = 4042322160LL;
L46: // BIT_XOR_LONG
  long_vars[2] = long_vars[0] ^ long_vars[1];
L47: // MOVE_CONSTANT_LONG
  long_vars[0] = 267390960LL;
L48: // EQ_LONG
  int_vars[0] = (long_vars[2] == long_vars[0]);
L49: // BOOL_INT
  int_vars[0] = int_vars[0];
L50: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L53; }
L51: // MOVE_CONSTANT_INT
  int_vars[5] = 1;
L52: // GOTO
  goto L53;
L53: // BOOL_INT
  int_vars[0] = int_vars[1];
L54: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L63; }
L55: // BOOL_INT
  int_vars[0] = int_vars[3];
L56: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L60; }
L57: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L58: // BOOL_INT
  int_vars[0] = int_vars[6];
L59: // GOTO
  goto L62;
L60: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L61: // BOOL_INT
  int_vars[0] = int_vars[7];
L62: // GOTO
  goto L65;
L63: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L64: // BOOL_INT
  int_vars[0] = int_vars[8];
L65: // BOOL_INT
  int_vars[0] = int_vars[0];
L66: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L75; }
L67: // BOOL_INT
  int_vars[0] = int_vars[4];
L68: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L72; }
L69: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L70: // BOOL_INT
  int_vars[0] = int_vars[6];
L71: // GOTO
  goto L74;
L72: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L73: // BOOL_INT
  int_vars[0] = int_vars[7];
L74: // GOTO
  goto L77;
L75: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L76: // BOOL_INT
  int_vars[0] = int_vars[8];
L77: // BOOL_INT
  int_vars[0] = int_vars[0];
L78: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L87; }
L79: // BOOL_INT
  int_vars[0] = int_vars[5];
L80: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L84; }
L81: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L82: // BOOL_INT
  int_vars[0] = int_vars[6];
L83: // GOTO
  goto L86;
L84: // MOVE_CONSTANT_INT
  int_vars[7] = 0;
L85: // BOOL_INT
  int_vars[0] = int_vars[7];
L86: // GOTO
  goto L89;
L87: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L88: // BOOL_INT
  int_vars[0] = int_vars[8];
L89: // BOOL_INT
  int_vars[0] = int_vars[0];
L90: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L94; }
L91: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L92: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L98;
L93: // GOTO
  goto L94;
L94: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L95: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L98;
L96: // INIT_INT
  int_vars[10] = 0;
L97: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L98;
L98: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}

int32_t SPPRECOMPILE__TestCase__BitOperator__complement(SPVM_ENV* env, SPVM_VALUE* stack) {
  int32_t object_header_byte_size = (intptr_t)env->object_header_byte_size;
  int64_t long_vars[3];
  int32_t int_vars[12];
  int32_t exception_flag = 0;
  int32_t mortal_stack[1];
  int32_t mortal_stack_top = 0;
  int16_t short_vars[2];
  int8_t byte_vars[2];
  char convert_string_buffer[21];

L0: // INIT_INT
  int_vars[0] = 0;
L1: // MOVE_CONSTANT_INT
  int_vars[1] = 240;
L2: // CONVERT_INT_TO_BYTE
  byte_vars[0] = (int8_t)int_vars[1];
L3: // MOVE_CONSTANT_INT
  int_vars[2] = 65520;
L4: // CONVERT_INT_TO_SHORT
  short_vars[0] = (int16_t)int_vars[2];
L5: // MOVE_CONSTANT_INT
  int_vars[2] = -16;
L6: // MOVE_CONSTANT_LONG
  long_vars[0] = -16LL;
L7: // CONVERT_BYTE_TO_INT
  int_vars[3] = (int32_t)byte_vars[0];
L8: // BIT_OMPLEMENT_INT
  int_vars[4] = ~int_vars[3];
L9: // CONVERT_SHORT_TO_INT
  int_vars[3] = (int32_t)short_vars[0];
L10: // BIT_OMPLEMENT_INT
  int_vars[5] = ~int_vars[3];
L11: // BIT_OMPLEMENT_INT
  int_vars[3] = ~int_vars[2];
L12: // BIT_NOT_LONG
  long_vars[1] = ~long_vars[0];
L13: // MOVE_CONSTANT_INT
  int_vars[6] = 15;
L14: // CONVERT_INT_TO_BYTE
  byte_vars[1] = (int8_t)int_vars[6];
L15: // CONVERT_BYTE_TO_INT
  int_vars[7] = (int32_t)byte_vars[1];
L16: // EQ_INT
  int_vars[0] = (int_vars[4] == int_vars[7]);
L17: // BOOL_INT
  int_vars[0] = int_vars[0];
L18: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L39; }
L19: // MOVE_CONSTANT_INT
  int_vars[6] = 15;
L20: // CONVERT_INT_TO_SHORT
  short_vars[1] = (int16_t)int_vars[6];
L21: // CONVERT_SHORT_TO_INT
  int_vars[7] = (int32_t)short_vars[1];
L22: // EQ_INT
  int_vars[0] = (int_vars[5] == int_vars[7]);
L23: // BOOL_INT
  int_vars[0] = int_vars[0];
L24: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L38; }
L25: // MOVE_CONSTANT_INT
  int_vars[6] = 15;
L26: // EQ_INT
  int_vars[0] = (int_vars[3] == int_vars[6]);
L27: // BOOL_INT
  int_vars[0] = int_vars[0];
L28: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L37; }
L29: // MOVE_CONSTANT_LONG
  long_vars[2] = 15LL;
L30: // EQ_LONG
  int_vars[0] = (long_vars[1] == long_vars[2]);
L31: // BOOL_INT
  int_vars[0] = int_vars[0];
L32: // IF_EQ_ZERO
  if (int_vars[0] == 0) { goto L36; }
L33: // MOVE_CONSTANT_INT
  int_vars[6] = 1;
L34: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[6];
  goto L43;
L35: // GOTO
  goto L36;
L36: // GOTO
  goto L37;
L37: // GOTO
  goto L38;
L38: // GOTO
  goto L39;
L39: // MOVE_CONSTANT_INT
  int_vars[8] = 0;
L40: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[8];
  goto L43;
L41: // INIT_INT
  int_vars[10] = 0;
L42: // RETURN_INT
  *(int32_t*)&stack[0] = int_vars[10];
  goto L43;
L43: // END_SUB
  if (!exception_flag) {
  }
  return exception_flag;
}


