=head1 NAME

Encode::JP::Emoji::Mapping - Emoji mappings

=head1 SYNOPSIS

    $ perl tools/make-mapping-pm.pl > lib/Encode/JP/Emoji/Mapping.pm

=head1 DESCRIPTION

B<DO NOT> edit this file but generate it as above.

=head1 SEE ALSO

L<Encode::JP::Emoji>

=cut

package Encode::JP::Emoji::Mapping;
use strict;
use warnings;
use utf8;

our $InEmojiDocomoCP932 = "E63E\tE757";
sub InEmojiDocomoCP932 { $InEmojiDocomoCP932; }
our $ReEmojiDocomoCP932 = qr/(?:\p{InEmojiDocomoCP932})/mo;

our $InEmojiKddiCP932 = "E468\tE5DF\nEA80\tEB8E";
sub InEmojiKddiCP932 { $InEmojiKddiCP932; }
our $ReEmojiKddiCP932 = qr/(?:\p{InEmojiKddiCP932})/mo;

our $InEmojiSoftbankCP932 = "E001\tE05A\nE101\tE15A\nE201\tE25A\nE301\tE34D\nE401\tE44C\nE501\tE53E";
sub InEmojiSoftbankCP932 { $InEmojiSoftbankCP932; }
our $ReEmojiSoftbankCP932 = qr/(?:\p{InEmojiSoftbankCP932})/mo;

our $InEmojiDocomoUnicode = "E63E\tE757";
sub InEmojiDocomoUnicode { $InEmojiDocomoUnicode; }
our $ReEmojiDocomoUnicode = qr/(?:\p{InEmojiDocomoUnicode})/mo;

our $InEmojiKddiUnicode = "E468\tE5DF\nEA80\tEB8E";
sub InEmojiKddiUnicode { $InEmojiKddiUnicode; }
our $ReEmojiKddiUnicode = qr/(?:\p{InEmojiKddiUnicode})/mo;

our $InEmojiSoftbankUnicode = "E001\tE05A\nE101\tE15A\nE201\tE25A\nE301\tE34D\nE401\tE44C\nE501\tE53E";
sub InEmojiSoftbankUnicode { $InEmojiSoftbankUnicode; }
our $ReEmojiSoftbankUnicode = qr/(?:\p{InEmojiSoftbankUnicode})/mo;

our $InEmojiGoogleUnicode = "FE000\tFE05B\nFE190\tFE1E3\nFE320\tFE369\nFE4B0\tFE553\nFE7D0\tFE83C\nFE960\tFE988\nFEAF0\tFEBA2\nFEE10\tFEE33\nFEE40\tFEE4A\nFEE70\tFEE7D\nFEEA0";
sub InEmojiGoogleUnicode { $InEmojiGoogleUnicode; }
our $ReEmojiGoogleUnicode = qr/(?:\p{InEmojiGoogleUnicode})/mo;

our $InEmojiUnicodeUnicode = "00A9\n00AE\n2002\t2003\n2005\n203C\n2049\n2122\n2139\n2194\t2199\n21A9\t21AA\n231A\t231B\n23E9\t23EA\n24C2\n25AA\t25AB\n25B6\n25C0\n25FB\t25FE\n2600\t2601\n260E\n2611\n2614\t2615\n261D\n263A\n2648\t2653\n2660\n2663\n2665\t2666\n2668\n267B\n267F\n2693\n26A0\t26A1\n26AA\t26AB\n26BD\t26BE\n26C4\t26C5\n26D4\n26E2\n26EA\n26F2\t26F3\n26F5\n26FA\n26FD\n2702\n2705\n2708\t270A\n270C\n270F\n2712\n2714\n2716\n2733\t2734\n2744\n2747\n2762\n2764\n27A1\n2934\t2935\n2B05\t2B07\n2B1B\t2B1C\n2B50\n2E32\n3030\n303D\n3297\n3299\n1F004\n1F170\t1F171\n1F17E\t1F17F\n1F18E\n1F201\n1F224\n1F22A\n1F231\n1F250\n1F44D\n1F541\n1F600";
sub InEmojiUnicodeUnicode { $InEmojiUnicodeUnicode; }
our $ReEmojiUnicodeUnicode = qr/(?:\p{InEmojiUnicodeUnicode}|[\x23\x31\x32\x33\x34\x35\x36\x37\x38\x39\x30]\x{20E3})/mo;

sub docomo_cp932_to_docomo_unicode {
    # through
}

sub docomo_unicode_to_docomo_cp932 {
    # through
}

sub kddi_cp932_to_kddi_unicode {
    $_[1] =~ tr
    [\x{E234}\x{E235}\x{E236}\x{E237}\x{E238}\x{E239}\x{E23A}\x{E23B}\x{E23C}\x{E23D}\x{E23E}\x{E23F}\x{E240}\x{E241}\x{E242}\x{E243}\x{E244}\x{E245}\x{E246}\x{E247}\x{E248}\x{E249}\x{E24A}\x{E24B}\x{E24C}\x{E24D}\x{E24E}\x{E24F}\x{E250}\x{E251}\x{E252}\x{E253}\x{E254}\x{E255}\x{E256}\x{E257}\x{E258}\x{E259}\x{E25A}\x{E25B}\x{E25C}\x{E25D}\x{E25E}\x{E25F}\x{E260}\x{E261}\x{E262}\x{E263}\x{E264}\x{E265}\x{E266}\x{E267}\x{E268}\x{E269}\x{E26A}\x{E26B}\x{E26C}\x{E26D}\x{E26E}\x{E26F}\x{E270}\x{E271}\x{E272}\x{E273}\x{E274}\x{E275}\x{E276}\x{E277}\x{E278}\x{E279}\x{E27A}\x{E27B}\x{E27C}\x{E27D}\x{E27E}\x{E27F}\x{E280}\x{E281}\x{E282}\x{E283}\x{E284}\x{E285}\x{E286}\x{E287}\x{E288}\x{E289}\x{E28A}\x{E28B}\x{E28C}\x{E28D}\x{E28E}\x{E28F}\x{E290}\x{E291}\x{E292}\x{E293}\x{E294}\x{E295}\x{E296}\x{E297}\x{E298}\x{E299}\x{E29A}\x{E29B}\x{E29C}\x{E29D}\x{E29E}\x{E29F}\x{E2A0}\x{E2A1}\x{E2A2}\x{E2A3}\x{E2A4}\x{E2A5}\x{E2A6}\x{E2A7}\x{E2A8}\x{E2A9}\x{E2AA}\x{E2AB}\x{E2AC}\x{E2AD}\x{E2AE}\x{E2AF}\x{E2B0}\x{E2B1}\x{E2B2}\x{E2B3}\x{E2B4}\x{E2B5}\x{E2B6}\x{E2B7}\x{E2B8}\x{E2B9}\x{E2BA}\x{E2BB}\x{E2BC}\x{E2BD}\x{E2BE}\x{E2BF}\x{E2C0}\x{E2C1}\x{E2C2}\x{E2C3}\x{E2C4}\x{E2C5}\x{E2C6}\x{E2C7}\x{E2C8}\x{E2C9}\x{E2CA}\x{E2CB}\x{E2CC}\x{E2CD}\x{E2CE}\x{E2CF}\x{E2D0}\x{E2D1}\x{E2D2}\x{E2D3}\x{E2D4}\x{E2D5}\x{E2D6}\x{E2D7}\x{E2D8}\x{E2D9}\x{E2DA}\x{E2DB}\x{E2DC}\x{E2DD}\x{E2DE}\x{E2DF}\x{E2E0}\x{E2E1}\x{E2E2}\x{E2E3}\x{E2E4}\x{E2E5}\x{E2E6}\x{E2E7}\x{E2E8}\x{E2E9}\x{E2EA}\x{E2EB}\x{E2EC}\x{E2ED}\x{E2EE}\x{E2EF}\x{E2F0}\x{E2F1}\x{E2F2}\x{E2F3}\x{E2F4}\x{E2F5}\x{E2F6}\x{E2F7}\x{E2F8}\x{E2F9}\x{E2FA}\x{E2FB}\x{E2FC}\x{E2FD}\x{E2FE}\x{E2FF}\x{E300}\x{E301}\x{E302}\x{E303}\x{E304}\x{E305}\x{E306}\x{E307}\x{E308}\x{E309}\x{E30A}\x{E30B}\x{E30C}\x{E30D}\x{E30E}\x{E30F}\x{E310}\x{E311}\x{E312}\x{E313}\x{E314}\x{E315}\x{E316}\x{E317}\x{E318}\x{E319}\x{E31A}\x{E31B}\x{E31C}\x{E31D}\x{E31E}\x{E31F}\x{E320}\x{E321}\x{E322}\x{E323}\x{E324}\x{E325}\x{E326}\x{E327}\x{E328}\x{E329}\x{E32A}\x{E32B}\x{E32C}\x{E32D}\x{E32E}\x{E32F}\x{E330}\x{E331}\x{E332}\x{E333}\x{E334}\x{E335}\x{E336}\x{E337}\x{E338}\x{E339}\x{E33A}\x{E33B}\x{E33C}\x{E33D}\x{E33E}\x{E33F}\x{E340}\x{E341}\x{E342}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E5DE}\x{E5DF}]
    [\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E5DE}\x{E5DF}\x{EA80}\x{EA81}\x{EA82}\x{EA83}\x{EA84}\x{EA85}\x{EA86}\x{EA87}\x{EA88}\x{EA89}\x{EA8A}\x{EA8B}\x{EA8C}\x{EA8D}\x{EA8E}\x{EA8F}\x{EA90}\x{EA91}\x{EA92}\x{EA93}\x{EA94}\x{EA95}\x{EA96}\x{EA97}\x{EA98}\x{EA99}\x{EA9A}\x{EA9B}\x{EA9C}\x{EA9D}\x{EA9E}\x{EA9F}\x{EAA0}\x{EAA1}\x{EAA2}\x{EAA3}\x{EAA4}\x{EAA5}\x{EAA6}\x{EAA7}\x{EAA8}\x{EAA9}\x{EAAA}\x{EAAB}\x{EAAC}\x{EAAD}\x{EAAE}\x{EAAF}\x{EAB0}\x{EAB1}\x{EAB2}\x{EAB3}\x{EAB4}\x{EAB5}\x{EAB6}\x{EAB7}\x{EAB8}\x{EAB9}\x{EABA}\x{EABB}\x{EABC}\x{EABD}\x{EABE}\x{EABF}\x{EAC0}\x{EAC1}\x{EAC2}\x{EAC3}\x{EAC4}\x{EAC5}\x{EAC6}\x{EAC7}\x{EAC8}\x{EAC9}\x{EACA}\x{EACB}\x{EACC}\x{EACD}\x{EACE}\x{EACF}\x{EAD0}\x{EAD1}\x{EAD2}\x{EAD3}\x{EAD4}\x{EAD5}\x{EAD6}\x{EAD7}\x{EAD8}\x{EAD9}\x{EADA}\x{EADB}\x{EADC}\x{EADD}\x{EADE}\x{EADF}\x{EAE0}\x{EAE1}\x{EAE2}\x{EAE3}\x{EAE4}\x{EAE5}\x{EAE6}\x{EAE7}\x{EAE8}\x{EAE9}\x{EAEA}\x{EAEB}\x{EAEC}\x{EAED}\x{EAEE}\x{EAEF}\x{EAF0}\x{EAF1}\x{EAF2}\x{EAF3}\x{EAF4}\x{EAF5}\x{EAF6}\x{EAF7}\x{EAF8}\x{EAF9}\x{EAFA}\x{EB0E}\x{EB0F}\x{EB10}\x{EB11}\x{EB12}\x{EB13}\x{EB14}\x{EB15}\x{EB16}\x{EB17}\x{EB18}\x{EB19}\x{EB1A}\x{EB1B}\x{EB1C}\x{EB1D}\x{EB1E}\x{EB1F}\x{EB20}\x{EB21}\x{EB22}\x{EB23}\x{EB24}\x{EB25}\x{EB26}\x{EB27}\x{EB28}\x{EB29}\x{EB2A}\x{EB2B}\x{EB2C}\x{EB2D}\x{EB2E}\x{EB2F}\x{EB30}\x{EB31}\x{EB32}\x{EB33}\x{EB34}\x{EB35}\x{EB36}\x{EB37}\x{EB38}\x{EB39}\x{EB3A}\x{EB3B}\x{EB3C}\x{EB3D}\x{EB3E}\x{EB3F}\x{EB40}\x{EB41}\x{EB42}\x{EB43}\x{EB44}\x{EB45}\x{EB46}\x{EB47}\x{EB48}\x{EB49}\x{EB4A}\x{EB4B}\x{EB4C}\x{EB4D}\x{EB4E}\x{EB4F}\x{EB50}\x{EB51}\x{EB52}\x{EB53}\x{EB54}\x{EB55}\x{EB56}\x{EB57}\x{EB58}\x{EB59}\x{EB5A}\x{EB5B}\x{EB5C}\x{EB5D}\x{EB5E}\x{EB5F}\x{EB60}\x{EB61}\x{EB62}\x{EB63}\x{EB64}\x{EB65}\x{EB66}\x{EB67}\x{EB68}\x{EB69}\x{EB6A}\x{EB6B}\x{EB6C}\x{EB6D}\x{EB6E}\x{EB6F}\x{EB70}\x{EB71}\x{EB72}\x{EB73}\x{EB74}\x{EB75}\x{EB76}\x{EB77}\x{EB78}\x{EB79}\x{EB7A}\x{EB7B}\x{EB7C}\x{EB7D}\x{EB7E}\x{EB7F}\x{EB80}\x{EB81}\x{EB82}\x{EB83}\x{EB84}\x{EB85}\x{EB86}\x{EB87}\x{EB88}\x{EB89}\x{EB8A}\x{EB8B}\x{EB8C}\x{EB8D}\x{EB8E}\x{EAFB}\x{EAFC}\x{EAFD}\x{EAFE}\x{EAFF}\x{EB00}\x{EB01}\x{EB02}\x{EB03}\x{EB04}\x{EB05}\x{EB06}\x{EB07}\x{EB08}\x{EB09}\x{EB0A}\x{EB0B}\x{EB0C}\x{EB0D}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}];
}

sub kddi_unicode_to_kddi_cp932 {
    $_[1] =~ tr
    [\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E5DE}\x{E5DF}\x{EA80}\x{EA81}\x{EA82}\x{EA83}\x{EA84}\x{EA85}\x{EA86}\x{EA87}\x{EA88}\x{EA89}\x{EA8A}\x{EA8B}\x{EA8C}\x{EA8D}\x{EA8E}\x{EA8F}\x{EA90}\x{EA91}\x{EA92}\x{EA93}\x{EA94}\x{EA95}\x{EA96}\x{EA97}\x{EA98}\x{EA99}\x{EA9A}\x{EA9B}\x{EA9C}\x{EA9D}\x{EA9E}\x{EA9F}\x{EAA0}\x{EAA1}\x{EAA2}\x{EAA3}\x{EAA4}\x{EAA5}\x{EAA6}\x{EAA7}\x{EAA8}\x{EAA9}\x{EAAA}\x{EAAB}\x{EAAC}\x{EAAD}\x{EAAE}\x{EAAF}\x{EAB0}\x{EAB1}\x{EAB2}\x{EAB3}\x{EAB4}\x{EAB5}\x{EAB6}\x{EAB7}\x{EAB8}\x{EAB9}\x{EABA}\x{EABB}\x{EABC}\x{EABD}\x{EABE}\x{EABF}\x{EAC0}\x{EAC1}\x{EAC2}\x{EAC3}\x{EAC4}\x{EAC5}\x{EAC6}\x{EAC7}\x{EAC8}\x{EAC9}\x{EACA}\x{EACB}\x{EACC}\x{EACD}\x{EACE}\x{EACF}\x{EAD0}\x{EAD1}\x{EAD2}\x{EAD3}\x{EAD4}\x{EAD5}\x{EAD6}\x{EAD7}\x{EAD8}\x{EAD9}\x{EADA}\x{EADB}\x{EADC}\x{EADD}\x{EADE}\x{EADF}\x{EAE0}\x{EAE1}\x{EAE2}\x{EAE3}\x{EAE4}\x{EAE5}\x{EAE6}\x{EAE7}\x{EAE8}\x{EAE9}\x{EAEA}\x{EAEB}\x{EAEC}\x{EAED}\x{EAEE}\x{EAEF}\x{EAF0}\x{EAF1}\x{EAF2}\x{EAF3}\x{EAF4}\x{EAF5}\x{EAF6}\x{EAF7}\x{EAF8}\x{EAF9}\x{EAFA}\x{EAFB}\x{EAFC}\x{EAFD}\x{EAFE}\x{EAFF}\x{EB00}\x{EB01}\x{EB02}\x{EB03}\x{EB04}\x{EB05}\x{EB06}\x{EB07}\x{EB08}\x{EB09}\x{EB0A}\x{EB0B}\x{EB0C}\x{EB0D}\x{EB0E}\x{EB0F}\x{EB10}\x{EB11}\x{EB12}\x{EB13}\x{EB14}\x{EB15}\x{EB16}\x{EB17}\x{EB18}\x{EB19}\x{EB1A}\x{EB1B}\x{EB1C}\x{EB1D}\x{EB1E}\x{EB1F}\x{EB20}\x{EB21}\x{EB22}\x{EB23}\x{EB24}\x{EB25}\x{EB26}\x{EB27}\x{EB28}\x{EB29}\x{EB2A}\x{EB2B}\x{EB2C}\x{EB2D}\x{EB2E}\x{EB2F}\x{EB30}\x{EB31}\x{EB32}\x{EB33}\x{EB34}\x{EB35}\x{EB36}\x{EB37}\x{EB38}\x{EB39}\x{EB3A}\x{EB3B}\x{EB3C}\x{EB3D}\x{EB3E}\x{EB3F}\x{EB40}\x{EB41}\x{EB42}\x{EB43}\x{EB44}\x{EB45}\x{EB46}\x{EB47}\x{EB48}\x{EB49}\x{EB4A}\x{EB4B}\x{EB4C}\x{EB4D}\x{EB4E}\x{EB4F}\x{EB50}\x{EB51}\x{EB52}\x{EB53}\x{EB54}\x{EB55}\x{EB56}\x{EB57}\x{EB58}\x{EB59}\x{EB5A}\x{EB5B}\x{EB5C}\x{EB5D}\x{EB5E}\x{EB5F}\x{EB60}\x{EB61}\x{EB62}\x{EB63}\x{EB64}\x{EB65}\x{EB66}\x{EB67}\x{EB68}\x{EB69}\x{EB6A}\x{EB6B}\x{EB6C}\x{EB6D}\x{EB6E}\x{EB6F}\x{EB70}\x{EB71}\x{EB72}\x{EB73}\x{EB74}\x{EB75}\x{EB76}\x{EB77}\x{EB78}\x{EB79}\x{EB7A}\x{EB7B}\x{EB7C}\x{EB7D}\x{EB7E}\x{EB7F}\x{EB80}\x{EB81}\x{EB82}\x{EB83}\x{EB84}\x{EB85}\x{EB86}\x{EB87}\x{EB88}\x{EB89}\x{EB8A}\x{EB8B}\x{EB8C}\x{EB8D}\x{EB8E}]
    [\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E5DE}\x{E5DF}\x{E234}\x{E235}\x{E236}\x{E237}\x{E238}\x{E239}\x{E23A}\x{E23B}\x{E23C}\x{E23D}\x{E23E}\x{E23F}\x{E240}\x{E241}\x{E242}\x{E243}\x{E244}\x{E245}\x{E246}\x{E247}\x{E248}\x{E249}\x{E24A}\x{E24B}\x{E24C}\x{E24D}\x{E24E}\x{E24F}\x{E250}\x{E251}\x{E252}\x{E253}\x{E254}\x{E255}\x{E256}\x{E257}\x{E258}\x{E259}\x{E25A}\x{E25B}\x{E25C}\x{E25D}\x{E25E}\x{E25F}\x{E260}\x{E261}\x{E262}\x{E263}\x{E264}\x{E265}\x{E266}\x{E267}\x{E268}\x{E269}\x{E26A}\x{E26B}\x{E26C}\x{E26D}\x{E26E}\x{E26F}\x{E270}\x{E271}\x{E272}\x{E273}\x{E274}\x{E275}\x{E276}\x{E277}\x{E278}\x{E279}\x{E27A}\x{E27B}\x{E27C}\x{E27D}\x{E27E}\x{E27F}\x{E280}\x{E281}\x{E282}\x{E283}\x{E284}\x{E285}\x{E286}\x{E287}\x{E288}\x{E289}\x{E28A}\x{E28B}\x{E28C}\x{E28D}\x{E28E}\x{E28F}\x{E290}\x{E291}\x{E292}\x{E293}\x{E294}\x{E295}\x{E296}\x{E297}\x{E298}\x{E299}\x{E29A}\x{E29B}\x{E29C}\x{E29D}\x{E29E}\x{E29F}\x{E2A0}\x{E2A1}\x{E2A2}\x{E2A3}\x{E2A4}\x{E2A5}\x{E2A6}\x{E2A7}\x{E2A8}\x{E2A9}\x{E2AA}\x{E2AB}\x{E2AC}\x{E2AD}\x{E2AE}\x{E2AF}\x{E2B0}\x{E2B1}\x{E2B2}\x{E2B3}\x{E2B4}\x{E2B5}\x{E2B6}\x{E2B7}\x{E2B8}\x{E2B9}\x{E2BA}\x{E2BB}\x{E2BC}\x{E2BD}\x{E2BE}\x{E2BF}\x{E2C0}\x{E2C1}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E2C2}\x{E2C3}\x{E2C4}\x{E2C5}\x{E2C6}\x{E2C7}\x{E2C8}\x{E2C9}\x{E2CA}\x{E2CB}\x{E2CC}\x{E2CD}\x{E2CE}\x{E2CF}\x{E2D0}\x{E2D1}\x{E2D2}\x{E2D3}\x{E2D4}\x{E2D5}\x{E2D6}\x{E2D7}\x{E2D8}\x{E2D9}\x{E2DA}\x{E2DB}\x{E2DC}\x{E2DD}\x{E2DE}\x{E2DF}\x{E2E0}\x{E2E1}\x{E2E2}\x{E2E3}\x{E2E4}\x{E2E5}\x{E2E6}\x{E2E7}\x{E2E8}\x{E2E9}\x{E2EA}\x{E2EB}\x{E2EC}\x{E2ED}\x{E2EE}\x{E2EF}\x{E2F0}\x{E2F1}\x{E2F2}\x{E2F3}\x{E2F4}\x{E2F5}\x{E2F6}\x{E2F7}\x{E2F8}\x{E2F9}\x{E2FA}\x{E2FB}\x{E2FC}\x{E2FD}\x{E2FE}\x{E2FF}\x{E300}\x{E301}\x{E302}\x{E303}\x{E304}\x{E305}\x{E306}\x{E307}\x{E308}\x{E309}\x{E30A}\x{E30B}\x{E30C}\x{E30D}\x{E30E}\x{E30F}\x{E310}\x{E311}\x{E312}\x{E313}\x{E314}\x{E315}\x{E316}\x{E317}\x{E318}\x{E319}\x{E31A}\x{E31B}\x{E31C}\x{E31D}\x{E31E}\x{E31F}\x{E320}\x{E321}\x{E322}\x{E323}\x{E324}\x{E325}\x{E326}\x{E327}\x{E328}\x{E329}\x{E32A}\x{E32B}\x{E32C}\x{E32D}\x{E32E}\x{E32F}\x{E330}\x{E331}\x{E332}\x{E333}\x{E334}\x{E335}\x{E336}\x{E337}\x{E338}\x{E339}\x{E33A}\x{E33B}\x{E33C}\x{E33D}\x{E33E}\x{E33F}\x{E340}\x{E341}\x{E342}];
}

sub softbank_cp932_to_softbank_unicode {
    $_[1] =~ tr
    [\x{52AF}\x{6DAC}\x{6DCF}\x{6DF2}\x{6DF8}\x{6DFC}\x{6E27}\x{6E39}\x{6E3C}\x{6E5C}\x{6EBF}\x{6F88}\x{6FB5}\x{6FF5}\x{7005}\x{7007}\x{7028}\x{7085}\x{70AB}\x{7104}\x{710F}\x{7146}\x{7147}\x{715C}\x{71C1}\x{71FE}\x{72B1}\x{72BE}\x{7324}\x{7377}\x{73BD}\x{73C9}\x{73D2}\x{73D6}\x{73E3}\x{73F5}\x{7407}\x{7426}\x{7429}\x{742A}\x{742E}\x{7462}\x{7489}\x{749F}\x{7501}\x{756F}\x{7682}\x{769B}\x{769C}\x{769E}\x{76A6}\x{7746}\x{7821}\x{784E}\x{7864}\x{787A}\x{7930}\x{7994}\x{799B}\x{7AD1}\x{7AE7}\x{7AEB}\x{7B9E}\x{7D48}\x{7D5C}\x{7DA0}\x{7DB7}\x{8807}\x{88F5}\x{8A12}\x{8A37}\x{8A79}\x{8AA7}\x{8ABE}\x{8ADF}\x{8AF6}\x{8B53}\x{8B7F}\x{8CF0}\x{8CF4}\x{8D12}\x{8D76}\x{8ECF}\x{9067}\x{90DE}\x{9115}\x{9127}\x{91D7}\x{91DA}\x{91DE}\x{91E4}\x{91E5}\x{91ED}\x{91EE}\x{9206}\x{920A}\x{9210}\x{9239}\x{923A}\x{923C}\x{9240}\x{924E}\x{9251}\x{9259}\x{9267}\x{9277}\x{9278}\x{92A7}\x{92D0}\x{92D3}\x{92D5}\x{92D7}\x{92D9}\x{92E0}\x{92E7}\x{92FB}\x{92FF}\x{9302}\x{931D}\x{931E}\x{9321}\x{9325}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}\x{E53F}\x{E540}\x{E541}\x{E542}\x{E543}\x{E544}\x{E545}\x{E546}\x{E547}\x{E548}\x{E549}\x{E54A}\x{E54B}\x{E54C}\x{E54D}\x{E54E}\x{E54F}\x{E550}\x{E551}\x{E552}\x{E553}\x{E554}\x{E555}\x{E556}\x{E557}\x{E558}\x{E559}\x{E55A}\x{E55B}\x{E55C}\x{E55D}\x{E55E}\x{E55F}\x{E560}\x{E561}\x{E562}\x{E563}\x{E564}\x{E565}\x{E566}\x{E567}\x{E568}\x{E569}\x{E56A}\x{E56B}\x{E56C}\x{E56D}\x{E56E}\x{E56F}\x{E570}\x{E571}\x{E572}\x{E573}\x{E574}\x{E575}\x{E576}\x{E577}\x{E578}\x{E579}\x{E57A}\x{E57B}\x{E57C}\x{E57D}\x{E57E}\x{E584}\x{E585}\x{E586}\x{E587}\x{E588}\x{E589}\x{E58A}\x{E58B}\x{E58C}\x{E58D}\x{E58E}\x{E58F}\x{E590}\x{E591}\x{E592}\x{E593}\x{E594}\x{E595}\x{E596}\x{E597}\x{E598}\x{E599}\x{E59A}\x{E59B}\x{E59C}\x{E59D}\x{E59E}\x{E59F}\x{E5A0}\x{E5A1}\x{E5A2}\x{E5A3}\x{E5A4}\x{E5A5}\x{E5A6}\x{E5A7}\x{E5A8}\x{E5A9}\x{E5AA}\x{E5AB}\x{E5AC}\x{E5AD}\x{E5AE}\x{E5AF}\x{E5B0}\x{E5B1}\x{E5B2}\x{E5B3}\x{E5B4}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E69D}\x{E69E}\x{E69F}\x{E6A0}\x{E6A1}\x{E6A2}\x{E6A3}\x{E6A4}\x{E6A5}\x{E6A6}\x{E6A7}\x{E6A8}\x{E6A9}\x{E6AA}\x{E6AB}\x{E6AC}\x{E6AD}\x{E6AE}\x{E6AF}\x{E6B0}\x{E6B1}\x{E6B2}\x{E6B3}\x{E6B4}\x{E6B5}\x{E6B6}\x{E6B7}\x{E6B8}\x{E6B9}\x{E6BA}\x{E6BB}\x{E6BC}\x{E6BD}\x{E6BE}\x{E6BF}\x{E6C0}\x{E6C1}\x{E6C2}\x{E6C3}\x{E6C4}\x{E6C5}\x{E6C6}\x{E6C7}\x{E6C8}\x{E6C9}\x{E6CA}\x{E6CB}\x{E6CC}\x{E6CD}\x{E6CE}\x{E6CF}\x{E6D0}\x{E6D1}\x{E6D2}\x{E6D3}\x{E6D4}\x{E6D5}\x{E6D6}\x{E6D7}\x{E6D8}\x{E6D9}\x{E6DA}\x{E6DB}\x{E6DC}\x{E6DD}\x{E6DE}\x{E6DF}\x{E6E0}\x{E6E1}\x{E6E2}\x{E6E3}\x{E6E4}\x{E6E5}\x{E6E6}\x{E6E7}\x{E6E8}\x{E6E9}\x{E6EA}\x{E6EB}\x{E6EC}\x{E6ED}\x{E6EE}\x{E6EF}\x{E6F0}\x{E6F1}\x{E6F2}\x{E6F3}\x{E6F4}\x{E6F5}\x{E6F6}\x{E6FC}\x{E6FD}\x{E6FE}\x{E6FF}\x{E700}\x{E701}\x{E702}\x{E703}\x{E704}\x{E705}\x{E706}\x{E707}\x{E708}\x{E709}\x{E70A}\x{E70B}\x{E70C}\x{E70D}\x{E70E}\x{E70F}\x{E710}\x{E711}\x{E712}\x{E713}\x{E714}\x{E715}\x{E716}\x{E717}\x{E718}\x{E719}\x{E71A}\x{E71B}\x{E71C}\x{E71D}\x{E71E}\x{E71F}\x{E720}\x{E721}\x{E722}\x{E723}\x{E724}\x{E725}\x{E726}\x{E727}\x{E728}\x{E729}\x{E72A}\x{E72B}\x{E72C}\x{E72D}\x{E72E}\x{E72F}\x{E730}\x{E731}\x{E732}\x{E733}\x{E734}\x{E735}\x{E736}\x{E737}\x{E738}\x{E739}\x{E73A}\x{E73B}\x{E73C}\x{E73D}\x{E73E}\x{E73F}\x{E740}\x{E741}\x{E742}\x{E743}\x{E744}\x{E745}\x{E746}\x{E747}\x{E748}\x{FA15}\x{FA16}\x{FA17}\x{FA18}\x{FA19}\x{FA1A}\x{FA1B}\x{FA1C}\x{FA1D}\x{FA22}\x{FA23}\x{FA24}\x{FA25}\x{FA26}\x{FA27}\x{FA28}]
    [\x{E437}\x{E401}\x{E402}\x{E404}\x{E403}\x{E405}\x{E408}\x{E406}\x{E409}\x{E407}\x{E40A}\x{E40B}\x{E40C}\x{E40D}\x{E40E}\x{E40F}\x{E410}\x{E411}\x{E412}\x{E414}\x{E413}\x{E416}\x{E417}\x{E415}\x{E419}\x{E41A}\x{E41B}\x{E41C}\x{E41D}\x{E41F}\x{E420}\x{E421}\x{E424}\x{E422}\x{E423}\x{E426}\x{E425}\x{E427}\x{E429}\x{E428}\x{E42A}\x{E42B}\x{E42C}\x{E42D}\x{E42E}\x{E42F}\x{E430}\x{E433}\x{E431}\x{E432}\x{E434}\x{E436}\x{E438}\x{E439}\x{E43A}\x{E43B}\x{E43C}\x{E440}\x{E442}\x{E443}\x{E444}\x{E446}\x{E447}\x{E449}\x{E44A}\x{E44C}\x{E44B}\x{E501}\x{E502}\x{E503}\x{E504}\x{E505}\x{E506}\x{E507}\x{E508}\x{E50A}\x{E50B}\x{E50C}\x{E50D}\x{E50E}\x{E50F}\x{E510}\x{E512}\x{E515}\x{E516}\x{E518}\x{E519}\x{E51B}\x{E51A}\x{E51C}\x{E51F}\x{E520}\x{E51D}\x{E51E}\x{E521}\x{E523}\x{E522}\x{E52A}\x{E524}\x{E526}\x{E525}\x{E527}\x{E529}\x{E528}\x{E52B}\x{E52D}\x{E52E}\x{E52C}\x{E532}\x{E536}\x{E534}\x{E530}\x{E531}\x{E535}\x{E52F}\x{E539}\x{E53C}\x{E53E}\x{E53D}\x{E53B}\x{E538}\x{E537}\x{E101}\x{E102}\x{E103}\x{E104}\x{E105}\x{E106}\x{E107}\x{E108}\x{E109}\x{E10A}\x{E10B}\x{E10C}\x{E10D}\x{E10E}\x{E10F}\x{E110}\x{E111}\x{E112}\x{E113}\x{E114}\x{E115}\x{E116}\x{E117}\x{E118}\x{E119}\x{E11A}\x{E11B}\x{E11C}\x{E11D}\x{E11E}\x{E11F}\x{E120}\x{E121}\x{E122}\x{E123}\x{E124}\x{E125}\x{E126}\x{E127}\x{E128}\x{E129}\x{E12A}\x{E12B}\x{E12C}\x{E12D}\x{E12E}\x{E12F}\x{E130}\x{E131}\x{E132}\x{E133}\x{E134}\x{E135}\x{E136}\x{E137}\x{E138}\x{E139}\x{E13A}\x{E13B}\x{E13C}\x{E13D}\x{E13E}\x{E13F}\x{E140}\x{E141}\x{E142}\x{E143}\x{E144}\x{E145}\x{E146}\x{E147}\x{E148}\x{E149}\x{E14A}\x{E14B}\x{E14C}\x{E14D}\x{E14E}\x{E14F}\x{E150}\x{E151}\x{E152}\x{E153}\x{E154}\x{E155}\x{E156}\x{E157}\x{E158}\x{E159}\x{E15A}\x{E201}\x{E202}\x{E203}\x{E204}\x{E205}\x{E206}\x{E207}\x{E208}\x{E209}\x{E20A}\x{E20B}\x{E20C}\x{E20D}\x{E20E}\x{E20F}\x{E210}\x{E211}\x{E212}\x{E213}\x{E214}\x{E215}\x{E216}\x{E217}\x{E218}\x{E219}\x{E21A}\x{E21B}\x{E21C}\x{E21D}\x{E21E}\x{E21F}\x{E220}\x{E221}\x{E222}\x{E223}\x{E224}\x{E225}\x{E226}\x{E227}\x{E228}\x{E229}\x{E22A}\x{E22B}\x{E22C}\x{E22D}\x{E22E}\x{E22F}\x{E230}\x{E231}\x{E232}\x{E233}\x{E234}\x{E235}\x{E236}\x{E237}\x{E238}\x{E239}\x{E23A}\x{E23B}\x{E23C}\x{E23D}\x{E23E}\x{E23F}\x{E240}\x{E241}\x{E242}\x{E243}\x{E244}\x{E245}\x{E246}\x{E247}\x{E248}\x{E249}\x{E24A}\x{E24B}\x{E24C}\x{E24D}\x{E24E}\x{E24F}\x{E250}\x{E251}\x{E252}\x{E253}\x{E254}\x{E255}\x{E256}\x{E257}\x{E258}\x{E259}\x{E25A}\x{E001}\x{E002}\x{E003}\x{E004}\x{E005}\x{E006}\x{E007}\x{E008}\x{E009}\x{E00A}\x{E00B}\x{E00C}\x{E00D}\x{E00E}\x{E00F}\x{E010}\x{E011}\x{E012}\x{E013}\x{E014}\x{E015}\x{E016}\x{E017}\x{E018}\x{E019}\x{E01A}\x{E01B}\x{E01C}\x{E01D}\x{E01E}\x{E01F}\x{E020}\x{E021}\x{E022}\x{E023}\x{E024}\x{E025}\x{E026}\x{E027}\x{E028}\x{E029}\x{E02A}\x{E02B}\x{E02C}\x{E02D}\x{E02E}\x{E02F}\x{E030}\x{E031}\x{E032}\x{E033}\x{E034}\x{E035}\x{E036}\x{E037}\x{E038}\x{E039}\x{E03A}\x{E03B}\x{E03C}\x{E03D}\x{E03E}\x{E03F}\x{E040}\x{E041}\x{E042}\x{E043}\x{E044}\x{E045}\x{E046}\x{E047}\x{E048}\x{E049}\x{E04A}\x{E04B}\x{E04C}\x{E04D}\x{E04E}\x{E04F}\x{E050}\x{E051}\x{E052}\x{E053}\x{E054}\x{E055}\x{E056}\x{E057}\x{E058}\x{E059}\x{E05A}\x{E301}\x{E302}\x{E303}\x{E304}\x{E305}\x{E306}\x{E307}\x{E308}\x{E309}\x{E30A}\x{E30B}\x{E30C}\x{E30D}\x{E30E}\x{E30F}\x{E310}\x{E311}\x{E312}\x{E313}\x{E314}\x{E315}\x{E316}\x{E317}\x{E318}\x{E319}\x{E31A}\x{E31B}\x{E31C}\x{E31D}\x{E31E}\x{E31F}\x{E320}\x{E321}\x{E322}\x{E323}\x{E324}\x{E325}\x{E326}\x{E327}\x{E328}\x{E329}\x{E32A}\x{E32B}\x{E32C}\x{E32D}\x{E32E}\x{E32F}\x{E330}\x{E331}\x{E332}\x{E333}\x{E334}\x{E335}\x{E336}\x{E337}\x{E338}\x{E339}\x{E33A}\x{E33B}\x{E33C}\x{E33D}\x{E33E}\x{E33F}\x{E340}\x{E341}\x{E342}\x{E343}\x{E344}\x{E345}\x{E346}\x{E347}\x{E348}\x{E349}\x{E34A}\x{E34B}\x{E34C}\x{E34D}\x{E418}\x{E41E}\x{E435}\x{E43D}\x{E43E}\x{E43F}\x{E441}\x{E445}\x{E448}\x{E509}\x{E511}\x{E513}\x{E514}\x{E517}\x{E533}\x{E53A}];
}

sub softbank_unicode_to_softbank_cp932 {
    $_[1] =~ tr
    [\x{E001}\x{E002}\x{E003}\x{E004}\x{E005}\x{E006}\x{E007}\x{E008}\x{E009}\x{E00A}\x{E00B}\x{E00C}\x{E00D}\x{E00E}\x{E00F}\x{E010}\x{E011}\x{E012}\x{E013}\x{E014}\x{E015}\x{E016}\x{E017}\x{E018}\x{E019}\x{E01A}\x{E01B}\x{E01C}\x{E01D}\x{E01E}\x{E01F}\x{E020}\x{E021}\x{E022}\x{E023}\x{E024}\x{E025}\x{E026}\x{E027}\x{E028}\x{E029}\x{E02A}\x{E02B}\x{E02C}\x{E02D}\x{E02E}\x{E02F}\x{E030}\x{E031}\x{E032}\x{E033}\x{E034}\x{E035}\x{E036}\x{E037}\x{E038}\x{E039}\x{E03A}\x{E03B}\x{E03C}\x{E03D}\x{E03E}\x{E03F}\x{E040}\x{E041}\x{E042}\x{E043}\x{E044}\x{E045}\x{E046}\x{E047}\x{E048}\x{E049}\x{E04A}\x{E04B}\x{E04C}\x{E04D}\x{E04E}\x{E04F}\x{E050}\x{E051}\x{E052}\x{E053}\x{E054}\x{E055}\x{E056}\x{E057}\x{E058}\x{E059}\x{E05A}\x{E101}\x{E102}\x{E103}\x{E104}\x{E105}\x{E106}\x{E107}\x{E108}\x{E109}\x{E10A}\x{E10B}\x{E10C}\x{E10D}\x{E10E}\x{E10F}\x{E110}\x{E111}\x{E112}\x{E113}\x{E114}\x{E115}\x{E116}\x{E117}\x{E118}\x{E119}\x{E11A}\x{E11B}\x{E11C}\x{E11D}\x{E11E}\x{E11F}\x{E120}\x{E121}\x{E122}\x{E123}\x{E124}\x{E125}\x{E126}\x{E127}\x{E128}\x{E129}\x{E12A}\x{E12B}\x{E12C}\x{E12D}\x{E12E}\x{E12F}\x{E130}\x{E131}\x{E132}\x{E133}\x{E134}\x{E135}\x{E136}\x{E137}\x{E138}\x{E139}\x{E13A}\x{E13B}\x{E13C}\x{E13D}\x{E13E}\x{E13F}\x{E140}\x{E141}\x{E142}\x{E143}\x{E144}\x{E145}\x{E146}\x{E147}\x{E148}\x{E149}\x{E14A}\x{E14B}\x{E14C}\x{E14D}\x{E14E}\x{E14F}\x{E150}\x{E151}\x{E152}\x{E153}\x{E154}\x{E155}\x{E156}\x{E157}\x{E158}\x{E159}\x{E15A}\x{E201}\x{E202}\x{E203}\x{E204}\x{E205}\x{E206}\x{E207}\x{E208}\x{E209}\x{E20A}\x{E20B}\x{E20C}\x{E20D}\x{E20E}\x{E20F}\x{E210}\x{E211}\x{E212}\x{E213}\x{E214}\x{E215}\x{E216}\x{E217}\x{E218}\x{E219}\x{E21A}\x{E21B}\x{E21C}\x{E21D}\x{E21E}\x{E21F}\x{E220}\x{E221}\x{E222}\x{E223}\x{E224}\x{E225}\x{E226}\x{E227}\x{E228}\x{E229}\x{E22A}\x{E22B}\x{E22C}\x{E22D}\x{E22E}\x{E22F}\x{E230}\x{E231}\x{E232}\x{E233}\x{E234}\x{E235}\x{E236}\x{E237}\x{E238}\x{E239}\x{E23A}\x{E23B}\x{E23C}\x{E23D}\x{E23E}\x{E23F}\x{E240}\x{E241}\x{E242}\x{E243}\x{E244}\x{E245}\x{E246}\x{E247}\x{E248}\x{E249}\x{E24A}\x{E24B}\x{E24C}\x{E24D}\x{E24E}\x{E24F}\x{E250}\x{E251}\x{E252}\x{E253}\x{E254}\x{E255}\x{E256}\x{E257}\x{E258}\x{E259}\x{E25A}\x{E301}\x{E302}\x{E303}\x{E304}\x{E305}\x{E306}\x{E307}\x{E308}\x{E309}\x{E30A}\x{E30B}\x{E30C}\x{E30D}\x{E30E}\x{E30F}\x{E310}\x{E311}\x{E312}\x{E313}\x{E314}\x{E315}\x{E316}\x{E317}\x{E318}\x{E319}\x{E31A}\x{E31B}\x{E31C}\x{E31D}\x{E31E}\x{E31F}\x{E320}\x{E321}\x{E322}\x{E323}\x{E324}\x{E325}\x{E326}\x{E327}\x{E328}\x{E329}\x{E32A}\x{E32B}\x{E32C}\x{E32D}\x{E32E}\x{E32F}\x{E330}\x{E331}\x{E332}\x{E333}\x{E334}\x{E335}\x{E336}\x{E337}\x{E338}\x{E339}\x{E33A}\x{E33B}\x{E33C}\x{E33D}\x{E33E}\x{E33F}\x{E340}\x{E341}\x{E342}\x{E343}\x{E344}\x{E345}\x{E346}\x{E347}\x{E348}\x{E349}\x{E34A}\x{E34B}\x{E34C}\x{E34D}\x{E401}\x{E402}\x{E403}\x{E404}\x{E405}\x{E406}\x{E407}\x{E408}\x{E409}\x{E40A}\x{E40B}\x{E40C}\x{E40D}\x{E40E}\x{E40F}\x{E410}\x{E411}\x{E412}\x{E413}\x{E414}\x{E415}\x{E416}\x{E417}\x{E418}\x{E419}\x{E41A}\x{E41B}\x{E41C}\x{E41D}\x{E41E}\x{E41F}\x{E420}\x{E421}\x{E422}\x{E423}\x{E424}\x{E425}\x{E426}\x{E427}\x{E428}\x{E429}\x{E42A}\x{E42B}\x{E42C}\x{E42D}\x{E42E}\x{E42F}\x{E430}\x{E431}\x{E432}\x{E433}\x{E434}\x{E435}\x{E436}\x{E437}\x{E438}\x{E439}\x{E43A}\x{E43B}\x{E43C}\x{E43D}\x{E43E}\x{E43F}\x{E440}\x{E441}\x{E442}\x{E443}\x{E444}\x{E445}\x{E446}\x{E447}\x{E448}\x{E449}\x{E44A}\x{E44B}\x{E44C}\x{E501}\x{E502}\x{E503}\x{E504}\x{E505}\x{E506}\x{E507}\x{E508}\x{E509}\x{E50A}\x{E50B}\x{E50C}\x{E50D}\x{E50E}\x{E50F}\x{E510}\x{E511}\x{E512}\x{E513}\x{E514}\x{E515}\x{E516}\x{E517}\x{E518}\x{E519}\x{E51A}\x{E51B}\x{E51C}\x{E51D}\x{E51E}\x{E51F}\x{E520}\x{E521}\x{E522}\x{E523}\x{E524}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}]
    [\x{E69D}\x{E69E}\x{E69F}\x{E6A0}\x{E6A1}\x{E6A2}\x{E6A3}\x{E6A4}\x{E6A5}\x{E6A6}\x{E6A7}\x{E6A8}\x{E6A9}\x{E6AA}\x{E6AB}\x{E6AC}\x{E6AD}\x{E6AE}\x{E6AF}\x{E6B0}\x{E6B1}\x{E6B2}\x{E6B3}\x{E6B4}\x{E6B5}\x{E6B6}\x{E6B7}\x{E6B8}\x{E6B9}\x{E6BA}\x{E6BB}\x{E6BC}\x{E6BD}\x{E6BE}\x{E6BF}\x{E6C0}\x{E6C1}\x{E6C2}\x{E6C3}\x{E6C4}\x{E6C5}\x{E6C6}\x{E6C7}\x{E6C8}\x{E6C9}\x{E6CA}\x{E6CB}\x{E6CC}\x{E6CD}\x{E6CE}\x{E6CF}\x{E6D0}\x{E6D1}\x{E6D2}\x{E6D3}\x{E6D4}\x{E6D5}\x{E6D6}\x{E6D7}\x{E6D8}\x{E6D9}\x{E6DA}\x{E6DB}\x{E6DC}\x{E6DD}\x{E6DE}\x{E6DF}\x{E6E0}\x{E6E1}\x{E6E2}\x{E6E3}\x{E6E4}\x{E6E5}\x{E6E6}\x{E6E7}\x{E6E8}\x{E6E9}\x{E6EA}\x{E6EB}\x{E6EC}\x{E6ED}\x{E6EE}\x{E6EF}\x{E6F0}\x{E6F1}\x{E6F2}\x{E6F3}\x{E6F4}\x{E6F5}\x{E6F6}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}\x{E53F}\x{E540}\x{E541}\x{E542}\x{E543}\x{E544}\x{E545}\x{E546}\x{E547}\x{E548}\x{E549}\x{E54A}\x{E54B}\x{E54C}\x{E54D}\x{E54E}\x{E54F}\x{E550}\x{E551}\x{E552}\x{E553}\x{E554}\x{E555}\x{E556}\x{E557}\x{E558}\x{E559}\x{E55A}\x{E55B}\x{E55C}\x{E55D}\x{E55E}\x{E55F}\x{E560}\x{E561}\x{E562}\x{E563}\x{E564}\x{E565}\x{E566}\x{E567}\x{E568}\x{E569}\x{E56A}\x{E56B}\x{E56C}\x{E56D}\x{E56E}\x{E56F}\x{E570}\x{E571}\x{E572}\x{E573}\x{E574}\x{E575}\x{E576}\x{E577}\x{E578}\x{E579}\x{E57A}\x{E57B}\x{E57C}\x{E57D}\x{E57E}\x{E584}\x{E585}\x{E586}\x{E587}\x{E588}\x{E589}\x{E58A}\x{E58B}\x{E58C}\x{E58D}\x{E58E}\x{E58F}\x{E590}\x{E591}\x{E592}\x{E593}\x{E594}\x{E595}\x{E596}\x{E597}\x{E598}\x{E599}\x{E59A}\x{E59B}\x{E59C}\x{E59D}\x{E59E}\x{E59F}\x{E5A0}\x{E5A1}\x{E5A2}\x{E5A3}\x{E5A4}\x{E5A5}\x{E5A6}\x{E5A7}\x{E5A8}\x{E5A9}\x{E5AA}\x{E5AB}\x{E5AC}\x{E5AD}\x{E5AE}\x{E5AF}\x{E5B0}\x{E5B1}\x{E5B2}\x{E5B3}\x{E5B4}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E6FC}\x{E6FD}\x{E6FE}\x{E6FF}\x{E700}\x{E701}\x{E702}\x{E703}\x{E704}\x{E705}\x{E706}\x{E707}\x{E708}\x{E709}\x{E70A}\x{E70B}\x{E70C}\x{E70D}\x{E70E}\x{E70F}\x{E710}\x{E711}\x{E712}\x{E713}\x{E714}\x{E715}\x{E716}\x{E717}\x{E718}\x{E719}\x{E71A}\x{E71B}\x{E71C}\x{E71D}\x{E71E}\x{E71F}\x{E720}\x{E721}\x{E722}\x{E723}\x{E724}\x{E725}\x{E726}\x{E727}\x{E728}\x{E729}\x{E72A}\x{E72B}\x{E72C}\x{E72D}\x{E72E}\x{E72F}\x{E730}\x{E731}\x{E732}\x{E733}\x{E734}\x{E735}\x{E736}\x{E737}\x{E738}\x{E739}\x{E73A}\x{E73B}\x{E73C}\x{E73D}\x{E73E}\x{E73F}\x{E740}\x{E741}\x{E742}\x{E743}\x{E744}\x{E745}\x{E746}\x{E747}\x{E748}\x{6DAC}\x{6DCF}\x{6DF8}\x{6DF2}\x{6DFC}\x{6E39}\x{6E5C}\x{6E27}\x{6E3C}\x{6EBF}\x{6F88}\x{6FB5}\x{6FF5}\x{7005}\x{7007}\x{7028}\x{7085}\x{70AB}\x{710F}\x{7104}\x{715C}\x{7146}\x{7147}\x{FA15}\x{71C1}\x{71FE}\x{72B1}\x{72BE}\x{7324}\x{FA16}\x{7377}\x{73BD}\x{73C9}\x{73D6}\x{73E3}\x{73D2}\x{7407}\x{73F5}\x{7426}\x{742A}\x{7429}\x{742E}\x{7462}\x{7489}\x{749F}\x{7501}\x{756F}\x{7682}\x{769C}\x{769E}\x{769B}\x{76A6}\x{FA17}\x{7746}\x{52AF}\x{7821}\x{784E}\x{7864}\x{787A}\x{7930}\x{FA18}\x{FA19}\x{FA1A}\x{7994}\x{FA1B}\x{799B}\x{7AD1}\x{7AE7}\x{FA1C}\x{7AEB}\x{7B9E}\x{FA1D}\x{7D48}\x{7D5C}\x{7DB7}\x{7DA0}\x{8807}\x{88F5}\x{8A12}\x{8A37}\x{8A79}\x{8AA7}\x{8ABE}\x{8ADF}\x{FA22}\x{8AF6}\x{8B53}\x{8B7F}\x{8CF0}\x{8CF4}\x{8D12}\x{8D76}\x{FA23}\x{8ECF}\x{FA24}\x{FA25}\x{9067}\x{90DE}\x{FA26}\x{9115}\x{9127}\x{91DA}\x{91D7}\x{91DE}\x{91ED}\x{91EE}\x{91E4}\x{91E5}\x{9206}\x{9210}\x{920A}\x{923A}\x{9240}\x{923C}\x{924E}\x{9259}\x{9251}\x{9239}\x{9267}\x{92A7}\x{9277}\x{9278}\x{92E7}\x{92D7}\x{92D9}\x{92D0}\x{FA27}\x{92D5}\x{92E0}\x{92D3}\x{9325}\x{9321}\x{92FB}\x{FA28}\x{931E}\x{92FF}\x{931D}\x{9302}];
}

sub docomo_cp932_to_google_unicode {
    $_[1] =~ tr
    [\x{E63E}\x{E63F}\x{E640}\x{E641}\x{E642}\x{E643}\x{E644}\x{E645}\x{E646}\x{E647}\x{E648}\x{E649}\x{E64A}\x{E64B}\x{E64C}\x{E64D}\x{E64E}\x{E64F}\x{E650}\x{E651}\x{E652}\x{E653}\x{E654}\x{E655}\x{E656}\x{E657}\x{E658}\x{E659}\x{E65A}\x{E65B}\x{E65C}\x{E65D}\x{E65E}\x{E65F}\x{E660}\x{E661}\x{E662}\x{E663}\x{E664}\x{E665}\x{E666}\x{E667}\x{E668}\x{E669}\x{E66A}\x{E66B}\x{E66C}\x{E66D}\x{E66E}\x{E66F}\x{E670}\x{E671}\x{E672}\x{E673}\x{E674}\x{E675}\x{E676}\x{E677}\x{E678}\x{E679}\x{E67A}\x{E67B}\x{E67C}\x{E67D}\x{E67E}\x{E67F}\x{E680}\x{E681}\x{E682}\x{E683}\x{E684}\x{E685}\x{E686}\x{E687}\x{E688}\x{E689}\x{E68A}\x{E68B}\x{E68C}\x{E68D}\x{E68E}\x{E68F}\x{E690}\x{E691}\x{E692}\x{E693}\x{E694}\x{E695}\x{E696}\x{E697}\x{E698}\x{E699}\x{E69A}\x{E69B}\x{E69C}\x{E69D}\x{E69E}\x{E69F}\x{E6A0}\x{E6A1}\x{E6A2}\x{E6A3}\x{E6A4}\x{E6A5}\x{E6A6}\x{E6A7}\x{E6A8}\x{E6A9}\x{E6AA}\x{E6AB}\x{E6AC}\x{E6AD}\x{E6AE}\x{E6AF}\x{E6B0}\x{E6B1}\x{E6B2}\x{E6B3}\x{E6B4}\x{E6B5}\x{E6B6}\x{E6B7}\x{E6B8}\x{E6B9}\x{E6BA}\x{E6BB}\x{E6BC}\x{E6BD}\x{E6BE}\x{E6BF}\x{E6C0}\x{E6C1}\x{E6C2}\x{E6C3}\x{E6C4}\x{E6C5}\x{E6C6}\x{E6C7}\x{E6C8}\x{E6C9}\x{E6CA}\x{E6CB}\x{E6CC}\x{E6CD}\x{E6CE}\x{E6CF}\x{E6D0}\x{E6D1}\x{E6D2}\x{E6D3}\x{E6D4}\x{E6D5}\x{E6D6}\x{E6D7}\x{E6D8}\x{E6D9}\x{E6DA}\x{E6DB}\x{E6DC}\x{E6DD}\x{E6DE}\x{E6DF}\x{E6E0}\x{E6E1}\x{E6E2}\x{E6E3}\x{E6E4}\x{E6E5}\x{E6E6}\x{E6E7}\x{E6E8}\x{E6E9}\x{E6EA}\x{E6EB}\x{E6EC}\x{E6ED}\x{E6EE}\x{E6EF}\x{E6F0}\x{E6F1}\x{E6F2}\x{E6F3}\x{E6F4}\x{E6F5}\x{E6F6}\x{E6F7}\x{E6F8}\x{E6F9}\x{E6FA}\x{E6FB}\x{E6FC}\x{E6FD}\x{E6FE}\x{E6FF}\x{E700}\x{E701}\x{E702}\x{E703}\x{E704}\x{E705}\x{E706}\x{E707}\x{E708}\x{E709}\x{E70A}\x{E70B}\x{E70C}\x{E70D}\x{E70E}\x{E70F}\x{E710}\x{E711}\x{E712}\x{E713}\x{E714}\x{E715}\x{E716}\x{E717}\x{E718}\x{E719}\x{E71A}\x{E71B}\x{E71C}\x{E71D}\x{E71E}\x{E71F}\x{E720}\x{E721}\x{E722}\x{E723}\x{E724}\x{E725}\x{E726}\x{E727}\x{E728}\x{E729}\x{E72A}\x{E72B}\x{E72C}\x{E72D}\x{E72E}\x{E72F}\x{E730}\x{E731}\x{E732}\x{E733}\x{E734}\x{E735}\x{E736}\x{E737}\x{E738}\x{E739}\x{E73A}\x{E73B}\x{E73C}\x{E73D}\x{E73E}\x{E73F}\x{E740}\x{E741}\x{E742}\x{E743}\x{E744}\x{E745}\x{E746}\x{E747}\x{E748}\x{E749}\x{E74A}\x{E74B}\x{E74C}\x{E74D}\x{E74E}\x{E74F}\x{E750}\x{E751}\x{E752}\x{E753}\x{E754}\x{E755}\x{E756}\x{E757}]
    [\x{FE000}\x{FE001}\x{FE002}\x{FE003}\x{FE004}\x{FE005}\x{FE006}\x{FE007}\x{FE02B}\x{FE02C}\x{FE02D}\x{FE02E}\x{FE02F}\x{FE030}\x{FE031}\x{FE032}\x{FE033}\x{FE034}\x{FE035}\x{FE036}\x{FE7D0}\x{FE7D1}\x{FE7D2}\x{FE7D3}\x{FE7D4}\x{FE7D5}\x{FE7D6}\x{FE7D7}\x{FE522}\x{FE7DF}\x{FE7E1}\x{FE7E2}\x{FE7E4}\x{FE7E5}\x{FE7E6}\x{FE7E8}\x{FE7E9}\x{FE4B0}\x{FE4B2}\x{FE4B3}\x{FE4B4}\x{FE4B5}\x{FE4B6}\x{FE4B7}\x{FE4B9}\x{FE7F5}\x{FE7F6}\x{FE7F7}\x{FE506}\x{FE980}\x{FE981}\x{FE982}\x{FE983}\x{FE960}\x{FE4D6}\x{FE53E}\x{FE800}\x{FE801}\x{FEAF0}\x{FE7FC}\x{FE803}\x{FE804}\x{FE805}\x{FE806}\x{FE807}\x{FEB1E}\x{FEB1F}\x{FE4EF}\x{FE4F0}\x{FE546}\x{FE50F}\x{FE510}\x{FE511}\x{FE523}\x{FE525}\x{FE527}\x{FE81C}\x{FE80A}\x{FE81D}\x{FEB1A}\x{FEB1B}\x{FEB1C}\x{FEB1D}\x{FE190}\x{FE191}\x{FEB93}\x{FEB94}\x{FEB95}\x{FEAF1}\x{FEAF2}\x{FE553}\x{FE4CD}\x{FE4CE}\x{FEB20}\x{FE011}\x{FE012}\x{FE013}\x{FE014}\x{FE015}\x{FE1B7}\x{FE1B8}\x{FE7EA}\x{FE512}\x{FEAF3}\x{FEE16}\x{FEE17}\x{FEE18}\x{FEE19}\x{FEE1A}\x{FEE1B}\x{FE808}\x{FE4F1}\x{FE536}\x{FEE1C}\x{FEE1D}\x{FE19A}\x{FE537}\x{FE008}\x{FEE1E}\x{FEE1F}\x{FEE20}\x{FE018}\x{FE019}\x{FE01A}\x{FE02A}\x{FEE21}\x{FEE22}\x{FEE23}\x{FEE24}\x{FEE25}\x{FEE26}\x{FEE27}\x{FEE28}\x{FEE29}\x{FEE2A}\x{FEE2B}\x{FEE2C}\x{FEE2D}\x{FEE2E}\x{FEE2F}\x{FEE30}\x{FEE31}\x{FEE32}\x{FEE33}\x{FE526}\x{FE52B}\x{FE528}\x{FEE10}\x{FEE11}\x{FE529}\x{FEE12}\x{FEE13}\x{FE4E2}\x{FEB21}\x{FEB81}\x{FEB82}\x{FEB83}\x{FEB84}\x{FEB85}\x{FEB36}\x{FEB22}\x{FE82B}\x{FE82C}\x{FE82D}\x{FE82E}\x{FE82F}\x{FE830}\x{FE831}\x{FE832}\x{FE833}\x{FE834}\x{FE835}\x{FE836}\x{FE837}\x{FEB0C}\x{FEB0D}\x{FEB0E}\x{FEB0F}\x{FE330}\x{FE320}\x{FE323}\x{FE33F}\x{FE324}\x{FEAF4}\x{FE813}\x{FE7FA}\x{FEB55}\x{FE823}\x{FEB60}\x{FEB56}\x{FEB57}\x{FEB96}\x{FEB58}\x{FE814}\x{FEAF5}\x{FEB59}\x{FEB04}\x{FEB05}\x{FEB06}\x{FEB5A}\x{FEB5B}\x{FEB5C}\x{FEB5D}\x{FEB07}\x{FEB08}\x{FEB27}\x{FEE14}\x{FEE15}\x{FE4CF}\x{FE4DC}\x{FE195}\x{FE4D0}\x{FE7D8}\x{FE4F2}\x{FE4F3}\x{FE4DD}\x{FE538}\x{FE824}\x{FE4C9}\x{FE539}\x{FE4D1}\x{FE825}\x{FE01B}\x{FE7EB}\x{FE984}\x{FE01D}\x{FE340}\x{FE33E}\x{FE331}\x{FE344}\x{FE33D}\x{FE326}\x{FE327}\x{FEB97}\x{FE329}\x{FE347}\x{FE332}\x{FE33C}\x{FE343}\x{FE33A}\x{FE339}\x{FEB28}\x{FE53A}\x{FEB29}\x{FEB2A}\x{FE7D9}\x{FEB2B}\x{FEB2C}\x{FEB2D}\x{FEB23}\x{FEB2E}\x{FEB2F}\x{FEB30}\x{FEB31}\x{FEAF6}\x{FEAF7}\x{FE4BA}\x{FE038}\x{FE4C3}\x{FE03C}\x{FE04F}\x{FE03D}\x{FE050}\x{FE051}\x{FE03E}\x{FE03F}\x{FE040}\x{FE961}\x{FE962}\x{FE985}\x{FE963}\x{FE964}\x{FE1B9}\x{FE1BA}\x{FE1BC}\x{FE1BD}\x{FE32B}\x{FE333}\x{FE1BE}\x{FE1BF}\x{FE986}\x{FE341}];
}

our %map_google_unicode_to_docomo_cp932 = (
    "\x{FE000}"=>"\x{E63E}", "\x{FE001}"=>"\x{E63F}", "\x{FE002}"=>"\x{E640}", "\x{FE003}"=>"\x{E641}", "\x{FE004}"=>"\x{E642}", "\x{FE005}"=>"\x{E643}", "\x{FE006}"=>"\x{E644}", "\x{FE007}"=>"\x{E645}", "\x{FE008}"=>"\x{E6B3}", "\x{FE009}"=>"\x{E63E}", "\x{FE00A}"=>"\x{E63E}", "\x{FE00C}"=>"\x{E63E}", "\x{FE00F}"=>"\x{E63E}\x{E63F}", "\x{FE010}"=>"\x{E6B3}", "\x{FE011}"=>"\x{E69C}", "\x{FE012}"=>"\x{E69D}", "\x{FE013}"=>"\x{E69E}", "\x{FE014}"=>"\x{E69F}", "\x{FE015}"=>"\x{E6A0}", "\x{FE016}"=>"\x{E69E}", "\x{FE018}"=>"\x{E6B7}", "\x{FE019}"=>"\x{E6B8}", "\x{FE01A}"=>"\x{E6B9}", "\x{FE01B}"=>"\x{E71C}", "\x{FE01C}"=>"\x{E71C}", "\x{FE01D}"=>"\x{E71F}", "\x{FE01E}"=>"\x{E6BA}", "\x{FE01F}"=>"\x{E6BA}", "\x{FE020}"=>"\x{E6BA}", "\x{FE021}"=>"\x{E6BA}", "\x{FE022}"=>"\x{E6BA}", "\x{FE023}"=>"\x{E6BA}", "\x{FE024}"=>"\x{E6BA}", "\x{FE025}"=>"\x{E6BA}", "\x{FE026}"=>"\x{E6BA}", "\x{FE027}"=>"\x{E6BA}", "\x{FE028}"=>"\x{E6BA}", "\x{FE029}"=>"\x{E6BA}", "\x{FE02A}"=>"\x{E6BA}", "\x{FE02B}"=>"\x{E646}", "\x{FE02C}"=>"\x{E647}", "\x{FE02D}"=>"\x{E648}", "\x{FE02E}"=>"\x{E649}", "\x{FE02F}"=>"\x{E64A}", "\x{FE030}"=>"\x{E64B}", "\x{FE031}"=>"\x{E64C}", "\x{FE032}"=>"\x{E64D}", "\x{FE033}"=>"\x{E64E}", "\x{FE034}"=>"\x{E64F}", "\x{FE035}"=>"\x{E650}", "\x{FE036}"=>"\x{E651}", "\x{FE038}"=>"\x{E73F}", "\x{FE03B}"=>"\x{E6B3}", "\x{FE03C}"=>"\x{E741}", "\x{FE03D}"=>"\x{E743}", "\x{FE03E}"=>"\x{E746}", "\x{FE03F}"=>"\x{E747}", "\x{FE040}"=>"\x{E748}", "\x{FE042}"=>"\x{E747}", "\x{FE04E}"=>"\x{E741}", "\x{FE04F}"=>"\x{E742}", "\x{FE050}"=>"\x{E744}", "\x{FE051}"=>"\x{E745}", "\x{FE05B}"=>"\x{E745}", "\x{FE190}"=>"\x{E691}", "\x{FE191}"=>"\x{E692}", "\x{FE193}"=>"\x{E6F9}", "\x{FE194}"=>"\x{E728}", "\x{FE195}"=>"\x{E710}", "\x{FE198}"=>"\x{E675}", "\x{FE19A}"=>"\x{E6B1}", "\x{FE19B}"=>"\x{E6F0}", "\x{FE19C}"=>"\x{E6F0}", "\x{FE19D}"=>"\x{E6F0}", "\x{FE19E}"=>"\x{E6F0}", "\x{FE1B7}"=>"\x{E6A1}", "\x{FE1B8}"=>"\x{E6A2}", "\x{FE1B9}"=>"\x{E74E}", "\x{FE1BA}"=>"\x{E74F}", "\x{FE1BB}"=>"\x{E74F}", "\x{FE1BC}"=>"\x{E750}", "\x{FE1BD}"=>"\x{E751}", "\x{FE1BE}"=>"\x{E754}", "\x{FE1BF}"=>"\x{E755}", "\x{FE1C8}"=>"\x{E74F}", "\x{FE1C9}"=>"\x{E751}", "\x{FE1D0}"=>"\x{E6A1}", "\x{FE1D8}"=>"\x{E6A1}", "\x{FE1D9}"=>"\x{E751}", "\x{FE1DB}"=>"\x{E698}", "\x{FE1DD}"=>"\x{E74F}", "\x{FE1E0}"=>"\x{E755}", "\x{FE320}"=>"\x{E6F1}", "\x{FE321}"=>"\x{E6F3}", "\x{FE322}"=>"\x{E6F4}", "\x{FE323}"=>"\x{E6F2}", "\x{FE324}"=>"\x{E6F4}", "\x{FE325}"=>"\x{E723}", "\x{FE326}"=>"\x{E725}", "\x{FE327}"=>"\x{E726}", "\x{FE328}"=>"\x{E753}", "\x{FE329}"=>"\x{E728}", "\x{FE32A}"=>"\x{E728}", "\x{FE32B}"=>"\x{E752}", "\x{FE32C}"=>"\x{E726}", "\x{FE32D}"=>"\x{E726}", "\x{FE32F}"=>"\x{E72A}", "\x{FE330}"=>"\x{E6F0}", "\x{FE331}"=>"\x{E722}", "\x{FE332}"=>"\x{E72A}", "\x{FE333}"=>"\x{E753}", "\x{FE334}"=>"\x{E72A}", "\x{FE335}"=>"\x{E6F0}", "\x{FE336}"=>"\x{E6F0}", "\x{FE337}"=>"\x{E6F0}", "\x{FE338}"=>"\x{E6F0}", "\x{FE339}"=>"\x{E72E}", "\x{FE33A}"=>"\x{E72D}", "\x{FE33B}"=>"\x{E757}", "\x{FE33C}"=>"\x{E72B}", "\x{FE33D}"=>"\x{E724}", "\x{FE33E}"=>"\x{E721}", "\x{FE33F}"=>"\x{E6F3}", "\x{FE340}"=>"\x{E720}", "\x{FE341}"=>"\x{E757}", "\x{FE342}"=>"\x{E701}", "\x{FE343}"=>"\x{E72C}", "\x{FE344}"=>"\x{E723}", "\x{FE345}"=>"\x{E723}", "\x{FE346}"=>"\x{E72B}", "\x{FE347}"=>"\x{E729}", "\x{FE348}"=>"\x{E6F0}", "\x{FE349}"=>"\x{E753}", "\x{FE34A}"=>"\x{E72A}", "\x{FE34B}"=>"\x{E726}", "\x{FE34C}"=>"\x{E726}", "\x{FE34D}"=>"\x{E72E}", "\x{FE34E}"=>"\x{E724}", "\x{FE34F}"=>"\x{E753}", "\x{FE350}"=>"\x{E6F3}", "\x{FE351}"=>"\x{E72F}", "\x{FE352}"=>"\x{E70B}", "\x{FE359}"=>"\x{E6F3}", "\x{FE35A}"=>"\x{E6F1}", "\x{FE4B0}"=>"\x{E663}", "\x{FE4B1}"=>"\x{E663}", "\x{FE4B2}"=>"\x{E664}", "\x{FE4B3}"=>"\x{E665}", "\x{FE4B4}"=>"\x{E666}", "\x{FE4B5}"=>"\x{E667}", "\x{FE4B6}"=>"\x{E668}", "\x{FE4B7}"=>"\x{E669}", "\x{FE4B8}"=>"\x{E669}\x{E6EF}", "\x{FE4B9}"=>"\x{E66A}", "\x{FE4BA}"=>"\x{E73E}", "\x{FE4C1}"=>"\x{E661}", "\x{FE4C2}"=>"\x{E74B}", "\x{FE4C3}"=>"\x{E740}", "\x{FE4C9}"=>"\x{E718}", "\x{FE4CC}"=>"\x{E699}", "\x{FE4CD}"=>"\x{E699}", "\x{FE4CE}"=>"\x{E69A}", "\x{FE4CF}"=>"\x{E70E}", "\x{FE4D0}"=>"\x{E711}", "\x{FE4D1}"=>"\x{E71A}", "\x{FE4D2}"=>"\x{E71A}", "\x{FE4D6}"=>"\x{E674}", "\x{FE4D7}"=>"\x{E674}", "\x{FE4DB}"=>"\x{E70E}", "\x{FE4DC}"=>"\x{E70F}", "\x{FE4DD}"=>"\x{E715}", "\x{FE4E0}"=>"\x{E715}", "\x{FE4E2}"=>"\x{E6D6}", "\x{FE4E3}"=>"\x{E715}", "\x{FE4EF}"=>"\x{E681}", "\x{FE4F0}"=>"\x{E682}", "\x{FE4F1}"=>"\x{E6AD}", "\x{FE4F2}"=>"\x{E713}", "\x{FE4F3}"=>"\x{E714}", "\x{FE4F9}"=>"\x{E677}", "\x{FE4FB}"=>"\x{E6FB}", "\x{FE4FD}"=>"\x{E70A}", "\x{FE4FF}"=>"\x{E683}", "\x{FE500}"=>"\x{E683}", "\x{FE501}"=>"\x{E683}", "\x{FE502}"=>"\x{E683}", "\x{FE503}"=>"\x{E683}", "\x{FE505}"=>"\x{E6F7}", "\x{FE506}"=>"\x{E66E}", "\x{FE507}"=>"\x{E66E}", "\x{FE508}"=>"\x{E66E}", "\x{FE50F}"=>"\x{E684}", "\x{FE510}"=>"\x{E685}", "\x{FE511}"=>"\x{E686}", "\x{FE512}"=>"\x{E6A4}", "\x{FE522}"=>"\x{E65A}", "\x{FE523}"=>"\x{E687}", "\x{FE524}"=>"\x{E687}", "\x{FE525}"=>"\x{E688}", "\x{FE526}"=>"\x{E6CE}", "\x{FE527}"=>"\x{E689}", "\x{FE528}"=>"\x{E6D0}", "\x{FE529}"=>"\x{E6D3}", "\x{FE52A}"=>"\x{E6CF}", "\x{FE52B}"=>"\x{E6CF}", "\x{FE52C}"=>"\x{E665}", "\x{FE52D}"=>"\x{E665}", "\x{FE52E}"=>"\x{E665}", "\x{FE535}"=>"\x{E685}", "\x{FE536}"=>"\x{E6AE}", "\x{FE537}"=>"\x{E6B2}", "\x{FE538}"=>"\x{E716}", "\x{FE539}"=>"\x{E719}", "\x{FE53A}"=>"\x{E730}", "\x{FE53B}"=>"\x{E682}", "\x{FE53E}"=>"\x{E675}", "\x{FE540}"=>"\x{E689}", "\x{FE541}"=>"\x{E689}", "\x{FE545}"=>"\x{E683}", "\x{FE546}"=>"\x{E683}", "\x{FE547}"=>"\x{E683}", "\x{FE548}"=>"\x{E689}", "\x{FE54D}"=>"\x{E683}", "\x{FE54F}"=>"\x{E683}", "\x{FE552}"=>"\x{E689}", "\x{FE553}"=>"\x{E698}", "\x{FE7D0}"=>"\x{E652}", "\x{FE7D1}"=>"\x{E653}", "\x{FE7D2}"=>"\x{E654}", "\x{FE7D3}"=>"\x{E655}", "\x{FE7D4}"=>"\x{E656}", "\x{FE7D5}"=>"\x{E657}", "\x{FE7D6}"=>"\x{E658}", "\x{FE7D7}"=>"\x{E659}", "\x{FE7D8}"=>"\x{E712}", "\x{FE7D9}"=>"\x{E733}", "\x{FE7DA}"=>"\x{E712}", "\x{FE7DC}"=>"\x{E754}", "\x{FE7DF}"=>"\x{E65B}", "\x{FE7E0}"=>"\x{E65C}", "\x{FE7E1}"=>"\x{E65C}", "\x{FE7E2}"=>"\x{E65D}", "\x{FE7E3}"=>"\x{E65D}", "\x{FE7E4}"=>"\x{E65E}", "\x{FE7E5}"=>"\x{E65F}", "\x{FE7E6}"=>"\x{E660}", "\x{FE7E8}"=>"\x{E661}", "\x{FE7E9}"=>"\x{E662}", "\x{FE7EA}"=>"\x{E6A3}", "\x{FE7EB}"=>"\x{E71D}", "\x{FE7EE}"=>"\x{E6A3}", "\x{FE7EF}"=>"\x{E65E}", "\x{FE7F0}"=>"\x{E733}", "\x{FE7F5}"=>"\x{E66B}", "\x{FE7F6}"=>"\x{E66C}", "\x{FE7F7}"=>"\x{E66D}", "\x{FE7FA}"=>"\x{E6F7}", "\x{FE7FC}"=>"\x{E679}", "\x{FE7FF}"=>"\x{E751}", "\x{FE800}"=>"\x{E676}", "\x{FE801}"=>"\x{E677}", "\x{FE802}"=>"\x{E677}", "\x{FE803}"=>"\x{E67A}", "\x{FE804}"=>"\x{E67B}", "\x{FE805}"=>"\x{E67C}", "\x{FE806}"=>"\x{E67D}", "\x{FE807}"=>"\x{E67E}", "\x{FE808}"=>"\x{E6AC}", "\x{FE80A}"=>"\x{E68B}", "\x{FE813}"=>"\x{E6F6}", "\x{FE814}"=>"\x{E6FF}", "\x{FE81A}"=>"\x{E6FF}", "\x{FE81C}"=>"\x{E68A}", "\x{FE81D}"=>"\x{E68C}", "\x{FE81E}"=>"\x{E68C}", "\x{FE823}"=>"\x{E6F9}", "\x{FE824}"=>"\x{E717}", "\x{FE825}"=>"\x{E71B}", "\x{FE826}"=>"\x{E71B}", "\x{FE827}"=>"\x{E6F9}", "\x{FE829}"=>"\x{E6ED}", "\x{FE82B}"=>"\x{E6DF}", "\x{FE82C}"=>"\x{E6E0}", "\x{FE82D}"=>"\x{E6E1}", "\x{FE82E}"=>"\x{E6E2}", "\x{FE82F}"=>"\x{E6E3}", "\x{FE830}"=>"\x{E6E4}", "\x{FE831}"=>"\x{E6E5}", "\x{FE832}"=>"\x{E6E6}", "\x{FE833}"=>"\x{E6E7}", "\x{FE834}"=>"\x{E6E8}", "\x{FE835}"=>"\x{E6E9}", "\x{FE836}"=>"\x{E6EA}", "\x{FE837}"=>"\x{E6EB}", "\x{FE960}"=>"\x{E673}", "\x{FE961}"=>"\x{E749}", "\x{FE962}"=>"\x{E74A}", "\x{FE963}"=>"\x{E74C}", "\x{FE964}"=>"\x{E74D}", "\x{FE96A}"=>"\x{E74C}", "\x{FE973}"=>"\x{E643}", "\x{FE980}"=>"\x{E66F}", "\x{FE981}"=>"\x{E670}", "\x{FE982}"=>"\x{E671}", "\x{FE983}"=>"\x{E672}", "\x{FE984}"=>"\x{E71E}", "\x{FE985}"=>"\x{E74B}", "\x{FE986}"=>"\x{E756}", "\x{FE987}"=>"\x{E672}", "\x{FE988}"=>"\x{E671}", "\x{FEAF0}"=>"\x{E678}", "\x{FEAF1}"=>"\x{E696}", "\x{FEAF2}"=>"\x{E697}", "\x{FEAF3}"=>"\x{E6A5}", "\x{FEAF4}"=>"\x{E6F5}", "\x{FEAF5}"=>"\x{E700}", "\x{FEAF6}"=>"\x{E73C}", "\x{FEAF7}"=>"\x{E73D}", "\x{FEB04}"=>"\x{E702}", "\x{FEB05}"=>"\x{E703}", "\x{FEB06}"=>"\x{E704}", "\x{FEB07}"=>"\x{E709}", "\x{FEB08}"=>"\x{E70A}", "\x{FEB0B}"=>"\x{E702}", "\x{FEB0C}"=>"\x{E6EC}", "\x{FEB0D}"=>"\x{E6ED}", "\x{FEB0E}"=>"\x{E6EE}", "\x{FEB0F}"=>"\x{E6EF}", "\x{FEB10}"=>"\x{E6EC}", "\x{FEB11}"=>"\x{E6ED}", "\x{FEB12}"=>"\x{E6EC}", "\x{FEB13}"=>"\x{E6EC}", "\x{FEB14}"=>"\x{E6EC}", "\x{FEB15}"=>"\x{E6EC}", "\x{FEB16}"=>"\x{E6EC}", "\x{FEB17}"=>"\x{E6EC}", "\x{FEB18}"=>"\x{E6ED}", "\x{FEB19}"=>"\x{E6F8}", "\x{FEB1A}"=>"\x{E68D}", "\x{FEB1B}"=>"\x{E68E}", "\x{FEB1C}"=>"\x{E68F}", "\x{FEB1D}"=>"\x{E690}", "\x{FEB1E}"=>"\x{E67F}", "\x{FEB1F}"=>"\x{E680}", "\x{FEB20}"=>"\x{E69B}", "\x{FEB21}"=>"\x{E6D7}", "\x{FEB22}"=>"\x{E6DE}", "\x{FEB23}"=>"\x{E737}", "\x{FEB26}"=>"\x{E72F}", "\x{FEB27}"=>"\x{E70B}", "\x{FEB28}"=>"\x{E72F}", "\x{FEB29}"=>"\x{E731}", "\x{FEB2A}"=>"\x{E732}", "\x{FEB2B}"=>"\x{E734}", "\x{FEB2C}"=>"\x{E735}", "\x{FEB2D}"=>"\x{E736}", "\x{FEB2E}"=>"\x{E738}", "\x{FEB2F}"=>"\x{E739}", "\x{FEB30}"=>"\x{E73A}", "\x{FEB31}"=>"\x{E73B}", "\x{FEB36}"=>"\x{E6DD}", "\x{FEB44}"=>"\x{E6A0}", "\x{FEB48}"=>"\x{E738}", "\x{FEB55}"=>"\x{E6F8}", "\x{FEB56}"=>"\x{E6FB}", "\x{FEB57}"=>"\x{E6FC}", "\x{FEB58}"=>"\x{E6FE}", "\x{FEB59}"=>"\x{E701}", "\x{FEB5A}"=>"\x{E705}", "\x{FEB5B}"=>"\x{E706}", "\x{FEB5C}"=>"\x{E707}", "\x{FEB5D}"=>"\x{E708}", "\x{FEB60}"=>"\x{E6FA}", "\x{FEB61}"=>"\x{E6F8}", "\x{FEB62}"=>"\x{E6F8}", "\x{FEB63}"=>"\x{E69C}", "\x{FEB64}"=>"\x{E69C}", "\x{FEB65}"=>"\x{E69C}", "\x{FEB66}"=>"\x{E69C}", "\x{FEB67}"=>"\x{E69C}", "\x{FEB77}"=>"\x{E6FA}", "\x{FEB81}"=>"\x{E6D8}", "\x{FEB82}"=>"\x{E6D9}", "\x{FEB83}"=>"\x{E6DA}", "\x{FEB84}"=>"\x{E6DB}", "\x{FEB85}"=>"\x{E6DC}", "\x{FEB86}"=>"\x{E6D9}", "\x{FEB87}"=>"\x{E6D9}", "\x{FEB8A}"=>"\x{E6D9}", "\x{FEB8D}"=>"\x{E6DC}", "\x{FEB90}"=>"\x{E6D9}", "\x{FEB91}"=>"\x{E735}", "\x{FEB92}"=>"\x{E6D3}", "\x{FEB93}"=>"\x{E693}", "\x{FEB94}"=>"\x{E694}", "\x{FEB95}"=>"\x{E695}", "\x{FEB96}"=>"\x{E6FD}", "\x{FEB97}"=>"\x{E727}", "\x{FEB9D}"=>"\x{E695}", "\x{FEB9F}"=>"\x{E70B}", "\x{FEBA0}"=>"\x{E700}", "\x{FEBA1}"=>"\x{E695}", "\x{FEE10}"=>"\x{E6D1}", "\x{FEE11}"=>"\x{E6D2}", "\x{FEE12}"=>"\x{E6D4}", "\x{FEE13}"=>"\x{E6D5}", "\x{FEE14}"=>"\x{E70C}", "\x{FEE15}"=>"\x{E70D}", "\x{FEE16}"=>"\x{E6A6}", "\x{FEE17}"=>"\x{E6A7}", "\x{FEE18}"=>"\x{E6A8}", "\x{FEE19}"=>"\x{E6A9}", "\x{FEE1A}"=>"\x{E6AA}", "\x{FEE1B}"=>"\x{E6AB}", "\x{FEE1C}"=>"\x{E6AF}", "\x{FEE1D}"=>"\x{E6B0}", "\x{FEE1E}"=>"\x{E6B4}", "\x{FEE1F}"=>"\x{E6B5}", "\x{FEE20}"=>"\x{E6B6}", "\x{FEE21}"=>"\x{E6BB}", "\x{FEE22}"=>"\x{E6BC}", "\x{FEE23}"=>"\x{E6BD}", "\x{FEE24}"=>"\x{E6BE}", "\x{FEE25}"=>"\x{E6BF}", "\x{FEE26}"=>"\x{E6C0}", "\x{FEE27}"=>"\x{E6C1}", "\x{FEE28}"=>"\x{E6C2}", "\x{FEE29}"=>"\x{E6C3}", "\x{FEE2A}"=>"\x{E6C4}", "\x{FEE2B}"=>"\x{E6C5}", "\x{FEE2C}"=>"\x{E6C6}", "\x{FEE2D}"=>"\x{E6C7}", "\x{FEE2E}"=>"\x{E6C8}", "\x{FEE2F}"=>"\x{E6C9}", "\x{FEE30}"=>"\x{E6CA}", "\x{FEE31}"=>"\x{E6CB}", "\x{FEE32}"=>"\x{E6CC}", "\x{FEE33}"=>"\x{E6CD}"
);

sub google_unicode_to_docomo_cp932 {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_docomo_cp932{$1} || &$check(ord $1)
    }egomx;
}

sub kddi_cp932_to_google_unicode {
    $_[1] =~ tr
    [\x{E234}\x{E235}\x{E236}\x{E237}\x{E238}\x{E239}\x{E23A}\x{E23B}\x{E23C}\x{E23D}\x{E23E}\x{E23F}\x{E240}\x{E241}\x{E242}\x{E243}\x{E244}\x{E245}\x{E246}\x{E247}\x{E248}\x{E249}\x{E24A}\x{E24B}\x{E24C}\x{E24D}\x{E24E}\x{E24F}\x{E250}\x{E251}\x{E252}\x{E253}\x{E254}\x{E255}\x{E256}\x{E257}\x{E258}\x{E259}\x{E25A}\x{E25B}\x{E25C}\x{E25D}\x{E25E}\x{E25F}\x{E260}\x{E261}\x{E262}\x{E263}\x{E264}\x{E265}\x{E266}\x{E267}\x{E268}\x{E269}\x{E26A}\x{E26B}\x{E26C}\x{E26D}\x{E26E}\x{E26F}\x{E270}\x{E271}\x{E272}\x{E273}\x{E274}\x{E275}\x{E276}\x{E277}\x{E278}\x{E279}\x{E27A}\x{E27B}\x{E27C}\x{E27D}\x{E27E}\x{E27F}\x{E280}\x{E281}\x{E282}\x{E283}\x{E284}\x{E285}\x{E286}\x{E287}\x{E288}\x{E289}\x{E28A}\x{E28B}\x{E28C}\x{E28D}\x{E28E}\x{E28F}\x{E290}\x{E291}\x{E292}\x{E293}\x{E294}\x{E295}\x{E296}\x{E297}\x{E298}\x{E299}\x{E29A}\x{E29B}\x{E29C}\x{E29D}\x{E29E}\x{E29F}\x{E2A0}\x{E2A1}\x{E2A2}\x{E2A3}\x{E2A4}\x{E2A5}\x{E2A6}\x{E2A7}\x{E2A8}\x{E2A9}\x{E2AA}\x{E2AB}\x{E2AC}\x{E2AD}\x{E2AE}\x{E2AF}\x{E2B0}\x{E2B1}\x{E2B2}\x{E2B3}\x{E2B4}\x{E2B5}\x{E2B6}\x{E2B7}\x{E2B8}\x{E2B9}\x{E2BA}\x{E2BB}\x{E2BC}\x{E2BD}\x{E2BE}\x{E2BF}\x{E2C0}\x{E2C1}\x{E2C2}\x{E2C3}\x{E2C4}\x{E2C5}\x{E2C6}\x{E2C7}\x{E2C8}\x{E2C9}\x{E2CA}\x{E2CB}\x{E2CC}\x{E2CD}\x{E2CE}\x{E2CF}\x{E2D0}\x{E2D1}\x{E2D2}\x{E2D3}\x{E2D4}\x{E2D5}\x{E2D6}\x{E2D7}\x{E2D8}\x{E2D9}\x{E2DA}\x{E2DB}\x{E2DC}\x{E2DD}\x{E2DE}\x{E2DF}\x{E2E0}\x{E2E1}\x{E2E2}\x{E2E3}\x{E2E4}\x{E2E5}\x{E2E6}\x{E2E7}\x{E2E8}\x{E2E9}\x{E2EA}\x{E2EB}\x{E2EC}\x{E2ED}\x{E2EE}\x{E2EF}\x{E2F0}\x{E2F1}\x{E2F2}\x{E2F3}\x{E2F4}\x{E2F5}\x{E2F6}\x{E2F7}\x{E2F8}\x{E2F9}\x{E2FA}\x{E2FB}\x{E2FC}\x{E2FD}\x{E2FE}\x{E2FF}\x{E300}\x{E301}\x{E302}\x{E303}\x{E304}\x{E305}\x{E306}\x{E307}\x{E308}\x{E309}\x{E30A}\x{E30B}\x{E30C}\x{E30D}\x{E30E}\x{E30F}\x{E310}\x{E311}\x{E312}\x{E313}\x{E314}\x{E315}\x{E316}\x{E317}\x{E318}\x{E319}\x{E31A}\x{E31B}\x{E31C}\x{E31D}\x{E31E}\x{E31F}\x{E320}\x{E321}\x{E322}\x{E323}\x{E324}\x{E325}\x{E326}\x{E327}\x{E328}\x{E329}\x{E32A}\x{E32B}\x{E32C}\x{E32D}\x{E32E}\x{E32F}\x{E330}\x{E331}\x{E332}\x{E333}\x{E334}\x{E335}\x{E336}\x{E337}\x{E338}\x{E339}\x{E33A}\x{E33B}\x{E33C}\x{E33D}\x{E33E}\x{E33F}\x{E340}\x{E341}\x{E342}\x{E468}\x{E469}\x{E46A}\x{E46B}\x{E46C}\x{E46D}\x{E46E}\x{E46F}\x{E470}\x{E471}\x{E472}\x{E473}\x{E474}\x{E475}\x{E476}\x{E477}\x{E478}\x{E479}\x{E47A}\x{E47B}\x{E47C}\x{E47D}\x{E47E}\x{E47F}\x{E480}\x{E481}\x{E482}\x{E483}\x{E484}\x{E485}\x{E486}\x{E487}\x{E488}\x{E489}\x{E48A}\x{E48B}\x{E48C}\x{E48D}\x{E48E}\x{E48F}\x{E490}\x{E491}\x{E492}\x{E493}\x{E494}\x{E495}\x{E496}\x{E497}\x{E498}\x{E499}\x{E49A}\x{E49B}\x{E49C}\x{E49D}\x{E49E}\x{E49F}\x{E4A0}\x{E4A1}\x{E4A2}\x{E4A3}\x{E4A4}\x{E4A5}\x{E4A6}\x{E4A7}\x{E4A8}\x{E4A9}\x{E4AA}\x{E4AB}\x{E4AC}\x{E4AD}\x{E4AE}\x{E4AF}\x{E4B0}\x{E4B1}\x{E4B2}\x{E4B3}\x{E4B4}\x{E4B5}\x{E4B6}\x{E4B7}\x{E4B8}\x{E4B9}\x{E4BA}\x{E4BB}\x{E4BC}\x{E4BD}\x{E4BE}\x{E4BF}\x{E4C0}\x{E4C1}\x{E4C2}\x{E4C3}\x{E4C4}\x{E4C5}\x{E4C6}\x{E4C7}\x{E4C8}\x{E4C9}\x{E4CA}\x{E4CB}\x{E4CC}\x{E4CD}\x{E4CE}\x{E4CF}\x{E4D0}\x{E4D1}\x{E4D2}\x{E4D3}\x{E4D4}\x{E4D5}\x{E4D6}\x{E4D7}\x{E4D8}\x{E4D9}\x{E4DA}\x{E4DB}\x{E4DC}\x{E4DD}\x{E4DE}\x{E4DF}\x{E4E0}\x{E4E1}\x{E4E2}\x{E4E3}\x{E4E4}\x{E4E5}\x{E4E6}\x{E4E7}\x{E4E8}\x{E4E9}\x{E4EA}\x{E4EB}\x{E4EC}\x{E4ED}\x{E4EE}\x{E4EF}\x{E4F0}\x{E4F1}\x{E4F2}\x{E4F3}\x{E4F4}\x{E4F5}\x{E4F6}\x{E4F7}\x{E4F8}\x{E4F9}\x{E4FA}\x{E4FB}\x{E4FC}\x{E4FD}\x{E4FE}\x{E4FF}\x{E500}\x{E501}\x{E502}\x{E503}\x{E504}\x{E505}\x{E506}\x{E507}\x{E508}\x{E509}\x{E50A}\x{E50B}\x{E50C}\x{E50D}\x{E50E}\x{E50F}\x{E510}\x{E511}\x{E512}\x{E513}\x{E514}\x{E515}\x{E516}\x{E517}\x{E518}\x{E519}\x{E51A}\x{E51B}\x{E51C}\x{E51D}\x{E51E}\x{E51F}\x{E520}\x{E521}\x{E522}\x{E523}\x{E524}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}\x{E53F}\x{E540}\x{E541}\x{E542}\x{E543}\x{E544}\x{E545}\x{E546}\x{E547}\x{E548}\x{E549}\x{E54A}\x{E54B}\x{E54C}\x{E54D}\x{E54E}\x{E54F}\x{E550}\x{E551}\x{E552}\x{E553}\x{E554}\x{E555}\x{E556}\x{E557}\x{E558}\x{E559}\x{E55A}\x{E55B}\x{E55C}\x{E55D}\x{E55E}\x{E55F}\x{E560}\x{E561}\x{E562}\x{E563}\x{E564}\x{E565}\x{E566}\x{E567}\x{E568}\x{E569}\x{E56A}\x{E56B}\x{E56C}\x{E56D}\x{E56E}\x{E56F}\x{E570}\x{E571}\x{E572}\x{E573}\x{E574}\x{E575}\x{E576}\x{E577}\x{E578}\x{E579}\x{E57A}\x{E57B}\x{E57C}\x{E57D}\x{E57E}\x{E57F}\x{E580}\x{E581}\x{E582}\x{E583}\x{E584}\x{E585}\x{E586}\x{E587}\x{E588}\x{E589}\x{E58A}\x{E58B}\x{E58C}\x{E58D}\x{E58E}\x{E58F}\x{E590}\x{E591}\x{E592}\x{E593}\x{E594}\x{E595}\x{E596}\x{E597}\x{E598}\x{E599}\x{E59A}\x{E59B}\x{E59C}\x{E59D}\x{E59E}\x{E59F}\x{E5A0}\x{E5A1}\x{E5A2}\x{E5A3}\x{E5A4}\x{E5A5}\x{E5A6}\x{E5A7}\x{E5A8}\x{E5A9}\x{E5AA}\x{E5AB}\x{E5AC}\x{E5AD}\x{E5AE}\x{E5AF}\x{E5B0}\x{E5B1}\x{E5B2}\x{E5B3}\x{E5B4}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E5DE}\x{E5DF}]
    [\x{FE042}\x{FE53B}\x{FE4BC}\x{FE7FB}\x{FE80B}\x{FEB32}\x{FE7DB}\x{FE1DC}\x{FE4EB}\x{FE4EC}\x{FE7F8}\x{FE505}\x{FE514}\x{FE00B}\x{FE1DD}\x{FE4DF}\x{FE1A1}\x{FE4B3}\x{FE4B4}\x{FE4BA}\x{FE4B7}\x{FE7E8}\x{FEB25}\x{FE838}\x{FEB38}\x{FEB3E}\x{FEB3F}\x{FEB81}\x{FEB31}\x{FEB2F}\x{FEB40}\x{FEB41}\x{FEB99}\x{FEB9A}\x{FE4F7}\x{FE839}\x{FE83A}\x{FE527}\x{FE4D3}\x{FE045}\x{FE828}\x{FE048}\x{FE985}\x{FE987}\x{FEB43}\x{FE50A}\x{FE516}\x{FE517}\x{FEE42}\x{FE4D4}\x{FE4D8}\x{FE196}\x{FE198}\x{FE199}\x{FE4D9}\x{FE4DA}\x{FEB1A}\x{FEB10}\x{FEB13}\x{FEB14}\x{FEB15}\x{FEB16}\x{FEB60}\x{FE7D5}\x{FEB44}\x{FE984}\x{FE964}\x{FE966}\x{FE967}\x{FE968}\x{FE969}\x{FE96A}\x{FE96B}\x{FE96C}\x{FE96D}\x{FE96E}\x{FE051}\x{FE052}\x{FE055}\x{FE056}\x{FE96F}\x{FE970}\x{FE343}\x{FE340}\x{FE328}\x{FE33C}\x{FE33F}\x{FE342}\x{FE33E}\x{FE33B}\x{FE32E}\x{FE32F}\x{FE326}\x{FE322}\x{FE325}\x{FE81A}\x{FE335}\x{FE32D}\x{FE32C}\x{FE192}\x{FE193}\x{FE35B}\x{FEB9E}\x{FEB9F}\x{FEBA0}\x{FEB9D}\x{FE351}\x{FE352}\x{FE353}\x{FE829}\x{FE1A2}\x{FE818}\x{FE80E}\x{FE7DE}\x{FE7F2}\x{FE7F3}\x{FE7F4}\x{FE7FE}\x{FE518}\x{FE519}\x{FE51A}\x{FE51B}\x{FE51C}\x{FE007}\x{FE1A3}\x{FE971}\x{FE51D}\x{FE1C6}\x{FE51E}\x{FE51F}\x{FE017}\x{FE513}\x{FE008}\x{FE00D}\x{FE4B8}\x{FE00A}\x{FE805}\x{FE4BD}\x{FE4BE}\x{FE4BF}\x{FE4C0}\x{FE4E7}\x{FE4E8}\x{FE4E9}\x{FE4EA}\x{FE4ED}\x{FE4EE}\x{FE1A4}\x{FE1A5}\x{FE1A6}\x{FE1A7}\x{FE1A8}\x{FE1A9}\x{FE1AA}\x{FE1AB}\x{FE1C7}\x{FE1B6}\x{FE1C9}\x{FE1CB}\x{FE1CC}\x{FE1CD}\x{FE1D1}\x{FE1D3}\x{FE1D4}\x{FE1D5}\x{FE1D6}\x{FE50B}\x{FE50C}\x{FE50E}\x{FE50D}\x{FE553}\x{FE4CD}\x{FEB22}\x{FEAF4}\x{FEAF5}\x{FEB05}\x{FEB06}\x{FEB08}\x{FE057}\x{FE058}\x{FE059}\x{FE050}\x{FE04A}\x{FE04B}\x{FE04C}\x{FE05A}\x{FE974}\x{FE975}\x{FE976}\x{FE521}\x{FE988}\x{FE1DE}\x{FE817}\x{FE7DA}\x{FE7FF}\x{FE810}\x{FE1AC}\x{FE1AD}\x{FE1DF}\x{FE194}\x{FE1E0}\x{FE04D}\x{FE977}\x{FE978}\x{FE979}\x{FE97A}\x{FE97B}\x{FE97C}\x{FE354}\x{FE355}\x{FE356}\x{FE03A}\x{FEB17}\x{FEB80}\x{FE97D}\x{FE1E1}\x{FE1E2}\x{FE97E}\x{FE05B}\x{FE4E4}\x{FEB5F}\x{FE33D}\x{FE34E}\x{FE03B}\x{FE34B}\x{FE348}\x{FE52B}\x{FE34A}\x{FE334}\x{FE34C}\x{FE350}\x{FE321}\x{FE34D}\x{FE339}\x{FE34F}\x{FE4D5}\x{FE4C8}\x{FE7EC}\x{FE811}\x{FE812}\x{FE97F}\x{FEB92}\x{FE7F0}\x{FE7F9}\x{FEE43}\x{FEB0D}\x{FE1BB}\x{FE4D0}\x{FE824}\x{FEB2C}\x{FEAF6}\x{FEAF7}\x{FE038}\x{FE03E}\x{FE1B9}\x{FE349}\x{FE333}\x{FEE44}\x{FE04E}\x{FEB93}\x{FE82C}\x{FE357}\x{FE358}\x{FE359}\x{FE35A}\x{FEE45}\x{FEE46}\x{FEE47}\x{FEE48}\x{FEE49}\x{FEE4A}\x{FEB6A}\x{FE005}\x{FE7F7}\x{FE7D9}\x{FEB77}\x{FE7FD}\x{FE80D}\x{FE520}\x{FE1C3}\x{FE330}\x{FE320}\x{FE33A}\x{FE346}\x{FEB59}\x{FEB56}\x{FEB0E}\x{FEB0F}\x{FEB61}\x{FEB58}\x{FE4F6}\x{FE01B}\x{FEB1E}\x{FEB1F}\x{FEB20}\x{FE044}\x{FEB23}\x{FEB04}\x{FEB09}\x{FEB26}\x{FE003}\x{FE014}\x{FE004}\x{FE000}\x{FE016}\x{FE00E}\x{FEB68}\x{FE002}\x{FE001}\x{FE00F}\x{FE02B}\x{FE02C}\x{FE02D}\x{FE02E}\x{FE02F}\x{FE030}\x{FE031}\x{FE032}\x{FE033}\x{FE034}\x{FE035}\x{FE036}\x{FE037}\x{FE4F0}\x{FE547}\x{FE807}\x{FE546}\x{FE53A}\x{FE539}\x{FE551}\x{FE4B6}\x{FE4B9}\x{FE506}\x{FE7F6}\x{FE7E7}\x{FE531}\x{FE4C1}\x{FE4B5}\x{FE4B0}\x{FE980}\x{FE4B2}\x{FE7EB}\x{FE7E6}\x{FE7E3}\x{FE7E4}\x{FE7F1}\x{FE7E9}\x{FE7EA}\x{FE7DF}\x{FE7D4}\x{FE7D3}\x{FE7D8}\x{FE7D7}\x{FE7D1}\x{FE7DD}\x{FE7FA}\x{FE4C2}\x{FE808}\x{FE010}\x{FE4C4}\x{FE986}\x{FE982}\x{FE983}\x{FE972}\x{FE80C}\x{FE80A}\x{FE4DD}\x{FE80F}\x{FE512}\x{FE040}\x{FE1AE}\x{FE4E5}\x{FE054}\x{FE03F}\x{FE510}\x{FE962}\x{FE965}\x{FE04F}\x{FE1D9}\x{FE053}\x{FE961}\x{FE960}\x{FE1D2}\x{FE1BE}\x{FE1C4}\x{FE1D7}\x{FE1B8}\x{FE1BC}\x{FE1DA}\x{FE1BF}\x{FE1D8}\x{FE1BA}\x{FE1B7}\x{FE047}\x{FE046}\x{FE03D}\x{FEB57}\x{FEB5C}\x{FE329}\x{FEB4F}\x{FEB5E}\x{FEB12}\x{FE823}\x{FE1B1}\x{FE973}\x{FE1DB}\x{FE1B2}\x{FEB7A}\x{FEB2B}\x{FEB7B}\x{FEB96}\x{FEB5D}\x{FE4F4}\x{FEB98}\x{FEB3D}\x{FE1B3}\x{FEB97}\x{FE19C}\x{FE336}\x{FE19B}\x{FE532}\x{FE4CE}\x{FEB9B}\x{FEB9C}\x{FE19F}\x{FE81C}\x{FE800}\x{FE4DC}\x{FE814}\x{FE816}\x{FE819}\x{FE803}\x{FE195}\x{FE4F5}\x{FE197}\x{FE81D}\x{FE4DB}\x{FE1B0}\x{FEB37}\x{FE509}\x{FE821}\x{FE4F2}\x{FE03C}\x{FE825}\x{FE4EF}\x{FE53E}\x{FE801}\x{FEB85}\x{FEB82}\x{FE4D6}\x{FE52C}\x{FEB86}\x{FE504}\x{FE524}\x{FE535}\x{FE528}\x{FE529}\x{FE82E}\x{FE82F}\x{FE830}\x{FE831}\x{FE832}\x{FE833}\x{FE834}\x{FE835}\x{FE836}\x{FE83B}\x{FE82D}\x{FEAFD}\x{FEAFC}\x{FEAFF}\x{FEAFE}\x{FEB6D}\x{FEB6E}\x{FEB47}\x{FEB6F}\x{FEB70}\x{FEB75}\x{FEB76}\x{FEB71}\x{FEB72}\x{FEB65}\x{FEB66}\x{FEB51}\x{FEB52}\x{FEB62}\x{FEAF8}\x{FEAF9}\x{FEB48}\x{FEB00}\x{FEB01}\x{FEB02}\x{FEB03}\x{FEB73}\x{FEB74}\x{FEB6B}\x{FEB6C}\x{FEB63}\x{FEB64}\x{FEAF2}\x{FEAF1}\x{FEB2A}\x{FEB53}\x{FEB45}\x{FEB46}\x{FEAFA}\x{FEAFB}\x{FEB54}\x{FEAF0}\x{FEAF3}\x{FEB49}\x{FEB29}\x{FEB2D}\x{FEB78}\x{FEB79}\x{FEB88}\x{FEB83}\x{FEB4A}\x{FE4FD}\x{FE53F}\x{FE540}\x{FE53D}\x{FE542}\x{FE548}\x{FE4FF}\x{FE500}\x{FE501}\x{FE502}\x{FE541}\x{FE549}\x{FE545}\x{FE54D}\x{FE54E}\x{FE54F}\x{FE503}\x{FE550}\x{FE7F5}\x{FE4C7}\x{FE4E6}\x{FE54A}\x{FE54B}\x{FE54C}\x{FEE40}\x{FEB21}\x{FE4E0}\x{FE01D}\x{FE01C}\x{FE4E1}\x{FE4E2}\x{FE4F9}\x{FE4FA}\x{FE820}\x{FE4CB}\x{FE53C}\x{FE4FB}\x{FE4FC}\x{FE4E3}\x{FE83C}\x{FE4C9}\x{FE525}\x{FE4FE}\x{FEB4B}\x{FE822}\x{FEB4C}\x{FEB4D}\x{FEB4E}\x{FE543}\x{FE544}\x{FE52A}\x{FE533}\x{FE534}\x{FE02A}\x{FEB0C}\x{FE523}\x{FE981}\x{FE006}\x{FE7D2}\x{FE7D6}\x{FE522}\x{FE804}\x{FE809}\x{FE806}\x{FE50F}\x{FE511}\x{FEB1B}\x{FEB1C}\x{FEB1D}\x{FE190}\x{FE191}\x{FEB94}\x{FEB95}\x{FE011}\x{FE012}\x{FE013}\x{FEB84}\x{FE837}\x{FEB27}\x{FE324}\x{FEB18}\x{FEB5A}\x{FEB5B}\x{FEE41}\x{FE039}\x{FE963}\x{FEB89}\x{FEB8A}\x{FEB7C}\x{FEB7D}\x{FEB7E}\x{FEB7F}\x{FEB50}\x{FEB8B}\x{FE536}\x{FEB8C}\x{FEB8D}\x{FEB8E}\x{FEB8F}\x{FE526}\x{FE4B1}\x{FE52D}\x{FE552}\x{FEB90}\x{FEB91}\x{FEB36}\x{FE4CF}\x{FE4CC}\x{FE538}\x{FE81F}\x{FE041}\x{FE4BB}\x{FE7E0}\x{FE4C3}\x{FE813}\x{FE1AF}\x{FE1C0}\x{FE1C1}\x{FE1C2}\x{FE347}\x{FE327}\x{FE341}\x{FE344}\x{FE1C5}\x{FE7ED}\x{FE4D1}\x{FE827}\x{FE4CA}\x{FE515}];
}

our %map_google_unicode_to_kddi_cp932 = (
    "\x{FE000}"=>"\x{E488}", "\x{FE001}"=>"\x{E48D}", "\x{FE002}"=>"\x{E48C}", "\x{FE003}"=>"\x{E485}", "\x{FE004}"=>"\x{E487}", "\x{FE005}"=>"\x{E469}", "\x{FE006}"=>"\x{E598}", "\x{FE007}"=>"\x{E2AF}", "\x{FE008}"=>"\x{E2B8}", "\x{FE009}"=>"\x{E2BB}", "\x{FE00A}"=>"\x{E2BB}", "\x{FE00B}"=>"\x{E241}", "\x{FE00C}"=>"\x{E241}", "\x{FE00D}"=>"\x{E2B9}", "\x{FE00E}"=>"\x{E48A}", "\x{FE00F}"=>"\x{E48E}", "\x{FE010}"=>"\x{E4BF}", "\x{FE011}"=>"\x{E5A8}", "\x{FE012}"=>"\x{E5A9}", "\x{FE013}"=>"\x{E5AA}", "\x{FE014}"=>"\x{E486}", "\x{FE016}"=>"\x{E489}", "\x{FE017}"=>"\x{E2B6}", "\x{FE01B}"=>"\x{E47C}", "\x{FE01C}"=>"\x{E57B}", "\x{FE01D}"=>"\x{E57A}", "\x{FE01E}"=>"\x{E594}", "\x{FE01F}"=>"\x{E594}", "\x{FE020}"=>"\x{E594}", "\x{FE021}"=>"\x{E594}", "\x{FE022}"=>"\x{E594}", "\x{FE023}"=>"\x{E594}", "\x{FE024}"=>"\x{E594}", "\x{FE025}"=>"\x{E594}", "\x{FE026}"=>"\x{E594}", "\x{FE027}"=>"\x{E594}", "\x{FE028}"=>"\x{E594}", "\x{FE029}"=>"\x{E594}", "\x{FE02A}"=>"\x{E594}", "\x{FE02B}"=>"\x{E48F}", "\x{FE02C}"=>"\x{E490}", "\x{FE02D}"=>"\x{E491}", "\x{FE02E}"=>"\x{E492}", "\x{FE02F}"=>"\x{E493}", "\x{FE030}"=>"\x{E494}", "\x{FE031}"=>"\x{E495}", "\x{FE032}"=>"\x{E496}", "\x{FE033}"=>"\x{E497}", "\x{FE034}"=>"\x{E498}", "\x{FE035}"=>"\x{E499}", "\x{FE036}"=>"\x{E49A}", "\x{FE037}"=>"\x{E49B}", "\x{FE038}"=>"\x{E330}", "\x{FE039}"=>"\x{E5B3}", "\x{FE03A}"=>"\x{E307}", "\x{FE03B}"=>"\x{E313}", "\x{FE03C}"=>"\x{E513}", "\x{FE03D}"=>"\x{E4E4}", "\x{FE03E}"=>"\x{E331}", "\x{FE03F}"=>"\x{E4CE}", "\x{FE040}"=>"\x{E4CA}", "\x{FE041}"=>"\x{E5CD}", "\x{FE042}"=>"\x{E234}", "\x{FE043}"=>"\x{E234}", "\x{FE044}"=>"\x{E480}", "\x{FE045}"=>"\x{E25B}", "\x{FE046}"=>"\x{E4E3}", "\x{FE047}"=>"\x{E4E2}", "\x{FE048}"=>"\x{E25D}", "\x{FE04A}"=>"\x{E2EA}", "\x{FE04B}"=>"\x{E2EB}", "\x{FE04C}"=>"\x{E2EC}", "\x{FE04D}"=>"\x{E2FD}", "\x{FE04E}"=>"\x{E336}", "\x{FE04F}"=>"\x{E4D2}", "\x{FE050}"=>"\x{E2E9}", "\x{FE051}"=>"\x{E280}", "\x{FE052}"=>"\x{E281}", "\x{FE053}"=>"\x{E4D4}", "\x{FE054}"=>"\x{E4CD}", "\x{FE055}"=>"\x{E282}", "\x{FE056}"=>"\x{E283}", "\x{FE057}"=>"\x{E2E6}", "\x{FE058}"=>"\x{E2E7}", "\x{FE059}"=>"\x{E2E8}", "\x{FE05A}"=>"\x{E2ED}", "\x{FE05B}"=>"\x{E30E}", "\x{FE190}"=>"\x{E5A4}", "\x{FE191}"=>"\x{E5A5}", "\x{FE192}"=>"\x{E297}", "\x{FE193}"=>"\x{E298}", "\x{FE194}"=>"\x{E2FB}", "\x{FE195}"=>"\x{E509}", "\x{FE196}"=>"\x{E267}", "\x{FE197}"=>"\x{E50B}", "\x{FE198}"=>"\x{E268}", "\x{FE199}"=>"\x{E269}", "\x{FE19B}"=>"\x{E4FC}", "\x{FE19C}"=>"\x{E4FA}", "\x{FE19D}"=>"\x{E4FC}", "\x{FE19E}"=>"\x{E4FA}", "\x{FE19F}"=>"\x{E501}", "\x{FE1A1}"=>"\x{E244}", "\x{FE1A2}"=>"\x{E2A2}", "\x{FE1A3}"=>"\x{E2B0}", "\x{FE1A4}"=>"\x{E2C7}", "\x{FE1A5}"=>"\x{E2C8}", "\x{FE1A6}"=>"\x{E2C9}", "\x{FE1A7}"=>"\x{E2CA}", "\x{FE1A8}"=>"\x{E2CB}", "\x{FE1A9}"=>"\x{E2CC}", "\x{FE1AA}"=>"\x{E2CD}", "\x{FE1AB}"=>"\x{E2CE}", "\x{FE1AC}"=>"\x{E2F8}", "\x{FE1AD}"=>"\x{E2F9}", "\x{FE1AE}"=>"\x{E4CB}", "\x{FE1AF}"=>"\x{E5D2}", "\x{FE1B0}"=>"\x{E50E}", "\x{FE1B1}"=>"\x{E4EC}", "\x{FE1B2}"=>"\x{E4EF}", "\x{FE1B3}"=>"\x{E4F8}", "\x{FE1B6}"=>"\x{E2D0}", "\x{FE1B7}"=>"\x{E4E1}", "\x{FE1B8}"=>"\x{E4DB}", "\x{FE1B9}"=>"\x{E332}", "\x{FE1BA}"=>"\x{E4E0}", "\x{FE1BB}"=>"\x{E32A}", "\x{FE1BC}"=>"\x{E4DC}", "\x{FE1BD}"=>"\x{E49A}", "\x{FE1BE}"=>"\x{E4D8}", "\x{FE1BF}"=>"\x{E4DE}", "\x{FE1C0}"=>"\x{E5D3}", "\x{FE1C1}"=>"\x{E5D4}", "\x{FE1C2}"=>"\x{E5D5}", "\x{FE1C3}"=>"\x{E470}", "\x{FE1C4}"=>"\x{E4D9}", "\x{FE1C5}"=>"\x{E5DA}", "\x{FE1C6}"=>"\x{E2B3}", "\x{FE1C7}"=>"\x{E2CF}", "\x{FE1C8}"=>"\x{E4E0}", "\x{FE1C9}"=>"\x{E2D1}", "\x{FE1CB}"=>"\x{E2D2}", "\x{FE1CC}"=>"\x{E2D3}", "\x{FE1CD}"=>"\x{E2D4}", "\x{FE1CE}"=>"\x{E4D9}", "\x{FE1CF}"=>"\x{E48F}", "\x{FE1D0}"=>"\x{E4E1}", "\x{FE1D1}"=>"\x{E2D5}", "\x{FE1D2}"=>"\x{E4D7}", "\x{FE1D3}"=>"\x{E2D6}", "\x{FE1D4}"=>"\x{E2D7}", "\x{FE1D5}"=>"\x{E2D8}", "\x{FE1D6}"=>"\x{E2D9}", "\x{FE1D7}"=>"\x{E4DA}", "\x{FE1D8}"=>"\x{E4DF}", "\x{FE1D9}"=>"\x{E4D3}", "\x{FE1DA}"=>"\x{E4DD}", "\x{FE1DB}"=>"\x{E4EE}", "\x{FE1DC}"=>"\x{E23B}", "\x{FE1DD}"=>"\x{E242}", "\x{FE1DE}"=>"\x{E2F3}", "\x{FE1DF}"=>"\x{E2FA}", "\x{FE1E0}"=>"\x{E2FC}", "\x{FE1E1}"=>"\x{E30B}", "\x{FE1E2}"=>"\x{E30C}", "\x{FE1E3}"=>"\x{E492}", "\x{FE320}"=>"\x{E472}", "\x{FE321}"=>"\x{E31B}", "\x{FE322}"=>"\x{E291}", "\x{FE323}"=>"\x{E287}", "\x{FE324}"=>"\x{E5AE}", "\x{FE325}"=>"\x{E292}", "\x{FE326}"=>"\x{E290}", "\x{FE327}"=>"\x{E5D7}", "\x{FE328}"=>"\x{E288}", "\x{FE329}"=>"\x{E4E7}", "\x{FE32A}"=>"\x{E4E7}", "\x{FE32B}"=>"\x{E294}", "\x{FE32C}"=>"\x{E296}", "\x{FE32D}"=>"\x{E295}", "\x{FE32E}"=>"\x{E28E}", "\x{FE32F}"=>"\x{E28F}", "\x{FE330}"=>"\x{E471}", "\x{FE331}"=>"\x{E471}\x{E5B1}", "\x{FE332}"=>"\x{E28C}", "\x{FE333}"=>"\x{E334}", "\x{FE334}"=>"\x{E318}", "\x{FE335}"=>"\x{E294}", "\x{FE336}"=>"\x{E4FB}", "\x{FE337}"=>"\x{E294}", "\x{FE338}"=>"\x{E471}", "\x{FE339}"=>"\x{E31D}", "\x{FE33A}"=>"\x{E473}", "\x{FE33B}"=>"\x{E28D}", "\x{FE33C}"=>"\x{E289}", "\x{FE33D}"=>"\x{E311}", "\x{FE33E}"=>"\x{E28C}", "\x{FE33F}"=>"\x{E28A}", "\x{FE340}"=>"\x{E287}", "\x{FE341}"=>"\x{E5D8}", "\x{FE342}"=>"\x{E28B}", "\x{FE343}"=>"\x{E286}", "\x{FE344}"=>"\x{E5D9}", "\x{FE345}"=>"\x{E5D9}", "\x{FE346}"=>"\x{E474}", "\x{FE347}"=>"\x{E5D6}", "\x{FE348}"=>"\x{E315}", "\x{FE349}"=>"\x{E333}", "\x{FE34A}"=>"\x{E317}", "\x{FE34B}"=>"\x{E314}", "\x{FE34C}"=>"\x{E319}", "\x{FE34D}"=>"\x{E31C}", "\x{FE34E}"=>"\x{E312}", "\x{FE34F}"=>"\x{E31E}", "\x{FE350}"=>"\x{E31A}", "\x{FE351}"=>"\x{E29E}", "\x{FE352}"=>"\x{E29F}", "\x{FE353}"=>"\x{E2A0}", "\x{FE354}"=>"\x{E304}", "\x{FE355}"=>"\x{E305}", "\x{FE356}"=>"\x{E306}", "\x{FE357}"=>"\x{E339}", "\x{FE358}"=>"\x{E33A}", "\x{FE359}"=>"\x{E33B}", "\x{FE35A}"=>"\x{E33C}", "\x{FE35B}"=>"\x{E299}", "\x{FE4B0}"=>"\x{E4AB}", "\x{FE4B1}"=>"\x{E5C3}", "\x{FE4B2}"=>"\x{E4AD}", "\x{FE4B3}"=>"\x{E245}", "\x{FE4B4}"=>"\x{E246}", "\x{FE4B5}"=>"\x{E4AA}", "\x{FE4B6}"=>"\x{E4A3}", "\x{FE4B7}"=>"\x{E248}", "\x{FE4B8}"=>"\x{E2BA}", "\x{FE4B9}"=>"\x{E4A4}", "\x{FE4BA}"=>"\x{E247}", "\x{FE4BB}"=>"\x{E5CE}", "\x{FE4BC}"=>"\x{E236}", "\x{FE4BD}"=>"\x{E2BD}", "\x{FE4BE}"=>"\x{E2BE}", "\x{FE4BF}"=>"\x{E2BF}", "\x{FE4C0}"=>"\x{E2C0}", "\x{FE4C1}"=>"\x{E4A9}", "\x{FE4C2}"=>"\x{E4BD}", "\x{FE4C3}"=>"\x{E5D0}", "\x{FE4C4}"=>"\x{E4C0}", "\x{FE4C7}"=>"\x{E572}", "\x{FE4C8}"=>"\x{E320}", "\x{FE4C9}"=>"\x{E587}", "\x{FE4CA}"=>"\x{E5DE}", "\x{FE4CB}"=>"\x{E581}", "\x{FE4CC}"=>"\x{E5CA}", "\x{FE4CD}"=>"\x{E2DF}", "\x{FE4CE}"=>"\x{E4FE}", "\x{FE4CF}"=>"\x{E5C9}", "\x{FE4D0}"=>"\x{E32B}", "\x{FE4D1}"=>"\x{E5DC}", "\x{FE4D2}"=>"\x{E5DC}", "\x{FE4D3}"=>"\x{E25A}", "\x{FE4D4}"=>"\x{E265}", "\x{FE4D5}"=>"\x{E31F}", "\x{FE4D6}"=>"\x{E51A}", "\x{FE4D7}"=>"\x{E51A}", "\x{FE4D8}"=>"\x{E266}", "\x{FE4D9}"=>"\x{E26A}", "\x{FE4DA}"=>"\x{E26B}", "\x{FE4DB}"=>"\x{E50D}", "\x{FE4DC}"=>"\x{E504}", "\x{FE4DD}"=>"\x{E4C7}", "\x{FE4DF}"=>"\x{E243}", "\x{FE4E0}"=>"\x{E579}", "\x{FE4E1}"=>"\x{E57C}", "\x{FE4E2}"=>"\x{E57D}", "\x{FE4E3}"=>"\x{E585}", "\x{FE4E4}"=>"\x{E30F}", "\x{FE4E5}"=>"\x{E4CC}", "\x{FE4E6}"=>"\x{E573}", "\x{FE4E7}"=>"\x{E2C1}", "\x{FE4E8}"=>"\x{E2C2}", "\x{FE4E9}"=>"\x{E2C3}", "\x{FE4EA}"=>"\x{E2C4}", "\x{FE4EB}"=>"\x{E23C}", "\x{FE4EC}"=>"\x{E23D}", "\x{FE4ED}"=>"\x{E2C5}", "\x{FE4EE}"=>"\x{E2C6}", "\x{FE4EF}"=>"\x{E515}", "\x{FE4F0}"=>"\x{E49C}", "\x{FE4F2}"=>"\x{E512}", "\x{FE4F4}"=>"\x{E4F5}", "\x{FE4F5}"=>"\x{E50A}", "\x{FE4F6}"=>"\x{E47B}", "\x{FE4F7}"=>"\x{E256}", "\x{FE4F8}"=>"\x{E256}", "\x{FE4F9}"=>"\x{E57E}", "\x{FE4FA}"=>"\x{E57F}", "\x{FE4FB}"=>"\x{E583}", "\x{FE4FC}"=>"\x{E584}", "\x{FE4FD}"=>"\x{E55F}", "\x{FE4FE}"=>"\x{E589}", "\x{FE4FF}"=>"\x{E565}", "\x{FE500}"=>"\x{E566}", "\x{FE501}"=>"\x{E567}", "\x{FE502}"=>"\x{E568}", "\x{FE503}"=>"\x{E56F}", "\x{FE504}"=>"\x{E51D}", "\x{FE505}"=>"\x{E23F}", "\x{FE506}"=>"\x{E4A5}", "\x{FE507}"=>"\x{E4A5}", "\x{FE508}"=>"\x{E4A5}", "\x{FE509}"=>"\x{E510}", "\x{FE50A}"=>"\x{E261}", "\x{FE50B}"=>"\x{E2DA}", "\x{FE50C}"=>"\x{E2DB}", "\x{FE50D}"=>"\x{E2DD}", "\x{FE50E}"=>"\x{E2DC}", "\x{FE50F}"=>"\x{E59F}", "\x{FE510}"=>"\x{E4CF}", "\x{FE511}"=>"\x{E5A0}", "\x{FE512}"=>"\x{E4C9}", "\x{FE513}"=>"\x{E2B7}", "\x{FE514}"=>"\x{E240}", "\x{FE515}"=>"\x{E5DF}", "\x{FE516}"=>"\x{E262}", "\x{FE517}"=>"\x{E263}", "\x{FE518}"=>"\x{E2AA}", "\x{FE519}"=>"\x{E2AB}", "\x{FE51A}"=>"\x{E2AC}", "\x{FE51B}"=>"\x{E2AD}", "\x{FE51C}"=>"\x{E2AE}", "\x{FE51D}"=>"\x{E2B2}", "\x{FE51E}"=>"\x{E2B4}", "\x{FE51F}"=>"\x{E2B5}", "\x{FE520}"=>"\x{E46F}", "\x{FE521}"=>"\x{E2F1}", "\x{FE522}"=>"\x{E59B}", "\x{FE523}"=>"\x{E596}", "\x{FE524}"=>"\x{E51E}", "\x{FE525}"=>"\x{E588}", "\x{FE526}"=>"\x{E5C2}", "\x{FE527}"=>"\x{E259}", "\x{FE528}"=>"\x{E520}", "\x{FE529}"=>"\x{E521}", "\x{FE52A}"=>"\x{E591}", "\x{FE52B}"=>"\x{E316}", "\x{FE52C}"=>"\x{E51B}", "\x{FE52D}"=>"\x{E5C4}", "\x{FE52E}"=>"\x{E51B}", "\x{FE52F}"=>"\x{E511}", "\x{FE530}"=>"\x{E511}", "\x{FE531}"=>"\x{E4A8}", "\x{FE532}"=>"\x{E4FD}", "\x{FE533}"=>"\x{E592}", "\x{FE534}"=>"\x{E593}", "\x{FE535}"=>"\x{E51F}", "\x{FE536}"=>"\x{E5BD}", "\x{FE538}"=>"\x{E5CB}", "\x{FE539}"=>"\x{E4A1}", "\x{FE53A}"=>"\x{E4A0}", "\x{FE53B}"=>"\x{E235}", "\x{FE53C}"=>"\x{E582}", "\x{FE53D}"=>"\x{E562}", "\x{FE53E}"=>"\x{E516}", "\x{FE53F}"=>"\x{E560}", "\x{FE540}"=>"\x{E561}", "\x{FE541}"=>"\x{E569}", "\x{FE542}"=>"\x{E563}", "\x{FE543}"=>"\x{E58F}", "\x{FE544}"=>"\x{E590}", "\x{FE545}"=>"\x{E56B}", "\x{FE546}"=>"\x{E49F}", "\x{FE547}"=>"\x{E49D}", "\x{FE548}"=>"\x{E564}", "\x{FE549}"=>"\x{E56A}", "\x{FE54A}"=>"\x{E574}", "\x{FE54B}"=>"\x{E575}", "\x{FE54C}"=>"\x{E576}", "\x{FE54D}"=>"\x{E56C}", "\x{FE54E}"=>"\x{E56D}", "\x{FE54F}"=>"\x{E56E}", "\x{FE550}"=>"\x{E570}", "\x{FE551}"=>"\x{E4A2}", "\x{FE552}"=>"\x{E5C5}", "\x{FE553}"=>"\x{E2DE}", "\x{FE7D1}"=>"\x{E4BA}", "\x{FE7D2}"=>"\x{E599}", "\x{FE7D3}"=>"\x{E4B7}", "\x{FE7D4}"=>"\x{E4B6}", "\x{FE7D5}"=>"\x{E273}", "\x{FE7D6}"=>"\x{E59A}", "\x{FE7D7}"=>"\x{E4B9}", "\x{FE7D8}"=>"\x{E4B8}", "\x{FE7D9}"=>"\x{E46B}", "\x{FE7DA}"=>"\x{E2F5}", "\x{FE7DB}"=>"\x{E23A}", "\x{FE7DC}"=>"\x{E4D8}", "\x{FE7DD}"=>"\x{E4BB}", "\x{FE7DE}"=>"\x{E2A5}", "\x{FE7DF}"=>"\x{E4B5}", "\x{FE7E0}"=>"\x{E5CF}", "\x{FE7E1}"=>"\x{E5CF}", "\x{FE7E2}"=>"\x{E4B0}", "\x{FE7E3}"=>"\x{E4B0}", "\x{FE7E4}"=>"\x{E4B1}", "\x{FE7E5}"=>"\x{E4B1}", "\x{FE7E6}"=>"\x{E4AF}", "\x{FE7E7}"=>"\x{E4A7}", "\x{FE7E8}"=>"\x{E249}", "\x{FE7E9}"=>"\x{E4B3}", "\x{FE7EA}"=>"\x{E4B4}", "\x{FE7EB}"=>"\x{E4AE}", "\x{FE7EC}"=>"\x{E321}", "\x{FE7ED}"=>"\x{E5DB}", "\x{FE7EE}"=>"\x{E4B4}", "\x{FE7EF}"=>"\x{E4B1}", "\x{FE7F0}"=>"\x{E326}", "\x{FE7F1}"=>"\x{E4B2}", "\x{FE7F2}"=>"\x{E2A6}", "\x{FE7F3}"=>"\x{E2A7}", "\x{FE7F4}"=>"\x{E2A8}", "\x{FE7F5}"=>"\x{E571}", "\x{FE7F6}"=>"\x{E4A6}", "\x{FE7F7}"=>"\x{E46A}", "\x{FE7F8}"=>"\x{E23E}", "\x{FE7F9}"=>"\x{E327}", "\x{FE7FA}"=>"\x{E4BC}", "\x{FE7FB}"=>"\x{E237}", "\x{FE7FD}"=>"\x{E46D}", "\x{FE7FE}"=>"\x{E2A9}", "\x{FE7FF}"=>"\x{E2F6}", "\x{FE800}"=>"\x{E503}", "\x{FE801}"=>"\x{E517}", "\x{FE802}"=>"\x{E517}", "\x{FE803}"=>"\x{E508}", "\x{FE804}"=>"\x{E59C}", "\x{FE805}"=>"\x{E2BC}", "\x{FE806}"=>"\x{E59E}", "\x{FE807}"=>"\x{E49E}", "\x{FE808}"=>"\x{E4BE}", "\x{FE809}"=>"\x{E59D}", "\x{FE80A}"=>"\x{E4C6}", "\x{FE80B}"=>"\x{E238}", "\x{FE80C}"=>"\x{E4C5}", "\x{FE80D}"=>"\x{E46E}", "\x{FE80E}"=>"\x{E2A4}", "\x{FE80F}"=>"\x{E4C8}", "\x{FE810}"=>"\x{E2F7}", "\x{FE811}"=>"\x{E322}", "\x{FE812}"=>"\x{E323}", "\x{FE813}"=>"\x{E5D1}", "\x{FE814}"=>"\x{E505}", "\x{FE816}"=>"\x{E506}", "\x{FE817}"=>"\x{E2F4}", "\x{FE818}"=>"\x{E2A3}", "\x{FE819}"=>"\x{E507}", "\x{FE81A}"=>"\x{E293}", "\x{FE81C}"=>"\x{E502}", "\x{FE81D}"=>"\x{E50C}", "\x{FE81E}"=>"\x{E50C}", "\x{FE81F}"=>"\x{E5CC}", "\x{FE820}"=>"\x{E580}", "\x{FE821}"=>"\x{E511}", "\x{FE822}"=>"\x{E58B}", "\x{FE823}"=>"\x{E4EB}", "\x{FE824}"=>"\x{E32C}", "\x{FE825}"=>"\x{E514}", "\x{FE826}"=>"\x{E514}", "\x{FE827}"=>"\x{E5DD}", "\x{FE828}"=>"\x{E25C}", "\x{FE829}"=>"\x{E2A1}", "\x{FE82A}"=>"\x{E5CE}", "\x{FE82C}"=>"\x{E338}", "\x{FE82D}"=>"\x{E52C}", "\x{FE82E}"=>"\x{E522}", "\x{FE82F}"=>"\x{E523}", "\x{FE830}"=>"\x{E524}", "\x{FE831}"=>"\x{E525}", "\x{FE832}"=>"\x{E526}", "\x{FE833}"=>"\x{E527}", "\x{FE834}"=>"\x{E528}", "\x{FE835}"=>"\x{E529}", "\x{FE836}"=>"\x{E52A}", "\x{FE837}"=>"\x{E5AC}", "\x{FE838}"=>"\x{E24B}", "\x{FE839}"=>"\x{E257}", "\x{FE83A}"=>"\x{E258}", "\x{FE83B}"=>"\x{E52B}", "\x{FE83C}"=>"\x{E586}", "\x{FE960}"=>"\x{E4D6}", "\x{FE961}"=>"\x{E4D5}", "\x{FE962}"=>"\x{E4D0}", "\x{FE963}"=>"\x{E5B4}", "\x{FE964}"=>"\x{E276}", "\x{FE965}"=>"\x{E4D1}", "\x{FE966}"=>"\x{E277}", "\x{FE967}"=>"\x{E278}", "\x{FE968}"=>"\x{E279}", "\x{FE969}"=>"\x{E27A}", "\x{FE96A}"=>"\x{E27B}", "\x{FE96B}"=>"\x{E27C}", "\x{FE96C}"=>"\x{E27D}", "\x{FE96D}"=>"\x{E27E}", "\x{FE96E}"=>"\x{E27F}", "\x{FE96F}"=>"\x{E284}", "\x{FE970}"=>"\x{E285}", "\x{FE971}"=>"\x{E2B1}", "\x{FE972}"=>"\x{E4C4}", "\x{FE973}"=>"\x{E4ED}", "\x{FE974}"=>"\x{E2EE}", "\x{FE975}"=>"\x{E2EF}", "\x{FE976}"=>"\x{E2F0}", "\x{FE977}"=>"\x{E2FE}", "\x{FE978}"=>"\x{E2FF}", "\x{FE979}"=>"\x{E300}", "\x{FE97A}"=>"\x{E301}", "\x{FE97B}"=>"\x{E302}", "\x{FE97C}"=>"\x{E303}", "\x{FE97D}"=>"\x{E30A}", "\x{FE97E}"=>"\x{E30D}", "\x{FE97F}"=>"\x{E324}", "\x{FE980}"=>"\x{E4AC}", "\x{FE981}"=>"\x{E597}", "\x{FE982}"=>"\x{E4C2}", "\x{FE983}"=>"\x{E4C3}", "\x{FE984}"=>"\x{E275}", "\x{FE985}"=>"\x{E25E}", "\x{FE986}"=>"\x{E4C1}", "\x{FE987}"=>"\x{E25F}", "\x{FE988}"=>"\x{E2F2}", "\x{FEAF0}"=>"\x{E555}", "\x{FEAF1}"=>"\x{E54D}", "\x{FEAF2}"=>"\x{E54C}", "\x{FEAF3}"=>"\x{E556}", "\x{FEAF4}"=>"\x{E2E1}", "\x{FEAF5}"=>"\x{E2E2}", "\x{FEAF6}"=>"\x{E32E}", "\x{FEAF7}"=>"\x{E32F}", "\x{FEAF8}"=>"\x{E53F}", "\x{FEAF9}"=>"\x{E540}", "\x{FEAFA}"=>"\x{E552}", "\x{FEAFB}"=>"\x{E553}", "\x{FEAFC}"=>"\x{E52E}", "\x{FEAFD}"=>"\x{E52D}", "\x{FEAFE}"=>"\x{E530}", "\x{FEAFF}"=>"\x{E52F}", "\x{FEB00}"=>"\x{E542}", "\x{FEB01}"=>"\x{E543}", "\x{FEB02}"=>"\x{E544}", "\x{FEB03}"=>"\x{E545}", "\x{FEB04}"=>"\x{E482}", "\x{FEB05}"=>"\x{E2E3}", "\x{FEB06}"=>"\x{E2E4}", "\x{FEB08}"=>"\x{E2E5}", "\x{FEB09}"=>"\x{E483}", "\x{FEB0A}"=>"\x{E483}", "\x{FEB0B}"=>"\x{E482}", "\x{FEB0C}"=>"\x{E595}", "\x{FEB0D}"=>"\x{E329}", "\x{FEB0E}"=>"\x{E477}", "\x{FEB0F}"=>"\x{E478}", "\x{FEB10}"=>"\x{E26D}", "\x{FEB11}"=>"\x{E329}", "\x{FEB12}"=>"\x{E4EA}", "\x{FEB13}"=>"\x{E26E}", "\x{FEB14}"=>"\x{E26F}", "\x{FEB15}"=>"\x{E270}", "\x{FEB16}"=>"\x{E271}", "\x{FEB17}"=>"\x{E308}", "\x{FEB18}"=>"\x{E5AF}", "\x{FEB19}"=>"\x{E595}", "\x{FEB1A}"=>"\x{E26C}", "\x{FEB1B}"=>"\x{E5A1}", "\x{FEB1C}"=>"\x{E5A2}", "\x{FEB1D}"=>"\x{E5A3}", "\x{FEB1E}"=>"\x{E47D}", "\x{FEB1F}"=>"\x{E47E}", "\x{FEB20}"=>"\x{E47F}", "\x{FEB21}"=>"\x{E578}", "\x{FEB22}"=>"\x{E2E0}", "\x{FEB23}"=>"\x{E481}", "\x{FEB25}"=>"\x{E24A}", "\x{FEB26}"=>"\x{E484}", "\x{FEB27}"=>"\x{E5AD}", "\x{FEB29}"=>"\x{E558}", "\x{FEB2A}"=>"\x{E54E}", "\x{FEB2B}"=>"\x{E4F1}", "\x{FEB2C}"=>"\x{E32D}", "\x{FEB2D}"=>"\x{E559}", "\x{FEB2F}"=>"\x{E251}", "\x{FEB31}"=>"\x{E250}", "\x{FEB32}"=>"\x{E239}", "\x{FEB35}"=>"\x{E2CC}", "\x{FEB36}"=>"\x{E5C8}", "\x{FEB37}"=>"\x{E50F}", "\x{FEB38}"=>"\x{E24C}", "\x{FEB3D}"=>"\x{E4F7}", "\x{FEB3E}"=>"\x{E24D}", "\x{FEB3F}"=>"\x{E24E}", "\x{FEB40}"=>"\x{E252}", "\x{FEB41}"=>"\x{E253}", "\x{FEB43}"=>"\x{E260}", "\x{FEB44}"=>"\x{E274}", "\x{FEB45}"=>"\x{E550}", "\x{FEB46}"=>"\x{E551}", "\x{FEB47}"=>"\x{E533}", "\x{FEB48}"=>"\x{E541}", "\x{FEB49}"=>"\x{E557}", "\x{FEB4A}"=>"\x{E55E}", "\x{FEB4B}"=>"\x{E58A}", "\x{FEB4C}"=>"\x{E58C}", "\x{FEB4D}"=>"\x{E58D}", "\x{FEB4E}"=>"\x{E58E}", "\x{FEB4F}"=>"\x{E4E8}", "\x{FEB50}"=>"\x{E5BB}", "\x{FEB51}"=>"\x{E53C}", "\x{FEB52}"=>"\x{E53D}", "\x{FEB53}"=>"\x{E54F}", "\x{FEB54}"=>"\x{E554}", "\x{FEB56}"=>"\x{E476}", "\x{FEB57}"=>"\x{E4E5}", "\x{FEB58}"=>"\x{E47A}", "\x{FEB59}"=>"\x{E475}", "\x{FEB5A}"=>"\x{E5B0}", "\x{FEB5B}"=>"\x{E5B1}", "\x{FEB5C}"=>"\x{E4E6}", "\x{FEB5D}"=>"\x{E4F4}", "\x{FEB5E}"=>"\x{E4E9}", "\x{FEB5F}"=>"\x{E310}", "\x{FEB60}"=>"\x{E272}", "\x{FEB61}"=>"\x{E479}", "\x{FEB62}"=>"\x{E53E}", "\x{FEB63}"=>"\x{E54A}", "\x{FEB64}"=>"\x{E54B}", "\x{FEB65}"=>"\x{E53A}", "\x{FEB66}"=>"\x{E53B}", "\x{FEB67}"=>"\x{E54B}", "\x{FEB68}"=>"\x{E48B}", "\x{FEB69}"=>"\x{E48B}", "\x{FEB6A}"=>"\x{E468}", "\x{FEB6B}"=>"\x{E548}", "\x{FEB6C}"=>"\x{E549}", "\x{FEB6D}"=>"\x{E531}", "\x{FEB6E}"=>"\x{E532}", "\x{FEB6F}"=>"\x{E534}", "\x{FEB70}"=>"\x{E535}", "\x{FEB71}"=>"\x{E538}", "\x{FEB72}"=>"\x{E539}", "\x{FEB73}"=>"\x{E546}", "\x{FEB74}"=>"\x{E547}", "\x{FEB75}"=>"\x{E536}", "\x{FEB76}"=>"\x{E537}", "\x{FEB77}"=>"\x{E46C}", "\x{FEB78}"=>"\x{E55A}", "\x{FEB79}"=>"\x{E55B}", "\x{FEB7A}"=>"\x{E4F0}", "\x{FEB7B}"=>"\x{E4F2}", "\x{FEB7C}"=>"\x{E5B7}", "\x{FEB7D}"=>"\x{E5B8}", "\x{FEB7E}"=>"\x{E5B9}", "\x{FEB7F}"=>"\x{E5BA}", "\x{FEB80}"=>"\x{E309}", "\x{FEB81}"=>"\x{E24F}", "\x{FEB82}"=>"\x{E519}", "\x{FEB83}"=>"\x{E55D}", "\x{FEB84}"=>"\x{E5AB}", "\x{FEB85}"=>"\x{E518}", "\x{FEB86}"=>"\x{E51C}", "\x{FEB87}"=>"\x{E51C}", "\x{FEB88}"=>"\x{E55C}", "\x{FEB89}"=>"\x{E5B5}", "\x{FEB8A}"=>"\x{E5B6}", "\x{FEB8B}"=>"\x{E5BC}", "\x{FEB8C}"=>"\x{E5BE}", "\x{FEB8D}"=>"\x{E5BF}", "\x{FEB8E}"=>"\x{E5C0}", "\x{FEB8F}"=>"\x{E5C1}", "\x{FEB90}"=>"\x{E5C6}", "\x{FEB91}"=>"\x{E5C7}", "\x{FEB92}"=>"\x{E325}", "\x{FEB93}"=>"\x{E337}", "\x{FEB94}"=>"\x{E5A6}", "\x{FEB95}"=>"\x{E5A7}", "\x{FEB96}"=>"\x{E4F3}", "\x{FEB97}"=>"\x{E4F9}", "\x{FEB98}"=>"\x{E4F6}", "\x{FEB99}"=>"\x{E254}", "\x{FEB9A}"=>"\x{E255}", "\x{FEB9B}"=>"\x{E4FF}", "\x{FEB9C}"=>"\x{E500}", "\x{FEB9D}"=>"\x{E29D}", "\x{FEB9E}"=>"\x{E29A}", "\x{FEB9F}"=>"\x{E29B}", "\x{FEBA0}"=>"\x{E29C}", "\x{FEBA1}"=>"\x{E29D}", "\x{FEE1C}"=>"\x{E517}", "\x{FEE33}"=>"\x{E5BC}", "\x{FEE40}"=>"\x{E577}", "\x{FEE41}"=>"\x{E5B2}", "\x{FEE42}"=>"\x{E264}", "\x{FEE43}"=>"\x{E328}", "\x{FEE44}"=>"\x{E335}", "\x{FEE45}"=>"\x{E33D}", "\x{FEE46}"=>"\x{E33E}", "\x{FEE47}"=>"\x{E33F}", "\x{FEE48}"=>"\x{E340}", "\x{FEE49}"=>"\x{E341}", "\x{FEE4A}"=>"\x{E342}"
);

sub google_unicode_to_kddi_cp932 {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_kddi_cp932{$1} || &$check(ord $1)
    }egomx;
}

sub softbank_cp932_to_google_unicode {
    $_[1] =~ tr
    [\x{52AF}\x{6DAC}\x{6DCF}\x{6DF2}\x{6DF8}\x{6DFC}\x{6E27}\x{6E39}\x{6E3C}\x{6E5C}\x{6EBF}\x{6F88}\x{6FB5}\x{6FF5}\x{7005}\x{7007}\x{7028}\x{7085}\x{70AB}\x{7104}\x{710F}\x{7146}\x{7147}\x{715C}\x{71C1}\x{71FE}\x{72B1}\x{72BE}\x{7324}\x{7377}\x{73BD}\x{73C9}\x{73D2}\x{73D6}\x{73E3}\x{73F5}\x{7407}\x{7426}\x{7429}\x{742A}\x{742E}\x{7462}\x{7489}\x{749F}\x{7501}\x{756F}\x{7682}\x{769B}\x{769C}\x{769E}\x{76A6}\x{7746}\x{7821}\x{784E}\x{7864}\x{787A}\x{7930}\x{7994}\x{799B}\x{7AD1}\x{7AE7}\x{7AEB}\x{7B9E}\x{7D48}\x{7D5C}\x{7DA0}\x{7DB7}\x{8807}\x{88F5}\x{8A12}\x{8A37}\x{8A79}\x{8AA7}\x{8ABE}\x{8ADF}\x{8AF6}\x{8B53}\x{8B7F}\x{8CF0}\x{8CF4}\x{8D12}\x{8D76}\x{8ECF}\x{9067}\x{90DE}\x{9115}\x{9127}\x{91D7}\x{91DA}\x{91DE}\x{91E4}\x{91E5}\x{91ED}\x{91EE}\x{9206}\x{920A}\x{9210}\x{9239}\x{923A}\x{923C}\x{9240}\x{924E}\x{9251}\x{9259}\x{9267}\x{9277}\x{9278}\x{92A7}\x{92D0}\x{92D3}\x{92D5}\x{92D7}\x{92D9}\x{92E0}\x{92E7}\x{92FB}\x{92FF}\x{9302}\x{931D}\x{931E}\x{9321}\x{9325}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}\x{E53F}\x{E540}\x{E541}\x{E542}\x{E543}\x{E544}\x{E545}\x{E546}\x{E547}\x{E548}\x{E549}\x{E54A}\x{E54B}\x{E54C}\x{E54D}\x{E54E}\x{E54F}\x{E550}\x{E551}\x{E552}\x{E553}\x{E554}\x{E555}\x{E556}\x{E557}\x{E558}\x{E559}\x{E55A}\x{E55B}\x{E55C}\x{E55D}\x{E55E}\x{E55F}\x{E560}\x{E561}\x{E562}\x{E563}\x{E564}\x{E565}\x{E566}\x{E567}\x{E568}\x{E569}\x{E56A}\x{E56B}\x{E56C}\x{E56D}\x{E56E}\x{E56F}\x{E570}\x{E571}\x{E572}\x{E573}\x{E574}\x{E575}\x{E576}\x{E577}\x{E578}\x{E579}\x{E57A}\x{E57B}\x{E57C}\x{E57D}\x{E57E}\x{E584}\x{E585}\x{E586}\x{E587}\x{E588}\x{E589}\x{E58A}\x{E58B}\x{E58C}\x{E58D}\x{E58E}\x{E58F}\x{E590}\x{E591}\x{E592}\x{E593}\x{E594}\x{E595}\x{E596}\x{E597}\x{E598}\x{E599}\x{E59A}\x{E59B}\x{E59C}\x{E59D}\x{E59E}\x{E59F}\x{E5A0}\x{E5A1}\x{E5A2}\x{E5A3}\x{E5A4}\x{E5A5}\x{E5A6}\x{E5A7}\x{E5A8}\x{E5A9}\x{E5AA}\x{E5AB}\x{E5AC}\x{E5AD}\x{E5AE}\x{E5AF}\x{E5B0}\x{E5B1}\x{E5B2}\x{E5B3}\x{E5B4}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E69D}\x{E69E}\x{E69F}\x{E6A0}\x{E6A1}\x{E6A2}\x{E6A3}\x{E6A4}\x{E6A5}\x{E6A6}\x{E6A7}\x{E6A8}\x{E6A9}\x{E6AA}\x{E6AB}\x{E6AC}\x{E6AD}\x{E6AE}\x{E6AF}\x{E6B0}\x{E6B1}\x{E6B2}\x{E6B3}\x{E6B4}\x{E6B5}\x{E6B6}\x{E6B7}\x{E6B8}\x{E6B9}\x{E6BA}\x{E6BB}\x{E6BC}\x{E6BD}\x{E6BE}\x{E6BF}\x{E6C0}\x{E6C1}\x{E6C2}\x{E6C3}\x{E6C4}\x{E6C5}\x{E6C6}\x{E6C7}\x{E6C8}\x{E6C9}\x{E6CA}\x{E6CB}\x{E6CC}\x{E6CD}\x{E6CE}\x{E6CF}\x{E6D0}\x{E6D1}\x{E6D2}\x{E6D3}\x{E6D4}\x{E6D5}\x{E6D6}\x{E6D7}\x{E6D8}\x{E6D9}\x{E6DA}\x{E6DB}\x{E6DC}\x{E6DD}\x{E6DE}\x{E6DF}\x{E6E0}\x{E6E1}\x{E6E2}\x{E6E3}\x{E6E4}\x{E6E5}\x{E6E6}\x{E6E7}\x{E6E8}\x{E6E9}\x{E6EA}\x{E6EB}\x{E6EC}\x{E6ED}\x{E6EE}\x{E6EF}\x{E6F0}\x{E6F1}\x{E6F2}\x{E6F3}\x{E6F4}\x{E6F5}\x{E6F6}\x{E6FC}\x{E6FD}\x{E6FE}\x{E6FF}\x{E700}\x{E701}\x{E702}\x{E703}\x{E704}\x{E705}\x{E706}\x{E707}\x{E708}\x{E709}\x{E70A}\x{E70B}\x{E70C}\x{E70D}\x{E70E}\x{E70F}\x{E710}\x{E711}\x{E712}\x{E713}\x{E714}\x{E715}\x{E716}\x{E717}\x{E718}\x{E719}\x{E71A}\x{E71B}\x{E71C}\x{E71D}\x{E71E}\x{E71F}\x{E720}\x{E721}\x{E722}\x{E723}\x{E724}\x{E725}\x{E726}\x{E727}\x{E728}\x{E729}\x{E72A}\x{E72B}\x{E72C}\x{E72D}\x{E72E}\x{E72F}\x{E730}\x{E731}\x{E732}\x{E733}\x{E734}\x{E735}\x{E736}\x{E737}\x{E738}\x{E739}\x{E73A}\x{E73B}\x{E73C}\x{E73D}\x{E73E}\x{E73F}\x{E740}\x{E741}\x{E742}\x{E743}\x{E744}\x{E745}\x{E746}\x{E747}\x{E748}\x{FA15}\x{FA16}\x{FA17}\x{FA18}\x{FA19}\x{FA1A}\x{FA1B}\x{FA1C}\x{FA1D}\x{FA22}\x{FA23}\x{FA24}\x{FA25}\x{FA26}\x{FA27}\x{FA28}]
    [\x{FEB17}\x{FE345}\x{FE343}\x{FE328}\x{FE340}\x{FE347}\x{FE342}\x{FE33C}\x{FE32A}\x{FE33F}\x{FE33E}\x{FE33B}\x{FE32E}\x{FE32F}\x{FE326}\x{FE325}\x{FE322}\x{FE33A}\x{FE334}\x{FE336}\x{FE339}\x{FE33D}\x{FE32D}\x{FE338}\x{FE190}\x{FE192}\x{FE191}\x{FE193}\x{FE35B}\x{FEB9E}\x{FEB9F}\x{FEBA0}\x{FE352}\x{FEBA1}\x{FE351}\x{FE353}\x{FE829}\x{FE358}\x{FE1A2}\x{FE1A0}\x{FE7D6}\x{FE7DD}\x{FE80E}\x{FE7DE}\x{FE7E5}\x{FE7F1}\x{FE7F2}\x{FE7FE}\x{FE7F3}\x{FE7F4}\x{FE7E0}\x{FE518}\x{FE519}\x{FE51A}\x{FE51B}\x{FE51C}\x{FE007}\x{FE51D}\x{FE51E}\x{FE005}\x{FE049}\x{FE017}\x{FE043}\x{FE00A}\x{FE00C}\x{FE00D}\x{FE008}\x{FE4B8}\x{FE804}\x{FE805}\x{FE4BD}\x{FE4BE}\x{FE4BF}\x{FE802}\x{FE4C0}\x{FE4C5}\x{FE4E5}\x{FE4E6}\x{FE4E7}\x{FE4E8}\x{FE4E9}\x{FE4EA}\x{FE4EC}\x{FE1A4}\x{FE1A5}\x{FE1A7}\x{FE1A8}\x{FE1AA}\x{FE1A9}\x{FE1AB}\x{FE1B6}\x{FE1C7}\x{FE4C6}\x{FE1B5}\x{FE1C8}\x{FE1BA}\x{FE1C9}\x{FE1D0}\x{FE1CA}\x{FE1CC}\x{FE1CB}\x{FE1CD}\x{FE1CF}\x{FE1CE}\x{FE1D1}\x{FE1D3}\x{FE1D4}\x{FE1D2}\x{FE50B}\x{FE553}\x{FE50D}\x{FE1D6}\x{FE1D7}\x{FE50E}\x{FE1D5}\x{FEE71}\x{FEE74}\x{FEE76}\x{FEE75}\x{FEE73}\x{FEE70}\x{FEB2A}\x{FE52C}\x{FE52E}\x{FE52B}\x{FE526}\x{FE329}\x{FE327}\x{FE341}\x{FE344}\x{FE1C4}\x{FE1C5}\x{FE1BF}\x{FE1B0}\x{FE7ED}\x{FE4D1}\x{FEB56}\x{FE03C}\x{FE827}\x{FE510}\x{FE4F5}\x{FEB85}\x{FE7D9}\x{FE4CA}\x{FE515}\x{FE03F}\x{FE042}\x{FE1B2}\x{FE1AE}\x{FE1B3}\x{FE4F6}\x{FE53B}\x{FE537}\x{FE960}\x{FE4BC}\x{FE7FB}\x{FE7FA}\x{FE7FD}\x{FE807}\x{FE81D}\x{FE81E}\x{FE81F}\x{FE820}\x{FE81C}\x{FE1B1}\x{FE81B}\x{FE80B}\x{FEB32}\x{FE4DD}\x{FE80C}\x{FE7DB}\x{FE7D7}\x{FE80D}\x{FE7DC}\x{FE7EE}\x{FE7EB}\x{FE7F8}\x{FEB33}\x{FEB34}\x{FEB35}\x{FE509}\x{FEB59}\x{FE004}\x{FE4D6}\x{FE505}\x{FE507}\x{FE821}\x{FE52F}\x{FE514}\x{FEB86}\x{FEB87}\x{FE00B}\x{FE965}\x{FE546}\x{FE4DE}\x{FE4DF}\x{FE531}\x{FEB5E}\x{FE4B5}\x{FE7F7}\x{FE7F6}\x{FE7E7}\x{FE506}\x{FE1A1}\x{FE4B3}\x{FE4B6}\x{FE4B4}\x{FE4B9}\x{FE4BA}\x{FE4B7}\x{FE7E6}\x{FE7EF}\x{FE7F0}\x{FE7E8}\x{FEB24}\x{FEB19}\x{FEB61}\x{FEB62}\x{FEB25}\x{FEB1F}\x{FE044}\x{FEB20}\x{FE838}\x{FEB1A}\x{FEB1C}\x{FEB1B}\x{FEB1D}\x{FE82C}\x{FE82B}\x{FEB36}\x{FEB37}\x{FEB38}\x{FEB39}\x{FEB3A}\x{FEB3B}\x{FEB3C}\x{FEB63}\x{FEB64}\x{FEB67}\x{FE82E}\x{FE82F}\x{FE830}\x{FE831}\x{FE832}\x{FE833}\x{FE834}\x{FE835}\x{FE836}\x{FE837}\x{FEB3D}\x{FEB3E}\x{FEB3F}\x{FEB81}\x{FEB31}\x{FEB2F}\x{FEB40}\x{FEB41}\x{FEB99}\x{FEB9A}\x{FEB9B}\x{FEB9C}\x{FEAF8}\x{FEAF9}\x{FEAFA}\x{FEAFB}\x{FEAF0}\x{FEAF2}\x{FEAF1}\x{FEAF3}\x{FEAFC}\x{FEAFD}\x{FEAFE}\x{FEAFF}\x{FE4F8}\x{FE02B}\x{FE02C}\x{FE02D}\x{FE02E}\x{FE02F}\x{FE030}\x{FE031}\x{FE032}\x{FE033}\x{FE034}\x{FE035}\x{FE036}\x{FE037}\x{FEB42}\x{FEB27}\x{FEB29}\x{FEB2D}\x{FE839}\x{FE83A}\x{FEB23}\x{FE1B4}\x{FEE77}\x{FEE78}\x{FEE79}\x{FEE7A}\x{FEE7B}\x{FEE7C}\x{FEE7D}\x{FE19B}\x{FE19C}\x{FE823}\x{FE19D}\x{FE19E}\x{FE4CF}\x{FE4CD}\x{FE4EF}\x{FE523}\x{FE525}\x{FE528}\x{FE538}\x{FEB96}\x{FEB97}\x{FEB98}\x{FEB93}\x{FEB94}\x{FEB95}\x{FE7D5}\x{FE7D2}\x{FE7D3}\x{FE7D1}\x{FE7DA}\x{FE7D4}\x{FE1BD}\x{FE1BE}\x{FE7E4}\x{FE7EA}\x{FE7E9}\x{FE7DF}\x{FE7E3}\x{FEB09}\x{FEB04}\x{FEB0C}\x{FEB0E}\x{FE01E}\x{FE01F}\x{FE020}\x{FE021}\x{FE022}\x{FE023}\x{FE024}\x{FE025}\x{FE026}\x{FE027}\x{FE028}\x{FE029}\x{FE040}\x{FE4D2}\x{FE041}\x{FE512}\x{FE825}\x{FE826}\x{FE4B0}\x{FE4BB}\x{FE4B2}\x{FE7EC}\x{FE7F5}\x{FE4C3}\x{FE800}\x{FE801}\x{FE813}\x{FEB82}\x{FE815}\x{FE816}\x{FE818}\x{FE980}\x{FE982}\x{FE981}\x{FE962}\x{FE983}\x{FE003}\x{FE001}\x{FE000}\x{FE002}\x{FE014}\x{FE009}\x{FE1AF}\x{FE1B8}\x{FE1C0}\x{FE1C1}\x{FE1B7}\x{FE1C2}\x{FE1C3}\x{FE1BC}\x{FE335}\x{FE330}\x{FE323}\x{FE320}\x{FE4F4}\x{FE527}\x{FE4D3}\x{FE045}\x{FE03D}\x{FE046}\x{FE828}\x{FE047}\x{FE048}\x{FE508}\x{FE803}\x{FE985}\x{FE987}\x{FEB43}\x{FEB1E}\x{FE50A}\x{FE516}\x{FEB58}\x{FE517}\x{FE53E}\x{FE50F}\x{FEB2B}\x{FE53C}\x{FE530}\x{FE4D4}\x{FE4D5}\x{FE4D7}\x{FE4D8}\x{FE195}\x{FE196}\x{FE197}\x{FE198}\x{FE199}\x{FE4D9}\x{FE4DA}\x{FE4F0}\x{FE808}\x{FE4F2}\x{FE814}\x{FEB0D}\x{FEB11}\x{FEB12}\x{FEB13}\x{FEB14}\x{FEB15}\x{FEB16}\x{FEB60}\x{FEB68}\x{FEB5D}\x{FEB5B}\x{FEB44}\x{FEB45}\x{FEB57}\x{FEB69}\x{FEB0A}\x{FEB0B}\x{FE984}\x{FE964}\x{FE966}\x{FE967}\x{FE968}\x{FE969}\x{FE96A}\x{FE96B}\x{FE963}\x{FE96C}\x{FE961}\x{FE96D}\x{FE96E}\x{FE051}\x{FE052}\x{FE053}\x{FE054}\x{FE055}\x{FE056}\x{FE511}\x{FE96F}\x{FE970}\x{FE32C}\x{FEB9D}\x{FE7E2}\x{FE82A}\x{FE038}\x{FE971}\x{FE1C6}\x{FE51F}\x{FE513}\x{FE4C4}\x{FE4EB}\x{FE4ED}\x{FE4EE}\x{FE1A6}\x{FE50C}\x{FEE72}];
}

our %map_google_unicode_to_softbank_cp932 = (
    "\x{FE000}"=>"\x{E6E6}", "\x{FE001}"=>"\x{E6E5}", "\x{FE002}"=>"\x{E6E7}", "\x{FE003}"=>"\x{E6E4}", "\x{FE004}"=>"\x{E561}", "\x{FE005}"=>"\x{7AD1}", "\x{FE007}"=>"\x{7930}", "\x{FE008}"=>"\x{7DB7}", "\x{FE009}"=>"\x{E6E9}", "\x{FE00A}"=>"\x{7D48}", "\x{FE00B}"=>"\x{E56A}", "\x{FE00C}"=>"\x{7D5C}", "\x{FE00D}"=>"\x{7DA0}", "\x{FE00F}"=>"\x{E6E6}\x{E6E5}", "\x{FE010}"=>"\x{7DB7}", "\x{FE012}"=>"\x{E6E8}", "\x{FE013}"=>"\x{E6E8}", "\x{FE014}"=>"\x{E6E8}", "\x{FE016}"=>"\x{E6E8}", "\x{FE017}"=>"\x{7AEB}", "\x{FE01E}"=>"\x{E6C0}", "\x{FE01F}"=>"\x{E6C1}", "\x{FE020}"=>"\x{E6C2}", "\x{FE021}"=>"\x{E6C3}", "\x{FE022}"=>"\x{E6C4}", "\x{FE023}"=>"\x{E6C5}", "\x{FE024}"=>"\x{E6C6}", "\x{FE025}"=>"\x{E6C7}", "\x{FE026}"=>"\x{E6C8}", "\x{FE027}"=>"\x{E6C9}", "\x{FE028}"=>"\x{E6CA}", "\x{FE029}"=>"\x{E6CB}", "\x{FE02A}"=>"\x{E6C9}", "\x{FE02B}"=>"\x{E5C2}", "\x{FE02C}"=>"\x{E5C3}", "\x{FE02D}"=>"\x{E5C4}", "\x{FE02E}"=>"\x{E5C5}", "\x{FE02F}"=>"\x{E5C6}", "\x{FE030}"=>"\x{E5C7}", "\x{FE031}"=>"\x{E5C8}", "\x{FE032}"=>"\x{E5C9}", "\x{FE033}"=>"\x{E5CA}", "\x{FE034}"=>"\x{E5CB}", "\x{FE035}"=>"\x{E5CC}", "\x{FE036}"=>"\x{E5CD}", "\x{FE037}"=>"\x{E5CE}", "\x{FE038}"=>"\x{FA19}", "\x{FE03B}"=>"\x{7DB7}", "\x{FE03C}"=>"\x{E534}", "\x{FE03D}"=>"\x{E6FF}", "\x{FE03E}"=>"\x{E534}", "\x{FE03F}"=>"\x{E53C}", "\x{FE040}"=>"\x{E6CC}", "\x{FE041}"=>"\x{E6CE}", "\x{FE042}"=>"\x{E53D}", "\x{FE043}"=>"\x{7B9E}", "\x{FE044}"=>"\x{E58C}", "\x{FE045}"=>"\x{E6FE}", "\x{FE046}"=>"\x{E700}", "\x{FE047}"=>"\x{E702}", "\x{FE048}"=>"\x{E703}", "\x{FE049}"=>"\x{7AE7}", "\x{FE04D}"=>"\x{E700}", "\x{FE04E}"=>"\x{E534}", "\x{FE051}"=>"\x{E740}", "\x{FE052}"=>"\x{E741}", "\x{FE053}"=>"\x{E742}", "\x{FE054}"=>"\x{E743}", "\x{FE055}"=>"\x{E744}", "\x{FE056}"=>"\x{E745}", "\x{FE05B}"=>"\x{E740}", "\x{FE190}"=>"\x{71C1}", "\x{FE191}"=>"\x{72B1}", "\x{FE192}"=>"\x{71FE}", "\x{FE193}"=>"\x{72BE}", "\x{FE194}"=>"\x{6E3C}", "\x{FE195}"=>"\x{E717}", "\x{FE196}"=>"\x{E718}", "\x{FE197}"=>"\x{E719}", "\x{FE198}"=>"\x{E71A}", "\x{FE199}"=>"\x{E71B}", "\x{FE19B}"=>"\x{E69D}", "\x{FE19C}"=>"\x{E69E}", "\x{FE19D}"=>"\x{E6A0}", "\x{FE19E}"=>"\x{E6A1}", "\x{FE1A0}"=>"\x{742A}", "\x{FE1A1}"=>"\x{E576}", "\x{FE1A2}"=>"\x{7429}", "\x{FE1A4}"=>"\x{9067}", "\x{FE1A5}"=>"\x{90DE}", "\x{FE1A6}"=>"\x{FA26}", "\x{FE1A7}"=>"\x{9115}", "\x{FE1A8}"=>"\x{9127}", "\x{FE1A9}"=>"\x{91DA}", "\x{FE1AA}"=>"\x{91D7}", "\x{FE1AB}"=>"\x{91DE}", "\x{FE1AE}"=>"\x{E53F}", "\x{FE1AF}"=>"\x{E6EA}", "\x{FE1B0}"=>"\x{E530}", "\x{FE1B1}"=>"\x{E54F}", "\x{FE1B2}"=>"\x{E53E}", "\x{FE1B3}"=>"\x{E540}", "\x{FE1B4}"=>"\x{E5D6}", "\x{FE1B5}"=>"\x{91EE}", "\x{FE1B6}"=>"\x{91E4}", "\x{FE1B7}"=>"\x{E6EE}", "\x{FE1B8}"=>"\x{E6EB}", "\x{FE1BA}"=>"\x{920A}", "\x{FE1BB}"=>"\x{920A}", "\x{FE1BC}"=>"\x{E6F1}", "\x{FE1BD}"=>"\x{E6B5}", "\x{FE1BE}"=>"\x{E6B6}", "\x{FE1BF}"=>"\x{E52F}", "\x{FE1C0}"=>"\x{E6EC}", "\x{FE1C1}"=>"\x{E6ED}", "\x{FE1C2}"=>"\x{E6EF}", "\x{FE1C3}"=>"\x{E6F0}", "\x{FE1C4}"=>"\x{E52D}", "\x{FE1C5}"=>"\x{E52E}", "\x{FE1C6}"=>"\x{FA1B}", "\x{FE1C7}"=>"\x{91E5}", "\x{FE1C8}"=>"\x{9206}", "\x{FE1C9}"=>"\x{9210}", "\x{FE1CA}"=>"\x{923A}", "\x{FE1CB}"=>"\x{9240}", "\x{FE1CC}"=>"\x{923C}", "\x{FE1CD}"=>"\x{924E}", "\x{FE1CE}"=>"\x{9259}", "\x{FE1CF}"=>"\x{9251}", "\x{FE1D0}"=>"\x{9239}", "\x{FE1D1}"=>"\x{9267}", "\x{FE1D2}"=>"\x{92A7}", "\x{FE1D3}"=>"\x{9277}", "\x{FE1D4}"=>"\x{9278}", "\x{FE1D5}"=>"\x{92E7}", "\x{FE1D6}"=>"\x{92D7}", "\x{FE1D7}"=>"\x{92D9}", "\x{FE1D8}"=>"\x{E6EE}", "\x{FE1D9}"=>"\x{E6B5}", "\x{FE1DB}"=>"\x{92D3}", "\x{FE1DD}"=>"\x{920A}", "\x{FE1E0}"=>"\x{E52F}", "\x{FE320}"=>"\x{E6F5}", "\x{FE321}"=>"\x{6DF8}", "\x{FE322}"=>"\x{7028}", "\x{FE323}"=>"\x{E6F4}", "\x{FE324}"=>"\x{6E39}", "\x{FE325}"=>"\x{7007}", "\x{FE326}"=>"\x{7005}", "\x{FE327}"=>"\x{E52A}", "\x{FE328}"=>"\x{6DF2}", "\x{FE329}"=>"\x{E529}", "\x{FE32A}"=>"\x{6E3C}", "\x{FE32B}"=>"\x{E6F2}", "\x{FE32C}"=>"\x{FA15}", "\x{FE32D}"=>"\x{7147}", "\x{FE32E}"=>"\x{6FB5}", "\x{FE32F}"=>"\x{6FF5}", "\x{FE330}"=>"\x{E6F3}", "\x{FE331}"=>"\x{715C}\x{E72C}", "\x{FE332}"=>"\x{6EBF}", "\x{FE333}"=>"\x{6DF2}", "\x{FE334}"=>"\x{70AB}", "\x{FE335}"=>"\x{E6F2}", "\x{FE336}"=>"\x{7104}", "\x{FE337}"=>"\x{E6F2}", "\x{FE338}"=>"\x{715C}", "\x{FE339}"=>"\x{710F}", "\x{FE33A}"=>"\x{7085}", "\x{FE33B}"=>"\x{6F88}", "\x{FE33C}"=>"\x{6E39}", "\x{FE33D}"=>"\x{7146}", "\x{FE33E}"=>"\x{6EBF}", "\x{FE33F}"=>"\x{6E5C}", "\x{FE340}"=>"\x{6DF8}", "\x{FE341}"=>"\x{E52B}", "\x{FE342}"=>"\x{6E27}", "\x{FE343}"=>"\x{6DCF}", "\x{FE344}"=>"\x{E52C}", "\x{FE345}"=>"\x{6DAC}", "\x{FE346}"=>"\x{6E39}", "\x{FE347}"=>"\x{6DFC}", "\x{FE348}"=>"\x{E6F3}", "\x{FE349}"=>"\x{6DF2}", "\x{FE34A}"=>"\x{70AB}", "\x{FE34B}"=>"\x{FA15}", "\x{FE34C}"=>"\x{E52A}", "\x{FE34D}"=>"\x{710F}", "\x{FE34E}"=>"\x{7146}", "\x{FE34F}"=>"\x{6DF2}", "\x{FE350}"=>"\x{6DF8}", "\x{FE351}"=>"\x{73E3}", "\x{FE352}"=>"\x{73D2}", "\x{FE353}"=>"\x{73F5}", "\x{FE357}"=>"\x{E6AE}", "\x{FE358}"=>"\x{7426}", "\x{FE359}"=>"\x{6DF8}", "\x{FE35A}"=>"\x{7146}", "\x{FE35B}"=>"\x{7324}", "\x{FE4B0}"=>"\x{E6D2}", "\x{FE4B1}"=>"\x{E6D2}", "\x{FE4B2}"=>"\x{E6D4}", "\x{FE4B3}"=>"\x{E577}", "\x{FE4B4}"=>"\x{E579}", "\x{FE4B5}"=>"\x{E571}", "\x{FE4B6}"=>"\x{E578}", "\x{FE4B7}"=>"\x{E57C}", "\x{FE4B8}"=>"\x{8807}", "\x{FE4B9}"=>"\x{E57A}", "\x{FE4BA}"=>"\x{E57B}", "\x{FE4BB}"=>"\x{E6D3}", "\x{FE4BC}"=>"\x{E545}", "\x{FE4BD}"=>"\x{8A37}", "\x{FE4BE}"=>"\x{8A79}", "\x{FE4BF}"=>"\x{8AA7}", "\x{FE4C0}"=>"\x{8ADF}", "\x{FE4C1}"=>"\x{E585}", "\x{FE4C2}"=>"\x{E706}", "\x{FE4C3}"=>"\x{E6D7}", "\x{FE4C4}"=>"\x{FA22}", "\x{FE4C5}"=>"\x{8AF6}", "\x{FE4C6}"=>"\x{91ED}", "\x{FE4CA}"=>"\x{E53A}", "\x{FE4CC}"=>"\x{E6A3}", "\x{FE4CD}"=>"\x{E6A3}", "\x{FE4CF}"=>"\x{E6A2}", "\x{FE4D1}"=>"\x{E532}", "\x{FE4D2}"=>"\x{E6CD}", "\x{FE4D3}"=>"\x{E6FD}", "\x{FE4D4}"=>"\x{E713}", "\x{FE4D5}"=>"\x{E714}", "\x{FE4D6}"=>"\x{E562}", "\x{FE4D7}"=>"\x{E715}", "\x{FE4D8}"=>"\x{E716}", "\x{FE4D9}"=>"\x{E71C}", "\x{FE4DA}"=>"\x{E71D}", "\x{FE4DB}"=>"\x{E6A2}", "\x{FE4DD}"=>"\x{E553}", "\x{FE4DE}"=>"\x{E56D}", "\x{FE4DF}"=>"\x{E56E}", "\x{FE4E0}"=>"\x{E553}", "\x{FE4E3}"=>"\x{E553}", "\x{FE4E5}"=>"\x{8B53}", "\x{FE4E6}"=>"\x{8B7F}", "\x{FE4E7}"=>"\x{8CF0}", "\x{FE4E8}"=>"\x{8CF4}", "\x{FE4E9}"=>"\x{8D12}", "\x{FE4EA}"=>"\x{8D76}", "\x{FE4EB}"=>"\x{FA23}", "\x{FE4EC}"=>"\x{8ECF}", "\x{FE4ED}"=>"\x{FA24}", "\x{FE4EE}"=>"\x{FA25}", "\x{FE4EF}"=>"\x{E6A4}", "\x{FE4F0}"=>"\x{E71E}", "\x{FE4F2}"=>"\x{E720}", "\x{FE4F4}"=>"\x{E6F6}", "\x{FE4F5}"=>"\x{E537}", "\x{FE4F6}"=>"\x{E541}", "\x{FE4F7}"=>"\x{E5C1}", "\x{FE4F8}"=>"\x{E5C1}", "\x{FE4F9}"=>"\x{E6D9}", "\x{FE4FF}"=>"\x{E56C}", "\x{FE500}"=>"\x{E56C}", "\x{FE501}"=>"\x{E56C}", "\x{FE502}"=>"\x{E56C}", "\x{FE503}"=>"\x{E56C}", "\x{FE505}"=>"\x{E563}", "\x{FE506}"=>"\x{E575}", "\x{FE507}"=>"\x{E564}", "\x{FE508}"=>"\x{E704}", "\x{FE509}"=>"\x{E55F}", "\x{FE50A}"=>"\x{E70A}", "\x{FE50B}"=>"\x{92D0}", "\x{FE50C}"=>"\x{FA27}", "\x{FE50D}"=>"\x{92D5}", "\x{FE50E}"=>"\x{92E0}", "\x{FE50F}"=>"\x{E70F}", "\x{FE510}"=>"\x{E536}", "\x{FE511}"=>"\x{E746}", "\x{FE512}"=>"\x{E6CF}", "\x{FE513}"=>"\x{FA1D}", "\x{FE514}"=>"\x{E567}", "\x{FE515}"=>"\x{E53B}", "\x{FE516}"=>"\x{E70B}", "\x{FE517}"=>"\x{E70D}", "\x{FE518}"=>"\x{7746}", "\x{FE519}"=>"\x{7821}", "\x{FE51A}"=>"\x{784E}", "\x{FE51B}"=>"\x{7864}", "\x{FE51C}"=>"\x{787A}", "\x{FE51D}"=>"\x{7994}", "\x{FE51E}"=>"\x{799B}", "\x{FE51F}"=>"\x{FA1C}", "\x{FE523}"=>"\x{E6A5}", "\x{FE524}"=>"\x{E6A5}", "\x{FE525}"=>"\x{E6A6}", "\x{FE526}"=>"\x{E528}", "\x{FE527}"=>"\x{E6FC}", "\x{FE528}"=>"\x{E6A7}", "\x{FE529}"=>"\x{E527}", "\x{FE52A}"=>"\x{E527}", "\x{FE52B}"=>"\x{E527}", "\x{FE52C}"=>"\x{E525}", "\x{FE52D}"=>"\x{E525}", "\x{FE52E}"=>"\x{E526}", "\x{FE52F}"=>"\x{E566}", "\x{FE530}"=>"\x{E712}", "\x{FE531}"=>"\x{E56F}", "\x{FE535}"=>"\x{E536}", "\x{FE537}"=>"\x{E543}", "\x{FE538}"=>"\x{E6A8}", "\x{FE539}"=>"\x{E6FC}", "\x{FE53B}"=>"\x{E542}", "\x{FE53C}"=>"\x{E711}", "\x{FE53D}"=>"\x{E711}", "\x{FE53E}"=>"\x{E70E}", "\x{FE540}"=>"\x{E6FC}", "\x{FE541}"=>"\x{E6FC}", "\x{FE545}"=>"\x{E56C}", "\x{FE546}"=>"\x{E56C}", "\x{FE547}"=>"\x{E56C}", "\x{FE548}"=>"\x{E6FC}", "\x{FE54A}"=>"\x{E56E}", "\x{FE54B}"=>"\x{E56E}", "\x{FE54D}"=>"\x{E56C}", "\x{FE54F}"=>"\x{E56C}", "\x{FE552}"=>"\x{E6FC}", "\x{FE553}"=>"\x{92D3}", "\x{FE7D1}"=>"\x{E6B2}", "\x{FE7D2}"=>"\x{E6B0}", "\x{FE7D3}"=>"\x{E6B1}", "\x{FE7D4}"=>"\x{E6B4}", "\x{FE7D5}"=>"\x{E6AF}", "\x{FE7D6}"=>"\x{742E}", "\x{FE7D7}"=>"\x{E556}", "\x{FE7D9}"=>"\x{E539}", "\x{FE7DA}"=>"\x{E6B3}", "\x{FE7DB}"=>"\x{E555}", "\x{FE7DC}"=>"\x{E558}", "\x{FE7DD}"=>"\x{7462}", "\x{FE7DE}"=>"\x{749F}", "\x{FE7DF}"=>"\x{E6BA}", "\x{FE7E0}"=>"\x{76A6}", "\x{FE7E1}"=>"\x{76A6}", "\x{FE7E2}"=>"\x{FA17}", "\x{FE7E3}"=>"\x{E6BB}", "\x{FE7E4}"=>"\x{E6B7}", "\x{FE7E5}"=>"\x{7501}", "\x{FE7E6}"=>"\x{E57D}", "\x{FE7E7}"=>"\x{E574}", "\x{FE7E8}"=>"\x{E585}", "\x{FE7E9}"=>"\x{E6B9}", "\x{FE7EA}"=>"\x{E6B8}", "\x{FE7EB}"=>"\x{E55A}", "\x{FE7EC}"=>"\x{E6D5}", "\x{FE7ED}"=>"\x{E531}", "\x{FE7EE}"=>"\x{E559}", "\x{FE7EF}"=>"\x{E57E}", "\x{FE7F0}"=>"\x{E584}", "\x{FE7F1}"=>"\x{756F}", "\x{FE7F2}"=>"\x{7682}", "\x{FE7F3}"=>"\x{769C}", "\x{FE7F4}"=>"\x{769E}", "\x{FE7F5}"=>"\x{E6D6}", "\x{FE7F6}"=>"\x{E573}", "\x{FE7F7}"=>"\x{E572}", "\x{FE7F8}"=>"\x{E55B}", "\x{FE7F9}"=>"\x{769E}", "\x{FE7FA}"=>"\x{E547}", "\x{FE7FB}"=>"\x{E546}", "\x{FE7FD}"=>"\x{E548}", "\x{FE7FE}"=>"\x{769B}", "\x{FE7FF}"=>"\x{E6B5}", "\x{FE800}"=>"\x{E6D8}", "\x{FE801}"=>"\x{E6D9}", "\x{FE802}"=>"\x{8ABE}", "\x{FE803}"=>"\x{E705}", "\x{FE804}"=>"\x{88F5}", "\x{FE805}"=>"\x{8A12}", "\x{FE807}"=>"\x{E549}", "\x{FE808}"=>"\x{E71F}", "\x{FE809}"=>"\x{8A12}", "\x{FE80B}"=>"\x{E551}", "\x{FE80C}"=>"\x{E554}", "\x{FE80D}"=>"\x{E557}", "\x{FE80E}"=>"\x{7489}", "\x{FE813}"=>"\x{E6DA}", "\x{FE814}"=>"\x{E721}", "\x{FE815}"=>"\x{E6DC}", "\x{FE816}"=>"\x{E6DD}", "\x{FE818}"=>"\x{E6DE}", "\x{FE81A}"=>"\x{E721}", "\x{FE81B}"=>"\x{E550}", "\x{FE81C}"=>"\x{E54E}", "\x{FE81D}"=>"\x{E54A}", "\x{FE81E}"=>"\x{E54B}", "\x{FE81F}"=>"\x{E54C}", "\x{FE820}"=>"\x{E54D}", "\x{FE821}"=>"\x{E565}", "\x{FE823}"=>"\x{E69F}", "\x{FE824}"=>"\x{E527}\x{E723}", "\x{FE825}"=>"\x{E6D0}", "\x{FE826}"=>"\x{E6D1}", "\x{FE827}"=>"\x{E535}", "\x{FE828}"=>"\x{E701}", "\x{FE829}"=>"\x{7407}", "\x{FE82A}"=>"\x{FA18}", "\x{FE82B}"=>"\x{E594}", "\x{FE82C}"=>"\x{E593}", "\x{FE82E}"=>"\x{E59F}", "\x{FE82F}"=>"\x{E5A0}", "\x{FE830}"=>"\x{E5A1}", "\x{FE831}"=>"\x{E5A2}", "\x{FE832}"=>"\x{E5A3}", "\x{FE833}"=>"\x{E5A4}", "\x{FE834}"=>"\x{E5A5}", "\x{FE835}"=>"\x{E5A6}", "\x{FE836}"=>"\x{E5A7}", "\x{FE837}"=>"\x{E5A8}", "\x{FE838}"=>"\x{E58E}", "\x{FE839}"=>"\x{E5D3}", "\x{FE83A}"=>"\x{E5D4}", "\x{FE960}"=>"\x{E544}", "\x{FE961}"=>"\x{E73D}", "\x{FE962}"=>"\x{E6E2}", "\x{FE963}"=>"\x{E73B}", "\x{FE964}"=>"\x{E734}", "\x{FE965}"=>"\x{E56B}", "\x{FE966}"=>"\x{E735}", "\x{FE967}"=>"\x{E736}", "\x{FE968}"=>"\x{E737}", "\x{FE969}"=>"\x{E738}", "\x{FE96A}"=>"\x{E739}", "\x{FE96B}"=>"\x{E73A}", "\x{FE96C}"=>"\x{E73C}", "\x{FE96D}"=>"\x{E73E}", "\x{FE96E}"=>"\x{E73F}", "\x{FE96F}"=>"\x{E747}", "\x{FE970}"=>"\x{E748}", "\x{FE971}"=>"\x{FA1A}", "\x{FE980}"=>"\x{E6DF}", "\x{FE981}"=>"\x{E6E1}", "\x{FE982}"=>"\x{E6E0}", "\x{FE983}"=>"\x{E6E3}", "\x{FE984}"=>"\x{E733}", "\x{FE985}"=>"\x{E706}", "\x{FE986}"=>"\x{E6E0}", "\x{FE987}"=>"\x{E707}", "\x{FE988}"=>"\x{E6E0}", "\x{FEAF0}"=>"\x{E5B9}", "\x{FEAF1}"=>"\x{E5BB}", "\x{FEAF2}"=>"\x{E5BA}", "\x{FEAF3}"=>"\x{E5BC}", "\x{FEAF4}"=>"\x{E5B9}", "\x{FEAF5}"=>"\x{E5BB}", "\x{FEAF8}"=>"\x{E5B5}", "\x{FEAF9}"=>"\x{E5B6}", "\x{FEAFA}"=>"\x{E5B7}", "\x{FEAFB}"=>"\x{E5B8}", "\x{FEAFC}"=>"\x{E5BD}", "\x{FEAFD}"=>"\x{E5BE}", "\x{FEAFE}"=>"\x{E5BF}", "\x{FEAFF}"=>"\x{E5C0}", "\x{FEB04}"=>"\x{E6BD}", "\x{FEB09}"=>"\x{E6BC}", "\x{FEB0A}"=>"\x{E731}", "\x{FEB0B}"=>"\x{E732}", "\x{FEB0C}"=>"\x{E6BE}", "\x{FEB0D}"=>"\x{E722}", "\x{FEB0E}"=>"\x{E6BF}", "\x{FEB0F}"=>"\x{E722}", "\x{FEB10}"=>"\x{E722}", "\x{FEB11}"=>"\x{E723}", "\x{FEB12}"=>"\x{E724}", "\x{FEB13}"=>"\x{E725}", "\x{FEB14}"=>"\x{E726}", "\x{FEB15}"=>"\x{E727}", "\x{FEB16}"=>"\x{E728}", "\x{FEB17}"=>"\x{52AF}", "\x{FEB18}"=>"\x{E722}", "\x{FEB19}"=>"\x{E587}", "\x{FEB1A}"=>"\x{E58F}", "\x{FEB1B}"=>"\x{E591}", "\x{FEB1C}"=>"\x{E590}", "\x{FEB1D}"=>"\x{E592}", "\x{FEB1E}"=>"\x{E709}", "\x{FEB1F}"=>"\x{E58B}", "\x{FEB20}"=>"\x{E58D}", "\x{FEB23}"=>"\x{E5D5}", "\x{FEB24}"=>"\x{E586}", "\x{FEB25}"=>"\x{E58A}", "\x{FEB26}"=>"\x{E55B}", "\x{FEB27}"=>"\x{E5D0}", "\x{FEB29}"=>"\x{E5D1}", "\x{FEB2A}"=>"\x{9325}", "\x{FEB2B}"=>"\x{E710}", "\x{FEB2D}"=>"\x{E5D2}", "\x{FEB2F}"=>"\x{E5AE}", "\x{FEB31}"=>"\x{E5AD}", "\x{FEB32}"=>"\x{E552}", "\x{FEB33}"=>"\x{E55C}", "\x{FEB34}"=>"\x{E55D}", "\x{FEB35}"=>"\x{E55E}", "\x{FEB36}"=>"\x{E595}", "\x{FEB37}"=>"\x{E596}", "\x{FEB38}"=>"\x{E597}", "\x{FEB39}"=>"\x{E598}", "\x{FEB3A}"=>"\x{E599}", "\x{FEB3B}"=>"\x{E59A}", "\x{FEB3C}"=>"\x{E59B}", "\x{FEB3D}"=>"\x{E5A9}", "\x{FEB3E}"=>"\x{E5AA}", "\x{FEB3F}"=>"\x{E5AB}", "\x{FEB40}"=>"\x{E5AF}", "\x{FEB41}"=>"\x{E5B0}", "\x{FEB42}"=>"\x{E5CF}", "\x{FEB43}"=>"\x{E708}", "\x{FEB44}"=>"\x{E72D}", "\x{FEB45}"=>"\x{E72E}", "\x{FEB46}"=>"\x{E72E}", "\x{FEB53}"=>"\x{E72E}", "\x{FEB56}"=>"\x{E533}", "\x{FEB57}"=>"\x{E72F}", "\x{FEB58}"=>"\x{E70C}", "\x{FEB59}"=>"\x{E560}", "\x{FEB5B}"=>"\x{E72C}", "\x{FEB5C}"=>"\x{E72C}", "\x{FEB5D}"=>"\x{E72B}", "\x{FEB5E}"=>"\x{E570}", "\x{FEB5F}"=>"\x{6E5C}", "\x{FEB60}"=>"\x{E729}", "\x{FEB61}"=>"\x{E588}", "\x{FEB62}"=>"\x{E589}", "\x{FEB63}"=>"\x{E59C}", "\x{FEB64}"=>"\x{E59D}", "\x{FEB65}"=>"\x{E59C}", "\x{FEB66}"=>"\x{E59C}", "\x{FEB67}"=>"\x{E59E}", "\x{FEB68}"=>"\x{E72A}", "\x{FEB69}"=>"\x{E730}", "\x{FEB6B}"=>"\x{E59E}", "\x{FEB6C}"=>"\x{E59D}", "\x{FEB6D}"=>"\x{E59E}", "\x{FEB6E}"=>"\x{E59D}", "\x{FEB6F}"=>"\x{E59E}", "\x{FEB70}"=>"\x{E59D}", "\x{FEB71}"=>"\x{E59E}", "\x{FEB72}"=>"\x{E59D}", "\x{FEB73}"=>"\x{E59E}", "\x{FEB74}"=>"\x{E59E}", "\x{FEB75}"=>"\x{E59E}", "\x{FEB76}"=>"\x{E59E}", "\x{FEB77}"=>"\x{E729}", "\x{FEB81}"=>"\x{E5AC}", "\x{FEB82}"=>"\x{E6DB}", "\x{FEB85}"=>"\x{E538}", "\x{FEB86}"=>"\x{E568}", "\x{FEB87}"=>"\x{E569}", "\x{FEB8A}"=>"\x{E568}", "\x{FEB8D}"=>"\x{E538}", "\x{FEB8E}"=>"\x{E5B8}", "\x{FEB90}"=>"\x{E568}", "\x{FEB92}"=>"\x{E527}", "\x{FEB93}"=>"\x{E6AC}", "\x{FEB94}"=>"\x{E6AD}", "\x{FEB95}"=>"\x{E6AE}", "\x{FEB96}"=>"\x{E6A9}", "\x{FEB97}"=>"\x{E6AA}", "\x{FEB98}"=>"\x{E6AB}", "\x{FEB99}"=>"\x{E5B1}", "\x{FEB9A}"=>"\x{E5B2}", "\x{FEB9B}"=>"\x{E5B3}", "\x{FEB9C}"=>"\x{E5B4}", "\x{FEB9D}"=>"\x{FA16}", "\x{FEB9E}"=>"\x{7377}", "\x{FEB9F}"=>"\x{73BD}", "\x{FEBA0}"=>"\x{73C9}", "\x{FEBA1}"=>"\x{73D6}", "\x{FEE1C}"=>"\x{E6D9}", "\x{FEE70}"=>"\x{9321}", "\x{FEE71}"=>"\x{92FB}", "\x{FEE72}"=>"\x{FA28}", "\x{FEE73}"=>"\x{931E}", "\x{FEE74}"=>"\x{92FF}", "\x{FEE75}"=>"\x{931D}", "\x{FEE76}"=>"\x{9302}", "\x{FEE77}"=>"\x{E5D7}", "\x{FEE78}"=>"\x{E5D8}", "\x{FEE79}"=>"\x{E5D9}", "\x{FEE7A}"=>"\x{E5DA}", "\x{FEE7B}"=>"\x{E5DB}", "\x{FEE7C}"=>"\x{E5DC}", "\x{FEE7D}"=>"\x{E5DD}"
);

sub google_unicode_to_softbank_cp932 {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_softbank_cp932{$1} || &$check(ord $1)
    }egomx;
}

sub docomo_unicode_to_google_unicode {
    $_[1] =~ tr
    [\x{E63E}\x{E63F}\x{E640}\x{E641}\x{E642}\x{E643}\x{E644}\x{E645}\x{E646}\x{E647}\x{E648}\x{E649}\x{E64A}\x{E64B}\x{E64C}\x{E64D}\x{E64E}\x{E64F}\x{E650}\x{E651}\x{E652}\x{E653}\x{E654}\x{E655}\x{E656}\x{E657}\x{E658}\x{E659}\x{E65A}\x{E65B}\x{E65C}\x{E65D}\x{E65E}\x{E65F}\x{E660}\x{E661}\x{E662}\x{E663}\x{E664}\x{E665}\x{E666}\x{E667}\x{E668}\x{E669}\x{E66A}\x{E66B}\x{E66C}\x{E66D}\x{E66E}\x{E66F}\x{E670}\x{E671}\x{E672}\x{E673}\x{E674}\x{E675}\x{E676}\x{E677}\x{E678}\x{E679}\x{E67A}\x{E67B}\x{E67C}\x{E67D}\x{E67E}\x{E67F}\x{E680}\x{E681}\x{E682}\x{E683}\x{E684}\x{E685}\x{E686}\x{E687}\x{E688}\x{E689}\x{E68A}\x{E68B}\x{E68C}\x{E68D}\x{E68E}\x{E68F}\x{E690}\x{E691}\x{E692}\x{E693}\x{E694}\x{E695}\x{E696}\x{E697}\x{E698}\x{E699}\x{E69A}\x{E69B}\x{E69C}\x{E69D}\x{E69E}\x{E69F}\x{E6A0}\x{E6A1}\x{E6A2}\x{E6A3}\x{E6A4}\x{E6A5}\x{E6A6}\x{E6A7}\x{E6A8}\x{E6A9}\x{E6AA}\x{E6AB}\x{E6AC}\x{E6AD}\x{E6AE}\x{E6AF}\x{E6B0}\x{E6B1}\x{E6B2}\x{E6B3}\x{E6B4}\x{E6B5}\x{E6B6}\x{E6B7}\x{E6B8}\x{E6B9}\x{E6BA}\x{E6BB}\x{E6BC}\x{E6BD}\x{E6BE}\x{E6BF}\x{E6C0}\x{E6C1}\x{E6C2}\x{E6C3}\x{E6C4}\x{E6C5}\x{E6C6}\x{E6C7}\x{E6C8}\x{E6C9}\x{E6CA}\x{E6CB}\x{E6CC}\x{E6CD}\x{E6CE}\x{E6CF}\x{E6D0}\x{E6D1}\x{E6D2}\x{E6D3}\x{E6D4}\x{E6D5}\x{E6D6}\x{E6D7}\x{E6D8}\x{E6D9}\x{E6DA}\x{E6DB}\x{E6DC}\x{E6DD}\x{E6DE}\x{E6DF}\x{E6E0}\x{E6E1}\x{E6E2}\x{E6E3}\x{E6E4}\x{E6E5}\x{E6E6}\x{E6E7}\x{E6E8}\x{E6E9}\x{E6EA}\x{E6EB}\x{E6EC}\x{E6ED}\x{E6EE}\x{E6EF}\x{E6F0}\x{E6F1}\x{E6F2}\x{E6F3}\x{E6F4}\x{E6F5}\x{E6F6}\x{E6F7}\x{E6F8}\x{E6F9}\x{E6FA}\x{E6FB}\x{E6FC}\x{E6FD}\x{E6FE}\x{E6FF}\x{E700}\x{E701}\x{E702}\x{E703}\x{E704}\x{E705}\x{E706}\x{E707}\x{E708}\x{E709}\x{E70A}\x{E70B}\x{E70C}\x{E70D}\x{E70E}\x{E70F}\x{E710}\x{E711}\x{E712}\x{E713}\x{E714}\x{E715}\x{E716}\x{E717}\x{E718}\x{E719}\x{E71A}\x{E71B}\x{E71C}\x{E71D}\x{E71E}\x{E71F}\x{E720}\x{E721}\x{E722}\x{E723}\x{E724}\x{E725}\x{E726}\x{E727}\x{E728}\x{E729}\x{E72A}\x{E72B}\x{E72C}\x{E72D}\x{E72E}\x{E72F}\x{E730}\x{E731}\x{E732}\x{E733}\x{E734}\x{E735}\x{E736}\x{E737}\x{E738}\x{E739}\x{E73A}\x{E73B}\x{E73C}\x{E73D}\x{E73E}\x{E73F}\x{E740}\x{E741}\x{E742}\x{E743}\x{E744}\x{E745}\x{E746}\x{E747}\x{E748}\x{E749}\x{E74A}\x{E74B}\x{E74C}\x{E74D}\x{E74E}\x{E74F}\x{E750}\x{E751}\x{E752}\x{E753}\x{E754}\x{E755}\x{E756}\x{E757}]
    [\x{FE000}\x{FE001}\x{FE002}\x{FE003}\x{FE004}\x{FE005}\x{FE006}\x{FE007}\x{FE02B}\x{FE02C}\x{FE02D}\x{FE02E}\x{FE02F}\x{FE030}\x{FE031}\x{FE032}\x{FE033}\x{FE034}\x{FE035}\x{FE036}\x{FE7D0}\x{FE7D1}\x{FE7D2}\x{FE7D3}\x{FE7D4}\x{FE7D5}\x{FE7D6}\x{FE7D7}\x{FE522}\x{FE7DF}\x{FE7E1}\x{FE7E2}\x{FE7E4}\x{FE7E5}\x{FE7E6}\x{FE7E8}\x{FE7E9}\x{FE4B0}\x{FE4B2}\x{FE4B3}\x{FE4B4}\x{FE4B5}\x{FE4B6}\x{FE4B7}\x{FE4B9}\x{FE7F5}\x{FE7F6}\x{FE7F7}\x{FE506}\x{FE980}\x{FE981}\x{FE982}\x{FE983}\x{FE960}\x{FE4D6}\x{FE53E}\x{FE800}\x{FE801}\x{FEAF0}\x{FE7FC}\x{FE803}\x{FE804}\x{FE805}\x{FE806}\x{FE807}\x{FEB1E}\x{FEB1F}\x{FE4EF}\x{FE4F0}\x{FE546}\x{FE50F}\x{FE510}\x{FE511}\x{FE523}\x{FE525}\x{FE527}\x{FE81C}\x{FE80A}\x{FE81D}\x{FEB1A}\x{FEB1B}\x{FEB1C}\x{FEB1D}\x{FE190}\x{FE191}\x{FEB93}\x{FEB94}\x{FEB95}\x{FEAF1}\x{FEAF2}\x{FE553}\x{FE4CD}\x{FE4CE}\x{FEB20}\x{FE011}\x{FE012}\x{FE013}\x{FE014}\x{FE015}\x{FE1B7}\x{FE1B8}\x{FE7EA}\x{FE512}\x{FEAF3}\x{FEE16}\x{FEE17}\x{FEE18}\x{FEE19}\x{FEE1A}\x{FEE1B}\x{FE808}\x{FE4F1}\x{FE536}\x{FEE1C}\x{FEE1D}\x{FE19A}\x{FE537}\x{FE008}\x{FEE1E}\x{FEE1F}\x{FEE20}\x{FE018}\x{FE019}\x{FE01A}\x{FE02A}\x{FEE21}\x{FEE22}\x{FEE23}\x{FEE24}\x{FEE25}\x{FEE26}\x{FEE27}\x{FEE28}\x{FEE29}\x{FEE2A}\x{FEE2B}\x{FEE2C}\x{FEE2D}\x{FEE2E}\x{FEE2F}\x{FEE30}\x{FEE31}\x{FEE32}\x{FEE33}\x{FE526}\x{FE52B}\x{FE528}\x{FEE10}\x{FEE11}\x{FE529}\x{FEE12}\x{FEE13}\x{FE4E2}\x{FEB21}\x{FEB81}\x{FEB82}\x{FEB83}\x{FEB84}\x{FEB85}\x{FEB36}\x{FEB22}\x{FE82B}\x{FE82C}\x{FE82D}\x{FE82E}\x{FE82F}\x{FE830}\x{FE831}\x{FE832}\x{FE833}\x{FE834}\x{FE835}\x{FE836}\x{FE837}\x{FEB0C}\x{FEB0D}\x{FEB0E}\x{FEB0F}\x{FE330}\x{FE320}\x{FE323}\x{FE33F}\x{FE324}\x{FEAF4}\x{FE813}\x{FE7FA}\x{FEB55}\x{FE823}\x{FEB60}\x{FEB56}\x{FEB57}\x{FEB96}\x{FEB58}\x{FE814}\x{FEAF5}\x{FEB59}\x{FEB04}\x{FEB05}\x{FEB06}\x{FEB5A}\x{FEB5B}\x{FEB5C}\x{FEB5D}\x{FEB07}\x{FEB08}\x{FEB27}\x{FEE14}\x{FEE15}\x{FE4CF}\x{FE4DC}\x{FE195}\x{FE4D0}\x{FE7D8}\x{FE4F2}\x{FE4F3}\x{FE4DD}\x{FE538}\x{FE824}\x{FE4C9}\x{FE539}\x{FE4D1}\x{FE825}\x{FE01B}\x{FE7EB}\x{FE984}\x{FE01D}\x{FE340}\x{FE33E}\x{FE331}\x{FE344}\x{FE33D}\x{FE326}\x{FE327}\x{FEB97}\x{FE329}\x{FE347}\x{FE332}\x{FE33C}\x{FE343}\x{FE33A}\x{FE339}\x{FEB28}\x{FE53A}\x{FEB29}\x{FEB2A}\x{FE7D9}\x{FEB2B}\x{FEB2C}\x{FEB2D}\x{FEB23}\x{FEB2E}\x{FEB2F}\x{FEB30}\x{FEB31}\x{FEAF6}\x{FEAF7}\x{FE4BA}\x{FE038}\x{FE4C3}\x{FE03C}\x{FE04F}\x{FE03D}\x{FE050}\x{FE051}\x{FE03E}\x{FE03F}\x{FE040}\x{FE961}\x{FE962}\x{FE985}\x{FE963}\x{FE964}\x{FE1B9}\x{FE1BA}\x{FE1BC}\x{FE1BD}\x{FE32B}\x{FE333}\x{FE1BE}\x{FE1BF}\x{FE986}\x{FE341}];
}

our %map_google_unicode_to_docomo_unicode = (
    "\x{FE000}"=>"\x{E63E}", "\x{FE001}"=>"\x{E63F}", "\x{FE002}"=>"\x{E640}", "\x{FE003}"=>"\x{E641}", "\x{FE004}"=>"\x{E642}", "\x{FE005}"=>"\x{E643}", "\x{FE006}"=>"\x{E644}", "\x{FE007}"=>"\x{E645}", "\x{FE008}"=>"\x{E6B3}", "\x{FE009}"=>"\x{E63E}", "\x{FE00A}"=>"\x{E63E}", "\x{FE00C}"=>"\x{E63E}", "\x{FE00F}"=>"\x{E63E}\x{E63F}", "\x{FE010}"=>"\x{E6B3}", "\x{FE011}"=>"\x{E69C}", "\x{FE012}"=>"\x{E69D}", "\x{FE013}"=>"\x{E69E}", "\x{FE014}"=>"\x{E69F}", "\x{FE015}"=>"\x{E6A0}", "\x{FE016}"=>"\x{E69E}", "\x{FE018}"=>"\x{E6B7}", "\x{FE019}"=>"\x{E6B8}", "\x{FE01A}"=>"\x{E6B9}", "\x{FE01B}"=>"\x{E71C}", "\x{FE01C}"=>"\x{E71C}", "\x{FE01D}"=>"\x{E71F}", "\x{FE01E}"=>"\x{E6BA}", "\x{FE01F}"=>"\x{E6BA}", "\x{FE020}"=>"\x{E6BA}", "\x{FE021}"=>"\x{E6BA}", "\x{FE022}"=>"\x{E6BA}", "\x{FE023}"=>"\x{E6BA}", "\x{FE024}"=>"\x{E6BA}", "\x{FE025}"=>"\x{E6BA}", "\x{FE026}"=>"\x{E6BA}", "\x{FE027}"=>"\x{E6BA}", "\x{FE028}"=>"\x{E6BA}", "\x{FE029}"=>"\x{E6BA}", "\x{FE02A}"=>"\x{E6BA}", "\x{FE02B}"=>"\x{E646}", "\x{FE02C}"=>"\x{E647}", "\x{FE02D}"=>"\x{E648}", "\x{FE02E}"=>"\x{E649}", "\x{FE02F}"=>"\x{E64A}", "\x{FE030}"=>"\x{E64B}", "\x{FE031}"=>"\x{E64C}", "\x{FE032}"=>"\x{E64D}", "\x{FE033}"=>"\x{E64E}", "\x{FE034}"=>"\x{E64F}", "\x{FE035}"=>"\x{E650}", "\x{FE036}"=>"\x{E651}", "\x{FE038}"=>"\x{E73F}", "\x{FE03B}"=>"\x{E6B3}", "\x{FE03C}"=>"\x{E741}", "\x{FE03D}"=>"\x{E743}", "\x{FE03E}"=>"\x{E746}", "\x{FE03F}"=>"\x{E747}", "\x{FE040}"=>"\x{E748}", "\x{FE042}"=>"\x{E747}", "\x{FE04E}"=>"\x{E741}", "\x{FE04F}"=>"\x{E742}", "\x{FE050}"=>"\x{E744}", "\x{FE051}"=>"\x{E745}", "\x{FE05B}"=>"\x{E745}", "\x{FE190}"=>"\x{E691}", "\x{FE191}"=>"\x{E692}", "\x{FE193}"=>"\x{E6F9}", "\x{FE194}"=>"\x{E728}", "\x{FE195}"=>"\x{E710}", "\x{FE198}"=>"\x{E675}", "\x{FE19A}"=>"\x{E6B1}", "\x{FE19B}"=>"\x{E6F0}", "\x{FE19C}"=>"\x{E6F0}", "\x{FE19D}"=>"\x{E6F0}", "\x{FE19E}"=>"\x{E6F0}", "\x{FE1B7}"=>"\x{E6A1}", "\x{FE1B8}"=>"\x{E6A2}", "\x{FE1B9}"=>"\x{E74E}", "\x{FE1BA}"=>"\x{E74F}", "\x{FE1BB}"=>"\x{E74F}", "\x{FE1BC}"=>"\x{E750}", "\x{FE1BD}"=>"\x{E751}", "\x{FE1BE}"=>"\x{E754}", "\x{FE1BF}"=>"\x{E755}", "\x{FE1C8}"=>"\x{E74F}", "\x{FE1C9}"=>"\x{E751}", "\x{FE1D0}"=>"\x{E6A1}", "\x{FE1D8}"=>"\x{E6A1}", "\x{FE1D9}"=>"\x{E751}", "\x{FE1DB}"=>"\x{E698}", "\x{FE1DD}"=>"\x{E74F}", "\x{FE1E0}"=>"\x{E755}", "\x{FE320}"=>"\x{E6F1}", "\x{FE321}"=>"\x{E6F3}", "\x{FE322}"=>"\x{E6F4}", "\x{FE323}"=>"\x{E6F2}", "\x{FE324}"=>"\x{E6F4}", "\x{FE325}"=>"\x{E723}", "\x{FE326}"=>"\x{E725}", "\x{FE327}"=>"\x{E726}", "\x{FE328}"=>"\x{E753}", "\x{FE329}"=>"\x{E728}", "\x{FE32A}"=>"\x{E728}", "\x{FE32B}"=>"\x{E752}", "\x{FE32C}"=>"\x{E726}", "\x{FE32D}"=>"\x{E726}", "\x{FE32F}"=>"\x{E72A}", "\x{FE330}"=>"\x{E6F0}", "\x{FE331}"=>"\x{E722}", "\x{FE332}"=>"\x{E72A}", "\x{FE333}"=>"\x{E753}", "\x{FE334}"=>"\x{E72A}", "\x{FE335}"=>"\x{E6F0}", "\x{FE336}"=>"\x{E6F0}", "\x{FE337}"=>"\x{E6F0}", "\x{FE338}"=>"\x{E6F0}", "\x{FE339}"=>"\x{E72E}", "\x{FE33A}"=>"\x{E72D}", "\x{FE33B}"=>"\x{E757}", "\x{FE33C}"=>"\x{E72B}", "\x{FE33D}"=>"\x{E724}", "\x{FE33E}"=>"\x{E721}", "\x{FE33F}"=>"\x{E6F3}", "\x{FE340}"=>"\x{E720}", "\x{FE341}"=>"\x{E757}", "\x{FE342}"=>"\x{E701}", "\x{FE343}"=>"\x{E72C}", "\x{FE344}"=>"\x{E723}", "\x{FE345}"=>"\x{E723}", "\x{FE346}"=>"\x{E72B}", "\x{FE347}"=>"\x{E729}", "\x{FE348}"=>"\x{E6F0}", "\x{FE349}"=>"\x{E753}", "\x{FE34A}"=>"\x{E72A}", "\x{FE34B}"=>"\x{E726}", "\x{FE34C}"=>"\x{E726}", "\x{FE34D}"=>"\x{E72E}", "\x{FE34E}"=>"\x{E724}", "\x{FE34F}"=>"\x{E753}", "\x{FE350}"=>"\x{E6F3}", "\x{FE351}"=>"\x{E72F}", "\x{FE352}"=>"\x{E70B}", "\x{FE359}"=>"\x{E6F3}", "\x{FE35A}"=>"\x{E6F1}", "\x{FE4B0}"=>"\x{E663}", "\x{FE4B1}"=>"\x{E663}", "\x{FE4B2}"=>"\x{E664}", "\x{FE4B3}"=>"\x{E665}", "\x{FE4B4}"=>"\x{E666}", "\x{FE4B5}"=>"\x{E667}", "\x{FE4B6}"=>"\x{E668}", "\x{FE4B7}"=>"\x{E669}", "\x{FE4B8}"=>"\x{E669}\x{E6EF}", "\x{FE4B9}"=>"\x{E66A}", "\x{FE4BA}"=>"\x{E73E}", "\x{FE4C1}"=>"\x{E661}", "\x{FE4C2}"=>"\x{E74B}", "\x{FE4C3}"=>"\x{E740}", "\x{FE4C9}"=>"\x{E718}", "\x{FE4CC}"=>"\x{E699}", "\x{FE4CD}"=>"\x{E699}", "\x{FE4CE}"=>"\x{E69A}", "\x{FE4CF}"=>"\x{E70E}", "\x{FE4D0}"=>"\x{E711}", "\x{FE4D1}"=>"\x{E71A}", "\x{FE4D2}"=>"\x{E71A}", "\x{FE4D6}"=>"\x{E674}", "\x{FE4D7}"=>"\x{E674}", "\x{FE4DB}"=>"\x{E70E}", "\x{FE4DC}"=>"\x{E70F}", "\x{FE4DD}"=>"\x{E715}", "\x{FE4E0}"=>"\x{E715}", "\x{FE4E2}"=>"\x{E6D6}", "\x{FE4E3}"=>"\x{E715}", "\x{FE4EF}"=>"\x{E681}", "\x{FE4F0}"=>"\x{E682}", "\x{FE4F1}"=>"\x{E6AD}", "\x{FE4F2}"=>"\x{E713}", "\x{FE4F3}"=>"\x{E714}", "\x{FE4F9}"=>"\x{E677}", "\x{FE4FB}"=>"\x{E6FB}", "\x{FE4FD}"=>"\x{E70A}", "\x{FE4FF}"=>"\x{E683}", "\x{FE500}"=>"\x{E683}", "\x{FE501}"=>"\x{E683}", "\x{FE502}"=>"\x{E683}", "\x{FE503}"=>"\x{E683}", "\x{FE505}"=>"\x{E6F7}", "\x{FE506}"=>"\x{E66E}", "\x{FE507}"=>"\x{E66E}", "\x{FE508}"=>"\x{E66E}", "\x{FE50F}"=>"\x{E684}", "\x{FE510}"=>"\x{E685}", "\x{FE511}"=>"\x{E686}", "\x{FE512}"=>"\x{E6A4}", "\x{FE522}"=>"\x{E65A}", "\x{FE523}"=>"\x{E687}", "\x{FE524}"=>"\x{E687}", "\x{FE525}"=>"\x{E688}", "\x{FE526}"=>"\x{E6CE}", "\x{FE527}"=>"\x{E689}", "\x{FE528}"=>"\x{E6D0}", "\x{FE529}"=>"\x{E6D3}", "\x{FE52A}"=>"\x{E6CF}", "\x{FE52B}"=>"\x{E6CF}", "\x{FE52C}"=>"\x{E665}", "\x{FE52D}"=>"\x{E665}", "\x{FE52E}"=>"\x{E665}", "\x{FE535}"=>"\x{E685}", "\x{FE536}"=>"\x{E6AE}", "\x{FE537}"=>"\x{E6B2}", "\x{FE538}"=>"\x{E716}", "\x{FE539}"=>"\x{E719}", "\x{FE53A}"=>"\x{E730}", "\x{FE53B}"=>"\x{E682}", "\x{FE53E}"=>"\x{E675}", "\x{FE540}"=>"\x{E689}", "\x{FE541}"=>"\x{E689}", "\x{FE545}"=>"\x{E683}", "\x{FE546}"=>"\x{E683}", "\x{FE547}"=>"\x{E683}", "\x{FE548}"=>"\x{E689}", "\x{FE54D}"=>"\x{E683}", "\x{FE54F}"=>"\x{E683}", "\x{FE552}"=>"\x{E689}", "\x{FE553}"=>"\x{E698}", "\x{FE7D0}"=>"\x{E652}", "\x{FE7D1}"=>"\x{E653}", "\x{FE7D2}"=>"\x{E654}", "\x{FE7D3}"=>"\x{E655}", "\x{FE7D4}"=>"\x{E656}", "\x{FE7D5}"=>"\x{E657}", "\x{FE7D6}"=>"\x{E658}", "\x{FE7D7}"=>"\x{E659}", "\x{FE7D8}"=>"\x{E712}", "\x{FE7D9}"=>"\x{E733}", "\x{FE7DA}"=>"\x{E712}", "\x{FE7DC}"=>"\x{E754}", "\x{FE7DF}"=>"\x{E65B}", "\x{FE7E0}"=>"\x{E65C}", "\x{FE7E1}"=>"\x{E65C}", "\x{FE7E2}"=>"\x{E65D}", "\x{FE7E3}"=>"\x{E65D}", "\x{FE7E4}"=>"\x{E65E}", "\x{FE7E5}"=>"\x{E65F}", "\x{FE7E6}"=>"\x{E660}", "\x{FE7E8}"=>"\x{E661}", "\x{FE7E9}"=>"\x{E662}", "\x{FE7EA}"=>"\x{E6A3}", "\x{FE7EB}"=>"\x{E71D}", "\x{FE7EE}"=>"\x{E6A3}", "\x{FE7EF}"=>"\x{E65E}", "\x{FE7F0}"=>"\x{E733}", "\x{FE7F5}"=>"\x{E66B}", "\x{FE7F6}"=>"\x{E66C}", "\x{FE7F7}"=>"\x{E66D}", "\x{FE7FA}"=>"\x{E6F7}", "\x{FE7FC}"=>"\x{E679}", "\x{FE7FF}"=>"\x{E751}", "\x{FE800}"=>"\x{E676}", "\x{FE801}"=>"\x{E677}", "\x{FE802}"=>"\x{E677}", "\x{FE803}"=>"\x{E67A}", "\x{FE804}"=>"\x{E67B}", "\x{FE805}"=>"\x{E67C}", "\x{FE806}"=>"\x{E67D}", "\x{FE807}"=>"\x{E67E}", "\x{FE808}"=>"\x{E6AC}", "\x{FE80A}"=>"\x{E68B}", "\x{FE813}"=>"\x{E6F6}", "\x{FE814}"=>"\x{E6FF}", "\x{FE81A}"=>"\x{E6FF}", "\x{FE81C}"=>"\x{E68A}", "\x{FE81D}"=>"\x{E68C}", "\x{FE81E}"=>"\x{E68C}", "\x{FE823}"=>"\x{E6F9}", "\x{FE824}"=>"\x{E717}", "\x{FE825}"=>"\x{E71B}", "\x{FE826}"=>"\x{E71B}", "\x{FE827}"=>"\x{E6F9}", "\x{FE829}"=>"\x{E6ED}", "\x{FE82B}"=>"\x{E6DF}", "\x{FE82C}"=>"\x{E6E0}", "\x{FE82D}"=>"\x{E6E1}", "\x{FE82E}"=>"\x{E6E2}", "\x{FE82F}"=>"\x{E6E3}", "\x{FE830}"=>"\x{E6E4}", "\x{FE831}"=>"\x{E6E5}", "\x{FE832}"=>"\x{E6E6}", "\x{FE833}"=>"\x{E6E7}", "\x{FE834}"=>"\x{E6E8}", "\x{FE835}"=>"\x{E6E9}", "\x{FE836}"=>"\x{E6EA}", "\x{FE837}"=>"\x{E6EB}", "\x{FE960}"=>"\x{E673}", "\x{FE961}"=>"\x{E749}", "\x{FE962}"=>"\x{E74A}", "\x{FE963}"=>"\x{E74C}", "\x{FE964}"=>"\x{E74D}", "\x{FE96A}"=>"\x{E74C}", "\x{FE973}"=>"\x{E643}", "\x{FE980}"=>"\x{E66F}", "\x{FE981}"=>"\x{E670}", "\x{FE982}"=>"\x{E671}", "\x{FE983}"=>"\x{E672}", "\x{FE984}"=>"\x{E71E}", "\x{FE985}"=>"\x{E74B}", "\x{FE986}"=>"\x{E756}", "\x{FE987}"=>"\x{E672}", "\x{FE988}"=>"\x{E671}", "\x{FEAF0}"=>"\x{E678}", "\x{FEAF1}"=>"\x{E696}", "\x{FEAF2}"=>"\x{E697}", "\x{FEAF3}"=>"\x{E6A5}", "\x{FEAF4}"=>"\x{E6F5}", "\x{FEAF5}"=>"\x{E700}", "\x{FEAF6}"=>"\x{E73C}", "\x{FEAF7}"=>"\x{E73D}", "\x{FEB04}"=>"\x{E702}", "\x{FEB05}"=>"\x{E703}", "\x{FEB06}"=>"\x{E704}", "\x{FEB07}"=>"\x{E709}", "\x{FEB08}"=>"\x{E70A}", "\x{FEB0B}"=>"\x{E702}", "\x{FEB0C}"=>"\x{E6EC}", "\x{FEB0D}"=>"\x{E6ED}", "\x{FEB0E}"=>"\x{E6EE}", "\x{FEB0F}"=>"\x{E6EF}", "\x{FEB10}"=>"\x{E6EC}", "\x{FEB11}"=>"\x{E6ED}", "\x{FEB12}"=>"\x{E6EC}", "\x{FEB13}"=>"\x{E6EC}", "\x{FEB14}"=>"\x{E6EC}", "\x{FEB15}"=>"\x{E6EC}", "\x{FEB16}"=>"\x{E6EC}", "\x{FEB17}"=>"\x{E6EC}", "\x{FEB18}"=>"\x{E6ED}", "\x{FEB19}"=>"\x{E6F8}", "\x{FEB1A}"=>"\x{E68D}", "\x{FEB1B}"=>"\x{E68E}", "\x{FEB1C}"=>"\x{E68F}", "\x{FEB1D}"=>"\x{E690}", "\x{FEB1E}"=>"\x{E67F}", "\x{FEB1F}"=>"\x{E680}", "\x{FEB20}"=>"\x{E69B}", "\x{FEB21}"=>"\x{E6D7}", "\x{FEB22}"=>"\x{E6DE}", "\x{FEB23}"=>"\x{E737}", "\x{FEB26}"=>"\x{E72F}", "\x{FEB27}"=>"\x{E70B}", "\x{FEB28}"=>"\x{E72F}", "\x{FEB29}"=>"\x{E731}", "\x{FEB2A}"=>"\x{E732}", "\x{FEB2B}"=>"\x{E734}", "\x{FEB2C}"=>"\x{E735}", "\x{FEB2D}"=>"\x{E736}", "\x{FEB2E}"=>"\x{E738}", "\x{FEB2F}"=>"\x{E739}", "\x{FEB30}"=>"\x{E73A}", "\x{FEB31}"=>"\x{E73B}", "\x{FEB36}"=>"\x{E6DD}", "\x{FEB44}"=>"\x{E6A0}", "\x{FEB48}"=>"\x{E738}", "\x{FEB55}"=>"\x{E6F8}", "\x{FEB56}"=>"\x{E6FB}", "\x{FEB57}"=>"\x{E6FC}", "\x{FEB58}"=>"\x{E6FE}", "\x{FEB59}"=>"\x{E701}", "\x{FEB5A}"=>"\x{E705}", "\x{FEB5B}"=>"\x{E706}", "\x{FEB5C}"=>"\x{E707}", "\x{FEB5D}"=>"\x{E708}", "\x{FEB60}"=>"\x{E6FA}", "\x{FEB61}"=>"\x{E6F8}", "\x{FEB62}"=>"\x{E6F8}", "\x{FEB63}"=>"\x{E69C}", "\x{FEB64}"=>"\x{E69C}", "\x{FEB65}"=>"\x{E69C}", "\x{FEB66}"=>"\x{E69C}", "\x{FEB67}"=>"\x{E69C}", "\x{FEB77}"=>"\x{E6FA}", "\x{FEB81}"=>"\x{E6D8}", "\x{FEB82}"=>"\x{E6D9}", "\x{FEB83}"=>"\x{E6DA}", "\x{FEB84}"=>"\x{E6DB}", "\x{FEB85}"=>"\x{E6DC}", "\x{FEB86}"=>"\x{E6D9}", "\x{FEB87}"=>"\x{E6D9}", "\x{FEB8A}"=>"\x{E6D9}", "\x{FEB8D}"=>"\x{E6DC}", "\x{FEB90}"=>"\x{E6D9}", "\x{FEB91}"=>"\x{E735}", "\x{FEB92}"=>"\x{E6D3}", "\x{FEB93}"=>"\x{E693}", "\x{FEB94}"=>"\x{E694}", "\x{FEB95}"=>"\x{E695}", "\x{FEB96}"=>"\x{E6FD}", "\x{FEB97}"=>"\x{E727}", "\x{FEB9D}"=>"\x{E695}", "\x{FEB9F}"=>"\x{E70B}", "\x{FEBA0}"=>"\x{E700}", "\x{FEBA1}"=>"\x{E695}", "\x{FEE10}"=>"\x{E6D1}", "\x{FEE11}"=>"\x{E6D2}", "\x{FEE12}"=>"\x{E6D4}", "\x{FEE13}"=>"\x{E6D5}", "\x{FEE14}"=>"\x{E70C}", "\x{FEE15}"=>"\x{E70D}", "\x{FEE16}"=>"\x{E6A6}", "\x{FEE17}"=>"\x{E6A7}", "\x{FEE18}"=>"\x{E6A8}", "\x{FEE19}"=>"\x{E6A9}", "\x{FEE1A}"=>"\x{E6AA}", "\x{FEE1B}"=>"\x{E6AB}", "\x{FEE1C}"=>"\x{E6AF}", "\x{FEE1D}"=>"\x{E6B0}", "\x{FEE1E}"=>"\x{E6B4}", "\x{FEE1F}"=>"\x{E6B5}", "\x{FEE20}"=>"\x{E6B6}", "\x{FEE21}"=>"\x{E6BB}", "\x{FEE22}"=>"\x{E6BC}", "\x{FEE23}"=>"\x{E6BD}", "\x{FEE24}"=>"\x{E6BE}", "\x{FEE25}"=>"\x{E6BF}", "\x{FEE26}"=>"\x{E6C0}", "\x{FEE27}"=>"\x{E6C1}", "\x{FEE28}"=>"\x{E6C2}", "\x{FEE29}"=>"\x{E6C3}", "\x{FEE2A}"=>"\x{E6C4}", "\x{FEE2B}"=>"\x{E6C5}", "\x{FEE2C}"=>"\x{E6C6}", "\x{FEE2D}"=>"\x{E6C7}", "\x{FEE2E}"=>"\x{E6C8}", "\x{FEE2F}"=>"\x{E6C9}", "\x{FEE30}"=>"\x{E6CA}", "\x{FEE31}"=>"\x{E6CB}", "\x{FEE32}"=>"\x{E6CC}", "\x{FEE33}"=>"\x{E6CD}"
);

sub google_unicode_to_docomo_unicode {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_docomo_unicode{$1} || &$check(ord $1)
    }egomx;
}

sub kddi_unicode_to_google_unicode {
    $_[1] =~ tr
    [\x{E468}\x{E469}\x{E46A}\x{E46B}\x{E46C}\x{E46D}\x{E46E}\x{E46F}\x{E470}\x{E471}\x{E472}\x{E473}\x{E474}\x{E475}\x{E476}\x{E477}\x{E478}\x{E479}\x{E47A}\x{E47B}\x{E47C}\x{E47D}\x{E47E}\x{E47F}\x{E480}\x{E481}\x{E482}\x{E483}\x{E484}\x{E485}\x{E486}\x{E487}\x{E488}\x{E489}\x{E48A}\x{E48B}\x{E48C}\x{E48D}\x{E48E}\x{E48F}\x{E490}\x{E491}\x{E492}\x{E493}\x{E494}\x{E495}\x{E496}\x{E497}\x{E498}\x{E499}\x{E49A}\x{E49B}\x{E49C}\x{E49D}\x{E49E}\x{E49F}\x{E4A0}\x{E4A1}\x{E4A2}\x{E4A3}\x{E4A4}\x{E4A5}\x{E4A6}\x{E4A7}\x{E4A8}\x{E4A9}\x{E4AA}\x{E4AB}\x{E4AC}\x{E4AD}\x{E4AE}\x{E4AF}\x{E4B0}\x{E4B1}\x{E4B2}\x{E4B3}\x{E4B4}\x{E4B5}\x{E4B6}\x{E4B7}\x{E4B8}\x{E4B9}\x{E4BA}\x{E4BB}\x{E4BC}\x{E4BD}\x{E4BE}\x{E4BF}\x{E4C0}\x{E4C1}\x{E4C2}\x{E4C3}\x{E4C4}\x{E4C5}\x{E4C6}\x{E4C7}\x{E4C8}\x{E4C9}\x{E4CA}\x{E4CB}\x{E4CC}\x{E4CD}\x{E4CE}\x{E4CF}\x{E4D0}\x{E4D1}\x{E4D2}\x{E4D3}\x{E4D4}\x{E4D5}\x{E4D6}\x{E4D7}\x{E4D8}\x{E4D9}\x{E4DA}\x{E4DB}\x{E4DC}\x{E4DD}\x{E4DE}\x{E4DF}\x{E4E0}\x{E4E1}\x{E4E2}\x{E4E3}\x{E4E4}\x{E4E5}\x{E4E6}\x{E4E7}\x{E4E8}\x{E4E9}\x{E4EA}\x{E4EB}\x{E4EC}\x{E4ED}\x{E4EE}\x{E4EF}\x{E4F0}\x{E4F1}\x{E4F2}\x{E4F3}\x{E4F4}\x{E4F5}\x{E4F6}\x{E4F7}\x{E4F8}\x{E4F9}\x{E4FA}\x{E4FB}\x{E4FC}\x{E4FD}\x{E4FE}\x{E4FF}\x{E500}\x{E501}\x{E502}\x{E503}\x{E504}\x{E505}\x{E506}\x{E507}\x{E508}\x{E509}\x{E50A}\x{E50B}\x{E50C}\x{E50D}\x{E50E}\x{E50F}\x{E510}\x{E511}\x{E512}\x{E513}\x{E514}\x{E515}\x{E516}\x{E517}\x{E518}\x{E519}\x{E51A}\x{E51B}\x{E51C}\x{E51D}\x{E51E}\x{E51F}\x{E520}\x{E521}\x{E522}\x{E523}\x{E524}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}\x{E53F}\x{E540}\x{E541}\x{E542}\x{E543}\x{E544}\x{E545}\x{E546}\x{E547}\x{E548}\x{E549}\x{E54A}\x{E54B}\x{E54C}\x{E54D}\x{E54E}\x{E54F}\x{E550}\x{E551}\x{E552}\x{E553}\x{E554}\x{E555}\x{E556}\x{E557}\x{E558}\x{E559}\x{E55A}\x{E55B}\x{E55C}\x{E55D}\x{E55E}\x{E55F}\x{E560}\x{E561}\x{E562}\x{E563}\x{E564}\x{E565}\x{E566}\x{E567}\x{E568}\x{E569}\x{E56A}\x{E56B}\x{E56C}\x{E56D}\x{E56E}\x{E56F}\x{E570}\x{E571}\x{E572}\x{E573}\x{E574}\x{E575}\x{E576}\x{E577}\x{E578}\x{E579}\x{E57A}\x{E57B}\x{E57C}\x{E57D}\x{E57E}\x{E57F}\x{E580}\x{E581}\x{E582}\x{E583}\x{E584}\x{E585}\x{E586}\x{E587}\x{E588}\x{E589}\x{E58A}\x{E58B}\x{E58C}\x{E58D}\x{E58E}\x{E58F}\x{E590}\x{E591}\x{E592}\x{E593}\x{E594}\x{E595}\x{E596}\x{E597}\x{E598}\x{E599}\x{E59A}\x{E59B}\x{E59C}\x{E59D}\x{E59E}\x{E59F}\x{E5A0}\x{E5A1}\x{E5A2}\x{E5A3}\x{E5A4}\x{E5A5}\x{E5A6}\x{E5A7}\x{E5A8}\x{E5A9}\x{E5AA}\x{E5AB}\x{E5AC}\x{E5AD}\x{E5AE}\x{E5AF}\x{E5B0}\x{E5B1}\x{E5B2}\x{E5B3}\x{E5B4}\x{E5B5}\x{E5B6}\x{E5B7}\x{E5B8}\x{E5B9}\x{E5BA}\x{E5BB}\x{E5BC}\x{E5BD}\x{E5BE}\x{E5BF}\x{E5C0}\x{E5C1}\x{E5C2}\x{E5C3}\x{E5C4}\x{E5C5}\x{E5C6}\x{E5C7}\x{E5C8}\x{E5C9}\x{E5CA}\x{E5CB}\x{E5CC}\x{E5CD}\x{E5CE}\x{E5CF}\x{E5D0}\x{E5D1}\x{E5D2}\x{E5D3}\x{E5D4}\x{E5D5}\x{E5D6}\x{E5D7}\x{E5D8}\x{E5D9}\x{E5DA}\x{E5DB}\x{E5DC}\x{E5DD}\x{E5DE}\x{E5DF}\x{EA80}\x{EA81}\x{EA82}\x{EA83}\x{EA84}\x{EA85}\x{EA86}\x{EA87}\x{EA88}\x{EA89}\x{EA8A}\x{EA8B}\x{EA8C}\x{EA8D}\x{EA8E}\x{EA8F}\x{EA90}\x{EA91}\x{EA92}\x{EA93}\x{EA94}\x{EA95}\x{EA96}\x{EA97}\x{EA98}\x{EA99}\x{EA9A}\x{EA9B}\x{EA9C}\x{EA9D}\x{EA9E}\x{EA9F}\x{EAA0}\x{EAA1}\x{EAA2}\x{EAA3}\x{EAA4}\x{EAA5}\x{EAA6}\x{EAA7}\x{EAA8}\x{EAA9}\x{EAAA}\x{EAAB}\x{EAAC}\x{EAAD}\x{EAAE}\x{EAAF}\x{EAB0}\x{EAB1}\x{EAB2}\x{EAB3}\x{EAB4}\x{EAB5}\x{EAB6}\x{EAB7}\x{EAB8}\x{EAB9}\x{EABA}\x{EABB}\x{EABC}\x{EABD}\x{EABE}\x{EABF}\x{EAC0}\x{EAC1}\x{EAC2}\x{EAC3}\x{EAC4}\x{EAC5}\x{EAC6}\x{EAC7}\x{EAC8}\x{EAC9}\x{EACA}\x{EACB}\x{EACC}\x{EACD}\x{EACE}\x{EACF}\x{EAD0}\x{EAD1}\x{EAD2}\x{EAD3}\x{EAD4}\x{EAD5}\x{EAD6}\x{EAD7}\x{EAD8}\x{EAD9}\x{EADA}\x{EADB}\x{EADC}\x{EADD}\x{EADE}\x{EADF}\x{EAE0}\x{EAE1}\x{EAE2}\x{EAE3}\x{EAE4}\x{EAE5}\x{EAE6}\x{EAE7}\x{EAE8}\x{EAE9}\x{EAEA}\x{EAEB}\x{EAEC}\x{EAED}\x{EAEE}\x{EAEF}\x{EAF0}\x{EAF1}\x{EAF2}\x{EAF3}\x{EAF4}\x{EAF5}\x{EAF6}\x{EAF7}\x{EAF8}\x{EAF9}\x{EAFA}\x{EAFB}\x{EAFC}\x{EAFD}\x{EAFE}\x{EAFF}\x{EB00}\x{EB01}\x{EB02}\x{EB03}\x{EB04}\x{EB05}\x{EB06}\x{EB07}\x{EB08}\x{EB09}\x{EB0A}\x{EB0B}\x{EB0C}\x{EB0D}\x{EB0E}\x{EB0F}\x{EB10}\x{EB11}\x{EB12}\x{EB13}\x{EB14}\x{EB15}\x{EB16}\x{EB17}\x{EB18}\x{EB19}\x{EB1A}\x{EB1B}\x{EB1C}\x{EB1D}\x{EB1E}\x{EB1F}\x{EB20}\x{EB21}\x{EB22}\x{EB23}\x{EB24}\x{EB25}\x{EB26}\x{EB27}\x{EB28}\x{EB29}\x{EB2A}\x{EB2B}\x{EB2C}\x{EB2D}\x{EB2E}\x{EB2F}\x{EB30}\x{EB31}\x{EB32}\x{EB33}\x{EB34}\x{EB35}\x{EB36}\x{EB37}\x{EB38}\x{EB39}\x{EB3A}\x{EB3B}\x{EB3C}\x{EB3D}\x{EB3E}\x{EB3F}\x{EB40}\x{EB41}\x{EB42}\x{EB43}\x{EB44}\x{EB45}\x{EB46}\x{EB47}\x{EB48}\x{EB49}\x{EB4A}\x{EB4B}\x{EB4C}\x{EB4D}\x{EB4E}\x{EB4F}\x{EB50}\x{EB51}\x{EB52}\x{EB53}\x{EB54}\x{EB55}\x{EB56}\x{EB57}\x{EB58}\x{EB59}\x{EB5A}\x{EB5B}\x{EB5C}\x{EB5D}\x{EB5E}\x{EB5F}\x{EB60}\x{EB61}\x{EB62}\x{EB63}\x{EB64}\x{EB65}\x{EB66}\x{EB67}\x{EB68}\x{EB69}\x{EB6A}\x{EB6B}\x{EB6C}\x{EB6D}\x{EB6E}\x{EB6F}\x{EB70}\x{EB71}\x{EB72}\x{EB73}\x{EB74}\x{EB75}\x{EB76}\x{EB77}\x{EB78}\x{EB79}\x{EB7A}\x{EB7B}\x{EB7C}\x{EB7D}\x{EB7E}\x{EB7F}\x{EB80}\x{EB81}\x{EB82}\x{EB83}\x{EB84}\x{EB85}\x{EB86}\x{EB87}\x{EB88}\x{EB89}\x{EB8A}\x{EB8B}\x{EB8C}\x{EB8D}\x{EB8E}]
    [\x{FEB6A}\x{FE005}\x{FE7F7}\x{FE7D9}\x{FEB77}\x{FE7FD}\x{FE80D}\x{FE520}\x{FE1C3}\x{FE330}\x{FE320}\x{FE33A}\x{FE346}\x{FEB59}\x{FEB56}\x{FEB0E}\x{FEB0F}\x{FEB61}\x{FEB58}\x{FE4F6}\x{FE01B}\x{FEB1E}\x{FEB1F}\x{FEB20}\x{FE044}\x{FEB23}\x{FEB04}\x{FEB09}\x{FEB26}\x{FE003}\x{FE014}\x{FE004}\x{FE000}\x{FE016}\x{FE00E}\x{FEB68}\x{FE002}\x{FE001}\x{FE00F}\x{FE02B}\x{FE02C}\x{FE02D}\x{FE02E}\x{FE02F}\x{FE030}\x{FE031}\x{FE032}\x{FE033}\x{FE034}\x{FE035}\x{FE036}\x{FE037}\x{FE4F0}\x{FE547}\x{FE807}\x{FE546}\x{FE53A}\x{FE539}\x{FE551}\x{FE4B6}\x{FE4B9}\x{FE506}\x{FE7F6}\x{FE7E7}\x{FE531}\x{FE4C1}\x{FE4B5}\x{FE4B0}\x{FE980}\x{FE4B2}\x{FE7EB}\x{FE7E6}\x{FE7E3}\x{FE7E4}\x{FE7F1}\x{FE7E9}\x{FE7EA}\x{FE7DF}\x{FE7D4}\x{FE7D3}\x{FE7D8}\x{FE7D7}\x{FE7D1}\x{FE7DD}\x{FE7FA}\x{FE4C2}\x{FE808}\x{FE010}\x{FE4C4}\x{FE986}\x{FE982}\x{FE983}\x{FE972}\x{FE80C}\x{FE80A}\x{FE4DD}\x{FE80F}\x{FE512}\x{FE040}\x{FE1AE}\x{FE4E5}\x{FE054}\x{FE03F}\x{FE510}\x{FE962}\x{FE965}\x{FE04F}\x{FE1D9}\x{FE053}\x{FE961}\x{FE960}\x{FE1D2}\x{FE1BE}\x{FE1C4}\x{FE1D7}\x{FE1B8}\x{FE1BC}\x{FE1DA}\x{FE1BF}\x{FE1D8}\x{FE1BA}\x{FE1B7}\x{FE047}\x{FE046}\x{FE03D}\x{FEB57}\x{FEB5C}\x{FE329}\x{FEB4F}\x{FEB5E}\x{FEB12}\x{FE823}\x{FE1B1}\x{FE973}\x{FE1DB}\x{FE1B2}\x{FEB7A}\x{FEB2B}\x{FEB7B}\x{FEB96}\x{FEB5D}\x{FE4F4}\x{FEB98}\x{FEB3D}\x{FE1B3}\x{FEB97}\x{FE19C}\x{FE336}\x{FE19B}\x{FE532}\x{FE4CE}\x{FEB9B}\x{FEB9C}\x{FE19F}\x{FE81C}\x{FE800}\x{FE4DC}\x{FE814}\x{FE816}\x{FE819}\x{FE803}\x{FE195}\x{FE4F5}\x{FE197}\x{FE81D}\x{FE4DB}\x{FE1B0}\x{FEB37}\x{FE509}\x{FE821}\x{FE4F2}\x{FE03C}\x{FE825}\x{FE4EF}\x{FE53E}\x{FE801}\x{FEB85}\x{FEB82}\x{FE4D6}\x{FE52C}\x{FEB86}\x{FE504}\x{FE524}\x{FE535}\x{FE528}\x{FE529}\x{FE82E}\x{FE82F}\x{FE830}\x{FE831}\x{FE832}\x{FE833}\x{FE834}\x{FE835}\x{FE836}\x{FE83B}\x{FE82D}\x{FEAFD}\x{FEAFC}\x{FEAFF}\x{FEAFE}\x{FEB6D}\x{FEB6E}\x{FEB47}\x{FEB6F}\x{FEB70}\x{FEB75}\x{FEB76}\x{FEB71}\x{FEB72}\x{FEB65}\x{FEB66}\x{FEB51}\x{FEB52}\x{FEB62}\x{FEAF8}\x{FEAF9}\x{FEB48}\x{FEB00}\x{FEB01}\x{FEB02}\x{FEB03}\x{FEB73}\x{FEB74}\x{FEB6B}\x{FEB6C}\x{FEB63}\x{FEB64}\x{FEAF2}\x{FEAF1}\x{FEB2A}\x{FEB53}\x{FEB45}\x{FEB46}\x{FEAFA}\x{FEAFB}\x{FEB54}\x{FEAF0}\x{FEAF3}\x{FEB49}\x{FEB29}\x{FEB2D}\x{FEB78}\x{FEB79}\x{FEB88}\x{FEB83}\x{FEB4A}\x{FE4FD}\x{FE53F}\x{FE540}\x{FE53D}\x{FE542}\x{FE548}\x{FE4FF}\x{FE500}\x{FE501}\x{FE502}\x{FE541}\x{FE549}\x{FE545}\x{FE54D}\x{FE54E}\x{FE54F}\x{FE503}\x{FE550}\x{FE7F5}\x{FE4C7}\x{FE4E6}\x{FE54A}\x{FE54B}\x{FE54C}\x{FEE40}\x{FEB21}\x{FE4E0}\x{FE01D}\x{FE01C}\x{FE4E1}\x{FE4E2}\x{FE4F9}\x{FE4FA}\x{FE820}\x{FE4CB}\x{FE53C}\x{FE4FB}\x{FE4FC}\x{FE4E3}\x{FE83C}\x{FE4C9}\x{FE525}\x{FE4FE}\x{FEB4B}\x{FE822}\x{FEB4C}\x{FEB4D}\x{FEB4E}\x{FE543}\x{FE544}\x{FE52A}\x{FE533}\x{FE534}\x{FE02A}\x{FEB0C}\x{FE523}\x{FE981}\x{FE006}\x{FE7D2}\x{FE7D6}\x{FE522}\x{FE804}\x{FE809}\x{FE806}\x{FE50F}\x{FE511}\x{FEB1B}\x{FEB1C}\x{FEB1D}\x{FE190}\x{FE191}\x{FEB94}\x{FEB95}\x{FE011}\x{FE012}\x{FE013}\x{FEB84}\x{FE837}\x{FEB27}\x{FE324}\x{FEB18}\x{FEB5A}\x{FEB5B}\x{FEE41}\x{FE039}\x{FE963}\x{FEB36}\x{FE4CF}\x{FE4CC}\x{FE538}\x{FE81F}\x{FE041}\x{FE4BB}\x{FE7E0}\x{FE4C3}\x{FE813}\x{FE1AF}\x{FE1C0}\x{FE1C1}\x{FE1C2}\x{FE347}\x{FE327}\x{FE341}\x{FE344}\x{FE1C5}\x{FE7ED}\x{FE4D1}\x{FE827}\x{FE4CA}\x{FE515}\x{FE042}\x{FE53B}\x{FE4BC}\x{FE7FB}\x{FE80B}\x{FEB32}\x{FE7DB}\x{FE1DC}\x{FE4EB}\x{FE4EC}\x{FE7F8}\x{FE505}\x{FE514}\x{FE00B}\x{FE1DD}\x{FE4DF}\x{FE1A1}\x{FE4B3}\x{FE4B4}\x{FE4BA}\x{FE4B7}\x{FE7E8}\x{FEB25}\x{FE838}\x{FEB38}\x{FEB3E}\x{FEB3F}\x{FEB81}\x{FEB31}\x{FEB2F}\x{FEB40}\x{FEB41}\x{FEB99}\x{FEB9A}\x{FE4F7}\x{FE839}\x{FE83A}\x{FE527}\x{FE4D3}\x{FE045}\x{FE828}\x{FE048}\x{FE985}\x{FE987}\x{FEB43}\x{FE50A}\x{FE516}\x{FE517}\x{FEE42}\x{FE4D4}\x{FE4D8}\x{FE196}\x{FE198}\x{FE199}\x{FE4D9}\x{FE4DA}\x{FEB1A}\x{FEB10}\x{FEB13}\x{FEB14}\x{FEB15}\x{FEB16}\x{FEB60}\x{FE7D5}\x{FEB44}\x{FE984}\x{FE964}\x{FE966}\x{FE967}\x{FE968}\x{FE969}\x{FE96A}\x{FE96B}\x{FE96C}\x{FE96D}\x{FE96E}\x{FE051}\x{FE052}\x{FE055}\x{FE056}\x{FE96F}\x{FE970}\x{FE343}\x{FE340}\x{FE328}\x{FE33C}\x{FE33F}\x{FE342}\x{FE33E}\x{FE33B}\x{FE32E}\x{FE32F}\x{FE326}\x{FE322}\x{FE325}\x{FE81A}\x{FE335}\x{FE32D}\x{FE32C}\x{FE192}\x{FE193}\x{FE35B}\x{FEB9E}\x{FEB9F}\x{FEBA0}\x{FEB9D}\x{FE351}\x{FE352}\x{FE353}\x{FE829}\x{FE1A2}\x{FE818}\x{FE80E}\x{FE7DE}\x{FE7F2}\x{FE7F3}\x{FE7F4}\x{FE7FE}\x{FE518}\x{FE519}\x{FE51A}\x{FE51B}\x{FE51C}\x{FE007}\x{FE1A3}\x{FE971}\x{FE51D}\x{FE1C6}\x{FE51E}\x{FE51F}\x{FE017}\x{FE513}\x{FE008}\x{FE00D}\x{FE4B8}\x{FE00A}\x{FE805}\x{FE4BD}\x{FE4BE}\x{FE4BF}\x{FE4C0}\x{FE4E7}\x{FEB89}\x{FEB8A}\x{FEB7C}\x{FEB7D}\x{FEB7E}\x{FEB7F}\x{FEB50}\x{FEB8B}\x{FE536}\x{FEB8C}\x{FEB8D}\x{FEB8E}\x{FEB8F}\x{FE526}\x{FE4B1}\x{FE52D}\x{FE552}\x{FEB90}\x{FEB91}\x{FE4E8}\x{FE4E9}\x{FE4EA}\x{FE4ED}\x{FE4EE}\x{FE1A4}\x{FE1A5}\x{FE1A6}\x{FE1A7}\x{FE1A8}\x{FE1A9}\x{FE1AA}\x{FE1AB}\x{FE1C7}\x{FE1B6}\x{FE1C9}\x{FE1CB}\x{FE1CC}\x{FE1CD}\x{FE1D1}\x{FE1D3}\x{FE1D4}\x{FE1D5}\x{FE1D6}\x{FE50B}\x{FE50C}\x{FE50E}\x{FE50D}\x{FE553}\x{FE4CD}\x{FEB22}\x{FEAF4}\x{FEAF5}\x{FEB05}\x{FEB06}\x{FEB08}\x{FE057}\x{FE058}\x{FE059}\x{FE050}\x{FE04A}\x{FE04B}\x{FE04C}\x{FE05A}\x{FE974}\x{FE975}\x{FE976}\x{FE521}\x{FE988}\x{FE1DE}\x{FE817}\x{FE7DA}\x{FE7FF}\x{FE810}\x{FE1AC}\x{FE1AD}\x{FE1DF}\x{FE194}\x{FE1E0}\x{FE04D}\x{FE977}\x{FE978}\x{FE979}\x{FE97A}\x{FE97B}\x{FE97C}\x{FE354}\x{FE355}\x{FE356}\x{FE03A}\x{FEB17}\x{FEB80}\x{FE97D}\x{FE1E1}\x{FE1E2}\x{FE97E}\x{FE05B}\x{FE4E4}\x{FEB5F}\x{FE33D}\x{FE34E}\x{FE03B}\x{FE34B}\x{FE348}\x{FE52B}\x{FE34A}\x{FE334}\x{FE34C}\x{FE350}\x{FE321}\x{FE34D}\x{FE339}\x{FE34F}\x{FE4D5}\x{FE4C8}\x{FE7EC}\x{FE811}\x{FE812}\x{FE97F}\x{FEB92}\x{FE7F0}\x{FE7F9}\x{FEE43}\x{FEB0D}\x{FE1BB}\x{FE4D0}\x{FE824}\x{FEB2C}\x{FEAF6}\x{FEAF7}\x{FE038}\x{FE03E}\x{FE1B9}\x{FE349}\x{FE333}\x{FEE44}\x{FE04E}\x{FEB93}\x{FE82C}\x{FE357}\x{FE358}\x{FE359}\x{FE35A}\x{FEE45}\x{FEE46}\x{FEE47}\x{FEE48}\x{FEE49}\x{FEE4A}];
}

our %map_google_unicode_to_kddi_unicode = (
    "\x{FE000}"=>"\x{E488}", "\x{FE001}"=>"\x{E48D}", "\x{FE002}"=>"\x{E48C}", "\x{FE003}"=>"\x{E485}", "\x{FE004}"=>"\x{E487}", "\x{FE005}"=>"\x{E469}", "\x{FE006}"=>"\x{E598}", "\x{FE007}"=>"\x{EAE8}", "\x{FE008}"=>"\x{EAF1}", "\x{FE009}"=>"\x{EAF4}", "\x{FE00A}"=>"\x{EAF4}", "\x{FE00B}"=>"\x{E5DA}", "\x{FE00C}"=>"\x{E5DA}", "\x{FE00D}"=>"\x{EAF2}", "\x{FE00E}"=>"\x{E48A}", "\x{FE00F}"=>"\x{E48E}", "\x{FE010}"=>"\x{E4BF}", "\x{FE011}"=>"\x{E5A8}", "\x{FE012}"=>"\x{E5A9}", "\x{FE013}"=>"\x{E5AA}", "\x{FE014}"=>"\x{E486}", "\x{FE016}"=>"\x{E489}", "\x{FE017}"=>"\x{EAEF}", "\x{FE01B}"=>"\x{E47C}", "\x{FE01C}"=>"\x{E57B}", "\x{FE01D}"=>"\x{E57A}", "\x{FE01E}"=>"\x{E594}", "\x{FE01F}"=>"\x{E594}", "\x{FE020}"=>"\x{E594}", "\x{FE021}"=>"\x{E594}", "\x{FE022}"=>"\x{E594}", "\x{FE023}"=>"\x{E594}", "\x{FE024}"=>"\x{E594}", "\x{FE025}"=>"\x{E594}", "\x{FE026}"=>"\x{E594}", "\x{FE027}"=>"\x{E594}", "\x{FE028}"=>"\x{E594}", "\x{FE029}"=>"\x{E594}", "\x{FE02A}"=>"\x{E594}", "\x{FE02B}"=>"\x{E48F}", "\x{FE02C}"=>"\x{E490}", "\x{FE02D}"=>"\x{E491}", "\x{FE02E}"=>"\x{E492}", "\x{FE02F}"=>"\x{E493}", "\x{FE030}"=>"\x{E494}", "\x{FE031}"=>"\x{E495}", "\x{FE032}"=>"\x{E496}", "\x{FE033}"=>"\x{E497}", "\x{FE034}"=>"\x{E498}", "\x{FE035}"=>"\x{E499}", "\x{FE036}"=>"\x{E49A}", "\x{FE037}"=>"\x{E49B}", "\x{FE038}"=>"\x{EB7C}", "\x{FE039}"=>"\x{E5B3}", "\x{FE03A}"=>"\x{EB53}", "\x{FE03B}"=>"\x{EB5F}", "\x{FE03C}"=>"\x{E513}", "\x{FE03D}"=>"\x{E4E4}", "\x{FE03E}"=>"\x{EB7D}", "\x{FE03F}"=>"\x{E4CE}", "\x{FE040}"=>"\x{E4CA}", "\x{FE041}"=>"\x{E5BA}", "\x{FE042}"=>"\x{E5CD}", "\x{FE043}"=>"\x{E5CD}", "\x{FE044}"=>"\x{E480}", "\x{FE045}"=>"\x{EA94}", "\x{FE046}"=>"\x{E4E3}", "\x{FE047}"=>"\x{E4E2}", "\x{FE048}"=>"\x{EA96}", "\x{FE04A}"=>"\x{EB36}", "\x{FE04B}"=>"\x{EB37}", "\x{FE04C}"=>"\x{EB38}", "\x{FE04D}"=>"\x{EB49}", "\x{FE04E}"=>"\x{EB82}", "\x{FE04F}"=>"\x{E4D2}", "\x{FE050}"=>"\x{EB35}", "\x{FE051}"=>"\x{EAB9}", "\x{FE052}"=>"\x{EABA}", "\x{FE053}"=>"\x{E4D4}", "\x{FE054}"=>"\x{E4CD}", "\x{FE055}"=>"\x{EABB}", "\x{FE056}"=>"\x{EABC}", "\x{FE057}"=>"\x{EB32}", "\x{FE058}"=>"\x{EB33}", "\x{FE059}"=>"\x{EB34}", "\x{FE05A}"=>"\x{EB39}", "\x{FE05B}"=>"\x{EB5A}", "\x{FE190}"=>"\x{E5A4}", "\x{FE191}"=>"\x{E5A5}", "\x{FE192}"=>"\x{EAD0}", "\x{FE193}"=>"\x{EAD1}", "\x{FE194}"=>"\x{EB47}", "\x{FE195}"=>"\x{E509}", "\x{FE196}"=>"\x{EAA0}", "\x{FE197}"=>"\x{E50B}", "\x{FE198}"=>"\x{EAA1}", "\x{FE199}"=>"\x{EAA2}", "\x{FE19B}"=>"\x{E4FC}", "\x{FE19C}"=>"\x{E4FA}", "\x{FE19D}"=>"\x{E4FC}", "\x{FE19E}"=>"\x{E4FA}", "\x{FE19F}"=>"\x{E501}", "\x{FE1A1}"=>"\x{E5DD}", "\x{FE1A2}"=>"\x{EADB}", "\x{FE1A3}"=>"\x{EAE9}", "\x{FE1A4}"=>"\x{EB13}", "\x{FE1A5}"=>"\x{EB14}", "\x{FE1A6}"=>"\x{EB15}", "\x{FE1A7}"=>"\x{EB16}", "\x{FE1A8}"=>"\x{EB17}", "\x{FE1A9}"=>"\x{EB18}", "\x{FE1AA}"=>"\x{EB19}", "\x{FE1AB}"=>"\x{EB1A}", "\x{FE1AC}"=>"\x{EB44}", "\x{FE1AD}"=>"\x{EB45}", "\x{FE1AE}"=>"\x{E4CB}", "\x{FE1AF}"=>"\x{E5BF}", "\x{FE1B0}"=>"\x{E50E}", "\x{FE1B1}"=>"\x{E4EC}", "\x{FE1B2}"=>"\x{E4EF}", "\x{FE1B3}"=>"\x{E4F8}", "\x{FE1B6}"=>"\x{EB1C}", "\x{FE1B7}"=>"\x{E4E1}", "\x{FE1B8}"=>"\x{E4DB}", "\x{FE1B9}"=>"\x{EB7E}", "\x{FE1BA}"=>"\x{E4E0}", "\x{FE1BB}"=>"\x{EB76}", "\x{FE1BC}"=>"\x{E4DC}", "\x{FE1BD}"=>"\x{E49A}", "\x{FE1BE}"=>"\x{E4D8}", "\x{FE1BF}"=>"\x{E4DE}", "\x{FE1C0}"=>"\x{E5C0}", "\x{FE1C1}"=>"\x{E5C1}", "\x{FE1C2}"=>"\x{E5C2}", "\x{FE1C3}"=>"\x{E470}", "\x{FE1C4}"=>"\x{E4D9}", "\x{FE1C5}"=>"\x{E5C7}", "\x{FE1C6}"=>"\x{EAEC}", "\x{FE1C7}"=>"\x{EB1B}", "\x{FE1C8}"=>"\x{E4E0}", "\x{FE1C9}"=>"\x{EB1D}", "\x{FE1CB}"=>"\x{EB1E}", "\x{FE1CC}"=>"\x{EB1F}", "\x{FE1CD}"=>"\x{EB20}", "\x{FE1CE}"=>"\x{E4D9}", "\x{FE1CF}"=>"\x{E48F}", "\x{FE1D0}"=>"\x{E4E1}", "\x{FE1D1}"=>"\x{EB21}", "\x{FE1D2}"=>"\x{E4D7}", "\x{FE1D3}"=>"\x{EB22}", "\x{FE1D4}"=>"\x{EB23}", "\x{FE1D5}"=>"\x{EB24}", "\x{FE1D6}"=>"\x{EB25}", "\x{FE1D7}"=>"\x{E4DA}", "\x{FE1D8}"=>"\x{E4DF}", "\x{FE1D9}"=>"\x{E4D3}", "\x{FE1DA}"=>"\x{E4DD}", "\x{FE1DB}"=>"\x{E4EE}", "\x{FE1DC}"=>"\x{E5D4}", "\x{FE1DD}"=>"\x{E5DB}", "\x{FE1DE}"=>"\x{EB3F}", "\x{FE1DF}"=>"\x{EB46}", "\x{FE1E0}"=>"\x{EB48}", "\x{FE1E1}"=>"\x{EB57}", "\x{FE1E2}"=>"\x{EB58}", "\x{FE1E3}"=>"\x{E492}", "\x{FE320}"=>"\x{E472}", "\x{FE321}"=>"\x{EB67}", "\x{FE322}"=>"\x{EACA}", "\x{FE323}"=>"\x{EAC0}", "\x{FE324}"=>"\x{E5AE}", "\x{FE325}"=>"\x{EACB}", "\x{FE326}"=>"\x{EAC9}", "\x{FE327}"=>"\x{E5C4}", "\x{FE328}"=>"\x{EAC1}", "\x{FE329}"=>"\x{E4E7}", "\x{FE32A}"=>"\x{E4E7}", "\x{FE32B}"=>"\x{EACD}", "\x{FE32C}"=>"\x{EACF}", "\x{FE32D}"=>"\x{EACE}", "\x{FE32E}"=>"\x{EAC7}", "\x{FE32F}"=>"\x{EAC8}", "\x{FE330}"=>"\x{E471}", "\x{FE331}"=>"\x{E471}\x{E5B1}", "\x{FE332}"=>"\x{EAC5}", "\x{FE333}"=>"\x{EB80}", "\x{FE334}"=>"\x{EB64}", "\x{FE335}"=>"\x{EACD}", "\x{FE336}"=>"\x{E4FB}", "\x{FE337}"=>"\x{EACD}", "\x{FE338}"=>"\x{E471}", "\x{FE339}"=>"\x{EB69}", "\x{FE33A}"=>"\x{E473}", "\x{FE33B}"=>"\x{EAC6}", "\x{FE33C}"=>"\x{EAC2}", "\x{FE33D}"=>"\x{EB5D}", "\x{FE33E}"=>"\x{EAC5}", "\x{FE33F}"=>"\x{EAC3}", "\x{FE340}"=>"\x{EAC0}", "\x{FE341}"=>"\x{E5C5}", "\x{FE342}"=>"\x{EAC4}", "\x{FE343}"=>"\x{EABF}", "\x{FE344}"=>"\x{E5C6}", "\x{FE345}"=>"\x{E5C6}", "\x{FE346}"=>"\x{E474}", "\x{FE347}"=>"\x{E5C3}", "\x{FE348}"=>"\x{EB61}", "\x{FE349}"=>"\x{EB7F}", "\x{FE34A}"=>"\x{EB63}", "\x{FE34B}"=>"\x{EB60}", "\x{FE34C}"=>"\x{EB65}", "\x{FE34D}"=>"\x{EB68}", "\x{FE34E}"=>"\x{EB5E}", "\x{FE34F}"=>"\x{EB6A}", "\x{FE350}"=>"\x{EB66}", "\x{FE351}"=>"\x{EAD7}", "\x{FE352}"=>"\x{EAD8}", "\x{FE353}"=>"\x{EAD9}", "\x{FE354}"=>"\x{EB50}", "\x{FE355}"=>"\x{EB51}", "\x{FE356}"=>"\x{EB52}", "\x{FE357}"=>"\x{EB85}", "\x{FE358}"=>"\x{EB86}", "\x{FE359}"=>"\x{EB87}", "\x{FE35A}"=>"\x{EB88}", "\x{FE35B}"=>"\x{EAD2}", "\x{FE4B0}"=>"\x{E4AB}", "\x{FE4B1}"=>"\x{EB09}", "\x{FE4B2}"=>"\x{E4AD}", "\x{FE4B3}"=>"\x{E5DE}", "\x{FE4B4}"=>"\x{E5DF}", "\x{FE4B5}"=>"\x{E4AA}", "\x{FE4B6}"=>"\x{E4A3}", "\x{FE4B7}"=>"\x{EA81}", "\x{FE4B8}"=>"\x{EAF3}", "\x{FE4B9}"=>"\x{E4A4}", "\x{FE4BA}"=>"\x{EA80}", "\x{FE4BB}"=>"\x{E5BB}", "\x{FE4BC}"=>"\x{E5CF}", "\x{FE4BD}"=>"\x{EAF6}", "\x{FE4BE}"=>"\x{EAF7}", "\x{FE4BF}"=>"\x{EAF8}", "\x{FE4C0}"=>"\x{EAF9}", "\x{FE4C1}"=>"\x{E4A9}", "\x{FE4C2}"=>"\x{E4BD}", "\x{FE4C3}"=>"\x{E5BD}", "\x{FE4C4}"=>"\x{E4C0}", "\x{FE4C7}"=>"\x{E572}", "\x{FE4C8}"=>"\x{EB6C}", "\x{FE4C9}"=>"\x{E587}", "\x{FE4CA}"=>"\x{E5CB}", "\x{FE4CB}"=>"\x{E581}", "\x{FE4CC}"=>"\x{E5B7}", "\x{FE4CD}"=>"\x{EB2B}", "\x{FE4CE}"=>"\x{E4FE}", "\x{FE4CF}"=>"\x{E5B6}", "\x{FE4D0}"=>"\x{EB77}", "\x{FE4D1}"=>"\x{E5C9}", "\x{FE4D2}"=>"\x{E5C9}", "\x{FE4D3}"=>"\x{EA93}", "\x{FE4D4}"=>"\x{EA9E}", "\x{FE4D5}"=>"\x{EB6B}", "\x{FE4D6}"=>"\x{E51A}", "\x{FE4D7}"=>"\x{E51A}", "\x{FE4D8}"=>"\x{EA9F}", "\x{FE4D9}"=>"\x{EAA3}", "\x{FE4DA}"=>"\x{EAA4}", "\x{FE4DB}"=>"\x{E50D}", "\x{FE4DC}"=>"\x{E504}", "\x{FE4DD}"=>"\x{E4C7}", "\x{FE4DF}"=>"\x{E5DC}", "\x{FE4E0}"=>"\x{E579}", "\x{FE4E1}"=>"\x{E57C}", "\x{FE4E2}"=>"\x{E57D}", "\x{FE4E3}"=>"\x{E585}", "\x{FE4E4}"=>"\x{EB5B}", "\x{FE4E5}"=>"\x{E4CC}", "\x{FE4E6}"=>"\x{E573}", "\x{FE4E7}"=>"\x{EAFA}", "\x{FE4E8}"=>"\x{EB0E}", "\x{FE4E9}"=>"\x{EB0F}", "\x{FE4EA}"=>"\x{EB10}", "\x{FE4EB}"=>"\x{E5D5}", "\x{FE4EC}"=>"\x{E5D6}", "\x{FE4ED}"=>"\x{EB11}", "\x{FE4EE}"=>"\x{EB12}", "\x{FE4EF}"=>"\x{E515}", "\x{FE4F0}"=>"\x{E49C}", "\x{FE4F2}"=>"\x{E512}", "\x{FE4F4}"=>"\x{E4F5}", "\x{FE4F5}"=>"\x{E50A}", "\x{FE4F6}"=>"\x{E47B}", "\x{FE4F7}"=>"\x{EA8F}", "\x{FE4F8}"=>"\x{EA8F}", "\x{FE4F9}"=>"\x{E57E}", "\x{FE4FA}"=>"\x{E57F}", "\x{FE4FB}"=>"\x{E583}", "\x{FE4FC}"=>"\x{E584}", "\x{FE4FD}"=>"\x{E55F}", "\x{FE4FE}"=>"\x{E589}", "\x{FE4FF}"=>"\x{E565}", "\x{FE500}"=>"\x{E566}", "\x{FE501}"=>"\x{E567}", "\x{FE502}"=>"\x{E568}", "\x{FE503}"=>"\x{E56F}", "\x{FE504}"=>"\x{E51D}", "\x{FE505}"=>"\x{E5D8}", "\x{FE506}"=>"\x{E4A5}", "\x{FE507}"=>"\x{E4A5}", "\x{FE508}"=>"\x{E4A5}", "\x{FE509}"=>"\x{E510}", "\x{FE50A}"=>"\x{EA9A}", "\x{FE50B}"=>"\x{EB26}", "\x{FE50C}"=>"\x{EB27}", "\x{FE50D}"=>"\x{EB29}", "\x{FE50E}"=>"\x{EB28}", "\x{FE50F}"=>"\x{E59F}", "\x{FE510}"=>"\x{E4CF}", "\x{FE511}"=>"\x{E5A0}", "\x{FE512}"=>"\x{E4C9}", "\x{FE513}"=>"\x{EAF0}", "\x{FE514}"=>"\x{E5D9}", "\x{FE515}"=>"\x{E5CC}", "\x{FE516}"=>"\x{EA9B}", "\x{FE517}"=>"\x{EA9C}", "\x{FE518}"=>"\x{EAE3}", "\x{FE519}"=>"\x{EAE4}", "\x{FE51A}"=>"\x{EAE5}", "\x{FE51B}"=>"\x{EAE6}", "\x{FE51C}"=>"\x{EAE7}", "\x{FE51D}"=>"\x{EAEB}", "\x{FE51E}"=>"\x{EAED}", "\x{FE51F}"=>"\x{EAEE}", "\x{FE520}"=>"\x{E46F}", "\x{FE521}"=>"\x{EB3D}", "\x{FE522}"=>"\x{E59B}", "\x{FE523}"=>"\x{E596}", "\x{FE524}"=>"\x{E51E}", "\x{FE525}"=>"\x{E588}", "\x{FE526}"=>"\x{EB08}", "\x{FE527}"=>"\x{EA92}", "\x{FE528}"=>"\x{E520}", "\x{FE529}"=>"\x{E521}", "\x{FE52A}"=>"\x{E591}", "\x{FE52B}"=>"\x{EB62}", "\x{FE52C}"=>"\x{E51B}", "\x{FE52D}"=>"\x{EB0A}", "\x{FE52E}"=>"\x{E51B}", "\x{FE52F}"=>"\x{E511}", "\x{FE530}"=>"\x{E511}", "\x{FE531}"=>"\x{E4A8}", "\x{FE532}"=>"\x{E4FD}", "\x{FE533}"=>"\x{E592}", "\x{FE534}"=>"\x{E593}", "\x{FE535}"=>"\x{E51F}", "\x{FE536}"=>"\x{EB03}", "\x{FE538}"=>"\x{E5B8}", "\x{FE539}"=>"\x{E4A1}", "\x{FE53A}"=>"\x{E4A0}", "\x{FE53B}"=>"\x{E5CE}", "\x{FE53C}"=>"\x{E582}", "\x{FE53D}"=>"\x{E562}", "\x{FE53E}"=>"\x{E516}", "\x{FE53F}"=>"\x{E560}", "\x{FE540}"=>"\x{E561}", "\x{FE541}"=>"\x{E569}", "\x{FE542}"=>"\x{E563}", "\x{FE543}"=>"\x{E58F}", "\x{FE544}"=>"\x{E590}", "\x{FE545}"=>"\x{E56B}", "\x{FE546}"=>"\x{E49F}", "\x{FE547}"=>"\x{E49D}", "\x{FE548}"=>"\x{E564}", "\x{FE549}"=>"\x{E56A}", "\x{FE54A}"=>"\x{E574}", "\x{FE54B}"=>"\x{E575}", "\x{FE54C}"=>"\x{E576}", "\x{FE54D}"=>"\x{E56C}", "\x{FE54E}"=>"\x{E56D}", "\x{FE54F}"=>"\x{E56E}", "\x{FE550}"=>"\x{E570}", "\x{FE551}"=>"\x{E4A2}", "\x{FE552}"=>"\x{EB0B}", "\x{FE553}"=>"\x{EB2A}", "\x{FE7D1}"=>"\x{E4BA}", "\x{FE7D2}"=>"\x{E599}", "\x{FE7D3}"=>"\x{E4B7}", "\x{FE7D4}"=>"\x{E4B6}", "\x{FE7D5}"=>"\x{EAAC}", "\x{FE7D6}"=>"\x{E59A}", "\x{FE7D7}"=>"\x{E4B9}", "\x{FE7D8}"=>"\x{E4B8}", "\x{FE7D9}"=>"\x{E46B}", "\x{FE7DA}"=>"\x{EB41}", "\x{FE7DB}"=>"\x{E5D3}", "\x{FE7DC}"=>"\x{E4D8}", "\x{FE7DD}"=>"\x{E4BB}", "\x{FE7DE}"=>"\x{EADE}", "\x{FE7DF}"=>"\x{E4B5}", "\x{FE7E0}"=>"\x{E5BC}", "\x{FE7E1}"=>"\x{E5BC}", "\x{FE7E2}"=>"\x{E4B0}", "\x{FE7E3}"=>"\x{E4B0}", "\x{FE7E4}"=>"\x{E4B1}", "\x{FE7E5}"=>"\x{E4B1}", "\x{FE7E6}"=>"\x{E4AF}", "\x{FE7E7}"=>"\x{E4A7}", "\x{FE7E8}"=>"\x{EA82}", "\x{FE7E9}"=>"\x{E4B3}", "\x{FE7EA}"=>"\x{E4B4}", "\x{FE7EB}"=>"\x{E4AE}", "\x{FE7EC}"=>"\x{EB6D}", "\x{FE7ED}"=>"\x{E5C8}", "\x{FE7EE}"=>"\x{E4B4}", "\x{FE7EF}"=>"\x{E4B1}", "\x{FE7F0}"=>"\x{EB72}", "\x{FE7F1}"=>"\x{E4B2}", "\x{FE7F2}"=>"\x{EADF}", "\x{FE7F3}"=>"\x{EAE0}", "\x{FE7F4}"=>"\x{EAE1}", "\x{FE7F5}"=>"\x{E571}", "\x{FE7F6}"=>"\x{E4A6}", "\x{FE7F7}"=>"\x{E46A}", "\x{FE7F8}"=>"\x{E5D7}", "\x{FE7F9}"=>"\x{EB73}", "\x{FE7FA}"=>"\x{E4BC}", "\x{FE7FB}"=>"\x{E5D0}", "\x{FE7FD}"=>"\x{E46D}", "\x{FE7FE}"=>"\x{EAE2}", "\x{FE7FF}"=>"\x{EB42}", "\x{FE800}"=>"\x{E503}", "\x{FE801}"=>"\x{E517}", "\x{FE802}"=>"\x{E517}", "\x{FE803}"=>"\x{E508}", "\x{FE804}"=>"\x{E59C}", "\x{FE805}"=>"\x{EAF5}", "\x{FE806}"=>"\x{E59E}", "\x{FE807}"=>"\x{E49E}", "\x{FE808}"=>"\x{E4BE}", "\x{FE809}"=>"\x{E59D}", "\x{FE80A}"=>"\x{E4C6}", "\x{FE80B}"=>"\x{E5D1}", "\x{FE80C}"=>"\x{E4C5}", "\x{FE80D}"=>"\x{E46E}", "\x{FE80E}"=>"\x{EADD}", "\x{FE80F}"=>"\x{E4C8}", "\x{FE810}"=>"\x{EB43}", "\x{FE811}"=>"\x{EB6E}", "\x{FE812}"=>"\x{EB6F}", "\x{FE813}"=>"\x{E5BE}", "\x{FE814}"=>"\x{E505}", "\x{FE816}"=>"\x{E506}", "\x{FE817}"=>"\x{EB40}", "\x{FE818}"=>"\x{EADC}", "\x{FE819}"=>"\x{E507}", "\x{FE81A}"=>"\x{EACC}", "\x{FE81C}"=>"\x{E502}", "\x{FE81D}"=>"\x{E50C}", "\x{FE81E}"=>"\x{E50C}", "\x{FE81F}"=>"\x{E5B9}", "\x{FE820}"=>"\x{E580}", "\x{FE821}"=>"\x{E511}", "\x{FE822}"=>"\x{E58B}", "\x{FE823}"=>"\x{E4EB}", "\x{FE824}"=>"\x{EB78}", "\x{FE825}"=>"\x{E514}", "\x{FE826}"=>"\x{E514}", "\x{FE827}"=>"\x{E5CA}", "\x{FE828}"=>"\x{EA95}", "\x{FE829}"=>"\x{EADA}", "\x{FE82A}"=>"\x{E5BB}", "\x{FE82C}"=>"\x{EB84}", "\x{FE82D}"=>"\x{E52C}", "\x{FE82E}"=>"\x{E522}", "\x{FE82F}"=>"\x{E523}", "\x{FE830}"=>"\x{E524}", "\x{FE831}"=>"\x{E525}", "\x{FE832}"=>"\x{E526}", "\x{FE833}"=>"\x{E527}", "\x{FE834}"=>"\x{E528}", "\x{FE835}"=>"\x{E529}", "\x{FE836}"=>"\x{E52A}", "\x{FE837}"=>"\x{E5AC}", "\x{FE838}"=>"\x{EA84}", "\x{FE839}"=>"\x{EA90}", "\x{FE83A}"=>"\x{EA91}", "\x{FE83B}"=>"\x{E52B}", "\x{FE83C}"=>"\x{E586}", "\x{FE960}"=>"\x{E4D6}", "\x{FE961}"=>"\x{E4D5}", "\x{FE962}"=>"\x{E4D0}", "\x{FE963}"=>"\x{E5B4}", "\x{FE964}"=>"\x{EAAF}", "\x{FE965}"=>"\x{E4D1}", "\x{FE966}"=>"\x{EAB0}", "\x{FE967}"=>"\x{EAB1}", "\x{FE968}"=>"\x{EAB2}", "\x{FE969}"=>"\x{EAB3}", "\x{FE96A}"=>"\x{EAB4}", "\x{FE96B}"=>"\x{EAB5}", "\x{FE96C}"=>"\x{EAB6}", "\x{FE96D}"=>"\x{EAB7}", "\x{FE96E}"=>"\x{EAB8}", "\x{FE96F}"=>"\x{EABD}", "\x{FE970}"=>"\x{EABE}", "\x{FE971}"=>"\x{EAEA}", "\x{FE972}"=>"\x{E4C4}", "\x{FE973}"=>"\x{E4ED}", "\x{FE974}"=>"\x{EB3A}", "\x{FE975}"=>"\x{EB3B}", "\x{FE976}"=>"\x{EB3C}", "\x{FE977}"=>"\x{EB4A}", "\x{FE978}"=>"\x{EB4B}", "\x{FE979}"=>"\x{EB4C}", "\x{FE97A}"=>"\x{EB4D}", "\x{FE97B}"=>"\x{EB4E}", "\x{FE97C}"=>"\x{EB4F}", "\x{FE97D}"=>"\x{EB56}", "\x{FE97E}"=>"\x{EB59}", "\x{FE97F}"=>"\x{EB70}", "\x{FE980}"=>"\x{E4AC}", "\x{FE981}"=>"\x{E597}", "\x{FE982}"=>"\x{E4C2}", "\x{FE983}"=>"\x{E4C3}", "\x{FE984}"=>"\x{EAAE}", "\x{FE985}"=>"\x{EA97}", "\x{FE986}"=>"\x{E4C1}", "\x{FE987}"=>"\x{EA98}", "\x{FE988}"=>"\x{EB3E}", "\x{FEAF0}"=>"\x{E555}", "\x{FEAF1}"=>"\x{E54D}", "\x{FEAF2}"=>"\x{E54C}", "\x{FEAF3}"=>"\x{E556}", "\x{FEAF4}"=>"\x{EB2D}", "\x{FEAF5}"=>"\x{EB2E}", "\x{FEAF6}"=>"\x{EB7A}", "\x{FEAF7}"=>"\x{EB7B}", "\x{FEAF8}"=>"\x{E53F}", "\x{FEAF9}"=>"\x{E540}", "\x{FEAFA}"=>"\x{E552}", "\x{FEAFB}"=>"\x{E553}", "\x{FEAFC}"=>"\x{E52E}", "\x{FEAFD}"=>"\x{E52D}", "\x{FEAFE}"=>"\x{E530}", "\x{FEAFF}"=>"\x{E52F}", "\x{FEB00}"=>"\x{E542}", "\x{FEB01}"=>"\x{E543}", "\x{FEB02}"=>"\x{E544}", "\x{FEB03}"=>"\x{E545}", "\x{FEB04}"=>"\x{E482}", "\x{FEB05}"=>"\x{EB2F}", "\x{FEB06}"=>"\x{EB30}", "\x{FEB08}"=>"\x{EB31}", "\x{FEB09}"=>"\x{E483}", "\x{FEB0A}"=>"\x{E483}", "\x{FEB0B}"=>"\x{E482}", "\x{FEB0C}"=>"\x{E595}", "\x{FEB0D}"=>"\x{EB75}", "\x{FEB0E}"=>"\x{E477}", "\x{FEB0F}"=>"\x{E478}", "\x{FEB10}"=>"\x{EAA6}", "\x{FEB11}"=>"\x{EB75}", "\x{FEB12}"=>"\x{E4EA}", "\x{FEB13}"=>"\x{EAA7}", "\x{FEB14}"=>"\x{EAA8}", "\x{FEB15}"=>"\x{EAA9}", "\x{FEB16}"=>"\x{EAAA}", "\x{FEB17}"=>"\x{EB54}", "\x{FEB18}"=>"\x{E5AF}", "\x{FEB19}"=>"\x{E595}", "\x{FEB1A}"=>"\x{EAA5}", "\x{FEB1B}"=>"\x{E5A1}", "\x{FEB1C}"=>"\x{E5A2}", "\x{FEB1D}"=>"\x{E5A3}", "\x{FEB1E}"=>"\x{E47D}", "\x{FEB1F}"=>"\x{E47E}", "\x{FEB20}"=>"\x{E47F}", "\x{FEB21}"=>"\x{E578}", "\x{FEB22}"=>"\x{EB2C}", "\x{FEB23}"=>"\x{E481}", "\x{FEB25}"=>"\x{EA83}", "\x{FEB26}"=>"\x{E484}", "\x{FEB27}"=>"\x{E5AD}", "\x{FEB29}"=>"\x{E558}", "\x{FEB2A}"=>"\x{E54E}", "\x{FEB2B}"=>"\x{E4F1}", "\x{FEB2C}"=>"\x{EB79}", "\x{FEB2D}"=>"\x{E559}", "\x{FEB2F}"=>"\x{EA8A}", "\x{FEB31}"=>"\x{EA89}", "\x{FEB32}"=>"\x{E5D2}", "\x{FEB35}"=>"\x{EB18}", "\x{FEB36}"=>"\x{E5B5}", "\x{FEB37}"=>"\x{E50F}", "\x{FEB38}"=>"\x{EA85}", "\x{FEB3D}"=>"\x{E4F7}", "\x{FEB3E}"=>"\x{EA86}", "\x{FEB3F}"=>"\x{EA87}", "\x{FEB40}"=>"\x{EA8B}", "\x{FEB41}"=>"\x{EA8C}", "\x{FEB43}"=>"\x{EA99}", "\x{FEB44}"=>"\x{EAAD}", "\x{FEB45}"=>"\x{E550}", "\x{FEB46}"=>"\x{E551}", "\x{FEB47}"=>"\x{E533}", "\x{FEB48}"=>"\x{E541}", "\x{FEB49}"=>"\x{E557}", "\x{FEB4A}"=>"\x{E55E}", "\x{FEB4B}"=>"\x{E58A}", "\x{FEB4C}"=>"\x{E58C}", "\x{FEB4D}"=>"\x{E58D}", "\x{FEB4E}"=>"\x{E58E}", "\x{FEB4F}"=>"\x{E4E8}", "\x{FEB50}"=>"\x{EB01}", "\x{FEB51}"=>"\x{E53C}", "\x{FEB52}"=>"\x{E53D}", "\x{FEB53}"=>"\x{E54F}", "\x{FEB54}"=>"\x{E554}", "\x{FEB56}"=>"\x{E476}", "\x{FEB57}"=>"\x{E4E5}", "\x{FEB58}"=>"\x{E47A}", "\x{FEB59}"=>"\x{E475}", "\x{FEB5A}"=>"\x{E5B0}", "\x{FEB5B}"=>"\x{E5B1}", "\x{FEB5C}"=>"\x{E4E6}", "\x{FEB5D}"=>"\x{E4F4}", "\x{FEB5E}"=>"\x{E4E9}", "\x{FEB5F}"=>"\x{EB5C}", "\x{FEB60}"=>"\x{EAAB}", "\x{FEB61}"=>"\x{E479}", "\x{FEB62}"=>"\x{E53E}", "\x{FEB63}"=>"\x{E54A}", "\x{FEB64}"=>"\x{E54B}", "\x{FEB65}"=>"\x{E53A}", "\x{FEB66}"=>"\x{E53B}", "\x{FEB67}"=>"\x{E54B}", "\x{FEB68}"=>"\x{E48B}", "\x{FEB69}"=>"\x{E48B}", "\x{FEB6A}"=>"\x{E468}", "\x{FEB6B}"=>"\x{E548}", "\x{FEB6C}"=>"\x{E549}", "\x{FEB6D}"=>"\x{E531}", "\x{FEB6E}"=>"\x{E532}", "\x{FEB6F}"=>"\x{E534}", "\x{FEB70}"=>"\x{E535}", "\x{FEB71}"=>"\x{E538}", "\x{FEB72}"=>"\x{E539}", "\x{FEB73}"=>"\x{E546}", "\x{FEB74}"=>"\x{E547}", "\x{FEB75}"=>"\x{E536}", "\x{FEB76}"=>"\x{E537}", "\x{FEB77}"=>"\x{E46C}", "\x{FEB78}"=>"\x{E55A}", "\x{FEB79}"=>"\x{E55B}", "\x{FEB7A}"=>"\x{E4F0}", "\x{FEB7B}"=>"\x{E4F2}", "\x{FEB7C}"=>"\x{EAFD}", "\x{FEB7D}"=>"\x{EAFE}", "\x{FEB7E}"=>"\x{EAFF}", "\x{FEB7F}"=>"\x{EB00}", "\x{FEB80}"=>"\x{EB55}", "\x{FEB81}"=>"\x{EA88}", "\x{FEB82}"=>"\x{E519}", "\x{FEB83}"=>"\x{E55D}", "\x{FEB84}"=>"\x{E5AB}", "\x{FEB85}"=>"\x{E518}", "\x{FEB86}"=>"\x{E51C}", "\x{FEB87}"=>"\x{E51C}", "\x{FEB88}"=>"\x{E55C}", "\x{FEB89}"=>"\x{EAFB}", "\x{FEB8A}"=>"\x{EAFC}", "\x{FEB8B}"=>"\x{EB02}", "\x{FEB8C}"=>"\x{EB04}", "\x{FEB8D}"=>"\x{EB05}", "\x{FEB8E}"=>"\x{EB06}", "\x{FEB8F}"=>"\x{EB07}", "\x{FEB90}"=>"\x{EB0C}", "\x{FEB91}"=>"\x{EB0D}", "\x{FEB92}"=>"\x{EB71}", "\x{FEB93}"=>"\x{EB83}", "\x{FEB94}"=>"\x{E5A6}", "\x{FEB95}"=>"\x{E5A7}", "\x{FEB96}"=>"\x{E4F3}", "\x{FEB97}"=>"\x{E4F9}", "\x{FEB98}"=>"\x{E4F6}", "\x{FEB99}"=>"\x{EA8D}", "\x{FEB9A}"=>"\x{EA8E}", "\x{FEB9B}"=>"\x{E4FF}", "\x{FEB9C}"=>"\x{E500}", "\x{FEB9D}"=>"\x{EAD6}", "\x{FEB9E}"=>"\x{EAD3}", "\x{FEB9F}"=>"\x{EAD4}", "\x{FEBA0}"=>"\x{EAD5}", "\x{FEBA1}"=>"\x{EAD6}", "\x{FEE1C}"=>"\x{E517}", "\x{FEE33}"=>"\x{EB02}", "\x{FEE40}"=>"\x{E577}", "\x{FEE41}"=>"\x{E5B2}", "\x{FEE42}"=>"\x{EA9D}", "\x{FEE43}"=>"\x{EB74}", "\x{FEE44}"=>"\x{EB81}", "\x{FEE45}"=>"\x{EB89}", "\x{FEE46}"=>"\x{EB8A}", "\x{FEE47}"=>"\x{EB8B}", "\x{FEE48}"=>"\x{EB8C}", "\x{FEE49}"=>"\x{EB8D}", "\x{FEE4A}"=>"\x{EB8E}"
);

sub google_unicode_to_kddi_unicode {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_kddi_unicode{$1} || &$check(ord $1)
    }egomx;
}

sub softbank_unicode_to_google_unicode {
    $_[1] =~ tr
    [\x{E001}\x{E002}\x{E003}\x{E004}\x{E005}\x{E006}\x{E007}\x{E008}\x{E009}\x{E00A}\x{E00B}\x{E00C}\x{E00D}\x{E00E}\x{E00F}\x{E010}\x{E011}\x{E012}\x{E013}\x{E014}\x{E015}\x{E016}\x{E017}\x{E018}\x{E019}\x{E01A}\x{E01B}\x{E01C}\x{E01D}\x{E01E}\x{E01F}\x{E020}\x{E021}\x{E022}\x{E023}\x{E024}\x{E025}\x{E026}\x{E027}\x{E028}\x{E029}\x{E02A}\x{E02B}\x{E02C}\x{E02D}\x{E02E}\x{E02F}\x{E030}\x{E031}\x{E032}\x{E033}\x{E034}\x{E035}\x{E036}\x{E037}\x{E038}\x{E039}\x{E03A}\x{E03B}\x{E03C}\x{E03D}\x{E03E}\x{E03F}\x{E040}\x{E041}\x{E042}\x{E043}\x{E044}\x{E045}\x{E046}\x{E047}\x{E048}\x{E049}\x{E04A}\x{E04B}\x{E04C}\x{E04D}\x{E04E}\x{E04F}\x{E050}\x{E051}\x{E052}\x{E053}\x{E054}\x{E055}\x{E056}\x{E057}\x{E058}\x{E059}\x{E05A}\x{E101}\x{E102}\x{E103}\x{E104}\x{E105}\x{E106}\x{E107}\x{E108}\x{E109}\x{E10A}\x{E10B}\x{E10C}\x{E10D}\x{E10E}\x{E10F}\x{E110}\x{E111}\x{E112}\x{E113}\x{E114}\x{E115}\x{E116}\x{E117}\x{E118}\x{E119}\x{E11A}\x{E11B}\x{E11C}\x{E11D}\x{E11E}\x{E11F}\x{E120}\x{E121}\x{E122}\x{E123}\x{E124}\x{E125}\x{E126}\x{E127}\x{E128}\x{E129}\x{E12A}\x{E12B}\x{E12C}\x{E12D}\x{E12E}\x{E12F}\x{E130}\x{E131}\x{E132}\x{E133}\x{E134}\x{E135}\x{E136}\x{E137}\x{E138}\x{E139}\x{E13A}\x{E13B}\x{E13C}\x{E13D}\x{E13E}\x{E13F}\x{E140}\x{E141}\x{E142}\x{E143}\x{E144}\x{E145}\x{E146}\x{E147}\x{E148}\x{E149}\x{E14A}\x{E14B}\x{E14C}\x{E14D}\x{E14E}\x{E14F}\x{E150}\x{E151}\x{E152}\x{E153}\x{E154}\x{E155}\x{E156}\x{E157}\x{E158}\x{E159}\x{E15A}\x{E201}\x{E202}\x{E203}\x{E204}\x{E205}\x{E206}\x{E207}\x{E208}\x{E209}\x{E20A}\x{E20B}\x{E20C}\x{E20D}\x{E20E}\x{E20F}\x{E210}\x{E211}\x{E212}\x{E213}\x{E214}\x{E215}\x{E216}\x{E217}\x{E218}\x{E219}\x{E21A}\x{E21B}\x{E21C}\x{E21D}\x{E21E}\x{E21F}\x{E220}\x{E221}\x{E222}\x{E223}\x{E224}\x{E225}\x{E226}\x{E227}\x{E228}\x{E229}\x{E22A}\x{E22B}\x{E22C}\x{E22D}\x{E22E}\x{E22F}\x{E230}\x{E231}\x{E232}\x{E233}\x{E234}\x{E235}\x{E236}\x{E237}\x{E238}\x{E239}\x{E23A}\x{E23B}\x{E23C}\x{E23D}\x{E23E}\x{E23F}\x{E240}\x{E241}\x{E242}\x{E243}\x{E244}\x{E245}\x{E246}\x{E247}\x{E248}\x{E249}\x{E24A}\x{E24B}\x{E24C}\x{E24D}\x{E24E}\x{E24F}\x{E250}\x{E251}\x{E252}\x{E253}\x{E254}\x{E255}\x{E256}\x{E257}\x{E258}\x{E259}\x{E25A}\x{E301}\x{E302}\x{E303}\x{E304}\x{E305}\x{E306}\x{E307}\x{E308}\x{E309}\x{E30A}\x{E30B}\x{E30C}\x{E30D}\x{E30E}\x{E30F}\x{E310}\x{E311}\x{E312}\x{E313}\x{E314}\x{E315}\x{E316}\x{E317}\x{E318}\x{E319}\x{E31A}\x{E31B}\x{E31C}\x{E31D}\x{E31E}\x{E31F}\x{E320}\x{E321}\x{E322}\x{E323}\x{E324}\x{E325}\x{E326}\x{E327}\x{E328}\x{E329}\x{E32A}\x{E32B}\x{E32C}\x{E32D}\x{E32E}\x{E32F}\x{E330}\x{E331}\x{E332}\x{E333}\x{E334}\x{E335}\x{E336}\x{E337}\x{E338}\x{E339}\x{E33A}\x{E33B}\x{E33C}\x{E33D}\x{E33E}\x{E33F}\x{E340}\x{E341}\x{E342}\x{E343}\x{E344}\x{E345}\x{E346}\x{E347}\x{E348}\x{E349}\x{E34A}\x{E34B}\x{E34C}\x{E34D}\x{E401}\x{E402}\x{E403}\x{E404}\x{E405}\x{E406}\x{E407}\x{E408}\x{E409}\x{E40A}\x{E40B}\x{E40C}\x{E40D}\x{E40E}\x{E40F}\x{E410}\x{E411}\x{E412}\x{E413}\x{E414}\x{E415}\x{E416}\x{E417}\x{E418}\x{E419}\x{E41A}\x{E41B}\x{E41C}\x{E41D}\x{E41E}\x{E41F}\x{E420}\x{E421}\x{E422}\x{E423}\x{E424}\x{E425}\x{E426}\x{E427}\x{E428}\x{E429}\x{E42A}\x{E42B}\x{E42C}\x{E42D}\x{E42E}\x{E42F}\x{E430}\x{E431}\x{E432}\x{E433}\x{E434}\x{E435}\x{E436}\x{E437}\x{E438}\x{E439}\x{E43A}\x{E43B}\x{E43C}\x{E43D}\x{E43E}\x{E43F}\x{E440}\x{E441}\x{E442}\x{E443}\x{E444}\x{E445}\x{E446}\x{E447}\x{E448}\x{E449}\x{E44A}\x{E44B}\x{E44C}\x{E501}\x{E502}\x{E503}\x{E504}\x{E505}\x{E506}\x{E507}\x{E508}\x{E509}\x{E50A}\x{E50B}\x{E50C}\x{E50D}\x{E50E}\x{E50F}\x{E510}\x{E511}\x{E512}\x{E513}\x{E514}\x{E515}\x{E516}\x{E517}\x{E518}\x{E519}\x{E51A}\x{E51B}\x{E51C}\x{E51D}\x{E51E}\x{E51F}\x{E520}\x{E521}\x{E522}\x{E523}\x{E524}\x{E525}\x{E526}\x{E527}\x{E528}\x{E529}\x{E52A}\x{E52B}\x{E52C}\x{E52D}\x{E52E}\x{E52F}\x{E530}\x{E531}\x{E532}\x{E533}\x{E534}\x{E535}\x{E536}\x{E537}\x{E538}\x{E539}\x{E53A}\x{E53B}\x{E53C}\x{E53D}\x{E53E}]
    [\x{FE19B}\x{FE19C}\x{FE823}\x{FE19D}\x{FE19E}\x{FE4CF}\x{FE4CD}\x{FE4EF}\x{FE523}\x{FE525}\x{FE528}\x{FE538}\x{FEB96}\x{FEB97}\x{FEB98}\x{FEB93}\x{FEB94}\x{FEB95}\x{FE7D5}\x{FE7D2}\x{FE7D3}\x{FE7D1}\x{FE7DA}\x{FE7D4}\x{FE1BD}\x{FE1BE}\x{FE7E4}\x{FE7EA}\x{FE7E9}\x{FE7DF}\x{FE7E3}\x{FEB09}\x{FEB04}\x{FEB0C}\x{FEB0E}\x{FE01E}\x{FE01F}\x{FE020}\x{FE021}\x{FE022}\x{FE023}\x{FE024}\x{FE025}\x{FE026}\x{FE027}\x{FE028}\x{FE029}\x{FE040}\x{FE4D2}\x{FE041}\x{FE512}\x{FE825}\x{FE826}\x{FE4B0}\x{FE4BB}\x{FE4B2}\x{FE7EC}\x{FE7F5}\x{FE4C3}\x{FE800}\x{FE801}\x{FE813}\x{FEB82}\x{FE815}\x{FE816}\x{FE818}\x{FE980}\x{FE982}\x{FE981}\x{FE962}\x{FE983}\x{FE003}\x{FE001}\x{FE000}\x{FE002}\x{FE014}\x{FE009}\x{FE1AF}\x{FE1B8}\x{FE1C0}\x{FE1C1}\x{FE1B7}\x{FE1C2}\x{FE1C3}\x{FE1BC}\x{FE335}\x{FE330}\x{FE323}\x{FE320}\x{FE4F4}\x{FE52C}\x{FE52E}\x{FE52B}\x{FE526}\x{FE329}\x{FE327}\x{FE341}\x{FE344}\x{FE1C4}\x{FE1C5}\x{FE1BF}\x{FE1B0}\x{FE7ED}\x{FE4D1}\x{FEB56}\x{FE03C}\x{FE827}\x{FE510}\x{FE4F5}\x{FEB85}\x{FE7D9}\x{FE4CA}\x{FE515}\x{FE03F}\x{FE042}\x{FE1B2}\x{FE1AE}\x{FE1B3}\x{FE4F6}\x{FE53B}\x{FE537}\x{FE960}\x{FE4BC}\x{FE7FB}\x{FE7FA}\x{FE7FD}\x{FE807}\x{FE81D}\x{FE81E}\x{FE81F}\x{FE820}\x{FE81C}\x{FE1B1}\x{FE81B}\x{FE80B}\x{FEB32}\x{FE4DD}\x{FE80C}\x{FE7DB}\x{FE7D7}\x{FE80D}\x{FE7DC}\x{FE7EE}\x{FE7EB}\x{FE7F8}\x{FEB33}\x{FEB34}\x{FEB35}\x{FE509}\x{FEB59}\x{FE004}\x{FE4D6}\x{FE505}\x{FE507}\x{FE821}\x{FE52F}\x{FE514}\x{FEB86}\x{FEB87}\x{FE00B}\x{FE965}\x{FE546}\x{FE4DE}\x{FE4DF}\x{FE531}\x{FEB5E}\x{FE4B5}\x{FE7F7}\x{FE7F6}\x{FE7E7}\x{FE506}\x{FE1A1}\x{FE4B3}\x{FE4B6}\x{FE4B4}\x{FE4B9}\x{FE4BA}\x{FE4B7}\x{FE7E6}\x{FE7EF}\x{FE7F0}\x{FE7E8}\x{FEB24}\x{FEB19}\x{FEB61}\x{FEB62}\x{FEB25}\x{FEB1F}\x{FE044}\x{FEB20}\x{FE838}\x{FEB1A}\x{FEB1C}\x{FEB1B}\x{FEB1D}\x{FE82C}\x{FE82B}\x{FEB36}\x{FEB37}\x{FEB38}\x{FEB39}\x{FEB3A}\x{FEB3B}\x{FEB3C}\x{FEB63}\x{FEB64}\x{FEB67}\x{FE82E}\x{FE82F}\x{FE830}\x{FE831}\x{FE832}\x{FE833}\x{FE834}\x{FE835}\x{FE836}\x{FE837}\x{FEB3D}\x{FEB3E}\x{FEB3F}\x{FEB81}\x{FEB31}\x{FEB2F}\x{FEB40}\x{FEB41}\x{FEB99}\x{FEB9A}\x{FEB9B}\x{FEB9C}\x{FEAF8}\x{FEAF9}\x{FEAFA}\x{FEAFB}\x{FEAF0}\x{FEAF2}\x{FEAF1}\x{FEAF3}\x{FEAFC}\x{FEAFD}\x{FEAFE}\x{FEAFF}\x{FE4F8}\x{FE02B}\x{FE02C}\x{FE02D}\x{FE02E}\x{FE02F}\x{FE030}\x{FE031}\x{FE032}\x{FE033}\x{FE034}\x{FE035}\x{FE036}\x{FE037}\x{FEB42}\x{FEB27}\x{FEB29}\x{FEB2D}\x{FE839}\x{FE83A}\x{FEB23}\x{FE1B4}\x{FEE77}\x{FEE78}\x{FEE79}\x{FEE7A}\x{FEE7B}\x{FEE7C}\x{FEE7D}\x{FE527}\x{FE4D3}\x{FE045}\x{FE03D}\x{FE046}\x{FE828}\x{FE047}\x{FE048}\x{FE508}\x{FE803}\x{FE985}\x{FE987}\x{FEB43}\x{FEB1E}\x{FE50A}\x{FE516}\x{FEB58}\x{FE517}\x{FE53E}\x{FE50F}\x{FEB2B}\x{FE53C}\x{FE530}\x{FE4D4}\x{FE4D5}\x{FE4D7}\x{FE4D8}\x{FE195}\x{FE196}\x{FE197}\x{FE198}\x{FE199}\x{FE4D9}\x{FE4DA}\x{FE4F0}\x{FE808}\x{FE4F2}\x{FE814}\x{FEB0D}\x{FEB11}\x{FEB12}\x{FEB13}\x{FEB14}\x{FEB15}\x{FEB16}\x{FEB60}\x{FEB68}\x{FEB5D}\x{FEB5B}\x{FEB44}\x{FEB45}\x{FEB57}\x{FEB69}\x{FEB0A}\x{FEB0B}\x{FE984}\x{FE964}\x{FE966}\x{FE967}\x{FE968}\x{FE969}\x{FE96A}\x{FE96B}\x{FE963}\x{FE96C}\x{FE961}\x{FE96D}\x{FE96E}\x{FE051}\x{FE052}\x{FE053}\x{FE054}\x{FE055}\x{FE056}\x{FE511}\x{FE96F}\x{FE970}\x{FE345}\x{FE343}\x{FE340}\x{FE328}\x{FE347}\x{FE33C}\x{FE33F}\x{FE342}\x{FE32A}\x{FE33E}\x{FE33B}\x{FE32E}\x{FE32F}\x{FE326}\x{FE325}\x{FE322}\x{FE33A}\x{FE334}\x{FE339}\x{FE336}\x{FE338}\x{FE33D}\x{FE32D}\x{FE32C}\x{FE190}\x{FE192}\x{FE191}\x{FE193}\x{FE35B}\x{FEB9D}\x{FEB9E}\x{FEB9F}\x{FEBA0}\x{FEBA1}\x{FE351}\x{FE352}\x{FE829}\x{FE353}\x{FE358}\x{FE1A0}\x{FE1A2}\x{FE7D6}\x{FE7DD}\x{FE80E}\x{FE7DE}\x{FE7E5}\x{FE7F1}\x{FE7F2}\x{FE7F3}\x{FE7F4}\x{FE7FE}\x{FE7E0}\x{FE7E2}\x{FE518}\x{FEB17}\x{FE519}\x{FE51A}\x{FE51B}\x{FE51C}\x{FE007}\x{FE82A}\x{FE038}\x{FE971}\x{FE51D}\x{FE1C6}\x{FE51E}\x{FE005}\x{FE049}\x{FE51F}\x{FE017}\x{FE043}\x{FE513}\x{FE00A}\x{FE00C}\x{FE008}\x{FE00D}\x{FE4B8}\x{FE804}\x{FE805}\x{FE4BD}\x{FE4BE}\x{FE4BF}\x{FE802}\x{FE4C0}\x{FE4C4}\x{FE4C5}\x{FE4E5}\x{FE4E6}\x{FE4E7}\x{FE4E8}\x{FE4E9}\x{FE4EA}\x{FE4EB}\x{FE4EC}\x{FE4ED}\x{FE4EE}\x{FE1A4}\x{FE1A5}\x{FE1A6}\x{FE1A7}\x{FE1A8}\x{FE1A9}\x{FE1AA}\x{FE1AB}\x{FE4C6}\x{FE1B5}\x{FE1B6}\x{FE1C7}\x{FE1C8}\x{FE1C9}\x{FE1BA}\x{FE1CA}\x{FE1CB}\x{FE1CC}\x{FE1CD}\x{FE1CE}\x{FE1CF}\x{FE1D0}\x{FE1D1}\x{FE1D2}\x{FE1D3}\x{FE1D4}\x{FE1D5}\x{FE1D6}\x{FE1D7}\x{FE50B}\x{FE50C}\x{FE50D}\x{FE50E}\x{FE553}\x{FEB2A}\x{FEE70}\x{FEE71}\x{FEE72}\x{FEE73}\x{FEE74}\x{FEE75}\x{FEE76}];
}

our %map_google_unicode_to_softbank_unicode = (
    "\x{FE000}"=>"\x{E04A}", "\x{FE001}"=>"\x{E049}", "\x{FE002}"=>"\x{E04B}", "\x{FE003}"=>"\x{E048}", "\x{FE004}"=>"\x{E13D}", "\x{FE005}"=>"\x{E443}", "\x{FE007}"=>"\x{E43C}", "\x{FE008}"=>"\x{E44B}", "\x{FE009}"=>"\x{E04D}", "\x{FE00A}"=>"\x{E449}", "\x{FE00B}"=>"\x{E146}", "\x{FE00C}"=>"\x{E44A}", "\x{FE00D}"=>"\x{E44C}", "\x{FE00F}"=>"\x{E04A}\x{E049}", "\x{FE010}"=>"\x{E44B}", "\x{FE012}"=>"\x{E04C}", "\x{FE013}"=>"\x{E04C}", "\x{FE014}"=>"\x{E04C}", "\x{FE016}"=>"\x{E04C}", "\x{FE017}"=>"\x{E446}", "\x{FE01E}"=>"\x{E024}", "\x{FE01F}"=>"\x{E025}", "\x{FE020}"=>"\x{E026}", "\x{FE021}"=>"\x{E027}", "\x{FE022}"=>"\x{E028}", "\x{FE023}"=>"\x{E029}", "\x{FE024}"=>"\x{E02A}", "\x{FE025}"=>"\x{E02B}", "\x{FE026}"=>"\x{E02C}", "\x{FE027}"=>"\x{E02D}", "\x{FE028}"=>"\x{E02E}", "\x{FE029}"=>"\x{E02F}", "\x{FE02A}"=>"\x{E02D}", "\x{FE02B}"=>"\x{E23F}", "\x{FE02C}"=>"\x{E240}", "\x{FE02D}"=>"\x{E241}", "\x{FE02E}"=>"\x{E242}", "\x{FE02F}"=>"\x{E243}", "\x{FE030}"=>"\x{E244}", "\x{FE031}"=>"\x{E245}", "\x{FE032}"=>"\x{E246}", "\x{FE033}"=>"\x{E247}", "\x{FE034}"=>"\x{E248}", "\x{FE035}"=>"\x{E249}", "\x{FE036}"=>"\x{E24A}", "\x{FE037}"=>"\x{E24B}", "\x{FE038}"=>"\x{E43E}", "\x{FE03B}"=>"\x{E44B}", "\x{FE03C}"=>"\x{E110}", "\x{FE03D}"=>"\x{E304}", "\x{FE03E}"=>"\x{E110}", "\x{FE03F}"=>"\x{E118}", "\x{FE040}"=>"\x{E030}", "\x{FE041}"=>"\x{E032}", "\x{FE042}"=>"\x{E119}", "\x{FE043}"=>"\x{E447}", "\x{FE044}"=>"\x{E209}", "\x{FE045}"=>"\x{E303}", "\x{FE046}"=>"\x{E305}", "\x{FE047}"=>"\x{E307}", "\x{FE048}"=>"\x{E308}", "\x{FE049}"=>"\x{E444}", "\x{FE04D}"=>"\x{E305}", "\x{FE04E}"=>"\x{E110}", "\x{FE051}"=>"\x{E345}", "\x{FE052}"=>"\x{E346}", "\x{FE053}"=>"\x{E347}", "\x{FE054}"=>"\x{E348}", "\x{FE055}"=>"\x{E349}", "\x{FE056}"=>"\x{E34A}", "\x{FE05B}"=>"\x{E345}", "\x{FE190}"=>"\x{E419}", "\x{FE191}"=>"\x{E41B}", "\x{FE192}"=>"\x{E41A}", "\x{FE193}"=>"\x{E41C}", "\x{FE194}"=>"\x{E409}", "\x{FE195}"=>"\x{E31C}", "\x{FE196}"=>"\x{E31D}", "\x{FE197}"=>"\x{E31E}", "\x{FE198}"=>"\x{E31F}", "\x{FE199}"=>"\x{E320}", "\x{FE19B}"=>"\x{E001}", "\x{FE19C}"=>"\x{E002}", "\x{FE19D}"=>"\x{E004}", "\x{FE19E}"=>"\x{E005}", "\x{FE1A0}"=>"\x{E428}", "\x{FE1A1}"=>"\x{E152}", "\x{FE1A2}"=>"\x{E429}", "\x{FE1A4}"=>"\x{E515}", "\x{FE1A5}"=>"\x{E516}", "\x{FE1A6}"=>"\x{E517}", "\x{FE1A7}"=>"\x{E518}", "\x{FE1A8}"=>"\x{E519}", "\x{FE1A9}"=>"\x{E51A}", "\x{FE1AA}"=>"\x{E51B}", "\x{FE1AB}"=>"\x{E51C}", "\x{FE1AE}"=>"\x{E11B}", "\x{FE1AF}"=>"\x{E04E}", "\x{FE1B0}"=>"\x{E10C}", "\x{FE1B1}"=>"\x{E12B}", "\x{FE1B2}"=>"\x{E11A}", "\x{FE1B3}"=>"\x{E11C}", "\x{FE1B4}"=>"\x{E253}", "\x{FE1B5}"=>"\x{E51E}", "\x{FE1B6}"=>"\x{E51F}", "\x{FE1B7}"=>"\x{E052}", "\x{FE1B8}"=>"\x{E04F}", "\x{FE1BA}"=>"\x{E523}", "\x{FE1BB}"=>"\x{E523}", "\x{FE1BC}"=>"\x{E055}", "\x{FE1BD}"=>"\x{E019}", "\x{FE1BE}"=>"\x{E01A}", "\x{FE1BF}"=>"\x{E10B}", "\x{FE1C0}"=>"\x{E050}", "\x{FE1C1}"=>"\x{E051}", "\x{FE1C2}"=>"\x{E053}", "\x{FE1C3}"=>"\x{E054}", "\x{FE1C4}"=>"\x{E109}", "\x{FE1C5}"=>"\x{E10A}", "\x{FE1C6}"=>"\x{E441}", "\x{FE1C7}"=>"\x{E520}", "\x{FE1C8}"=>"\x{E521}", "\x{FE1C9}"=>"\x{E522}", "\x{FE1CA}"=>"\x{E524}", "\x{FE1CB}"=>"\x{E525}", "\x{FE1CC}"=>"\x{E526}", "\x{FE1CD}"=>"\x{E527}", "\x{FE1CE}"=>"\x{E528}", "\x{FE1CF}"=>"\x{E529}", "\x{FE1D0}"=>"\x{E52A}", "\x{FE1D1}"=>"\x{E52B}", "\x{FE1D2}"=>"\x{E52C}", "\x{FE1D3}"=>"\x{E52D}", "\x{FE1D4}"=>"\x{E52E}", "\x{FE1D5}"=>"\x{E52F}", "\x{FE1D6}"=>"\x{E530}", "\x{FE1D7}"=>"\x{E531}", "\x{FE1D8}"=>"\x{E052}", "\x{FE1D9}"=>"\x{E019}", "\x{FE1DB}"=>"\x{E536}", "\x{FE1DD}"=>"\x{E523}", "\x{FE1E0}"=>"\x{E10B}", "\x{FE320}"=>"\x{E059}", "\x{FE321}"=>"\x{E403}", "\x{FE322}"=>"\x{E410}", "\x{FE323}"=>"\x{E058}", "\x{FE324}"=>"\x{E406}", "\x{FE325}"=>"\x{E40F}", "\x{FE326}"=>"\x{E40E}", "\x{FE327}"=>"\x{E106}", "\x{FE328}"=>"\x{E404}", "\x{FE329}"=>"\x{E105}", "\x{FE32A}"=>"\x{E409}", "\x{FE32B}"=>"\x{E056}", "\x{FE32C}"=>"\x{E418}", "\x{FE32D}"=>"\x{E417}", "\x{FE32E}"=>"\x{E40C}", "\x{FE32F}"=>"\x{E40D}", "\x{FE330}"=>"\x{E057}", "\x{FE331}"=>"\x{E415}\x{E331}", "\x{FE332}"=>"\x{E40A}", "\x{FE333}"=>"\x{E404}", "\x{FE334}"=>"\x{E412}", "\x{FE335}"=>"\x{E056}", "\x{FE336}"=>"\x{E414}", "\x{FE337}"=>"\x{E056}", "\x{FE338}"=>"\x{E415}", "\x{FE339}"=>"\x{E413}", "\x{FE33A}"=>"\x{E411}", "\x{FE33B}"=>"\x{E40B}", "\x{FE33C}"=>"\x{E406}", "\x{FE33D}"=>"\x{E416}", "\x{FE33E}"=>"\x{E40A}", "\x{FE33F}"=>"\x{E407}", "\x{FE340}"=>"\x{E403}", "\x{FE341}"=>"\x{E107}", "\x{FE342}"=>"\x{E408}", "\x{FE343}"=>"\x{E402}", "\x{FE344}"=>"\x{E108}", "\x{FE345}"=>"\x{E401}", "\x{FE346}"=>"\x{E406}", "\x{FE347}"=>"\x{E405}", "\x{FE348}"=>"\x{E057}", "\x{FE349}"=>"\x{E404}", "\x{FE34A}"=>"\x{E412}", "\x{FE34B}"=>"\x{E418}", "\x{FE34C}"=>"\x{E106}", "\x{FE34D}"=>"\x{E413}", "\x{FE34E}"=>"\x{E416}", "\x{FE34F}"=>"\x{E404}", "\x{FE350}"=>"\x{E403}", "\x{FE351}"=>"\x{E423}", "\x{FE352}"=>"\x{E424}", "\x{FE353}"=>"\x{E426}", "\x{FE357}"=>"\x{E012}", "\x{FE358}"=>"\x{E427}", "\x{FE359}"=>"\x{E403}", "\x{FE35A}"=>"\x{E416}", "\x{FE35B}"=>"\x{E41D}", "\x{FE4B0}"=>"\x{E036}", "\x{FE4B1}"=>"\x{E036}", "\x{FE4B2}"=>"\x{E038}", "\x{FE4B3}"=>"\x{E153}", "\x{FE4B4}"=>"\x{E155}", "\x{FE4B5}"=>"\x{E14D}", "\x{FE4B6}"=>"\x{E154}", "\x{FE4B7}"=>"\x{E158}", "\x{FE4B8}"=>"\x{E501}", "\x{FE4B9}"=>"\x{E156}", "\x{FE4BA}"=>"\x{E157}", "\x{FE4BB}"=>"\x{E037}", "\x{FE4BC}"=>"\x{E121}", "\x{FE4BD}"=>"\x{E504}", "\x{FE4BE}"=>"\x{E505}", "\x{FE4BF}"=>"\x{E506}", "\x{FE4C0}"=>"\x{E508}", "\x{FE4C1}"=>"\x{E202}", "\x{FE4C2}"=>"\x{E30B}", "\x{FE4C3}"=>"\x{E03B}", "\x{FE4C4}"=>"\x{E509}", "\x{FE4C5}"=>"\x{E50A}", "\x{FE4C6}"=>"\x{E51D}", "\x{FE4CA}"=>"\x{E116}", "\x{FE4CC}"=>"\x{E007}", "\x{FE4CD}"=>"\x{E007}", "\x{FE4CF}"=>"\x{E006}", "\x{FE4D1}"=>"\x{E10E}", "\x{FE4D2}"=>"\x{E031}", "\x{FE4D3}"=>"\x{E302}", "\x{FE4D4}"=>"\x{E318}", "\x{FE4D5}"=>"\x{E319}", "\x{FE4D6}"=>"\x{E13E}", "\x{FE4D7}"=>"\x{E31A}", "\x{FE4D8}"=>"\x{E31B}", "\x{FE4D9}"=>"\x{E321}", "\x{FE4DA}"=>"\x{E322}", "\x{FE4DB}"=>"\x{E006}", "\x{FE4DD}"=>"\x{E12F}", "\x{FE4DE}"=>"\x{E149}", "\x{FE4DF}"=>"\x{E14A}", "\x{FE4E0}"=>"\x{E12F}", "\x{FE4E3}"=>"\x{E12F}", "\x{FE4E5}"=>"\x{E50B}", "\x{FE4E6}"=>"\x{E50C}", "\x{FE4E7}"=>"\x{E50D}", "\x{FE4E8}"=>"\x{E50E}", "\x{FE4E9}"=>"\x{E50F}", "\x{FE4EA}"=>"\x{E510}", "\x{FE4EB}"=>"\x{E511}", "\x{FE4EC}"=>"\x{E512}", "\x{FE4ED}"=>"\x{E513}", "\x{FE4EE}"=>"\x{E514}", "\x{FE4EF}"=>"\x{E008}", "\x{FE4F0}"=>"\x{E323}", "\x{FE4F2}"=>"\x{E325}", "\x{FE4F4}"=>"\x{E05A}", "\x{FE4F5}"=>"\x{E113}", "\x{FE4F6}"=>"\x{E11D}", "\x{FE4F7}"=>"\x{E23E}", "\x{FE4F8}"=>"\x{E23E}", "\x{FE4F9}"=>"\x{E03D}", "\x{FE4FF}"=>"\x{E148}", "\x{FE500}"=>"\x{E148}", "\x{FE501}"=>"\x{E148}", "\x{FE502}"=>"\x{E148}", "\x{FE503}"=>"\x{E148}", "\x{FE505}"=>"\x{E13F}", "\x{FE506}"=>"\x{E151}", "\x{FE507}"=>"\x{E140}", "\x{FE508}"=>"\x{E309}", "\x{FE509}"=>"\x{E13B}", "\x{FE50A}"=>"\x{E30F}", "\x{FE50B}"=>"\x{E532}", "\x{FE50C}"=>"\x{E533}", "\x{FE50D}"=>"\x{E534}", "\x{FE50E}"=>"\x{E535}", "\x{FE50F}"=>"\x{E314}", "\x{FE510}"=>"\x{E112}", "\x{FE511}"=>"\x{E34B}", "\x{FE512}"=>"\x{E033}", "\x{FE513}"=>"\x{E448}", "\x{FE514}"=>"\x{E143}", "\x{FE515}"=>"\x{E117}", "\x{FE516}"=>"\x{E310}", "\x{FE517}"=>"\x{E312}", "\x{FE518}"=>"\x{E436}", "\x{FE519}"=>"\x{E438}", "\x{FE51A}"=>"\x{E439}", "\x{FE51B}"=>"\x{E43A}", "\x{FE51C}"=>"\x{E43B}", "\x{FE51D}"=>"\x{E440}", "\x{FE51E}"=>"\x{E442}", "\x{FE51F}"=>"\x{E445}", "\x{FE523}"=>"\x{E009}", "\x{FE524}"=>"\x{E009}", "\x{FE525}"=>"\x{E00A}", "\x{FE526}"=>"\x{E104}", "\x{FE527}"=>"\x{E301}", "\x{FE528}"=>"\x{E00B}", "\x{FE529}"=>"\x{E103}", "\x{FE52A}"=>"\x{E103}", "\x{FE52B}"=>"\x{E103}", "\x{FE52C}"=>"\x{E101}", "\x{FE52D}"=>"\x{E101}", "\x{FE52E}"=>"\x{E102}", "\x{FE52F}"=>"\x{E142}", "\x{FE530}"=>"\x{E317}", "\x{FE531}"=>"\x{E14B}", "\x{FE535}"=>"\x{E112}", "\x{FE537}"=>"\x{E11F}", "\x{FE538}"=>"\x{E00C}", "\x{FE539}"=>"\x{E301}", "\x{FE53B}"=>"\x{E11E}", "\x{FE53C}"=>"\x{E316}", "\x{FE53D}"=>"\x{E316}", "\x{FE53E}"=>"\x{E313}", "\x{FE540}"=>"\x{E301}", "\x{FE541}"=>"\x{E301}", "\x{FE545}"=>"\x{E148}", "\x{FE546}"=>"\x{E148}", "\x{FE547}"=>"\x{E148}", "\x{FE548}"=>"\x{E301}", "\x{FE54A}"=>"\x{E14A}", "\x{FE54B}"=>"\x{E14A}", "\x{FE54D}"=>"\x{E148}", "\x{FE54F}"=>"\x{E148}", "\x{FE552}"=>"\x{E301}", "\x{FE553}"=>"\x{E536}", "\x{FE7D1}"=>"\x{E016}", "\x{FE7D2}"=>"\x{E014}", "\x{FE7D3}"=>"\x{E015}", "\x{FE7D4}"=>"\x{E018}", "\x{FE7D5}"=>"\x{E013}", "\x{FE7D6}"=>"\x{E42A}", "\x{FE7D7}"=>"\x{E132}", "\x{FE7D9}"=>"\x{E115}", "\x{FE7DA}"=>"\x{E017}", "\x{FE7DB}"=>"\x{E131}", "\x{FE7DC}"=>"\x{E134}", "\x{FE7DD}"=>"\x{E42B}", "\x{FE7DE}"=>"\x{E42D}", "\x{FE7DF}"=>"\x{E01E}", "\x{FE7E0}"=>"\x{E434}", "\x{FE7E1}"=>"\x{E434}", "\x{FE7E2}"=>"\x{E435}", "\x{FE7E3}"=>"\x{E01F}", "\x{FE7E4}"=>"\x{E01B}", "\x{FE7E5}"=>"\x{E42E}", "\x{FE7E6}"=>"\x{E159}", "\x{FE7E7}"=>"\x{E150}", "\x{FE7E8}"=>"\x{E202}", "\x{FE7E9}"=>"\x{E01D}", "\x{FE7EA}"=>"\x{E01C}", "\x{FE7EB}"=>"\x{E136}", "\x{FE7EC}"=>"\x{E039}", "\x{FE7ED}"=>"\x{E10D}", "\x{FE7EE}"=>"\x{E135}", "\x{FE7EF}"=>"\x{E15A}", "\x{FE7F0}"=>"\x{E201}", "\x{FE7F1}"=>"\x{E42F}", "\x{FE7F2}"=>"\x{E430}", "\x{FE7F3}"=>"\x{E431}", "\x{FE7F4}"=>"\x{E432}", "\x{FE7F5}"=>"\x{E03A}", "\x{FE7F6}"=>"\x{E14F}", "\x{FE7F7}"=>"\x{E14E}", "\x{FE7F8}"=>"\x{E137}", "\x{FE7F9}"=>"\x{E432}", "\x{FE7FA}"=>"\x{E123}", "\x{FE7FB}"=>"\x{E122}", "\x{FE7FD}"=>"\x{E124}", "\x{FE7FE}"=>"\x{E433}", "\x{FE7FF}"=>"\x{E019}", "\x{FE800}"=>"\x{E03C}", "\x{FE801}"=>"\x{E03D}", "\x{FE802}"=>"\x{E507}", "\x{FE803}"=>"\x{E30A}", "\x{FE804}"=>"\x{E502}", "\x{FE805}"=>"\x{E503}", "\x{FE807}"=>"\x{E125}", "\x{FE808}"=>"\x{E324}", "\x{FE809}"=>"\x{E503}", "\x{FE80B}"=>"\x{E12D}", "\x{FE80C}"=>"\x{E130}", "\x{FE80D}"=>"\x{E133}", "\x{FE80E}"=>"\x{E42C}", "\x{FE813}"=>"\x{E03E}", "\x{FE814}"=>"\x{E326}", "\x{FE815}"=>"\x{E040}", "\x{FE816}"=>"\x{E041}", "\x{FE818}"=>"\x{E042}", "\x{FE81A}"=>"\x{E326}", "\x{FE81B}"=>"\x{E12C}", "\x{FE81C}"=>"\x{E12A}", "\x{FE81D}"=>"\x{E126}", "\x{FE81E}"=>"\x{E127}", "\x{FE81F}"=>"\x{E128}", "\x{FE820}"=>"\x{E129}", "\x{FE821}"=>"\x{E141}", "\x{FE823}"=>"\x{E003}", "\x{FE824}"=>"\x{E103}\x{E328}", "\x{FE825}"=>"\x{E034}", "\x{FE826}"=>"\x{E035}", "\x{FE827}"=>"\x{E111}", "\x{FE828}"=>"\x{E306}", "\x{FE829}"=>"\x{E425}", "\x{FE82A}"=>"\x{E43D}", "\x{FE82B}"=>"\x{E211}", "\x{FE82C}"=>"\x{E210}", "\x{FE82E}"=>"\x{E21C}", "\x{FE82F}"=>"\x{E21D}", "\x{FE830}"=>"\x{E21E}", "\x{FE831}"=>"\x{E21F}", "\x{FE832}"=>"\x{E220}", "\x{FE833}"=>"\x{E221}", "\x{FE834}"=>"\x{E222}", "\x{FE835}"=>"\x{E223}", "\x{FE836}"=>"\x{E224}", "\x{FE837}"=>"\x{E225}", "\x{FE838}"=>"\x{E20B}", "\x{FE839}"=>"\x{E250}", "\x{FE83A}"=>"\x{E251}", "\x{FE960}"=>"\x{E120}", "\x{FE961}"=>"\x{E342}", "\x{FE962}"=>"\x{E046}", "\x{FE963}"=>"\x{E340}", "\x{FE964}"=>"\x{E339}", "\x{FE965}"=>"\x{E147}", "\x{FE966}"=>"\x{E33A}", "\x{FE967}"=>"\x{E33B}", "\x{FE968}"=>"\x{E33C}", "\x{FE969}"=>"\x{E33D}", "\x{FE96A}"=>"\x{E33E}", "\x{FE96B}"=>"\x{E33F}", "\x{FE96C}"=>"\x{E341}", "\x{FE96D}"=>"\x{E343}", "\x{FE96E}"=>"\x{E344}", "\x{FE96F}"=>"\x{E34C}", "\x{FE970}"=>"\x{E34D}", "\x{FE971}"=>"\x{E43F}", "\x{FE980}"=>"\x{E043}", "\x{FE981}"=>"\x{E045}", "\x{FE982}"=>"\x{E044}", "\x{FE983}"=>"\x{E047}", "\x{FE984}"=>"\x{E338}", "\x{FE985}"=>"\x{E30B}", "\x{FE986}"=>"\x{E044}", "\x{FE987}"=>"\x{E30C}", "\x{FE988}"=>"\x{E044}", "\x{FEAF0}"=>"\x{E236}", "\x{FEAF1}"=>"\x{E238}", "\x{FEAF2}"=>"\x{E237}", "\x{FEAF3}"=>"\x{E239}", "\x{FEAF4}"=>"\x{E236}", "\x{FEAF5}"=>"\x{E238}", "\x{FEAF8}"=>"\x{E232}", "\x{FEAF9}"=>"\x{E233}", "\x{FEAFA}"=>"\x{E234}", "\x{FEAFB}"=>"\x{E235}", "\x{FEAFC}"=>"\x{E23A}", "\x{FEAFD}"=>"\x{E23B}", "\x{FEAFE}"=>"\x{E23C}", "\x{FEAFF}"=>"\x{E23D}", "\x{FEB04}"=>"\x{E021}", "\x{FEB09}"=>"\x{E020}", "\x{FEB0A}"=>"\x{E336}", "\x{FEB0B}"=>"\x{E337}", "\x{FEB0C}"=>"\x{E022}", "\x{FEB0D}"=>"\x{E327}", "\x{FEB0E}"=>"\x{E023}", "\x{FEB0F}"=>"\x{E327}", "\x{FEB10}"=>"\x{E327}", "\x{FEB11}"=>"\x{E328}", "\x{FEB12}"=>"\x{E329}", "\x{FEB13}"=>"\x{E32A}", "\x{FEB14}"=>"\x{E32B}", "\x{FEB15}"=>"\x{E32C}", "\x{FEB16}"=>"\x{E32D}", "\x{FEB17}"=>"\x{E437}", "\x{FEB18}"=>"\x{E327}", "\x{FEB19}"=>"\x{E204}", "\x{FEB1A}"=>"\x{E20C}", "\x{FEB1B}"=>"\x{E20E}", "\x{FEB1C}"=>"\x{E20D}", "\x{FEB1D}"=>"\x{E20F}", "\x{FEB1E}"=>"\x{E30E}", "\x{FEB1F}"=>"\x{E208}", "\x{FEB20}"=>"\x{E20A}", "\x{FEB23}"=>"\x{E252}", "\x{FEB24}"=>"\x{E203}", "\x{FEB25}"=>"\x{E207}", "\x{FEB26}"=>"\x{E137}", "\x{FEB27}"=>"\x{E24D}", "\x{FEB29}"=>"\x{E24E}", "\x{FEB2A}"=>"\x{E537}", "\x{FEB2B}"=>"\x{E315}", "\x{FEB2D}"=>"\x{E24F}", "\x{FEB2F}"=>"\x{E22B}", "\x{FEB31}"=>"\x{E22A}", "\x{FEB32}"=>"\x{E12E}", "\x{FEB33}"=>"\x{E138}", "\x{FEB34}"=>"\x{E139}", "\x{FEB35}"=>"\x{E13A}", "\x{FEB36}"=>"\x{E212}", "\x{FEB37}"=>"\x{E213}", "\x{FEB38}"=>"\x{E214}", "\x{FEB39}"=>"\x{E215}", "\x{FEB3A}"=>"\x{E216}", "\x{FEB3B}"=>"\x{E217}", "\x{FEB3C}"=>"\x{E218}", "\x{FEB3D}"=>"\x{E226}", "\x{FEB3E}"=>"\x{E227}", "\x{FEB3F}"=>"\x{E228}", "\x{FEB40}"=>"\x{E22C}", "\x{FEB41}"=>"\x{E22D}", "\x{FEB42}"=>"\x{E24C}", "\x{FEB43}"=>"\x{E30D}", "\x{FEB44}"=>"\x{E332}", "\x{FEB45}"=>"\x{E333}", "\x{FEB46}"=>"\x{E333}", "\x{FEB53}"=>"\x{E333}", "\x{FEB56}"=>"\x{E10F}", "\x{FEB57}"=>"\x{E334}", "\x{FEB58}"=>"\x{E311}", "\x{FEB59}"=>"\x{E13C}", "\x{FEB5B}"=>"\x{E331}", "\x{FEB5C}"=>"\x{E331}", "\x{FEB5D}"=>"\x{E330}", "\x{FEB5E}"=>"\x{E14C}", "\x{FEB5F}"=>"\x{E407}", "\x{FEB60}"=>"\x{E32E}", "\x{FEB61}"=>"\x{E205}", "\x{FEB62}"=>"\x{E206}", "\x{FEB63}"=>"\x{E219}", "\x{FEB64}"=>"\x{E21A}", "\x{FEB65}"=>"\x{E219}", "\x{FEB66}"=>"\x{E219}", "\x{FEB67}"=>"\x{E21B}", "\x{FEB68}"=>"\x{E32F}", "\x{FEB69}"=>"\x{E335}", "\x{FEB6B}"=>"\x{E21B}", "\x{FEB6C}"=>"\x{E21A}", "\x{FEB6D}"=>"\x{E21B}", "\x{FEB6E}"=>"\x{E21A}", "\x{FEB6F}"=>"\x{E21B}", "\x{FEB70}"=>"\x{E21A}", "\x{FEB71}"=>"\x{E21B}", "\x{FEB72}"=>"\x{E21A}", "\x{FEB73}"=>"\x{E21B}", "\x{FEB74}"=>"\x{E21B}", "\x{FEB75}"=>"\x{E21B}", "\x{FEB76}"=>"\x{E21B}", "\x{FEB77}"=>"\x{E32E}", "\x{FEB81}"=>"\x{E229}", "\x{FEB82}"=>"\x{E03F}", "\x{FEB85}"=>"\x{E114}", "\x{FEB86}"=>"\x{E144}", "\x{FEB87}"=>"\x{E145}", "\x{FEB8A}"=>"\x{E144}", "\x{FEB8D}"=>"\x{E114}", "\x{FEB8E}"=>"\x{E235}", "\x{FEB90}"=>"\x{E144}", "\x{FEB92}"=>"\x{E103}", "\x{FEB93}"=>"\x{E010}", "\x{FEB94}"=>"\x{E011}", "\x{FEB95}"=>"\x{E012}", "\x{FEB96}"=>"\x{E00D}", "\x{FEB97}"=>"\x{E00E}", "\x{FEB98}"=>"\x{E00F}", "\x{FEB99}"=>"\x{E22E}", "\x{FEB9A}"=>"\x{E22F}", "\x{FEB9B}"=>"\x{E230}", "\x{FEB9C}"=>"\x{E231}", "\x{FEB9D}"=>"\x{E41E}", "\x{FEB9E}"=>"\x{E41F}", "\x{FEB9F}"=>"\x{E420}", "\x{FEBA0}"=>"\x{E421}", "\x{FEBA1}"=>"\x{E422}", "\x{FEE1C}"=>"\x{E03D}", "\x{FEE70}"=>"\x{E538}", "\x{FEE71}"=>"\x{E539}", "\x{FEE72}"=>"\x{E53A}", "\x{FEE73}"=>"\x{E53B}", "\x{FEE74}"=>"\x{E53C}", "\x{FEE75}"=>"\x{E53D}", "\x{FEE76}"=>"\x{E53E}", "\x{FEE77}"=>"\x{E254}", "\x{FEE78}"=>"\x{E255}", "\x{FEE79}"=>"\x{E256}", "\x{FEE7A}"=>"\x{E257}", "\x{FEE7B}"=>"\x{E258}", "\x{FEE7C}"=>"\x{E259}", "\x{FEE7D}"=>"\x{E25A}"
);

sub google_unicode_to_softbank_unicode {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_softbank_unicode{$1} || &$check(ord $1)
    }egomx;
}

our %map_unicode_unicode_to_google_unicode = (
    "#\x{20E3}"=>"\x{FE82C}", "0\x{20E3}"=>"\x{FE837}", "1\x{20E3}"=>"\x{FE82E}", "2\x{20E3}"=>"\x{FE82F}", "3\x{20E3}"=>"\x{FE830}", "4\x{20E3}"=>"\x{FE831}", "5\x{20E3}"=>"\x{FE832}", "6\x{20E3}"=>"\x{FE833}", "7\x{20E3}"=>"\x{FE834}", "8\x{20E3}"=>"\x{FE835}", "9\x{20E3}"=>"\x{FE836}", "\x{00A9}"=>"\x{FEB29}", "\x{00AE}"=>"\x{FEB2D}", "\x{2002}"=>"\x{FEB4D}", "\x{2003}"=>"\x{FEB4C}", "\x{2005}"=>"\x{FEB4E}", "\x{203C}"=>"\x{FEB06}", "\x{2049}"=>"\x{FEB05}", "\x{2122}"=>"\x{FEB2A}", "\x{2139}"=>"\x{FEB47}", "\x{2194}"=>"\x{FEAF6}", "\x{2195}"=>"\x{FEAF7}", "\x{2196}"=>"\x{FEAF2}", "\x{2197}"=>"\x{FEAF0}", "\x{2198}"=>"\x{FEAF1}", "\x{2199}"=>"\x{FEAF3}", "\x{21A9}"=>"\x{FEB83}", "\x{21AA}"=>"\x{FEB88}", "\x{231A}"=>"\x{FE01D}", "\x{231B}"=>"\x{FE01C}", "\x{23E9}"=>"\x{FE02A}", "\x{23EA}"=>"\x{FEAFE}", "\x{24C2}"=>"\x{FE7E1}", "\x{25AA}"=>"\x{FEB6E}", "\x{25AB}"=>"\x{FEB6D}", "\x{25B6}"=>"\x{FEAFC}", "\x{25C0}"=>"\x{FEAFD}", "\x{25FB}"=>"\x{FEB71}", "\x{25FC}"=>"\x{FEB72}", "\x{25FD}"=>"\x{FEB6F}", "\x{25FE}"=>"\x{FEB70}", "\x{2600}"=>"\x{FE000}", "\x{2601}"=>"\x{FE001}", "\x{260E}"=>"\x{FE523}", "\x{2611}"=>"\x{FEB8B}", "\x{2614}"=>"\x{FE002}", "\x{2615}"=>"\x{FE981}", "\x{261D}"=>"\x{FEB98}", "\x{263A}"=>"\x{FE336}", "\x{2648}"=>"\x{FE02B}", "\x{2649}"=>"\x{FE02C}", "\x{264A}"=>"\x{FE02D}", "\x{264B}"=>"\x{FE02E}", "\x{264C}"=>"\x{FE02F}", "\x{264D}"=>"\x{FE030}", "\x{264E}"=>"\x{FE031}", "\x{264F}"=>"\x{FE032}", "\x{2650}"=>"\x{FE033}", "\x{2651}"=>"\x{FE034}", "\x{2652}"=>"\x{FE035}", "\x{2653}"=>"\x{FE036}", "\x{2660}"=>"\x{FEB1B}", "\x{2663}"=>"\x{FEB1D}", "\x{2665}"=>"\x{FEB1A}", "\x{2666}"=>"\x{FEB1C}", "\x{2668}"=>"\x{FE7FA}", "\x{267B}"=>"\x{FEB2C}", "\x{267F}"=>"\x{FEB20}", "\x{2693}"=>"\x{FE4C1}", "\x{26A0}"=>"\x{FEB23}", "\x{26A1}"=>"\x{FE004}", "\x{26AA}"=>"\x{FEB65}", "\x{26AB}"=>"\x{FEB66}", "\x{26BD}"=>"\x{FE7D4}", "\x{26BE}"=>"\x{FE7D1}", "\x{26C4}"=>"\x{FE003}", "\x{26C5}"=>"\x{FE00F}", "\x{26D4}"=>"\x{FEB26}", "\x{26E2}"=>"\x{FEB44}", "\x{26EA}"=>"\x{FE4BB}", "\x{26F2}"=>"\x{FE4BC}", "\x{26F3}"=>"\x{FE7D2}", "\x{26F5}"=>"\x{FE7EA}", "\x{26FA}"=>"\x{FE7FB}", "\x{26FD}"=>"\x{FE7F5}", "\x{2702}"=>"\x{FE53E}", "\x{2705}"=>"\x{FEB4A}", "\x{2708}"=>"\x{FE7E9}", "\x{2709}"=>"\x{FE529}", "\x{270A}"=>"\x{FEB93}", "\x{270C}"=>"\x{FEB94}", "\x{270F}"=>"\x{FE539}", "\x{2712}"=>"\x{FE536}", "\x{2714}"=>"\x{FEB49}", "\x{2716}"=>"\x{FEB53}", "\x{2733}"=>"\x{FEB62}", "\x{2734}"=>"\x{FEB61}", "\x{2744}"=>"\x{FE00E}", "\x{2747}"=>"\x{FEB77}", "\x{2762}"=>"\x{FEB04}", "\x{2764}"=>"\x{FEB0C}", "\x{27A1}"=>"\x{FEAFA}", "\x{2934}"=>"\x{FEAF4}", "\x{2935}"=>"\x{FEAF5}", "\x{2B05}"=>"\x{FEAFB}", "\x{2B06}"=>"\x{FEAF8}", "\x{2B07}"=>"\x{FEAF9}", "\x{2B1B}"=>"\x{FEB6C}", "\x{2B1C}"=>"\x{FEB6B}", "\x{2B50}"=>"\x{FEB68}", "\x{2E32}"=>"\x{FEB08}", "\x{3030}"=>"\x{FEB07}", "\x{303D}"=>"\x{FE81B}", "\x{3297}"=>"\x{FEB43}", "\x{3299}"=>"\x{FEB2B}", "\x{1F004}"=>"\x{FE80B}", "\x{1F170}"=>"\x{FE50B}", "\x{1F171}"=>"\x{FE50C}", "\x{1F17E}"=>"\x{FE50E}", "\x{1F17F}"=>"\x{FE7F6}", "\x{1F18E}"=>"\x{FE50D}", "\x{1F201}"=>"\x{FEB24}", "\x{1F224}"=>"\x{FEB40}", "\x{1F22A}"=>"\x{FEB3A}", "\x{1F231}"=>"\x{FEB2E}", "\x{1F250}"=>"\x{FEB3D}", "\x{1F44D}"=>"\x{FE537}", "\x{1F541}"=>"\x{FEB7C}", "\x{1F600}"=>"\x{FEE10}"
);

sub unicode_unicode_to_google_unicode {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiUnicodeUnicode)
    }{
        $map_unicode_unicode_to_google_unicode{$1} || &$check(ord $1)
    }egomx;
}

our %map_google_unicode_to_unicode_unicode = (
    "\x{FE000}"=>"\x{2600}", "\x{FE001}"=>"\x{2601}", "\x{FE002}"=>"\x{2614}", "\x{FE003}"=>"\x{26C4}", "\x{FE004}"=>"\x{26A1}", "\x{FE00E}"=>"\x{2744}", "\x{FE00F}"=>"\x{26C5}", "\x{FE01C}"=>"\x{231B}", "\x{FE01D}"=>"\x{231A}", "\x{FE02A}"=>"\x{23E9}", "\x{FE02B}"=>"\x{2648}", "\x{FE02C}"=>"\x{2649}", "\x{FE02D}"=>"\x{264A}", "\x{FE02E}"=>"\x{264B}", "\x{FE02F}"=>"\x{264C}", "\x{FE030}"=>"\x{264D}", "\x{FE031}"=>"\x{264E}", "\x{FE032}"=>"\x{264F}", "\x{FE033}"=>"\x{2650}", "\x{FE034}"=>"\x{2651}", "\x{FE035}"=>"\x{2652}", "\x{FE036}"=>"\x{2653}", "\x{FE336}"=>"\x{263A}", "\x{FE4BB}"=>"\x{26EA}", "\x{FE4BC}"=>"\x{26F2}", "\x{FE4C1}"=>"\x{2693}", "\x{FE50B}"=>"\x{1F170}", "\x{FE50C}"=>"\x{1F171}", "\x{FE50D}"=>"\x{1F18E}", "\x{FE50E}"=>"\x{1F17E}", "\x{FE523}"=>"\x{260E}", "\x{FE529}"=>"\x{2709}", "\x{FE536}"=>"\x{2712}", "\x{FE537}"=>"\x{1F44D}", "\x{FE539}"=>"\x{270F}", "\x{FE53E}"=>"\x{2702}", "\x{FE7D1}"=>"\x{26BE}", "\x{FE7D2}"=>"\x{26F3}", "\x{FE7D4}"=>"\x{26BD}", "\x{FE7E1}"=>"\x{24C2}", "\x{FE7E9}"=>"\x{2708}", "\x{FE7EA}"=>"\x{26F5}", "\x{FE7F5}"=>"\x{26FD}", "\x{FE7F6}"=>"\x{1F17F}", "\x{FE7FA}"=>"\x{2668}", "\x{FE7FB}"=>"\x{26FA}", "\x{FE80B}"=>"\x{1F004}", "\x{FE81B}"=>"\x{303D}", "\x{FE82C}"=>"#\x{20E3}", "\x{FE82E}"=>"1\x{20E3}", "\x{FE82F}"=>"2\x{20E3}", "\x{FE830}"=>"3\x{20E3}", "\x{FE831}"=>"4\x{20E3}", "\x{FE832}"=>"5\x{20E3}", "\x{FE833}"=>"6\x{20E3}", "\x{FE834}"=>"7\x{20E3}", "\x{FE835}"=>"8\x{20E3}", "\x{FE836}"=>"9\x{20E3}", "\x{FE837}"=>"0\x{20E3}", "\x{FE981}"=>"\x{2615}", "\x{FEAF0}"=>"\x{2197}", "\x{FEAF1}"=>"\x{2198}", "\x{FEAF2}"=>"\x{2196}", "\x{FEAF3}"=>"\x{2199}", "\x{FEAF4}"=>"\x{2934}", "\x{FEAF5}"=>"\x{2935}", "\x{FEAF6}"=>"\x{2194}", "\x{FEAF7}"=>"\x{2195}", "\x{FEAF8}"=>"\x{2B06}", "\x{FEAF9}"=>"\x{2B07}", "\x{FEAFA}"=>"\x{27A1}", "\x{FEAFB}"=>"\x{2B05}", "\x{FEAFC}"=>"\x{25B6}", "\x{FEAFD}"=>"\x{25C0}", "\x{FEAFE}"=>"\x{23EA}", "\x{FEB04}"=>"\x{2762}", "\x{FEB05}"=>"\x{2049}", "\x{FEB06}"=>"\x{203C}", "\x{FEB07}"=>"\x{3030}", "\x{FEB08}"=>"\x{2E32}", "\x{FEB0C}"=>"\x{2764}", "\x{FEB1A}"=>"\x{2665}", "\x{FEB1B}"=>"\x{2660}", "\x{FEB1C}"=>"\x{2666}", "\x{FEB1D}"=>"\x{2663}", "\x{FEB20}"=>"\x{267F}", "\x{FEB23}"=>"\x{26A0}", "\x{FEB24}"=>"\x{1F201}", "\x{FEB26}"=>"\x{26D4}", "\x{FEB29}"=>"\x{00A9}", "\x{FEB2A}"=>"\x{2122}", "\x{FEB2B}"=>"\x{3299}", "\x{FEB2C}"=>"\x{267B}", "\x{FEB2D}"=>"\x{00AE}", "\x{FEB2E}"=>"\x{1F231}", "\x{FEB3A}"=>"\x{1F22A}", "\x{FEB3D}"=>"\x{1F250}", "\x{FEB40}"=>"\x{1F224}", "\x{FEB43}"=>"\x{3297}", "\x{FEB44}"=>"\x{26E2}", "\x{FEB47}"=>"\x{2139}", "\x{FEB49}"=>"\x{2714}", "\x{FEB4A}"=>"\x{2705}", "\x{FEB4C}"=>"\x{2003}", "\x{FEB4D}"=>"\x{2002}", "\x{FEB4E}"=>"\x{2005}", "\x{FEB53}"=>"\x{2716}", "\x{FEB61}"=>"\x{2734}", "\x{FEB62}"=>"\x{2733}", "\x{FEB65}"=>"\x{26AA}", "\x{FEB66}"=>"\x{26AB}", "\x{FEB68}"=>"\x{2B50}", "\x{FEB6B}"=>"\x{2B1C}", "\x{FEB6C}"=>"\x{2B1B}", "\x{FEB6D}"=>"\x{25AB}", "\x{FEB6E}"=>"\x{25AA}", "\x{FEB6F}"=>"\x{25FD}", "\x{FEB70}"=>"\x{25FE}", "\x{FEB71}"=>"\x{25FB}", "\x{FEB72}"=>"\x{25FC}", "\x{FEB77}"=>"\x{2747}", "\x{FEB7C}"=>"\x{1F541}", "\x{FEB83}"=>"\x{21A9}", "\x{FEB88}"=>"\x{21AA}", "\x{FEB8B}"=>"\x{2611}", "\x{FEB93}"=>"\x{270A}", "\x{FEB94}"=>"\x{270C}", "\x{FEB98}"=>"\x{261D}", "\x{FEE10}"=>"\x{1F600}"
);

sub google_unicode_to_unicode_unicode {
    my $check = $_[2] || sub {''};
    $_[1] =~ s{
        ($ReEmojiGoogleUnicode)
    }{
        $map_google_unicode_to_unicode_unicode{$1} || &$check(ord $1)
    }egomx;
}

our %CharnamesEmojiDocomo = (
    "E63E"=>"晴れ", "E63F"=>"曇り", "E640"=>"雨", "E641"=>"雪", "E642"=>"雷", "E643"=>"台風", "E644"=>"霧", "E645"=>"小雨", "E646"=>"牡羊座", "E647"=>"牡牛座", "E648"=>"双子座", "E649"=>"蟹座", "E64A"=>"獅子座", "E64B"=>"乙女座", "E64C"=>"天秤座", "E64D"=>"蠍座", "E64E"=>"射手座", "E64F"=>"山羊座", "E650"=>"水瓶座", "E651"=>"魚座", "E652"=>"スポーツ", "E653"=>"野球", "E654"=>"ゴルフ", "E655"=>"テニス", "E656"=>"サッカー", "E657"=>"スキー", "E658"=>"バスケットボール", "E659"=>"モータースポーツ", "E65A"=>"ポケットベル", "E65B"=>"電車", "E65C"=>"地下鉄", "E65D"=>"新幹線", "E65E"=>"車（セダン）", "E65F"=>"車（ＲＶ）", "E660"=>"バス", "E661"=>"船", "E662"=>"飛行機", "E663"=>"家", "E664"=>"ビル", "E665"=>"郵便局", "E666"=>"病院", "E667"=>"銀行", "E668"=>"ＡＴＭ", "E669"=>"ホテル", "E66A"=>"コンビニ", "E66B"=>"ガソリンスタンド", "E66C"=>"駐車場", "E66D"=>"信号", "E66E"=>"トイレ", "E66F"=>"レストラン", "E670"=>"喫茶店", "E671"=>"バー", "E672"=>"ビール", "E673"=>"ファーストフード", "E674"=>"ブティック", "E675"=>"美容院", "E676"=>"カラオケ", "E677"=>"映画", "E678"=>"右斜め上", "E679"=>"遊園地", "E67A"=>"音楽", "E67B"=>"アート", "E67C"=>"演劇", "E67D"=>"イベント", "E67E"=>"チケット", "E67F"=>"喫煙", "E680"=>"禁煙", "E681"=>"カメラ", "E682"=>"カバン", "E683"=>"本", "E684"=>"リボン", "E685"=>"プレゼント", "E686"=>"バースデー", "E687"=>"電話", "E688"=>"携帯電話", "E689"=>"メモ", "E68A"=>"ＴＶ", "E68B"=>"ゲーム", "E68C"=>"ＣＤ", "E68D"=>"ハート", "E68E"=>"スペード", "E68F"=>"ダイヤ", "E690"=>"クラブ", "E691"=>"目", "E692"=>"耳", "E693"=>"手（グー）", "E694"=>"手（チョキ）", "E695"=>"手（パー）", "E696"=>"右斜め下", "E697"=>"左斜め上", "E698"=>"足", "E699"=>"くつ", "E69A"=>"眼鏡", "E69B"=>"車椅子", "E69C"=>"新月", "E69D"=>"やや欠け月", "E69E"=>"半月", "E69F"=>"三日月", "E6A0"=>"満月", "E6A1"=>"犬", "E6A2"=>"猫", "E6A3"=>"リゾート", "E6A4"=>"クリスマス", "E6A5"=>"左斜め下", "E6AC"=>"カチンコ", "E6AD"=>"ふくろ", "E6AE"=>"ペン", "E6B1"=>"人影", "E6B2"=>"いす", "E6B3"=>"夜", "E6B7"=>"soon", "E6B8"=>"on", "E6B9"=>"end", "E6BA"=>"時計", "E6CE"=>"phone to", "E6CF"=>"mail to", "E6D0"=>"fax to", "E6D1"=>"iモード", "E6D2"=>"iモード（枠付き）", "E6D3"=>"メール", "E6D4"=>"ドコモ提供", "E6D5"=>"ドコモポイント", "E6D6"=>"有料", "E6D7"=>"無料", "E6D8"=>"ID", "E6D9"=>"パスワード", "E6DA"=>"次項有", "E6DB"=>"クリア", "E6DC"=>"サーチ（調べる）", "E6DD"=>"ＮＥＷ", "E6DE"=>"位置情報", "E6DF"=>"フリーダイヤル", "E6E0"=>"シャープダイヤル", "E6E1"=>"モバＱ", "E6E2"=>"1", "E6E3"=>"2", "E6E4"=>"3", "E6E5"=>"4", "E6E6"=>"5", "E6E7"=>"6", "E6E8"=>"7", "E6E9"=>"8", "E6EA"=>"9", "E6EB"=>"", "E6EC"=>"黒ハート", "E6ED"=>"揺れるハート", "E6EE"=>"失恋", "E6EF"=>"ハートたち（複数ハート）", "E6F0"=>"わーい（嬉しい顔）", "E6F1"=>"ちっ（怒った顔）", "E6F2"=>"がく～（落胆した顔）", "E6F3"=>"もうやだ～（悲しい顔）", "E6F4"=>"ふらふら", "E6F5"=>"グッド（上向き矢印）", "E6F6"=>"るんるん", "E6F7"=>"いい気分（温泉）", "E6F8"=>"かわいい", "E6F9"=>"キスマーク", "E6FA"=>"ぴかぴか（新しい）", "E6FB"=>"ひらめき", "E6FC"=>"むかっ（怒り）", "E6FD"=>"パンチ", "E6FE"=>"爆弾", "E6FF"=>"ムード", "E700"=>"バッド（下向き矢印）", "E701"=>"眠い(睡眠)", "E702"=>"exclamation", "E703"=>"exclamation\&question", "E704"=>"exclamation×2", "E705"=>"どんっ（衝撃）", "E706"=>"あせあせ（飛び散る汗）", "E707"=>"たらーっ（汗）", "E708"=>"ダッシュ（走り出すさま）", "E709"=>"ー（長音記号１）", "E70A"=>"ー（長音記号２）", "E70B"=>"決定", "E70C"=>"iアプリ", "E70D"=>"iアプリ（枠付き）", "E70E"=>"Tシャツ（ボーダー）", "E70F"=>"がま口財布", "E710"=>"化粧", "E711"=>"ジーンズ", "E712"=>"スノボ", "E713"=>"チャペル", "E714"=>"ドア", "E715"=>"ドル袋", "E716"=>"パソコン", "E717"=>"ラブレター", "E718"=>"レンチ", "E719"=>"鉛筆", "E71A"=>"王冠", "E71B"=>"指輪", "E71C"=>"砂時計", "E71D"=>"自転車", "E71E"=>"湯のみ", "E71F"=>"腕時計", "E720"=>"考えてる顔", "E721"=>"ほっとした顔", "E722"=>"冷や汗", "E723"=>"冷や汗2", "E724"=>"ぷっくっくな顔", "E725"=>"ボケーっとした顔", "E726"=>"目がハート", "E727"=>"指でOK", "E728"=>"あっかんべー", "E729"=>"ウィンク", "E72A"=>"うれしい顔", "E72B"=>"がまん顔", "E72C"=>"猫2", "E72D"=>"泣き顔", "E72E"=>"涙", "E72F"=>"NG", "E730"=>"クリップ", "E731"=>"コピーライト", "E732"=>"トレードマーク", "E733"=>"走る人", "E734"=>"マル秘", "E735"=>"リサイクル", "E736"=>"レジスタードトレードマーク", "E737"=>"危険・警告", "E738"=>"禁止", "E739"=>"空室・空席・空車", "E73A"=>"合格マーク", "E73B"=>"満室・満席・満車", "E73C"=>"矢印左右", "E73D"=>"矢印上下", "E73E"=>"学校", "E73F"=>"波", "E740"=>"富士山", "E741"=>"クローバー", "E742"=>"さくらんぼ", "E743"=>"チューリップ", "E744"=>"バナナ", "E745"=>"りんご", "E746"=>"芽", "E747"=>"もみじ", "E748"=>"桜", "E749"=>"おにぎり", "E74A"=>"ショートケーキ", "E74B"=>"とっくり（おちょこ付き）", "E74C"=>"どんぶり", "E74D"=>"パン", "E74E"=>"かたつむり", "E74F"=>"ひよこ", "E750"=>"ペンギン", "E751"=>"魚", "E752"=>"うまい！", "E753"=>"ウッシッシ", "E754"=>"ウマ", "E755"=>"ブタ", "E756"=>"ワイングラス", "E757"=>"げっそり"
);

our %CharnamesEmojiKddi = (
    "E468"=>"星３", "E469"=>"台風", "E46A"=>"信号", "E46B"=>"マラソン", "E46C"=>"スパーク", "E46D"=>"遊園地", "E46E"=>"スロット（７７７）", "E46F"=>"くす玉（アタリのくす玉）", "E470"=>"くじら", "E471"=>"顔１（うれしいカオ）", "E472"=>"顔２（おこったカオ）", "E473"=>"顔３（かなしいカオ）", "E474"=>"顔４（つかれたカオ）", "E475"=>"眠い（ＺＺＺ…）", "E476"=>"電球", "E477"=>"ハート２（われている）", "E478"=>"ハート３（大きい＆小さい）", "E479"=>"スパーク２（キラリマーク）", "E47A"=>"爆弾", "E47B"=>"炎", "E47C"=>"砂時計２", "E47D"=>"喫煙", "E47E"=>"禁煙", "E47F"=>"車椅子", "E480"=>"若葉マーク", "E481"=>"！", "E482"=>"！", "E483"=>"？", "E484"=>"立ち入り禁止", "E485"=>"ゆきだるま", "E486"=>"月１", "E487"=>"いなずま", "E488"=>"太陽", "E489"=>"月２（顔つき）", "E48A"=>"雪の結晶", "E48B"=>"星２", "E48C"=>"雨", "E48D"=>"くもり", "E48E"=>"ときどき曇り", "E48F"=>"星座（おひつじ座）", "E490"=>"星座（おうし座）", "E491"=>"星座（双子座）", "E492"=>"星座（かに座）", "E493"=>"星座（しし座）", "E494"=>"星座（おとめ座）", "E495"=>"星座（天秤座）", "E496"=>"星座（さそり座）", "E497"=>"星座（いて座）", "E498"=>"星座（やぎ座）", "E499"=>"星座（水瓶座）", "E49A"=>"星座（うお座）", "E49B"=>"星座（へびつかい座）", "E49C"=>"ブリーフケース(ハンドバック）", "E49D"=>"ノート３", "E49E"=>"チケット・キップ", "E49F"=>"ノート２（開）", "E4A0"=>"クリップ", "E4A1"=>"エンピツ", "E4A2"=>"定規２", "E4A3"=>"ＡＴＭ", "E4A4"=>"２４HOURS（コンビニ)", "E4A5"=>"トイレ", "E4A6"=>"パーキング", "E4A7"=>"バス停", "E4A8"=>"ｱﾝﾃﾅ（位置情報ﾏｰｸ）", "E4A9"=>"港（いかりマーク）", "E4AA"=>"銀行", "E4AB"=>"家", "E4AC"=>"ゴハン１", "E4AD"=>"工場・建物", "E4AE"=>"自転車", "E4AF"=>"バス", "E4B0"=>"新幹線", "E4B1"=>"車", "E4B2"=>"トラック", "E4B3"=>"飛行機", "E4B4"=>"ボート(船）", "E4B5"=>"電車", "E4B6"=>"サッカー", "E4B7"=>"テニス", "E4B8"=>"スノーボード", "E4B9"=>"チェッカーフラグ（モータースポーツ）", "E4BA"=>"野球ボール", "E4BB"=>"フットボール", "E4BC"=>"温泉", "E4BD"=>"居酒屋（赤ちょうちん）", "E4BE"=>"映画（かちんこ）", "E4BF"=>"夜の橋", "E4C0"=>"東京タワー", "E4C1"=>"ワイングラス", "E4C2"=>"マティーニ（カクテルグラス）", "E4C3"=>"マグカップ", "E4C4"=>"食事２", "E4C5"=>"当選弓矢", "E4C6"=>"ゲームのコントローラ", "E4C7"=>"賞金", "E4C8"=>"サイコロ", "E4C9"=>"クリスマスツリー", "E4CA"=>"花見(さくら）", "E4CB"=>"お化け", "E4CC"=>"旗（祝日・日の丸）", "E4CD"=>"スイカ", "E4CE"=>"はっぱ", "E4CF"=>"プレゼント", "E4D0"=>"ケーキ", "E4D1"=>"フライパン（目玉焼き）", "E4D2"=>"さくらんぼ", "E4D3"=>"ふぐ", "E4D4"=>"イチゴ", "E4D5"=>"おにぎり", "E4D6"=>"ハンバーガー（ファーストフード）", "E4D7"=>"うさぎ", "E4D8"=>"うま", "E4D9"=>"さる", "E4DA"=>"かえる", "E4DB"=>"猫", "E4DC"=>"ペンギン", "E4DD"=>"あり", "E4DE"=>"ぶた", "E4DF"=>"犬（プードル）", "E4E0"=>"鳥", "E4E1"=>"猟犬", "E4E2"=>"やしのき", "E4E3"=>"ひまわり", "E4E4"=>"花", "E4E5"=>"怒り（ムカッ）", "E4E6"=>"雫（涙・汗）", "E4E7"=>"からかう（あっかんべえ）", "E4E8"=>"捜索（SOS）", "E4E9"=>"力こぶ", "E4EA"=>"ハート５（矢がささっている）", "E4EB"=>"キスマーク", "E4EC"=>"宇宙人", "E4ED"=>"なると", "E4EE"=>"足跡（犬）", "E4EF"=>"悪魔", "E4F0"=>"花丸", "E4F1"=>"丸秘", "E4F2"=>"100点満点", "E4F3"=>"パンチ", "E4F4"=>"ダッシュ", "E4F5"=>"ウンチマーク", "E4F6"=>"人差し指サイン", "E4F7"=>"マル得", "E4F8"=>"どくろ", "E4F9"=>"おやゆびサイン", "E4FA"=>"小顔", "E4FB"=>"スマイルフェイス", "E4FC"=>"顔１", "E4FD"=>"吹き出しコメント", "E4FE"=>"めがね", "E4FF"=>"指差し確認左", "E500"=>"指差し確認右", "E501"=>"家族", "E502"=>"テレビ", "E503"=>"マイク", "E504"=>"財布", "E505"=>"メロディ", "E506"=>"ギター（エレキ）", "E507"=>"バイオリン（クラッシック）", "E508"=>"ヘッドフォン", "E509"=>"口紅", "E50A"=>"アクション（ピストル）", "E50B"=>"エステ", "E50C"=>"CD/DVD", "E50D"=>"婦人服", "E50E"=>"UFO", "E50F"=>"更新（ＵＰ！）", "E510"=>"注射器（血）", "E511"=>"スピーカ", "E512"=>"ベル", "E513"=>"四つ葉", "E514"=>"ジュエリー", "E515"=>"カメラ", "E516"=>"はさみ", "E517"=>"ビデオカメラ", "E518"=>"むしめがね", "E519"=>"鍵", "E51A"=>"くつ", "E51B"=>"メールボックス", "E51C"=>"錠前", "E51D"=>"名札", "E51E"=>"電話２", "E51F"=>"パッケージ", "E520"=>"ＦＡＸ", "E521"=>"封筒", "E522"=>"四角数字１", "E523"=>"四角数字2", "E524"=>"四角数字3", "E525"=>"四角数字4", "E526"=>"四角数字5", "E527"=>"四角数字6", "E528"=>"四角数字7", "E529"=>"四角数字8", "E52A"=>"四角数字9", "E52B"=>"四角数字10", "E52C"=>"？", "E52D"=>"左向き三角１", "E52E"=>"右向き三角１", "E52F"=>"左向き三角２", "E530"=>"右向き三角２", "E531"=>"小四角１", "E532"=>"小四角２", "E533"=>"インフォメーションシンボル", "E534"=>"中四角１", "E535"=>"中四角２", "E536"=>"小菱形１", "E537"=>"小菱形２", "E538"=>"大四角１", "E539"=>"大四角１", "E53A"=>"小丸１", "E53B"=>"小丸2", "E53C"=>"プラス", "E53D"=>"マイナス", "E53E"=>"星１", "E53F"=>"上矢印１", "E540"=>"下矢印１", "E541"=>"丸に斜め線", "E542"=>"下三角１", "E543"=>"上三角１", "E544"=>"下三角２", "E545"=>"上三角２", "E546"=>"大菱形１", "E547"=>"大菱形２", "E548"=>"特大四角１", "E549"=>"特大四角２", "E54A"=>"大丸１", "E54B"=>"大丸２", "E54C"=>"上矢印２", "E54D"=>"下矢印２", "E54E"=>"トレードマーク（TM）", "E54F"=>"かける", "E550"=>"バツ１", "E551"=>"バツ２", "E552"=>"右矢印１", "E553"=>"左矢印１", "E554"=>"割る", "E555"=>"右矢印２", "E556"=>"左矢印２", "E557"=>"チェックマーク１", "E558"=>"コピーライトマーク", "E559"=>"レジスタードマーク", "E55A"=>"上三角３", "E55B"=>"下三角３", "E55C"=>"回り矢印１", "E55D"=>"回り矢印２", "E55E"=>"チェックマーク２", "E55F"=>"スクロール", "E560"=>"プッシュピン（画鋲）", "E561"=>"文書１", "E562"=>"フロッピーディスク１", "E563"=>"カレンダー", "E564"=>"クリップボード", "E565"=>"本１", "E566"=>"本２", "E567"=>"本３", "E568"=>"本４", "E569"=>"文書２", "E56A"=>"ひめくりカレンダー", "E56B"=>"ノート１", "E56C"=>"Roldex", "E56D"=>"がびょう", "E56E"=>"台帳", "E56F"=>"複数本", "E570"=>"定規１", "E571"=>"ガススタンド", "E572"=>"地図", "E573"=>"ＵＳＡ", "E574"=>"チャート（棒グラフ）", "E575"=>"グラフ１（折れ線グラフ）", "E576"=>"グラフ２", "E577"=>"EZマーク", "E578"=>"無料（ＦＲＥＥ）", "E579"=>"ドル", "E57A"=>"腕時計", "E57B"=>"砂時計１", "E57C"=>"クレジットカード", "E57D"=>"小切手（CHECK）", "E57E"=>"ハンディカム", "E57F"=>"ナイフ", "E580"=>"ビデオテープ", "E581"=>"ボルト＆ナット", "E582"=>"フロッピー２", "E583"=>"懐中電灯", "E584"=>"電池", "E585"=>"ドル札", "E586"=>"ロゴ（ＰＤＣ社）", "E587"=>"レンチ", "E588"=>"電話３", "E589"=>"コンセント", "E58A"=>"リンク", "E58B"=>"新聞", "E58C"=>"全部ブランク", "E58D"=>"半分ブランク", "E58E"=>"4分の１ブランク", "E58F"=>"フォルダ１（閉）", "E590"=>"フォルダ２（開）", "E591"=>"封筒２", "E592"=>"送信ＢＯＸ", "E593"=>"受信ＢＯＸ", "E594"=>"時計", "E595"=>"ハート", "E596"=>"電話１（プッシュホン）", "E597"=>"カップ", "E598"=>"霧", "E599"=>"ゴルフ", "E59A"=>"バスケットボール", "E59B"=>"ポケットベル", "E59C"=>"アート", "E59D"=>"演劇", "E59E"=>"イベント", "E59F"=>"リボン", "E5A0"=>"バースデー", "E5A1"=>"スペード", "E5A2"=>"ダイヤ", "E5A3"=>"クラブ", "E5A4"=>"目", "E5A5"=>"耳", "E5A6"=>"手（チョキ）", "E5A7"=>"手（パー）", "E5A8"=>"新月", "E5A9"=>"やや欠け月", "E5AA"=>"半月", "E5AB"=>"クリア", "E5AC"=>"四角数字0", "E5AD"=>"決定", "E5AE"=>"ふらふら", "E5AF"=>"かわいい", "E5B0"=>"どんっ（衝撃）", "E5B1"=>"あせあせ（飛び散る汗）", "E5B2"=>"イージープラス", "E5B3"=>"地球", "E5B4"=>"ラーメン", "E5B5"=>"NEW", "E5B6"=>"紳士服", "E5B7"=>"紳士靴", "E5B8"=>"パソコン", "E5B9"=>"ラジオ", "E5BA"=>"バラ", "E5BB"=>"チャペル", "E5BC"=>"地下鉄", "E5BD"=>"富士山", "E5BE"=>"八分音符", "E5BF"=>"天使", "E5C0"=>"トラ", "E5C1"=>"くま", "E5C2"=>"ねずみ", "E5C3"=>"ウインク", "E5C4"=>"目がハート", "E5C5"=>"ショッキング", "E5C6"=>"困り", "E5C7"=>"たこ", "E5C8"=>"ロケット", "E5C9"=>"王冠", "E5CA"=>"チュー", "E5CB"=>"ハンマー", "E5CC"=>"打ち上げ花火", "E5CD"=>"枯れ葉", "E5CE"=>"仕事かばん", "E5CF"=>"噴水", "E5D0"=>"キャンプ", "E5D1"=>"麻雀", "E5D2"=>"ＶＳ（バーサス）", "E5D3"=>"トロフィー", "E5D4"=>"カメ", "E5D5"=>"スペイン国旗", "E5D6"=>"ロシア国旗", "E5D7"=>"工事中", "E5D8"=>"風呂", "E5D9"=>"祝日マーク", "E5DA"=>"夕方街並み", "E5DB"=>"卵割り", "E5DC"=>"株価", "E5DD"=>"ポリス", "E5DE"=>"郵便局", "E5DF"=>"病院", "EA80"=>"学校", "EA81"=>"ホテル", "EA82"=>"船", "EA83"=>"18禁", "EA84"=>"圏内", "EA85"=>"COOL!", "EA86"=>"割マーク", "EA87"=>"ザ・マーク", "EA88"=>"ＩＤマーク", "EA89"=>"満マーク", "EA8A"=>"空マーク", "EA8B"=>"指定マーク", "EA8C"=>"営業中マーク", "EA8D"=>"上指差し", "EA8E"=>"下指差し", "EA8F"=>"占い", "EA90"=>"マナーモード", "EA91"=>"電源OFF", "EA92"=>"メモする", "EA93"=>"ネクタイ", "EA94"=>"ハイビスカス", "EA95"=>"花束", "EA96"=>"サボテン", "EA97"=>"お銚子＆杯", "EA98"=>"乾杯", "EA99"=>"祝マーク", "EA9A"=>"風邪薬", "EA9B"=>"風船", "EA9C"=>"クラッカー", "EA9D"=>"eznavigation", "EA9E"=>"帽子", "EA9F"=>"ロングブーツ", "EAA0"=>"ネイル", "EAA1"=>"美容院", "EAA2"=>"床屋", "EAA3"=>"着物", "EAA4"=>"ビキニ", "EAA5"=>"ハート（トランプ）", "EAA6"=>"光るハート", "EAA7"=>"青ハート", "EAA8"=>"緑ハート", "EAA9"=>"黄ハート", "EAAA"=>"紫ハート", "EAAB"=>"きらきら", "EAAC"=>"スキー", "EAAD"=>"○", "EAAE"=>"日本茶", "EAAF"=>"食パン", "EAB0"=>"ソフトクリーム", "EAB1"=>"ポテト", "EAB2"=>"だんご", "EAB3"=>"おせんべい", "EAB4"=>"ごはん", "EAB5"=>"スパゲッティ", "EAB6"=>"カレー", "EAB7"=>"おでん", "EAB8"=>"寿司", "EAB9"=>"りんご", "EABA"=>"みかん", "EABB"=>"トマト", "EABC"=>"なす", "EABD"=>"弁当", "EABE"=>"鍋", "EABF"=>"ふっ", "EAC0"=>"しょぼり", "EAC1"=>"勝ち誇り", "EAC2"=>"失敗", "EAC3"=>"わからん", "EAC4"=>"眠い", "EAC5"=>"てれてれ", "EAC6"=>"青ざめ", "EAC7"=>"風邪ひき", "EAC8"=>"熱", "EAC9"=>"横目", "EACA"=>"びっくり", "EACB"=>"あせり", "EACC"=>"楽譜", "EACD"=>"にこにこ", "EACE"=>"チュー２", "EACF"=>"チュッ", "EAD0"=>"鼻", "EAD1"=>"口", "EAD2"=>"ゴメン／お願い", "EAD3"=>"拍手", "EAD4"=>"ＯＫ！", "EAD5"=>"ブーイング", "EAD6"=>"バイバイ", "EAD7"=>"ＮＧ", "EAD8"=>"ＯＫ！２", "EAD9"=>"平謝り", "EADA"=>"カップル", "EADB"=>"バニー", "EADC"=>"トランペット", "EADD"=>"ビリヤード", "EADE"=>"水泳", "EADF"=>"消防車", "EAE0"=>"救急車", "EAE1"=>"パトカー", "EAE2"=>"ジェットコースター", "EAE3"=>"門松", "EAE4"=>"雛祭り", "EAE5"=>"卒業式", "EAE6"=>"入学式", "EAE7"=>"こいのぼり", "EAE8"=>"傘", "EAE9"=>"花嫁", "EAEA"=>"かき氷", "EAEB"=>"線香花火", "EAEC"=>"巻き貝", "EAED"=>"風鈴", "EAEE"=>"ハロウィン", "EAEF"=>"お月見", "EAF0"=>"サンタ", "EAF1"=>"夜／流れ星", "EAF2"=>"虹", "EAF3"=>"ホテル２", "EAF4"=>"日の出", "EAF5"=>"シルクハット", "EAF6"=>"デパート", "EAF7"=>"城（日本）", "EAF8"=>"城（ヨーロッパ）", "EAF9"=>"工場２", "EAFA"=>"フランス国旗", "EAFB"=>"オープンウェーブ", "EAFC"=>"ロック確認", "EAFD"=>"大文字", "EAFE"=>"小文字", "EAFF"=>"数字", "EB00"=>"記号", "EB01"=>"アクセプト", "EB02"=>"チェックボックス", "EB03"=>"エディット", "EB04"=>"ラジオボタン", "EB05"=>"見る", "EB06"=>"戻る", "EB07"=>"お気に入り", "EB08"=>"終了", "EB09"=>"ホーム", "EB0A"=>"受信箱１", "EB0B"=>"マーク", "EB0C"=>"個人", "EB0D"=>"再読み込み", "EB0E"=>"ドイツ国旗", "EB0F"=>"イタリア国旗", "EB10"=>"イギリス国旗", "EB11"=>"中国国旗", "EB12"=>"韓国国旗", "EB13"=>"白人", "EB14"=>"中国人", "EB15"=>"インド人", "EB16"=>"おじいさん", "EB17"=>"おばあさん", "EB18"=>"赤ちゃん", "EB19"=>"工事現場の人", "EB1A"=>"お姫様", "EB1B"=>"イルカ", "EB1C"=>"ダンス", "EB1D"=>"熱帯魚", "EB1E"=>"げじげじ", "EB1F"=>"象", "EB20"=>"コアラ", "EB21"=>"ホルスタイン", "EB22"=>"ヘビ", "EB23"=>"鶏", "EB24"=>"うりぼう", "EB25"=>"ふたこぶらくだ", "EB26"=>"Ａ型", "EB27"=>"Ｂ型", "EB28"=>"Ｏ型", "EB29"=>"ＡＢ型", "EB2A"=>"足跡", "EB2B"=>"スニーカー", "EB2C"=>"旗", "EB2D"=>"上向きカーブ矢印", "EB2E"=>"下向きカーブ矢印", "EB2F"=>"「！？」", "EB30"=>"「！！」", "EB31"=>"くるり", "EB32"=>"メロン", "EB33"=>"パイナップル", "EB34"=>"ぶどう", "EB35"=>"バナナ", "EB36"=>"とうもろこし", "EB37"=>"きのこ", "EB38"=>"栗", "EB39"=>"桃", "EB3A"=>"やきいも", "EB3B"=>"ピザ", "EB3C"=>"ターキー", "EB3D"=>"七夕笹飾り", "EB3E"=>"トロピカルドリンク", "EB3F"=>"辰", "EB40"=>"ピアノ", "EB41"=>"サーフィン", "EB42"=>"釣り", "EB43"=>"ボーリング", "EB44"=>"なまはげ", "EB45"=>"天狗", "EB46"=>"パンダ", "EB47"=>"あかんべー", "EB48"=>"ぶたの鼻", "EB49"=>"花", "EB4A"=>"アイスクリーム", "EB4B"=>"ドーナツ", "EB4C"=>"クッキー", "EB4D"=>"チョコ", "EB4E"=>"キャンディ（つつみ）", "EB4F"=>"キャンディ（ぺろぺろ）", "EB50"=>"見ざる", "EB51"=>"言わざる", "EB52"=>"聞かざる", "EB53"=>"火山", "EB54"=>"リボンがけのハート", "EB55"=>"英語「ＡＢＣ」", "EB56"=>"プリン", "EB57"=>"ミツバチ", "EB58"=>"テントウムシ", "EB59"=>"蜂蜜ポット", "EB5A"=>"青りんご", "EB5B"=>"羽のはえたお札", "EB5C"=>"目がまわる時の記号", "EB5D"=>"ぷー（かわいく怒）", "EB5E"=>"ぶー（かわいく怒）（ネコ）", "EB5F"=>"天の川", "EB60"=>"チュー（ネコ）", "EB61"=>"にこ（ネコ）", "EB62"=>"メールする", "EB63"=>"泣き笑い（ネコ）", "EB64"=>"泣き笑い", "EB65"=>"目がハート（ネコ）", "EB66"=>"ほえー（ネコ）", "EB67"=>"ほえー", "EB68"=>"涙ぽろり（ネコ）", "EB69"=>"涙ぽろり", "EB6A"=>"きりり（ネコ）", "EB6B"=>"ドレス", "EB6C"=>"モヤイ像", "EB6D"=>"駅", "EB6E"=>"花札", "EB6F"=>"ジョーカー", "EB70"=>"エビフライ", "EB71"=>"ｅメールアイコン", "EB72"=>"歩く人", "EB73"=>"パトカーのランプ", "EB74"=>"ezmovie", "EB75"=>"ドキドキしているハート", "EB76"=>"正面向きのひよこ", "EB77"=>"ジーンズ", "EB78"=>"ハートつきメール", "EB79"=>"循環矢印", "EB7A"=>"左右両方向矢印", "EB7B"=>"上下両方向矢印", "EB7C"=>"荒波", "EB7D"=>"双葉", "EB7E"=>"かたつむり", "EB7F"=>"うっしっし（ネコ）", "EB80"=>"うっしっし", "EB81"=>"Cメールアイコン", "EB82"=>"ハーブ", "EB83"=>"グー", "EB84"=>"＃", "EB85"=>"キャラクター（挙手）", "EB86"=>"キャラクター（万歳）", "EB87"=>"キャラクター（しょんぼり）", "EB88"=>"キャラクター（かわいく怒る）"
);

our %CharnamesEmojiSoftbank = (
    "E001"=>"男の子", "E002"=>"女の子", "E003"=>"くちびる", "E004"=>"成人男性", "E005"=>"成人女性", "E006"=>"服", "E007"=>"靴", "E008"=>"カメラ", "E009"=>"固定電話", "E00A"=>"携帯電話", "E00B"=>"FAX", "E00C"=>"パソコン", "E00D"=>"手（パンチ）", "E00E"=>"手（Good）", "E00F"=>"手（指差し）", "E010"=>"手（グー）", "E011"=>"手（チョキ）", "E012"=>"手（パー）", "E013"=>"スキー", "E014"=>"ゴルフ", "E015"=>"テニス", "E016"=>"野球", "E017"=>"サーフィン", "E018"=>"サッカー", "E019"=>"魚", "E01A"=>"馬（首）", "E01B"=>"車", "E01C"=>"ヨット", "E01D"=>"飛行機", "E01E"=>"電車", "E01F"=>"新幹線", "E020"=>"はてなマーク", "E021"=>"びっくりマーク", "E022"=>"ハートマーク", "E023"=>"ハートブレイク", "E024"=>"時計（1時）", "E025"=>"時計（２時）", "E026"=>"時計（３時）", "E027"=>"時計（４時）", "E028"=>"時計（５時）", "E029"=>"時計（６時）", "E02A"=>"時計（７時）", "E02B"=>"時計（８時）", "E02C"=>"時計（９時）", "E02D"=>"目覚まし時計（１０時）", "E02E"=>"時計（１１時）", "E02F"=>"時計（１２時）", "E030"=>"さくら", "E031"=>"エンブレム", "E032"=>"バラ", "E033"=>"クリスマスツリー", "E034"=>"指輪", "E035"=>"ダイヤモンド", "E036"=>"家", "E037"=>"教会", "E038"=>"ビル", "E039"=>"駅", "E03A"=>"ガソリンスタンド", "E03B"=>"富士山", "E03C"=>"カラオケ（マイク）", "E03D"=>"映画（カメラ）", "E03E"=>"音符", "E03F"=>"鍵", "E040"=>"サックス", "E041"=>"ギター", "E042"=>"トランペット", "E043"=>"食事（ナイフ＆フォーク）", "E044"=>"バー（カクテル）", "E045"=>"喫茶（コーヒー）", "E046"=>"ケーキ", "E047"=>"ビール", "E048"=>"雪（雪だるま）", "E049"=>"くもり", "E04A"=>"晴れ", "E04B"=>"雨", "E04C"=>"月", "E04D"=>"日の出", "E04E"=>"天使", "E04F"=>"猫", "E050"=>"トラ", "E051"=>"熊", "E052"=>"いぬ", "E053"=>"ねずみ", "E054"=>"くじら", "E055"=>"ペンギン", "E056"=>"表情（にこにこ）", "E057"=>"表情（笑顔）", "E058"=>"表情（がっかり）", "E059"=>"表情（ぶんぶん）", "E05A"=>"うんち", "E101"=>"メール受信（郵便受け）", "E102"=>"メール送信（ポスト）", "E103"=>"Mail to", "E104"=>"Phone to", "E105"=>"表情（あっかんべー）", "E106"=>"表情（ラブラブ）", "E107"=>"表情（ひえ～）", "E108"=>"表情（冷や汗）", "E109"=>"さる", "E10A"=>"たこ", "E10B"=>"ぶた", "E10C"=>"宇宙人", "E10D"=>"ロケット", "E10E"=>"王冠", "E10F"=>"電球", "E110"=>"四つ葉", "E111"=>"キス", "E112"=>"プレゼント", "E113"=>"ピストル", "E114"=>"虫眼鏡", "E115"=>"走る人", "E116"=>"ハンマー", "E117"=>"打ち上げ花火", "E118"=>"紅葉", "E119"=>"落ち葉", "E11A"=>"悪魔", "E11B"=>"お化け", "E11C"=>"どくろ", "E11D"=>"炎", "E11E"=>"かばん", "E11F"=>"座席", "E120"=>"ハンバーガー", "E121"=>"公園（噴水）", "E122"=>"キャンプ", "E123"=>"温泉", "E124"=>"観覧車", "E125"=>"チケット", "E126"=>"CD", "E127"=>"DVD", "E128"=>"ラジオ", "E129"=>"ビデオ", "E12A"=>"テレビ", "E12B"=>"ゲーム", "E12C"=>"歌記号（いおり点）", "E12D"=>"麻雀", "E12E"=>"VS（Versus)", "E12F"=>"賞金", "E130"=>"当たり", "E131"=>"優勝カップ", "E132"=>"チェッカーフラグ", "E133"=>"スロット（スリーセブン）", "E134"=>"馬（全体）", "E135"=>"ボート（競艇）", "E136"=>"自転車", "E137"=>"工事中", "E138"=>"男性マーク", "E139"=>"女性マーク", "E13A"=>"赤ちゃんマーク", "E13B"=>"注射", "E13C"=>"ZZZ（眠り）", "E13D"=>"いなずま", "E13E"=>"パンプス", "E13F"=>"お風呂", "E140"=>"洋式トイレ", "E141"=>"スピーカー", "E142"=>"お知らせ（メガホン）", "E143"=>"祝日", "E144"=>"鍵（ロック）", "E145"=>"鍵（解除）", "E146"=>"夕方の街", "E147"=>"料理（たまご）", "E148"=>"本", "E149"=>"為替", "E14A"=>"株", "E14B"=>"アンテナ", "E14C"=>"力こぶ", "E14D"=>"銀行", "E14E"=>"信号", "E14F"=>"駐車場", "E150"=>"バス停", "E151"=>"公衆トイレ", "E152"=>"警官", "E153"=>"郵便局", "E154"=>"ATM", "E155"=>"病院", "E156"=>"コンビニエンスストア", "E157"=>"学校", "E158"=>"ホテル", "E159"=>"バス", "E15A"=>"タクシー", "E201"=>"歩く人", "E202"=>"船", "E203"=>"ココ", "E204"=>"飾り1", "E205"=>"飾り２", "E206"=>"飾り３", "E207"=>"１８禁", "E208"=>"禁煙", "E209"=>"初心者マーク", "E20A"=>"車椅子マーク", "E20B"=>"電波状況", "E20C"=>"ハート", "E20D"=>"ダイヤ", "E20E"=>"スペード", "E20F"=>"クローバー", "E210"=>"＃", "E211"=>"フリーダイヤル", "E212"=>"NEW", "E213"=>"UP", "E214"=>"COOL", "E215"=>"有（有料）", "E216"=>"無（無料）", "E217"=>"月（月額）", "E218"=>"申（申込み）", "E219"=>"ボタン１", "E21A"=>"ボタン２", "E21B"=>"ボタン３", "E21C"=>"1", "E21D"=>"2", "E21E"=>"3", "E21F"=>"4", "E220"=>"5", "E221"=>"6", "E222"=>"7", "E223"=>"8", "E224"=>"9", "E225"=>"0", "E226"=>"得（お得）", "E227"=>"割（割引）", "E228"=>"サ（サービス料）", "E229"=>"ID", "E22A"=>"満（満室）", "E22B"=>"空（空室）", "E22C"=>"指（指定）", "E22D"=>"営（営業時間）", "E22E"=>"指差し（上）", "E22F"=>"指差し(下）", "E230"=>"指差し（左）", "E231"=>"指差し（右）", "E232"=>"矢印（上）", "E233"=>"矢印（下）", "E234"=>"矢印（右）", "E235"=>"矢印（左）", "E236"=>"矢印（右斜め上）", "E237"=>"矢印（左斜め上）", "E238"=>"矢印（右斜め下）", "E239"=>"矢印（左斜め下）", "E23A"=>"次へ", "E23B"=>"戻る", "E23C"=>"早送り", "E23D"=>"巻き戻し", "E23E"=>"占い", "E23F"=>"おひつじ座", "E240"=>"おうし座", "E241"=>"ふたご座", "E242"=>"かに座", "E243"=>"しし座", "E244"=>"おとめ座", "E245"=>"てんびん座", "E246"=>"さそり座", "E247"=>"いて座", "E248"=>"やぎ座", "E249"=>"みずがめ座", "E24A"=>"うお座", "E24B"=>"へびつかい座", "E24C"=>"TOP", "E24D"=>"OK", "E24E"=>"コピーライトマーク", "E24F"=>"レジスタードマーク", "E250"=>"マナーモード", "E251"=>"電源OFF", "E252"=>"注意マーク", "E253"=>"案内（カスタマーサービス）", "E254"=>"J-PHONショップ", "E255"=>"スカイウェイブ", "E256"=>"スカイウォーカー", "E257"=>"スカイメロディ", "E258"=>"J-PHONE", "E259"=>"J-PHONE2", "E25A"=>"J-PHONE3", "E301"=>"メモ", "E302"=>"ビジネス（ネクタイ）", "E303"=>"ハイビスカス", "E304"=>"チューリップ", "E305"=>"ひまわり", "E306"=>"花束", "E307"=>"やしの木", "E308"=>"サボテン", "E309"=>"トイレマーク", "E30A"=>"ヘッドホン", "E30B"=>"お酒（とっくり・おちょこ）", "E30C"=>"乾杯", "E30D"=>"祝（お祝い）", "E30E"=>"喫煙", "E30F"=>"くすり", "E310"=>"風船", "E311"=>"爆弾", "E312"=>"クラッカー", "E313"=>"はさみ", "E314"=>"リボン", "E315"=>"マル秘", "E316"=>"MD", "E317"=>"応援（メガホン）", "E318"=>"むぎわら帽子", "E319"=>"ワンピース", "E31A"=>"サンダル", "E31B"=>"ブーツ", "E31C"=>"口紅", "E31D"=>"マニキュア", "E31E"=>"エステ", "E31F"=>"美容院", "E320"=>"床屋", "E321"=>"着物", "E322"=>"ビキニ", "E323"=>"ハンドバック", "E324"=>"映画（ガチンコ）", "E325"=>"ベル", "E326"=>"音符（楽しい）", "E327"=>"ハート（ぴかぴかひかる）", "E328"=>"ハート（ドキドキ）", "E329"=>"ハート（矢がささる）", "E32A"=>"ハート（青）", "E32B"=>"ハート（緑）", "E32C"=>"ハート（黄）", "E32D"=>"ハート（紫）", "E32E"=>"ぴかぴか", "E32F"=>"星", "E330"=>"ダッシュ", "E331"=>"汗", "E332"=>"○", "E333"=>"×", "E334"=>"怒り", "E335"=>"輝く星", "E336"=>"はてなマーク（アニメ）", "E337"=>"びっくりマーク（アニメ）", "E338"=>"お茶", "E339"=>"パン", "E33A"=>"ソフトクリーム", "E33B"=>"フライドポテト", "E33C"=>"おだんご", "E33D"=>"おせんべい", "E33E"=>"ごはん", "E33F"=>"スパゲッティー", "E340"=>"ラーメン", "E341"=>"カレー", "E342"=>"おにぎり", "E343"=>"おでん", "E344"=>"お寿司", "E345"=>"リンゴ", "E346"=>"みかん", "E347"=>"いちご", "E348"=>"スイカ", "E349"=>"トマト", "E34A"=>"なす", "E34B"=>"バースデーケーキ", "E34C"=>"お弁当", "E34D"=>"なべ", "E401"=>"表情（やれやれ）", "E402"=>"表示（冷笑）", "E403"=>"表情（考え中）", "E404"=>"表情（うっしし）", "E405"=>"表情（ウィンク）", "E406"=>"表情（あちゃー）", "E407"=>"表情（困惑）", "E408"=>"表情（あくび）", "E409"=>"表情（いー）", "E40A"=>"表情（ほっ）", "E40B"=>"表情（がーん）", "E40C"=>"表情（マスク）", "E40D"=>"表情（ぽっ）", "E40E"=>"表情（しらー）", "E40F"=>"表情（おろおろ）", "E410"=>"表情（ふらふら）", "E411"=>"表情（大泣き）", "E412"=>"表情（泣き笑い）", "E413"=>"表情（悲しい）", "E414"=>"表情（にっこり）", "E415"=>"表情（嬉しい）", "E416"=>"表情（怒り）", "E417"=>"表情（チュ）", "E418"=>"表情（投げキッス）", "E419"=>"目", "E41A"=>"鼻", "E41B"=>"耳", "E41C"=>"口", "E41D"=>"手（お願い）", "E41E"=>"手（バイバイ）", "E41F"=>"手（拍手）", "E420"=>"手（オッケー）", "E421"=>"手（ブーイング）", "E422"=>"手（おっはー）", "E423"=>"ジェスチャー（ダメ）", "E424"=>"ジェスチャー（オッケー）", "E425"=>"デート", "E426"=>"土下座", "E427"=>"万歳", "E428"=>"カップル", "E429"=>"ラインダンス", "E42A"=>"バスケットボール", "E42B"=>"フットボール", "E42C"=>"ビリヤード", "E42D"=>"水泳", "E42E"=>"RV車", "E42F"=>"トラック", "E430"=>"消防車", "E431"=>"救急車", "E432"=>"パトカー", "E433"=>"ジェットコースター", "E434"=>"地下鉄", "E435"=>"新幹線（新型）", "E436"=>"門松", "E437"=>"バレンタインデー", "E438"=>"ひな祭り", "E439"=>"卒業式", "E43A"=>"ランドセル", "E43B"=>"こいのぼり", "E43C"=>"とじ傘", "E43D"=>"結婚式", "E43E"=>"波", "E43F"=>"かき氷", "E440"=>"線香花火", "E441"=>"貝", "E442"=>"風鈴", "E443"=>"台風（うずまき）", "E444"=>"稲穂", "E445"=>"ハロウィン", "E446"=>"お月見", "E447"=>"風", "E448"=>"サンタクロース", "E449"=>"朝日", "E44A"=>"夕日", "E44B"=>"流れ星", "E44C"=>"虹", "E501"=>"ラブホテル", "E502"=>"パレット", "E503"=>"シルクハット", "E504"=>"デパート", "E505"=>"お城（日本）", "E506"=>"お城（西洋）", "E507"=>"映画館", "E508"=>"工場", "E509"=>"東京タワー", "E50A"=>"渋谷", "E50B"=>"国旗（日本）", "E50C"=>"国旗（アメリカ）", "E50D"=>"国旗（フランス）", "E50E"=>"国旗（ドイツ）", "E50F"=>"国旗（イタリア）", "E510"=>"国旗（イギリス）", "E511"=>"国旗（スペイン）", "E512"=>"国旗（ロシア）", "E513"=>"国旗（中国）", "E514"=>"国旗（韓国）", "E515"=>"西洋人", "E516"=>"中国人", "E517"=>"インド人", "E518"=>"おじいさん", "E519"=>"おばあさん", "E51A"=>"あかちゃん", "E51B"=>"工事現場の人", "E51C"=>"お姫様", "E51D"=>"自由の女神", "E51E"=>"衛兵", "E51F"=>"フラメンコ", "E520"=>"イルカ", "E521"=>"鳥", "E522"=>"熱帯魚", "E523"=>"ひよこ", "E524"=>"ハムスター", "E525"=>"毛虫", "E526"=>"ぞう", "E527"=>"コアラ", "E528"=>"さる", "E529"=>"ひつじ", "E52A"=>"おおかみ", "E52B"=>"うし", "E52C"=>"うさぎ", "E52D"=>"へび", "E52E"=>"にわとり", "E52F"=>"いのしし", "E530"=>"らくだ", "E531"=>"カエル", "E532"=>"A", "E533"=>"B", "E534"=>"AB", "E535"=>"O", "E536"=>"足跡", "E537"=>"トレードマーク", "E538"=>"J-Sky1", "E539"=>"J-Sky2", "E53A"=>"vodafone1", "E53B"=>"vodafone2", "E53C"=>"vodafone3", "E53D"=>"vodafone4", "E53E"=>"vodafone5"
);

our %CharnamesEmojiGoogle = (
    "FE000"=>"晴れ", "FE001"=>"曇り", "FE002"=>"雨", "FE003"=>"雪", "FE004"=>"雷", "FE005"=>"台風", "FE006"=>"霧", "FE007"=>"小雨", "FE008"=>"夜", "FE009"=>"日の出", "FE00A"=>"日の出", "FE00B"=>"夕焼け", "FE00C"=>"夕日", "FE00D"=>"虹", "FE00E"=>"雪結晶", "FE00F"=>"ときどき曇り", "FE010"=>"夜の橋", "FE011"=>"●", "FE012"=>"やや欠け月", "FE013"=>"半月", "FE014"=>"三日月", "FE015"=>"○", "FE016"=>"月２（顔つき）", "FE017"=>"お月見", "FE018"=>"SOON", "FE019"=>"ON", "FE01A"=>"end", "FE01B"=>"砂時計", "FE01C"=>"砂時計", "FE01D"=>"腕時計", "FE01E"=>"時計（1時）", "FE01F"=>"時計（２時）", "FE020"=>"時計（３時）", "FE021"=>"時計（４時）", "FE022"=>"時計（５時）", "FE023"=>"時計（６時）", "FE024"=>"時計（７時）", "FE025"=>"時計（８時）", "FE026"=>"時計（９時）", "FE027"=>"目覚まし時計（１０時）", "FE028"=>"時計（１１時）", "FE029"=>"時計（１２時）", "FE02A"=>"時計", "FE02B"=>"牡羊座", "FE02C"=>"牡牛座", "FE02D"=>"双子座", "FE02E"=>"蟹座", "FE02F"=>"獅子座", "FE030"=>"乙女座", "FE031"=>"天秤座", "FE032"=>"蠍座", "FE033"=>"射手座", "FE034"=>"山羊座", "FE035"=>"水瓶座", "FE036"=>"魚座", "FE037"=>"蛇使座", "FE038"=>"波", "FE039"=>"地球", "FE03A"=>"火山", "FE03B"=>"天の川", "FE03C"=>"クローバー", "FE03D"=>"チューリップ", "FE03E"=>"芽", "FE03F"=>"もみじ", "FE040"=>"桜", "FE041"=>"バラ", "FE042"=>"枯れ葉", "FE043"=>"風", "FE044"=>"若葉マーク", "FE045"=>"ハイビスカス", "FE046"=>"ひまわり", "FE047"=>"ビーチ", "FE048"=>"サボテン", "FE049"=>"稲穂", "FE04A"=>"とうもろこし", "FE04B"=>"キノコ", "FE04C"=>"栗", "FE04D"=>"花", "FE04E"=>"ハーブ", "FE04F"=>"さくらんぼ", "FE050"=>"バナナ", "FE051"=>"りんご", "FE052"=>"みかん", "FE053"=>"イチゴ", "FE054"=>"スイカ", "FE055"=>"トマト", "FE056"=>"ナス", "FE057"=>"メロン", "FE058"=>"パイナップル", "FE059"=>"ブドウ", "FE05A"=>"モモ", "FE05B"=>"青りんご", "FE190"=>"目", "FE191"=>"耳", "FE192"=>"鼻", "FE193"=>"口", "FE194"=>"あかんべー", "FE195"=>"化粧", "FE196"=>"マニキュア", "FE197"=>"エステ", "FE198"=>"美容院", "FE199"=>"床屋", "FE19A"=>"人影", "FE19B"=>"顔１", "FE19C"=>"小顔", "FE19D"=>"成人男性", "FE19E"=>"成人女性", "FE19F"=>"家族", "FE1A0"=>"カップル", "FE1A1"=>"警官", "FE1A2"=>"バニー", "FE1A3"=>"花嫁", "FE1A4"=>"白人", "FE1A5"=>"中国人", "FE1A6"=>"インド", "FE1A7"=>"おじいさん", "FE1A8"=>"おばあさん", "FE1A9"=>"赤ちゃん", "FE1AA"=>"工事現場の人", "FE1AB"=>"お姫様", "FE1AC"=>"なまはげ", "FE1AD"=>"天狗", "FE1AE"=>"お化け", "FE1AF"=>"天使", "FE1B0"=>"UFO", "FE1B1"=>"宇宙人", "FE1B2"=>"アクマ", "FE1B3"=>"ドクロ", "FE1B4"=>"案内（カスタマーサービス）", "FE1B5"=>"衛兵", "FE1B6"=>"ダンス", "FE1B7"=>"犬", "FE1B8"=>"猫", "FE1B9"=>"カタツムリ", "FE1BA"=>"ひよこ", "FE1BB"=>"正面向きのひよこ", "FE1BC"=>"ペンギン", "FE1BD"=>"魚", "FE1BE"=>"ウマ", "FE1BF"=>"ブタ", "FE1C0"=>"トラ", "FE1C1"=>"クマ", "FE1C2"=>"ネズミ", "FE1C3"=>"クジラ", "FE1C4"=>"さる", "FE1C5"=>"タコ", "FE1C6"=>"巻貝", "FE1C7"=>"イルカ", "FE1C8"=>"鳥", "FE1C9"=>"熱帯魚", "FE1CA"=>"ハムスター", "FE1CB"=>"ゲジゲジ", "FE1CC"=>"ゾウ", "FE1CD"=>"コアラ", "FE1CE"=>"サル", "FE1CF"=>"ヒツジ", "FE1D0"=>"おおかみ", "FE1D1"=>"牛", "FE1D2"=>"ウサギ", "FE1D3"=>"ヘビ", "FE1D4"=>"ニワトリ", "FE1D5"=>"イノシシ", "FE1D6"=>"ラクダ", "FE1D7"=>"カエル", "FE1D8"=>"犬（プードル）", "FE1D9"=>"ふぐ", "FE1DA"=>"アリ", "FE1DB"=>"足跡（犬）", "FE1DC"=>"カメ", "FE1DD"=>"卵割り", "FE1DE"=>"辰", "FE1DF"=>"パンダ", "FE1E0"=>"ぶたの鼻", "FE1E1"=>"ミツバチ", "FE1E2"=>"てんとう虫", "FE1E3"=>"カニ", "FE320"=>"ちっ（怒った顔）", "FE321"=>"ほえー", "FE322"=>"びっくり", "FE323"=>"がく～（落胆した顔）", "FE324"=>"ふらふら", "FE325"=>"あせり", "FE326"=>"ボケーっとした顔", "FE327"=>"目がハート", "FE328"=>"勝ち誇り", "FE329"=>"あっかんべー", "FE32A"=>"表情（いー）", "FE32B"=>"うまい！", "FE32C"=>"チュッ", "FE32D"=>"チュー２", "FE32E"=>"風邪ひき", "FE32F"=>"熱", "FE330"=>"わーい（嬉しい顔）", "FE331"=>"冷や汗", "FE332"=>"うれしい顔", "FE333"=>"ウッシッシ", "FE334"=>"泣き笑い", "FE335"=>"にこにこ", "FE336"=>"スマイルフェイス", "FE338"=>"表情（嬉しい）", "FE339"=>"涙", "FE33A"=>"泣き顔", "FE33B"=>"青ざめ", "FE33C"=>"がまん顔", "FE33D"=>"ぷっくっくな顔", "FE33E"=>"ほっとした顔", "FE33F"=>"もうやだ～（悲しい顔）", "FE340"=>"考えてる顔", "FE341"=>"げっそり", "FE342"=>"眠い", "FE343"=>"猫2", "FE344"=>"冷や汗2", "FE345"=>"表情（やれやれ）", "FE346"=>"顔４（つかれたカオ）", "FE347"=>"ウィンク", "FE348"=>"にこ（ネコ）", "FE349"=>"うっしっし（ネコ）", "FE34A"=>"泣き笑い（ネコ）", "FE34B"=>"チュー（ネコ）", "FE34C"=>"目がハート（ネコ）", "FE34D"=>"涙ぽろり（ネコ）", "FE34E"=>"ぶー（かわいく怒）（ネコ）", "FE34F"=>"きりり（ネコ）", "FE350"=>"ほえー（ネコ）", "FE351"=>"ＮＧ", "FE352"=>"ＯＫ！２", "FE353"=>"m(_ _)m", "FE354"=>"(/_＼)", "FE355"=>"(・×・)", "FE356"=>"|(・×・)|", "FE357"=>"(^-^)/", "FE358"=>"＼(^o^)／", "FE359"=>"キャラクター（しょんぼり）", "FE35A"=>"キャラクター（かわいく怒る）", "FE35B"=>"(>人<)", "FE35C"=>"B-)", "FE35D"=>"＼(^-^)／", "FE35E"=>"8-|", "FE35F"=>"考え中", "FE360"=>"やったー", "FE361"=>"クラクラ", "FE362"=>"ムムム", "FE363"=>"エッ?", "FE364"=>"逆立ち", "FE365"=>"怪我をした顔", "FE366"=>"心配した顔", "FE367"=>"同情した顔", "FE368"=>"細い顔", "FE369"=>"ロボット", "FE4B0"=>"家", "FE4B1"=>"ホーム", "FE4B2"=>"ビル", "FE4B3"=>"郵便局", "FE4B4"=>"病院", "FE4B5"=>"銀行", "FE4B6"=>"ＡＴＭ", "FE4B7"=>"ホテル", "FE4B8"=>"ホテル２", "FE4B9"=>"コンビニ", "FE4BA"=>"学校", "FE4BB"=>"教会", "FE4BC"=>"噴水", "FE4BD"=>"デパート", "FE4BE"=>"城", "FE4BF"=>"城", "FE4C0"=>"工場", "FE4C1"=>"港（いかりマーク）", "FE4C2"=>"居酒屋（赤ちょうちん）", "FE4C3"=>"富士山", "FE4C4"=>"東京タワー", "FE4C5"=>"渋谷", "FE4C6"=>"自由の女神", "FE4C7"=>"地図", "FE4C8"=>"モアイ", "FE4C9"=>"レンチ", "FE4CA"=>"ハンマー", "FE4CB"=>"ネジ", "FE4CC"=>"紳士靴", "FE4CD"=>"くつ", "FE4CE"=>"メガネ", "FE4CF"=>"Tシャツ（ボーダー）", "FE4D0"=>"ジーンズ", "FE4D1"=>"王冠", "FE4D2"=>"エンブレム", "FE4D3"=>"ネクタイ", "FE4D4"=>"帽子", "FE4D5"=>"ドレス", "FE4D6"=>"ブティック", "FE4D7"=>"サンダル", "FE4D8"=>"ブーツ", "FE4D9"=>"着物", "FE4DA"=>"ビキニ", "FE4DB"=>"婦人服", "FE4DC"=>"財布", "FE4DD"=>"ドル袋", "FE4DE"=>"\$￥", "FE4DF"=>"株価", "FE4E0"=>"ドル", "FE4E1"=>"カード", "FE4E2"=>"￥", "FE4E3"=>"ドル札", "FE4E4"=>"飛んでいくお金", "FE4E5"=>"日の丸", "FE4E6"=>"USA", "FE4E7"=>"フランス", "FE4E8"=>"ドイツ", "FE4E9"=>"イタリア", "FE4EA"=>"イギリス", "FE4EB"=>"スペイン", "FE4EC"=>"ロシア", "FE4ED"=>"中国", "FE4EE"=>"韓国", "FE4EF"=>"カメラ", "FE4F0"=>"カバン", "FE4F1"=>"ふくろ", "FE4F2"=>"チャペル", "FE4F3"=>"ドア", "FE4F4"=>"ウンチ", "FE4F5"=>"ピストル", "FE4F6"=>"炎", "FE4F7"=>"占い", "FE4F8"=>"占い", "FE4F9"=>"ハンディカム", "FE4FA"=>"包丁", "FE4FB"=>"懐中電灯", "FE4FC"=>"電池", "FE4FD"=>"スクロール", "FE4FE"=>"コンセント", "FE4FF"=>"本１", "FE500"=>"本２", "FE501"=>"本３", "FE502"=>"本４", "FE503"=>"複数本", "FE504"=>"名札", "FE505"=>"風呂", "FE506"=>"トイレ", "FE507"=>"洋式トイレ", "FE508"=>"トイレマーク", "FE509"=>"注射", "FE50A"=>"薬", "FE50B"=>"A", "FE50C"=>"B", "FE50D"=>"AB", "FE50E"=>"O", "FE50F"=>"リボン", "FE510"=>"プレゼント", "FE511"=>"バースデー", "FE512"=>"クリスマス", "FE513"=>"サンタ", "FE514"=>"祝日", "FE515"=>"花火", "FE516"=>"風船", "FE517"=>"クラッカー", "FE518"=>"門松", "FE519"=>"ひな祭り", "FE51A"=>"卒業式", "FE51B"=>"ランドセル", "FE51C"=>"こいのぼり", "FE51D"=>"線香花火", "FE51E"=>"風鈴", "FE51F"=>"ハロウィン", "FE520"=>"オメデトウ", "FE521"=>"七夕", "FE522"=>"ポケベル", "FE523"=>"電話", "FE524"=>"電話２", "FE525"=>"携帯電話", "FE526"=>"phone to", "FE527"=>"メモ", "FE528"=>"fax to", "FE529"=>"メール", "FE52A"=>"封筒２", "FE52B"=>"mail to", "FE52C"=>"メールボックス", "FE52D"=>"受信箱１", "FE52E"=>"メール送信（ポスト）", "FE52F"=>"スピーカ", "FE530"=>"スピーカ", "FE531"=>"アンテナ", "FE532"=>"フキダシ", "FE533"=>"送信BOX", "FE534"=>"受信BOX", "FE535"=>"パッケージ", "FE536"=>"ペン", "FE537"=>"いす", "FE538"=>"パソコン", "FE539"=>"鉛筆", "FE53A"=>"クリップ", "FE53B"=>"仕事かばん", "FE53C"=>"フロッピー", "FE53D"=>"フロッピー", "FE53E"=>"美容院", "FE53F"=>"φ", "FE540"=>"文書１", "FE541"=>"文書２", "FE542"=>"カレンダー", "FE543"=>"フォルダ", "FE544"=>"フォルダ", "FE545"=>"ノート１", "FE546"=>"本", "FE547"=>"ノート３", "FE548"=>"クリップボード", "FE549"=>"カレンダー", "FE54A"=>"グラフ", "FE54B"=>"グラフ", "FE54C"=>"グラフ", "FE54D"=>"Roldex", "FE54E"=>"画びょう", "FE54F"=>"台帳", "FE550"=>"定規", "FE551"=>"三角定規", "FE552"=>"マーク", "FE553"=>"足", "FE7D0"=>"スポーツ", "FE7D1"=>"野球", "FE7D2"=>"ゴルフ", "FE7D3"=>"テニス", "FE7D4"=>"サッカー", "FE7D5"=>"スキー", "FE7D6"=>"バスケットボール", "FE7D7"=>"モータースポーツ", "FE7D8"=>"スノボ", "FE7D9"=>"走る人", "FE7DA"=>"サーフィン", "FE7DB"=>"トロフィー", "FE7DC"=>"馬（全体）", "FE7DD"=>"フットボール", "FE7DE"=>"水泳", "FE7DF"=>"電車", "FE7E0"=>"地下鉄", "FE7E1"=>"地下鉄", "FE7E2"=>"新幹線", "FE7E3"=>"新幹線", "FE7E4"=>"車（セダン）", "FE7E5"=>"車（ＲＶ）", "FE7E6"=>"バス", "FE7E7"=>"バス停", "FE7E8"=>"船", "FE7E9"=>"飛行機", "FE7EA"=>"リゾート", "FE7EB"=>"自転車", "FE7EC"=>"駅", "FE7ED"=>"ロケット", "FE7EE"=>"ボート（競艇）", "FE7EF"=>"タクシー", "FE7F0"=>"歩く人", "FE7F1"=>"トラック", "FE7F2"=>"消防車", "FE7F3"=>"救急車", "FE7F4"=>"パトカー", "FE7F5"=>"ガソリンスタンド", "FE7F6"=>"駐車場", "FE7F7"=>"信号", "FE7F8"=>"工事中", "FE7F9"=>"パトカー", "FE7FA"=>"いい気分（温泉）", "FE7FB"=>"キャンプ", "FE7FC"=>"遊園地", "FE7FD"=>"観覧車", "FE7FE"=>"ジェットコースター", "FE7FF"=>"釣り", "FE800"=>"カラオケ", "FE801"=>"映画", "FE802"=>"映画館", "FE803"=>"音楽", "FE804"=>"アート", "FE805"=>"演劇", "FE806"=>"イベント", "FE807"=>"チケット", "FE808"=>"カチンコ", "FE809"=>"演劇", "FE80A"=>"ゲーム", "FE80B"=>"麻雀", "FE80C"=>"的中", "FE80D"=>"777", "FE80E"=>"ビリヤード", "FE80F"=>"サイコロ", "FE810"=>"ボーリング", "FE811"=>"花札", "FE812"=>"ジョーカー", "FE813"=>"るんるん", "FE814"=>"ムード", "FE815"=>"サックス", "FE816"=>"ギター", "FE817"=>"ピアノ", "FE818"=>"トランペット", "FE819"=>"バイオリン", "FE81A"=>"楽譜", "FE81B"=>"グラフ", "FE81C"=>"ＴＶ", "FE81D"=>"ＣＤ", "FE81E"=>"DVD", "FE81F"=>"ラジオ", "FE820"=>"ビデオ", "FE821"=>"スピーカ", "FE822"=>"新聞", "FE823"=>"キスマーク", "FE824"=>"ラブレター", "FE825"=>"指輪", "FE826"=>"ダイヤモンド", "FE827"=>"チュー", "FE828"=>"花束", "FE829"=>"カップル", "FE82A"=>"結婚式", "FE82B"=>"フリーダイヤル", "FE82C"=>"シャープダイヤル", "FE82D"=>"Q", "FE82E"=>"1", "FE82F"=>"2", "FE830"=>"3", "FE831"=>"4", "FE832"=>"5", "FE833"=>"6", "FE834"=>"7", "FE835"=>"8", "FE836"=>"9", "FE837"=>"四角数字0", "FE838"=>"バリ3", "FE839"=>"マナーモード", "FE83A"=>"ケータイOFF", "FE83B"=>"10", "FE83C"=>"PDC", "FE960"=>"ファーストフード", "FE961"=>"おにぎり", "FE962"=>"ショートケーキ", "FE963"=>"どんぶり", "FE964"=>"パン", "FE965"=>"フライパン", "FE966"=>"ソフトクリーム", "FE967"=>"ポテト", "FE968"=>"だんご", "FE969"=>"せんべい", "FE96A"=>"ごはん", "FE96B"=>"パスタ", "FE96C"=>"カレー", "FE96D"=>"おでん", "FE96E"=>"すし", "FE96F"=>"弁当", "FE970"=>"鍋", "FE971"=>"カキ氷", "FE972"=>"肉", "FE973"=>"なると", "FE974"=>"やきいも", "FE975"=>"ピザ", "FE976"=>"チキン", "FE977"=>"アイスクリーム", "FE978"=>"ドーナツ", "FE979"=>"クッキー", "FE97A"=>"チョコ", "FE97B"=>"キャンディ", "FE97C"=>"キャンディ", "FE97D"=>"プリン", "FE97E"=>"ハチミツ", "FE97F"=>"エビフライ", "FE980"=>"レストラン", "FE981"=>"喫茶店", "FE982"=>"バー", "FE983"=>"ビール", "FE984"=>"湯のみ", "FE985"=>"とっくり（おちょこ付き）", "FE986"=>"ワイングラス", "FE987"=>"乾杯", "FE988"=>"トロピカルドリンク", "FEAF0"=>"右斜め上", "FEAF1"=>"右斜め下", "FEAF2"=>"左斜め上", "FEAF3"=>"左斜め下", "FEAF4"=>"グッド（上向き矢印）", "FEAF5"=>"バッド（下向き矢印）", "FEAF6"=>"⇔", "FEAF7"=>"↑↓", "FEAF8"=>"↑", "FEAF9"=>"↓", "FEAFA"=>"→", "FEAFB"=>"←", "FEAFC"=>">", "FEAFD"=>"<", "FEAFE"=>">>", "FEAFF"=>"<<", "FEB00"=>"▼", "FEB01"=>"▲", "FEB02"=>"▼", "FEB03"=>"▲", "FEB04"=>"exclamation", "FEB05"=>"！？", "FEB06"=>"！！", "FEB07"=>"ー（長音記号１）", "FEB08"=>"～", "FEB09"=>"？", "FEB0A"=>"？", "FEB0B"=>"びっくりマーク（アニメ）", "FEB0C"=>"黒ハート", "FEB0D"=>"揺れるハート", "FEB0E"=>"失恋", "FEB0F"=>"ハートたち（複数ハート）", "FEB10"=>"光るハート", "FEB11"=>"ハート（ドキドキ）", "FEB12"=>"ハート５（矢がささっている）", "FEB13"=>"青ハート", "FEB14"=>"緑ハート", "FEB15"=>"黄ハート", "FEB16"=>"紫ハート", "FEB17"=>"リボンがけのハート", "FEB18"=>"かわいい", "FEB19"=>"飾り1", "FEB1A"=>"ハート", "FEB1B"=>"スペード", "FEB1C"=>"ダイヤ", "FEB1D"=>"クラブ", "FEB1E"=>"喫煙", "FEB1F"=>"禁煙", "FEB20"=>"車椅子", "FEB21"=>"FREE", "FEB22"=>"旗", "FEB23"=>"危険・警告", "FEB24"=>"ココ", "FEB25"=>"18禁", "FEB26"=>"立ち入り禁止", "FEB27"=>"決定", "FEB28"=>"NG", "FEB29"=>"コピーライト", "FEB2A"=>"トレードマーク", "FEB2B"=>"マル秘", "FEB2C"=>"↑↓", "FEB2D"=>"レジスタードトレードマーク", "FEB2E"=>"禁", "FEB2F"=>"空室・空席・空車", "FEB30"=>"合", "FEB31"=>"満室・満席・満車", "FEB32"=>"VS", "FEB33"=>"♂", "FEB34"=>"♀", "FEB35"=>"赤ちゃん", "FEB36"=>"ＮＥＷ", "FEB37"=>"UP!", "FEB38"=>"COOL", "FEB39"=>"有", "FEB3A"=>"無", "FEB3B"=>"月", "FEB3C"=>"申", "FEB3D"=>"得", "FEB3E"=>"割", "FEB3F"=>"サービス", "FEB40"=>"指", "FEB41"=>"営", "FEB42"=>"TOP", "FEB43"=>"祝", "FEB44"=>"○", "FEB45"=>"×", "FEB46"=>"×", "FEB47"=>"ｉ", "FEB48"=>"禁止", "FEB49"=>"チェックマーク", "FEB4A"=>"チェックマーク", "FEB4B"=>"リンク", "FEB4C"=>"全部ブランク", "FEB4D"=>"半分ブランク", "FEB4E"=>"4分の１ブランク", "FEB4F"=>"SOS", "FEB50"=>"可", "FEB51"=>"＋", "FEB52"=>"－", "FEB53"=>"×", "FEB54"=>"÷", "FEB55"=>"かわいい", "FEB56"=>"ひらめき", "FEB57"=>"むかっ（怒り）", "FEB58"=>"爆弾", "FEB59"=>"眠い(睡眠)", "FEB5A"=>"ドンッ", "FEB5B"=>"あせあせ（飛び散る汗）", "FEB5C"=>"たらーっ（汗）", "FEB5D"=>"ダッシュ（走り出すさま）", "FEB5E"=>"力こぶ", "FEB5F"=>"クラクラ", "FEB60"=>"ぴかぴか（新しい）", "FEB61"=>"スパーク２（キラリマーク）", "FEB62"=>"星１", "FEB63"=>"大丸１", "FEB64"=>"大丸２", "FEB64"=>"大丸２", "FEB65"=>"小丸１", "FEB66"=>"小丸2", "FEB67"=>"ボタン３", "FEB68"=>"☆", "FEB69"=>"☆", "FEB6A"=>"☆彡", "FEB6B"=>"■", "FEB6C"=>"■", "FEB6D"=>"■", "FEB6E"=>"■", "FEB6F"=>"■", "FEB70"=>"■", "FEB71"=>"■", "FEB72"=>"■", "FEB73"=>"◆", "FEB74"=>"◆", "FEB75"=>"◆", "FEB76"=>"◆", "FEB77"=>"スパーク", "FEB78"=>"▲", "FEB79"=>"▼", "FEB7A"=>"花丸", "FEB7B"=>"100点", "FEB7C"=>"ABCD", "FEB7D"=>"abcd", "FEB7E"=>"1234", "FEB7F"=>"記号", "FEB80"=>"ABC", "FEB81"=>"ID", "FEB82"=>"パスワード", "FEB83"=>"←┘", "FEB84"=>"CL", "FEB85"=>"サーチ（調べる）", "FEB86"=>"錠前", "FEB87"=>"鍵（解除）", "FEB88"=>"└→", "FEB89"=>"オープンウェブ", "FEB8A"=>"ロック確認", "FEB8B"=>"チェックマーク", "FEB8C"=>"ラジオボタン", "FEB8D"=>"見る", "FEB8E"=>"←BACK", "FEB8F"=>"ブックマーク", "FEB90"=>"個人", "FEB91"=>"↑↓", "FEB92"=>"ｅメールアイコン", "FEB93"=>"手（グー）", "FEB94"=>"手（チョキ）", "FEB95"=>"手（パー）", "FEB96"=>"パンチ", "FEB97"=>"指でOK", "FEB98"=>"人差し指", "FEB99"=>"↑", "FEB9A"=>"↓", "FEB9B"=>"←", "FEB9C"=>"→", "FEB9D"=>"バイバイ", "FEB9E"=>"拍手", "FEB9F"=>"ＯＫ！", "FEBA0"=>"ブーイング", "FEBA1"=>"手（おっはー）", "FEBA2"=>"ロックオン", "FEE10"=>"iモード", "FEE11"=>"iモード", "FEE12"=>"ドコモ", "FEE13"=>"ドコモポイント", "FEE14"=>"iアプリ", "FEE15"=>"iアプリ", "FEE16"=>"ぴ", "FEE17"=>"あ", "FEE18"=>"チケット", "FEE19"=>"チケット", "FEE1A"=>"電話先行", "FEE1B"=>"Pコード", "FEE1D"=>"ぴ", "FEE1E"=>"(ぴ)", "FEE1F"=>"ぴ", "FEE20"=>"チェック", "FEE21"=>"F", "FEE22"=>"D", "FEE23"=>"S", "FEE24"=>"C", "FEE25"=>"R", "FEE26"=>"■", "FEE27"=>"■", "FEE28"=>"▼", "FEE29"=>"††††", "FEE2A"=>"†††", "FEE2B"=>"††", "FEE2C"=>"†", "FEE2D"=>"I", "FEE2E"=>"M", "FEE2F"=>"E", "FEE30"=>"VE", "FEE31"=>"●", "FEE32"=>"カード使用不可", "FEE33"=>"チェックボックス", "FEE40"=>"EZ", "FEE41"=>"ezplus", "FEE42"=>"EZナビ", "FEE43"=>"EZムービー", "FEE44"=>"Cメール", "FEE45"=>"Java", "FEE46"=>"BREW", "FEE47"=>"EZ着うた", "FEE48"=>"EZナビ", "FEE49"=>"WIN", "FEE4A"=>"プレミアム", "FEE70"=>"J-Sky1", "FEE71"=>"J-Sky2", "FEE72"=>"vodafone1", "FEE73"=>"vodafone2", "FEE74"=>"v", "FEE75"=>"oda", "FEE76"=>"fone", "FEE77"=>"J-PHONショップ", "FEE78"=>"スカイウェイブ", "FEE79"=>"スカイウォーカー", "FEE7A"=>"スカイメロディ", "FEE7B"=>"J-PHONE", "FEE7C"=>"J-PHONE2", "FEE7D"=>"J-PHONE3", "FEEA0"=>"Google"
);

our %CharnamesEmojiUnicode = (
    "00A9"=>"COPYRIGHT SIGN", "00AE"=>"REGISTERED SIGN", "2002"=>"EN SPACE", "2003"=>"EM SPACE", "2005"=>"FOUR-PER-EM SPACE", "203C"=>"DOUBLE EXCLAMATION MARK", "2049"=>"EXCLAMATION QUESTION MARK", "2122"=>"TRADE MARK SIGN", "2139"=>"INFORMATION SOURCE", "2194"=>"LEFT RIGHT ARROW", "2195"=>"UP DOWN ARROW", "2196"=>"NORTH WEST ARROW", "2197"=>"NORTH EAST ARROW", "2198"=>"SOUTH EAST ARROW", "2199"=>"SOUTH WEST ARROW", "21A9"=>"LEFTWARDS ARROW WITH HOOK", "21AA"=>"RIGHTWARDS ARROW WITH HOOK", "231A"=>"WATCH", "231B"=>"HOURGLASS", "23E9"=>"ALARM CLOCK", "23EA"=>"BLACK RIGHT-POINTING DOUBLE TRIANGLE", "24C2"=>"CIRCLED LATIN CAPITAL LETTER M", "25AA"=>"BLACK SMALL SQUARE", "25AB"=>"WHITE SMALL SQUARE", "25B6"=>"BLACK RIGHT-POINTING TRIANGLE", "25C0"=>"BLACK LEFT-POINTING TRIANGLE", "25FB"=>"WHITE MEDIUM SQUARE", "25FC"=>"BLACK MEDIUM SQUARE", "25FD"=>"WHITE MEDIUM SMALL SQUARE", "25FE"=>"BLACK MEDIUM SMALL SQUARE", "2600"=>"BLACK SUN WITH RAYS", "2601"=>"CLOUD", "260E"=>"BLACK TELEPHONE", "2611"=>"BALLOT BOX WITH CHECK", "2614"=>"UMBRELLA WITH RAIN DROPS", "2615"=>"HOT BEVERAGE", "261D"=>"WHITE UP POINTING INDEX", "263A"=>"WHITE SMILING FACE", "2648"=>"ARIES", "2649"=>"TAURUS", "264A"=>"GEMINI", "264B"=>"CANCER", "264C"=>"LEO", "264D"=>"VIRGO", "264E"=>"LIBRA", "264F"=>"SCORPIUS", "2650"=>"SAGITTARIUS", "2651"=>"CAPRICORN", "2652"=>"AQUARIUS", "2653"=>"PISCES", "2660"=>"BLACK SPADE SUIT", "2663"=>"BLACK CLUB SUIT", "2665"=>"BLACK HEART SUIT", "2666"=>"BLACK DIAMOND SUIT", "2668"=>"HOT SPRINGS", "267B"=>"BLACK UNIVERSAL RECYCLING SYMBOL", "267F"=>"WHEELCHAIR SYMBOL", "2693"=>"ANCHOR", "26A0"=>"WARNING SIGN", "26A1"=>"HIGH VOLTAGE SIGN", "26AA"=>"MEDIUM WHITE CIRCLE", "26AB"=>"MEDIUM BLACK CIRCLE", "26BD"=>"SOCCER BALL", "26BE"=>"BASEBALL", "26C4"=>"SNOWMAN WITHOUT SNOW", "26C5"=>"SUN BEHIND CLOUD", "26D4"=>"NO ENTRY", "26E2"=>"HEAVY LARGE CIRCLE", "26EA"=>"CHURCH", "26F2"=>"FOUNTAIN", "26F3"=>"FLAG IN HOLE", "26F5"=>"SAILBOAT", "26FA"=>"TENT", "26FD"=>"FUEL PUMP", "2702"=>"BLACK SCISSORS", "2705"=>"WHITE HEAVY CHECK MARK", "2708"=>"AIRPLANE", "2709"=>"ENVELOPE", "270A"=>"RAISED FIST", "270C"=>"VICTORY HAND", "270F"=>"PENCIL", "2712"=>"BLACK NIB", "2714"=>"HEAVY CHECK MARK", "2716"=>"HEAVY MULTIPLICATION X", "2733"=>"EIGHT SPOKED ASTERISK", "2734"=>"EIGHT POINTED BLACK STAR", "2744"=>"SNOWFLAKE", "2747"=>"SPARKLE", "2762"=>"HEAVY EXCLAMATION MARK ORNAMENT", "2764"=>"HEAVY BLACK HEART", "27A1"=>"BLACK RIGHTWARDS ARROW", "2934"=>"ARROW POINTING RIGHTWARDS THEN CURVING UPWARDS", "2935"=>"ARROW POINTING RIGHTWARDS THEN CURVING DOWNWARDS", "2B05"=>"LEFTWARDS BLACK ARROW", "2B06"=>"UPWARDS BLACK ARROW", "2B07"=>"DOWNWARDS BLACK ARROW", "2B1B"=>"BLACK LARGE SQUARE", "2B1C"=>"WHITE LARGE SQUARE", "2B50"=>"WHITE MEDIUM STAR", "2E32"=>"LOOPED LENGTH MARK", "3030"=>"WAVY DASH", "303D"=>"PART ALTERNATION MARK", "3297"=>"CIRCLED IDEOGRAPH CONGRATULATION", "3299"=>"CIRCLED IDEOGRAPH SECRET", "1F004"=>"MAHJONG TILE RED DRAGON", "1F170"=>"NEGATIVE SQUARED LATIN CAPITAL LETTER A", "1F171"=>"NEGATIVE SQUARED LATIN CAPITAL LETTER B", "1F17E"=>"NEGATIVE SQUARED LATIN CAPITAL LETTER O", "1F17F"=>"WHITE ON BLACK SQUARED LATIN CAPITAL LETTER P", "1F18E"=>"NEGATIVE SQUARED LATIN CAPITAL LETTER AB", "1F201"=>"SQUARED KATAKANA KOKO", "1F224"=>"SQUARED CJK UNIFIED IDEOGRAPH-6307", "1F22A"=>"SQUARED CJK UNIFIED IDEOGRAPH-7121", "1F231"=>"SQUARED CJK UNIFIED IDEOGRAPH-7981", "1F250"=>"CIRCLED IDEOGRAPH ADVANTAGE", "1F44D"=>"SEAT", "1F541"=>"LATIN CAPITAL LETTERS INPUT SYMBOL", "1F600"=>"EMOJI COMPATIBILITY SYMBOL-1"
);

1;
