#
# This file is part of Acme::MetaSyntactic::buzzwords.
# Copyright (c) 2007 Jerome Quelin, all rights reserved.
#
# This program is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
#

package Acme::MetaSyntactic::buzzwords;

use strict;
use warnings;

use base qw[ Acme::MetaSyntactic::List ];

our $VERSION = '0.02';
__PACKAGE__->init();


=head1 NAME

Acme::MetaSyntactic::buzzwords - Pointy-haired boss lingo


=head1 DESCRIPTION

This theme lists some buzzwords used by pointy-haired bosses - and other
'hype' people.

Note: words taken from L<http://en.wikipedia.org/wiki/List_of_buzzwords>


=head1 BUGS

Please report any bugs or feature requests to C<< < bug-acme-metasyntactic-buzzwords at
rt.cpan.org> >>, or through the web interface at
L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Acme-MetaSyntactic-buzzwords>.  I will be
notified, and then you'll automatically be notified of progress on your
bug as I make changes.


=head1 SEE ALSO

C<Acme::MetaSyntactic::buzzwords> development takes place on
L<http://acme-metasyntactic-buzzwords.googlecode.com> - feel free to join us.


You can also look for information on this module at:

=over 4

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Acme-MetaSyntactic-buzzwords>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Acme-MetaSyntactic-buzzwords>

=item * RT: CPAN's request tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Acme-MetaSyntactic-buzzwords>

=back


=head1 AUTHOR

Jerome Quelin, C<< <jquelin at cpan.org> >>


=head1 COPYRIGHT & LICENSE

Copyright (c) 2007 Jerome Quelin, all rights reserved.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.


=cut


1;

__DATA__
# names
alignment at_the_end_of_the_day buzzword disconnect empowerment
exit_strategy face_time generation_x globalization grow_the_business
impact interflop leverage on_the_runway ogranic_growth outside_the_box
paradigm paradigm_shift proactive sea_change spin_up streamline synergy
wellness win_win

ballpark_figure business_to_business b2b business_to_consumer b2c
best_of_breed best_practices bizmeth brand brick_and_mortar
buzzword_compliant client_centric co_opetition customer_centric
downsizing drinking_the_kool_aid eat_their_own_dog_food enterprise
event_horizon eyeballs free_value fulfilment_issues granular
herding_cats logisitcs long_tail low_hanging_fruit make_it_pop mindshare
new_economy next_generation offshoring return_on_investment roi
reverse_fulfilment rightshoring share_options solution sox
sarbanes_oxley value_added visibility

aggregator ajax bandwidth benchmarking backend beta bleeding_edge blog
bricks_and_clicks clickthrough client_server collaboration
content_management content_management_system convergence cross_platform
design_patterns digital_divide remastering digital_rights_management drm
digital_signage document_management dot_bomb download elearning
enterprise_content_management enterprise_service_bus framework
folksonomy fuzzy_logic immersion information_superhighway
information_highway mobile modularity nanotechnology netiquette
next_generation nextgen podcasting portal realtime saas scalability
social_bookmarking social_software spam struts sync_up tagging
user_generated_content virtualization vlogging vortal web_20 webinar
weblog web_services wikiality workflow

information_society political_capital stakeholder truthiness

best_in_class triptronic
