package Paws::ElasticBeanstalk::ConfigurationOptionSetting;
  use Moose;
  has Namespace => (is => 'ro', isa => 'Str');
  has OptionName => (is => 'ro', isa => 'Str');
  has ResourceName => (is => 'ro', isa => 'Str');
  has Value => (is => 'ro', isa => 'Str');
1;

### main pod documentation begin ###

=head1 NAME

Paws::ElasticBeanstalk::ConfigurationOptionSetting

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElasticBeanstalk::ConfigurationOptionSetting object:

  $service_obj->Method(Att1 => { Namespace => $value, ..., Value => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElasticBeanstalk::ConfigurationOptionSetting object:

  $result = $service_obj->Method(...);
  $result->Att1->Namespace

=head1 DESCRIPTION

A specification identifying an individual configuration option along
with its current value. For a list of possible option values, go to
Option Values
(https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
in the I<AWS Elastic Beanstalk Developer Guide>.

=head1 ATTRIBUTES


=head2 Namespace => Str

  A unique namespace identifying the option's associated AWS resource.


=head2 OptionName => Str

  The name of the configuration option.


=head2 ResourceName => Str

  A unique resource name for a time-based scaling configuration option.


=head2 Value => Str

  The current value for the configuration option.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElasticBeanstalk>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

