package SolarBeam::Response;
use Mojo::Base -base;
use Data::Page;
use Mojo::JSON::MaybeXS;
use Mojo::JSON qw/decode_json/;

has 'status';
has 'error' => 'Unknown error';
has 'QTime';
has 'params';

has 'numFound';
has 'start';
has 'docs' => sub { [] };

has 'facet_queries' => sub { {} };
has 'facet_fields'  => sub { {} };
has 'facet_dates'   => sub { {} };
has 'facet_ranges'  => sub { {} };

has 'terms';

has 'pager' => sub { Data::Page->new };

sub parse {
  my ($self, $msg) = @_;

  if ($msg->error) {
    $self->status(1);
    $self->error($msg->error);
    return $self;
  }

  my $data = decode_json($msg->body);

  my $header = $data->{responseHeader};
  my $res    = $data->{response};
  my $facets = $data->{facet_counts};
  my $terms  = $data->{terms};
  my $field;

  if (!$header) {
    $self->status(1);
    my $dom = $msg->dom;
    my $title = $dom->at('title') if $dom;

    if ($title) {
      $self->error($title->text);
    }
    else {
      $self->error($msg->code . ': ' . $msg->body);
    }
    return $self;
  }

  for $field (keys %{$header}) {
    $self->$field($header->{$field}) if $self->can($field);
  }

  for $field (keys %{$res}) {
    $self->$field($res->{$field}) if $self->can($field);
  }

  for $field (keys %{$facets}) {
    $self->$field($facets->{$field}) if $self->can($field);
  }

  my $ff = $self->facet_fields;
  if ($ff) {
    for $field (keys %$ff) {
      $ff->{$field} = $self->build_count_list($ff->{$field});
    }
  }

  if ($self->facet_ranges) {
    for $field (keys %{$self->facet_ranges}) {
      my $range = $self->facet_ranges->{$field};
      $range->{counts} = $self->build_count_list($range->{counts});
    }
  }

  if ($terms) {
    my $sane_terms = {};
    for $field (keys %{$terms}) {
      $sane_terms->{$field} = $self->build_count_list($terms->{$field});
    }
    $self->terms($sane_terms);
  }

  if ($self->ok && $res) {
    $self->pager->total_entries($self->numFound);
  }

  $self;
}

sub ok {
  my $self = shift;
  $self->status == 0;
}

sub build_count_list {
  my ($self, $list) = @_;
  my @result = ();
  for (my $i = 1; $i < @$list; $i += 2) {
    push @result, {value => $list->[$i - 1], count => $list->[$i]};
  }
  return \@result;
}

1;

=encoding utf8

=head1 NAME

SolarBeam::Response - TODO

=head1 SYNOPSIS

TODO

=head1 DESCRIPTION

TODO

=head1 ATTRIBUTES

=head1 METHODS

=head2 build_count_list

=head2 ok

=head2 parse

=head1 AUTHOR

Jan Henning Thorsen

=head1 COPYRIGHT AND LICENSE

TODO

=head1 SEE ALSO

TODO

=cut
