#!perl -T
use 5.006;
use strict;
use warnings;
use Test::More;
use Geo::OLC qw(recover_nearest);

# there are no formal test cases for recover_nearest(), so this is
# just an ad-hoc supplement to reversing the shorten() test cases,
# generated by taking the location supplied with the short code on
# https://plus.codes/ and looking it up on https://maps.google.com/
# to get lat/lon.
#
# TODO: come up with a full set of lat/lon +1/-1 tests, including
# failures.
#
my @tests = (
	# Tenka Gyoza ("MG93+742 Chuo-ku, 542-0071, Osaka-fu")
	'8Q6QMG93+742,34.6685209,135.499779,MG93+742',
	# 3970 Powell Road ("RRPP+CJF Huber Heights, 45424, Ohio")
	'86FQRRPP+CJF,39.858732,-84.1832896,RRPP+CJF',
	# Kinkaku-ji ("2PQH+R9 Kita-ku, 603-8361, Kyoto-fu")
	'8Q7Q2PQH+R9,35.0395227,135.7273061,2PQH+R9',
	# Kyoto Station ("XQP5+ Shimogyo-ku, 600-0000, Kyoto-fu")
	'8Q6QXQP5+,34.9992261,135.7422907,XQP5+',
	# reference in lat+1 (8Q7Q2Q69+M6 == "Kyoto City Hall")
	'8Q6QXQP5+,35.0116875,135.7680625,XQP5+',
	# can be a full 0.5 degrees away (8Q7QFV64+QW == "Wakasa City Hall")
	'8Q6QXQP5+,35.4619283,135.8572769,XQP5+',
);

plan tests => @tests + 0;

foreach (@tests) {
	my ($code,$lat,$lon,$short) = split(/,/);
	my $code2 = recover_nearest($short,$lat,$lon);
	ok ($code eq $code2,
		"recover_nearest('$code',$lat,$lon): $code == $code2");
}
