package Locale::CLDR::Sr;
# This file auto generated from Data\common\main\sr.xml
#	on Thu  2 Oct  1:44:19 pm GMT
# XML file generated 2014-08-14 15:10:07 -0500 (Thu, 14 Aug 2014)

use version;

our $VERSION = version->declare('v0.26.0');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => 'ArrayRef',
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal-masculine','spellout-cardinal-neuter','spellout-cardinal-feminine','spellout-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => 'HashRef',
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'ordi' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(и),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' и =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' и =%spellout-ordinal=),
				},
			},
		},
		'ordti' => {
			'private' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ти),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
				'max' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(' =%spellout-ordinal=),
				},
			},
		},
		'spellout-cardinal-feminine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(једна),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(две),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-masculine' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(један),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(три),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четири),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пет),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шест),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седам),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осам),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девет),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десет),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(једанаест),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаест),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаест),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четрнаест),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаест),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаест),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седамнаест),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осамнаест),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаест),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-cardinal-neuter' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нула),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← кома →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(једно),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(два),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет[ и →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет[ и →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет[ и →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет[ и →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет[ и →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет[ и →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет[ и →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет[ и →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста[ →→]),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста[ →→]),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљаду[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←%spellout-cardinal-feminine← хиљада[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(←%spellout-cardinal-masculine← милион[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←%spellout-cardinal-masculine← милијарда[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←%spellout-cardinal-masculine← билион[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←%spellout-cardinal-masculine← билијарда[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal-masculine=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,###0.#=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(минус →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(нулти),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(први),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(други),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(трећи),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(четврти),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(пети),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(шести),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(седми),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(осми),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(девети),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(десети),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(једанаести),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(дванаести),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(тринаести),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(четрнаести),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(петнаести),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(шеснаести),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(седамнаести),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(осамнаести),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(деветнаести),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(двадесет→%%ordi→),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(тридесет→%%ordi→),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(четрдесет→%%ordi→),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(педесет→%%ordi→),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(шездесет→%%ordi→),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(седамдесет→%%ordi→),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(осамдесет→%%ordi→),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(деведесет→%%ordi→),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(сто→%%ordti→),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(двеста→%%ordti→),
				},
				'300' => {
					base_value => q(300),
					divisor => q(100),
					rule => q(триста→%%ordti→),
				},
				'400' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто→%%ordti→),
				},
				'max' => {
					base_value => q(400),
					divisor => q(100),
					rule => q(←%spellout-cardinal-feminine←сто→%%ordti→),
				},
			},
		},
	} },
);

# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'Афарски',
 				'ab' => 'абхаски',
 				'ace' => 'Ачинески',
 				'ach' => 'Аколи',
 				'ada' => 'Адангмејски',
 				'ady' => 'Адигејски',
 				'ae' => 'Авестански',
 				'af' => 'африканс',
 				'afh' => 'Африхили',
 				'agq' => 'агем',
 				'ain' => 'Аину',
 				'ak' => 'акан',
 				'akk' => 'Акадијски',
 				'ale' => 'Аљут',
 				'alt' => 'Јужни алтаи',
 				'am' => 'амхарски',
 				'an' => 'Арагонежански',
 				'ang' => 'Староенглески',
 				'anp' => 'Ангика',
 				'ar' => 'арапски',
 				'ar_001' => 'модеран стандардни арапски',
 				'arc' => 'Армајски',
 				'arn' => 'мапуче',
 				'arp' => 'Арапахо',
 				'arw' => 'Аравак',
 				'as' => 'асамски',
 				'asa' => 'асу',
 				'ast' => 'Астуријски',
 				'av' => 'Аварски',
 				'awa' => 'Авадхи',
 				'ay' => 'Ајмара',
 				'az' => 'азербејџански',
 				'az@alt=short' => 'азерски',
 				'ba' => 'башкирски',
 				'bal' => 'Балучи',
 				'ban' => 'Балинезијски',
 				'bas' => 'Баса',
 				'be' => 'белоруски',
 				'bej' => 'Беја',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'бугарски',
 				'bho' => 'Бојпури',
 				'bi' => 'Бислама',
 				'bik' => 'Бикол',
 				'bin' => 'Бини',
 				'bla' => 'Сисика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгалски',
 				'bo' => 'тибетански',
 				'br' => 'бретонски',
 				'bra' => 'Брај',
 				'brx' => 'бодо',
 				'bs' => 'босански',
 				'bua' => 'Буриат',
 				'bug' => 'Бугинежански',
 				'byn' => 'Блин',
 				'ca' => 'каталонски',
 				'cad' => 'Кадо',
 				'car' => 'Карипски',
 				'cch' => 'Атсамски',
 				'ce' => 'Чеченски',
 				'ceb' => 'Цебуано',
 				'cgg' => 'чига',
 				'ch' => 'Чаморо',
 				'chb' => 'Чибча',
 				'chg' => 'Чагатаи',
 				'chk' => 'Чукески',
 				'chm' => 'Мари',
 				'chn' => 'Чинукски',
 				'cho' => 'Чоктавски',
 				'chp' => 'Чипвијански',
 				'chr' => 'чероки',
 				'chy' => 'Чејенски',
 				'ckb' => 'сорани курдски',
 				'co' => 'корзикански',
 				'cop' => 'Коптски',
 				'cr' => 'Кри',
 				'crh' => 'Кримеански турски',
 				'cs' => 'чешки',
 				'csb' => 'Кашубијански',
 				'cu' => 'Старословенски',
 				'cv' => 'Чувашки',
 				'cy' => 'велшки',
 				'da' => 'дански',
 				'dak' => 'Дакота',
 				'dar' => 'Даргва',
 				'dav' => 'таита',
 				'de' => 'немачки',
 				'de_CH' => 'швајцарски високи немачки',
 				'del' => 'Делавер',
 				'den' => 'Славски',
 				'dgr' => 'Догриб',
 				'din' => 'Динка',
 				'dje' => 'зарма',
 				'doi' => 'Догри',
 				'dsb' => 'доњи лужичкосрпски',
 				'dua' => 'дуала',
 				'dum' => 'Средњи холандски',
 				'dv' => 'Дивехијски',
 				'dyo' => 'џола фоњи',
 				'dyu' => 'Ђула',
 				'dz' => 'џонга',
 				'ebu' => 'ембу',
 				'ee' => 'еве',
 				'efi' => 'Ефикски',
 				'egy' => 'Староегипатски',
 				'eka' => 'Екајук',
 				'el' => 'грчки',
 				'elx' => 'Еламитски',
 				'en' => 'енглески',
 				'en_GB@alt=short' => 'енглески (УК)',
 				'en_US@alt=short' => 'енглески (САД)',
 				'enm' => 'Средњи енглески',
 				'eo' => 'есперанто',
 				'es' => 'шпански',
 				'et' => 'естонски',
 				'eu' => 'баскијски',
 				'ewo' => 'Евондо',
 				'fa' => 'персијски',
 				'fan' => 'Фанг',
 				'fat' => 'Фанти',
 				'ff' => 'Фулах',
 				'fi' => 'фински',
 				'fil' => 'филипински',
 				'fj' => 'фиџијски',
 				'fo' => 'фарски',
 				'fon' => 'Фон',
 				'fr' => 'француски',
 				'frm' => 'Средњи француски',
 				'fro' => 'Старофранцуски',
 				'frr' => 'Северно-фризијски',
 				'frs' => 'Источни фризијски',
 				'fur' => 'Фриулијски',
 				'fy' => 'западни фризијски',
 				'ga' => 'ирски',
 				'gaa' => 'Га',
 				'gag' => 'гагауз',
 				'gay' => 'Гајо',
 				'gba' => 'Гбаја',
 				'gd' => 'Шкотски Галски',
 				'gez' => 'Џиз',
 				'gil' => 'Гилбертшки',
 				'gl' => 'галицијски',
 				'gmh' => 'Средњи високи немачки',
 				'gn' => 'гварани',
 				'goh' => 'Старонемачки',
 				'gon' => 'Гонди',
 				'gor' => 'Горонтало',
 				'got' => 'Готски',
 				'grb' => 'Гребо',
 				'grc' => 'Старогрчки',
 				'gsw' => 'Швајцарски немачки',
 				'gu' => 'гуџарати',
 				'guz' => 'гуси',
 				'gv' => 'Манкс',
 				'gwi' => 'Гвич’ин',
 				'ha' => 'хауса',
 				'hai' => 'Хаида',
 				'haw' => 'хавајски',
 				'he' => 'хебрејски',
 				'hi' => 'хинди',
 				'hil' => 'Хилигајнон',
 				'hit' => 'Хитите',
 				'hmn' => 'Хмонг',
 				'ho' => 'Хири Моту',
 				'hr' => 'хрватски',
 				'hsb' => 'горњи лужичкосрпски',
 				'ht' => 'Хаитски',
 				'hu' => 'мађарски',
 				'hup' => 'Хупа',
 				'hy' => 'јерменски',
 				'hz' => 'Хереро',
 				'ia' => 'Интерлингва',
 				'iba' => 'Ибан',
 				'id' => 'индонежански',
 				'ie' => 'Међујезички',
 				'ig' => 'игбо',
 				'ii' => 'сечуан ји',
 				'ik' => 'Унупиак',
 				'ilo' => 'Илоко',
 				'inh' => 'Ингвишки',
 				'io' => 'Идо',
 				'is' => 'исландски',
 				'it' => 'италијански',
 				'iu' => 'инуктитут',
 				'ja' => 'јапански',
 				'jbo' => 'Лојбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачаме',
 				'jpr' => 'Јудео-персијски',
 				'jrb' => 'Јудео-арапски',
 				'jv' => 'јавански',
 				'ka' => 'грузијски',
 				'kaa' => 'Кара-калпашки',
 				'kab' => 'кабиле',
 				'kac' => 'Качин',
 				'kaj' => 'Ђу',
 				'kam' => 'камба',
 				'kaw' => 'Кави',
 				'kbd' => 'Кабардијски',
 				'kcg' => 'Тјап',
 				'kde' => 'маконде',
 				'kea' => 'зеленортски креолски',
 				'kfo' => 'Коро',
 				'kg' => 'Конго',
 				'kha' => 'Каси',
 				'kho' => 'Котанешки',
 				'khq' => 'којра чиини',
 				'ki' => 'кикују',
 				'kj' => 'Куањама',
 				'kk' => 'казашки',
 				'kl' => 'калалисут',
 				'kln' => 'каленџин',
 				'km' => 'кмерски',
 				'kmb' => 'Кимбунду',
 				'kn' => 'канада',
 				'ko' => 'корејски',
 				'koi' => 'коми-пермски',
 				'kok' => 'конкани',
 				'kos' => 'Косреански',
 				'kpe' => 'Кпеле',
 				'kr' => 'Канури',
 				'krc' => 'Карачај-балкар',
 				'kri' => 'Крио',
 				'krl' => 'Карелијски',
 				'kru' => 'Курукх',
 				'ks' => 'кашмирски',
 				'ksb' => 'шамбала',
 				'ksf' => 'бафија',
 				'ku' => 'курдски',
 				'kum' => 'Кумик',
 				'kut' => 'Кутенаи',
 				'kv' => 'Коми',
 				'kw' => 'корнволски',
 				'ky' => 'киргиски',
 				'la' => 'латински',
 				'lad' => 'Ладино',
 				'lag' => 'ланги',
 				'lah' => 'Ланда',
 				'lam' => 'Ламба',
 				'lb' => 'луксембуршки',
 				'lez' => 'Лезгиан',
 				'lg' => 'ганда',
 				'li' => 'Лимбургиш',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаошки',
 				'lol' => 'Монго',
 				'loz' => 'Лози',
 				'lt' => 'литвански',
 				'lu' => 'луба-катанга',
 				'lua' => 'Луба-лулуа',
 				'lui' => 'Луисено',
 				'lun' => 'Лунда',
 				'luo' => 'луо',
 				'lus' => 'Лушаи',
 				'luy' => 'лујиа',
 				'lv' => 'летонски',
 				'mad' => 'Мадурешки',
 				'mag' => 'Магахи',
 				'mai' => 'Маитили',
 				'mak' => 'Макасар',
 				'man' => 'Мандинго',
 				'mas' => 'масаи',
 				'mdf' => 'Мокша',
 				'mdr' => 'Мандар',
 				'men' => 'Менде',
 				'mer' => 'меру',
 				'mfe' => 'морисјен',
 				'mg' => 'малгашки',
 				'mga' => 'Средњи ирски',
 				'mgh' => 'макува-меето',
 				'mgo' => 'мета',
 				'mh' => 'Маршалски',
 				'mi' => 'маорски',
 				'mic' => 'Микмак',
 				'min' => 'Минангкабау',
 				'mk' => 'македонски',
 				'ml' => 'малајалам',
 				'mn' => 'монголски',
 				'mnc' => 'Манчу',
 				'mni' => 'Манипури',
 				'moh' => 'мохок',
 				'mos' => 'Моси',
 				'mr' => 'марати',
 				'ms' => 'малајски',
 				'mt' => 'малтешки',
 				'mua' => 'мунданг',
 				'mul' => 'Више језика',
 				'mus' => 'Кришки',
 				'mwl' => 'Мирандешки',
 				'mwr' => 'Марвари',
 				'my' => 'бурмански',
 				'myv' => 'Ерзија',
 				'na' => 'Науру',
 				'nap' => 'Неаполитански',
 				'naq' => 'нама',
 				'nb' => 'норвешки бокмал',
 				'nd' => 'северни ндебеле',
 				'nds' => 'Ниски немачки',
 				'ne' => 'непалски',
 				'new' => 'Невари',
 				'ng' => 'Ндонга',
 				'nia' => 'Ниас',
 				'niu' => 'Ниуеан',
 				'nl' => 'холандски',
 				'nl_BE' => 'фламански',
 				'nmg' => 'квасио',
 				'nn' => 'норвешки нинорск',
 				'no' => 'Норвешки',
 				'nog' => 'Ногаи',
 				'non' => 'Стари норски',
 				'nqo' => 'Н’ко',
 				'nr' => 'Јужни ндебеле',
 				'nso' => 'Северни сото',
 				'nus' => 'нуер',
 				'nv' => 'Навахо',
 				'nwc' => 'Класични невари',
 				'ny' => 'Њања',
 				'nym' => 'Њамвези',
 				'nyn' => 'нјанколе',
 				'nyo' => 'Њоро',
 				'nzi' => 'Нзима',
 				'oc' => 'Провансалски',
 				'oj' => 'Ојибва',
 				'om' => 'оромо',
 				'or' => 'орија',
 				'os' => 'Осетски',
 				'osa' => 'Осаге',
 				'ota' => 'Отомански турски',
 				'pa' => 'панџаби',
 				'pag' => 'Пангасински',
 				'pal' => 'Пахлави',
 				'pam' => 'Пампанга',
 				'pap' => 'Папиаменто',
 				'pau' => 'Палауански',
 				'peo' => 'Староперсијски',
 				'phn' => 'Феничански',
 				'pi' => 'Пали',
 				'pl' => 'пољски',
 				'pon' => 'Понпејски',
 				'pro' => 'Старопровансалски',
 				'ps' => 'паштунски',
 				'ps@alt=variant' => 'пашто',
 				'pt' => 'португалски',
 				'pt_BR' => 'Бразилски португалски',
 				'pt_PT' => 'Иберијски португалски',
 				'qu' => 'кечуа',
 				'quc' => 'к’иче',
 				'raj' => 'Рађастани',
 				'rap' => 'Рапануи',
 				'rar' => 'Раротонган',
 				'rm' => 'рето-романски',
 				'rn' => 'рунди',
 				'ro' => 'румунски',
 				'ro_MD' => 'молдавски',
 				'rof' => 'ромбо',
 				'rom' => 'Романи',
 				'root' => 'Рут',
 				'ru' => 'руски',
 				'rup' => 'Ароманијски',
 				'rw' => 'кинјаруанда',
 				'rwk' => 'руа',
 				'sa' => 'санскрит',
 				'sad' => 'Сандаве',
 				'sah' => 'Јакут',
 				'sam' => 'Самаритански арамејски',
 				'saq' => 'самбуру',
 				'sas' => 'Сасак',
 				'sat' => 'Сантали',
 				'sbp' => 'сангу',
 				'sc' => 'Сардињаски',
 				'scn' => 'Сицилијански',
 				'sco' => 'Шкотски',
 				'sd' => 'синди',
 				'se' => 'северни сами',
 				'seh' => 'сена',
 				'sel' => 'Селкап',
 				'ses' => 'којраборо сени',
 				'sg' => 'санго',
 				'sga' => 'Староирски',
 				'sh' => 'Српскохрватски',
 				'shi' => 'ташелхит',
 				'shn' => 'Шан',
 				'si' => 'синхалски',
 				'sid' => 'Сидамо',
 				'sk' => 'словачки',
 				'sl' => 'словеначки',
 				'sm' => 'Самоански',
 				'sma' => 'јужни сами',
 				'smj' => 'луле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'Сонинке',
 				'so' => 'сомалски',
 				'sog' => 'Соџијенски',
 				'sq' => 'албански',
 				'sr' => 'српски',
 				'srn' => 'Сранански тонго',
 				'srr' => 'Серер',
 				'ss' => 'Свати',
 				'st' => 'Сесото',
 				'su' => 'судански',
 				'suk' => 'Сукума',
 				'sus' => 'Сусу',
 				'sux' => 'Сумерски',
 				'sv' => 'шведски',
 				'sw' => 'свахили',
 				'swb' => 'Коморски',
 				'swc' => 'конго свахили',
 				'syc' => 'Класични сиријски',
 				'syr' => 'Сиријски',
 				'ta' => 'тамилски',
 				'te' => 'телугу',
 				'tem' => 'Тимне',
 				'teo' => 'тесо',
 				'ter' => 'Терено',
 				'tet' => 'Тетум',
 				'tg' => 'Тађик',
 				'th' => 'тајландски',
 				'ti' => 'тигриња',
 				'tig' => 'Тигре',
 				'tiv' => 'Тив',
 				'tk' => 'туркменски',
 				'tkl' => 'Токелау',
 				'tl' => 'Тагалски',
 				'tlh' => 'Клингонски',
 				'tli' => 'Тлингит',
 				'tmh' => 'Тамашек',
 				'tn' => 'Тсвана',
 				'to' => 'тонга',
 				'tog' => 'Њаса тонга',
 				'tpi' => 'Ток Писин',
 				'tr' => 'турски',
 				'ts' => 'Тсонга',
 				'tsi' => 'Тсимшиан',
 				'tt' => 'татарски',
 				'tum' => 'Тумбука',
 				'tvl' => 'Тувалу',
 				'tw' => 'Тви',
 				'twq' => 'тасавак',
 				'ty' => 'Тахићански',
 				'tyv' => 'Тувинијски',
 				'tzm' => 'централноатласки тамазигт',
 				'udm' => 'Удмурт',
 				'ug' => 'ујгурски',
 				'uga' => 'Угаритски',
 				'uk' => 'украјински',
 				'umb' => 'Умбунду',
 				'und' => 'непознат језик',
 				'ur' => 'урду',
 				'uz' => 'узбечки',
 				'vai' => 'ваи',
 				've' => 'Венда',
 				'vi' => 'вијетнамски',
 				'vo' => 'Волапук',
 				'vot' => 'Вотски',
 				'vun' => 'вунџо',
 				'wa' => 'Валун',
 				'wal' => 'Валамо',
 				'war' => 'Варај',
 				'was' => 'Вашо',
 				'wo' => 'волоф',
 				'xal' => 'Калмик',
 				'xh' => 'коса',
 				'xog' => 'сога',
 				'yao' => 'Јао',
 				'yap' => 'Јапешки',
 				'yi' => 'Јидиш',
 				'yo' => 'јоруба',
 				'yue' => 'Кантонски',
 				'za' => 'Жуанг',
 				'zap' => 'Запотечки',
 				'zbl' => 'Блисимболи',
 				'zen' => 'Зенага',
 				'zgh' => 'стандардни марокански тамазигт',
 				'zh' => 'кинески',
 				'zu' => 'зулу',
 				'zun' => 'Зуни',
 				'zxx' => 'без лингвистичког садржаја',
 				'zza' => 'Заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'арапско писмо',
 			'Arab@alt=variant' => 'персијско-арапско писмо',
 			'Armi' => 'империјско арамејско писмо',
 			'Armn' => 'јерменско писмо',
 			'Avst' => 'авестанско писмо',
 			'Bali' => 'балијско писмо',
 			'Batk' => 'батак писмо',
 			'Beng' => 'бенгалско писмо',
 			'Blis' => 'блисимболично писмо',
 			'Bopo' => 'бопомофо писмо',
 			'Brah' => 'браманско писмо',
 			'Brai' => 'Брајево писмо',
 			'Bugi' => 'бугинско писмо',
 			'Buhd' => 'бухидско писмо',
 			'Cakm' => 'чакманско писмо',
 			'Cans' => 'уједињени канадски абориџински силабици',
 			'Cari' => 'каријско писмо',
 			'Cham' => 'чамско писмо',
 			'Cher' => 'Чероки',
 			'Cirt' => 'цирт писмо',
 			'Copt' => 'коптичко писмо',
 			'Cprt' => 'кипарско писмо',
 			'Cyrl' => 'ћирилица',
 			'Cyrs' => 'Старословенска црквена ћирилица',
 			'Deva' => 'деванагари',
 			'Dsrt' => 'Дезерет',
 			'Egyd' => 'египатско народно писмо',
 			'Egyh' => 'египатско хијератско писмо',
 			'Egyp' => 'египатски хијероглифи',
 			'Ethi' => 'етиопско писмо',
 			'Geok' => 'грузијско кхутсури писмо',
 			'Geor' => 'грузијско писмо',
 			'Glag' => 'глагољица',
 			'Goth' => 'Готика',
 			'Grek' => 'грчко писмо',
 			'Gujr' => 'гуџаратско писмо',
 			'Guru' => 'гурмуки писмо',
 			'Hang' => 'хангул',
 			'Hani' => 'хан',
 			'Hano' => 'хануно',
 			'Hans' => 'поједностављено кинеско писмо',
 			'Hans@alt=stand-alone' => 'поједностављено хан писмо',
 			'Hant' => 'традиционално кинеско писмо',
 			'Hant@alt=stand-alone' => 'традиционално хан писмо',
 			'Hebr' => 'хебрејско писмо',
 			'Hira' => 'хирагана',
 			'Hmng' => 'пахав хмонг писмо',
 			'Hrkt' => 'Катакана или Хирагана',
 			'Hung' => 'старомађарско писмо',
 			'Inds' => 'индушко писмо',
 			'Ital' => 'стари италик',
 			'Java' => 'јаванско писмо',
 			'Jpan' => 'јапанско писмо',
 			'Kali' => 'кајах-ли писмо',
 			'Kana' => 'катакана',
 			'Khar' => 'карошти писмо',
 			'Khmr' => 'кмерско писмо',
 			'Knda' => 'канада писмо',
 			'Kore' => 'корејско писмо',
 			'Kthi' => 'каити',
 			'Lana' => 'ланна писмо',
 			'Laoo' => 'лаошко писмо',
 			'Latf' => 'латиница (фрактур варијанта)',
 			'Latg' => 'галска латиница',
 			'Latn' => 'латиница',
 			'Lepc' => 'лепча писмо',
 			'Limb' => 'лимбу писмо',
 			'Lina' => 'линеарно А писмо',
 			'Linb' => 'линеарно Б писмо',
 			'Lyci' => 'лисијско писмо',
 			'Lydi' => 'лидијско писмо',
 			'Mand' => 'мандеанско писмо',
 			'Mani' => 'манихејско писмо',
 			'Maya' => 'мајански хијероглифи',
 			'Mero' => 'мероитик писмо',
 			'Mlym' => 'малајалам писмо',
 			'Mong' => 'монголско писмо',
 			'Moon' => 'месечево писмо',
 			'Mtei' => 'меитеи мајек писмо',
 			'Mymr' => 'мијанмарско писмо',
 			'Nkoo' => 'н’ко писмо',
 			'Ogam' => 'огамско писмо',
 			'Olck' => 'ол чики писмо',
 			'Orkh' => 'орконско писмо',
 			'Orya' => 'оријанско писмо',
 			'Osma' => 'осмањанско писмо',
 			'Perm' => 'старо пермикско писмо',
 			'Phag' => 'пагс-па писмо',
 			'Phli' => 'писани пахлави',
 			'Phlp' => 'псалтер пахлави',
 			'Phlv' => 'пахлави писмо',
 			'Phnx' => 'Феничанско писмо',
 			'Plrd' => 'поралд фонетско писмо',
 			'Prti' => 'писани партиан',
 			'Rjng' => 'рејанг писмо',
 			'Roro' => 'ронгоронго писмо',
 			'Runr' => 'рунско писмо',
 			'Samr' => 'самаританско писмо',
 			'Sara' => 'сарати писмо',
 			'Saur' => 'саураштра писмо',
 			'Sgnw' => 'знаковно писмо',
 			'Shaw' => 'шавијанско писмо',
 			'Sinh' => 'синхалско писмо',
 			'Sund' => 'суданско писмо',
 			'Sylo' => 'силоти нагри писмо',
 			'Syrc' => 'сиријско писмо',
 			'Syre' => 'сиријско естрангело писмо',
 			'Syrj' => 'западносиријско писмо',
 			'Syrn' => 'писмо источне Сирије',
 			'Tagb' => 'тагбанва писмо',
 			'Tale' => 'таи ле писмо',
 			'Talu' => 'нови таи луе',
 			'Taml' => 'тамилско писмо',
 			'Tavt' => 'таи виет писмо',
 			'Telu' => 'телугу писмо',
 			'Teng' => 'тенгвар писмо',
 			'Tfng' => 'тифинаг писмо',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'тхана писмо',
 			'Thai' => 'тајландско писмо',
 			'Tibt' => 'тибетанско писмо',
 			'Ugar' => 'угаритско писмо',
 			'Vaii' => 'ваи писмо',
 			'Visp' => 'видљиви говор',
 			'Xpeo' => 'староперсијско писмо',
 			'Xsux' => 'сумерско-акадско кунеиформ писмо',
 			'Yiii' => 'ји писмо',
 			'Zinh' => 'наследно писмо',
 			'Zmth' => 'математичка нотација',
 			'Zsym' => 'симболи',
 			'Zxxx' => 'неписани језик',
 			'Zyyy' => 'заједничко писмо',
 			'Zzzz' => 'непознато писмо',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'свет',
 			'002' => 'Африка',
 			'003' => 'Северноамерички континент',
 			'005' => 'Јужна Америка',
 			'009' => 'Океанија',
 			'011' => 'Западна Африка',
 			'013' => 'Централна Америка',
 			'014' => 'Источна Африка',
 			'015' => 'Северна Африка',
 			'017' => 'Централна Африка',
 			'018' => 'Јужна Африка',
 			'019' => 'Северна и Јужна Америка',
 			'021' => 'Северна Америка',
 			'029' => 'Кариби',
 			'030' => 'Источна Азија',
 			'034' => 'Јужна Азија',
 			'035' => 'Југоисточна Азија',
 			'039' => 'Јужна Европа',
 			'053' => 'Аустралија и Нови Зеланд',
 			'054' => 'Меланезија',
 			'057' => 'Микронезијски регион',
 			'061' => 'Полинезија',
 			'142' => 'Азија',
 			'143' => 'Централна Азија',
 			'145' => 'Западна Азија',
 			'150' => 'Европа',
 			'151' => 'Источна Европа',
 			'154' => 'Северна Европа',
 			'155' => 'Западна Европа',
 			'419' => 'Латинска Америка',
 			'AC' => 'Острво Асенсион',
 			'AD' => 'Андора',
 			'AE' => 'Уједињени Арапски Емирати',
 			'AF' => 'Авганистан',
 			'AG' => 'Антигва и Барбуда',
 			'AI' => 'Ангвила',
 			'AL' => 'Албанија',
 			'AM' => 'Јерменија',
 			'AN' => 'Холандски Антили',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктик',
 			'AR' => 'Аргентина',
 			'AS' => 'Америчка Самоа',
 			'AT' => 'Аустрија',
 			'AU' => 'Аустралија',
 			'AW' => 'Аруба',
 			'AX' => 'Оландска острва',
 			'AZ' => 'Азербејџан',
 			'BA' => 'Босна и Херцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Белгија',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Бугарска',
 			'BH' => 'Бахреин',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Свети Бартоломеј',
 			'BM' => 'Бермуда',
 			'BN' => 'Брунеј',
 			'BO' => 'Боливија',
 			'BQ' => 'Карипска Холандија',
 			'BR' => 'Бразил',
 			'BS' => 'Бахами',
 			'BT' => 'Бутан',
 			'BV' => 'Острво Буве',
 			'BW' => 'Боцвана',
 			'BY' => 'Белорусија',
 			'BZ' => 'Белизе',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Келинг) Острва',
 			'CD' => 'Конго - Киншаса',
 			'CD@alt=variant' => 'Конго (ДРК)',
 			'CF' => 'Централноафричка Република',
 			'CG' => 'Конго - Бразавил',
 			'CG@alt=variant' => 'Конго (Република)',
 			'CH' => 'Швајцарска',
 			'CI' => 'Обала Слоноваче',
 			'CK' => 'Кукова Острва',
 			'CL' => 'Чиле',
 			'CM' => 'Камерун',
 			'CN' => 'Кина',
 			'CO' => 'Колумбија',
 			'CP' => 'Острво Клипертон',
 			'CR' => 'Костарика',
 			'CU' => 'Куба',
 			'CV' => 'Зеленортска Острва',
 			'CW' => 'Курасао',
 			'CX' => 'Божићно острво',
 			'CY' => 'Кипар',
 			'CZ' => 'Чешка',
 			'DE' => 'Немачка',
 			'DG' => 'Дијего Гарсија',
 			'DJ' => 'Џибути',
 			'DK' => 'Данска',
 			'DM' => 'Доминика',
 			'DO' => 'Доминиканска Република',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута и Мелиља',
 			'EC' => 'Еквадор',
 			'EE' => 'Естонија',
 			'EG' => 'Египат',
 			'EH' => 'Западна Сахара',
 			'ER' => 'Еритреја',
 			'ES' => 'Шпанија',
 			'ET' => 'Етиопија',
 			'EU' => 'Европска Унија',
 			'FI' => 'Финска',
 			'FJ' => 'Фиџи',
 			'FK' => 'Фокландска острва',
 			'FK@alt=variant' => 'Фокландска (Малвинска) острва',
 			'FM' => 'Микронезија',
 			'FO' => 'Фарска Острва',
 			'FR' => 'Француска',
 			'GA' => 'Габон',
 			'GB' => 'Велика Британија',
 			'GB@alt=short' => 'УК',
 			'GD' => 'Гренада',
 			'GE' => 'Грузија',
 			'GF' => 'Француска Гвајана',
 			'GG' => 'Гурнси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамбија',
 			'GN' => 'Гвинеја',
 			'GP' => 'Гваделупе',
 			'GQ' => 'Екваторијална Гвинеја',
 			'GR' => 'Грчка',
 			'GS' => 'Јужна Џорџија и Јужна Сендвич Острва',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинеја-Бисао',
 			'GY' => 'Гвајана',
 			'HK' => 'Хонг Конг С. А. Р. Кина',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Острва Херд и Мекдоналд',
 			'HN' => 'Хондурас',
 			'HR' => 'Хрватска',
 			'HT' => 'Хаити',
 			'HU' => 'Мађарска',
 			'IC' => 'Канарска острва',
 			'ID' => 'Индонезија',
 			'IE' => 'Ирска',
 			'IL' => 'Израел',
 			'IM' => 'Острво Ман',
 			'IN' => 'Индија',
 			'IO' => 'Британска територија у Индијском океану',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Италија',
 			'JE' => 'Џерси',
 			'JM' => 'Јамајка',
 			'JO' => 'Јордан',
 			'JP' => 'Јапан',
 			'KE' => 'Кенија',
 			'KG' => 'Киргистан',
 			'KH' => 'Камбоџа',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморска Острва',
 			'KN' => 'Сент Китс и Невис',
 			'KP' => 'Северна Кореја',
 			'KR' => 'Јужна Кореја',
 			'KW' => 'Кувајт',
 			'KY' => 'Кајманска Острва',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Либан',
 			'LC' => 'Света Луција',
 			'LI' => 'Лихтенштајн',
 			'LK' => 'Шри Ланка',
 			'LR' => 'Либерија',
 			'LS' => 'Лесото',
 			'LT' => 'Литванија',
 			'LU' => 'Луксембург',
 			'LV' => 'Летонија',
 			'LY' => 'Либија',
 			'MA' => 'Мароко',
 			'MC' => 'Монако',
 			'MD' => 'Молдавија',
 			'ME' => 'Црна Гора',
 			'MF' => 'Сент Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалска Острва',
 			'MK' => 'Македонија',
 			'MK@alt=variant' => 'Македонија (БЈРМ)',
 			'ML' => 'Мали',
 			'MM' => 'Мијанмар (Бурма)',
 			'MN' => 'Монголија',
 			'MO' => 'САР Макао (Кина)',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Северна Маријанска Острва',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мауританија',
 			'MS' => 'Монсерат',
 			'MT' => 'Малта',
 			'MU' => 'Маурицијус',
 			'MV' => 'Малдиви',
 			'MW' => 'Малави',
 			'MX' => 'Мексико',
 			'MY' => 'Малезија',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибија',
 			'NC' => 'Нова Каледонија',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк Острво',
 			'NG' => 'Нигерија',
 			'NI' => 'Никарагва',
 			'NL' => 'Холандија',
 			'NO' => 'Норвешка',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуе',
 			'NZ' => 'Нови Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француска Полинезија',
 			'PG' => 'Папуа Нова Гвинеја',
 			'PH' => 'Филипини',
 			'PK' => 'Пакистан',
 			'PL' => 'Пољска',
 			'PM' => 'Сен Пјер и Микелон',
 			'PN' => 'Питкерн',
 			'PR' => 'Порторико',
 			'PS' => 'Палестинске територије',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португал',
 			'PW' => 'Палау',
 			'PY' => 'Парагвај',
 			'QA' => 'Катар',
 			'QO' => 'Океанија (удаљена острва)',
 			'RE' => 'Реинион',
 			'RO' => 'Румунија',
 			'RS' => 'Србија',
 			'RU' => 'Русија',
 			'RW' => 'Руанда',
 			'SA' => 'Саудијска Арабија',
 			'SB' => 'Соломонска Острва',
 			'SC' => 'Сејшели',
 			'SD' => 'Судан',
 			'SE' => 'Шведска',
 			'SG' => 'Сингапур',
 			'SH' => 'Света Јелена',
 			'SI' => 'Словенија',
 			'SJ' => 'Свалбард и Јан Мајен',
 			'SK' => 'Словачка',
 			'SL' => 'Сијера Леоне',
 			'SM' => 'Сан Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомалија',
 			'SR' => 'Суринам',
 			'SS' => 'Јужни Судан',
 			'ST' => 'Сао Томе и Принципе',
 			'SV' => 'Салвадор',
 			'SX' => 'Свети Мартин',
 			'SY' => 'Сирија',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан да Куња',
 			'TC' => 'Острва Туркс и Каикос',
 			'TD' => 'Чад',
 			'TF' => 'Француске Јужне Територије',
 			'TG' => 'Того',
 			'TH' => 'Тајланд',
 			'TJ' => 'Таџикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Источни Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турска',
 			'TT' => 'Тринидад и Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тајван',
 			'TZ' => 'Танзанија',
 			'UA' => 'Украјина',
 			'UG' => 'Уганда',
 			'UM' => 'Удаљена острва САД',
 			'US' => 'Сједињене Америчке Државе',
 			'US@alt=short' => 'САД',
 			'UY' => 'Уругвај',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент Винсент и Гренадини',
 			'VE' => 'Венецуела',
 			'VG' => 'Британска Девичанска Острва',
 			'VI' => 'Америчка Девичанска Острва',
 			'VN' => 'Вијетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Валис и Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Јемен',
 			'YT' => 'Мајот',
 			'ZA' => 'Јужноафричка Република',
 			'ZM' => 'Замбија',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Непознат регион',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'1901' => 'Традиционална немачка ортографија',
 			'1994' => 'Стандарднизована ресијанска ортографија',
 			'1996' => 'Немачка ортографија из 1996',
 			'1606NICT' => 'Француски из касног средњег века до 1606.',
 			'1694ACAD' => 'Рани модерни француски',
 			'1959ACAD' => 'Академски',
 			'AREVELA' => 'Источни арменијски',
 			'AREVMDA' => 'Западно јерменска',
 			'BAKU1926' => 'Уједињен турски латинични алфабет',
 			'BISKE' => 'Сан Ђорђио/Била дијалект',
 			'BOONT' => 'Бунтлинг',
 			'FONIPA' => 'ИПА фонетика',
 			'FONUPA' => 'УПА фонетика',
 			'KKCOR' => 'Уобичајена ортографија',
 			'LIPAW' => 'Липовички дијалект ресијански',
 			'MONOTON' => 'Монотоник',
 			'NEDIS' => 'Натисоне дијалект',
 			'NJIVA' => 'Гњива/Њива дијалкект',
 			'OSOJS' => 'Осеако/Осојане дијалект',
 			'POLYTON' => 'Политоник',
 			'POSIX' => 'Компјутер',
 			'REVISED' => 'Ревидирана ортографија',
 			'ROZAJ' => 'Ресијан',
 			'SAAHO' => 'Сахо',
 			'SCOTLAND' => 'Шкотски стандардни Енглески',
 			'SCOUSE' => 'Скауз',
 			'SOLBA' => 'Столвица/Солбица дијалект',
 			'TARASK' => 'Тараскијевичка ортографија',
 			'UCCOR' => 'Уједињена ортографија',
 			'UCRCOR' => 'Уједињена ревидирана ортографија',
 			'VALENCIA' => 'Валенцијска',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'календар',
 			'colalternate' => 'Сортирање уз игнорисање симбола',
 			'colbackwards' => 'Сортирање према обрнутим акцентима',
 			'colcasefirst' => 'Ређање према малом/великом слову',
 			'colcaselevel' => 'Сортирање према малом/великом слову',
 			'colhiraganaquaternary' => 'Сортирање према кана симболима',
 			'collation' => 'Сортирање',
 			'colnormalization' => 'Нормализовано сортирање',
 			'colnumeric' => 'Нумеричко сортирање',
 			'colstrength' => 'Сортирање према јачини',
 			'currency' => 'валута',
 			'numbers' => 'бројеви',
 			'timezone' => 'Временска зона',
 			'va' => 'Варијанта локалитета',
 			'variabletop' => 'Сортирај као симболе',
 			'x' => 'Приватна употреба',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{будистички календар},
 				'chinese' => q{кинески календар},
 				'coptic' => q{коптски календар},
 				'dangi' => q{данги календар},
 				'ethiopic' => q{етиопски календар},
 				'ethiopic-amete-alem' => q{етиопски амет алем календар},
 				'gregorian' => q{грегоријански календар},
 				'hebrew' => q{хебрејски календар},
 				'indian' => q{Индијски национални календар},
 				'islamic' => q{исламски календар},
 				'islamic-civil' => q{Исламски цивилни календар},
 				'iso8601' => q{ISO-8601 календар},
 				'japanese' => q{јапански календар},
 				'persian' => q{персијски календар},
 				'roc' => q{календар Републике Кине},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{Сортирај симболе},
 				'shifted' => q{Сортирање уз игнорисање симбола},
 			},
 			'colbackwards' => {
 				'no' => q{Сортирај акценте нормално},
 				'yes' => q{Сортирај акценте обрнуто},
 			},
 			'colcasefirst' => {
 				'lower' => q{Сортирај прво мала слова},
 				'no' => q{Сортирај нормалан редослед великих и малих слова},
 				'upper' => q{Сортирај прво велика слова},
 			},
 			'colcaselevel' => {
 				'no' => q{Сортирај без обзира на велика и мала слова},
 				'yes' => q{Сортирај мала и велика слова},
 			},
 			'colhiraganaquaternary' => {
 				'no' => q{Сортирај кана симболе одвојено},
 				'yes' => q{Сортирај кана симболе другачије},
 			},
 			'collation' => {
 				'big5han' => q{Традиционално кинеско сортирање},
 				'dictionary' => q{Редослед сортирања у речнику},
 				'ducet' => q{Подразумевани Unicode редослед сортирања},
 				'gb2312han' => q{Поједностављено кинеско сортирање},
 				'phonebook' => q{Сортирање као телефонски именик},
 				'phonetic' => q{Фонетски редослед сортирања},
 				'pinyin' => q{Пињин сортирање},
 				'reformed' => q{Реформисани редослед сортирања},
 				'search' => q{претрага опште намене},
 				'searchjl' => q{Претрага према хангул почетном сугласнику},
 				'standard' => q{стандардни редослед сортирања},
 				'stroke' => q{Сортирање по броју црта},
 				'traditional' => q{Традиционално сортирање},
 				'unihan' => q{Редослед сортирања радикалним цртицама},
 			},
 			'colnormalization' => {
 				'no' => q{Сортирај без нормализације},
 				'yes' => q{Сортирај Unicode нормализовано},
 			},
 			'colnumeric' => {
 				'no' => q{Сортирај цифре појединачно},
 				'yes' => q{Сортирај цифре нумерички},
 			},
 			'colstrength' => {
 				'identical' => q{Сортирај све},
 				'primary' => q{Сортирај само основна слова},
 				'quaternary' => q{Сортирај акценте/мала и велика слова/ширину/кана симболе},
 				'secondary' => q{Сортирај акценте},
 				'tertiary' => q{Сортирај акценте/мала и велика слова/ширину},
 			},
 			'numbers' => {
 				'arab' => q{арапско-индијске цифре},
 				'arabext' => q{продужене арапско-индијске цифре},
 				'armn' => q{јерменски бројеви},
 				'armnlow' => q{мали јерменски бројеви},
 				'beng' => q{бенгалске цифре},
 				'deva' => q{девангари цифре},
 				'ethi' => q{етиопски бројеви},
 				'finance' => q{Финансијски бројеви},
 				'fullwide' => q{цифре пуне ширине},
 				'geor' => q{грузијски бројеви},
 				'grek' => q{грчки бројеви},
 				'greklow' => q{мали грчки бројеви},
 				'gujr' => q{гуџаратске цифре},
 				'guru' => q{гурмуки цифре},
 				'hanidec' => q{кинески децимални бројеви},
 				'hans' => q{поједностављени кинески бројеви},
 				'hansfin' => q{поједностављени кинески финансијски бројеви},
 				'hant' => q{традиционални кинески бројеви},
 				'hantfin' => q{традиционални кинески финансијски бројеви},
 				'hebr' => q{хебрејски бројеви},
 				'jpan' => q{јапански бројеви},
 				'jpanfin' => q{јапански финансијски бројеви},
 				'khmr' => q{кмерске цифре},
 				'knda' => q{канада цифре},
 				'laoo' => q{лаошке цифре},
 				'latn' => q{западне цифре},
 				'mlym' => q{малајалам цифре},
 				'mong' => q{монголске цифре},
 				'mymr' => q{мијанмарске цифре},
 				'native' => q{Локалне цифре},
 				'orya' => q{орија цифре},
 				'roman' => q{римски бројеви},
 				'romanlow' => q{мали римски бројеви},
 				'taml' => q{тамилски бројеви},
 				'tamldec' => q{тамилске цифре},
 				'telu' => q{телугу цифре},
 				'thai' => q{тајске цифре},
 				'tibt' => q{тибетанске цифре},
 				'traditional' => q{Традиционални бројеви},
 				'vaii' => q{Ваи цифре},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрички},
 			'UK' => q{УК},
 			'US' => q{САД},

		}
	},
);

has 'display_name_transform_name' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'bgn' => 'БГН (BGN)',
 			'numeric' => 'Нумеричка',
 			'tone' => 'Тон',
 			'ungegn' => 'УНГЕГН (BGN)',
 			'x-accents' => 'Акценти',
 			'x-fullwidth' => 'пуна ширина',
 			'x-halfwidth' => 'пола ширине',
 			'x-jamo' => 'Џамо',
 			'x-pinyin' => 'Пинјин',
 			'x-publishing' => 'Издавачки',

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Језик: {0}',
 			'script' => 'писмо: {0}',
 			'territory' => 'Регион: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[ё й щ ъ ы ь э ю я])},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'],
			main => qr{(?^u:[а б в г д ђ е ж з и ј к л љ м н њ о п р с т ћ у ф х ц ч џ ш])},
			punctuation => qr{(?^u:[\- ‐ – , ; \: ! ? . … ‘ ‚ “ „ ( ) \[ \] \{ \} * #])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Ђ', 'Е', 'Ж', 'З', 'И', 'Ј', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'Ћ', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{„},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'' => q(акери),
						'few' => q({0} акера),
						'one' => q({0} акер),
						'other' => q({0} акера),
					},
					'acre-foot' => {
						'' => q(акер стопе),
						'few' => q({0} акер стопе),
						'one' => q({0} акер стопа),
						'other' => q({0} акер стопа),
					},
					'ampere' => {
						'' => q(ампери),
						'few' => q({0} ампера),
						'one' => q({0} ампер),
						'other' => q({0} ампера),
					},
					'arc-minute' => {
						'' => q(минути),
						'few' => q({0} минута),
						'one' => q({0} минут),
						'other' => q({0} минута),
					},
					'arc-second' => {
						'' => q(секунде),
						'few' => q({0} секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'astronomical-unit' => {
						'' => q(астрономске јединице),
						'few' => q({0} астрономске јединице),
						'one' => q({0} астрономска јединица),
						'other' => q({0} астрономских јединица),
					},
					'bit' => {
						'' => q(битови),
						'few' => q({0} бита),
						'one' => q({0} бит),
						'other' => q({0} битова),
					},
					'byte' => {
						'' => q(бајтови),
						'few' => q({0} бајта),
						'one' => q({0} бајт),
						'other' => q({0} бајтова),
					},
					'calorie' => {
						'' => q(калорије),
						'few' => q({0} калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					'carat' => {
						'' => q(карати),
						'few' => q({0} карата),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'celsius' => {
						'' => q(степени Целзијуса),
						'few' => q({0} степена Целзијуса),
						'one' => q({0} степен Целзијуса),
						'other' => q({0} степени Целзијуса),
					},
					'centiliter' => {
						'' => q(центилитри),
						'few' => q({0} центилитра),
						'one' => q({0} центилитар),
						'other' => q({0} центилитара),
					},
					'centimeter' => {
						'' => q(центиметри),
						'few' => q({0} центиментра),
						'one' => q({0} центиметар),
						'other' => q({0} центиметара),
					},
					'cubic-centimeter' => {
						'' => q(кубни центиметри),
						'few' => q({0} кубна центиметра),
						'one' => q({0} кубни центиметар),
						'other' => q({0} кубних центиметара),
					},
					'cubic-foot' => {
						'' => q(кубне стопе),
						'few' => q({0} кубне стопе),
						'one' => q({0} кубна стопа),
						'other' => q({0} кубних стопа),
					},
					'cubic-inch' => {
						'' => q(кубни инчи),
						'few' => q({0} кубна инча),
						'one' => q({0} кубни инч),
						'other' => q({0} кубних инча),
					},
					'cubic-kilometer' => {
						'' => q(кубни километри),
						'few' => q({0} кубна километра),
						'one' => q({0} кубни километар),
						'other' => q({0} кубних километара),
					},
					'cubic-meter' => {
						'' => q(кубни метри),
						'few' => q({0} кубна метра),
						'one' => q({0} кубни метар),
						'other' => q({0} кубних метара),
					},
					'cubic-mile' => {
						'' => q(кубне миље),
						'few' => q({0} кубне миље),
						'one' => q({0} кубна миља),
						'other' => q({0} кубних миља),
					},
					'cubic-yard' => {
						'' => q(кубни јарди),
						'few' => q({0} кубна јарда),
						'one' => q({0} кубни јард),
						'other' => q({0} кубних јарди),
					},
					'cup' => {
						'' => q(шоље),
						'few' => q({0} шоље),
						'one' => q({0} шоља),
						'other' => q({0} шоља),
					},
					'day' => {
						'' => q(дани),
						'few' => q({0} дана),
						'one' => q({0} дан),
						'other' => q({0} дана),
					},
					'deciliter' => {
						'' => q(децилитри),
						'few' => q({0} децилитра),
						'one' => q({0} децилитар),
						'other' => q({0} децилитара),
					},
					'decimeter' => {
						'' => q(дециметри),
						'few' => q({0} дециметра),
						'one' => q({0} дециметар),
						'other' => q({0} дециметара),
					},
					'degree' => {
						'' => q(степени),
						'few' => q({0} степена),
						'one' => q({0} степен),
						'other' => q({0} степени),
					},
					'fahrenheit' => {
						'' => q(степени Фаренхајта),
						'few' => q({0} степена Фаренхајта),
						'one' => q({0} степен Фаренхајта),
						'other' => q({0} степени Фаренхајта),
					},
					'fluid-ounce' => {
						'' => q(унце течности),
						'few' => q({0} унце течности),
						'one' => q({0} унца течности),
						'other' => q({0} унци течности),
					},
					'foodcalorie' => {
						'' => q(Калорије),
						'few' => q({0} калорије),
						'one' => q({0} калорија),
						'other' => q({0} калорија),
					},
					'foot' => {
						'' => q(стопе),
						'few' => q({0} стопе),
						'one' => q({0} стопа),
						'other' => q({0} стопа),
					},
					'g-force' => {
						'' => q(ге сила),
						'few' => q({0} ге сила),
						'one' => q({0} ге сила),
						'other' => q({0} ге сила),
					},
					'gallon' => {
						'' => q(галони),
						'few' => q({0} галона),
						'one' => q({0} галон),
						'other' => q({0} галона),
					},
					'gigabit' => {
						'' => q(гигабитови),
						'few' => q({0} гигабита),
						'one' => q({0} гигабит),
						'other' => q({0} гигабита),
					},
					'gigabyte' => {
						'' => q(гигабајти),
						'few' => q({0} гигабајта),
						'one' => q({0} гигабајт),
						'other' => q({0} гигабајта),
					},
					'gigahertz' => {
						'' => q(гигахерци),
						'few' => q({0} гигахерца),
						'one' => q({0} гигахерц),
						'other' => q({0} гигахерца),
					},
					'gigawatt' => {
						'' => q(гигавати),
						'few' => q({0} гигавата),
						'one' => q({0} гигават),
						'other' => q({0} гигавати),
					},
					'gram' => {
						'' => q(грами),
						'few' => q({0} грама),
						'one' => q({0} грам),
						'other' => q({0} грама),
					},
					'hectare' => {
						'' => q(хектари),
						'few' => q({0} хектара),
						'one' => q({0} хектар),
						'other' => q({0} хектара),
					},
					'hectoliter' => {
						'' => q(хектолитри),
						'few' => q({0} хектолитра),
						'one' => q({0} хектолитар),
						'other' => q({0} хектолитара),
					},
					'hectopascal' => {
						'' => q(хектопаскали),
						'few' => q({0} хектопаскала),
						'one' => q({0} хектопаскал),
						'other' => q({0} хектопаскала),
					},
					'hertz' => {
						'' => q(херци),
						'few' => q({0} херца),
						'one' => q({0} херц),
						'other' => q({0} херца),
					},
					'horsepower' => {
						'' => q(коњске снаге),
						'few' => q({0} коњске снаге),
						'one' => q({0} коњска снага),
						'other' => q({0} коњских снага),
					},
					'hour' => {
						'' => q({0}/сат),
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
					},
					'inch' => {
						'' => q(инчи),
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'' => q(инчи живиног стуба),
						'few' => q({0} инча живиног стуба),
						'one' => q({0} инч живиног стуба),
						'other' => q({0} инча живиног стуба),
					},
					'joule' => {
						'' => q(џули),
						'few' => q({0} џула),
						'one' => q({0} џул),
						'other' => q({0} џула),
					},
					'karat' => {
						'' => q(карати),
						'few' => q({0} карата),
						'one' => q({0} карат),
						'other' => q({0} карата),
					},
					'kelvin' => {
						'' => q(келвин),
						'few' => q({0} келвина),
						'one' => q({0} келвин),
						'other' => q({0} келвина),
					},
					'kilobit' => {
						'' => q(килобитови),
						'few' => q({0} килобита),
						'one' => q({0} килобит),
						'other' => q({0} килобита),
					},
					'kilobyte' => {
						'' => q(килобајти),
						'few' => q({0} килобајта),
						'one' => q({0} килобајт),
						'other' => q({0} килобајта),
					},
					'kilocalorie' => {
						'' => q(килокалорије),
						'few' => q({0} килокалорије),
						'one' => q({0} килокалорија),
						'other' => q({0} килокалорија),
					},
					'kilogram' => {
						'' => q(килограми),
						'few' => q({0} килограма),
						'one' => q({0} килограм),
						'other' => q({0} килограма),
					},
					'kilohertz' => {
						'' => q(килохерци),
						'few' => q({0} килохерца),
						'one' => q({0} килохерц),
						'other' => q({0} килохерца),
					},
					'kilojoule' => {
						'' => q(килоџули),
						'few' => q({0} килоџула),
						'one' => q({0} килоџул),
						'other' => q({0} килоџула),
					},
					'kilometer' => {
						'' => q(километри),
						'few' => q({0} километра),
						'one' => q({0} километар),
						'other' => q({0} километара),
					},
					'kilometer-per-hour' => {
						'' => q(километри на сат),
						'few' => q({0} километра на сат),
						'one' => q({0} километар на сат),
						'other' => q({0} километара на сат),
					},
					'kilowatt' => {
						'' => q(киловати),
						'few' => q({0} киловата),
						'one' => q({0} киловат),
						'other' => q({0} киловати),
					},
					'kilowatt-hour' => {
						'' => q(киловат-сати),
						'few' => q({0} киловат-сата),
						'one' => q({0} киловат-сат),
						'other' => q({0} киловат-сати),
					},
					'light-year' => {
						'' => q(светлосне године),
						'few' => q({0} светлосне године),
						'one' => q({0} светлосна година),
						'other' => q({0} светлосних година),
					},
					'liter' => {
						'' => q(литри),
						'few' => q({0} литра),
						'one' => q({0} литар),
						'other' => q({0} литара),
					},
					'liter-per-kilometer' => {
						'' => q(литри по километру),
						'few' => q({0} литра по километру),
						'one' => q({0} литар по километру),
						'other' => q({0} литара по километру),
					},
					'lux' => {
						'' => q(лукс),
						'few' => q({0} лукса),
						'one' => q({0} лукс),
						'other' => q({0} лукса),
					},
					'megabit' => {
						'' => q(мегабитови),
						'few' => q({0} мегабита),
						'one' => q({0} мегабит),
						'other' => q({0} мегабита),
					},
					'megabyte' => {
						'' => q(мегабајти),
						'few' => q({0} мегабајта),
						'one' => q({0} мегабајт),
						'other' => q({0} мегабајта),
					},
					'megahertz' => {
						'' => q(мегахерци),
						'few' => q({0} мегахерца),
						'one' => q({0} мегахерц),
						'other' => q({0} мегахерца),
					},
					'megaliter' => {
						'' => q(мегалитри),
						'few' => q({0} мегалитра),
						'one' => q({0} мегалитар),
						'other' => q({0} мегалитара),
					},
					'megawatt' => {
						'' => q(мегавати),
						'few' => q({0} мегавата),
						'one' => q({0} мегават),
						'other' => q({0} мегавати),
					},
					'meter' => {
						'' => q(метри),
						'few' => q({0} метра),
						'one' => q({0} метар),
						'other' => q({0} метара),
					},
					'meter-per-second' => {
						'' => q(метри у секунди),
						'few' => q({0} метра у секунди),
						'one' => q({0} метар у секунди),
						'other' => q({0} метара у секунди),
					},
					'meter-per-second-squared' => {
						'' => q(метри у секунди на квадрат),
						'few' => q({0} метра у секунди на квадрат),
						'one' => q({0} метар у секунди на квадрат),
						'other' => q({0} метара у секунди на квадрат),
					},
					'metric-ton' => {
						'' => q(метричке тоне),
						'few' => q({0} метричке тоне),
						'one' => q({0} метричка тона),
						'other' => q({0} метричких тона),
					},
					'microgram' => {
						'' => q(микрограми),
						'few' => q({0} микрограма),
						'one' => q({0} микрограм),
						'other' => q({0} микрограма),
					},
					'micrometer' => {
						'' => q(микрометри),
						'few' => q({0} микрометра),
						'one' => q({0} микрометар),
						'other' => q({0} микрометара),
					},
					'microsecond' => {
						'' => q(микросекунде),
						'few' => q({0} микросекунде),
						'one' => q({0} микросекунда),
						'other' => q({0} микросекунди),
					},
					'mile' => {
						'' => q(миље),
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-gallon' => {
						'' => q(миља по галону),
						'few' => q({0} миље по галону),
						'one' => q({0} миља по галону),
						'other' => q({0} миља по галону),
					},
					'mile-per-hour' => {
						'' => q(миље на сат),
						'few' => q({0} миље на сат),
						'one' => q({0} миља на сат),
						'other' => q({0} миља на сат),
					},
					'milliampere' => {
						'' => q(милиампери),
						'few' => q({0} милиампера),
						'one' => q({0} милиампер),
						'other' => q({0} милиампера),
					},
					'millibar' => {
						'' => q(милибари),
						'few' => q({0} милибара),
						'one' => q({0} милибар),
						'other' => q({0} милибара),
					},
					'milligram' => {
						'' => q(милиграми),
						'few' => q({0} милиграма),
						'one' => q({0} милиграм),
						'other' => q({0} милиграма),
					},
					'milliliter' => {
						'' => q(милилитри),
						'few' => q({0} милилитра),
						'one' => q({0} милилитар),
						'other' => q({0} милилитара),
					},
					'millimeter' => {
						'' => q(милиметри),
						'few' => q({0} милиметра),
						'one' => q({0} милиметар),
						'other' => q({0} милиметара),
					},
					'millimeter-of-mercury' => {
						'' => q(милиметри живиног стуба),
						'few' => q({0} милиметра живиног стуба),
						'one' => q({0} милиметар живиног стуба),
						'other' => q({0} милиметара живиног стуба),
					},
					'millisecond' => {
						'' => q(милисекунде),
						'few' => q({0} милисекунде),
						'one' => q({0} милисекунда),
						'other' => q({0} милисекунди),
					},
					'milliwatt' => {
						'' => q(миливати),
						'few' => q({0} миливата),
						'one' => q({0} миливат),
						'other' => q({0} миливати),
					},
					'minute' => {
						'' => q(минути),
						'few' => q({0} минута),
						'one' => q({0} минут),
						'other' => q({0} минута),
					},
					'month' => {
						'' => q(месеци),
						'few' => q({0} месеца),
						'one' => q({0} месец),
						'other' => q({0} месеци),
					},
					'nanometer' => {
						'' => q(нанометри),
						'few' => q({0} нанометра),
						'one' => q({0} нанометар),
						'other' => q({0} нанометара),
					},
					'nanosecond' => {
						'' => q(наносекунде),
						'few' => q({0} наносекунде),
						'one' => q({0} наносекунда),
						'other' => q({0} наносекунди),
					},
					'nautical-mile' => {
						'' => q(наутичке миље),
						'few' => q({0} наутичке миље),
						'one' => q({0} наутичка миља),
						'other' => q({0} наутичких миља),
					},
					'ohm' => {
						'' => q(ом),
						'few' => q({0} ома),
						'one' => q({0} ом),
						'other' => q({0} ома),
					},
					'ounce' => {
						'' => q(унце),
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'ounce-troy' => {
						'' => q(фине унце),
						'few' => q({0} фине унце),
						'one' => q({0} фина унца),
						'other' => q({0} финих унци),
					},
					'parsec' => {
						'' => q(парсеци),
						'few' => q({0} парсека),
						'one' => q({0} парсек),
						'other' => q({0} парсека),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'' => q(пикометри),
						'few' => q({0} пикометра),
						'one' => q({0} пикометар),
						'other' => q({0} пикометара),
					},
					'pint' => {
						'' => q(пинте),
						'few' => q({0} пинте),
						'one' => q({0} пинта),
						'other' => q({0} пинти),
					},
					'pound' => {
						'' => q(фунте),
						'few' => q({0} фунте),
						'one' => q({0} фунта),
						'other' => q({0} фунти),
					},
					'pound-per-square-inch' => {
						'' => q(фунте по квадратном инчу),
						'few' => q({0} фунте по квадратном инчу),
						'one' => q({0} фунта по квадратном инчу),
						'other' => q({0} фунти по квадратном инчу),
					},
					'quart' => {
						'' => q(кварти),
						'few' => q({0} кварта),
						'one' => q({0} кварат),
						'other' => q({0} кварата),
					},
					'radian' => {
						'' => q(радијани),
						'few' => q({0} радијана),
						'one' => q({0} радијан),
						'other' => q({0} радијана),
					},
					'second' => {
						'' => q({0}/сек),
						'few' => q({0} секунде),
						'one' => q({0} секунда),
						'other' => q({0} секунди),
					},
					'square-centimeter' => {
						'' => q(квадратни центиметри),
						'few' => q({0} квадратна центиметра),
						'one' => q({0} квадратни центиметар),
						'other' => q({0} квадратних центиметара),
					},
					'square-foot' => {
						'' => q(квадратне стопе),
						'few' => q({0} квадратне стопе),
						'one' => q({0} квадратна стопа),
						'other' => q({0} квадратних стопа),
					},
					'square-inch' => {
						'' => q(квадратни инчи),
						'few' => q({0} квадратна инча),
						'one' => q({0} квадратни инч),
						'other' => q({0} квадратних инча),
					},
					'square-kilometer' => {
						'' => q(квадратни километри),
						'few' => q({0} квадратна километра),
						'one' => q({0} квадратни километар),
						'other' => q({0} квадратних километара),
					},
					'square-meter' => {
						'' => q(квадратни метри),
						'few' => q({0} квадратна метра),
						'one' => q({0} квадратни метар),
						'other' => q({0} квадратних метара),
					},
					'square-mile' => {
						'' => q(квадратне миље),
						'few' => q({0} квадратне миље),
						'one' => q({0} квадратна миља),
						'other' => q({0} квадратних миља),
					},
					'square-yard' => {
						'' => q(квадратни јарди),
						'few' => q({0} квадратна јарда),
						'one' => q({0} квадратни јард),
						'other' => q({0} квадратних јарди),
					},
					'tablespoon' => {
						'' => q(кашике),
						'few' => q({0} кашике),
						'one' => q({0} кашика),
						'other' => q({0} кашика),
					},
					'teaspoon' => {
						'' => q(кашичице),
						'few' => q({0} кашичице),
						'one' => q({0} кашичица),
						'other' => q({0} кашичица),
					},
					'terabit' => {
						'' => q(терабитови),
						'few' => q({0} терабита),
						'one' => q({0} терабит),
						'other' => q({0} терабита),
					},
					'terabyte' => {
						'' => q(терабајти),
						'few' => q({0} терабајта),
						'one' => q({0} терабајт),
						'other' => q({0} терабајта),
					},
					'ton' => {
						'' => q(тоне),
						'few' => q({0} тоне),
						'one' => q({0} тона),
						'other' => q({0} тона),
					},
					'volt' => {
						'' => q(волти),
						'few' => q({0} волта),
						'one' => q({0} волт),
						'other' => q({0} волти),
					},
					'watt' => {
						'' => q(вати),
						'few' => q({0} вата),
						'one' => q({0} ват),
						'other' => q({0} вати),
					},
					'week' => {
						'' => q(недеље),
						'few' => q({0} недеље),
						'one' => q({0} недеља),
						'other' => q({0} недеља),
					},
					'yard' => {
						'' => q(јарди),
						'few' => q({0} јарда),
						'one' => q({0} јард),
						'other' => q({0} јарди),
					},
					'year' => {
						'' => q(године),
						'few' => q({0} године),
						'one' => q({0} година),
						'other' => q({0} година),
					},
				},
				'narrow' => {
					'acre' => {
						'few' => q({0} ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'arc-minute' => {
						'few' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'few' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'' => q(°C),
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'' => q(cm),
						'few' => q({0} cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-kilometer' => {
						'few' => q({0} km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-mile' => {
						'few' => q({0} mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'day' => {
						'' => q(д.),
						'few' => q({0} д),
						'one' => q({0} д),
						'other' => q({0} д),
					},
					'degree' => {
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'few' => q({0}°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'' => q(ft),
						'few' => q({0} ft),
						'one' => q({0} ft),
						'other' => q({0} ft),
					},
					'g-force' => {
						'few' => q({0} G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'' => q(g),
						'few' => q({0} g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'few' => q({0} ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectopascal' => {
						'few' => q({0} hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'' => q(сати),
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
					},
					'inch' => {
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'few' => q({0} inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'' => q(kg),
						'few' => q({0} kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilometer' => {
						'' => q(km),
						'few' => q({0} km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'' => q(km/h),
						'few' => q({0} km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'few' => q({0} kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'light-year' => {
						'few' => q({0} сг),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'' => q(l),
						'few' => q({0} l),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'meter' => {
						'' => q(метар),
						'few' => q({0} m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'few' => q({0} m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'few' => q({0} миље),
						'one' => q({0} миља),
						'other' => q({0} миља),
					},
					'mile-per-hour' => {
						'few' => q({0} mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'millibar' => {
						'few' => q({0} mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'millimeter' => {
						'' => q(mm),
						'few' => q({0} mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millisecond' => {
						'' => q(ms),
						'few' => q({0} ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'' => q(мин),
						'few' => q({0} м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'month' => {
						'' => q(м.),
						'few' => q({0} м),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'ounce' => {
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'few' => q({0} pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pound' => {
						'few' => q({0} lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
					},
					'second' => {
						'' => q(сек),
						'few' => q({0} сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-foot' => {
						'few' => q({0} ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-kilometer' => {
						'few' => q({0} km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'few' => q({0} m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'few' => q({0} mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'watt' => {
						'few' => q({0} W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'' => q(н.),
						'few' => q({0} н),
						'one' => q({0} н),
						'other' => q({0} н),
					},
					'yard' => {
						'few' => q({0} јрд),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					'year' => {
						'' => q(г.),
						'few' => q({0} г),
						'one' => q({0} г),
						'other' => q({0} г),
					},
				},
				'short' => {
					'acre' => {
						'' => q(акери),
						'few' => q({0} ac),
						'one' => q({0} ac),
						'other' => q({0} ac),
					},
					'acre-foot' => {
						'' => q(ac ft),
						'few' => q({0} ac ft),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'' => q(ампери),
						'few' => q({0} A),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'' => q(минути),
						'few' => q({0}′),
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'' => q(секунди),
						'few' => q({0}″),
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'' => q(ај),
						'few' => q({0} ај),
						'one' => q({0} ај),
						'other' => q({0} ај),
					},
					'bit' => {
						'' => q(бит),
						'few' => q({0} b),
						'one' => q({0} b),
						'other' => q({0} b),
					},
					'byte' => {
						'' => q(бајт),
						'few' => q({0} B),
						'one' => q({0} B),
						'other' => q({0} B),
					},
					'calorie' => {
						'' => q(cal),
						'few' => q({0} cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'' => q(карати),
						'few' => q({0} CD),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'' => q(°C),
						'few' => q({0}°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'' => q(cL),
						'few' => q({0} cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'' => q(cm),
						'few' => q({0} cm),
						'one' => q({0} cm),
						'other' => q({0} cm),
					},
					'cubic-centimeter' => {
						'' => q(cm³),
						'few' => q({0} cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
					},
					'cubic-foot' => {
						'' => q(ft³),
						'few' => q({0} ft³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'' => q(in³),
						'few' => q({0} in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'' => q(km³),
						'few' => q({0} km³),
						'one' => q({0} km³),
						'other' => q({0} km³),
					},
					'cubic-meter' => {
						'' => q(m³),
						'few' => q({0} m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
					},
					'cubic-mile' => {
						'' => q(mi³),
						'few' => q({0} mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'' => q(yd³),
						'few' => q({0} yd³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					'cup' => {
						'' => q(шоље),
						'few' => q({0} ш.),
						'one' => q({0} ш.),
						'other' => q({0} ш.),
					},
					'day' => {
						'' => q(д.),
						'few' => q({0} дана),
						'one' => q({0} дан),
						'other' => q({0} дана),
					},
					'deciliter' => {
						'' => q(dL),
						'few' => q({0} dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'' => q(dm),
						'few' => q({0} dm),
						'one' => q({0} dm),
						'other' => q({0} dm),
					},
					'degree' => {
						'' => q(степени),
						'few' => q({0}°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'' => q(степени Фаренхајта),
						'few' => q({0}°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'' => q(fl oz),
						'few' => q({0} fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'' => q(Cal),
						'few' => q({0} Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					'foot' => {
						'' => q(ft),
						'few' => q({0} ft),
						'one' => q({0} ft),
						'other' => q({0} ft),
					},
					'g-force' => {
						'' => q(ге сила),
						'few' => q({0} G),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'' => q(gal),
						'few' => q({0} gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
					},
					'gigabit' => {
						'' => q(Gb),
						'few' => q({0} Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'' => q(GB),
						'few' => q({0} GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'' => q(GHz),
						'few' => q({0} GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'' => q(GW),
						'few' => q({0} GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'' => q(грами),
						'few' => q({0} g),
						'one' => q({0} g),
						'other' => q({0} g),
					},
					'hectare' => {
						'' => q(хектари),
						'few' => q({0} ha),
						'one' => q({0} ha),
						'other' => q({0} ha),
					},
					'hectoliter' => {
						'' => q(hL),
						'few' => q({0} hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'' => q(hPa),
						'few' => q({0} hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'' => q(Hz),
						'few' => q({0} Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'' => q(кс),
						'few' => q({0} кс),
						'one' => q({0} кс),
						'other' => q({0} кс),
					},
					'hour' => {
						'' => q({0}/с),
						'few' => q({0} сата),
						'one' => q({0} сат),
						'other' => q({0} сати),
					},
					'inch' => {
						'' => q(инчи),
						'few' => q({0} инча),
						'one' => q({0} инч),
						'other' => q({0} инча),
					},
					'inch-hg' => {
						'' => q(inHg),
						'few' => q({0} inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'' => q(џули),
						'few' => q({0} J),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'' => q(kt),
						'few' => q({0} kt),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'' => q(K),
						'few' => q({0} K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'' => q(kb),
						'few' => q({0} kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'' => q(kB),
						'few' => q({0} kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'' => q(kcal),
						'few' => q({0} kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'' => q(kg),
						'few' => q({0} kg),
						'one' => q({0} kg),
						'other' => q({0} kg),
					},
					'kilohertz' => {
						'' => q(kHz),
						'few' => q({0} kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'' => q(kJ),
						'few' => q({0} kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'' => q(km),
						'few' => q({0} km),
						'one' => q({0} km),
						'other' => q({0} km),
					},
					'kilometer-per-hour' => {
						'' => q(километри на сат),
						'few' => q({0} km/h),
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'' => q(kW),
						'few' => q({0} kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'' => q(kWh),
						'few' => q({0} kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'light-year' => {
						'' => q(светлосне год.),
						'few' => q({0} сг),
						'one' => q({0} сг),
						'other' => q({0} сг),
					},
					'liter' => {
						'' => q(литри),
						'few' => q({0} l),
						'one' => q({0} l),
						'other' => q({0} l),
					},
					'liter-per-kilometer' => {
						'' => q(L/km),
						'few' => q({0} L/km),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'' => q(lx),
						'few' => q({0} lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'' => q(Mb),
						'few' => q({0} Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'' => q(MB),
						'few' => q({0} MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'' => q(MHz),
						'few' => q({0} MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'' => q(ML),
						'few' => q({0} ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'' => q(MW),
						'few' => q({0} MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'' => q(метри),
						'few' => q({0} m),
						'one' => q({0} m),
						'other' => q({0} m),
					},
					'meter-per-second' => {
						'' => q(метри у секунди),
						'few' => q({0} m/s),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'' => q(m/s²),
						'few' => q({0} m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'' => q(t),
						'few' => q({0} t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'' => q(µg),
						'few' => q({0} µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'' => q(µm),
						'few' => q({0} µm),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'' => q(μs),
						'few' => q({0} μs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'' => q(миље),
						'few' => q({0} mi),
						'one' => q({0} mi),
						'other' => q({0} mi),
					},
					'mile-per-gallon' => {
						'' => q(mpg),
						'few' => q({0} mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-hour' => {
						'' => q(миље на сат),
						'few' => q({0} mi/h),
						'one' => q({0} mi/h),
						'other' => q({0} mi/h),
					},
					'milliampere' => {
						'' => q(mA),
						'few' => q({0} mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'' => q(mbar),
						'few' => q({0} mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'' => q(mg),
						'few' => q({0} mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'milliliter' => {
						'' => q(mL),
						'few' => q({0} mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'' => q(mm),
						'few' => q({0} mm),
						'one' => q({0} mm),
						'other' => q({0} mm),
					},
					'millimeter-of-mercury' => {
						'' => q(mm Hg),
						'few' => q({0} mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millisecond' => {
						'' => q(ms),
						'few' => q({0} ms),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'' => q(mW),
						'few' => q({0} mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'' => q(мин),
						'few' => q({0} мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
					},
					'month' => {
						'' => q(месеци),
						'few' => q({0} мес.),
						'one' => q({0} мес.),
						'other' => q({0} мес.),
					},
					'nanometer' => {
						'' => q(nm),
						'few' => q({0} nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'' => q(ns),
						'few' => q({0} ns),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'' => q(nmi),
						'few' => q({0} nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'' => q(оми),
						'few' => q({0} Ω),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'' => q(oz),
						'few' => q({0} унце),
						'one' => q({0} унца),
						'other' => q({0} унци),
					},
					'ounce-troy' => {
						'' => q(oz t),
						'few' => q({0} oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'' => q(парсеци),
						'few' => q({0} pc),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'' => q(пикометри),
						'few' => q({0} pm),
						'one' => q({0} pm),
						'other' => q({0} pm),
					},
					'pint' => {
						'' => q(pt),
						'few' => q({0} pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'' => q(lb),
						'few' => q({0} lb),
						'one' => q({0} lb),
						'other' => q({0} lb),
					},
					'pound-per-square-inch' => {
						'' => q(psi),
						'few' => q({0} psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'' => q(qt),
						'few' => q({0} qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'' => q(rad),
						'few' => q({0} rad),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'second' => {
						'' => q({0}/сек),
						'few' => q({0} сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
					},
					'square-centimeter' => {
						'' => q(cm²),
						'few' => q({0} cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
					},
					'square-foot' => {
						'' => q(квадратне стопе),
						'few' => q({0} ft²),
						'one' => q({0} ft²),
						'other' => q({0} ft²),
					},
					'square-inch' => {
						'' => q(in²),
						'few' => q({0} in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
					},
					'square-kilometer' => {
						'' => q(квадратни километри),
						'few' => q({0} km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
					},
					'square-meter' => {
						'' => q(квадратни метри),
						'few' => q({0} m²),
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'' => q(mi²),
						'few' => q({0} mi²),
						'one' => q({0} mi²),
						'other' => q({0} mi²),
					},
					'square-yard' => {
						'' => q(yd²),
						'few' => q({0} yd²),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					'tablespoon' => {
						'' => q(каш.),
						'few' => q({0} каш.),
						'one' => q({0} каш.),
						'other' => q({0} каш.),
					},
					'teaspoon' => {
						'' => q(кашич.),
						'few' => q({0} кашич.),
						'one' => q({0} кашич.),
						'other' => q({0} кашич.),
					},
					'terabit' => {
						'' => q(Tb),
						'few' => q({0} Tb),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'' => q(TB),
						'few' => q({0} TB),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'' => q(tn),
						'few' => q({0} tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					'volt' => {
						'' => q(волти),
						'few' => q({0} V),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'' => q(вати),
						'few' => q({0} W),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'' => q(нед.),
						'few' => q({0} нед.),
						'one' => q({0} нед.),
						'other' => q({0} нед.),
					},
					'yard' => {
						'' => q(јарди),
						'few' => q({0} јрд),
						'one' => q({0} јрд),
						'other' => q({0} јрд),
					},
					'year' => {
						'' => q(год.),
						'few' => q({0} год.),
						'one' => q({0} год),
						'other' => q({0} год.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:да|д|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:не|н|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0} и {1}),
				2 => q({0} и {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q(.),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0.###',
				},
				'1000' => {
					'few' => '0 хиљ'.'',
					'one' => '0 хиљ'.'',
					'other' => '0 хиљ'.'',
				},
				'10000' => {
					'few' => '00 хиљ'.'',
					'one' => '00 хиљ'.'',
					'other' => '00 хиљ'.'',
				},
				'100000' => {
					'few' => '000 хиљ'.'',
					'one' => '000 хиљ'.'',
					'other' => '000 хиљ'.'',
				},
				'1000000' => {
					'few' => '0 мил'.'',
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'few' => '00 мил'.'',
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'few' => '000 мил'.'',
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'few' => '0 млрд'.'',
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'few' => '00 млрд'.'',
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'few' => '000 млрд'.'',
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'few' => '0 бил'.'',
					'one' => '0 бил'.'',
					'other' => '0 бил'.'',
				},
				'10000000000000' => {
					'few' => '00 бил'.'',
					'one' => '00 бил'.'',
					'other' => '00 бил'.'',
				},
				'100000000000000' => {
					'few' => '000 бил'.'',
					'one' => '000 бил'.'',
					'other' => '000 бил'.'',
				},
			},
			'long' => {
				'1000' => {
					'few' => '0 хиљаде',
					'one' => '0 хиљада',
					'other' => '0 хиљада',
				},
				'10000' => {
					'few' => '00 хиљаде',
					'one' => '00 хиљада',
					'other' => '00 хиљада',
				},
				'100000' => {
					'few' => '000 хиљаде',
					'one' => '000 хиљада',
					'other' => '000 хиљада',
				},
				'1000000' => {
					'few' => '0 милиона',
					'one' => '0 милион',
					'other' => '0 милиона',
				},
				'10000000' => {
					'few' => '00 милиона',
					'one' => '00 милион',
					'other' => '00 милиона',
				},
				'100000000' => {
					'few' => '000 милиона',
					'one' => '000 милион',
					'other' => '000 милиона',
				},
				'1000000000' => {
					'few' => '0 милијарде',
					'one' => '0 милијарда',
					'other' => '0 милијарди',
				},
				'10000000000' => {
					'few' => '00 милијарде',
					'one' => '00 милијарда',
					'other' => '00 милијарди',
				},
				'100000000000' => {
					'few' => '000 милијарде',
					'one' => '000 милијарда',
					'other' => '000 милијарди',
				},
				'1000000000000' => {
					'few' => '0 трилиона',
					'one' => '0 трилион',
					'other' => '0 трилиона',
				},
				'10000000000000' => {
					'few' => '00 трилиона',
					'one' => '00 трилион',
					'other' => '00 трилиона',
				},
				'100000000000000' => {
					'few' => '000 трилиона',
					'one' => '000 трилион',
					'other' => '000 трилиона',
				},
			},
			'short' => {
				'1000' => {
					'few' => '0 хиљ'.'',
					'one' => '0 хиљ'.'',
					'other' => '0 хиљ'.'',
				},
				'10000' => {
					'few' => '00 хиљ'.'',
					'one' => '00 хиљ'.'',
					'other' => '00 хиљ'.'',
				},
				'100000' => {
					'few' => '000 хиљ'.'',
					'one' => '000 хиљ'.'',
					'other' => '000 хиљ'.'',
				},
				'1000000' => {
					'few' => '0 мил'.'',
					'one' => '0 мил'.'',
					'other' => '0 мил'.'',
				},
				'10000000' => {
					'few' => '00 мил'.'',
					'one' => '00 мил'.'',
					'other' => '00 мил'.'',
				},
				'100000000' => {
					'few' => '000 мил'.'',
					'one' => '000 мил'.'',
					'other' => '000 мил'.'',
				},
				'1000000000' => {
					'few' => '0 млрд'.'',
					'one' => '0 млрд'.'',
					'other' => '0 млрд'.'',
				},
				'10000000000' => {
					'few' => '00 млрд'.'',
					'one' => '00 млрд'.'',
					'other' => '00 млрд'.'',
				},
				'100000000000' => {
					'few' => '000 млрд'.'',
					'one' => '000 млрд'.'',
					'other' => '000 млрд'.'',
				},
				'1000000000000' => {
					'few' => '0 бил'.'',
					'one' => '0 бил'.'',
					'other' => '0 бил'.'',
				},
				'10000000000000' => {
					'few' => '00 бил'.'',
					'one' => '00 бил'.'',
					'other' => '00 бил'.'',
				},
				'100000000000000' => {
					'few' => '000 бил'.'',
					'one' => '000 бил'.'',
					'other' => '000 бил'.'',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00 ¤)',
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'negative' => '#,##0.00 ¤',
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(Андорска пезета),
				'few' => q(андорске пезете),
				'one' => q(андорска пезета),
				'other' => q(андорске пезете),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(УАЕ дирхам),
				'few' => q(УАЕ дирхама),
				'one' => q(УАЕ дирхам),
				'other' => q(УАЕ дирхама),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(Авганистански авгани \(1927–2002\)),
				'few' => q(авганистанска авгана \(1927–2002\)),
				'one' => q(aвганистански авгани \(1927–2002\)),
				'other' => q(авганистанских авгана \(1927–2002\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Авганистански авгани),
				'few' => q(авганистанска авгана),
				'one' => q(aвганистански авгани),
				'other' => q(авганистанских авгана),
			},
		},
		'ALK' => {
			display_name => {
				'few' => q(стара албанска лека),
				'one' => q(стари албански лек),
				'other' => q(старих албанских лека),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Албански лек),
				'few' => q(албанска лека),
				'one' => q(албански лек),
				'other' => q(албанских лека),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Јерменски драм),
				'few' => q(јерменска драма),
				'one' => q(јерменски драм),
				'other' => q(јерменска драма),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Холандскоантилски гулден),
				'few' => q(холандскоантилска гулдена),
				'one' => q(холандскоантилски гулден),
				'other' => q(холандскоантилских гулдена),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Анголска кванза),
				'few' => q(анголске кванзе),
				'one' => q(анголска кванза),
				'other' => q(анголских кванзи),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(Анголијска кванза \(1977–1990\)),
				'few' => q(анголијске кванзе \(1977–1990\)),
				'one' => q(анголијска кванза \(1977–1990\)),
				'other' => q(анголијских кванзи \(1977–1990\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(Анголијска нова кванза \(1990–2000\)),
				'few' => q(анголијске нове кванзе),
				'one' => q(анголијска нова кванза),
				'other' => q(анголијских нових кванзи),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(Анголијска кванза реађустадо \(1995–1999\)),
				'few' => q(анголијске кванзе реађустадо \(1995–1999\)),
				'one' => q(анголијска кванза реађустадо \(1995–1999\)),
				'other' => q(анголијских кванзи реађустадо \(1995–1999\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(Аргентински аустрал),
				'few' => q(аргентинска аустрала),
				'one' => q(аргентински аустрал),
				'other' => q(аргентинских аустрала),
			},
		},
		'ARL' => {
			display_name => {
				'currency' => q(Аргентински пезос леј),
				'few' => q(аргентинска пезос леја),
				'one' => q(аргентински пезос леј),
				'other' => q(аргентинских пезос леја),
			},
		},
		'ARM' => {
			display_name => {
				'currency' => q(Аргентински пезос монедо национал),
				'few' => q(аргентинска пезос монеда национал),
				'one' => q(аргентински пезос монедо национал),
				'other' => q(аргентинских пезос монеда национала),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(Аргентински пезо \(1983–1985\)),
				'few' => q(аргентинска пезоса \(1983–1985\)),
				'one' => q(аргентински пезо \(1983–1985\)),
				'other' => q(аргентинских пезоса \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Аргентински пезос),
				'few' => q(аргентинска пезоса),
				'one' => q(аргентински пезос),
				'other' => q(аргентинских пезоса),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(Аустријски шилинг),
				'few' => q(аустријска шилинга),
				'one' => q(аустријски шилинг),
				'other' => q(аустријских шилинга),
			},
		},
		'AUD' => {
			symbol => 'AUD',
			display_name => {
				'currency' => q(Аустралијски долар),
				'few' => q(Аустралијска долара),
				'one' => q(аустралијски долар),
				'other' => q(аустралијских долара),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Арубански флорин),
				'few' => q(арубанска флорина),
				'one' => q(арубански флорин),
				'other' => q(арубанских флорина),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербејџански манат \(1993–2006\)),
				'few' => q(азербејџанска маната \(1993–2006\)),
				'one' => q(азербејџански манат \(1993–2006\)),
				'other' => q(азербејџанских маната \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Азербејџански манат),
				'few' => q(азербејџанска маната),
				'one' => q(азербејџански манат),
				'other' => q(азербејџанских маната),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(Босанско-Херцеговачки динар),
				'few' => q(босанско-херцеговачка динара),
				'one' => q(босанско-херцеговачки динар),
				'other' => q(босанско-херцеговачких динара),
			},
		},
		'BAM' => {
			symbol => 'КМ',
			display_name => {
				'currency' => q(Босанско-херцеговачка конвертибилна марка),
				'few' => q(босанско-херцеговачке конвертибилне маркe),
				'one' => q(босанско-херцеговачка конвертибилна марка),
				'other' => q(босанско-херцеговачких конвертибилних марака),
			},
		},
		'BAN' => {
			display_name => {
				'currency' => q(Босанско-херцеговачки нови динар),
				'few' => q(босанско-херцеговачка нова динара),
				'one' => q(босанско-херцеговачки нови динар),
				'other' => q(босанско-херцеговачких нових динара),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Барбадошки долар),
				'few' => q(барбадошка долара),
				'one' => q(барбадошки долар),
				'other' => q(барбадошких долара),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладешка така),
				'few' => q(бангладешке таке),
				'one' => q(бангладешка така),
				'other' => q(бангладешких така),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(Белгијски франак \(конвертибилни\)),
				'few' => q(белгијска франка \(конвертибилна\)),
				'one' => q(белгијски франак \(конвертибилни\)),
				'other' => q(белгијских франака \(конвертибилних\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(Белгијски франак),
				'few' => q(белгијска франка),
				'one' => q(белгијски франак),
				'other' => q(белгијских франака),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(Белгијски франак \(финансијски\)),
				'few' => q(белгијска франка \(финансијска\)),
				'one' => q(белгијски франак \(финансијски\)),
				'other' => q(белгијских франака \(финансијских\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(Бугарски тврди лев),
				'few' => q(бугарска тврда лева),
				'one' => q(бугарски тврди лев),
				'other' => q(бугарских тврдих лева),
			},
		},
		'BGM' => {
			display_name => {
				'currency' => q(Бугарски социјалистички лев),
				'few' => q(бугарска социјалистичка лева),
				'one' => q(бугарски социјалистички лев),
				'other' => q(бугарских социјалистичких лева),
			},
		},
		'BGN' => {
			symbol => '[BGN]',
			display_name => {
				'currency' => q(Бугарски лев),
				'few' => q(бугарска лева),
				'one' => q(бугарски лев),
				'other' => q(бугарских лева),
			},
		},
		'BGO' => {
			display_name => {
				'currency' => q(Стари бугарски лев),
				'few' => q(стара бугарска лева),
				'one' => q(стари бугарски лев),
				'other' => q(старих бугарских лева),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахреински динар),
				'few' => q(бахреинскa динара),
				'one' => q(бахреински динар),
				'other' => q(бахреинских динара),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурундски франак),
				'few' => q(бурундска франка),
				'one' => q(бурундски франак),
				'other' => q(бурундских франакa),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(Бермудски долар),
				'few' => q(бермудска долара),
				'one' => q(бермудски долар),
				'other' => q(бермудских долара),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Брунејски долар),
				'few' => q(брунејска долара),
				'one' => q(брунејски долар),
				'other' => q(брунејских долара),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Боливијски Боливиано),
				'few' => q(боливијска боливиана),
				'one' => q(боливијски боливиано),
				'other' => q(боливијских боливиана),
			},
		},
		'BOL' => {
			display_name => {
				'currency' => q(Стари боливијски боливијано),
				'few' => q(стара боливијска боливијана),
				'one' => q(стари боливијски боливијано),
				'other' => q(старих боливијских боливијана),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(Боливијски пезо),
				'few' => q(боливијска пезоса),
				'one' => q(боливијски пезо),
				'other' => q(боливијских пезоса),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(Боливијски мвдол),
				'few' => q(боливијска мвдола),
				'one' => q(боливијски мвдол),
				'other' => q(боливијских мвдола),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(Бразилски нови крузеиро \(1967–1986\)),
				'few' => q(бразилска нова крузеира \(1967–1986\)),
				'one' => q(бразилски нови крузеиро \(1967–1986\)),
				'other' => q(бразилских нових крузеира \(1967–1986\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(Бразилијски крузадо),
				'few' => q(бразилска крузадоса),
				'one' => q(бразилски крузадос),
				'other' => q(бразилских крузадоса),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(Бразилски крузеиро \(1990–1993\)),
				'few' => q(бразилска крузеира \(1990–1993\)),
				'one' => q(бразилски крузеиро \(1990–1993\)),
				'other' => q(бразилских крузеира \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Бразилски реал),
				'few' => q(бразилска реала),
				'one' => q(бразилски реал),
				'other' => q(бразилских реала),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(Бразилијски нови крузадо),
				'few' => q(бразилска нова крузада),
				'one' => q(бразилски нови крузадо),
				'other' => q(бразилских нових крузада),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(Бразилски крузеиро),
				'few' => q(бразилска крузеира),
				'one' => q(бразилски крузеиро),
				'other' => q(бразилских крузеира),
			},
		},
		'BRZ' => {
			display_name => {
				'currency' => q(Стари бразилски крузеиро),
				'few' => q(стара бразилска крузеира),
				'one' => q(стари бразилски крузеиро),
				'other' => q(старих бразилских крузеира),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Бахамски долар),
				'few' => q(бахамска долара),
				'one' => q(бахамски долар),
				'other' => q(бахамских долара),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутански нгултрум),
				'few' => q(бутанска нгултрума),
				'one' => q(бутански нгултрум),
				'other' => q(бутанских нгултрума),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(Бурмански кјат),
				'few' => q(бурманска кјата),
				'one' => q(бурмански кјат),
				'other' => q(бурманских кјата),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Боцванска пула),
				'few' => q(боцванске пуле),
				'one' => q(боцванска пула),
				'other' => q(боцванских пула),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(Белоруска нова рубља \(1994–1999\)),
				'few' => q(белоруске нове рубља \(1994–1999\)),
				'one' => q(белоруска нова рубља \(1994–1999\)),
				'other' => q(белоруских нових рубљи \(1994–1999\)),
			},
		},
		'BYR' => {
			symbol => '[BYR]',
			display_name => {
				'currency' => q(Белоруска рубља),
				'few' => q(белоруске рубље),
				'one' => q(белоруска рубља),
				'other' => q(белоруских рубљи),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Белиски долар),
				'few' => q(белиска долара),
				'one' => q(белиски долар),
				'other' => q(белиских долара),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(Канадски долар),
				'few' => q(канадска долара),
				'one' => q(канадски долар),
				'other' => q(канадских долара),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конгоански франак),
				'few' => q(конголска франка),
				'one' => q(конголски франак),
				'other' => q(конголских франака),
			},
		},
		'CHE' => {
			display_name => {
				'currency' => q(WIR евро),
				'few' => q(WIR евра),
				'one' => q(WIR евро),
				'other' => q(WIR евра),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Швајцарски франак),
				'few' => q(швајцарска франка),
				'one' => q(швајцарски франак),
				'other' => q(швајцарских франака),
			},
		},
		'CHW' => {
			display_name => {
				'currency' => q(WIR франак),
				'few' => q(WIR франка),
				'one' => q(WIR франак),
				'other' => q(WIR франака),
			},
		},
		'CLE' => {
			display_name => {
				'currency' => q(Чилеански ескудо),
				'few' => q(чилеанска ескуда),
				'one' => q(чилеански ескудо),
				'other' => q(чилеанских ескуда),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(Чилеовски унидадес се фоменто),
				'few' => q(чилеанска унидадес де фомента),
				'one' => q(чилеански унидадес де фоменто),
				'other' => q(чилеански унидадеси де фоменто),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Чилеански пезос),
				'few' => q(чилеанска пезоса),
				'one' => q(чилеански пезос),
				'other' => q(чилеанских пезоса),
			},
		},
		'CNX' => {
			display_name => {
				'currency' => q(Долар кинеске народне банке),
				'few' => q(долара кинеске народне банке),
				'one' => q(долар кинеске народне банке),
				'other' => q(долара кинеске народне банке),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Кинески јуан),
				'few' => q(кинеска јуана),
				'one' => q(кинески јуан),
				'other' => q(кинеских јуана),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Колумбијски пезос),
				'few' => q(колумбијска пезоса),
				'one' => q(колумбијски пезос),
				'other' => q(колумбијских пезоса),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(Унидад де валоршки реал),
				'few' => q(нидад де валор реала),
				'one' => q(унидад де валоршки реал),
				'other' => q(унидад де валоршких реала),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Костарикански колон),
				'few' => q(костариканска колона),
				'one' => q(костарикански колон),
				'other' => q(костарикански колони),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(Стари српски динар),
				'few' => q(стара српска динара),
				'one' => q(стари српски динар),
				'other' => q(старих српских динара),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(Чехословачка тврда круна),
				'few' => q(чехословачке тврде круне),
				'one' => q(чехословачка тврда круна),
				'other' => q(чехословачких тврдих круна),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Кубански конвертибилни пезос),
				'few' => q(кубанска конвертибилна пезоса),
				'one' => q(кубански конвертибилни пезос),
				'other' => q(кубанских конвертибилних пезоса),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Кубански пезос),
				'few' => q(кубанска пезоса),
				'one' => q(кубански пезос),
				'other' => q(кубанских пезоса),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Зеленортски ескудо),
				'few' => q(зеленортска ескуда),
				'one' => q(зеленортски ескудо),
				'other' => q(зеленортских ескуда),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(Кипарска фунта),
				'few' => q(кипарске фунте),
				'one' => q(кипарска фунта),
				'other' => q(кипарских фунти),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Чешка круна),
				'few' => q(чешке круне),
				'one' => q(чешка круна),
				'other' => q(чешких крунa),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(Источно-немачка марка),
				'few' => q(источно-немачке марке),
				'one' => q(источно-немачка марка),
				'other' => q(источно-немачких марака),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(Немачка марка),
				'few' => q(немачке марке),
				'one' => q(немачка марка),
				'other' => q(немачких марака),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Џибутански франак),
				'few' => q(џибутанскa франкa),
				'one' => q(џибутански франак),
				'other' => q(џибутанских франакa),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Данска круна),
				'few' => q(данске круне),
				'one' => q(данска круна),
				'other' => q(данских круна),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Доминикански пезос),
				'few' => q(доминиканска пезоса),
				'one' => q(доминикански пезос),
				'other' => q(доминиканских пезоса),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Алжирски динар),
				'few' => q(алжирска динара),
				'one' => q(алжирски динар),
				'other' => q(алжирских динара),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(Еквадорски сакр),
				'few' => q(еквадорска сакра),
				'one' => q(еквадорски сакр),
				'other' => q(еквадорских сакра),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(Еквадорски унидад де валор константе),
				'few' => q(еквадорска унидад де валор константа),
				'one' => q(еквадорски унидад де валор константе),
				'other' => q(еквадорских унидад де валор константа),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(Естонска кроон),
				'few' => q(естонске круне),
				'one' => q(естонска круна),
				'other' => q(естонских круна),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Египатска фунта),
				'few' => q(египатске фунте),
				'one' => q(египатска фунта),
				'other' => q(египатских фунти),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Eритрејска накфa),
				'few' => q(еритрејске накфе),
				'one' => q(еритрејска накфа),
				'other' => q(еритрејских накфи),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(Шпанска пезета \(рачун\)),
				'few' => q(шпанске пезете \(А рачун\)),
				'one' => q(шпанска пезета \(А рачун\)),
				'other' => q(шпанских пезета \(А рачун\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(Шпанска пезета \(конвертибилнирачун\)),
				'few' => q(шпанске пезете \(конвертибилан рачун\)),
				'one' => q(шпанска пезета \(конвертибилан рачун\)),
				'other' => q(шпанских пезета \(конвертибилан рачун\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(Шпанска пезета),
				'few' => q(шпанска пезета),
				'one' => q(шпанска пезета),
				'other' => q(шпанске пезете),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Етиопијски бир),
				'few' => q(етиопијска бира),
				'one' => q(етиопијски бир),
				'other' => q(етиопијских бира),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Евро),
				'few' => q(евра),
				'one' => q(евро),
				'other' => q(евра),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(Финска марка),
				'few' => q(финске марке),
				'one' => q(финска марка),
				'other' => q(финских марака),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фиџијски долар),
				'few' => q(фиџијска долара),
				'one' => q(фиџијски долар),
				'other' => q(фиџијских долара),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Фокландска фунта),
				'few' => q(фокландске фунте),
				'one' => q(фокландска фунта),
				'other' => q(фокландских фунти),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(Француски франак),
				'few' => q(француска франка),
				'one' => q(француски франак),
				'other' => q(француских франака),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Британска фунта стерлинга),
				'few' => q(британске фунте стерлинга),
				'one' => q(британска фунта стерлинга),
				'other' => q(британских фунти стерлинга),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(Грузијски купон ларит),
				'few' => q(грузијска купон ларита),
				'one' => q(грузијски купон ларит),
				'other' => q(грузијских купон ларита),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Грузијски лари),
				'few' => q(грузијска ларија),
				'one' => q(грузијски лари),
				'other' => q(грузијских ларија),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(Гански цеди \(1979–2007\)),
				'few' => q(ганска цеда \(1979–2007\)),
				'one' => q(гански цед \(1979–2007\)),
				'other' => q(ганских цеда \(1979–2007\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гански седи),
				'few' => q(ганска седија),
				'one' => q(гански седи),
				'other' => q(ганских седија),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Гибралтарска фунта),
				'few' => q(гибралтарске фунте),
				'one' => q(гибралтарска фунта),
				'other' => q(гибралтарских фунти),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбијски даласи),
				'few' => q(гамбијска даласа),
				'one' => q(гамбијски даласи),
				'other' => q(гамбијских даласа),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвинејски франак),
				'few' => q(гвинејска франка),
				'one' => q(гвинејски франак),
				'other' => q(гвинејских франака),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(Гвинејски сили),
				'few' => q(гвинејска сила),
				'one' => q(гвинејски сили),
				'other' => q(гвинејских сила),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(Екваторијално-гвинејски еквеле),
				'few' => q(екваторијално-гвинејска еквела),
				'one' => q(екваторијално-гвинејски еквеле),
				'other' => q(екваторијално-гвинејских еквела),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(Грчка драхма),
				'few' => q(грчке драхме),
				'one' => q(грчка драхма),
				'other' => q(грчких драхми),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Гватемалски кецал),
				'few' => q(гватемалска кецала),
				'one' => q(гватемалски кецал),
				'other' => q(гватемалских кецала),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(Португалска гвинеја ескудо),
				'few' => q(португалско-гвинејска ескуда),
				'one' => q(португалско-гвинејски ескудо),
				'other' => q(португалско-гвинејских ескуда),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(Гвинеја Бисао Пезо),
				'few' => q(гвинеја-бисаошка пезоса),
				'one' => q(гвинеја-бисаошки пезо),
				'other' => q(гвинеја-бисаошких пезоса),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Гвајански долар),
				'few' => q(гвајанска долара),
				'one' => q(гвајански долар),
				'other' => q(гвајанских долара),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Хонгконшки долар),
				'few' => q(хонгконшка долара),
				'one' => q(хонгконшки долар),
				'other' => q(хонгконшких долара),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Хондурашка лемпира),
				'few' => q(хондурашка лемпира),
				'one' => q(хондурашки лемпир),
				'other' => q(хондурашких лемпира),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(Хрватски динар),
				'few' => q(хрватска динара),
				'one' => q(хрватски динар),
				'other' => q(хрватских динара),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Хрватска куна),
				'few' => q(хрватске куне),
				'one' => q(хрватска куна),
				'other' => q(хрватских куна),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Хаићански гурд),
				'few' => q(хаићанска гурда),
				'one' => q(хаићански гурд),
				'other' => q(хаићанских гурда),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Мађарска форинта),
				'few' => q(мађарске форинте),
				'one' => q(мађарска форинта),
				'other' => q(мађарских форинти),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонежанска рупија),
				'few' => q(индонежанске рупије),
				'one' => q(индонежанска рупија),
				'other' => q(индонежанских рупијa),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(Ирска фунта),
				'few' => q(ирске фунте),
				'one' => q(ирска фунта),
				'other' => q(ирских фунти),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(Израелска фунта),
				'few' => q(израелске фунте),
				'one' => q(израелска фунта),
				'other' => q(израелских фунти),
			},
		},
		'ILR' => {
			display_name => {
				'currency' => q(Стари израелски шекели),
				'few' => q(стари израелски шекели),
				'one' => q(стари израелски шекели),
				'other' => q(стари израелски шекели),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Израелски нови шекел),
				'few' => q(израелска нова шекела),
				'one' => q(израелски нови шекел),
				'other' => q(израелских нових шекела),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Индијска рупија),
				'few' => q(индијске рупије),
				'one' => q(индијска рупија),
				'other' => q(индијских рупија),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Ирачки динар),
				'few' => q(ирачка динара),
				'one' => q(ирачки динар),
				'other' => q(ирачких динара),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Ирански риjал),
				'few' => q(иранска ријала),
				'one' => q(ирански ријал),
				'other' => q(иранских ријала),
			},
		},
		'ISJ' => {
			display_name => {
				'currency' => q(Стара исландска круна),
				'few' => q(стара исландска круна),
				'one' => q(стара исландска круна),
				'other' => q(стара исландска круна),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Исландска круна),
				'few' => q(исландске круне),
				'one' => q(исландска круна),
				'other' => q(исландских круна),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(Италијанска лира),
				'few' => q(италијанске лире),
				'one' => q(италијанска лира),
				'other' => q(италијанске лире),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Јамајчански долар),
				'few' => q(jамајканскa доларa),
				'one' => q(jамајкански долар),
				'other' => q(jамајканскиx доларa),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Јордански динар),
				'few' => q(јорданскa динара),
				'one' => q(јордански динар),
				'other' => q(јорданских динара),
			},
		},
		'JPY' => {
			symbol => '¥',
			display_name => {
				'currency' => q(Јапански јен),
				'few' => q(јапанска јена),
				'one' => q(јапански јен),
				'other' => q(јапанских јена),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кенијски шилинг),
				'few' => q(кенијска шилинга),
				'one' => q(кенијски шилинг),
				'other' => q(кенијских шилинга),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Киргистански сом),
				'few' => q(киргистанска сома),
				'one' => q(киргистански сом),
				'other' => q(киргистанских сома),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Kамбоџански ријел),
				'few' => q(камбоџанска ријела),
				'one' => q(камбоџански ријел),
				'other' => q(камбоџанских ријела),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Коморски франак),
				'few' => q(коморскa франкa),
				'one' => q(коморски франак),
				'other' => q(коморских франакa),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Севернокорејски вон),
				'few' => q(севернокорејска вона),
				'one' => q(севернокорејски вон),
				'other' => q(севернокорејских вона),
			},
		},
		'KRH' => {
			display_name => {
				'currency' => q(Јужнокорејски хван),
				'few' => q(јужнокорејска хвана),
				'one' => q(јужнокорејски хван),
				'other' => q(јужнокорејских хвана),
			},
		},
		'KRO' => {
			display_name => {
				'currency' => q(Стари јужнокорејски вон),
				'few' => q(стара јужнокорејска вона),
				'one' => q(стари јужнокорејски вон),
				'other' => q(старих јужнокорејских вона),
			},
		},
		'KRW' => {
			symbol => 'KRW',
			display_name => {
				'currency' => q(Јужнокорејски Вон),
				'few' => q(јужнокорејска вона),
				'one' => q(јужнокорејски вон),
				'other' => q(јужнокорејских вона),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувајтски динар),
				'few' => q(кувајтскa динара),
				'one' => q(кувајтски динар),
				'other' => q(кувајтских динара),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Кајмански долар),
				'few' => q(кајманска долара),
				'one' => q(кајмански долар),
				'other' => q(кајманских долара),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(Казахстански тенге),
				'few' => q(казахстанске тенге),
				'one' => q(казахстански тенге),
				'other' => q(казахстанских тенги),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаошки кип),
				'few' => q(лаошка кипа),
				'one' => q(лаошки кип),
				'other' => q(лаошких кипи),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Либанска фунта),
				'few' => q(либанскe фунтe),
				'one' => q(либанскa фунтa),
				'other' => q(либанских фунти),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шриланканскa рупиja),
				'few' => q(шриланканскe рупијe),
				'one' => q(шриланканска рупија),
				'other' => q(шриланканских рупија),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либеријски долар),
				'few' => q(либеријска долара),
				'one' => q(либеријски долар),
				'other' => q(либеријских долара),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесото лоти),
				'few' => q(лесотска лотиса),
				'one' => q(лесотски лотис),
				'other' => q(лесотских лотиса),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(Литвански литас),
				'few' => q(литванска литаса),
				'one' => q(литвански литас),
				'other' => q(литванских литаса),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(Литвански талонас),
				'few' => q(литванска талонаса),
				'one' => q(литвански талонас),
				'other' => q(литванских талонаса),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(Луксембуршки конвертибилни франак),
				'few' => q(луксембуршка конвертибилна франка),
				'one' => q(луксембуршки конвертибилни франак),
				'other' => q(луксембуршких конвертибилних франака),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(Луксембуршки франак),
				'few' => q(луксембуршка франка),
				'one' => q(луксембуршки франак),
				'other' => q(луксембуршки франци),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(Луксембуршки финансијски франак),
				'few' => q(луксембуршка финансијска франка),
				'one' => q(луксембуршки финансијски франак),
				'other' => q(луксембуршких финансијских франака),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(Латвијски лати),
				'few' => q(латвијска лата),
				'one' => q(латвијски лат),
				'other' => q(латвијских лата),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(Латвијска рубља),
				'few' => q(латвијске рубље),
				'one' => q(латвијска рубља),
				'other' => q(латвијских рубљи),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Либијски динар),
				'few' => q(либијскa динарa),
				'one' => q(либијски динар),
				'other' => q(либијских динарa),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Марокански дирхам),
				'few' => q(мароканске дирхаме),
				'one' => q(мароканска дирхама),
				'other' => q(мароканских дирхама),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(Марокански франак),
				'few' => q(мароканска франка),
				'one' => q(марокански франак),
				'other' => q(мароканских франака),
			},
		},
		'MCF' => {
			display_name => {
				'currency' => q(Монегаскански франак),
				'few' => q(монегасканска франка),
				'one' => q(монегаскански франак),
				'other' => q(монегасканских франака),
			},
		},
		'MDC' => {
			display_name => {
				'currency' => q(Молдовански купон),
				'few' => q(молдованска купона),
				'one' => q(молдовански купон),
				'other' => q(молдованских купона),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Молдавски леј),
				'few' => q(молдaвскa леја),
				'one' => q(молдaвски леј),
				'other' => q(молдaвских леја),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Малагасијски ариари),
				'few' => q(малагасијскa ариариja),
				'one' => q(малагасијски ариари),
				'other' => q(малагасијских ариариja),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(Малагасијски франак),
				'few' => q(малагашајска франка),
				'one' => q(малагашајски франак),
				'other' => q(малагашајски франци),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(Македонски денар),
				'few' => q(македонска денара),
				'one' => q(македонски денар),
				'other' => q(македонских динара),
			},
		},
		'MKN' => {
			display_name => {
				'currency' => q(Стари македонски денар),
				'few' => q(стара македонска денара),
				'one' => q(стари македонски денар),
				'other' => q(старих македонских денара),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(Малијански франак),
				'few' => q(малијска франка),
				'one' => q(малијски франак),
				'other' => q(малијских франака),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мјанмарски кјат),
				'few' => q(мјанмарскa кјатa),
				'one' => q(мјанмарски кјат),
				'other' => q(мјанмарских кјатa),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Монголски тугрик),
				'few' => q(монголскa тугрика),
				'one' => q(монголски тугрик),
				'other' => q(монголских тугрика),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Маканишка патака),
				'few' => q(маканешке патаке),
				'one' => q(маканешка патака),
				'other' => q(маканешких патака),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мауританијска oгија),
				'few' => q(мауританијскe oгијe),
				'one' => q(мауританијска oгија),
				'other' => q(мауританијских oгијa),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(Малтешка лира),
				'few' => q(малтешке лире),
				'one' => q(малтешка лира),
				'other' => q(малтешких лира),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(Малтешка фунта),
				'few' => q(малтешке фунте),
				'one' => q(малтешка фунта),
				'other' => q(малтешких фунти),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Маурицијска рупија),
				'few' => q(маурицијскe рупијe),
				'one' => q(маурицијска рупија),
				'other' => q(маурицијских рупија),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Малдивска руфија),
				'few' => q(малдивскe руфијe),
				'one' => q(малдивскa руфија),
				'other' => q(малдивских руфија),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малавијска квача),
				'few' => q(малавијске кваче),
				'one' => q(малавијска квача),
				'other' => q(малавијских квача),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Мексички пезос),
				'few' => q(мексичка пезоса),
				'one' => q(мексички пезос),
				'other' => q(мексичких пезоса),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(Мексички сребрни пезо \(1861–1992\)),
				'few' => q(мексичка сребрна пезоса),
				'one' => q(мексички сребрни пезо),
				'other' => q(мексичких сребрних пезоса),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(Мексички унидад де инверсион \(UDI\)),
				'few' => q(мексичка унидадс де инверзиона),
				'one' => q(мексички унидадс де инверзион),
				'other' => q(мексичких унидадс де инверзиона),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малезијски ринггит),
				'few' => q(малезијска ринггита),
				'one' => q(малезијски ринггит),
				'other' => q(малезијских ринггита),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(Мозамбијски ескудо),
				'few' => q(мозамбијска ескуда),
				'one' => q(мозамбијски ескудо),
				'other' => q(мозамбијских ескуда),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(Стари мозамбијски метикал),
				'few' => q(стара мозамбијска метикала),
				'one' => q(стари мозамбијски метикал),
				'other' => q(старих мозамбијских метикала),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбијски метикал),
				'few' => q(мозамбијска метикала),
				'one' => q(мозамбијски метикал),
				'other' => q(мозамбијских метикала),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибијски долар),
				'few' => q(намибијска долара),
				'one' => q(намибијски долар),
				'other' => q(намибијских долара),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигеријска наира),
				'few' => q(нигеријске наире),
				'one' => q(нигеријска наира),
				'other' => q(нигеријских наира),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(Никарагванска кордоба),
				'few' => q(никарагванске кордобе),
				'one' => q(никарагванска кордоба),
				'other' => q(никарагванских кордоба),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Никарагванска златна кордоба),
				'few' => q(никарагванске златне кордобе),
				'one' => q(никарагванска златна кордоба),
				'other' => q(никарагванских златних кордоба),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(Холандски гулден),
				'few' => q(холандска гулдена),
				'one' => q(холандски гулден),
				'other' => q(холандских гулдена),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Норвешка круна),
				'few' => q(норвешке круне),
				'one' => q(норвешка круна),
				'other' => q(норвешких круна),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непалскa рупиja),
				'few' => q(непалске рупије),
				'one' => q(непалска рупија),
				'other' => q(непалских рупија),
			},
		},
		'NZD' => {
			symbol => 'NZD',
			display_name => {
				'currency' => q(Новозеландски долар),
				'few' => q(новозеландска долара),
				'one' => q(новозеландски долар),
				'other' => q(новозеландских долара),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Омански ријал),
				'few' => q(оманскa ријала),
				'one' => q(омански ријал),
				'other' => q(оманских ријала),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Панамска балбоа),
				'few' => q(панамске балбое),
				'one' => q(панамска балбоа),
				'other' => q(панамских балбоа),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(Перуански инти),
				'few' => q(перувијска интија),
				'one' => q(перувијски инти),
				'other' => q(перувијских интија),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Перуански нуево сол),
				'few' => q(перуанска нуево сола),
				'one' => q(перуански нуево сол),
				'other' => q(перуанских нуево сола),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(Перуански сол),
				'few' => q(перуанска сола),
				'one' => q(перуански сол),
				'other' => q(перуанских сола),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуанска кина),
				'few' => q(папуанскe кинe),
				'one' => q(папуанска кина),
				'other' => q(папуанских кинa),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филипински пезос),
				'few' => q(филипинска пезоса),
				'one' => q(филипински пезос),
				'other' => q(филипинских пезоса),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пакистанскa рупиja),
				'few' => q(пакистанске рупије),
				'one' => q(пакистанска рупија),
				'other' => q(пакистанских рупија),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Пољски злот),
				'few' => q(пољска злота),
				'one' => q(пољски злот),
				'other' => q(пољских злота),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(Пољски злоти \(1950–1995\)),
				'few' => q(пољска злота \(1950–1995\)),
				'one' => q(пољски злот \(1950–1995\)),
				'other' => q(пољских злота \(1950–1995\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(Португалски ескудо),
				'few' => q(португалска ескуда),
				'one' => q(португалски ескудо),
				'other' => q(португалских ескуда),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Парагвајски гварани),
				'few' => q(парагвајска гваранија),
				'one' => q(парагвајски гварани),
				'other' => q(парагвајских гваранија),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катарски ријал),
				'few' => q(катарска ријала),
				'one' => q(катарски ријал),
				'other' => q(катарских ријала),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(Родејскидолар),
				'few' => q(родежанска долара),
				'one' => q(родежански долар),
				'other' => q(родежанских долара),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(Румунски леј),
				'few' => q(румунскa леја),
				'one' => q(румунски леј),
				'other' => q(румунских леја),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Румунски леј \(1952–2006\)),
				'few' => q(румунскa леја \(1952–2006\)),
				'one' => q(румунски леј \(1952–2006\)),
				'other' => q(румунских леја \(1952–2006\)),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Српски динар),
				'few' => q(српска динара),
				'one' => q(српски динар),
				'other' => q(српских динара),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(Руска рубља),
				'few' => q(руске рубље),
				'one' => q(руска рубља),
				'other' => q(руских рубљи),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(Руска рубља \(1991–1998\)),
				'few' => q(руске рубље \(1991–1998\)),
				'one' => q(руска рубља \(1991–1998\)),
				'other' => q(руских рубљи \(1991–1998\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руандски франак),
				'few' => q(руандскa франка),
				'one' => q(руандски франак),
				'other' => q(руандских франака),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Саудијски ријал),
				'few' => q(саудијска ријала),
				'one' => q(саудијски ријал),
				'other' => q(саудијских ријала),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломонски долар),
				'few' => q(соломонска долара),
				'one' => q(соломонски долар),
				'other' => q(соломонских долара),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сејшелска рупија),
				'few' => q(сејшелске рупије),
				'one' => q(сејшелска рупија),
				'other' => q(сејшелских рупија),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(Стари судански динар),
				'few' => q(стара суданска динара),
				'one' => q(стари судански динар),
				'other' => q(старих суданских динара),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Суданска фунта),
				'few' => q(суданске фунте),
				'one' => q(суданска фунта),
				'other' => q(суданских фунти),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(Стара суданска фунта),
				'few' => q(старе суданске фунте),
				'one' => q(стара суданска фунта),
				'other' => q(старих суданских фунти),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Шведска круна),
				'few' => q(шведске круне),
				'one' => q(шведска круна),
				'other' => q(шведских круна),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапурски долар),
				'few' => q(сингапурска долара),
				'one' => q(сингапурски долар),
				'other' => q(сингапурских долара),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Св. јеленска фунта),
				'few' => q(св. јеленске фунте),
				'one' => q(св. јеленска фунта),
				'other' => q(св. јеленских фунти),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(Словеначки толар),
				'few' => q(словеначка толара),
				'one' => q(словеначки толар),
				'other' => q(словеначких толара),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(Словачка круна),
				'few' => q(словачке круне),
				'one' => q(словачка круна),
				'other' => q(словачких круна),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сијера-леоншки леоне),
				'few' => q(сијералеонска леона),
				'one' => q(сијералеонски леоне),
				'other' => q(сијералеонских леона),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомалијски шилинг),
				'few' => q(сомалијска шилинга),
				'one' => q(сомалијски шилинг),
				'other' => q(сомалијских шилинга),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Суринамски долар),
				'few' => q(суринамска долара),
				'one' => q(суринамски долар),
				'other' => q(суринамских долара),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(Суринамски гилдер),
				'few' => q(суринамска гилдера),
				'one' => q(суринамски гилдер),
				'other' => q(суринамских гилдера),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Јужносуданска фунта),
				'few' => q(јужносуданскe фунтe),
				'one' => q(јужносуданска фунта),
				'other' => q(јужносуданских фунти),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Сао Томе и Принципе добра),
				'few' => q(сао томе и принципе добра),
				'one' => q(сао томе и принципе добар),
				'other' => q(сао томе и принципе добра),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(Совјетска рубља),
				'few' => q(совјетске рубље),
				'one' => q(совјетска рубља),
				'other' => q(совјетских рубљи),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(Салвадорски колон),
				'few' => q(салвадорска колона),
				'one' => q(салвадорски колон),
				'other' => q(салвадорских колона),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Сиријска фунта),
				'few' => q(сиријске фунте),
				'one' => q(сиријска фунта),
				'other' => q(сиријских фунти),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свази лилангени),
				'few' => q(свази емалангена),
				'one' => q(свази емаланген),
				'other' => q(свази емалангена),
			},
		},
		'THB' => {
			symbol => 'THB',
			display_name => {
				'currency' => q(Тајландски бат),
				'few' => q(тајландска бата),
				'one' => q(тајландски бат),
				'other' => q(тајландских бата),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(Таџихистанска рубља),
				'few' => q(таџихистанске рубље),
				'one' => q(таџихистанска рубља),
				'other' => q(таџихистанских рубљи),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Tаџихистански сомон),
				'few' => q(таџикистанска сомона),
				'one' => q(таџикистански сомон),
				'other' => q(таџикистанских сомона),
			},
		},
		'TMM' => {
			display_name => {
				'currency' => q(Туркменистански манат \(1993–2009\)),
				'few' => q(туркменистанска маната \(1993–2009\)),
				'one' => q(туркменистански манат \(1993–2009\)),
				'other' => q(туркменистански манат \(1993–2009\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Туркменистански манат),
				'few' => q(туркменистанскa манатa),
				'one' => q(туркменистански манат),
				'other' => q(туркменистанских маната),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Туниски динар),
				'few' => q(туниска динара),
				'one' => q(туниски динар),
				'other' => q(туниских динара),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонгоншка Панга),
				'few' => q(тонгашке панге),
				'one' => q(тонгашка панга),
				'other' => q(тонгашких панга),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(Тиморшки ескудо),
				'few' => q(тиморшка ескуда),
				'one' => q(тиморшки ескудо),
				'other' => q(тиморшких ескуда),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(Турска лира \(1922–2005\)),
				'few' => q(турске лире \(1922–2005\)),
				'one' => q(турска лира \(1922–2005\)),
				'other' => q(турских лира \(1922–2005\)),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Турска лира),
				'few' => q(турске лире),
				'one' => q(турска лира),
				'other' => q(турских лира),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Тринидад-тобагошки долар),
				'few' => q(тринидад-тобагошка долара),
				'one' => q(тринидад-тобагошки долар),
				'other' => q(тринидад-тобагошких долара),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Нови тајвански долар),
				'few' => q(нова тајванска долара),
				'one' => q(нови тајвански долар),
				'other' => q(нових тајванских долара),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзанијски шилинг),
				'few' => q(танзанијска шилинга),
				'one' => q(танзанијски шилинг),
				'other' => q(танзанијских шилинга),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Украјинска гривна),
				'few' => q(украјинскe хривњe),
				'one' => q(украјинскa хривњa),
				'other' => q(украјинских гривни),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(Украјински карбованети),
				'few' => q(украјинска карбованцива),
				'one' => q(украјински карбованец),
				'other' => q(украјинских карбованцива),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(Угандски шилинг \(1966–1987\)),
				'few' => q(угандијска шилинга \(1966–1987\)),
				'one' => q(угандијски шилинг \(1966–1987\)),
				'other' => q(угандијских шилинга \(1966–1987\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Угандски шилинг),
				'few' => q(угандскa шилинга),
				'one' => q(угандски шилинг),
				'other' => q(угандских шилинга),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(Амерички долар),
				'few' => q(америчка долара),
				'one' => q(амерички долар),
				'other' => q(америчких долара),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(САД долар \(следећи дан\)),
				'few' => q(САД долара \(следећи дан\)),
				'one' => q(САД долар \(следећи дан\)),
				'other' => q(САД долара \(следећи дан\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(САД долар \(исти дан\)),
				'few' => q(САД долара \(исти дан\)),
				'one' => q(САД долар \(исти дан\)),
				'other' => q(САД долара \(исти дан\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(Уругвајски пезо ен унидадес индексадас),
				'few' => q(уругвајска пезоса ен унидадес индексадеса),
				'one' => q(уругвајски пезо ен унидадес индексадес),
				'other' => q(угвајских пезоса ен унидадес индексадеса),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(Уругвајски пезо \(1975–1993\)),
				'few' => q(уругвајска пезоса \(1975–1993\)),
				'one' => q(уругвајски пезо \(1975–1993\)),
				'other' => q(уругвајских пезоса \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Уругвајски пезос),
				'few' => q(уругвајска пезоса),
				'one' => q(уругвајски пезос),
				'other' => q(уругвајских пезоса),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Узбекистански сом),
				'few' => q(узбекистанска сома),
				'one' => q(узбекистански сом),
				'other' => q(узбекистанских сома),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(Венецуелански боливар \(1871–2008\)),
				'few' => q(венецуеланска боливара \(1871–2008\)),
				'one' => q(венецуелански боливар \(1871–2008\)),
				'other' => q(венецуеланских боливара \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Венецуелански боливар),
				'few' => q(венецуеланска боливара),
				'one' => q(венецуелански боливар),
				'other' => q(венецуеланских боливара),
			},
		},
		'VND' => {
			symbol => 'VND',
			display_name => {
				'currency' => q(Вијетнамски донг),
				'few' => q(вијетнамска донга),
				'one' => q(вијетнамски донг),
				'other' => q(вијетнамских донга),
			},
		},
		'VNN' => {
			display_name => {
				'currency' => q(Вијетнамски донг \(1978–1985\)),
				'few' => q(вијетнамска донга \(1978–1985\)),
				'one' => q(вијетнамски донг \(1978–1985\)),
				'other' => q(вијетнамских донга \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Вануатски вату),
				'few' => q(вануатскa ватуa),
				'one' => q(вануатски вату),
				'other' => q(вануатских ватуa),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоанска тала),
				'few' => q(самоанске тале),
				'one' => q(самоанска тала),
				'other' => q(самоанских тала),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(CFA франак BEAC),
				'few' => q(CFA франка BEAC),
				'one' => q(CFA франак BEAC),
				'other' => q(CFA франака BEAC),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(Сребро),
				'few' => q(сребра),
				'one' => q(сребро),
				'other' => q(сребра),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(Злато),
				'few' => q(злата),
				'one' => q(злато),
				'other' => q(злата),
			},
		},
		'XBA' => {
			display_name => {
				'currency' => q(Европска композитна јединица),
				'few' => q(европске композитне јединице),
				'one' => q(европска композитна јединица),
				'other' => q(европских композитних јединица),
			},
		},
		'XBB' => {
			display_name => {
				'currency' => q(Европска новчана јединица),
				'few' => q(европске новчане јединице \(XBB\)),
				'one' => q(европска новчана јединица \(XBB\)),
				'other' => q(европске новчане јединице \(XBB\)),
			},
		},
		'XBC' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBC\)),
				'few' => q(европске јединице рачуна \(XBC\)),
				'one' => q(европска јединица рачуна \(XBC\)),
				'other' => q(европских јединица рачуна \(XBC\)),
			},
		},
		'XBD' => {
			display_name => {
				'currency' => q(Европска јединица рачуна \(XBD\)),
				'few' => q(европске јединице рачуна \(XBD\)),
				'one' => q(европска јединица рачуна \(XBD\)),
				'other' => q(европских јединица рачуна \(XBD\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Источнокарипски долар),
				'few' => q(источно-карипскa доларa),
				'one' => q(источнокарипски долар),
				'other' => q(источно-карипскиx доларa),
			},
		},
		'XDR' => {
			display_name => {
				'currency' => q(Посебна цртаћа права),
				'few' => q(посебна цртаћа права),
				'one' => q(посебно цртаће право),
				'other' => q(посебних цртаћих права),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(Европска валутна јединица),
				'few' => q(европске новчане јединице \(XEU\)),
				'one' => q(европска новчана јединица \(XEU\)),
				'other' => q(европских новчаних јединица),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(Француски златни франак),
				'few' => q(француска златна франка),
				'one' => q(француски златни франак),
				'other' => q(француских златних франака),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(Француски UIC-франак),
				'few' => q(француска UIC-франка),
				'one' => q(француски UIC-франак),
				'other' => q(француских UIC-франака),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ЦФА франак БЦЕАО),
				'few' => q(ЦФА франка БЦЕАО),
				'one' => q(ЦФА франак БЦЕАО),
				'other' => q(ЦФА франака БЦЕАО),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(Паладијум),
				'few' => q(паладијума),
				'one' => q(паладијум),
				'other' => q(паладијума),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(CFP франак),
				'few' => q(CFP франка),
				'one' => q(CFP франак),
				'other' => q(CFP франака),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(Платина),
				'few' => q(платине),
				'one' => q(платина),
				'other' => q(платина),
			},
		},
		'XRE' => {
			display_name => {
				'currency' => q(RINET фонд),
				'few' => q(RINET фонда),
				'one' => q(RINET фонд),
				'other' => q(RINET фондова),
			},
		},
		'XTS' => {
			display_name => {
				'currency' => q(Код тестиране валуте),
				'few' => q(кода тестиране валуте),
				'one' => q(код тестиране валуте),
				'other' => q(кодова тестиране валуте),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Непозната или неважећа валута),
				'few' => q(непознате или неважеће валуте),
				'one' => q(непозната или неважећа валута),
				'other' => q(непознатих или неважећих валута),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(Јеменски динар),
				'few' => q(јеменска долара),
				'one' => q(јеменски долар),
				'other' => q(јеменских долара),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Јеменски риjал),
				'few' => q(јеменска ријала),
				'one' => q(јеменски ријал),
				'other' => q(jеменских ријала),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(Југословенски тврди динар),
				'few' => q(југословенска тврда динара),
				'one' => q(југословенски тврди динар),
				'other' => q(југословенских тврдих динара),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(Југословенски нови динар),
				'few' => q(југословенска нова динара),
				'one' => q(југословенски нови динар),
				'other' => q(југословенских нових динара),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(Југословенски конвертибилни динар),
				'few' => q(југословенска конвертибилна динара),
				'one' => q(југословенски конвертибилни динар),
				'other' => q(југословенских конвертибилних динара),
			},
		},
		'YUR' => {
			display_name => {
				'currency' => q(Југословенски реформирани динар),
				'few' => q(југословенска реформирана динара),
				'one' => q(југословенски реформирани динар),
				'other' => q(југословенских реформираних динара),
			},
		},
		'ZAL' => {
			display_name => {
				'currency' => q(Јужно-афрички ранд \(финансијски\)),
				'few' => q(јужноафричка ранда \(финансијска\)),
				'one' => q(јужноафрички ранд \(финансијски\)),
				'other' => q(јужноафричких ранда \(финансијских\)),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Јужно-афрички ранд),
				'few' => q(јужно-афричка ранда),
				'one' => q(јужно-афрички ранд),
				'other' => q(јужно-афричких ранда),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замбијска квача \(1968–2012\)),
				'few' => q(замбијске кваче \(1968–2012\)),
				'one' => q(замбијска квача \(1968–2012\)),
				'other' => q(замбијских квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбијска квача),
				'few' => q(замбијске кваче),
				'one' => q(замбијска квача),
				'other' => q(замбијских квача),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(Заирски нови заир),
				'few' => q(заирска нова заира),
				'one' => q(заирски нови заир),
				'other' => q(заирских нових заира),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(Заирски заир),
				'few' => q(заирска заира),
				'one' => q(заирски заир),
				'other' => q(заирских заира),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(1980–2008\)),
				'few' => q(зимбабвејска долара \(1980–2008\)),
				'one' => q(зимбабвејски долар \(1980–2008\)),
				'other' => q(зимбабвејских долара \(1980–2008\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2009\)),
				'few' => q(зимбабвејска долара \(2009\)),
				'one' => q(зимбабвејски долар \(2009\)),
				'other' => q(зимбабвејских долара \(2009\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(Зимбабвеански долар \(2008\)),
				'few' => q(зимбабвејска долара \(2008\)),
				'one' => q(зимбабвејски долар \(2008\)),
				'other' => q(зимбабвејских долара \(2008\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					wide => {
						nonleap => [
							'Таут',
							'Баба',
							'Хатор',
							'Киахк',
							'Тоба',
							'Амшир',
							'Барамхат',
							'Барамуда',
							'Башанс',
							'Паона',
							'Епеп',
							'Месра',
							'Наси'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'Мескерем',
							'Текемт',
							'Хедар',
							'Тахсас',
							'Тер',
							'Јекатит',
							'Мегабит',
							'Миазиа',
							'Генбот',
							'Сене',
							'Хамле',
							'Нехасе',
							'Пагумен'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'јан',
							'феб',
							'мар',
							'апр',
							'мај',
							'јун',
							'јул',
							'авг',
							'сеп',
							'окт',
							'нов',
							'дец'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ј',
							'ф',
							'м',
							'а',
							'м',
							'ј',
							'ј',
							'а',
							'с',
							'о',
							'н',
							'д'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'јануар',
							'фебруар',
							'март',
							'април',
							'мај',
							'јун',
							'јул',
							'август',
							'септембар',
							'октобар',
							'новембар',
							'децембар'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					wide => {
						nonleap => [
							'Тишри',
							'Хешван',
							'Кислев',
							'Тевет',
							'Шеват',
							'Адар I',
							'Адар',
							'Нисан',
							'Ијар',
							'Сиван',
							'Тамуз',
							'Ав',
							'Елул'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'Адар II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'Чаитра',
							'Ваисака',
							'Јиаиста',
							'Асада',
							'Сравана',
							'Бадра',
							'Асвина',
							'Картика',
							'Аргајана',
							'Пауза',
							'Мага',
							'Фалгуна'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'Мух.',
							'Саф.',
							'Реб. 1',
							'Реб 2',
							'Џум. 1',
							'Џум. 2',
							'Реџ.',
							'Ша.',
							'Рам.',
							'Ше.',
							'Зул-к.',
							'Зул-х.'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Мурахам',
							'Сафар',
							'Рабиʻ I',
							'Рабиʻ II',
							'Јумада I',
							'Јумада II',
							'Рађаб',
							'Шаʻбан',
							'Рамадан',
							'Шавал',
							'Дуʻл-Киʻда',
							'Дуʻл-хиђа'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					wide => {
						nonleap => [
							'Мухарем',
							'Сафер',
							'Реби 1',
							'Реби 2',
							'Џумаде 1',
							'Џумаде 2',
							'Реџеб',
							'Шаʻбан',
							'Рамазан',
							'Шевал',
							'Зул-каде',
							'Зул-хиџе'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					wide => {
						nonleap => [
							'Фаравадин',
							'Ордибехешт',
							'Кордад',
							'Тир',
							'Мордад',
							'Шахривар',
							'Мехр',
							'Абан',
							'Азар',
							'Деј',
							'Бахман',
							'Есфанд'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'пон',
						tue => 'уто',
						wed => 'сре',
						thu => 'чет',
						fri => 'пет',
						sat => 'суб',
						sun => 'нед'
					},
					narrow => {
						mon => 'п',
						tue => 'у',
						wed => 'с',
						thu => 'ч',
						fri => 'п',
						sat => 'с',
						sun => 'н'
					},
					short => {
						mon => 'по',
						tue => 'ут',
						wed => 'ср',
						thu => 'че',
						fri => 'пе',
						sat => 'су',
						sun => 'не'
					},
					wide => {
						mon => 'понедељак',
						tue => 'уторак',
						wed => 'среда',
						thu => 'четвртак',
						fri => 'петак',
						sat => 'субота',
						sun => 'недеља'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'Прво тромесечје',
						1 => 'Друго тромесечје',
						2 => 'Треће тромесечје',
						3 => 'Четврто тромесечје'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'К1',
						1 => 'К2',
						2 => 'К3',
						3 => 'К4'
					},
					narrow => {0 => '1.',
						1 => '2.',
						2 => '3.',
						3 => '4.'
					},
					wide => {0 => 'Прво тромесечје',
						1 => 'Друго тромесечје',
						2 => 'Треће тромесечје',
						3 => 'Четврто тромесечје'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'narrow' => {
					'pm' => q{p},
					'noon' => q{n},
					'am' => q{a},
				},
				'wide' => {
					'am' => q{пре подне},
					'noon' => q{у подне},
					'pm' => q{по подне},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'БЕ'
			},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'п. н. е.',
				'1' => 'н. е.'
			},
			narrow => {
				'0' => 'п.н.е.',
				'1' => 'н.е.'
			},
			wide => {
				'0' => 'Пре нове ере',
				'1' => 'Нове ере'
			},
		},
		'hebrew' => {
		},
		'indian' => {
			abbreviated => {
				'0' => 'САКА'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'АХ'
			},
		},
		'japanese' => {
			abbreviated => {
				'0' => 'Таика (645-650)',
				'1' => 'Хакучи (650-671)',
				'2' => 'Хакухо (672-686)',
				'3' => 'Шучо (686-701)',
				'4' => 'Таихо (701-704)',
				'5' => 'Кеиун (704-708)',
				'6' => 'Вадо (708-715)',
				'7' => 'Реики (715-717)',
				'8' => 'Јоро (717-724)',
				'9' => 'Јинки (724-729)',
				'10' => 'Темпио (729-749)',
				'11' => 'Темпио-кампо (749-749)',
				'12' => 'Темпио-шохо (749-757)',
				'13' => 'Темпио-хођи (757-765)',
				'14' => 'Темпо-ђинго (765-767)',
				'15' => 'Ђинго-кеиун (767-770)',
				'16' => 'Хоки (770-780)',
				'17' => 'Тен-о (781-782)',
				'18' => 'Енрјаку (782-806)',
				'19' => 'Даидо (806-810)',
				'20' => 'Конин (810-824)',
				'21' => 'Тенчо (824-834)',
				'22' => 'Шова (834-848)',
				'23' => 'Кајо (848-851)',
				'24' => 'Нињу (851-854)',
				'25' => 'Саико (854-857)',
				'26' => 'Тенан (857-859)',
				'27' => 'Јоган (859-877)',
				'28' => 'Генкеи (877-885)',
				'29' => 'Ниња (885-889)',
				'30' => 'Кампјо (889-898)',
				'31' => 'Шотаи (898-901)',
				'32' => 'Енђи (901-923)',
				'33' => 'Енчо (923-931)',
				'34' => 'Шохеи (931-938)',
				'35' => 'Тенгјо (938-947)',
				'36' => 'Тенриаку (947-957)',
				'37' => 'Тентоку (957-961)',
				'38' => 'Ова (961-964)',
				'39' => 'Кохо (964-968)',
				'40' => 'Ана (968-970)',
				'41' => 'Тенроку (970-973)',
				'42' => 'Тен-ен (973-976)',
				'43' => 'Јоген (976-978)',
				'44' => 'Тенген (978-983)',
				'45' => 'Еикан (983-985)',
				'46' => 'Кана (985-987)',
				'47' => 'Еи-ен (987-989)',
				'48' => 'Еисо (989-990)',
				'49' => 'Шорјаку (990-995)',
				'50' => 'Чотоку (995-999)',
				'51' => 'Чохо (999-1004)',
				'52' => 'Канко (1004-1012)',
				'53' => 'Чова (1012-1017)',
				'54' => 'Канин (1017-1021)',
				'55' => 'Ђиан (1021-1024)',
				'56' => 'Мању (1024-1028)',
				'57' => 'Чоген (1028-1037)',
				'58' => 'Чорјаку (1037-1040)',
				'59' => 'Чокју (1040-1044)',
				'60' => 'Кантоку (1044-1046)',
				'61' => 'Еишо (1046-1053)',
				'62' => 'Тенђи (1053-1058)',
				'63' => 'Кохеи (1058-1065)',
				'64' => 'Ђирјаку (1065-1069)',
				'65' => 'Енкју (1069-1074)',
				'66' => 'Шохо (1074-1077)',
				'67' => 'Шорјаку (1077-1081)',
				'68' => 'Еишо (1081-1084)',
				'69' => 'Отоку (1084-1087)',
				'70' => 'Канђи (1087-1094)',
				'71' => 'Кахо (1094-1096)',
				'72' => 'Еичо (1096-1097)',
				'73' => 'Шотоку (1097-1099)',
				'74' => 'Кова (1099-1104)',
				'75' => 'Чођи (1104-1106)',
				'76' => 'Кашо (1106-1108)',
				'77' => 'Тенин (1108-1110)',
				'78' => 'Тен-еи (1110-1113)',
				'79' => 'Еикју (1113-1118)',
				'80' => 'Ђен-еи (1118-1120)',
				'81' => 'Хоан (1120-1124)',
				'82' => 'Тенђи (1124-1126)',
				'83' => 'Даиђи (1126-1131)',
				'84' => 'Теншо (1131-1132)',
				'85' => 'Чошао (1132-1135)',
				'86' => 'Хоен (1135-1141)',
				'87' => 'Еиђи (1141-1142)',
				'88' => 'Кођи (1142-1144)',
				'89' => 'Тењо (1144-1145)',
				'90' => 'Кјуан (1145-1151)',
				'91' => 'Нинпеи (1151-1154)',
				'92' => 'Кјују (1154-1156)',
				'93' => 'Хоген (1156-1159)',
				'94' => 'Хеиђи (1159-1160)',
				'95' => 'Еирјаку (1160-1161)',
				'96' => 'Охо (1161-1163)',
				'97' => 'Чокан (1163-1165)',
				'98' => 'Еиман (1165-1166)',
				'99' => 'Нин-ан (1166-1169)',
				'100' => 'Као (1169-1171)',
				'101' => 'Шоан (1171-1175)',
				'102' => 'Анген (1175-1177)',
				'103' => 'Ђишо (1177-1181)',
				'104' => 'Јова (1181-1182)',
				'105' => 'Ђуеи (1182-1184)',
				'106' => 'Генрјуку (1184-1185)',
				'107' => 'Бунђи (1185-1190)',
				'108' => 'Кенкју (1190-1199)',
				'109' => 'Шођи (1199-1201)',
				'110' => 'Кенин (1201-1204)',
				'111' => 'Генкју (1204-1206)',
				'112' => 'Кен-еи (1206-1207)',
				'113' => 'Шоген (1207-1211)',
				'114' => 'Кенрјаку (1211-1213)',
				'115' => 'Кенпо (1213-1219)',
				'116' => 'Шокју (1219-1222)',
				'117' => 'Ђу (1222-1224)',
				'118' => 'Ђенин (1224-1225)',
				'119' => 'Кароку (1225-1227)',
				'120' => 'Антеи (1227-1229)',
				'121' => 'Канки (1229-1232)',
				'122' => 'Ђоеи (1232-1233)',
				'123' => 'Темпуку (1233-1234)',
				'124' => 'Бунрјаку (1234-1235)',
				'125' => 'Катеи (1235-1238)',
				'126' => 'Рјакунин (1238-1239)',
				'127' => 'Ен-о (1239-1240)',
				'128' => 'Нињи (1240-1243)',
				'129' => 'Канген (1243-1247)',
				'130' => 'Хођи (1247-1249)',
				'131' => 'Кенчо (1249-1256)',
				'132' => 'Коген (1256-1257)',
				'133' => 'Шока (1257-1259)',
				'134' => 'Шоген (1259-1260)',
				'135' => 'Бун-о (1260-1261)',
				'136' => 'Кочо (1261-1264)',
				'137' => 'Бун-еи (1264-1275)',
				'138' => 'Кенђи (1275-1278)',
				'139' => 'Коан (1278-1288)',
				'140' => 'Шу (1288-1293)',
				'141' => 'Еинин (1293-1299)',
				'142' => 'Шоан (1299-1302)',
				'143' => 'Кенген (1302-1303)',
				'144' => 'Каген (1303-1306)',
				'145' => 'Токуђи (1306-1308)',
				'146' => 'Енкеи (1308-1311)',
				'147' => 'Очо (1311-1312)',
				'148' => 'Шова (1312-1317)',
				'149' => 'Бунпо (1317-1319)',
				'150' => 'Ђено (1319-1321)',
				'151' => 'Ђенкјо (1321-1324)',
				'152' => 'Шочу (1324-1326)',
				'153' => 'Кареки (1326-1329)',
				'154' => 'Гентоку (1329-1331)',
				'155' => 'Генко (1331-1334)',
				'156' => 'Кему (1334-1336)',
				'157' => 'Енген (1336-1340)',
				'158' => 'Кококу (1340-1346)',
				'159' => 'Шохеи (1346-1370)',
				'160' => 'Кентоку (1370-1372)',
				'161' => 'Бучу (1372-1375)',
				'162' => 'Тењу (1375-1379)',
				'163' => 'Корјаку (1379-1381)',
				'164' => 'Кова (1381-1384)',
				'165' => 'Генчу (1384-1392)',
				'166' => 'Меитоку (1384-1387)',
				'167' => 'Какеи (1387-1389)',
				'168' => 'Ку (1389-1390)',
				'169' => 'Меитоку (1390-1394)',
				'170' => 'Оеи (1394-1428)',
				'171' => 'Шочо (1428-1429)',
				'172' => 'Еикјо (1429-1441)',
				'173' => 'Какитсу (1441-1444)',
				'174' => 'Бун-ан (1444-1449)',
				'175' => 'Хотоку (1449-1452)',
				'176' => 'Кјотоку (1452-1455)',
				'177' => 'Кошо (1455-1457)',
				'178' => 'Чороку (1457-1460)',
				'179' => 'Каншо (1460-1466)',
				'180' => 'Буншо (1466-1467)',
				'181' => 'Онин (1467-1469)',
				'182' => 'Бунмеи (1469-1487)',
				'183' => 'Чокјо (1487-1489)',
				'184' => 'Ентоку (1489-1492)',
				'185' => 'Меио (1492-1501)',
				'186' => 'Бунки (1501-1504)',
				'187' => 'Еишо (1504-1521)',
				'188' => 'Таиеи (1521-1528)',
				'189' => 'Кјороку (1528-1532)',
				'190' => 'Тенмон (1532-1555)',
				'191' => 'Кођи (1555-1558)',
				'192' => 'Еироку (1558-1570)',
				'193' => 'Генки (1570-1573)',
				'194' => 'Теншо (1573-1592)',
				'195' => 'Бунроку (1592-1596)',
				'196' => 'Кеичо (1596-1615)',
				'197' => 'Генва (1615-1624)',
				'198' => 'Кан-еи (1624-1644)',
				'199' => 'Шохо (1644-1648)',
				'200' => 'Кеиан (1648-1652)',
				'201' => 'Шу (1652-1655)',
				'202' => 'Меирјаку (1655-1658)',
				'203' => 'Мањи (1658-1661)',
				'204' => 'Канбун (1661-1673)',
				'205' => 'Енпо (1673-1681)',
				'206' => 'Тенва (1681-1684)',
				'207' => 'Јокјо (1684-1688)',
				'208' => 'Генроку (1688-1704)',
				'209' => 'Хоеи (1704-1711)',
				'210' => 'Шотоку (1711-1716)',
				'211' => 'Кјохо (1716-1736)',
				'212' => 'Генбун (1736-1741)',
				'213' => 'Канпо (1741-1744)',
				'214' => 'Енкјо (1744-1748)',
				'215' => 'Кан-ен (1748-1751)',
				'216' => 'Хорјаку (1751-1764)',
				'217' => 'Меива (1764-1772)',
				'218' => 'Ан-еи (1772-1781)',
				'219' => 'Тенмеи (1781-1789)',
				'220' => 'Кансеи (1789-1801)',
				'221' => 'Кјова (1801-1804)',
				'222' => 'Бунка (1804-1818)',
				'223' => 'Бунсеи (1818-1830)',
				'224' => 'Тенпо (1830-1844)',
				'225' => 'Кока (1844-1848)',
				'226' => 'Каеи (1848-1854)',
				'227' => 'Ансеи (1854-1860)',
				'228' => 'Ман-ен (1860-1861)',
				'229' => 'Бункју (1861-1864)',
				'230' => 'Генђи (1864-1865)',
				'231' => 'Кеико (1865-1868)',
				'232' => 'Меиђи',
				'233' => 'Таишо',
				'234' => 'Шова',
				'235' => 'Хаисеи'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'АП'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'Пре РК',
				'1' => 'РК'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE, dd. MMMM y. G},
			'long' => q{dd. MMMM y. G},
			'medium' => q{dd.MM.y. G},
			'short' => q{d.M.y. GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, dd. MMMM y.},
			'long' => q{dd. MMMM y.},
			'medium' => q{dd.MM.y.},
			'short' => q{d.M.yy.},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
			'full' => q{EEEE, MMMM d, y G},
			'long' => q{MMMM d, y G},
			'medium' => q{MMM d, y G},
			'short' => q{M/d/yy G},
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH.mm.ss zzzz},
			'long' => q{HH.mm.ss z},
			'medium' => q{HH.mm.ss},
			'short' => q{HH.mm},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'japanese' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{E d.},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			H => q{HH},
			Hm => q{HH.mm},
			Hms => q{HH.mm.ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{E d. MMM},
			MMMMEd => q{E d. MMMM},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{MM-dd},
			Md => q{d/M},
			d => q{d},
			h => q{hh a},
			hm => q{hh.mm a},
			hms => q{hh.mm.ss a},
			ms => q{mm.ss},
			y => q{y. G},
			yyyy => q{y. G},
			yyyyM => q{M.y. G},
			yyyyMEd => q{E, d.M.y. G},
			yyyyMM => q{MM.y. G},
			yyyyMMM => q{MMM y. G},
			yyyyMMMEd => q{E, d. MMM y. G},
			yyyyMMMM => q{MMMM y. G},
			yyyyMMMd => q{d. MMM y. G},
			yyyyMMdd => q{dd.MM.y. G},
			yyyyMd => q{d.M.y. G},
			yyyyQQQ => q{QQQ, y. G},
			yyyyQQQQ => q{QQQQ y. G},
		},
		'gregorian' => {
			E => q{E},
			EHm => q{E, HH:mm},
			EHms => q{E, HH:mm:ss},
			Ed => q{E d.},
			Ehm => q{E, h:mm a},
			Ehms => q{E, h:mm:ss a},
			Gy => q{y. G},
			GyMMM => q{MMM y. G},
			GyMMMEd => q{E, d. MMM y. G},
			GyMMMd => q{d. MMM y. G},
			H => q{HH},
			Hm => q{HH.mm},
			Hms => q{HH.mm.ss},
			M => q{L},
			MEd => q{E, M-d},
			MMM => q{LLL},
			MMMEd => q{E d. MMM},
			MMMMEd => q{E d. MMMM},
			MMMMd => q{d. MMMM},
			MMMd => q{d. MMM},
			MMMdd => q{dd.MMM},
			MMdd => q{MM-dd},
			Md => q{d/M},
			d => q{d},
			h => q{hh a},
			hm => q{hh.mm a},
			hms => q{hh.mm.ss a},
			ms => q{mm.ss},
			y => q{y.},
			yM => q{M.y.},
			yMEd => q{E, d.M.y.},
			yMM => q{MM.y.},
			yMMM => q{MMM y.},
			yMMMEd => q{E, d. MMM y.},
			yMMMM => q{MMMM y.},
			yMMMd => q{d. MMM y.},
			yMMdd => q{dd.MM.y.},
			yMd => q{d.M.y.},
			yQQQ => q{QQQ. y},
			yQQQQ => q{QQQQ. y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH.mm-HH.mm},
				m => q{HH.mm-HH.mm},
			},
			Hmv => {
				H => q{HH.mm-HH.mm v},
				m => q{HH.mm-HH.mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d.M - E, d.M},
				d => q{E, d.M - E, d.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM - E, dd. MMM},
				d => q{E, dd. - E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM - dd. MMM},
				d => q{dd.-dd. MMM},
			},
			Md => {
				M => q{d.M - d.M},
				d => q{d.M - d.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h.mm a - h.mm a},
				h => q{h.mm-h.mm a},
				m => q{h.mm-h.mm a},
			},
			hmv => {
				a => q{h.mm a - h.mm a v},
				h => q{h.mm-h.mm a v},
				m => q{h.mm-h.mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{y M - M},
				y => q{M.y - M.y},
			},
			yMEd => {
				M => q{E, d.M.y. - E, d.M.y.},
				d => q{E, d.M.y. - E, d.M.y.},
				y => q{E, d.M.y. - E, d.M.y.},
			},
			yMMM => {
				M => q{MMM-MMM y.},
				y => q{MMM y. - MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM - E, dd. MMM y.},
				d => q{E, dd. - E, dd. MMM y.},
				y => q{E, dd. MMM y. - E, dd. MMM y.},
			},
			yMMMM => {
				M => q{y-MM – MM},
				y => q{y-MM – y-MM},
			},
			yMMMd => {
				M => q{dd. MMM - dd. MMM y.},
				d => q{dd.-dd. MMM y.},
				y => q{dd. MMM y. - dd. MMM y.},
			},
			yMd => {
				M => q{d.M.y. - d.M.y.},
				d => q{d.M.y. - d.M.y.},
				y => q{d.M.y. - d.M.y.},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH-HH},
			},
			Hm => {
				H => q{HH.mm-HH.mm},
				m => q{HH.mm-HH.mm},
			},
			Hmv => {
				H => q{HH.mm-HH.mm v},
				m => q{HH.mm-HH.mm v},
			},
			Hv => {
				H => q{HH-HH v},
			},
			M => {
				M => q{M-M},
			},
			MEd => {
				M => q{E, d.M - E, d.M},
				d => q{E, d.M - E, d.M},
			},
			MMM => {
				M => q{MMM-MMM},
			},
			MMMEd => {
				M => q{E, dd. MMM - E, dd. MMM},
				d => q{E, dd. - E, dd. MMM},
			},
			MMMd => {
				M => q{dd. MMM - dd. MMM},
				d => q{dd.-dd. MMM},
			},
			Md => {
				M => q{d.M - d.M},
				d => q{d.M - d.M},
			},
			d => {
				d => q{d-d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{h a - h a},
				h => q{h-h a},
			},
			hm => {
				a => q{h.mm a - h.mm a},
				h => q{h.mm-h.mm a},
				m => q{h.mm-h.mm a},
			},
			hmv => {
				a => q{h.mm a - h.mm a v},
				h => q{h.mm-h.mm a v},
				m => q{h.mm-h.mm a v},
			},
			hv => {
				a => q{h a - h a v},
				h => q{h-h a v},
			},
			y => {
				y => q{y-y},
			},
			yM => {
				M => q{y M - M},
				y => q{y M - M},
			},
			yMEd => {
				M => q{E, d.M.y. - E, d.M.y.},
				d => q{E, d.M.y. - E, d.M.y.},
				y => q{E, d.M.y. - E, d.M.y.},
			},
			yMMM => {
				M => q{MMM-MMM y.},
				y => q{MMM y. - MMM y.},
			},
			yMMMEd => {
				M => q{E, dd. MMM - E, dd. MMM y.},
				d => q{E, dd. - E, dd. MMM y.},
				y => q{E, dd. MMM y. - E, dd. MMM y.},
			},
			yMMMM => {
				M => q{y-MM – MM},
				y => q{y-MM – y-MM},
			},
			yMMMd => {
				M => q{dd. MMM - dd. MMM y.},
				d => q{dd.-dd. MMM y.},
				y => q{dd. MMM y. - dd. MMM y.},
			},
			yMd => {
				M => q{d.M.y. - d.M.y.},
				d => q{d.M.y. - d.M.y.},
				y => q{d.M.y. - d.M.y.},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HHmm;-HHmm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q(Време у земљи: {0}),
		regionFormat => q({0}, летње време),
		regionFormat => q({0}, стандардно време),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q(Акре летње рачунање времена),
				'generic' => q(Акре време),
				'standard' => q(Акре стандардно време),
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q(Авганистан време),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиџан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Акра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Адис Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмера#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуи#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисао#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантир#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Бразавил#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Буџумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каиро#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Казабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-ес-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Џибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Ел Ајун#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габорон#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Јоханесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Џуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Картум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревил#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадиш#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровија#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Најроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нџамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Нијамеј#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сао Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Централно-афричко време),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Источно-афричко време),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Јужно-афричко време),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Западно-афричко летње рачунање времена),
				'generic' => q(Западно-афричко време),
				'standard' => q(Западно-афричко стандардно време),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аљашко летње време),
				'generic' => q(Аљашко време),
				'standard' => q(Аљашко стандардно време),
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q(Алмати летње рачунање времена),
				'generic' => q(Алмати време),
				'standard' => q(Алмати стандардно време),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазон летње рачунање времена),
				'generic' => q(Амазон време),
				'standard' => q(Амазон стандардно време),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Енкориџ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангвила#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигва#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагвајана#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио Гелегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуаија#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсион#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баија#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баија Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Сејблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бојзи#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буенос Ајрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембриџ Беј#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кајен#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кајманска Острва#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал Харбур#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Костарика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куиаба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кирасо#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхаген#,
		},
		'America/Dawson' => {
			exemplarCity => q#Досон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детроит#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Едмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Еирунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Салвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глејс Беј#,
		},
		'America/Godthab' => {
			exemplarCity => q#Готхаб#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус Беј#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гвадалупе#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гвајакил#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гвајана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосиљо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индијана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индијана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индијана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вевај, Индијана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винценес, Индијана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индијана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Иквалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Јамајка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуи#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичело, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендајк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос Анђелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луивиле#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуер Принсиз Квортер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масејо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагва#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мексико Сити#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтереј#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсерат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Насау#,
		},
		'America/New_York' => {
			exemplarCity => q#Њујорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Нороња#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бијула, Северна Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Центар, Северна Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нови Салем, Северна Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртунг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт оф Спејн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто Вељо#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Порто Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рејни Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифе#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Ресолут#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио Бранко#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантјаго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сао Паоло#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорезбисунд#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Св. Бартоломeј#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Св. Џон#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Св. Луција#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Св. Тома#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Курент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигалпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Тул#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер Беј#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Вајтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Винипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Јакутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Јелоунајф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Северноамерички Централно летње рачунање времена),
				'generic' => q(Северноамерички Централно време),
				'standard' => q(Северноамерички Централно стандардно време),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Северноамерички Источно летње рачунање времена),
				'generic' => q(Северноамерички Источно време),
				'standard' => q(Северноамерички Источно стандардно време),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Северноамерички Планинско летње рачунање времена),
				'generic' => q(Северноамерички Планинско време),
				'standard' => q(Северноамерички Планинско стандардно време),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Северноамерички Пацифичко летње рачунање времена),
				'generic' => q(Северноамерички Пацифичко време),
				'standard' => q(Северноамерички Пацифичко стандардно време),
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q(Анадир летње рачунање времена),
				'generic' => q(Анадир време),
				'standard' => q(Анадир стандардно време),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кејси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дејвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Димон д’Урвил#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Меквори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Мосон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Макмурдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Шова#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Трол#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Апија летње рачунање времена),
				'generic' => q(Апија време),
				'standard' => q(Апија стандардно време),
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q(Акватау летње рачунање времена),
				'generic' => q(Акватау време),
				'standard' => q(Акватау стандардно време),
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q(Акутобе летње рачунање времена),
				'generic' => q(Акутобе време),
				'standard' => q(Акутобе стандардно време),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Арабијско летње рачунање времена),
				'generic' => q(Арабијско време),
				'standard' => q(Арабијско стандардно време),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгјербјен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аргентина летње рачунање времена),
				'generic' => q(Аргентина време),
				'standard' => q(Аргентина стандардно време),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Западна Аргентина летње рачунање времена),
				'generic' => q(Западна Аргентина време),
				'standard' => q(Западна Аргентина стандардно време),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Арменија летње рачунање времена),
				'generic' => q(Арменија време),
				'standard' => q(Арменија стандардно време),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алмати#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Аман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадир#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Акутобе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахреин#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Банкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бејрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Брунеји#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калкута#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чојбалсан#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#Чонгкинг#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубаи#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#Харбин#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркуцк#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Џакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Џајапура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Јерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#Кашгар#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандига#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Краснојарск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувајт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макасар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никозија#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузњецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пном Пен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтијанак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пјонгјанг#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кизилорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Ријад#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шангај#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тајпеј#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Техеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тимпу#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Урумкви#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вијентијан#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Јакутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Јекатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Јереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атланско лтње рачунање времена),
				'generic' => q(Атланско време),
				'standard' => q(Атланско стандардно време),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азори#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канарска острва#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Зеленортска Острва#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарска Острва#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадеира#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рејкјавик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Јужна Џорџија#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Света Јелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделејд#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Бризбејн#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хил#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Курие#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Иукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хау#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мелбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сиднеј#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Аустралијско централно летње рачунање времена),
				'generic' => q(Аустралијско централно време),
				'standard' => q(Аустралијско централно стандардно време),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Аустралијско централно западно летње рачунање времена),
				'generic' => q(Аустралијско централно западно време),
				'standard' => q(Аустралијско централно западно стандардно време),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Аустралијско источно летње рачунање времена),
				'generic' => q(Аустралијско источно време),
				'standard' => q(Аустралијско источно стандардно време),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Аустралијско западно летње рачунање времена),
				'generic' => q(Аустралијско западно време),
				'standard' => q(Аустралијско западно стандардно време),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Азербејџан летње рачунање времена),
				'generic' => q(Азербејџан време),
				'standard' => q(Азербејџан стандардно време),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азори летње рачунање времена),
				'generic' => q(Азори време),
				'standard' => q(Азори стандардно време),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладеш летње рачунање времена),
				'generic' => q(Бангладеш време),
				'standard' => q(Бангладеш стандардно време),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутан време),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливија време),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилија летње рачунање времена),
				'generic' => q(Бразилија време),
				'standard' => q(Бразилија стандардно време),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Брунеј Дарусалум време),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Зеленортско летње рачунање времена),
				'generic' => q(Зелениртско време),
				'standard' => q(Зелениртско стандардно време),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморо време),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чатам летње рачунање времена),
				'generic' => q(Чатам време),
				'standard' => q(Чатам стандардно време),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чиле летње рачунање времена),
				'generic' => q(Чиле време),
				'standard' => q(Чиле стандардно време),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Кина летње рачунање времена),
				'generic' => q(Кина време),
				'standard' => q(Кинеско стандардно време),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чојбалсан летње рачунање времена),
				'generic' => q(Чојбалсан време),
				'standard' => q(Чојбалсан стандардно време),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Божићна острва време),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокос (Келинг) Острва време),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбија летње рачунање времена),
				'generic' => q(Колумбија време),
				'standard' => q(Колумбија стандардно време),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Кукова острва полу-летње рачунање времена),
				'generic' => q(Кукова острва време),
				'standard' => q(Кукова острва стандардно време),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Куба летње рачунање времена),
				'generic' => q(Куба време),
				'standard' => q(Куба стандардно време),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дејвис време),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Димон д’Урвил време),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Источни тимор време),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Ускршња острва летње рачунање времена),
				'generic' => q(Ускршња острва време),
				'standard' => q(Ускршња острва стандардно време),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Еквадор време),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Непознат град#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андора#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Атина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Београд#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брисел#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Букурешт#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будимпешта#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бисинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишињев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенхаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Даблин#,
			long => {
				'daylight' => q(ирско летње време),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернзи#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Острво Ман#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Џерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калињинград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Кијев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лисабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Љубљана#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(британско летње време),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Луксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Малта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париз#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Праг#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сарајево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферопољ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопље#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#Софија#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокхолм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Талин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Беч#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вилњус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожје#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цирих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Средњеевропско летње рачунање времена),
				'generic' => q(Средњеевропско време),
				'standard' => q(Средњеевропско стандардно време),
			},
			short => {
				'daylight' => q(CEST),
				'generic' => q(CET),
				'standard' => q(CET),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Источноевропско летње рачунање времена),
				'generic' => q(Источноевропско време),
				'standard' => q(Источноевропско стандардно време),
			},
			short => {
				'daylight' => q(EEST),
				'generic' => q(EET),
				'standard' => q(EET),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(даљи исток Европе),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Западноевропско летње рачунање времена),
				'generic' => q(Западноевропско време),
				'standard' => q(Западноевропско стандардно време),
			},
			short => {
				'daylight' => q(WEST),
				'generic' => q(WET),
				'standard' => q(WET),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолкландска Острва летње рачунање времена),
				'generic' => q(Фолкландска Острва време),
				'standard' => q(Фолкландска Острва стандардно време),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фиџи летње рачунање времена),
				'generic' => q(Фиџи време),
				'standard' => q(Фиџи стандардно време),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Француска Гвајана време),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Француско јужно и антарктичко време),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Средње време по Гриничу),
			},
			short => {
				'standard' => q(GMT),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагос време),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбијер време),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Грузија летње рачунање времена),
				'generic' => q(Грузија време),
				'standard' => q(Грузија стандардно време),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Гилберт острва време),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Источни Гренланд летње рачунање времена),
				'generic' => q(Источни Гренланд време),
				'standard' => q(Источни Гренланд стандардно време),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Западни Гренланд летње рачунање времена),
				'generic' => q(Западни Гренланд време),
				'standard' => q(Западни Гренланд стандардно време),
			},
		},
		'Guam' => {
			long => {
				'standard' => q(Гуам стандардно време),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Заливско време),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гвајана време),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Хавајско-алеутско летње рачунање времена),
				'generic' => q(Хавајско-алеутско време),
				'standard' => q(Хавајско-алеутско стандардно време),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Хонг Конг летње рачунање времена),
				'generic' => q(Хонг Конг време),
				'standard' => q(Хонг Конг стандардно време),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховд летње рачунање времена),
				'generic' => q(Ховд време),
				'standard' => q(Ховд стандардно време),
			},
		},
		'India' => {
			long => {
				'standard' => q(Индијско стандардно време),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Божић#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Малдиви#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маурицијус#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Мајот#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реунион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Индијско океанско време),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Индокина време),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Централно-индонезијско време),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Источно-индонезијско време),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Западно-индонезијско време),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Иран летње рачунање времена),
				'generic' => q(Иран време),
				'standard' => q(Иран стандардно време),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Иркуцк летње рачунање времена),
				'generic' => q(Иркуцк време),
				'standard' => q(Иркуцк стандардно време),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израелско летње рачунање времена),
				'generic' => q(Израелско време),
				'standard' => q(Израелско стандардно време),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Јапанско летње рачунање времена),
				'generic' => q(Јапанско време),
				'standard' => q(Јапанско стандардно време),
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q(Петропавловско-камчатско летње рачунање времена),
				'generic' => q(Петропавловско-камчатско време),
				'standard' => q(Петропавловско-камчатско стандардно време),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Источно-казахстанско време),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Западно-казахстанско време),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Корејско летње рачунање времена),
				'generic' => q(Корејско време),
				'standard' => q(Корејско стандардно време),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Кошре време),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Краснојарск летње рачунање времена),
				'generic' => q(Краснојарск време),
				'standard' => q(Краснојарск стандардно време),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Киргизстан време),
			},
		},
		'Lanka' => {
			long => {
				'standard' => q(Шри Ланка време),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Лине Острва време),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд Хов летње рачунање времена),
				'generic' => q(Лорд Хов време),
				'standard' => q(Лорд Хов стандардно време),
			},
		},
		'Macau' => {
			long => {
				'daylight' => q(Макао летње рачунање времена),
				'generic' => q(Макао време),
				'standard' => q(Макао стандардно време),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Макверијско време),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магадан летње рачунање времена),
				'generic' => q(Магадан време),
				'standard' => q(Магадан стандардно време),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малезија време),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Малдиви време),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркиз време),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршалска Острва време),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Маурицијус летње рачунање времена),
				'generic' => q(Маурицијус време),
				'standard' => q(Маурицијус стандардно време),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Мосон време),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Северозападни Мексико летње рачунање времена),
				'generic' => q(Северни Мексико),
				'standard' => q(Северозападни Мексико стандардно време),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Мексички Пацифик летње рачунање времена),
				'generic' => q(Мексички Пацифик),
				'standard' => q(Мексички Пацифик стандардно време),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Улан Батор летње рачунање времена),
				'generic' => q(Улан Батор време),
				'standard' => q(Улан Батор стандардно време),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Москва летње рачунање времена),
				'generic' => q(Москва време),
				'standard' => q(Москва стандардно време),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мијанмар време),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науру време),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Непал време),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Нова Каледонија летње рачунање времена),
				'generic' => q(Нова Каледонија време),
				'standard' => q(Нова Каледонија стандардно време),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Нови Зеланд летње рачунање времена),
				'generic' => q(Нови Зеланд време),
				'standard' => q(Нови Зеланд стандардно време),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Њуфаундленд летње рачунање времена),
				'generic' => q(Њуфаундленд време),
				'standard' => q(Њуфаундленд стандардно време),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуе време),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк Острво време),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернандо де Нороња летње рачунање времена),
				'generic' => q(Фернандо де Нороња време),
				'standard' => q(Фернандо де Нороња стандардно време),
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q(Северна Маријанска Острва време),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосибирск летње рачунање времена),
				'generic' => q(Новосибирск време),
				'standard' => q(Новосибирск стандардно време),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омск летње рачунање времена),
				'generic' => q(Омск време),
				'standard' => q(Омск стандардно време),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апија#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окланд#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатам#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Ускршње острво#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Ефат#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Ендербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиџи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбије#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Џонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Кошре#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваџалејин#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мајуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидвеј#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуе#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт Морзби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сајпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Тахити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Трук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Вејк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Валис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пакистан летње рачунање времена),
				'generic' => q(Пакистан време),
				'standard' => q(Пакистан стандардно време),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палау време),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа Нова Гвинеја време),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвај летње рачунање времена),
				'generic' => q(Парагвај време),
				'standard' => q(Парагвај стандардно време),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перу летње рачунање времена),
				'generic' => q(Перу време),
				'standard' => q(Перу стандардно време),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филипини летње рачунање времена),
				'generic' => q(Филипини време),
				'standard' => q(Филипини стандардно време),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Феникс острва време),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сен Пјер и Микелон летње рачунање времена),
				'generic' => q(Сен Пјер и Микелон време),
				'standard' => q(Сен Пјер и Микелон стандардно време),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкерн време),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понпеи време),
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q(Кизилорда летње рачунање времена),
				'generic' => q(Кизилорда време),
				'standard' => q(Кизилорда стандардно време),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реинион време),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротера време),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалин летње рачунање времена),
				'generic' => q(Сахалин време),
				'standard' => q(Сахалин стандардно време),
			},
		},
		'Samara' => {
			long => {
				'daylight' => q(Самара летње рачунање времена),
				'generic' => q(Самара време),
				'standard' => q(Самара стандардно време),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоа летње рачунање времена),
				'generic' => q(Самоа време),
				'standard' => q(Самоа стандардно време),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сејшели време),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапур стандардно време),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломонска Острва време),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Јужна Џорџија време),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринам),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Шова време),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Тахити време),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Таипеи летње рачунање времена),
				'generic' => q(Таипеи време),
				'standard' => q(Таипеи стандардно време),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Таџикистан време),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелау време),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонга летње рачунање времена),
				'generic' => q(Тонга време),
				'standard' => q(Тонга стандардно време),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Чуук време),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Туркменистан летње рачунање времена),
				'generic' => q(Туркменистан време),
				'standard' => q(Туркменистан стандардно време),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалу време),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвај летње рачунање времена),
				'generic' => q(Уругвај време),
				'standard' => q(Уругвај стандардно време),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Узбекистан летње рачунање времена),
				'generic' => q(Узбекистан време),
				'standard' => q(Узбекистан стандардно време),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануату летње рачунање времена),
				'generic' => q(Вануату време),
				'standard' => q(Вануату стандардно време),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венецуела време),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивосток летње рачунање времена),
				'generic' => q(Владивосток време),
				'standard' => q(Владивосток стандардно време),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоград летње рачунање времена),
				'generic' => q(Волгоград време),
				'standard' => q(Волгоград стандардно време),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Восток време),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Вејк острво време),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Валис и Футуна Острва време),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Јакутск летње рачунање времена),
				'generic' => q(Јакутск време),
				'standard' => q(Јакутск стандардно време),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Јекатеринбург летње рачунање времена),
				'generic' => q(Јекатеринбург време),
				'standard' => q(Јекатеринбург стандардно време),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
