package Locale::CLDR::Pa;
# This file auto generated from Data\common\main\pa.xml
#	on Tue 10 Jun 10:13:34 pm GMT
# XML file generated 2014-02-28 23:57:43 -0600 (Fri, 28 Feb 2014)

use version;

our $VERSION = version->declare('v0.25.3');

use v5.10;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Moose;

extends('Locale::CLDR::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $territory, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$territory,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'ਅਬਖਾਜ਼ੀਅਨ',
 				'ace' => 'ਅਚੀਨੀ',
 				'ach' => 'ਅਕੋਲੀ',
 				'af' => 'ਅਫ਼ਰੀਕੀ',
 				'am' => 'ਅਮਹਾਰਿਕ',
 				'ar' => 'ਅਰਬੀ',
 				'ar_001' => 'ਆਧੁਨਿਕ ਸਟੈਂਡਰਡ ਅਰਬੀ',
 				'as' => 'ਅਸਾਮੀ',
 				'az' => 'ਅਜ਼ਰਬੈਜਾਨੀ',
 				'be' => 'ਬੇਲਾਰੂਸੀ',
 				'bg' => 'ਬੁਲਗਾਰੀਅਨ',
 				'bn' => 'ਬੰਗਾਲੀ',
 				'bo' => 'ਤਿੱਬਤੀ',
 				'bs' => 'ਬੋਸਨੀਅਨ',
 				'ca' => 'ਕੈਟਾਲਾਨ',
 				'cs' => 'ਚੈਕ',
 				'cy' => 'ਵੈਲਸ਼',
 				'da' => 'ਡੈਨਿਸ਼',
 				'de' => 'ਜਰਮਨ',
 				'de_AT' => 'ਔਸਟ੍ਰੀਅਨ ਜਰਮਨ',
 				'de_CH' => 'ਸਵਿਸ',
 				'el' => 'ਗ੍ਰੀਕ',
 				'en' => 'ਅੰਗਰੇਜ਼ੀ',
 				'en_AU' => 'ਆਸਟ੍ਰੇਲੀਆਈ ਅੰਗਰੇਜ਼ੀ',
 				'en_CA' => 'ਕਨੈਡੀਅਨ ਅੰਗਰੇਜ਼ੀ',
 				'en_GB' => 'ਬ੍ਰਿਟਿਸ਼ ਅੰਗਰੇਜ਼ੀ',
 				'en_GB@alt=short' => 'ਯੂ.ਕੇ ਅੰਗਰੇਜ਼ੀ',
 				'en_US' => 'ਅਮਰੀਕੀ ਅੰਗਰੇਜ਼ੀ',
 				'en_US@alt=short' => 'ਯੂ.ਐਸ. ਅੰਗਰੇਜ਼ੀ',
 				'eo' => 'ਇਸਪੇਰਾਂਟੋ',
 				'es' => 'ਸਪੈਨਿਸ਼',
 				'es_419' => 'ਲੈਟਿਨ ਅਮਰੀਕੀ ਸਪੈਨਿਸ਼',
 				'es_ES' => 'ਯੂਰੋਪੀਅਨ ਸਪੈਨਿਸ਼',
 				'es_MX' => 'ਮੈਕਸੀਕਨ ਸਪੈਨਿਸ਼',
 				'et' => 'ਇਸਟੋਨੀਅਨ',
 				'eu' => 'ਬਾਸਕੀ',
 				'fa' => 'ਫ਼ਾਰਸੀ',
 				'fi' => 'ਫਿਨਿਸ਼',
 				'fil' => 'ਫਿਲੀਪਿਨੋ',
 				'fj' => 'ਫਿਜੀਅਨ',
 				'fo' => 'ਫ਼ੇਰੋਸੇ',
 				'fr' => 'ਫ੍ਰੈਂਚ',
 				'fr_CA' => 'ਕਨੈਡੀਅਨ ਫ੍ਰੈਂਚ',
 				'fr_CH' => 'ਸਵਿਸ ਫ੍ਰੈਂਚ',
 				'fy' => 'ਪਛਮੀ ਫ੍ਰਿਸ਼ੀਅਨ',
 				'ga' => 'ਆਇਰਿਸ਼',
 				'gl' => 'ਗੈਲਿਸ਼ਿਅਨ',
 				'gn' => 'ਗੁਆਰਾਨੀ',
 				'gsw' => 'ਸਵਿਸ ਜਰਮਨ',
 				'gu' => 'ਗੁਜਰਾਤੀ',
 				'ha' => 'ਹੌਸਾ',
 				'haw' => 'ਹਵਾਈਅਨ',
 				'he' => 'ਯਹੂਦੀ',
 				'hi' => 'ਹਿੰਦੀ',
 				'hr' => 'ਕ੍ਰੋਏਸ਼ਿਆਈ',
 				'ht' => 'ਹਾਈਟਿਅਨ',
 				'hu' => 'ਹੰਗੇਰੀਅਨ',
 				'hy' => 'ਆਰਮੀਨੀਅਨ',
 				'id' => 'ਇੰਡੋਨੇਸ਼ੀਆਈ',
 				'ig' => 'ਇਗਬੋ',
 				'is' => 'ਆਈਸਲੈਂਡਿਕ',
 				'it' => 'ਇਤਾਲਵੀ',
 				'ja' => 'ਜਾਪਾਨੀ',
 				'jv' => 'ਜਾਵਾਨੀਜ਼',
 				'ka' => 'ਜਾਰਜੀਅਨ',
 				'kk' => 'ਕਜ਼ਾਖ਼',
 				'km' => 'ਖਮੇਰ',
 				'kn' => 'ਕੰਨੜ',
 				'ko' => 'ਕੋਰੀਆਈ',
 				'ks' => 'ਕਸ਼ਮੀਰੀ',
 				'ku' => 'ਕੁਰਦਿਸ਼',
 				'ky' => 'ਕਿਰਗੀਜ਼',
 				'la' => 'ਲੈਟਿਨ',
 				'lb' => 'ਲਕਜ਼ਮਬਰਗਿਸ਼',
 				'lo' => 'ਲਾਓ',
 				'lt' => 'ਲਿਥੁਆਨੀਅਨ',
 				'lv' => 'ਲਾਟਵਿਅਨ',
 				'mg' => 'ਮਾਲਾਗੈਸੀ',
 				'mi' => 'ਮਾਉਰੀ',
 				'mk' => 'ਮੈਕਡੋਨੀਅਨ',
 				'ml' => 'ਮਲਿਆਲਮ',
 				'mr' => 'ਮਰਾਠੀ',
 				'ms' => 'ਮਲਯ',
 				'mt' => 'ਮਾਲਟੀਜ਼',
 				'my' => 'ਬਰਮੀ',
 				'nb' => 'ਨੌਰਵੇਜਿਅਨ ਬੋਕਮਲ',
 				'ne' => 'ਨੇਪਾਲੀ',
 				'nl' => 'ਡੱਚ',
 				'nl_BE' => 'ਫਲੈਮਿਸ਼',
 				'nn' => 'ਨੌਰਵੇਜਿਅਨ ਨਿਨੋਰਸ੍ਕ',
 				'no' => 'ਨਾਰਵੇਜੀਅਨ',
 				'or' => 'ਉੜੀਆ',
 				'pa' => 'ਪੰਜਾਬੀ',
 				'pl' => 'ਪੋਲਿਸ਼',
 				'ps' => 'ਪਸ਼ਤੋ',
 				'pt' => 'ਪੁਰਤਗਾਲੀ',
 				'pt_BR' => 'ਬ੍ਰਾਜ਼ਿਲੀਅਨ ਪੁਰਤਗਾਲੀ',
 				'pt_PT' => 'ਯੂਰੋਪੀਅਨ ਪੁਰਤਗਾਲੀ',
 				'qu' => 'ਕਿਊਚੁਆ',
 				'rm' => 'ਰੋਮਾਂਸ਼',
 				'ro' => 'ਰੋਮਾਨੀਆਈ',
 				'ru' => 'ਰੂਸੀ',
 				'sa' => 'ਸੰਸਕ੍ਰਿਤ',
 				'sd' => 'ਸਿੰਧੀ',
 				'si' => 'ਸਿੰਹਾਲਾ',
 				'sk' => 'ਸਲੋਵਾਕ',
 				'sl' => 'ਸਲੋਵੇਨੀਅਨ',
 				'so' => 'ਸੋਮਾਲੀ',
 				'sq' => 'ਅਲਬਾਨੀਅਨ',
 				'sr' => 'ਸਰਬਿਆਈ',
 				'su' => 'ਸੂਡਾਨੀ',
 				'sv' => 'ਸਵੀਡਿਸ਼',
 				'sw' => 'ਸਵਾਹਿਲੀ',
 				'ta' => 'ਤਮਿਲ',
 				'te' => 'ਤੇਲਗੂ',
 				'tg' => 'ਤਾਜਿਕ',
 				'th' => 'ਥਾਈ',
 				'ti' => 'ਟਿਗਰੀਨਿਆ',
 				'tk' => 'ਤੁਰਕਮੇਨ',
 				'to' => 'ਟੌਂਗਨ',
 				'tr' => 'ਤੁਰਕਿਸ਼',
 				'tt' => 'ਤਤਾਰ',
 				'tw' => 'ਤ੍ਵਿ',
 				'ug' => 'ਉਇਗੁਰ',
 				'uk' => 'ਯੂਕਰੇਨੀਅਨ',
 				'und' => 'ਅਗਿਆਤ ਭਾਸ਼ਾ',
 				'ur' => 'ਉਰਦੂ',
 				'uz' => 'ਉਜ਼ਬੇਕ',
 				'vi' => 'ਵਿਯਤਨਾਮੀ',
 				'wo' => 'ਵੋਲੋਫ',
 				'xh' => 'ਖੋਸਾ',
 				'yo' => 'ਯੋਰੂਬਾ',
 				'zgh' => 'ਸਟੈਂਡਰਡ ਮੋਰੋਕੈਨ ਟੈਮਾਜ਼ਾਈਟ',
 				'zh' => 'ਚੀਨੀ',
 				'zh_Hans' => 'ਸਰਲ ਕੀਤੀ ਚੀਨੀ',
 				'zh_Hant' => 'ਰਵਾਇਤੀ ਚੀਨੀ',
 				'zu' => 'ਜ਼ੁਲੂ',
 				'zxx' => 'ਕੋਈ ਭਾਸ਼ਾ-ਵਿਗਿਆਨਿਕ ਸਮੱਗਰੀ ਨਹੀਂ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> 'CodeRef',
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'ਅਰਬੀ',
 			'Armn' => 'ਆਰਮੀਨੀਅਨ',
 			'Beng' => 'ਬੰਗਾਲੀ',
 			'Bopo' => 'ਬੋਪੋਮੋਫੋ',
 			'Brai' => 'ਬ੍ਰੇਲ',
 			'Cyrl' => 'ਸਿਰੀਲਿਕ',
 			'Deva' => 'ਦੇਵਨਾਗਰੀ',
 			'Ethi' => 'ਐਥਿਓਪਿਕ',
 			'Geor' => 'ਜਾਰਜੀਅਨ',
 			'Grek' => 'ਗ੍ਰੀਕ',
 			'Gujr' => 'ਗੁਜਰਾਤੀ',
 			'Guru' => 'ਗੁਰਮੁਖੀ',
 			'Hang' => 'ਹੰਗੁਲ',
 			'Hani' => 'ਹਾਨ',
 			'Hans' => 'ਸਰਲ ਕੀਤੀ',
 			'Hans@alt=stand-alone' => 'ਸਰਲ ਕੀਤੀ ਹਾਨ',
 			'Hant' => 'ਰਵਾਇਤੀ',
 			'Hant@alt=stand-alone' => 'ਰਵਾਇਤੀ ਹਾਨ',
 			'Hebr' => 'ਹਿਬਰੂ',
 			'Hira' => 'ਹਿਰਾਗਾਨਾ',
 			'Jpan' => 'ਜਾਪਾਨੀ',
 			'Kana' => 'ਕਾਟਾਕਾਨਾ',
 			'Khmr' => 'ਖਮੇਰ',
 			'Knda' => 'ਕੰਨੜ',
 			'Kore' => 'ਕੋਰੀਆਈ',
 			'Laoo' => 'ਲਾਓ',
 			'Latn' => 'ਲੈਟਿਨ',
 			'Mlym' => 'ਮਲਿਆਲਮ',
 			'Mong' => 'ਮੰਗੋਲੀਅਨ',
 			'Mymr' => 'ਮਿਆਂਮਾਰ',
 			'Orya' => 'ਉੜੀਆ',
 			'Sinh' => 'ਸਿੰਹਾਲਾ',
 			'Taml' => 'ਤਮਿਲ',
 			'Telu' => 'ਤੇਲਗੂ',
 			'Thaa' => 'ਥਾਨਾ',
 			'Thai' => 'ਥਾਈ',
 			'Tibt' => 'ਤਿੱਬਤੀ',
 			'Zsym' => 'ਪ੍ਰਤੀਕ ਲਿਪੀ',
 			'Zxxx' => 'ਅਲਿਖਤ',
 			'Zyyy' => 'ਸਧਾਰਨ',
 			'Zzzz' => 'ਅਗਿਆਤ ਲਿਪੀ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_territory' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ਵਿਸ਼ਵ',
 			'002' => 'ਅਫ਼ਰੀਕਾ',
 			'003' => 'ਉੱਤਰ ਅਮਰੀਕਾ',
 			'005' => 'ਦੱਖਣ ਅਮਰੀਕਾ',
 			'009' => 'ਓਸ਼ਨਿਆ',
 			'011' => 'ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ',
 			'013' => 'ਕੇਂਦਰੀ ਅਮਰੀਕਾ',
 			'014' => 'ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ',
 			'015' => 'ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ',
 			'017' => 'ਮੱਧਮ ਅਫ਼ਰੀਕਾ',
 			'018' => 'ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ',
 			'019' => 'ਅਮਰੀਕਾ',
 			'021' => 'ਉੱਤਰੀ ਅਮਰੀਕਾ',
 			'029' => 'ਕੈਰੇਬੀਅਨ',
 			'030' => 'ਪੂਰਬੀ ਏਸ਼ੀਆ',
 			'034' => 'ਦੱਖਣੀ ਏਸ਼ੀਆ',
 			'035' => 'ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ',
 			'039' => 'ਦੱਖਣੀ ਯੂਰਪ',
 			'053' => 'ਔਸਟ੍ਰਾਲੇਸ਼ੀਆ',
 			'054' => 'ਮੈਲਾਨੇਸ਼ੀਆ',
 			'057' => 'ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਖੇਤਰ',
 			'061' => 'ਪੋਲਿਨੇਸ਼ੀਆ',
 			'142' => 'ਏਸ਼ੀਆ',
 			'143' => 'ਕੇਂਦਰੀ ਏਸ਼ੀਆ',
 			'145' => 'ਪੱਛਮੀ ਏਸ਼ੀਆ',
 			'150' => 'ਯੂਰਪ',
 			'151' => 'ਪੂਰਬੀ ਯੂਰਪ',
 			'154' => 'ਉੱਤਰੀ ਯੂਰਪ',
 			'155' => 'ਪੱਛਮੀ ਯੂਰਪ',
 			'419' => 'ਲੈਟਿਨ ਅਮਰੀਕਾ',
 			'AC' => 'ਅਸੈਂਸ਼ਨ ਆਈਲੈਂਡ',
 			'AD' => 'ਅੰਡੋਰਾ',
 			'AE' => 'ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ',
 			'AF' => 'ਅਫ਼ਗਾਨਿਸਤਾਨ',
 			'AG' => 'ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ',
 			'AI' => 'ਅੰਗੁਇਲਾ',
 			'AL' => 'ਅਲਬਾਨੀਆ',
 			'AM' => 'ਆਰਮੀਨਿਆ',
 			'AO' => 'ਅੰਗੋਲਾ',
 			'AQ' => 'ਅੰਟਾਰਕਟਿਕਾ',
 			'AR' => 'ਅਰਜਨਟੀਨਾ',
 			'AS' => 'ਅਮੈਰੀਕਨ ਸਮੋਆ',
 			'AT' => 'ਆਸਟਰੀਆ',
 			'AU' => 'ਆਸਟ੍ਰੇਲੀਆ',
 			'AW' => 'ਅਰੂਬਾ',
 			'AX' => 'ਅਲੈਂਡ ਆਈਲੈਂਡਸ',
 			'AZ' => 'ਅਜ਼ਰਬੈਜਾਨ',
 			'BA' => 'ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ',
 			'BB' => 'ਬਾਰਬਾਡੋਸ',
 			'BD' => 'ਬੰਗਲਾਦੇਸ਼',
 			'BE' => 'ਬੈਲਜੀਅਮ',
 			'BF' => 'ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ',
 			'BG' => 'ਬੁਲਗਾਰਿਆ',
 			'BH' => 'ਬਹਿਰੀਨ',
 			'BI' => 'ਬੁਰੁੰਡੀ',
 			'BJ' => 'ਬੇਨਿਨ',
 			'BL' => 'ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ',
 			'BM' => 'ਬਰਮੂਡਾ',
 			'BN' => 'ਬਰੂਨੇਈ',
 			'BO' => 'ਬੋਲੀਵੀਆ',
 			'BQ' => 'ਕੈਰੇਬੀਅਨ ਨੀਦਰਲੈਂਡ',
 			'BR' => 'ਬ੍ਰਾਜ਼ੀਲ',
 			'BS' => 'ਬਹਾਮਾਸ',
 			'BT' => 'ਭੂਟਾਨ',
 			'BV' => 'ਬੌਵੇਟ ਆਈਲੈਂਡ',
 			'BW' => 'ਬੋਟਸਵਾਨਾ',
 			'BY' => 'ਬੇਲਾਰੂਸ',
 			'BZ' => 'ਬੇਲੀਜ਼',
 			'CA' => 'ਕੈਨੇਡਾ',
 			'CC' => 'ਕੋਕੋਜ਼ (ਕੀਲਿੰਗ) ਆਈਲੈਂਡਸ',
 			'CD' => 'ਕਾਂਗੋ - ਕਿਂਸ਼ਾਸਾ',
 			'CD@alt=variant' => 'ਕਾਂਗੋ ਲੋਕਤੰਤਰੀ ਗਣਰਾਜ',
 			'CF' => 'ਕੇਂਦਰੀ ਅਫਰੀਕੀ ਗਣਰਾਜ',
 			'CG' => 'ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ',
 			'CG@alt=variant' => 'ਕਾਂਗੋ ਗਣਰਾਜ',
 			'CH' => 'ਸਵਿਟਜ਼ਰਲੈਂਡ',
 			'CI' => 'ਕੋਟ ਡੀਵੋਆਰ',
 			'CI@alt=variant' => 'ਆਇਵਰੀ ਕੋਸਟ',
 			'CK' => 'ਕੁਕ ਆਈਲੈਂਡਸ',
 			'CL' => 'ਚਿਲੀ',
 			'CM' => 'ਕੈਮਰੂਨ',
 			'CN' => 'ਚੀਨ',
 			'CO' => 'ਕੋਲੰਬੀਆ',
 			'CP' => 'ਕਲਿਪਰਟਨ ਆਈਲੈਂਡ',
 			'CR' => 'ਕੋਸਟਾ ਰੀਕਾ',
 			'CU' => 'ਕਿਊਬਾ',
 			'CV' => 'ਕੇਪ ਵਰਡ',
 			'CW' => 'ਕੁਰਾਕਾਓ',
 			'CX' => 'ਕ੍ਰਿਸਮਸ ਆਈਲੈਂਡ',
 			'CY' => 'ਸਾਇਪਰਸ',
 			'CZ' => 'ਚੈਕ ਗਣਰਾਜ',
 			'DE' => 'ਜਰਮਨੀ',
 			'DG' => 'ਡੀਗੋ ਗਾਰਸ਼ੀਆ',
 			'DJ' => 'ਜ਼ੀਬੂਤੀ',
 			'DK' => 'ਡੈਨਮਾਰਕ',
 			'DM' => 'ਡੋਮੀਨਿਕਾ',
 			'DO' => 'ਡੌਮਿਨਿਕਨ ਗਣਰਾਜ',
 			'DZ' => 'ਅਲਜੀਰੀਆ',
 			'EA' => 'ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ',
 			'EC' => 'ਇਕਵੇਡੋਰ',
 			'EE' => 'ਇਸਟੋਨੀਆ',
 			'EG' => 'ਮਿਸਰ',
 			'EH' => 'ਪੱਛਮੀ ਸਹਾਰਾ',
 			'ER' => 'ਇਰੀਟ੍ਰਿਆ',
 			'ES' => 'ਸਪੇਨ',
 			'ET' => 'ਇਥੋਪੀਆ',
 			'EU' => 'ਯੂਰੋਪੀਅਨ ਯੂਨਿਅਨ',
 			'FI' => 'ਫਿਨਲੈਂਡ',
 			'FJ' => 'ਫ਼ਿਜੀ',
 			'FK' => 'ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ',
 			'FK@alt=variant' => 'ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ (ਆਈਲਾਸ ਮਾਲਵਿਨਾਸ)',
 			'FM' => 'ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ',
 			'FO' => 'ਫੈਰੋ ਆਇਲੈਂਡਸ',
 			'FR' => 'ਫ੍ਰਾਂਸ',
 			'GA' => 'ਗਾਬੋਨ',
 			'GB' => 'ਯੁਨਾਇਟੇਡ ਕਿੰਗਡਮ',
 			'GB@alt=short' => 'ਯੂ.ਕੇ.',
 			'GD' => 'ਗ੍ਰੇਨਾਡਾ',
 			'GE' => 'ਜਾਰਜਿਆ',
 			'GF' => 'ਫ੍ਰੈਂਚ ਗੁਏਨਾ',
 			'GG' => 'ਗਰਨਸੀ',
 			'GH' => 'ਘਾਨਾ',
 			'GI' => 'ਜਿਬਰਾਲਟਰ',
 			'GL' => 'ਗ੍ਰੀਨਲੈਂਡ',
 			'GM' => 'ਗਾਂਬੀਆ',
 			'GN' => 'ਗਿਨੀ',
 			'GP' => 'ਗੁਆਡੇਲੋਪ',
 			'GQ' => 'ਭੂ-ਖੰਡੀ ਗਿਨੀ',
 			'GR' => 'ਗ੍ਰੀਸ',
 			'GS' => 'ਦੱਖਣੀ ਜਾਰਜਿਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਆਇਲੈਂਡਸ',
 			'GT' => 'ਗੁਆਟੇਮਾਲਾ',
 			'GU' => 'ਗੁਆਮ',
 			'GW' => 'ਗਿਨੀ-ਬਿਸਾਉ',
 			'GY' => 'ਗੁਯਾਨਾ',
 			'HK' => 'ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ',
 			'HK@alt=short' => 'ਹਾਂਗ ਕਾਂਗ',
 			'HM' => 'ਹਰਡ ਆਈਲੈਂਡ ਅਤੇ ਮੈਕਡੋਨਾਲਡ ਆਈਲੈਂਡਸ',
 			'HN' => 'ਹਾਨਡੂਰਸ',
 			'HR' => 'ਕਰੋਏਸ਼ੀਆ',
 			'HT' => 'ਹਾਈਟੀ',
 			'HU' => 'ਹੰਗਰੀ',
 			'IC' => 'ਕੇਨੇਰੀ ਆਈਲੈਂਡਜ਼',
 			'ID' => 'ਇੰਡੋਨੇਸ਼ੀਆ',
 			'IE' => 'ਆਇਰਲੈਂਡ',
 			'IL' => 'ਇਜ਼ਰਾਈਲ',
 			'IM' => 'ਆਇਲ ਆਫ ਮੈਨ',
 			'IN' => 'ਭਾਰਤ',
 			'IO' => 'ਬ੍ਰਿਟਿਸ਼ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਟੈਰਿਟਰੀ',
 			'IQ' => 'ਇਰਾਕ',
 			'IR' => 'ਈਰਾਨ',
 			'IS' => 'ਆਈਸਲੈਂਡ',
 			'IT' => 'ਇਟਲੀ',
 			'JE' => 'ਜਰਸੀ',
 			'JM' => 'ਜਮਾਇਕਾ',
 			'JO' => 'ਜੌਰਡਨ',
 			'JP' => 'ਜਾਪਾਨ',
 			'KE' => 'ਕੀਨੀਆ',
 			'KG' => 'ਕਿਰਗਿਜ਼ਸਤਾਨ',
 			'KH' => 'ਕੰਬੋਡੀਆ',
 			'KI' => 'ਕੀਰੀਬਾਟੀ',
 			'KM' => 'ਕੋਮੋਰੋਸ',
 			'KN' => 'ਸੈਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ',
 			'KP' => 'ਉੱਤਰੀ ਕੋਰੀਆ',
 			'KR' => 'ਦੱਖਣੀ ਕੋਰੀਆ',
 			'KW' => 'ਕੁਵੈਤ',
 			'KY' => 'ਕੇਮੈਨ ਆਈਲੈਂਡਸ',
 			'KZ' => 'ਕਜ਼ਾਕਸਤਾਨ',
 			'LA' => 'ਲਾਓਸ',
 			'LB' => 'ਲੈਬਨਾਨ',
 			'LC' => 'ਸੇਂਟ ਲੂਸੀਆ',
 			'LI' => 'ਲਿਕਟਨਸਟਾਇਨ',
 			'LK' => 'ਸ੍ਰੀ ਲੰਕਾ',
 			'LR' => 'ਲਾਈਬੀਰੀਆ',
 			'LS' => 'ਲੇਸੋਥੋ',
 			'LT' => 'ਲਿਥੁਆਨੀਆ',
 			'LU' => 'ਲਕਜ਼ਮਬਰਗ',
 			'LV' => 'ਲਾਟਵਿਆ',
 			'LY' => 'ਲੀਬੀਆ',
 			'MA' => 'ਮੋਰੱਕੋ',
 			'MC' => 'ਮੋਨਾਕੋ',
 			'MD' => 'ਮੋਲਡੋਵਾ',
 			'ME' => 'ਮੋਨਟੇਨੇਗਰੋ',
 			'MF' => 'ਸੇਂਟ ਮਾਰਟਿਨ',
 			'MG' => 'ਮੈਡਾਗਾਸਕਰ',
 			'MH' => 'ਮਾਰਸ਼ਲ ਆਈਲੈਂਡਸ',
 			'MK' => 'ਮੈਕਡੋਨੀਆ',
 			'MK@alt=variant' => 'ਮੈਕਡੋਨੀਆ (ਪੂਰਵ ਯੁਗੋਸਲਾਵ ਮੈਕਡੋਨੀਆਈ ਗਣਰਾਜ)',
 			'ML' => 'ਮਾਲੀ',
 			'MM' => 'ਮਿਆਂਮਾਰ',
 			'MN' => 'ਮੰਗੋਲੀਆ',
 			'MO' => 'ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ',
 			'MO@alt=short' => 'ਮਕਾਉ',
 			'MP' => 'ਉੱਤਰੀ ਮਰੀਆਨਾ ਆਈਲੈਂਡ',
 			'MQ' => 'ਮਾਰਟੀਨਿਕ',
 			'MR' => 'ਮੋਰਿਟਾਨੀਆ',
 			'MS' => 'ਮੋਂਟਸੇਰਾਤ',
 			'MT' => 'ਮਾਲਟਾ',
 			'MU' => 'ਮੌਰਿਸ਼ਸ',
 			'MV' => 'ਮਾਲਦੀਵ',
 			'MW' => 'ਮਾਲਾਵੀ',
 			'MX' => 'ਮੈਕਸਿਕੋ',
 			'MY' => 'ਮਲੇਸ਼ੀਆ',
 			'MZ' => 'ਮੋਜ਼ਾਮਬੀਕ',
 			'NA' => 'ਨਾਮੀਬੀਆ',
 			'NC' => 'ਨਿਊ ਕੈਲੇਡੋਨਿਆ',
 			'NE' => 'ਨਾਇਜਰ',
 			'NF' => 'ਨੋਰਫੌਕ ਆਈਲੈਂਡ',
 			'NG' => 'ਨਾਇਜੀਰੀਆ',
 			'NI' => 'ਨਿਕਾਰਾਗੁਆ',
 			'NL' => 'ਨੀਦਰਲੈਂਡਸ',
 			'NO' => 'ਨਾਰਵੇ',
 			'NP' => 'ਨੇਪਾਲ',
 			'NR' => 'ਨਾਉਰੂ',
 			'NU' => 'ਨਿਯੂ',
 			'NZ' => 'ਨਿਊਜ਼ੀਲੈਂਡ',
 			'OM' => 'ਓਮਾਨ',
 			'PA' => 'ਪਨਾਮਾ',
 			'PE' => 'ਪੇਰੂ',
 			'PF' => 'ਫ੍ਰੈਂਚ ਪੋਲਿਨੇਸ਼ੀਆ',
 			'PG' => 'ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ',
 			'PH' => 'ਫਿਲਿਪੀਨੀਜ਼',
 			'PK' => 'ਪਾਕਿਸਤਾਨ',
 			'PL' => 'ਪੋਲੈਂਡ',
 			'PM' => 'ਸੈਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ',
 			'PN' => 'ਪਿਟਕੈਰਨ ਆਈਲੈਂਡਸ',
 			'PR' => 'ਪਿਊਰਟੋ ਰਿਕੋ',
 			'PS' => 'ਪਲੈਸਟਿਨੀ ਪ੍ਰਦੇਸ਼',
 			'PS@alt=short' => 'ਪਲੈਸਟੀਨ',
 			'PT' => 'ਪੁਰਤਗਾਲ',
 			'PW' => 'ਪਲਾਉ',
 			'PY' => 'ਪੈਰਾਗਵੇ',
 			'QA' => 'ਕਤਰ',
 			'QO' => 'ਆਊਟਲਾਇੰਗ ਓਸ਼ਨੀਆ',
 			'RE' => 'ਰਿਯੂਨਿਅਨ',
 			'RO' => 'ਰੋਮਾਨੀਆ',
 			'RS' => 'ਸਰਬੀਆ',
 			'RU' => 'ਰੂਸ',
 			'RW' => 'ਰਵਾਂਡਾ',
 			'SA' => 'ਸਾਉਦੀ ਅਰਬ',
 			'SB' => 'ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ',
 			'SC' => 'ਸੇਸ਼ਲਸ',
 			'SD' => 'ਸੁਡਾਨ',
 			'SE' => 'ਸਵੀਡਨ',
 			'SG' => 'ਸਿੰਗਾਪੁਰ',
 			'SH' => 'ਸੇਂਟ ਹੇਲੇਨਾ',
 			'SI' => 'ਸਲੋਵੇਨੀਆ',
 			'SJ' => 'ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ',
 			'SK' => 'ਸਲੋਵਾਕੀਆ',
 			'SL' => 'ਸਿਏਰਾ ਲਿਓਨ',
 			'SM' => 'ਸੈਨ ਮਰੀਨੋ',
 			'SN' => 'ਸੇਨੇਗਲ',
 			'SO' => 'ਸੋਮਾਲੀਆ',
 			'SR' => 'ਸੂਰੀਨਾਮ',
 			'SS' => 'ਦੱਖਣੀ ਸੁਡਾਨ',
 			'ST' => 'ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ',
 			'SV' => 'ਅਲ ਸਲਵਾਡੋਰ',
 			'SX' => 'ਸਿੰਟ ਮਾਰਟੀਨ',
 			'SY' => 'ਸੀਰੀਆ',
 			'SZ' => 'ਸਵਾਜ਼ੀਲੈਂਡ',
 			'TA' => 'ਤ੍ਰਿਸਟਾਨ ਡਾ ਕੁਨਾ',
 			'TC' => 'ਤੁਰਕਸ ਐਂਡ ਕੇਕੋਸ ਆਈਲੈਂਡਸ',
 			'TD' => 'ਚਾਡ',
 			'TF' => 'ਫ੍ਰੈਂਚ ਸਾਉਦਰਨ ਟੈਰੀਟਰੀਜ਼',
 			'TG' => 'ਟੋਗੋ',
 			'TH' => 'ਥਾਈਲੈਂਡ',
 			'TJ' => 'ਤਾਜਿਕਿਸਤਾਨ',
 			'TK' => 'ਟੋਕੇਲਾਉ',
 			'TL' => 'ਟੀਮੁਰ-ਲੀਸਟੀ',
 			'TL@alt=variant' => 'ਪੂਰਬੀ ਟੀਮੁਰ',
 			'TM' => 'ਤੁਰਕਮੇਨਿਸਤਾਨ',
 			'TN' => 'ਟਿਉਨੀਸ਼ੀਆ',
 			'TO' => 'ਟੌਂਗਾ',
 			'TR' => 'ਤੁਰਕੀ',
 			'TT' => 'ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ',
 			'TV' => 'ਟੁਵਾਲੂ',
 			'TW' => 'ਤਾਇਵਾਨ',
 			'TZ' => 'ਤਨਜ਼ਾਨੀਆ',
 			'UA' => 'ਯੂਕਰੇਨ',
 			'UG' => 'ਯੂਗਾਂਡਾ',
 			'UM' => 'ਯੂ.ਐਸ. ਆਊਟਲਾਇੰਗ ਆਈਲੈਂਡਸ',
 			'US' => 'ਯੂਨਾਇਟੇਡ ਸਟੇਟਸ',
 			'US@alt=short' => 'ਯੂ.ਐਸ.',
 			'UY' => 'ਉਰੂਗਵੇ',
 			'UZ' => 'ਉਜ਼ਬੇਕਿਸਤਾਨ',
 			'VA' => 'ਵੈਟਿਕਨ ਸਿਟੀ',
 			'VC' => 'ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ',
 			'VE' => 'ਵੇਨੇਜ਼ੂਏਲਾ',
 			'VG' => 'ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਆਈਲੈਂਡਸ',
 			'VI' => 'ਯੂ ਐਸ ਵਰਜਿਨ ਆਈਲੈਂਡਸ',
 			'VN' => 'ਵਿਯਤਨਾਮ',
 			'VU' => 'ਵਾਨੂਆਟੂ',
 			'WF' => 'ਵਾਲਿਸ ਐਂਡ ਫਯੁਚੁਨਾ',
 			'WS' => 'ਸਾਮੋਆ',
 			'XK' => 'ਕੋਸੋਵੋ',
 			'YE' => 'ਯਮਨ',
 			'YT' => 'ਮਾਯੋਟੀ',
 			'ZA' => 'ਦੱਖਣੀ ਅਫਰੀਕਾ',
 			'ZM' => 'ਜ਼ਾਮਬੀਆ',
 			'ZW' => 'ਜ਼ਿੰਬਾਬਵੇ',
 			'ZZ' => 'ਅਗਿਆਤ ਖੇਤਰ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ਕੈਲੰਡਰ',
 			'collation' => 'ਸੌਰਟ ਓਰਡਰ',
 			'currency' => 'ਮੁਦਰਾ',
 			'numbers' => 'ਸੰਖਿਆ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[Str]]',
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'gregorian' => q{ਗਰੀਜੋਰੀਅਨ ਕੈਲੰਡਰ},
 			},
 			'collation' => {
 				'ducet' => q{ਡਿਫੌਲਟ ਯੂਨੀਕੋਡ ਸੌਰਟ ਓਰਡਰ},
 				'search' => q{ਆਮ-ਮੰਤਵ ਖੋਜ},
 				'standard' => q{ਸਟੈਂਡਰਡ ਸੌਰਟ ਓਰਡਰ},
 			},
 			'numbers' => {
 				'arab' => q{ਅਰਬੀ-ਇੰਡਿਕ ਅੰਕ},
 				'arabext' => q{ਵਿਸਤਰਿਤ ਅਰਬੀ-ਇੰਡਿਕ ਅੰਕ},
 				'armn' => q{ਆਰਮੀਨੀਅਨ ਸੰਖਿਆਵਾਂ},
 				'armnlow' => q{ਆਰਮੀਨੀਅਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'beng' => q{ਬੰਗਾਲੀ ਅੰਕ},
 				'deva' => q{ਦੇਵਨਾਗਰੀ ਅੰਕ},
 				'ethi' => q{ਐਥਿਓਪਿਕ ਸੰਖਿਆਵਾਂ},
 				'fullwide' => q{ਪੂਰਨ ਵਿਸਤਾਰ ਅੰਕ},
 				'geor' => q{ਜਾਰਜੀਅਨ ਸੰਖਿਆਵਾਂ},
 				'grek' => q{ਗ੍ਰੀਕ ਸੰਖਿਆਵਾਂ},
 				'greklow' => q{ਗ੍ਰੀਕ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'gujr' => q{ਗੁਜਰਾਤੀ ਅੰਕ},
 				'guru' => q{ਗੁਰਮੁਖੀ ਅੰਕ},
 				'hanidec' => q{ਚੀਨੀ ਦਸ਼ਮਲਵ ਸੰਖਿਆਵਾਂ},
 				'hans' => q{ਸਰਲ ਕੀਤੀ ਚੀਨੀ ਸੰਖਿਆਵਾਂ},
 				'hansfin' => q{ਸਰਲ ਕੀਤੀ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'hant' => q{ਰਵਾਇਤੀ ਚੀਨੀ ਸੰਖਿਆਵਾਂ},
 				'hantfin' => q{ਰਵਾਇਤੀ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'hebr' => q{ਹਿਬਰੂ ਸੰਖਿਆਵਾਂ},
 				'jpan' => q{ਜਾਪਾਨੀ ਸੰਖਿਆਵਾਂ},
 				'jpanfin' => q{ਜਾਪਾਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'khmr' => q{ਖਮੇਰ ਅੰਕ},
 				'knda' => q{ਕੰਨੜ ਅੰਕ},
 				'laoo' => q{ਲਾਓ ਅੰਕ},
 				'latn' => q{ਪੱਛਮੀ ਅੰਕ},
 				'mlym' => q{ਮਲਿਆਲਮ ਅੰਕ},
 				'mymr' => q{ਮਿਆਂਮਾਰ ਅੰਕ},
 				'orya' => q{ਉੜੀਆ ਅੰਕ},
 				'roman' => q{ਰੋਮਨ ਸੰਖਿਆਵਾਂ},
 				'romanlow' => q{ਰੋਮਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'taml' => q{ਰਵਾਇਤੀ ਤਮਿਲ ਸੰਖਿਆਵਾਂ},
 				'tamldec' => q{ਤਮਿਲ ਅੰਕ},
 				'telu' => q{ਤੇਲਗੂ ਅੰਕ},
 				'thai' => q{ਥਾਈ ਅੰਕ},
 				'tibt' => q{ਤਿੱਬਤੀ ਅੰਕ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ਮੈਟਰਿਕ},
 			'UK' => q{ਯੂ. ਕੇ.},
 			'US' => q{ਯੂ. ਐਸ.},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ਪੰਜਾਬੀ: {0}',
 			'script' => 'ਲਿਪੀ: {0}',
 			'territory' => 'ਖੇਤਰ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{(?^u:[‌‍ ਃ ਂ ਁ {ਲ਼}])},
			index => ['ੴ', 'ੳ', 'ਉ', 'ਊ', 'ਓ', 'ਅ', 'ਆ', 'ਐ', 'ਔ', 'ੲ', 'ਇ', 'ਈ', 'ਏ', 'ਸ', 'ਹ', 'ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਵ', 'ੜ'],
			main => qr{(?^u:[ੱ ੰ ਼ ੦ ੧ ੨ ੩ ੪ ੫ ੬ ੭ ੮ ੯ ੴ ੳ ਉ ਊ ਓ ਅ ਆ ਐ ਔ ੲ ਇ ਈ ਏ ਸ {ਸ਼} ਹ ਕ ਖ {ਖ਼} ਗ {ਗ਼} ਘ ਙ ਚ ਛ ਜ {ਜ਼} ਝ ਞ ਟ ਠ ਡ ਢ ਣ ਤ ਥ ਦ ਧ ਨ ਪ ਫ {ਫ਼} ਬ ਭ ਮ ਯ ਰ ਲ ਵ ੜ ੍ ਾ ਿ ੀ ੁ ੂ ੇ ੈ ੋ ੌ])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . ' ‘ ’ " “ ” ( ) \[ \] / \& ′ ″])},
		};
	},
EOT
: sub {
		return { index => ['ੴ', 'ੳ', 'ਉ', 'ਊ', 'ਓ', 'ਅ', 'ਆ', 'ਐ', 'ਔ', 'ੲ', 'ਇ', 'ਈ', 'ਏ', 'ਸ', 'ਹ', 'ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਵ', 'ੜ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{'},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{'},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{"},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> qq{"},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> 'HashRef[Str]',
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> 'HashRef[HashRef[HashRef[Str]]]',
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'arc-minute' => {
						'one' => q({0} ਮਿਨਟ),
						'other' => q({0} ਮਿਨਟ),
					},
					'arc-second' => {
						'one' => q({0} ਸੈਕੇਂਡ),
						'other' => q({0} ਸੈਕੇਂਡ),
					},
					'celsius' => {
						'one' => q({0} ਡਿਗਰੀ ਸੈਲਸੀਅਸ),
						'other' => q({0} ਡਿਗਰੀ ਸੈਲਸੀਅਸ),
					},
					'centimeter' => {
						'one' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਸੈਂਟੀਮੀਟਰ),
					},
					'cubic-kilometer' => {
						'one' => q({0} ਘਣ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਘਣ ਕਿਲੋਮੀਟਰ),
					},
					'cubic-mile' => {
						'one' => q({0} ਘਣ ਮੀਲ),
						'other' => q({0} ਘਣ ਮੀਲ),
					},
					'day' => {
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
					},
					'degree' => {
						'one' => q({0} ਡਿਗਰੀ),
						'other' => q({0} ਡਿਗਰੀ),
					},
					'fahrenheit' => {
						'one' => q({0} ਡਿਗਰੀ ਫਾਰੇਨਹਾਈਟ),
						'other' => q({0} ਡਿਗਰੀ ਫਾਰੇਨਹਾਈਟ),
					},
					'foot' => {
						'one' => q({0} ਫੁੱਟ),
						'other' => q({0} ਫੁੱਟ),
					},
					'g-force' => {
						'one' => q({0} ਗੁਰੂਤੱਵ ਆਕਰਸ਼ਨ ਸ਼ਕਤੀ),
						'other' => q({0} ਗੁਰੂਤੱਵ ਆਕਰਸ਼ਨ ਸ਼ਕਤੀ),
					},
					'gram' => {
						'one' => q({0} ਗ੍ਰਾਮ),
						'other' => q({0} ਗ੍ਰਾਮ),
					},
					'hectare' => {
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectopascal' => {
						'one' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
						'other' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
					},
					'horsepower' => {
						'one' => q({0} ਹੌਰਸਪਾਵਰ),
						'other' => q({0} ਹੌਰਸਪਾਵਰ),
					},
					'hour' => {
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
					},
					'inch' => {
						'one' => q({0} ਇੰਚ),
						'other' => q({0} ਇੰਚ),
					},
					'inch-hg' => {
						'one' => q({0} ਪਾਰੇ ਦਾ ਇੰਚ),
						'other' => q({0} ਪਾਰੇ ਦਾ ਇੰਚ),
					},
					'kilogram' => {
						'one' => q({0} ਕਿਲੋਗ੍ਰਾਮ),
						'other' => q({0} ਕਿਲੋਗ੍ਰਾਮ),
					},
					'kilometer' => {
						'one' => q({0} ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਕਿਲੋਮੀਟਰ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
						'other' => q({0} ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'kilowatt' => {
						'one' => q({0} ਕਿਲੋਵਾਟ),
						'other' => q({0} ਕਿਲੋਵਾਟ),
					},
					'light-year' => {
						'one' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'other' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
					},
					'liter' => {
						'one' => q({0} ਲੀਟਰ),
						'other' => q({0} ਲੀਟਰ),
					},
					'meter' => {
						'one' => q({0} ਮੀਟਰ),
						'other' => q({0} ਮੀਟਰ),
					},
					'meter-per-second' => {
						'one' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
						'other' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
					},
					'mile' => {
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-hour' => {
						'one' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
						'other' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'millibar' => {
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'millimeter' => {
						'one' => q({0} ਮਿਲੀਮੀਟਰ),
						'other' => q({0} ਮਿਲੀਮੀਟਰ),
					},
					'millisecond' => {
						'one' => q({0} ਮਿਲੀ ਸਕਿੰਟ),
						'other' => q({0} ਮਿਲੀ ਸਕਿੰਟ),
					},
					'minute' => {
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
					},
					'month' => {
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
					},
					'ounce' => {
						'one' => q({0} ਆਉਂਸ),
						'other' => q({0} ਆਉਂਸ),
					},
					'per' => {
						'' => q({0} ਪ੍ਰਤੀ {1}),
					},
					'picometer' => {
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pound' => {
						'one' => q({0} ਪਾਉਂਡ),
						'other' => q({0} ਪਾਉਂਡ),
					},
					'second' => {
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
					},
					'square-foot' => {
						'one' => q({0} ਵਰਗ ਫੁੱਟ),
						'other' => q({0} ਵਰਗ ਫੁੱਟ),
					},
					'square-kilometer' => {
						'one' => q({0} ਵਰਗ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਕਿਲੋਮੀਟਰ),
					},
					'square-meter' => {
						'one' => q({0} ਵਰਗ ਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਮੀਟਰ),
					},
					'square-mile' => {
						'one' => q({0} ਵਰਗ ਮੀਲ),
						'other' => q({0} ਵਰਗ ਮੀਲ),
					},
					'watt' => {
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
					},
					'yard' => {
						'one' => q({0} ਯਾਰਡ),
						'other' => q({0} ਯਾਰਡ),
					},
					'year' => {
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'centimeter' => {
						'one' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਸੈਂਟੀਮੀਟਰ),
					},
					'cubic-kilometer' => {
						'one' => q({0} ਘਣ ਕਿਮੀ),
						'other' => q({0} ਘਣ ਕਿਮੀ),
					},
					'cubic-mile' => {
						'one' => q({0} ਘਣ ਮੀਲ),
						'other' => q({0} ਘਣ ਮੀਲ),
					},
					'day' => {
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0}'),
						'other' => q({0}'),
					},
					'g-force' => {
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gram' => {
						'one' => q({0} ਗ੍ਰਾ.),
						'other' => q({0} ਗ੍ਰਾ.),
					},
					'hectare' => {
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'one' => q({0} ਘੰਟੇ),
						'other' => q({0} ਘੰਟੇ),
					},
					'inch' => {
						'one' => q({0}"),
						'other' => q({0}"),
					},
					'inch-hg' => {
						'one' => q({0} ਪਾਰੇ ਦਾ ਇੰਚ),
						'other' => q({0} ਪਾਰੇ ਦਾ ਇੰਚ),
					},
					'kilogram' => {
						'one' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਕਿ.ਗ੍ਰਾ.),
					},
					'kilometer' => {
						'one' => q({0} ਕਿਮੀ),
						'other' => q({0} ਕਿਮੀ),
					},
					'kilometer-per-hour' => {
						'one' => q({0} km/h),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'one' => q({0}kW),
						'other' => q({0}kW),
					},
					'light-year' => {
						'one' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'other' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
					},
					'liter' => {
						'one' => q({0} ਲੀ.),
						'other' => q({0} ਲੀ.),
					},
					'meter' => {
						'one' => q({0} ਮੀ),
						'other' => q({0} ਮੀ),
					},
					'meter-per-second' => {
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'mile' => {
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'millimeter' => {
						'one' => q({0} ਮਿਮੀ),
						'other' => q({0} ਮਿਮੀ),
					},
					'millisecond' => {
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
					},
					'month' => {
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
					},
					'ounce' => {
						'one' => q({0} ਆਉਂਸ),
						'other' => q({0} ਆਉਂਸ),
					},
					'per' => {
						'' => q({0} ਪ੍ਰਤੀ {1}),
					},
					'picometer' => {
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pound' => {
						'one' => q({0} ਪਾਉਂਡ),
						'other' => q({0} ਪਾਉਂਡ),
					},
					'second' => {
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
					},
					'square-foot' => {
						'one' => q({0} ਵ.ਫੁੱ.),
						'other' => q({0} ਵ.ਫੁੱ.),
					},
					'square-kilometer' => {
						'one' => q({0} ਵ.ਕਿਮੀ),
						'other' => q({0} ਵ.ਕਿਮੀ),
					},
					'square-meter' => {
						'one' => q({0} ਵ.ਮੀ.),
						'other' => q({0} ਵ.ਮੀ.),
					},
					'square-mile' => {
						'one' => q({0} ਵ. ਮੀਲ),
						'other' => q({0} ਵ. ਮੀਲ),
					},
					'watt' => {
						'one' => q({0}W),
						'other' => q({0}W),
					},
					'week' => {
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
					},
					'yard' => {
						'one' => q({0} ਯਾਰਡ),
						'other' => q({0} ਯਾਰਡ),
					},
					'year' => {
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
					},
				},
				'short' => {
					'acre' => {
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'arc-minute' => {
						'one' => q({0} ਮਿਨਟ),
						'other' => q({0} ਮਿਨਟ),
					},
					'arc-second' => {
						'one' => q({0} ਸੈਕੇਂਡ),
						'other' => q({0} ਸੈਕੇਂਡ),
					},
					'celsius' => {
						'one' => q({0} ਡਿਗਰੀ ਸੈਲਸੀਅਸ),
						'other' => q({0} ਡਿਗਰੀ ਸੈਲਸੀਅਸ),
					},
					'centimeter' => {
						'one' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਸੈਂਟੀਮੀਟਰ),
					},
					'cubic-kilometer' => {
						'one' => q({0} ਘਣ ਕਿ.ਮੀ.),
						'other' => q({0} ਘਣ ਕਿ.ਮੀ.),
					},
					'cubic-mile' => {
						'one' => q({0} ਘਣ ਮੀਲ),
						'other' => q({0} ਘਣ ਮੀਲ),
					},
					'day' => {
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
					},
					'degree' => {
						'one' => q({0} ਡਿ.),
						'other' => q({0} ਡਿ.),
					},
					'fahrenheit' => {
						'one' => q({0} ਡਿਗਰੀ ਫਾਰੇਨਹਾਈਟ),
						'other' => q({0} ਡਿਗਰੀ ਫਾਰੇਨਹਾਈਟ),
					},
					'foot' => {
						'one' => q({0} ਫੁੱ.),
						'other' => q({0} ਫੁੱ.),
					},
					'g-force' => {
						'one' => q({0} ਗੁ-ਸ਼ਕਤੀ),
						'other' => q({0} ਗੁ-ਸ਼ਕਤੀ),
					},
					'gram' => {
						'one' => q({0} ਗ੍ਰਾ.),
						'other' => q({0} ਗ੍ਰਾ.),
					},
					'hectare' => {
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectopascal' => {
						'one' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
						'other' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
					},
					'horsepower' => {
						'one' => q({0} ਹੌਰਸਪਾਵਰ),
						'other' => q({0} ਹੌਰਸਪਾਵਰ),
					},
					'hour' => {
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
					},
					'inch' => {
						'one' => q({0} ਇੰਚ),
						'other' => q({0} ਇੰਚ),
					},
					'inch-hg' => {
						'one' => q({0} ਪਾਰੇ ਦਾ ਇੰਚ),
						'other' => q({0} ਪਾਰੇ ਦਾ ਇੰਚ),
					},
					'kilogram' => {
						'one' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਕਿ.ਗ੍ਰਾ.),
					},
					'kilometer' => {
						'one' => q({0} ਕਿ.ਮੀ.),
						'other' => q({0} ਕਿ.ਮੀ.),
					},
					'kilometer-per-hour' => {
						'one' => q({0} ਕਿ.ਮੀ./ਘੰਟਾ),
						'other' => q({0} ਕਿ.ਮੀ./ਘੰਟਾ),
					},
					'kilowatt' => {
						'one' => q({0} ਕਿ. ਵਾਟ),
						'other' => q({0} ਕਿ. ਵਾਟ),
					},
					'light-year' => {
						'one' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'other' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
					},
					'liter' => {
						'one' => q({0} ਲੀ.),
						'other' => q({0} ਲੀ.),
					},
					'meter' => {
						'one' => q({0} ਮੀ.),
						'other' => q({0} ਮੀ.),
					},
					'meter-per-second' => {
						'one' => q({0} ਮੀ./ਸਕਿੰਟ),
						'other' => q({0} ਮੀ./ਸਕਿੰਟ),
					},
					'mile' => {
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-hour' => {
						'one' => q({0} ਮੀਲ/ਘੰਟਾ),
						'other' => q({0} ਮੀਲ/ਘੰਟਾ),
					},
					'millibar' => {
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'millimeter' => {
						'one' => q({0} ਮਿ.ਮੀ.),
						'other' => q({0} ਮਿ.ਮੀ.),
					},
					'millisecond' => {
						'one' => q({0} ਮਿਲੀ ਸਕਿੰਟ),
						'other' => q({0} ਮਿਲੀ ਸਕਿੰਟ),
					},
					'minute' => {
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
					},
					'month' => {
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
					},
					'ounce' => {
						'one' => q({0} ਆਉਂਸ),
						'other' => q({0} ਆਉਂਸ),
					},
					'per' => {
						'' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pound' => {
						'one' => q({0} ਪਾਉਂਡ),
						'other' => q({0} ਪਾਉਂਡ),
					},
					'second' => {
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
					},
					'square-foot' => {
						'one' => q({0} ਵ.ਫੁੱ.),
						'other' => q({0} ਵ.ਫੁੱ.),
					},
					'square-kilometer' => {
						'one' => q({0} ਵ.ਕਿ.ਮੀ.),
						'other' => q({0} ਵ.ਕਿ.ਮੀ.),
					},
					'square-meter' => {
						'one' => q({0} ਵ.ਮੀ.),
						'other' => q({0} ਵ.ਮੀ.),
					},
					'square-mile' => {
						'one' => q({0} ਵ. ਮੀਲ),
						'other' => q({0} ਵ. ਮੀਲ),
					},
					'watt' => {
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
					},
					'yard' => {
						'one' => q({0} ਯਾਰਡ),
						'other' => q({0} ਯਾਰਡ),
					},
					'year' => {
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ਹਾਂ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> 'RegexpRef',
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ਨਹੀਂ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> 'Str',
	init_arg	=> undef,
	default		=> 'guru',
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0.###',
				},
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'0' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'0' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'negative' => '¤#,##,##0.00',
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '¤ #,##0.00',
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'negative' => '¤ #,##,##0.00',
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'curriencies' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
				'one' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
				'other' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
				'one' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
				'other' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
				'one' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
				'other' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(ਆਰਮੀਨਿਆਈ ਦਰਮ),
				'one' => q(ਆਰਮੀਨਿਆਈ ਦਰਮ),
				'other' => q(ਆਰਮੀਨਿਆਈ ਦਰਮ),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
				'one' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
				'other' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
				'one' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
				'other' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(ਅਰਜਨਟਾਈਨ ਪੈਸੋ),
				'one' => q(ਅਰਜਨਟਾਈਨ ਪੈਸੋ),
				'other' => q(ਅਰਜਨਟਾਈਨ ਪੈਸੋ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
				'one' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
				'other' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
				'one' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
				'other' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(ਅਜ਼ਰਬੈਜਾਨੀ ਮਾਨਤ),
				'one' => q(ਅਜ਼ਰਬੈਜਾਨੀ ਮਾਨਤ),
				'other' => q(ਅਜ਼ਰਬੈਜਾਨੀ ਮਾਨਤ),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣ੍ਯੋਗ ਮਾਰਕ),
				'one' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣ੍ਯੋਗ ਮਾਰਕ),
				'other' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣ੍ਯੋਗ ਮਾਰਕ),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
				'one' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
				'other' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
				'one' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
				'other' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(ਬੁਲਗਾਰਿਆਈ ਲੇਵ),
				'one' => q(ਬੁਲਗਾਰਿਆਈ ਲੇਵ),
				'other' => q(ਬੁਲਗਾਰਿਆਈ ਲੇਵ),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
				'one' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
				'other' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
				'one' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
				'other' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
				'one' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
				'other' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
				'one' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
				'other' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
				'one' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
				'other' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ਿਲਿਆਈ ਰੀਅਲ),
				'one' => q(ਬ੍ਰਾਜ਼ਿਲਿਆਈ ਰੀਅਲ),
				'other' => q(ਬ੍ਰਾਜ਼ਿਲਿਆਈ ਰੀਅਲ),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
				'one' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
				'other' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
				'one' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
				'other' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
				'one' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
				'other' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
				'one' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
				'other' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
				'one' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
				'other' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
				'one' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
				'other' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
				'one' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
				'other' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
				'one' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
				'other' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(ਚਿਲੀਅਨ ਪੈਸੋ),
				'one' => q(ਚਿਲੀਅਨ ਪੈਸੋ),
				'other' => q(ਚਿਲੀਅਨ ਪੈਸੋ),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ਚੀਨੀ ਯੁਆਨ),
				'one' => q(ਚੀਨੀ ਯੁਆਨ),
				'other' => q(ਚੀਨੀ ਯੁਆਨ),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(ਕੋਲੰਬੀਅਨ ਪੈਸੋ),
				'one' => q(ਕੋਲੰਬੀਅਨ ਪੈਸੋ),
				'other' => q(ਕੋਲੰਬੀਅਨ ਪੈਸੋ),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
				'one' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
				'other' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(ਕਿਊਬਨ ਬਦਲਣ੍ਯੋਗ ਪੈਸੋ),
				'one' => q(ਕਿਊਬਨ ਬਦਲਣ੍ਯੋਗ ਪੈਸੋ),
				'other' => q(ਕਿਊਬਨ ਬਦਲਣ੍ਯੋਗ ਪੈਸੋ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(ਕਿਊਬਨ ਪੈਸੋ),
				'one' => q(ਕਿਊਬਨ ਪੈਸੋ),
				'other' => q(ਕਿਊਬਨ ਪੈਸੋ),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(ਕੇਪ ਵਰਡੀਅਨ ਸ਼ਿਊਡੋ),
				'one' => q(ਕੇਪ ਵਰਡੀਅਨ ਸ਼ਿਊਡੋ),
				'other' => q(ਕੇਪ ਵਰਡੀਅਨ ਸ਼ਿਊਡੋ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
				'one' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
				'other' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(ਦਾਨਿਸ਼ ਕਰੌਨ),
				'one' => q(ਦਾਨਿਸ਼ ਕਰੌਨ),
				'other' => q(ਦਾਨਿਸ਼ ਕਰੌਨ),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(ਡੌਮਿਨਿਕਨ ਪੈਸੋ),
				'one' => q(ਡੌਮਿਨਿਕਨ ਪੈਸੋ),
				'other' => q(ਡੌਮਿਨਿਕਨ ਪੈਸੋ),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
				'one' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
				'other' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(ਮਿਸਰੀ ਪਾਉਂਡ),
				'one' => q(ਮਿਸਰੀ ਪਾਉਂਡ),
				'other' => q(ਮਿਸਰੀ ਪਾਉਂਡ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਕਫਾ),
				'one' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਕਫਾ),
				'other' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਕਫਾ),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
				'one' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
				'other' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ਯੂਰੋ),
				'one' => q(ਯੂਰੋ),
				'other' => q(ਯੂਰੋ),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(ਫ਼ਿਜੀਆਈ ਡਾਲਰ),
				'one' => q(ਫ਼ਿਜੀਆਈ ਡਾਲਰ),
				'other' => q(ਫ਼ਿਜੀਆਈ ਡਾਲਰ),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪਾਉਂਡ),
				'one' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪਾਉਂਡ),
				'other' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪਾਉਂਡ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ਬ੍ਰਿਟਿਸ਼ ਪਾਉਂਡ ਸਟਰਲਿੰਗ),
				'one' => q(ਬ੍ਰਿਟਿਸ਼ ਪਾਉਂਡ ਸਟਰਲਿੰਗ),
				'other' => q(ਬ੍ਰਿਟਿਸ਼ ਪਾਉਂਡ ਸਟਰਲਿੰਗ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(ਜਾਰਜਿਆਈ ਲਾਰੀ),
				'one' => q(ਜਾਰਜਿਆਈ ਲਾਰੀ),
				'other' => q(ਜਾਰਜਿਆਈ ਲਾਰੀ),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(ਘਾਨਾਈ ਸੇਡੀ),
				'one' => q(ਘਾਨਾਈ ਸੇਡੀ),
				'other' => q(ਘਾਨਾਈ ਸੇਡੀ),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ਜਿਬਰਾਲਟਰ ਪਾਉਂਡ),
				'one' => q(ਜਿਬਰਾਲਟਰ ਪਾਉਂਡ),
				'other' => q(ਜਿਬਰਾਲਟਰ ਪਾਉਂਡ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(ਗਾਂਬੀਆਈ ਦਲਾਸੀ),
				'one' => q(ਗਾਂਬੀਆਈ ਦਲਾਸੀ),
				'other' => q(ਗਾਂਬੀਆਈ ਦਲਾਸੀ),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(ਗਿਨੀਅਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਗਿਨੀਅਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਗਿਨੀਅਨ ਫ੍ਰੈਂਕ),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
				'one' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
				'other' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(ਗੁਯਾਨਾਈਜ਼ ਡਾਲਰ),
				'one' => q(ਗੁਯਾਨਾਈਜ਼ ਡਾਲਰ),
				'other' => q(ਗੁਯਾਨਾਈਜ਼ ਡਾਲਰ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
				'one' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
				'other' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
				'one' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
				'other' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
				'one' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
				'other' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(ਹਾਈਟੀਅਨ ਗੌਰਡੇ),
				'one' => q(ਹਾਈਟੀਅਨ ਗੌਰਡੇ),
				'other' => q(ਹਾਈਟੀਅਨ ਗੌਰਡੇ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(ਹੰਗਰਾਈ ਫੋਰਿੰਟ),
				'one' => q(ਹੰਗਰਾਈ ਫੋਰਿੰਟ),
				'other' => q(ਹੰਗਰਾਈ ਫੋਰਿੰਟ),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
				'one' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
				'other' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
				'one' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
				'other' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ਭਾਰਤੀ ਰੁਪਏ),
				'one' => q(ਭਾਰਤੀ ਰੁਪਏ),
				'other' => q(ਭਾਰਤੀ ਰੁਪਏ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
				'one' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
				'other' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(ਈਰਾਨੀ ਰਿਆਲ),
				'one' => q(ਈਰਾਨੀ ਰਿਆਲ),
				'other' => q(ਈਰਾਨੀ ਰਿਆਲ),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
				'one' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
				'other' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
				'one' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
				'other' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(ਜੌਰਡਨੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਜੌਰਡਨੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਜੌਰਡਨੀਆਈ ਦਿਨਾਰ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ਜਾਪਾਨੀ ਯੇਨ),
				'one' => q(ਜਾਪਾਨੀ ਯੇਨ),
				'other' => q(ਜਾਪਾਨੀ ਯੇਨ),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
				'one' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
				'other' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
				'one' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
				'other' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(ਕੋਮੋਰੀਅਨ ਫੈਂਕ),
				'one' => q(ਕੋਮੋਰੀਅਨ ਫੈਂਕ),
				'other' => q(ਕੋਮੋਰੀਅਨ ਫੈਂਕ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
				'one' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
				'other' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
				'one' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
				'other' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
				'one' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
				'other' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'one' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'other' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(ਕਜ਼ਾਕਸਤਾਨੀ ਤੇਂਗੇ),
				'one' => q(ਕਜ਼ਾਕਸਤਾਨੀ ਤੇਂਗੇ),
				'other' => q(ਕਜ਼ਾਕਸਤਾਨੀ ਤੇਂਗੇ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
				'one' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
				'other' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(ਲੈਬਨਾਨੀ ਪਾਉਂਡ),
				'one' => q(ਲੈਬਨਾਨੀ ਪਾਉਂਡ),
				'other' => q(ਲੈਬਨਾਨੀ ਪਾਉਂਡ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(ਸ੍ਰੀ ਲੰਕਾਈ ਰੁਪਏ),
				'one' => q(ਸ੍ਰੀ ਲੰਕਾਈ ਰੁਪਏ),
				'other' => q(ਸ੍ਰੀ ਲੰਕਾਈ ਰੁਪਏ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
				'one' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
				'other' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
				'one' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
				'other' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
				'one' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
				'other' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
				'one' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
				'other' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
				'one' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
				'other' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(ਮੋਲਡੋਵਨ ਲਿਯੂ),
				'one' => q(ਮੋਲਡੋਵਨ ਲਿਯੂ),
				'other' => q(ਮੋਲਡੋਵਨ ਲਿਯੂ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
				'one' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
				'other' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
				'one' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
				'other' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(ਮਿਆਂਮਾ ਕ੍ਯਾਤ),
				'one' => q(ਮਿਆਂਮਾ ਕ੍ਯਾਤ),
				'other' => q(ਮਿਆਂਮਾ ਕ੍ਯਾਤ),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
				'one' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
				'other' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
				'one' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
				'other' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
				'one' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
				'other' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਏ),
				'one' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਏ),
				'other' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਏ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
				'one' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
				'other' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
				'one' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
				'other' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ਮੈਕਸਿਕਨ ਪੈਸੋ),
				'one' => q(ਮੈਕਸਿਕਨ ਪੈਸੋ),
				'other' => q(ਮੈਕਸਿਕਨ ਪੈਸੋ),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(ਮੇਲੇਸ਼ਿਆਈ ਰਿਨਗਿੱਟ),
				'one' => q(ਮੇਲੇਸ਼ਿਆਈ ਰਿਨਗਿੱਟ),
				'other' => q(ਮੇਲੇਸ਼ਿਆਈ ਰਿਨਗਿੱਟ),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
				'one' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
				'other' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
				'one' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
				'other' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
				'one' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
				'other' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(ਨਿਕਾਰਾਗੁਆਨ ਕੋਰਡੋਬਾ),
				'one' => q(ਨਿਕਾਰਾਗੁਆਨ ਕੋਰਡੋਬਾ),
				'other' => q(ਨਿਕਾਰਾਗੁਆਨ ਕੋਰਡੋਬਾ),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(ਨੌਰਵੇਜਿਅਨ ਕਰੌਨ),
				'one' => q(ਨੌਰਵੇਜਿਅਨ ਕਰੌਨ),
				'other' => q(ਨੌਰਵੇਜਿਅਨ ਕਰੌਨ),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(ਨੇਪਾਲੀ ਰੁਪਏ),
				'one' => q(ਨੇਪਾਲੀ ਰੁਪਏ),
				'other' => q(ਨੇਪਾਲੀ ਰੁਪਏ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
				'one' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
				'other' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(ਓਮਾਨੀ ਰਿਆਲ),
				'one' => q(ਓਮਾਨੀ ਰਿਆਲ),
				'other' => q(ਓਮਾਨੀ ਰਿਆਲ),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
				'one' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
				'other' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(ਪੇਰੂਵੀਅਨ ਨਿਊਵੋ ਸੋਲ),
				'one' => q(ਪੇਰੂਵੀਅਨ ਨਿਊਵੋ ਸੋਲ),
				'other' => q(ਪੇਰੂਵੀਅਨ ਨਿਊਵੋ ਸੋਲ),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕਿਨਾ),
				'one' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕਿਨਾ),
				'other' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕਿਨਾ),
			},
		},
		'PHP' => {
			display_name => {
				'currency' => q(ਫਿਲਿਪੀਨੀ ਪੈਸੋ),
				'one' => q(ਫਿਲਿਪੀਨੀ ਪੈਸੋ),
				'other' => q(ਫਿਲਿਪੀਨੀ ਪੈਸੋ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਏ),
				'one' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਏ),
				'other' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਏ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(ਪੋਲਿਸ਼ ਜ਼ਲੌਟੀ),
				'one' => q(ਪੋਲਿਸ਼ ਜ਼ਲੌਟੀ),
				'other' => q(ਪੋਲਿਸ਼ ਜ਼ਲੌਟੀ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
				'one' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
				'other' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(ਕਤਰੀ ਰਿਆਲ),
				'one' => q(ਕਤਰੀ ਰਿਆਲ),
				'other' => q(ਕਤਰੀ ਰਿਆਲ),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(ਰੋਮਾਨੀਆਈ ਲਿਯੂ),
				'one' => q(ਰੋਮਾਨੀਆਈ ਲਿਯੂ),
				'other' => q(ਰੋਮਾਨੀਆਈ ਲਿਯੂ),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(ਰੂਸੀ ਰੂਬਲ),
				'one' => q(ਰੂਸੀ ਰੂਬਲ),
				'other' => q(ਰੂਸੀ ਰੂਬਲ),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(ਸਾਉਦੀ ਰਿਆਲ),
				'one' => q(ਸਾਉਦੀ ਰਿਆਲ),
				'other' => q(ਸਾਉਦੀ ਰਿਆਲ),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'one' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'other' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(ਸੇਸ਼ਲਸ ਰੁਪਏ),
				'one' => q(ਸੇਸ਼ਲਸ ਰੁਪਏ),
				'other' => q(ਸੇਸ਼ਲਸ ਰੁਪਏ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(ਸੁਡਾਨੀਜ਼ ਪਾਉਂਡ),
				'one' => q(ਸੁਡਾਨੀਜ਼ ਪਾਉਂਡ),
				'other' => q(ਸੁਡਾਨੀਜ਼ ਪਾਉਂਡ),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
				'one' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
				'other' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
				'one' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
				'other' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪਾਉਂਡ),
				'one' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪਾਉਂਡ),
				'other' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪਾਉਂਡ),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
				'one' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
				'other' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(ਸੂਰੀਨਾਮੀਜ਼ ਡਾਲਰ),
				'one' => q(ਸੂਰੀਨਾਮੀਜ਼ ਡਾਲਰ),
				'other' => q(ਸੂਰੀਨਾਮੀਜ਼ ਡਾਲਰ),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਸੁਡਾਨੀਜ਼ ਪਾਉਂਡ),
				'one' => q(ਦੱਖਣੀ ਸੁਡਾਨੀਜ਼ ਪਾਉਂਡ),
				'other' => q(ਦੱਖਣੀ ਸੁਡਾਨੀਜ਼ ਪਾਉਂਡ),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
				'one' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
				'other' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(ਸੀਰੀਆਈ ਪਾਉਂਡ),
				'one' => q(ਸੀਰੀਆਈ ਪਾਉਂਡ),
				'other' => q(ਸੀਰੀਆਈ ਪਾਉਂਡ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
				'one' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
				'other' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ਥਾਈ ਬਾਹਤ),
				'one' => q(ਥਾਈ ਬਾਹਤ),
				'other' => q(ਥਾਈ ਬਾਹਤ),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
				'one' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
				'other' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
				'one' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
				'other' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
				'one' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
				'other' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(ਤੁਰਕਿਸ਼ ਲਿਰਾ),
				'one' => q(ਤੁਰਕਿਸ਼ ਲਿਰਾ),
				'other' => q(ਤੁਰਕਿਸ਼ ਲਿਰਾ),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
				'one' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
				'other' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
				'one' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
				'other' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
				'one' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
				'other' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(ਯੂਗਾਂਡਨ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਯੂਗਾਂਡਨ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਯੂਗਾਂਡਨ ਸ਼ਿਲਿੰਗ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
				'one' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
				'other' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(ਉਰੂਗੁਵਾਇਨ ਪੈਸੋ),
				'one' => q(ਉਰੂਗੁਵਾਇਨ ਪੈਸੋ),
				'other' => q(ਉਰੂਗੁਵਾਇਨ ਪੈਸੋ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
				'one' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
				'other' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
				'one' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
				'other' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ਵਿਯਤਨਾਮੀ ਡੋਂਗ),
				'one' => q(ਵਿਯਤਨਾਮੀ ਡੋਂਗ),
				'other' => q(ਵਿਯਤਨਾਮੀ ਡੋਂਗ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
				'one' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
				'other' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
				'one' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
				'other' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ਫ੍ਰੈਂਕ \(CFA BEAC\)),
				'one' => q(ਫ੍ਰੈਂਕ \(CFA BEAC\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFA BEAC\)),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
				'one' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
				'other' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ਫ੍ਰੈਂਕ \(CFA BCEAO\)),
				'one' => q(ਫ੍ਰੈਂਕ \(CFA BCEAO\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFA BCEAO\)),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ਫ੍ਰੈਂਕ \(CFP\)),
				'one' => q(ਫ੍ਰੈਂਕ \(CFP\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFP\)),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ਅਗਿਆਤ ਮੁਦਰਾ),
				'one' => q(\(ਮੁਦਰਾ ਦੀ ਅਗਿਆਤ ਇਕਾਈ\)),
				'other' => q(\(ਅਗਿਆਤ ਮੁਦਰਾ\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(ਯਮਨੀ ਰਿਆਲ),
				'one' => q(ਯਮਨੀ ਰਿਆਲ),
				'other' => q(ਯਮਨੀ ਰਿਆਲ),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
				'one' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
				'other' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
				'one' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
				'other' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ਜ',
							'ਫ਼',
							'ਮਾ',
							'ਅ',
							'ਮ',
							'ਜੂ',
							'ਜੁ',
							'ਅ',
							'ਸ',
							'ਅ',
							'ਨ',
							'ਦ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ਜ',
							'ਫ਼',
							'ਮਾ',
							'ਅ',
							'ਮ',
							'ਜੂ',
							'ਜੁ',
							'ਅ',
							'ਸ',
							'ਅ',
							'ਨ',
							'ਦ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ਸੋਮ.',
						tue => 'ਮੰਗਲ.',
						wed => 'ਬੁਧ.',
						thu => 'ਵੀਰ.',
						fri => 'ਸ਼ੁੱਕਰ.',
						sat => 'ਸ਼ਨੀ.',
						sun => 'ਐਤ.'
					},
					narrow => {
						mon => 'ਸੋ',
						tue => 'ਮੰ',
						wed => 'ਬੁੱ',
						thu => 'ਵੀ',
						fri => 'ਸ਼ੁੱ',
						sat => 'ਸ਼',
						sun => 'ਐ'
					},
					short => {
						mon => 'ਸੋਮ.',
						tue => 'ਮੰਗਲ.',
						wed => 'ਬੁਧ.',
						thu => 'ਵੀਰ.',
						fri => 'ਸ਼ੁੱਕਰ.',
						sat => 'ਸ਼ਨੀ.',
						sun => 'ਐਤ.'
					},
					wide => {
						mon => 'ਸੋਮਵਾਰ',
						tue => 'ਮੰਗਲਵਾਰ',
						wed => 'ਬੁਧਵਾਰ',
						thu => 'ਵੀਰਵਾਰ',
						fri => 'ਸ਼ੁੱਕਰਵਾਰ',
						sat => 'ਸ਼ਨੀਵਾਰ',
						sun => 'ਐਤਵਾਰ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ਸੋਮ.',
						tue => 'ਮੰਗਲ.',
						wed => 'ਬੁਧ.',
						thu => 'ਵੀਰ.',
						fri => 'ਸ਼ੁੱਕਰ.',
						sat => 'ਸ਼ਨੀ.',
						sun => 'ਐਤ.'
					},
					narrow => {
						mon => 'ਸੋ',
						tue => 'ਮੰ',
						wed => 'ਬੁੱ',
						thu => 'ਵੀ',
						fri => 'ਸ਼ੁੱ',
						sat => 'ਸ਼',
						sun => 'ਐ'
					},
					short => {
						mon => 'ਸੋਮ.',
						tue => 'ਮੰਗਲ.',
						wed => 'ਬੁਧ.',
						thu => 'ਵੀਰ.',
						fri => 'ਸ਼ੁੱਕਰ.',
						sat => 'ਸ਼ਨੀ.',
						sun => 'ਐਤ.'
					},
					wide => {
						mon => 'ਸੋਮਵਾਰ',
						tue => 'ਮੰਗਲਵਾਰ',
						wed => 'ਬੁਧਵਾਰ',
						thu => 'ਵੀਰਵਾਰ',
						fri => 'ਸ਼ੁੱਕਰਵਾਰ',
						sat => 'ਸ਼ਨੀਵਾਰ',
						sun => 'ਐਤਵਾਰ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ਪਊਆ',
						1 => 'ਅੱਧਾ',
						2 => 'ਪੌਣਾ',
						3 => 'ਪੂਰਾ'
					},
					narrow => {0 => '੧',
						1 => '੨',
						2 => '੩',
						3 => '੪'
					},
					wide => {0 => 'ਪਊਆ',
						1 => 'ਅੱਧਾ',
						2 => 'ਪੌਣਾ',
						3 => 'ਪੂਰਾ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ਪਊਆ',
						1 => 'ਅੱਧਾ',
						2 => 'ਪੌਣਾ',
						3 => 'ਪੂਰਾ'
					},
					narrow => {0 => '੧',
						1 => '੨',
						2 => '੩',
						3 => '੪'
					},
					wide => {0 => 'ਪਊਆ',
						1 => 'ਅੱਧਾ',
						2 => 'ਪੌਣਾ',
						3 => 'ਪੂਰਾ'
					},
				},
			},
	} },
);

has 'day_periods' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'am' => q{AM},
					'pm' => q{PM},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ਈ. ਪੂ.',
				'1' => 'ਸੰਨ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, dd MMMM G y},
			'long' => q{d MMMM G y},
			'medium' => q{d MMM G y},
			'short' => q{dd/MM/GGGGG y},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1}, {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Ed => q{E, d},
			Gy => q{G y},
			GyMMM => q{MMM G y},
			GyMMMEd => q{E, d MMM G y},
			GyMMMd => q{d MMM, G y},
			HHmmss => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			mmss => q{mm:ss},
			y => q{G y},
			yMMM => q{MMM G y},
			yQQQ => q{QQQ G y},
			yyyy => q{G y},
			yyyyM => q{M/GGGGG y},
			yyyyMEd => q{E, d/M/GGGGG y},
			yyyyMMM => q{MMM G y},
			yyyyMMMEd => q{E, d MMM, G y},
			yyyyMMMd => q{d MMM, G y},
			yyyyMd => q{d/M/GGGGG y},
			yyyyQQQ => q{QQQ G y},
			yyyyQQQQ => q{QQQQ G y},
		},
		'gregorian' => {
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E d MMM, G y},
			GyMMMd => q{d MMM y},
			H => q{HH},
			HHmmss => q{HH:mm:ss},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, dd-MM.},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M-y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			y => {
				y => q{G y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM-MMM y},
				y => q{MMM y-MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM – E, d MMM y},
				y => q{E, d MMM – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d-d, MMM y},
				y => q{d, MMM – d, MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, dd-MM – E, dd-MM},
				d => q{E, dd-MM – E, dd-MM},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> 'HashRef',
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} ਸਮਾਂ),
		regionFormat => q({0} ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
		regionFormat => q({0} ਮਿਆਰੀ ਸਮਾਂ),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(ਅਫ਼ਗਾਨਿਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ਐਬੀਡਜਾਨ#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ਅੱਕਰਾ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ਐਡਿਸ ਅਬਾਬਾ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ਅਲਜੀਅਰਸ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ਅਸਮਾਰਾ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ਬਮੇਕੋ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ਬਾਂਗੁਈ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ਬਾਂਜੁਲ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ਬਿਸਾਉ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ਬਲੰਟਾਇਰ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ਬ੍ਰਾਜ਼ਾਵਿਲੇ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ਬੁਜੁੰਬੁਰਾ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ਕੈਰੋ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ਕਾਸਬਲੈਂਕਾ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ਸੀਊਟਾ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ਕੋਨੇਕਰੀ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ਡਕਾਰ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ਦਾਰ ਏਸ ਸਲਾਮ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ਜ਼ੀਬੂਤੀ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ਡੌਆਲਾ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ਅਲ ਅਯੂਨ#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ਫਰੀਟਾਉਨ#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ਗਾਬੋਰੋਨ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ਹਰਾਰੇ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ਜੋਹਨਸਬਰਗ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ਜੂਬਾ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ਕੰਪਾਲਾ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ਖਾਰਟੌਮ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ਕਿਗਾਲੀ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ਕਿੰਸ਼ਾਸਾ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ਲਾਗੋਸ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ਲਿਬਰਵਿਲੇ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ਲੋਮ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ਲੁਆਂਡਾ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ਲੁਬੁਮਬਾਸ਼ੀ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ਲੁਸਾਕਾ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ਮਾਲਾਬੋ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ਮਾਪੁਟੋ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ਮਸੇਰੂ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ਏਮਬਾਬਾਨੇ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ਮੋਗਾਦਿਸ਼ੂ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ਮੋਨਰੋਵੀਆ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ਨੈਰੋਬੀ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ਐੰਜਾਮੀਨਾ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ਨਿਆਮੇ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ਨੌਆਕਸ਼ਾਟ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ਉਆਗਾਡੂਗੂ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ਪੋਰਟੋ-ਨੋਵੋ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ਸਾਓ ਟੋਮ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ਟ੍ਰਿਪੋਲੀ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ਟਿਉਨੀਸ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ਵਿੰਡਹੋਇਕ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(ਕੇਂਦਰੀ ਅਫਰੀਕਾ ਸਮਾਂ),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਅਫਰੀਕਾ ਸਮਾਂ),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(ਦੱਖਣੀ ਅਫਰੀਕਾ ਸਮਾਂ),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਅਫਰੀਕਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਅਫਰੀਕਾ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਅਫਰੀਕਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(ਅਲਾਸਕਾ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਅਲਾਸਕਾ ਸਮਾਂ),
				'standard' => q(ਅਲਾਸਕਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(ਅਮੇਜ਼ਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਮੇਜ਼ਨ ਸਮਾਂ),
				'standard' => q(ਅਮੇਜ਼ਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America/Adak' => {
			exemplarCity => q#ਏਡਕ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ਐਂਕਰੇਜ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ਅੰਗੁਇਲਾ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ਐਂਟੀਗੁਆ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ਆਰਗੁਆਇਨਾ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ਲਾ ਰਿਉਜਾ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ਰਿਓ ਗੈਲੇਗੋਸ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ਸਾਲਟਾ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ਸੇਨ ਜੁਆਨ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ਸੇਨ ਲੂਈਸ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ਟੁਕੁਮਨ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ਉਸ਼ਵਾਇਆ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ਅਰੂਬਾ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ਐਸੁਂਕੀਅਨ#,
		},
		'America/Bahia' => {
			exemplarCity => q#ਬਾਹੀਆ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ਬਾਹੀਆ ਬਾਂਦੇਰਸ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ਬਾਰਬਾਡੋਸ#,
		},
		'America/Belem' => {
			exemplarCity => q#ਬੇਲੇਮ#,
		},
		'America/Belize' => {
			exemplarCity => q#ਬੇਲੀਜ਼#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ਬਲੈਂਕ-ਸੈਬਲਾਨ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ਬੋਆ ਵਿਸਟਾ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ਬੋਗੋਟਾ#,
		},
		'America/Boise' => {
			exemplarCity => q#ਬੋਇਸ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ਬਿਉਨੋ ਆਇਰਸ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ਕੈਮਬ੍ਰਿਜ ਬੇ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ਕੈਂਪੋ ਗ੍ਰਾਂਡੇ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ਕੈਨਕੁਨ#,
		},
		'America/Caracas' => {
			exemplarCity => q#ਕੈਰਾਕਾਸ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ਕੈਟਾਮਾਰਕਾ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ਕੇਯੇਨੇ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ਕੇਮੈਨ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ਸ਼ਿਕਾਗੋ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ਚਿਹੁਆਹੁਆ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ਐਟੀਕੋਕਨ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ਕੋਰਡੋਬਾ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ਕੋਸਟਾ ਰੀਕਾ#,
		},
		'America/Creston' => {
			exemplarCity => q#ਕ੍ਰੈਸਟਨ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ਕਯੁਏਬਾ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ਕੁਰਾਕਾਓ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ਡੈਨਮਾਰਕਸ਼ੌਨ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ਡੌਅਸਨ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ਡੌਅਸਨ ਕ੍ਰੀਕ#,
		},
		'America/Denver' => {
			exemplarCity => q#ਡੇਨਵਰ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ਡਿਟਰੋਇਟ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ਡੋਮੀਨਿਕਾ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ਐਡਮੋਂਟਨ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ਯੁਰੂਨੀਪੇ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ਅਲ ਸਲਵਾਡੋਰ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ਫੋਰਟਾਲੇਜ਼ਾ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ਗਲੇਸ ਬੇ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ਨੂਕ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ਗੂਜ਼ ਬੇ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ਗਰਾਂਡ ਤੁਰਕ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ਗ੍ਰੇਨਾਡਾ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ਗੁਆਡੇਲੋਪ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ਗੁਆਟੇਮਾਲਾ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ਗੁਆਇਕਵਿਲ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ਗੁਯਾਨਾ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ਹੈਲੀਫੈਕਸ#,
		},
		'America/Havana' => {
			exemplarCity => q#ਹਵਾਨਾ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ਹਰਮੋਸਿੱਲੋ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ਨੋਕਸ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ਮਾਰੇਂਗੋ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ਪੀਟਰਸਬਰਗ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ਟੈਲ ਸਿਟੀ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ਵੇਵੇ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ਵਿੰਸੇਨੇਸ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ਵਿਨਮੈਕ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ਇੰਡੀਆਨਾਪੋਲਿਸ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ਇਨੁਵਿਕ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ਇਕਾਲੁਈਟ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ਜਮਾਇਕਾ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ਜੂਜੁਏ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ਜਯੂਨੋ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ਮੋੰਟੀਸੈਲੋ, ਕੈਂਟਕੀ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ਕ੍ਰਾਲੇਂਦਿਜਕ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ਲਾ ਪਾਜ਼#,
		},
		'America/Lima' => {
			exemplarCity => q#ਲੀਮਾ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ਲਾਸ ਐਂਜਲਸ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ਲੁਈਸਵਿਲੇ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ਲੋਅਰ ਪ੍ਰਿੰਸ'ਸ ਕਵਾਰਟਰ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ਮੈਸੀਓ#,
		},
		'America/Managua' => {
			exemplarCity => q#ਮਨਾਗੁਆ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ਮਨੌਸ#,
		},
		'America/Marigot' => {
			exemplarCity => q#ਮੈਰੀਗੋਟ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ਮਾਰਟੀਨਿਕ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ਮਾਟਾਮੋਰਸ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ਮਜ਼ੇਤਲਾਨ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ਮੈਂਡੋਜ਼ਾ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ਮੈਨੋਮਿਨੀ#,
		},
		'America/Merida' => {
			exemplarCity => q#ਮੇਰਿਡਾ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ਮੇਟਲਾਕਾਟਲਾ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ਮੈਕਸੀਕੋ ਸਿਟੀ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ਮਿਕੇਲਨ#,
		},
		'America/Moncton' => {
			exemplarCity => q#ਮੋਂਕਟਨ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ਮੋਨਟੇਰੀ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ਮੋਂਟੇਵੀਡੀਓ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ਮੋਂਟਸੇਰਾਤ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ਨਾਸਾਓ#,
		},
		'America/New_York' => {
			exemplarCity => q#ਨਿਊ ਯਾਰਕ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ਨਿਪਿਗੌਨ#,
		},
		'America/Nome' => {
			exemplarCity => q#ਨੋਮ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ਨੌਰੋਨਹਾ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ਬਿਉਲਾ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ਸੇਂਟਰ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ਨਿਊ ਸਲੇਮ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ਓਜੀਨਾਗਾ#,
		},
		'America/Panama' => {
			exemplarCity => q#ਪਨਾਮਾ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ਪੈਂਗਨਿਰਟੰਗ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ਪੈਰਾਮਰੀਬੋ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ਫੋਨਿਕਸ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ਪੋਰਟ-ਔ-ਪ੍ਰਿੰਸ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ਪੋਰਟ ਔਫ ਸਪੇਨ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ਪੋਰਟੋ ਵੇਲ੍ਹੋ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ਪਿਊਰਟੋ ਰੀਕੋ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ਰੇਨੀ ਰਿਵਰ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ਰੈਂਕਿਨ ਇਨਲੈਟ#,
		},
		'America/Recife' => {
			exemplarCity => q#ਰੇਸੀਫੇ#,
		},
		'America/Regina' => {
			exemplarCity => q#ਰੈਜੀਨਾ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ਰੈਜ਼ੋਲਿਊਟ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ਰਿਓ ਬ੍ਰਾਂਕੋ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ਸੈਂਟਾ ਇਸਾਬੇਲ#,
		},
		'America/Santarem' => {
			exemplarCity => q#ਸੇਂਟਾਰਮ#,
		},
		'America/Santiago' => {
			exemplarCity => q#ਸੇਂਟੀਆਗੋ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ਸੇਂਟੋ ਡੋਮਿੰਗੋ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ਸਾਓ ਪੌਲੋ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ਇੱਟੋਕੋਰਟੂਰਮੀਟ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ਸਿਟਕਾ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ਸੇਂਟ ਜੌਨਸ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ਸੇਂਟ ਕਿਟਸ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ਸੇਂਟ ਲੁਸੀਆ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ਸੇਂਟ ਥੋਮਸ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ਸੇਂਟ ਵਿਨਸੇਂਟ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ਸਵਿਫਟ ਕਰੈਂਟ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ਟੇਗੁਸੀਗਲਪਾ#,
		},
		'America/Thule' => {
			exemplarCity => q#ਥੁਲੇ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ਥੰਡਰ ਬੇ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ਟਿਜੂਆਨਾ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ਟੋਰੰਟੋ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ਟੋਰਟੋਲਾ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ਵੈਨਕੂਵਰ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ਵਾਈਟਹੌਰਸ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ਵਿਨੀਪੇਗ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ਯਕੁਤਤ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ਯੈਲੋਨਾਈਫ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਕੇਂਦਰੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਕੇਂਦਰੀ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਕੇਂਦਰੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਪੂਰਬੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਪੂਰਬੀ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਮਾਉਂਟੇਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਮਾਉਂਟੇਨ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਮਾਉਂਟੇਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਪੈਸਿਫਿਕ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਪੈਸਿਫਿਕ ਸਮਾਂ),
				'standard' => q(ਉੱਤਰੀ ਅਮੇਰਿਕਨ ਪੈਸਿਫਿਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ਕਾਸੇ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ਡੇਵਿਸ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ਡਿਉਮੋਂਟ ਡਿਉਰਵਿਲੇ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ਮੈਕਕਵੈਰੀ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ਮੌਸਨ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ਮੈਕਮੁਰਡੋ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ਪਾਮਰ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ਰੋਥੇਰਾ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ਸਵੋਯਾ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ਵੋਸਟੋਕ#,
		},
		'Arabian' => {
			long => {
				'daylight' => q(ਅਰੇਬੀਅਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਅਰੇਬੀਅਨ ਸਮਾਂ),
				'standard' => q(ਅਰੇਬੀਅਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ਲੋਂਗਈਅਰਬਾਇਨ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(ਅਰਜਨਟੀਨਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਰਜਨਟੀਨਾ ਸਮਾਂ),
				'standard' => q(ਅਰਜਨਟੀਨਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(ਆਰਮੀਨਿਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਆਰਮੀਨਿਆ ਸਮਾਂ),
				'standard' => q(ਆਰਮੀਨਿਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ਅਡੇਨ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ਅਲਮੇਟੀ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ਅੰਮਾਨ#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ਇਨਾਡਾਇਰ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ਅਕਤੌ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ਅਕਤੋਬੇ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ਅਸ਼ਗਾਬਾਟ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ਬਗਦਾਦ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ਬਹਿਰੀਨ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ਬਾਕੂ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ਬੈਂਗਕਾਕ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ਬੈਰੂਤ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ਬਿਸ਼ਕੇਕ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ਬਰੂਨੇਈ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ਕੋਲਕਾਤਾ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ਚੋਇਲਬਾਲਸਨ#,
		},
		'Asia/Chongqing' => {
			exemplarCity => q#ਚੋਂਗਿੰਗ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ਕੋਲੰਬੋ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ਡੈਮਸਕਸ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ਢਾਕਾ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ਡਿਲੀ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ਦੁਬਈ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ਦੁਸ਼ਾਂਬੇ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ਗਾਜਾ#,
		},
		'Asia/Harbin' => {
			exemplarCity => q#ਹਾਰਬਿਨ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ਹੇਬਰਾਨ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ਹਾਂਗ ਕਾਂਗ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ਹੋਵਡ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ਇਰਕੁਤਸਕ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ਜਕਾਰਤਾ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ਜਯਾਪੁਰਾ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ਜੇਰੂਸਲਮ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ਕਾਬੁਲ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ਕਮਚਟਕਾ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ਕਰਾਚੀ#,
		},
		'Asia/Kashgar' => {
			exemplarCity => q#ਕੈਸ਼ਗਰ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ਕਾਠਮਾਂਡੂ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ਖਾਨਡਿਗਾ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ਕਰੈਸਨੇਜਰਸ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ਕੌਲਾ ਲੁੰਪੁਰ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ਕੁਚਿੰਗ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ਕੁਵੈਤ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ਮਕਾਉ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ਮੈਗੇਡਨ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ਮਕਸਾਰ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ਮਨੀਲਾ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ਮਸਕਟ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ਨਿਕੋਸੀਆ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ਨੋਵੋਕੁਜ਼ਨੇਟਸਕ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ਨੋਵੋਸਿਬੀਰਸਕ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ਓਮਸਕ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ਓਰਲ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ਫਨੋਮ ਪੇਨਹ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ਪੌਂਟੀਆਨਾਕ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ਪਯੋਂਗਯਾਂਗ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ਕਤਰ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ਕਿਜ਼ੀਲੋਰਡਾ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ਰੰਗੂਨ#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ਰਿਯਾਧ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ਹੋ ਚਾਈ ਮਿਨ੍ਹ ਸਿਟੀ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ਸਖਲੀਨ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ਸਮਰਕਂਡ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ਸਿਉਲ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ਸ਼ੰਘਾਈ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ਸਿੰਗਾਪੁਰ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ਤੈਪਈ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ਤਾਸ਼ਕੈਂਟ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ਟਬਿਲਿਸੀ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ਤੇਹਰਾਨ#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ਥਿੰਫੂ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ਟੋਕਯੋ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ਉਲਾਨਬਾਤਰ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ਊਰੂਮਕੀ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ਉਸਤ-ਨੇਰਾ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ਵਾਏਨਟਿਆਨੇ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ਵਲਾਦੀਵੋਸਤਕ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ਯਕੁਤਸਕ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ਯਕੇਤਰਿਨਬਰਗ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ਯੇਰੇਵਨ#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(ਅਟਲਾਂਟਿਕ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਅਟਲਾਂਟਿਕ ਸਮਾਂ),
				'standard' => q(ਅਟਲਾਂਟਿਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ਅਜੋਰੇਸ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ਬਰਮੂਡਾ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ਕੇਨੇਰੀ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ਕੇਪ ਵਰਡ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ਫੈਰੋ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ਮਡੀਅਰਾ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ਰੇਕਜਾਵਿਕ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ਦੱਖਣੀ ਜਾਰਜਿਆ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ਸੇਂਟ ਹੇਲੇਨਾ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ਸਟੇਨਲੀ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ਏਡੀਲੇਡ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ਬ੍ਰਿਸਬੇਨ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ਬ੍ਰੋਕਨ ਹਿਲ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ਕਰੀ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ਡਾਰਵਿਨ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ਯੂਕਲਾ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ਹੋਬਾਰਟ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ਲਿੰਡੇਮਨ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ਲੌਰਡ ਹੋਵੇ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ਮੈਲਬੋਰਨ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ਪਰਥ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ਸਿਡਨੀ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਕੇਂਦਰੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਕੇਂਦਰੀ ਆਸਟ੍ਰੇਲੀਅਨ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਕੇਂਦਰੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਕੇਂਦਰੀ ਪੱਛਮੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਕੇਂਦਰੀ ਪੱਛਮੀ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਕੇਂਦਰੀ ਪੱਛਮੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਪੂਰਬੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਪੂਰਬੀ ਆਸਟ੍ਰੇਲੀਅਨ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਪੂਰਬੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਪੱਛਮੀ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਆਸਟ੍ਰੇਲੀਅਨ ਸਮਾਂ),
				'standard' => q(ਆਸਟ੍ਰੇਲੀਅਨ ਪੱਛਮੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(ਅਜ਼ਰਬੈਜਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਜ਼ਰਬੈਜਾਨ ਸਮਾਂ),
				'standard' => q(ਅਜ਼ਰਬੈਜਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(ਅਜੋਰੇਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਅਜੋਰੇਸ ਸਮਾਂ),
				'standard' => q(ਅਜੋਰੇਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(ਬੰਗਲਾਦੇਸ਼ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਬੰਗਲਾਦੇਸ਼ ਸਮਾਂ),
				'standard' => q(ਬੰਗਲਾਦੇਸ਼ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(ਭੂਟਾਨ ਸਮਾਂ),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(ਬੋਲੀਵੀਆ ਸਮਾਂ),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਂ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਂ ਸਮਾਂ),
				'standard' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਂ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(ਬਰੂਨੇਈ ਦਾਰੂਸਲਾਮ ਸਮਾਂ),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(ਕੇਪ ਵਰਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੇਪ ਵਰਡ ਸਮਾਂ),
				'standard' => q(ਕੇਪ ਵਰਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(ਚਾਮੋਰੋ ਸਮਾਂ),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(ਚੈਟਹੇਮ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਚੈਟਹੇਮ ਸਮਾਂ),
				'standard' => q(ਚੈਟਹੇਮ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(ਚਿਲੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਚਿਲੀ ਸਮਾਂ),
				'standard' => q(ਚਿਲੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'China' => {
			long => {
				'daylight' => q(ਚੀਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਚੀਨ ਸਮਾਂ),
				'standard' => q(ਚੀਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(ਚੌਇਬਾਲਸਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਚੌਇਬਾਲਸਨ ਸਮਾਂ),
				'standard' => q(ਚੌਇਬਾਲਸਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(ਕ੍ਰਿਸਮਸ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(ਕੋਕੋਜ਼ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(ਕੋਲੰਬੀਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੋਲੰਬੀਆ ਸਮਾਂ),
				'standard' => q(ਕੋਲੰਬੀਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(ਕੁੱਕ ਆਈਲੈਂਡ ਅੱਧਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੁੱਕ ਆਈਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਕੁੱਕ ਆਈਲੈਂਡ ਅੱਧਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(ਕਿਊਬਾ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਕਿਊਬਾ ਸਮਾਂ),
				'standard' => q(ਕਿਊਬਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(ਡੇਵਿਸ ਸਮਾਂ),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(ਡਿਉਮੋਂਟ ਡਿਉਰਵਿਲੇ ਸਮਾਂ),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਟੀਮੁਰ ਸਮਾਂ),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(ਈਸਟਰ ਆਈਲੈਂਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਈਸਟਰ ਆਈਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਈਸਟਰ ਆਈਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(ਇਕਵੇਡੋਰ ਸਮਾਂ),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ਅਗਿਆਤ ਸ਼ਹਿਰ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ਐਮਸਟਰਡਮ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ਅੰਡੋਰਾ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ਏਥਨਸ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ਬੈਲਗ੍ਰੇਡ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ਬਰਲਿਨ#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ਬ੍ਰਟਿਸਲਾਵਾ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ਬਰੂਸੇਲਸ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ਬੁਚਾਰੇਸਟ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ਬੁਡਾਪੇਸਟ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ਬੁਸਿਂਜੇਨ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ਚਿਸਿਨੌ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ਕੋਪੇਨਹੇਗਨ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ਡਬਲਿਨ#,
			long => {
				'daylight' => q(ਆਇਰਿਸ਼ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ਜਿਬਰਾਲਟਰ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ਗਰਨਸੀ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ਹੇਲਸਿੰਕੀ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ਆਇਲ ਆਫ ਮੈਨ#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ਇਸਤਨਾਬੁਲ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ਜਰਸੀ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ਕਾਲੀਨਿੰਗ੍ਰੇਡ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ਕੀਵ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ਲਿਸਬਨ#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ਲਜੁਬਲਜਾਨਾ#,
		},
		'Europe/London' => {
			exemplarCity => q#ਲੰਡਨ#,
			long => {
				'daylight' => q(ਬ੍ਰਿਟਿਸ਼ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ਲਕਜ਼ਮਬਰਗ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ਮੈਡ੍ਰਿਡ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ਮਾਲਟਾ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ਮਾਰੀਏਹਾਮੇਨ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ਮਿੰਸਕ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ਮੋਨਾਕੋ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ਮਾਸਕੋ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ਓਸਲੋ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ਪੈਰਿਸ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ਪੋਡਗੋਰੀਕਾ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ਪ੍ਰਾਗ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ਰਿਗਾ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ਰੋਮ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ਸਮਾਰਾ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ਸੈਨ ਮਰੀਨੋ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ਸਾਰਾਜੇਵੋ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ਸਿਮਫਰੋਪੋਲ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ਸਕੋਪਜੇ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ਸੋਫੀਆ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ਸਟਾਕਹੋਮ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ਟੱਲਿਨ#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ਤਿਰਾਨੇ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ਉਝਗੋਰੋਡ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ਵਾਡੁਜ਼#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ਵੈਟਿਕਨ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ਵਿਏਨਾ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ਵਿਲਨਿਅਸ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ਵੋਲਗੋਗ੍ਰੇਡ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ਵਾਰਸਾਅ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ਜ਼ਗਰੇਬ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ਜਪੋਰੋਜ਼ਾਏ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ਜਿਊਰਿਖ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(ਕੇਂਦਰੀ ਯੂਰੋਪੀਅਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕੇਂਦਰੀ ਯੂਰੋਪੀਅਨ ਸਮਾਂ),
				'standard' => q(ਕੇਂਦਰੀ ਯੂਰੋਪੀਅਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(ਪੂਰਬੀ ਯੂਰੋਪੀਅਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੂਰਬੀ ਯੂਰੋਪੀਅਨ ਸਮਾਂ),
				'standard' => q(ਪੂਰਬੀ ਯੂਰੋਪੀਅਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਯੂਰੋਪੀਅਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਯੂਰੋਪੀਅਨ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਯੂਰੋਪੀਅਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਸਮਾਂ),
				'standard' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(ਫ਼ਿਜ਼ੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫ਼ਿਜ਼ੀ ਸਮਾਂ),
				'standard' => q(ਫ਼ਿਜ਼ੀ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(ਫ੍ਰੈਂਚ ਗੁਏਨਾ ਸਮਾਂ),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(ਫ੍ਰੈਂਚ ਦੱਖਣੀ ਅਤੇ ਐਂਟਾਰਟਿਕ ਸਮਾਂ),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(ਗ੍ਰੀਨਵਿਚ ਮੀਨ ਟਾਈਮ),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(ਗਲਾਪਾਗੋਸ ਸਮਾਂ),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(ਗੈਂਬੀਅਰ ਸਮਾਂ),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(ਜਾਰਜਿਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਜਾਰਜਿਆ ਸਮਾਂ),
				'standard' => q(ਜਾਰਜਿਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(ਗਿਲਬਰਟ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(ਖਾੜੀ ਸਮਾਂ),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(ਗੁਯਾਨਾ ਸਮਾਂ),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਸਮਾਂ),
				'standard' => q(ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(ਹਾਂਗ ਕਾਂਗ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਹਾਂਗ ਕਾਂਗ ਸਮਾਂ),
				'standard' => q(ਹਾਂਗ ਕਾਂਗ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(ਹੋਵਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਹੋਵਡ ਸਮਾਂ),
				'standard' => q(ਹੋਵਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'India' => {
			long => {
				'standard' => q(ਭਾਰਤ ਸਮਾਂ),
			},
			short => {
				'standard' => q(IST),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ਅੰਟਾਨਨੇਰਿਵੋ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ਚਾਗੋਸ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ਕ੍ਰਿਸਮਸ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ਕੋਕੋਜ਼#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ਕੋਮੋਰੋ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ਕਰਗਯੂਲੇਨ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ਮਾਹੇ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ਮਾਲਦੀਵ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ਮੌਰਿਸ਼ਸ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ਮਾਯੋਟੀ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ਰਿਯੂਨੀਅਨ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(ਭਾਰਤੀ ਓਸ਼ਨ ਸਮਾਂ),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(ਇੰਡੋਚਾਈਨਾ ਸਮਾਂ),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(ਕੇਂਦਰੀ ਇੰਡੋਨੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਇੰਡੋਨੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(ਪੱਛਮੀ ਇੰਡੋਨੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(ਈਰਾਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਈਰਾਨ ਸਮਾਂ),
				'standard' => q(ਈਰਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(ਇਰਕੁਤਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਇਰਕੁਤਸਕ ਸਮਾਂ),
				'standard' => q(ਇਰਕੁਤਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(ਇਜ਼ਰਾਈਲ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਇਜ਼ਰਾਈਲ ਸਮਾਂ),
				'standard' => q(ਇਜ਼ਰਾਈਲ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(ਜਾਪਾਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਜਾਪਾਨ ਸਮਾਂ),
				'standard' => q(ਜਾਪਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(ਪੂਰਬੀ ਕਜ਼ਾਕਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(ਪੱਛਮੀ ਕਜ਼ਾਕਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(ਕੋਰੀਆਈ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਕੋਰੀਆਈ ਸਮਾਂ),
				'standard' => q(ਕੋਰੀਆਈ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(ਕੋਸ੍ਰਾਏ ਸਮਾਂ),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(ਕ੍ਰਾਸਨੋਯਾਰਕਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਕ੍ਰਾਸਨੋਯਾਰਕਸ ਸਮਾਂ),
				'standard' => q(ਕ੍ਰਾਸਨੋਯਾਰਕਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(ਕਿਰਗਿਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(ਲਾਈਨ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(ਲੌਰਡ ਹੋਵੇ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਲੌਰਡ ਹੋਵੇ ਸਮਾਂ),
				'standard' => q(ਲੌਰਡ ਹੋਵੇ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(ਮੈਕਕਵੇਰੀ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(ਮੈਗੇਡਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮੈਗੇਡਨ ਸਮਾਂ),
				'standard' => q(ਮੈਗੇਡਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(ਮਲੇਸ਼ੀਆ ਸਮਾਂ),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(ਮਾਲਦੀਵ ਸਮਾਂ),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(ਮਾਰਕਿਸਾਸ ਸਮਾਂ),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(ਮਾਰਸ਼ਲ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(ਮੌਰਿਸ਼ਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮੌਰਿਸ਼ਸ ਸਮਾਂ),
				'standard' => q(ਮੌਰਿਸ਼ਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(ਮੌਸਨ ਸਮਾਂ),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(ਉਲਨ ਬਟੋਰ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਉਲਨ ਬਟੋਰ ਸਮਾਂ),
				'standard' => q(ਉਲਨ ਬਟੋਰ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(ਮਾਸਕੋ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਮਾਸਕੋ ਸਮਾਂ),
				'standard' => q(ਮਾਸਕੋ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(ਮਿਆਂਮਾਰ ਸਮਾਂ),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(ਨਾਉਰੂ ਸਮਾਂ),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(ਨੇਪਾਲ ਸਮਾਂ),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(ਨਿਊ ਕੈਲੇਡੋਨਿਆ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਨਿਊ ਕੈਲੇਡੋਨਿਆ ਸਮਾਂ),
				'standard' => q(ਨਿਊ ਕੈਲੇਡੋਨਿਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(ਨਿਊਫਾਉਂਡਲੈਂਡ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਨਿਊਫਾਉਂਡਲੈਂਡ ਸਮਾਂ),
				'standard' => q(ਨਿਊਫਾਉਂਡਲੈਂਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(ਨਿਊ ਸਮਾਂ),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(ਨੋਰਫੌਕ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਸਮਾਂ),
				'standard' => q(ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(ਨੌਵੋਸਿਬੀਰਕਸ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਨੌਵੋਸਿਬੀਰਕਸ ਸਮਾਂ),
				'standard' => q(ਨੌਵੋਸਿਬੀਰਕਸ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(ਓਮਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਓਮਸਕ ਸਮਾਂ),
				'standard' => q(ਓਮਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ਐਪਿਆ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ਔਕਲੈਂਡ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ਚੈਤਹੈਮ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ਈਸਟਰ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ਇਫੇਟ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ਏੰਡਰਬਰੀ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ਫਕਾਉਫੋ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ਫ਼ਿਜੀ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ਫੁਨਾਫੁਟੀ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ਗਲਪੇਗੋਸ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ਗੈਂਬੀਅਰ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ਗੁਆਡਾਕੇਨਲ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ਗੁਆਮ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ਹੋਨੋਲੁਲੂ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ਜੋਨਸਟਨ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ਕਿਰਿਤਿਮਤੀ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ਕੋਸ੍ਰਾਏ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ਕਵਾਜਾਲੀਨ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ਮੇਜੁਰੋ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ਮਾਰਕਿਸਾਸ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ਮਿਡਵੇ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ਨਾਉਰੂ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ਨਿਯੂ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ਨੋਰਫੌਕ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ਨਾਉਮੇ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ਪਾਗੋ ਪਾਗੋ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ਪਲਾਉ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ਪਿਟਕੈਰਨ#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ਪੋਹਨਪੇਈ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ਪੋਰਟ ਮੋਰੇਸਬੀ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ਰਾਰੋਟੋਂਗਾ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ਸੈਪਾਨ#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ਤਹਿਤੀ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ਟਾਰਾਵਾ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ਟੋਂਗਾਟਾਪੂ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ਚੂਕ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ਵੇਕ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ਵਾਲਿਸ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(ਪਾਕਿਸਤਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪਾਕਿਸਤਾਨ ਸਮਾਂ),
				'standard' => q(ਪਾਕਿਸਤਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(ਪਲਾਉ ਸਮਾਂ),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ ਸਮਾਂ),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(ਪੈਰਾਗਵੇ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੈਰਾਗਵੇ ਸਮਾਂ),
				'standard' => q(ਪੈਰਾਗਵੇ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(ਪੇਰੂ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਪੇਰੂ ਸਮਾਂ),
				'standard' => q(ਪੇਰੂ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(ਫਿਲਿਪਾਈਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਫਿਲਿਪਾਈਨ ਸਮਾਂ),
				'standard' => q(ਫਿਲਿਪਾਈਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(ਫੋਨਿਕਸ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਸਮਾਂ),
				'standard' => q(ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(ਪਿਟਕੈਰਨ ਸਮਾਂ),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(ਪੋਹਨਪੇਈ ਸਮਾਂ),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(ਰਿਯੂਨੀਅਨ ਸਮਾਂ),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(ਰੋਥੇਰਾ ਸਮਾਂ),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(ਸਖਲੀਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਸਖਲੀਨ ਸਮਾਂ),
				'standard' => q(ਸਖਲੀਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(ਸਾਮੋਆ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਸਾਮੋਆ ਸਮਾਂ),
				'standard' => q(ਸਾਮੋਆ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(ਸੇਸ਼ਲਸ ਸਮਾਂ),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(ਸਿੰਗਾਪੁਰ ਸਮਾਂ),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਸਮਾਂ),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(ਦੱਖਣੀ ਜਾਰਜਿਆ ਸਮਾਂ),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(ਸੂਰੀਨਾਮ ਸਮਾਂ),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(ਸਵੋਯਾ ਸਮਾਂ),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(ਤਹਿਤੀ ਸਮਾਂ),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(ਤੈਪਈ ਪ੍ਰਕਾਸ਼ ਸਮਾਂ),
				'generic' => q(ਤੈਪਈ ਸਮਾਂ),
				'standard' => q(ਤੈਪਈ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(ਤਾਜਿਕਿਸਤਾਨ ਸਮਾਂ),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(ਟੋਕੇਲਾਉ ਸਮਾਂ),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(ਟੋਂਗਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਟੋਂਗਾ ਸਮਾਂ),
				'standard' => q(ਟੋਂਗਾ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(ਚੂਕ ਸਮਾਂ),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(ਤੁਰਕਮੇਨਿਸਤਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਤੁਰਕਮੇਨਿਸਤਾਨ ਸਮਾਂ),
				'standard' => q(ਤੁਰਕਮੇਨਿਸਤਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(ਟੁਵਾਲੂ ਸਮਾਂ),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(ਉਰੂਗਵੇ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਉਰੂਗਵੇ ਸਮਾਂ),
				'standard' => q(ਉਰੂਗਵੇ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸਮਾਂ),
				'standard' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(ਵਾਨੂਆਟੂ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਵਾਨੂਆਟੂ ਸਮਾਂ),
				'standard' => q(ਵਾਨੂਆਟੂ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(ਵੈਨੇਜ਼ੂਏਲਾ ਸਮਾਂ),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(ਵਲਾਦੀਵੋਸਤਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਵਲਾਦੀਵੋਸਤਕ ਸਮਾਂ),
				'standard' => q(ਵਲਾਦੀਵੋਸਤਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(ਵੋਲਵੋਗ੍ਰੇਡ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਵੋਲਵੋਗ੍ਰੇਡ ਸਮਾਂ),
				'standard' => q(ਵੋਲਵੋਗ੍ਰੇਡ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(ਵੋਸਟੋਕ ਸਮਾਂ),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(ਵੇਕ ਆਈਲੈਂਡ ਸਮਾਂ),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(ਵਾਲਿਸ ਅਤੇ ਫਯੁਚੁਨਾ ਸਮਾਂ),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(ਯਕੁਤਸਕ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਯਕੁਤਸਕ ਸਮਾਂ),
				'standard' => q(ਯਕੁਤਸਕ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(ਯਕੇਤਰਿਨਬਰਗ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ),
				'generic' => q(ਯਕੇਤਰਿਨਬਰਗ ਸਮਾਂ),
				'standard' => q(ਯਕੇਤਰਿਨਬਰਗ ਮਿਆਰੀ ਸਮਾਂ),
			},
		},
	 } }
);
no Moose;
__PACKAGE__->meta->make_immutable;

1;

# vim: tabstop=4
