package Locale::CLDR::Transformations::Any::Ru::Zh;
# This file auto generated from Data\common\transforms\ru-zh.xml
#	on Sun  3 Dec 10:05:00 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.4');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

BEGIN {
	die "Transliteration requires Perl 5.18 or above"
		unless $^V ge v5.18.0;
}

no warnings 'experimental::regex_sets';
has 'transforms' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub { [
		qr/(?^um:\G.)/,
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
				{
					from => q(Any),
					to => q(Lower),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q(),
					replace => q(аа),
					result  => q(а),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бб),
					result  => q(б),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вв),
					result  => q(в),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гг),
					result  => q(г),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дд),
					result  => q(д),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жж),
					result  => q(ж),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зз),
					result  => q(з),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ии),
					result  => q(и),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кк),
					result  => q(к),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лл),
					result  => q(л),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мм),
					result  => q(),
					revisit => 1,
				},
				{
					before  => q(),
					after   => q([бп]),
					replace => q(м),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q([аеийоуыьэюяё]),
					after   => q(),
					replace => q(нь),
					result  => q(н),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пп),
					result  => q(п),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рр),
					result  => q(р),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сс),
					result  => q(с),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тт),
					result  => q(т),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(уу),
					result  => q(у),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фф),
					result  => q(ф),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хх),
					result  => q(х),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цц),
					result  => q(ц),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чч),
					result  => q(ч),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шш),
					result  => q(ш),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щщ),
					result  => q(щ),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(бург),
					result  => q(堡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(град),
					result  => q(格勒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(город),
					result  => q(哥罗德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(цов),
					result  => q(佐夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(аи),
					result  => q(艾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ай),
					result  => q(艾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ан),
					result  => q(安),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ао),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ау),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(а),
					result  => q(阿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(баи),
					result  => q(拜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бай),
					result  => q(拜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бан),
					result  => q(班),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бао),
					result  => q(包),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бау),
					result  => q(包),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ба),
					result  => q(巴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бен),
					result  => q(边),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бе),
					result  => q(别),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бий),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бин),
					result  => q(宾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(би),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бйо),
					result  => q(比奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бон),
					result  => q(邦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бо),
					result  => q(博),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(буй),
					result  => q(布伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бун),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бу),
					result  => q(布),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бый),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бын),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бы),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бьи),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бью),
					result  => q(比尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бь),
					result  => q(比),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бэй),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бэн),
					result  => q(本),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бэ),
					result  => q(贝),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бю),
					result  => q(比尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(бян),
					result  => q(比扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бя),
					result  => q(比亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(бё),
					result  => q(比奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(б),
					result  => q(布),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ваи),
					result  => q(瓦伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вай),
					result  => q(瓦伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ван),
					result  => q(万),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вао),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вау),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ва),
					result  => q(瓦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вен),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ве),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вий),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вин),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ви),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вйо),
					result  => q(维奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вон),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(во),
					result  => q(沃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вуй),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вун),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ву),
					result  => q(武),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вый),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вын),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вы),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вьи),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вью),
					result  => q(维尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вь),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вэй),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вэн),
					result  => q(文),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вэ),
					result  => q(韦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вю),
					result  => q(维尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(вян),
					result  => q(维扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вя),
					result  => q(维亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(вё),
					result  => q(维奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(в),
					result  => q(夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гаи),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гай),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ган),
					result  => q(甘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гао),
					result  => q(高),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гау),
					result  => q(高),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(га),
					result  => q(加),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ген),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ге),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гий),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(гин),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ги),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гйо),
					result  => q(吉奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(гон),
					result  => q(贡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(го),
					result  => q(戈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гуй),
					result  => q(圭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(гун),
					result  => q(贡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гу),
					result  => q(古),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гый),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(гын),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гы),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гьи),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гью),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гь),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гэй),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(гэн),
					result  => q(根),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гэ),
					result  => q(盖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гю),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(гян),
					result  => q(吉扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гя),
					result  => q(吉亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(гё),
					result  => q(吉奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(г),
					result  => q(格),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(даи),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дай),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дан),
					result  => q(丹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дао),
					result  => q(道),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дау),
					result  => q(道),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(да),
					result  => q(达),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ден),
					result  => q(坚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(де),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джаи),
					result  => q(贾伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джай),
					result  => q(贾伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джан),
					result  => q(占),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джао),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джау),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джа),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джен),
					result  => q(真),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дже),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джий),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джин),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джи),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джйо),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джон),
					result  => q(忠),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джо),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джуй),
					result  => q(朱伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джун),
					result  => q(准),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джу),
					result  => q(朱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джый),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джын),
					result  => q(真),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джы),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джьи),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джью),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джь),
					result  => q(吉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джэй),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джэн),
					result  => q(真),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джэ),
					result  => q(杰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джю),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(джян),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джя),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(джё),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дж),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзаи),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзай),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзан),
					result  => q(赞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзао),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзау),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дза),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзен),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзе),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзий),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзин),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзи),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзйо),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзон),
					result  => q(宗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзо),
					result  => q(佐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзуй),
					result  => q(祖伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзун),
					result  => q(尊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзу),
					result  => q(祖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзый),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзын),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзы),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзьи),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзью),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзь),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзэй),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзэн),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзэ),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзю),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дзян),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзя),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дзё),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дз),
					result  => q(兹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дий),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дин),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ди),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дйо),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дон),
					result  => q(东),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(до),
					result  => q(多),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсаи),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсай),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсан),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсао),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсау),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дса),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсен),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсе),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсий),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дси),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсон),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсо),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсун),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсу),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсый),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсын),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсы),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсьи),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсь),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсэй),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дсэн),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсэ),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дсю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дся),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дс),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дуй),
					result  => q(杜伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дун),
					result  => q(敦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ду),
					result  => q(杜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцаи),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцай),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцан),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцао),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцау),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дца),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцен),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дце),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дций),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дци),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцон),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцо),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцун),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцу),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцый),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцын),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцы),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцьи),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дць),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцэй),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дцэн),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцэ),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дцю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дця),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дц),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчаи),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчай),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчан),
					result  => q(昌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчао),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчау),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дча),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчен),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дче),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчий),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчи),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчйо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчон),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчун),
					result  => q(春),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчу),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчый),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчын),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчы),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчьи),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчь),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчэй),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчэн),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчэ),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дчян),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дчё),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дч),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дый),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дын),
					result  => q(登),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ды),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дьи),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дью),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дь),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дэй),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дэн),
					result  => q(登),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дэ),
					result  => q(代),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дюн),
					result  => q(久恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дю),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(дян),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дя),
					result  => q(佳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(дё),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(д),
					result  => q(德),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ен),
					result  => q(延),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(е),
					result  => q(耶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жаи),
					result  => q(扎伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жай),
					result  => q(扎伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жан),
					result  => q(然),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жао),
					result  => q(饶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жау),
					result  => q(饶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жа),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жен),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(же),
					result  => q(热),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жий),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жин),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жи),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жйо),
					result  => q(若),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жон),
					result  => q(容),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жо),
					result  => q(若),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жуй),
					result  => q(瑞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жун),
					result  => q(容),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жу),
					result  => q(茹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жый),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жын),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жы),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жьи),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жью),
					result  => q(茹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жь),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жэй),
					result  => q(热),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жэн),
					result  => q(任),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жэ),
					result  => q(热),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жю),
					result  => q(茹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(жян),
					result  => q(让),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жя),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(жё),
					result  => q(若),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ж),
					result  => q(日),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(заи),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зай),
					result  => q(宰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зан),
					result  => q(赞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зао),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зау),
					result  => q(藻),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(за),
					result  => q(扎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зен),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зе),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зий),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зин),
					result  => q(津),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зи),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зйо),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зон),
					result  => q(宗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зо),
					result  => q(佐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зуй),
					result  => q(祖伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зун),
					result  => q(尊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зу),
					result  => q(祖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зый),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зын),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зы),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зьи),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зью),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зь),
					result  => q(济),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зэй),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зэн),
					result  => q(曾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зэ),
					result  => q(泽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зю),
					result  => q(久),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(зян),
					result  => q(江),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зя),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(зё),
					result  => q(焦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(з),
					result  => q(兹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ий),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ин),
					result  => q(因),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(и),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(йо),
					result  => q(约),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(й),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(каи),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кай),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кан),
					result  => q(坎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(као),
					result  => q(考),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кау),
					result  => q(考),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ка),
					result  => q(卡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кен),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ке),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кий),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кин),
					result  => q(金),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ки),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кйо),
					result  => q(基奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кон),
					result  => q(孔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ко),
					result  => q(科),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(куй),
					result  => q(奎),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кун),
					result  => q(昆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ку),
					result  => q(库),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кый),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кын),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кы),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кьи),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кью),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кь),
					result  => q(基),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кэй),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кэн),
					result  => q(肯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кэ),
					result  => q(凯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кю),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(кян),
					result  => q(基扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кя),
					result  => q(基亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(кё),
					result  => q(基奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(к),
					result  => q(克),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лаи),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лай),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лан),
					result  => q(兰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лао),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лау),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ла),
					result  => q(拉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лен),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ле),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лий),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лин),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ли),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лйо),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лон),
					result  => q(隆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ло),
					result  => q(洛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(луй),
					result  => q(卢伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лун),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лу),
					result  => q(卢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лый),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лын),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лы),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(льи),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лью),
					result  => q(柳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ль),
					result  => q(利),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лэй),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лэн),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лэ),
					result  => q(莱),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лю),
					result  => q(柳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(лян),
					result  => q(良),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ля),
					result  => q(利亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(лё),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(л),
					result  => q(尔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(маи),
					result  => q(迈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(май),
					result  => q(迈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ман),
					result  => q(曼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мао),
					result  => q(毛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мау),
					result  => q(毛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ма),
					result  => q(马),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мен),
					result  => q(缅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ме),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мий),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мин),
					result  => q(明),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ми),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мйо),
					result  => q(苗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мон),
					result  => q(蒙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мо),
					result  => q(莫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(муй),
					result  => q(穆伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мун),
					result  => q(蒙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(му),
					result  => q(穆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мый),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мын),
					result  => q(门),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мы),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мьи),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мью),
					result  => q(缪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мь),
					result  => q(米),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мэй),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мэн),
					result  => q(门),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мэ),
					result  => q(梅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мюн),
					result  => q(敏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мю),
					result  => q(缪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(мян),
					result  => q(米扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мя),
					result  => q(米亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(мё),
					result  => q(苗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(м),
					result  => q(姆),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(наи),
					result  => q(奈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(най),
					result  => q(奈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нан),
					result  => q(南),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нао),
					result  => q(瑙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нау),
					result  => q(瑙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(на),
					result  => q(纳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нен),
					result  => q(年),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(не),
					result  => q(涅),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ний),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нин),
					result  => q(宁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ни),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нйо),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нон),
					result  => q(农),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(но),
					result  => q(诺),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нуй),
					result  => q(努伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нун),
					result  => q(农),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ну),
					result  => q(努),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ный),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нын),
					result  => q(嫩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ны),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нь),
					result  => q(尼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нэй),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нэн),
					result  => q(嫩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нэ),
					result  => q(内),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нюн),
					result  => q(纽恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ню),
					result  => q(纽),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(нян),
					result  => q(尼扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ня),
					result  => q(尼亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(нё),
					result  => q(尼奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(н),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(он),
					result  => q(翁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(о),
					result  => q(奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(паи),
					result  => q(派),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пай),
					result  => q(派),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пан),
					result  => q(潘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пао),
					result  => q(保),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пау),
					result  => q(保),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(па),
					result  => q(帕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пен),
					result  => q(片),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пе),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пий),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пин),
					result  => q(平),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пи),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пйо),
					result  => q(皮奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пон),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(по),
					result  => q(波),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пуй),
					result  => q(普伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пун),
					result  => q(蓬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пу),
					result  => q(普),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пый),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пын),
					result  => q(彭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пы),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пьи),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пью),
					result  => q(皮尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пь),
					result  => q(皮),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пэй),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пэн),
					result  => q(彭),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пэ),
					result  => q(佩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пю),
					result  => q(皮尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(пян),
					result  => q(皮扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пя),
					result  => q(皮亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(пё),
					result  => q(皮奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(п),
					result  => q(普),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(раи),
					result  => q(赖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рай),
					result  => q(赖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ран),
					result  => q(兰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рао),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рау),
					result  => q(劳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ра),
					result  => q(拉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рен),
					result  => q(连),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ре),
					result  => q(列),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рий),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рин),
					result  => q(林),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ри),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рйо),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рон),
					result  => q(龙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ро),
					result  => q(罗),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(руй),
					result  => q(鲁伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рун),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ру),
					result  => q(鲁),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рый),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рын),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ры),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рьи),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рью),
					result  => q(留),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рь),
					result  => q(里),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рэй),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рэн),
					result  => q(伦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рэ),
					result  => q(雷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рю),
					result  => q(留),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(рян),
					result  => q(良),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ря),
					result  => q(里亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(рё),
					result  => q(廖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(р),
					result  => q(尔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(саи),
					result  => q(赛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сай),
					result  => q(赛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сан),
					result  => q(桑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сао),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сау),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(са),
					result  => q(萨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сен),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(се),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сий),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(син),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(си),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сйо),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сон),
					result  => q(松),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(со),
					result  => q(索),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(суй),
					result  => q(绥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сун),
					result  => q(孙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(су),
					result  => q(苏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счаи),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счай),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счан),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счао),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счау),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сча),
					result  => q(夏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счен),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сче),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счий),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счин),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счйо),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счон),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счо),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счуй),
					result  => q(休伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счун),
					result  => q(逊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счу),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счын),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счьи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счью),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счь),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(счэн),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счю),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(счё),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сч),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сый),
					result  => q(瑟),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сын),
					result  => q(森),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сы),
					result  => q(瑟),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сьи),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сью),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сь),
					result  => q(西),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сэй),
					result  => q(塞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сэн),
					result  => q(森),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сэ),
					result  => q(塞),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сюн),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сю),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(сян),
					result  => q(相),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ся),
					result  => q(贾),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(сё),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(с),
					result  => q(斯),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(таи),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тай),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тан),
					result  => q(坦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тао),
					result  => q(陶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тау),
					result  => q(陶),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(та),
					result  => q(塔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тен),
					result  => q(坚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(те),
					result  => q(捷),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тий),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тин),
					result  => q(京),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ти),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тйо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тон),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(то),
					result  => q(托),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсаи),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсай),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсан),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсао),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсау),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тса),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсен),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсе),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсий),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тси),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсон),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсо),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсун),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсу),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсый),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсын),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсы),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсьи),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсь),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсэй),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тсэн),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсэ),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тсю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тся),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тс),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(туй),
					result  => q(图伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тун),
					result  => q(通),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ту),
					result  => q(图),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцаи),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцай),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцан),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцао),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцау),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тца),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцен),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тце),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тций),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тци),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцон),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцо),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцун),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцу),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцый),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцын),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцы),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцьи),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тць),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцэй),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тцэн),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцэ),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тцю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тця),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тц),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчаи),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчай),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчан),
					result  => q(昌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчао),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчау),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тча),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчен),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тче),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчий),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчи),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчйо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчон),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчун),
					result  => q(春),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчу),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчый),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчын),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчы),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчьи),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчь),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчэй),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчэн),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчэ),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тчян),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тчё),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тч),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тый),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тын),
					result  => q(滕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ты),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тьи),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ть),
					result  => q(季),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тэй),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тэн),
					result  => q(滕),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тэ),
					result  => q(泰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тюн),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(тян),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тя),
					result  => q(佳),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(тё),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(т),
					result  => q(特),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(уй),
					result  => q(维),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ун),
					result  => q(温),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(у),
					result  => q(乌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фаи),
					result  => q(法伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фай),
					result  => q(法伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фан),
					result  => q(凡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фао),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фау),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фа),
					result  => q(法),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фен),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фе),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фий),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фин),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фи),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фйо),
					result  => q(菲奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фон),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фо),
					result  => q(福),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фуй),
					result  => q(富伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фун),
					result  => q(丰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фу),
					result  => q(富),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фый),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фын),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фы),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фьи),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фью),
					result  => q(菲尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фь),
					result  => q(菲),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фэй),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(фэн),
					result  => q(芬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фэ),
					result  => q(费),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фю),
					result  => q(菲尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фя),
					result  => q(菲亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(фё),
					result  => q(菲奥),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ф),
					result  => q(夫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хаи),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хай),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хан),
					result  => q(汉),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хао),
					result  => q(豪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хау),
					result  => q(豪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ха),
					result  => q(哈),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хен),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хе),
					result  => q(赫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хий),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хин),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хон),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хо),
					result  => q(霍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хуй),
					result  => q(惠),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хун),
					result  => q(洪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ху),
					result  => q(胡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хый),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хын),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хы),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хьи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хью),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хь),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хэй),
					result  => q(黑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хэн),
					result  => q(亨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хэ),
					result  => q(海),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хю),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(хян),
					result  => q(希扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(хя),
					result  => q(希亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(х),
					result  => q(赫),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цаи),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цай),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цан),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цао),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цау),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ца),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цен),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(це),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ций),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ци),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цон),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цо),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсаи),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсай),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсан),
					result  => q(灿),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсао),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсау),
					result  => q(曹),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цса),
					result  => q(察),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсен),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсе),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсий),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цси),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсон),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсо),
					result  => q(措),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсун),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсу),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсый),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсын),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсы),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсьи),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсь),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсэй),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цсэн),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсэ),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цсю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цся),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цс),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цун),
					result  => q(聪),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цу),
					result  => q(楚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цый),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цын),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цы),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цьи),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цью),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ць),
					result  => q(齐),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цэй),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(цэн),
					result  => q(岑),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цэ),
					result  => q(采),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(цю),
					result  => q(秋),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ця),
					result  => q(齐亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ц),
					result  => q(茨),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чаи),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чай),
					result  => q(柴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чан),
					result  => q(昌),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чао),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чау),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ча),
					result  => q(恰),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чен),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(че),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чий),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чин),
					result  => q(钦),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чи),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чйо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чон),
					result  => q(琼),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чо),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чуй),
					result  => q(崔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чун),
					result  => q(春),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чу),
					result  => q(丘),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чый),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чын),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чы),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чьи),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чь),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чэй),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чэн),
					result  => q(琴),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чэ),
					result  => q(切),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(чян),
					result  => q(强),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(чё),
					result  => q(乔),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ч),
					result  => q(奇),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шаи),
					result  => q(沙伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шай),
					result  => q(沙伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шан),
					result  => q(尚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шао),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шау),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ша),
					result  => q(沙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шен),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ше),
					result  => q(舍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ший),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шин),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ши),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шйо),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шон),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шо),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шуй),
					result  => q(舒伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шун),
					result  => q(顺),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шу),
					result  => q(舒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шый),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шын),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шы),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шьи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шью),
					result  => q(舒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шь),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шэй),
					result  => q(舍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шэн),
					result  => q(申),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шэ),
					result  => q(舍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шю),
					result  => q(舒),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(шян),
					result  => q(尚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шя),
					result  => q(沙),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(шё),
					result  => q(绍),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ш),
					result  => q(什),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щаи),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щай),
					result  => q(夏伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щан),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щао),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щау),
					result  => q(肖),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ща),
					result  => q(夏),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щен),
					result  => q(先),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ще),
					result  => q(谢),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щий),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щин),
					result  => q(辛),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щйо),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щон),
					result  => q(雄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(що),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щуй),
					result  => q(休伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щун),
					result  => q(逊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щу),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щын),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щьи),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щью),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щь),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(щэн),
					result  => q(欣),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щю),
					result  => q(休),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щё),
					result  => q(晓),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(щ),
					result  => q(希),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ъ),
					result  => q(),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ый),
					result  => q(厄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ын),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ы),
					result  => q(厄),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ьи),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ью),
					result  => q(尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ь),
					result  => q(伊),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(эй),
					result  => q(埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(эн),
					result  => q(恩),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(э),
					result  => q(埃),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(юн),
					result  => q(云),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ю),
					result  => q(尤),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([^[аеийоуыьэюяё]]),
					replace => q(ян),
					result  => q(扬),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(я),
					result  => q(亚),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q(),
					replace => q(ё),
					result  => q(约),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(Null),
				},
			],
		},
		{
			type => 'conversion',
			data => [
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(耶),
					result  => q(叶),
					revisit => 0,
				},
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(夫),
					result  => q(弗),
					revisit => 0,
				},
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(东),
					result  => q(栋),
					revisit => 0,
				},
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(南),
					result  => q(楠),
					revisit => 0,
				},
				{
					before  => q([-\ $]),
					after   => q(),
					replace => q(西),
					result  => q(锡),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(江),
					result  => q(姜),
					revisit => 0,
				},
				{
					before  => q(),
					after   => q([-\ $]),
					replace => q(海),
					result  => q(亥),
					revisit => 0,
				},
			],
		},
		{
			type => 'transform',
			data => [
				{
					from => q(Any),
					to => q(NFC),
				},
			]
		},
	] },
);

no Moo;

1;

# vim: tabstop=4
