=encoding utf8

=head1

Locale::CLDR::Locales::Pa - Package for language Punjabi

=cut

package Locale::CLDR::Locales::Pa;
# This file auto generated from Data\common\main\pa.xml
#	on Sun  3 Feb  2:12:39 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => 'ਅਫ਼ਾਰ',
 				'ab' => 'ਅਬਖਾਜ਼ੀਅਨ',
 				'ace' => 'ਅਚੀਨੀ',
 				'ach' => 'ਅਕੋਲੀ',
 				'ada' => 'ਅਡਾਂਗਮੇ',
 				'ady' => 'ਅਡਿਗੇ',
 				'af' => 'ਅਫ਼ਰੀਕੀ',
 				'agq' => 'ਅਗੇਮ',
 				'ain' => 'ਆਇਨੂ',
 				'ak' => 'ਅਕਾਨ',
 				'ale' => 'ਅਲੇਉਟ',
 				'alt' => 'ਦੱਖਣੀ ਅਲਤਾਈ',
 				'am' => 'ਅਮਹਾਰਿਕ',
 				'an' => 'ਅਰਾਗੋਨੀ',
 				'ang' => 'ਪੁਰਾਣੀ ਅੰਗਰੇਜ਼ੀ',
 				'anp' => 'ਅੰਗਿਕਾ',
 				'ar' => 'ਅਰਬੀ',
 				'ar_001' => 'ਆਧੁਨਿਕ ਮਿਆਰੀ ਅਰਬੀ',
 				'arn' => 'ਮਾਪੁਚੇ',
 				'arp' => 'ਅਰਾਫਾਓ',
 				'as' => 'ਅਸਾਮੀ',
 				'asa' => 'ਅਸੂ',
 				'ast' => 'ਅਸਤੂਰੀ',
 				'av' => 'ਅਵਾਰਿਕ',
 				'awa' => 'ਅਵਧੀ',
 				'ay' => 'ਅਈਮਾਰਾ',
 				'az' => 'ਅਜ਼ਰਬਾਈਜਾਨੀ',
 				'az@alt=short' => 'ਅਜ਼ੇਰੀ',
 				'ba' => 'ਬਸ਼ਕੀਰ',
 				'ban' => 'ਬਾਲੀਨੀਜ਼',
 				'bas' => 'ਬਾਸਾ',
 				'be' => 'ਬੇਲਾਰੂਸੀ',
 				'bem' => 'ਬੇਮਬਾ',
 				'bez' => 'ਬੇਨਾ',
 				'bg' => 'ਬੁਲਗਾਰੀਆਈ',
 				'bgn' => 'ਪੱਛਮੀ ਬਲੂਚੀ',
 				'bho' => 'ਭੋਜਪੁਰੀ',
 				'bi' => 'ਬਿਸਲਾਮਾ',
 				'bin' => 'ਬਿਨੀ',
 				'bla' => 'ਸਿਕਸਿਕਾ',
 				'bm' => 'ਬੰਬਾਰਾ',
 				'bn' => 'ਬੰਗਾਲੀ',
 				'bo' => 'ਤਿੱਬਤੀ',
 				'br' => 'ਬਰੇਟਨ',
 				'brx' => 'ਬੋਡੋ',
 				'bs' => 'ਬੋਸਨੀਆਈ',
 				'bug' => 'ਬਗਨੀਜ਼',
 				'byn' => 'ਬਲਿਨ',
 				'ca' => 'ਕੈਟਾਲਾਨ',
 				'ce' => 'ਚੇਚਨ',
 				'ceb' => 'ਸੀਬੂਆਨੋ',
 				'cgg' => 'ਚੀਗਾ',
 				'ch' => 'ਚਮੋਰੋ',
 				'chk' => 'ਚੂਕੀਸ',
 				'chm' => 'ਮਾਰੀ',
 				'cho' => 'ਚੌਕਟੋ',
 				'chr' => 'ਚੇਰੋਕੀ',
 				'chy' => 'ਛਾਇਆਨ',
 				'ckb' => 'ਕੇਂਦਰੀ ਕੁਰਦਿਸ਼',
 				'co' => 'ਕੋਰਸੀਕਨ',
 				'crs' => 'ਸੇਸੇਲਵਾ ਕ੍ਰਿਓਲ ਫ੍ਰੈਂਚ',
 				'cs' => 'ਚੈੱਕ',
 				'cu' => 'ਚਰਚ ਸਲਾਵੀ',
 				'cv' => 'ਚੁਵਾਸ਼',
 				'cy' => 'ਵੈਲਸ਼',
 				'da' => 'ਡੈਨਿਸ਼',
 				'dak' => 'ਡਕੋਟਾ',
 				'dar' => 'ਦਾਰਗਵਾ',
 				'dav' => 'ਟੇਟਾ',
 				'de' => 'ਜਰਮਨ',
 				'de_AT' => 'ਜਰਮਨ (ਆਸਟਰੀਆਈ)',
 				'de_CH' => 'ਹਾਈ ਜਰਮਨ (ਸਵਿਟਜ਼ਰਲੈਂਡ)',
 				'dgr' => 'ਡੋਗਰਿੱਬ',
 				'dje' => 'ਜ਼ਾਰਮਾ',
 				'dsb' => 'ਲੋਅਰ ਸੋਰਬੀਅਨ',
 				'dua' => 'ਡੂਆਲਾ',
 				'dv' => 'ਦਿਵੇਹੀ',
 				'dyo' => 'ਜੋਲਾ-ਫੋਇਨੀ',
 				'dz' => 'ਜ਼ੋਂਗਖਾ',
 				'dzg' => 'ਡਜ਼ਾਗਾ',
 				'ebu' => 'ਇੰਬੂ',
 				'ee' => 'ਈਵਈ',
 				'efi' => 'ਐਫਿਕ',
 				'egy' => 'ਪੁਰਾਤਨ ਮਿਸਰੀ',
 				'eka' => 'ਏਕਾਜੁਕ',
 				'el' => 'ਯੂਨਾਨੀ',
 				'en' => 'ਅੰਗਰੇਜ਼ੀ',
 				'en_GB' => 'ਅੰਗਰੇਜ਼ੀ (ਬਰਤਾਨਵੀ)',
 				'en_GB@alt=short' => 'ਅੰਗਰੇਜ਼ੀ (ਯੂ.ਕੇ.)',
 				'en_US' => 'ਅੰਗਰੇਜ਼ੀ (ਅਮਰੀਕੀ)',
 				'en_US@alt=short' => 'ਅੰਗਰੇਜ਼ੀ (ਯੂ.ਐੱਸ.)',
 				'eo' => 'ਇਸਪੇਰਾਂਟੋ',
 				'es' => 'ਸਪੇਨੀ',
 				'es_419' => 'ਸਪੇਨੀ (ਲਾਤੀਨੀ ਅਮਰੀਕੀ)',
 				'es_ES' => 'ਸਪੇਨੀ (ਯੂਰਪੀ)',
 				'es_MX' => 'ਸਪੇਨੀ (ਮੈਕਸੀਕੀ)',
 				'et' => 'ਇਸਟੋਨੀਆਈ',
 				'eu' => 'ਬਾਸਕ',
 				'ewo' => 'ਇਵੋਂਡੋ',
 				'fa' => 'ਫ਼ਾਰਸੀ',
 				'ff' => 'ਫੁਲਾਹ',
 				'fi' => 'ਫਿਨਿਸ਼',
 				'fil' => 'ਫਿਲੀਪਿਨੋ',
 				'fj' => 'ਫ਼ਿਜ਼ੀ',
 				'fo' => 'ਫ਼ੇਰੋਸੇ',
 				'fon' => 'ਫੌਨ',
 				'fr' => 'ਫਰਾਂਸੀਸੀ',
 				'fr_CA' => 'ਫਰਾਂਸੀਸੀ (ਕੈਨੇਡੀਅਨ)',
 				'frc' => 'ਕੇਜੁਨ ਫ੍ਰੇੰਚ',
 				'fur' => 'ਫਰੀਉਲੀਅਨ',
 				'fy' => 'ਪੱਛਮੀ ਫ੍ਰਿਸੀਅਨ',
 				'ga' => 'ਆਇਰਸ਼',
 				'gaa' => 'ਗਾ',
 				'gag' => 'ਗਾਗੌਜ਼',
 				'gan' => 'ਚੀਨੀ ਗਾਨ',
 				'gd' => 'ਸਕਾਟਿਸ਼ ਗੇਲਿਕ',
 				'gez' => 'ਜੀਜ਼',
 				'gil' => 'ਗਿਲਬਰਤੀਜ਼',
 				'gl' => 'ਗੈਲਿਸ਼ਿਅਨ',
 				'gn' => 'ਗੁਆਰਾਨੀ',
 				'gor' => 'ਗੋਰੋਂਤਾਲੋ',
 				'grc' => 'ਪੁਰਾਤਨ ਯੂਨਾਨੀ',
 				'gsw' => 'ਜਰਮਨ (ਸਵਿਸ)',
 				'gu' => 'ਗੁਜਰਾਤੀ',
 				'guz' => 'ਗੁਸੀ',
 				'gv' => 'ਮੈਂਕਸ',
 				'gwi' => 'ਗਵਿਚ’ਇਨ',
 				'ha' => 'ਹੌਸਾ',
 				'hak' => 'ਚੀਨੀ ਹਾਕਾ',
 				'haw' => 'ਹਵਾਈ',
 				'he' => 'ਹਿਬਰੂ',
 				'hi' => 'ਹਿੰਦੀ',
 				'hif' => 'ਫਿਜੀ ਹਿੰਦੀ',
 				'hil' => 'ਹਿਲੀਗੇਨਨ',
 				'hmn' => 'ਹਮੋਂਗ',
 				'hr' => 'ਕ੍ਰੋਏਸ਼ਿਆਈ',
 				'hsb' => 'ਅੱਪਰ ਸੋਰਬੀਅਨ',
 				'hsn' => 'ਚੀਨੀ ਜ਼ਿਆਂਗ',
 				'ht' => 'ਹੈਤੀਆਈ',
 				'hu' => 'ਹੰਗਰੀਆਈ',
 				'hup' => 'ਹੂਪਾ',
 				'hy' => 'ਅਰਮੀਨੀਆਈ',
 				'hz' => 'ਹਰੇਰੋ',
 				'ia' => 'ਇੰਟਰਲਿੰਗੁਆ',
 				'iba' => 'ਇਬਾਨ',
 				'ibb' => 'ਇਬੀਬੀਓ',
 				'id' => 'ਇੰਡੋਨੇਸ਼ੀਆਈ',
 				'ig' => 'ਇਗਬੋ',
 				'ii' => 'ਸਿਚੁਆਨ ਯੀ',
 				'ilo' => 'ਇਲੋਕੋ',
 				'inh' => 'ਇੰਗੁਸ਼',
 				'io' => 'ਇਡੂ',
 				'is' => 'ਆਈਸਲੈਂਡਿਕ',
 				'it' => 'ਇਤਾਲਵੀ',
 				'iu' => 'ਇੰਕਟੀਟੂਤ',
 				'ja' => 'ਜਪਾਨੀ',
 				'jbo' => 'ਲੋਜਬਾਨ',
 				'jgo' => 'ਨਗੋਂਬਾ',
 				'jmc' => 'ਮਚਾਮੇ',
 				'jv' => 'ਜਾਵਾਨੀਜ਼',
 				'ka' => 'ਜਾਰਜੀਆਈ',
 				'kab' => 'ਕਬਾਇਲ',
 				'kac' => 'ਕਾਚਿਨ',
 				'kaj' => 'ਜਜੂ',
 				'kam' => 'ਕੰਬਾ',
 				'kbd' => 'ਕਬਾਰਦੀ',
 				'kcg' => 'ਟਾਇਪ',
 				'kde' => 'ਮਕੋਂਡ',
 				'kea' => 'ਕਾਬੁਵੇਰਦਿਆਨੂ',
 				'kfo' => 'ਕੋਰੋ',
 				'kha' => 'ਖਾਸੀ',
 				'khq' => 'ਕੋਯਰਾ ਚੀਨੀ',
 				'ki' => 'ਕਿਕੂਯੂ',
 				'kj' => 'ਕੁਆਨਯਾਮਾ',
 				'kk' => 'ਕਜ਼ਾਖ਼',
 				'kkj' => 'ਕਾਕੋ',
 				'kl' => 'ਕਲਾਅੱਲੀਸੁਟ',
 				'kln' => 'ਕਲੇਜਿਨ',
 				'km' => 'ਖਮੇਰ',
 				'kmb' => 'ਕਿਮਬੁੰਦੂ',
 				'kn' => 'ਕੰਨੜ',
 				'ko' => 'ਕੋਰੀਆਈ',
 				'koi' => 'ਕੋਮੀ-ਪੇਰਮਿਆਕ',
 				'kok' => 'ਕੋਂਕਣੀ',
 				'kpe' => 'ਕਪੇਲ',
 				'kr' => 'ਕਨੂਰੀ',
 				'krc' => 'ਕਰਾਚੇ ਬਲਕਾਰ',
 				'krl' => 'ਕਰੀਲੀਅਨ',
 				'kru' => 'ਕੁਰੁਖ',
 				'ks' => 'ਕਸ਼ਮੀਰੀ',
 				'ksb' => 'ਸ਼ੰਬਾਲਾ',
 				'ksf' => 'ਬਫ਼ੀਆ',
 				'ksh' => 'ਕਲੋਗਨੀਅਨ',
 				'ku' => 'ਕੁਰਦਿਸ਼',
 				'kum' => 'ਕੁਮੀਕ',
 				'kv' => 'ਕੋਮੀ',
 				'kw' => 'ਕੋਰਨਿਸ਼',
 				'ky' => 'ਕਿਰਗੀਜ਼',
 				'la' => 'ਲਾਤੀਨੀ',
 				'lad' => 'ਲੈਡੀਨੋ',
 				'lag' => 'ਲੰਗਾਈ',
 				'lb' => 'ਲਕਜ਼ਮਬਰਗਿਸ਼',
 				'lez' => 'ਲੈਜ਼ਗੀ',
 				'lg' => 'ਗਾਂਡਾ',
 				'li' => 'ਲਿਮਬੁਰਗੀ',
 				'lkt' => 'ਲਕੋਟਾ',
 				'ln' => 'ਲਿੰਗਾਲਾ',
 				'lo' => 'ਲਾਓ',
 				'lou' => 'ਲੇਉ',
 				'loz' => 'ਲੋਜ਼ੀ',
 				'lrc' => 'ਉੱਤਰੀ ਲੁਰੀ',
 				'lt' => 'ਲਿਥੁਆਨੀਅਨ',
 				'lu' => 'ਲੂਬਾ-ਕਾਟਾਂਗਾ',
 				'lua' => 'ਲਿਊਬਾ-ਲਿਊਲਿਆ',
 				'lun' => 'ਲੁੰਡਾ',
 				'luo' => 'ਲੂਓ',
 				'lus' => 'ਮਿਜ਼ੋ',
 				'luy' => 'ਲੂਈਆ',
 				'lv' => 'ਲਾਤੀਵੀ',
 				'mad' => 'ਮਾਡੂਰੀਸ',
 				'mag' => 'ਮਗਾਹੀ',
 				'mai' => 'ਮੈਥਲੀ',
 				'mak' => 'ਮਕਾਸਰ',
 				'mas' => 'ਮਸਾਈ',
 				'mdf' => 'ਮੋਕਸ਼ਾ',
 				'men' => 'ਮੇਂਡੇ',
 				'mer' => 'ਮੇਰੂ',
 				'mfe' => 'ਮੋਰੀਸਿਅਨ',
 				'mg' => 'ਮੇਲੇਗਸੀ',
 				'mgh' => 'ਮਖੋਵਾ-ਮਿੱਟੋ',
 				'mgo' => 'ਮੇਟਾ',
 				'mh' => 'ਮਾਰਸ਼ਲੀਜ਼',
 				'mi' => 'ਮਾਉਰੀ',
 				'mic' => 'ਮਾਇਮੈਕ',
 				'min' => 'ਮਿਨਾਂਗਕਾਬਾਓ',
 				'mk' => 'ਮੈਕਡੋਨੀਆਈ',
 				'ml' => 'ਮਲਿਆਲਮ',
 				'mn' => 'ਮੰਗੋਲੀ',
 				'mni' => 'ਮਨੀਪੁਰੀ',
 				'moh' => 'ਮੋਹਆਕ',
 				'mos' => 'ਮੋਸੀ',
 				'mr' => 'ਮਰਾਠੀ',
 				'ms' => 'ਮਲਯ',
 				'mt' => 'ਮਾਲਟੀਜ਼',
 				'mua' => 'ਮੁੰਡੇਂਗ',
 				'mul' => 'ਬਹੁਤੀਆਂ ਬੋਲੀਆਂ',
 				'mus' => 'ਕ੍ਰੀਕ',
 				'mwl' => 'ਮਿਰਾਂਡੀ',
 				'my' => 'ਬਰਮੀ',
 				'myv' => 'ਇਰਜ਼ੀਆ',
 				'mzn' => 'ਮੇਜ਼ੈਂਡਰਾਨੀ',
 				'na' => 'ਨਾਉਰੂ',
 				'nan' => 'ਚੀਨੀ ਮਿਨ ਨਾਨ',
 				'nap' => 'ਨਿਆਪੋਲੀਟਨ',
 				'naq' => 'ਨਾਮਾ',
 				'nb' => 'ਨਾਰਵੇਜਿਆਈ ਬੋਕਮਲ',
 				'nd' => 'ਉੱਤਰੀ ਨਡੇਬੇਲੇ',
 				'nds' => 'ਲੋ ਜਰਮਨ',
 				'nds_NL' => 'ਲੋ ਸੈਕਸਨ',
 				'ne' => 'ਨੇਪਾਲੀ',
 				'new' => 'ਨੇਵਾਰੀ',
 				'ng' => 'ਐਂਡੋਂਗਾ',
 				'nia' => 'ਨਿਆਸ',
 				'niu' => 'ਨਿਊਏਈ',
 				'nl' => 'ਡੱਚ',
 				'nl_BE' => 'ਫਲੈਮਿਸ਼',
 				'nmg' => 'ਕਵਾਸਿਓ',
 				'nn' => 'ਨਾਰਵੇਜਿਆਈ ਨਿਓਨੌਰਸਕ',
 				'nnh' => 'ਨਿਓਮਬੂਨ',
 				'no' => 'ਨਾਰਵੇਜਿਆਈ',
 				'nog' => 'ਨੋਗਾਈ',
 				'nqo' => 'ਐਂਕੋ',
 				'nr' => 'ਸਾਊਥ ਨਡੇਬੇਲੇ',
 				'nso' => 'ਉੱਤਰੀ ਸੋਥੋ',
 				'nus' => 'ਨੁਏਰ',
 				'nv' => 'ਨਵਾਜੋ',
 				'ny' => 'ਨਯਾਂਜਾ',
 				'nyn' => 'ਨਿਆਂਕੋਲੇ',
 				'oc' => 'ਓਕਸੀਟਾਨ',
 				'om' => 'ਓਰੋਮੋ',
 				'or' => 'ਉੜੀਆ',
 				'os' => 'ਓਸੈਟਿਕ',
 				'pa' => 'ਪੰਜਾਬੀ',
 				'pag' => 'ਪੰਗਾਸੀਨਾਨ',
 				'pam' => 'ਪੈਂਪਾਂਗਾ',
 				'pap' => 'ਪਾਪਿਆਮੈਂਟੋ',
 				'pau' => 'ਪਲਾਊਵੀ',
 				'pcm' => 'ਨਾਇਜੀਰੀਆਈ ਪਿਡਗਿਨ',
 				'pi' => 'ਪਾਲੀ',
 				'pl' => 'ਪੋਲੈਂਡੀ',
 				'prg' => 'ਪਰੂਸ਼ੀਆ',
 				'ps' => 'ਪਸ਼ਤੋ',
 				'pt' => 'ਪੁਰਤਗਾਲੀ',
 				'pt_BR' => 'ਪੁਰਤਗਾਲੀ (ਬ੍ਰਾਜ਼ੀਲੀ)',
 				'pt_PT' => 'ਪੁਰਤਗਾਲੀ (ਯੂਰਪੀ)',
 				'qu' => 'ਕਕੇਸ਼ੁਆ',
 				'quc' => 'ਕੇਸ਼',
 				'raj' => 'ਰਾਜਸਥਾਨੀ',
 				'rap' => 'ਰਾਪਾਨੁਈ',
 				'rar' => 'ਰਾਰੋਤੋਂਗਨ',
 				'rm' => 'ਰੋਮਾਂਸ਼',
 				'rn' => 'ਰੁੰਡੀ',
 				'ro' => 'ਰੋਮਾਨੀਆਈ',
 				'ro_MD' => 'ਮੋਲਡਾਵੀਆਈ',
 				'rof' => 'ਰੋਮਬੋ',
 				'root' => 'ਰੂਟ',
 				'ru' => 'ਰੂਸੀ',
 				'rup' => 'ਅਰੋਮੀਨੀਆਈ',
 				'rw' => 'ਕਿਨਿਆਰਵਾਂਡਾ',
 				'rwk' => 'ਰਵਾ',
 				'sa' => 'ਸੰਸਕ੍ਰਿਤ',
 				'sad' => 'ਸਾਂਡੋ',
 				'sah' => 'ਸਾਖਾ',
 				'saq' => 'ਸਮਬੁਰੂ',
 				'sat' => 'ਸੰਥਾਲੀ',
 				'sba' => 'ਨਗਾਂਬੇ',
 				'sbp' => 'ਸੇਂਗੋ',
 				'sc' => 'ਸਾਰਡੀਨੀਆਈ',
 				'scn' => 'ਸਿਸੀਲੀਅਨ',
 				'sco' => 'ਸਕਾਟਸ',
 				'sd' => 'ਸਿੰਧੀ',
 				'sdh' => 'ਦੱਖਣੀ ਕੁਰਦਿਸ਼',
 				'se' => 'ਉੱਤਰੀ ਸਾਮੀ',
 				'seh' => 'ਸੇਨਾ',
 				'ses' => 'ਕੋਇਰਾਬੋਰੋ ਸੇਂਨੀ',
 				'sg' => 'ਸਾਂਗੋ',
 				'shi' => 'ਟਚੇਲਹਿਟ',
 				'shn' => 'ਸ਼ਾਨ',
 				'si' => 'ਸਿੰਹਾਲਾ',
 				'sk' => 'ਸਲੋਵਾਕ',
 				'sl' => 'ਸਲੋਵੇਨੀਆਈ',
 				'sm' => 'ਸਾਮੋਨ',
 				'sma' => 'ਦੱਖਣੀ ਸਾਮੀ',
 				'smj' => 'ਲਿਊਲ ਸਾਮੀ',
 				'smn' => 'ਇਨਾਰੀ ਸਾਮੀ',
 				'sms' => 'ਸਕੌਲਟ ਸਾਮੀ',
 				'sn' => 'ਸ਼ੋਨਾ',
 				'snk' => 'ਸੋਨਿੰਕੇ',
 				'so' => 'ਸੋਮਾਲੀ',
 				'sq' => 'ਅਲਬਾਨੀਆਈ',
 				'sr' => 'ਸਰਬੀਆਈ',
 				'srn' => 'ਸ੍ਰਾਨਾਨ ਟੋਂਗੋ',
 				'ss' => 'ਸਵਾਤੀ',
 				'ssy' => 'ਸਾਹੋ',
 				'st' => 'ਦੱਖਣੀ ਸੋਥੋ',
 				'su' => 'ਸੂੰਡਾਨੀ',
 				'suk' => 'ਸੁਕੁਮਾ',
 				'sv' => 'ਸਵੀਡਿਸ਼',
 				'sw' => 'ਸਵਾਹਿਲੀ',
 				'sw_CD' => 'ਕਾਂਗੋ ਸਵਾਇਲੀ',
 				'swb' => 'ਕੋਮੋਰੀਅਨ',
 				'syr' => 'ਸੀਰੀਆਈ',
 				'ta' => 'ਤਮਿਲ',
 				'te' => 'ਤੇਲਗੂ',
 				'tem' => 'ਟਿਮਨੇ',
 				'teo' => 'ਟੇਸੋ',
 				'tet' => 'ਟੇਟਮ',
 				'tg' => 'ਤਾਜਿਕ',
 				'th' => 'ਥਾਈ',
 				'ti' => 'ਤਿਗ੍ਰੀਨਿਆ',
 				'tig' => 'ਟਿਗਰਾ',
 				'tk' => 'ਤੁਰਕਮੇਨ',
 				'tlh' => 'ਕਲਿੰਗਨ',
 				'tn' => 'ਤਸਵਾਨਾ',
 				'to' => 'ਟੌਂਗਨ',
 				'tpi' => 'ਟੋਕ ਪਿਸਿਨ',
 				'tr' => 'ਤੁਰਕੀ',
 				'trv' => 'ਟਾਰੋਕੋ',
 				'ts' => 'ਸੋਂਗਾ',
 				'tt' => 'ਤਤਾਰ',
 				'tum' => 'ਤੁੰਬੁਕਾ',
 				'tvl' => 'ਟਿਊਵਾਲੂ',
 				'tw' => 'ਤ੍ਵਿ',
 				'twq' => 'ਤਾਸਾਵਿਕ',
 				'ty' => 'ਤਾਹੀਟੀ',
 				'tyv' => 'ਤੁਵੀਨੀਅਨ',
 				'tzm' => 'ਮੱਧ ਐਟਲਸ ਤਮਾਜ਼ਿਤ',
 				'udm' => 'ਉਦਮੁਰਤ',
 				'ug' => 'ਉਇਗੁਰ',
 				'uk' => 'ਯੂਕਰੇਨੀਆਈ',
 				'umb' => 'ਉਮਬੁੰਡੂ',
 				'und' => 'ਅਣਪਛਾਤੀ ਬੋਲੀ',
 				'ur' => 'ਉਰਦੂ',
 				'uz' => 'ਉਜ਼ਬੇਕ',
 				'vai' => 'ਵਾਈ',
 				've' => 'ਵੇਂਡਾ',
 				'vi' => 'ਵੀਅਤਨਾਮੀ',
 				'vo' => 'ਵੋਲਾਪੂਕ',
 				'vun' => 'ਵੂੰਜੋ',
 				'wa' => 'ਵਲੂਨ',
 				'wae' => 'ਵਾਲਸਰ',
 				'wal' => 'ਵੋਲਾਏਟਾ',
 				'war' => 'ਵੈਰੇ',
 				'wbp' => 'ਵਾਲਪੁਰੀ',
 				'wo' => 'ਵੋਲੋਫ',
 				'wuu' => 'ਚੀਨੀ ਵੂ',
 				'xal' => 'ਕਾਲਮਿਕ',
 				'xh' => 'ਖੋਸਾ',
 				'xog' => 'ਸੋਗਾ',
 				'yav' => 'ਯਾਂਗਬੇਨ',
 				'ybb' => 'ਯੇਂਬਾ',
 				'yi' => 'ਯਿਦਿਸ਼',
 				'yo' => 'ਯੋਰੂਬਾ',
 				'yue' => 'ਕੈਂਟੋਨੀਜ਼',
 				'zgh' => 'ਮਿਆਰੀ ਮੋਰੋਕੇਨ ਟਾਮਾਜ਼ਿਕ',
 				'zh' => 'ਚੀਨੀ (ਮੈਂਡਰਿਨ)',
 				'zh_Hans' => 'ਚੀਨੀ (ਸਰਲ)',
 				'zh_Hant' => 'ਚੀਨੀ (ਰਵਾਇਤੀ)',
 				'zu' => 'ਜ਼ੁਲੂ',
 				'zun' => 'ਜ਼ੂਨੀ',
 				'zxx' => 'ਬੋਲੀ ਸੰਬੰਧੀ ਕੋਈ ਸਮੱਗਰੀ ਨਹੀਂ',
 				'zza' => 'ਜ਼ਾਜ਼ਾ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'ਅਰਬੀ',
 			'Armn' => 'ਅਰਮੀਨੀਆਈ',
 			'Beng' => 'ਬੰਗਾਲੀ',
 			'Bopo' => 'ਬੋਪੋਮੋਫੋ',
 			'Brai' => 'ਬਰੇਲ',
 			'Cyrl' => 'ਸਿਰੀਲਿਕ',
 			'Deva' => 'ਦੇਵਨਾਗਰੀ',
 			'Ethi' => 'ਇਥੀਓਪਿਕ',
 			'Geor' => 'ਜਾਰਜੀਆਈ',
 			'Grek' => 'ਯੂਨਾਨੀ',
 			'Gujr' => 'ਗੁਜਰਾਤੀ',
 			'Guru' => 'ਗੁਰਮੁਖੀ',
 			'Hanb' => 'ਹਾਂਬ',
 			'Hang' => 'ਹੰਗੁਲ',
 			'Hani' => 'ਹਾਨ',
 			'Hans' => 'ਸਰਲ',
 			'Hans@alt=stand-alone' => 'ਸਰਲ ਹਾਨ',
 			'Hant' => 'ਰਵਾਇਤੀ',
 			'Hant@alt=stand-alone' => 'ਰਵਾਇਤੀ ਹਾਨ',
 			'Hebr' => 'ਹਿਬਰੂ',
 			'Hira' => 'ਹਿਰਾਗਾਨਾ',
 			'Hrkt' => 'ਜਾਪਾਨੀ ਸਿਲੇਬਰੀਜ਼',
 			'Jamo' => 'ਜਾਮੋ',
 			'Jpan' => 'ਜਪਾਨੀ',
 			'Kana' => 'ਕਾਟਾਕਾਨਾ',
 			'Khmr' => 'ਖਮੇਰ',
 			'Knda' => 'ਕੰਨੜ',
 			'Kore' => 'ਕੋਰੀਆਈ',
 			'Laoo' => 'ਲਾਓ',
 			'Latn' => 'ਲਾਤੀਨੀ',
 			'Mlym' => 'ਮਲਿਆਲਮ',
 			'Mong' => 'ਮੰਗੋਲੀਅਨ',
 			'Mymr' => 'ਮਿਆਂਮਾਰ',
 			'Orya' => 'ਉੜੀਆ',
 			'Sinh' => 'ਸਿੰਹਾਲਾ',
 			'Taml' => 'ਤਮਿਲ',
 			'Telu' => 'ਤੇਲਗੂ',
 			'Thaa' => 'ਥਾਨਾ',
 			'Thai' => 'ਥਾਈ',
 			'Tibt' => 'ਤਿੱਬਤੀ',
 			'Zmth' => 'ਗਣਿਤ ਚਿੰਨ੍ਹ-ਲਿਪੀ',
 			'Zsye' => 'ਇਮੋਜੀ',
 			'Zsym' => 'ਚਿੰਨ੍ਹ',
 			'Zxxx' => 'ਅਲਿਖਤ',
 			'Zyyy' => 'ਸਧਾਰਨ',
 			'Zzzz' => 'ਅਣਪਛਾਤੀ ਲਿਪੀ',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'ਸੰਸਾਰ',
 			'002' => 'ਅਫ਼ਰੀਕਾ',
 			'003' => 'ਉੱਤਰ ਅਮਰੀਕਾ',
 			'005' => 'ਦੱਖਣ ਅਮਰੀਕਾ',
 			'009' => 'ਓਸ਼ੇਨੀਆ',
 			'011' => 'ਪੱਛਮੀ ਅਫ਼ਰੀਕਾ',
 			'013' => 'ਕੇਂਦਰੀ ਅਮਰੀਕਾ',
 			'014' => 'ਪੂਰਬੀ ਅਫ਼ਰੀਕਾ',
 			'015' => 'ਉੱਤਰੀ ਅਫ਼ਰੀਕਾ',
 			'017' => 'ਮੱਧ ਅਫ਼ਰੀਕਾ',
 			'018' => 'ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ',
 			'019' => 'ਅਮਰੀਕਾ',
 			'021' => 'ਉੱਤਰੀ ਅਮਰੀਕਾ',
 			'029' => 'ਕੈਰੇਬੀਆਈ',
 			'030' => 'ਪੂਰਬੀ ਏਸ਼ੀਆ',
 			'034' => 'ਦੱਖਣੀ ਏਸ਼ੀਆ',
 			'035' => 'ਦੱਖਣ-ਪੂਰਬੀ ਏਸ਼ੀਆ',
 			'039' => 'ਦੱਖਣੀ ਯੂਰਪ',
 			'053' => 'ਆਸਟਰੇਲੇਸ਼ੀਆ',
 			'054' => 'ਮੇਲਾਨੇਸ਼ੀਆ',
 			'057' => 'ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆਈ ਇਲਾਕਾ',
 			'061' => 'ਪੋਲੀਨੇਸ਼ੀਆ',
 			'142' => 'ਏਸ਼ੀਆ',
 			'143' => 'ਕੇਂਦਰੀ ਏਸ਼ੀਆ',
 			'145' => 'ਪੱਛਮੀ ਏਸ਼ੀਆ',
 			'150' => 'ਯੂਰਪ',
 			'151' => 'ਪੂਰਬੀ ਯੂਰਪ',
 			'154' => 'ਉੱਤਰੀ ਯੂਰਪ',
 			'155' => 'ਪੱਛਮੀ ਯੂਰਪ',
 			'202' => 'ਉਪ-ਸਹਾਰਾ ਅਫ਼ਰੀਕਾ',
 			'419' => 'ਲਾਤੀਨੀ ਅਮਰੀਕਾ',
 			'AC' => 'ਅਸੈਂਸ਼ਨ ਟਾਪੂ',
 			'AD' => 'ਅੰਡੋਰਾ',
 			'AE' => 'ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ',
 			'AF' => 'ਅਫ਼ਗਾਨਿਸਤਾਨ',
 			'AG' => 'ਐਂਟੀਗੁਆ ਅਤੇ ਬਾਰਬੁਡਾ',
 			'AI' => 'ਅੰਗੁਇਲਾ',
 			'AL' => 'ਅਲਬਾਨੀਆ',
 			'AM' => 'ਅਰਮੀਨੀਆ',
 			'AO' => 'ਅੰਗੋਲਾ',
 			'AQ' => 'ਅੰਟਾਰਕਟਿਕਾ',
 			'AR' => 'ਅਰਜਨਟੀਨਾ',
 			'AS' => 'ਅਮੈਰੀਕਨ ਸਮੋਆ',
 			'AT' => 'ਆਸਟਰੀਆ',
 			'AU' => 'ਆਸਟ੍ਰੇਲੀਆ',
 			'AW' => 'ਅਰੂਬਾ',
 			'AX' => 'ਅਲੈਂਡ ਟਾਪੂ',
 			'AZ' => 'ਅਜ਼ਰਬਾਈਜਾਨ',
 			'BA' => 'ਬੋਸਨੀਆ ਅਤੇ ਹਰਜ਼ੇਗੋਵੀਨਾ',
 			'BB' => 'ਬਾਰਬਾਡੋਸ',
 			'BD' => 'ਬੰਗਲਾਦੇਸ਼',
 			'BE' => 'ਬੈਲਜੀਅਮ',
 			'BF' => 'ਬੁਰਕੀਨਾ ਫ਼ਾਸੋ',
 			'BG' => 'ਬੁਲਗਾਰੀਆ',
 			'BH' => 'ਬਹਿਰੀਨ',
 			'BI' => 'ਬੁਰੁੰਡੀ',
 			'BJ' => 'ਬੇਨਿਨ',
 			'BL' => 'ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ',
 			'BM' => 'ਬਰਮੂਡਾ',
 			'BN' => 'ਬਰੂਨੇਈ',
 			'BO' => 'ਬੋਲੀਵੀਆ',
 			'BQ' => 'ਕੈਰੇਬੀਆਈ ਨੀਦਰਲੈਂਡ',
 			'BR' => 'ਬ੍ਰਾਜ਼ੀਲ',
 			'BS' => 'ਬਹਾਮਾਸ',
 			'BT' => 'ਭੂਟਾਨ',
 			'BV' => 'ਬੌਵੇਟ ਟਾਪੂ',
 			'BW' => 'ਬੋਤਸਵਾਨਾ',
 			'BY' => 'ਬੇਲਾਰੂਸ',
 			'BZ' => 'ਬੇਲੀਜ਼',
 			'CA' => 'ਕੈਨੇਡਾ',
 			'CC' => 'ਕੋਕੋਸ (ਕੀਲਿੰਗ) ਟਾਪੂ',
 			'CD' => 'ਕਾਂਗੋ - ਕਿੰਸ਼ਾਸਾ',
 			'CD@alt=variant' => 'ਕਾਂਗੋ (ਡੀਆਰਸੀ)',
 			'CF' => 'ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ ਗਣਰਾਜ',
 			'CG' => 'ਕਾਂਗੋ - ਬ੍ਰਾਜ਼ਾਵਿਲੇ',
 			'CG@alt=variant' => 'ਕਾਂਗੋ ਗਣਰਾਜ',
 			'CH' => 'ਸਵਿਟਜ਼ਰਲੈਂਡ',
 			'CI' => 'ਕੋਟ ਡੀਵੋਆਰ',
 			'CI@alt=variant' => 'ਆਇਵਰੀ ਕੋਸਟ',
 			'CK' => 'ਕੁੱਕ ਟਾਪੂ',
 			'CL' => 'ਚਿਲੀ',
 			'CM' => 'ਕੈਮਰੂਨ',
 			'CN' => 'ਚੀਨ',
 			'CO' => 'ਕੋਲੰਬੀਆ',
 			'CP' => 'ਕਲਿੱਪਰਟਨ ਟਾਪੂ',
 			'CR' => 'ਕੋਸਟਾ ਰੀਕਾ',
 			'CU' => 'ਕਿਊਬਾ',
 			'CV' => 'ਕੇਪ ਵਰਡੇ',
 			'CW' => 'ਕੁਰਾਕਾਓ',
 			'CX' => 'ਕ੍ਰਿਸਮਿਸ ਟਾਪੂ',
 			'CY' => 'ਸਾਇਪ੍ਰਸ',
 			'CZ' => 'ਚੈਕੀਆ',
 			'CZ@alt=variant' => 'ਚੈੱਕ ਗਣਰਾਜ',
 			'DE' => 'ਜਰਮਨੀ',
 			'DG' => 'ਡੀਇਗੋ ਗਾਰਸੀਆ',
 			'DJ' => 'ਜ਼ੀਬੂਤੀ',
 			'DK' => 'ਡੈਨਮਾਰਕ',
 			'DM' => 'ਡੋਮੀਨਿਕਾ',
 			'DO' => 'ਡੋਮੀਨਿਕਾਈ ਗਣਰਾਜ',
 			'DZ' => 'ਅਲਜੀਰੀਆ',
 			'EA' => 'ਸਿਓਟਾ ਅਤੇ ਮੇਲਿੱਲਾ',
 			'EC' => 'ਇਕਵੇਡੋਰ',
 			'EE' => 'ਇਸਟੋਨੀਆ',
 			'EG' => 'ਮਿਸਰ',
 			'EH' => 'ਪੱਛਮੀ ਸਹਾਰਾ',
 			'ER' => 'ਇਰੀਟ੍ਰਿਆ',
 			'ES' => 'ਸਪੇਨ',
 			'ET' => 'ਇਥੋਪੀਆ',
 			'EU' => 'ਯੂਰਪੀ ਸੰਘ',
 			'EZ' => 'ਯੂਰੋਜ਼ੋਨ',
 			'FI' => 'ਫਿਨਲੈਂਡ',
 			'FJ' => 'ਫ਼ਿਜੀ',
 			'FK' => 'ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ',
 			'FK@alt=variant' => 'ਫ਼ਾਕਲੈਂਡ ਟਾਪੂ (ਆਈਲਾਸ ਮਾਲਵਿਨਾਸ)',
 			'FM' => 'ਮਾਇਕ੍ਰੋਨੇਸ਼ੀਆ',
 			'FO' => 'ਫੈਰੋ ਟਾਪੂ',
 			'FR' => 'ਫ਼ਰਾਂਸ',
 			'GA' => 'ਗਬੋਨ',
 			'GB' => 'ਯੂਨਾਈਟਡ ਕਿੰਗਡਮ',
 			'GB@alt=short' => 'ਯੂ.ਕੇ.',
 			'GD' => 'ਗ੍ਰੇਨਾਡਾ',
 			'GE' => 'ਜਾਰਜੀਆ',
 			'GF' => 'ਫਰੈਂਚ ਗੁਇਆਨਾ',
 			'GG' => 'ਗਰਨਜੀ',
 			'GH' => 'ਘਾਨਾ',
 			'GI' => 'ਜਿਬਰਾਲਟਰ',
 			'GL' => 'ਗ੍ਰੀਨਲੈਂਡ',
 			'GM' => 'ਗੈਂਬੀਆ',
 			'GN' => 'ਗਿਨੀ',
 			'GP' => 'ਗੁਆਡੇਲੋਪ',
 			'GQ' => 'ਭੂ-ਖੰਡੀ ਗਿਨੀ',
 			'GR' => 'ਗ੍ਰੀਸ',
 			'GS' => 'ਦੱਖਣੀ ਜਾਰਜੀਆ ਅਤੇ ਦੱਖਣੀ ਸੈਂਡਵਿਚ ਟਾਪੂ',
 			'GT' => 'ਗੁਆਟੇਮਾਲਾ',
 			'GU' => 'ਗੁਆਮ',
 			'GW' => 'ਗਿਨੀ-ਬਿਸਾਉ',
 			'GY' => 'ਗੁਯਾਨਾ',
 			'HK' => 'ਹਾਂਗ ਕਾਂਗ ਐਸਏਆਰ ਚੀਨ',
 			'HK@alt=short' => 'ਹਾਂਗ ਕਾਂਗ',
 			'HM' => 'ਹਰਡ ਤੇ ਮੈਕਡੋਨਾਲਡ ਟਾਪੂ',
 			'HN' => 'ਹੋਂਡੁਰਸ',
 			'HR' => 'ਕਰੋਏਸ਼ੀਆ',
 			'HT' => 'ਹੈਤੀ',
 			'HU' => 'ਹੰਗਰੀ',
 			'IC' => 'ਕੇਨਾਰੀ ਟਾਪੂ',
 			'ID' => 'ਇੰਡੋਨੇਸ਼ੀਆ',
 			'IE' => 'ਆਇਰਲੈਂਡ',
 			'IL' => 'ਇਜ਼ਰਾਈਲ',
 			'IM' => 'ਆਇਲ ਆਫ ਮੈਨ',
 			'IN' => 'ਭਾਰਤ',
 			'IO' => 'ਬਰਤਾਨਵੀ ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਖਿੱਤਾ',
 			'IQ' => 'ਇਰਾਕ',
 			'IR' => 'ਈਰਾਨ',
 			'IS' => 'ਆਈਸਲੈਂਡ',
 			'IT' => 'ਇਟਲੀ',
 			'JE' => 'ਜਰਸੀ',
 			'JM' => 'ਜਮਾਇਕਾ',
 			'JO' => 'ਜਾਰਡਨ',
 			'JP' => 'ਜਪਾਨ',
 			'KE' => 'ਕੀਨੀਆ',
 			'KG' => 'ਕਿਰਗਿਜ਼ਸਤਾਨ',
 			'KH' => 'ਕੰਬੋਡੀਆ',
 			'KI' => 'ਕਿਰਬਾਤੀ',
 			'KM' => 'ਕੋਮੋਰੋਸ',
 			'KN' => 'ਸੇਂਟ ਕਿਟਸ ਐਂਡ ਨੇਵਿਸ',
 			'KP' => 'ਉੱਤਰ ਕੋਰੀਆ',
 			'KR' => 'ਦੱਖਣ ਕੋਰੀਆ',
 			'KW' => 'ਕੁਵੈਤ',
 			'KY' => 'ਕੇਮੈਨ ਟਾਪੂ',
 			'KZ' => 'ਕਜ਼ਾਖਸਤਾਨ',
 			'LA' => 'ਲਾਓਸ',
 			'LB' => 'ਲੈਬਨਾਨ',
 			'LC' => 'ਸੇਂਟ ਲੂਸੀਆ',
 			'LI' => 'ਲਿਚੇਂਸਟਾਇਨ',
 			'LK' => 'ਸ੍ਰੀ ਲੰਕਾ',
 			'LR' => 'ਲਾਈਬੀਰੀਆ',
 			'LS' => 'ਲੇਸੋਥੋ',
 			'LT' => 'ਲਿਥੁਆਨੀਆ',
 			'LU' => 'ਲਕਜ਼ਮਬਰਗ',
 			'LV' => 'ਲਾਤਵੀਆ',
 			'LY' => 'ਲੀਬੀਆ',
 			'MA' => 'ਮੋਰੱਕੋ',
 			'MC' => 'ਮੋਨਾਕੋ',
 			'MD' => 'ਮੋਲਡੋਵਾ',
 			'ME' => 'ਮੋਂਟੇਨੇਗਰੋ',
 			'MF' => 'ਸੇਂਟ ਮਾਰਟਿਨ',
 			'MG' => 'ਮੈਡਾਗਾਸਕਰ',
 			'MH' => 'ਮਾਰਸ਼ਲ ਟਾਪੂ',
 			'MK' => 'ਮੈਕਡੋਨੀਆ',
 			'MK@alt=variant' => 'ਮੈਕਡੋਨੀਆ (ਪੂਰਵ ਯੂਗੋਸਲਾਵ ਮੈਕਡੋਨੀਆਈ ਗਣਰਾਜ)',
 			'ML' => 'ਮਾਲੀ',
 			'MM' => 'ਮਿਆਂਮਾਰ (ਬਰਮਾ)',
 			'MN' => 'ਮੰਗੋਲੀਆ',
 			'MO' => 'ਮਕਾਉ ਐਸਏਆਰ ਚੀਨ',
 			'MO@alt=short' => 'ਮਕਾਉ',
 			'MP' => 'ਉੱਤਰੀ ਮਾਰੀਆਨਾ ਟਾਪੂ',
 			'MQ' => 'ਮਾਰਟੀਨਿਕ',
 			'MR' => 'ਮੋਰਿਟਾਨੀਆ',
 			'MS' => 'ਮੋਂਟਸੇਰਾਤ',
 			'MT' => 'ਮਾਲਟਾ',
 			'MU' => 'ਮੌਰੀਸ਼ਸ',
 			'MV' => 'ਮਾਲਦੀਵ',
 			'MW' => 'ਮਲਾਵੀ',
 			'MX' => 'ਮੈਕਸੀਕੋ',
 			'MY' => 'ਮਲੇਸ਼ੀਆ',
 			'MZ' => 'ਮੋਜ਼ਾਮਬੀਕ',
 			'NA' => 'ਨਾਮੀਬੀਆ',
 			'NC' => 'ਨਿਊ ਕੈਲੇਡੋਨੀਆ',
 			'NE' => 'ਨਾਈਜਰ',
 			'NF' => 'ਨੋਰਫੌਕ ਟਾਪੂ',
 			'NG' => 'ਨਾਈਜੀਰੀਆ',
 			'NI' => 'ਨਿਕਾਰਾਗੁਆ',
 			'NL' => 'ਨੀਦਰਲੈਂਡ',
 			'NO' => 'ਨਾਰਵੇ',
 			'NP' => 'ਨੇਪਾਲ',
 			'NR' => 'ਨਾਉਰੂ',
 			'NU' => 'ਨਿਯੂ',
 			'NZ' => 'ਨਿਊਜ਼ੀਲੈਂਡ',
 			'OM' => 'ਓਮਾਨ',
 			'PA' => 'ਪਨਾਮਾ',
 			'PE' => 'ਪੇਰੂ',
 			'PF' => 'ਫਰੈਂਚ ਪੋਲੀਨੇਸ਼ੀਆ',
 			'PG' => 'ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ',
 			'PH' => 'ਫਿਲੀਪੀਨਜ',
 			'PK' => 'ਪਾਕਿਸਤਾਨ',
 			'PL' => 'ਪੋਲੈਂਡ',
 			'PM' => 'ਸੇਂਟ ਪੀਅਰੇ ਐਂਡ ਮਿਕੇਲਨ',
 			'PN' => 'ਪਿਟਕੇਰਨ ਟਾਪੂ',
 			'PR' => 'ਪਿਊਰਟੋ ਰਿਕੋ',
 			'PS' => 'ਫਿਲੀਸਤੀਨੀ ਇਲਾਕਾ',
 			'PS@alt=short' => 'ਫਿਲੀਸਤੀਨ',
 			'PT' => 'ਪੁਰਤਗਾਲ',
 			'PW' => 'ਪਲਾਉ',
 			'PY' => 'ਪੈਰਾਗਵੇ',
 			'QA' => 'ਕਤਰ',
 			'QO' => 'ਆਊਟਲਾਇੰਗ ਓਸ਼ੀਨੀਆ',
 			'RE' => 'ਰਿਯੂਨੀਅਨ',
 			'RO' => 'ਰੋਮਾਨੀਆ',
 			'RS' => 'ਸਰਬੀਆ',
 			'RU' => 'ਰੂਸ',
 			'RW' => 'ਰਵਾਂਡਾ',
 			'SA' => 'ਸਾਊਦੀ ਅਰਬ',
 			'SB' => 'ਸੋਲੋਮਨ ਟਾਪੂ',
 			'SC' => 'ਸੇਸ਼ਲਸ',
 			'SD' => 'ਸੂਡਾਨ',
 			'SE' => 'ਸਵੀਡਨ',
 			'SG' => 'ਸਿੰਗਾਪੁਰ',
 			'SH' => 'ਸੇਂਟ ਹੇਲੇਨਾ',
 			'SI' => 'ਸਲੋਵੇਨੀਆ',
 			'SJ' => 'ਸਵਾਲਬਰਡ ਅਤੇ ਜਾਨ ਮਾਯੇਨ',
 			'SK' => 'ਸਲੋਵਾਕੀਆ',
 			'SL' => 'ਸਿਏਰਾ ਲਿਓਨ',
 			'SM' => 'ਸੈਨ ਮਰੀਨੋ',
 			'SN' => 'ਸੇਨੇਗਲ',
 			'SO' => 'ਸੋਮਾਲੀਆ',
 			'SR' => 'ਸੂਰੀਨਾਮ',
 			'SS' => 'ਦੱਖਣ ਸੁਡਾਨ',
 			'ST' => 'ਸਾਓ ਟੋਮ ਅਤੇ ਪ੍ਰਿੰਸੀਪੇ',
 			'SV' => 'ਅਲ ਸਲਵਾਡੋਰ',
 			'SX' => 'ਸਿੰਟ ਮਾਰਟੀਨ',
 			'SY' => 'ਸੀਰੀਆ',
 			'SZ' => 'ਸਵਾਜ਼ੀਲੈਂਡ',
 			'TA' => 'ਟ੍ਰਿਸਟਾਨ ਦਾ ਕੁੰਹਾ',
 			'TC' => 'ਟੁਰਕਸ ਅਤੇ ਕੈਕੋਸ ਟਾਪੂ',
 			'TD' => 'ਚਾਡ',
 			'TF' => 'ਫਰੈਂਚ ਦੱਖਣੀ ਪ੍ਰਦੇਸ਼',
 			'TG' => 'ਟੋਗੋ',
 			'TH' => 'ਥਾਈਲੈਂਡ',
 			'TJ' => 'ਤਾਜਿਕਿਸਤਾਨ',
 			'TK' => 'ਟੋਕੇਲਾਉ',
 			'TL' => 'ਤਿਮੋਰ-ਲੇਸਤੇ',
 			'TL@alt=variant' => 'ਪੂਰਬ ਤਿਮੋਰ',
 			'TM' => 'ਤੁਰਕਮੇਨਿਸਤਾਨ',
 			'TN' => 'ਟਿਊਨੀਸ਼ੀਆ',
 			'TO' => 'ਟੌਂਗਾ',
 			'TR' => 'ਤੁਰਕੀ',
 			'TT' => 'ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ',
 			'TV' => 'ਟੁਵਾਲੂ',
 			'TW' => 'ਤਾਇਵਾਨ',
 			'TZ' => 'ਤਨਜ਼ਾਨੀਆ',
 			'UA' => 'ਯੂਕਰੇਨ',
 			'UG' => 'ਯੂਗਾਂਡਾ',
 			'UM' => 'ਯੂ.ਐੱਸ. ਦੂਰ-ਦੁਰਾਡੇ ਟਾਪੂ',
 			'UN' => 'ਸੰਯੁਕਤ ਰਾਸ਼ਟਰ',
 			'UN@alt=short' => 'ਯੂ.ਐੱਨ.',
 			'US' => 'ਸੰਯੁਕਤ ਰਾਜ',
 			'US@alt=short' => 'ਯੂ.ਐੱਸ.',
 			'UY' => 'ਉਰੂਗਵੇ',
 			'UZ' => 'ਉਜ਼ਬੇਕਿਸਤਾਨ',
 			'VA' => 'ਵੈਟੀਕਨ ਸਿਟੀ',
 			'VC' => 'ਸੇਂਟ ਵਿਨਸੈਂਟ ਐਂਡ ਗ੍ਰੇਨਾਡੀਨਸ',
 			'VE' => 'ਵੇਨੇਜ਼ੂਏਲਾ',
 			'VG' => 'ਬ੍ਰਿਟਿਸ਼ ਵਰਜਿਨ ਟਾਪੂ',
 			'VI' => 'ਯੂ ਐੱਸ ਵਰਜਿਨ ਟਾਪੂ',
 			'VN' => 'ਵੀਅਤਨਾਮ',
 			'VU' => 'ਵਾਨੂਆਟੂ',
 			'WF' => 'ਵਾਲਿਸ ਅਤੇ ਫੂਟੂਨਾ',
 			'WS' => 'ਸਾਮੋਆ',
 			'XK' => 'ਕੋਸੋਵੋ',
 			'YE' => 'ਯਮਨ',
 			'YT' => 'ਮਾਯੋਟੀ',
 			'ZA' => 'ਦੱਖਣੀ ਅਫਰੀਕਾ',
 			'ZM' => 'ਜ਼ਾਮਬੀਆ',
 			'ZW' => 'ਜ਼ਿੰਬਾਬਵੇ',
 			'ZZ' => 'ਅਣਪਛਾਤਾ ਇਲਾਕਾ',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'ਕੈਲੰਡਰ',
 			'cf' => 'ਮੁਦਰਾ ਬਣਤਰ',
 			'collation' => 'ਲੜੀਬੱਧ ਕ੍ਰਮ',
 			'currency' => 'ਮੁਦਰਾ',
 			'hc' => 'ਘੰਟੇ ਦਾ ਚੱਕਰ (12 ਬਨਾਮ 24)',
 			'lb' => 'ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ',
 			'ms' => 'ਮਾਪ ਪ੍ਰਣਾਲੀ',
 			'numbers' => 'ਸੰਖਿਆਵਾਂ',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{ਬੋਧੀ ਕੈਲੰਡਰ},
 				'chinese' => q{ਚੀਨੀ ਕੈਲੰਡਰ},
 				'coptic' => q{ਕੋਪਟਿਕ ਕੈਲੰਡਰ},
 				'dangi' => q{ਡਾਂਗੀ ਕੈਲੰਡਰ},
 				'ethiopic' => q{ਇਥੀਓਪਿਕ ਕੈਲੰਡਰ},
 				'ethiopic-amete-alem' => q{ਇਥੀਓਪਿਕ-ਅਮੀਟ-ਆਲਮ},
 				'gregorian' => q{ਗਰੇਗੋਰੀਅਨ ਕੈਲੰਡਰ},
 				'hebrew' => q{ਹਿਬਰੂ ਕੈਲੰਡਰ},
 				'indian' => q{ਭਾਰਤੀ ਕੌਮੀ ਕੈਲੰਡਰ},
 				'islamic' => q{ਇਸਲਾਮੀ ਕੈਲੰਡਰ},
 				'islamic-civil' => q{ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਸਾਰਨੀਬੱਧ, ਸਮਾਜਿਕ ਯੁੱਗ)},
 				'islamic-rgsa' => q{ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਸਾਊਦੀ ਅਰਬ, ਚੰਨ ਦਿਖਣਾ)},
 				'islamic-tbla' => q{ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਟੇਬਲਰ, ਖਗੋਲੀ ਯੁੱਗ)},
 				'islamic-umalqura' => q{ਇਸਲਾਮੀ ਕੈਲੰਡਰ (ਅਮ ਅਲ-ਕੁਰਾ)},
 				'iso8601' => q{(ISO-8601) ਕੈਲੰਡਰ},
 				'japanese' => q{ਜਪਾਨੀ ਕੈਲੰਡਰ},
 				'persian' => q{ਫ਼ਾਰਸੀ ਕੈਲੰਡਰ},
 				'roc' => q{ਮਿੰਗੂਓ ਕੈਲੰਡਰ},
 			},
 			'cf' => {
 				'account' => q{ਲੇਖਾ ਮੁਦਰਾ ਬਣਤਰ},
 				'standard' => q{ਮਿਆਰੀ ਮੁਦਰਾ ਬਣਤਰ},
 			},
 			'collation' => {
 				'compat' => q{ਪਿਛਲਾ ਤਰਤੀਬ ਵਾਰ ਕ੍ਰਮ, ਅਨੁਰੂਪਤਾ ਲਈ},
 				'dictionary' => q{ਸ਼ਬਦ-ਕੋਸ਼ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 				'ducet' => q{ਮੂਲ ਯੂਨੀਕੋਡ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 				'search' => q{ਆਮ-ਮੰਤਵ ਖੋਜ},
 				'standard' => q{ਸਧਾਰਨ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 				'traditional' => q{ਰਵਾਇਤੀ ਲੜੀਬੱਧ ਕ੍ਰਮ},
 			},
 			'hc' => {
 				'h11' => q{12 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (0–11)},
 				'h12' => q{12 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (1–12)},
 				'h23' => q{24 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (0–23)},
 				'h24' => q{24 ਘੰਟੇ ਦੀ ਪ੍ਰਣਾਲੀ (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ਖੁੱਲ੍ਹੀ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ},
 				'normal' => q{ਸਧਾਰਨ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ},
 				'strict' => q{ਪੱਕੀ ਰੇਖਾ ਵਿੱਥ ਸ਼ੈਲੀ},
 			},
 			'ms' => {
 				'metric' => q{ਮੀਟਰਿਕ ਪ੍ਰਣਾਲੀ},
 				'uksystem' => q{ਇੰਪੀਰੀਅਲ ਮਾਪ ਪ੍ਰਣਾਲੀ},
 				'ussystem' => q{ਅਮਰੀਕੀ ਮਾਪ ਪ੍ਰਣਾਲੀ},
 			},
 			'numbers' => {
 				'arab' => q{ਅਰਬੀ-ਭਾਰਤੀ ਅੰਕ},
 				'arabext' => q{ਵਿਸਤਾਰਿਤ ਅਰਬੀ-ਭਾਰਤੀ ਅੰਕ},
 				'armn' => q{ਆਰਮੀਨੀਅਨ ਸੰਖਿਆਵਾਂ},
 				'armnlow' => q{ਆਰਮੀਨੀਅਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'beng' => q{ਬੰਗਾਲੀ ਅੰਕ},
 				'brah' => q{ਬਰਾਹਮੀ ਅੰਕ},
 				'deva' => q{ਦੇਵਨਾਗਰੀ ਅੰਕ},
 				'ethi' => q{ਐਥਿਓਪਿਕ ਸੰਖਿਆਵਾਂ},
 				'fullwide' => q{ਪੂਰਨ ਵਿਸਤਾਰ ਅੰਕ},
 				'geor' => q{ਜਾਰਜੀਅਨ ਸੰਖਿਆਵਾਂ},
 				'grek' => q{ਯੂਨਾਨੀ ਸੰਖਿਆਵਾਂ},
 				'greklow' => q{ਯੂਨਾਨੀ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'gujr' => q{ਗੁਜਰਾਤੀ ਅੰਕ},
 				'guru' => q{ਗੁਰਮੁਖੀ ਅੰਕ},
 				'hanidec' => q{ਚੀਨੀ ਦਸ਼ਮਲਵ ਸੰਖਿਆਵਾਂ},
 				'hans' => q{ਸਰਲ ਚੀਨੀ ਸੰਖਿਆਵਾਂ},
 				'hansfin' => q{ਸਰਲ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'hant' => q{ਰਵਾਇਤੀ ਚੀਨੀ ਸੰਖਿਆਵਾਂ},
 				'hantfin' => q{ਰਵਾਇਤੀ ਚੀਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'hebr' => q{ਹਿਬਰੂ ਸੰਖਿਆਵਾਂ},
 				'jpan' => q{ਜਪਾਨੀ ਸੰਖਿਆਵਾਂ},
 				'jpanfin' => q{ਜਪਾਨੀ ਵਿੱਤੀ ਸੰਖਿਆਵਾਂ},
 				'khmr' => q{ਖਮੇਰ ਅੰਕ},
 				'knda' => q{ਕੰਨੜ ਅੰਕ},
 				'laoo' => q{ਲਾਓ ਅੰਕ},
 				'latn' => q{ਪੱਛਮੀ ਅੰਕ},
 				'mlym' => q{ਮਲਿਆਲਮ ਅੰਕ},
 				'mong' => q{ਮੰਗੋਲ ਅੰਕ},
 				'mymr' => q{ਮਿਆਂਮਾਰ ਅੰਕ},
 				'orya' => q{ਉੜੀਆ ਅੰਕ},
 				'roman' => q{ਰੋਮਨ ਸੰਖਿਆਵਾਂ},
 				'romanlow' => q{ਰੋਮਨ ਲੋਅਰਕੇਸ ਸੰਖਿਆਵਾਂ},
 				'taml' => q{ਰਵਾਇਤੀ ਤਮਿਲ ਸੰਖਿਆਵਾਂ},
 				'tamldec' => q{ਤਮਿਲ ਅੰਕ},
 				'telu' => q{ਤੇਲਗੂ ਅੰਕ},
 				'thai' => q{ਥਾਈ ਅੰਕ},
 				'tibt' => q{ਤਿੱਬਤੀ ਅੰਕ},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{ਮੀਟਰਿਕ},
 			'UK' => q{ਯੂ. ਕੇ.},
 			'US' => q{ਯੂ. ਐਸ.},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'ਬੋਲੀ: {0}',
 			'script' => 'ਲਿਪੀ: {0}',
 			'region' => 'ਇਲਾਕਾ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[‌‍ ਃ ਂ ਁ {ਲ਼}]},
			index => ['ੴ', 'ੳ', 'ਉ', 'ਊ', 'ਓ', 'ਅ', 'ਆ', 'ਐ', 'ਔ', 'ੲ', 'ਇ', 'ਈ', 'ਏ', 'ਸ', 'ਹ', 'ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਵ', 'ੜ'],
			main => qr{[ੱ ੰ ਼ ੦ ੧ ੨ ੩ ੪ ੫ ੬ ੭ ੮ ੯ ੴ ੳ ਉ ਊ ਓ ਅ ਆ ਐ ਔ ੲ ਇ ਈ ਏ ਸ {ਸ਼} ਹ ਕ ਖ {ਖ਼} ਗ {ਗ਼} ਘ ਙ ਚ ਛ ਜ {ਜ਼} ਝ ਞ ਟ ਠ ਡ ਢ ਣ ਤ ਥ ਦ ਧ ਨ ਪ ਫ {ਫ਼} ਬ ਭ ਮ ਯ ਰ ਲ ਵ ੜ ੍ ਾ ਿ ੀ ੁ ੂ ੇ ੈ ੋ ੌ]},
			numbers => qr{[\- , . % ‰ + 0੦ 1੧ 2੨ 3੩ 4੪ 5੫ 6੬ 7੭ 8੮ 9੯]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? . ' ‘ ’ " “ ” ( ) \[ \] / \& ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['ੴ', 'ੳ', 'ਉ', 'ਊ', 'ਓ', 'ਅ', 'ਆ', 'ਐ', 'ਔ', 'ੲ', 'ਇ', 'ਈ', 'ਏ', 'ਸ', 'ਹ', 'ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਵ', 'ੜ'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'' => {
						'name' => q(ਮੁੱਖ ਦਿਸ਼ਾ),
					},
					'acre' => {
						'name' => q(ਏਕੜ),
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'acre-foot' => {
						'name' => q(ਏਕੜ ਫੁੱਟ),
						'one' => q({0} ਏਕੜ ਫੁੱਟ),
						'other' => q({0} ਏਕੜ ਫੁੱਟ),
					},
					'ampere' => {
						'name' => q(ਐਮਪੀਅਰ),
						'one' => q({0} ਐਮਪੀਅਰ),
						'other' => q({0} ਐਮਪੀਅਰ),
					},
					'arc-minute' => {
						'name' => q(ਚਾਪ-ਮਿੰਟ),
						'one' => q({0} ਚਾਪ-ਮਿੰਟ),
						'other' => q({0} ਚਾਪ-ਮਿੰਟ),
					},
					'arc-second' => {
						'name' => q(ਚਾਪ-ਸਕਿੰਟ),
						'one' => q({0} ਚਾਪ-ਸਕਿੰਟ),
						'other' => q({0} ਚਾਪ-ਸਕਿੰਟ),
					},
					'astronomical-unit' => {
						'name' => q(ਖਗੋਲੀ ਇਕਾਈਆਂ),
						'one' => q({0} ਖਗੋਲੀ ਇਕਾਈ),
						'other' => q({0} ਖਗੋਲੀ ਇਕਾਈਆਂ),
					},
					'atmosphere' => {
						'name' => q(ਵਾਯੂਮੰਡਲ),
						'one' => q({0} ਵਾਯੂਮੰਡਲ),
						'other' => q({0} ਵਾਯੂਮੰਡਲ),
					},
					'bit' => {
						'name' => q(ਬਿਟ),
						'one' => q({0} ਬਿਟ),
						'other' => q({0} ਬਿਟ),
					},
					'bushel' => {
						'name' => q(ਬੁਸ਼ਲ),
						'one' => q({0} ਬੁਸ਼ਲ),
						'other' => q({0} ਬੁਸ਼ਲ),
					},
					'byte' => {
						'name' => q(ਬਾਇਟ),
						'one' => q({0} ਬਾਇਟ),
						'other' => q({0} ਬਾਇਟ),
					},
					'calorie' => {
						'name' => q(ਕੈਲੋਰੀਆਂ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'carat' => {
						'name' => q(ਕੈਰਟ),
						'one' => q({0} ਕੈਰਟ),
						'other' => q({0} ਕੈਰਟ),
					},
					'celsius' => {
						'name' => q(ਦਰਜੇ ਸੈਲਸੀਅਸ),
						'one' => q({0} ਦਰਜਾ ਸੈਲਸੀਅਸ),
						'other' => q({0} ਦਰਜੇ ਸੈਲਸੀਅਸ),
					},
					'centiliter' => {
						'name' => q(ਸੈਂਟੀਲਿਟਰ),
						'one' => q({0} ਸੈਂਟੀਲਿਟਰ),
						'other' => q({0} ਸੈਂਟੀਲਿਟਰ),
					},
					'centimeter' => {
						'name' => q(ਸੈਂਟੀਮੀਟਰ),
						'one' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਸੈਂਟੀਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਸੈਂਟੀਮੀਟਰ),
					},
					'century' => {
						'name' => q(ਸਦੀਆਂ),
						'one' => q({0} ਸਦੀ),
						'other' => q({0} ਸਦੀਆਂ),
					},
					'coordinate' => {
						'east' => q({0}ਪੂ),
						'north' => q({0}ਉ),
						'south' => q({0}ਦੱ),
						'west' => q({0}ਪੱ),
					},
					'cubic-centimeter' => {
						'name' => q(ਘਣ ਸੈਂਟੀਮੀਟਰ),
						'one' => q({0} ਘਣ ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਘਣ ਸੈਂਟੀਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਘਣ ਸੈਂਟੀਮੀਟਰ),
					},
					'cubic-foot' => {
						'name' => q(ਘਣ ਫੁੱਟ),
						'one' => q({0} ਘਣ ਫੁੱਟ),
						'other' => q({0} ਘਣ ਫੁੱਟ),
					},
					'cubic-inch' => {
						'name' => q(ਘਣ ਇੰਚ),
						'one' => q({0} ਘਣ ਇੰਚ),
						'other' => q({0} ਘਣ ਇੰਚ),
					},
					'cubic-kilometer' => {
						'name' => q(ਘਣ ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਘਣ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਘਣ ਕਿਲੋਮੀਟਰ),
					},
					'cubic-meter' => {
						'name' => q(ਘਣ ਮੀਟਰ),
						'one' => q({0} ਘਣ ਮੀਟਰ),
						'other' => q({0} ਘਣ ਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਘਣ ਮੀਟਰ),
					},
					'cubic-mile' => {
						'name' => q(ਘਣ ਮੀਲ),
						'one' => q({0} ਘਣ ਮੀਲ),
						'other' => q({0} ਘਣ ਮੀਲ),
					},
					'cubic-yard' => {
						'name' => q(ਘਣ ਗਜ਼),
						'one' => q({0} ਘਣ ਗਜ਼),
						'other' => q({0} ਘਣ ਗਜ਼),
					},
					'cup' => {
						'name' => q(ਕੱਪ),
						'one' => q({0} ਕੱਪ),
						'other' => q({0} ਕੱਪ),
					},
					'cup-metric' => {
						'name' => q(ਮੀਟਰਿਕ ਕੱਪ),
						'one' => q({0} ਮੀਟਰਿਕ ਕੱਪ),
						'other' => q({0} ਮੀਟਰਿਕ ਕੱਪ),
					},
					'day' => {
						'name' => q(ਦਿਨ),
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
						'per' => q({0} ਪ੍ਰਤੀ ਦਿਨ),
					},
					'deciliter' => {
						'name' => q(ਡੈਸੀਲਿਟਰ),
						'one' => q({0} ਡੈਸੀਲਿਟਰ),
						'other' => q({0} ਡੈਸੀਲਿਟਰ),
					},
					'decimeter' => {
						'name' => q(ਡੈਸੀਮੀਟਰ),
						'one' => q({0} ਡੈਸੀਮੀਟਰ),
						'other' => q({0} ਡੈਸੀਮੀਟਰ),
					},
					'degree' => {
						'name' => q(ਡਿਗਰੀ),
						'one' => q({0} ਡਿਗਰੀ),
						'other' => q({0} ਡਿਗਰੀ),
					},
					'fahrenheit' => {
						'name' => q(ਦਰਜੇ ਫਾਰੇਨਹਾਈਟ),
						'one' => q({0} ਦਰਜਾ ਫਾਰੇਨਹਾਈਟ),
						'other' => q({0} ਦਰਜੇ ਫਾਰੇਨਹਾਈਟ),
					},
					'fathom' => {
						'name' => q(ਫ਼ੈਦਮ),
						'one' => q({0} ਫ਼ੈਦਮ),
						'other' => q({0} ਫ਼ੈਦਮ),
					},
					'fluid-ounce' => {
						'name' => q(ਤਰਲ ਔਂਸ),
						'one' => q({0} ਤਰਲ ਔਂਸ),
						'other' => q({0} ਤਰਲ ਔਂਸ),
					},
					'foodcalorie' => {
						'name' => q(ਕੈਲੋਰੀਆਂ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'foot' => {
						'name' => q(ਫੁੱਟ),
						'one' => q({0} ਫੁੱਟ),
						'other' => q({0} ਫੁੱਟ),
						'per' => q({0} ਪ੍ਰਤੀ ਫੁੱਟ),
					},
					'furlong' => {
						'name' => q(ਫਰਲਾਂਗ),
						'one' => q({0} ਫਰਲਾਂਗ),
						'other' => q({0} ਫਰਲਾਂਗ),
					},
					'g-force' => {
						'name' => q(ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
						'one' => q({0} ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
						'other' => q({0} ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
					},
					'gallon' => {
						'name' => q(ਗੈਲਨ),
						'one' => q({0} ਗੈਲਨ),
						'other' => q({0} ਗੈਲਨ),
						'per' => q({0} ਪ੍ਰਤੀ ਗੈਲਨ),
					},
					'gallon-imperial' => {
						'name' => q(ਇੰਪ. ਗੈਲਨ),
						'one' => q({0} ਇੰਪ. ਗੈਲਨ),
						'other' => q({0} ਇੰਪ. ਗੈਲਨ),
						'per' => q({0} ਪ੍ਰਤੀ ਇੰਪ. ਗੈਲਨ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(ਗੀਗਾਬਿਟ),
						'one' => q({0} ਗੀਗਾਬਿਟ),
						'other' => q({0} ਗੀਗਾਬਿਟ),
					},
					'gigabyte' => {
						'name' => q(ਗੀਗਾਬਾਇਟ),
						'one' => q({0} ਗੀਗਾਬਾਇਟ),
						'other' => q({0} ਗੀਗਾਬਾਇਟ),
					},
					'gigahertz' => {
						'name' => q(ਗੀਗਾਹਰਟਜ਼),
						'one' => q({0} ਗੀਗਾਹਰਟਜ਼),
						'other' => q({0} ਗੀਗਾਹਰਟਜ਼),
					},
					'gigawatt' => {
						'name' => q(ਗੀਗਾਵਾਟ),
						'one' => q({0} ਗੀਗਾਵਾਟ),
						'other' => q({0} ਗੀਗਾਵਾਟ),
					},
					'gram' => {
						'name' => q(ਗ੍ਰਾਮ),
						'one' => q({0} ਗ੍ਰਾਮ),
						'other' => q({0} ਗ੍ਰਾਮ),
						'per' => q({0} ਪ੍ਰਤੀ ਗ੍ਰਾਮ),
					},
					'hectare' => {
						'name' => q(ਹੈਕਟੇਅਰ),
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectoliter' => {
						'name' => q(ਹੈਕਟੋਲਿਟਰ),
						'one' => q({0} ਹੈਕਟੋਲਿਟਰ),
						'other' => q({0} ਹੈਕਟੋਲਿਟਰ),
					},
					'hectopascal' => {
						'name' => q(ਹੈਕਟੋਪਾਸਕਲ),
						'one' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
						'other' => q({0} ਹੈਕਟੋਪਾਸਕਲ),
					},
					'hertz' => {
						'name' => q(ਹਰਟਜ਼),
						'one' => q({0} ਹਰਟਜ਼),
						'other' => q({0} ਹਰਟਜ਼),
					},
					'horsepower' => {
						'name' => q(ਹੌਰਸਪਾਵਰ),
						'one' => q({0} ਹੌਰਸਪਾਵਰ),
						'other' => q({0} ਹੌਰਸਪਾਵਰ),
					},
					'hour' => {
						'name' => q(ਘੰਟੇ),
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
						'per' => q({0} ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'inch' => {
						'name' => q(ਇੰਚ),
						'one' => q({0} ਇੰਚ),
						'other' => q({0} ਇੰਚ),
						'per' => q({0} ਪ੍ਰਤੀ ਇੰਚ),
					},
					'inch-hg' => {
						'name' => q(ਇੰਚ ਪਾਰਾ),
						'one' => q({0} ਇੰਚ ਪਾਰਾ),
						'other' => q({0} ਇੰਚ ਪਾਰਾ),
					},
					'joule' => {
						'name' => q(ਜੂਲ),
						'one' => q({0} ਜੂਲ),
						'other' => q({0} ਜੂਲ),
					},
					'karat' => {
						'name' => q(ਕੇਰਟ),
						'one' => q({0} ਕੇਰਟ),
						'other' => q({0} ਕੇਰਟ),
					},
					'kelvin' => {
						'name' => q(ਕੈਲਵਿਨ),
						'one' => q({0} ਕੈਲਵਿਨ),
						'other' => q({0} ਕੈਲਵਿਨ),
					},
					'kilobit' => {
						'name' => q(ਕਿਲੋਬਿਟ),
						'one' => q({0} ਕਿਲੋਬਿਟ),
						'other' => q({0} ਕਿਲੋਬਿਟ),
					},
					'kilobyte' => {
						'name' => q(ਕਿਲੋਬਾਇਟ),
						'one' => q({0} ਕਿਲੋਬਾਇਟ),
						'other' => q({0} ਕਿਲੋਬਾਇਟ),
					},
					'kilocalorie' => {
						'name' => q(ਕਿਲੋਕੈਲੋਰੀਆਂ),
						'one' => q({0} ਕਿਲੋਕੈਲੋਰੀ),
						'other' => q({0} ਕਿਲੋਕੈਲੋਰੀਆਂ),
					},
					'kilogram' => {
						'name' => q(ਕਿਲੋਗ੍ਰਾਮ),
						'one' => q({0} ਕਿਲੋਗ੍ਰਾਮ),
						'other' => q({0} ਕਿਲੋਗ੍ਰਾਮ),
						'per' => q({0} ਪ੍ਰਤੀ ਕਿਲੋਗ੍ਰਾਮ),
					},
					'kilohertz' => {
						'name' => q(ਕਿਲੋਹਰਟਜ਼),
						'one' => q({0} ਕਿਲੋਹਰਟਜ਼),
						'other' => q({0} ਕਿਲੋਹਰਟਜ਼),
					},
					'kilojoule' => {
						'name' => q(ਕਿਲੋਜੂਲ),
						'one' => q({0} ਕਿਲੋਜੂਲ),
						'other' => q({0} ਕਿਲੋਜੂਲ),
					},
					'kilometer' => {
						'name' => q(ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਕਿਲੋਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
					},
					'kilometer-per-hour' => {
						'name' => q(ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
						'one' => q({0} ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
						'other' => q({0} ਕਿਲੋਮੀਟਰ ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'kilowatt' => {
						'name' => q(ਕਿਲੋਵਾਟ),
						'one' => q({0} ਕਿਲੋਵਾਟ),
						'other' => q({0} ਕਿਲੋਵਾਟ),
					},
					'kilowatt-hour' => {
						'name' => q(ਕਿਲੋਵਾਟ-ਘੰਟੇ),
						'one' => q({0} ਕਿਲੋਵਾਟ ਘੰਟਾ),
						'other' => q({0} ਕਿਲੋਵਾਟ ਘੰਟੇ),
					},
					'knot' => {
						'name' => q(ਨੌਟ),
						'one' => q({0} ਨੌਟ),
						'other' => q({0} ਨੌਟ),
					},
					'light-year' => {
						'name' => q(ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'one' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'other' => q({0} ਪ੍ਰਕਾਸ਼ ਸਾਲ),
					},
					'liter' => {
						'name' => q(ਲਿਟਰ),
						'one' => q({0} ਲਿਟਰ),
						'other' => q({0} ਲਿਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਲਿਟਰ),
					},
					'liter-per-100kilometers' => {
						'name' => q(ਲਿਟਰ ਪ੍ਰਤੀ 100 ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ 100 ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ 100 ਕਿਲੋਮੀਟਰ),
					},
					'liter-per-kilometer' => {
						'name' => q(ਲਿਟਰ ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਲਿਟਰ ਪ੍ਰਤੀ ਕਿਲੋਮੀਟਰ),
					},
					'lux' => {
						'name' => q(ਲਕਸ),
						'one' => q({0} ਲਕਸ),
						'other' => q({0} ਲਕਸ),
					},
					'megabit' => {
						'name' => q(ਮੈਗਾਬਿਟ),
						'one' => q({0} ਮੈਗਾਬਿਟ),
						'other' => q({0} ਮੈਗਾਬਿਟ),
					},
					'megabyte' => {
						'name' => q(ਮੈਗਾਬਾਇਟ),
						'one' => q({0} ਮੈਗਾਬਾਇਟ),
						'other' => q({0} ਮੈਗਾਬਾਇਟ),
					},
					'megahertz' => {
						'name' => q(ਮੈਗਾਹਰਟਜ਼),
						'one' => q({0} ਮੈਗਾਹਰਟਜ਼),
						'other' => q({0} ਮੈਗਾਹਰਟਜ਼),
					},
					'megaliter' => {
						'name' => q(ਮੈਗਾਲਿਟਰ),
						'one' => q({0} ਮੈਗਾਲਿਟਰ),
						'other' => q({0} ਮੈਗਾਲਿਟਰ),
					},
					'megawatt' => {
						'name' => q(ਮੈਗਾਵਾਟ),
						'one' => q({0} ਮੈਗਾਵਾਟ),
						'other' => q({0} ਮੈਗਾਵਾਟ),
					},
					'meter' => {
						'name' => q(ਮੀਟਰ),
						'one' => q({0} ਮੀਟਰ),
						'other' => q({0} ਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਮੀਟਰ),
					},
					'meter-per-second' => {
						'name' => q(ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
						'one' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
						'other' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਸਕਿੰਟ),
					},
					'meter-per-second-squared' => {
						'name' => q(ਮੀਟਰ ਪ੍ਰਤੀ ਵਰਗ ਸਕਿੰਟ),
						'one' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਵਰਗ ਸਕਿੰਟ),
						'other' => q({0} ਮੀਟਰ ਪ੍ਰਤੀ ਵਰਗ ਸਕਿੰਟ),
					},
					'metric-ton' => {
						'name' => q(ਮੀਟਰਿਕ ਟਨ),
						'one' => q({0} ਮੀਟਰਿਕ ਟਨ),
						'other' => q({0} ਮੀਟਰਿਕ ਟਨ),
					},
					'microgram' => {
						'name' => q(ਮਾਈਕਰੋਗ੍ਰਾਮ),
						'one' => q({0} ਮਾਈਕਰੋਗ੍ਰਾਮ),
						'other' => q({0} ਮਾਈਕਰੋਗ੍ਰਾਮ),
					},
					'micrometer' => {
						'name' => q(ਮਾਈਕਰੋਮੀਟਰ),
						'one' => q({0} ਮਾਈਕਰੋਮੀਟਰ),
						'other' => q({0} ਮਾਈਕਰੋਮੀਟਰ),
					},
					'microsecond' => {
						'name' => q(ਮਾਈਕਰੋਸਕਿੰਟ),
						'one' => q({0} ਮਾਈਕਰੋਸਕਿੰਟ),
						'other' => q({0} ਮਾਈਕਰੋਸਕਿੰਟ),
					},
					'mile' => {
						'name' => q(ਮੀਲ),
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-gallon' => {
						'name' => q(ਮੀਲ ਪ੍ਰਤੀ ਗੈਲਨ),
						'one' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਗੈਲਨ),
						'other' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਗੈਲਨ),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ਮੀਲ ਪ੍ਰਤੀ ਇੰਪ. ਗੈਲਨ),
						'one' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਇੰਪ. ਗੈਲਨ),
						'other' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਇੰਪ. ਗੈਲਨ),
					},
					'mile-per-hour' => {
						'name' => q(ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
						'one' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
						'other' => q({0} ਮੀਲ ਪ੍ਰਤੀ ਘੰਟਾ),
					},
					'mile-scandinavian' => {
						'name' => q(ਮੀਲ-ਸਕੈਂਡਿਨੇਵਿਆਈ),
						'one' => q({0} ਮੀਲ-ਸਕੈਂਡਿਨੇਵਿਆਈ),
						'other' => q({0} ਮੀਲ-ਸਕੈਂਡਿਨੇਵਿਆਈ),
					},
					'milliampere' => {
						'name' => q(ਮਿਲੀਐਮਪੀਅਰ),
						'one' => q({0} ਮਿਲੀਐਮਪੀਅਰ),
						'other' => q({0} ਮਿਲੀਐਮਪੀਅਰ),
					},
					'millibar' => {
						'name' => q(ਮਿਲੀਬਾਰ),
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'milligram' => {
						'name' => q(ਮਿਲੀਗ੍ਰਾਮ),
						'one' => q({0} ਮਿਲੀਗ੍ਰਾਮ),
						'other' => q({0} ਮਿਲੀਗ੍ਰਾਮ),
					},
					'milligram-per-deciliter' => {
						'name' => q(ਮਿਲੀਗ੍ਰਾਮ ਪ੍ਰਤੀ ਡੈਸੀਲਿਟਰ),
						'one' => q({0} ਮਿਲੀਗ੍ਰਾਮ ਪ੍ਰਤੀ ਡੈਸੀਲਿਟਰ),
						'other' => q({0} ਮਿਲੀਗ੍ਰਾਮ ਪ੍ਰਤੀ ਡੈਸੀਲਿਟਰ),
					},
					'milliliter' => {
						'name' => q(ਮਿਲੀਲਿਟਰ),
						'one' => q({0} ਮਿਲੀਲਿਟਰ),
						'other' => q({0} ਮਿਲੀਲਿਟਰ),
					},
					'millimeter' => {
						'name' => q(ਮਿਲੀਮੀਟਰ),
						'one' => q({0} ਮਿਲੀਮੀਟਰ),
						'other' => q({0} ਮਿਲੀਮੀਟਰ),
					},
					'millimeter-of-mercury' => {
						'name' => q(ਮਿਲੀਮੀਟਰ ਪਾਰਾ),
						'one' => q({0} ਮਿਲੀਮੀਟਰ ਪਾਰਾ),
						'other' => q({0} ਮਿਲੀਮੀਟਰ ਪਾਰਾ),
					},
					'millimole-per-liter' => {
						'name' => q(ਮਿਲੀਮੋਲ ਪ੍ਰਤੀ ਲਿਟਰ),
						'one' => q({0} ਮਿਲੀਮੋਲ ਪ੍ਰਤੀ ਲਿਟਰ),
						'other' => q({0} ਮਿਲੀਮੋਲ ਪ੍ਰਤੀ ਲਿਟਰ),
					},
					'millisecond' => {
						'name' => q(ਮਿਲੀਸਕਿੰਟ),
						'one' => q({0} ਮਿਲੀਸਕਿੰਟ),
						'other' => q({0} ਮਿਲੀਸਕਿੰਟ),
					},
					'milliwatt' => {
						'name' => q(ਮਿਲੀਵਾਟ),
						'one' => q({0} ਮਿਲੀਵਾਟ),
						'other' => q({0} ਮਿਲੀਵਾਟ),
					},
					'minute' => {
						'name' => q(ਮਿੰਟ),
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
						'per' => q({0} ਪ੍ਰਤੀ ਮਿੰਟ),
					},
					'month' => {
						'name' => q(ਮਹੀਨੇ),
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
						'per' => q({0} ਪ੍ਰਤੀ ਮਹੀਨਾ),
					},
					'nanometer' => {
						'name' => q(ਨੈਨੋਮੀਟਰ),
						'one' => q({0} ਨੈਨੋਮੀਟਰ),
						'other' => q({0} ਨੈਨੋਮੀਟਰ),
					},
					'nanosecond' => {
						'name' => q(ਨੈਨੋਸਕਿੰਟ),
						'one' => q({0} ਨੈਨੋਸਕਿੰਟ),
						'other' => q({0} ਨੈਨੋਸਕਿੰਟ),
					},
					'nautical-mile' => {
						'name' => q(ਨੋਟੀਕਲ ਮੀਲ),
						'one' => q({0} ਨੋਟੀਕਲ ਮੀਲ),
						'other' => q({0} ਨੋਟੀਕਲ ਮੀਲ),
					},
					'ohm' => {
						'name' => q(ਓਹਮ),
						'one' => q({0} ਓਹਮ),
						'other' => q({0} ਓਹਮ),
					},
					'ounce' => {
						'name' => q(ਔਂਸ),
						'one' => q({0} ਔਂਸ),
						'other' => q({0} ਔਂਸ),
						'per' => q({0} ਪ੍ਰਤੀ ਔਂਸ),
					},
					'ounce-troy' => {
						'name' => q(ਟਰੌਏ ਔਂਸ),
						'one' => q({0} ਟਰੌਏ ਔਂਸ),
						'other' => q({0} ਟਰੌਏ ਔਂਸ),
					},
					'parsec' => {
						'name' => q(ਪਾਸੈੱਕ),
						'one' => q({0} ਪਾਸੈੱਕ),
						'other' => q({0} ਪਾਸੈੱਕ),
					},
					'part-per-million' => {
						'name' => q(ਹਿੱਸੇ ਪ੍ਰਤੀ ਮਿਲੀਅਨ),
						'one' => q({0} ਹਿੱਸਾ ਪ੍ਰਤੀ ਮਿਲੀਅਨ),
						'other' => q({0} ਹਿੱਸੇ ਪ੍ਰਤੀ ਮਿਲੀਅਨ),
					},
					'per' => {
						'1' => q({0} ਪ੍ਰਤੀ {1}),
					},
					'percent' => {
						'name' => q(ਪ੍ਰਤੀਸ਼ਤ),
						'one' => q({0} ਪ੍ਰਤੀਸ਼ਤ),
						'other' => q({0} ਪ੍ਰਤੀਸ਼ਤ),
					},
					'permille' => {
						'name' => q(ਪਰਮਾਈਲ),
						'one' => q({0} ਪਰਮਾਈਲ),
						'other' => q({0} ਪਰਮਾਈਲ),
					},
					'petabyte' => {
						'name' => q(ਪੈਟਾਬਾਇਟ),
						'one' => q({0} ਪੈਟਾਬਾਇਟ),
						'other' => q({0} ਪੈਟਾਬਾਇਟ),
					},
					'picometer' => {
						'name' => q(ਪਿਕੋਮੀਟਰ),
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pint' => {
						'name' => q(ਪਿੰਟ),
						'one' => q({0} ਪਿੰਟ),
						'other' => q({0} ਪਿੰਟ),
					},
					'pint-metric' => {
						'name' => q(ਮੀਟਰਿਕ ਪਿੰਟ),
						'one' => q({0} ਮੀਟਰਿਕ ਪਿੰਟ),
						'other' => q({0} ਮੀਟਰਿਕ ਪਿੰਟ),
					},
					'point' => {
						'name' => q(ਪੁਆਇੰਟ),
						'one' => q({0} ਪੁਆਇੰਟ),
						'other' => q({0} ਪੁਆਇੰਟ),
					},
					'pound' => {
						'name' => q(ਪੌਂਡ),
						'one' => q({0} ਪੌਂਡ),
						'other' => q({0} ਪੌਂਡ),
						'per' => q({0} ਪ੍ਰਤੀ ਪੌਂਡ),
					},
					'pound-per-square-inch' => {
						'name' => q(ਪੌਂਡ ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
						'one' => q({0} ਪੌਂਡ ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
						'other' => q({0} ਪੌਂਡ ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
					},
					'quart' => {
						'name' => q(ਕੁਆਟ),
						'one' => q({0} ਕੁਆਟ),
						'other' => q({0} ਕੁਆਟ),
					},
					'radian' => {
						'name' => q(ਰੇਡੀਅਨ),
						'one' => q({0} ਰੇਡੀਅਨ),
						'other' => q({0} ਰੇਡੀਅਨ),
					},
					'revolution' => {
						'name' => q(ਪਰਿਕਰਮਾ),
						'one' => q({0} ਪਰਿਕਰਮਾ),
						'other' => q({0} ਪਰਿਕਰਮਾ),
					},
					'second' => {
						'name' => q(ਸਕਿੰਟ),
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
						'per' => q({0} ਪ੍ਰਤੀ ਸਕਿੰਟ),
					},
					'square-centimeter' => {
						'name' => q(ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
						'one' => q({0} ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਸੈਂਟੀਮੀਟਰ),
					},
					'square-foot' => {
						'name' => q(ਵਰਗ ਫੁੱਟ),
						'one' => q({0} ਵਰਗ ਫੁੱਟ),
						'other' => q({0} ਵਰਗ ਫੁੱਟ),
					},
					'square-inch' => {
						'name' => q(ਵਰਗ ਇੰਚ),
						'one' => q({0} ਵਰਗ ਇੰਚ),
						'other' => q({0} ਵਰਗ ਇੰਚ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਇੰਚ),
					},
					'square-kilometer' => {
						'name' => q(ਵਰਗ ਕਿਲੋਮੀਟਰ),
						'one' => q({0} ਵਰਗ ਕਿਲੋਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਕਿਲੋਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਕਿਲੋਮੀਟਰ),
					},
					'square-meter' => {
						'name' => q(ਵਰਗ ਮੀਟਰ),
						'one' => q({0} ਵਰਗ ਮੀਟਰ),
						'other' => q({0} ਵਰਗ ਮੀਟਰ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਮੀਟਰ),
					},
					'square-mile' => {
						'name' => q(ਵਰਗ ਮੀਲ),
						'one' => q({0} ਵਰਗ ਮੀਲ),
						'other' => q({0} ਵਰਗ ਮੀਲ),
						'per' => q({0} ਪ੍ਰਤੀ ਵਰਗ ਮੀਲ),
					},
					'square-yard' => {
						'name' => q(ਵਰਗ ਗਜ਼),
						'one' => q({0} ਵਰਗ ਗਜ਼),
						'other' => q({0} ਵਰਗ ਗਜ਼),
					},
					'stone' => {
						'name' => q(ਸਟੋਨ),
						'one' => q({0} ਸਟੋਨ),
						'other' => q({0} ਸਟੋਨ),
					},
					'tablespoon' => {
						'name' => q(ਟੇਬਲ ਸਪੂਨ),
						'one' => q({0} ਟੇਬਲ ਸਪੂਨ),
						'other' => q({0} ਟੇਬਲ ਸਪੂਨ),
					},
					'teaspoon' => {
						'name' => q(ਟੀ ਸਪੂਨ),
						'one' => q({0} ਟੀ ਸਪੂਨ),
						'other' => q({0} ਟੀ ਸਪੂਨ),
					},
					'terabit' => {
						'name' => q(ਟੇਰਾਬਿਟ),
						'one' => q({0} ਟੇਰਾਬਿਟ),
						'other' => q({0} ਟੇਰਾਬਿਟ),
					},
					'terabyte' => {
						'name' => q(ਟੈਰਾਬਾਇਟ),
						'one' => q({0} ਟੈਰਾਬਾਇਟ),
						'other' => q({0} ਟੈਰਾਬਾਇਟ),
					},
					'ton' => {
						'name' => q(ਟਨ),
						'one' => q({0} ਟਨ),
						'other' => q({0} ਟਨ),
					},
					'volt' => {
						'name' => q(ਵੋਲਟ),
						'one' => q({0} ਵੋਲਟ),
						'other' => q({0} ਵੋਲਟ),
					},
					'watt' => {
						'name' => q(ਵਾਟ),
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'name' => q(ਹਫ਼ਤੇ),
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
						'per' => q({0} ਪ੍ਰਤੀ ਹਫ਼ਤਾ),
					},
					'yard' => {
						'name' => q(ਗਜ਼),
						'one' => q({0} ਗਜ਼),
						'other' => q({0} ਗਜ਼),
					},
					'year' => {
						'name' => q(ਸਾਲ),
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
						'per' => q({0} ਪ੍ਰਤੀ ਸਾਲ),
					},
				},
				'narrow' => {
					'' => {
						'name' => q(ਦਿਸ਼ਾ),
					},
					'acre' => {
						'one' => q({0}ਏਕੜ),
						'other' => q({0}ਏਕੜ),
					},
					'acre-foot' => {
						'one' => q({0}ਏਕੜ ਫੁੱਟ),
						'other' => q({0}ਏਕੜ ਫੁੱਟ),
					},
					'ampere' => {
						'one' => q({0}A),
						'other' => q({0}A),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'astronomical-unit' => {
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'bit' => {
						'one' => q({0}ਬਿਟ),
						'other' => q({0}ਬਿਟ),
					},
					'bushel' => {
						'name' => q(ਬੁਸ਼ਲ),
						'one' => q({0}ਬੁਸ਼ਲ),
						'other' => q({0}ਬੁਸ਼ਲ),
					},
					'byte' => {
						'one' => q({0}ਬਾਇਟ),
						'other' => q({0}ਬਾਇਟ),
					},
					'calorie' => {
						'one' => q({0} ਕੈਲੋਰੀਆਂ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'one' => q({0} ਸੈਂ.ਲਿ.),
						'other' => q({0} ਸੈਂ.ਲਿ.),
					},
					'centimeter' => {
						'name' => q(ਸੈਂ.ਮੀ.),
						'one' => q({0}ਸੈਂ.ਮੀ.),
						'other' => q({0}ਸੈਂ.ਮੀ.),
					},
					'coordinate' => {
						'east' => q({0}ਪੂ),
						'north' => q({0}ਉ),
						'south' => q({0}ਦੱ),
						'west' => q({0}ਪੱ),
					},
					'cubic-centimeter' => {
						'one' => q({0}ਸੈਮੀ³),
						'other' => q({0}ਸੈਮੀ³),
					},
					'cubic-foot' => {
						'one' => q({0}ਫੁੱਟ³),
						'other' => q({0}ਫੁੱਟ³),
					},
					'cubic-inch' => {
						'one' => q({0}ਇੰਚ³),
						'other' => q({0}ਇੰਚ³),
					},
					'cubic-kilometer' => {
						'one' => q({0}ਕਿਮੀ³),
						'other' => q({0}ਕਿਮੀ³),
					},
					'cubic-meter' => {
						'one' => q({0}ਮੀ³),
						'other' => q({0}ਮੀ³),
					},
					'cubic-mile' => {
						'one' => q({0}ਮੀਲ³),
						'other' => q({0}ਮੀਲ³),
					},
					'cubic-yard' => {
						'one' => q({0}ਗਜ਼³),
						'other' => q({0}ਗਜ਼³),
					},
					'cup' => {
						'one' => q({0}ਕੱਪ),
						'other' => q({0}ਕੱਪ),
					},
					'day' => {
						'name' => q(ਦਿਨ),
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
						'per' => q({0}/ਦਿਨ),
					},
					'deciliter' => {
						'one' => q({0} ਡੈ.ਲਿ.),
						'other' => q({0} ਡੈ.ਲਿ.),
					},
					'decimeter' => {
						'name' => q(ਡੈ.ਮੀ.),
						'one' => q({0} ਡੈ.ਮੀ.),
						'other' => q({0} ਡੈ.ਮੀ.),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fathom' => {
						'name' => q(ਫ਼ੈਦਮ),
						'one' => q({0} ਫ਼ੈਦਮ),
						'other' => q({0} ਫ਼ੈਦਮ),
					},
					'fluid-ounce' => {
						'one' => q({0} ਤ. ਔਂਸ),
						'other' => q({0} ਤ. ਔਂਸ),
					},
					'foodcalorie' => {
						'one' => q({0} ਕੈਲੋਰੀਆਂ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'foot' => {
						'name' => q(ਫੁੱਟ),
						'one' => q({0}'),
						'other' => q({0}'),
						'per' => q({0}/ਫੁੱਟ),
					},
					'furlong' => {
						'name' => q(ਫਰਲਾਂਗ),
						'one' => q({0} ਫਰਲਾਂਗ),
						'other' => q({0} ਫਰਲਾਂਗ),
					},
					'g-force' => {
						'one' => q({0}G),
						'other' => q({0}Gs),
					},
					'gallon' => {
						'one' => q({0}ਗੈਲਨ),
						'other' => q({0}ਗੈਲਨ),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'one' => q({0}GHz),
						'other' => q({0}GHz),
					},
					'gigawatt' => {
						'one' => q({0} ਗੀ.ਵਾਟ),
						'other' => q({0} ਗੀ.ਵਾਟ),
					},
					'gram' => {
						'name' => q(ਗ੍ਰਾਮ),
						'one' => q({0} ਗ੍ਰਾ.),
						'other' => q({0} ਗ੍ਰਾ.),
						'per' => q({0}/ਗ੍ਰਾ.),
					},
					'hectare' => {
						'one' => q({0}ਹੈਕ),
						'other' => q({0}ਹੈਕ),
					},
					'hectoliter' => {
						'one' => q({0} ਹੈ.ਲਿ.),
						'other' => q({0} ਹੈ.ਲਿ.),
					},
					'hectopascal' => {
						'name' => q(ਹੈ.ਪਾ.),
						'one' => q({0} ਹੈ.ਪਾ.),
						'other' => q({0} ਹੈ.ਪਾ.),
					},
					'hertz' => {
						'one' => q({0}Hz),
						'other' => q({0}Hz),
					},
					'horsepower' => {
						'one' => q({0}hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(ਘੰਟਾ),
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
						'per' => q({0}/ਘੰ),
					},
					'inch' => {
						'name' => q(ਇੰਚ),
						'one' => q({0}"),
						'other' => q({0}"),
						'per' => q({0}/ਇੰਚ),
					},
					'inch-hg' => {
						'name' => q(ਇੰਚ ਪਾਰਾ),
						'one' => q({0}" ਪਾਰਾ),
						'other' => q({0}" ਪਾਰਾ),
					},
					'joule' => {
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'one' => q({0} ਕੇਰਟ),
						'other' => q({0} ਕੇਰਟ),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0}°K),
						'other' => q({0}°K),
					},
					'kilobit' => {
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'one' => q({0}ਕਿ.ਕੈਲੋਰੀਆਂ),
						'other' => q({0}ਕਿ.ਕੈਲੋਰੀਆਂ),
					},
					'kilogram' => {
						'name' => q(ਕਿ ਗ੍ਰਾ),
						'one' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'per' => q({0}/ਕਿ.ਗ੍ਰਾ.),
					},
					'kilohertz' => {
						'one' => q({0}kHz),
						'other' => q({0}kHz),
					},
					'kilojoule' => {
						'one' => q({0} ਕਿ.ਜੂਲ),
						'other' => q({0} ਕਿ.ਜੂਲ),
					},
					'kilometer' => {
						'name' => q(ਕਿ.ਮੀ.),
						'one' => q({0} ਕਿ.ਮੀ.),
						'other' => q({0} ਕਿ.ਮੀ.),
						'per' => q({0}/ਕਿ.ਮੀ.),
					},
					'kilometer-per-hour' => {
						'name' => q(ਕਿ.ਮੀ./ਘੰਟਾ),
						'one' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
					},
					'kilowatt' => {
						'one' => q({0} ਕਿ. ਵਾਟ),
						'other' => q({0} ਕਿ. ਵਾਟ),
					},
					'kilowatt-hour' => {
						'one' => q({0} ਕਿ.ਵਾ.ਘੰ.),
						'other' => q({0} ਕਿ.ਵਾ.ਘੰ.),
					},
					'light-year' => {
						'one' => q({0} ਪ੍ਰ.ਸ.),
						'other' => q({0} ਪ੍ਰ.ਸ.),
					},
					'liter' => {
						'name' => q(ਲਿਟਰ),
						'one' => q({0} ਲਿ.),
						'other' => q({0} ਲਿ.),
					},
					'liter-per-100kilometers' => {
						'name' => q(ਲਿ./100ਕਿ.ਮੀ.),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'one' => q({0}ਲਿ./ਕਿ.ਮੀ.),
						'other' => q({0}ਲਿ./ਕਿ.ਮੀ.),
					},
					'lux' => {
						'one' => q({0} ਲਕਸ),
						'other' => q({0} ਲਕਸ),
					},
					'megabit' => {
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'one' => q({0}MHz),
						'other' => q({0}MHz),
					},
					'megaliter' => {
						'one' => q({0} ਮੈ.ਲਿ.),
						'other' => q({0} ਮੈ.ਲਿ.),
					},
					'megawatt' => {
						'one' => q({0} ਮੈ.ਵਾਟ),
						'other' => q({0} ਮੈ.ਵਾਟ),
					},
					'meter' => {
						'name' => q(ਮੀਟਰ),
						'one' => q({0} ਮੀ.),
						'other' => q({0} ਮੀ.),
						'per' => q({0}/ਮੀ.),
					},
					'meter-per-second' => {
						'name' => q(ਮੀਟਰ/ਸਕਿੰਟ),
						'one' => q({0}ਮੀ/ਸ),
						'other' => q({0}ਮੀ/ਸ),
					},
					'meter-per-second-squared' => {
						'one' => q({0}ਮੀ/ਸ²),
						'other' => q({0}ਮੀ/ਸ²),
					},
					'micrometer' => {
						'name' => q(ਮਾਇਕ੍ਰੋ. ਮੀ.),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(ਮੀਲ),
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-gallon' => {
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
					},
					'mile-per-hour' => {
						'name' => q(ਮੀਲ/ਘੰਟਾ),
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
					},
					'milliampere' => {
						'one' => q({0}mA),
						'other' => q({0}mA),
					},
					'millibar' => {
						'name' => q(ਮਿਲੀਬਾਰ),
						'one' => q({0} ਮਿ.ਬਾ.),
						'other' => q({0} ਮਿ.ਬਾ.),
					},
					'milliliter' => {
						'one' => q({0} ਮਿ.ਲਿ.),
						'other' => q({0} ਮਿ.ਲਿ.),
					},
					'millimeter' => {
						'name' => q(ਮਿ.ਮੀ.),
						'one' => q({0} ਮਿ.ਮੀ.),
						'other' => q({0} ਮਿ.ਮੀ.),
					},
					'millimeter-of-mercury' => {
						'name' => q(ਮਿ.ਮੀ. ਪਾਰਾ),
						'one' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
						'other' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
					},
					'millisecond' => {
						'name' => q(ਮਿਲੀਸਕਿੰਟ),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'one' => q({0} ਮਿ.ਵਾਟ),
						'other' => q({0} ਮਿ.ਵਾਟ),
					},
					'minute' => {
						'name' => q(ਮਿੰਟ),
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
						'per' => q({0}/ਮਿੰਟ),
					},
					'month' => {
						'name' => q(ਮਹੀਨਾ),
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
					},
					'nanometer' => {
						'name' => q(ਨੈ.ਮੀ.),
						'one' => q({0} ਨੈ.ਮੀ.),
						'other' => q({0} ਨੈ.ਮੀ.),
					},
					'nanosecond' => {
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'one' => q({0} ਨੋ.ਮੀਲ),
						'other' => q({0} ਨੋ.ਮੀਲ),
					},
					'ohm' => {
						'one' => q({0}Ω),
						'other' => q({0}Ω),
					},
					'ounce' => {
						'name' => q(ਔਂਸ),
						'one' => q({0} ਔਂਸ),
						'other' => q({0} ਔਂਸ),
						'per' => q({0}/ਔਂਸ),
					},
					'ounce-troy' => {
						'one' => q({0} ਔਂਸ ਟ.),
						'other' => q({0} ਔਂਸ ਟ.),
					},
					'parsec' => {
						'name' => q(ਪਾਸੈੱਕ),
						'one' => q({0} ਪਾਸੈੱਕ),
						'other' => q({0} ਪਾਸੈੱਕ),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(ਪ੍ਰਤੀਸ਼ਤ),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'picometer' => {
						'name' => q(ਪਿ.ਮੀ.),
						'one' => q({0} ਪਿ.ਮੀ.),
						'other' => q({0} ਪਿ.ਮੀ.),
					},
					'pint' => {
						'one' => q({0}ਪਿੰਟ),
						'other' => q({0}ਪਿੰਟ),
					},
					'pound' => {
						'name' => q(ਪੌਂਡ),
						'one' => q({0}#),
						'other' => q({0}#),
						'per' => q({0}/ਪੌਂਡ),
					},
					'pound-per-square-inch' => {
						'name' => q(ਪੌਂ.ਵ.ਇੰਚ),
						'one' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
						'other' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
					},
					'quart' => {
						'one' => q({0}ਕੁਆਟ),
						'other' => q({0}ਕੁਆਟ),
					},
					'radian' => {
						'one' => q({0} ਰੇਡੀ.),
						'other' => q({0} ਰੇਡੀ.),
					},
					'second' => {
						'name' => q(ਸਕਿੰਟ),
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
						'per' => q({0}/ਸਕਿੰ),
					},
					'square-centimeter' => {
						'one' => q({0}ਸੈਮੀ²),
						'other' => q({0}ਸੈਮੀ²),
					},
					'square-foot' => {
						'one' => q({0}ਫੁੱਟ²),
						'other' => q({0}ਫੁੱਟ²),
					},
					'square-inch' => {
						'one' => q({0}ਇੰਚ²),
						'other' => q({0}ਇੰਚ²),
					},
					'square-kilometer' => {
						'one' => q({0} ਕਿਮੀ²),
						'other' => q({0} ਕਿਮੀ²),
					},
					'square-meter' => {
						'one' => q({0} ਮੀ²),
						'other' => q({0} ਮੀ²),
					},
					'square-mile' => {
						'one' => q({0}ਮੀਲ²),
						'other' => q({0}ਮੀਲ²),
					},
					'square-yard' => {
						'one' => q({0} ਗਜ਼²),
						'other' => q({0} ਗਜ਼²),
					},
					'stone' => {
						'name' => q(ਸਟੋਨ),
						'one' => q({0}ਸਟੋਨ),
						'other' => q({0}ਸਟੋਨ),
					},
					'terabit' => {
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'one' => q({0}ਟਨ),
						'other' => q({0}ਟਨ),
					},
					'volt' => {
						'one' => q({0}V),
						'other' => q({0}V),
					},
					'watt' => {
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'name' => q(ਹਫ਼ਤਾ),
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
					},
					'yard' => {
						'name' => q(ਗਜ਼),
						'one' => q({0} ਗਜ਼),
						'other' => q({0} ਗਜ਼),
					},
					'year' => {
						'name' => q(ਸਾਲ),
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
					},
				},
				'short' => {
					'' => {
						'name' => q(ਦਿਸ਼ਾ),
					},
					'acre' => {
						'name' => q(ਏਕੜ),
						'one' => q({0} ਏਕੜ),
						'other' => q({0} ਏਕੜ),
					},
					'acre-foot' => {
						'name' => q(ਏਕੜ ਫੁੱਟ),
						'one' => q({0} ਏਕੜ ਫੁੱਟ),
						'other' => q({0} ਏਕੜ ਫੁੱਟ),
					},
					'ampere' => {
						'name' => q(ਐਮਪੀਅਰ),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(ਚਾਪ-ਮਿੰਟ),
						'one' => q({0} ਚਾਪਮਿੰਟ),
						'other' => q({0} ਚਾਪ-ਮਿੰਟ),
					},
					'arc-second' => {
						'name' => q(ਚਾਪ-ਸਕਿੰਟ),
						'one' => q({0} ਚਾਪ-ਸਕਿੰਟ),
						'other' => q({0} ਚਾਪ-ਸਕਿੰਟ),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'atmosphere' => {
						'name' => q(ਵਾ. ਮੰ.),
						'one' => q({0} ਵਾ. ਮੰ.),
						'other' => q({0} ਵਾ. ਮੰ.),
					},
					'bit' => {
						'name' => q(ਬਿਟ),
						'one' => q({0} ਬਿਟ),
						'other' => q({0} ਬਿਟ),
					},
					'bushel' => {
						'name' => q(ਬੁਸ਼ਲ),
						'one' => q({0} ਬੁਸ਼ਲ),
						'other' => q({0} ਬੁਸ਼ਲ),
					},
					'byte' => {
						'name' => q(ਬਾਇਟ),
						'one' => q({0} ਬਾਇਟ),
						'other' => q({0} ਬਾਇਟ),
					},
					'calorie' => {
						'name' => q(ਕੈਲੋਰੀ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'carat' => {
						'name' => q(ਕੈਰਟ),
						'one' => q({0} ਕੈਰਟ),
						'other' => q({0} ਕੈਰਟ),
					},
					'celsius' => {
						'name' => q(ਦਰਜਾ ਸੈਲਸੀਅਸ),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(ਸੈਂ.ਲਿ.),
						'one' => q({0} ਸੈਂ.ਲਿ.),
						'other' => q({0} ਸੈਂ.ਲਿ.),
					},
					'centimeter' => {
						'name' => q(ਸੈਂ.ਮੀ.),
						'one' => q({0} ਸੈਂ.ਮੀ.),
						'other' => q({0} ਸੈਂ.ਮੀ.),
						'per' => q({0}/ਸੈਂ.ਮੀ.),
					},
					'century' => {
						'name' => q(ਸਦੀ),
						'one' => q({0} ਸਦੀ),
						'other' => q({0} ਸਦੀ),
					},
					'coordinate' => {
						'east' => q({0}ਪੂ),
						'north' => q({0}ਉ),
						'south' => q({0}ਦੱ),
						'west' => q({0}ਪੱ),
					},
					'cubic-centimeter' => {
						'name' => q(ਸੈਮੀ³),
						'one' => q({0} ਸੈਮੀ³),
						'other' => q({0} ਸੈਮੀ³),
						'per' => q({0}/ਸੈਮੀ³),
					},
					'cubic-foot' => {
						'name' => q(ਫੁੱਟ³),
						'one' => q({0} ਫੁੱਟ³),
						'other' => q({0} ਫੁੱਟ³),
					},
					'cubic-inch' => {
						'name' => q(ਇੰਚ³),
						'one' => q({0} ਇੰਚ³),
						'other' => q({0} ਇੰਚ³),
					},
					'cubic-kilometer' => {
						'name' => q(ਕਿਮੀ³),
						'one' => q({0} ਕਿਮੀ³),
						'other' => q({0} ਕਿਮੀ³),
					},
					'cubic-meter' => {
						'name' => q(ਮੀ³),
						'one' => q({0} ਮੀ³),
						'other' => q({0} ਮੀ³),
						'per' => q({0}/ਮੀ³),
					},
					'cubic-mile' => {
						'name' => q(ਮੀਲ³),
						'one' => q({0} ਮੀਲ³),
						'other' => q({0} ਮੀਲ³),
					},
					'cubic-yard' => {
						'name' => q(ਗਜ਼³),
						'one' => q({0} ਗਜ਼³),
						'other' => q({0} ਗਜ਼³),
					},
					'cup' => {
						'name' => q(ਕੱਪ),
						'one' => q({0} ਕੱਪ),
						'other' => q({0} ਕੱਪ),
					},
					'cup-metric' => {
						'name' => q(ਮੀ ਕੱਪ),
						'one' => q({0} ਮੀ ਕੱਪ),
						'other' => q({0} ਮੀ ਕੱਪ),
					},
					'day' => {
						'name' => q(ਦਿਨ),
						'one' => q({0} ਦਿਨ),
						'other' => q({0} ਦਿਨ),
						'per' => q({0}/ਦਿਨ),
					},
					'deciliter' => {
						'name' => q(ਡੈ.ਲਿ.),
						'one' => q({0} ਡੈ.ਲਿ.),
						'other' => q({0} ਡੈ.ਲਿ.),
					},
					'decimeter' => {
						'name' => q(ਡੈ.ਮੀ.),
						'one' => q({0} ਡੈ.ਮੀ.),
						'other' => q({0} ਡੈ.ਮੀ.),
					},
					'degree' => {
						'name' => q(ਡਿਗਰੀ),
						'one' => q({0} ਡਿ.),
						'other' => q({0} ਡਿ.),
					},
					'fahrenheit' => {
						'name' => q(ਦਰਜਾ ਫਾਰੇਨਹਾਈਟ),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fathom' => {
						'name' => q(ਫ਼ੈਦਮ),
						'one' => q({0} ਫ਼ੈਦਮ),
						'other' => q({0} ਫ਼ੈਦਮ),
					},
					'fluid-ounce' => {
						'name' => q(ਤ. ਔਂਸ),
						'one' => q({0} ਤ. ਔਂਸ),
						'other' => q({0} ਤ. ਔਂਸ),
					},
					'foodcalorie' => {
						'name' => q(ਕੈਲੋਰੀ),
						'one' => q({0} ਕੈਲੋਰੀ),
						'other' => q({0} ਕੈਲੋਰੀਆਂ),
					},
					'foot' => {
						'name' => q(ਫੁੱਟ),
						'one' => q({0} ਫੁੱਟ),
						'other' => q({0} ਫੁੱਟ),
						'per' => q({0}/ਫੁੱਟ),
					},
					'furlong' => {
						'name' => q(ਫਰਲਾਂਗ),
						'one' => q({0} ਫਰਲਾਂਗ),
						'other' => q({0} ਫਰਲਾਂਗ),
					},
					'g-force' => {
						'name' => q(ਗੁਰੂਤਾਕਰਸ਼ਣ ਬਲ),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(ਗੈਲਨ),
						'one' => q({0} ਗੈਲਨ),
						'other' => q({0} ਗੈਲਨ),
						'per' => q({0}/ਗੈਲਨ),
					},
					'gallon-imperial' => {
						'name' => q(ਇੰਪ. ਗੈਲਨ),
						'one' => q({0} ਗੈਲਨ ਇੰਪ.),
						'other' => q({0} ਗੈਲਨ ਇੰਪ.),
						'per' => q({0}/ਗੈਲਨ ਇੰਪ.),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Gbit),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(ਗੀਗਾਬਾਇਟ),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(ਗੀ.ਵਾਟ),
						'one' => q({0} ਗੀ.ਵਾਟ),
						'other' => q({0} ਗੀ.ਵਾਟ),
					},
					'gram' => {
						'name' => q(ਗ੍ਰਾਮ),
						'one' => q({0} ਗ੍ਰਾ.),
						'other' => q({0} ਗ੍ਰਾ.),
						'per' => q({0}/ਗ੍ਰਾ.),
					},
					'hectare' => {
						'name' => q(ਹੈਕਟੇਅਰ),
						'one' => q({0} ਹੈਕਟੇਅਰ),
						'other' => q({0} ਹੈਕਟੇਅਰ),
					},
					'hectoliter' => {
						'name' => q(ਹੈ.ਲਿ.),
						'one' => q({0} ਹੈ.ਲਿ.),
						'other' => q({0} ਹੈ.ਲਿ.),
					},
					'hectopascal' => {
						'name' => q(ਹੈ.ਪਾ.),
						'one' => q({0} ਹੈ.ਪਾ.),
						'other' => q({0} ਹੈ.ਪਾ.),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} ਹੌਰਸਪਾਵਰ),
						'other' => q({0} ਹੌਰਸਪਾਵਰ),
					},
					'hour' => {
						'name' => q(ਘੰਟੇ),
						'one' => q({0} ਘੰਟਾ),
						'other' => q({0} ਘੰਟੇ),
						'per' => q({0} ਪ੍ਰ.ਘੰ.),
					},
					'inch' => {
						'name' => q(ਇੰਚ),
						'one' => q({0} ਇੰਚ),
						'other' => q({0} ਇੰਚ),
						'per' => q({0}/ਇੰਚ),
					},
					'inch-hg' => {
						'name' => q(ਇੰਚ ਪਾਰਾ),
						'one' => q({0} ਇੰਚ ਪਾਰਾ),
						'other' => q({0} ਇੰਚ ਪਾਰਾ),
					},
					'joule' => {
						'name' => q(ਜੂਲ),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(ਕੇਰਟ),
						'one' => q({0} ਕੇਰਟ),
						'other' => q({0} ਕੇਰਟ),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(ਕਿਲੋਬਿਟ),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(ਕਿਲੋਬਾਇਟ),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(ਕਿ.ਕੈਲੋਰੀ),
						'one' => q({0} ਕਿ.ਕੈਲੋਰੀ),
						'other' => q({0} ਕਿ.ਕੈਲੋਰੀਆਂ),
					},
					'kilogram' => {
						'name' => q(ਕਿ.ਗ੍ਰਾ.),
						'one' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਕਿ.ਗ੍ਰਾ.),
						'per' => q({0}/ਕਿ.ਗ੍ਰਾ.),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(ਕਿਲੋਜੂਲ),
						'one' => q({0} ਕਿ.ਜੂਲ),
						'other' => q({0} ਕਿ.ਜੂਲ),
					},
					'kilometer' => {
						'name' => q(ਕਿ.ਮੀ.),
						'one' => q({0} ਕਿ.ਮੀ.),
						'other' => q({0} ਕਿ.ਮੀ.),
						'per' => q({0}/ਕਿ.ਮੀ.),
					},
					'kilometer-per-hour' => {
						'name' => q(ਕਿ.ਮੀ./ਘੰਟਾ),
						'one' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਕਿ.ਪ੍ਰ.ਘੰ.),
					},
					'kilowatt' => {
						'name' => q(ਕਿ.ਵਾਟ),
						'one' => q({0} ਕਿ. ਵਾਟ),
						'other' => q({0} ਕਿ. ਵਾਟ),
					},
					'kilowatt-hour' => {
						'name' => q(ਕਿ.ਵਾ.ਘੰ.),
						'one' => q({0} ਕਿ.ਵਾ.ਘੰ.),
						'other' => q({0} ਕਿ.ਵਾ.ਘੰ.),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(ਪ੍ਰਕਾਸ਼ ਸਾਲ),
						'one' => q({0} ਪ੍ਰ.ਸ.),
						'other' => q({0} ਪ੍ਰ.ਸ.),
					},
					'liter' => {
						'name' => q(ਲਿਟਰ),
						'one' => q({0} ਲਿ.),
						'other' => q({0} ਲਿ.),
						'per' => q({0}/ਲਿ.),
					},
					'liter-per-100kilometers' => {
						'name' => q(ਲਿ./100ਕਿ.ਮੀ.),
						'one' => q({0}ਲਿ/100 ਕਿਮੀ),
						'other' => q({0}ਲਿ/100 ਕਿਮੀ),
					},
					'liter-per-kilometer' => {
						'name' => q(ਲਿਟਰ/ਕਿ.ਮੀ.),
						'one' => q({0} ਲਿ./ਕਿ.ਮੀ.),
						'other' => q({0} ਲਿ./ਕਿ.ਮੀ.),
					},
					'lux' => {
						'name' => q(ਲਕਸ),
						'one' => q({0} ਲਕਸ),
						'other' => q({0} ਲਕਸ),
					},
					'megabit' => {
						'name' => q(ਮੈਗਾਬਿਟ),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(ਮੈਗਾਬਾਇਟ),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ਮੈ.ਲਿ.),
						'one' => q({0} ਮੈ.ਲਿ.),
						'other' => q({0} ਮੈ.ਲਿ.),
					},
					'megawatt' => {
						'name' => q(ਮੈ.ਵਾਟ),
						'one' => q({0} ਮੈ.ਵਾਟ),
						'other' => q({0} ਮੈ.ਵਾਟ),
					},
					'meter' => {
						'name' => q(ਮੀਟਰ),
						'one' => q({0} ਮੀ.),
						'other' => q({0} ਮੀ.),
						'per' => q({0}/ਮੀ.),
					},
					'meter-per-second' => {
						'name' => q(ਮੀਟਰ/ਸਕਿੰਟ),
						'one' => q({0} ਮੀ./ਸ.),
						'other' => q({0} ਮੀ./ਸ.),
					},
					'meter-per-second-squared' => {
						'name' => q(ਮੀਟਰ/ਸਕਿੰਟ²),
						'one' => q({0} ਮੀ/ਸ²),
						'other' => q({0} ਮੀ/ਸ²),
					},
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(ਮਾਈਕਰੋਮੀਟਰ),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(ਮਾਈਕਰੋਸਕਿੰਟ),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(ਮੀਲ),
						'one' => q({0} ਮੀਲ),
						'other' => q({0} ਮੀਲ),
					},
					'mile-per-gallon' => {
						'name' => q(ਮੀਲ/ਗੈਲਨ),
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਗੈ.),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(ਮੀਲ/ਗੈਲਨ ਇੰਪ.),
						'one' => q({0} mpg ਇੰਪ.),
						'other' => q({0} mpg ਇੰਪ.),
					},
					'mile-per-hour' => {
						'name' => q(ਮੀਲ/ਘੰਟਾ),
						'one' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
						'other' => q({0} ਮੀ.ਪ੍ਰ.ਘੰ.),
					},
					'mile-scandinavian' => {
						'name' => q(ਸਕੈਂਡ. ਮੀਲ),
						'one' => q({0} ਸਕੈਂਡ. ਮੀਲ),
						'other' => q({0} ਸਕੈਂਡ. ਮੀਲ),
					},
					'milliampere' => {
						'name' => q(ਮਿਲੀਐਮਪੀਅਰ),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(ਮਿਲੀਬਾਰ),
						'one' => q({0} ਮਿਲੀਬਾਰ),
						'other' => q({0} ਮਿਲੀਬਾਰ),
					},
					'milligram' => {
						'name' => q(ਮਿ.ਗ੍ਰਾ.),
						'one' => q({0} ਮਿ.ਗ੍ਰਾ.),
						'other' => q({0} ਮਿ.ਗ੍ਰਾ.),
					},
					'milligram-per-deciliter' => {
						'name' => q(ਮਿ.ਗ੍ਰਾ./ਡੈ.ਲਿ.),
						'one' => q({0}ਮਿਗ੍ਰਾ/ਡੈ.ਲਿ),
						'other' => q({0}ਮਿਗ੍ਰਾ/ਡੈ.ਲਿ),
					},
					'milliliter' => {
						'name' => q(ਮਿ.ਲਿ.),
						'one' => q({0} ਮਿ.ਲਿ.),
						'other' => q({0} ਮਿ.ਲਿ.),
					},
					'millimeter' => {
						'name' => q(ਮਿ.ਮੀ.),
						'one' => q({0} ਮਿ.ਮੀ.),
						'other' => q({0} ਮਿ.ਮੀ.),
					},
					'millimeter-of-mercury' => {
						'name' => q(ਮਿ.ਮੀ. ਪਾਰਾ),
						'one' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
						'other' => q({0} ਮਿ.ਮੀ. ਪਾਰਾ),
					},
					'millimole-per-liter' => {
						'name' => q(ਮਿਲੀਮੋਲ/ਲਿਟਰ),
						'one' => q({0} ਮਿ.ਮੋ./ਲਿ.),
						'other' => q({0} ਮਿ.ਮੋ./ਲਿ.),
					},
					'millisecond' => {
						'name' => q(ਮਿਲੀਸਕਿੰਟ),
						'one' => q({0} ਮਿਲੀਸਕਿੰਟ),
						'other' => q({0} ਮਿਲੀਸਕਿੰਟ),
					},
					'milliwatt' => {
						'name' => q(ਮਿ.ਵਾਟ),
						'one' => q({0} ਮਿ.ਵਾਟ),
						'other' => q({0} ਮਿ.ਵਾਟ),
					},
					'minute' => {
						'name' => q(ਮਿੰਟ),
						'one' => q({0} ਮਿੰਟ),
						'other' => q({0} ਮਿੰਟ),
						'per' => q({0}/ਮਿੰਟ),
					},
					'month' => {
						'name' => q(ਮਹੀਨੇ),
						'one' => q({0} ਮਹੀਨਾ),
						'other' => q({0} ਮਹੀਨੇ),
						'per' => q({0}/ਮਹੀਨਾ),
					},
					'nanometer' => {
						'name' => q(ਨੈ.ਮੀ.),
						'one' => q({0} ਨੈ.ਮੀ.),
						'other' => q({0} ਨੈ.ਮੀ.),
					},
					'nanosecond' => {
						'name' => q(ਨੈਨੋਸਕਿੰਟ),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(ਨੋ.ਮੀਲ),
						'one' => q({0} ਨੋ.ਮੀਲ),
						'other' => q({0} ਨੋ.ਮੀਲ),
					},
					'ohm' => {
						'name' => q(ਓਹਮ),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(ਔਂਸ),
						'one' => q({0} ਔਂਸ),
						'other' => q({0} ਔਂਸ),
						'per' => q({0}/ਔਂਸ),
					},
					'ounce-troy' => {
						'name' => q(ਔਂਸ ਟਰੌਏ),
						'one' => q({0} ਔਂਸ ਟ.),
						'other' => q({0} ਔਂਸ ਟ.),
					},
					'parsec' => {
						'name' => q(ਪਾਸੈੱਕ),
						'one' => q({0} ਪਾਸੈੱਕ),
						'other' => q({0} ਪਾਸੈੱਕ),
					},
					'part-per-million' => {
						'name' => q(ਹਿੱਸੇ/ਮਿਲੀਅਨ),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'percent' => {
						'name' => q(ਪ੍ਰਤੀਸ਼ਤ),
						'one' => q({0}%),
						'other' => q({0}%),
					},
					'permille' => {
						'name' => q(ਪਰਮਾਈਲ),
						'one' => q({0}‰),
						'other' => q({0}‰),
					},
					'petabyte' => {
						'name' => q(ਪੈਟਾਬਾਇਟ),
						'one' => q({0} PB),
						'other' => q({0} PB),
					},
					'picometer' => {
						'name' => q(ਪਿ.ਮੀ.),
						'one' => q({0} ਪਿਕੋਮੀਟਰ),
						'other' => q({0} ਪਿਕੋਮੀਟਰ),
					},
					'pint' => {
						'name' => q(ਪਿੰਟ),
						'one' => q({0} ਪਿੰਟ),
						'other' => q({0} ਪਿੰਟ),
					},
					'pint-metric' => {
						'name' => q(ਮੀ ਪਿੰਟ),
						'one' => q({0} ਮੀ ਪਿੰਟ),
						'other' => q({0} ਮੀ ਪਿੰਟ),
					},
					'point' => {
						'name' => q(ਪੁਆਇੰਟ),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pound' => {
						'name' => q(ਪੌਂਡ),
						'one' => q({0} ਪੌਂਡ),
						'other' => q({0} ਪੌਂਡ),
						'per' => q({0}/ਪੌਂਡ),
					},
					'pound-per-square-inch' => {
						'name' => q(ਪੌਂ.ਵ.ਇੰਚ),
						'one' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
						'other' => q({0} ਪੌਂ.ਵ.ਇੰਚ),
					},
					'quart' => {
						'name' => q(ਕੁਆਟ),
						'one' => q({0} ਕੁਆਟ),
						'other' => q({0} ਕੁਆਟ),
					},
					'radian' => {
						'name' => q(ਰੇਡੀਅਨ),
						'one' => q({0} ਰੇਡੀ.),
						'other' => q({0} ਰੇਡੀ.),
					},
					'revolution' => {
						'name' => q(ਪਰਿਕਰਮਾ),
						'one' => q({0} ਪਰਿਕਰਮਾ),
						'other' => q({0} ਪਰਿਕਰਮਾ),
					},
					'second' => {
						'name' => q(ਸਕਿੰਟ),
						'one' => q({0} ਸਕਿੰਟ),
						'other' => q({0} ਸਕਿੰਟ),
						'per' => q({0} ਪ੍ਰ.ਸ.),
					},
					'square-centimeter' => {
						'name' => q(ਸੈਮੀ²),
						'one' => q({0} ਸੈਮੀ²),
						'other' => q({0} ਸੈਮੀ²),
						'per' => q({0} ਪ੍ਰਤੀ ਸੈਮੀ²),
					},
					'square-foot' => {
						'name' => q(ਵ. ਫੁੱਟ),
						'one' => q({0} ਵ. ਫੁੱਟ),
						'other' => q({0} ਵ. ਫੁੱਟ),
					},
					'square-inch' => {
						'name' => q(ਇੰਚ²),
						'one' => q({0} ਇੰਚ²),
						'other' => q({0} ਇੰਚ²),
						'per' => q({0} ਪ੍ਰਤੀ ਇੰਚ²),
					},
					'square-kilometer' => {
						'name' => q(ਕਿਮੀ²),
						'one' => q({0} ਕਿਮੀ²),
						'other' => q({0} ਕਿਮੀ²),
						'per' => q({0}/ਕਿਮੀ²),
					},
					'square-meter' => {
						'name' => q(ਮੀਟਰ²),
						'one' => q({0} ਮੀ²),
						'other' => q({0} ਮੀ²),
						'per' => q({0} ਪ੍ਰਤੀ ਮੀ²),
					},
					'square-mile' => {
						'name' => q(ਵਰਗ ਮੀਲ),
						'one' => q({0} ਵ. ਮੀਲ),
						'other' => q({0} ਵ. ਮੀਲ),
						'per' => q({0}/ਮੀਲ²),
					},
					'square-yard' => {
						'name' => q(ਗਜ਼²),
						'one' => q({0} ਗਜ਼²),
						'other' => q({0} ਗਜ਼²),
					},
					'stone' => {
						'name' => q(ਸਟੋਨ),
						'one' => q({0} ਸਟੋਨ),
						'other' => q({0} ਸਟੋਨ),
					},
					'tablespoon' => {
						'name' => q(ਟੇਬਲ ਸਪੂਨ),
						'one' => q({0} ਟੇਬਲ ਸਪੂਨ),
						'other' => q({0} ਟੇਬਲ ਸਪੂਨ),
					},
					'teaspoon' => {
						'name' => q(ਟੀ ਸਪੂਨ),
						'one' => q({0} ਟੀ ਸਪੂਨ),
						'other' => q({0} ਟੀ ਸਪੂਨ),
					},
					'terabit' => {
						'name' => q(ਟੇਰਾਬਿਟ),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(ਟੈਰਾਬਾਇਟ),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(ਟਨ),
						'one' => q({0} ਟਨ),
						'other' => q({0} ਟਨ),
					},
					'volt' => {
						'name' => q(ਵੋਲਟ),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(ਵਾਟ),
						'one' => q({0} ਵਾਟ),
						'other' => q({0} ਵਾਟ),
					},
					'week' => {
						'name' => q(ਹਫ਼ਤੇ),
						'one' => q({0} ਹਫ਼ਤਾ),
						'other' => q({0} ਹਫ਼ਤੇ),
						'per' => q({0}/ਹਫ਼ਤਾ),
					},
					'yard' => {
						'name' => q(ਗਜ਼),
						'one' => q({0} ਗਜ਼),
						'other' => q({0} ਗਜ਼),
					},
					'year' => {
						'name' => q(ਸਾਲ),
						'one' => q({0} ਸਾਲ),
						'other' => q({0} ਸਾਲ),
						'per' => q({0}/ਸਾਲ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ਹਾਂ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:ਨਹੀਂ|ਨ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'guru',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'decimal' => q(٫),
			'exponential' => q(×۱۰^),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(؉),
			'percentSign' => q(٪),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(٫),
		},
		'guru' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ਹਜ਼ਾਰ',
					'other' => '0 ਹਜ਼ਾਰ',
				},
				'10000' => {
					'one' => '00 ਹਜ਼ਾਰ',
					'other' => '00 ਹਜ਼ਾਰ',
				},
				'100000' => {
					'one' => '0 ਲੱਖ',
					'other' => '0 ਲੱਖ',
				},
				'1000000' => {
					'one' => '00 ਲੱਖ',
					'other' => '00 ਲੱਖ',
				},
				'10000000' => {
					'one' => '0 ਕਰੋੜ',
					'other' => '0 ਕਰੋੜ',
				},
				'100000000' => {
					'one' => '00 ਕਰੋੜ',
					'other' => '00 ਕਰੋੜ',
				},
				'1000000000' => {
					'one' => '0 ਅਰਬ',
					'other' => '0 ਅਰਬ',
				},
				'10000000000' => {
					'one' => '00 ਅਰਬ',
					'other' => '00 ਅਰਬ',
				},
				'100000000000' => {
					'one' => '0 ਖਰਬ',
					'other' => '0 ਖਰਬ',
				},
				'1000000000000' => {
					'one' => '00 ਖਰਬ',
					'other' => '00 ਖਰਬ',
				},
				'10000000000000' => {
					'one' => '0 ਨੀਲ',
					'other' => '0 ਨੀਲ',
				},
				'100000000000000' => {
					'one' => '00 ਨੀਲ',
					'other' => '00 ਨੀਲ',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '[#E0]',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'arabext' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤#,##,##0.00',
					},
				},
			},
		},
		'guru' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '¤ #,##0.00',
					},
					'standard' => {
						'positive' => '¤ #,##,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
				'one' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
				'other' => q(ਸੰਯੁਕਤ ਅਰਬ ਅਮੀਰਾਤ ਦਿਰਹਾਮ),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
				'one' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
				'other' => q(ਅਫ਼ਗਾਨ ਅਫ਼ਗਾਨੀ),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
				'one' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
				'other' => q(ਅਲਬਾਨੀਆਈ ਲੇਕ),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(ਅਰਮੀਨੀਆਈ ਦਰਮ),
				'one' => q(ਅਰਮੀਨੀਆਈ ਦਰਮ),
				'other' => q(ਅਰਮੀਨੀਆਈ ਦਰਮ),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
				'one' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
				'other' => q(ਨੀਦਰਲੈਂਡਸ ਐਂਟੀਲੀਅਨ ਗਿਲਡਰ),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
				'one' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
				'other' => q(ਅੰਗੋਲਾ ਕਵਾਂਜਾ),
			},
		},
		'ARA' => {
			symbol => 'ARA',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ),
				'one' => q(ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ),
				'other' => q(ਅਰਜਨਟੀਨੀ ਅਸਟਰਾਲ),
			},
		},
		'ARL' => {
			symbol => 'ARL',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ \(1970–1983\)),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ \(1970–1983\)),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ ਲੇ \(1970–1983\)),
			},
		},
		'ARM' => {
			symbol => 'ARM',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1881–1970\)),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1881–1970\)),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1881–1970\)),
			},
		},
		'ARP' => {
			symbol => 'ARP',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1983–1985\)),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1983–1985\)),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ \(1983–1985\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ),
				'one' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ),
				'other' => q(ਅਰਜਨਟੀਨੀ ਪੇਸੋ),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
				'one' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
				'other' => q(ਆਸਟ੍ਰੇਲੀਆਈ ਡਾਲਰ),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
				'one' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
				'other' => q(ਅਰੂਬਨ ਫਲੋਰਿਨ),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ),
				'one' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ),
				'other' => q(ਅਜ਼ਰਬਾਈਜਾਨ ਮਾਨਤ),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ),
				'one' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ),
				'other' => q(ਬੋਸਨੀਆ-ਹਰਜ਼ੇਗੋਵੀਨਾ ਬਦਲਣਯੋਗ ਮਾਰਕ),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
				'one' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
				'other' => q(ਬਾਰਬਾਡੀਅਨ ਡਾਲਰ),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
				'one' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
				'other' => q(ਬੰਗਲਾਦੇਸ਼ੀ ਟਕਾ),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(ਬੁਲਗਾਰੀਆਈ ਲੇਵ),
				'one' => q(ਬੁਲਗਾਰੀਆਈ ਲੇਵ),
				'other' => q(ਬੁਲਗਾਰੀਆਈ ਲੇਵ),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
				'one' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
				'other' => q(ਬਹਿਰੀਨੀ ਦਿਨਾਰ),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
				'one' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
				'other' => q(ਬੁਰੁੰਡੀਆਈ ਫ੍ਰੈਂਕ),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
				'one' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
				'other' => q(ਬਰਮੂਡਾ ਡਾਲਰ),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
				'one' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
				'other' => q(ਬਰੂਨੇਈ ਡਾਲਰ),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
				'one' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
				'other' => q(ਬੋਲੀਵੀਅਨ ਬੋਲੀਵੀਅਨੋ),
			},
		},
		'BOL' => {
			symbol => 'BOL',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ \(1863–1963\)),
				'one' => q(ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ \(1863–1963\)),
				'other' => q(ਬੋਲੀਵੀਆਈ ਬੋਲੀਵੀਅਨੋ \(1863–1963\)),
			},
		},
		'BOP' => {
			symbol => 'BOP',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਆਈ ਪੇਸੋ),
				'one' => q(ਬੋਲੀਵੀਆਈ ਪੇਸੋ),
				'other' => q(ਬੋਲੀਵੀਆਈ ਪੇਸੋ),
			},
		},
		'BOV' => {
			symbol => 'BOV',
			display_name => {
				'currency' => q(ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ),
				'one' => q(ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ),
				'other' => q(ਬੋਲੀਵੀਆਈ ਮਵਡੋਲ),
			},
		},
		'BRB' => {
			symbol => 'BRB',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ \(1967–1986\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ \(1967–1986\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਿਰੋਸ \(1967–1986\)),
			},
		},
		'BRC' => {
			symbol => 'BRC',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ \(1986–1989\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ \(1986–1989\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਾਡੂ \(1986–1989\)),
			},
		},
		'BRE' => {
			symbol => 'BRE',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1990–1993\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1990–1993\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1990–1993\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਰੀਅਲ),
			},
		},
		'BRN' => {
			symbol => 'BRN',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ \(1989–1990\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ \(1989–1990\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਨਿਊ ਕਰੁਜ਼ਾਡੂ \(1989–1990\)),
			},
		},
		'BRR' => {
			symbol => 'BRR',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1993–1994\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1993–1994\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1993–1994\)),
			},
		},
		'BRZ' => {
			symbol => 'BRZ',
			display_name => {
				'currency' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1942–1967\)),
				'one' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1942–1967\)),
				'other' => q(ਬ੍ਰਾਜ਼ੀਲੀਆਈ ਕਰੁਜ਼ਿਰੋਸ \(1942–1967\)),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
				'one' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
				'other' => q(ਬਾਹਾਮੀਅਨ ਡਾਲਰ),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
				'one' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
				'other' => q(ਭੂਟਾਨੀ ਐਂਗਲਟ੍ਰਮ),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
				'one' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
				'other' => q(ਬੋਟਸਵਾਨਾ ਪੁਲਾ),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
				'one' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
				'other' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ \(2000–2016\)),
				'one' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ \(2000–2016\)),
				'other' => q(ਬੇਲਾਰੂਸੀ ਰੂਬਲ \(2000–2016\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
				'one' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
				'other' => q(ਬੇਲੀਜ਼ ਡਾਲਰ),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
				'one' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
				'other' => q(ਕੇਨੇਡਿਆਈ ਡਾਲਰ),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
				'one' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
				'other' => q(ਕਾਂਗੋਲੀਜ਼ ਫ੍ਰੈਂਕ),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
				'one' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
				'other' => q(ਸਵਿਸ ਫ੍ਰੈਂਕ),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(ਚਿਲੀ ਪੇਸੋ),
				'one' => q(ਚਿਲੀ ਪੇਸੋ),
				'other' => q(ਚਿਲੀ ਪੇਸੋ),
			},
		},
		'CNH' => {
			symbol => 'CNH',
			display_name => {
				'currency' => q(ਚੀਨੀ ਯੁਆਨ \(ਔਫ਼ਸ਼ੋਰ\)),
				'one' => q(ਚੀਨੀ ਯੁਆਨ \(ਔਫ਼ਸ਼ੋਰ\)),
				'other' => q(ਚੀਨੀ ਯੁਆਨ \(ਔਫ਼ਸ਼ੋਰ\)),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(ਚੀਨੀ ਯੁਆਨ),
				'one' => q(ਚੀਨੀ ਯੁਆਨ),
				'other' => q(ਚੀਨੀ ਯੁਆਨ),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(ਕੋਲੰਬਿਆਈ ਪੇਸੋ),
				'one' => q(ਕੋਲੰਬਿਆਈ ਪੇਸੋ),
				'other' => q(ਕੋਲੰਬਿਆਈ ਪੇਸੋ),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
				'one' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
				'other' => q(ਕੋਸਟਾ ਰੀਕਨ ਕੋਲਨ),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ),
				'one' => q(ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ),
				'other' => q(ਕਿਊਬਨ ਬਦਲਣਯੋਗ ਪੇਸੋ),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(ਕਿਊਬਨ ਪੇਸੋ),
				'one' => q(ਕਿਊਬਨ ਪੇਸੋ),
				'other' => q(ਕਿਊਬਨ ਪੇਸੋ),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ),
				'one' => q(ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ),
				'other' => q(ਕੇਪ ਵਰਡੀਅਨ ਸਕੂਡੋ),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
				'one' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
				'other' => q(ਚੈਕ ਗਣਰਾਜ ਕੋਰੁਨਾ),
			},
		},
		'DEM' => {
			symbol => 'DEM',
			display_name => {
				'currency' => q(ਜਰਮਨ ਮਾਰਕ),
				'one' => q(ਜਰਮਨ ਮਾਰਕ),
				'other' => q(ਜਰਮਨ ਮਾਰਕ),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਜ਼ੀਬੂਤੀਅਨ ਫ੍ਰੈਂਕ),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(ਡੈਨਿਸ਼ ਕਰੌਨ),
				'one' => q(ਡੈਨਿਸ਼ ਕਰੌਨ),
				'other' => q(ਡੈਨਿਸ਼ ਕਰੌਨ),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(ਡੌਮਿਨਿਕਨ ਪੇਸੋ),
				'one' => q(ਡੌਮਿਨਿਕਨ ਪੇਸੋ),
				'other' => q(ਡੌਮਿਨਿਕਨ ਪੇਸੋ),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
				'one' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
				'other' => q(ਅਲਜੀਰਿਆਈ ਦਿਨਾਰ),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(ਮਿਸਰੀ ਪੌਂਡ),
				'one' => q(ਮਿਸਰੀ ਪੌਂਡ),
				'other' => q(ਮਿਸਰੀ ਪੌਂਡ),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ),
				'one' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ),
				'other' => q(ਇਰੀਟ੍ਰਿਆਈ ਨਾਫ਼ਾ),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
				'one' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
				'other' => q(ਇਥੋਪੀਆਈ ਬਿਰ),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(ਯੂਰੋ),
				'one' => q(ਯੂਰੋ),
				'other' => q(ਯੂਰੋ),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(ਫ਼ਿਜ਼ੀ ਡਾਲਰ),
				'one' => q(ਫ਼ਿਜ਼ੀ ਡਾਲਰ),
				'other' => q(ਫ਼ਿਜ਼ੀ ਡਾਲਰ),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ),
				'one' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ),
				'other' => q(ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਪੌਂਡ),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ),
				'one' => q(ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ),
				'other' => q(ਬ੍ਰਿਟਿਸ਼ ਪੌਂਡ),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(ਜਾਰਜੀਆਈ ਲਾਰੀ),
				'one' => q(ਜਾਰਜੀਆਈ ਲਾਰੀ),
				'other' => q(ਜਾਰਜੀਆਈ ਲਾਰੀ),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(ਘਾਨਾਈ ਸੇਡੀ),
				'one' => q(ਘਾਨਾਈ ਸੇਡੀ),
				'other' => q(ਘਾਨਾਈ ਸੇਡੀ),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(ਜਿਬਰਾਲਟਰ ਪੌਂਡ),
				'one' => q(ਜਿਬਰਾਲਟਰ ਪੌਂਡ),
				'other' => q(ਜਿਬਰਾਲਟਰ ਪੌਂਡ),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(ਗੈਂਬੀਆਈ ਦਲਾਸੀ),
				'one' => q(ਗੈਂਬੀਆਈ ਦਲਾਸੀ),
				'other' => q(ਗੈਂਬੀਆਈ ਦਲਾਸੀ),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(ਗਿਨੀ ਫ੍ਰੈਂਕ),
				'one' => q(ਗਿਨੀ ਫ੍ਰੈਂਕ),
				'other' => q(ਗਿਨੀ ਫ੍ਰੈਂਕ),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
				'one' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
				'other' => q(ਗੁਆਟੇਮਾਲਾ ਕੁਏਟਜ਼ਲ),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(ਗੁਆਨਾਆਈ ਡਾਲਰ),
				'one' => q(ਗੁਆਨਾਆਈ ਡਾਲਰ),
				'other' => q(ਗੁਆਨਾਆਈ ਡਾਲਰ),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
				'one' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
				'other' => q(ਹਾਂਗ ਕਾਂਗ ਡਾਲਰ),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
				'one' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
				'other' => q(ਹਾਨਡੂਰਨ ਲੇਮਪਿਰਾ),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
				'one' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
				'other' => q(ਕਰੋਏਸ਼ੀਆਈ ਕੁਨਾ),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(ਹੈਤੀ ਗੌਰਡੇ),
				'one' => q(ਹੈਤੀ ਗੌਰਡੇ),
				'other' => q(ਹੈਤੀ ਗੌਰਡੇ),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(ਹੰਗਰੀ ਫੋਰਿੰਟ),
				'one' => q(ਹੰਗਰੀ ਫੋਰਿੰਟ),
				'other' => q(ਹੰਗਰੀ ਫੋਰਿੰਟ),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
				'one' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
				'other' => q(ਇੰਡੋਨੇਸ਼ੀਆਈ ਰੁਪਿਆਹ),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(ਆਇਰਿਸ਼ ਪੌਂਡ),
				'one' => q(ਆਇਰਿਸ਼ ਪੌਂਡ),
				'other' => q(ਆਇਰਿਸ਼ ਪੌਂਡ),
			},
		},
		'ILP' => {
			symbol => 'ILP',
			display_name => {
				'currency' => q(ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ),
				'one' => q(ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ),
				'other' => q(ਇਜ਼ਰਾਈਲੀ ਪੌਂਡ),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
				'one' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
				'other' => q(ਇਜ਼ਰਾਈਲੀ ਨਵੀਂ ਸ਼ੇਕੇਲ),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(ਭਾਰਤੀ ਰੁਪਇਆ),
				'one' => q(ਭਾਰਤੀ ਰੁਪਇਆ),
				'other' => q(ਭਾਰਤੀ ਰੁਪਏ),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
				'one' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
				'other' => q(ਇਰਾਕੀ ਦਿਨਾਰ),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(ਈਰਾਨੀ ਰਿਆਲ),
				'one' => q(ਈਰਾਨੀ ਰਿਆਲ),
				'other' => q(ਈਰਾਨੀ ਰਿਆਲ),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
				'one' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
				'other' => q(ਆਈਸਲੈਂਡਿਕ ਕਰੌਨ),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
				'one' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
				'other' => q(ਜਮਾਇਕਨ ਡਾਲਰ),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(ਜਾਰਡਨ ਦਿਨਾਰ),
				'one' => q(ਜਾਰਡਨ ਦਿਨਾਰ),
				'other' => q(ਜਾਰਡਨ ਦਿਨਾਰ),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(ਜਪਾਨੀ ਯੇਨ),
				'one' => q(ਜਪਾਨੀ ਯੇਨ),
				'other' => q(ਜਪਾਨੀ ਯੇਨ),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਕੀਨੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
				'one' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
				'other' => q(ਕਿਰਗਿਸਤਾਨੀ ਸੋਮ),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
				'one' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
				'other' => q(ਕੰਬੋਡੀਆਈ ਰੀਅਲ),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਕੋਮੋਰੀਅਨ ਫ੍ਰੈਂਕ),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
				'one' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
				'other' => q(ਉੱਤਰੀ ਕੋਰੀਆਈ ਵੋਨ),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
				'one' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
				'other' => q(ਦੱਖਣੀ ਕੋਰੀਆਈ ਵੋਨ),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
				'one' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
				'other' => q(ਕੁਵੈਤੀ ਦਿਨਾਰ),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'one' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'other' => q(ਕੇਮੈਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ),
				'one' => q(ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ),
				'other' => q(ਕਜ਼ਾਖਸਤਾਨੀ ਤੇਂਗੇ),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
				'one' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
				'other' => q(ਲਾਓਟਿਆਈ ਕਿਪ),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(ਲੈਬਨਾਨੀ ਪੌਂਡ),
				'one' => q(ਲੈਬਨਾਨੀ ਪੌਂਡ),
				'other' => q(ਲੈਬਨਾਨੀ ਪੌਂਡ),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਇਆ),
				'one' => q(ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਇਆ),
				'other' => q(ਸ੍ਰੀਲੰਕਾਈ ਰੁਪਏ),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
				'one' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
				'other' => q(ਲਾਈਬੀਰੀਆਈ ਡਾਲਰ),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
				'one' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
				'other' => q(ਲਿਥੁਆਨੀਆਈ ਲਿਤਾਸ),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
				'one' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
				'other' => q(ਲਾਟਵਿਆਈ ਲਾਟਸ),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
				'one' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
				'other' => q(ਲੀਬੀਅਨ ਦਿਨਾਰ),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
				'one' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
				'other' => q(ਮੋਰੱਕਨ ਦਿਰਹਾਮ),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(ਮੋਲਡੋਵਨ ਲੇਉ),
				'one' => q(ਮੋਲਡੋਵਨ ਲੇਉ),
				'other' => q(ਮੋਲਡੋਵਨ ਲੇਉ),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
				'one' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
				'other' => q(ਮਾਲਾਗਾਸੀ ਅਰਾਇਰੀ),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
				'one' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
				'other' => q(ਮੈਕਡੋਨੀਆਈ ਡੇਨਾਰ),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(ਮਿਆਂਮਾਰ ਕਿਆਤ),
				'one' => q(ਮਿਆਂਮਾਰ ਕਿਆਤ),
				'other' => q(ਮਿਆਂਮਾਰ ਕਿਆਤ),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
				'one' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
				'other' => q(ਮੰਗੋਲੀਆਈ ਤੁਗਰਿਕ),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
				'one' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
				'other' => q(ਮੇਕਾਨੀ ਪਟਾਕਾ),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ \(1973–2017\)),
				'one' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ \(1973–2017\)),
				'other' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ \(1973–2017\)),
			},
		},
		'MRU' => {
			symbol => 'MRU',
			display_name => {
				'currency' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
				'one' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
				'other' => q(ਮੋਰਿਟਾਨੀਆਈ ਊਗੀਆ),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਇਆ),
				'one' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਇਆ),
				'other' => q(ਮੌਰਿਸ਼ੀਆਈ ਰੁਪਏ),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
				'one' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
				'other' => q(ਮਾਲਦੀਵੀ ਰੁਫੀਆ),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
				'one' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
				'other' => q(ਮਾਲਾਵੀਆਈ ਕਵਾਚਾ),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(ਮੈਕਸੀਕਨ ਪੇਸੋ),
				'one' => q(ਮੈਕਸੀਕਨ ਪੇਸੋ),
				'other' => q(ਮੈਕਸੀਕਨ ਪੇਸੋ),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ),
				'one' => q(ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ),
				'other' => q(ਮਲੇਸ਼ੀਆਈ ਰਿੰਗਿਟ),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
				'one' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
				'other' => q(ਮੋਜ਼ਾਮਬੀਕਨ ਮੈਟੀਕਲ),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
				'one' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
				'other' => q(ਨਾਮੀਬੀਆਈ ਡਾਲਰ),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
				'one' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
				'other' => q(ਨਾਇਜੀਰੀਆਈ ਨਾਇਰਾ),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ),
				'one' => q(ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ),
				'other' => q(ਨਿਕਾਰਾਗੁਆਈ ਕੋਰਡੋਬਾ),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ),
				'one' => q(ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ),
				'other' => q(ਨਾਰਵੇਜੀਆਈ ਕਰੌਨ),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(ਨੇਪਾਲੀ ਰੁਪਇਆ),
				'one' => q(ਨੇਪਾਲੀ ਰੁਪਇਆ),
				'other' => q(ਨੇਪਾਲੀ ਰੁਪਏ),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
				'one' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
				'other' => q(ਨਿਊਜ਼ੀਲੈਂਡ ਡਾਲਰ),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(ਓਮਾਨੀ ਰਿਆਲ),
				'one' => q(ਓਮਾਨੀ ਰਿਆਲ),
				'other' => q(ਓਮਾਨੀ ਰਿਆਲ),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
				'one' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
				'other' => q(ਪਨਾਮੇਨੀਅਨ ਬਾਲਬੋਆ),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(ਪੇਰੂਵੀਅਨ ਸੋਲ),
				'one' => q(ਪੇਰੂਵੀਅਨ ਸੋਲ),
				'other' => q(ਪੇਰੂਵੀਅਨ ਸੋਲ),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ),
				'one' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ),
				'other' => q(ਪਾਪੂਆ ਨਿਊ ਗਿਨੀਆਈ ਕੀਨਾ),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(ਫਿਲਿਪੀਨੀ ਪੇਸੋ),
				'one' => q(ਫਿਲਿਪੀਨੀ ਪੇਸੋ),
				'other' => q(ਫਿਲਿਪੀਨੀ ਪੇਸੋ),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਇਆ),
				'one' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਇਆ),
				'other' => q(ਪਾਕਿਸਤਾਨੀ ਰੁਪਏ),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ),
				'one' => q(ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ),
				'other' => q(ਪੋਲੈਂਡੀ ਜ਼ਲੌਟੀ),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
				'one' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
				'other' => q(ਪੈਰਾਗੁਵਾਇਨ ਗੁਆਰਾਨੀ),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(ਕਤਰੀ ਰਿਆਲ),
				'one' => q(ਕਤਰੀ ਰਿਆਲ),
				'other' => q(ਕਤਰੀ ਰਿਆਲ),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(ਰੋਮਾਨੀਆਈ ਲੇਉ),
				'one' => q(ਰੋਮਾਨੀਆਈ ਲੇਉ),
				'other' => q(ਰੋਮਾਨੀਆਈ ਲੇਉ),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਸਰਬੀਆਈ ਦਿਨਾਰ),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(ਰੂਸੀ ਰੂਬਲ),
				'one' => q(ਰੂਸੀ ਰੂਬਲ),
				'other' => q(ਰੂਸੀ ਰੂਬਲ),
			},
		},
		'RUR' => {
			symbol => 'р.',
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
				'one' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
				'other' => q(ਰਵਾਂਡਨ ਫ੍ਰੈਂਕ),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(ਸਾਊਦੀ ਰਿਆਲ),
				'one' => q(ਸਾਊਦੀ ਰਿਆਲ),
				'other' => q(ਸਾਊਦੀ ਰਿਆਲ),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'one' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
				'other' => q(ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਡਾਲਰ),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(ਸੇਸ਼ਲਸ ਰੁਪਇਆ),
				'one' => q(ਸੇਸ਼ਲਸ ਰੁਪਇਆ),
				'other' => q(ਸੇਸ਼ਲਸ ਰੁਪਏ),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(ਸੂਡਾਨੀ ਪੌਂਡ),
				'one' => q(ਸੂਡਾਨੀ ਪੌਂਡ),
				'other' => q(ਸੂਡਾਨੀ ਪੌਂਡ),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
				'one' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
				'other' => q(ਸਵੀਡਿਸ਼ ਕਰੋਨਾ),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
				'one' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
				'other' => q(ਸਿੰਗਾਪੁਰ ਡਾਲਰ),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ),
				'one' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ),
				'other' => q(ਸੇਂਟ ਹੇਲੇਨਾ ਪੌਂਡ),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
				'one' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
				'other' => q(ਸਿਏਰਾ ਲਿਓਨੀਅਨ ਲਿਓਨ),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਸੋਮਾਲੀ ਸ਼ਿਲਿੰਗ),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(ਸੂਰੀਨਾਮੀ ਡਾਲਰ),
				'one' => q(ਸੂਰੀਨਾਮੀ ਡਾਲਰ),
				'other' => q(ਸੂਰੀਨਾਮੀ ਡਾਲਰ),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ),
				'one' => q(ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ),
				'other' => q(ਦੱਖਣੀ ਸੂਡਾਨੀ ਪੌਂਡ),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ \(1977–2017\)),
				'one' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ \(1977–2017\)),
				'other' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'STN',
			display_name => {
				'currency' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
				'one' => q(ਸਾਉ ਟੋਮੀ ਅਤੇ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
				'other' => q(ਸਾਉ ਟੋਮੀ ਐਂਡ ਪ੍ਰਿੰਸਪੀ ਡੋਬਰਾ),
			},
		},
		'SUR' => {
			symbol => 'SUR',
			display_name => {
				'currency' => q(ਸੋਵੀਅਤ ਰੂਬਲ),
				'one' => q(ਸੋਵੀਅਤ ਰੂਬਲ),
				'other' => q(ਸੋਵੀਅਤ ਰੂਬਲ),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(ਸੀਰੀਆਈ ਪੌਂਡ),
				'one' => q(ਸੀਰੀਆਈ ਪੌਂਡ),
				'other' => q(ਸੀਰੀਆਈ ਪੌਂਡ),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
				'one' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
				'other' => q(ਸਵਾਜ਼ੀ ਲਾਇਲੈਂਗਨੀ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(ਥਾਈ ਬਾਹਤ),
				'one' => q(ਥਾਈ ਬਾਹਤ),
				'other' => q(ਥਾਈ ਬਾਹਤ),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
				'one' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
				'other' => q(ਤਾਜਿਕਿਸਤਾਨੀ ਸੋਮੋਨੀ),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
				'one' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
				'other' => q(ਤੁਰਕਮੇਨਿਸਤਾਨੀ ਮਾਨਤ),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
				'one' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
				'other' => q(ਟਿਉਨੀਸ਼ੀਆਈ ਦਿਨਾਰ),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
				'one' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
				'other' => q(ਟੌਂਗਨ ਪੈਂਗਾ),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(ਤੁਰਕੀ ਲੀਰਾ),
				'one' => q(ਤੁਰਕੀ ਲੀਰਾ),
				'other' => q(ਤੁਰਕੀ ਲੀਰਾ),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
				'one' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
				'other' => q(ਟ੍ਰਿਨੀਡਾਡ ਅਤੇ ਟੋਬਾਗੋ ਡਾਲਰ),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
				'one' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
				'other' => q(ਨਵਾਂ ਤਾਇਵਾਨ ਡਾਲਰ),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਤਨਜ਼ਾਨੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
				'one' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
				'other' => q(ਯੂਕਰੇਨੀਆਈ ਰਿਵਨਿਆ),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ),
				'one' => q(ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ),
				'other' => q(ਯੂਗਾਂਡੀਆਈ ਸ਼ਿਲਿੰਗ),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
				'one' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
				'other' => q(ਯੂ.ਐਸ. ਡਾਲਰ),
			},
		},
		'UYI' => {
			symbol => 'UYI',
		},
		'UYP' => {
			symbol => 'UYP',
			display_name => {
				'currency' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ \(1975–1993\)),
				'one' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ \(1975–1993\)),
				'other' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ \(1975–1993\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ),
				'one' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ),
				'other' => q(ਉਰੂਗੁਵਾਇਨ ਪੇਸੋ),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
				'one' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
				'other' => q(ਉਜ਼ਬੇਕਿਸਤਾਨ ਸੋਮ),
			},
		},
		'VEB' => {
			symbol => 'VEB',
			display_name => {
				'currency' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(1871–2008\)),
				'one' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(1871–2008\)),
				'other' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(1871–2008\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(2008–2018\)),
				'one' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(2008–2018\)),
				'other' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ \(2008–2018\)),
			},
		},
		'VES' => {
			symbol => 'VES',
			display_name => {
				'currency' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
				'one' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
				'other' => q(ਵੇਨੇਜ਼ੂਏਲਨ ਬੋਲੀਵਰ),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ),
				'one' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ),
				'other' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ),
			},
		},
		'VNN' => {
			symbol => 'VNN',
			display_name => {
				'currency' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ \(1978–1985\)),
				'one' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ \(1978–1985\)),
				'other' => q(ਵੀਅਤਨਾਮੀ ਡੋਂਗ \(1978–1985\)),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
				'one' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
				'other' => q(ਵਾਨੂਆਟੂ ਵਾਟੂ),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
				'one' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
				'other' => q(ਸਾਮੋਆਈ ਤਾਲਾ),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ [CFA] ਫ੍ਰੈਂਕ),
				'one' => q(ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ [CFA] ਫ੍ਰੈਂਕ),
				'other' => q(ਕੇਂਦਰੀ ਅਫ਼ਰੀਕੀ [CFA] ਫ੍ਰੈਂਕ),
			},
		},
		'XAG' => {
			symbol => 'XAG',
			display_name => {
				'currency' => q(ਚਾਂਦੀ),
				'one' => q(ਚਾਂਦੀ ਦਾ ਟਰੌਏ ਔਂਸ),
				'other' => q(ਚਾਂਦੀ ਦਾ ਟਰੌਏ ਔਂਸ),
			},
		},
		'XAU' => {
			symbol => 'XAU',
			display_name => {
				'currency' => q(ਸੋਨਾ),
				'one' => q(ਸੋਨੇ ਦਾ ਟਰੌਏ ਔਂਸ),
				'other' => q(ਸੋਨੇ ਦਾ ਟਰੌਏ ਔਂਸ),
			},
		},
		'XBA' => {
			symbol => 'XBA',
		},
		'XBB' => {
			symbol => 'XBB',
			display_name => {
				'currency' => q(ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ),
				'one' => q(ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ),
				'other' => q(ਯੂਰਪੀ ਵਿੱਤੀ ਇਕਾਈ),
			},
		},
		'XBC' => {
			symbol => 'XBC',
		},
		'XBD' => {
			symbol => 'XBD',
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
				'one' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
				'other' => q(ਪੂਰਬੀ ਕੈਰੇਬੀਅਨ ਡਾਲਰ),
			},
		},
		'XEU' => {
			symbol => 'XEU',
			display_name => {
				'currency' => q(ਯੂਰਪੀ ਮੁਦਰਾ ਇਕਾਈ),
				'one' => q(XEU),
				'other' => q(ਯੂਰਪੀ ਮੁਦਰਾ ਇਕਾਈ),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(ਪੱਛਮੀ ਅਫ਼ਰੀਕੀ \(CFA\) ਫ੍ਰੈਂਕ),
				'one' => q(ਪੱਛਮੀ ਅਫ਼ਰੀਕੀ \(CFA\) ਫ੍ਰੈਂਕ),
				'other' => q(ਪੱਛਮੀ ਅਫ਼ਰੀਕੀ \(CFA\) ਫ੍ਰੈਂਕ),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(ਫ੍ਰੈਂਕ \(CFP\)),
				'one' => q(ਫ੍ਰੈਂਕ \(CFP\)),
				'other' => q(ਫ੍ਰੈਂਕ \(CFP\)),
			},
		},
		'XXX' => {
			symbol => 'XXX',
			display_name => {
				'currency' => q(ਅਗਿਆਤ ਮੁਦਰਾ),
				'one' => q(\(ਮੁਦਰਾ ਦੀ ਅਗਿਆਤ ਇਕਾਈ\)),
				'other' => q(\(ਅਗਿਆਤ ਮੁਦਰਾ\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(ਯਮਨੀ ਰਿਆਲ),
				'one' => q(ਯਮਨੀ ਰਿਆਲ),
				'other' => q(ਯਮਨੀ ਰਿਆਲ),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
				'one' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
				'other' => q(ਦੱਖਣੀ ਅਫਰੀਕੀ ਰੈਂਡ),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
				'one' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
				'other' => q(ਜ਼ਾਮਬੀਆਈ ਕਵਾਚਾ),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਟੋਉਟ',
							'ਬਾਬਾ',
							'ਹੇਟਰ',
							'ਕੀਅਕ',
							'ਤੋਬਾ',
							'ਅਮਸ਼ੀਰ',
							'ਬ੍ਰਾਮਹਟ',
							'ਬਾਰਾਮੂਡਾ',
							'ਬਾਸ਼ਨਸ',
							'ਪਾਓਨਾ',
							'ਅਪੈਪ',
							'ਮੈਸਰਾ',
							'ਨੇਜ਼ੀ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਟੋਉਟ',
							'ਬਾਬਾ',
							'ਹੇਟਰ',
							'ਕੀਅਕ',
							'ਤੋਬਾ',
							'ਅਮਸ਼ੀਰ',
							'ਬ੍ਰਾਮਹਟ',
							'ਬਾਰਾਮੂਡਾ',
							'ਬਾਸ਼ਨਸ',
							'ਪਾਓਨਾ',
							'ਅਪੈਪ',
							'ਮੈਸਰਾ',
							'ਨੇਜ਼ੀ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਟੋਉਟ',
							'ਬਾਬਾ',
							'ਹੇਟਰ',
							'ਕੀਅਕ',
							'ਤੋਬਾ',
							'ਅਮਸ਼ੀਰ',
							'ਬ੍ਰਾਮਹਟ',
							'ਬਾਰਾਮੂਡਾ',
							'ਬਾਸ਼ਨਸ',
							'ਪਾਓਨਾ',
							'ਅਪੈਪ',
							'ਮੈਸਰਾ',
							'ਨੇਜ਼ੀ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਟੋਉਟ',
							'ਬਾਬਾ',
							'ਹੇਟਰ',
							'ਕੀਅਕ',
							'ਤੋਬਾ',
							'ਅਮਸ਼ੀਰ',
							'ਬ੍ਰਾਮਹਟ',
							'ਬਾਰਾਮੂਡਾ',
							'ਬਾਸ਼ਨਸ',
							'ਪਾਓਨਾ',
							'ਅਪੈਪ',
							'ਮੈਸਰਾ',
							'ਨੇਜ਼ੀ'
						],
						leap => [
							
						],
					},
				},
			},
			'ethiopic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਮੇਸਕੇਰੇਮ',
							'ਟੇਕੇਮਟ',
							'ਹੈਡਰ',
							'ਤਾਹਸਸ',
							'ਟਰ',
							'ਯਕੇਟਿਤ',
							'ਮੇਗਾਬਿਟ',
							'ਮਿਆਜਿਆ',
							'ਜੇਨਬੋਟ',
							'ਸੀਨ',
							'ਹਮਲੇ',
							'ਨੇਹਾਸੇ',
							'ਪਾਗੂਮੇਨ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਮੇਸਕੇਰੇਮ',
							'ਟੇਕੇਮਟ',
							'ਹੈਡਰ',
							'ਤਾਹਸਸ',
							'ਟਰ',
							'ਯਕੇਟਿਤ',
							'ਮੇਗਾਬਿਟ',
							'ਮਿਆਜਿਆ',
							'ਜੇਨਬੋਟ',
							'ਸੀਨ',
							'ਹਮਲੇ',
							'ਨੇਹਾਸੇ',
							'ਪਾਗੂਮੇਨ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਮੇਸਕੇਰੇਮ',
							'ਟੇਕੇਮਟ',
							'ਹੈਡਰ',
							'ਤਾਹਸਸ',
							'ਟਰ',
							'ਯਕੇਟਿਤ',
							'ਮੇਗਾਬਿਟ',
							'ਮਿਆਜਿਆ',
							'ਜੇਨਬੋਟ',
							'ਸੀਨ',
							'ਹਮਲੇ',
							'ਨੇਹਾਸੇ',
							'ਪਾਗੂਮੇਨ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਮੇਸਕੇਰੇਮ',
							'ਟੇਕੇਮਟ',
							'ਹੈਡਰ',
							'ਤਾਹਸਸ',
							'ਟਰ',
							'ਯਕੇਟਿਤ',
							'ਮੇਗਾਬਿਟ',
							'ਮਿਆਜਿਆ',
							'ਜੇਨਬੋਟ',
							'ਸੀਨ',
							'ਹਮਲੇ',
							'ਨੇਹਾਸੇ',
							'Pagumen'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਜਨ',
							'ਫ਼ਰ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾ',
							'ਅਗ',
							'ਸਤੰ',
							'ਅਕਤੂ',
							'ਨਵੰ',
							'ਦਸੰ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ਜ',
							'ਫ਼',
							'ਮਾ',
							'ਅ',
							'ਮ',
							'ਜੂ',
							'ਜੁ',
							'ਅ',
							'ਸ',
							'ਅ',
							'ਨ',
							'ਦ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਜਨ',
							'ਫ਼ਰ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾ',
							'ਅਗ',
							'ਸਤੰ',
							'ਅਕਤੂ',
							'ਨਵੰ',
							'ਦਸੰ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'ਜ',
							'ਫ਼',
							'ਮਾ',
							'ਅ',
							'ਮ',
							'ਜੂ',
							'ਜੁ',
							'ਅ',
							'ਸ',
							'ਅ',
							'ਨ',
							'ਦ'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਜਨਵਰੀ',
							'ਫ਼ਰਵਰੀ',
							'ਮਾਰਚ',
							'ਅਪ੍ਰੈਲ',
							'ਮਈ',
							'ਜੂਨ',
							'ਜੁਲਾਈ',
							'ਅਗਸਤ',
							'ਸਤੰਬਰ',
							'ਅਕਤੂਬਰ',
							'ਨਵੰਬਰ',
							'ਦਸੰਬਰ'
						],
						leap => [
							
						],
					},
				},
			},
			'hebrew' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਤਿਸ਼ਰੀ',
							'ਹੇਸ਼ਵਨ',
							'ਕਿਸਲੇਵ',
							'ਟੇਵਟ',
							'ਸ਼ੇਵਟ',
							'ਅਦਰ I',
							'ਅਦਰ',
							'ਨਿਸਾਨ',
							'ਅਇਯਰ',
							'ਸਿਵਾਨ',
							'ਤਾਮੁਜ਼',
							'ਅਵ',
							'ਏਲੁਲ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ਅਦਰ II'
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'7'
						],
					},
					wide => {
						nonleap => [
							'ਤਿਸ਼ਰੀ',
							'ਹੇਸ਼ਵਨ',
							'ਕਿਸਲੇਵ',
							'ਟੇਵਟ',
							'ਸ਼ੇਵਟ',
							'ਅਦਰ I',
							'ਅਦਰ',
							'ਨਿਸਾਨ',
							'ਅਇਯਰ',
							'ਸਿਵਾਨ',
							'ਤਾਮੁਜ਼',
							'ਅਵ',
							'ਏਲੁਲ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ਅਦਰ II'
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਤਿਸ਼ਰੀ',
							'ਹੇਸ਼ਵਨ',
							'ਕਿਸਲੇਵ',
							'ਟੇਵਟ',
							'ਸ਼ੇਵਟ',
							'ਅਦਰ I',
							'ਅਦਰ',
							'ਨਿਸਾਨ',
							'ਅਇਯਰ',
							'ਸਿਵਾਨ',
							'ਤਾਮੁਜ਼',
							'Av',
							'Elul'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ਅਦਰ II'
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'7'
						],
					},
					wide => {
						nonleap => [
							'ਤਿਸ਼ਰੀ',
							'ਹੇਸ਼ਵਨ',
							'ਕਿਸਲੇਵ',
							'ਟੇਵਟ',
							'ਸ਼ੇਵਟ',
							'ਅਦਰ I',
							'ਅਦਰ',
							'ਨਿਸਾਨ',
							'ਅਇਯਰ',
							'ਸਿਵਾਨ',
							'ਤਾਮੁਜ਼',
							'ਅਵ',
							'ਏਲੁਲ'
						],
						leap => [
							'',
							'',
							'',
							'',
							'',
							'',
							'ਅਦਰ II'
						],
					},
				},
			},
			'indian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'੧',
							'੨',
							'੩',
							'੪',
							'੫',
							'੬',
							'੭',
							'੮',
							'੯',
							'੧੦',
							'੧੧',
							'੧੨'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'੧',
							'੨',
							'੩',
							'੪',
							'੫',
							'੬',
							'੭',
							'੮',
							'੯',
							'੧੦',
							'੧੧',
							'੧੨'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਚੇਤ',
							'ਵੈਸਾਖ',
							'ਜੇਠ',
							'ਹਾੜ',
							'ਸਾਉਣ',
							'ਭਾਦੋਂ',
							'ਅੱਸੂ',
							'ਕੱਤਕ',
							'ਮੱਘਰ',
							'ਪੋਹ',
							'ਮਾਘ',
							'ਫੱਗਣ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਮੁਹੱ.',
							'ਸਫ.',
							'ਰਬ. I',
							'ਰਬ. II',
							'ਜੁਮ. I',
							'ਜੁਮ. II',
							'ਰਾਜ.',
							'ਸ਼ਾ.',
							'ਰਾਮ.',
							'ਸ਼ਅ.',
							'ਦੂ-ਅਲ-ਕੀ.',
							'ਦੂ-ਅਲ-ਹਿ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਮੁਹੱਰਮ',
							'ਸਫਰ',
							'ਰਬੀ ʻ I',
							'ਰਬੀ ʻ II',
							'ਜੁਮਾਦਾ I',
							'ਜੁਮਾਦਾ II',
							'ਰਜਬ',
							'ਸ਼ਬਾਨ',
							'ਰਮਜ਼ਾਨ',
							'ਸ਼ਵਾਲ',
							'ਦੂ-ਅਲ-ਕੀਦਾਹ',
							'ਦੂ-ਅਲ-ਹਿਜ੍ਹਾ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਮੁਹੱ.',
							'ਸਫ.',
							'ਰਬ. I',
							'ਰਬ. II',
							'ਜੁਮ. I',
							'ਜੁਮ. II',
							'ਰਾਜ.',
							'ਸ਼ਾ.',
							'ਰਾਮ.',
							'ਸ਼ਅ.',
							'ਦੂ-ਅਲ-ਕੀ.',
							'ਦੂ-ਅਲ-ਹਿ.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਮੁਹੱਰਮ',
							'ਸਫਰ',
							'ਰਬੀʻ I',
							'ਰਬੀʻ II',
							'ਜੁਮਾਦਾ I',
							'ਜੁਮਾਦਾ II',
							'ਰਜਬ',
							'ਸ਼ਬਾਨ',
							'ਰਮਜ਼ਾਨ',
							'ਸ਼ਵਾਲ',
							'ਦੂ-ਅਲ-ਕੀਦਾਹ',
							'ਦੂ-ਅਲ-ਹਿਜ੍ਹਾ'
						],
						leap => [
							
						],
					},
				},
			},
			'persian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ਫਾਰਵਰਡੀਨ',
							'ਔਰਡਾਈਬਹੈਸ਼ਟ',
							'ਖੋਡਰਡ',
							'ਟਿਰ',
							'ਮੋਰਡਾਦ',
							'ਸ਼ਰਾਇਵਰ',
							'ਮੇਹਰ',
							'ਅਬਾਨ',
							'ਅਜ਼ਾਰ',
							'ਡੇਅ',
							'ਬਾਹਮਨ',
							'ਐਸਫੰਡ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਫਾਰਵਰਡੀਨ',
							'ਔਰਡਾਈਬਹੈਸ਼ਟ',
							'ਖੋਡਰਡ',
							'ਟਿਰ',
							'ਮੋਰਡਾਦ',
							'ਸ਼ਰਾਇਵਰ',
							'ਮੇਹਰ',
							'ਅਬਾਨ',
							'ਅਜ਼ਾਰ',
							'ਡੇਅ',
							'ਬਾਹਮਨ',
							'ਐਸਫੰਡ'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'ਫਾਰਵਰਡੀਨ',
							'ਔਰਡਾਈਬਹੈਸ਼ਟ',
							'ਖੋਡਰਡ',
							'ਟਿਰ',
							'ਮੋਰਡਾਦ',
							'ਸ਼ਰਾਇਵਰ',
							'ਮੇਹਰ',
							'ਅਬਾਨ',
							'ਅਜ਼ਾਰ',
							'ਡੇਅ',
							'ਬਾਹਮਨ',
							'ਐਸਫੰਡ'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ਫਾਰਵਰਡੀਨ',
							'ਔਰਡਾਈਬਹੈਸ਼ਟ',
							'ਖੋਡਰਡ',
							'ਟਿਰ',
							'ਮੋਰਡਾਦ',
							'ਸ਼ਰਾਇਵਰ',
							'ਮੇਹਰ',
							'ਅਬਾਨ',
							'ਅਜ਼ਾਰ',
							'ਡੇਅ',
							'ਬਾਹਮਨ',
							'ਐਸਫੰਡ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗਲ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕਰ',
						sat => 'ਸ਼ਨਿੱਚਰ',
						sun => 'ਐਤ'
					},
					narrow => {
						mon => 'ਸੋ',
						tue => 'ਮੰ',
						wed => 'ਬੁੱ',
						thu => 'ਵੀ',
						fri => 'ਸ਼ੁੱ',
						sat => 'ਸ਼',
						sun => 'ਐ'
					},
					short => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕ',
						sat => 'ਸ਼ਨਿੱ',
						sun => 'ਐਤ'
					},
					wide => {
						mon => 'ਸੋਮਵਾਰ',
						tue => 'ਮੰਗਲਵਾਰ',
						wed => 'ਬੁੱਧਵਾਰ',
						thu => 'ਵੀਰਵਾਰ',
						fri => 'ਸ਼ੁੱਕਰਵਾਰ',
						sat => 'ਸ਼ਨਿੱਚਰਵਾਰ',
						sun => 'ਐਤਵਾਰ'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗਲ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕਰ',
						sat => 'ਸ਼ਨਿੱਚਰ',
						sun => 'ਐਤ'
					},
					narrow => {
						mon => 'ਸੋ',
						tue => 'ਮੰ',
						wed => 'ਬੁੱ',
						thu => 'ਵੀ',
						fri => 'ਸ਼ੁੱ',
						sat => 'ਸ਼',
						sun => 'ਐ'
					},
					short => {
						mon => 'ਸੋਮ',
						tue => 'ਮੰਗ',
						wed => 'ਬੁੱਧ',
						thu => 'ਵੀਰ',
						fri => 'ਸ਼ੁੱਕ',
						sat => 'ਸ਼ਨਿੱ',
						sun => 'ਐਤ'
					},
					wide => {
						mon => 'ਸੋਮਵਾਰ',
						tue => 'ਮੰਗਲਵਾਰ',
						wed => 'ਬੁੱਧਵਾਰ',
						thu => 'ਵੀਰਵਾਰ',
						fri => 'ਸ਼ੁੱਕਰਵਾਰ',
						sat => 'ਸ਼ਨਿੱਚਰਵਾਰ',
						sun => 'ਐਤਵਾਰ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ਤਿਮਾਹੀ1',
						1 => 'ਤਿਮਾਹੀ2',
						2 => 'ਤਿਮਾਹੀ3',
						3 => 'ਤਿਮਾਹੀ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ਪਹਿਲੀ ਤਿਮਾਹੀ',
						1 => 'ਦੂਜੀ ਤਿਮਾਹੀ',
						2 => 'ਤੀਜੀ ਤਿਮਾਹੀ',
						3 => 'ਚੌਥੀ ਤਿਮਾਹੀ'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'ਤਿਮਾਹੀ1',
						1 => 'ਤਿਮਾਹੀ2',
						2 => 'ਤਿਮਾਹੀ3',
						3 => 'ਤਿਮਾਹੀ4'
					},
					narrow => {0 => '1',
						1 => '2',
						2 => '3',
						3 => '4'
					},
					wide => {0 => 'ਪਹਿਲੀ ਤਿਮਾਹੀ',
						1 => 'ਦੂਜੀ ਤਿਮਾਹੀ',
						2 => 'ਤੀਜੀ ਤਿਮਾਹੀ',
						3 => 'ਚੌਥੀ ਤਿਮਾਹੀ'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic-amete-alem') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'hebrew') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'roc') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
			if ($_ eq 'persian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
				}
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 400;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 1200;
					return 'evening1' if $time >= 1600
						&& $time < 2100;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'pm' => q{ਬਾ.ਦੁ.},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'evening1' => q{ਸ਼ਾਮੀਂ},
					'am' => q{ਪੂ.ਦੁ.},
					'morning1' => q{ਸਵੇਰੇ},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'night1' => q{ਰਾਤੀਂ},
				},
				'wide' => {
					'night1' => q{ਰਾਤੀਂ},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'am' => q{ਪੂ.ਦੁ.},
					'morning1' => q{ਸਵੇਰੇ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'pm' => q{ਬਾ.ਦੁ.},
					'evening1' => q{ਸ਼ਾਮੀਂ},
				},
				'narrow' => {
					'evening1' => q{ਸ਼ਾਮੀਂ},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'pm' => q{ਸ਼.},
					'morning1' => q{ਸਵੇਰੇ},
					'am' => q{ਸ.},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'night1' => q{ਰਾਤੀਂ},
				},
			},
			'stand-alone' => {
				'narrow' => {
					'night1' => q{ਰਾਤੀਂ},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'morning1' => q{ਸਵੇਰੇ},
					'am' => q{ਪੂ.ਦੁ.},
					'evening1' => q{ਸ਼ਾਮੀਂ},
					'pm' => q{ਬਾ.ਦੁ.},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
				},
				'wide' => {
					'night1' => q{ਰਾਤ},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'morning1' => q{ਸਵੇਰੇ},
					'am' => q{ਪੂ.ਦੁ.},
					'evening1' => q{ਸ਼ਾਮ},
					'pm' => q{ਬਾ.ਦੁ.},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
				},
				'abbreviated' => {
					'night1' => q{ਰਾਤੀਂ},
					'afternoon1' => q{ਦੁਪਹਿਰੇ},
					'am' => q{ਪੂ.ਦੁ.},
					'morning1' => q{ਸਵੇਰੇ},
					'pm' => q{ਬਾ.ਦੁ.},
					'midnight' => q{ਅੱਧੀ ਰਾਤ},
					'evening1' => q{ਸ਼ਾਮੀਂ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			abbreviated => {
				'0' => 'ਈਸਵੀ ਪੂਰਵ'
			},
			narrow => {
				'0' => 'ਈ. ਪੂ.'
			},
			wide => {
				'0' => 'ਈਸਵੀ ਪੂਰਵ'
			},
		},
		'coptic' => {
			abbreviated => {
				'0' => 'ਕਾਲ0',
				'1' => 'ਕਾਲ1'
			},
			narrow => {
				'0' => 'ਕਾਲ0',
				'1' => 'ਕਾਲ1'
			},
			wide => {
				'0' => 'ਕਾਲ0',
				'1' => 'ਕਾਲ1'
			},
		},
		'ethiopic' => {
			abbreviated => {
				'0' => 'ਕਾਲ0',
				'1' => 'ਕਾਲ1'
			},
			narrow => {
				'0' => 'ਕਾਲ0',
				'1' => 'ਕਾਲ1'
			},
			wide => {
				'0' => 'ਕਾਲ0',
				'1' => 'ਕਾਲ1'
			},
		},
		'ethiopic-amete-alem' => {
			abbreviated => {
				'0' => 'ERA0'
			},
			narrow => {
				'0' => 'ERA0'
			},
			wide => {
				'0' => 'ERA0'
			},
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ਈ. ਪੂ.',
				'1' => 'ਸੰਨ'
			},
			narrow => {
				'0' => 'ਈ.ਪੂ.',
				'1' => 'ਸੰਨ'
			},
			wide => {
				'0' => 'ਈਸਵੀ ਪੂਰਵ',
				'1' => 'ਈਸਵੀ ਸੰਨ'
			},
		},
		'hebrew' => {
			abbreviated => {
				'0' => 'AM'
			},
			narrow => {
				'0' => 'AM'
			},
			wide => {
				'0' => 'AM'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => 'ਸਾਕਾ'
			},
			narrow => {
				'0' => 'ਸਾਕਾ'
			},
			wide => {
				'0' => 'ਸਾਕਾ'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => 'AH'
			},
			narrow => {
				'0' => 'AH'
			},
			wide => {
				'0' => 'AH'
			},
		},
		'persian' => {
			abbreviated => {
				'0' => 'AP'
			},
			narrow => {
				'0' => 'AP'
			},
			wide => {
				'0' => 'AP'
			},
		},
		'roc' => {
			abbreviated => {
				'0' => 'ਆਰ.ਓ.ਸੀ ਤੋਂ ਪਹਿਲਾਂ',
				'1' => 'ਮਿੰਗ'
			},
			narrow => {
				'0' => 'ਆਰ.ਓ.ਸੀ ਤੋਂ ਪਹਿਲਾਂ',
				'1' => 'ਮਿੰਗ'
			},
			wide => {
				'0' => 'ਚੀਨ ਦੇ ਗਣਰਾਜ ਤੋਂ ਪਹਿਲਾਂ',
				'1' => 'ਮਿੰਗ'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'ethiopic-amete-alem' => {
		},
		'generic' => {
			'full' => q{EEEE, dd MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd/MM/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM y},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{d/M/yy},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'ethiopic-amete-alem' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			'full' => q{{0} ਵਿਖੇ {1}},
			'long' => q{{0} ਵਿਖੇ {1}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'ethiopic-amete-alem' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1}, {0}},
			'short' => q{{1}, {0}},
		},
		'hebrew' => {
		},
		'indian' => {
		},
		'islamic' => {
		},
		'persian' => {
		},
		'roc' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM, G y},
			GyMMMEd => q{E d MMM, G y},
			GyMMMd => q{d MMM y},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, dd-MM.},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMW => q{MMM ਦਾ W ਹਫ਼ਤਾ},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			mmss => q{mm:ss},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y ਦਾ w ਹਫ਼ਤਾ},
		},
		'generic' => {
			Bh => q{h B},
			Bhm => q{h:mm B},
			Bhms => q{h:mm:ss B},
			E => q{ccc},
			EBhm => q{E h:mm B},
			EBhms => q{E h:mm:ss B},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{E, d},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{G y},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM y G},
			GyMMMd => q{d MMM,y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d/M},
			MMM => q{LLL},
			MMMEd => q{E, d MMM},
			MMMMd => q{MMMM d},
			MMMd => q{d MMM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yMMM => q{MMM y G},
			yQQQ => q{QQQ y G},
			yyyy => q{y G},
			yyyyM => q{M/y GGGGG},
			yyyyMEd => q{E, d/M/y GGGGG},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM y G},
			yyyyMd => q{d/M/y GGGGG},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y},
				d => q{E, d MMM – E, d MMM y},
				y => q{E, d MMM y – E, d MMM y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM y},
				d => q{d–d MMM y},
				y => q{d MMM y – d MMM y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{MM–MM},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d – d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y – y G},
			},
			yM => {
				M => q{M/y – M/y GGGGG},
				y => q{M/y – M/y GGGGG},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y GGGGG},
				d => q{E, d/M/y – E, d/M/y GGGGG},
				y => q{E, d/M/y – E, d/M/y GGGGG},
			},
			yMMM => {
				M => q{MMM – MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM y G},
				d => q{E, d MMM – E, d MMM y G},
				y => q{E, d MMM y – E, d MMM y G},
			},
			yMMMM => {
				M => q{MMMM – MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM y G},
				d => q{d – d, MMM y G},
				y => q{d, MMM y – d, MMM y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y GGGGG},
				d => q{d/M/y – d/M/y GGGGG},
				y => q{d/M/y – d/M/y GGGGG},
			},
		},
		'islamic' => {
			fallback => '{0} – {1}',
		},
		'buddhist' => {
			fallback => '{0} – {1}',
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} ਵੇਲਾ),
		regionFormat => q({0} ਪ੍ਰਕਾਸ਼ ਵੇਲਾ),
		regionFormat => q({0} ਮਿਆਰੀ ਵੇਲਾ),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q#ਅਫ਼ਗਾਨਿਸਤਾਨ ਵੇਲਾ#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#ਅਬੀਦਜਾਨ#,
		},
		'Africa/Accra' => {
			exemplarCity => q#ਅੱਕਰਾ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#ਐਡਿਸ ਅਬਾਬਾ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#ਅਲਜੀਅਰਸ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#ਅਸਮਾਰਾ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ਬਮੇਕੋ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ਬਾਂਗੁਈ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ਬਾਂਜੁਲ#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ਬਿਸਾਉ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ਬਲੰਟਾਇਰ#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ਬ੍ਰਾਜ਼ਾਵਿਲੇ#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ਬੁਜੁੰਬੁਰਾ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ਕੈਰੋ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ਕਾਸਾਬਲਾਂਕਾ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ਸੀਊਟਾ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ਕੋਨੇਕਰੀ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ਡਕਾਰ#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ਦਾਰ ਏਸ ਸਲਾਮ#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ਜ਼ੀਬੂਤੀ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ਡੌਆਲਾ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ਅਲ ਅਯੂਨ#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ਫਰੀਟਾਉਨ#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ਗਾਬੋਰੋਨ#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ਹਰਾਰੇ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ਜੋਹਨਸਬਰਗ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ਜੂਬਾ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ਕੰਪਾਲਾ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ਖਾਰਟੌਮ#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ਕਿਗਾਲੀ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ਕਿੰਸ਼ਾਸਾ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ਲਾਗੋਸ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ਲਿਬਰਵਿਲੇ#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ਲੋਮ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ਲੁਆਂਡਾ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ਲੁਬੁਮਬਾਸ਼ੀ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ਲੁਸਾਕਾ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ਮਾਲਾਬੋ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ਮਾਪੁਟੋ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ਮਸੇਰੂ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ਏਮਬਾਬਾਨੇ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ਮੋਗਾਦਿਸ਼ੂ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ਮੋਨਰੋਵੀਆ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ਨੈਰੋਬੀ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ਐਂਜਾਮੇਨਾ#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ਨਿਆਮੇ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ਨੌਆਕਸ਼ਾਟ#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ਉਆਗਾਡੂਗੂ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ਪੋਰਟੋ-ਨੋਵੋ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ਸਾਓ ਟੋਮ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ਤ੍ਰਿਪੋਲੀ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ਟੁਨਿਸ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ਵਿੰਡਹੋਇਕ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#ਕੇਂਦਰੀ ਅਫਰੀਕਾ ਵੇਲਾ#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#ਪੂਰਬੀ ਅਫਰੀਕਾ ਵੇਲਾ#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#ਦੱਖਣੀ ਅਫ਼ਰੀਕਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#ਪੱਛਮੀ ਅਫਰੀਕਾ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੱਛਮੀ ਅਫਰੀਕਾ ਵੇਲਾ#,
				'standard' => q#ਪੱਛਮੀ ਅਫਰੀਕਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#ਅਲਾਸਕਾ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਅਲਾਸਕਾ ਵੇਲਾ#,
				'standard' => q#ਅਲਾਸਕਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#ਅਲਮਾਟੀ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ#,
				'generic' => q#ਅਲਮਾਟੀ ਸਮਾਂ#,
				'standard' => q#ਅਲਮਾਟੀ ਮਿਆਰੀ ਸਮਾਂ#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#ਅਮੇਜ਼ਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਅਮੇਜ਼ਨ ਵੇਲਾ#,
				'standard' => q#ਅਮੇਜ਼ਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#ਏਡਕ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#ਐਂਕਰੇਜ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#ਅੰਗੁਇਲਾ#,
		},
		'America/Antigua' => {
			exemplarCity => q#ਐਂਟੀਗੁਆ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#ਆਰਗੁਆਇਨਾ#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ਲਾ ਰਿਉਜਾ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ਰਿਓ ਗੈਲੇਗੋਸ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ਸਾਲਟਾ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ਸੇਨ ਜੁਆਨ#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ਸੇਨ ਲੂਈਸ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ਟੁਕੁਮਨ#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ਉਸ਼ਵਾਇਆ#,
		},
		'America/Aruba' => {
			exemplarCity => q#ਅਰੂਬਾ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#ਐਸੁੰਕੀਅਨ#,
		},
		'America/Bahia' => {
			exemplarCity => q#ਬਾਹੀਆ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ਬਾਹੀਆ ਬਾਂਦੇਰਸ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ਬਾਰਬਾਡੋਸ#,
		},
		'America/Belem' => {
			exemplarCity => q#ਬੇਲੇਮ#,
		},
		'America/Belize' => {
			exemplarCity => q#ਬੇਲੀਜ਼#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ਬਲੈਂਕ-ਸੈਬਲਾਨ#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ਬੋਆ ਵਿਸਟਾ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ਬੋਗੋਟਾ#,
		},
		'America/Boise' => {
			exemplarCity => q#ਬੋਇਸ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ਬੂਈਨਸ ਆਇਰਸ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ਕੈਮਬ੍ਰਿਜ ਬੇ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ਕੈਂਪੋ ਗ੍ਰਾਂਡੇ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ਕੈਨਕੁਨ#,
		},
		'America/Caracas' => {
			exemplarCity => q#ਕੈਰਾਕਾਸ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ਕੈਟਾਮਾਰਕਾ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ਕੇਯੇਨੇ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ਕੇਮੈਨ#,
		},
		'America/Chicago' => {
			exemplarCity => q#ਸ਼ਿਕਾਗੋ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ਚਿਹੁਆਹੁਆ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#ਐਟੀਕੋਕਨ#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ਕੋਰਡੋਬਾ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ਕੋਸਟਾ ਰੀਕਾ#,
		},
		'America/Creston' => {
			exemplarCity => q#ਕ੍ਰੈਸਟਨ#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ਕਯੁਏਬਾ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ਕੁਰਾਕਾਓ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ਡੈਨਮਾਰਕਸ਼ੌਨ#,
		},
		'America/Dawson' => {
			exemplarCity => q#ਡੌਅਸਨ#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ਡੌਅਸਨ ਕ੍ਰੀਕ#,
		},
		'America/Denver' => {
			exemplarCity => q#ਡੇਨਵਰ#,
		},
		'America/Detroit' => {
			exemplarCity => q#ਡਿਟਰੋਇਟ#,
		},
		'America/Dominica' => {
			exemplarCity => q#ਡੋਮੀਨਿਕਾ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ਐਡਮੋਂਟਨ#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ਯੁਰੂਨੀਪੇ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ਅਲ ਸਲਵਾਡੋਰ#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ਫੋਰਟ ਨੈਲਸਨ#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ਫੋਰਟਾਲੇਜ਼ਾ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ਗਲੇਸ ਬੇ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ਨੂਕ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ਗੂਜ਼ ਬੇ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ਗਰਾਂਡ ਤੁਰਕ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ਗ੍ਰੇਨਾਡਾ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ਗੁਆਡੇਲੋਪ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ਗੁਆਟੇਮਾਲਾ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ਗੁਆਇਕਵਿਲ#,
		},
		'America/Guyana' => {
			exemplarCity => q#ਗੁਆਨਾ#,
		},
		'America/Halifax' => {
			exemplarCity => q#ਹੈਲੀਫੈਕਸ#,
		},
		'America/Havana' => {
			exemplarCity => q#ਹਵਾਨਾ#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ਹਰਮੋਸਿੱਲੋ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ਨੋਕਸ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ਮਾਰੇਂਗੋ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ਪੀਟਰਸਬਰਗ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ਟੈਲ ਸਿਟੀ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ਵੇਵੇ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ਵਿੰਸੇਨੇਸ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ਵਿਨਮੈਕ, ਇੰਡੀਆਨਾ#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ਇੰਡੀਆਨਾਪੋਲਿਸ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ਇਨੁਵਿਕ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ਇਕਾਲੁਈਟ#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ਜਮਾਇਕਾ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ਜੂਜੁਏ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ਜਯੂਨੋ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ਮੋਂਟੀਸੈਲੋ, ਕੈਂਟਕੀ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ਕ੍ਰਾਲੇਂਦਿਜਕ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ਲਾ ਪਾਜ਼#,
		},
		'America/Lima' => {
			exemplarCity => q#ਲੀਮਾ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ਲਾਸ ਐਂਜਲਸ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ਲੁਈਸਵਿਲੇ#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#ਲੋਅਰ ਪ੍ਰਿੰਸ’ਸ ਕਵਾਰਟਰ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ਮੈਸੀਓ#,
		},
		'America/Managua' => {
			exemplarCity => q#ਮਨਾਗੁਆ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ਮਨੌਸ#,
		},
		'America/Marigot' => {
			exemplarCity => q#ਮੈਰੀਗੋਟ#,
		},
		'America/Martinique' => {
			exemplarCity => q#ਮਾਰਟੀਨਿਕ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ਮਾਟਾਮੋਰਸ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ਮਜ਼ੇਤਲਾਨ#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ਮੈਂਡੋਜ਼ਾ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ਮੈਨੋਮਿਨੀ#,
		},
		'America/Merida' => {
			exemplarCity => q#ਮੇਰਿਡਾ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#ਮੇਟਲਾਕਾਟਲਾ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ਮੈਕਸੀਕੋ ਸਿਟੀ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ਮਿਕੇਲਨ#,
		},
		'America/Moncton' => {
			exemplarCity => q#ਮੋਂਕਟਨ#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ਮੋਨਟੇਰੀ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ਮੋਂਟੇਵੀਡੀਓ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ਮੋਂਟਸੇਰਾਤ#,
		},
		'America/Nassau' => {
			exemplarCity => q#ਨਾਸਾਓ#,
		},
		'America/New_York' => {
			exemplarCity => q#ਨਿਊ ਯਾਰਕ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ਨਿਪਿਗੌਨ#,
		},
		'America/Nome' => {
			exemplarCity => q#ਨੋਮ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ਨੌਰੋਨਹਾ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ਬਿਉਲਾ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#ਸੇਂਟਰ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#ਨਿਊ ਸਲੇਮ, ਉੱਤਰੀ ਡਕੋਟਾ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ਓਜੀਨਾਗਾ#,
		},
		'America/Panama' => {
			exemplarCity => q#ਪਨਾਮਾ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ਪੈਂਗਨਿਰਟੰਗ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ਪੈਰਾਮਰੀਬੋ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ਫਿਨਿਕਸ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ਪੋਰਟ-ਔ-ਪ੍ਰਿੰਸ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#ਪੋਰਟ ਔਫ ਸਪੇਨ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ਪੋਰਟੋ ਵੇਲ੍ਹੋ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ਪਿਊਰਟੋ ਰੀਕੋ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#ਪੰਟਾ ਅਰੇਨਸ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ਰੇਨੀ ਰਿਵਰ#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ਰੈਂਕਿਨ ਇਨਲੈਟ#,
		},
		'America/Recife' => {
			exemplarCity => q#ਰੇਸੀਫੇ#,
		},
		'America/Regina' => {
			exemplarCity => q#ਰੈਜੀਨਾ#,
		},
		'America/Resolute' => {
			exemplarCity => q#ਰੈਜ਼ੋਲਿਊਟ#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ਰੀਓ ਬ੍ਰਾਂਕੋ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ਸੈਂਟਾ ਇਸਾਬੇਲ#,
		},
		'America/Santarem' => {
			exemplarCity => q#ਸੇਂਟਾਰਮ#,
		},
		'America/Santiago' => {
			exemplarCity => q#ਸੇਂਟੀਆਗੋ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ਸੇਂਟੋ ਡੋਮਿੰਗੋ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ਸਾਓ ਪੌਲੋ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ਇੱਟੋਕੋਰਟੂਰਮੀਟ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ਸਿਟਕਾ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ਸੇਂਟ ਬਾਰਥੇਲੇਮੀ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ਸੇਂਟ ਜੌਹਨਸ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ਸੇਂਟ ਕਿਟਸ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ਸੇਂਟ ਲੁਸੀਆ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ਸੇਂਟ ਥੋਮਸ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ਸੇਂਟ ਵਿਨਸੇਂਟ#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#ਸਵਿਫਟ ਕਰੰਟ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ਟੇਗੁਸੀਗਲਪਾ#,
		},
		'America/Thule' => {
			exemplarCity => q#ਥੁਲੇ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ਥੰਡਰ ਬੇ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ਟਿਜੂਆਨਾ#,
		},
		'America/Toronto' => {
			exemplarCity => q#ਟੋਰਾਂਟੋ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ਟੋਰਟੋਲਾ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ਵੈਨਕੂਵਰ#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ਵਾਈਟਹੌਰਸ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ਵਿਨੀਪੈਗ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ਯਕੁਤਤ#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#ਯੈਲੋਨਾਈਫ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਕੇਂਦਰੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਕੇਂਦਰੀ ਵੇਲਾ#,
				'standard' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਕੇਂਦਰੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੂਰਬੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੂਰਬੀ ਵੇਲਾ#,
				'standard' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੂਰਬੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਮਾਉਂਟੇਨ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਮਾਉਂਟੇਨ ਵੇਲਾ#,
				'standard' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਮਾਉਂਟੇਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੈਸਿਫਿਕ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੈਸਿਫਿਕ ਵੇਲਾ#,
				'standard' => q#ਉੱਤਰੀ ਅਮਰੀਕੀ ਪੈਸਿਫਿਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ਕਾਸੇ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ਡੇਵਿਸ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ਡਿਉਮੋਂਟ ਡਿਉਰਵਿਲੇ#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ਮੈਕਕਵੈਰੀ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ਮੌਸਨ#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ਮੈਕਮੁਰਡੋ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ਪਾਮਰ#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ਰੋਥੇਰਾ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ਸਵੋਯਾ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ਟਰੋਲ#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ਵੋਸਟੋਕ#,
		},
		'Apia' => {
			long => {
				'daylight' => q#ਐਪੀਆ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਐਪੀਆ ਵੇਲਾ#,
				'standard' => q#ਐਪੀਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#ਅਕਤਾਉ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ#,
				'generic' => q#ਅਕਤਾਉ ਸਮਾਂ#,
				'standard' => q#ਅਕਤਾਉ ਮਿਆਰੀ ਸਮਾਂ#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#ਅਕਤੋਬ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ#,
				'generic' => q#ਅਕਤੋਬ ਸਮਾਂ#,
				'standard' => q#ਅਕਤੋਬ ਮਿਆਰੀ ਸਮਾਂ#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#ਅਰਬੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਅਰਬੀ ਵੇਲਾ#,
				'standard' => q#ਅਰਬੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ਲੋਂਗਈਅਰਬਾਇਨ#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#ਅਰਜਨਟੀਨਾ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਅਰਜਨਟੀਨਾ ਵੇਲਾ#,
				'standard' => q#ਅਰਜਨਟੀਨਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਵੇਲਾ#,
				'standard' => q#ਪੱਛਮੀ ਅਰਜਨਟੀਨਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#ਅਰਮੀਨੀਆ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਅਰਮੀਨੀਆ ਵੇਲਾ#,
				'standard' => q#ਅਰਮੀਨੀਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ਅਡੇਨ#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#ਅਲਮੇਟੀ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#ਅਮਾਨ#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#ਐਨਾਡਾਇਰ#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#ਅਕਤੌ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#ਅਕਤੋਬੇ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#ਅਸ਼ਗਾਬਾਟ#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#ਏਤੇਰਾਓ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ਬਗਦਾਦ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ਬਹਿਰੀਨ#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ਬਾਕੂ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ਬੈਂਕਾਕ#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ਬਰਨੌਲ#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ਬੈਰੂਤ#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ਬਿਸ਼ਕੇਕ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ਬਰੂਨੇਈ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ਕੋਲਕਾਤਾ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ਚਿਤਾ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ਚੋਇਲਬਾਲਸਨ#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ਕੋਲੰਬੋ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ਡੈਮਸਕਸ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ਢਾਕਾ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ਡਿਲੀ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ਦੁਬਈ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ਦੁਸ਼ਾਂਬੇ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ਫਾਮਾਗੁਸਟਾ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ਗਾਜ਼ਾ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ਹੇਬਰਾਨ#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ਹਾਂਗ ਕਾਂਗ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ਹੋਵਡ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ਇਰਕੁਤਸਕ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ਜਕਾਰਤਾ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ਜਯਾਪੁਰਾ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#ਜੇਰੂਸਲਮ#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ਕਾਬੁਲ#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ਕਮਚਟਕਾ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ਕਰਾਚੀ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ਕਾਠਮਾਂਡੂ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ਖਾਨਡਿਗਾ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ਕਰੈਸਨੇਜਰਸ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ਕੁਆਲਾਲੰਪੁਰ#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ਕੁਚਿੰਗ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ਕੁਵੈਤ#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ਮਕਾਉ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ਮੈਗੇਡਨ#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ਮਕਸਾਰ#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ਮਨੀਲਾ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ਮਸਕਟ#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ਨਿਕੋਸੀਆ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ਨੋਵੋਕੁਜ਼ਨੇਟਸਕ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ਨੋਵੋਸਿਬੀਰਸਕ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ਓਮਸਕ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ਓਰਲ#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ਫਨੋਮ ਪੇਨਹ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ਪੌਂਟੀਆਨਾਕ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ਪਯੋਂਗਯਾਂਗ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ਕਤਰ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ਕਿਜ਼ੀਲੋਰਡਾ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ਰੰਗੂਨ#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ਰਿਆਧ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ਹੋ ਚੀ ਮਿਨ੍ਹ ਸਿਟੀ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ਸਖਲੀਨ#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ਸਮਰਕੰਦ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ਸਿਉਲ#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ਸ਼ੰਘਾਈ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ਸਿੰਗਾਪੁਰ#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ਸਰਿਡਨੀਕੋਲਿਸਕ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ਤੈਪਈ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ਤਾਸ਼ਕੰਦ#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ਟਬਿਲਿਸੀ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ਤੇਹਰਾਨ#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ਥਿੰਫੂ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ਟੋਕੀਓ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ਟੋਮਸਕ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ਉਲਾਨਬਾਤਰ#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ਊਰੂਮਕੀ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ਉਸਤ-ਨੇਰਾ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ਵਾਏਨਟਿਆਨੇ#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ਵਲਾਦੀਵੋਸਤਕ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ਯਕੁਤਸਕ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#ਯਕੇਤਰਿਨਬਰਗ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ਯੇਰੇਵਨ#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#ਅਟਲਾਂਟਿਕ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਅਟਲਾਂਟਿਕ ਵੇਲਾ#,
				'standard' => q#ਅਟਲਾਂਟਿਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#ਅਜੋਰੇਸ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ਬਰਮੂਡਾ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ਕੇਨੇਰੀ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ਕੇਪ ਵਰਡ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ਫੈਰੋ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ਮਡੀਅਰਾ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ਰੇਕਜਾਵਿਕ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ਦੱਖਣੀ ਜਾਰਜੀਆ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ਸੇਂਟ ਹੇਲੇਨਾ#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ਸਟੇਨਲੀ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#ਐਡੀਲੇਡ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ਬ੍ਰਿਸਬੇਨ#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ਬ੍ਰੋਕਨ ਹਿਲ#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ਕਰੀ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ਡਾਰਵਿਨ#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ਯੂਕਲਾ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ਹੋਬਾਰਟ#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ਲਿੰਡੇਮਨ#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ਲੌਰਡ ਹੋਵੇ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ਮੈਲਬੋਰਨ#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ਪਰਥ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ਸਿਡਨੀ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਕੇਂਦਰੀ ਆਸਟ੍ਰੇਲੀਆਈ ਵੇਲਾ#,
				'standard' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪੱਛਮੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪੱਛਮੀ ਵੇਲਾ#,
				'standard' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਕੇਂਦਰੀ ਪੱਛਮੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਪੂਰਬੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਪੂਰਬੀ ਆਸਟ੍ਰੇਲੀਆਈ ਵੇਲਾ#,
				'standard' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਪੂਰਬੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਪੱਛਮੀ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਪੱਛਮੀ ਆਸਟ੍ਰੇਲੀਆਈ ਵੇਲਾ#,
				'standard' => q#ਆਸਟ੍ਰੇਲੀਆਈ ਪੱਛਮੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#ਅਜ਼ਰਬਾਈਜਾਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਅਜ਼ਰਬਾਈਜਾਨ ਵੇਲਾ#,
				'standard' => q#ਅਜ਼ਰਬਾਈਜਾਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#ਅਜੋਰੇਸ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਅਜੋਰੇਸ ਵੇਲਾ#,
				'standard' => q#ਅਜੋਰੇਸ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#ਬੰਗਲਾਦੇਸ਼ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਬੰਗਲਾਦੇਸ਼ ਵੇਲਾ#,
				'standard' => q#ਬੰਗਲਾਦੇਸ਼ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#ਭੂਟਾਨ ਵੇਲਾ#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#ਬੋਲੀਵੀਆ ਵੇਲਾ#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#ਬ੍ਰਾਜ਼ੀਲੀਆ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਬ੍ਰਾਜ਼ੀਲੀਆ ਵੇਲਾ#,
				'standard' => q#ਬ੍ਰਾਜ਼ੀਲੀਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#ਬਰੂਨੇਈ ਦਾਰੂਸਲਾਮ ਵੇਲਾ#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#ਕੇਪ ਵਰਡ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਕੇਪ ਵਰਡ ਵੇਲਾ#,
				'standard' => q#ਕੇਪ ਵਰਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Casey' => {
			long => {
				'standard' => q#ਕੇਸੀ ਸਮਾਂ#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#ਚਾਮੋਰੋ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#ਚੈਥਮ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਚੈਥਮ ਵੇਲਾ#,
				'standard' => q#ਚੈਥਮ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#ਚਿਲੀ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਚਿਲੀ ਵੇਲਾ#,
				'standard' => q#ਚਿਲੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#ਚੀਨ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਚੀਨ ਵੇਲਾ#,
				'standard' => q#ਚੀਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#ਚੌਇਬਾਲਸਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਚੌਇਬਾਲਸਨ ਵੇਲਾ#,
				'standard' => q#ਚੌਇਬਾਲਸਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#ਕ੍ਰਿਸਮਸ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#ਕੋਕਸ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#ਕੋਲੰਬੀਆ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਕੋਲੰਬੀਆ ਵੇਲਾ#,
				'standard' => q#ਕੋਲੰਬੀਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#ਕੁੱਕ ਆਈਲੈਂਡ ਅੱਧ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਕੁੱਕ ਆਈਲੈਂਡ ਵੇਲਾ#,
				'standard' => q#ਕੁੱਕ ਆਈਲੈਂਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#ਕਿਊਬਾ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਕਿਊਬਾ ਵੇਲਾ#,
				'standard' => q#ਕਿਊਬਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#ਡੇਵਿਸ ਵੇਲਾ#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#ਡਿਉਮੋਂਟ ਡਿਉਰਵਿਲੇ ਵੇਲਾ#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#ਪੂਰਬੀ ਤਿਮੂਰ ਵੇਲਾ#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#ਈਸਟਰ ਆਈਲੈਂਡ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਈਸਟਰ ਆਈਲੈਂਡ ਵੇਲਾ#,
				'standard' => q#ਈਸਟਰ ਆਈਲੈਂਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#ਇਕਵੇਡੋਰ ਵੇਲਾ#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#ਕੋਔਰਡੀਨੇਟੇਡ ਵਿਆਪਕ ਵੇਲਾ#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ਅਣਪਛਾਤਾ ਸ਼ਹਿਰ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#ਐਮਸਟਰਡਮ#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#ਅੰਡੋਰਾ#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#ਆਸਟ੍ਰਾਖਾਨ#,
		},
		'Europe/Athens' => {
			exemplarCity => q#ਏਥਨਸ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ਬੈਲਗ੍ਰੇਡ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#ਬਰਲਿਨ#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ਬ੍ਰਾਟਿਸਲਾਵਾ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ਬਰੱਸਲਜ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ਬੂਕਾਰੈਸਟ#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ਬੁਡਾਪੈਸਟ#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ਬੁਸਿੰਜੇਨ#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ਚਿਸਿਨੌ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ਕੋਪਨਹੇਗਨ#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ਡਬਲਿਨ#,
			long => {
				'daylight' => q#ਆਇਰਿਸ਼ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ਜਿਬਰਾਲਟਰ#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ਗਰਨਜੀ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ਹੇਲਸਿੰਕੀ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#ਆਇਲ ਆਫ ਮੈਨ#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ਇਸਤਾਂਬੁਲ#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ਜਰਸੀ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ਕਲੀਨਿੰਗ੍ਰੇਡ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ਕੀਵ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#ਕੀਰੋਵ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ਲਿਸਬਨ#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ਲਜੁਬਲਜਾਨਾ#,
		},
		'Europe/London' => {
			exemplarCity => q#ਲੰਡਨ#,
			long => {
				'daylight' => q#ਬ੍ਰਿਟਿਸ਼ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ਲਕਜ਼ਮਬਰਗ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ਮੈਡ੍ਰਿਡ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ਮਾਲਟਾ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ਮਾਰੀਏਹਾਮੇਨ#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ਮਿੰਸਕ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ਮੋਨਾਕੋ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ਮਾਸਕੋ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ਓਸਲੋ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ਪੈਰਿਸ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ਪੋਡਗੋਰੀਕਾ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ਪ੍ਰਾਗ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ਰਿਗਾ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ਰੋਮ#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ਸਮਾਰਾ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ਸੈਨ ਮਰੀਨੋ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ਸਾਰਾਜੇਵੋ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ਸੈਰਾਟੋਵ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ਸਿਮਫਰੋਪੋਲ#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ਸਕੋਪਜੇ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ਸੋਫੀਆ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ਸਟਾਕਹੋਮ#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ਟੱਲਿਨ#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ਤਿਰਾਨੇ#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ਯੁਲਿਆਨੋਸਕ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ਉਜ਼ਗੋਰੋਡ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ਵਾਡੁਜ਼#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ਵੈਟਿਕਨ#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ਵਿਆਨਾ#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ਵਿਲਨਿਅਸ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ਵੋਲਗੋਗ੍ਰੇਡ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ਵਾਰਸਾਅ#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ਜ਼ਗਰੇਬ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ਜਪੋਰੋਜ਼ਾਏ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ਜਿਊਰਿਖ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#ਮੱਧ ਯੂਰਪੀ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਮੱਧ ਯੂਰਪੀ ਵੇਲਾ#,
				'standard' => q#ਮੱਧ ਯੂਰਪੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#ਪੂਰਬੀ ਯੂਰਪੀ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੂਰਬੀ ਯੂਰਪੀ ਵੇਲਾ#,
				'standard' => q#ਪੂਰਬੀ ਯੂਰਪੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#ਹੋਰ-ਪੂਰਬੀ ਯੂਰਪੀ ਵੇਲਾ#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#ਪੱਛਮੀ ਯੂਰਪੀ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੱਛਮੀ ਯੂਰਪੀ ਵੇਲਾ#,
				'standard' => q#ਪੱਛਮੀ ਯੂਰਪੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਵੇਲਾ#,
				'standard' => q#ਫ਼ਾਕਲੈਂਡ ਆਈਲੈਂਡਸ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#ਫ਼ਿਜ਼ੀ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਫ਼ਿਜ਼ੀ ਵੇਲਾ#,
				'standard' => q#ਫ਼ਿਜ਼ੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#ਫ੍ਰੈਂਚ ਗੁਏਨਾ ਵੇਲਾ#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#ਫ੍ਰੈਂਚ ਦੱਖਣੀ ਅਤੇ ਐਂਟਾਰਟਿਕ ਵੇਲਾ#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ਗ੍ਰੀਨਵਿਚ ਮੀਨ ਵੇਲਾ#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#ਗਲਾਪਾਗੋਸ ਵੇਲਾ#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#ਗੈਂਬੀਅਰ ਵੇਲਾ#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#ਜਾਰਜੀਆ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਜਾਰਜੀਆ ਵੇਲਾ#,
				'standard' => q#ਜਾਰਜੀਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#ਗਿਲਬਰਟ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਵੇਲਾ#,
				'standard' => q#ਪੂਰਬੀ ਗ੍ਰੀਨਲੈਂਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਵੇਲਾ#,
				'standard' => q#ਪੱਛਮੀ ਗ੍ਰੀਨਲੈਂਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#ਗੁਆਮ ਸਮਾਂ#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#ਖਾੜੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#ਗੁਯਾਨਾ ਵੇਲਾ#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਵੇਲਾ#,
				'standard' => q#ਹਵਾਈ-ਅਲੇਯੂਸ਼ਿਅਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#ਹਾਂਗ ਕਾਂਗ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਹਾਂਗ ਕਾਂਗ ਵੇਲਾ#,
				'standard' => q#ਹਾਂਗ ਕਾਂਗ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#ਹੋਵਡ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਹੋਵਡ ਵੇਲਾ#,
				'standard' => q#ਹੋਵਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'India' => {
			long => {
				'standard' => q#ਭਾਰਤੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#ਅੰਟਾਨਨੇਰਿਵੋ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ਚਾਗੋਸ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ਕ੍ਰਿਸਮਸ#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ਕੋਕੋਜ਼#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ਕੋਮੋਰੋ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ਕਰਗਯੂਲੇਨ#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ਮਾਹੇ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ਮਾਲਦੀਵ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ਮੌਰਿਸ਼ਸ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ਮਾਯੋਟੀ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ਰਿਯੂਨੀਅਨ#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#ਹਿੰਦ ਮਹਾਂਸਾਗਰ ਵੇਲਾ#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#ਇੰਡੋਚਾਈਨਾ ਵੇਲਾ#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#ਮੱਧ ਇੰਡੋਨੇਸ਼ੀਆਈ ਵੇਲਾ#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#ਪੂਰਬੀ ਇੰਡੋਨੇਸ਼ੀਆ ਵੇਲਾ#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#ਪੱਛਮੀ ਇੰਡੋਨੇਸ਼ੀਆ ਵੇਲਾ#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#ਈਰਾਨ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਈਰਾਨ ਵੇਲਾ#,
				'standard' => q#ਈਰਾਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ਇਰਕੁਤਸਕ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਇਰਕੁਤਸਕ ਵੇਲਾ#,
				'standard' => q#ਇਰਕੁਤਸਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#ਇਜ਼ਰਾਈਲ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਇਜ਼ਰਾਈਲ ਵੇਲਾ#,
				'standard' => q#ਇਜ਼ਰਾਈਲ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#ਜਪਾਨ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਜਪਾਨ ਵੇਲਾ#,
				'standard' => q#ਜਪਾਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#ਪੂਰਬੀ ਕਜ਼ਾਖ਼ਸਤਾਨ ਵੇਲਾ#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#ਪੱਛਮੀ ਕਜ਼ਾਖ਼ਸਤਾਨ ਵੇਲਾ#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#ਕੋਰੀਆਈ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਕੋਰੀਆਈ ਵੇਲਾ#,
				'standard' => q#ਕੋਰੀਆਈ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#ਕੋਸਰੇ ਵੇਲਾ#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#ਕ੍ਰਾਸਨੋਯਾਰਸਕ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਕ੍ਰਾਸਨੋਯਾਰਸਕ ਵੇਲਾ#,
				'standard' => q#ਕ੍ਰਾਸਨੋਯਾਰਸਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#ਕਿਰਗਿਸਤਾਨ ਵੇਲਾ#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#ਲੰਕਾ ਸਮਾਂ#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#ਲਾਈਨ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#ਲੌਰਡ ਹੋਵੇ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਲੌਰਡ ਹੋਵੇ ਵੇਲਾ#,
				'standard' => q#ਲੌਰਡ ਹੋਵੇ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#ਮਕਾਉ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ#,
				'generic' => q#ਮਕਾਉ ਸਮਾਂ#,
				'standard' => q#ਮਕਾਉ ਮਿਆਰੀ ਸਮਾਂ#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#ਮੈਕਕਵੇਰੀ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#ਮੈਗੇਡਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਮੈਗੇਡਨ ਵੇਲਾ#,
				'standard' => q#ਮੈਗੇਡਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#ਮਲੇਸ਼ੀਆ ਵੇਲਾ#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#ਮਾਲਦੀਵ ਵੇਲਾ#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#ਮਾਰਕਿਸਾਸ ਵੇਲਾ#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#ਮਾਰਸ਼ਲ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#ਮੌਰਿਸ਼ਸ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਮੌਰਿਸ਼ਸ ਵੇਲਾ#,
				'standard' => q#ਮੌਰਿਸ਼ਸ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#ਮੌਸਨ ਵੇਲਾ#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#ਉੱਤਰ ਪੱਛਮੀ ਮੈਕਸੀਕੋ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਉੱਤਰ ਪੱਛਮੀ ਮੈਕਸੀਕੋ ਵੇਲਾ#,
				'standard' => q#ਉੱਤਰ ਪੱਛਮੀ ਮੈਕਸੀਕੋ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#ਮੈਕਸੀਕਨ ਪੈਸਿਫਿਕ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਮੈਕਸੀਕਨ ਪੈਸਿਫਿਕ ਵੇਲਾ#,
				'standard' => q#ਮੈਕਸੀਕਨ ਪੈਸਿਫਿਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#ਉਲਨ ਬਟੋਰ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਉਲਨ ਬਟੋਰ ਵੇਲਾ#,
				'standard' => q#ਉਲਨ ਬਟੋਰ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#ਮਾਸਕੋ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਮਾਸਕੋ ਵੇਲਾ#,
				'standard' => q#ਮਾਸਕੋ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#ਮਿਆਂਮਾਰ ਵੇਲਾ#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#ਨਾਉਰੂ ਵੇਲਾ#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#ਨੇਪਾਲ ਵੇਲਾ#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#ਨਿਊ ਕੈਲੇਡੋਨੀਆ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਨਿਊ ਕੈਲੇਡੋਨੀਆ ਵੇਲਾ#,
				'standard' => q#ਨਿਊ ਕੈਲੇਡੋਨੀਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#ਨਿਊਜ਼ੀਲੈਂਡ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਨਿਊਜ਼ੀਲੈਂਡ ਵੇਲਾ#,
				'standard' => q#ਨਿਊਜ਼ੀਲੈਂਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#ਨਿਊਫਾਉਂਡਲੈਂਡ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਨਿਊਫਾਉਂਡਲੈਂਡ ਵੇਲਾ#,
				'standard' => q#ਨਿਊਫਾਉਂਡਲੈਂਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#ਨੀਊ ਵੇਲਾ#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#ਨੋਰਫੌਕ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਵੇਲਾ#,
				'standard' => q#ਫਰਨਾਂਡੋ ਡੇ ਨੋਰੋਨਹਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#ਉੱਤਰੀ ਮਰਿਆਨਾ ਆਈਲੈਂਡ ਸਮਾਂ#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#ਨੌਵੋਸਿਬੀਰਸਕ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਨੌਵੋਸਿਬੀਰਸਕ ਵੇਲਾ#,
				'standard' => q#ਨੌਵੋਸਿਬੀਰਸਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#ਓਮਸਕ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਓਮਸਕ ਵੇਲਾ#,
				'standard' => q#ਓਮਸਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#ਐਪੀਆ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ਆਕਲੈਂਡ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ਬੋਗਨਵਿਲੇ#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ਚੈਥਮ#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ਈਸਟਰ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ਇਫੇਟ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ਏਂਡਰਬਰੀ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ਫਕਾਉਫੋ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ਫ਼ਿਜੀ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ਫੁਨਾਫੁਟੀ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ਗਲਪੇਗੋਸ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ਗੈਂਬੀਅਰ#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ਗੁਆਡਾਕੇਨਲ#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ਗੁਆਮ#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ਹੋਨੋਲੁਲੂ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ਜੋਨਸਟਨ#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ਕਿਰਿਤਿਮਤੀ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ਕੋਸ੍ਰਾਏ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ਕਵਾਜਾਲੀਨ#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ਮੇਜੁਰੋ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ਮਾਰਕਿਸਾਸ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ਮਿਡਵੇ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ਨਾਉਰੂ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ਨਿਯੂ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ਨੋਰਫੌਕ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ਨੌਮਿਆ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ਪਾਗੋ ਪਾਗੋ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ਪਲਾਉ#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ਪਿਟਕੈਰਨ#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ਪੋਹਨਪੇਈ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ਪੋਰਟ ਮੋਰੇਸਬੀ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ਰਾਰੋਟੋਂਗਾ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ਸੈਪਾਨ#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ਤਹਿਤੀ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ਟਾਰਾਵਾ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ਟੋਂਗਾਟਾਪੂ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ਚੂਕ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ਵੇਕ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ਵਾਲਿਸ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#ਪਾਕਿਸਤਾਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪਾਕਿਸਤਾਨ ਵੇਲਾ#,
				'standard' => q#ਪਾਕਿਸਤਾਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#ਪਲਾਉ ਵੇਲਾ#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#ਪਾਪੂਆ ਨਿਊ ਗਿਨੀ ਵੇਲਾ#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#ਪੈਰਾਗਵੇ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੈਰਾਗਵੇ ਵੇਲਾ#,
				'standard' => q#ਪੈਰਾਗਵੇ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#ਪੇਰੂ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਪੇਰੂ ਵੇਲਾ#,
				'standard' => q#ਪੇਰੂ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#ਫਿਲਿਪੀਨੀ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਫਿਲਿਪੀਨੀ ਵੇਲਾ#,
				'standard' => q#ਫਿਲਿਪੀਨੀ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#ਫਿਨਿਕਸ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਵੇਲਾ#,
				'standard' => q#ਸੈਂਟ ਪੀਅਰੇ ਅਤੇ ਮਿਕੇਲਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#ਪਿਟਕੈਰਨ ਵੇਲਾ#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#ਪੋਨਾਪੇ ਵੇਲਾ#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#ਪਯੋਂਗਯਾਂਗ ਵੇਲਾ#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#ਕਿਜ਼ਲੋਰਡਾ ਗਰਮੀ-ਰੁੱਤ ਸਮਾਂ#,
				'generic' => q#ਕਿਜ਼ਲੋਰਡਾ ਸਮਾਂ#,
				'standard' => q#ਕਿਜ਼ਲੋਰਡਾ ਮਿਆਰੀ ਸਮਾਂ#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#ਰਿਯੂਨੀਅਨ ਵੇਲਾ#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#ਰੋਥੇਰਾ ਵੇਲਾ#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#ਸਖਲੀਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਸਖਲੀਨ ਵੇਲਾ#,
				'standard' => q#ਸਖਲੀਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#ਸਾਮੋਆ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਸਾਮੋਆ ਵੇਲਾ#,
				'standard' => q#ਸਾਮੋਆ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#ਸੇਸ਼ਲਸ ਵੇਲਾ#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#ਸਿੰਗਾਪੁਰ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#ਸੋਲੋਮਨ ਆਈਲੈਂਡਸ ਵੇਲਾ#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#ਦੱਖਣੀ ਜਾਰਜੀਆ ਵੇਲਾ#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#ਸੂਰੀਨਾਮ ਵੇਲਾ#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#ਸਿਓਵਾ ਵੇਲਾ#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#ਤਾਹੀਤੀ ਵੇਲਾ#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#ਤੈਪਈ ਪ੍ਰਕਾਸ਼ ਵੇਲਾ#,
				'generic' => q#ਤੈਪਈ ਵੇਲਾ#,
				'standard' => q#ਤੈਪਈ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#ਤਾਜਿਕਿਸਤਾਨ ਵੇਲਾ#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#ਟੋਕੇਲਾਉ ਵੇਲਾ#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#ਟੋਂਗਾ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਟੋਂਗਾ ਵੇਲਾ#,
				'standard' => q#ਟੋਂਗਾ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#ਚੂਕ ਵੇਲਾ#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#ਤੁਰਕਮੇਨਿਸਤਾਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਤੁਰਕਮੇਨਿਸਤਾਨ ਵੇਲਾ#,
				'standard' => q#ਤੁਰਕਮੇਨਿਸਤਾਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#ਟੁਵਾਲੂ ਵੇਲਾ#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#ਉਰੂਗਵੇ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਉਰੂਗਵੇ ਵੇਲਾ#,
				'standard' => q#ਉਰੂਗਵੇ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#ਉਜ਼ਬੇਕਿਸਤਾਨ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਉਜ਼ਬੇਕਿਸਤਾਨ ਵੇਲਾ#,
				'standard' => q#ਉਜ਼ਬੇਕਿਸਤਾਨ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#ਵਾਨੂਆਟੂ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਵਾਨੂਆਟੂ ਵੇਲਾ#,
				'standard' => q#ਵਾਨੂਆਟੂ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#ਵੈਨੇਜ਼ੂਏਲਾ ਵੇਲਾ#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#ਵਲਾਦੀਵੋਸਤਕ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਵਲਾਦੀਵੋਸਤਕ ਵੇਲਾ#,
				'standard' => q#ਵਲਾਦੀਵੋਸਤਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#ਵੋਲਗੋਗ੍ਰੇਡ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਵੋਲਗੋਗ੍ਰੇਡ ਵੇਲਾ#,
				'standard' => q#ਵੋਲਗੋਗ੍ਰੇਡ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#ਵੋਸਟੋਕ ਵੇਲਾ#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#ਵੇਕ ਆਈਲੈਂਡ ਵੇਲਾ#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#ਵਾਲਿਸ ਅਤੇ ਫੁਟੂਨਾ ਵੇਲਾ#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#ਯਕੁਤਸਕ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਯਕੁਤਸਕ ਵੇਲਾ#,
				'standard' => q#ਯਕੁਤਸਕ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#ਯਕੇਤਰਿਨਬਰਗ ਗਰਮੀਆਂ ਦਾ ਵੇਲਾ#,
				'generic' => q#ਯਕੇਤਰਿਨਬਰਗ ਵੇਲਾ#,
				'standard' => q#ਯਕੇਤਰਿਨਬਰਗ ਮਿਆਰੀ ਵੇਲਾ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
