=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Mn - Package for language Mongolian

=cut

package Locale::CLDR::Locales::Mn;
# This file auto generated from Data\common\main\mn.xml
#	on Fri 28 Jun  8:55:56 am GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.45.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'афар',
 				'ab' => 'абхаз',
 				'ace' => 'ачин',
 				'ada' => 'адангмэ',
 				'ady' => 'адигэ',
 				'af' => 'африкаанс',
 				'agq' => 'агем',
 				'ain' => 'айну',
 				'ak' => 'акан',
 				'ale' => 'алют',
 				'alt' => 'өмнөд алтай',
 				'am' => 'амхар',
 				'an' => 'арагон',
 				'ann' => 'оболо',
 				'anp' => 'ангик',
 				'ar' => 'араб',
 				'ar_001' => 'стандарт араб',
 				'arn' => 'мапүчи',
 				'arp' => 'арапаго',
 				'ars' => 'наджи араб',
 				'as' => 'ассам',
 				'asa' => 'асу',
 				'ast' => 'астури',
 				'atj' => 'атикамек',
 				'av' => 'авар',
 				'awa' => 'авадхи',
 				'ay' => 'аймара',
 				'az' => 'азербайжан',
 				'az@alt=short' => 'азери',
 				'ba' => 'башкир',
 				'ban' => 'бали',
 				'bas' => 'басаа',
 				'be' => 'беларусь',
 				'bem' => 'бемба',
 				'bez' => 'бена',
 				'bg' => 'болгар',
 				'bgc' => 'Харьянви',
 				'bho' => 'божпури',
 				'bi' => 'бислам',
 				'bin' => 'бини',
 				'bla' => 'сиксика',
 				'bm' => 'бамбара',
 				'bn' => 'бенгал',
 				'bo' => 'төвд',
 				'br' => 'бретон',
 				'brx' => 'бодо',
 				'bs' => 'босни',
 				'bug' => 'буги',
 				'byn' => 'блин',
 				'ca' => 'каталан',
 				'cay' => 'кайюга хэл',
 				'ccp' => 'чакма',
 				'ce' => 'чечень',
 				'ceb' => 'себуано',
 				'cgg' => 'чига',
 				'ch' => 'чаморро',
 				'chk' => 'чуук',
 				'chm' => 'мари хэл',
 				'cho' => 'чоктау',
 				'chp' => 'чипевайан',
 				'chr' => 'чероки',
 				'chy' => 'чэенн',
 				'ckb' => 'төв курд',
 				'ckb@alt=menu' => 'Курд, Төв',
 				'ckb@alt=variant' => 'Курд, Сорани',
 				'clc' => 'чилкотин',
 				'co' => 'корсик',
 				'crg' => 'мичиф',
 				'crj' => 'зүүн өмнөд кри',
 				'crk' => 'плэйн кри',
 				'crl' => 'зүүн хойд кри',
 				'crm' => 'мүүс кри',
 				'crr' => 'каролина алгонкинск хэл',
 				'crs' => 'сеселва креол франц',
 				'cs' => 'чех',
 				'csw' => 'свампи кри',
 				'cu' => 'сүмийн славян',
 				'cv' => 'чуваш',
 				'cy' => 'уэльс',
 				'da' => 'дани',
 				'dak' => 'дакота',
 				'dar' => 'даргва',
 				'dav' => 'тайта',
 				'de' => 'герман',
 				'de_AT' => 'австри-герман',
 				'de_CH' => 'швейцарь-герман',
 				'dgr' => 'догриб',
 				'dje' => 'зарма',
 				'doi' => 'догри',
 				'dsb' => 'доод сорби',
 				'dua' => 'дуала',
 				'dv' => 'дивехи',
 				'dyo' => 'жола-фони',
 				'dz' => 'зонха',
 				'dzg' => 'дазага',
 				'ebu' => 'эмбу',
 				'ee' => 'эвэ',
 				'efi' => 'эфик',
 				'eka' => 'экажук',
 				'el' => 'грек',
 				'en' => 'англи',
 				'en_AU' => 'австрали-англи',
 				'en_CA' => 'канад-англи',
 				'en_GB' => 'британи-англи',
 				'en_US' => 'америк-англи',
 				'eo' => 'эсперанто',
 				'es' => 'испани',
 				'es_419' => 'испани хэл (Латин Америк)',
 				'es_ES' => 'испани хэл (Европ)',
 				'es_MX' => 'испани хэл (Мексик)',
 				'et' => 'эстони',
 				'eu' => 'баск',
 				'ewo' => 'эвондо',
 				'fa' => 'перс',
 				'ff' => 'фула',
 				'fi' => 'фин',
 				'fil' => 'филипино',
 				'fj' => 'фижи',
 				'fo' => 'фарер',
 				'fon' => 'фон',
 				'fr' => 'франц',
 				'fr_CA' => 'канад-франц',
 				'fr_CH' => 'швейцари-франц',
 				'frc' => 'франц, кажун',
 				'frr' => 'хойд фриз',
 				'fur' => 'фриулан',
 				'fy' => 'баруун фриз',
 				'ga' => 'ирланд',
 				'gaa' => 'га',
 				'gag' => 'гагуз',
 				'gd' => 'шотландын гел',
 				'gez' => 'гийз',
 				'gil' => 'гилберт',
 				'gl' => 'галего',
 				'gn' => 'гуарани',
 				'gor' => 'горонтало',
 				'gsw' => 'швейцари-герман',
 				'gu' => 'гужарати',
 				'guz' => 'гузы',
 				'gv' => 'манкс',
 				'gwi' => 'гвичин',
 				'ha' => 'хауса',
 				'hai' => 'хайда',
 				'haw' => 'хавай',
 				'hax' => 'өмнөд хайда',
 				'he' => 'еврей',
 				'hi' => 'хинди',
 				'hi_Latn@alt=variant' => 'хинглиш',
 				'hil' => 'хилигайнон',
 				'hmn' => 'хмонг',
 				'hr' => 'хорват',
 				'hsb' => 'дээд сорби',
 				'ht' => 'Гаитийн креол',
 				'hu' => 'мажар',
 				'hup' => 'хупа',
 				'hur' => 'халкомелем',
 				'hy' => 'армен',
 				'hz' => 'хереро',
 				'ia' => 'интерлингво',
 				'iba' => 'ибан',
 				'ibb' => 'ибибио',
 				'id' => 'индонези',
 				'ie' => 'нэгдмэл хэл',
 				'ig' => 'игбо',
 				'ii' => 'сычуань и',
 				'ikt' => 'баруун канадын инуктитут',
 				'ilo' => 'илоко',
 				'inh' => 'ингуш',
 				'io' => 'идо',
 				'is' => 'исланд',
 				'it' => 'итали',
 				'iu' => 'инуктитут',
 				'ja' => 'япон',
 				'jbo' => 'ложбан',
 				'jgo' => 'нгомба',
 				'jmc' => 'мачамэ',
 				'jv' => 'ява',
 				'ka' => 'гүрж',
 				'kab' => 'кабиле',
 				'kac' => 'качин',
 				'kaj' => 'жжу',
 				'kam' => 'камба',
 				'kbd' => 'кабардин',
 				'kcg' => 'тяп',
 				'kde' => 'маконде',
 				'kea' => 'кабүвердиану',
 				'kfo' => 'коро',
 				'kgp' => 'кайнганг',
 				'kha' => 'каси',
 				'khq' => 'койра чини',
 				'ki' => 'кикуюү',
 				'kj' => 'куаньяма',
 				'kk' => 'казах',
 				'kkj' => 'како',
 				'kl' => 'калалисут',
 				'kln' => 'каленжин',
 				'km' => 'кхмер',
 				'kmb' => 'кимбунду',
 				'kn' => 'каннада',
 				'ko' => 'солонгос',
 				'koi' => 'коми-пермяк',
 				'kok' => 'конкани',
 				'kpe' => 'кпелле',
 				'kr' => 'канури',
 				'krc' => 'карачай-балкар',
 				'krl' => 'карель',
 				'kru' => 'курук',
 				'ks' => 'кашмир',
 				'ksb' => 'шамбал',
 				'ksf' => 'бафиа',
 				'ksh' => 'кёльш',
 				'ku' => 'курд',
 				'kum' => 'кумук',
 				'kv' => 'коми',
 				'kw' => 'корн',
 				'kwk' => 'квак вала',
 				'ky' => 'киргиз',
 				'la' => 'латин',
 				'lad' => 'ладин',
 				'lag' => 'ланги',
 				'lb' => 'люксембург',
 				'lez' => 'лезги',
 				'lg' => 'ганда',
 				'li' => 'лимбург',
 				'lij' => 'Лигури',
 				'lil' => 'лиллуэт',
 				'lkt' => 'лакота',
 				'ln' => 'лингала',
 				'lo' => 'лаос',
 				'lou' => 'луизиана креоле',
 				'loz' => 'лози',
 				'lrc' => 'хойд лури',
 				'lsm' => 'самиа',
 				'lt' => 'литва',
 				'lu' => 'луба-катанга',
 				'lua' => 'луба-лулуа',
 				'lun' => 'лунда',
 				'luo' => 'луо',
 				'lus' => 'мизо',
 				'luy' => 'луяа',
 				'lv' => 'латви',
 				'mad' => 'мадури хэл',
 				'mag' => 'магахи',
 				'mai' => 'май',
 				'mak' => 'макасар',
 				'mas' => 'масай',
 				'mdf' => 'мокша',
 				'men' => 'менде',
 				'mer' => 'меру',
 				'mfe' => 'морисен',
 				'mg' => 'малагаси',
 				'mgh' => 'макува-мито',
 				'mgo' => 'мета',
 				'mh' => 'маршалл',
 				'mi' => 'маори',
 				'mic' => 'микмак',
 				'min' => 'минангкабау',
 				'mk' => 'македон',
 				'ml' => 'малаялам',
 				'mn' => 'монгол',
 				'mni' => 'манипури',
 				'moe' => 'инну-аймун',
 				'moh' => 'мохаук',
 				'mos' => 'мосси',
 				'mr' => 'марати',
 				'ms' => 'малай',
 				'mt' => 'малта',
 				'mua' => 'мунданг',
 				'mul' => 'олон хэл',
 				'mus' => 'крик',
 				'mwl' => 'меранди',
 				'my' => 'бирм',
 				'myv' => 'эрзя',
 				'mzn' => 'мазандерани',
 				'na' => 'науру',
 				'nap' => 'неаполитан',
 				'naq' => 'нама',
 				'nb' => 'норвегийн букмол',
 				'nd' => 'хойд ндебеле',
 				'nds' => 'доод герман',
 				'ne' => 'балба',
 				'new' => 'невари',
 				'ng' => 'ндонга',
 				'nia' => 'ниас хэл',
 				'niu' => 'ниуэ',
 				'nl' => 'нидерланд',
 				'nl_BE' => 'фламанд',
 				'nmg' => 'квазио',
 				'nn' => 'норвегийн нинорск',
 				'nnh' => 'нгиембүүн',
 				'no' => 'норвег',
 				'nog' => 'ногаи',
 				'nqo' => 'нко',
 				'nr' => 'өмнөд ндебеле',
 				'nso' => 'хойд сото',
 				'nus' => 'нуер',
 				'nv' => 'навахо',
 				'ny' => 'нянжа',
 				'nyn' => 'нянколе',
 				'oc' => 'окситан',
 				'ojb' => 'баруун хойд ожибва',
 				'ojc' => 'төв ожибва',
 				'ojs' => 'ожи кри',
 				'ojw' => 'баруун ожибва',
 				'oka' => 'оканаган',
 				'om' => 'оромо',
 				'or' => 'ория',
 				'os' => 'оссетин',
 				'pa' => 'панжаби',
 				'pag' => 'пангасин',
 				'pam' => 'пампанга',
 				'pap' => 'папьяменто',
 				'pau' => 'палау',
 				'pcm' => 'нигерийн пиджин',
 				'pis' => 'пижин',
 				'pl' => 'польш',
 				'pqm' => 'малесит-пассамакводди',
 				'prg' => 'прусс',
 				'ps' => 'пушту',
 				'pt' => 'португал',
 				'pt_BR' => 'португал хэл (Бразил)',
 				'pt_PT' => 'португал хэл (Европ)',
 				'qu' => 'кечуа',
 				'quc' => 'киче',
 				'raj' => 'ражастани',
 				'rap' => 'рапануи',
 				'rar' => 'раротонг',
 				'rhg' => 'рохинжа',
 				'rm' => 'романш',
 				'rn' => 'рунди',
 				'ro' => 'румын',
 				'ro_MD' => 'молдав',
 				'rof' => 'ромбо',
 				'ru' => 'орос',
 				'rup' => 'ароманы',
 				'rw' => 'киньяруанда',
 				'rwk' => 'рва',
 				'sa' => 'санскрит',
 				'sad' => 'сандавэ',
 				'sah' => 'саха',
 				'saq' => 'самбүрү',
 				'sat' => 'сантали',
 				'sba' => 'нгамбай',
 				'sbp' => 'сангү',
 				'sc' => 'сардин',
 				'scn' => 'сицил',
 				'sco' => 'шотланд',
 				'sd' => 'синдхи',
 				'se' => 'хойд сами',
 				'seh' => 'сена',
 				'ses' => 'кёраборо сени',
 				'sg' => 'санго',
 				'sh' => 'хорватын серб',
 				'shi' => 'тачелхит',
 				'shn' => 'шань',
 				'si' => 'синхала',
 				'sk' => 'словак',
 				'sl' => 'словени',
 				'slh' => 'өмнөд лушуцид',
 				'sm' => 'самоа',
 				'sma' => 'өмнөд сами',
 				'smj' => 'люле сами',
 				'smn' => 'инари сами',
 				'sms' => 'сколт сами',
 				'sn' => 'шона',
 				'snk' => 'сонинке',
 				'so' => 'сомали',
 				'sq' => 'албани',
 				'sr' => 'серб',
 				'srn' => 'сранан тонго',
 				'ss' => 'свати',
 				'ssy' => 'сахо',
 				'st' => 'сесото',
 				'str' => 'стрейтс салиш',
 				'su' => 'сундан',
 				'suk' => 'сукума',
 				'sv' => 'швед',
 				'sw' => 'свахили',
 				'sw_CD' => 'конгогийн свахили',
 				'swb' => 'комори',
 				'syr' => 'сири',
 				'ta' => 'тамил',
 				'tce' => 'өмнөд тутчоне',
 				'te' => 'тэлүгү',
 				'tem' => 'тимн',
 				'teo' => 'тэсо',
 				'tet' => 'тетум',
 				'tg' => 'тажик',
 				'tgx' => 'тагиш',
 				'th' => 'тай',
 				'tht' => 'талтан',
 				'ti' => 'тигринья',
 				'tig' => 'тигр',
 				'tk' => 'туркмен',
 				'tlh' => 'клингон',
 				'tli' => 'тлингит',
 				'tn' => 'цвана',
 				'to' => 'тонга',
 				'tok' => 'токипона',
 				'tpi' => 'ток писин',
 				'tr' => 'турк',
 				'trv' => 'тароко',
 				'ts' => 'цонга',
 				'tt' => 'татар',
 				'ttm' => 'хойд тутчоне',
 				'tum' => 'тумбула',
 				'tvl' => 'тувалу',
 				'tw' => 'тви',
 				'twq' => 'тасавак',
 				'ty' => 'таити',
 				'tyv' => 'тува',
 				'tzm' => 'Төв Атласын тамазигхт',
 				'udm' => 'удмурт',
 				'ug' => 'уйгур',
 				'uk' => 'украин',
 				'umb' => 'умбунду',
 				'und' => 'Үл мэдэгдэх хэл',
 				'ur' => 'урду',
 				'uz' => 'узбек',
 				'vai' => 'вай',
 				've' => 'венда',
 				'vec' => 'венец',
 				'vi' => 'вьетнам',
 				'vo' => 'волапюк',
 				'vun' => 'вунжо',
 				'wa' => 'уоллун',
 				'wae' => 'уолсэр',
 				'wal' => 'уоллайтта',
 				'war' => 'варай',
 				'wo' => 'волоф',
 				'wuu' => 'хятад, ву хэл',
 				'xal' => 'халимаг',
 				'xh' => 'хоса',
 				'xog' => 'сога',
 				'yav' => 'янгбен',
 				'ybb' => 'емба',
 				'yi' => 'иддиш',
 				'yo' => 'ёруба',
 				'yrl' => 'ньенгату',
 				'yue' => 'кантон',
 				'yue@alt=menu' => 'хятад, кантон',
 				'zgh' => 'стандарт тамазайт (Морокко)',
 				'zh' => 'хятад',
 				'zh@alt=menu' => 'хятад, мандарин',
 				'zh_Hans' => 'хялбаршуулсан хятад',
 				'zh_Hans@alt=long' => 'хялбаршуулсан мандарин хятад',
 				'zh_Hant' => 'уламжлалт хятад',
 				'zh_Hant@alt=long' => 'уламжлалт мандарин хятад',
 				'zu' => 'зулу',
 				'zun' => 'зуни',
 				'zxx' => 'хэл зүйн агуулгагүй',
 				'zza' => 'заза',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'Адлам бичиг',
 			'Aghb' => 'Кавказийн албани',
 			'Ahom' => 'Ахом',
 			'Arab' => 'араб',
 			'Aran' => 'Насталик бичиг',
 			'Armi' => 'Арамайк',
 			'Armn' => 'армени',
 			'Avst' => 'Авестан',
 			'Bali' => 'Бали',
 			'Bamu' => 'Баму',
 			'Bass' => 'Басс',
 			'Batk' => 'Батк',
 			'Beng' => 'бенгал',
 			'Bhks' => 'Байксуки',
 			'Bopo' => 'вопомофо',
 			'Brah' => 'Брахми',
 			'Brai' => 'брайл',
 			'Bugi' => 'Бугинез',
 			'Buhd' => 'Бухид',
 			'Cakm' => 'Чакма бичиг',
 			'Cans' => 'Канадын уугуул иргэдийн тэмдэгт бичиг',
 			'Cari' => 'Кари',
 			'Cham' => 'Чам',
 			'Cher' => 'Чероки бичиг',
 			'Chrs' => 'Корасми',
 			'Copt' => 'Коптик',
 			'Cpmn' => 'Кипр-Миноан',
 			'Cprt' => 'Киприот',
 			'Cyrl' => 'кирилл',
 			'Deva' => 'деванагари',
 			'Diak' => 'Диак',
 			'Dogr' => 'Догра',
 			'Dsrt' => 'Дезерет',
 			'Dupl' => 'Дуплоян',
 			'Egyp' => 'Египетийн дүрс бичиг',
 			'Elba' => 'Элбасан',
 			'Elym' => 'Элимайк',
 			'Ethi' => 'этиоп',
 			'Geor' => 'гүрж',
 			'Glag' => 'Глаголитик',
 			'Gong' => 'Гонг',
 			'Gonm' => 'Масарам Гонди',
 			'Goth' => 'Готик',
 			'Gran' => 'Гранта',
 			'Grek' => 'грек',
 			'Gujr' => 'гужарати',
 			'Guru' => 'гүрмүх',
 			'Hanb' => 'Бопомофотой ханз',
 			'Hang' => 'хангыль',
 			'Hani' => 'ханз',
 			'Hano' => 'Хануноо',
 			'Hans' => 'хялбаршуулсан',
 			'Hans@alt=stand-alone' => 'хялбаршуулсан ханз',
 			'Hant' => 'уламжлалт',
 			'Hant@alt=stand-alone' => 'уламжлалт ханз',
 			'Hatr' => 'Хатран',
 			'Hebr' => 'еврей',
 			'Hira' => 'хирагана',
 			'Hluw' => 'Анатолийн дүрс бичиг',
 			'Hmng' => 'Пахав Хмонг',
 			'Hmnp' => 'Хмнп',
 			'Hrkt' => 'япон хэлний үеийн цагаан толгой',
 			'Hung' => 'Хуучин Унгар',
 			'Ital' => 'Хуучин итали',
 			'Jamo' => 'жамо',
 			'Java' => 'Жава',
 			'Jpan' => 'япон',
 			'Kali' => 'Кали',
 			'Kana' => 'катакана',
 			'Kawi' => 'Кави',
 			'Khar' => 'Карошти',
 			'Khmr' => 'кхмер',
 			'Khoj' => 'Кожки',
 			'Kits' => 'Китан бага бичвэр',
 			'Knda' => 'каннада',
 			'Kore' => 'солонгос',
 			'Kthi' => 'Кайти',
 			'Lana' => 'Лана',
 			'Laoo' => 'лаос',
 			'Latn' => 'латин',
 			'Lepc' => 'Лепк',
 			'Limb' => 'Лимб',
 			'Lina' => 'Зураасан A',
 			'Linb' => 'Зураасан B',
 			'Lisu' => 'Лису',
 			'Lyci' => 'Лиси',
 			'Lydi' => 'Лиди',
 			'Mahj' => 'Махажани',
 			'Maka' => 'Макасар',
 			'Mand' => 'Манд',
 			'Mani' => 'Манич',
 			'Marc' => 'Марк',
 			'Medf' => 'Медефайдрин',
 			'Mend' => 'Менди',
 			'Merc' => 'Меройтик Курсив',
 			'Mero' => 'Меройтик',
 			'Mlym' => 'малаялам',
 			'Modi' => 'Моди',
 			'Mong' => 'монгол бичиг',
 			'Mroo' => 'Мру',
 			'Mtei' => 'Мейтей маек бичиг',
 			'Mult' => 'Мултани',
 			'Mymr' => 'мьянмар',
 			'Nagm' => 'Наг Мундари',
 			'Nand' => 'Нандинагари',
 			'Narb' => 'Хуучин Хойд Араб бичиг',
 			'Nbat' => 'Набата',
 			'Newa' => 'Нева',
 			'Nkoo' => 'Нко бичиг',
 			'Nshu' => 'Нүшү',
 			'Ogam' => 'Огам',
 			'Olck' => 'Ол чики бичиг',
 			'Orkh' => 'Орхон',
 			'Orya' => 'ория',
 			'Osge' => 'Осге',
 			'Osma' => 'Османи',
 			'Ougr' => 'Хуучин уйгар',
 			'Palm' => 'Палмирен',
 			'Pauc' => 'Пай Чин Хау',
 			'Perm' => 'Хуучин Пермик',
 			'Phag' => 'Фагс-па',
 			'Phli' => 'Пахлави',
 			'Phlp' => 'Псалтер Пахлави',
 			'Phnx' => 'Финик',
 			'Plrd' => 'Пирд',
 			'Prti' => 'Партиан',
 			'Qaag' => 'Каак',
 			'Rjng' => 'Режанг',
 			'Rohg' => 'Ханафи бичиг',
 			'Runr' => 'Руни',
 			'Samr' => 'Самаритан',
 			'Sarb' => 'Хуучин Өмнөд Араб',
 			'Saur' => 'Саураштра',
 			'Sgnw' => 'Тэмдэгт бичиг',
 			'Shaw' => 'Шави',
 			'Shrd' => 'Шарада',
 			'Sidd' => 'Сиддхам',
 			'Sind' => 'Кудавади',
 			'Sinh' => 'синхала',
 			'Sogd' => 'Согди',
 			'Sogo' => 'Хуучин согди',
 			'Sora' => 'Сора сомпенг',
 			'Soyo' => 'Соёмбо',
 			'Sund' => 'Сундан бичиг',
 			'Sylo' => 'Сило',
 			'Syrc' => 'Сирийк бичиг',
 			'Tagb' => 'Тагбанва',
 			'Takr' => 'Такри',
 			'Tale' => 'Тале',
 			'Talu' => 'Талу',
 			'Taml' => 'тамил',
 			'Tang' => 'Тангут',
 			'Tavt' => 'Тай Вьетнам',
 			'Telu' => 'тэлүгү',
 			'Tfng' => 'Тифинаг бичиг',
 			'Tglg' => 'Тагалог',
 			'Thaa' => 'тана',
 			'Thai' => 'тай',
 			'Tibt' => 'төвд',
 			'Tirh' => 'Тирхута',
 			'Tnsa' => 'Тангса',
 			'Toto' => 'Тото',
 			'Ugar' => 'Угаритик',
 			'Vaii' => 'Ваи бичиг',
 			'Vith' => 'Виткуки',
 			'Wara' => 'Варанг Кшити',
 			'Wcho' => 'Ванчу',
 			'Xpeo' => 'Хуучин перс',
 			'Xsux' => 'Сумеро-Аккадиан шаантаг бичиг',
 			'Yezi' => 'Езиди',
 			'Yiii' => 'И бичиг',
 			'Zanb' => 'Занабазарын дөрвөлжин бичиг',
 			'Zinh' => 'Зинх',
 			'Zmth' => 'математик тооллын систем',
 			'Zsye' => 'эможи',
 			'Zsym' => 'тэмдэг',
 			'Zxxx' => 'бичигдээгүй',
 			'Zyyy' => 'нийтлэг',
 			'Zzzz' => 'тодорхойгүй бичиг',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'Дэлхий',
 			'002' => 'Африк',
 			'003' => 'Хойд Америк',
 			'005' => 'Өмнөд Америк',
 			'009' => 'Номхон далайн орнууд',
 			'011' => 'Баруун Африк',
 			'013' => 'Төв Америк',
 			'014' => 'Зүүн Африк',
 			'015' => 'Хойд Африк',
 			'017' => 'Төв Африк',
 			'018' => 'Өмнөд Африк тив',
 			'019' => 'Америк',
 			'021' => 'Хойд Америк тив',
 			'029' => 'Карибын тэнгис',
 			'030' => 'Зүүн Ази',
 			'034' => 'Өмнөд Ази',
 			'035' => 'Зүүн өмнөд Ази',
 			'039' => 'Өмнөд Европ',
 			'053' => 'Австрали-Ази',
 			'054' => 'Меланези',
 			'057' => 'Микронезийн бүс',
 			'061' => 'Полинези',
 			'142' => 'Ази',
 			'143' => 'Төв Ази',
 			'145' => 'Баруун Ази',
 			'150' => 'Европ',
 			'151' => 'Зүүн Европ',
 			'154' => 'Хойд Европ',
 			'155' => 'Баруун Европ',
 			'202' => 'Сахарын цөлийн урд хэсгийн Африк',
 			'419' => 'Латин Америк',
 			'AC' => 'Асенсион арал',
 			'AD' => 'Андорра',
 			'AE' => 'Арабын Нэгдсэн Эмирт Улс',
 			'AF' => 'Афганистан',
 			'AG' => 'Антигуа ба Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албани',
 			'AM' => 'Армени',
 			'AO' => 'Ангол',
 			'AQ' => 'Антарктид',
 			'AR' => 'Аргентин',
 			'AS' => 'Америкийн Самоа',
 			'AT' => 'Австри',
 			'AU' => 'Австрали',
 			'AW' => 'Аруба',
 			'AX' => 'Аландын арлууд',
 			'AZ' => 'Азербайжан',
 			'BA' => 'Босни-Герцеговин',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельги',
 			'BF' => 'Буркина Фасо',
 			'BG' => 'Болгар',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сент-Бартельми',
 			'BM' => 'Бермуда',
 			'BN' => 'Бруней',
 			'BO' => 'Боливи',
 			'BQ' => 'Карибын Нидерланд',
 			'BR' => 'Бразил',
 			'BS' => 'Багамын арлууд',
 			'BT' => 'Бутан',
 			'BV' => 'Буве арал',
 			'BW' => 'Ботсван',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белизе',
 			'CA' => 'Канад',
 			'CC' => 'Кокос (Кийлинг) арлууд',
 			'CD' => 'Конго-Киншаса',
 			'CD@alt=variant' => 'Бүгд Найрамдах Ардчилсан Конго Улс',
 			'CF' => 'Төв Африкийн Бүгд Найрамдах Улс',
 			'CG' => 'Конго-Браззавиль',
 			'CG@alt=variant' => 'Конго (Бүгд Найрамдах улс)',
 			'CH' => 'Швейцарь',
 			'CI' => 'Кот-д’Ивуар',
 			'CI@alt=variant' => 'Зааны ясан эрэг',
 			'CK' => 'Күүкийн арлууд',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Хятад',
 			'CO' => 'Колумби',
 			'CP' => 'Клиппертон арал',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Зул сарын арал',
 			'CY' => 'Кипр',
 			'CZ' => 'Чех',
 			'CZ@alt=variant' => 'Бүгд Найрамдах Чех Улс',
 			'DE' => 'Герман',
 			'DG' => 'Диего Гарсиа',
 			'DJ' => 'Джибути',
 			'DK' => 'Дани',
 			'DM' => 'Доминика',
 			'DO' => 'Бүгд Найрамдах Доминикан Улс',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута ба Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстони',
 			'EG' => 'Египет',
 			'EH' => 'Баруун Сахар',
 			'ER' => 'Эритрей',
 			'ES' => 'Испани',
 			'ET' => 'Этиоп',
 			'EU' => 'Европын Холбоо',
 			'EZ' => 'Евро бүс',
 			'FI' => 'Финлянд',
 			'FJ' => 'Фижи',
 			'FK' => 'Фолклендийн арлууд',
 			'FK@alt=variant' => 'Фолклендийн арлууд (Мальвины арлууд)',
 			'FM' => 'Микронези',
 			'FO' => 'Фарерын арлууд',
 			'FR' => 'Франц',
 			'GA' => 'Габон',
 			'GB' => 'Их Британи',
 			'GB@alt=short' => 'ИБ',
 			'GD' => 'Гренада',
 			'GE' => 'Гүрж',
 			'GF' => 'Францын Гвиана',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренланд',
 			'GM' => 'Гамби',
 			'GN' => 'Гвиней',
 			'GP' => 'Гваделуп',
 			'GQ' => 'Экваторын Гвиней',
 			'GR' => 'Грек',
 			'GS' => 'Өмнөд Жоржиа ба Өмнөд Сэндвичийн арлууд',
 			'GT' => 'Гватемал',
 			'GU' => 'Гуам',
 			'GW' => 'Гвиней-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'БНХАУ-ын Тусгай захиргааны бүс Хонг Конг',
 			'HK@alt=short' => 'Хонг Конг',
 			'HM' => 'Херд ба Макдональдийн арлууд',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорват',
 			'HT' => 'Гаити',
 			'HU' => 'Унгар',
 			'IC' => 'Канарын арлууд',
 			'ID' => 'Индонез',
 			'IE' => 'Ирланд',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн Арал',
 			'IN' => 'Энэтхэг',
 			'IO' => 'Британийн харьяа Энэтхэгийн далай дахь нутаг дэвсгэр',
 			'IO@alt=chagos' => 'Чагос олтриг',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исланд',
 			'IT' => 'Итали',
 			'JE' => 'Жерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Йордан',
 			'JP' => 'Япон',
 			'KE' => 'Кени',
 			'KG' => 'Кыргызстан',
 			'KH' => 'Камбож',
 			'KI' => 'Кирибати',
 			'KM' => 'Коморын арлууд',
 			'KN' => 'Сент-Киттс ба Невис',
 			'KP' => 'Хойд Солонгос',
 			'KR' => 'Өмнөд Солонгос',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайманы арлууд',
 			'KZ' => 'Казахстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент Люсиа',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либери',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латви',
 			'LY' => 'Ливи',
 			'MA' => 'Морокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Монтенегро',
 			'MF' => 'Сент-Мартин',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршаллын арлууд',
 			'MK' => 'Хойд Македон',
 			'ML' => 'Мали',
 			'MM' => 'Мьянмар',
 			'MN' => 'Монгол',
 			'MO' => 'БНХАУ-ын Тусгай захиргааны бүс Макао',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Хойд Марианы арлууд',
 			'MQ' => 'Мартиник',
 			'MR' => 'Мавритани',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Мальдив',
 			'MW' => 'Малави',
 			'MX' => 'Мексик',
 			'MY' => 'Малайз',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намиби',
 			'NC' => 'Шинэ Каледони',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк арал',
 			'NG' => 'Нигери',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвеги',
 			'NP' => 'Балба',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Шинэ Зеланд',
 			'NZ@alt=variant' => 'Аотеароагийн Шинэ Зеланд',
 			'OM' => 'Оман',
 			'PA' => 'Панам',
 			'PE' => 'Перу',
 			'PF' => 'Францын Полинез',
 			'PG' => 'Папуа Шинэ Гвиней',
 			'PH' => 'Филиппин',
 			'PK' => 'Пакистан',
 			'PL' => 'Польш',
 			'PM' => 'Сент-Пьер ба Микело',
 			'PN' => 'Питкэрн арлууд',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестины нутаг дэвсгэр',
 			'PS@alt=short' => 'Палестин',
 			'PT' => 'Португал',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Номхон далайг тойрсон улс орнууд',
 			'RE' => 'Реюнион',
 			'RO' => 'Румын',
 			'RS' => 'Серби',
 			'RU' => 'Орос',
 			'RW' => 'Руанда',
 			'SA' => 'Саудын Араб',
 			'SB' => 'Соломоны арлууд',
 			'SC' => 'Сейшелийн арлууд',
 			'SD' => 'Судан',
 			'SE' => 'Швед',
 			'SG' => 'Сингапур',
 			'SH' => 'Сент Хелена',
 			'SI' => 'Словени',
 			'SJ' => 'Свалбард ба Ян Майен',
 			'SK' => 'Словак',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Өмнөд Судан',
 			'ST' => 'Сан-Томе ба Принсипи',
 			'SV' => 'Эль Сальвадор',
 			'SX' => 'Синт Мартен',
 			'SY' => 'Сири',
 			'SZ' => 'Эсватини',
 			'SZ@alt=variant' => 'Свазиланд',
 			'TA' => 'Тристан да Кунъя',
 			'TC' => 'Турк ба Кайкосын Арлууд',
 			'TD' => 'Чад',
 			'TF' => 'Францын өмнөд газар нутаг',
 			'TG' => 'Того',
 			'TH' => 'Тайланд',
 			'TJ' => 'Тажикистан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Зүүн Тимор',
 			'TM' => 'Туркменистан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Турк',
 			'TT' => 'Тринидад ба Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзани',
 			'UA' => 'Украин',
 			'UG' => 'Уганда',
 			'UM' => 'Америкийн Нэгдсэн Улсын бага арлууд',
 			'UN' => 'Нэгдсэн Үндэстний Байгууллага',
 			'UN@alt=short' => 'НҮБ',
 			'US' => 'Америкийн Нэгдсэн Улс',
 			'US@alt=short' => 'АНУ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Узбекистан',
 			'VA' => 'Ватикан хот улс',
 			'VC' => 'Сент-Винсент ба Гренадин',
 			'VE' => 'Венесуэл',
 			'VG' => 'Британийн Виржиний арлууд',
 			'VI' => 'АНУ-ын Виржиний арлууд',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис ба Футуна',
 			'WS' => 'Самоа',
 			'XA' => 'хуурмаг аялга',
 			'XB' => 'хуурмаг хоёр чиглэлт',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Өмнөд Африк',
 			'ZM' => 'Замби',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Тодорхойгүй бүс',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'цаглавар',
 			'cf' => 'мөнгөн тэмдэгтийн хэлбэр',
 			'collation' => 'эрэмбэлэх дараалал',
 			'currency' => 'мөнгөн тэмдэгт',
 			'hc' => 'цагийн мөчлөг (12 эсвэл 24)',
 			'lb' => 'мөрийн зайн загвар',
 			'ms' => 'нэгжийн систем',
 			'numbers' => 'тоо',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{буддын цаглавар},
 				'chinese' => q{хятад цаглавар},
 				'coptic' => q{коптик цаглавар},
 				'dangi' => q{данги цаглавар},
 				'ethiopic' => q{этиоп цаглавар},
 				'ethiopic-amete-alem' => q{этиоп цаглавар},
 				'gregorian' => q{грегорийн цаглавар},
 				'hebrew' => q{еврей цаглавар},
 				'indian' => q{энэтхэгийн үндэсний цаглавар},
 				'islamic' => q{исламын цаглавар},
 				'islamic-civil' => q{исламын цаглавар (хүснэгт, иргэний эрин үе)},
 				'islamic-rgsa' => q{исламийн цаглавар (саудын араб, газарзүйн)},
 				'islamic-tbla' => q{исламийн цаглавар (хүснэгтэн, одон орны эрин)},
 				'islamic-umalqura' => q{исламын цаглавар (Umm al-Qura)},
 				'iso8601' => q{ISO-8601 цаглавар},
 				'japanese' => q{япон цаглавар},
 				'persian' => q{перс цаглавар},
 				'roc' => q{минго цаглавар},
 			},
 			'cf' => {
 				'account' => q{мөнгөн тэмдэгтийн нягтлан бодох бүртгэлийн хэлбэр},
 				'standard' => q{мөнгөн тэмдэгтийн стандарт хэлбэр},
 			},
 			'collation' => {
 				'big5han' => q{Хуучин хятад Эрэмбэлэх дараалал - Том5},
 				'compat' => q{Нийцлийн үүднээс өмнөх эрэмбэлэх дараалал},
 				'dictionary' => q{Тольны эрэмбэлэх дараалал},
 				'ducet' => q{юникодын үндсэн эрэмбэлэх дараалал},
 				'emoji' => q{Эможи эрэмбэлэх дараалал},
 				'eor' => q{Европийн эрэмбэлэх дүрэм},
 				'gb2312han' => q{Хялбаршуулсан хятад Эрэмбэлэх дараалал - GB2312},
 				'phonebook' => q{Утасны дэвтрийн эрэмбэлэх дараалал},
 				'pinyin' => q{Пиньян эрэмбэлэх дараалал},
 				'search' => q{ерөнхий хайлт},
 				'searchjl' => q{Хангүлээр эхний гийгүүлэгчээр хайх},
 				'standard' => q{стандарт эрэмбэлэх дараалал},
 				'traditional' => q{Хуучин эрэмбэлэх дараалал},
 				'unihan' => q{Язгуурын зураасны эрэмбэлэх дараалал},
 				'zhuyin' => q{Жүяин эрэмбэлэх дараалал},
 			},
 			'hc' => {
 				'h11' => q{12 цагийн систем (0–11)},
 				'h12' => q{12 цагийн систем (1–12)},
 				'h23' => q{24 цагийн систем (0–23)},
 				'h24' => q{24 цагийн систем (1–24)},
 			},
 			'lb' => {
 				'loose' => q{урт мөрийн зайн загвар},
 				'normal' => q{энгийн мөрийн зайн загвар},
 				'strict' => q{шулуун мөрийн зайн загвар},
 			},
 			'ms' => {
 				'metric' => q{метрийн систем},
 				'uksystem' => q{Англи нэгжийн систем},
 				'ussystem' => q{Америк нэгжийн систем},
 			},
 			'numbers' => {
 				'ahom' => q{Ахом тоо},
 				'arab' => q{араб-энэтхэг тоо},
 				'arabext' => q{өргөтгөсөн араб-энэтхэг тоо},
 				'armn' => q{армен тоо},
 				'armnlow' => q{жижиг армен тоо},
 				'bali' => q{Бали тоо},
 				'beng' => q{бенгал тоо},
 				'brah' => q{Брахми тоо},
 				'cakm' => q{чакма тоо},
 				'cham' => q{Чам тоо},
 				'cyrl' => q{Кирилл тоо},
 				'deva' => q{деванагари тоо},
 				'diak' => q{Дивэс Акүрү Тоо},
 				'ethi' => q{этиоп тоо},
 				'fullwide' => q{бүтэн-өргөнтэй тоо},
 				'geor' => q{гүрж тоо},
 				'gong' => q{Гунжала Гонди тоо},
 				'gonm' => q{Масарам Гонди тоо},
 				'grek' => q{грек тоо},
 				'greklow' => q{жижиг грек тоо},
 				'gujr' => q{гүжарати тоо},
 				'guru' => q{гүрмүхи тоо},
 				'hanidec' => q{хятад аравтын тоо},
 				'hans' => q{хялбаршуулсан хятад тоо},
 				'hansfin' => q{хялбаршуулсан хятад санхүүгийн тоо},
 				'hant' => q{уламжлалт хятад тоо},
 				'hantfin' => q{уламжлалт хятад санхүүгийн тоо},
 				'hebr' => q{еврей тоо},
 				'hmng' => q{Пахав Хмонг тоо},
 				'hmnp' => q{Няакенг Пуачэ Хмонг тоо},
 				'java' => q{жава тоо},
 				'jpan' => q{япон тоо},
 				'jpanfin' => q{япон санхүүгийн тоо},
 				'kali' => q{Каяа Ли тоо},
 				'kawi' => q{Кави тоо},
 				'khmr' => q{кхмер тоо},
 				'knda' => q{каннада тоо},
 				'lana' => q{Тай Там Хора тоо},
 				'lanatham' => q{Тай Там Там тоо},
 				'laoo' => q{лаос тоо},
 				'latn' => q{араб тоо},
 				'lepc' => q{Лепча тоо},
 				'limb' => q{Лимбу тоо},
 				'mathbold' => q{Математикийн бүдүүн тоо},
 				'mathdbl' => q{Математикийн хос зурлагат тоо},
 				'mathmono' => q{Математикийн Monospace тоо},
 				'mathsanb' => q{Математикийн Sans-Serif Бүдүүн тоо},
 				'mathsans' => q{Математикийн Sans-Serif тоо},
 				'mlym' => q{малаялам тоо},
 				'modi' => q{Моди тоо},
 				'mong' => q{монгол тоо},
 				'mroo' => q{Мро тоо},
 				'mtei' => q{мейтей маек тоо},
 				'mymr' => q{мьянмар тоо},
 				'mymrshan' => q{Мьянмар Шан тоо},
 				'mymrtlng' => q{Мьянмар Тай Лайнг тоо},
 				'nagm' => q{Наг Мундари тоо},
 				'nkoo' => q{N’Ko тоо},
 				'olck' => q{ол чики тоо},
 				'orya' => q{ория тоо},
 				'osma' => q{Османи тоо},
 				'rohg' => q{Ханифи Рохинж тоо},
 				'roman' => q{ром тоо},
 				'romanlow' => q{жижиг ром тоо},
 				'saur' => q{Саураштра тоо},
 				'shrd' => q{Шарада тоо},
 				'sind' => q{Күдавади тоо},
 				'sinh' => q{Синхала Лит тоо},
 				'sora' => q{Сора Сомпенг тоо},
 				'sund' => q{Сундан тоо},
 				'takr' => q{Такри тоо},
 				'talu' => q{Шинэ тай луэ тоо},
 				'taml' => q{уламжлалт тамил тоо},
 				'tamldec' => q{тамил тоо},
 				'telu' => q{тэлүгү тоо},
 				'thai' => q{тай тоо},
 				'tibt' => q{төвд тоо},
 				'tirh' => q{Тирхута тоо},
 				'tnsa' => q{Тангса тоо},
 				'vaii' => q{вай тоо},
 				'wara' => q{Варанг сити тоо},
 				'wcho' => q{Ванчо тоо},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{метрийн систем},
 			'UK' => q{ИБ},
 			'US' => q{АНУ},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'language' => 'Хэл: {0}',
 			'script' => 'Бичиг: {0}',
 			'region' => 'Бүс: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			auxiliary => qr{[ә җ ӊ һ]},
			index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{[а б в г д её ж з и й к л м н о ө п р с т у ү ф х ц ч ш щ ъ ы ь э ю я]},
			punctuation => qr{[\- ‐‑ – — , ; \: ! ? . … '‘’ "“” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['А', 'Б', 'В', 'Г', 'Д', 'Е', 'Ж', 'З', 'И', 'Й', 'К', 'Л', 'М', 'Н', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ү', 'Ф', 'Х', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'hh:mm',
				hms => 'hh:mm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(зүг чиг),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(зүг чиг),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(киби{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(мэби{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(мэби{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(гиби{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(тэби{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(тэби{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(пэби{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(пэби{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(эксби{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(эксби{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(зэби{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(зэби{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(яиобэ{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(яиобэ{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(деси{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(деси{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(пико{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(пико{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(фемто{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(фемто{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(атто{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(атто{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(сенти{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(сенти{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(зепто{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(зепто{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ёокто{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ёокто{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(мили{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(мили{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(микро{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(микро{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(нано{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(нано{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(дека{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(тера{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(пета{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(экса{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(экса{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(хекто{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(хекто{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(зетта{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(зетта{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(ёотта{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(ёотта{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(кило{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(мега{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(гига{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(жи-хүч),
						'one' => q({0} жи-хүч),
						'other' => q({0} жи-хүч),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(жи-хүч),
						'one' => q({0} жи-хүч),
						'other' => q({0} жи-хүч),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(квадрат секундэд ногдох метр),
						'one' => q(квадрат секундэд {0} метр),
						'other' => q(квадрат секундэд {0} метр),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(квадрат секундэд ногдох метр),
						'one' => q(квадрат секундэд {0} метр),
						'other' => q(квадрат секундэд {0} метр),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(аркминут),
						'one' => q({0} аркминут),
						'other' => q({0} аркминут),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(аркминут),
						'one' => q({0} аркминут),
						'other' => q({0} аркминут),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(арксекунд),
						'one' => q({0} арксекунд),
						'other' => q({0} арксекунд),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					# Core Unit Identifier
					'radian' => {
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					# Core Unit Identifier
					'hectare' => {
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(квадрат сантиметр),
						'one' => q({0} квадрат сантиметр),
						'other' => q({0} квадрат сантиметр),
						'per' => q(квадрат сантиметр тутамд {0}),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(квадрат сантиметр),
						'one' => q({0} квадрат сантиметр),
						'other' => q({0} квадрат сантиметр),
						'per' => q(квадрат сантиметр тутамд {0}),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(квадрат фут),
						'one' => q({0} квадрат фут),
						'other' => q({0} квадрат фут),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(квадрат фут),
						'one' => q({0} квадрат фут),
						'other' => q({0} квадрат фут),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(квадрат инч),
						'one' => q({0} квадрат инч),
						'other' => q({0} квадрат инч),
						'per' => q(квадрат инч тутамд {0}),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(квадрат инч),
						'one' => q({0} квадрат инч),
						'other' => q({0} квадрат инч),
						'per' => q(квадрат инч тутамд {0}),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(квадрат километр),
						'one' => q({0} квадрат километр),
						'other' => q({0} квадрат километр),
						'per' => q(квадрат километр тутамд {0}),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(квадрат километр),
						'one' => q({0} квадрат километр),
						'other' => q({0} квадрат километр),
						'per' => q(квадрат километр тутамд {0}),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(квадрат метр),
						'one' => q({0} квадрат метр),
						'other' => q({0} квадрат метр),
						'per' => q(квадрат метр тутамд {0}),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(квадрат метр),
						'one' => q({0} квадрат метр),
						'other' => q({0} квадрат метр),
						'per' => q(квадрат метр тутамд {0}),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(квадрат миль),
						'one' => q({0} квадрат миль),
						'other' => q({0} квадрат миль),
						'per' => q(квадрат миль тутамд {0}),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(квадрат миль),
						'one' => q({0} квадрат миль),
						'other' => q({0} квадрат миль),
						'per' => q(квадрат миль тутамд {0}),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(квадрат ярд),
						'one' => q({0} квадрат ярд),
						'other' => q({0} квадрат ярд),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(квадрат ярд),
						'one' => q({0} квадрат ярд),
						'other' => q({0} квадрат ярд),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'karat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(литр тутамд ногдох миллимоль),
						'one' => q(литр тутамд {0} миллимоль),
						'other' => q(литр тутамд {0} миллимоль),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(литр тутамд ногдох миллимоль),
						'one' => q(литр тутамд {0} миллимоль),
						'other' => q(литр тутамд {0} миллимоль),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'one' => q({0} хувь),
						'other' => q({0} хувь),
					},
					# Core Unit Identifier
					'percent' => {
						'one' => q({0} хувь),
						'other' => q({0} хувь),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'one' => q(мянганы {0} хувь),
						'other' => q(мянганы {0} хувь),
					},
					# Core Unit Identifier
					'permille' => {
						'one' => q(мянганы {0} хувь),
						'other' => q(мянганы {0} хувь),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(саяны хувь),
						'one' => q(саяны {0} хувь),
						'other' => q(саяны {0} хувь),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(саяны хувь),
						'one' => q(саяны {0} хувь),
						'other' => q(саяны {0} хувь),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'one' => q(арван мянганы {0} хувь),
						'other' => q(арван мянганы {0} хувь),
					},
					# Core Unit Identifier
					'permyriad' => {
						'one' => q(арван мянганы {0} хувь),
						'other' => q(арван мянганы {0} хувь),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(100 километр тутамд ногдох литр),
						'one' => q(100 километр тутамд {0} литр),
						'other' => q(100 километр тутамд {0} литр),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(100 километр тутамд ногдох литр),
						'one' => q(100 километр тутамд {0} литр),
						'other' => q(100 километр тутамд {0} литр),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(километр тутамд ногдох литр),
						'one' => q(километр тутамд {0} литр),
						'other' => q(километр тутамд {0} литр),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(километр тутамд ногдох литр),
						'one' => q(километр тутамд {0} литр),
						'other' => q(километр тутамд {0} литр),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(галлон тутамд ногдох миль),
						'one' => q(галлон тутамд {0} миль),
						'other' => q(Vote галлон тутамд {0} миль),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(галлон тутамд ногдох миль),
						'one' => q(галлон тутамд {0} миль),
						'other' => q(Vote галлон тутамд {0} миль),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(анг. галлон тутамд ногдох миль),
						'one' => q(анг. галлон тутамд {0} миль),
						'other' => q(анг. галлон тутамд {0} миль),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(анг. галлон тутамд ногдох миль),
						'one' => q(анг. галлон тутамд {0} миль),
						'other' => q(анг. галлон тутамд {0} миль),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q(зүүн уртрагийн {0}),
						'north' => q(хойд өргөргийн {0}),
						'south' => q(өмнөд өргөргийн {0}),
						'west' => q(баруун уртрагийн {0}),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q(зүүн уртрагийн {0}),
						'north' => q(хойд өргөргийн {0}),
						'south' => q(өмнөд өргөргийн {0}),
						'west' => q(баруун уртрагийн {0}),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(петабайт),
						'one' => q({0} петабайт),
						'other' => q({0} петабайт),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(петабайт),
						'one' => q({0} петабайт),
						'other' => q({0} петабайт),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} долоо хоног),
						'other' => q({0} долоо хоног),
						'per' => q({0}/долоо хоног),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} долоо хоног),
						'other' => q({0} долоо хоног),
						'per' => q({0}/долоо хоног),
					},
					# Long Unit Identifier
					'duration-year' => {
						'per' => q({0}/жил),
					},
					# Core Unit Identifier
					'year' => {
						'per' => q({0}/жил),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(Ампер),
						'one' => q({0} Ампер),
						'other' => q({0} Ампер),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(Ампер),
						'one' => q({0} Ампер),
						'other' => q({0} Ампер),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(миллиАмпер),
						'one' => q({0} миллиАмпер),
						'other' => q({0} миллиАмпер),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(миллиАмпер),
						'one' => q({0} миллиАмпер),
						'other' => q({0} миллиАмпер),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ом),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ом),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(Вольт),
						'one' => q({0} Вольт),
						'other' => q({0} Вольт),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(Вольт),
						'one' => q({0} Вольт),
						'other' => q({0} Вольт),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(Британийн дулааны нэгж),
						'one' => q({0} британийн дулааны нэгж),
						'other' => q({0} британийн дулааны нэгж),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(Британийн дулааны нэгж),
						'one' => q({0} британийн дулааны нэгж),
						'other' => q({0} британийн дулааны нэгж),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(калори),
						'one' => q({0} калори),
						'other' => q({0} калори),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(калори),
						'one' => q({0} калори),
						'other' => q({0} калори),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'one' => q({0} электрон-Вольт),
						'other' => q({0} электрон-Вольт),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'one' => q({0} электрон-Вольт),
						'other' => q({0} электрон-Вольт),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(калори),
						'one' => q({0} калори),
						'other' => q({0} калори),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(калори),
						'one' => q({0} калори),
						'other' => q({0} калори),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'one' => q({0} Жоуль),
						'other' => q({0} Жоуль),
					},
					# Core Unit Identifier
					'joule' => {
						'one' => q({0} Жоуль),
						'other' => q({0} Жоуль),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(килокалори),
						'one' => q({0} килокалори),
						'other' => q({0} килокалори),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(килокалори),
						'one' => q({0} килокалори),
						'other' => q({0} килокалори),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'one' => q({0} килоЖоуль),
						'other' => q({0} килоЖоуль),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'one' => q({0} килоЖоуль),
						'other' => q({0} килоЖоуль),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(килоВатт-цаг),
						'one' => q({0} килоВатт-цаг),
						'other' => q({0} килоВатт-цаг),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(килоВатт-цаг),
						'one' => q({0} килоВатт-цаг),
						'other' => q({0} килоВатт-цаг),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(америк дулаан),
						'one' => q({0} америк дулаан),
						'other' => q({0} америк дулаан),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(америк дулаан),
						'one' => q({0} америк дулаан),
						'other' => q({0} америк дулаан),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(киловатт-цаг 100 километрт),
						'one' => q({0} киловатт-цаг 100 километрт),
						'other' => q({0} киловатт-цаг 100 километрт),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(киловатт-цаг 100 километрт),
						'one' => q({0} киловатт-цаг 100 километрт),
						'other' => q({0} киловатт-цаг 100 километрт),
					},
					# Long Unit Identifier
					'force-newton' => {
						'one' => q({0} ньютон),
						'other' => q({0} ньютон),
					},
					# Core Unit Identifier
					'newton' => {
						'one' => q({0} ньютон),
						'other' => q({0} ньютон),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'one' => q({0} фунт хүч),
						'other' => q({0} фунт хүч),
					},
					# Core Unit Identifier
					'pound-force' => {
						'one' => q({0} фунт хүч),
						'other' => q({0} фунт хүч),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(гигаГерц),
						'one' => q({0} гигаГерц),
						'other' => q({0} гигаГерц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(гигаГерц),
						'one' => q({0} гигаГерц),
						'other' => q({0} гигаГерц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Герц),
						'one' => q({0} Герц),
						'other' => q({0} Герц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Герц),
						'one' => q({0} Герц),
						'other' => q({0} Герц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(килоГерц),
						'one' => q({0} килоГерц),
						'other' => q({0} килоГерц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(килоГерц),
						'one' => q({0} килоГерц),
						'other' => q({0} килоГерц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(мегаГерц),
						'one' => q({0} мегаГерц),
						'other' => q({0} мегаГерц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(мегаГерц),
						'one' => q({0} мегаГерц),
						'other' => q({0} мегаГерц),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(пиксель/см),
						'one' => q({0} пиксель/см),
						'other' => q({0} пиксель/см),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(пиксель/см),
						'one' => q({0} пиксель/см),
						'other' => q({0} пиксель/см),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(пиксель/инч),
						'one' => q({0} пиксель/инч),
						'other' => q({0} пиксель/инч),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(пиксель/инч),
						'one' => q({0} пиксель/инч),
						'other' => q({0} пиксель/инч),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(сансрын нэгж),
						'one' => q({0} сансрын нэгж),
						'other' => q({0} сансрын нэгж),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(сансрын нэгж),
						'one' => q({0} сансрын нэгж),
						'other' => q({0} сансрын нэгж),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} см),
						'per' => q(сантиметр тутамд {0}),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} см),
						'per' => q(сантиметр тутамд {0}),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					# Long Unit Identifier
					'length-earth-radius' => {
						'name' => q(дэлхийн радиус),
						'one' => q({0} дэлхийн радиус),
						'other' => q({0} дэлхийн радиус),
					},
					# Core Unit Identifier
					'earth-radius' => {
						'name' => q(дэлхийн радиус),
						'one' => q({0} дэлхийн радиус),
						'other' => q({0} дэлхийн радиус),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0} фатом),
						'other' => q({0} фатом),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0} фатом),
						'other' => q({0} фатом),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонг),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонг),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
						'per' => q(километр тутамд {0}),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
						'per' => q(километр тутамд {0}),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(гэрлийн жил),
						'one' => q({0} гэрлийн жил),
						'other' => q({0} гэрлийн жил),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(гэрлийн жил),
						'one' => q({0} гэрлийн жил),
						'other' => q({0} гэрлийн жил),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q(метр тутамд {0}),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q(метр тутамд {0}),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(микрометр),
						'one' => q({0} микрометр),
						'other' => q({0} микрометр),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(микрометр),
						'one' => q({0} микрометр),
						'other' => q({0} микрометр),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'one' => q({0} скандинавын миль),
						'other' => q({0} скандинавын миль),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'one' => q({0} скандинавын миль),
						'other' => q({0} скандинавын миль),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(далайн миль),
						'one' => q({0} далайн миль),
						'other' => q({0} далайн миль),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(далайн миль),
						'one' => q({0} далайн миль),
						'other' => q({0} далайн миль),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					# Core Unit Identifier
					'parsec' => {
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0} нарны радиус),
						'other' => q({0} нарны радиус),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0} нарны радиус),
						'other' => q({0} нарны радиус),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кандел),
						'one' => q({0} кандел),
						'other' => q({0} кандел),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кандел),
						'one' => q({0} кандел),
						'other' => q({0} кандел),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(люмен),
						'one' => q({0} люмен),
						'other' => q({0} люмен),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(люмен),
						'one' => q({0} люмен),
						'other' => q({0} люмен),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'one' => q({0} нарны гэрлийн урсгал),
						'other' => q({0} нарны гэрлийн урсгал),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'one' => q({0} нарны гэрлийн урсгал),
						'other' => q({0} нарны гэрлийн урсгал),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Core Unit Identifier
					'carat' => {
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'one' => q({0} дальтон),
						'other' => q({0} дальтон),
					},
					# Core Unit Identifier
					'dalton' => {
						'one' => q({0} дальтон),
						'other' => q({0} дальтон),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} Дэлхийн масс),
						'other' => q({0} Дэлхийн масс),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} Дэлхийн масс),
						'other' => q({0} Дэлхийн масс),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q(грамм тутамд {0}),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q(грамм тутамд {0}),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
						'per' => q(килограмм тутамд {0}),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
						'per' => q(килограмм тутамд {0}),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'per' => q(унц тутамд {0}),
					},
					# Core Unit Identifier
					'ounce' => {
						'per' => q(унц тутамд {0}),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'one' => q({0} трой унц),
						'other' => q({0} трой унц),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'one' => q({0} трой унц),
						'other' => q({0} трой унц),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'per' => q(фунт тутамд {0}),
					},
					# Core Unit Identifier
					'pound' => {
						'per' => q(фунт тутамд {0}),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} нарны масс),
						'other' => q({0} нарны масс),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} нарны масс),
						'other' => q({0} нарны масс),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'one' => q({0} чулуу),
						'other' => q({0} чулуу),
					},
					# Core Unit Identifier
					'stone' => {
						'one' => q({0} чулуу),
						'other' => q({0} чулуу),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'one' => q({0} америк тонн),
						'other' => q({0} америк тонн),
					},
					# Core Unit Identifier
					'ton' => {
						'one' => q({0} америк тонн),
						'other' => q({0} америк тонн),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(тонн),
						'one' => q({0} тонн),
						'other' => q({0} тонн),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(тонн),
						'one' => q({0} тонн),
						'other' => q({0} тонн),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({1} тутамд {0}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({1} тутамд {0}),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(гигаВатт),
						'one' => q({0} гигаВатт),
						'other' => q({0} гигаВатт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(гигаВатт),
						'one' => q({0} гигаВатт),
						'other' => q({0} гигаВатт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(морины хүч),
						'one' => q({0} морины хүч),
						'other' => q({0} морины хүч),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(морины хүч),
						'one' => q({0} морины хүч),
						'other' => q({0} морины хүч),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(килоВатт),
						'one' => q({0} килоВатт),
						'other' => q({0} килоВатт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(килоВатт),
						'one' => q({0} килоВатт),
						'other' => q({0} килоВатт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(мегаВатт),
						'one' => q({0} мегаВатт),
						'other' => q({0} мегаВатт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(мегаВатт),
						'one' => q({0} мегаВатт),
						'other' => q({0} мегаВатт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(миллиВатт),
						'one' => q({0} миллиВатт),
						'other' => q({0} миллиВатт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(миллиВатт),
						'one' => q({0} миллиВатт),
						'other' => q({0} миллиВатт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} Ватт),
						'other' => q({0} Ватт),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} Ватт),
						'other' => q({0} Ватт),
					},
					# Long Unit Identifier
					'power2' => {
						'1' => q(квадрат {0}),
						'one' => q(квадрат {0}),
						'other' => q(квадрат {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'1' => q(квадрат {0}),
						'one' => q(квадрат {0}),
						'other' => q(квадрат {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'1' => q(куб {0}),
						'one' => q(куб {0}),
						'other' => q(куб {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'1' => q(куб {0}),
						'one' => q(куб {0}),
						'other' => q(куб {0}),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(уур амьсгал),
						'one' => q({0} уур амьсгал),
						'other' => q({0} уур амьсгал),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(уур амьсгал),
						'one' => q({0} уур амьсгал),
						'other' => q({0} уур амьсгал),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гектоПаскал),
						'one' => q({0} гектоПаскал),
						'other' => q({0} гектоПаскал),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гектоПаскал),
						'one' => q({0} гектоПаскал),
						'other' => q({0} гектоПаскал),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(мөнгөн усны баганын инч),
						'one' => q({0} мөнгөн усны баганын инч),
						'other' => q({0} мөнгөн усны баганын инч),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(мөнгөн усны баганын инч),
						'one' => q({0} мөнгөн усны баганын инч),
						'other' => q({0} мөнгөн усны баганын инч),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(килопаскаль),
						'one' => q({0} килопаскаль),
						'other' => q({0} килопаскаль),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(килопаскаль),
						'one' => q({0} килопаскаль),
						'other' => q({0} килопаскаль),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(мегаПаскаль),
						'one' => q({0} мегаПаскаль),
						'other' => q({0} мегаПаскаль),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(мегаПаскаль),
						'one' => q({0} мегаПаскаль),
						'other' => q({0} мегаПаскаль),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(мөнгөн усны баганын миллиметр),
						'one' => q({0} мөнгөн усны баганын миллиметр),
						'other' => q({0} мөнгөн усны баганын миллиметр),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(мөнгөн усны баганын миллиметр),
						'one' => q({0} мөнгөн усны баганын миллиметр),
						'other' => q({0} мөнгөн усны баганын миллиметр),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(Паскаль),
						'one' => q({0} Паскаль),
						'other' => q({0} Паскаль),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(Паскаль),
						'one' => q({0} Паскаль),
						'other' => q({0} Паскаль),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(квадрат инч тутамд ногдох фунт),
						'one' => q(квадрат инч тутамд {0} фунт),
						'other' => q(квадрат инч тутамд {0} фунт),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(квадрат инч тутамд ногдох фунт),
						'one' => q(квадрат инч тутамд {0} фунт),
						'other' => q(квадрат инч тутамд {0} фунт),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(цагт ногдох километр),
						'one' => q(цагт {0} километр),
						'other' => q(цагт {0} километр),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(цагт ногдох километр),
						'one' => q(цагт {0} километр),
						'other' => q(цагт {0} километр),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(зангилаа),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(зангилаа),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(секундэд ногдох метр),
						'one' => q(секундэд {0} метр),
						'other' => q(секундэд {0} метр),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(секундэд ногдох метр),
						'one' => q(секундэд {0} метр),
						'other' => q(секундэд {0} метр),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(цагт ногдох миль),
						'one' => q(цагт {0} миль),
						'other' => q(цагт {0} миль),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(цагт ногдох миль),
						'one' => q(цагт {0} миль),
						'other' => q(цагт {0} миль),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(Цельсийн хэм),
						'one' => q({0} Цельсийн хэм),
						'other' => q({0} Цельсийн хэм),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(Цельсийн хэм),
						'one' => q({0} Цельсийн хэм),
						'other' => q({0} Цельсийн хэм),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(Фаренгейтын хэм),
						'one' => q({0} Фаренгейтын хэм),
						'other' => q({0} Фаренгейтын хэм),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(Фаренгейтын хэм),
						'one' => q({0} Фаренгейтын хэм),
						'other' => q({0} Фаренгейтын хэм),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(Кельвиний хэм),
						'one' => q({0} Кельвиний хэм),
						'other' => q({0} Кельвиний хэм),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(Кельвиний хэм),
						'one' => q({0} Кельвиний хэм),
						'other' => q({0} Кельвиний хэм),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ньютон метр),
						'one' => q({0} ньютон метр),
						'other' => q({0} ньютон метр),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ньютон метр),
						'one' => q({0} ньютон метр),
						'other' => q({0} ньютон метр),
					},
					# Long Unit Identifier
					'torque-pound-force-foot' => {
						'name' => q(фунт фүүт),
						'one' => q({0} фунт фүүт),
						'other' => q({0} фунт фүүт),
					},
					# Core Unit Identifier
					'pound-force-foot' => {
						'name' => q(фунт фүүт),
						'one' => q({0} фунт фүүт),
						'other' => q({0} фунт фүүт),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фут),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр-фут),
						'one' => q({0} акр-фут),
						'other' => q({0} акр-фут),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(центилитр),
						'one' => q({0} центилитр),
						'other' => q({0} центилитр),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(центилитр),
						'one' => q({0} центилитр),
						'other' => q({0} центилитр),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(куб сантиметр),
						'one' => q({0} куб сантиметр),
						'other' => q({0} куб сантиметр),
						'per' => q(куб сантиметр тутамд {0}),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(куб сантиметр),
						'one' => q({0} куб сантиметр),
						'other' => q({0} куб сантиметр),
						'per' => q(куб сантиметр тутамд {0}),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(куб фут),
						'one' => q({0} куб фут),
						'other' => q({0} куб фут),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(куб фут),
						'one' => q({0} куб фут),
						'other' => q({0} куб фут),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(куб инч),
						'one' => q({0} куб инч),
						'other' => q({0} куб инч),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(куб инч),
						'one' => q({0} куб инч),
						'other' => q({0} куб инч),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(куб километр),
						'one' => q({0} куб километр),
						'other' => q({0} куб километр),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(куб километр),
						'one' => q({0} куб километр),
						'other' => q({0} куб километр),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(куб метр),
						'one' => q({0} куб метр),
						'other' => q({0} куб метр),
						'per' => q(куб метр тутамд {0}),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(куб метр),
						'one' => q({0} куб метр),
						'other' => q({0} куб метр),
						'per' => q(куб метр тутамд {0}),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(куб миль),
						'one' => q({0} куб миль),
						'other' => q({0} куб миль),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(куб миль),
						'one' => q({0} куб миль),
						'other' => q({0} куб миль),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(куб ярд),
						'one' => q({0} куб ярд),
						'other' => q({0} куб ярд),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(куб ярд),
						'one' => q({0} куб ярд),
						'other' => q({0} куб ярд),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0} аяга),
						'other' => q({0} аяга),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0} аяга),
						'other' => q({0} аяга),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(метрийн аяга),
						'one' => q({0} метрийн аяга),
						'other' => q({0} метрийн аяга),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(метрийн аяга),
						'one' => q({0} метрийн аяга),
						'other' => q({0} метрийн аяга),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(амттаны халбага),
						'one' => q({0} амттаны халбага),
						'other' => q({0} амттаны халбага),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(амттаны халбага),
						'one' => q({0} амттаны халбага),
						'other' => q({0} амттаны халбага),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(Том амттаны халбага),
						'one' => q({0} том амттаны халбага),
						'other' => q({0} том амттаны халбага),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(Том амттаны халбага),
						'one' => q({0} том амттаны халбага),
						'other' => q({0} том амттаны халбага),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(драм),
						'one' => q({0} драм),
						'other' => q({0} драм),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(драм),
						'one' => q({0} драм),
						'other' => q({0} драм),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(шингэн унц),
						'one' => q({0} шингэн унц),
						'other' => q({0} шингэн унц),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(шингэн унц),
						'one' => q({0} шингэн унц),
						'other' => q({0} шингэн унц),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(анг. шингэн унц),
						'one' => q({0} анг. шингэн унц),
						'other' => q({0} анг. шингэн унц),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(анг. шингэн унц),
						'one' => q({0} анг. шингэн унц),
						'other' => q({0} анг. шингэн унц),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q(галлон тутамд {0}),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q(галлон тутамд {0}),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(анг. галлон),
						'one' => q({0} анг. галлон),
						'other' => q({0} анг. галлон),
						'per' => q(анг. галлон тутамд {0}),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(анг. галлон),
						'one' => q({0} анг. галлон),
						'other' => q({0} анг. галлон),
						'per' => q(анг. галлон тутамд {0}),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(хектолитр),
						'one' => q({0} хектолитр),
						'other' => q({0} хектолитр),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(хектолитр),
						'one' => q({0} хектолитр),
						'other' => q({0} хектолитр),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q(литр тутамд {0}),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q(литр тутамд {0}),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'one' => q({0} пинт),
						'other' => q({0} пинт),
					},
					# Core Unit Identifier
					'pint' => {
						'one' => q({0} пинт),
						'other' => q({0} пинт),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(метрийн пинт),
						'one' => q({0} метрийн пинт),
						'other' => q({0} метрийн пинт),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(метрийн пинт),
						'one' => q({0} метрийн пинт),
						'other' => q({0} метрийн пинт),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(кварц),
						'one' => q({0} кварц),
						'other' => q({0} кварц),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(кварц),
						'one' => q({0} кварц),
						'other' => q({0} кварц),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(Том куарт),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(Том куарт),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(хоолны халбага),
						'one' => q({0} хоолны халбага),
						'other' => q({0} хоолны халбага),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(хоолны халбага),
						'one' => q({0} хоолны халбага),
						'other' => q({0} хоолны халбага),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(цайны халбага),
						'one' => q({0} цайны халбага),
						'other' => q({0} цайны халбага),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(цайны халбага),
						'one' => q({0} цайны халбага),
						'other' => q({0} цайны халбага),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(гравитацын тогтмол хүч),
						'one' => q({0} гравитацын тогтмол хүч),
						'other' => q({0} гравитацын тогтмол хүч),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(гравитацын тогтмол хүч),
						'one' => q({0} гравитацын тогтмол хүч),
						'other' => q({0} гравитацын тогтмол хүч),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(м/с²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(м/с²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} фт²),
						'other' => q({0} фт²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} фт²),
						'other' => q({0} фт²),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(‰),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(ppm),
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(ppm),
						'one' => q({0}ppm),
						'other' => q({0}ppm),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(‱),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(‱),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'one' => q({0} л/100км),
						'other' => q({0}л/100км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'one' => q({0} л/100км),
						'other' => q({0}л/100км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(ми/анг. гал),
						'one' => q({0} ми/анг.гал),
						'other' => q({0} ми/анг.гал),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(ми/анг. гал),
						'one' => q({0} ми/анг.гал),
						'other' => q({0} ми/анг.гал),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} ц),
						'other' => q({0} ц),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} ц),
						'other' => q({0} ц),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(мсек),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(мсек),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0}с),
						'other' => q({0}с),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0}с),
						'other' => q({0}с),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(д.х),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(д.х),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0}ж),
						'other' => q({0}ж),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0}ж),
						'other' => q({0}ж),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}кВт.ц/100км),
						'other' => q({0}кВт.ц/100км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'one' => q({0}кВт.ц/100км),
						'other' => q({0}кВт.ц/100км),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(lbf),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(lbf),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'one' => q({0}цэг),
						'other' => q({0}цэг),
					},
					# Core Unit Identifier
					'dot' => {
						'one' => q({0}цэг),
						'other' => q({0}цэг),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(цэг/инч),
						'one' => q({0} цэг/инч),
						'other' => q({0} цэг/инч),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(цэг/инч),
						'one' => q({0} цэг/инч),
						'other' => q({0} цэг/инч),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(au),
						'one' => q({0}au),
						'other' => q({0}au),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0}au),
						'other' => q({0}au),
					},
					# Long Unit Identifier
					'length-foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'foot' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонг),
					},
					# Core Unit Identifier
					'furlong' => {
						'one' => q({0} фурлонг),
						'other' => q({0} фурлонг),
					},
					# Long Unit Identifier
					'length-inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'inch' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(метр),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(метр),
					},
					# Long Unit Identifier
					'length-mile' => {
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					# Core Unit Identifier
					'mile' => {
						'one' => q({0} миль),
						'other' => q({0} миль),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'one' => q({0} ск.миль),
						'other' => q({0} ск.миль),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'one' => q({0} ск.миль),
						'other' => q({0} ск.миль),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(R☉),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(R☉),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(кандел),
						'one' => q({0} кандел),
						'other' => q({0} кандел),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(кандел),
						'one' => q({0} кандел),
						'other' => q({0} кандел),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(люмен),
						'one' => q({0} люмен),
						'other' => q({0} люмен),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(люмен),
						'one' => q({0} люмен),
						'other' => q({0} люмен),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(L☉),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(L☉),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					# Core Unit Identifier
					'pound' => {
						'one' => q({0}#),
						'other' => q({0}#),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0} м.х.),
						'other' => q({0} м.х.),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0} м.х.),
						'other' => q({0} м.х.),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0} кватт),
						'other' => q({0} кватт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0} кватт),
						'other' => q({0} кватт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(уур амьсгал),
						'one' => q({0} уур амьсгал),
						'other' => q({0} уур амьсгал),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(уур амьсгал),
						'one' => q({0} уур амьсгал),
						'other' => q({0} уур амьсгал),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} муб),
						'other' => q({0} муб),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} муб),
						'other' => q({0} муб),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} милбар),
						'other' => q({0} милбар),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} милбар),
						'other' => q({0} милбар),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(км/ц),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(км/ц),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(м/с),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(м/с),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ми/ц),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ми/ц),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(°C),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(°C),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0}K),
						'other' => q({0}K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0}K),
						'other' => q({0}K),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'one' => q({0} аяга),
						'other' => q({0} аяга),
					},
					# Core Unit Identifier
					'cup' => {
						'one' => q({0} аяга),
						'other' => q({0} аяга),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'per' => q({0} гал),
					},
					# Core Unit Identifier
					'gallon' => {
						'per' => q({0} гал),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(анг.гал),
						'one' => q({0} анг.гал),
						'other' => q({0} анг.гал),
						'per' => q({0} анг.гал),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(анг.гал),
						'one' => q({0} анг.гал),
						'other' => q({0} анг.гал),
						'per' => q({0} анг.гал),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(зүг),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(зүг),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q(Ки{0}),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q(Ми{0}),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q(Ги{0}),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q(Ти{0}),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q(Пи{0}),
					},
					# Long Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Core Unit Identifier
					'1024p6' => {
						'1' => q(Эи{0}),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q(Зи{0}),
					},
					# Long Unit Identifier
					'1024p8' => {
						'1' => q(Яи{0}),
					},
					# Core Unit Identifier
					'1024p8' => {
						'1' => q(Яи{0}),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(д{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(д{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(п{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(п{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ф{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ф{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(а{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(а{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(с{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(с{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(з{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(з{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ё{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ё{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(м{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(м{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(н{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(н{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(да{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(Т{0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(П{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(Э{0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(х{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(х{0}),
					},
					# Long Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Core Unit Identifier
					'10p21' => {
						'1' => q(З{0}),
					},
					# Long Unit Identifier
					'10p24' => {
						'1' => q(Ё{0}),
					},
					# Core Unit Identifier
					'10p24' => {
						'1' => q(Ё{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(к{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(М{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(Г{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(Жи),
						'one' => q({0} Жи),
						'other' => q({0} Жи),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(Жи),
						'one' => q({0} Жи),
						'other' => q({0} Жи),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(аркмин),
						'one' => q({0} аркмин),
						'other' => q({0} аркмин),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(аркмин),
						'one' => q({0} аркмин),
						'other' => q({0} аркмин),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(арксек),
						'one' => q({0} арксек),
						'other' => q({0} арксек),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(хэм),
						'one' => q({0} хэм),
						'other' => q({0} хэм),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(хэм),
						'one' => q({0} хэм),
						'other' => q({0} хэм),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(эргэлт),
						'one' => q({0} эргэлт),
						'other' => q({0} эргэлт),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(эргэлт),
						'one' => q({0} эргэлт),
						'other' => q({0} эргэлт),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(дунам),
						'one' => q({0} дунам),
						'other' => q({0} дунам),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(дунам),
						'one' => q({0} дунам),
						'other' => q({0} дунам),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(см²),
						'one' => q({0} см²),
						'other' => q({0} см²),
						'per' => q({0}/см²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(фут²),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(фут²),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(инч²),
						'one' => q({0} инч²),
						'other' => q({0} инч²),
						'per' => q({0}/инч²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(инч²),
						'one' => q({0} инч²),
						'other' => q({0} инч²),
						'per' => q({0}/инч²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
						'per' => q({0}/км²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(миль²),
						'one' => q({0} миль²),
						'other' => q({0} миль²),
						'per' => q({0}/миль²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(миль²),
						'one' => q({0} миль²),
						'other' => q({0} миль²),
						'per' => q({0}/миль²),
					},
					# Long Unit Identifier
					'area-square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					# Core Unit Identifier
					'square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(зүйл),
						'one' => q({0} зүйл),
						'other' => q({0} зүйл),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(зүйл),
						'one' => q({0} зүйл),
						'other' => q({0} зүйл),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(карат),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(карат),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'one' => q({0} мг/дл),
						'other' => q({0} мг/дл),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(мг/дл),
						'one' => q({0} мг/дл),
						'other' => q({0} мг/дл),
					},
					# Long Unit Identifier
					'concentr-millimole-per-liter' => {
						'name' => q(миллимоль/литр),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Core Unit Identifier
					'millimole-per-liter' => {
						'name' => q(миллимоль/литр),
						'one' => q({0} ммоль/л),
						'other' => q({0} ммоль/л),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'name' => q(моль),
						'one' => q({0} моль),
						'other' => q({0} моль),
					},
					# Core Unit Identifier
					'mole' => {
						'name' => q(моль),
						'one' => q({0} моль),
						'other' => q({0} моль),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(хувь),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(хувь),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(мянганы хувь),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(мянганы хувь),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'name' => q(хувь/сая),
						'one' => q({0}x10⁻⁶),
						'other' => q({0}x10⁻⁶),
					},
					# Core Unit Identifier
					'permillion' => {
						'name' => q(хувь/сая),
						'one' => q({0}x10⁻⁶),
						'other' => q({0}x10⁻⁶),
					},
					# Long Unit Identifier
					'concentr-permyriad' => {
						'name' => q(арван мянганы хувь),
					},
					# Core Unit Identifier
					'permyriad' => {
						'name' => q(арван мянганы хувь),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(л/100км),
						'one' => q({0} л/100км),
						'other' => q({0} л/100км),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(л/100км),
						'one' => q({0} л/100км),
						'other' => q({0} л/100км),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(миль/гал),
						'one' => q(миль/гал),
						'other' => q({0} ми/гал),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(миль/гал),
						'one' => q(миль/гал),
						'other' => q({0} ми/гал),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon-imperial' => {
						'name' => q(миль/анг. гал),
						'one' => q({0} ми/анг. гал),
						'other' => q({0} ми/анг. гал),
					},
					# Core Unit Identifier
					'mile-per-gallon-imperial' => {
						'name' => q(миль/анг. гал),
						'one' => q({0} ми/анг. гал),
						'other' => q({0} ми/анг. гал),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0} з.у),
						'north' => q({0} х.ө),
						'south' => q({0} ө.ө),
						'west' => q({0} б.у),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0} з.у),
						'north' => q({0} х.ө),
						'south' => q({0} ө.ө),
						'west' => q({0} б.у),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Мб),
						'other' => q({0} Мб),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(Мбайт),
						'one' => q({0} МБ),
						'other' => q({0} МБ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ПБайт),
						'one' => q({0} ПБ),
						'other' => q({0} ПБ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ПБайт),
						'one' => q({0} ПБ),
						'other' => q({0} ПБ),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Тб),
						'other' => q({0} Тб),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(Тбайт),
						'one' => q({0} ТБ),
						'other' => q({0} ТБ),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(зуун),
						'one' => q({0} зуун),
						'other' => q({0} зуун),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(зуун),
						'one' => q({0} зуун),
						'other' => q({0} зуун),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(хоног),
						'one' => q({0} хоног),
						'other' => q({0} хоног),
						'per' => q({0}/хоног),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(хоног),
						'one' => q({0} хоног),
						'other' => q({0} хоног),
						'per' => q({0}/хоног),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(декад),
						'one' => q({0} декад),
						'other' => q({0} декад),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(декад),
						'one' => q({0} декад),
						'other' => q({0} декад),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(цаг),
						'one' => q({0} цаг),
						'other' => q({0} цаг),
						'per' => q({0}/ц),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(цаг),
						'one' => q({0} цаг),
						'other' => q({0} цаг),
						'per' => q({0}/ц),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(μсек),
						'one' => q({0} μсек),
						'other' => q({0} μсек),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(μсек),
						'one' => q({0} μсек),
						'other' => q({0} μсек),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(мин),
						'one' => q({0} мин),
						'other' => q({0} мин),
						'per' => q({0}/мин),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
						'per' => q({0}/сар),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(сар),
						'one' => q({0} сар),
						'other' => q({0} сар),
						'per' => q({0}/сар),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(наносек),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(улирал),
						'one' => q({0} улирал),
						'other' => q({0} улирал),
						'per' => q({0}/улирал),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(улирал),
						'one' => q({0} улирал),
						'other' => q({0} улирал),
						'per' => q({0}/улирал),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q({0}/сек),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(сек),
						'one' => q({0} сек),
						'other' => q({0} сек),
						'per' => q({0}/сек),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(долоо хоног),
						'one' => q({0} д.х),
						'other' => q({0} д.х),
						'per' => q({0}/д.х),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(долоо хоног),
						'one' => q({0} д.х),
						'other' => q({0} д.х),
						'per' => q({0}/д.х),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
						'per' => q({0}/ж),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(жил),
						'one' => q({0} жил),
						'other' => q({0} жил),
						'per' => q({0}/ж),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'name' => q(А),
						'one' => q({0} А),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'name' => q(А),
						'one' => q({0} А),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-milliampere' => {
						'name' => q(мА),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					# Core Unit Identifier
					'milliampere' => {
						'name' => q(мА),
						'one' => q({0} мА),
						'other' => q({0} мА),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'name' => q(Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'name' => q(Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'name' => q(В),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					# Core Unit Identifier
					'volt' => {
						'name' => q(В),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					# Long Unit Identifier
					'energy-british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Core Unit Identifier
					'british-thermal-unit' => {
						'name' => q(BTU),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(электрон-Вольт),
						'one' => q({0} эВ),
						'other' => q({0} эВ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(электрон-Вольт),
						'one' => q({0} эВ),
						'other' => q({0} эВ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					# Long Unit Identifier
					'energy-joule' => {
						'name' => q(Жоуль),
						'one' => q({0} Ж),
						'other' => q({0} Ж),
					},
					# Core Unit Identifier
					'joule' => {
						'name' => q(Жоуль),
						'one' => q({0} Ж),
						'other' => q({0} Ж),
					},
					# Long Unit Identifier
					'energy-kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Core Unit Identifier
					'kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					# Long Unit Identifier
					'energy-kilojoule' => {
						'name' => q(килоЖоуль),
						'one' => q({0} кЖ),
						'other' => q({0} кЖ),
					},
					# Core Unit Identifier
					'kilojoule' => {
						'name' => q(килоЖоуль),
						'one' => q({0} кЖ),
						'other' => q({0} кЖ),
					},
					# Long Unit Identifier
					'energy-kilowatt-hour' => {
						'name' => q(кВт-цаг),
						'one' => q({0} кВтц),
						'other' => q({0} кВтц),
					},
					# Core Unit Identifier
					'kilowatt-hour' => {
						'name' => q(кВт-цаг),
						'one' => q({0} кВтц),
						'other' => q({0} кВтц),
					},
					# Long Unit Identifier
					'energy-therm-us' => {
						'name' => q(ам.дулаан),
						'one' => q({0} ам.дулаан),
						'other' => q({0} ам.дулаан),
					},
					# Core Unit Identifier
					'therm-us' => {
						'name' => q(ам.дулаан),
						'one' => q({0} ам.дулаан),
						'other' => q({0} ам.дулаан),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт.ц/100 км),
						'one' => q({0} кВт.ц/100 км),
						'other' => q({0} кВт.ц/100 км),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(кВт.ц/100 км),
						'one' => q({0} кВт.ц/100 км),
						'other' => q({0} кВт.ц/100 км),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(ньютон),
						'one' => q({0} Н),
						'other' => q({0} Н),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(ньютон),
						'one' => q({0} Н),
						'other' => q({0} Н),
					},
					# Long Unit Identifier
					'force-pound-force' => {
						'name' => q(фунт хүч),
					},
					# Core Unit Identifier
					'pound-force' => {
						'name' => q(фунт хүч),
					},
					# Long Unit Identifier
					'frequency-gigahertz' => {
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					# Core Unit Identifier
					'gigahertz' => {
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					# Core Unit Identifier
					'hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					# Long Unit Identifier
					'frequency-kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					# Core Unit Identifier
					'kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					# Long Unit Identifier
					'frequency-megahertz' => {
						'name' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					# Core Unit Identifier
					'megahertz' => {
						'name' => q(МГц),
						'one' => q({0} МГц),
						'other' => q({0} МГц),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(цэг),
						'one' => q({0} цэг),
						'other' => q({0} цэг),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(цэг),
						'one' => q({0} цэг),
						'other' => q({0} цэг),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(цэг/см),
						'one' => q({0} цэг/см),
						'other' => q({0} цэг/см),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(цэг/см),
						'one' => q({0} цэг/см),
						'other' => q({0} цэг/см),
					},
					# Long Unit Identifier
					'length-astronomical-unit' => {
						'name' => q(сн),
						'one' => q({0} сн),
						'other' => q({0} сн),
					},
					# Core Unit Identifier
					'astronomical-unit' => {
						'name' => q(сн),
						'one' => q({0} сн),
						'other' => q({0} сн),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(фатом),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(фатом),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(фурлонг),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(фурлонг),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(инч),
						'one' => q({0} инч),
						'other' => q({0} инч),
						'per' => q({0}/инч),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(инч),
						'one' => q({0} инч),
						'other' => q({0} инч),
						'per' => q({0}/инч),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(гэрл. жил),
						'one' => q({0} гэрл.жил),
						'other' => q({0} гэрл.жил),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(гэрл. жил),
						'one' => q({0} гэрл.жил),
						'other' => q({0} гэрл.жил),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(м),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(μметр),
						'one' => q({0} μм),
						'other' => q({0} μм),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(μметр),
						'one' => q({0} μм),
						'other' => q({0} μм),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(миль),
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(миль),
						'one' => q({0} ми),
						'other' => q({0} ми),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(скандинавын миль),
						'one' => q({0} ск. миль),
						'other' => q({0} ск. миль),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(скандинавын миль),
						'one' => q({0} ск. миль),
						'other' => q({0} ск. миль),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(дми),
						'one' => q({0} дми),
						'other' => q({0} дми),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(дми),
						'one' => q({0} дми),
						'other' => q({0} дми),
					},
					# Long Unit Identifier
					'length-parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					# Core Unit Identifier
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(пм),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(оноо),
						'one' => q({0} оноо),
						'other' => q({0} оноо),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(оноо),
						'one' => q({0} оноо),
						'other' => q({0} оноо),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(нарны радиус),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(нарны радиус),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					# Long Unit Identifier
					'light-solar-luminosity' => {
						'name' => q(нарны гэрлийн урсгал),
					},
					# Core Unit Identifier
					'solar-luminosity' => {
						'name' => q(нарны гэрлийн урсгал),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(карат),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(карат),
						'one' => q({0} кар),
						'other' => q({0} кар),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(дальтон),
						'one' => q({0} Да),
						'other' => q({0} Да),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(дальтон),
						'one' => q({0} Да),
						'other' => q({0} Да),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(Дэлхийн масс),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(Дэлхийн масс),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(үр),
						'one' => q({0} үр),
						'other' => q({0} үр),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(үр),
						'one' => q({0} үр),
						'other' => q({0} үр),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(грамм),
						'one' => q({0} гр),
						'other' => q({0} гр),
						'per' => q({0}/гр),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} гр),
						'other' => q({0} гр),
						'per' => q({0}/гр),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'name' => q(μг),
						'one' => q({0} μг),
						'other' => q({0} μг),
					},
					# Core Unit Identifier
					'microgram' => {
						'name' => q(μг),
						'one' => q({0} μг),
						'other' => q({0} μг),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(унц),
						'one' => q({0} унц),
						'other' => q({0} унц),
						'per' => q({0}/унц),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(унц),
						'one' => q({0} унц),
						'other' => q({0} унц),
						'per' => q({0}/унц),
					},
					# Long Unit Identifier
					'mass-ounce-troy' => {
						'name' => q(трой унц),
						'one' => q({0} тр.унц),
						'other' => q({0} тр.унц),
					},
					# Core Unit Identifier
					'ounce-troy' => {
						'name' => q(трой унц),
						'one' => q({0} тр.унц),
						'other' => q({0} тр.унц),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(нарны масс),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(нарны масс),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(чулуу),
						'one' => q({0} ч),
						'other' => q({0} ч),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(чулуу),
						'one' => q({0} ч),
						'other' => q({0} ч),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(америк тонн),
						'one' => q({0} ам. тн),
						'other' => q({0} ам. тн),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(америк тонн),
						'one' => q({0} ам. тн),
						'other' => q({0} ам. тн),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					# Long Unit Identifier
					'power-gigawatt' => {
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					# Core Unit Identifier
					'gigawatt' => {
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(мх),
						'one' => q({0} мх),
						'other' => q({0} мх),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(мх),
						'one' => q({0} мх),
						'other' => q({0} мх),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(кВт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					# Long Unit Identifier
					'power-megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					# Core Unit Identifier
					'megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					# Long Unit Identifier
					'power-milliwatt' => {
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					# Core Unit Identifier
					'milliwatt' => {
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(Ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(Ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атм),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(атм),
						'one' => q({0} атм),
						'other' => q({0} атм),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(бар),
						'one' => q({0} бар),
						'other' => q({0} бар),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(бар),
						'one' => q({0} бар),
						'other' => q({0} бар),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(гПа),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(инч.муб),
						'one' => q({0} инч.муб),
						'other' => q({0} инч.муб),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(инч.муб),
						'one' => q({0} инч.муб),
						'other' => q({0} инч.муб),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(кПа),
						'one' => q({0} кПа),
						'other' => q({0} кПа),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(кПа),
						'one' => q({0} кПа),
						'other' => q({0} кПа),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(МПа),
						'one' => q({0} МПа),
						'other' => q({0} МПа),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(МПа),
						'one' => q({0} МПа),
						'other' => q({0} МПа),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(мбар),
						'one' => q({0} мбар),
						'other' => q({0} мбар),
					},
					# Long Unit Identifier
					'pressure-millimeter-ofhg' => {
						'name' => q(мм.муб),
						'one' => q({0} мм.муб),
						'other' => q({0} мм.муб),
					},
					# Core Unit Identifier
					'millimeter-ofhg' => {
						'name' => q(мм.муб),
						'one' => q({0} мм.муб),
						'other' => q({0} мм.муб),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(Па),
						'one' => q({0} Па),
						'other' => q({0} Па),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(Па),
						'one' => q({0} Па),
						'other' => q({0} Па),
					},
					# Long Unit Identifier
					'pressure-pound-force-per-square-inch' => {
						'name' => q(фунт/инч²),
						'one' => q({0} фунт/инч²),
						'other' => q({0} фунт/инч²),
					},
					# Core Unit Identifier
					'pound-force-per-square-inch' => {
						'name' => q(фунт/инч²),
						'one' => q({0} фунт/инч²),
						'other' => q({0} фунт/инч²),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(км/цаг),
						'one' => q({0} км/ц),
						'other' => q({0} км/ц),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(км/цаг),
						'one' => q({0} км/ц),
						'other' => q({0} км/ц),
					},
					# Long Unit Identifier
					'speed-knot' => {
						'name' => q(занг.),
						'one' => q({0} занг.),
						'other' => q({0} занг.),
					},
					# Core Unit Identifier
					'knot' => {
						'name' => q(занг.),
						'one' => q({0} занг.),
						'other' => q({0} занг.),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(метр/сек),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(метр/сек),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(миль/цаг),
						'one' => q({0} ми/ц),
						'other' => q({0} ми/ц),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(миль/цаг),
						'one' => q({0} ми/ц),
						'other' => q({0} ми/ц),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(C хэм),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(C хэм),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(F хэм),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(F хэм),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0}°К),
						'other' => q({0}°К),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0}°К),
						'other' => q({0}°К),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(Н⋅м),
						'one' => q({0} Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(Н⋅м),
						'one' => q({0} Н⋅м),
						'other' => q({0} Н⋅м),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(акр фут),
						'one' => q({0} акр фут),
						'other' => q({0} акр фут),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(акр фут),
						'one' => q({0} акр фут),
						'other' => q({0} акр фут),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(баррель),
						'one' => q({0} баррель),
						'other' => q({0} баррель),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(баррель),
						'one' => q({0} баррель),
						'other' => q({0} баррель),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(цл),
						'one' => q({0} цл),
						'other' => q({0} цл),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(цл),
						'one' => q({0} цл),
						'other' => q({0} цл),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(см³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(см³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фут³),
						'other' => q({0} фут³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(инч³),
						'one' => q({0} инч³),
						'other' => q({0} инч³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(инч³),
						'one' => q({0} инч³),
						'other' => q({0} инч³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ми³),
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ми³),
						'one' => q({0} ми³),
						'other' => q({0} ми³),
					},
					# Long Unit Identifier
					'volume-cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					# Core Unit Identifier
					'cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(аяга),
						'one' => q({0} а),
						'other' => q({0} а),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(аяга),
						'one' => q({0} а),
						'other' => q({0} а),
					},
					# Long Unit Identifier
					'volume-cup-metric' => {
						'name' => q(м.аяга),
						'one' => q({0} м.аяга),
						'other' => q({0} м.аяга),
					},
					# Core Unit Identifier
					'cup-metric' => {
						'name' => q(м.аяга),
						'one' => q({0} м.аяга),
						'other' => q({0} м.аяга),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(амт.х),
						'one' => q({0} амт.х),
						'other' => q({0} амт.х),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(амт.х),
						'one' => q({0} амт.х),
						'other' => q({0} амт.х),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(том амт.х),
						'one' => q({0} том амт.х),
						'other' => q({0} том амт.х),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(том амт.х),
						'one' => q({0} том амт.х),
						'other' => q({0} том амт.х),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(драм шингэн),
						'one' => q({0} драм.ш),
						'other' => q({0} драм.ш),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(драм шингэн),
						'one' => q({0} драм.ш),
						'other' => q({0} драм.ш),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(дусал),
						'one' => q({0} дусал),
						'other' => q({0} дусал),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(дусал),
						'one' => q({0} дусал),
						'other' => q({0} дусал),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(ш.унц),
						'one' => q({0} ш.унц),
						'other' => q({0} ш.унц),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(ш.унц),
						'one' => q({0} ш.унц),
						'other' => q({0} ш.унц),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(анг. ш.унц),
						'one' => q({0} анг. ш.унц),
						'other' => q({0} анг. ш.унц),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(анг. ш.унц),
						'one' => q({0} анг. ш.унц),
						'other' => q({0} анг. ш.унц),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(гал),
						'one' => q({0} гал),
						'other' => q({0} гал),
						'per' => q({0}/ам. гал),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(гал),
						'one' => q({0} гал),
						'other' => q({0} гал),
						'per' => q({0}/ам. гал),
					},
					# Long Unit Identifier
					'volume-gallon-imperial' => {
						'name' => q(анг. гал),
						'one' => q({0} анг. гал),
						'other' => q({0} анг. гал),
						'per' => q({0}/анг. гал),
					},
					# Core Unit Identifier
					'gallon-imperial' => {
						'name' => q(анг. гал),
						'one' => q({0} анг. гал),
						'other' => q({0} анг. гал),
						'per' => q({0}/анг. гал),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'name' => q(хл),
						'one' => q({0} хл),
						'other' => q({0} хл),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'name' => q(хл),
						'one' => q({0} хл),
						'other' => q({0} хл),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(джиггер),
						'one' => q({0} джиггер),
						'other' => q({0} джиггер),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(джиггер),
						'one' => q({0} джиггер),
						'other' => q({0} джиггер),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(чимх),
						'one' => q({0} чимх),
						'other' => q({0} чимх),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(чимх),
						'one' => q({0} чимх),
						'other' => q({0} чимх),
					},
					# Long Unit Identifier
					'volume-pint' => {
						'name' => q(пинт),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					# Core Unit Identifier
					'pint' => {
						'name' => q(пинт),
						'one' => q({0} пт),
						'other' => q({0} пт),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'name' => q(мпт),
						'one' => q({0} мпт),
						'other' => q({0} мпт),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'name' => q(мпт),
						'one' => q({0} мпт),
						'other' => q({0} мпт),
					},
					# Long Unit Identifier
					'volume-quart' => {
						'name' => q(крц),
						'one' => q({0} крц),
						'other' => q({0} крц),
					},
					# Core Unit Identifier
					'quart' => {
						'name' => q(крц),
						'one' => q({0} крц),
						'other' => q({0} крц),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(том куарт),
						'one' => q({0} том куарт),
						'other' => q({0} том куарт),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(том куарт),
						'one' => q({0} том куарт),
						'other' => q({0} том куарт),
					},
					# Long Unit Identifier
					'volume-tablespoon' => {
						'name' => q(х.х),
						'one' => q({0} х.х),
						'other' => q({0} х.х),
					},
					# Core Unit Identifier
					'tablespoon' => {
						'name' => q(х.х),
						'one' => q({0} х.х),
						'other' => q({0} х.х),
					},
					# Long Unit Identifier
					'volume-teaspoon' => {
						'name' => q(ц.х),
						'one' => q({0} ц.х),
						'other' => q({0} ц.х),
					},
					# Core Unit Identifier
					'teaspoon' => {
						'name' => q(ц.х),
						'one' => q({0} ц.х),
						'other' => q({0} ц.х),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:тийм|т|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:үгүй|ү|no|n)$' }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 мянга',
					'other' => '0 мянга',
				},
				'10000' => {
					'one' => '00 мянга',
					'other' => '00 мянга',
				},
				'100000' => {
					'one' => '000 мянга',
					'other' => '000 мянга',
				},
				'1000000' => {
					'one' => '0 сая',
					'other' => '0 сая',
				},
				'10000000' => {
					'one' => '00 сая',
					'other' => '00 сая',
				},
				'100000000' => {
					'one' => '000 сая',
					'other' => '000 сая',
				},
				'1000000000' => {
					'one' => '0 тэрбум',
					'other' => '0 тэрбум',
				},
				'10000000000' => {
					'one' => '00 тэрбум',
					'other' => '00 тэрбум',
				},
				'100000000000' => {
					'one' => '000 тэрбум',
					'other' => '000 тэрбум',
				},
				'1000000000000' => {
					'one' => '0 их наяд',
					'other' => '0 их наяд',
				},
				'10000000000000' => {
					'one' => '00 их наяд',
					'other' => '00 их наяд',
				},
				'100000000000000' => {
					'one' => '000 их наяд',
					'other' => '000 их наяд',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 мянга',
					'other' => '0 мянга',
				},
				'10000' => {
					'one' => '00 мянга',
					'other' => '00 мянга',
				},
				'100000' => {
					'one' => '000 мянга',
					'other' => '000 мянга',
				},
				'1000000' => {
					'one' => '0 сая',
					'other' => '0 сая',
				},
				'10000000' => {
					'one' => '00 сая',
					'other' => '00 сая',
				},
				'100000000' => {
					'one' => '000 сая',
					'other' => '000 сая',
				},
				'1000000000' => {
					'one' => '0 тэрбум',
					'other' => '0 тэрбум',
				},
				'10000000000' => {
					'one' => '00 тэрбум',
					'other' => '00 тэрбум',
				},
				'100000000000' => {
					'one' => '000Т',
					'other' => '000Т',
				},
				'1000000000000' => {
					'one' => '0ИН',
					'other' => '0ИН',
				},
				'10000000000000' => {
					'one' => '00ИН',
					'other' => '00ИН',
				},
				'100000000000000' => {
					'one' => '000ИН',
					'other' => '000ИН',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##0.00)',
						'positive' => '#,##0.00',
					},
					'standard' => {
						'positive' => '¤ 0 мянга',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(арабын нэгдсэн эмиратын дирхам),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(Афганистаны афгани),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(Албанийн лек),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(Арменийн драм),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(Нидерландын Антиллийн гулдер),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(Анголын кванза),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(Аргентины песо),
			},
		},
		'AUD' => {
			display_name => {
				'currency' => q(Австралийн доллар),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(Арубын флорин),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(Азербайжаны манат),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(Босни-Герцеговины хөрвөгч марк),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(барбадос доллар),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(Бангладешийн така),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(Болгарын лев),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(Бахрейн динар),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(Бурундийн франк),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(Бермудын доллар),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(Брунейн доллар),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(Боливийн боливиано),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(Бразилийн реал),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(Багамын доллар),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(Бутаны нгултрум),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(Ботсванийн пула),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(Беларусийн рубль),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(беларусь рубль \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(Белизийн доллар),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(канад доллар),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(Конгогийн франк),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(Швейцарийн франк),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(Чилийн песо),
			},
		},
		'CNH' => {
			display_name => {
				'currency' => q(Хятадын юань \(офшор\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(Хятадын юань),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(Колумбын песо),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(Коста-Рикагийн колон),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(Кубын хөрвөгч песо),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(Кубын песо),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(Кабо-Вердийн эскудо),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(Чехийн крон),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(Жибутийн франк),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(Данийн крон),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(Доминиканы песо),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(Алжирийн доллар),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(Египетийн фунт),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(Эритрейн накфа),
			},
		},
		'ETB' => {
			display_name => {
				'currency' => q(Этиопын бирр),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(евро),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(Фижигийн доллар),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(Фолклендийн арлуудын паунд),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(Британийн фунт),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(Гүржийн лари),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(Ганагийн седи),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(Гибралтарын фунт),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(Гамбийн даласи),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(Гвинейн франк),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(Гватемалын кецал),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(Гайанын доллар),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(Хонг Конгийн доллар),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(Гондурасын лемпира),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(Хорватын куна),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(Гаитийн гурд),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(Унгарын форинт),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(Индонезийн рупи),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(Израилийн шинэ шекел),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(Энэтхэгийн рупи),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(Иракийн динар),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(Ираны риял),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(Исландын крон),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(Ямайкийн доллар),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(Йорданы динар),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(Японы иен),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(Кенийн шиллинг),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(Кыргызын сом),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(Камбожийн риел),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(Коморын франк),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(Хойд Солонгосын вон),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(Өмнөд Солонгосын вон),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(Кувейтийн динар),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(Кайманы арлуудын доллар),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(Казахстаны тэнгэ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(Лаосын кип),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(Ливаны фунт),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(Шри-Ланкийн рупи),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(Либерийн доллар),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(Лесото лоти),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(литвийн литас),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(латвийн лац),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(Ливийн доллар),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(Мороккогийн дирхэм),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(Молдовын лей),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(Малагасийн ариари),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(Македонийн динар),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(Мьянмарын киат),
			},
		},
		'MNT' => {
			symbol => '₮',
			display_name => {
				'currency' => q(Монгол төгрөг),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(Макаогийн патака),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(мавритан угия \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(Мавританийн угия),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(Маврикийн рупи),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(Мальдивийн руфия),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(Малавийн квача),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(Мексикийн песо),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(Малайзын рингит),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(Мозамбикийн метикал),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(Намибийн доллар),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(Нигерийн найра),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(Никарагуагийн кордоба),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(Норвегийн крон),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(Балбын рупи),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(Шинэ Зеландын доллар),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(Оманийн риал),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(Панамын бальбоа),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(Перугийн соль),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(Папуа-Шинэ Гвинейн кина),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филиппиний песо),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(Пакистаны рупи),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(Польшийн злот),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(Парагвайн гуарани),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(Катарын риал),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(Румыны лей),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(Сербийн динар),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(Оросын рубль),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(Руандагийн франк),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(Саудын риял),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(Соломоны арлуудын доллар),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(Сейшелийн рупи),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(Суданы фунт),
			},
		},
		'SEK' => {
			symbol => 'кр',
			display_name => {
				'currency' => q(Шведийн крон),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(Сингапурын доллар),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(Сент Хеленагийн фунт),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(Сьерра-Леоны леон),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(Сьерра-Леоны леон \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(Сомалийн шиллинг),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(Суринамын доллар),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(Өмнөд Суданы фунт),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(сан-томе ба принсипи добра \(1977–2017\)),
				'one' => q(Сан-Томе Принсипигийн мөнгөн тэмдэгт добра \(1977–2017\)),
				'other' => q(Сан-Томе Принсипигийн мөнгөн тэмдэгт добра \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(Сан-Томе ба Принсипигийн добра),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(Сирийн фунт),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(Свазиландын лилангени),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Тайландын бат),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(Тажикийн сомон),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(Туркмены манат),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(Тунисын доллар),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(Тонгагийн панга),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(Туркийн лира),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(Тринидад ба Тобагогийн доллар),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Шинэ Тайванийн доллар),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(Танзанийн шиллинг),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(Украины гривна),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(Угандагийн шиллинг),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(америк доллар),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(Уругвайн песо),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(Узбекийн сом),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(венесуэлийн боливар \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(Венесуэлийн боливар),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(Вьетнамын донг),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(Вануатугийн вату),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(Самоагийн тала),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(Төв Африкийн франк),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(Зүүн Карибийн доллар),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(Баруун Африкийн франк),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(Францын колонийн франк),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(тодорхойгүй мөнгөн тэмдэгт),
				'one' => q(\(тодорхойгүй мөнгөн тэмдэгтийн нэгж\)),
				'other' => q(\(тодорхойгүй мөнгөн тэмдэгт\)),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(Йемений риял),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(Өмнөд Африкийн ранд),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(Замби квача \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(Замбийн квача),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'chinese' => {
				'format' => {
					wide => {
						nonleap => [
							'1-р сар',
							'2-р сар',
							'3-р сар',
							'4-р сар',
							'5-р сар',
							'6-р сар',
							'7-р сар',
							'8-р сар',
							'9-р сар',
							'10-р сар',
							'11-р сар',
							'12-р сар'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'1-р сар',
							'2-р сар',
							'3-р сар',
							'4-р сар',
							'5-р сар',
							'6-р сар',
							'7-р сар',
							'8-р сар',
							'9-р сар',
							'10-р сар',
							'11-р сар',
							'12-р сар'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'нэгдүгээр сар',
							'хоёрдугаар сар',
							'гуравдугаар сар',
							'дөрөвдүгээр сар',
							'тавдугаар сар',
							'зургаадугаар сар',
							'долоодугаар сар',
							'наймдугаар сар',
							'есдүгээр сар',
							'аравдугаар сар',
							'арван нэгдүгээр сар',
							'арван хоёрдугаар сар'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'I',
							'II',
							'III',
							'IV',
							'V',
							'VI',
							'VII',
							'VIII',
							'IX',
							'X',
							'XI',
							'XII'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Нэгдүгээр сар',
							'Хоёрдугаар сар',
							'Гуравдугаар сар',
							'Дөрөвдүгээр сар',
							'Тавдугаар сар',
							'Зургаадугаар сар',
							'Долоодугаар сар',
							'Наймдугаар сар',
							'Есдүгээр сар',
							'Аравдугаар сар',
							'Арван нэгдүгээр сар',
							'Арван хоёрдугаар сар'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					wide => {
						mon => 'даваа',
						tue => 'мягмар',
						wed => 'лхагва',
						thu => 'пүрэв',
						fri => 'баасан',
						sat => 'бямба',
						sun => 'ням'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'Да',
						tue => 'Мя',
						wed => 'Лх',
						thu => 'Пү',
						fri => 'Ба',
						sat => 'Бя',
						sun => 'Ня'
					},
					wide => {
						mon => 'Даваа',
						tue => 'Мягмар',
						wed => 'Лхагва',
						thu => 'Пүрэв',
						fri => 'Баасан',
						sat => 'Бямба',
						sun => 'Ням'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'I улирал',
						1 => 'II улирал',
						2 => 'III улирал',
						3 => 'IV улирал'
					},
					wide => {0 => '1-р улирал',
						1 => '2-р улирал',
						2 => '3-р улирал',
						3 => '4-р улирал'
					},
				},
				'stand-alone' => {
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'chinese') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{өдөр},
					'am' => q{ү.ө.},
					'evening1' => q{орой},
					'midnight' => q{шөнө дунд},
					'morning1' => q{өглөө},
					'night1' => q{шөнө},
					'noon' => q{үд дунд},
					'pm' => q{ү.х.},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'МЭӨ',
				'1' => 'МЭ'
			},
			wide => {
				'0' => 'манай эриний өмнөх',
				'1' => 'манай эриний'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
			'full' => q{r(U) 'оны' MM 'сарын' d, EEEE},
			'long' => q{r(U) 'оны' MM-'р' 'сарын' d},
			'medium' => q{r.MM.d},
			'short' => q{r-MM-dd},
		},
		'generic' => {
			'full' => q{G y 'оны' MMMM'ын' d. cccc 'гараг'},
			'long' => q{G y 'оны' MM 'сарын' dd},
			'medium' => q{G y 'оны' MMM'ын' d},
			'short' => q{GGGGG y.MM.dd},
		},
		'gregorian' => {
			'full' => q{y 'оны' MMMM'ын' d, EEEE 'гараг'},
			'long' => q{y 'оны' MMMM'ын' d},
			'medium' => q{y 'оны' MMM'ын' d},
			'short' => q{y.MM.dd},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss (zzzz)},
			'long' => q{HH:mm:ss (z)},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'chinese' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			Bh => q{B h 'ц'},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E. B h:mm},
			EBhms => q{E. B h:mm:ss},
			EHm => q{E. HH:mm},
			EHms => q{E. HH:mm:ss},
			Ed => q{dd. E},
			Ehm => q{E. h:mm a},
			Ehms => q{E. h:mm:ss a},
			GyMMM => q{G y 'оны' MMM},
			GyMMMEd => q{G y 'оны' MMM'ын' d. E},
			GyMMMd => q{G y 'оны' MMM'ын' d},
			GyMd => q{GGGGG y.MM.dd},
			H => q{HH 'ц'},
			M => q{LLLLL},
			MEd => q{MMMMM/dd. E},
			MMMEd => q{MMM'ын' d. E},
			MMMMd => q{MMMM'ын' d},
			MMMd => q{MMM'ын' d},
			Md => q{MMMMM/dd},
			h => q{h 'ц' a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			yyyyM => q{GGGGG y MMMMM},
			yyyyMEd => q{GGGGG y.MM.dd. E},
			yyyyMMM => q{G y 'оны' MMM},
			yyyyMMMEd => q{G y 'оны' MMM'ын' d. E},
			yyyyMMMM => q{G y 'оны' MMMM},
			yyyyMMMd => q{G y 'оны' MMM'ын' d},
			yyyyMd => q{GGGGG y.MM.dd},
			yyyyQQQ => q{G y 'оны' QQQ},
			yyyyQQQQ => q{G y 'оны' QQQQ},
		},
		'gregorian' => {
			Bh => q{B h 'ц'},
			Bhm => q{B h:mm},
			Bhms => q{B h:mm:ss},
			EBhm => q{E. B h:mm},
			EBhms => q{E. B h:mm:ss},
			EHm => q{E. HH:mm},
			EHms => q{E. HH:mm:ss},
			Ed => q{dd. E},
			Ehm => q{E. h:mm a},
			Ehms => q{E. h:mm:ss a},
			GyMMM => q{G y 'оны' MMM},
			GyMMMEd => q{G y 'оны' MMM'ын' d. E},
			GyMMMd => q{G y 'оны' MMM'ын' d},
			H => q{HH 'ц'},
			Hmsv => q{HH:mm:ss (v)},
			Hmv => q{HH:mm (v)},
			M => q{LLLLL},
			MEd => q{MMMMM/dd. E},
			MMMEd => q{MMM'ын' d. E},
			MMMMW => q{MMMM'ын' W-'р' 'долоо' 'хоног'},
			MMMMd => q{MMMM'ын' d},
			MMMd => q{MMM'ын' d},
			Md => q{MMMMM/dd},
			h => q{h 'ц' a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a (v)},
			hmv => q{h:mm a (v)},
			yM => q{y MMMMM},
			yMEd => q{y.MM.dd. E},
			yMMM => q{y 'оны' MMM},
			yMMMEd => q{y 'оны' MMM'ын' d. E},
			yMMMM => q{y 'оны' MMMM},
			yMMMd => q{y 'оны' MMM'ын' d},
			yMd => q{y.MM.dd},
			yQQQ => q{y 'оны' QQQ},
			yQQQQ => q{y 'оны' QQQQ},
			yw => q{Y 'оны' w-'р' 'долоо' 'хоног'},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} ({1})',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{MMMMM – MMMMM 'сар'},
			},
			MEd => {
				M => q{MMMMM/d E – MMMMM/d E},
				d => q{MMMMM/d E – MMMMM/d E},
			},
			MMM => {
				M => q{MMMMM – MMMMM 'сар'},
			},
			MMMEd => {
				M => q{MMMMM/d E – MMMMM/d E},
				d => q{MMMMM/d E – MMMMM/d E},
			},
			MMMd => {
				M => q{MMMMM/d – MMMMM/d},
				d => q{MMMMM/d – d},
			},
			Md => {
				M => q{MMMMM/d – MMMMM/d},
				d => q{MMMMM/d – MMMMM/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			yM => {
				M => q{GGGGG y 'оны' MMMMM–MMMMM 'сар'},
				y => q{GGGGG y 'оны' MMMMM 'сар' – y 'оны' MMMMM 'сар'},
			},
			yMEd => {
				M => q{GGGGG y 'оны' MMMMM/dd E – MMMMM/dd E},
				d => q{GGGGG y 'оны' MMMMM/dd E – MMMMM/dd E},
				y => q{GGGGG y 'оны' MMMMM/dd E – y 'оны' MMMMM/dd E},
			},
			yMMM => {
				M => q{G y 'оны' MMMMM – MMMMM 'сар'},
				y => q{G y 'оны' MMMMM 'сар' – y 'оны' MMMMM 'сар'},
			},
			yMMMEd => {
				M => q{G y 'оны' MMMMM/dd E – MMMMM/dd E},
				d => q{G y 'оны' MMMMM/dd E – MMMMM/dd E},
				y => q{G y 'оны' MMMMM/dd E – y 'оны' MMMMM/dd E},
			},
			yMMMM => {
				M => q{G y 'оны' MMMMM – MMMMM 'сар'},
				y => q{G y 'оны' MMMMM 'сар' – y 'оны' MMMMM 'сар'},
			},
			yMMMd => {
				M => q{G y 'оны' MMMMM/dd – MMMMM/dd},
				d => q{G y 'оны' MMMMM/dd – dd},
				y => q{G y 'оны' MMMMM/dd – y 'оны' MMMMM/dd},
			},
			yMd => {
				M => q{GGGGG y 'оны' MMMMM/dd – MMMMM/dd},
				d => q{GGGGG y 'оны' MMMMM/dd – MMMMM/dd},
				y => q{GGGGG y 'оны' MMMMM/dd – y 'оны' MMMMM/dd},
			},
		},
		'gregorian' => {
			GyMMM => {
				M => q{G y MMM – MMM},
			},
			H => {
				H => q{HH – HH 'ц'},
			},
			Hm => {
				H => q{HH:mm – HH:mm},
				m => q{HH:mm – HH:mm},
			},
			Hmv => {
				H => q{HH:mm – HH:mm (v)},
				m => q{HH:mm – HH:mm (v)},
			},
			Hv => {
				H => q{HH – HH 'ц' (v)},
			},
			M => {
				M => q{MMMMM – MMMMM 'сар'},
			},
			MEd => {
				M => q{MMMMM/d E – MMMMM/d E},
				d => q{MMMMM/d E – MMMMM/d E},
			},
			MMM => {
				M => q{MMMMM – MMMMM 'сар'},
			},
			MMMEd => {
				M => q{MMMMM/d E – MMMMM/d E},
				d => q{MMMMM/d E – MMMMM/d E},
			},
			MMMd => {
				M => q{MMMMM/d – MMMMM/d},
				d => q{MMMMM/d – d},
			},
			Md => {
				M => q{MMMMM/d – MMMMM/d},
				d => q{MMMMM/d – MMMMM/d},
			},
			d => {
				d => q{d – d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h – h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a (v)},
				h => q{h:mm – h:mm a (v)},
				m => q{h:mm – h:mm a (v)},
			},
			hv => {
				a => q{h a – h a (v)},
				h => q{h – h a (v)},
			},
			y => {
				y => q{y – y},
			},
			yM => {
				M => q{y 'оны' MMMMM–MMMMM 'сар'},
				y => q{y 'оны' MMMMM 'сар' – y 'оны' MMMMM 'сар'},
			},
			yMEd => {
				M => q{y 'оны' MMMMM/dd E – MMMMM/dd E},
				d => q{y 'оны' MMMMM/dd E – MMMMM/dd E},
				y => q{y 'оны' MMMMM/dd E – y 'оны' MMMMM/dd E},
			},
			yMMM => {
				M => q{y 'оны' MMMMM – MMMMM 'сар'},
				y => q{y 'оны' MMMMM 'сар' – y 'оны' MMMMM 'сар'},
			},
			yMMMEd => {
				M => q{y 'оны' MMMMM/dd E – MMMMM/dd E},
				d => q{y 'оны' MMMMM/dd E – MMMMM/dd E},
				y => q{y 'оны' MMMMM/dd E – y 'оны' MMMMM/dd E},
			},
			yMMMM => {
				M => q{y 'оны' MMMMM – MMMMM 'сар'},
				y => q{y 'оны' MMMMM 'сар' – y 'оны' MMMMM 'сар'},
			},
			yMMMd => {
				M => q{y 'оны' MMMMM/dd – MMMMM/dd},
				d => q{y 'оны' MMMMM/dd – dd},
				y => q{y 'оны' MMMMM/dd – y 'оны' MMMMM/dd},
			},
			yMd => {
				M => q{y 'оны' MMMMM/dd – MMMMM/dd},
				d => q{y 'оны' MMMMM/dd – MMMMM/dd},
				y => q{y 'оны' MMMMM/dd – y 'оны' MMMMM/dd},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		regionFormat => q({0}-н цаг),
		regionFormat => q({0}-н зуны цаг),
		regionFormat => q({0}-н стандарт цаг),
		'Afghanistan' => {
			long => {
				'standard' => q#Афганистаны цаг#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абижан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Aбеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Бангуй#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Биссау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Жибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Жуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуто#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишу#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровиа#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нжамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#Төв Африкийн цаг#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#Зүүн Африкийн цаг#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#Өмнөд Африкийн стандарт цаг#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#Баруун Африкийн зуны цаг#,
				'generic' => q#Баруун Африкийн цаг#,
				'standard' => q#Баруун Африкийн стандарт цаг#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#Аляскийн зуны цаг#,
				'generic' => q#Аляскийн цаг#,
				'standard' => q#Аляскийн стандарт цаг#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#Амазоны зуны цаг#,
				'generic' => q#Амазоны цаг#,
				'standard' => q#Амазоны стандарт цаг#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкораж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаяна#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Салта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан Луи#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайя#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Байя#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Бахья Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белизе#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Блан-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Боа-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Боисе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кэмбрижийн булан#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампо-Гранде#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чихуахуа#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#Сьюдад Хуарес#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Атикокан#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордова#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Кюрасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмаркшавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Доусон Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Эль Сальвадор#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#Форт Нэльсон#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс булан#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нүүк#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гуус булан#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд Турк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделуп#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемал#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Халифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Хавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Хермосилло#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсбург, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Тел Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенес, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Жуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентаки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендик#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла Паз#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анжелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Ловер Принсес Квартер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Маригот#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиник#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Мазатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоза#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтерей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норона#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Била, Хойд Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Төв, Хойд Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Хойд Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Ожинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Феникс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Принс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Испаний боомт#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порто-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#Пунта Арена#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Рэнкин Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Рио-Бранко#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбисунн#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сент-Бартельми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Жонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Киттс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент Люсиа#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт Каррент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорз#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#Төв зуны цаг#,
				'generic' => q#Төв цаг#,
				'standard' => q#Төв стандарт цаг#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#Зүүн эргийн зуны цаг#,
				'generic' => q#Зүүн эргийн цаг#,
				'standard' => q#Зүүн эргийн стандарт цаг#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#Уулын зуны цаг#,
				'generic' => q#Уулын цаг#,
				'standard' => q#Уулын стандарт цаг#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#Номхон далайн зуны цаг#,
				'generic' => q#Номхон далайн цаг#,
				'standard' => q#Номхон далайн стандарт цаг#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кэсей#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мөрдо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q#Апиагийн зуны цаг#,
				'generic' => q#Апиагийн цаг#,
				'standard' => q#Апиагийн стандарт цаг#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#Арабын зуны цаг#,
				'generic' => q#Арабын цаг#,
				'standard' => q#Арабын стандарт цаг#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгирбайен#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#Аргентины зуны цаг#,
				'generic' => q#Аргентины цаг#,
				'standard' => q#Аргентины стандарт цаг#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#Баруун Аргентины зуны цаг#,
				'generic' => q#Баруун Аргентины цаг#,
				'standard' => q#Баруун Аргентины стандарт цаг#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#Арменийн зуны цаг#,
				'generic' => q#Арменийн цаг#,
				'standard' => q#Арменийн стандарт цаг#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Актау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Актөбе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#Атырау#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Багдад#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#Барнаул#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бишкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дака#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#Фамагуста#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеброн#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Хонг Конг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Эрхүү#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Жакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Жайпур#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Ерусалем#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Кандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучин#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Мускат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосибирск#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омск#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпень#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пёньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#Костанай#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Кызылорд#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хо Ши Мин хот#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарканд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сөүл#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайпей#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#Томск#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улаанбаатар#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрүмчи#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Уст-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#Атлантын зуны цаг#,
				'generic' => q#Атлантын цаг#,
				'standard' => q#Атлантын стандарт цаг#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуда#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канари#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Өмнөд Жоржиа#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Сент Хелена#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стэнли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен Хилл#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Еукла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдемэн#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд Хоу#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перс#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#Төв Австралийн зуны цаг#,
				'generic' => q#Төв Австралийн цаг#,
				'standard' => q#Төв Австралийн стандарт цаг#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#Австралийн төв баруун эргийн зуны цаг#,
				'generic' => q#Австралийн төв баруун эргийн цаг#,
				'standard' => q#Австралийн төв баруун эргийн стандарт цаг#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#Австралийн зүүн эргийн зуны цаг#,
				'generic' => q#Зүүн Австралийн цаг#,
				'standard' => q#Австралийн зүүн эргийн стандарт цаг#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#Австралийн баруун эргийн зуны цаг#,
				'generic' => q#Баруун Австралийн цаг#,
				'standard' => q#Австралийн баруун эргийн стандарт цаг#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#Азербайжаны зуны цаг#,
				'generic' => q#Азербайжаны цаг#,
				'standard' => q#Азербайжаны стандарт цаг#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#Азорын зуны цаг#,
				'generic' => q#Азорын цаг#,
				'standard' => q#Азорын стандарт цаг#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#Бангладешийн зуны цаг#,
				'generic' => q#Бангладешийн цаг#,
				'standard' => q#Бангладешийн стандарт цаг#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#Бутаны цаг#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#Боливийн цаг#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#Бразилийн зуны цаг#,
				'generic' => q#Бразилийн цаг#,
				'standard' => q#Бразилийн стандарт цаг#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#Бруней Даруссаламын цаг#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#Кабо-Вердийн зуны цаг#,
				'generic' => q#Кабо-Вердийн цаг#,
				'standard' => q#Кабо-Вердийн стандарт цаг#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#Чаморрогийн цаг#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#Чатемын зуны цаг#,
				'generic' => q#Чатемын цаг#,
				'standard' => q#Чатемын стандарт цаг#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#Чилийн зуны цаг#,
				'generic' => q#Чилийн цаг#,
				'standard' => q#Чилийн стандарт цаг#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#Хятадын зуны цаг#,
				'generic' => q#Хятадын цаг#,
				'standard' => q#Хятадын стандарт цаг#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#Чойбалсангийн зуны цаг#,
				'generic' => q#Чойбалсангийн цаг#,
				'standard' => q#Чойбалсангийн стандарт цаг#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#Крисмас арлын цаг#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#Кокос арлын цаг#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#Колумбын зуны цаг#,
				'generic' => q#Колумбын цаг#,
				'standard' => q#Колумбын стандарт цаг#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#Күүкийн арлуудын хагас зуны цаг#,
				'generic' => q#Күүкийн арлуудын цаг#,
				'standard' => q#Күүкийн арлуудын стандарт цаг#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#Кубын зуны цаг#,
				'generic' => q#Кубын цаг#,
				'standard' => q#Кубын стандарт цаг#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#Дэвисийн цаг#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#Дюмон д’Юрвилийн цаг#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#Зүүн Тиморын цаг#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#Зүүн Исландын зуны цаг#,
				'generic' => q#Зүүн Исландын цаг#,
				'standard' => q#Зүүн Исландын стандарт цаг#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#Эквадорын цаг#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#Олон улсын зохицуулалттай цаг#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Үл мэдэгдэх хот#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#Астрахань#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афин#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислав#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бусинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинёв#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q#Ирландын стандарт цаг#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хельсинк#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн Арал#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Истанбул#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Жерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#Киров#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q#Британийн зуны цаг#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Марихамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Москва#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Парис#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Ром#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#Саратов#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#Ульяновск#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуз#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнюс#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшав#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#Төв Европын зуны цаг#,
				'generic' => q#Төв Европын цаг#,
				'standard' => q#Төв Европын стандарт цаг#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#Зүүн Европын зуны цаг#,
				'generic' => q#Зүүн Европын цаг#,
				'standard' => q#Зүүн Европын стандарт цаг#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#Алс дорнод Европын цаг#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#Баруун Европын зуны цаг#,
				'generic' => q#Баруун Европын цаг#,
				'standard' => q#Баруун Европын стандарт цаг#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#Фолклендийн арлуудын зуны цаг#,
				'generic' => q#Фолклендийн арлуудын цаг#,
				'standard' => q#Фолклендийн арлуудын стандарт цаг#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#Фижигийн зуны цаг#,
				'generic' => q#Фижигийн цаг#,
				'standard' => q#Фижигийн стандарт цаг#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#Францын Гвианагийн цаг#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#Францын Өмнөд ба Антарктидийн цаг#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#Гринвичийн цаг#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#Галапагосын цаг#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#Гамбьегийн цаг#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#Гүржийн зуны цаг#,
				'generic' => q#Гүржийн цаг#,
				'standard' => q#Гүржийн стандарт цаг#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#Гильбертийн арлуудын цаг#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#Зүүн Гренландын зуны цаг#,
				'generic' => q#Зүүн Гренландын цаг#,
				'standard' => q#Зүүн Гренландын стандарт цаг#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#Баруун Гренландын зуны цаг#,
				'generic' => q#Баруун Гренландын цаг#,
				'standard' => q#Баруун Гренландын стандарт цаг#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#Персийн булангийн цаг#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#Гайанагийн цаг#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#Хавай-Алеутын зуны цаг#,
				'generic' => q#Хавай-Алеутын цаг#,
				'standard' => q#Хавай-Алеутын стандарт цаг#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#Хонг Конгийн зуны цаг#,
				'generic' => q#Хонг Конгийн цаг#,
				'standard' => q#Хонг Конгийн стандарт цаг#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#Ховдын зуны цаг#,
				'generic' => q#Ховдын цаг#,
				'standard' => q#Ховдын стандарт цаг#,
			},
		},
		'India' => {
			long => {
				'standard' => q#Энэтхэгийн цаг#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариво#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Крисмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Махе#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдив#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюнион#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#Энэтхэгийн далайн цаг#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#Энэтхэг-Хятадын хойгийн цаг#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#Төв Индонезийн цаг#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#Зүүн Индонезийн цаг#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#Баруун Индонезийн цаг#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#Ираны зуны цаг#,
				'generic' => q#Ираны цаг#,
				'standard' => q#Ираны стандарт цаг#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#Эрхүүгийн зуны цаг#,
				'generic' => q#Эрхүүгийн цаг#,
				'standard' => q#Эрхүүгийн стандарт цаг#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#Израилийн зуны цаг#,
				'generic' => q#Израилийн цаг#,
				'standard' => q#Израилийн стандарт цаг#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#Японы зуны цаг#,
				'generic' => q#Японы цаг#,
				'standard' => q#Японы стандарт цаг#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#Зүүн Казахстаны цаг#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#Баруун Казахстаны цаг#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#Солонгосын зуны цаг#,
				'generic' => q#Солонгосын цаг#,
				'standard' => q#Солонгосын стандарт цаг#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#Косрэгийн цаг#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#Красноярскийн зуны цаг#,
				'generic' => q#Красноярскийн цаг#,
				'standard' => q#Красноярскийн стандарт цаг#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#Киргизийн цаг#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#Лайн арлуудын цаг#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#Лорд Хоугийн зуны цаг#,
				'generic' => q#Лорд Хоугийн цаг#,
				'standard' => q#Лорд Хоугийн стандарт цаг#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#Магаданы зуны цаг#,
				'generic' => q#Магаданы цаг#,
				'standard' => q#Магаданы стандарт цаг#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#Малайзын цаг#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#Мальдивийн цаг#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#Маркезын арлуудын цаг#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#Маршаллын арлуудын цаг#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#Маврикийн зуны цаг#,
				'generic' => q#Маврикийн цаг#,
				'standard' => q#Маврикийн стандарт цаг#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#Моусоны цаг#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#Мексик-Номхон далайн зуны цаг#,
				'generic' => q#Мексик-Номхон далайн цаг#,
				'standard' => q#Мексик-Номхон далайн стандарт цаг#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#Улаанбаатарын зуны цаг#,
				'generic' => q#Улаанбаатарын цаг#,
				'standard' => q#Улаанбаатарын стандарт цаг#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#Москвагийн зуны цаг#,
				'generic' => q#Москвагийн цаг#,
				'standard' => q#Москвагийн стандарт цаг#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#Мьянмарын цаг#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#Науругийн цаг#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#Балбын цаг#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#Шинэ Каледонийн зуны цаг#,
				'generic' => q#Шинэ Каледонийн цаг#,
				'standard' => q#Шинэ Каледонийн стандарт цаг#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#Шинэ Зеландын зуны цаг#,
				'generic' => q#Шинэ Зеландын цаг#,
				'standard' => q#Шинэ Зеландын стандарт цаг#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#Нью-Фаундлендын зуны цаг#,
				'generic' => q#Нью-Фаундлендын цаг#,
				'standard' => q#Нью-Фаундлендын стандарт цаг#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#Ниуэгийн цаг#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#Норфолк арлын зуны цаг#,
				'generic' => q#Норфолк арлын цаг#,
				'standard' => q#Норфолк арлын стандарт цаг#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#Фернандо де Норонагийн зуны цаг#,
				'generic' => q#Фернандо де Норонагийн цаг#,
				'standard' => q#Фернандо де Норонагийн стандарт цаг#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#Новосибирскийн зуны цаг#,
				'generic' => q#Новосибирскийн цаг#,
				'standard' => q#Новосибирскийн стандарт цаг#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#Омскийн зуны цаг#,
				'generic' => q#Омскийн цаг#,
				'standard' => q#Омскийн стандарт цаг#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Оукленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Истер#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фижи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбьер#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гуадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Хонолулу#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#Кантон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косрэ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кважалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Мажуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркез#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкэрн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понпей#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чүүк#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#Пакистаны зуны цаг#,
				'generic' => q#Пакистаны цаг#,
				'standard' => q#Пакистаны стандарт цаг#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#Палаугийн цаг#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#Папуа Шинэ Гвинейн цаг#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#Парагвайн зуны цаг#,
				'generic' => q#Парагвайн цаг#,
				'standard' => q#Парагвайн стандарт цаг#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#Перугийн зуны цаг#,
				'generic' => q#Перугийн цаг#,
				'standard' => q#Перугийн стандарт цаг#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#Филиппиний зуны цаг#,
				'generic' => q#Филиппиний цаг#,
				'standard' => q#Филиппиний стандарт цаг#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#Феникс арлын цаг#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#Сент-Пьер ба Микелоны зуны цаг#,
				'generic' => q#Сент-Пьер ба Микелоны цаг#,
				'standard' => q#Сент-Пьер ба Микелоны стандарт цаг#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#Питкернийн цаг#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#Понапегийн цаг#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#Пёньяны цаг#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#Реюнионы цаг#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#Ротерагийн цаг#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#Сахалины зуны цаг#,
				'generic' => q#Сахалины цаг#,
				'standard' => q#Сахалины стандарт цаг#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#Самоагийн зуны цаг#,
				'generic' => q#Самоагийн цаг#,
				'standard' => q#Самоагийн стандарт цаг#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#Сейшелийн арлуудын цаг#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#Сингапурын цаг#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#Соломоны арлуудын цаг#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#Өмнөд Жоржиагийн цаг#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#Суринамын цаг#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#Сёвагийн цаг#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#Таитигийн цаг#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#Тайпейн зуны цаг#,
				'generic' => q#Тайпейн цаг#,
				'standard' => q#Тайпейн стандарт цаг#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#Тажикистаны цаг#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#Токелаугийн цаг#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#Тонгагийн зуны цаг#,
				'generic' => q#Тонгагийн цаг#,
				'standard' => q#Тонгагийн стандарт цаг#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#Чүүкийн цаг#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#Туркменистаны зуны цаг#,
				'generic' => q#Туркменистаны цаг#,
				'standard' => q#Туркменистаны стандарт цаг#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#Тувалугийн цаг#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#Уругвайн зуны цаг#,
				'generic' => q#Уругвайн цаг#,
				'standard' => q#Уругвайн стандарт цаг#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#Узбекистаны зуны цаг#,
				'generic' => q#Узбекистаны цаг#,
				'standard' => q#Узбекистаны стандарт цаг#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#Вануатугийн зуны цаг#,
				'generic' => q#Вануатугийн цаг#,
				'standard' => q#Вануатугийн стандарт цаг#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#Венесуэлийн цаг#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#Владивостокийн зуны цаг#,
				'generic' => q#Владивостокийн цаг#,
				'standard' => q#Владивостокийн стандарт цаг#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#Волгоградын зуны цаг#,
				'generic' => q#Волгоградын цаг#,
				'standard' => q#Волгоградын стандарт цаг#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#Востокийн цаг#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#Уэкийн арлуудын цаг#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#Уоллис ба Футунагийн цаг#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#Якутын зуны цаг#,
				'generic' => q#Якутын цаг#,
				'standard' => q#Якутын стандарт цаг#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#Екатеринбургийн зуны цаг#,
				'generic' => q#Екатеринбургийн цаг#,
				'standard' => q#Екатеринбургийн стандарт цаг#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#Юкон цагийн бүс#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
