=head1

Locale::CLDR::Locales::Kk - Package for language Kazakh

=cut

package Locale::CLDR::Locales::Kk;
# This file auto generated from Data\common\main\kk.xml
#	on Sun 24 Apr  8:36:52 am GMT

use version;

our $VERSION = version->declare('v0.29.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';

use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
# Need to add code for Key type pattern
sub display_name_pattern {
	my ($self, $name, $region, $script, $variant) = @_;

	my $display_pattern = '{0} ({1})';
	$display_pattern =~s/\{0\}/$name/g;
	my $subtags = join '{0}, {1}', grep {$_} (
		$region,
		$script,
		$variant,
	);

	$display_pattern =~s/\{1\}/$subtags/g;
	return $display_pattern;
}

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'ab' => 'абхаз тілі',
 				'af' => 'африкаанс тілі',
 				'agq' => 'агхем тілі',
 				'ak' => 'акан тілі',
 				'am' => 'амхар тілі',
 				'ar' => 'араб тілі',
 				'ar_001' => 'қазіргі стандартты араб тілі',
 				'arn' => 'мапуче тілі',
 				'as' => 'ассам тілі',
 				'asa' => 'асу тілі',
 				'ay' => 'Аймара',
 				'az' => 'әзірбайжан тілі',
 				'az@alt=short' => 'әзери тілі',
 				'ba' => 'башқұрт тілі',
 				'be' => 'беларусь тілі',
 				'bem' => 'бемба тілі',
 				'bez' => 'бена тілі',
 				'bg' => 'болгар тілі',
 				'bgn' => 'батыс балучи тілі',
 				'bm' => 'бамбара тілі',
 				'bn' => 'бенгал тілі',
 				'bo' => 'тибет тілі',
 				'br' => 'бретон тілі',
 				'brx' => 'бодо тілі',
 				'bs' => 'босния тілі',
 				'ca' => 'каталан тілі',
 				'ce' => 'шешен тілі',
 				'cgg' => 'кига тілі',
 				'chr' => 'чероки тілі',
 				'ckb' => 'сорани тілі',
 				'co' => 'корсика тілі',
 				'cs' => 'чех тілі',
 				'cv' => 'чуваш тілі',
 				'cy' => 'валлий тілі',
 				'da' => 'дат тілі',
 				'dav' => 'таита тілі',
 				'de' => 'неміс тілі',
 				'de_AT' => 'австриялық неміс тілі',
 				'de_CH' => 'швейцариялық жоғарғы неміс тілі',
 				'dje' => 'зарма тілі',
 				'dsb' => 'төменгі лужица тілі',
 				'dua' => 'дуала тілі',
 				'dv' => 'Мальдив',
 				'dyo' => 'диола тілі',
 				'dz' => 'дзонг-кэ тілі',
 				'ebu' => 'ембу тілі',
 				'ee' => 'эве тілі',
 				'efi' => 'эфик',
 				'el' => 'грек тілі',
 				'en' => 'ағылшын тілі',
 				'en_AU' => 'австралиялық ағылшын тілі',
 				'en_CA' => 'канадалық ағылшын тілі',
 				'en_GB' => 'британиялық ағылшын тілі',
 				'en_US' => 'американдық ағылшын тілі',
 				'eo' => 'эсперанто тілі',
 				'es' => 'испан тілі',
 				'es_419' => 'латын американдық испан тілі',
 				'es_ES' => 'ибериялық испан тілі',
 				'es_MX' => 'мексикалық испан тілі',
 				'et' => 'эстон тілі',
 				'eu' => 'баск тілі',
 				'fa' => 'парсы тілі',
 				'fi' => 'фин тілі',
 				'fil' => 'филиппин тілі',
 				'fj' => 'фиджи тілі',
 				'fo' => 'фарер тілі',
 				'fr' => 'француз тілі',
 				'fr_CA' => 'канадалық француз тілі',
 				'fr_CH' => 'швейцариялық француз тілі',
 				'fy' => 'батыс фриз тілі',
 				'ga' => 'ирланд тілі',
 				'gag' => 'гагауз тілі',
 				'gd' => 'Солтүстік Шотландия',
 				'gl' => 'галисия тілі',
 				'gn' => 'гуарани тілі',
 				'gsw' => 'швейцариялық неміс тілі',
 				'gu' => 'гуджарати тілі',
 				'guz' => 'гусии тілі',
 				'gv' => 'мэнс тілі',
 				'ha' => 'хауса тілі',
 				'haw' => 'гавайи тілі',
 				'he' => 'иврит тілі',
 				'hi' => 'хинди тілі',
 				'hr' => 'хорват тілі',
 				'hsb' => 'жоғарғы лужица тілі',
 				'ht' => 'гаити тілі',
 				'hu' => 'венгр тілі',
 				'hy' => 'армян тілі',
 				'ia' => 'интерлингва',
 				'id' => 'индонезия тілі',
 				'ie' => 'интерлингве',
 				'ig' => 'игбо тілі',
 				'ii' => 'сычуан и тілі',
 				'is' => 'исланд тілі',
 				'it' => 'итальян тілі',
 				'iu' => 'инуктитут тілі',
 				'ja' => 'жапон тілі',
 				'jgo' => 'нгомба тілі',
 				'jmc' => 'мачаме тілі',
 				'jv' => 'ява тілі',
 				'ka' => 'грузин тілі',
 				'kab' => 'кабил тілі',
 				'kam' => 'камба тілі',
 				'kde' => 'маконде тілі',
 				'kea' => 'кабувердиана тілі',
 				'khq' => 'койра чини тілі',
 				'ki' => 'кикуйю тілі',
 				'kk' => 'қазақ тілі',
 				'kl' => 'калаалисут тілі',
 				'kln' => 'каленжин тілі',
 				'km' => 'кхмер тілі',
 				'kn' => 'каннада тілі',
 				'ko' => 'кәріс тілі',
 				'koi' => 'коми-пермяк тілі',
 				'kok' => 'конкани тілі',
 				'ks' => 'кашмир тілі',
 				'ksb' => 'шамбала тілі',
 				'ksf' => 'бафиа тілі',
 				'ku' => 'күрд тілі',
 				'kw' => 'корн тілі',
 				'ky' => 'қырғыз тілі',
 				'la' => 'латын тілі',
 				'lag' => 'ланги тілі',
 				'lb' => 'люксембург тілі',
 				'lg' => 'ганда тілі',
 				'lkt' => 'лакота тілі',
 				'ln' => 'лингала тілі',
 				'lo' => 'лаос тілі',
 				'lrc' => 'солтүстік люри тілі',
 				'lt' => 'литва тілі',
 				'lu' => 'луба-катанга тілі',
 				'luo' => 'луо тілі',
 				'luy' => 'лухиа тілі',
 				'lv' => 'латыш тілі',
 				'mas' => 'масай тілі',
 				'mer' => 'меру тілі',
 				'mfe' => 'морисиен тілі',
 				'mg' => 'малагаси тілі',
 				'mgh' => 'макуа-меетто тілі',
 				'mgo' => 'мета тілі',
 				'mi' => 'маори тілі',
 				'mk' => 'македон тілі',
 				'ml' => 'малаялам тілі',
 				'mn' => 'моңғол тілі',
 				'moh' => 'могавк тілі',
 				'mr' => 'маратхи тілі',
 				'ms' => 'малай тілі',
 				'mt' => 'мальта тілі',
 				'mua' => 'мунданг тілі',
 				'my' => 'бирма тілі',
 				'mzn' => 'мазандеран тілі',
 				'naq' => 'нама тілі',
 				'nb' => 'норвегиялық букмол тілі',
 				'nd' => 'солтүстік ндебеле тілі',
 				'nds' => 'төменгі неміс тілі',
 				'nds_NL' => 'төменгі саксон тілі',
 				'ne' => 'непал тілі',
 				'nl' => 'нидерланд тілі',
 				'nl_BE' => 'фламанд тілі',
 				'nmg' => 'квасио тілі',
 				'nn' => 'норвегиялық нюнорск тілі',
 				'no' => 'норвег',
 				'nqo' => 'нко тілі',
 				'nso' => 'Солтүстік сотхо',
 				'nus' => 'нуэр тілі',
 				'ny' => 'ньянджа',
 				'nyn' => 'нианколе тілі',
 				'oc' => 'окситан',
 				'om' => 'оромо тілі',
 				'or' => 'ория тілі',
 				'os' => 'осетин',
 				'pa' => 'пенджаб тілі',
 				'pl' => 'поляк тілі',
 				'ps' => 'пушту тілі',
 				'pt' => 'португал тілі',
 				'pt_BR' => 'бразилиялық португал тілі',
 				'pt_PT' => 'еуропалық португал тілі',
 				'qu' => 'кечуа тілі',
 				'quc' => 'киче тілі',
 				'rm' => 'романш тілі',
 				'rn' => 'рунди тілі',
 				'ro' => 'румын тілі',
 				'ro_MD' => 'молдован тілі',
 				'rof' => 'ромбо тілі',
 				'ru' => 'орыс тілі',
 				'rw' => 'киньяруанда тілі',
 				'rwk' => 'руа тілі',
 				'sa' => 'санскрит тілі',
 				'sah' => 'якут',
 				'saq' => 'самбуру тілі',
 				'sbp' => 'сангу тілі',
 				'sd' => 'синдхи тілі',
 				'sdh' => 'оңтүстік күрд тілі',
 				'se' => 'солтүстік саам тілі',
 				'seh' => 'сена тілі',
 				'ses' => 'койраборо сенни тілі',
 				'sg' => 'санго тілі',
 				'sh' => 'сербхорват',
 				'shi' => 'ташелхит тілі',
 				'si' => 'сингал тілі',
 				'sk' => 'словак тілі',
 				'sl' => 'словен тілі',
 				'sma' => 'оңтүстік саам тілі',
 				'smj' => 'луле саам тілі',
 				'smn' => 'инари саам тілі',
 				'sms' => 'сколт саам',
 				'sn' => 'шона тілі',
 				'so' => 'сомали тілі',
 				'sq' => 'албан тілі',
 				'sr' => 'серб тілі',
 				'st' => 'сесото',
 				'sv' => 'швед тілі',
 				'sw' => 'суахили тілі',
 				'sw_CD' => 'конго суахили тілі',
 				'ta' => 'тамил тілі',
 				'te' => 'телугу тілі',
 				'teo' => 'тесо тілі',
 				'tg' => 'тәжік тілі',
 				'th' => 'тай тілі',
 				'ti' => 'тигринья тілі',
 				'tk' => 'түрікмен тілі',
 				'tlh' => 'клингон',
 				'to' => 'тонган тілі',
 				'tr' => 'түрік тілі',
 				'tt' => 'татар тілі',
 				'tw' => 'тви',
 				'twq' => 'тасавак тілі',
 				'tzm' => 'орталық атлас тамасагихт тілі',
 				'ug' => 'ұйғыр тілі',
 				'uk' => 'украин тілі',
 				'und' => 'белгісіз тіл',
 				'ur' => 'урду тілі',
 				'uz' => 'өзбек тілі',
 				'vai' => 'вай тілі',
 				'vi' => 'вьетнам тілі',
 				'vun' => 'вунджо тілі',
 				'wbp' => 'вальбири тілі',
 				'wo' => 'волоф тілі',
 				'xh' => 'кхоса тілі',
 				'xog' => 'сога тілі',
 				'yi' => 'идиш',
 				'yo' => 'йоруба тілі',
 				'zgh' => 'марокколық стандартты тамазигхт тілі',
 				'zh' => 'қытай тілі',
 				'zh_Hans' => 'жеңілдетілген қытай тілі',
 				'zh_Hant' => 'дәстүрлі қытай тілі',
 				'zu' => 'зулу тілі',
 				'zxx' => 'тілдік мазмұны жоқ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => 'араб жазуы',
 			'Armn' => 'армян жазуы',
 			'Beng' => 'бенгал жазуы',
 			'Bopo' => 'бопомофо жазу',
 			'Brai' => 'Брайль жазуы',
 			'Cyrl' => 'кирилл жазуы',
 			'Deva' => 'деванагари жазуы',
 			'Ethi' => 'эфиоп жазу',
 			'Geor' => 'грузин жазуы',
 			'Grek' => 'грек жазуы',
 			'Gujr' => 'гуджарати жазуы',
 			'Guru' => 'гурмукхи жазуы',
 			'Hang' => 'хангул жазуы',
 			'Hani' => 'қытай жазуы',
 			'Hans' => 'жеңілдетілген қытай иероглифы',
 			'Hans@alt=stand-alone' => 'жеңілдетілген қытай иероглифы',
 			'Hant' => 'дәстүрлі қытай иероглифы',
 			'Hant@alt=stand-alone' => 'дәстүрлі қытай иероглифы',
 			'Hebr' => 'иврит жазуы',
 			'Hira' => 'хирагана жазуы',
 			'Jpan' => 'жапон жазуы',
 			'Kana' => 'катакана жазуы',
 			'Khmr' => 'кхмер жазуы',
 			'Knda' => 'каннада жазуы',
 			'Kore' => 'корей жазуы',
 			'Laoo' => 'лаос жазуы',
 			'Latn' => 'латын жазуы',
 			'Mlym' => 'малаялам жазуы',
 			'Mong' => 'моңғол жазуы',
 			'Mymr' => 'мьянма жазуы',
 			'Orya' => 'ория жазуы',
 			'Sinh' => 'сингаль жазуы',
 			'Taml' => 'тамиль жазуы',
 			'Telu' => 'телугу жазуы',
 			'Thaa' => 'таана жазуы',
 			'Thai' => 'тай жазуы',
 			'Tibt' => 'тибет жазуы',
 			'Zsym' => 'таңбалар',
 			'Zxxx' => 'жазусыз',
 			'Zyyy' => 'жалпы',
 			'Zzzz' => 'белгісіз жазу',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => 'Әлем',
 			'002' => 'Африка',
 			'003' => 'Солтүстік Америка',
 			'005' => 'Оңтүстік Америка',
 			'009' => 'Океания',
 			'011' => 'Батыс Африка',
 			'013' => 'Орталық Америка',
 			'014' => 'Шығыс Африка',
 			'015' => 'Солтүстік Африка',
 			'017' => 'Орталық Африка',
 			'018' => 'Оңтүстік Африка',
 			'019' => 'Солтүстік және Оңтүстік Америка',
 			'021' => 'Американың солтүстігі',
 			'029' => 'Кариб',
 			'030' => 'Шығыс Азия',
 			'034' => 'Оңтүстік Азия',
 			'035' => 'Оңтүстік-шығыс Азия',
 			'039' => 'Оңтүстік Еуропа',
 			'053' => 'Австралазия',
 			'054' => 'Меланезия',
 			'057' => 'Микронезия аймағы',
 			'061' => 'Полинезия',
 			'142' => 'Азия',
 			'143' => 'Орталық Азия',
 			'145' => 'Батыс Азия',
 			'150' => 'Еуропа',
 			'151' => 'Шығыс Еуропа',
 			'154' => 'Солтүстік Еуропа',
 			'155' => 'Батыс Еуропа',
 			'419' => 'Латын Америкасы',
 			'AC' => 'Әскенжін аралы',
 			'AD' => 'Андорра',
 			'AE' => 'Біріккен Араб Әмірліктері',
 			'AF' => 'Ауғанстан',
 			'AG' => 'Антигуа мен Барбуда',
 			'AI' => 'Ангилья',
 			'AL' => 'Албания',
 			'AM' => 'Армения',
 			'AO' => 'Ангола',
 			'AQ' => 'Антарктика',
 			'AR' => 'Аргентина',
 			'AS' => 'Американдық Самоа',
 			'AT' => 'Австрия',
 			'AU' => 'Австралия',
 			'AW' => 'Аруба',
 			'AX' => 'Аланд аралдары',
 			'AZ' => 'Әзірбайжан',
 			'BA' => 'Босния және Герцеговина',
 			'BB' => 'Барбадос',
 			'BD' => 'Бангладеш',
 			'BE' => 'Бельгия',
 			'BF' => 'Буркина-Фасо',
 			'BG' => 'Болгария',
 			'BH' => 'Бахрейн',
 			'BI' => 'Бурунди',
 			'BJ' => 'Бенин',
 			'BL' => 'Сен-Бартелеми',
 			'BM' => 'Бермуд аралдары',
 			'BN' => 'Бруней',
 			'BO' => 'Боливия',
 			'BQ' => 'Кариб Нидерландысы',
 			'BR' => 'Бразилия',
 			'BS' => 'Багам аралдары',
 			'BT' => 'Бутан',
 			'BV' => 'Буве аралы',
 			'BW' => 'Ботсвана',
 			'BY' => 'Беларусь',
 			'BZ' => 'Белиз',
 			'CA' => 'Канада',
 			'CC' => 'Кокос (Килинг) аралдары',
 			'CD' => 'Конго',
 			'CD@alt=variant' => 'Конго Демократиялық Республикасы',
 			'CF' => 'Орталық Африка Республикасы',
 			'CG' => 'Конго-Браззавиль Республикасы',
 			'CG@alt=variant' => 'Конго Республикасы',
 			'CH' => 'Швейцария',
 			'CI' => 'Кот-д’Ивуар',
 			'CI@alt=variant' => 'Піл Сүйегі Жағалауы',
 			'CK' => 'Кук аралдары',
 			'CL' => 'Чили',
 			'CM' => 'Камерун',
 			'CN' => 'Қытай',
 			'CO' => 'Колумбия',
 			'CP' => 'Клиппертон аралы',
 			'CR' => 'Коста-Рика',
 			'CU' => 'Куба',
 			'CV' => 'Кабо-Верде',
 			'CW' => 'Кюрасао',
 			'CX' => 'Кристмас аралы',
 			'CY' => 'Кипр',
 			'CZ' => 'Чех Республикасы',
 			'DE' => 'Германия',
 			'DG' => 'Диего-Гарсия',
 			'DJ' => 'Джибути',
 			'DK' => 'Дания',
 			'DM' => 'Доминика',
 			'DO' => 'Доминикан Республикасы',
 			'DZ' => 'Алжир',
 			'EA' => 'Сеута мен Мелилья',
 			'EC' => 'Эквадор',
 			'EE' => 'Эстония',
 			'EG' => 'Мысыр',
 			'EH' => 'Батыс Сахара',
 			'ER' => 'Эритрея',
 			'ES' => 'Испания',
 			'ET' => 'Эфиопия',
 			'EU' => 'Еуропалық Одақ',
 			'FI' => 'Финляндия',
 			'FJ' => 'Фиджи',
 			'FK' => 'Фолкленд аралдары',
 			'FK@alt=variant' => 'Фолкленд аралдары (Мальвин аралдары)',
 			'FM' => 'Микронезия',
 			'FO' => 'Фарер аралдары',
 			'FR' => 'Франция',
 			'GA' => 'Габон',
 			'GB' => 'Біріккен Корольдік',
 			'GB@alt=short' => 'Біріккен Корольдік',
 			'GD' => 'Гренада',
 			'GE' => 'Грузия',
 			'GF' => 'Француз Гвианасы',
 			'GG' => 'Гернси',
 			'GH' => 'Гана',
 			'GI' => 'Гибралтар',
 			'GL' => 'Гренландия',
 			'GM' => 'Гамбия',
 			'GN' => 'Гвинея',
 			'GP' => 'Гваделупа',
 			'GQ' => 'Экваторлық Гвинея',
 			'GR' => 'Греция',
 			'GS' => 'Оңтүстік Георгия және Оңтүстік Сандвич аралдары',
 			'GT' => 'Гватемала',
 			'GU' => 'Гуам',
 			'GW' => 'Гвинея-Бисау',
 			'GY' => 'Гайана',
 			'HK' => 'Қытай Халық Республикасының Гонг-Конг арнайы әкімшілік ауданы',
 			'HK@alt=short' => 'Гонконг',
 			'HM' => 'Херд аралы мен Макдональд аралдары',
 			'HN' => 'Гондурас',
 			'HR' => 'Хорватия',
 			'HT' => 'Гаити',
 			'HU' => 'Венгрия',
 			'IC' => 'Канар аралдары',
 			'ID' => 'Индонезия',
 			'IE' => 'Ирландия',
 			'IL' => 'Израиль',
 			'IM' => 'Мэн аралы',
 			'IN' => 'Үндістан',
 			'IO' => 'Үнді мұхитындағы Британ аймағы',
 			'IQ' => 'Ирак',
 			'IR' => 'Иран',
 			'IS' => 'Исландия',
 			'IT' => 'Италия',
 			'JE' => 'Джерси',
 			'JM' => 'Ямайка',
 			'JO' => 'Иордания',
 			'JP' => 'Жапония',
 			'KE' => 'Кения',
 			'KG' => 'Қырғызстан',
 			'KH' => 'Камбоджа',
 			'KI' => 'Кирибати',
 			'KM' => 'Комор',
 			'KN' => 'Сент-Китс және Невис',
 			'KP' => 'Солтүстік Корея',
 			'KR' => 'Оңтүстік Корея',
 			'KW' => 'Кувейт',
 			'KY' => 'Кайман аралдары',
 			'KZ' => 'Қазақстан',
 			'LA' => 'Лаос',
 			'LB' => 'Ливан',
 			'LC' => 'Сент-Люсия',
 			'LI' => 'Лихтенштейн',
 			'LK' => 'Шри-Ланка',
 			'LR' => 'Либерия',
 			'LS' => 'Лесото',
 			'LT' => 'Литва',
 			'LU' => 'Люксембург',
 			'LV' => 'Латвия',
 			'LY' => 'Ливия',
 			'MA' => 'Морокко',
 			'MC' => 'Монако',
 			'MD' => 'Молдова',
 			'ME' => 'Черногория',
 			'MF' => 'Сен-Мартен',
 			'MG' => 'Мадагаскар',
 			'MH' => 'Маршалл аралдары',
 			'MK' => 'Македония',
 			'MK@alt=variant' => 'Македония Республикасы',
 			'ML' => 'Мали',
 			'MM' => 'Мьянма (Бирма)',
 			'MN' => 'Моңғолия',
 			'MO' => 'Қытай Халық Республикасының Макао арнайы әкімшілік ауданы',
 			'MO@alt=short' => 'Макао',
 			'MP' => 'Солтүстік Мариан аралдары',
 			'MQ' => 'Мартиника',
 			'MR' => 'Мавритания',
 			'MS' => 'Монтсеррат',
 			'MT' => 'Мальта',
 			'MU' => 'Маврикий',
 			'MV' => 'Мальдив Республикасы',
 			'MW' => 'Малави',
 			'MX' => 'Мексика',
 			'MY' => 'Малайзия',
 			'MZ' => 'Мозамбик',
 			'NA' => 'Намибия',
 			'NC' => 'Жаңа Каледония',
 			'NE' => 'Нигер',
 			'NF' => 'Норфолк аралы',
 			'NG' => 'Нигерия',
 			'NI' => 'Никарагуа',
 			'NL' => 'Нидерланд',
 			'NO' => 'Норвегия',
 			'NP' => 'Непал',
 			'NR' => 'Науру',
 			'NU' => 'Ниуэ',
 			'NZ' => 'Жаңа Зеландия',
 			'OM' => 'Оман',
 			'PA' => 'Панама',
 			'PE' => 'Перу',
 			'PF' => 'Француз Полинезиясы',
 			'PG' => 'Папуа — Жаңа Гвинея',
 			'PH' => 'Филиппин',
 			'PK' => 'Пәкістан',
 			'PL' => 'Польша',
 			'PM' => 'Сен-Пьер және Микелон',
 			'PN' => 'Питкэрн аралдары',
 			'PR' => 'Пуэрто-Рико',
 			'PS' => 'Палестина аймақтары',
 			'PS@alt=short' => 'Палестина',
 			'PT' => 'Португалия',
 			'PW' => 'Палау',
 			'PY' => 'Парагвай',
 			'QA' => 'Катар',
 			'QO' => 'Алыс Океания',
 			'RE' => 'Реюньон',
 			'RO' => 'Румыния',
 			'RS' => 'Сербия',
 			'RU' => 'Ресей',
 			'RW' => 'Руанда',
 			'SA' => 'Сауд Арабиясы',
 			'SB' => 'Соломон аралдары',
 			'SC' => 'Сейшель аралдары',
 			'SD' => 'Судан',
 			'SE' => 'Швеция',
 			'SG' => 'Сингапур',
 			'SH' => 'Әулие Елена аралы',
 			'SI' => 'Словения',
 			'SJ' => 'Шпицберген мен Ян-Майен',
 			'SK' => 'Словакия',
 			'SL' => 'Сьерра-Леоне',
 			'SM' => 'Сан-Марино',
 			'SN' => 'Сенегал',
 			'SO' => 'Сомали',
 			'SR' => 'Суринам',
 			'SS' => 'Оңтүстік Судан',
 			'ST' => 'Сан-Томе мен Принсипи',
 			'SV' => 'Сальвадор',
 			'SX' => 'Синт-Мартен',
 			'SY' => 'Сирия',
 			'SZ' => 'Свазиленд',
 			'TA' => 'Тристан-да-Кунья',
 			'TC' => 'Теркс және Кайкос аралдары',
 			'TD' => 'Чад',
 			'TF' => 'Францияның оңтүстік аймақтары',
 			'TG' => 'Того',
 			'TH' => 'Тайланд',
 			'TJ' => 'Тәжікстан',
 			'TK' => 'Токелау',
 			'TL' => 'Тимор-Лесте',
 			'TL@alt=variant' => 'Шығыс Тимор',
 			'TM' => 'Түрікменстан',
 			'TN' => 'Тунис',
 			'TO' => 'Тонга',
 			'TR' => 'Түркия',
 			'TT' => 'Тринидад пен Тобаго',
 			'TV' => 'Тувалу',
 			'TW' => 'Тайвань',
 			'TZ' => 'Танзания',
 			'UA' => 'Украина',
 			'UG' => 'Уганда',
 			'UM' => 'АҚШ-тың сыртқы кіші аралдары',
 			'US' => 'АҚШ',
 			'US@alt=short' => 'АҚШ',
 			'UY' => 'Уругвай',
 			'UZ' => 'Өзбекстан',
 			'VA' => 'Ватикан',
 			'VC' => 'Сент-Винсент және Гренадин аралдары',
 			'VE' => 'Венесуэла',
 			'VG' => 'Британдық Виргин аралдары',
 			'VI' => 'АҚШ-тың Виргин аралдары',
 			'VN' => 'Вьетнам',
 			'VU' => 'Вануату',
 			'WF' => 'Уоллис пен Футуна',
 			'WS' => 'Самоа',
 			'XK' => 'Косово',
 			'YE' => 'Йемен',
 			'YT' => 'Майотта',
 			'ZA' => 'Оңтүстік Африка Республикасы',
 			'ZM' => 'Замбия',
 			'ZW' => 'Зимбабве',
 			'ZZ' => 'Белгісіз аймақ',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'AREVELA' => 'Шығыс-армян',
 			'AREVMDA' => 'Батыс-армян',
 			'SAAHO' => 'Сахо',
 			'WADEGILE' => 'Уейд-Джайлс жүйесі',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => 'Күнтізбе',
 			'collation' => 'Сұрыптау реті',
 			'currency' => 'Валюта',
 			'hc' => 'Уақыт пішімі (12 не 24)',
 			'lb' => 'Жолды тасымалдау стилі',
 			'ms' => 'Өлшемдер жүйесі',
 			'numbers' => 'Сандар',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{Будда күнтізбесі},
 				'chinese' => q{Қытай күнтізбесі},
 				'dangi' => q{Данги күнтізбесі},
 				'ethiopic' => q{Эфиопия күнтізбесі},
 				'gregorian' => q{Грегориандық күнтізбе},
 				'hebrew' => q{Көне еврей күнтізбесі},
 				'indian' => q{Үндістанның ұлттық күнтізбесі},
 				'islamic' => q{Ислам күнтізбесі},
 				'islamic-civil' => q{Ислам азаматтық күнтізбесі},
 				'iso8601' => q{ISO-8601 күнтізбесі},
 				'japanese' => q{Жапон күнтізбесі},
 				'persian' => q{Парсы күнтізбесі},
 				'roc' => q{Мингуо күнтізбесі},
 			},
 			'collation' => {
 				'ducet' => q{Әдепкі уникод сұрыптау реті},
 				'search' => q{Жалпы мақсаттағы іздеу},
 				'standard' => q{Стандартты сұрыптау реті},
 			},
 			'hc' => {
 				'h11' => q{12 сағаттық жүйе (0–11)},
 				'h12' => q{12 сағаттық жүйе (1–12)},
 				'h23' => q{24 сағаттық жүйе (0–23)},
 				'h24' => q{24 сағаттық жүйе (1–24)},
 			},
 			'lb' => {
 				'loose' => q{Жолды тасымалдаудың еркін стилі},
 				'normal' => q{Жолды тасымалдаудың қалыпты стилі},
 				'strict' => q{Жолды тасымалдаудың қатаң стилі},
 			},
 			'ms' => {
 				'metric' => q{Метрлік жүйе},
 				'uksystem' => q{Империялық өлшемдер жүйесі},
 				'ussystem' => q{Американдық өлшемдер жүйесі},
 			},
 			'numbers' => {
 				'arab' => q{Үнді-араб сандары},
 				'arabext' => q{Үнді-араб сандарының кеңейтілген жүйесі},
 				'armn' => q{Армян сандары},
 				'armnlow' => q{Кіші әріппен берілген армян сандары},
 				'beng' => q{Бенгал сандары},
 				'deva' => q{Деванагари сандары},
 				'ethi' => q{Эфиопия сандары},
 				'fullwide' => q{Сандардың толық пішімі},
 				'geor' => q{Грузин сандары},
 				'grek' => q{Грек сандары},
 				'greklow' => q{Кіші әріппен берілген грек сандары},
 				'gujr' => q{Гуджарати сандары},
 				'guru' => q{Гурмукхи сандары},
 				'hanidec' => q{Қытай ондық сандары},
 				'hans' => q{Жеңілдетілген қытай сандары},
 				'hansfin' => q{Қаржы саласындағы жеңілдетілген қытай сандары},
 				'hant' => q{Дәстүрлі қытай сандары},
 				'hantfin' => q{Қаржы саласындағы дәстүрлі қытай сандары},
 				'hebr' => q{Иврит сандары},
 				'jpan' => q{Жапон сандары},
 				'jpanfin' => q{Қаржы саласындағы жапон сандары},
 				'khmr' => q{Кхмер сандары},
 				'knda' => q{Каннада сандары},
 				'laoo' => q{Лаос сандары},
 				'latn' => q{Батыс сандары},
 				'mlym' => q{Малаялам сандары},
 				'mymr' => q{Мьянма сандары},
 				'orya' => q{Ория сандары},
 				'roman' => q{Рим сандары},
 				'romanlow' => q{Кіші әріппен берілген рим сандары},
 				'taml' => q{Дәстүрлі тамил сандары},
 				'tamldec' => q{Тамил сандары},
 				'telu' => q{Телугу сандары},
 				'thai' => q{Тай сандары},
 				'tibt' => q{Тибет сандары},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{Метрлік},
 			'UK' => q{Ағылшын},
 			'US' => q{Американдық},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => 'Тіл: {0}',
 			'script' => 'Жазу: {0}',
 			'region' => 'Аймақ: {0}',

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['А', 'Ә', 'Б', 'В', 'Г', 'Ғ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ұ', 'Ү', 'Ф', 'Х', 'Һ', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'І', 'Ь', 'Э', 'Ю', 'Я'],
			main => qr{(?^u:[а ә б в г ғ д е ё ж з и й к қ л м н ң о ө п р с т у ұ ү ф х һ ц ч ш щ ъ ы і ь э ю я])},
			punctuation => qr{(?^u:[\- ‐ – — , ; \: ! ? . … ' ‘ ’ " “ ” « » ( ) \[ \] \{ \} § @ * / \& #])},
		};
	},
EOT
: sub {
		return { index => ['А', 'Ә', 'Б', 'В', 'Г', 'Ғ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'И', 'Й', 'К', 'Қ', 'Л', 'М', 'Н', 'Ң', 'О', 'Ө', 'П', 'Р', 'С', 'Т', 'У', 'Ұ', 'Ү', 'Ф', 'Х', 'Һ', 'Ц', 'Ч', 'Ш', 'Щ', 'Ъ', 'Ы', 'І', 'Ь', 'Э', 'Ю', 'Я'], };
},
);


has 'ellipsis' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub {
		return {
			'final' => '{0}…',
			'initial' => '…{0}',
			'medial' => '{0}…{1}',
			'word-final' => '{0} …',
			'word-initial' => '… {0}',
			'word-medial' => '{0} … {1}',
		};
	},
);

has 'more_information' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{?},
);

has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'name' => q(акро-фут),
						'one' => q({0} aкро-фут),
						'other' => q({0} aкро-фут),
					},
					'ampere' => {
						'name' => q(ампер),
						'one' => q({0} aмпер),
						'other' => q({0} aмпер),
					},
					'arc-minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
					},
					'arc-second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
					},
					'astronomical-unit' => {
						'name' => q(астрономиялық бірлік),
						'one' => q({0} астрономиялық бірлік),
						'other' => q({0} астрономиялық бірлік),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'name' => q(калория),
						'one' => q({0} калория),
						'other' => q({0} калория),
					},
					'carat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'celsius' => {
						'name' => q(Цельсий градусы),
						'one' => q({0} Цельсий градусы),
						'other' => q({0} Цельсий градусы),
					},
					'centiliter' => {
						'name' => q(сантилитр),
						'one' => q({0} cантилитр),
						'other' => q({0} cантилитр),
					},
					'centimeter' => {
						'name' => q(сантиметр),
						'one' => q({0} сантиметр),
						'other' => q({0} сантиметр),
						'per' => q({0}/сантиметр),
					},
					'century' => {
						'name' => q(ғасыр),
						'one' => q({0} ғасыр),
						'other' => q({0} ғасыр),
					},
					'coordinate' => {
						'east' => q({0} Ш),
						'north' => q({0} С),
						'south' => q({0} О),
						'west' => q({0} Б),
					},
					'cubic-centimeter' => {
						'name' => q(текше сантиметр),
						'one' => q({0} текше сантиметр),
						'other' => q({0} текше сантиметр),
						'per' => q({0}/сантиметр³),
					},
					'cubic-foot' => {
						'name' => q(текше фут),
						'one' => q({0} текше фут),
						'other' => q({0} текше фут),
					},
					'cubic-inch' => {
						'name' => q(текше дюйм),
						'one' => q({0} текше дюйм),
						'other' => q({0} текше дюйм),
					},
					'cubic-kilometer' => {
						'name' => q(текше километр),
						'one' => q({0} текше километр),
						'other' => q({0} текше километр),
					},
					'cubic-meter' => {
						'name' => q(текше метр),
						'one' => q({0} текше метр),
						'other' => q({0} текше метр),
						'per' => q({0}/метр³),
					},
					'cubic-mile' => {
						'name' => q(текше миля),
						'one' => q({0} текше миля),
						'other' => q({0} текше миля),
					},
					'cubic-yard' => {
						'name' => q(текше ярд),
						'one' => q({0} текше ярд),
						'other' => q({0} текше ярд),
					},
					'cup' => {
						'name' => q(кесе),
						'one' => q({0} кесе),
						'other' => q({0} кесе),
					},
					'cup-metric' => {
						'name' => q(метрлік кесе),
						'one' => q({0} метрлік кесе),
						'other' => q({0} метрлік кесе),
					},
					'day' => {
						'name' => q(тәулік),
						'one' => q({0} тәулік),
						'other' => q({0} тәулік),
						'per' => q(тәулігіне {0}),
					},
					'deciliter' => {
						'name' => q(децилитр),
						'one' => q({0} децилитр),
						'other' => q({0} децилитр),
					},
					'decimeter' => {
						'name' => q(дециметр),
						'one' => q({0} дециметр),
						'other' => q({0} дециметр),
					},
					'degree' => {
						'name' => q(градус),
						'one' => q({0} градус),
						'other' => q({0} градус),
					},
					'fahrenheit' => {
						'name' => q(Фаренгейт градусы),
						'one' => q({0} Фаренгейт градусы),
						'other' => q({0} Фаренгейт градусы),
					},
					'fluid-ounce' => {
						'name' => q(сұйық унция),
						'one' => q({0} сұйық унция),
						'other' => q({0} сұйық унция),
					},
					'foodcalorie' => {
						'name' => q(Калория),
						'one' => q({0} Калория),
						'other' => q({0} Калория),
					},
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					'g-force' => {
						'name' => q(гравитациялық күш),
						'one' => q({0} гравитациялық күш),
						'other' => q({0} гравитациялық күш),
					},
					'gallon' => {
						'name' => q(галлон),
						'one' => q({0} галлон),
						'other' => q({0} галлон),
						'per' => q({0}/галлон),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(гигабит),
						'one' => q({0} гигабит),
						'other' => q({0} гигабит),
					},
					'gigabyte' => {
						'name' => q(гигабайт),
						'one' => q({0} гигабайт),
						'other' => q({0} гигабайт),
					},
					'gigahertz' => {
						'name' => q(гигагерц),
						'one' => q({0} гигагерц),
						'other' => q({0} гигагерц),
					},
					'gigawatt' => {
						'name' => q(гигаватт),
						'one' => q({0} гигаватт),
						'other' => q({0} гигаватт),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} грамм),
						'other' => q({0} грамм),
						'per' => q({0}/грамм),
					},
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} гектар),
						'other' => q({0} гектар),
					},
					'hectoliter' => {
						'name' => q(гектолитр),
						'one' => q({0} гектолитр),
						'other' => q({0} гектолитр),
					},
					'hectopascal' => {
						'name' => q(гектопаскаль),
						'one' => q({0} гектопаскаль),
						'other' => q({0} гектопаскаль),
					},
					'hertz' => {
						'name' => q(герц),
						'one' => q({0} герц),
						'other' => q({0} герц),
					},
					'horsepower' => {
						'name' => q(ат күші),
						'one' => q({0} ат күші),
						'other' => q({0} ат күші),
					},
					'hour' => {
						'name' => q(сағат),
						'one' => q({0} сағат),
						'other' => q({0} сағат),
						'per' => q(сағатына {0}),
					},
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					'inch-hg' => {
						'name' => q(сынап бағанасының дюймы),
						'one' => q(сынап бағанасының {0} дюймы),
						'other' => q(сынап бағанасының {0} дюймы),
					},
					'joule' => {
						'name' => q(джоуль),
						'one' => q({0} джоуль),
						'other' => q({0} джоуль),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} карат),
						'other' => q({0} карат),
					},
					'kelvin' => {
						'name' => q(кельвин),
						'one' => q({0} кельвин),
						'other' => q({0} кельвин),
					},
					'kilobit' => {
						'name' => q(килобит),
						'one' => q({0} килобит),
						'other' => q({0} килобит),
					},
					'kilobyte' => {
						'name' => q(килобайт),
						'one' => q({0} килобайт),
						'other' => q({0} килобайт),
					},
					'kilocalorie' => {
						'name' => q(килокалория),
						'one' => q({0} килокалория),
						'other' => q({0} килокалория),
					},
					'kilogram' => {
						'name' => q(килограмм),
						'one' => q({0} килограмм),
						'other' => q({0} килограмм),
						'per' => q({0}/килограмм),
					},
					'kilohertz' => {
						'name' => q(килогерц),
						'one' => q({0} килогерц),
						'other' => q({0} килогерц),
					},
					'kilojoule' => {
						'name' => q(килоджоуль),
						'one' => q({0} килоджуоль),
						'other' => q({0} килоджоуль),
					},
					'kilometer' => {
						'name' => q(километр),
						'one' => q({0} километр),
						'other' => q({0} километр),
						'per' => q({0}/километр),
					},
					'kilometer-per-hour' => {
						'name' => q(километр/сағат),
						'one' => q({0} километр/сағат),
						'other' => q({0} километр/сағат),
					},
					'kilowatt' => {
						'name' => q(киловатт),
						'one' => q({0} киловатт),
						'other' => q({0} киловатт),
					},
					'kilowatt-hour' => {
						'name' => q(киловатт-сағат),
						'one' => q({0} киловатт-сағат),
						'other' => q({0} киловатт-сағат),
					},
					'knot' => {
						'name' => q(түйін),
						'one' => q({0} түйін),
						'other' => q({0} түйін),
					},
					'light-year' => {
						'name' => q(жарық жылы),
						'one' => q({0} жарық жылы),
						'other' => q({0} жарық жылы),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} литр),
						'other' => q({0} литр),
						'per' => q({0}/литр),
					},
					'liter-per-100kilometers' => {
						'name' => q(литр/100 километр),
						'one' => q({0} литр/100 километр),
						'other' => q({0} литр/100 километр),
					},
					'liter-per-kilometer' => {
						'name' => q(литр/километр),
						'one' => q({0} литр/километр),
						'other' => q({0} литр/километр),
					},
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} люкс),
						'other' => q({0} люкс),
					},
					'megabit' => {
						'name' => q(мегабит),
						'one' => q({0} мегабит),
						'other' => q({0} мегабит),
					},
					'megabyte' => {
						'name' => q(мегабайт),
						'one' => q({0} мегабайт),
						'other' => q({0} мегабайт),
					},
					'megahertz' => {
						'name' => q(мегагерц),
						'one' => q({0} мегагерц),
						'other' => q({0} мегагерц),
					},
					'megaliter' => {
						'name' => q(мегалитр),
						'one' => q({0} мегалитр),
						'other' => q({0} мегалитр),
					},
					'megawatt' => {
						'name' => q(мегаватт),
						'one' => q({0} мегаватт),
						'other' => q({0} мегаватт),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} метр),
						'other' => q({0} метр),
						'per' => q({0}/метр),
					},
					'meter-per-second' => {
						'name' => q(метр/секунд),
						'one' => q({0} метр/секунд),
						'other' => q({0} метр/секунд),
					},
					'meter-per-second-squared' => {
						'name' => q(метр/шаршы секунд),
						'one' => q({0} метр/шаршы секунд),
						'other' => q({0} метр/шаршы секунд),
					},
					'metric-ton' => {
						'name' => q(метрлік тонна),
						'one' => q({0} метрлік тонна),
						'other' => q({0} метрлік тонна),
					},
					'microgram' => {
						'name' => q(микрограмм),
						'one' => q({0} микрограмм),
						'other' => q({0} микрограмм),
					},
					'micrometer' => {
						'name' => q(микрометр),
						'one' => q({0} микрометр),
						'other' => q({0} микрометр),
					},
					'microsecond' => {
						'name' => q(микросекунд),
						'one' => q({0} микросекунд),
						'other' => q({0} микросекунд),
					},
					'mile' => {
						'name' => q(миля),
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					'mile-per-gallon' => {
						'name' => q(миля/галлон),
						'one' => q({0} миля/галлон),
						'other' => q({0} миля/галллон),
					},
					'mile-per-hour' => {
						'name' => q(миля/сағат),
						'one' => q({0} миля/сағат),
						'other' => q({0} миля/сағат),
					},
					'mile-scandinavian' => {
						'name' => q(скандинавиялық миля),
						'one' => q({0} скандинавиялық миля),
						'other' => q({0} скандинавиялық миля),
					},
					'milliampere' => {
						'name' => q(миллиампер),
						'one' => q({0} миллиампер),
						'other' => q({0} миллиампер),
					},
					'millibar' => {
						'name' => q(миллибар),
						'one' => q({0} миллибар),
						'other' => q({0} миллибар),
					},
					'milligram' => {
						'name' => q(миллиграмм),
						'one' => q({0} миллиграмм),
						'other' => q({0} миллиграмм),
					},
					'milliliter' => {
						'name' => q(миллилитр),
						'one' => q({0} миллилитр),
						'other' => q({0} миллилитр),
					},
					'millimeter' => {
						'name' => q(миллиметр),
						'one' => q({0} миллиметр),
						'other' => q({0} миллиметр),
					},
					'millimeter-of-mercury' => {
						'name' => q(сынап бағанасының миллиметрі),
						'one' => q(сынап бағанасының {0} миллиметрі),
						'other' => q(сынап бағанасының {0} миллиметрі),
					},
					'millisecond' => {
						'name' => q(миллисекунд),
						'one' => q({0} миллисекунд),
						'other' => q({0} миллисекунд),
					},
					'milliwatt' => {
						'name' => q(милливатт),
						'one' => q({0} милливатт),
						'other' => q({0} милливатт),
					},
					'minute' => {
						'name' => q(минут),
						'one' => q({0} минут),
						'other' => q({0} минут),
						'per' => q(минутына {0}),
					},
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
						'per' => q(айына {0}),
					},
					'nanometer' => {
						'name' => q(нанометр),
						'one' => q({0} нанометр),
						'other' => q({0} нанометр),
					},
					'nanosecond' => {
						'name' => q(наносекунд),
						'one' => q({0} наносекунд),
						'other' => q({0} наносекунд),
					},
					'nautical-mile' => {
						'name' => q(теңіз милясы),
						'one' => q({0} теңіз милясы),
						'other' => q({0} теңіз милясы),
					},
					'ohm' => {
						'name' => q(Ом),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					'ounce' => {
						'name' => q(унция),
						'one' => q({0} унция),
						'other' => q({0} унция),
						'per' => q({0}/унция),
					},
					'ounce-troy' => {
						'name' => q(трой унциясы),
						'one' => q({0} трой унциясы),
						'other' => q({0} трой унциясы),
					},
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} парсек),
						'other' => q({0} парсек),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пикометр),
						'other' => q({0} пикометр),
					},
					'pint' => {
						'name' => q(пинта),
						'one' => q({0} пинта),
						'other' => q({0} пинта),
					},
					'pint-metric' => {
						'name' => q(метрлік пинта),
						'one' => q({0} метрлік пинта),
						'other' => q({0} метрлік пинта),
					},
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					'pound-per-square-inch' => {
						'name' => q(фунт/шаршы дюйм),
						'one' => q({0} фунт/шаршы дюйм),
						'other' => q({0} фунт/шаршы дюйм),
					},
					'quart' => {
						'name' => q(кварта),
						'one' => q({0} кварта),
						'other' => q({0} кварта),
					},
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} радиан),
						'other' => q({0} радиан),
					},
					'revolution' => {
						'name' => q(айналым),
						'one' => q({0} айналым),
						'other' => q({0} айналым),
					},
					'second' => {
						'name' => q(секунд),
						'one' => q({0} секунд),
						'other' => q({0} секунд),
						'per' => q(секундына {0}),
					},
					'square-centimeter' => {
						'name' => q(шаршы сантиметр),
						'one' => q({0} шаршы сантиметр),
						'other' => q({0} шаршы сантиметр),
						'per' => q({0}/см²),
					},
					'square-foot' => {
						'name' => q(шаршы фут),
						'one' => q({0} шаршы фут),
						'other' => q({0} шаршы фут),
					},
					'square-inch' => {
						'name' => q(шаршы дюйм),
						'one' => q({0} шаршы дюйм),
						'other' => q({0} шаршы дюйм),
						'per' => q({0}/дюйм²),
					},
					'square-kilometer' => {
						'name' => q(шаршы километр),
						'one' => q({0} шаршы километр),
						'other' => q({0} шаршы километр),
					},
					'square-meter' => {
						'name' => q(шаршы метр),
						'one' => q({0} шаршы метр),
						'other' => q({0} шаршы метр),
						'per' => q({0}/метр²),
					},
					'square-mile' => {
						'name' => q(шаршы миля),
						'one' => q({0} шаршы миля),
						'other' => q({0} шаршы миля),
					},
					'square-yard' => {
						'name' => q(шаршы ярд),
						'one' => q({0} шаршы ярд),
						'other' => q({0} шаршы ярд),
					},
					'tablespoon' => {
						'name' => q(ас қасық),
						'one' => q({0} ас қасық),
						'other' => q({0} ас қасық),
					},
					'teaspoon' => {
						'name' => q(шай қасық),
						'one' => q({0} шай қасық),
						'other' => q({0} шай қасық),
					},
					'terabit' => {
						'name' => q(терабит),
						'one' => q({0} терабит),
						'other' => q({0} терабит),
					},
					'terabyte' => {
						'name' => q(терабайт),
						'one' => q({0} терабайт),
						'other' => q({0} терабайт),
					},
					'ton' => {
						'name' => q(тонна),
						'one' => q({0} тонна),
						'other' => q({0} тонна),
					},
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} вольт),
						'other' => q({0} вольт),
					},
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} ватт),
						'other' => q({0} ватт),
					},
					'week' => {
						'name' => q(апта),
						'one' => q({0} апта),
						'other' => q({0} апта),
						'per' => q(аптасына {0}),
					},
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жыл),
						'one' => q({0} жыл),
						'other' => q({0} жыл),
						'per' => q(жылына {0}),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
					},
					'coordinate' => {
						'east' => q({0} Ш),
						'north' => q({0} С),
						'south' => q({0} О),
						'west' => q({0} Б),
					},
					'cubic-kilometer' => {
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-mile' => {
						'one' => q({0} миля³),
						'other' => q({0} миля³),
					},
					'day' => {
						'name' => q(күн),
						'one' => q({0} к.),
						'other' => q({0} к.),
					},
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} фут),
						'other' => q({0} фут),
					},
					'g-force' => {
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} г),
						'other' => q({0} г),
					},
					'hectare' => {
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectopascal' => {
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'horsepower' => {
						'one' => q({0} ат күші),
						'other' => q({0} ат күші),
					},
					'hour' => {
						'name' => q(сағ.),
						'one' => q({0} сағ.),
						'other' => q({0} сағ.),
					},
					'inch' => {
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/сағ),
						'one' => q({0} км/сағ),
						'other' => q({0} км/сағ),
					},
					'kilowatt' => {
						'one' => q({0}кВт),
						'other' => q({0}кВт),
					},
					'light-year' => {
						'one' => q({0} ly),
						'other' => q({0} ly),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
					},
					'liter-per-100kilometers' => {
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
					},
					'meter-per-second' => {
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'mile' => {
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					'mile-per-hour' => {
						'one' => q({0} миля/сағ),
						'other' => q({0} миля/сағ),
					},
					'millibar' => {
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millisecond' => {
						'name' => q(мс),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'minute' => {
						'name' => q(мин.),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
					},
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
					},
					'ounce' => {
						'one' => q({0} унция),
						'other' => q({0} унция),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pound' => {
						'one' => q({0} фунт),
						'other' => q({0} фунт),
					},
					'second' => {
						'name' => q(с),
						'one' => q({0} с),
						'other' => q({0} с),
					},
					'square-foot' => {
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-kilometer' => {
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'one' => q({0} м²),
						'other' => q({0} м²),
					},
					'square-mile' => {
						'one' => q({0} миля²),
						'other' => q({0} миля²),
					},
					'watt' => {
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'name' => q(ап.),
						'one' => q({0} ап.),
						'other' => q({0} ап.),
					},
					'yard' => {
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(ж.),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(акр),
						'one' => q({0} акр),
						'other' => q({0} акр),
					},
					'acre-foot' => {
						'name' => q(aкро-фут),
						'one' => q({0} aкро-фут),
						'other' => q({0} aкро-фут),
					},
					'ampere' => {
						'name' => q(А),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(минут),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
					},
					'arc-second' => {
						'name' => q(секунд),
						'one' => q({0} сек.),
						'other' => q({0} сек.),
					},
					'astronomical-unit' => {
						'name' => q(а.б.),
						'one' => q({0} а.б.),
						'other' => q({0} а.б.),
					},
					'bit' => {
						'name' => q(бит),
						'one' => q({0} бит),
						'other' => q({0} бит),
					},
					'byte' => {
						'name' => q(байт),
						'one' => q({0} байт),
						'other' => q({0} байт),
					},
					'calorie' => {
						'name' => q(кал),
						'one' => q({0} кал),
						'other' => q({0} кал),
					},
					'carat' => {
						'name' => q(карат),
						'one' => q({0} КТ),
						'other' => q({0} КТ),
					},
					'celsius' => {
						'name' => q(Цельсий градусы),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(сл),
						'one' => q({0} cл),
						'other' => q({0} cл),
					},
					'centimeter' => {
						'name' => q(см),
						'one' => q({0} см),
						'other' => q({0} см),
						'per' => q({0}/см),
					},
					'century' => {
						'name' => q(ғ.),
						'one' => q({0} ғ.),
						'other' => q({0} ғ.),
					},
					'coordinate' => {
						'east' => q({0} Ш),
						'north' => q({0} С),
						'south' => q({0} О),
						'west' => q({0} Б),
					},
					'cubic-centimeter' => {
						'name' => q(cм³),
						'one' => q({0} cм³),
						'other' => q({0} cм³),
						'per' => q({0}/см³),
					},
					'cubic-foot' => {
						'name' => q(фут³),
						'one' => q({0} фт³),
						'other' => q({0} фт³),
					},
					'cubic-inch' => {
						'name' => q(дюйм³),
						'one' => q({0} дюйм³),
						'other' => q({0} дюйм³),
					},
					'cubic-kilometer' => {
						'name' => q(км³),
						'one' => q({0} км³),
						'other' => q({0} км³),
					},
					'cubic-meter' => {
						'name' => q(м³),
						'one' => q({0} м³),
						'other' => q({0} м³),
						'per' => q({0}/м³),
					},
					'cubic-mile' => {
						'name' => q(миля³),
						'one' => q({0} миля³),
						'other' => q({0} миля³),
					},
					'cubic-yard' => {
						'name' => q(ярд³),
						'one' => q({0} ярд³),
						'other' => q({0} ярд³),
					},
					'cup' => {
						'name' => q(кесе),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'cup-metric' => {
						'name' => q(м. кесе),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(күн),
						'one' => q({0} күн),
						'other' => q({0} күн),
						'per' => q({0}/күн),
					},
					'deciliter' => {
						'name' => q(дл),
						'one' => q({0} дл),
						'other' => q({0} дл),
					},
					'decimeter' => {
						'name' => q(дм),
						'one' => q({0} дм),
						'other' => q({0} дм),
					},
					'degree' => {
						'name' => q(градус),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'fahrenheit' => {
						'name' => q(Фаренгейт градусы),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(Кал),
						'one' => q({0} Кал),
						'other' => q({0} Кал),
					},
					'foot' => {
						'name' => q(фут),
						'one' => q({0} фут),
						'other' => q({0} фут),
						'per' => q({0}/фут),
					},
					'g-force' => {
						'name' => q(гравитациялық күш),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Гбит),
						'one' => q({0} Гб),
						'other' => q({0} Гб),
					},
					'gigabyte' => {
						'name' => q(Гбайт),
						'one' => q({0} ГБ),
						'other' => q({0} ГБ),
					},
					'gigahertz' => {
						'name' => q(ГГц),
						'one' => q({0} ГГц),
						'other' => q({0} ГГц),
					},
					'gigawatt' => {
						'name' => q(ГВт),
						'one' => q({0} ГВт),
						'other' => q({0} ГВт),
					},
					'gram' => {
						'name' => q(грамм),
						'one' => q({0} г),
						'other' => q({0} г),
						'per' => q({0}/г),
					},
					'hectare' => {
						'name' => q(гектар),
						'one' => q({0} га),
						'other' => q({0} га),
					},
					'hectoliter' => {
						'name' => q(гл),
						'one' => q({0} гл),
						'other' => q({0} гл),
					},
					'hectopascal' => {
						'name' => q(гектопаскаль),
						'one' => q({0} гПа),
						'other' => q({0} гПа),
					},
					'hertz' => {
						'name' => q(Гц),
						'one' => q({0} Гц),
						'other' => q({0} Гц),
					},
					'horsepower' => {
						'name' => q(а. к.),
						'one' => q({0} а. к.),
						'other' => q({0} а. к.),
					},
					'hour' => {
						'name' => q(сағат),
						'one' => q({0} сағ.),
						'other' => q({0} сағ.),
						'per' => q({0}/сағ.),
					},
					'inch' => {
						'name' => q(дюйм),
						'one' => q({0} дюйм),
						'other' => q({0} дюйм),
						'per' => q({0}/дюйм),
					},
					'inch-hg' => {
						'name' => q(in Hg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(джоуль),
						'one' => q({0} Дж),
						'other' => q({0} Дж),
					},
					'karat' => {
						'name' => q(карат),
						'one' => q({0} КТ),
						'other' => q({0} КТ),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} К),
						'other' => q({0} К),
					},
					'kilobit' => {
						'name' => q(кбит),
						'one' => q({0} кб),
						'other' => q({0} кб),
					},
					'kilobyte' => {
						'name' => q(кбайт),
						'one' => q({0} кБ),
						'other' => q({0} кБ),
					},
					'kilocalorie' => {
						'name' => q(ккал),
						'one' => q({0} ккал),
						'other' => q({0} ккал),
					},
					'kilogram' => {
						'name' => q(кг),
						'one' => q({0} кг),
						'other' => q({0} кг),
						'per' => q({0}/кг),
					},
					'kilohertz' => {
						'name' => q(кГц),
						'one' => q({0} кГц),
						'other' => q({0} кГц),
					},
					'kilojoule' => {
						'name' => q(килоджоуль),
						'one' => q({0} кДж),
						'other' => q({0} кДж),
					},
					'kilometer' => {
						'name' => q(км),
						'one' => q({0} км),
						'other' => q({0} км),
						'per' => q({0}/км),
					},
					'kilometer-per-hour' => {
						'name' => q(км/сағ),
						'one' => q({0} км/сағ),
						'other' => q({0} км/сағ),
					},
					'kilowatt' => {
						'name' => q(киловатт),
						'one' => q({0} кВт),
						'other' => q({0} кВт),
					},
					'kilowatt-hour' => {
						'name' => q(кВт-сағ),
						'one' => q({0} кВт-сағ),
						'other' => q({0} кВт-сағ),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(жарық жылы),
						'one' => q({0} ж. ж.),
						'other' => q({0} ж. ж.),
					},
					'liter' => {
						'name' => q(литр),
						'one' => q({0} л),
						'other' => q({0} л),
						'per' => q({0}/л),
					},
					'liter-per-100kilometers' => {
						'name' => q(л/100 км),
						'one' => q({0} л/100 км),
						'other' => q({0} л/100 км),
					},
					'liter-per-kilometer' => {
						'name' => q(литр/км),
						'one' => q({0} л/км),
						'other' => q({0} л/км),
					},
					'lux' => {
						'name' => q(люкс),
						'one' => q({0} лк),
						'other' => q({0} лк),
					},
					'megabit' => {
						'name' => q(Мбит),
						'one' => q({0} Mб),
						'other' => q({0} Mб),
					},
					'megabyte' => {
						'name' => q(Мбайт),
						'one' => q({0} MБ),
						'other' => q({0} MБ),
					},
					'megahertz' => {
						'name' => q(МГц),
						'one' => q({0} MГц),
						'other' => q({0} MГц),
					},
					'megaliter' => {
						'name' => q(Мл),
						'one' => q({0} Мл),
						'other' => q({0} Мл),
					},
					'megawatt' => {
						'name' => q(МВт),
						'one' => q({0} МВт),
						'other' => q({0} МВт),
					},
					'meter' => {
						'name' => q(метр),
						'one' => q({0} м),
						'other' => q({0} м),
						'per' => q({0}/м),
					},
					'meter-per-second' => {
						'name' => q(метр/секунд),
						'one' => q({0} м/с),
						'other' => q({0} м/с),
					},
					'meter-per-second-squared' => {
						'name' => q(метр/сек²),
						'one' => q({0} м/с²),
						'other' => q({0} м/с²),
					},
					'metric-ton' => {
						'name' => q(т),
						'one' => q({0} т),
						'other' => q({0} т),
					},
					'microgram' => {
						'name' => q(мкг),
						'one' => q({0} мкг),
						'other' => q({0} мкг),
					},
					'micrometer' => {
						'name' => q(мкм),
						'one' => q({0} мкм),
						'other' => q({0} мкм),
					},
					'microsecond' => {
						'name' => q(мкс),
						'one' => q({0} мкс),
						'other' => q({0} мкс),
					},
					'mile' => {
						'name' => q(миля),
						'one' => q({0} миля),
						'other' => q({0} миля),
					},
					'mile-per-gallon' => {
						'name' => q(миля/галллон),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-hour' => {
						'name' => q(миля/сағат),
						'one' => q({0} миля/сағ),
						'other' => q({0} миля/сағ),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(миллиампер),
						'one' => q({0} мA),
						'other' => q({0} мA),
					},
					'millibar' => {
						'name' => q(мбар),
						'one' => q({0} мб),
						'other' => q({0} мб),
					},
					'milligram' => {
						'name' => q(мг),
						'one' => q({0} мг),
						'other' => q({0} мг),
					},
					'milliliter' => {
						'name' => q(мл),
						'one' => q({0} мл),
						'other' => q({0} мл),
					},
					'millimeter' => {
						'name' => q(мм),
						'one' => q({0} мм),
						'other' => q({0} мм),
					},
					'millimeter-of-mercury' => {
						'name' => q(с.б.мм.),
						'one' => q({0} с.б.мм.),
						'other' => q({0} с.б.мм.),
					},
					'millisecond' => {
						'name' => q(мсек.),
						'one' => q({0} мс),
						'other' => q({0} мс),
					},
					'milliwatt' => {
						'name' => q(мВт),
						'one' => q({0} мВт),
						'other' => q({0} мВт),
					},
					'minute' => {
						'name' => q(мин.),
						'one' => q({0} мин.),
						'other' => q({0} мин.),
						'per' => q({0}/мин.),
					},
					'month' => {
						'name' => q(ай),
						'one' => q({0} ай),
						'other' => q({0} ай),
						'per' => q({0}/ай),
					},
					'nanometer' => {
						'name' => q(нм),
						'one' => q({0} нм),
						'other' => q({0} нм),
					},
					'nanosecond' => {
						'name' => q(нс),
						'one' => q({0} нс),
						'other' => q({0} нс),
					},
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'name' => q(Ом),
						'one' => q({0} Ом),
						'other' => q({0} Ом),
					},
					'ounce' => {
						'name' => q(унц.),
						'one' => q({0} унц.),
						'other' => q({0} унц.),
						'per' => q({0}/унц.),
					},
					'ounce-troy' => {
						'name' => q(тр. унц.),
						'one' => q({0} тр. унц.),
						'other' => q({0} тр. унц.),
					},
					'parsec' => {
						'name' => q(парсек),
						'one' => q({0} пк),
						'other' => q({0} пк),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(пикометр),
						'one' => q({0} пм),
						'other' => q({0} пм),
					},
					'pint' => {
						'name' => q(пинта),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'pound' => {
						'name' => q(фунт),
						'one' => q({0} фунт),
						'other' => q({0} фунт),
						'per' => q({0}/фунт),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(радиан),
						'one' => q({0} рад),
						'other' => q({0} рад),
					},
					'revolution' => {
						'name' => q(айн.),
						'one' => q({0} айн.),
						'other' => q({0} айн.),
					},
					'second' => {
						'name' => q(сек.),
						'one' => q({0} сек.),
						'other' => q({0} сек.),
						'per' => q({0}/с),
					},
					'square-centimeter' => {
						'name' => q(cм²),
						'one' => q({0} cм²),
						'other' => q({0} cм²),
						'per' => q({0}/см²),
					},
					'square-foot' => {
						'name' => q(шаршы фут),
						'one' => q({0} фут²),
						'other' => q({0} фут²),
					},
					'square-inch' => {
						'name' => q(дюйм²),
						'one' => q({0} дюйм²),
						'other' => q({0} дюйм²),
						'per' => q({0}/дюйм²),
					},
					'square-kilometer' => {
						'name' => q(км²),
						'one' => q({0} км²),
						'other' => q({0} км²),
					},
					'square-meter' => {
						'name' => q(метр²),
						'one' => q({0} м²),
						'other' => q({0} м²),
						'per' => q({0}/м²),
					},
					'square-mile' => {
						'name' => q(шаршы миля),
						'one' => q({0} миля²),
						'other' => q({0} миля²),
					},
					'square-yard' => {
						'name' => q(ярд²),
						'one' => q({0} ярд²),
						'other' => q({0} ярд²),
					},
					'tablespoon' => {
						'name' => q(ас қ.),
						'one' => q({0} ас қ.),
						'other' => q({0} ас қ.),
					},
					'teaspoon' => {
						'name' => q(ш. қ.),
						'one' => q({0} ш. қ.),
						'other' => q({0} ш. қ.),
					},
					'terabit' => {
						'name' => q(Тбит),
						'one' => q({0} Tб),
						'other' => q({0} Tб),
					},
					'terabyte' => {
						'name' => q(Тбайт),
						'one' => q({0} TБ),
						'other' => q({0} TБ),
					},
					'ton' => {
						'name' => q(тонна),
						'one' => q({0} тн),
						'other' => q({0} тн),
					},
					'volt' => {
						'name' => q(вольт),
						'one' => q({0} В),
						'other' => q({0} В),
					},
					'watt' => {
						'name' => q(ватт),
						'one' => q({0} Вт),
						'other' => q({0} Вт),
					},
					'week' => {
						'name' => q(апта),
						'one' => q({0} ап.),
						'other' => q({0} ап.),
						'per' => q({0}/ап.),
					},
					'yard' => {
						'name' => q(ярд),
						'one' => q({0} ярд),
						'other' => q({0} ярд),
					},
					'year' => {
						'name' => q(жыл),
						'one' => q({0} ж.),
						'other' => q({0} ж.),
						'per' => q({0}/ж.),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:иә|и|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:жоқ|ж|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'latn',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'decimal' => q(,),
			'exponential' => q(E),
			'group' => q( ),
			'infinity' => q(∞),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'1000' => {
					'one' => '0 мың',
					'other' => '0 мың',
				},
				'10000' => {
					'one' => '00 мың',
					'other' => '00 мың',
				},
				'100000' => {
					'one' => '000 мың',
					'other' => '000 мың',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
				'standard' => {
					'' => '#,##0.###',
				},
			},
			'long' => {
				'1000' => {
					'one' => '0 мың',
					'other' => '0 мың',
				},
				'10000' => {
					'one' => '00 мың',
					'other' => '00 мың',
				},
				'100000' => {
					'one' => '000 мың',
					'other' => '000 мың',
				},
				'1000000' => {
					'one' => '0 миллион',
					'other' => '0 миллион',
				},
				'10000000' => {
					'one' => '00 миллион',
					'other' => '00 миллион',
				},
				'100000000' => {
					'one' => '000 миллион',
					'other' => '000 миллион',
				},
				'1000000000' => {
					'one' => '0 миллиард',
					'other' => '0 миллиард',
				},
				'10000000000' => {
					'one' => '00 миллиард',
					'other' => '00 миллиард',
				},
				'100000000000' => {
					'one' => '000 миллиард',
					'other' => '000 миллиард',
				},
				'1000000000000' => {
					'one' => '0 триллион',
					'other' => '0 триллион',
				},
				'10000000000000' => {
					'one' => '00 триллион',
					'other' => '00 триллион',
				},
				'100000000000000' => {
					'one' => '000 триллион',
					'other' => '000 триллион',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 мың',
					'other' => '0 мың',
				},
				'10000' => {
					'one' => '00 мың',
					'other' => '00 мың',
				},
				'100000' => {
					'one' => '000 мың',
					'other' => '000 мың',
				},
				'1000000' => {
					'one' => '0 млн',
					'other' => '0 млн',
				},
				'10000000' => {
					'one' => '00 млн',
					'other' => '00 млн',
				},
				'100000000' => {
					'one' => '000 млн',
					'other' => '000 млн',
				},
				'1000000000' => {
					'one' => '0 млрд',
					'other' => '0 млрд',
				},
				'10000000000' => {
					'one' => '00 млрд',
					'other' => '00 млрд',
				},
				'100000000000' => {
					'one' => '000 млрд',
					'other' => '000 млрд',
				},
				'1000000000000' => {
					'one' => '0 трлн',
					'other' => '0 трлн',
				},
				'10000000000000' => {
					'one' => '00 трлн',
					'other' => '00 трлн',
				},
				'100000000000000' => {
					'one' => '000 трлн',
					'other' => '000 трлн',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'' => '#,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'positive' => '#,##0.00 ¤',
					},
					'standard' => {
						'positive' => '#,##0.00 ¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(Біріккен Араб Әмірліктерінің дирхамы),
				'one' => q(БАӘ дирхамы),
				'other' => q(БАӘ дирхамы),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(Ауғанстан афганиі),
				'one' => q(Ауғанстан афганиі),
				'other' => q(Ауғанстан афганиі),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(Албания легі),
				'one' => q(Албания легі),
				'other' => q(Албания легі),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(Армения драмы),
				'one' => q(Армения драмы),
				'other' => q(Армения драмы),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(Нидерланд антиль гульдені),
				'one' => q(Нидерланд антиль гульдені),
				'other' => q(Нидерланд антиль гульдені),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(Ангола кванзасы),
				'one' => q(Ангола кванзасы),
				'other' => q(Ангола кванзасы),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(Аргентина песосы),
				'one' => q(Аргентина песосы),
				'other' => q(Аргентина песосы),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(Австралия доллары),
				'one' => q(Австралия доллары),
				'other' => q(Австралия доллары),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(Аруба флорині),
				'one' => q(Аруба флорині),
				'other' => q(Аруба флорині),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(Азербайджан манаты \(1993–2006\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(Әзірбайжан манаты),
				'one' => q(Әзірбайжан манаты),
				'other' => q(Әзірбайжан манаты),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(Босния және Герцеговина айырбасталмалы маркасы),
				'one' => q(Босния және Герцеговина айырбасталмалы маркасы),
				'other' => q(Босния және Герцеговина айырбасталмалы маркасы),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(Барбадос доллары),
				'one' => q(Барбадос доллары),
				'other' => q(Барбадос доллары),
			},
		},
		'BDT' => {
			symbol => 'BDT',
			display_name => {
				'currency' => q(Бангладеш такасы),
				'one' => q(Бангладеш такасы),
				'other' => q(Бангладеш такасы),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(Болгария леві),
				'one' => q(Болгария леві),
				'other' => q(Болгария леві),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(Бахрейн динары),
				'one' => q(Бахрейн динары),
				'other' => q(Бахрейн динары),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(Бурунди франкы),
				'one' => q(Бурунди франкы),
				'other' => q(Бурунди франкы),
			},
		},
		'BMD' => {
			symbol => 'БД',
			display_name => {
				'currency' => q(Бермуд доллары),
				'one' => q(Бермуд доллары),
				'other' => q(Бермуд доллары),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(Бруней доллары),
				'one' => q(Бруней доллары),
				'other' => q(Бруней доллары),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(Боливия боливианосы),
				'one' => q(Боливия боливианосы),
				'other' => q(Боливия боливианосы),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(Бразилия реалы),
				'one' => q(Бразилия реалы),
				'other' => q(Бразилия реалы),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(Багам доллары),
				'one' => q(Багам доллары),
				'other' => q(Багам доллары),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(Бутан нгултрумы),
				'one' => q(Бутан нгултрумы),
				'other' => q(Бутан нгултрумы),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(Ботсвана пуласы),
				'one' => q(Ботсвана пуласы),
				'other' => q(Ботсвана пуласы),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(Беларусь рублі),
				'one' => q(Беларусь рублі),
				'other' => q(Беларусь рублі),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(Белиз доллары),
				'one' => q(Белиз доллары),
				'other' => q(Белиз доллары),
			},
		},
		'CAD' => {
			symbol => 'КД$',
			display_name => {
				'currency' => q(Канада доллары),
				'one' => q(Канада доллары),
				'other' => q(Канада доллары),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(Конго франкы),
				'one' => q(Конго франкы),
				'other' => q(Конго франкы),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(Швейцария франкы),
				'one' => q(Швейцария франкы),
				'other' => q(Швейцария франкы),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(Чили песосы),
				'one' => q(Чили песосы),
				'other' => q(Чили песосы),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(Қытай юані),
				'one' => q(Қытай юані),
				'other' => q(Қытай юані),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(Колумбия песосы),
				'one' => q(Колумбия песосы),
				'other' => q(Колумбия песосы),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(Коста-Рика колоны),
				'one' => q(Коста-Рика колоны),
				'other' => q(Коста-Рика колоны),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(Куба айырбасталмалы песосы),
				'one' => q(Куба айырбасталмалы песосы),
				'other' => q(Куба айырбасталмалы песосы),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(Куба песосы),
				'one' => q(Куба песосы),
				'other' => q(Куба песосы),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(Кабо-Верде эскудосы),
				'one' => q(Кабо-Верде эскудосы),
				'other' => q(Кабо-Верде эскудосы),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(Чехия кронасы),
				'one' => q(Чехия кронасы),
				'other' => q(Чехия кронасы),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(Джибути франкы),
				'one' => q(Джибути франкы),
				'other' => q(Джибути франкы),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(Дат кроны),
				'one' => q(Дат кроны),
				'other' => q(Дат кроны),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(Доминикан песосы),
				'one' => q(Доминикан песосы),
				'other' => q(Доминикан песосы),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(Алжир динары),
				'one' => q(Алжир динары),
				'other' => q(Алжир динары),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(Мысыр фунты),
				'one' => q(Мысыр фунты),
				'other' => q(Мысыр фунты),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(Эритрея накфасы),
				'one' => q(Эритрея накфасы),
				'other' => q(Эритрея накфасы),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(Эфиопия быры),
				'one' => q(Эфиопия быры),
				'other' => q(Эфиопия быры),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(Еуро),
				'one' => q(еуро),
				'other' => q(еуро),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(Фиджи доллары),
				'one' => q(Фиджи доллары),
				'other' => q(Фиджи доллары),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(Фолкленд аралдарының фунты),
				'one' => q(Фолкленд аралдарының фунты),
				'other' => q(Фолкленд аралдарының фунты),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(Британия фунты),
				'one' => q(Британия фунты),
				'other' => q(Британия фунты),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(Грузия лариі),
				'one' => q(Грузия лариі),
				'other' => q(Грузия лариі),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(Гана седиі),
				'one' => q(Гана седиі),
				'other' => q(Гана седиі),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(Гибралтар фунты),
				'one' => q(Гибралтар фунты),
				'other' => q(Гибралтар фунты),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(Гамбия даласиі),
				'one' => q(Гамбия даласиі),
				'other' => q(Гамбия даласиі),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(Гвинея франкы),
				'one' => q(Гвинея франкы),
				'other' => q(Гвинея франкы),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(Гватемала кетсалі),
				'one' => q(Гватемала кетсалі),
				'other' => q(Гватемала кетсалі),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(Гайана доллары),
				'one' => q(Гайана доллары),
				'other' => q(Гайана доллары),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(Гонконг доллары),
				'one' => q(Гонконг доллары),
				'other' => q(Гонконг доллары),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(Гондурас лемпираcы),
				'one' => q(Гондурас лемпираcы),
				'other' => q(Гондурас лемпираcы),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(Хорватия кунасы),
				'one' => q(Хорватия кунасы),
				'other' => q(Хорватия кунасы),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(Гаити гурды),
				'one' => q(Гаити гурды),
				'other' => q(Гаити гурды),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(Венгрия форинты),
				'one' => q(Венгрия форинты),
				'other' => q(Венгрия форинты),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(Индонезия рупиясы),
				'one' => q(Индонезия рупиясы),
				'other' => q(Индонезия рупиясы),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(Израиль жаңа шекелі),
				'one' => q(Израиль жаңа шекелі),
				'other' => q(Израиль жаңа шекелі),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(Үндістан рупиясы),
				'one' => q(Үндістан рупиясы),
				'other' => q(Үндістан рупиясы),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(Ирак динары),
				'one' => q(Ирак динары),
				'other' => q(Ирак динары),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(Иран риалы),
				'one' => q(Иран риалы),
				'other' => q(Иран риалы),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(Исландия кронасы),
				'one' => q(Исландия кронасы),
				'other' => q(Исландия кронасы),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(Ямайка доллары),
				'one' => q(Ямайка доллары),
				'other' => q(Ямайка доллары),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(Иордания динары),
				'one' => q(Иордания динары),
				'other' => q(Иордания динары),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(Жапония иенасы),
				'one' => q(Жапония иенасы),
				'other' => q(Жапония иенасы),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(Кения шиллингі),
				'one' => q(Кения шиллингі),
				'other' => q(Кения шиллингі),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(Қырғызстан сомы),
				'one' => q(Қырғызстан сомы),
				'other' => q(Қырғызстан сомы),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(Камбоджа риелі),
				'one' => q(Камбоджа риелі),
				'other' => q(Камбоджа риелі),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(Комор аралдары франкы),
				'one' => q(Комор аралдары франкы),
				'other' => q(Комор аралдары франкы),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(Солтүстік Корея воны),
				'one' => q(Солтүстік Корея воны),
				'other' => q(Солтүстік Корея воны),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(Оңтүстік Корея воны),
				'one' => q(Оңтүстік Корея воны),
				'other' => q(Оңтүстік Корея воны),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(Кувейт динары),
				'one' => q(Кувейт динары),
				'other' => q(Кувейт динары),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(Кайман аралдары доллары),
				'one' => q(Кайман аралдары доллары),
				'other' => q(Кайман аралдары доллары),
			},
		},
		'KZT' => {
			symbol => '₸',
			display_name => {
				'currency' => q(Қазақстан теңгесі),
				'one' => q(Қазақстан теңгесі),
				'other' => q(Қазақстан теңгесі),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(Лаос кипі),
				'one' => q(Лаос кипі),
				'other' => q(Лаос кипі),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(Ливан фунты),
				'one' => q(Ливан фунты),
				'other' => q(Ливан фунты),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(Шри-Ланка рупиясы),
				'one' => q(Шри-Ланка рупиясы),
				'other' => q(Шри-Ланка рупиясы),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(Либерия доллары),
				'one' => q(Либерия доллары),
				'other' => q(Либерия доллары),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(Литва литы),
				'one' => q(Литва литы),
				'other' => q(Литва литы),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(Латвия латы),
				'one' => q(Латвия латы),
				'other' => q(Латвия латы),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(Ливия динары),
				'one' => q(Ливия динары),
				'other' => q(Ливия динары),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(Марокко дирхамы),
				'one' => q(Марокко дирхамы),
				'other' => q(Марокко дирхамы),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(Молдова лейі),
				'one' => q(Молдова лейі),
				'other' => q(Молдова лейі),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(Малагаси ариариы),
				'one' => q(Малагаси ариариы),
				'other' => q(Малагаси ариариы),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(Македония динары),
				'one' => q(Македония динары),
				'other' => q(Македония динары),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(Мьянма кьяты),
				'one' => q(Мьянма кьяты),
				'other' => q(Мьянма кьяты),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(Моңғолия тугригі),
				'one' => q(Моңғолия тугригі),
				'other' => q(Моңғолия тугригі),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(Макао патакасы),
				'one' => q(Макао патакасы),
				'other' => q(Макао патакасы),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(Мавритания угиясы),
				'one' => q(Мавритания угиясы),
				'other' => q(Мавритания угиясы),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(Маврикий рупиясы),
				'one' => q(Маврикий рупиясы),
				'other' => q(Маврикий рупиясы),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(Мальдив руфиясы),
				'one' => q(Мальдив руфиясы),
				'other' => q(Мальдив руфиясы),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(Малави квачасы),
				'one' => q(Малави квачасы),
				'other' => q(Малави квачасы),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(Мексика песосы),
				'one' => q(Мексика песосы),
				'other' => q(Мексика песосы),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(Малайзия ринггиті),
				'one' => q(Малайзия ринггиті),
				'other' => q(Малайзия ринггиті),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(Мозамбик метикалы),
				'one' => q(Мозамбик метикалы),
				'other' => q(Мозамбик метикалы),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(Намибия доллары),
				'one' => q(Намибия доллары),
				'other' => q(Намибия доллары),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(Нигерия найрасы),
				'one' => q(Нигерия найрасы),
				'other' => q(Нигерия найрасы),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(Никарагуа кордобасы),
				'one' => q(Никарагуа кордобасы),
				'other' => q(Никарагуа кордобасы),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(Норвегия кроны),
				'one' => q(Норвегия кроны),
				'other' => q(Норвегия кроны),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(Непал рупиясы),
				'one' => q(Непал рупиясы),
				'other' => q(Непал рупиясы),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(Жаңа Зеландия доллары),
				'one' => q(Жаңа Зеландия доллары),
				'other' => q(Жаңа Зеландия доллары),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(Оман риалы),
				'one' => q(Оман риалы),
				'other' => q(Оман риалы),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(Панама бальбоасы),
				'one' => q(Панама бальбоасы),
				'other' => q(Панама бальбоасы),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(Перу жаңа солі),
				'one' => q(Перу жаңа солі),
				'other' => q(Перу жаңа солі),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(Папуа - Жаңа Гвинея кинасы),
				'one' => q(Папуа - Жаңа Гвинея кинасы),
				'other' => q(Папуа - Жаңа Гвинея кинасы),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(Филиппин песосы),
				'one' => q(Филиппин песосы),
				'other' => q(Филиппин песосы),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(Пәкістан рупиясы),
				'one' => q(Пәкістан рупиясы),
				'other' => q(Пәкістан рупиясы),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(Польша злотасы),
				'one' => q(Польша злотасы),
				'other' => q(Польша злотасы),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(Парагвай гуараниі),
				'one' => q(Парагвай гуараниі),
				'other' => q(Парагвай гуараниі),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(Катар риалы),
				'one' => q(Катар риалы),
				'other' => q(Катар риалы),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(Румыния лейі),
				'one' => q(Румыния лейі),
				'other' => q(Румыния лейі),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(Сербия динары),
				'one' => q(Сербия динары),
				'other' => q(Сербия динары),
			},
		},
		'RUB' => {
			symbol => '₽',
			display_name => {
				'currency' => q(Ресей рублі),
				'one' => q(Ресей рублі),
				'other' => q(Ресей рублі),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(Руанда франкы),
				'one' => q(Руанда франкы),
				'other' => q(Руанда франкы),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(Сауд Арабиясының риалы),
				'one' => q(Сауд Арабиясының риалы),
				'other' => q(Сауд Арабиясының риалы),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(Соломон аралдары доллары),
				'one' => q(Соломон аралдары доллары),
				'other' => q(Соломон аралдары доллары),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(Сейшель рупиясы),
				'one' => q(Сейшель рупиясы),
				'other' => q(Сейшель рупиясы),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(Судан фунты),
				'one' => q(Судан фунты),
				'other' => q(Судан фунты),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(Швеция кроны),
				'one' => q(Швеция кроны),
				'other' => q(Швеция кроны),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(Сингапур доллары),
				'one' => q(Сингапур доллары),
				'other' => q(Сингапур доллары),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(Әулие Елена аралы фунты),
				'one' => q(Әулие Елена аралы фунты),
				'other' => q(Әулие Елена аралы фунты),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(Сьерра-Леоне леонесы),
				'one' => q(Сьерра-Леоне леонесы),
				'other' => q(Сьерра-Леоне леонесы),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(Сомали шиллингі),
				'one' => q(Сомали шиллингі),
				'other' => q(Сомали шиллингі),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(Суринам доллары),
				'one' => q(Суринам доллары),
				'other' => q(Суринам доллары),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(Оңтүстік Судан фунты),
				'one' => q(Оңтүстік Судан фунты),
				'other' => q(Оңтүстік Судан фунты),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(Сант-Томе мен Принсипи добрасы),
				'one' => q(Сант-Томе мен Принсипи добрасы),
				'other' => q(Сант-Томе мен Принсипи добрасы),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(Сирия фунты),
				'one' => q(Сирия фунты),
				'other' => q(Сирия фунты),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(Свазиленд лилангениі),
				'one' => q(Свазиленд лилангениі),
				'other' => q(Свазиленд лилангениі),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(Тай баты),
				'one' => q(Тай баты),
				'other' => q(Тай баты),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(Тәжікстан сомониі),
				'one' => q(Тәжікстан сомониі),
				'other' => q(Тәжікстан сомониі),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(Түрікменстан манаты),
				'one' => q(Түрікменстан манаты),
				'other' => q(Түрікменстан манаты),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(Тунис динары),
				'one' => q(Тунис динары),
				'other' => q(Тунис динары),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(Тонга паангасы),
				'one' => q(Тонга паангасы),
				'other' => q(Тонга паангасы),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(Түрік лирасы),
				'one' => q(Түрік лирасы),
				'other' => q(Түрік лирасы),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(Тринидад пен Тобаго доллары),
				'one' => q(Тринидад пен Тобаго доллары),
				'other' => q(Тринидад пен Тобаго доллары),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(Жаңа Тайван доллары),
				'one' => q(Жаңа Тайван доллары),
				'other' => q(Жаңа Тайван доллары),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(Танзания шиллингі),
				'one' => q(Танзания шиллингі),
				'other' => q(Танзания шиллингі),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(Украина гривнасы),
				'one' => q(Украина гривнасы),
				'other' => q(Украина гривнасы),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(Уганда шиллингі),
				'one' => q(Уганда шиллингі),
				'other' => q(Уганда шиллингі),
			},
		},
		'USD' => {
			symbol => '$',
			display_name => {
				'currency' => q(АҚШ доллары),
				'one' => q(АҚШ доллары),
				'other' => q(АҚШ доллары),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(Уругвай песосы),
				'one' => q(Уругвай песосы),
				'other' => q(Уругвай песосы),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(Өзбекстан сомы),
				'one' => q(Өзбекстан сомы),
				'other' => q(Өзбекстан сомы),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(Венесуэла боливары),
				'one' => q(Венесуэла боливары),
				'other' => q(Венесуэла боливары),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(Вьетнам донгы),
				'one' => q(Вьетнам донгы),
				'other' => q(Вьетнам донгы),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(Вануату ватуы),
				'one' => q(Вануату ватуы),
				'other' => q(Вануату ватуы),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(Самоа таласы),
				'one' => q(Самоа таласы),
				'other' => q(Самоа таласы),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(КФА ВЕАС франкы),
				'one' => q(КФА ВЕАС франкы),
				'other' => q(КФА ВЕАС франкы),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(Шығыс Кариб доллары),
				'one' => q(Шығыс Кариб доллары),
				'other' => q(Шығыс Кариб доллары),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(КФА ВСЕАО франкы),
				'one' => q(КФА ВСЕАО франкы),
				'other' => q(КФА ВСЕАО франкы),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(КФП франкы),
				'one' => q(КФП франкы),
				'other' => q(КФП франкы),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(Белгісіз валюта),
				'one' => q(\(белгісіз валюта бірлігі\)),
				'other' => q(\(белгісіз валюта\)),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(Йемен риалы),
				'one' => q(Йемен риалы),
				'other' => q(Йемен риалы),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(Оңтүстік Африка рэнді),
				'one' => q(Оңтүстік Африка рэнді),
				'other' => q(Оңтүстік Африка рэнді),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(Замбия квачасы),
				'one' => q(Замбия квачасы),
				'other' => q(Замбия квачасы),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'coptic' => {
				'format' => {
					narrow => {
						nonleap => [
							'1',
							'2',
							'3',
							'4',
							'5',
							'6',
							'7',
							'8',
							'9',
							'10',
							'11',
							'12',
							'13'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'қаң.',
							'ақп.',
							'нау.',
							'сәу.',
							'мам.',
							'мау.',
							'шіл.',
							'там.',
							'қыр.',
							'қаз.',
							'қар.',
							'жел.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Қ',
							'А',
							'Н',
							'С',
							'М',
							'М',
							'Ш',
							'Т',
							'Қ',
							'Қ',
							'Қ',
							'Ж'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'қаңтар',
							'ақпан',
							'наурыз',
							'сәуір',
							'мамыр',
							'маусым',
							'шілде',
							'тамыз',
							'қыркүйек',
							'қазан',
							'қараша',
							'желтоқсан'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'Қаң.',
							'Ақп.',
							'Нау.',
							'Сәу.',
							'Мам.',
							'Мау.',
							'Шіл.',
							'Там.',
							'Қыр.',
							'Қаз.',
							'Қар.',
							'Жел.'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'Қ',
							'А',
							'Н',
							'С',
							'М',
							'М',
							'Ш',
							'Т',
							'Қ',
							'Қ',
							'Қ',
							'Ж'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'Қаңтар',
							'Ақпан',
							'Наурыз',
							'Сәуір',
							'Мамыр',
							'Маусым',
							'Шілде',
							'Тамыз',
							'Қыркүйек',
							'Қазан',
							'Қараша',
							'Желтоқсан'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'Дс',
						tue => 'Сс',
						wed => 'Ср',
						thu => 'Бс',
						fri => 'Жм',
						sat => 'Сб',
						sun => 'Жс'
					},
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'С',
						thu => 'Б',
						fri => 'Ж',
						sat => 'С',
						sun => 'Ж'
					},
					short => {
						mon => 'Дс',
						tue => 'Сс',
						wed => 'Ср',
						thu => 'Бс',
						fri => 'Жм',
						sat => 'Сб',
						sun => 'Жс'
					},
					wide => {
						mon => 'дүйсенбі',
						tue => 'сейсенбі',
						wed => 'сәрсенбі',
						thu => 'бейсенбі',
						fri => 'жұма',
						sat => 'сенбі',
						sun => 'жексенбі'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => 'Дс',
						tue => 'Сс',
						wed => 'Ср',
						thu => 'Бс',
						fri => 'Жм',
						sat => 'Сб',
						sun => 'Жс'
					},
					narrow => {
						mon => 'Д',
						tue => 'С',
						wed => 'С',
						thu => 'Б',
						fri => 'Ж',
						sat => 'С',
						sun => 'Ж'
					},
					short => {
						mon => 'Дс',
						tue => 'Сс',
						wed => 'Ср',
						thu => 'Бс',
						fri => 'Жм',
						sat => 'Сб',
						sun => 'Жс'
					},
					wide => {
						mon => 'Дүйсенбі',
						tue => 'Сейсенбі',
						wed => 'Сәрсенбі',
						thu => 'Бейсенбі',
						fri => 'Жұма',
						sat => 'Сенбі',
						sun => 'Жексенбі'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'І ш.',
						1 => 'ІІ ш.',
						2 => 'ІІІ ш.',
						3 => 'IV ш.'
					},
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					wide => {0 => 'І ширек',
						1 => 'ІІ ширек',
						2 => 'ІІІ ширек',
						3 => 'IV ширек'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'І ш.',
						1 => 'ІІ ш.',
						2 => 'ІІІ ш.',
						3 => 'IV ш.'
					},
					narrow => {0 => 'I',
						1 => 'II',
						2 => 'III',
						3 => 'IV'
					},
					wide => {0 => 'І ширек',
						1 => 'ІІ ширек',
						2 => 'ІІІ ширек',
						3 => 'IV ширек'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
				}
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
				}
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'noon' if $time == 1200;
					return 'midnight' if $time == 0;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2100;
				}
				if($day_period_type eq 'selection') {
					return 'evening1' if $time >= 1800
						&& $time < 2100;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'night1' if $time >= 2100;
					return 'night1' if $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'wide' => {
					'noon' => q{түскі},
					'evening1' => q{кешкі},
					'am' => q{таңғы},
					'morning1' => q{таңғы},
					'pm' => q{түскі/кешкі},
					'afternoon1' => q{түстен кейінгі},
					'night1' => q{түнгі},
					'midnight' => q{түн жарымы},
				},
				'narrow' => {
					'am' => q{таңғы},
					'evening1' => q{кешкі},
					'noon' => q{түскі},
					'night1' => q{түнгі},
					'afternoon1' => q{түстен кейінгі},
					'pm' => q{түскі/кешкі},
					'morning1' => q{таңғы},
					'midnight' => q{түн жарымы},
				},
				'abbreviated' => {
					'midnight' => q{түн жарымы},
					'am' => q{таңғы},
					'noon' => q{түскі},
					'evening1' => q{кешкі},
					'night1' => q{түнгі},
					'morning1' => q{таңғы},
					'afternoon1' => q{түстен кейінгі},
					'pm' => q{түскі/кешкі},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'midnight' => q{түн жарымы},
					'noon' => q{талтүс},
					'evening1' => q{кеш},
					'am' => q{таң},
					'morning1' => q{таң},
					'pm' => q{түс/кеш},
					'afternoon1' => q{түстен кейін},
					'night1' => q{түн},
				},
				'narrow' => {
					'midnight' => q{түн жарымы},
					'noon' => q{талтүс},
					'evening1' => q{кеш},
					'am' => q{таң},
					'morning1' => q{таң},
					'pm' => q{түс/кеш},
					'afternoon1' => q{түстен кейін},
					'night1' => q{түн},
				},
				'wide' => {
					'midnight' => q{түн жарымы},
					'pm' => q{түс/кеш},
					'afternoon1' => q{түстен кейін},
					'morning1' => q{таң},
					'night1' => q{түн},
					'evening1' => q{кеш},
					'noon' => q{талтүс},
					'am' => q{таң},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'б.з.д.',
				'1' => 'б.з.'
			},
			wide => {
				'0' => 'Біздің заманымызға дейін',
				'1' => 'Біздің заманымыз'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
			'full' => q{G y 'ж'. d MMMM, EEEE},
			'long' => q{G y 'ж'. d MMMM},
			'medium' => q{G dd.MM.y},
			'short' => q{GGGGG dd.MM.y},
		},
		'gregorian' => {
			'full' => q{y 'ж'. d MMMM, EEEE},
			'long' => q{y 'ж'. d MMMM},
			'medium' => q{y 'ж'. dd MMM},
			'short' => q{dd.MM.yy},
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{HH:mm:ss zzzz},
			'long' => q{HH:mm:ss z},
			'medium' => q{HH:mm:ss},
			'short' => q{HH:mm},
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'coptic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d, E},
			Ehm => q{E, a h:mm},
			Ehms => q{E, a h:mm:ss},
			Gy => q{G y 'ж'.},
			GyMMM => q{G y 'ж'. MMM},
			GyMMMEd => q{G y 'ж'. d MMM, E},
			GyMMMd => q{G y 'ж'. d MMM},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{dd.MM, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			h => q{a h},
			hm => q{a h:mm},
			hms => q{a h:mm:ss},
			hmsv => q{a h:mm:ss v},
			hmv => q{a h:mm v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{MM.y},
			yMEd => q{dd.MM.y, E},
			yMMM => q{y 'ж'. MMM},
			yMMMEd => q{y 'ж'. d MMM, E},
			yMMMM => q{y 'ж'. MMMM},
			yMMMd => q{y 'ж'. d MMM},
			yMd => q{dd.MM.y},
			yQQQ => q{y 'ж'. QQQ},
			yQQQQ => q{y 'ж'. QQQQ},
		},
		'generic' => {
			E => q{ccc},
			Ed => q{d, E},
			Gy => q{G y 'ж'.},
			GyMMM => q{G y 'ж'. MMM},
			GyMMMEd => q{G y 'ж'. d MMM, E},
			GyMMMd => q{G y 'ж'. d MMM},
			M => q{L},
			MEd => q{dd.MM, E},
			MMM => q{LLL},
			MMMEd => q{d MMM, E},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			Md => q{dd.MM},
			d => q{d},
			y => q{G y 'ж'.},
			yyyy => q{G y 'ж'.},
			yyyyM => q{GGGGG MM.y},
			yyyyMEd => q{GGGGG dd.MM.y, E},
			yyyyMMM => q{G y 'ж'. MMM},
			yyyyMMMEd => q{G y 'ж'. d MMM, E},
			yyyyMMMM => q{G y 'ж'. MMMM},
			yyyyMMMd => q{G y 'ж'. d MMM},
			yyyyMd => q{GGGGG dd.MM.y},
			yyyyQQQ => q{G y 'ж'. QQQ},
			yyyyQQQQ => q{G y 'ж'. QQQQ},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{dd.MM, E – dd.MM, E},
				d => q{dd.MM, E – dd.MM, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d MMM, E – d MMM, E},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				a => q{a h – a h},
				h => q{a h–h},
			},
			hm => {
				a => q{a h:mm – a h:mm},
				h => q{a h:mm–h:mm},
				m => q{a h:mm–h:mm},
			},
			hmv => {
				a => q{a h:mm – a h:mm v},
				h => q{a h:mm – h:mm v},
				m => q{a h:mm – h:mm v},
			},
			hv => {
				a => q{a h – a h v},
				h => q{a h – h v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{MM.y – MM.y},
				y => q{MM.y – MM.y},
			},
			yMEd => {
				M => q{dd.MM.y, E – dd.MM.y, E},
				d => q{dd.MM.y, E – dd.MM.y, E},
				y => q{dd.MM.y, E – dd.MM.y, E},
			},
			yMMM => {
				M => q{y 'ж'. MMM–MMM},
				y => q{y 'ж'. MMM – y 'ж'. MMM},
			},
			yMMMEd => {
				M => q{y 'ж'. d MMM, E – d MMM, E},
				d => q{y 'ж'. d MMM, E – y 'ж'. d MMM, E},
				y => q{y 'ж'. d MMM, E – y 'ж'. d MMM, E},
			},
			yMMMM => {
				M => q{y 'ж'. MMMM – MMMM},
				y => q{y 'ж'. MMMM – y 'ж'. MMMM},
			},
			yMMMd => {
				M => q{y 'ж'. d MMM – d MMM},
				d => q{y 'ж'. d–d MMM},
				y => q{y 'ж'. d MMM – y 'ж'. d MMM},
			},
			yMd => {
				M => q{dd.MM.y – dd.MM.y},
				d => q{dd.MM.y – dd.MM.y},
				y => q{dd.MM.y – dd.MM.y},
			},
		},
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{dd.MM, E – dd.MM, E},
				d => q{dd.MM, E – dd.MM, E},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{d MMM, E – d MMM, E},
				d => q{d (E) – d (E) MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{dd.MM – dd.MM},
				d => q{dd.MM – dd.MM},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} - {1}',
			h => {
				h => q{h–h a},
			},
			hm => {
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				h => q{h–h a v},
			},
			y => {
				y => q{G y–y 'жж'.},
			},
			yM => {
				M => q{GGGGG MM.y – MM.y},
				y => q{GGGGG MM.y – MM.y},
			},
			yMEd => {
				M => q{GGGGG dd.MM.y, E – dd.MM.y, E},
				d => q{GGGGG dd.MM.y, E – dd.MM.y, E},
				y => q{GGGGG dd.MM.y, E – dd.MM.y, E},
			},
			yMMM => {
				M => q{G y 'ж'. MMM–MMM},
				y => q{G y 'ж'. MMM – y 'ж'. MMM},
			},
			yMMMEd => {
				M => q{G y 'ж'. d MMM, E – d MMM, E},
				d => q{G y 'ж'. d MMM, E – d MMM, E},
				y => q{G y 'ж'. d MMM, E – y 'ж'. d MMM, E},
			},
			yMMMM => {
				M => q{G y 'ж'. MMMM – MMMM},
				y => q{G y 'ж'. MMMM – y 'ж'. MMMM},
			},
			yMMMd => {
				M => q{G y 'ж'. d MMM – d MMM},
				d => q{G y 'ж'. d–d MMM},
				y => q{G y 'ж'. d MMM – y 'ж'. d MMM},
			},
			yMd => {
				M => q{GGGGG dd.MM.y – dd.MM.y},
				d => q{GGGGG dd.MM.y – dd.MM.y},
				y => q{GGGGG dd.MM.y – dd.MM.y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT{0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} уақыты),
		regionFormat => q({0} жазғы уақыты),
		regionFormat => q({0} стандартты уақыты),
		fallbackFormat => q({1} ({0})),
		'Afghanistan' => {
			long => {
				'standard' => q(Ауғанстан уақыты),
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#Абиджан#,
		},
		'Africa/Accra' => {
			exemplarCity => q#Аккра#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#Аддис-Абеба#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#Алжир#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#Асмара#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#Бамако#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#Банги#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#Банжул#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#Бисау#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#Блантайр#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#Браззавиль#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#Бужумбура#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#Каир#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#Касабланка#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#Сеута#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#Конакри#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#Дакар#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#Дар-эс-Салам#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#Джибути#,
		},
		'Africa/Douala' => {
			exemplarCity => q#Дуала#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#Эль-Аюн#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#Фритаун#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#Габороне#,
		},
		'Africa/Harare' => {
			exemplarCity => q#Хараре#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#Йоханнесбург#,
		},
		'Africa/Juba' => {
			exemplarCity => q#Джуба#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#Кампала#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#Хартум#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#Кигали#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#Киншаса#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#Лагос#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#Либревиль#,
		},
		'Africa/Lome' => {
			exemplarCity => q#Ломе#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#Луанда#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#Лубумбаши#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#Лусака#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#Малабо#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#Мапуту#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#Масеру#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#Мбабане#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#Могадишо#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#Монровия#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#Найроби#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#Нджамена#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#Ниамей#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#Нуакшот#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#Уагадугу#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#Порто-Ново#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#Сан-Томе#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#Триполи#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#Тунис#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#Виндхук#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q(Орталық Африка уақыты),
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q(Шығыс Африка уақыты),
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q(Оңтүстік Африка уақыты),
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q(Батыс Африка жазғы уақыты),
				'generic' => q(Батыс Африка уақыты),
				'standard' => q(Батыс Африка стандартты уақыты),
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q(Аляска жазғы уақыты),
				'generic' => q(Аляска уақыты),
				'standard' => q(Аляска стандартты уақыты),
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q(Амазон жазғы уақыты),
				'generic' => q(Амазон уақыты),
				'standard' => q(Амазон стандартты уақыты),
			},
		},
		'America/Adak' => {
			exemplarCity => q#Адак#,
		},
		'America/Anchorage' => {
			exemplarCity => q#Анкоридж#,
		},
		'America/Anguilla' => {
			exemplarCity => q#Ангилья#,
		},
		'America/Antigua' => {
			exemplarCity => q#Антигуа#,
		},
		'America/Araguaina' => {
			exemplarCity => q#Арагуаина#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#Ла-Риоха#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#Рио-Гальегос#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#Сальта#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#Сан-Хуан#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#Сан-Луис#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#Тукуман#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#Ушуайя#,
		},
		'America/Aruba' => {
			exemplarCity => q#Аруба#,
		},
		'America/Asuncion' => {
			exemplarCity => q#Асунсьон#,
		},
		'America/Bahia' => {
			exemplarCity => q#Баия#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#Баия-де-Бандерас#,
		},
		'America/Barbados' => {
			exemplarCity => q#Барбадос#,
		},
		'America/Belem' => {
			exemplarCity => q#Белем#,
		},
		'America/Belize' => {
			exemplarCity => q#Белиз#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#Бланк-Саблон#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#Бао-Виста#,
		},
		'America/Bogota' => {
			exemplarCity => q#Богота#,
		},
		'America/Boise' => {
			exemplarCity => q#Бойсе#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#Буэнос-Айрес#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#Кембридж-Бей#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#Кампу-Гранди#,
		},
		'America/Cancun' => {
			exemplarCity => q#Канкун#,
		},
		'America/Caracas' => {
			exemplarCity => q#Каракас#,
		},
		'America/Catamarca' => {
			exemplarCity => q#Катамарка#,
		},
		'America/Cayenne' => {
			exemplarCity => q#Кайенна#,
		},
		'America/Cayman' => {
			exemplarCity => q#Кайман аралдары#,
		},
		'America/Chicago' => {
			exemplarCity => q#Чикаго#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#Чиуауа#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#Корал-Харбор#,
		},
		'America/Cordoba' => {
			exemplarCity => q#Кордоба#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#Коста-Рика#,
		},
		'America/Creston' => {
			exemplarCity => q#Крестон#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#Куяба#,
		},
		'America/Curacao' => {
			exemplarCity => q#Курасао#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#Данмарксхавн#,
		},
		'America/Dawson' => {
			exemplarCity => q#Доусон#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#Досон-Крик#,
		},
		'America/Denver' => {
			exemplarCity => q#Денвер#,
		},
		'America/Detroit' => {
			exemplarCity => q#Детройт#,
		},
		'America/Dominica' => {
			exemplarCity => q#Доминика#,
		},
		'America/Edmonton' => {
			exemplarCity => q#Эдмонтон#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#Эйрунепе#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#Сальвадор#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#Форталеза#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#Глейс-Бей#,
		},
		'America/Godthab' => {
			exemplarCity => q#Нуук#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#Гус-Бей#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#Гранд-Тёрк#,
		},
		'America/Grenada' => {
			exemplarCity => q#Гренада#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#Гваделупа#,
		},
		'America/Guatemala' => {
			exemplarCity => q#Гватемала#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#Гуаякиль#,
		},
		'America/Guyana' => {
			exemplarCity => q#Гайана#,
		},
		'America/Halifax' => {
			exemplarCity => q#Галифакс#,
		},
		'America/Havana' => {
			exemplarCity => q#Гавана#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#Эрмосильо#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#Нокс, Индиана#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#Маренго, Индиана#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#Питерсберг, Индиана#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#Телл-Сити, Индиана#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#Вивей, Индиана#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#Винсенс, Индиана#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#Винамак, Индиана#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#Индианаполис#,
		},
		'America/Inuvik' => {
			exemplarCity => q#Инувик#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#Икалуит#,
		},
		'America/Jamaica' => {
			exemplarCity => q#Ямайка#,
		},
		'America/Jujuy' => {
			exemplarCity => q#Жужуй#,
		},
		'America/Juneau' => {
			exemplarCity => q#Джуно#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#Монтичелло, Кентуки#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#Кралендейк#,
		},
		'America/La_Paz' => {
			exemplarCity => q#Ла-Пас#,
		},
		'America/Lima' => {
			exemplarCity => q#Лима#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#Лос-Анжелес#,
		},
		'America/Louisville' => {
			exemplarCity => q#Луисвилл#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#Лоуэр-Принсес-Куортер#,
		},
		'America/Maceio' => {
			exemplarCity => q#Масейо#,
		},
		'America/Managua' => {
			exemplarCity => q#Манагуа#,
		},
		'America/Manaus' => {
			exemplarCity => q#Манаус#,
		},
		'America/Marigot' => {
			exemplarCity => q#Мариго#,
		},
		'America/Martinique' => {
			exemplarCity => q#Мартиника#,
		},
		'America/Matamoros' => {
			exemplarCity => q#Матаморос#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#Масатлан#,
		},
		'America/Mendoza' => {
			exemplarCity => q#Мендоса#,
		},
		'America/Menominee' => {
			exemplarCity => q#Меномини#,
		},
		'America/Merida' => {
			exemplarCity => q#Мерида#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#Метлакатла#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#Мехико#,
		},
		'America/Miquelon' => {
			exemplarCity => q#Микелон#,
		},
		'America/Moncton' => {
			exemplarCity => q#Монктон#,
		},
		'America/Monterrey' => {
			exemplarCity => q#Монтеррей#,
		},
		'America/Montevideo' => {
			exemplarCity => q#Монтевидео#,
		},
		'America/Montserrat' => {
			exemplarCity => q#Монтсеррат#,
		},
		'America/Nassau' => {
			exemplarCity => q#Нассау#,
		},
		'America/New_York' => {
			exemplarCity => q#Нью-Йорк#,
		},
		'America/Nipigon' => {
			exemplarCity => q#Нипигон#,
		},
		'America/Nome' => {
			exemplarCity => q#Ном#,
		},
		'America/Noronha' => {
			exemplarCity => q#Норонха#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#Бьюла, Солтүстік Дакота#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#Сентер, Солтүстік Дакота#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#Нью-Салем, Солтүстік Дакота#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#Охинага#,
		},
		'America/Panama' => {
			exemplarCity => q#Панама#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#Пангниртанг#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#Парамарибо#,
		},
		'America/Phoenix' => {
			exemplarCity => q#Финикс#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#Порт-о-Пренс#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#Порт-оф-Спейн#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#Порту-Велью#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#Пуэрто-Рико#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#Рейни-Ривер#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#Ранкин-Инлет#,
		},
		'America/Recife' => {
			exemplarCity => q#Ресифи#,
		},
		'America/Regina' => {
			exemplarCity => q#Регина#,
		},
		'America/Resolute' => {
			exemplarCity => q#Резолют#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#Риу-Бранку#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#Санта-Изабел#,
		},
		'America/Santarem' => {
			exemplarCity => q#Сантарем#,
		},
		'America/Santiago' => {
			exemplarCity => q#Сантьяго#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#Санто-Доминго#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#Сан-Паулу#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#Скорсбиссун#,
		},
		'America/Sitka' => {
			exemplarCity => q#Ситка#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#Сен-Бартелеми#,
		},
		'America/St_Johns' => {
			exemplarCity => q#Сент-Джонс#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#Сент-Китс#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#Сент-Люсия#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#Сент-Томас#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#Сент-Винсент#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#Свифт-Керрент#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#Тегусигальпа#,
		},
		'America/Thule' => {
			exemplarCity => q#Туле#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#Тандер-Бей#,
		},
		'America/Tijuana' => {
			exemplarCity => q#Тихуана#,
		},
		'America/Toronto' => {
			exemplarCity => q#Торонто#,
		},
		'America/Tortola' => {
			exemplarCity => q#Тортола#,
		},
		'America/Vancouver' => {
			exemplarCity => q#Ванкувер#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#Уайтхорс#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#Виннипег#,
		},
		'America/Yakutat' => {
			exemplarCity => q#Якутат#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#Йеллоунайф#,
		},
		'America_Central' => {
			long => {
				'daylight' => q(Солтүстік Америка жазғы орталық уақыты),
				'generic' => q(Солтүстік Америка орталық уақыты),
				'standard' => q(Солтүстік Америка стандартты орталық уақыты),
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q(Солтүстік Америка жазғы шығыс уақыты),
				'generic' => q(Солтүстік Америка шығыс уақыты),
				'standard' => q(Солтүстік Америка стандартты шығыс уақыты),
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q(Солтүстік Америка жазғы тау уақыты),
				'generic' => q(Солтүстік Америка тау уақыты),
				'standard' => q(Солтүстік Америка стандартты тау уақыты),
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q(Солтүстік Америка жазғы Тынық мұхиты уақыты),
				'generic' => q(Солтүстік Америка Тынық мұхиты уақыты),
				'standard' => q(Солтүстік Америка стандартты Тынық мұхиты уақыты),
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#Кейси#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#Дэйвис#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#Дюмон-д’Юрвиль#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#Маккуори#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#Моусон#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#Мак-Мердо#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#Палмер#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#Ротера#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#Сёва#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#Тролл#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#Восток#,
		},
		'Apia' => {
			long => {
				'daylight' => q(Апиа жазғы уақыты),
				'generic' => q(Апиа уақыты),
				'standard' => q(Апиа стандартты уақыты),
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q(Сауд Арабиясы жазғы уақыты),
				'generic' => q(Сауд Арабиясы уақыты),
				'standard' => q(Сауд Арабиясы стандартты уақыты),
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#Лонгйир#,
		},
		'Argentina' => {
			long => {
				'daylight' => q(Аргентина жазғы уақыты),
				'generic' => q(Аргентина уақыты),
				'standard' => q(Аргентина стандартты уақыты),
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q(Батыс Аргентина жазғы уақыты),
				'generic' => q(Батыс Аргентина уақыты),
				'standard' => q(Батыс Аргентина стандартты уақыты),
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q(Армения жазғы уақыты),
				'generic' => q(Армения уақыты),
				'standard' => q(Армения стандартты уақыты),
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#Аден#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#Алматы#,
		},
		'Asia/Amman' => {
			exemplarCity => q#Амман#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#Анадыр#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#Ақтау#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#Ақтөбе#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#Ашхабад#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#Бағдат#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#Бахрейн#,
		},
		'Asia/Baku' => {
			exemplarCity => q#Баку#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#Бангкок#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#Бейрут#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#Бішкек#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#Бруней#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#Калькутта#,
		},
		'Asia/Chita' => {
			exemplarCity => q#Чита#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#Чойбалсан#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#Коломбо#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#Дамаск#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#Дакка#,
		},
		'Asia/Dili' => {
			exemplarCity => q#Дили#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#Дубай#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#Душанбе#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#Газа#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#Хеврон#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#Гонконг#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#Ховд#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#Иркутск#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#Джакарта#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#Джаяпура#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#Иерусалим#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#Кабул#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#Камчатка#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#Карачи#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#Катманду#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#Хандыга#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#Красноярск#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#Куала-Лумпур#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#Кучинг#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#Кувейт#,
		},
		'Asia/Macau' => {
			exemplarCity => q#Макао#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#Магадан#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#Макассар#,
		},
		'Asia/Manila' => {
			exemplarCity => q#Манила#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#Маскат#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#Никосия#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#Новокузнецк#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#Новосібір#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#Омбы#,
		},
		'Asia/Oral' => {
			exemplarCity => q#Орал#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#Пномпен#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#Понтианак#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#Пхеньян#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#Катар#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#Қызылорда#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#Рангун#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#Эр-Рияд#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#Хошимин#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#Сахалин#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#Самарқанд#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#Сеул#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#Шанхай#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#Сингапур#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#Среднеколымск#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#Тайбэй#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#Ташкент#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#Тбилиси#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#Тегеран#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#Тхимпху#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#Токио#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#Улан-Батор#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#Үрімші#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#Усть-Нера#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#Вьентьян#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#Владивосток#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#Якутск#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#Екатеринбург#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#Ереван#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q(Атлантика жазғы уақыты),
				'generic' => q(Атлантика уақыты),
				'standard' => q(Атлантика стандартты уақыты),
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#Азор аралдары#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#Бермуд аралдары#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#Канар аралдары#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#Кабо-Верде#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#Фарер аралдары#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#Мадейра#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#Рейкьявик#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#Оңтүстік Георгия#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#Әулие Елена аралы#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#Стенли#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#Аделаида#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#Брисбен#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#Брокен-Хилл#,
		},
		'Australia/Currie' => {
			exemplarCity => q#Керри#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#Дарвин#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#Юкла#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#Хобарт#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#Линдеман#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#Лорд-Хау аралы#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#Мельбурн#,
		},
		'Australia/Perth' => {
			exemplarCity => q#Перт#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#Сидней#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q(Австралия жазғы орталық уақыты),
				'generic' => q(Орталық Австралия уақыты),
				'standard' => q(Австралия стандартты орталық уақыты),
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q(Австралия жазғы орталық-батыс уақыты),
				'generic' => q(Австралия орталық-батыс уақыты),
				'standard' => q(Австралия стандартты орталық-батыс уақыты),
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q(Австралия жазғы шығыс уақыты),
				'generic' => q(Австралия шығыс уақыты),
				'standard' => q(Австралия стандартты шығыс уақыты),
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q(Австралия жазғы батыс уақыты),
				'generic' => q(Австралия батыс уақыты),
				'standard' => q(Австралия стандартты батыс уақыты),
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q(Әзірбайжан жазғы уақыты),
				'generic' => q(Әзірбайжан уақыты),
				'standard' => q(Әзірбайжан стандартты уақыты),
			},
		},
		'Azores' => {
			long => {
				'daylight' => q(Азор аралдары жазғы уақыты),
				'generic' => q(Азор аралдары уақыты),
				'standard' => q(Азор аралдары стандартты уақыты),
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q(Бангладеш жазғы уақыты),
				'generic' => q(Бангладеш уақыты),
				'standard' => q(Бангладеш стандартты уақыты),
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q(Бутан уақыты),
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q(Боливия уақыты),
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q(Бразилия жазғы уақыты),
				'generic' => q(Бразилия уақыты),
				'standard' => q(Бразилия стандартты уақыты),
			},
		},
		'Brunei' => {
			long => {
				'standard' => q(Бруней-Даруссалам уақыты),
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q(Кабо-Верде жазғы уақыты),
				'generic' => q(Кабо-Верде уақыты),
				'standard' => q(Кабо-Верде стандартты уақыты),
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q(Чаморро стандартты уақыты),
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q(Чатем жазғы уақыты),
				'generic' => q(Чатем уақыты),
				'standard' => q(Чатем стандартты уақыты),
			},
		},
		'Chile' => {
			long => {
				'daylight' => q(Чили жазғы уақыты),
				'generic' => q(Чили уақыты),
				'standard' => q(Чили стандартты уақыты),
			},
		},
		'China' => {
			long => {
				'daylight' => q(Қытай жазғы уақыты),
				'generic' => q(Қытай уақыты),
				'standard' => q(Қытай стандартты уақыты),
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q(Чойбалсан жазғы уақыты),
				'generic' => q(Чойбалсан уақыты),
				'standard' => q(Чойбалсан стандартты уақыты),
			},
		},
		'Christmas' => {
			long => {
				'standard' => q(Кристмас аралы уақыты),
			},
		},
		'Cocos' => {
			long => {
				'standard' => q(Кокос аралдары уақыты),
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q(Колумбия жазғы уақыты),
				'generic' => q(Колумбия уақыты),
				'standard' => q(Колумбия стандартты уақыты),
			},
		},
		'Cook' => {
			long => {
				'daylight' => q(Кук аралдары жартылай жазғы уақыты),
				'generic' => q(Кук аралдары уақыты),
				'standard' => q(Кук аралдары стандартты уақыты),
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q(Куба жазғы уақыты),
				'generic' => q(Куба уақыты),
				'standard' => q(Куба стандартты уақыты),
			},
		},
		'Davis' => {
			long => {
				'standard' => q(Дейвис уақыты),
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q(Дюмон-д’Юрвиль уақыты),
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q(Шығыс Тимор уақыты),
			},
		},
		'Easter' => {
			long => {
				'daylight' => q(Пасха аралы жазғы уақыты),
				'generic' => q(Пасха аралы уақыты),
				'standard' => q(Пасха аралы стандартты уақыты),
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q(Эквадор уақыты),
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#Белгісіз қала#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#Амстердам#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#Андорра#,
		},
		'Europe/Athens' => {
			exemplarCity => q#Афина#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#Белград#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#Берлин#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#Братислава#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#Брюссель#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#Бухарест#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#Будапешт#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#Бюзинген#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#Кишинев#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#Копенгаген#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#Дублин#,
			long => {
				'daylight' => q(Ирландия жазғы уақыты),
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#Гибралтар#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#Гернси#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#Хелсинки#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#Мэн аралы#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#Ыстамбұл#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#Джерси#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#Калининград#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#Киев#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#Лиссабон#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#Любляна#,
		},
		'Europe/London' => {
			exemplarCity => q#Лондон#,
			long => {
				'daylight' => q(Ұлыбритания жазғы уақыты),
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#Люксембург#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#Мадрид#,
		},
		'Europe/Malta' => {
			exemplarCity => q#Мальта#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#Мариехамн#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#Минск#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#Монако#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#Мәскеу#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#Осло#,
		},
		'Europe/Paris' => {
			exemplarCity => q#Париж#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#Подгорица#,
		},
		'Europe/Prague' => {
			exemplarCity => q#Прага#,
		},
		'Europe/Riga' => {
			exemplarCity => q#Рига#,
		},
		'Europe/Rome' => {
			exemplarCity => q#Рим#,
		},
		'Europe/Samara' => {
			exemplarCity => q#Самара#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#Сан-Марино#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#Сараево#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#Симферополь#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#Скопье#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#София#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#Стокгольм#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#Таллин#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#Тирана#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#Ужгород#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#Вадуц#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#Ватикан#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#Вена#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#Вильнус#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#Волгоград#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#Варшава#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#Загреб#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#Запорожье#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#Цюрих#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q(Орталық Еуропа жазғы уақыты),
				'generic' => q(Орталық Еуропа уақыты),
				'standard' => q(Орталық Еуропа стандартты уақыты),
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q(Шығыс Еуропа жазғы уақыты),
				'generic' => q(Шығыс Еуропа уақыты),
				'standard' => q(Шығыс Еуропа стандартты уақыты),
			},
			short => {
				'daylight' => q(EEST),
				'generic' => q(EET),
				'standard' => q(EET),
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q(Қиыр Шығыс Еуропа уақыты),
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q(Батыс Еуропа жазғы уақыты),
				'generic' => q(Батыс Еуропа уақыты),
				'standard' => q(Батыс Еуропа стандартты уақыты),
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q(Фолкленд аралдары жазғы уақыты),
				'generic' => q(Фолкленд аралдары уақыты),
				'standard' => q(Фолкленд аралдары стандартты уақыты),
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q(Фиджи жазғы уақыты),
				'generic' => q(Фиджи уақыты),
				'standard' => q(Фиджи стандартты уақыты),
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q(Француз Гвианасы уақыты),
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q(Францияның оңтүстік аймағы және Антарктика уақыты),
			},
		},
		'GMT' => {
			long => {
				'standard' => q(Гринвич уақыты),
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q(Галапагос уақыты),
			},
		},
		'Gambier' => {
			long => {
				'standard' => q(Гамбье уақыты),
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q(Грузия жазғы уақыты),
				'generic' => q(Грузия уақыты),
				'standard' => q(Грузия стандартты уақыты),
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q(Гилберт аралдары уақыты),
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q(Шығыс Гренландия жазғы уақыты),
				'generic' => q(Шығыс Гренландия уақыты),
				'standard' => q(Шығыс Гренландия стандартты уақыты),
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q(Батыс Гренландия жазғы уақыты),
				'generic' => q(Батыс Гренландия уақыты),
				'standard' => q(Батыс Гренландия стандартты уақыты),
			},
		},
		'Gulf' => {
			long => {
				'standard' => q(Парсы шығанағы уақыты),
			},
		},
		'Guyana' => {
			long => {
				'standard' => q(Гайана уақыты),
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q(Гавай және Алеут аралдары жазғы уақыты),
				'generic' => q(Гавай және Алеут аралдары уақыты),
				'standard' => q(Гавай және Алеут аралдары стандартты уақыты),
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q(Гонконг жазғы уақыты),
				'generic' => q(Гонконг уақыты),
				'standard' => q(Гонконг стандартты уақыты),
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q(Ховд жазғы уақыты),
				'generic' => q(Ховд уақыты),
				'standard' => q(Ховд стандартты уақыты),
			},
		},
		'India' => {
			long => {
				'standard' => q(Үндістан стандартты уақыты),
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#Антананариву#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#Чагос#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#Кристмас#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#Кокос аралдары#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#Коморо#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#Кергелен#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#Маэ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#Мальдив#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#Маврикий#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#Майотта#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#Реюньон#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q(Үнді мұхиты уақыты),
			},
		},
		'Indochina' => {
			long => {
				'standard' => q(Үндіқытай уақыты),
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q(Орталық Индонезия уақыты),
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q(Шығыс Индонезия уақыты),
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q(Батыс Индонезия уақыты),
			},
		},
		'Iran' => {
			long => {
				'daylight' => q(Иран жазғы уақыты),
				'generic' => q(Иран уақыты),
				'standard' => q(Иран стандартты уақыты),
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q(Иркутск жазғы уақыты),
				'generic' => q(Иркутск уақыты),
				'standard' => q(Иркутск стандартты уақыты),
			},
		},
		'Israel' => {
			long => {
				'daylight' => q(Израиль жазғы уақыты),
				'generic' => q(Израиль уақыты),
				'standard' => q(Израиль стандартты уақыты),
			},
		},
		'Japan' => {
			long => {
				'daylight' => q(Жапония жазғы уақыты),
				'generic' => q(Жапония уақыты),
				'standard' => q(Жапония стандартты уақыты),
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q(Шығыс Қазақстан уақыты),
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q(Батыс Қазақстан уақыты),
			},
		},
		'Korea' => {
			long => {
				'daylight' => q(Корея жазғы уақыты),
				'generic' => q(Корея уақыты),
				'standard' => q(Корея стандартты уақыты),
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q(Косраэ уақыты),
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q(Красноярск жазғы уақыты),
				'generic' => q(Красноярск уақыты),
				'standard' => q(Красноярск стандартты уақыты),
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q(Қырғызстан уақыты),
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q(Лайн аралдары уақыты),
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q(Лорд-Хау жазғы уақыты),
				'generic' => q(Лорд-Хау уақыты),
				'standard' => q(Лорд-Хау стандартты уақыты),
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q(Маккуори аралы уақыты),
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q(Магадан жазғы уақыты),
				'generic' => q(Магадан уақыты),
				'standard' => q(Магадан стандартты уақыты),
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q(Малайзия уақыты),
			},
		},
		'Maldives' => {
			long => {
				'standard' => q(Мальдив уақыты),
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q(Маркиз аралдары уақыты),
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q(Маршалл аралдары уақыты),
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q(Маврикий жазғы уақыты),
				'generic' => q(Маврикий уақыты),
				'standard' => q(Маврикий стандартты уақыты),
			},
		},
		'Mawson' => {
			long => {
				'standard' => q(Моусон уақыты),
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q(Солтүстік Мексика жазғы уақыты),
				'generic' => q(Солтүстік Мексика уақыты),
				'standard' => q(Солтүстік Мексика стандартты уақыты),
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q(Мексика жазғы Тынық мұхит уақыты),
				'generic' => q(Мексика Тынық мұхит уақыты),
				'standard' => q(Мексика стандартты Тынық мұхит уақыты),
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q(Улан-Батор жазғы уақыты),
				'generic' => q(Улан-Батор уақыты),
				'standard' => q(Улан-Батор стандартты уақыты),
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q(Мәскеу жазғы уақыты),
				'generic' => q(Мәскеу уақыты),
				'standard' => q(Мәскеу стандартты уақыты),
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q(Мьянма уақыты),
			},
		},
		'Nauru' => {
			long => {
				'standard' => q(Науру уақыты),
			},
		},
		'Nepal' => {
			long => {
				'standard' => q(Непал уақыты),
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q(Жаңа Каледония жазғы уақыты),
				'generic' => q(Жаңа Каледония уақыты),
				'standard' => q(Жаңа Каледония стандартты уақыты),
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q(Жаңа Зеландия жазғы уақыты),
				'generic' => q(Жаңа Зеландия уақыты),
				'standard' => q(Жаңа Зеландия стандартты уақыты),
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q(Ньюфаундленд жазғы уақыты),
				'generic' => q(Ньюфаундленд уақыты),
				'standard' => q(Ньюфаундленд стандартты уақыты),
			},
		},
		'Niue' => {
			long => {
				'standard' => q(Ниуэ уақыты),
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q(Норфолк аралы уақыты),
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q(Фернанду-ди-Норонья жазғы уақыты),
				'generic' => q(Фернанду-ди-Норонья уақыты),
				'standard' => q(Фернанду-ди-Норонья стандартты уақыты),
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q(Новосібір жазғы уақыты),
				'generic' => q(Новосібір уақыты),
				'standard' => q(Новосібір стандартты уақыты),
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q(Омбы жазғы уақыты),
				'generic' => q(Омбы уақыты),
				'standard' => q(Омбы стандартты уақыты),
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#Апиа#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#Окленд#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#Бугенвиль#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#Чатем#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#Пасха аралы#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#Эфате#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#Эндербери#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#Факаофо#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#Фиджи#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#Фунафути#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#Галапагос#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#Гамбье#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#Гвадалканал#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#Гуам#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#Гонолулу#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#Джонстон#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#Киритимати#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#Косраэ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#Кваджалейн#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#Маджуро#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#Маркиз#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#Мидуэй#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#Науру#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#Ниуэ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#Норфолк#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#Нумеа#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#Паго-Паго#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#Палау#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#Питкерн#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#Понапе#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#Порт-Морсби#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#Раротонга#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#Сайпан#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#Таити#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#Тарава#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#Тонгатапу#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#Чуук#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#Уэйк#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#Уоллис#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q(Пәкістан жазғы уақыты),
				'generic' => q(Пәкістан уақыты),
				'standard' => q(Пәкістан стандартты уақыты),
			},
		},
		'Palau' => {
			long => {
				'standard' => q(Палау уақыты),
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q(Папуа – Жаңа Гвинея уақыты),
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q(Парагвай жазғы уақыты),
				'generic' => q(Парагвай уақыты),
				'standard' => q(Парагвай стандартты уақыты),
			},
		},
		'Peru' => {
			long => {
				'daylight' => q(Перу жазғы уақыты),
				'generic' => q(Перу уақыты),
				'standard' => q(Перу стандартты уақыты),
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q(Филиппин жазғы уақыты),
				'generic' => q(Филиппин уақыты),
				'standard' => q(Филиппин стандартты уақыты),
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q(Феникс аралдары уақыты),
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q(Сен-Пьер және Микелон жазғы уақыты),
				'generic' => q(Сен-Пьер және Микелон уақыты),
				'standard' => q(Сен-Пьер және Микелон стандартты уақыты),
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q(Питкэрн уақыты),
			},
		},
		'Ponape' => {
			long => {
				'standard' => q(Понапе уақыты),
			},
		},
		'Reunion' => {
			long => {
				'standard' => q(Реюньон уақыты),
			},
		},
		'Rothera' => {
			long => {
				'standard' => q(Ротера уақыты),
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q(Сахалин жазғы уақыты),
				'generic' => q(Сахалин уақыты),
				'standard' => q(Сахалин стандартты уақыты),
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q(Самоа жазғы уақыты),
				'generic' => q(Самоа уақыты),
				'standard' => q(Самоа стандартты уақыты),
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q(Сейшель уақыты),
			},
		},
		'Singapore' => {
			long => {
				'standard' => q(Сингапур уақыты),
			},
		},
		'Solomon' => {
			long => {
				'standard' => q(Соломон аралдары уақыты),
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q(Оңтүстік Георгия уақыты),
			},
		},
		'Suriname' => {
			long => {
				'standard' => q(Суринам уақыты),
			},
		},
		'Syowa' => {
			long => {
				'standard' => q(Сёва уақыты),
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q(Таити уақыты),
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q(Тайбэй жазғы уақыты),
				'generic' => q(Тайбэй уақыты),
				'standard' => q(Тайбэй стандартты уақыты),
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q(Тәжікстан уақыты),
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q(Токелау уақыты),
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q(Тонга жазғы уақыты),
				'generic' => q(Тонга уақыты),
				'standard' => q(Тонга стандартты уақыты),
			},
		},
		'Truk' => {
			long => {
				'standard' => q(Чуук уақыты),
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q(Түрікменстан жазғы уақыты),
				'generic' => q(Түрікменстан уақыты),
				'standard' => q(Түрікменстан стандартты уақыты),
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q(Тувалу уақыты),
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q(Уругвай жазғы уақыты),
				'generic' => q(Уругвай уақыты),
				'standard' => q(Уругвай стандартты уақыты),
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q(Өзбекстан жазғы уақыты),
				'generic' => q(Өзбекстан уақыты),
				'standard' => q(Өзбекстан стандартты уақыты),
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q(Вануату жазғы уақыты),
				'generic' => q(Вануату уақыты),
				'standard' => q(Вануату стандартты уақыты),
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q(Венесуэла уақыты),
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q(Владивосток жазғы уақыты),
				'generic' => q(Владивосток уақыты),
				'standard' => q(Владивосток стандартты уақыты),
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q(Волгоград жазғы уақыты),
				'generic' => q(Волгоград уақыты),
				'standard' => q(Волгоград стандартты уақыты),
			},
		},
		'Vostok' => {
			long => {
				'standard' => q(Восток уақыты),
			},
		},
		'Wake' => {
			long => {
				'standard' => q(Уэйк аралы уақыты),
			},
		},
		'Wallis' => {
			long => {
				'standard' => q(Уоллис және Футуна уақыты),
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q(Якутск жазғы уақыты),
				'generic' => q(Якутск уақыты),
				'standard' => q(Якутск стандартты уақыты),
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q(Екатеринбург жазғы уақыты),
				'generic' => q(Екатеринбург уақыты),
				'standard' => q(Екатеринбург стандартты уақыты),
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
