=encoding utf8

=head1

Locale::CLDR::Locales::Ccp - Package for language Chakma

=cut

package Locale::CLDR::Locales::Ccp;
# This file auto generated from Data\common\main\ccp.xml
#	on Sun 16 Dec  4:09:24 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.34.0');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
	is => 'ro',
	isa => ArrayRef,
	init_arg => undef,
	default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
	is => 'ro',
	isa => HashRef,
	init_arg => undef,
	default => sub { 
		use bignum;
		return {
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(𑄜𑄢𑄧𑄇𑄴 →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(𑄥𑄪𑄚𑄳𑄠𑄴𑄧),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← 𑄜𑄪𑄘𑄮 →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(𑄆𑄇𑄴),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(𑄘𑄨),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(𑄖𑄨𑄚𑄴),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(𑄌𑄳𑄆𑄬𑄢𑄴),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(𑄛𑄌𑄴),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(𑄍𑄧),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(𑄥𑄖𑄴),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(𑄃𑄖𑄳𑄠𑄴𑄧),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(𑄚𑄧),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(𑄘𑄧𑄌𑄴),
				},
				'11' => {
					base_value => q(11),
					divisor => q(10),
					rule => q(𑄆𑄉𑄢𑄧),
				},
				'12' => {
					base_value => q(12),
					divisor => q(10),
					rule => q(𑄝𑄢𑄳𑄦𑄧),
				},
				'13' => {
					base_value => q(13),
					divisor => q(10),
					rule => q(𑄖𑄬𑄢𑄳𑄦𑄧),
				},
				'14' => {
					base_value => q(14),
					divisor => q(10),
					rule => q(𑄌𑄮𑄖𑄴𑄙𑄮),
				},
				'15' => {
					base_value => q(15),
					divisor => q(10),
					rule => q(𑄛𑄧𑄚𑄴𑄘𑄳𑄢𑄧),
				},
				'16' => {
					base_value => q(16),
					divisor => q(10),
					rule => q(𑄥𑄪𑄣𑄮),
				},
				'17' => {
					base_value => q(17),
					divisor => q(10),
					rule => q(𑄥𑄧𑄖𑄴𑄧𑄢𑄧),
				},
				'18' => {
					base_value => q(18),
					divisor => q(10),
					rule => q(𑄃𑄘𑄧𑄢𑄳𑄦𑄧),
				},
				'19' => {
					base_value => q(19),
					divisor => q(10),
					rule => q(𑄃𑄪𑄚𑄴𑄮𑄌𑄴),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(𑄇𑄪𑄢𑄨[ →→]),
				},
				'30' => {
					base_value => q(30),
					divisor => q(10),
					rule => q(𑄖𑄳𑄢𑄨𑄌𑄴[ →→]),
				},
				'40' => {
					base_value => q(40),
					divisor => q(10),
					rule => q(𑄌𑄣𑄨𑄨𑄌𑄴[ →→]),
				},
				'50' => {
					base_value => q(50),
					divisor => q(10),
					rule => q(𑄛𑄧𑄚𑄴𑄎𑄌𑄴[ →→]),
				},
				'60' => {
					base_value => q(60),
					divisor => q(10),
					rule => q(𑄦𑄬𑄖𑄴[ →→]),
				},
				'70' => {
					base_value => q(70),
					divisor => q(10),
					rule => q(𑄦𑄮𑄖𑄴𑄪𑄢𑄴[ →→]),
				},
				'80' => {
					base_value => q(80),
					divisor => q(10),
					rule => q(𑄃𑄎𑄨[ →→]),
				},
				'90' => {
					base_value => q(90),
					divisor => q(10),
					rule => q(𑄚𑄧𑄛𑄴𑄝𑄰[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(←←𑄥𑄧[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(←← 𑄦𑄎𑄢𑄴[ →→]),
				},
				'100000' => {
					base_value => q(100000),
					divisor => q(100000),
					rule => q(←← 𑄣𑄇𑄴[ →→]),
				},
				'10000000' => {
					base_value => q(10000000),
					divisor => q(10000000),
					rule => q(←← 𑄇𑄪𑄖𑄨[ →→]),
				},
				'100000000000000000' => {
					base_value => q(100000000000000000),
					divisor => q(100000000000000000),
					rule => q(=#,##,##0=),
				},
				'Inf' => {
					divisor => q(1),
					rule => q(𑄃𑄧𑄜𑄪𑄢𑄧𑄚𑄴𑄘𑄨),
				},
				'NaN' => {
					divisor => q(1),
					rule => q(𑄚𑄘 𑄚𑄧𑄠𑄴),
				},
				'max' => {
					divisor => q(1),
					rule => q(𑄚𑄘 𑄚𑄧𑄠𑄴),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(𑄜𑄢𑄧𑄇𑄴 →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering= 𑄛𑄳𑄆𑄘𑄳𑄠𑄬),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##,##0.0=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,##,##0.0=),
				},
			},
		},
	} },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { 
		 sub {
			 my %languages = (
				'aa' => '𑄃𑄜𑄢𑄴',
 				'ab' => '𑄃𑄝𑄴𑄈𑄎𑄨𑄠𑄚𑄴',
 				'ace' => '𑄃𑄳𑄃𑄌𑄳𑄆𑄚𑄨𑄎𑄴',
 				'ach' => '𑄃𑄇𑄮𑄣𑄨',
 				'ada' => '𑄃𑄧𑄘𑄟𑄳𑄉𑄬',
 				'ady' => '𑄃𑄘𑄬𑄉𑄬',
 				'ae' => '𑄃𑄝𑄬𑄌𑄴𑄖𑄩𑄠𑄧',
 				'af' => '𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴',
 				'afh' => '𑄃𑄜𑄳𑄢𑄨𑄦𑄨𑄣𑄨',
 				'agq' => '𑄃𑄬𑄊𑄟𑄴',
 				'ain' => '𑄃𑄳𑄆𑄚𑄪',
 				'ak' => '𑄃𑄇𑄚𑄴',
 				'akk' => '𑄃𑄇𑄳𑄦𑄴𑄘𑄨𑄠𑄚𑄴',
 				'ale' => '𑄃𑄣𑄬𑄅𑄖𑄴',
 				'alt' => '𑄓𑄧𑄉𑄨𑄚𑄴 𑄃𑄣𑄴𑄖𑄭',
 				'am' => '𑄃𑄟𑄴𑄦𑄢𑄨𑄇𑄴',
 				'an' => '𑄃𑄢𑄴𑄉𑄮𑄚𑄨𑄎𑄴',
 				'ang' => '𑄛𑄪𑄢𑄧𑄚𑄨 𑄃𑄟𑄧𑄣𑄧𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄩',
 				'anp' => '𑄃𑄋𑄳𑄉𑄨𑄇',
 				'ar' => '𑄃𑄢𑄧𑄝𑄩',
 				'ar_001' => '𑄚𑄱 𑄉𑄧𑄟𑄴 𑄃𑄢𑄧𑄝𑄩',
 				'arc' => '𑄃𑄢𑄟𑄳𑄆𑄇𑄴',
 				'arn' => '𑄟𑄛𑄪𑄌𑄨',
 				'arp' => '𑄃𑄢𑄛𑄦𑄮',
 				'arw' => '𑄃𑄢𑄤𑄇𑄴',
 				'as' => '𑄃𑄥𑄟𑄨',
 				'asa' => '𑄃𑄥𑄪',
 				'ast' => '𑄃𑄌𑄴𑄖𑄪𑄢𑄨𑄠𑄧',
 				'av' => '𑄃𑄞𑄬𑄢𑄨𑄇𑄴',
 				'awa' => '𑄃𑄤𑄙𑄨',
 				'ay' => '𑄃𑄠𑄧𑄟𑄢',
 				'az' => '𑄃𑄎𑄢𑄴𑄝𑄳𑄆𑄎𑄚𑄩',
 				'az@alt=short' => '𑄃𑄎𑄬𑄢𑄨',
 				'ba' => '𑄝𑄌𑄴𑄇𑄨𑄢𑄴',
 				'bal' => '𑄝𑄬𑄣𑄪𑄌𑄩',
 				'ban' => '𑄝𑄣𑄨𑄚𑄩𑄠𑄧',
 				'bas' => '𑄝𑄥',
 				'be' => '𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄧',
 				'bej' => '𑄝𑄬𑄎',
 				'bem' => '𑄝𑄬𑄟𑄴𑄝',
 				'bez' => '𑄝𑄬𑄚',
 				'bg' => '𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠𑄧',
 				'bgn' => '𑄛𑄧𑄏𑄨𑄟𑄴 𑄝𑄣𑄮𑄌𑄨',
 				'bho' => '𑄞𑄮𑄎𑄴𑄛𑄪𑄢𑄨',
 				'bi' => '𑄝𑄨𑄥𑄴𑄣𑄟',
 				'bik' => '𑄝𑄨𑄇𑄮𑄣𑄴',
 				'bin' => '𑄝𑄨𑄚𑄨',
 				'bla' => '𑄥𑄨𑄇𑄴𑄥𑄨𑄇',
 				'bm' => '𑄝𑄟𑄴𑄝𑄢',
 				'bn' => '𑄝𑄁𑄣',
 				'bo' => '𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨',
 				'br' => '𑄝𑄳𑄢𑄬𑄑𑄧𑄚𑄴',
 				'bra' => '𑄝𑄳𑄢𑄎𑄴',
 				'brx' => '𑄝𑄮𑄢𑄮',
 				'bs' => '𑄝𑄧𑄥𑄴𑄚𑄩𑄠𑄚𑄴',
 				'bua' => '𑄝𑄪𑄢𑄨𑄠𑄖𑄴',
 				'bug' => '𑄝𑄪𑄉𑄨𑄚𑄨',
 				'byn' => '𑄝𑄳𑄣𑄨𑄚𑄴',
 				'ca' => '𑄇𑄖𑄣𑄚𑄴',
 				'cad' => '𑄇𑄳𑄠𑄓𑄮',
 				'car' => '𑄝𑄳𑄠𑄢𑄨𑄛𑄴',
 				'cch' => '𑄃𑄖𑄴𑄥𑄟𑄴',
 				'ccp' => '𑄌𑄋𑄴𑄟𑄳𑄦',
 				'ce' => '𑄌𑄬𑄌𑄬𑄚𑄴',
 				'ceb' => '𑄌𑄬𑄝𑄪𑄠𑄚𑄮',
 				'cgg' => '𑄌𑄨𑄉',
 				'ch' => '𑄌𑄟𑄮𑄢𑄮',
 				'chb' => '𑄌𑄨𑄛𑄴𑄌',
 				'chg' => '𑄌𑄉𑄖𑄳𑄆',
 				'chk' => '𑄌𑄪𑄇𑄨',
 				'chm' => '𑄟𑄢𑄨',
 				'chn' => '𑄌𑄨𑄚𑄪𑄇𑄴 𑄎𑄢𑄴𑄉𑄧𑄚𑄴',
 				'cho' => '𑄌𑄧𑄇𑄴𑄑𑄳𑄅𑄧𑄠𑄧',
 				'chp' => '𑄌𑄨𑄛𑄮𑄤𑄚𑄴',
 				'chr' => '𑄌𑄬𑄢𑄮𑄇𑄩',
 				'chy' => '𑄥𑄳𑄆𑄠𑄬𑄚𑄴',
 				'ckb' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴',
 				'co' => '𑄇𑄧𑄢𑄴𑄥𑄨𑄇𑄚𑄴',
 				'cop' => '𑄇𑄧𑄛𑄴𑄑𑄨𑄇𑄴',
 				'cr' => '𑄇𑄳𑄢𑄨',
 				'crh' => '𑄇𑄳𑄢𑄨𑄟𑄨𑄠𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨',
 				'crs' => '𑄥𑄬𑄥𑄬𑄣𑄧𑄤 𑄇𑄳𑄢𑄬𑄃𑄮𑄣𑄴 𑄜𑄳𑄢𑄬𑄐𑄴𑄌𑄧',
 				'cs' => '𑄌𑄬𑄇𑄴',
 				'csb' => '𑄇𑄥𑄪𑄝𑄨𑄠𑄚𑄴',
 				'cu' => '𑄌𑄢𑄴𑄌𑄴 𑄥𑄳𑄣𑄞𑄨𑄇𑄴',
 				'cv' => '𑄌𑄪𑄝𑄥𑄴',
 				'cy' => '𑄃𑄮𑄠𑄬𑄣𑄧𑄌𑄴',
 				'da' => '𑄓𑄬𑄚𑄨𑄌𑄴',
 				'dak' => '𑄓𑄇𑄮𑄑',
 				'dar' => '𑄘𑄢𑄴𑄉𑄧𑄤',
 				'dav' => '𑄖𑄳𑄆𑄖',
 				'de' => '𑄎𑄢𑄴𑄟𑄚𑄴',
 				'de_AT' => '𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠𑄚𑄴 𑄎𑄢𑄴𑄟𑄚𑄴',
 				'de_CH' => '𑄥𑄪𑄃𑄨𑄌𑄴 𑄦𑄭 𑄎𑄢𑄴𑄟𑄚𑄴',
 				'del' => '𑄓𑄬𑄣𑄤𑄬𑄢𑄴',
 				'den' => '𑄥𑄳𑄣𑄳𑄠𑄞𑄴',
 				'dgr' => '𑄘𑄮𑄉𑄳𑄢𑄨𑄝𑄴',
 				'din' => '𑄓𑄨𑄁𑄇',
 				'dje' => '𑄎𑄢𑄴𑄟',
 				'doi' => '𑄓𑄮𑄉𑄧𑄢𑄨',
 				'dsb' => '𑄙𑄮𑄣𑄴𑄚𑄬𑄭𑄙𑄳𑄠𑄬 𑄥𑄮𑄢𑄴𑄝𑄨𑄠𑄚𑄴',
 				'dua' => '𑄘𑄱𑄣',
 				'dum' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄓𑄌𑄴',
 				'dv' => '𑄘𑄨𑄝𑄬𑄦𑄨',
 				'dyo' => '𑄎𑄧𑄣-𑄜𑄧𑄚𑄩',
 				'dyu' => '𑄓𑄨𑄃𑄪𑄣',
 				'dz' => '𑄎𑄮𑄋𑄴𑄉',
 				'dzg' => '𑄘𑄉𑄎',
 				'ebu' => '𑄃𑄬𑄟𑄳𑄝𑄪𑄪',
 				'ee' => '𑄃𑄨𑄅𑄠𑄨',
 				'efi' => '𑄆𑄜𑄨𑄇𑄴',
 				'egy' => '𑄛𑄪𑄢𑄨𑄚𑄩 𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧',
 				'eka' => '𑄃𑄨𑄇𑄎𑄪𑄇𑄴',
 				'el' => '𑄉𑄳𑄢𑄨𑄇𑄴',
 				'elx' => '𑄆𑄣𑄟𑄭𑄖𑄴',
 				'en' => '𑄃𑄨𑄁𑄢𑄨𑄎𑄨',
 				'en_AU' => '𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨',
 				'en_CA' => '𑄇𑄚𑄓𑄩𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨',
 				'en_GB' => '𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨',
 				'en_GB@alt=short' => '𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨',
 				'en_US' => '𑄃𑄟𑄬𑄢𑄨𑄇𑄢𑄴 𑄃𑄨𑄁𑄢𑄎𑄨',
 				'en_US@alt=short' => '𑄃𑄨𑄅𑄪𑄃𑄬𑄌𑄴 𑄃𑄨𑄁𑄢𑄬𑄎𑄨',
 				'enm' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄨𑄁𑄢𑄬𑄎𑄨',
 				'eo' => '𑄆𑄥𑄴𑄛𑄬𑄢𑄚𑄴𑄖𑄮',
 				'es' => '𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴',
 				'es_419' => '𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴',
 				'es_ES' => '𑄄𑄅𑄢𑄮𑄛𑄩𑄠𑄧 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴',
 				'es_MX' => '𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄌𑄴',
 				'et' => '𑄆𑄌𑄴𑄖𑄨𑄚𑄩𑄠𑄧',
 				'eu' => '𑄝𑄌𑄴𑄇𑄧',
 				'ewo' => '𑄄𑄃𑄮𑄚𑄴𑄓𑄮',
 				'fa' => '𑄜𑄢𑄴𑄥𑄨',
 				'fan' => '𑄜𑄳𑄠𑄋𑄴𑄉𑄧',
 				'fat' => '𑄜𑄚𑄴𑄖𑄨',
 				'ff' => '𑄜𑄪𑄣𑄳𑄦',
 				'fi' => '𑄜𑄨𑄚𑄨𑄌𑄴',
 				'fil' => '𑄜𑄨𑄣𑄨𑄛𑄨𑄚𑄮',
 				'fj' => '𑄜𑄨𑄎𑄨𑄠𑄚𑄴',
 				'fo' => '𑄜𑄢𑄮𑄌𑄴',
 				'fon' => '𑄜𑄧𑄚𑄴',
 				'fr' => '𑄜𑄧𑄢𑄥𑄨',
 				'fr_CA' => '𑄇𑄚𑄓𑄩𑄠𑄧 𑄜𑄧𑄢𑄥𑄨',
 				'fr_CH' => '𑄥𑄪𑄃𑄨𑄌𑄴 𑄜𑄧𑄢𑄥𑄨',
 				'frm' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄜𑄧𑄢𑄥𑄨',
 				'fro' => '𑄛𑄪𑄢𑄮𑄚𑄨 𑄜𑄧𑄢𑄥𑄨',
 				'frr' => '𑄅𑄖𑄴𑄗𑄧𑄢𑄴 𑄎𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴',
 				'frs' => '𑄛𑄪𑄉𑄮 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄧',
 				'fur' => '𑄜𑄳𑄢𑄨𑄃𑄪𑄣𑄨𑄠𑄚𑄴',
 				'fy' => '𑄛𑄧𑄎𑄨𑄟𑄴 𑄜𑄳𑄢𑄨𑄥𑄨𑄠𑄚𑄴',
 				'ga' => '𑄃𑄭𑄢𑄨𑄌𑄴',
 				'gaa' => '𑄉𑄳𑄃',
 				'gag' => '𑄉𑄉𑄃𑄪𑄌𑄴',
 				'gan' => '𑄉𑄧𑄚𑄴',
 				'gay' => '𑄉𑄧𑄠𑄮',
 				'gba' => '𑄝𑄠',
 				'gd' => '𑄃𑄨𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄧-𑄉𑄳𑄠𑄬𑄣𑄨𑄇𑄴',
 				'gez' => '𑄉𑄩𑄎𑄴',
 				'gil' => '𑄉𑄨𑄣𑄴𑄝𑄢𑄴𑄑𑄨𑄎𑄴',
 				'gl' => '𑄉𑄳𑄠𑄣𑄨𑄥𑄨𑄠𑄧',
 				'gmh' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧-𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩',
 				'gn' => '𑄉𑄪𑄠𑄢𑄚𑄨',
 				'goh' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄅𑄪𑄉𑄪𑄢𑄬 𑄎𑄢𑄴𑄟𑄚𑄩',
 				'gon' => '𑄉𑄮𑄚𑄴𑄓𑄨',
 				'gor' => '𑄉𑄢𑄮𑄚𑄴𑄖𑄣𑄮',
 				'got' => '𑄉𑄧𑄗𑄨𑄇𑄴',
 				'grb' => '𑄉𑄳𑄢𑄬𑄝𑄮',
 				'grc' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄉𑄳𑄢𑄩𑄇𑄴',
 				'gsw' => '𑄥𑄪𑄃𑄨𑄌𑄴 𑄥𑄢𑄴𑄟𑄚𑄴',
 				'gu' => '𑄉𑄪𑄎𑄴𑄢𑄖𑄨',
 				'guz' => '𑄉𑄪𑄥𑄩',
 				'gv' => '𑄟𑄳𑄠𑄇𑄴𑄥𑄧',
 				'gwi' => '𑄉𑄧𑄃𑄮𑄃𑄨𑄌𑄴𑄃𑄨𑄚𑄴',
 				'ha' => '𑄦𑄃𑄪𑄥',
 				'hai' => '𑄦𑄭𑄓',
 				'hak' => '𑄦𑄧𑄇𑄴',
 				'haw' => '𑄦𑄤𑄃𑄨𑄠𑄚𑄴',
 				'he' => '𑄦𑄨𑄛𑄴𑄝𑄳𑄢𑄪',
 				'hi' => '𑄦𑄨𑄚𑄴𑄓𑄨',
 				'hil' => '𑄦𑄨𑄣𑄨𑄉𑄳𑄠𑄠𑄧𑄚𑄮𑄚𑄴',
 				'hit' => '𑄦𑄨𑄖𑄨𑄨𑄖𑄴',
 				'hmn' => '𑄦𑄳𑄦𑄟𑄮𑄋𑄴',
 				'ho' => '𑄦𑄪𑄢𑄨 𑄟𑄮𑄖𑄪',
 				'hr' => '𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄩𑄠𑄧',
 				'hsb' => '𑄅𑄪𑄉𑄪𑄢𑄬 𑄥𑄮𑄢𑄴𑄥𑄨𑄠𑄚𑄴',
 				'hsn' => 'Xiang 𑄌𑄨𑄚',
 				'ht' => '𑄦𑄭𑄖𑄨𑄠𑄚𑄴',
 				'hu' => '𑄦𑄁𑄉𑄬𑄢𑄩𑄠𑄧',
 				'hup' => '𑄦𑄪𑄛',
 				'hy' => '𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄧',
 				'hz' => '𑄦𑄬𑄢𑄬𑄢𑄮',
 				'ia' => '𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄪𑄠',
 				'iba' => '𑄃𑄨𑄝𑄚𑄴',
 				'ibb' => '𑄃𑄨𑄝𑄨𑄝𑄨𑄠𑄧',
 				'id' => '𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄧',
 				'ie' => '𑄃𑄨𑄚𑄴𑄑𑄢𑄴𑄣𑄨𑄁𑄉𑄧',
 				'ig' => '𑄃𑄨𑄉𑄴𑄝𑄮',
 				'ii' => '𑄥𑄨𑄥𑄪𑄠𑄚𑄴𑄠𑄨',
 				'ik' => '𑄃𑄨𑄚𑄪𑄛𑄨𑄠𑄇𑄴',
 				'ilo' => '𑄃𑄨𑄣𑄮𑄇𑄮',
 				'inh' => '𑄃𑄨𑄁𑄉𑄪𑄌𑄴',
 				'io' => '𑄃𑄨𑄓𑄮',
 				'is' => '𑄃𑄭𑄌𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨𑄠𑄧',
 				'it' => '𑄃𑄨𑄖𑄣𑄩𑄠𑄧',
 				'iu' => '𑄃𑄨𑄚𑄪𑄇𑄴𑄑𑄨𑄑𑄪𑄖𑄴',
 				'ja' => '𑄎𑄛𑄚𑄨',
 				'jbo' => '𑄣𑄮𑄌𑄴𑄝𑄚𑄴',
 				'jgo' => '𑄉𑄮𑄟𑄴𑄝',
 				'jmc' => '𑄟𑄇𑄟𑄬',
 				'jpr' => '𑄎𑄪𑄘𑄬𑄃𑄮 𑄜𑄢𑄴𑄥𑄨',
 				'jrb' => '𑄎𑄪𑄘𑄬𑄃𑄮 𑄃𑄢𑄧𑄝𑄨',
 				'jv' => '𑄎𑄞𑄚𑄨𑄎𑄴',
 				'ka' => '𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴',
 				'kaa' => '𑄇𑄢-𑄇𑄣𑄴𑄛𑄇𑄴',
 				'kab' => '𑄇𑄝𑄭𑄣𑄬',
 				'kac' => '𑄇𑄌𑄨𑄚𑄴',
 				'kaj' => '𑄃𑄧𑄌𑄴𑄎𑄪',
 				'kam' => '𑄇𑄟𑄴𑄝',
 				'kaw' => '𑄇𑄃𑄪𑄃𑄨',
 				'kbd' => '𑄇𑄝𑄢𑄴𑄓𑄨𑄠𑄚𑄴',
 				'kcg' => '𑄑𑄃𑄨𑄠𑄛𑄴',
 				'kde' => '𑄟𑄇𑄮𑄚𑄴𑄘𑄬',
 				'kea' => '𑄇𑄝𑄪𑄞𑄢𑄴𑄘𑄨𑄠𑄚𑄪',
 				'kfo' => '𑄇𑄮𑄢𑄮',
 				'kg' => '𑄇𑄧𑄁𑄉𑄮',
 				'kha' => '𑄈𑄥𑄨',
 				'kho' => '𑄈𑄮𑄑𑄚𑄨𑄎𑄴',
 				'khq' => '𑄇𑄮𑄠𑄧𑄢 𑄌𑄩𑄚𑄨',
 				'ki' => '𑄇𑄨𑄇𑄪𑄠𑄪',
 				'kj' => '𑄇𑄮𑄠𑄚𑄨𑄠𑄟',
 				'kk' => '𑄇𑄎𑄇𑄴',
 				'kkj' => '𑄇𑄇𑄮',
 				'kl' => '𑄇𑄳𑄠𑄣𑄣𑄴𑄣𑄨𑄥𑄪𑄖𑄴',
 				'kln' => '𑄇𑄣𑄬𑄚𑄴𑄎𑄨𑄚𑄴',
 				'km' => '𑄈𑄧𑄟𑄬𑄢𑄴',
 				'kmb' => '𑄇𑄨𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪',
 				'kn' => '𑄇𑄧𑄚𑄴𑄚𑄧𑄢𑄴',
 				'ko' => '𑄇𑄮𑄢𑄨𑄠𑄚𑄴',
 				'koi' => '𑄇𑄧𑄟𑄨-𑄛𑄢𑄧𑄟𑄨𑄃𑄇𑄴',
 				'kok' => '𑄇𑄮𑄋𑄴𑄇𑄚𑄨',
 				'kos' => '𑄇𑄮𑄥𑄳𑄢𑄭𑄚𑄴',
 				'kpe' => '𑄇𑄴𑄛𑄬𑄣𑄳𑄣𑄬',
 				'kr' => '𑄇𑄚𑄪𑄢𑄨',
 				'krc' => '𑄇𑄢𑄴𑄌𑄮-𑄝𑄣𑄴𑄇𑄢𑄴',
 				'krl' => '𑄇𑄢𑄬𑄣𑄨𑄠𑄚𑄴',
 				'kru' => '𑄇𑄪𑄢𑄪𑄇𑄴',
 				'ks' => '𑄇𑄌𑄴𑄟𑄨𑄢𑄨',
 				'ksb' => '𑄥𑄟𑄴𑄝𑄣',
 				'ksf' => '𑄝𑄜𑄨𑄠',
 				'ksh' => '𑄇𑄣𑄴𑄥𑄧',
 				'ku' => '𑄇𑄪𑄢𑄴𑄘𑄨𑄥𑄴',
 				'kum' => '𑄇𑄪𑄟𑄨𑄇𑄴',
 				'kut' => '𑄇𑄪𑄑𑄬𑄚𑄭',
 				'kv' => '𑄇𑄮𑄟𑄨',
 				'kw' => '𑄇𑄧𑄢𑄴𑄚𑄨𑄌𑄴',
 				'ky' => '𑄇𑄨𑄢𑄴𑄉𑄨𑄌𑄴',
 				'la' => '𑄣𑄑𑄨𑄚𑄴',
 				'lad' => '𑄣𑄓𑄨𑄚𑄮',
 				'lag' => '𑄣𑄋𑄴𑄉𑄨',
 				'lah' => '𑄣𑄚𑄴𑄓',
 				'lam' => '𑄣𑄟𑄴𑄝',
 				'lb' => '𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄩𑄠𑄧',
 				'lez' => '𑄣𑄬𑄎𑄴𑄊𑄨𑄠𑄚𑄴',
 				'lg' => '𑄉𑄚𑄴𑄓',
 				'li' => '𑄣𑄨𑄟𑄴𑄝𑄪𑄢𑄴𑄉𑄨𑄌𑄴',
 				'lkt' => '𑄣𑄇𑄮𑄑',
 				'ln' => '𑄣𑄨𑄋𑄴𑄉𑄣',
 				'lo' => '𑄣𑄃𑄮',
 				'lol' => '𑄟𑄮𑄋𑄴𑄉𑄮',
 				'loz' => '𑄣𑄮𑄎𑄨',
 				'lrc' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄣𑄪𑄢𑄨',
 				'lt' => '𑄣𑄨𑄗𑄪𑄠𑄬𑄚𑄩𑄠𑄧',
 				'lu' => '𑄣𑄪𑄝-𑄇𑄑𑄋𑄴𑄉',
 				'lua' => '𑄣𑄪𑄝-𑄣𑄪𑄣𑄪𑄠',
 				'lui' => '𑄣𑄭𑄪𑄥𑄬𑄚𑄮',
 				'lun' => '𑄣𑄪𑄚𑄴𑄓',
 				'luo' => '𑄣𑄪𑄠𑄮',
 				'lus' => '𑄟𑄨𑄎𑄮',
 				'luy' => '𑄣𑄭𑄪𑄠',
 				'lv' => '𑄣𑄖𑄴𑄞𑄩𑄠𑄧',
 				'mad' => '𑄟𑄘𑄪𑄢𑄬𑄥𑄬',
 				'mag' => '𑄟𑄉𑄦𑄨',
 				'mai' => '𑄟𑄳𑄆𑄧𑄗𑄨𑄣𑄨',
 				'mak' => '𑄟𑄳𑄠𑄇𑄥𑄢𑄴',
 				'man' => '𑄟𑄳𑄠𑄚𑄴𑄓𑄨𑄁𑄉𑄮',
 				'mas' => '𑄟𑄥𑄭',
 				'mdf' => '𑄟𑄮𑄇𑄴𑄥',
 				'mdr' => '𑄟𑄳𑄠𑄚𑄴𑄓𑄢𑄴',
 				'men' => '𑄟𑄬𑄚𑄴𑄓𑄬',
 				'mer' => '𑄟𑄬𑄢𑄪',
 				'mfe' => '𑄟𑄢𑄨𑄥𑄨𑄠𑄚𑄴',
 				'mg' => '𑄟𑄣𑄉𑄥𑄨',
 				'mga' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄭𑄢𑄨𑄌𑄴',
 				'mgh' => '𑄟𑄈𑄪𑄠-𑄟𑄬𑄖𑄴𑄖𑄮',
 				'mgo' => '𑄟𑄬𑄑',
 				'mh' => '𑄟𑄢𑄴𑄥𑄣𑄨𑄎𑄴',
 				'mi' => '𑄟𑄃𑄮𑄢𑄨',
 				'mic' => '𑄟𑄨𑄇𑄟𑄳𑄠𑄇𑄴',
 				'min' => '𑄟𑄨𑄚𑄋𑄴𑄇𑄝𑄃𑄪',
 				'mk' => '𑄟𑄳𑄠𑄥𑄨𑄓𑄮𑄚𑄩𑄠𑄧',
 				'ml' => '𑄟𑄣𑄠𑄣𑄟𑄴',
 				'mn' => '𑄟𑄧𑄁𑄉𑄮𑄣𑄨𑄠𑄧',
 				'mnc' => '𑄟𑄚𑄴𑄌𑄪',
 				'mni' => '𑄟𑄚𑄨𑄛𑄪𑄢𑄩',
 				'moh' => '𑄟𑄮𑄦𑄃𑄮𑄇𑄴',
 				'mos' => '𑄟𑄧𑄥𑄨',
 				'mr' => '𑄟𑄢𑄒𑄨',
 				'ms' => '𑄟𑄣𑄧𑄠𑄴',
 				'mt' => '𑄟𑄧𑄣𑄴𑄑𑄨𑄠𑄧',
 				'mua' => '𑄟𑄪𑄘𑄋𑄴𑄉𑄧',
 				'mul' => '𑄝𑄣𑄧𑄇𑄴𑄇𑄚𑄨 𑄞𑄌𑄴',
 				'mus' => '𑄇𑄳𑄢𑄨𑄇𑄴',
 				'mwl' => '𑄟𑄨𑄢𑄚𑄴𑄓𑄨𑄎𑄴',
 				'mwr' => '𑄟𑄢𑄮𑄠𑄢𑄨',
 				'my' => '𑄝𑄧𑄢𑄴𑄟𑄨',
 				'myv' => '𑄆𑄢𑄧𑄎𑄨𑄠',
 				'mzn' => '𑄟𑄎𑄚𑄴𑄘𑄬𑄢𑄚𑄨',
 				'na' => '𑄚𑄃𑄪𑄢𑄪',
 				'nan' => '𑄚𑄚𑄴',
 				'nap' => '𑄚𑄬𑄠𑄛𑄮𑄣𑄨𑄑𑄚𑄴',
 				'naq' => '𑄚𑄟',
 				'nb' => '𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄨𑄠𑄚𑄴 𑄝𑄮𑄇𑄴𑄟𑄣𑄴',
 				'nd' => '𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄆𑄚𑄴𑄘𑄬𑄝𑄨𑄣𑄨',
 				'nds' => '𑄖𑄧𑄣𑄬 𑄎𑄢𑄴𑄟𑄚𑄨',
 				'nds_NL' => '𑄣𑄮𑄥𑄳𑄠𑄇𑄴𑄥𑄧𑄚𑄴',
 				'ne' => '𑄚𑄬𑄛𑄣𑄨',
 				'new' => '𑄚𑄬𑄃𑄮𑄠𑄢𑄨',
 				'ng' => '𑄆𑄚𑄴𑄘𑄮𑄋𑄴𑄉',
 				'nia' => '𑄚𑄨𑄠𑄌𑄴',
 				'niu' => '𑄚𑄨𑄃𑄪𑄠𑄚𑄴',
 				'nl' => '𑄓𑄌𑄴',
 				'nl_BE' => '𑄜𑄳𑄣𑄬𑄟𑄨𑄌𑄴',
 				'nmg' => '𑄇𑄱𑄥𑄨𑄃𑄮',
 				'nn' => '𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄚𑄴 𑄚𑄨𑄚𑄧𑄢𑄴𑄥𑄳𑄇𑄴',
 				'nnh' => '𑄚𑄨𑄋𑄴𑄉𑄬𑄟𑄴𑄝𑄪𑄚𑄴',
 				'no' => '𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬𑄎𑄩𑄠𑄧',
 				'nog' => '𑄚𑄮𑄉𑄭',
 				'non' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄧𑄢𑄴𑄥𑄧',
 				'nqo' => '𑄆𑄚𑄴𑄇𑄮',
 				'nr' => '𑄓𑄧𑄉𑄨𑄚𑄴 𑄆𑄚𑄴𑄓𑄬𑄝𑄬𑄣𑄬',
 				'nso' => '𑄃𑄪𑄖𑄴𑄗𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄮𑄗𑄮',
 				'nus' => '𑄚𑄪𑄠𑄢𑄴',
 				'nv' => '𑄚𑄞𑄎𑄮',
 				'nwc' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄚𑄬𑄃𑄮𑄠𑄢𑄩',
 				'ny' => '𑄚𑄠𑄚𑄴𑄎',
 				'nym' => '𑄚𑄳𑄠𑄠𑄟𑄴𑄃𑄮𑄠𑄬𑄎𑄨',
 				'nyn' => '𑄚𑄳𑄠𑄠𑄋𑄴𑄇𑄮𑄣𑄬',
 				'nyo' => '𑄚𑄧𑄱𑄢𑄮',
 				'nzi' => '𑄆𑄚𑄴𑄎𑄨𑄟',
 				'oc' => '𑄃𑄧𑄇𑄴𑄥𑄨𑄑𑄚𑄴',
 				'oj' => '𑄃𑄮𑄎𑄨𑄝𑄧𑄤',
 				'om' => '𑄃𑄧𑄢𑄮𑄟𑄮',
 				'or' => '𑄃𑄮𑄢𑄨𑄠',
 				'os' => '𑄃𑄮𑄥𑄬𑄑𑄨𑄇𑄴',
 				'osa' => '𑄃𑄮𑄥𑄬𑄌𑄴',
 				'ota' => '𑄃𑄧𑄑𑄮𑄟𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨',
 				'pa' => '𑄛𑄚𑄴𑄎𑄝𑄩',
 				'pag' => '𑄛𑄁𑄉𑄥𑄨𑄚𑄚𑄴',
 				'pal' => '𑄛𑄦𑄳𑄣𑄞𑄨',
 				'pam' => '𑄛𑄟𑄴𑄛𑄋𑄴𑄉',
 				'pap' => '𑄛𑄛𑄨𑄠𑄟𑄬𑄚𑄴𑄖𑄮',
 				'pau' => '𑄛𑄣𑄠𑄪𑄠𑄚𑄴',
 				'pcm' => '𑄚𑄎𑄬𑄢𑄨𑄠𑄧 𑄛𑄨𑄎𑄨𑄚𑄴',
 				'peo' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄜𑄢𑄴𑄥𑄨',
 				'phn' => '𑄜𑄮𑄚𑄨𑄥𑄨𑄠𑄚𑄴',
 				'pi' => '𑄛𑄣𑄨',
 				'pl' => '𑄛𑄮𑄣𑄨𑄌𑄴',
 				'pon' => '𑄛𑄮𑄚𑄴𑄦𑄧𑄛𑄳𑄆𑄬𑄠𑄚𑄴',
 				'prg' => '𑄛𑄴𑄢𑄪𑄥𑄨𑄠𑄚𑄴',
 				'pro' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄛𑄳𑄢𑄮𑄞𑄬𑄚𑄴𑄥𑄣𑄴',
 				'ps' => '𑄛𑄌𑄴𑄑𑄪',
 				'ps@alt=variant' => '𑄛𑄪𑄌𑄴𑄖𑄮',
 				'pt' => '𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴',
 				'pt_BR' => '𑄝𑄳𑄢𑄎𑄨𑄣𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴',
 				'pt_PT' => '𑄃𑄨𑄃𑄪𑄢𑄮𑄛𑄬𑄢𑄴 𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴',
 				'qu' => '𑄇𑄬𑄌𑄪𑄠',
 				'quc' => '𑄇𑄳𑄦𑄨𑄌𑄬',
 				'raj' => '𑄢𑄎𑄴𑄥𑄳𑄦𑄚𑄨',
 				'rap' => '𑄢𑄛𑄚𑄳𑄆𑄪',
 				'rar' => '𑄢𑄢𑄮𑄑𑄮𑄁𑄉𑄚𑄴',
 				'rm' => '𑄢𑄮𑄟𑄚𑄴𑄥𑄴',
 				'rn' => '𑄢𑄪𑄚𑄴𑄘𑄨',
 				'ro' => '𑄢𑄮𑄟𑄚𑄩𑄠𑄧',
 				'ro_MD' => '𑄟𑄧𑄣𑄴𑄘𑄞𑄨𑄠𑄧',
 				'rof' => '𑄢𑄧𑄟𑄴𑄝𑄮',
 				'rom' => '𑄢𑄮𑄟𑄚𑄨',
 				'root' => '𑄥𑄨𑄠𑄮𑄢𑄴',
 				'ru' => '𑄢𑄪𑄌𑄴',
 				'rup' => '𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴',
 				'rw' => '𑄇𑄨𑄚𑄴𑄠𑄢𑄮𑄠𑄚𑄴𑄓',
 				'rwk' => '𑄢𑄤',
 				'sa' => '𑄥𑄧𑄁𑄥𑄴𑄇𑄳𑄢𑄨𑄖𑄴',
 				'sad' => '𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄮𑄠𑄬',
 				'sah' => '𑄥𑄈',
 				'sam' => '𑄥𑄟𑄢𑄨𑄑𑄚𑄴 𑄃𑄢𑄟𑄨𑄇𑄴',
 				'saq' => '𑄥𑄟𑄴𑄝𑄪𑄢𑄪',
 				'sas' => '𑄥𑄥𑄇𑄴',
 				'sat' => '𑄥𑄀𑄃𑄮𑄖𑄣𑄨',
 				'sba' => '𑄚𑄳𑄠𑄉𑄟𑄴𑄝𑄬',
 				'sbp' => '𑄥𑄁𑄚𑄴𑄉𑄪',
 				'sc' => '𑄥𑄢𑄴𑄓𑄨𑄚𑄨𑄠𑄚𑄴',
 				'scn' => '𑄥𑄨𑄥𑄨𑄣𑄨𑄠𑄚𑄴',
 				'sco' => '𑄆𑄌𑄴𑄇𑄧𑄖𑄴𑄥𑄴',
 				'sd' => '𑄥𑄨𑄚𑄴𑄙𑄨',
 				'sdh' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄪𑄢𑄴𑄘𑄨𑄌𑄴',
 				'se' => '𑄅𑄖𑄴𑄖𑄧𑄢𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨',
 				'seh' => '𑄥𑄬𑄚',
 				'sel' => '𑄥𑄬𑄣𑄴𑄇𑄪𑄛𑄴',
 				'ses' => '𑄇𑄱𑄢𑄝𑄬𑄚𑄮 𑄥𑄬𑄚𑄳𑄚𑄨',
 				'sg' => '𑄥𑄋𑄴𑄉𑄮',
 				'sga' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄃𑄭𑄢𑄨𑄌𑄴',
 				'sh' => '𑄥𑄢𑄴𑄝𑄮-𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄧',
 				'shi' => '𑄖𑄌𑄬𑄣𑄴𑄦𑄨𑄖𑄴',
 				'shn' => '𑄥𑄚𑄴',
 				'si' => '𑄥𑄨𑄁𑄦𑄧𑄣𑄩',
 				'sid' => '𑄥𑄨𑄓𑄟𑄮',
 				'sk' => '𑄥𑄳𑄣𑄮𑄞𑄇𑄴',
 				'sl' => '𑄥𑄳𑄣𑄮𑄞𑄬𑄚𑄩𑄠𑄧',
 				'sm' => '𑄥𑄟𑄮𑄠𑄚𑄴',
 				'sma' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄥𑄟𑄨',
 				'smj' => '𑄣𑄪𑄣𑄬 𑄥𑄟𑄨',
 				'smn' => '𑄃𑄨𑄚𑄢𑄨 𑄥𑄟𑄨',
 				'sms' => '𑄥𑄳𑄇𑄧𑄣𑄳𑄑𑄧 𑄥𑄟𑄨',
 				'sn' => '𑄥𑄮𑄚',
 				'snk' => '𑄥𑄮𑄚𑄨𑄋𑄴𑄇𑄬',
 				'so' => '𑄥𑄮𑄟𑄣𑄨',
 				'sog' => '𑄥𑄮𑄇𑄴𑄓𑄠𑄚𑄴',
 				'sq' => '𑄃𑄣𑄴𑄝𑄬𑄚𑄩𑄠𑄧',
 				'sr' => '𑄥𑄢𑄴𑄝𑄩𑄠𑄧',
 				'srn' => '𑄥𑄳𑄢𑄚𑄚𑄴 𑄑𑄮𑄋𑄴𑄉𑄮',
 				'srr' => '𑄥𑄬𑄢𑄬𑄢𑄴',
 				'ss' => '𑄥𑄮𑄠𑄖𑄨',
 				'ssy' => '𑄥𑄦𑄮',
 				'st' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄮𑄗𑄮',
 				'su' => '𑄥𑄪𑄘𑄚𑄩',
 				'suk' => '𑄥𑄪𑄇𑄪𑄟',
 				'sus' => '𑄥𑄪𑄥𑄪',
 				'sux' => '𑄥𑄪𑄟𑄬𑄢𑄩𑄠𑄧',
 				'sv' => '𑄥𑄭𑄪𑄓𑄨𑄥𑄴',
 				'sw' => '𑄥𑄱𑄦𑄨𑄣𑄨',
 				'sw_CD' => '𑄇𑄧𑄋𑄴𑄉𑄮 𑄥𑄱𑄦𑄨𑄣𑄨',
 				'swb' => '𑄇𑄧𑄟𑄮𑄢𑄨𑄠𑄚𑄴',
 				'syc' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄥𑄨𑄢𑄨𑄃𑄮',
 				'syr' => '𑄥𑄨𑄢𑄨𑄠𑄇𑄴',
 				'ta' => '𑄖𑄟𑄨𑄣𑄴',
 				'te' => '𑄖𑄬𑄣𑄬𑄉𑄪',
 				'tem' => '𑄑𑄭𑄟𑄴𑄚𑄬',
 				'teo' => '𑄖𑄬𑄥𑄮',
 				'ter' => '𑄖𑄬𑄢𑄬𑄚𑄮',
 				'tet' => '𑄖𑄬𑄖𑄪𑄟𑄴',
 				'tg' => '𑄖𑄎𑄨𑄇𑄴',
 				'th' => '𑄗𑄭',
 				'ti' => '𑄖𑄨𑄉𑄧𑄢𑄨𑄚𑄨𑄠',
 				'tig' => '𑄑𑄭𑄉𑄳𑄢𑄬',
 				'tiv' => '𑄑𑄨𑄞𑄴',
 				'tk' => '𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨',
 				'tkl' => '𑄑𑄮𑄇𑄬𑄣𑄃𑄪',
 				'tl' => '𑄖𑄉𑄣𑄧𑄇𑄴',
 				'tlh' => '𑄇𑄳𑄣𑄨𑄋𑄴𑄉𑄧𑄚𑄴',
 				'tli' => '𑄖𑄴𑄣𑄨𑄋𑄴𑄉𑄨𑄖𑄴',
 				'tmh' => '𑄖𑄟𑄥𑄬𑄇𑄴',
 				'tn' => '𑄥𑄱𑄚',
 				'to' => '𑄑𑄮𑄋𑄴𑄉𑄚𑄴',
 				'tog' => '𑄚𑄠𑄥𑄑𑄮𑄋𑄴𑄉',
 				'tpi' => '𑄑𑄮𑄇𑄴 𑄛𑄨𑄥𑄨𑄚𑄴',
 				'tr' => '𑄖𑄪𑄢𑄴𑄇𑄩',
 				'trv' => '𑄖𑄢𑄮𑄇𑄮',
 				'ts' => '𑄥𑄧𑄋𑄴𑄉',
 				'tsi' => '𑄥𑄨𑄟𑄴𑄥𑄨𑄠𑄚𑄴',
 				'tt' => '𑄖𑄖𑄢𑄴',
 				'tum' => '𑄖𑄪𑄟𑄴𑄝𑄪𑄇',
 				'tvl' => '𑄑𑄪𑄞𑄣𑄪',
 				'tw' => '𑄑𑄮𑄠𑄭',
 				'twq' => '𑄖𑄥𑄤𑄇𑄴',
 				'ty' => '𑄖𑄦𑄨𑄖𑄨𑄠𑄚𑄴',
 				'tyv' => '𑄑𑄪𑄞𑄨𑄚𑄨𑄠𑄚𑄴',
 				'tzm' => '𑄥𑄬𑄚𑄴𑄑𑄳𑄢𑄣𑄴 𑄃𑄣𑄴𑄖𑄌𑄴 𑄖𑄟𑄎𑄨𑄉𑄖𑄴',
 				'udm' => '𑄃𑄪𑄓𑄴𑄟𑄪𑄢𑄴𑄑𑄧',
 				'ug' => '𑄃𑄪𑄃𑄨𑄊𑄪𑄢𑄴',
 				'uga' => '𑄃𑄪𑄉𑄢𑄨𑄑𑄨𑄇𑄴',
 				'uk' => '𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄩𑄠𑄧',
 				'umb' => '𑄃𑄪𑄟𑄴𑄝𑄪𑄚𑄴𑄘𑄪',
 				'und' => '𑄦𑄧𑄝𑄧𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄞𑄌𑄴',
 				'ur' => '𑄃𑄪𑄢𑄴𑄘𑄪',
 				'uz' => '𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄩𑄠𑄧',
 				'vai' => '𑄞𑄭',
 				've' => '𑄞𑄬𑄚𑄴𑄓',
 				'vi' => '𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄩',
 				'vo' => '𑄞𑄮𑄣𑄛𑄪𑄇𑄴',
 				'vot' => '𑄞𑄮𑄑𑄨𑄇𑄴',
 				'vun' => '𑄞𑄪𑄚𑄴𑄏𑄮',
 				'wa' => '𑄤𑄣𑄪𑄚𑄴',
 				'wae' => '𑄤𑄣𑄧𑄥𑄬𑄢𑄴',
 				'wal' => '𑄤𑄣𑄟𑄮',
 				'war' => '𑄤𑄢𑄬',
 				'was' => '𑄤𑄥𑄮',
 				'wbp' => '𑄤𑄢𑄴𑄣𑄴𑄛𑄨𑄢𑄨',
 				'wo' => '𑄤𑄃𑄮𑄣𑄮𑄜𑄴',
 				'wuu' => '𑄤𑄌𑄨𑄚',
 				'xal' => '𑄇𑄣𑄴𑄟𑄳𑄆𑄧𑄇𑄴',
 				'xh' => '𑄎𑄮𑄥',
 				'xog' => '𑄥𑄮𑄉',
 				'yao' => '𑄃𑄨𑄠𑄃𑄮',
 				'yap' => '𑄃𑄨𑄠𑄛𑄬𑄥𑄬',
 				'yav' => '𑄠𑄋𑄴𑄉𑄧𑄝𑄬𑄚𑄴',
 				'ybb' => '𑄠𑄮𑄟𑄴𑄝',
 				'yi' => '𑄠𑄨𑄖𑄴𑄘𑄨𑄥𑄴',
 				'yo' => '𑄃𑄨𑄃𑄮𑄢𑄪𑄝',
 				'yue' => '𑄇𑄳𑄠𑄚𑄴𑄑𑄮𑄚𑄩𑄎𑄴',
 				'za' => '𑄏𑄪𑄠𑄋𑄴',
 				'zap' => '𑄎𑄛𑄮𑄑𑄬𑄇𑄴',
 				'zbl' => '𑄃𑄉𑄬𑄠 𑄞𑄌𑄴',
 				'zen' => '𑄎𑄬𑄚𑄉',
 				'zgh' => '𑄉𑄧𑄟𑄴𑄘𑄮𑄣𑄴 𑄟𑄧𑄢𑄧𑄇𑄧𑄧𑄱𑄚𑄴𑄖𑄟𑄎𑄨𑄉𑄖𑄴',
 				'zh' => '𑄌𑄩𑄚',
 				'zh_Hans' => '𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫 𑄌𑄩𑄚',
 				'zh_Hant' => '𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄩𑄚',
 				'zu' => '𑄎𑄪𑄣𑄪',
 				'zun' => '𑄎𑄪𑄚𑄨',
 				'zxx' => '𑄞𑄏𑄧𑄢𑄴𑄘𑄮𑄇𑄳𑄠𑄬 𑄝𑄨𑄥𑄧𑄠𑄴 𑄚𑄳𑄄𑄬',
 				'zza' => '𑄎𑄎',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Arab' => '𑄃𑄢𑄧𑄝𑄨',
 			'Arab@alt=variant' => '𑄜𑄢𑄴𑄥𑄨-𑄃𑄢𑄧𑄝𑄨',
 			'Armi' => '𑄃𑄢𑄧𑄟𑄨',
 			'Armn' => '𑄃𑄢𑄴𑄟𑄬𑄚𑄩𑄠𑄧',
 			'Avst' => '𑄃𑄞𑄬𑄥𑄧𑄖𑄚𑄴',
 			'Bali' => '𑄝𑄣𑄩𑄠𑄧',
 			'Batk' => '𑄖𑄑𑄇𑄴',
 			'Beng' => '𑄝𑄁𑄣',
 			'Blis' => '𑄝𑄳𑄣𑄨𑄌𑄴𑄛𑄳𑄢𑄧𑄖𑄩𑄇𑄴',
 			'Bopo' => '𑄝𑄮𑄛𑄮𑄟𑄮𑄜𑄮',
 			'Brah' => '𑄝𑄳𑄢𑄟𑄴𑄦𑄴𑄟𑄩',
 			'Brai' => '𑄝𑄳𑄢𑄳𑄆𑄬𑄣𑄴',
 			'Bugi' => '𑄝𑄪𑄉𑄨',
 			'Buhd' => '𑄝𑄪𑄦𑄨𑄓𑄴',
 			'Cakm' => '𑄌𑄋𑄴𑄟𑄳𑄦',
 			'Cans' => '𑄎𑄧𑄙 𑄇𑄚𑄓𑄨𑄠𑄚𑄴 𑄃𑄳𑄠𑄝𑄳𑄢𑄮𑄎𑄨𑄚𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄬𑄝𑄨𑄇𑄴𑄥𑄧',
 			'Cari' => '𑄇𑄳𑄠𑄢𑄨𑄠𑄚𑄴',
 			'Cham' => '𑄌𑄳𑄠𑄟𑄴',
 			'Cher' => '𑄌𑄬𑄇𑄮𑄇𑄨',
 			'Cirt' => '𑄇𑄨𑄢𑄴𑄑𑄧',
 			'Copt' => '𑄇𑄮𑄛𑄴𑄑𑄨𑄇𑄴',
 			'Cprt' => '𑄥𑄭𑄛𑄳𑄢𑄮𑄠𑄬𑄖𑄴',
 			'Cyrl' => '𑄥𑄨𑄢𑄨𑄣𑄨𑄇𑄴',
 			'Cyrs' => '𑄛𑄪𑄢𑄮𑄚𑄨 𑄌𑄢𑄴𑄌𑄧 𑄥𑄳𑄣𑄞𑄮𑄚𑄨𑄇𑄴 𑄥𑄨𑄢𑄨𑄣𑄨𑄇𑄴',
 			'Deva' => '𑄘𑄬𑄛𑄴𑄚𑄉𑄧𑄢𑄨',
 			'Dsrt' => '𑄘𑄬𑄥𑄬𑄢𑄖𑄴',
 			'Egyd' => '𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧 𑄓𑄬𑄟𑄮𑄑𑄨𑄇𑄴',
 			'Egyh' => '𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧 𑄦𑄠𑄴𑄢𑄬𑄑𑄨𑄇𑄴',
 			'Egyp' => '𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄧 𑄦𑄠𑄢𑄮𑄉𑄳𑄣𑄨𑄛𑄴',
 			'Ethi' => '𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄠𑄧',
 			'Geok' => '𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄧 𑄈𑄪𑄖𑄴𑄥𑄪𑄢𑄨',
 			'Geor' => '𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴',
 			'Glag' => '𑄉𑄳𑄣𑄉𑄮𑄣𑄨𑄑𑄨𑄇𑄴',
 			'Goth' => '𑄉𑄮𑄗𑄨𑄇𑄴',
 			'Grek' => '𑄉𑄳𑄢𑄨𑄇𑄴',
 			'Gujr' => '𑄉𑄪𑄎𑄴𑄢𑄑𑄨',
 			'Guru' => '𑄉𑄪𑄢𑄪𑄟𑄪𑄈𑄨',
 			'Hanb' => '𑄦𑄳𑄠𑄚𑄴𑄝𑄨',
 			'Hang' => '𑄦𑄋𑄴𑄉𑄪𑄣𑄴',
 			'Hani' => '𑄦𑄳𑄠𑄚𑄴',
 			'Hano' => '𑄦𑄳𑄠𑄚𑄪𑄚𑄪',
 			'Hans' => '𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄫',
 			'Hans@alt=stand-alone' => '𑄅𑄪𑄎𑄪𑄅𑄪𑄏𑄪 𑄦𑄳𑄠𑄚𑄴',
 			'Hant' => '𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴',
 			'Hant@alt=stand-alone' => '𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄦𑄳𑄠𑄚𑄴',
 			'Hebr' => '𑄦𑄨𑄛𑄴𑄝𑄳𑄢𑄪',
 			'Hira' => '𑄦𑄨𑄢𑄉𑄚',
 			'Hmng' => '𑄜𑄦𑄃𑄮𑄟𑄧𑄋𑄴',
 			'Hrkt' => '𑄎𑄛𑄚𑄨 𑄦𑄧𑄢𑄧𑄇𑄴',
 			'Hung' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄦𑄋𑄴𑄉𑄬𑄢𑄨𑄠𑄧',
 			'Inds' => '𑄥𑄨𑄚𑄴𑄙𑄪',
 			'Ital' => '𑄛𑄪𑄢𑄮𑄚𑄩 𑄃𑄨𑄖𑄣𑄨',
 			'Jamo' => '𑄎𑄳𑄠𑄟𑄮',
 			'Java' => '𑄎𑄞𑄚𑄨𑄎𑄴',
 			'Jpan' => '𑄎𑄛𑄚𑄩',
 			'Kali' => '𑄇𑄠𑄦𑄧𑄣𑄨',
 			'Kana' => '𑄇𑄑𑄇𑄚',
 			'Khar' => '𑄈𑄢𑄮𑄌𑄴𑄒𑄩',
 			'Khmr' => '𑄈𑄬𑄟𑄬𑄢𑄴',
 			'Knda' => '𑄇𑄚𑄢',
 			'Kore' => '𑄇𑄮𑄢𑄨𑄠𑄚𑄴',
 			'Kthi' => '𑄇𑄭𑄗𑄨',
 			'Lana' => '𑄣𑄚𑄳𑄦',
 			'Laoo' => '𑄣𑄃𑄮',
 			'Latf' => '𑄜𑄳𑄢𑄇𑄴𑄑𑄪𑄢𑄴 𑄣𑄳𑄠𑄑𑄨𑄚𑄴',
 			'Latg' => '𑄉𑄳𑄠𑄣𑄨𑄇𑄴 𑄣𑄳𑄠𑄑𑄨𑄚𑄴',
 			'Latn' => '𑄣𑄳𑄠𑄑𑄨𑄚𑄴',
 			'Lepc' => '𑄣𑄬𑄛𑄴𑄌',
 			'Limb' => '𑄣𑄨𑄟𑄴𑄝𑄪',
 			'Lina' => '𑄣𑄨𑄚𑄨𑄠𑄢𑄴 𑄆',
 			'Linb' => '𑄣𑄨𑄚𑄨𑄠𑄢𑄴 𑄝𑄨',
 			'Lyci' => '𑄣𑄭𑄥𑄨𑄠𑄚𑄴',
 			'Lydi' => '𑄣𑄭𑄓𑄨𑄠𑄚𑄴',
 			'Mand' => '𑄟𑄳𑄠𑄚𑄴𑄓𑄠𑄩𑄚𑄴',
 			'Mani' => '𑄟𑄳𑄠𑄚𑄨𑄌𑄭𑄚𑄴',
 			'Maya' => '𑄟𑄠𑄚𑄴 𑄦𑄠𑄢𑄮𑄉𑄳𑄣𑄨𑄛𑄴',
 			'Mero' => '𑄟𑄬𑄢𑄮𑄃𑄨𑄑𑄨𑄇𑄴',
 			'Mlym' => '𑄟𑄣𑄠𑄣𑄟𑄴',
 			'Mong' => '𑄟𑄮𑄋𑄴𑄉𑄮𑄣𑄩𑄠𑄧',
 			'Moon' => '𑄟𑄪𑄚𑄴',
 			'Mtei' => '𑄟𑄳𑄆𑄬𑄑𑄳𑄆𑄬 𑄟𑄠𑄬𑄇𑄴',
 			'Mymr' => '𑄟𑄠𑄚𑄴𑄟𑄢𑄴',
 			'Nkoo' => '𑄃𑄬𑄚𑄴𑄇𑄮',
 			'Ogam' => '𑄃𑄮𑄊𑄟𑄴',
 			'Olck' => '𑄃𑄮𑄣𑄴𑄌𑄨𑄇𑄨',
 			'Orkh' => '𑄃𑄧𑄢𑄴𑄈𑄮𑄚𑄴',
 			'Orya' => '𑄃𑄮𑄢𑄨𑄠',
 			'Osma' => '𑄃𑄮𑄥𑄟𑄚𑄨𑄠𑄧',
 			'Perm' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄛𑄢𑄴𑄟𑄨𑄇𑄴',
 			'Phag' => '𑄜𑄧𑄉𑄴𑄥𑄧-𑄛',
 			'Phli' => '𑄈𑄧𑄘𑄨𑄖𑄧 𑄛𑄳𑄦𑄣𑄧𑄞𑄩',
 			'Phlp' => '𑄥𑄧𑄣𑄴𑄑𑄢𑄴 𑄛𑄳𑄦𑄣𑄧𑄞𑄩',
 			'Phlv' => '𑄛𑄪𑄌𑄴𑄖𑄧𑄇𑄴 𑄛𑄳𑄦𑄣𑄧𑄞𑄩',
 			'Phnx' => '𑄜𑄨𑄚𑄨𑄥𑄩𑄠𑄧',
 			'Plrd' => '𑄛𑄮𑄣𑄢𑄴𑄓𑄧 𑄙𑄧𑄚𑄨𑄇𑄴',
 			'Prti' => '𑄛𑄢𑄴𑄗𑄨𑄠𑄧𑄚𑄴',
 			'Rjng' => '𑄢𑄬𑄎𑄳𑄠𑄋𑄴𑄉𑄧',
 			'Roro' => '𑄢𑄮𑄋𑄴𑄉𑄮𑄢𑄮𑄋𑄴𑄉𑄮',
 			'Runr' => '𑄢𑄪𑄚𑄨𑄇𑄴',
 			'Samr' => '𑄥𑄧𑄟𑄬𑄢𑄨𑄑𑄧𑄚𑄴',
 			'Sara' => '𑄥𑄢𑄖𑄨',
 			'Saur' => '𑄥𑄯𑄢𑄌𑄴𑄑𑄳𑄢𑄧',
 			'Sgnw' => '𑄌𑄨𑄚𑄴𑄦𑄧 𑄣𑄨𑄈𑄧𑄚𑄴',
 			'Shaw' => '𑄥𑄞𑄨𑄠𑄚𑄴',
 			'Sinh' => '𑄥𑄨𑄁𑄦𑄧𑄣𑄨',
 			'Sund' => '𑄥𑄚𑄴𑄘𑄚𑄨𑄎𑄴',
 			'Sylo' => '𑄥𑄨𑄣𑄬𑄑𑄨 𑄚𑄉𑄧𑄢𑄨',
 			'Syrc' => '𑄥𑄨𑄢𑄨𑄠𑄇𑄴',
 			'Syre' => '𑄃𑄬𑄌𑄴𑄑𑄳𑄢𑄬𑄋𑄴𑄉𑄬𑄣𑄮 𑄥𑄨𑄢𑄨𑄠𑄇𑄴',
 			'Syrj' => '𑄛𑄧𑄏𑄨𑄟𑄴𑄎𑄉𑄢𑄴 𑄥𑄨𑄢𑄨𑄠𑄇𑄴',
 			'Syrn' => '𑄛𑄪𑄇𑄴𑄎𑄉𑄧𑄢𑄴 𑄥𑄨𑄢𑄨𑄠𑄇𑄴',
 			'Tagb' => '𑄑𑄉𑄮𑄤𑄚',
 			'Tale' => '𑄖𑄭𑄣𑄬',
 			'Talu' => '𑄚𑄱 𑄖𑄭 𑄣𑄪',
 			'Taml' => '𑄖𑄟𑄨𑄣𑄴',
 			'Tavt' => '𑄖𑄭 𑄞𑄨𑄠𑄬𑄖𑄴',
 			'Telu' => '𑄖𑄬𑄣𑄬𑄉𑄪',
 			'Teng' => '𑄖𑄬𑄋𑄴𑄉𑄮𑄠𑄢𑄴',
 			'Tfng' => '𑄖𑄨𑄜𑄨𑄚𑄉𑄴',
 			'Tglg' => '𑄑𑄉𑄣𑄧𑄉𑄴',
 			'Thaa' => '𑄗𑄚',
 			'Thai' => '𑄗𑄭',
 			'Tibt' => '𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨',
 			'Ugar' => '𑄅𑄪𑄉𑄢𑄨𑄑𑄨𑄇𑄴',
 			'Vaii' => '𑄞𑄭',
 			'Visp' => '𑄘𑄬𑄉𑄧𑄎𑄭𑄘𑄳𑄠𑄬 𑄞𑄌𑄴',
 			'Xpeo' => '𑄛𑄪𑄢𑄮𑄚𑄴 𑄜𑄢𑄴𑄥𑄨',
 			'Xsux' => '𑄥𑄪𑄟𑄬𑄢𑄧-𑄃𑄇𑄳𑄇𑄘𑄩𑄠𑄧 𑄇𑄩𑄣𑄧𑄇𑄴𑄢𑄪𑄛𑄴',
 			'Yiii' => '𑄅𑄪𑄃𑄨',
 			'Zinh' => '𑄇𑄭',
 			'Zmth' => '𑄚𑄘𑄞𑄬𑄖𑄴 𑄌𑄨𑄚𑄴𑄦𑄧',
 			'Zsye' => '𑄃𑄨𑄟𑄮𑄎𑄨',
 			'Zsym' => '𑄍𑄪𑄝𑄨𑄉𑄪𑄚𑄴',
 			'Zxxx' => '𑄚𑄧𑄣𑄬𑄇𑄴𑄈𑄳𑄠𑄬',
 			'Zyyy' => '𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴',
 			'Zzzz' => '𑄦𑄧𑄝𑄧𑄢𑄴𑄚𑄧𑄛𑄨𑄠𑄬 𑄦𑄧𑄢𑄧𑄇𑄴',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'001' => '𑄛𑄨𑄖𑄴𑄗𑄨𑄟𑄨',
 			'002' => '𑄃𑄜𑄳𑄢𑄨𑄇',
 			'003' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇',
 			'005' => '𑄘𑄨𑄉𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇',
 			'009' => '𑄃𑄮𑄥𑄨𑄠𑄚𑄨𑄠',
 			'011' => '𑄛𑄧𑄏𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇',
 			'013' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇',
 			'014' => '𑄛𑄪𑄇𑄴𑄘𑄩 𑄃𑄜𑄳𑄢𑄨𑄇',
 			'015' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄃𑄜𑄳𑄢𑄨𑄇',
 			'017' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇',
 			'018' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇 𑄎𑄉',
 			'019' => '𑄃𑄟𑄬𑄢𑄨𑄇𑄥𑄴',
 			'021' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄎𑄉𑄢𑄴 𑄃𑄟𑄬𑄢𑄨𑄇',
 			'029' => '𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴',
 			'030' => '𑄛𑄪𑄉𑄬𑄘𑄩 𑄃𑄬𑄥𑄨𑄠',
 			'034' => '𑄘𑄧𑄉𑄨𑄚𑄬 𑄃𑄬𑄥𑄨𑄠',
 			'035' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄛𑄪𑄇𑄴 𑄃𑄬𑄥𑄨𑄠',
 			'039' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴',
 			'053' => '𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄬𑄥𑄨𑄠',
 			'054' => '𑄟𑄳𑄠𑄣𑄬𑄚𑄬𑄥𑄨𑄠',
 			'057' => '𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠 𑄎𑄉',
 			'061' => '𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠',
 			'142' => '𑄃𑄬𑄥𑄨𑄠',
 			'143' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄬𑄥𑄨𑄠',
 			'145' => '𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄬𑄥𑄨𑄠',
 			'150' => '𑄄𑄃𑄪𑄢𑄮𑄛𑄴',
 			'151' => '𑄛𑄪𑄉𑄬𑄘𑄨 𑄄𑄃𑄪𑄢𑄮𑄛𑄴',
 			'154' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴',
 			'155' => '𑄛𑄧𑄎𑄨𑄟𑄴 𑄄𑄃𑄪𑄢𑄮𑄛𑄴',
 			'419' => '𑄣𑄳𑄠𑄑𑄨𑄚𑄴 𑄃𑄟𑄬𑄢𑄨𑄇',
 			'AC' => '𑄃𑄳𑄠𑄥𑄴𑄥𑄬𑄚𑄴𑄥𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'AD' => '𑄃𑄚𑄴𑄓𑄮𑄢',
 			'AE' => '𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴',
 			'AF' => '𑄃𑄛𑄴𑄉𑄚𑄨𑄌𑄴𑄖𑄚𑄴',
 			'AG' => '𑄆𑄚𑄴𑄖𑄨𑄉𑄱 𑄃𑄮 𑄝𑄢𑄴𑄟𑄪𑄓',
 			'AI' => '𑄄𑄳𑄠𑄋𑄴𑄉𑄪𑄃𑄨𑄣',
 			'AL' => '𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠',
 			'AM' => '𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠',
 			'AO' => '𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣',
 			'AQ' => '𑄃𑄳𑄠𑄚𑄴𑄑𑄢𑄴𑄇𑄧𑄑𑄨𑄇',
 			'AR' => '𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚',
 			'AS' => '𑄃𑄟𑄬𑄢𑄨𑄇𑄚𑄴 𑄥𑄟𑄮𑄠',
 			'AT' => '𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠',
 			'AU' => '𑄃𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠',
 			'AW' => '𑄃𑄢𑄪𑄝',
 			'AX' => '𑄃𑄣𑄚𑄴𑄓𑄧 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'AZ' => '𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴',
 			'BA' => '𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄮 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚',
 			'BB' => '𑄝𑄢𑄴𑄝𑄘𑄮𑄌𑄴',
 			'BD' => '𑄝𑄁𑄣𑄘𑄬𑄌𑄴',
 			'BE' => '𑄝𑄬𑄣𑄴𑄎𑄨𑄠𑄟𑄴',
 			'BF' => '𑄝𑄪𑄢𑄴𑄇𑄨𑄚 𑄜𑄥𑄮',
 			'BG' => '𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄨𑄠',
 			'BH' => '𑄝𑄦𑄧𑄢𑄭𑄚𑄴',
 			'BI' => '𑄝𑄪𑄢𑄪𑄚𑄴𑄘𑄨',
 			'BJ' => '𑄝𑄬𑄚𑄨𑄚𑄴',
 			'BL' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄝𑄢𑄴𑄗𑄬𑄣𑄨𑄟𑄨',
 			'BM' => '𑄝𑄢𑄴𑄟𑄪𑄓',
 			'BN' => '𑄝𑄳𑄢𑄪𑄚𑄬𑄭',
 			'BO' => '𑄝𑄧𑄣𑄨𑄞𑄨𑄠',
 			'BQ' => '𑄇𑄳𑄠𑄢𑄨𑄝𑄨𑄠𑄚𑄴 𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄧𑄥𑄴',
 			'BR' => '𑄝𑄳𑄢𑄎𑄨𑄣𑄴',
 			'BS' => '𑄝𑄦𑄟 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'BT' => '𑄞𑄪𑄑𑄚𑄴',
 			'BV' => '𑄝𑄮𑄞𑄬𑄑𑄴 𑄞𑄨𑄘𑄳𑄠',
 			'BW' => '𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚',
 			'BY' => '𑄝𑄬𑄣𑄢𑄪𑄌𑄴',
 			'BZ' => '𑄝𑄬𑄣𑄨𑄎𑄴',
 			'CA' => '𑄇𑄚𑄓',
 			'CC' => '𑄇𑄮𑄇𑄮𑄌𑄴 (𑄇𑄨𑄣𑄨𑄁) 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'CD' => '𑄇𑄧𑄋𑄴𑄉𑄮-𑄚𑄨𑄇𑄴𑄥𑄥',
 			'CD@alt=variant' => '𑄇𑄧𑄋𑄴𑄉𑄮(DRC)',
 			'CF' => '𑄟𑄧𑄖𑄴𑄙𑄳𑄠𑄧 𑄃𑄜𑄳𑄢𑄨𑄇𑄢𑄴𑄛𑄳𑄢𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧',
 			'CG' => '𑄇𑄧𑄋𑄴𑄉𑄮-𑄝𑄳𑄢𑄎𑄞𑄨𑄣𑄴',
 			'CG@alt=variant' => '𑄇𑄧𑄋𑄴𑄉𑄮 (𑄛𑄳𑄢𑄎𑄖𑄚𑄴𑄖𑄳𑄢𑄧)',
 			'CH' => '𑄥𑄭𑄪𑄎𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'CI' => '𑄃𑄭𑄞𑄧𑄢𑄨 𑄇𑄮𑄌𑄴𑄑𑄴',
 			'CI@alt=variant' => '𑄃𑄭𑄞𑄧𑄢𑄨',
 			'CK' => '𑄇𑄪𑄇𑄪 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'CL' => '𑄌𑄨𑄣𑄨',
 			'CM' => '𑄇𑄳𑄠𑄟𑄬𑄢𑄪𑄚𑄴',
 			'CN' => '𑄌𑄩𑄚𑄴',
 			'CO' => '𑄃𑄣𑄧𑄟𑄴𑄝𑄨𑄠',
 			'CP' => '𑄇𑄳𑄣𑄨𑄛𑄢𑄴𑄑𑄧𑄚𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄳𑄓𑄴',
 			'CR' => '𑄇𑄮𑄥𑄳𑄑𑄢𑄨𑄇',
 			'CU' => '𑄇𑄨𑄃𑄪𑄝',
 			'CV' => '𑄇𑄬𑄛𑄴𑄞𑄢𑄴𑄘𑄬',
 			'CW' => '𑄇𑄨𑄃𑄪𑄢𑄥𑄃𑄮',
 			'CX' => '𑄇𑄳𑄢𑄨𑄥𑄴𑄟𑄥𑄴 𑄞𑄨𑄘𑄳𑄠',
 			'CY' => '𑄥𑄭𑄛𑄳𑄢𑄥𑄴',
 			'CZ' => '𑄌𑄬𑄌𑄨𑄠',
 			'CZ@alt=variant' => '𑄌𑄬𑄇𑄴 𑄛𑄳𑄢𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧',
 			'DE' => '𑄎𑄢𑄴𑄟𑄚𑄨',
 			'DG' => '𑄘𑄨𑄠𑄬𑄉𑄮 𑄉𑄢𑄴𑄥𑄨𑄠',
 			'DJ' => '𑄎𑄨𑄝𑄪𑄖𑄨',
 			'DK' => '𑄓𑄬𑄚𑄴𑄟𑄢𑄴𑄇𑄧',
 			'DM' => '𑄓𑄮𑄟𑄨𑄚𑄨𑄇',
 			'DO' => '𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧',
 			'DZ' => '𑄃𑄢𑄴𑄎𑄬𑄢𑄨𑄠',
 			'EA' => '𑄇𑄪𑄃𑄪𑄑 𑄃𑄳𑄃 𑄟𑄬𑄣𑄨𑄣',
 			'EC' => '𑄄𑄇𑄪𑄠𑄬𑄓𑄧𑄢𑄴',
 			'EE' => '𑄆𑄌𑄴𑄖𑄮𑄚𑄨𑄠',
 			'EG' => '𑄟𑄨𑄥𑄧𑄢𑄴',
 			'EH' => '𑄛𑄧𑄎𑄨𑄟𑄴 𑄥𑄦𑄢',
 			'ER' => '𑄄𑄢𑄨𑄖𑄳𑄢𑄨𑄠',
 			'ES' => '𑄥𑄳𑄛𑄬𑄚𑄴',
 			'ET' => '𑄃𑄨𑄜𑄨𑄃𑄮𑄛𑄨𑄠',
 			'EU' => '𑄄𑄃𑄪𑄢𑄮𑄛𑄩𑄠𑄧 𑄄𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴',
 			'FI' => '𑄜𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'FJ' => '𑄜𑄨𑄎𑄨',
 			'FK' => '𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'FK@alt=variant' => '𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴 (𑄄𑄥𑄴𑄣𑄳𑄠𑄌𑄴 𑄟𑄥𑄴𑄞𑄬𑄚𑄨𑄌𑄴)',
 			'FM' => '𑄟𑄭𑄇𑄳𑄢𑄮𑄚𑄬𑄥𑄨𑄠',
 			'FO' => '𑄜𑄳𑄠𑄢𑄧𑄃𑄮 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'FR' => '𑄜𑄳𑄢𑄚𑄴𑄥𑄴',
 			'GA' => '𑄉𑄳𑄠𑄝𑄧𑄚𑄴',
 			'GB' => '𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮',
 			'GB@alt=short' => '𑄄𑄃𑄪𑄇𑄬',
 			'GD' => '𑄉𑄳𑄢𑄬𑄚𑄓',
 			'GE' => '𑄎𑄧𑄢𑄴𑄎𑄨𑄠',
 			'GF' => '𑄜𑄧𑄢𑄥𑄩 𑄉𑄠𑄚',
 			'GG' => '𑄉𑄳𑄢𑄚𑄴𑄏𑄨',
 			'GH' => '𑄊𑄚',
 			'GI' => '𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴',
 			'GL' => '𑄉𑄳𑄢𑄩𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'GM' => '𑄉𑄟𑄴𑄝𑄨𑄠',
 			'GN' => '𑄉𑄨𑄚𑄨',
 			'GP' => '𑄉𑄪𑄠𑄘𑄬𑄣𑄯𑄛𑄴',
 			'GQ' => '𑄚𑄨𑄢𑄧𑄇𑄴𑄈𑄩𑄠𑄧 𑄉𑄨𑄚𑄨',
 			'GR' => '𑄉𑄳𑄢𑄨𑄌𑄴',
 			'GS' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄮 𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄳𑄠𑄚𑄴𑄓𑄃𑄪𑄃𑄨𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'GT' => '𑄉𑄪𑄠𑄖𑄬𑄟𑄣',
 			'GU' => '𑄉𑄪𑄠𑄟𑄴',
 			'GW' => '𑄉𑄨𑄚𑄨-𑄝𑄨𑄥𑄃𑄪',
 			'GY' => '𑄉𑄨𑄠𑄚',
 			'HK' => '𑄦𑄧𑄁𑄇𑄧𑄁 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚',
 			'HK@alt=short' => '𑄦𑄧𑄁𑄇𑄧𑄁',
 			'HM' => '𑄦𑄢𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠 𑄃𑄳𑄃 𑄟𑄳𑄠𑄇𑄴𑄓𑄮𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'HN' => '𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴',
 			'HR' => '𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠',
 			'HT' => '𑄦𑄭𑄖𑄨',
 			'HU' => '𑄦𑄧𑄋𑄴𑄉𑄬𑄢𑄨',
 			'IC' => '𑄇𑄳𑄠𑄚𑄢𑄨 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'ID' => '𑄄𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠',
 			'IE' => '𑄃𑄠𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'IL' => '𑄄𑄎𑄴𑄢𑄠𑄬𑄣𑄴',
 			'IM' => '𑄃𑄭𑄣𑄴 𑄃𑄧𑄜𑄴 𑄟𑄳𑄠𑄚𑄴',
 			'IN' => '𑄞𑄢𑄧𑄖𑄴',
 			'IO' => '𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄧𑄖𑄴 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄨𑄠𑄧 𑄞𑄨𑄘𑄳𑄠',
 			'IQ' => '𑄄𑄢𑄇𑄴',
 			'IR' => '𑄄𑄢𑄚𑄴',
 			'IS' => '𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'IT' => '𑄄𑄖𑄣𑄨',
 			'JE' => '𑄎𑄢𑄴𑄥𑄨',
 			'JM' => '𑄎𑄟𑄭𑄇',
 			'JO' => '𑄎𑄧𑄢𑄴𑄓𑄧𑄚𑄴',
 			'JP' => '𑄎𑄛𑄚𑄴',
 			'KE' => '𑄇𑄬𑄚𑄨𑄠',
 			'KG' => '𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄨𑄌𑄴𑄖𑄚𑄴',
 			'KH' => '𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠',
 			'KI' => '𑄇𑄨𑄢𑄨𑄝𑄖𑄨',
 			'KM' => '𑄇𑄧𑄟𑄮𑄢𑄮𑄌𑄴',
 			'KN' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄇𑄨𑄑𑄴𑄥𑄴 𑄃𑄮 𑄚𑄬𑄞𑄨𑄌𑄴',
 			'KP' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠',
 			'KR' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠',
 			'KW' => '𑄇𑄪𑄠𑄬𑄖𑄴',
 			'KY' => '𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'KZ' => '𑄇𑄎𑄈𑄌𑄴𑄖𑄚𑄴',
 			'LA' => '𑄣𑄃𑄮𑄌𑄴',
 			'LB' => '𑄣𑄬𑄝𑄚𑄧𑄚𑄴',
 			'LC' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄣𑄪𑄥𑄨𑄠',
 			'LI' => '𑄣𑄨𑄌𑄬𑄚𑄴𑄥𑄳𑄑𑄬𑄃𑄨𑄚𑄴',
 			'LK' => '𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇',
 			'LR' => '𑄃𑄭𑄝𑄬𑄢𑄨𑄠',
 			'LS' => '𑄣𑄬𑄥𑄮𑄗𑄮',
 			'LT' => '𑄣𑄨𑄗𑄪𑄠𑄚𑄨𑄠',
 			'LU' => '𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄧',
 			'LV' => '𑄣𑄖𑄴𑄞𑄨𑄠',
 			'LY' => '𑄣𑄨𑄝𑄨𑄠',
 			'MA' => '𑄟𑄮𑄢𑄧𑄇𑄴𑄇𑄮',
 			'MC' => '𑄟𑄮𑄚𑄇𑄮',
 			'MD' => '𑄟𑄮𑄣𑄴𑄘𑄞𑄨𑄠',
 			'ME' => '𑄟𑄧𑄚𑄴𑄑𑄨𑄚𑄨𑄉𑄳𑄢𑄮',
 			'MF' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄨𑄚𑄴',
 			'MG' => '𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴',
 			'MH' => '𑄟𑄢𑄴𑄥𑄣𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'MK' => '𑄟𑄳𑄠𑄥𑄓𑄮𑄚𑄨𑄠',
 			'MK@alt=variant' => '𑄟𑄬𑄥𑄨𑄓𑄮𑄚𑄠(FYROM)',
 			'ML' => '𑄟𑄣𑄨',
 			'MM' => '𑄟𑄠𑄚𑄴𑄟𑄢𑄴 (𑄝𑄢𑄴𑄟)',
 			'MN' => '𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠',
 			'MO' => '𑄟𑄳𑄠𑄇𑄃𑄮 𑄆𑄌𑄴𑄃𑄬𑄃𑄢𑄴 𑄌𑄩𑄚',
 			'MO@alt=short' => '𑄟𑄳𑄠𑄇𑄃𑄮',
 			'MP' => '𑄅𑄪𑄖𑄴𑄖𑄮𑄉𑄎𑄢𑄴 𑄟𑄢𑄨𑄠𑄚 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'MQ' => '𑄟𑄢𑄴𑄑𑄨𑄚𑄨𑄇𑄴',
 			'MR' => '𑄟𑄧𑄢𑄨𑄖𑄚𑄨𑄠',
 			'MS' => '𑄟𑄧𑄚𑄴𑄑𑄴𑄥𑄬𑄢𑄑𑄴',
 			'MT' => '𑄟𑄣𑄴𑄑',
 			'MU' => '𑄟𑄧𑄢𑄨𑄥𑄥𑄴',
 			'MV' => '𑄟𑄣𑄴𑄘𑄨𑄛𑄴',
 			'MW' => '𑄟𑄣𑄃𑄪𑄃𑄨',
 			'MX' => '𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮',
 			'MY' => '𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠',
 			'MZ' => '𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴',
 			'NA' => '𑄚𑄟𑄨𑄝𑄨𑄠',
 			'NC' => '𑄚𑄱 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠',
 			'NE' => '𑄚𑄭𑄎𑄢𑄴',
 			'NF' => '𑄚𑄨𑄢𑄴𑄜𑄮𑄇𑄴 𑄞𑄨𑄘𑄳𑄠',
 			'NG' => '𑄚𑄭𑄎𑄬𑄢𑄨𑄠',
 			'NI' => '𑄚𑄨𑄇𑄢𑄉𑄪𑄠',
 			'NL' => '𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴𑄥𑄴',
 			'NO' => '𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬',
 			'NP' => '𑄚𑄬𑄛𑄣𑄴',
 			'NR' => '𑄚𑄃𑄪𑄢𑄪',
 			'NU' => '𑄚𑄨𑄃𑄪𑄠𑄬',
 			'NZ' => '𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'OM' => '𑄃𑄮𑄟𑄚𑄴',
 			'PA' => '𑄛𑄚𑄟',
 			'PE' => '𑄛𑄬𑄢𑄪',
 			'PF' => '𑄜𑄧𑄢𑄥𑄩 𑄛𑄧𑄣𑄨𑄚𑄬𑄥𑄨𑄠',
 			'PG' => '𑄛𑄛𑄪𑄠 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨',
 			'PH' => '𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴',
 			'PK' => '𑄛𑄇𑄨𑄌𑄴𑄖𑄚𑄴',
 			'PL' => '𑄛𑄮𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'PM' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄢𑄪𑄠𑄬𑄣𑄧𑄚𑄴',
 			'PN' => '𑄛𑄨𑄇𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'PR' => '𑄛𑄪𑄠𑄬𑄢𑄴𑄖𑄮 𑄢𑄨𑄇𑄮',
 			'PS' => '𑄜𑄨𑄣𑄨𑄌𑄴𑄖𑄨𑄚𑄴 𑄎𑄉𑄊𑄚𑄨',
 			'PS@alt=short' => '𑄜𑄨𑄣𑄨𑄌𑄴𑄖𑄨𑄚𑄴',
 			'PT' => '𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄣𑄴',
 			'PW' => '𑄛𑄣𑄃𑄪',
 			'PY' => '𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬',
 			'QA' => '𑄇𑄖𑄢𑄴',
 			'QO' => '𑄃𑄅𑄪𑄑𑄣𑄭𑄚𑄨𑄁 𑄃𑄮𑄥𑄚𑄨𑄠',
 			'RE' => '𑄢𑄨𑄃𑄨𑄃𑄪𑄚𑄨𑄠𑄧𑄚𑄴',
 			'RO' => '𑄢𑄮𑄟𑄚𑄨𑄠',
 			'RS' => '𑄥𑄢𑄴𑄝𑄨𑄠',
 			'RU' => '𑄢𑄥𑄨𑄠',
 			'RW' => '𑄢𑄪𑄠𑄚𑄴𑄓',
 			'SA' => '𑄥𑄯𑄘𑄨 𑄃𑄢𑄧𑄝𑄴',
 			'SB' => '𑄥𑄧𑄣𑄮𑄟𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'SC' => '𑄥𑄨𑄥𑄨𑄣𑄨',
 			'SD' => '𑄥𑄪𑄘𑄚𑄴',
 			'SE' => '𑄥𑄭𑄪𑄓𑄬𑄚𑄴',
 			'SG' => '𑄥𑄨𑄋𑄴𑄉𑄛𑄪𑄢𑄴',
 			'SH' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄦𑄬𑄣𑄬𑄚',
 			'SI' => '𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠',
 			'SJ' => '𑄥𑄣𑄴𑄝𑄢𑄴𑄓𑄴 𑄃𑄮 𑄎𑄚𑄴 𑄟𑄬𑄠𑄬𑄚𑄴',
 			'SK' => '𑄥𑄳𑄣𑄮𑄞𑄇𑄨𑄠',
 			'SL' => '𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄃𑄮𑄚𑄴',
 			'SM' => '𑄥𑄚𑄴 𑄟𑄢𑄨𑄚𑄮',
 			'SN' => '𑄥𑄬𑄚𑄬𑄉𑄣𑄴',
 			'SO' => '𑄥𑄮𑄟𑄣𑄨𑄠',
 			'SR' => '𑄥𑄪𑄢𑄨𑄚𑄟𑄴',
 			'SS' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄴',
 			'ST' => '𑄥𑄃𑄮𑄑𑄟 𑄃𑄮 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄨',
 			'SV' => '𑄆𑄣𑄴 𑄥𑄣𑄴𑄞𑄬𑄘𑄧𑄢𑄴',
 			'SX' => '𑄥𑄨𑄚𑄴𑄑𑄴 𑄟𑄢𑄴𑄑𑄬𑄚𑄴',
 			'SY' => '𑄥𑄨𑄢𑄨𑄠',
 			'SZ' => '𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'TA' => '𑄑𑄳𑄢𑄌𑄴𑄑𑄚𑄴 𑄓 𑄇𑄪𑄚𑄴𑄦',
 			'TC' => '𑄖𑄪𑄢𑄴𑄇𑄧𑄌𑄴 𑄃𑄮 𑄇𑄭𑄇𑄮𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'TD' => '𑄌𑄘𑄴',
 			'TF' => '𑄜𑄢𑄥𑄩 𑄘𑄧𑄉𑄨𑄚𑄧 𑄎𑄉',
 			'TG' => '𑄑𑄮𑄉𑄮',
 			'TH' => '𑄗𑄭𑄣𑄳𑄠𑄚𑄴𑄓𑄴',
 			'TJ' => '𑄖𑄎𑄨𑄇𑄴𑄥𑄳𑄗𑄚𑄴',
 			'TK' => '𑄑𑄮𑄇𑄬𑄣𑄃𑄪',
 			'TL' => '𑄖𑄨𑄟𑄪𑄢𑄴-𑄣𑄬𑄌𑄴𑄖𑄬',
 			'TL@alt=variant' => '𑄛𑄪𑄉𑄮 𑄖𑄨𑄟𑄪𑄢𑄴',
 			'TM' => '𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴',
 			'TN' => '𑄖𑄨𑄃𑄪𑄚𑄨𑄥𑄨𑄠',
 			'TO' => '𑄑𑄮𑄋𑄴𑄉',
 			'TR' => '𑄖𑄪𑄢𑄧𑄌𑄴𑄇𑄧',
 			'TT' => '𑄖𑄳𑄢𑄨𑄚𑄨𑄚𑄘𑄴 𑄃𑄮 𑄑𑄮𑄝𑄳𑄠𑄉𑄮',
 			'TV' => '𑄑𑄪𑄞𑄣𑄪',
 			'TW' => '𑄖𑄭𑄤𑄚𑄴',
 			'TZ' => '𑄖𑄚𑄴𑄎𑄚𑄨𑄠',
 			'UA' => '𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄬𑄚𑄴',
 			'UG' => '𑄅𑄉𑄚𑄴𑄓',
 			'UM' => '𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄦𑄭𑄇𑄪𑄢𑄬 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'UN' => '𑄎𑄘𑄨𑄥𑄧𑄁𑄊𑄧',
 			'UN@alt=short' => '𑄃𑄨𑄃𑄪𑄃𑄬𑄚𑄴',
 			'US' => '𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮',
 			'US@alt=short' => '𑄃𑄨𑄃𑄪𑄃𑄬𑄌𑄴',
 			'UY' => '𑄅𑄪𑄢𑄪𑄉𑄪𑄠𑄬',
 			'UZ' => '𑄅𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄴',
 			'VA' => '𑄞𑄳𑄠𑄑𑄨𑄇𑄚𑄴 𑄥𑄨𑄑𑄨',
 			'VC' => '𑄥𑄬𑄚𑄴𑄑𑄴 𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄑𑄴 𑄃𑄮 𑄘𑄳𑄠 𑄉𑄳𑄢𑄬𑄚𑄓𑄨𑄚𑄴𑄥𑄴',
 			'VE' => '𑄞𑄬𑄚𑄬𑄎𑄪𑄠𑄬𑄣',
 			'VG' => '𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'VI' => '𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄞𑄢𑄴𑄎𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄳𑄠',
 			'VN' => '𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄴',
 			'VU' => '𑄞𑄚𑄪𑄠𑄑𑄪',
 			'WF' => '𑄤𑄣𑄨𑄌𑄴 𑄃𑄮 𑄜𑄪𑄑𑄪𑄚',
 			'WS' => '𑄥𑄟𑄮𑄠',
 			'XK' => '𑄇𑄧𑄥𑄮𑄞𑄮',
 			'YE' => '𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄴',
 			'YT' => '𑄟𑄠𑄮𑄖𑄴𑄖𑄬',
 			'ZA' => '𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇',
 			'ZM' => '𑄎𑄟𑄴𑄝𑄨𑄠',
 			'ZW' => '𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬',
 			'ZZ' => '𑄃𑄨𑄌𑄨𑄚𑄴 𑄎𑄉',

		}
	},
);

has 'display_name_variant' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'PINYIN' => '𑄛𑄨𑄚𑄴𑄃𑄨𑄚𑄴 𑄟𑄮𑄟𑄚𑄭𑄎𑄬𑄥𑄧𑄚𑄴',
 			'WADEGILE' => '𑄤𑄘𑄬-𑄉𑄨𑄣𑄬𑄌𑄴 𑄢𑄮𑄟𑄚𑄭𑄎𑄬𑄥𑄧𑄚𑄴',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'calendar' => '𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴',
 			'cf' => '𑄟𑄪𑄖𑄴𑄘𑄳𑄢 𑄜𑄧𑄢𑄴𑄟𑄳𑄠𑄑𑄴',
 			'colalternate' => '𑄝𑄌𑄴𑄥𑄬𑄭 𑄗𑄉𑄴 𑄍𑄪𑄝𑄨 𑄝𑄬𑄭 𑄣𑄧𑄞𑄢𑄴 𑄃𑄏𑄠𑄴',
 			'colbackwards' => '𑄅𑄪𑄣𑄴𑄣𑄮𑄛𑄣𑄳𑄦𑄴 𑄢𑄳𑄦𑄧 𑄖𑄮𑄉𑄬𑄭 𑄣𑄧𑄚',
 			'colcasefirst' => '𑄝𑄧𑄢𑄴𑄦𑄘𑄧𑄢𑄴/𑄥𑄨𑄉𑄮𑄚𑄴𑄦𑄘𑄧𑄢𑄴 𑄦𑄧𑄢𑄧𑄉𑄪𑄢𑄴 𑄥𑄪𑄢𑄴𑄣𑄭𑄚𑄴',
 			'colcaselevel' => '𑄇𑄬𑄌𑄴 𑄥𑄧𑄁𑄝𑄬𑄘𑄩 𑄝𑄬𑄭 𑄣𑄧𑄚',
 			'collation' => '𑄝𑄬𑄭𑄣𑄧𑄚𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴',
 			'colnormalization' => '𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴𑄥𑄬 𑄝𑄬𑄭𑄣𑄧𑄚',
 			'colnumeric' => '𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠𑄬 𑄝𑄬𑄭𑄣𑄧𑄚',
 			'colstrength' => '𑄝𑄬𑄭𑄣𑄧𑄚𑄢𑄴 𑄝𑄧𑄣𑄴',
 			'currency' => '𑄑𑄬𑄋-𑄛𑄧𑄠𑄴𑄎𑄳𑄠',
 			'hc' => '𑄃𑄧𑄇𑄴𑄖𑄧𑄢𑄴 𑄃𑄨𑄏𑄬𑄛𑄴 (𑄷𑄸 𑄃𑄳𑄃 𑄸𑄺)',
 			'lb' => '𑄣𑄃𑄨𑄚𑄴 𑄞𑄉𑄴𑄉𑄧𑄢𑄚𑄢𑄴 𑄃𑄨𑄌𑄴𑄑𑄭𑄣𑄴',
 			'ms' => '𑄟𑄝𑄚𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴',
 			'numbers' => '𑄚𑄘𑄅𑄪𑄚𑄴',
 			'timezone' => '𑄃𑄧𑄇𑄴𑄖𑄧 𑄎𑄮𑄚𑄴',
 			'va' => '𑄃𑄨𑄘𑄪𑄉𑄮𑄢𑄴 𑄚𑄚𑄝𑄝𑄧𑄖𑄳𑄠',
 			'x' => '𑄃𑄟𑄧𑄚𑄧𑄢𑄴-𑄣𑄢𑄴𑄌𑄢𑄴',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{𑄝𑄪𑄖𑄴𑄙𑄮 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'chinese' => q{𑄌𑄨𑄚 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'coptic' => q{𑄇𑄧𑄛𑄴𑄑𑄨𑄇𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'dangi' => q{𑄓𑄋𑄴𑄉𑄨 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'ethiopic' => q{𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄇𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'ethiopic-amete-alem' => q{𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄃𑄮 𑄃𑄟𑄬𑄖𑄬 𑄃𑄣𑄬𑄟𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'gregorian' => q{𑄉𑄳𑄢𑄉𑄮𑄢𑄨𑄠𑄚𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'hebrew' => q{𑄦𑄨𑄝𑄳𑄢𑄪 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'indian' => q{𑄞𑄢𑄧𑄘𑄧𑄢𑄴 𑄎𑄖𑄩𑄠𑄧 𑄝𑄧𑄢𑄴𑄥𑄧𑄛𑄧𑄚𑄴𑄏𑄩},
 				'islamic' => q{𑄃𑄨𑄥𑄴𑄣𑄟𑄨𑄇𑄴 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'islamic-civil' => q{𑄃𑄨𑄥𑄴𑄣𑄟𑄨𑄇𑄴-𑄥𑄨𑄞𑄨𑄣𑄴 𑄝𑄧𑄢𑄴𑄥𑄧𑄛𑄧𑄚𑄴𑄏𑄩},
 				'iso8601' => q{ISO-861 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'japanese' => q{𑄎𑄛𑄚𑄨 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'persian' => q{𑄜𑄢𑄴𑄥𑄨 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 				'roc' => q{𑄟𑄨𑄁𑄉𑄪𑄃𑄮 𑄇𑄳𑄠𑄣𑄬𑄚𑄴𑄓𑄢𑄴},
 			},
 			'cf' => {
 				'account' => q{𑄑𑄬𑄋𑄛𑄧𑄠𑄴𑄎𑄳𑄠 𑄃𑄨𑄏𑄬𑄝𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴},
 				'standard' => q{𑄟𑄚𑄧𑄇𑄴 𑄑𑄬𑄋𑄛𑄧𑄠𑄴𑄎𑄳𑄠𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{𑄍𑄪𑄝𑄨 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'shifted' => q{𑄝𑄌𑄴𑄥𑄬𑄭𑄗𑄚 𑄍𑄪𑄝𑄨 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'colbackwards' => {
 				'no' => q{𑄢𑄳𑄦𑄧𑄉𑄪𑄚𑄴 𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴𑄥𑄳𑄠𑄉𑄧𑄢𑄨 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'yes' => q{𑄢𑄳𑄦𑄧𑄉𑄪𑄚𑄴 𑄅𑄪𑄣𑄴𑄣𑄮𑄛𑄣𑄳𑄦𑄴 𑄉𑄧𑄢𑄨 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'colcasefirst' => {
 				'lower' => q{𑄜𑄪𑄣𑄴𑄣𑄳𑄠𑄬 𑄥𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄦𑄧𑄢𑄧𑄇𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'no' => q{𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴 𑄇𑄬𑄥𑄴 𑄇𑄳𑄢𑄧𑄟𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'upper' => q{𑄜𑄪𑄣𑄴𑄣𑄳𑄠𑄬 𑄝𑄧𑄢𑄧𑄦𑄘𑄧𑄢𑄴 𑄦𑄧𑄢𑄧𑄇𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'colcaselevel' => {
 				'no' => q{𑄇𑄬𑄥𑄴 𑄃𑄧𑄥𑄧𑄁𑄝𑄬𑄘𑄩 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'yes' => q{𑄇𑄬𑄥𑄴 𑄥𑄧𑄁𑄝𑄘𑄩 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'collation' => {
 				'big5han' => q{𑄛𑄳𑄢𑄧𑄗𑄉𑄧𑄖𑄧 𑄌𑄩𑄚 𑄥𑄧𑄎𑄴𑄎𑄇𑄳𑄢𑄟𑄴-𑄝𑄨𑄉𑄴𑄻},
 				'dictionary' => q{𑄇𑄧𑄙𑄖𑄢 𑄝𑄬𑄭𑄣𑄧𑄚𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴},
 				'ducet' => q{𑄓𑄨𑄜𑄧𑄣𑄴𑄑𑄴 𑄃𑄨𑄃𑄪𑄚𑄨𑄇𑄮𑄓𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'gb2312han' => q{𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴 𑄌𑄩𑄚 𑄥𑄎𑄚-𑄎𑄨𑄝𑄨𑄸𑄹𑄷𑄸},
 				'phonebook' => q{𑄜𑄮𑄚𑄴𑄝𑄪𑄇𑄴 𑄥𑄎𑄚},
 				'phonetic' => q{𑄢𑄳𑄦𑄧 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'pinyin' => q{𑄛𑄨𑄚𑄨𑄚𑄴 𑄥𑄎𑄚},
 				'reformed' => q{𑄢𑄨𑄜𑄧𑄟𑄴𑄓𑄨 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'search' => q{𑄃𑄧𑄎𑄧𑄃𑄧𑄌𑄴-𑄅𑄪𑄘𑄨𑄌𑄴𑄥𑄳𑄠 𑄖𑄮𑄉𑄚},
 				'searchjl' => q{𑄦𑄋𑄴𑄉𑄪𑄣𑄴 𑄛𑄧𑄖𑄴𑄗𑄧𑄟𑄴 𑄝𑄧𑄣𑄬𑄟𑄖𑄳𑄠𑄬 𑄦𑄧𑄢𑄧𑄇𑄴 𑄘𑄨𑄚𑄬𑄭 𑄖𑄮𑄉𑄚},
 				'standard' => q{𑄉𑄧𑄟𑄴 𑄘𑄮𑄣𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'stroke' => q{𑄊𑄪𑄎𑄳𑄠𑄛𑄪𑄏𑄳𑄠 𑄥𑄎𑄬𑄭𑄗𑄧𑄚},
 				'traditional' => q{𑄛𑄳𑄢𑄧𑄗𑄉𑄧𑄖𑄧 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'unihan' => q{𑄢𑄓𑄨𑄇𑄬𑄣𑄴 𑄃𑄨𑄌𑄴𑄑𑄳𑄢𑄮𑄇𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'colnormalization' => {
 				'no' => q{𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴 𑄍𑄢 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'yes' => q{𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴 𑄃𑄨𑄃𑄪𑄚𑄨𑄇𑄮𑄓𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'colnumeric' => {
 				'no' => q{𑄚𑄘 𑄜𑄢𑄧𑄇𑄴𑄉𑄧𑄢𑄨 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'yes' => q{𑄚𑄘 𑄚𑄘𑄘𑄬𑄇𑄳𑄠 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'colstrength' => {
 				'identical' => q{𑄝𑄬𑄇𑄴𑄅𑄚𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'primary' => q{𑄝𑄚 𑄜𑄪𑄣𑄴𑄣𑄳𑄠 𑄦𑄧𑄢𑄧𑄇𑄴𑄅𑄚𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'quaternary' => q{𑄢𑄳𑄦𑄧/𑄇𑄬𑄥𑄴/𑄃𑄮𑄏𑄢𑄴/𑄇𑄚 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'secondary' => q{𑄢𑄳𑄦𑄧 𑄝𑄬𑄭𑄣𑄧𑄚},
 				'tertiary' => q{𑄢𑄳𑄦𑄧/𑄇𑄬𑄥𑄴/𑄃𑄮𑄏𑄢𑄴 𑄝𑄬𑄭𑄣𑄧𑄚},
 			},
 			'd0' => {
 				'fwidth' => q{𑄛𑄪𑄢𑄮𑄃𑄮𑄏𑄢𑄴},
 				'hwidth' => q{𑄃𑄧𑄖𑄴𑄘𑄬𑄇𑄴 𑄃𑄮𑄏𑄢𑄴},
 				'npinyin' => q{𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠},
 			},
 			'hc' => {
 				'h11' => q{𑄷𑄸 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴 (𑄶-𑄷𑄷)},
 				'h12' => q{𑄷𑄸 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴 (𑄷-𑄷𑄸)},
 				'h23' => q{𑄸𑄺 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴(𑄷-𑄸𑄹)},
 				'h24' => q{𑄸𑄺 𑄊𑄧𑄚𑄴𑄑𑄢𑄴 𑄦𑄨𑄏𑄬𑄛𑄴 (𑄷-𑄸𑄺)},
 			},
 			'lb' => {
 				'loose' => q{𑄃𑄣𑄴𑄉 𑄣𑄭𑄚𑄴 𑄜𑄢𑄧𑄉𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴},
 				'normal' => q{𑄃𑄧𑄎𑄬𑄃𑄧𑄌𑄴 𑄣𑄭𑄚𑄴 𑄜𑄢𑄧𑄉𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴},
 				'strict' => q{𑄑𑄭𑄑𑄴 𑄣𑄭𑄚𑄴 𑄜𑄢𑄧𑄉𑄧𑄢𑄴 𑄚𑄨𑄠𑄮𑄟𑄴},
 			},
 			'm0' => {
 				'bgn' => q{𑄝𑄨𑄎𑄨𑄃𑄬𑄚𑄴},
 				'ungegn' => q{𑄃𑄚𑄴𑄎𑄨𑄃𑄨𑄎𑄨𑄃𑄬𑄚𑄴},
 			},
 			'ms' => {
 				'metric' => q{𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄥𑄨𑄥𑄴𑄑𑄬𑄟𑄴},
 				'uksystem' => q{𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄟𑄝𑄧𑄢𑄴 𑄥𑄨𑄥𑄴𑄑𑄬𑄟𑄴},
 				'ussystem' => q{𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄎𑄧𑄙𑄢𑄬𑄌𑄴𑄎𑄮𑄢𑄴 𑄟𑄝𑄧𑄢𑄴 𑄥𑄨𑄥𑄴𑄑𑄬𑄟𑄴},
 			},
 			'numbers' => {
 				'arab' => q{𑄃𑄢𑄧𑄝𑄨-𑄞𑄢𑄨𑄖𑄩𑄠𑄧 𑄚𑄘},
 				'arabext' => q{𑄍𑄧𑄢𑄨𑄠𑄬 𑄍𑄨𑄖𑄴𑄖𑄳𑄠𑄬 𑄃𑄢𑄧𑄝𑄨-𑄞𑄢𑄧𑄖𑄩𑄠 𑄚𑄘},
 				'armn' => q{𑄃𑄢𑄴𑄟𑄬𑄚𑄩𑄠𑄧 𑄚𑄘},
 				'armnlow' => q{𑄃𑄢𑄴𑄟𑄬𑄚𑄩𑄠𑄧 𑄌𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄚𑄘},
 				'beng' => q{𑄝𑄁𑄣 𑄚𑄘},
 				'deva' => q{𑄘𑄬𑄝𑄧𑄚𑄉𑄧𑄢𑄨 𑄚𑄘},
 				'ethi' => q{𑄃𑄨𑄗𑄨𑄠𑄮𑄛𑄇𑄴 𑄚𑄘},
 				'finance' => q{𑄃𑄧𑄢𑄴𑄗𑄧𑄚𑄨𑄖𑄨𑄇𑄴 𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠},
 				'fullwide' => q{𑄛𑄪𑄢𑄮 𑄃𑄧𑄏𑄢𑄴 𑄚𑄘𑄨},
 				'geor' => q{𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄚𑄘},
 				'grek' => q{𑄉𑄳𑄢𑄨𑄇𑄴 𑄚𑄘𑄨},
 				'greklow' => q{𑄉𑄳𑄢𑄨𑄇𑄴 𑄌𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄚𑄘},
 				'gujr' => q{𑄉𑄪𑄎𑄴𑄢𑄖𑄨 𑄚𑄘},
 				'guru' => q{𑄉𑄪𑄢𑄪𑄟𑄪𑄈𑄨 𑄚𑄘},
 				'hanidec' => q{𑄌𑄳𑄆𑄚𑄨𑄇 𑄜𑄪𑄘𑄮 𑄚𑄘},
 				'hans' => q{𑄅𑄪𑄎𑄪𑄅𑄪𑄎𑄪 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄚𑄘},
 				'hansfin' => q{𑄅𑄪𑄎𑄪𑄅𑄎𑄪 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄑𑄬𑄋 𑄚𑄘},
 				'hant' => q{𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄚𑄘},
 				'hantfin' => q{𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄌𑄳𑄆𑄚𑄨𑄇𑄴 𑄑𑄬𑄋 𑄚𑄘},
 				'hebr' => q{𑄦𑄨𑄝𑄳𑄢𑄪 𑄚𑄘𑄨},
 				'jpan' => q{𑄎𑄛𑄚𑄨 𑄚𑄘},
 				'jpanfin' => q{𑄎𑄛𑄚𑄨 𑄑𑄬𑄋 𑄚𑄘},
 				'khmr' => q{𑄈𑄬𑄟𑄬𑄢𑄴 𑄚𑄘},
 				'knda' => q{𑄇𑄧𑄚𑄴𑄚𑄧𑄢𑄴 𑄚𑄘},
 				'laoo' => q{𑄣𑄃𑄮 𑄚𑄘},
 				'latn' => q{𑄃𑄮𑄠𑄬𑄌𑄴𑄑𑄢𑄴𑄚𑄴 𑄓𑄨𑄎𑄨𑄑𑄴},
 				'mlym' => q{𑄟𑄣𑄴𑄠𑄣𑄧𑄟𑄴 𑄚𑄘},
 				'mong' => q{𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄩𑄠𑄧 𑄚𑄘},
 				'mymr' => q{𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄚𑄘},
 				'native' => q{𑄃𑄟𑄧𑄚𑄧 𑄎𑄉𑄢𑄴 𑄚𑄘𑄨},
 				'orya' => q{𑄃𑄮𑄢𑄨𑄠 𑄚𑄘},
 				'roman' => q{𑄢𑄮𑄟𑄚𑄴 𑄚𑄘},
 				'romanlow' => q{𑄢𑄮𑄟𑄚𑄴 𑄌𑄨𑄉𑄮𑄚𑄴 𑄦𑄘𑄧𑄢𑄴 𑄚𑄘},
 				'taml' => q{𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄖𑄟𑄨𑄣𑄴 𑄚𑄘},
 				'tamldec' => q{𑄖𑄟𑄨𑄣 𑄚𑄘},
 				'telu' => q{𑄖𑄬𑄣𑄪𑄉𑄪 𑄚𑄘},
 				'thai' => q{𑄗𑄭 𑄚𑄘},
 				'tibt' => q{𑄖𑄨𑄛𑄴𑄝𑄧𑄖𑄨 𑄚𑄘},
 				'traditional' => q{𑄢𑄨𑄘𑄨𑄥𑄪𑄘𑄮𑄟𑄴 𑄚𑄘𑄝𑄝𑄧𑄖𑄳𑄠},
 				'vaii' => q{𑄞𑄭 𑄚𑄘},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'metric' => q{𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴},
 			'UK' => q{𑄃𑄨𑄅𑄪𑄇𑄬},
 			'US' => q{𑄃𑄨𑄅𑄪𑄃𑄬𑄌𑄴},

		}
	},
);

has 'display_name_code_patterns' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { 
		{
			'language' => '𑄞𑄌𑄴: {0}',
 			'script' => '𑄦𑄧𑄢𑄧𑄇𑄴: {0}',
 			'region' => '𑄎𑄉: {0}',

		}
	},
);

has 'text_orientation' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { return {
			lines => 'top-to-bottom',
			characters => 'left-to-right',
		}}
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['𑄃', '𑄄', '𑄅', '𑄆', '𑄇', '𑄈', '𑄉', '𑄊', '𑄋', '𑄌', '𑄍', '𑄎', '𑄏', '𑄐', '𑄑', '𑄒', '𑄓', '𑄔', '𑄕', '𑄖', '𑄗', '𑄘', '𑄙', '𑄚', '𑄛', '𑄜', '𑄝', '𑄞', '𑄟', '𑄠', '𑄡', '𑄢', '𑄣', '𑄤', '𑄥', '𑄦'],
			main => qr{[𑄀 𑄁 𑄂 𑄃 𑄄 𑄅 𑄆 𑄇 𑄈 𑄉 𑄊 𑄋 𑄌 𑄍 𑄎 𑄏 𑄐 𑄑 𑄒 𑄓 𑄔 𑄕 𑄖 𑄗 𑄘 𑄙 𑄚 𑄛 𑄜 𑄝 𑄞 𑄟 𑄠 𑄡 𑄢 𑄣 𑄤 𑄥 𑄦 𑄧 𑄨 𑄩 𑄪 𑄫 𑄬 𑄭 𑄮 𑄯 𑄰 𑄱 𑄲 𑄳 𑄴]},
			numbers => qr{[\- , . % ‰ + 0০ 1১ 2২ 3৩ 4৪ 5৫ 6৬ 7৭ 8৮ 9৯]},
			punctuation => qr{[\- ‐ – — , ; \: ! ? 𑅃 . … 𑅁 𑅂 𑅀 ' ‘ ’ " “ ” ( ) \[ \] § @ * / \& # † ‡ ′ ″]},
		};
	},
EOT
: sub {
		return { index => ['𑄃', '𑄄', '𑄅', '𑄆', '𑄇', '𑄈', '𑄉', '𑄊', '𑄋', '𑄌', '𑄍', '𑄎', '𑄏', '𑄐', '𑄑', '𑄒', '𑄓', '𑄔', '𑄕', '𑄖', '𑄗', '𑄘', '𑄙', '𑄚', '𑄛', '𑄜', '𑄝', '𑄞', '𑄟', '𑄠', '𑄡', '𑄢', '𑄣', '𑄤', '𑄥', '𑄦'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{“},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{”},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‘},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{’},
);

has 'duration_units' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub { {
				hm => 'h:mm',
				hms => 'h:mm:ss',
				ms => 'm:ss',
			} }
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					'acre' => {
						'name' => q(𑄃𑄬𑄇𑄧𑄢𑄴),
						'one' => q({0} 𑄃𑄬𑄇𑄧𑄢𑄴),
						'other' => q({0} 𑄃𑄬𑄇𑄧𑄢𑄴),
					},
					'acre-foot' => {
						'name' => q(𑄃𑄬𑄇𑄧𑄢𑄴-𑄜𑄪𑄖𑄴),
						'one' => q({0} 𑄃𑄬𑄇𑄧𑄢𑄴-𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄃𑄬𑄇𑄧𑄢𑄴-𑄜𑄪𑄖𑄴),
					},
					'ampere' => {
						'name' => q(𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴),
						'one' => q({0} 𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴),
						'other' => q({0} 𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴),
					},
					'arc-minute' => {
						'name' => q(𑄃𑄢𑄴𑄇𑄴-𑄟𑄨𑄚𑄨𑄖𑄴),
						'one' => q({0} 𑄃𑄢𑄴𑄇𑄴-𑄟𑄨𑄚𑄨𑄖𑄴),
						'other' => q({0} 𑄃𑄢𑄴𑄇𑄴-𑄟𑄨𑄚𑄨𑄖𑄴),
					},
					'arc-second' => {
						'name' => q(𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'astronomical-unit' => {
						'name' => q(𑄎𑄳𑄠𑄬𑄖𑄨𑄢𑄴𑄝𑄨𑄇𑄴𑄉𑄳𑄠𑄚𑄴 𑄃𑄬𑄇𑄧𑄇𑄴),
						'one' => q({0} 𑄎𑄳𑄠𑄬𑄖𑄨𑄢𑄴𑄝𑄨𑄇𑄴𑄉𑄳𑄠𑄚𑄴 𑄃𑄬𑄇𑄧𑄇𑄴),
						'other' => q({0} 𑄎𑄳𑄠𑄬𑄖𑄨𑄢𑄴𑄝𑄨𑄇𑄴𑄉𑄳𑄠𑄚𑄴 𑄃𑄬𑄇𑄧𑄇𑄴),
					},
					'bit' => {
						'name' => q(𑄝𑄨𑄖𑄴),
						'one' => q({0} 𑄝𑄨𑄖𑄴),
						'other' => q({0} 𑄝𑄨𑄖𑄴),
					},
					'byte' => {
						'name' => q(𑄝𑄭𑄖𑄴),
						'one' => q({0} 𑄝𑄭𑄖𑄴),
						'other' => q({0} 𑄝𑄭𑄖𑄴),
					},
					'calorie' => {
						'name' => q(𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
						'one' => q({0} 𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
						'other' => q({0} 𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
					},
					'carat' => {
						'name' => q(𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
						'one' => q({0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
						'other' => q({0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
					},
					'celsius' => {
						'name' => q(𑄓𑄨𑄉𑄳𑄢𑄩 𑄥𑄬𑄣𑄴𑄥𑄨𑄠𑄌𑄴),
						'one' => q({0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄥𑄬𑄣𑄴𑄥𑄨𑄠𑄌𑄴),
						'other' => q({0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄥𑄬𑄣𑄴𑄥𑄨𑄠𑄌𑄴),
					},
					'centiliter' => {
						'name' => q(𑄥𑄬𑄚𑄴𑄑𑄨𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄣𑄨𑄑𑄢𑄴),
					},
					'centimeter' => {
						'name' => q(𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
					},
					'century' => {
						'name' => q(𑄃𑄬𑄇𑄴𑄥𑄧 𑄝𑄧𑄏𑄧𑄢𑄴),
						'one' => q({0} 𑄃𑄬𑄇𑄴𑄥𑄧 𑄝𑄧𑄏𑄧𑄢𑄴),
						'other' => q({0} 𑄃𑄬𑄇𑄴𑄥𑄧 𑄝𑄧𑄏𑄧𑄢𑄴),
					},
					'coordinate' => {
						'east' => q({0} 𑄛𑄪𑄇𑄴),
						'north' => q({0} 𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴),
						'south' => q({0} 𑄘𑄧𑄉𑄨𑄚𑄴),
						'west' => q({0} 𑄛𑄮𑄏𑄨𑄟𑄴),
					},
					'cubic-centimeter' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
					},
					'cubic-foot' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄜𑄪𑄖𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄜𑄪𑄖𑄴),
					},
					'cubic-inch' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄃𑄨𑄚𑄴𑄌𑄨),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄃𑄨𑄚𑄴𑄌𑄨),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄃𑄨𑄚𑄴𑄌𑄨),
					},
					'cubic-kilometer' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'cubic-meter' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄨𑄑𑄢𑄴),
					},
					'cubic-mile' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄬𑄣𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄟𑄬𑄣𑄴),
					},
					'cubic-yard' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄉𑄧𑄌𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄉𑄧𑄌𑄴),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(𑄇𑄛𑄴),
						'one' => q({0} 𑄇𑄛𑄴),
						'other' => q({0} 𑄇𑄛𑄴),
					},
					'cup-metric' => {
						'name' => q(𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄇𑄛𑄴),
						'one' => q({0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄇𑄛𑄴),
						'other' => q({0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄇𑄛𑄴),
					},
					'day' => {
						'name' => q(𑄘𑄨𑄚𑄴),
						'one' => q({0} 𑄘𑄨𑄚𑄴),
						'other' => q({0} 𑄘𑄨𑄚𑄴),
						'per' => q({0} 𑄘𑄨𑄚𑄴 𑄟𑄉𑄬𑄚𑄬),
					},
					'deciliter' => {
						'name' => q(𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄴),
					},
					'decimeter' => {
						'name' => q(𑄓𑄬𑄥𑄨𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄓𑄬𑄥𑄨𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄓𑄬𑄥𑄨𑄟𑄨𑄑𑄢𑄴),
					},
					'degree' => {
						'name' => q(𑄓𑄨𑄉𑄳𑄢𑄩),
						'one' => q({0} 𑄓𑄨𑄉𑄳𑄢𑄩),
						'other' => q({0} 𑄓𑄨𑄉𑄳𑄢𑄩),
					},
					'fahrenheit' => {
						'name' => q(𑄓𑄨𑄉𑄳𑄢𑄩 𑄜𑄢𑄬𑄚𑄴𑄦𑄭𑄖𑄴),
						'one' => q({0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄜𑄢𑄬𑄚𑄴𑄦𑄭𑄖𑄴),
						'other' => q({0} 𑄓𑄨𑄉𑄳𑄢𑄩 𑄜𑄢𑄬𑄚𑄴𑄦𑄭𑄖𑄴),
					},
					'fluid-ounce' => {
						'name' => q(𑄜𑄳𑄣𑄪𑄃𑄨𑄓𑄴 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
						'one' => q({0} 𑄜𑄳𑄣𑄪𑄃𑄨𑄓𑄴 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
						'other' => q({0} 𑄜𑄳𑄣𑄪𑄃𑄨𑄓𑄴 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
					},
					'foodcalorie' => {
						'name' => q(𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
						'one' => q({0} 𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
						'other' => q({0} 𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
					},
					'foot' => {
						'name' => q(𑄜𑄪𑄖𑄴),
						'one' => q({0} 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄜𑄪𑄖𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄜𑄪𑄖𑄴),
					},
					'g-force' => {
						'name' => q(𑄎𑄨-𑄝𑄧𑄣𑄴),
						'one' => q({0} 𑄎𑄨-𑄝𑄧𑄣𑄴),
						'other' => q({0} 𑄎𑄨-𑄝𑄧𑄣𑄴),
					},
					'gallon' => {
						'name' => q(𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'one' => q({0} 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'other' => q({0} 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
					},
					'gallon-imperial' => {
						'name' => q(𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'one' => q({0} 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'other' => q({0} 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(𑄉𑄨𑄉𑄝𑄨𑄖𑄴),
						'one' => q({0} 𑄉𑄨𑄉𑄝𑄨𑄖𑄴),
						'other' => q({0} 𑄉𑄨𑄉𑄝𑄨𑄖𑄴),
					},
					'gigabyte' => {
						'name' => q(𑄉𑄨𑄉𑄝𑄭𑄖𑄴),
						'one' => q({0} 𑄉𑄨𑄉𑄝𑄭𑄖𑄴),
						'other' => q({0} 𑄉𑄨𑄉𑄝𑄭𑄖𑄴),
					},
					'gigahertz' => {
						'name' => q(𑄉𑄨𑄉𑄦𑄢𑄴𑄎𑄴),
						'one' => q({0} 𑄉𑄨𑄉𑄦𑄢𑄴𑄎𑄴),
						'other' => q({0} 𑄉𑄨𑄉𑄦𑄢𑄴𑄎𑄴),
					},
					'gigawatt' => {
						'name' => q(𑄉𑄨𑄉𑄤𑄖𑄴),
						'one' => q({0} 𑄉𑄨𑄉𑄤𑄖𑄴),
						'other' => q({0} 𑄉𑄨𑄉𑄤𑄖𑄴),
					},
					'gram' => {
						'name' => q(𑄉𑄳𑄢𑄟𑄴),
						'one' => q({0} 𑄉𑄳𑄢𑄟𑄴),
						'other' => q({0} 𑄉𑄳𑄢𑄟𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄢𑄟𑄴),
					},
					'hectare' => {
						'name' => q(𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
						'one' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
						'other' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
					},
					'hectoliter' => {
						'name' => q(𑄦𑄬𑄇𑄴𑄑𑄮𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄣𑄨𑄑𑄢𑄴),
					},
					'hectopascal' => {
						'name' => q(𑄦𑄬𑄇𑄴𑄑𑄮𑄛𑄥𑄴𑄇𑄧𑄣𑄴),
						'one' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄛𑄥𑄴𑄇𑄧𑄣𑄴),
						'other' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄮𑄛𑄥𑄴𑄇𑄧𑄣𑄴),
					},
					'hertz' => {
						'name' => q(𑄦𑄢𑄴𑄎𑄴),
						'one' => q({0} 𑄦𑄢𑄴𑄎𑄴),
						'other' => q({0} 𑄦𑄢𑄴𑄎𑄴),
					},
					'horsepower' => {
						'name' => q(𑄦𑄧𑄢𑄴𑄥𑄴𑄛𑄤𑄢𑄴),
						'one' => q({0} 𑄦𑄧𑄢𑄴𑄥𑄴𑄛𑄤𑄢𑄴),
						'other' => q({0} 𑄦𑄧𑄢𑄴𑄥𑄴𑄛𑄤𑄢𑄴),
					},
					'hour' => {
						'name' => q(𑄊𑄧𑄚𑄴𑄘),
						'one' => q({0} 𑄊𑄧𑄚𑄴𑄘),
						'other' => q({0} 𑄊𑄧𑄚𑄴𑄘),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄊𑄧𑄚𑄴𑄘),
					},
					'inch' => {
						'name' => q(𑄃𑄨𑄚𑄴𑄌𑄨),
						'one' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨),
						'other' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄚𑄴𑄌𑄨),
					},
					'inch-hg' => {
						'name' => q(𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄢𑄧𑄖𑄴),
						'one' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄢𑄧𑄖𑄴),
						'other' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄢𑄧𑄖𑄴),
					},
					'joule' => {
						'name' => q(𑄎𑄪𑄣𑄴),
						'one' => q({0} 𑄎𑄪𑄣𑄴),
						'other' => q({0} 𑄎𑄪𑄣𑄴),
					},
					'karat' => {
						'name' => q(𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
						'one' => q({0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
						'other' => q({0} 𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
					},
					'kelvin' => {
						'name' => q(𑄇𑄬𑄣𑄴𑄞𑄨𑄚𑄴),
						'one' => q({0} 𑄇𑄬𑄣𑄴𑄞𑄨𑄚𑄴),
						'other' => q({0} 𑄇𑄬𑄣𑄴𑄞𑄨𑄚𑄴),
					},
					'kilobit' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄝𑄨𑄖𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄝𑄨𑄖𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄝𑄨𑄖𑄴),
					},
					'kilobyte' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄝𑄭𑄖𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄝𑄭𑄖𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄝𑄭𑄖𑄴),
					},
					'kilocalorie' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
						'other' => q({0}𑄇𑄨𑄣𑄮𑄇𑄳𑄠𑄣𑄮𑄢𑄨),
					},
					'kilogram' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄉𑄳𑄢𑄟𑄴),
					},
					'kilohertz' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄦𑄢𑄴𑄎𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄦𑄢𑄴𑄎𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄦𑄢𑄴𑄎𑄴),
					},
					'kilojoule' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄎𑄪𑄣𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄎𑄪𑄣𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄎𑄪𑄣𑄴),
					},
					'kilometer' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄟𑄨𑄢𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'kilometer-per-hour' => {
						'name' => q(𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'kilowatt' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄤𑄖𑄴),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴),
					},
					'kilowatt-hour' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄃𑄮𑄠𑄖𑄴 𑄊𑄧𑄚𑄳𑄑),
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄃𑄮𑄠𑄖𑄴 𑄊𑄧𑄚𑄳𑄑),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄃𑄮𑄠𑄖𑄴 𑄊𑄧𑄚𑄳𑄑),
					},
					'knot' => {
						'name' => q(𑄚𑄧𑄖𑄴),
						'one' => q({0} 𑄚𑄧𑄖𑄴),
						'other' => q({0} 𑄚𑄧𑄖𑄴),
					},
					'light-year' => {
						'name' => q(𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴),
						'one' => q({0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴),
						'other' => q({0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴),
					},
					'liter' => {
						'name' => q(𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄣𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄴),
					},
					'liter-per-100kilometers' => {
						'name' => q(𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄷𑄶𑄶 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬),
						'one' => q({0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄷𑄶𑄶 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬),
						'other' => q({0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄷𑄶𑄶 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬),
					},
					'liter-per-kilometer' => {
						'name' => q(𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬),
						'one' => q({0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬),
						'other' => q({0} 𑄣𑄨𑄑𑄢𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄬),
					},
					'lux' => {
						'name' => q(𑄣𑄇𑄳𑄥𑄴),
						'one' => q({0} 𑄣𑄇𑄳𑄥𑄴),
						'other' => q({0} 𑄣𑄇𑄳𑄥𑄴),
					},
					'megabit' => {
						'name' => q(𑄟𑄬𑄉𑄝𑄨𑄖𑄴),
						'one' => q({0} 𑄟𑄬𑄉𑄝𑄨𑄖𑄴),
						'other' => q({0} 𑄟𑄬𑄉𑄝𑄨𑄖𑄴),
					},
					'megabyte' => {
						'name' => q(𑄟𑄬𑄉𑄝𑄭𑄖𑄴),
						'one' => q({0} 𑄟𑄬𑄉𑄝𑄭𑄖𑄴),
						'other' => q({0} 𑄟𑄬𑄉𑄝𑄭𑄖𑄴),
					},
					'megahertz' => {
						'name' => q(𑄟𑄬𑄉𑄦𑄢𑄴𑄎𑄴),
						'one' => q({0} 𑄟𑄬𑄉𑄦𑄢𑄴𑄎𑄴),
						'other' => q({0} 𑄟𑄬𑄉𑄦𑄢𑄴𑄎𑄴),
					},
					'megaliter' => {
						'name' => q(𑄟𑄬𑄉𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄬𑄉𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄟𑄬𑄉𑄣𑄨𑄑𑄢𑄴),
					},
					'megawatt' => {
						'name' => q(𑄟𑄬𑄉𑄤𑄖𑄴),
						'one' => q({0} 𑄟𑄬𑄉𑄤𑄖𑄴),
						'other' => q({0} 𑄟𑄬𑄉𑄤𑄖𑄴),
					},
					'meter' => {
						'name' => q(𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄟𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄑𑄢𑄴),
					},
					'meter-per-second' => {
						'name' => q(𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'meter-per-second-squared' => {
						'name' => q(𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄇𑄬𑄚𑄴𑄓𑄬),
						'other' => q({0} 𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄇𑄬𑄚𑄴𑄓𑄬),
					},
					'metric-ton' => {
						'name' => q(𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄑𑄧𑄚𑄴),
						'one' => q({0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄑𑄧𑄚𑄴),
						'other' => q({0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄑𑄧𑄚𑄴),
					},
					'microgram' => {
						'name' => q(𑄟𑄭𑄇𑄳𑄢𑄮𑄉𑄳𑄢𑄟𑄴),
						'one' => q({0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄉𑄳𑄢𑄟𑄴),
						'other' => q({0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄉𑄳𑄢𑄟𑄴),
					},
					'micrometer' => {
						'name' => q(𑄟𑄭𑄇𑄳𑄢𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'microsecond' => {
						'name' => q(𑄟𑄭𑄇𑄳𑄢𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄟𑄭𑄇𑄳𑄢𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'mile' => {
						'name' => q(𑄟𑄬𑄣𑄴),
						'one' => q({0} 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄟𑄬𑄣𑄴),
					},
					'mile-per-gallon' => {
						'name' => q(𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄬),
						'one' => q({0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄬),
						'other' => q({0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄠𑄣𑄧𑄚𑄬),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄬),
						'one' => q({0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄬),
						'other' => q({0} 𑄟𑄬𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄟𑄴𑄛𑄬𑄢𑄨𑄠𑄣𑄴 𑄉𑄳𑄠𑄣𑄧𑄚𑄬),
					},
					'mile-per-hour' => {
						'name' => q(𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴),
						'one' => q({0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄊𑄧𑄚𑄳𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴),
					},
					'mile-scandinavian' => {
						'name' => q(𑄟𑄬𑄣𑄴-𑄥𑄳𑄇𑄳𑄠𑄚𑄴𑄓𑄨𑄚𑄬𑄞𑄨𑄠𑄚𑄴),
						'one' => q({0} 𑄟𑄬𑄣𑄴-𑄥𑄳𑄇𑄳𑄠𑄚𑄴𑄓𑄨𑄚𑄬𑄞𑄨𑄠𑄚𑄴),
						'other' => q({0} 𑄟𑄬𑄣𑄴-𑄥𑄳𑄇𑄳𑄠𑄚𑄴𑄓𑄨𑄚𑄬𑄞𑄨𑄠𑄚𑄴),
					},
					'milliampere' => {
						'name' => q(𑄟𑄨𑄣𑄨-𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨-𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨-𑄃𑄳𑄠𑄟𑄴𑄛𑄨𑄠𑄢𑄴),
					},
					'millibar' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄝𑄢𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄝𑄢𑄴),
						'other' => q({0}𑄟𑄨𑄣𑄨𑄝𑄢𑄴),
					},
					'milligram' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴),
					},
					'milligram-per-deciliter' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄬),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄬),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄉𑄳𑄢𑄟𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄓𑄬𑄥𑄨𑄣𑄨𑄑𑄢𑄬),
					},
					'milliliter' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄣𑄨𑄑𑄢𑄴),
					},
					'millimeter' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴),
					},
					'millimeter-of-mercury' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴 𑄛𑄢𑄧𑄖𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴 𑄛𑄢𑄧𑄖𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄟𑄨𑄑𑄢𑄴 𑄛𑄢𑄧𑄖𑄴),
					},
					'millimole-per-liter' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄟𑄮𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄬),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄟𑄮𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄬),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄟𑄮𑄣𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄣𑄨𑄑𑄢𑄬),
					},
					'millisecond' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0}𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'milliwatt' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄤𑄖𑄴),
						'one' => q({0} 𑄟𑄨𑄣𑄨𑄤𑄖𑄴),
						'other' => q({0} 𑄟𑄨𑄣𑄨𑄤𑄖𑄴),
					},
					'minute' => {
						'name' => q(𑄟𑄨𑄚𑄨𑄖𑄴),
						'one' => q({0} 𑄟𑄨𑄚𑄨𑄖𑄴),
						'other' => q({0} 𑄟𑄨𑄚𑄨𑄖𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄚𑄨𑄖𑄴),
					},
					'month' => {
						'name' => q(𑄟𑄌𑄴),
						'one' => q({0} 𑄟𑄌𑄴),
						'other' => q({0} 𑄟𑄌𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄌𑄴),
					},
					'nanometer' => {
						'name' => q(𑄚𑄳𑄠𑄚𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄚𑄳𑄠𑄚𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄚𑄳𑄠𑄚𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'nanosecond' => {
						'name' => q(𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'nautical-mile' => {
						'name' => q(𑄚𑄧𑄑𑄨𑄇𑄳𑄠𑄣𑄴 𑄟𑄬𑄣𑄴),
						'one' => q({0} 𑄚𑄧𑄑𑄨𑄇𑄳𑄠𑄣𑄴 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄚𑄧𑄑𑄨𑄇𑄳𑄠𑄣𑄴 𑄟𑄬𑄣𑄴),
					},
					'ohm' => {
						'name' => q(𑄃𑄮𑄦𑄧𑄟𑄴),
						'one' => q({0} 𑄃𑄮𑄦𑄧𑄟𑄴),
						'other' => q({0} 𑄃𑄮𑄦𑄧𑄟𑄴),
					},
					'ounce' => {
						'name' => q(𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
						'one' => q({0} 𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
						'other' => q({0} 𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
					},
					'ounce-troy' => {
						'name' => q(𑄛𑄳𑄢𑄧𑄠𑄴 𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
						'one' => q({0} 𑄛𑄳𑄢𑄧𑄠𑄴 𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
						'other' => q({0} 𑄛𑄳𑄢𑄧𑄠𑄴 𑄃𑄅𑄪𑄚𑄳𑄥𑄴),
					},
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} parsec),
						'other' => q({0} parsecs),
					},
					'part-per-million' => {
						'name' => q(𑄞𑄇𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄧𑄌𑄴 𑄣𑄬𑄉),
						'one' => q({0} 𑄞𑄧𑄇𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄧𑄌𑄴 𑄣𑄉𑄬),
						'other' => q({0} 𑄞𑄧𑄇𑄴, 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄧𑄌𑄴 𑄣𑄉𑄬),
					},
					'per' => {
						'1' => q({1} 𑄛𑄳𑄢𑄧𑄖𑄨 {0}),
					},
					'picometer' => {
						'name' => q(𑄛𑄨𑄇𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄛𑄨𑄇𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄛𑄨𑄇𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'pint' => {
						'name' => q(𑄛𑄨𑄚𑄳𑄑𑄴),
						'one' => q({0} 𑄛𑄨𑄚𑄳𑄑𑄴),
						'other' => q({0} 𑄛𑄨𑄚𑄳𑄑𑄴),
					},
					'pint-metric' => {
						'name' => q(𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄛𑄨𑄚𑄳𑄑𑄴),
						'one' => q({0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄛𑄨𑄚𑄳𑄑𑄴),
						'other' => q({0} 𑄟𑄬𑄑𑄳𑄢𑄨𑄇𑄴 𑄛𑄨𑄚𑄳𑄑𑄴),
					},
					'pound' => {
						'name' => q(𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
					},
					'pound-per-square-inch' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧𑄃𑄨𑄚𑄴𑄌𑄨 𑄛𑄳𑄢𑄧𑄖𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
					},
					'quart' => {
						'name' => q(𑄇𑄮𑄠𑄢𑄴𑄑𑄴),
						'one' => q({0} 𑄇𑄮𑄠𑄢𑄴𑄑𑄴),
						'other' => q({0} 𑄇𑄮𑄠𑄢𑄴𑄑𑄴),
					},
					'radian' => {
						'name' => q(𑄢𑄬𑄓𑄨𑄠𑄚𑄴),
						'one' => q({0} 𑄢𑄬𑄓𑄨𑄠𑄚𑄴),
						'other' => q({0} 𑄢𑄬𑄓𑄨𑄠𑄳𑄠𑄚𑄴𑄥𑄴),
					},
					'revolution' => {
						'name' => q(𑄊𑄪𑄢𑄮𑄚𑄴),
						'one' => q({0} 𑄢𑄨𑄞𑄮𑄣𑄨𑄅𑄪𑄥𑄧𑄚𑄴),
						'other' => q({0} 𑄊𑄪𑄢𑄮𑄚𑄴),
					},
					'second' => {
						'name' => q(𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'square-centimeter' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄥𑄬𑄚𑄴𑄑𑄨𑄟𑄨𑄑𑄢𑄴),
					},
					'square-foot' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
					},
					'square-inch' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨),
						'per' => q(𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄃𑄨𑄚𑄴𑄌𑄨𑄖𑄴 {0}),
					},
					'square-kilometer' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'per' => q(𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴𑄢𑄳𑄠 {0}),
					},
					'square-meter' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴),
						'per' => q(𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄬 {0}),
					},
					'square-mile' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄭),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄭),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄭),
						'per' => q(𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄬{0}),
					},
					'square-yard' => {
						'name' => q(yd²),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴),
					},
					'tablespoon' => {
						'name' => q(𑄑𑄬𑄝𑄨𑄣𑄴 𑄌𑄟𑄬𑄌𑄴),
						'one' => q({0} 𑄑𑄬𑄝𑄨𑄣𑄴 𑄌𑄟𑄬𑄌𑄴),
						'other' => q({0} 𑄑𑄬𑄝𑄨𑄣𑄴 𑄌𑄟𑄬𑄌𑄴),
					},
					'teaspoon' => {
						'name' => q(𑄌 𑄌𑄟𑄬𑄌𑄴),
						'one' => q({0} 𑄌 𑄌𑄟𑄬𑄌𑄴),
						'other' => q({0} 𑄌 𑄌𑄟𑄬𑄌𑄴),
					},
					'terabit' => {
						'name' => q(𑄑𑄬𑄢𑄝𑄨𑄖𑄴),
						'one' => q({0} 𑄑𑄬𑄢𑄝𑄨𑄖𑄴),
						'other' => q({0} 𑄑𑄬𑄢𑄝𑄨𑄖𑄴),
					},
					'terabyte' => {
						'name' => q(𑄑𑄢𑄝𑄭𑄖𑄴),
						'one' => q({0} 𑄑𑄢𑄝𑄭𑄖𑄴),
						'other' => q({0} 𑄑𑄢𑄝𑄭𑄖𑄴),
					},
					'ton' => {
						'name' => q(𑄑𑄧𑄚𑄴),
						'one' => q({0} 𑄑𑄧𑄚𑄴),
						'other' => q({0} 𑄑𑄧𑄚𑄴),
					},
					'volt' => {
						'name' => q(𑄣𑄮𑄣𑄳𑄑𑄴),
						'one' => q({0} 𑄞𑄮𑄣𑄳𑄑𑄴),
						'other' => q({0} 𑄞𑄮𑄣𑄳𑄑𑄴),
					},
					'watt' => {
						'name' => q(𑄤𑄖𑄴),
						'one' => q({0} 𑄤𑄖𑄴),
						'other' => q({0} 𑄤𑄖𑄴),
					},
					'week' => {
						'name' => q(𑄥𑄛𑄴𑄖),
						'one' => q({0} 𑄥𑄛𑄴𑄖),
						'other' => q({0} 𑄥𑄛𑄴𑄖),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄛𑄴𑄖),
					},
					'yard' => {
						'name' => q(𑄉𑄧𑄌𑄴),
						'one' => q({0} 𑄉𑄧𑄌𑄴),
						'other' => q({0} 𑄉𑄧𑄌𑄴),
					},
					'year' => {
						'name' => q(𑄝𑄧𑄏𑄧𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄏𑄧𑄢𑄴),
						'other' => q({0} 𑄝𑄧𑄏𑄧𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄏𑄧𑄢𑄴),
					},
				},
				'narrow' => {
					'acre' => {
						'one' => q({0} 𑄃𑄬𑄉𑄧𑄢𑄴),
						'other' => q({0} 𑄃𑄬𑄉𑄧𑄢𑄴),
					},
					'arc-minute' => {
						'one' => q({0}𑄟𑄨𑄚𑄨𑄖𑄴),
						'other' => q({0}𑄟𑄨𑄚𑄨𑄖𑄴),
					},
					'arc-second' => {
						'one' => q({0}𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0}𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'celsius' => {
						'name' => q(°C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centimeter' => {
						'name' => q(𑄥𑄬𑄟𑄨),
						'one' => q({0} 𑄥𑄬𑄟𑄨),
						'other' => q({0} 𑄥𑄬𑄟𑄨),
					},
					'coordinate' => {
						'east' => q({0}𑄛𑄪),
						'north' => q({0}𑄅𑄪),
						'south' => q({0}𑄘𑄧),
						'west' => q({0}𑄛𑄧),
					},
					'cubic-kilometer' => {
						'one' => q({0}km³),
						'other' => q({0}km³),
					},
					'cubic-mile' => {
						'one' => q({0}mi³),
						'other' => q({0}mi³),
					},
					'day' => {
						'name' => q(𑄘𑄨𑄚𑄴),
						'one' => q({0} 𑄘𑄨𑄚𑄴),
						'other' => q({0} 𑄘𑄨𑄚𑄴),
					},
					'degree' => {
						'one' => q({0}𑄓𑄨𑄉𑄳𑄢𑄩),
						'other' => q({0}𑄓𑄨𑄉𑄳𑄢𑄩),
					},
					'fahrenheit' => {
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'foot' => {
						'one' => q({0} 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄜𑄪𑄖𑄴),
					},
					'g-force' => {
						'one' => q({0} 𑄎𑄨-𑄝𑄧𑄣𑄴),
						'other' => q({0} 𑄎𑄨-𑄝𑄧𑄣𑄴),
					},
					'gram' => {
						'name' => q(𑄉𑄳𑄢𑄟𑄴),
						'one' => q({0} 𑄉𑄳𑄢𑄟𑄴),
						'other' => q({0} 𑄉𑄳𑄢𑄟𑄴),
					},
					'hectare' => {
						'one' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
						'other' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
					},
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'horsepower' => {
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(𑄊𑄧𑄚𑄴𑄑),
						'one' => q({0} 𑄊𑄂),
						'other' => q({0} 𑄊𑄂),
					},
					'inch' => {
						'one' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨),
						'other' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨),
					},
					'inch-hg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'kilogram' => {
						'name' => q(𑄇𑄬𑄎𑄨),
						'one' => q({0} 𑄇𑄬𑄎𑄨),
						'other' => q({0} 𑄇𑄬𑄎𑄨),
					},
					'kilometer' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄟𑄨),
						'other' => q({0} 𑄇𑄨𑄟𑄨),
					},
					'kilometer-per-hour' => {
						'name' => q(km/hr),
						'one' => q({0}kph),
						'other' => q({0}kph),
					},
					'kilowatt' => {
						'one' => q({0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴),
						'other' => q({0} 𑄇𑄨𑄣𑄮𑄤𑄖𑄴),
					},
					'light-year' => {
						'one' => q({0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄢𑄴),
						'other' => q({0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄢𑄴),
					},
					'liter' => {
						'name' => q(𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄣𑄨𑄑𑄢𑄴),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'meter' => {
						'name' => q(𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄨),
						'other' => q({0} 𑄟𑄨),
					},
					'meter-per-second' => {
						'one' => q({0}m/s),
						'other' => q({0}m/s),
					},
					'mile' => {
						'one' => q({0} 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄟𑄬𑄣𑄴),
					},
					'mile-per-hour' => {
						'one' => q({0}mph),
						'other' => q({0}mph),
					},
					'millibar' => {
						'one' => q({0} mb),
						'other' => q({0} mb),
					},
					'millimeter' => {
						'name' => q(𑄟𑄨𑄟𑄨),
						'one' => q({0} 𑄟𑄨𑄟𑄨),
						'other' => q({0} 𑄟𑄨𑄟𑄨),
					},
					'millisecond' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'minute' => {
						'name' => q(𑄟𑄨𑄚𑄨𑄖𑄴),
						'one' => q({0} 𑄟𑄨𑄂),
						'other' => q({0} 𑄟𑄨𑄂),
					},
					'month' => {
						'name' => q(𑄟𑄌𑄴),
						'one' => q({0} 𑄟𑄌𑄴),
						'other' => q({0} 𑄟𑄌𑄴),
					},
					'ounce' => {
						'one' => q({0} 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
						'other' => q({0} 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'one' => q({0}𑄛𑄨𑄟𑄨),
						'other' => q({0} 𑄛𑄨𑄟𑄨),
					},
					'pound' => {
						'one' => q({0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
					},
					'second' => {
						'name' => q(𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄥𑄬𑄂),
						'other' => q({0} 𑄥𑄬𑄂),
					},
					'square-foot' => {
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
					},
					'square-kilometer' => {
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨),
					},
					'square-meter' => {
						'one' => q({0} m²),
						'other' => q({0} m²),
					},
					'square-mile' => {
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴),
					},
					'watt' => {
						'one' => q({0} 𑄤𑄖𑄴),
						'other' => q({0} 𑄤𑄖𑄴),
					},
					'week' => {
						'name' => q(𑄥𑄛𑄴𑄖),
						'one' => q({0} 𑄥𑄛𑄴𑄖),
						'other' => q({0} 𑄥𑄛𑄴𑄖),
					},
					'yard' => {
						'one' => q({0} 𑄉𑄧𑄌𑄴),
						'other' => q({0} 𑄉𑄧𑄌𑄴),
					},
					'year' => {
						'name' => q(𑄝𑄧𑄏𑄧𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄏𑄧𑄢𑄴),
						'other' => q({0} 𑄝𑄧𑄏𑄧𑄢𑄴),
					},
				},
				'short' => {
					'acre' => {
						'name' => q(𑄃𑄬𑄉𑄧𑄢𑄴),
						'one' => q({0} 𑄃𑄬𑄉𑄧𑄢𑄴),
						'other' => q({0} 𑄃𑄬𑄉𑄧𑄢𑄴),
					},
					'acre-foot' => {
						'name' => q(ac ft),
						'one' => q({0} ac ft),
						'other' => q({0} ac ft),
					},
					'ampere' => {
						'name' => q(amp),
						'one' => q({0} A),
						'other' => q({0} A),
					},
					'arc-minute' => {
						'name' => q(𑄃𑄢𑄴𑄇𑄴𑄟𑄨𑄚𑄴),
						'one' => q({0} 𑄃𑄢𑄴𑄇𑄴𑄟𑄨𑄚𑄴),
						'other' => q({0} 𑄃𑄢𑄴𑄇𑄴𑄟𑄨𑄚𑄴),
					},
					'arc-second' => {
						'name' => q(𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄴),
						'other' => q({0} 𑄃𑄢𑄴𑄇𑄴𑄥𑄬𑄇𑄴),
					},
					'astronomical-unit' => {
						'name' => q(au),
						'one' => q({0} au),
						'other' => q({0} au),
					},
					'bit' => {
						'name' => q(𑄝𑄨𑄖𑄴),
						'one' => q({0} 𑄝𑄨𑄖𑄴),
						'other' => q({0} 𑄝𑄨𑄖𑄴),
					},
					'byte' => {
						'name' => q(𑄝𑄭𑄖𑄴),
						'one' => q({0} 𑄝𑄭𑄖𑄴),
						'other' => q({0} 𑄝𑄭𑄖𑄴),
					},
					'calorie' => {
						'name' => q(cal),
						'one' => q({0} cal),
						'other' => q({0} cal),
					},
					'carat' => {
						'name' => q(𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
						'one' => q({0} CD),
						'other' => q({0} CD),
					},
					'celsius' => {
						'name' => q(deg. C),
						'one' => q({0}°C),
						'other' => q({0}°C),
					},
					'centiliter' => {
						'name' => q(cL),
						'one' => q({0} cL),
						'other' => q({0} cL),
					},
					'centimeter' => {
						'name' => q(𑄥𑄬𑄟𑄨),
						'one' => q({0} 𑄥𑄬𑄟𑄨),
						'other' => q({0} 𑄥𑄬𑄟𑄨),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄟𑄨),
					},
					'century' => {
						'name' => q(𑄥𑄧𑄖𑄧𑄇𑄴),
						'one' => q({0} 𑄥𑄧𑄖𑄧𑄇𑄴),
						'other' => q({0} 𑄥𑄧𑄖𑄧𑄇𑄴),
					},
					'coordinate' => {
						'east' => q({0}𑄛𑄪),
						'north' => q({0}𑄅𑄪),
						'south' => q({0}𑄘𑄧),
						'west' => q({0}𑄛𑄧),
					},
					'cubic-centimeter' => {
						'name' => q(cm³),
						'one' => q({0} cm³),
						'other' => q({0} cm³),
						'per' => q({0}/cm³),
					},
					'cubic-foot' => {
						'name' => q(ft³),
						'one' => q({0} ft³),
						'other' => q({0} ft³),
					},
					'cubic-inch' => {
						'name' => q(in³),
						'one' => q({0} in³),
						'other' => q({0} in³),
					},
					'cubic-kilometer' => {
						'name' => q(𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄇𑄨𑄅𑄪𑄝𑄨𑄇𑄴 𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
					},
					'cubic-meter' => {
						'name' => q(m³),
						'one' => q({0} m³),
						'other' => q({0} m³),
						'per' => q({0}/m³),
					},
					'cubic-mile' => {
						'name' => q(mi³),
						'one' => q({0} mi³),
						'other' => q({0} mi³),
					},
					'cubic-yard' => {
						'name' => q(yd³),
						'one' => q({0} yd³),
						'other' => q({0} yd³),
					},
					'cup' => {
						'name' => q(cup),
						'one' => q({0} c),
						'other' => q({0} c),
					},
					'cup-metric' => {
						'name' => q(mcup),
						'one' => q({0} mc),
						'other' => q({0} mc),
					},
					'day' => {
						'name' => q(𑄘𑄨𑄚𑄴),
						'one' => q({0} 𑄘𑄨𑄚𑄴),
						'other' => q({0} 𑄘𑄨𑄚𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄘𑄨𑄚𑄴),
					},
					'deciliter' => {
						'name' => q(dL),
						'one' => q({0} dL),
						'other' => q({0} dL),
					},
					'decimeter' => {
						'name' => q(𑄓𑄬𑄟𑄨),
						'one' => q({0} 𑄓𑄬𑄟𑄨),
						'other' => q({0} 𑄓𑄬𑄟𑄨),
					},
					'degree' => {
						'name' => q(𑄓𑄨𑄉𑄳𑄢𑄩),
						'one' => q({0}𑄓𑄨𑄉𑄳𑄢𑄩),
						'other' => q({0}𑄓𑄨𑄉𑄳𑄢𑄩),
					},
					'fahrenheit' => {
						'name' => q(°F),
						'one' => q({0}°F),
						'other' => q({0}°F),
					},
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					'foodcalorie' => {
						'name' => q(Cal),
						'one' => q({0} Cal),
						'other' => q({0} Cal),
					},
					'foot' => {
						'name' => q(𑄜𑄪𑄖𑄴),
						'one' => q({0} 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄜𑄪𑄖𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄜𑄪𑄖𑄴),
					},
					'g-force' => {
						'name' => q(𑄎𑄨-𑄝𑄧𑄣𑄴),
						'one' => q({0} G),
						'other' => q({0} G),
					},
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal US),
					},
					'gallon-imperial' => {
						'name' => q(Imp. gal),
						'one' => q({0} gal Imp.),
						'other' => q({0} gal Imp.),
						'per' => q({0}/gal Imp.),
					},
					'generic' => {
						'name' => q(°),
						'one' => q({0}°),
						'other' => q({0}°),
					},
					'gigabit' => {
						'name' => q(Gb),
						'one' => q({0} Gb),
						'other' => q({0} Gb),
					},
					'gigabyte' => {
						'name' => q(GB),
						'one' => q({0} GB),
						'other' => q({0} GB),
					},
					'gigahertz' => {
						'name' => q(GHz),
						'one' => q({0} GHz),
						'other' => q({0} GHz),
					},
					'gigawatt' => {
						'name' => q(GW),
						'one' => q({0} GW),
						'other' => q({0} GW),
					},
					'gram' => {
						'name' => q(𑄉𑄳𑄢𑄟𑄴),
						'one' => q({0}𑄉𑄳𑄢𑄟𑄴),
						'other' => q({0} 𑄉𑄳𑄢𑄟𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄉𑄳𑄢𑄟𑄴),
					},
					'hectare' => {
						'name' => q(𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
						'one' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
						'other' => q({0} 𑄦𑄬𑄇𑄴𑄑𑄧𑄢𑄴),
					},
					'hectoliter' => {
						'name' => q(hL),
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					'hectopascal' => {
						'name' => q(hPa),
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					'hertz' => {
						'name' => q(Hz),
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					'horsepower' => {
						'name' => q(hp),
						'one' => q({0} hp),
						'other' => q({0} hp),
					},
					'hour' => {
						'name' => q(𑄊𑄧𑄚𑄴𑄑),
						'one' => q({0} 𑄊𑄧𑄚𑄴𑄑),
						'other' => q({0} 𑄊𑄧𑄚𑄴𑄑),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄊𑄧𑄚𑄴𑄑),
					},
					'inch' => {
						'name' => q(𑄃𑄨𑄚𑄴𑄌𑄨),
						'one' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨),
						'other' => q({0} 𑄃𑄨𑄚𑄴𑄌𑄨),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄨𑄚𑄴𑄌𑄨),
					},
					'inch-hg' => {
						'name' => q(inHg),
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					'joule' => {
						'name' => q(𑄎𑄪𑄣𑄴),
						'one' => q({0} J),
						'other' => q({0} J),
					},
					'karat' => {
						'name' => q(𑄇𑄳𑄠𑄢𑄬𑄖𑄴),
						'one' => q({0} kt),
						'other' => q({0} kt),
					},
					'kelvin' => {
						'name' => q(K),
						'one' => q({0} K),
						'other' => q({0} K),
					},
					'kilobit' => {
						'name' => q(kb),
						'one' => q({0} kb),
						'other' => q({0} kb),
					},
					'kilobyte' => {
						'name' => q(kB),
						'one' => q({0} kB),
						'other' => q({0} kB),
					},
					'kilocalorie' => {
						'name' => q(kcal),
						'one' => q({0} kcal),
						'other' => q({0} kcal),
					},
					'kilogram' => {
						'name' => q(𑄇𑄬𑄎𑄨),
						'one' => q({0} 𑄇𑄬𑄎𑄨),
						'other' => q({0} 𑄇𑄬𑄎𑄨),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄬𑄎𑄨),
					},
					'kilohertz' => {
						'name' => q(kHz),
						'one' => q({0} kHz),
						'other' => q({0} kHz),
					},
					'kilojoule' => {
						'name' => q(kJ),
						'one' => q({0} kJ),
						'other' => q({0} kJ),
					},
					'kilometer' => {
						'name' => q(𑄇𑄨𑄣𑄮𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄇𑄨𑄟𑄨),
						'other' => q({0} 𑄇𑄨𑄟𑄨),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄇𑄨𑄟𑄨),
					},
					'kilometer-per-hour' => {
						'name' => q(km/h),
						'one' => q({0} kph),
						'other' => q({0} km/h),
					},
					'kilowatt' => {
						'name' => q(kW),
						'one' => q({0} kW),
						'other' => q({0} kW),
					},
					'kilowatt-hour' => {
						'name' => q(kWh),
						'one' => q({0} kWh),
						'other' => q({0} kWh),
					},
					'knot' => {
						'name' => q(kn),
						'one' => q({0} kn),
						'other' => q({0} kn),
					},
					'light-year' => {
						'name' => q(𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴),
						'one' => q({0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴),
						'other' => q({0} 𑄃𑄣𑄮𑄇𑄴𑄝𑄧𑄏𑄧𑄢𑄴),
					},
					'liter' => {
						'name' => q(𑄣𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄣𑄨𑄑𑄢𑄴),
						'other' => q({0} 𑄣𑄨𑄑𑄢𑄴),
						'per' => q({0}/l),
					},
					'liter-per-100kilometers' => {
						'name' => q(L/100km),
						'one' => q({0} L/100km),
						'other' => q({0} L/100km),
					},
					'liter-per-kilometer' => {
						'name' => q(𑄣𑄨𑄑𑄢𑄴/𑄇𑄨𑄟𑄨),
						'one' => q({0} L/km),
						'other' => q({0} L/km),
					},
					'lux' => {
						'name' => q(lx),
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					'megabit' => {
						'name' => q(Mb),
						'one' => q({0} Mb),
						'other' => q({0} Mb),
					},
					'megabyte' => {
						'name' => q(MB),
						'one' => q({0} MB),
						'other' => q({0} MB),
					},
					'megahertz' => {
						'name' => q(MHz),
						'one' => q({0} MHz),
						'other' => q({0} MHz),
					},
					'megaliter' => {
						'name' => q(ML),
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					'megawatt' => {
						'name' => q(MW),
						'one' => q({0} MW),
						'other' => q({0} MW),
					},
					'meter' => {
						'name' => q(𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄟𑄨),
						'other' => q({0} 𑄟𑄨),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨),
					},
					'meter-per-second' => {
						'name' => q(𑄟𑄨𑄑𑄢𑄴 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} m/s),
						'other' => q({0} m/s),
					},
					'meter-per-second-squared' => {
						'name' => q(m/s²),
						'one' => q({0} m/s²),
						'other' => q({0} m/s²),
					},
					'metric-ton' => {
						'name' => q(t),
						'one' => q({0} t),
						'other' => q({0} t),
					},
					'microgram' => {
						'name' => q(µg),
						'one' => q({0} µg),
						'other' => q({0} µg),
					},
					'micrometer' => {
						'name' => q(µmeters),
						'one' => q({0} µm),
						'other' => q({0} µm),
					},
					'microsecond' => {
						'name' => q(μsecs),
						'one' => q({0} μs),
						'other' => q({0} μs),
					},
					'mile' => {
						'name' => q(𑄟𑄬𑄣𑄴),
						'one' => q({0} 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄟𑄬𑄣𑄴),
					},
					'mile-per-gallon' => {
						'name' => q(𑄟𑄬𑄣𑄴/𑄉𑄳𑄠𑄣𑄧𑄚𑄴),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					'mile-per-gallon-imperial' => {
						'name' => q(miles/gal Imp),
						'one' => q({0} mpg Imp.),
						'other' => q({0} mpg Imp.),
					},
					'mile-per-hour' => {
						'name' => q(𑄊𑄧𑄚𑄴𑄑 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄬𑄣𑄴),
						'one' => q({0} mph),
						'other' => q({0} mph),
					},
					'mile-scandinavian' => {
						'name' => q(smi),
						'one' => q({0} smi),
						'other' => q({0} smi),
					},
					'milliampere' => {
						'name' => q(mA),
						'one' => q({0} mA),
						'other' => q({0} mA),
					},
					'millibar' => {
						'name' => q(mbar),
						'one' => q({0} mbar),
						'other' => q({0} mbar),
					},
					'milligram' => {
						'name' => q(mg),
						'one' => q({0} mg),
						'other' => q({0} mg),
					},
					'milligram-per-deciliter' => {
						'name' => q(mg/dL),
						'one' => q({0} mg/dL),
						'other' => q({0} mg/dL),
					},
					'milliliter' => {
						'name' => q(mL),
						'one' => q({0} mL),
						'other' => q({0} mL),
					},
					'millimeter' => {
						'name' => q(𑄟𑄨𑄟𑄨),
						'one' => q({0} 𑄟𑄨𑄟𑄨),
						'other' => q({0} 𑄟𑄨𑄟𑄨),
					},
					'millimeter-of-mercury' => {
						'name' => q(mm Hg),
						'one' => q({0} mm Hg),
						'other' => q({0} mm Hg),
					},
					'millimole-per-liter' => {
						'name' => q(mmol/L),
						'one' => q({0} mmol/L),
						'other' => q({0} mmol/L),
					},
					'millisecond' => {
						'name' => q(𑄟𑄨𑄣𑄨𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} ms),
						'other' => q({0} ms),
					},
					'milliwatt' => {
						'name' => q(mW),
						'one' => q({0} mW),
						'other' => q({0} mW),
					},
					'minute' => {
						'name' => q(𑄟𑄨𑄚𑄨𑄖𑄴),
						'one' => q({0} 𑄟𑄨𑄚𑄨𑄖𑄴),
						'other' => q({0} 𑄟𑄨𑄚𑄨𑄖𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄨𑄚𑄨𑄖𑄴),
					},
					'month' => {
						'name' => q(𑄟𑄌𑄴),
						'one' => q({0} 𑄟𑄌𑄴),
						'other' => q({0} 𑄟𑄌𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄟𑄌𑄴),
					},
					'nanometer' => {
						'name' => q(nm),
						'one' => q({0} nm),
						'other' => q({0} nm),
					},
					'nanosecond' => {
						'name' => q(𑄚𑄳𑄠𑄚𑄮𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} ns),
						'other' => q({0} ns),
					},
					'nautical-mile' => {
						'name' => q(nmi),
						'one' => q({0} nmi),
						'other' => q({0} nmi),
					},
					'ohm' => {
						'name' => q(𑄃𑄮𑄦𑄧𑄟𑄴),
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					'ounce' => {
						'name' => q(𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
						'one' => q({0} 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
						'other' => q({0} 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄃𑄅𑄪𑄚𑄳𑄌𑄴),
					},
					'ounce-troy' => {
						'name' => q(oz t),
						'one' => q({0} oz t),
						'other' => q({0} oz t),
					},
					'parsec' => {
						'name' => q(parsecs),
						'one' => q({0} pc),
						'other' => q({0} pc),
					},
					'part-per-million' => {
						'name' => q(ppm),
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					'per' => {
						'1' => q({0}/{1}),
					},
					'picometer' => {
						'name' => q(𑄛𑄨𑄟𑄨),
						'one' => q({0} 𑄛𑄨𑄟𑄨),
						'other' => q({0} 𑄛𑄨𑄟𑄨),
					},
					'pint' => {
						'name' => q(pt),
						'one' => q({0} pt),
						'other' => q({0} pt),
					},
					'pint-metric' => {
						'name' => q(mpt),
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					'pound' => {
						'name' => q(𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
						'other' => q({0} lb),
						'per' => q({0}/lb),
					},
					'pound-per-square-inch' => {
						'name' => q(psi),
						'one' => q({0} psi),
						'other' => q({0} psi),
					},
					'quart' => {
						'name' => q(qt),
						'one' => q({0} qt),
						'other' => q({0} qt),
					},
					'radian' => {
						'name' => q(𑄢𑄬𑄓𑄨𑄠𑄳𑄠𑄚𑄳𑄌𑄴),
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					'revolution' => {
						'name' => q(𑄊𑄪𑄢𑄰𑄱),
						'one' => q({0} 𑄊𑄪𑄢𑄰𑄱),
						'other' => q({0} 𑄊𑄪𑄢𑄰𑄱),
					},
					'second' => {
						'name' => q(𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'one' => q({0} 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'other' => q({0} 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄬𑄇𑄬𑄚𑄳𑄓𑄴),
					},
					'square-centimeter' => {
						'name' => q(cm²),
						'one' => q({0} cm²),
						'other' => q({0} cm²),
						'per' => q({0}/cm²),
					},
					'square-foot' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄜𑄪𑄖𑄴),
					},
					'square-inch' => {
						'name' => q(in²),
						'one' => q({0} in²),
						'other' => q({0} in²),
						'per' => q({0}/in²),
					},
					'square-kilometer' => {
						'name' => q(km²),
						'one' => q({0} km²),
						'other' => q({0} km²),
						'per' => q({0}/𑄝𑄧𑄢𑄴𑄉𑄧 𑄇𑄨𑄟𑄨),
					},
					'square-meter' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄨𑄑𑄢𑄴),
						'other' => q({0} m²),
						'per' => q({0}/m²),
					},
					'square-mile' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴),
						'one' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴),
						'other' => q({0} 𑄝𑄧𑄢𑄴𑄉𑄧 𑄟𑄬𑄣𑄴),
						'per' => q({0}/mi²),
					},
					'square-yard' => {
						'name' => q(𑄝𑄧𑄢𑄴𑄉𑄧 𑄉𑄧𑄌𑄴),
						'one' => q({0} yd²),
						'other' => q({0} yd²),
					},
					'tablespoon' => {
						'name' => q(tbsp),
						'one' => q({0} tbsp),
						'other' => q({0} tbsp),
					},
					'teaspoon' => {
						'name' => q(tsp),
						'one' => q({0} tsp),
						'other' => q({0} tsp),
					},
					'terabit' => {
						'name' => q(Tbit),
						'one' => q({0} Tb),
						'other' => q({0} Tb),
					},
					'terabyte' => {
						'name' => q(TByte),
						'one' => q({0} TB),
						'other' => q({0} TB),
					},
					'ton' => {
						'name' => q(tn),
						'one' => q({0} tn),
						'other' => q({0} tn),
					},
					'volt' => {
						'name' => q(𑄞𑄮𑄣𑄴𑄑𑄴),
						'one' => q({0} V),
						'other' => q({0} V),
					},
					'watt' => {
						'name' => q(𑄤𑄖𑄴),
						'one' => q({0} W),
						'other' => q({0} W),
					},
					'week' => {
						'name' => q(𑄥𑄛𑄴𑄖),
						'one' => q({0} 𑄥𑄛𑄴𑄖),
						'other' => q({0} 𑄥𑄛𑄴𑄖),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄥𑄛𑄴𑄖),
					},
					'yard' => {
						'name' => q(𑄉𑄧𑄌𑄴),
						'one' => q({0} 𑄉𑄧𑄌𑄴),
						'other' => q({0} 𑄉𑄧𑄌𑄴),
					},
					'year' => {
						'name' => q(𑄝𑄧𑄏𑄧𑄢𑄴),
						'one' => q({0} 𑄝𑄧𑄏𑄧𑄢𑄴),
						'other' => q({0} 𑄝𑄧𑄏𑄧𑄢𑄴),
						'per' => q({0} 𑄛𑄳𑄢𑄧𑄖𑄨 𑄝𑄧𑄏𑄧𑄢𑄴),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:𑄃𑄳𑄦𑄨|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:𑄚|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}, {1}),
				middle => q({0}, {1}),
				end => q({0}, {1}),
				2 => q({0}, {1}),
		} }
);

has 'default_numbering_system' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'cakm',
);

has native_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'cakm',
);

has 'minimum_grouping_digits' => (
	is			=>'ro',
	isa			=> Int,
	init_arg	=> undef,
	default		=> 1,
);

has 'number_symbols' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'cakm' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'infinity' => q(∞),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'superscriptingExponent' => q(×),
		},
		'latn' => {
			'decimal' => q(.),
			'exponential' => q(E),
			'group' => q(,),
			'infinity' => q(∞),
			'list' => q(;),
			'minusSign' => q(-),
			'nan' => q(NaN),
			'perMille' => q(‰),
			'percentSign' => q(%),
			'plusSign' => q(+),
			'superscriptingExponent' => q(×),
			'timeSeparator' => q(:),
		},
	} }
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0.###',
				},
			},
		},
		percentFormat => {
			'default' => {
				'standard' => {
					'default' => '#,##,##0%',
				},
			},
		},
		scientificFormat => {
			'default' => {
				'standard' => {
					'default' => '#E0',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'cakm' => {
			'pattern' => {
				'default' => {
					'standard' => {
						'positive' => '#,##,##0.00¤',
					},
				},
			},
		},
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(#,##,##0.00¤)',
						'positive' => '#,##,##0.00¤',
					},
					'standard' => {
						'positive' => '#,##,##0.00¤',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'ADP' => {
			display_name => {
				'currency' => q(𑄃𑄳𑄠𑄚𑄴𑄓𑄮𑄢𑄚𑄴 𑄛𑄬𑄥𑄬𑄖),
			},
		},
		'AED' => {
			symbol => 'AED',
			display_name => {
				'currency' => q(𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴),
				'one' => q(𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴),
				'other' => q(𑄎𑄧𑄙 𑄃𑄢𑄧𑄝𑄴 𑄃𑄟𑄨𑄢𑄖𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴),
			},
		},
		'AFA' => {
			display_name => {
				'currency' => q(𑄃𑄛𑄴𑄉𑄚𑄨 \(𑄷𑄿𑄸𑄽-𑄸𑄶𑄶𑄸\)),
			},
		},
		'AFN' => {
			symbol => 'AFN',
			display_name => {
				'currency' => q(𑄃𑄜𑄴𑄉𑄚𑄴 𑄃𑄜𑄴𑄉𑄚𑄨),
				'one' => q(𑄃𑄜𑄴𑄉𑄚𑄴 𑄃𑄜𑄴𑄉𑄚𑄨),
				'other' => q(𑄃𑄜𑄴𑄉𑄚𑄴 𑄃𑄜𑄴𑄉𑄚𑄨),
			},
		},
		'ALL' => {
			symbol => 'ALL',
			display_name => {
				'currency' => q(𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠𑄚𑄴 𑄣𑄬𑄇𑄴),
				'one' => q(𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠𑄚𑄴 𑄣𑄬𑄇𑄴),
				'other' => q(𑄃𑄣𑄴𑄝𑄬𑄚𑄨𑄠𑄚𑄴 𑄣𑄬𑄇𑄴),
			},
		},
		'AMD' => {
			symbol => 'AMD',
			display_name => {
				'currency' => q(𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴 𑄘𑄳𑄢𑄟𑄴),
				'one' => q(𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴 𑄘𑄳𑄢𑄟𑄴),
				'other' => q(𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠𑄚𑄴 𑄘𑄳𑄢𑄟𑄴),
			},
		},
		'ANG' => {
			symbol => 'ANG',
			display_name => {
				'currency' => q(𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄳𑄠𑄚𑄴𑄑𑄨𑄣𑄨𑄠𑄚𑄴 𑄉𑄪𑄣𑄴𑄓𑄬𑄢𑄴),
				'one' => q(𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄳𑄠𑄚𑄴𑄑𑄨𑄣𑄨𑄠𑄚𑄴 𑄉𑄪𑄣𑄴𑄓𑄬𑄢𑄴),
				'other' => q(𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄳𑄠𑄚𑄴𑄑𑄨𑄣𑄨𑄠𑄚𑄴 𑄉𑄪𑄣𑄴𑄓𑄬𑄢𑄴),
			},
		},
		'AOA' => {
			symbol => 'AOA',
			display_name => {
				'currency' => q(𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎),
				'one' => q(𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎),
				'other' => q(𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎),
			},
		},
		'AOK' => {
			display_name => {
				'currency' => q(𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎\(𑄷𑄿𑄽𑄽-𑄷𑄿𑄿𑄶\)),
			},
		},
		'AON' => {
			display_name => {
				'currency' => q(𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄚𑄱 𑄇𑄧𑄤𑄮𑄚𑄴𑄎\(𑄷𑄿𑄿𑄻-𑄸𑄶𑄶𑄶\)),
			},
		},
		'AOR' => {
			display_name => {
				'currency' => q(𑄃𑄳𑄠𑄋𑄴𑄉𑄮𑄣𑄚𑄴 𑄇𑄧𑄤𑄮𑄚𑄴𑄎\(𑄷𑄿𑄿𑄻-𑄷𑄿𑄿𑄿\)),
			},
		},
		'ARA' => {
			display_name => {
				'currency' => q(𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄣𑄴),
			},
		},
		'ARP' => {
			display_name => {
				'currency' => q(𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄬𑄥𑄮 \(𑄷𑄿𑄾𑄹-𑄷𑄿𑄾𑄻\)),
			},
		},
		'ARS' => {
			symbol => 'ARS',
			display_name => {
				'currency' => q(𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄬𑄥𑄮),
				'one' => q(𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄬𑄥𑄮),
				'other' => q(𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄬𑄥𑄮),
			},
		},
		'ATS' => {
			display_name => {
				'currency' => q(𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
			},
		},
		'AUD' => {
			symbol => 'A$',
			display_name => {
				'currency' => q(𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'AWG' => {
			symbol => 'AWG',
			display_name => {
				'currency' => q(𑄃𑄢𑄪𑄝 𑄉𑄨𑄣𑄴𑄓𑄢𑄴),
				'one' => q(𑄃𑄢𑄪𑄝 𑄉𑄨𑄣𑄴𑄓𑄢𑄴),
				'other' => q(𑄃𑄢𑄪𑄝 𑄉𑄨𑄣𑄴𑄓𑄢𑄴),
			},
		},
		'AZM' => {
			display_name => {
				'currency' => q(𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄖𑄴 \(𑄷𑄿𑄿𑄹-𑄸𑄶𑄶𑄼\)),
			},
		},
		'AZN' => {
			symbol => 'AZN',
			display_name => {
				'currency' => q(𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄖𑄴),
				'one' => q(𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄖𑄴),
				'other' => q(𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄖𑄴),
			},
		},
		'BAD' => {
			display_name => {
				'currency' => q(𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄳𑄃 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'BAM' => {
			symbol => 'BAM',
			display_name => {
				'currency' => q(𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄳𑄃 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚 𑄟𑄢𑄴𑄇𑄴),
				'one' => q(𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄳𑄃 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚 𑄟𑄢𑄴𑄇𑄴),
				'other' => q(𑄝𑄧𑄥𑄴𑄚𑄨𑄠 𑄃𑄳𑄃 𑄦𑄢𑄴𑄎𑄬𑄉𑄮𑄞𑄨𑄚 𑄟𑄢𑄴𑄇𑄴),
			},
		},
		'BBD' => {
			symbol => 'BBD',
			display_name => {
				'currency' => q(𑄝𑄢𑄴𑄝𑄬𑄓𑄮𑄎𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄝𑄢𑄴𑄝𑄬𑄓𑄮𑄎𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄝𑄢𑄴𑄝𑄬𑄓𑄮𑄎𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'BDT' => {
			symbol => '৳',
			display_name => {
				'currency' => q(𑄝𑄁𑄣𑄘𑄬𑄥𑄨 𑄑𑄬𑄋),
				'one' => q(𑄝𑄁𑄣𑄘𑄬𑄥𑄨 𑄑𑄬𑄋),
				'other' => q(𑄝𑄁𑄣𑄘𑄬𑄥𑄨 𑄑𑄬𑄋),
			},
		},
		'BEC' => {
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄴𑄘𑄎𑄨𑄠𑄚𑄴 𑄜𑄳𑄢𑄋𑄴𑄇𑄴 \(𑄝𑄮𑄘𑄮𑄣𑄬𑄭𑄛𑄢𑄬\)),
			},
		},
		'BEF' => {
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄴𑄘𑄎𑄨𑄠𑄚𑄴 𑄜𑄳𑄢𑄋𑄴𑄇𑄴),
			},
		},
		'BEL' => {
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄴𑄘𑄎𑄨𑄠𑄚𑄴 𑄜𑄳𑄢𑄋𑄴𑄇𑄴 \(𑄃𑄢𑄴𑄗𑄨𑄇𑄴\)),
			},
		},
		'BGL' => {
			display_name => {
				'currency' => q(𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄩𑄠𑄧 𑄦𑄢𑄴𑄓𑄴 𑄣𑄬𑄞𑄴),
			},
		},
		'BGN' => {
			symbol => 'BGN',
			display_name => {
				'currency' => q(𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄩𑄠𑄧 𑄚𑄱 𑄣𑄬𑄞𑄴),
				'one' => q(𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄩𑄠𑄧 𑄚𑄱 𑄣𑄬𑄞𑄴),
				'other' => q(𑄝𑄪𑄣𑄴𑄉𑄬𑄢𑄩𑄠𑄧 𑄚𑄱 𑄣𑄬𑄞𑄴),
			},
		},
		'BHD' => {
			symbol => 'BHD',
			display_name => {
				'currency' => q(𑄝𑄦𑄧𑄢𑄭𑄚𑄨 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄝𑄦𑄧𑄢𑄭𑄚𑄨 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄝𑄦𑄧𑄢𑄭𑄚𑄨 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'BIF' => {
			symbol => 'BIF',
			display_name => {
				'currency' => q(𑄝𑄪𑄢𑄪𑄚𑄴𑄓𑄨 𑄜𑄳𑄢𑄋𑄴𑄇𑄴),
				'one' => q(𑄝𑄪𑄢𑄪𑄚𑄴𑄓𑄨 𑄜𑄳𑄢𑄋𑄴𑄇𑄴),
				'other' => q(𑄝𑄪𑄢𑄪𑄚𑄴𑄓𑄨 𑄜𑄳𑄢𑄋𑄴𑄇𑄴),
			},
		},
		'BMD' => {
			symbol => 'BMD',
			display_name => {
				'currency' => q(𑄝𑄢𑄴𑄟𑄨𑄅𑄪𑄓𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄝𑄢𑄴𑄟𑄨𑄅𑄪𑄓𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄝𑄢𑄴𑄟𑄨𑄅𑄪𑄓𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'BND' => {
			symbol => 'BND',
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄪𑄚𑄬𑄭 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄝𑄳𑄢𑄪𑄚𑄬𑄭 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄝𑄳𑄢𑄪𑄚𑄬𑄭 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'BOB' => {
			symbol => 'BOB',
			display_name => {
				'currency' => q(𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄮),
				'one' => q(𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄮),
				'other' => q(𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄮),
			},
		},
		'BOP' => {
			display_name => {
				'currency' => q(𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄴 𑄛𑄬𑄥𑄮),
			},
		},
		'BOV' => {
			display_name => {
				'currency' => q(𑄝𑄧𑄣𑄨𑄞𑄨𑄠𑄚𑄴 𑄟𑄧𑄞𑄴𑄓𑄮𑄣𑄴),
			},
		},
		'BRB' => {
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄇𑄳𑄢𑄪𑄎𑄬𑄠𑄧𑄢𑄮𑄚𑄮𑄞𑄮 \(𑄷𑄿𑄼𑄽-𑄷𑄿𑄾𑄼\)),
			},
		},
		'BRC' => {
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄇𑄳𑄢𑄪𑄎𑄬𑄭𑄓𑄅𑄪),
			},
		},
		'BRE' => {
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄇𑄳𑄢𑄪𑄎𑄬𑄠𑄧𑄢𑄮 \(𑄷𑄿𑄿𑄶-𑄷𑄿𑄿𑄹\)),
			},
		},
		'BRL' => {
			symbol => 'R$',
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
				'one' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
				'other' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
			},
		},
		'BRN' => {
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄝𑄳𑄢𑄪𑄎𑄬𑄭𑄓𑄮 𑄚𑄮𑄞𑄮),
			},
		},
		'BRR' => {
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄎𑄨𑄣𑄨𑄠𑄚𑄴 𑄝𑄳𑄢𑄪𑄎𑄬𑄠𑄧𑄢𑄮),
			},
		},
		'BSD' => {
			symbol => 'BSD',
			display_name => {
				'currency' => q(𑄝𑄦𑄟𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄝𑄦𑄟𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄝𑄦𑄟𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'BTN' => {
			symbol => 'BTN',
			display_name => {
				'currency' => q(𑄞𑄪𑄑𑄚𑄨 𑄃𑄬𑄚𑄴𑄉𑄪𑄣𑄴𑄑𑄳𑄢𑄟𑄴𑄛𑄴),
				'one' => q(𑄞𑄪𑄑𑄚𑄨 𑄃𑄬𑄚𑄴𑄉𑄪𑄣𑄴𑄑𑄳𑄢𑄟𑄴𑄛𑄴),
				'other' => q(𑄞𑄪𑄑𑄚𑄨 𑄃𑄬𑄚𑄴𑄉𑄪𑄣𑄴𑄑𑄳𑄢𑄟𑄴𑄛𑄴),
			},
		},
		'BUK' => {
			display_name => {
				'currency' => q(𑄝𑄧𑄢𑄴𑄟𑄨 𑄇𑄨𑄠𑄖𑄴),
			},
		},
		'BWP' => {
			symbol => 'BWP',
			display_name => {
				'currency' => q(𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚 𑄛𑄪𑄣),
				'one' => q(𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚 𑄛𑄪𑄣),
				'other' => q(𑄝𑄧𑄖𑄴𑄥𑄮𑄠𑄚 𑄛𑄪𑄣),
			},
		},
		'BYB' => {
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄚𑄨𑄅𑄪 𑄢𑄪𑄝𑄬𑄣𑄴 \(𑄷𑄿𑄿𑄺-𑄷𑄿𑄿𑄿\)),
			},
		},
		'BYN' => {
			symbol => 'BYN',
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴),
				'one' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴),
				'other' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴),
			},
		},
		'BYR' => {
			symbol => 'BYR',
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴\(𑄸𑄶𑄶𑄶-𑄸𑄶𑄷𑄼\)),
				'one' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴\(𑄸𑄶𑄶𑄶-𑄸𑄶𑄷𑄼\)),
				'other' => q(𑄝𑄬𑄣𑄢𑄪𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴\(𑄸𑄶𑄶𑄶-𑄸𑄶𑄷𑄼\)),
			},
		},
		'BZD' => {
			symbol => 'BZD',
			display_name => {
				'currency' => q(𑄝𑄬𑄣𑄨𑄎𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄝𑄬𑄣𑄨𑄎𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄝𑄬𑄣𑄨𑄎𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'CAD' => {
			symbol => 'CA$',
			display_name => {
				'currency' => q(𑄇𑄚𑄓𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄇𑄚𑄓𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄇𑄚𑄓𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'CDF' => {
			symbol => 'CDF',
			display_name => {
				'currency' => q(𑄇𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄌𑄴 𑄜𑄳𑄢𑄁𑄇𑄴),
				'one' => q(𑄇𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄌𑄴 𑄜𑄳𑄢𑄁𑄇𑄴),
				'other' => q(𑄇𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄌𑄴 𑄜𑄳𑄢𑄁𑄇𑄴),
			},
		},
		'CHF' => {
			symbol => 'CHF',
			display_name => {
				'currency' => q(𑄥𑄭𑄪𑄥𑄴 𑄜𑄳𑄢𑄀),
				'one' => q(𑄥𑄭𑄪𑄥𑄴 𑄜𑄳𑄢𑄀),
				'other' => q(𑄥𑄭𑄪𑄥𑄴 𑄜𑄳𑄢𑄀),
			},
		},
		'CLF' => {
			display_name => {
				'currency' => q(𑄌𑄨𑄣𑄨𑄠𑄚𑄴 𑄃𑄪𑄚𑄨𑄘𑄘𑄬𑄥𑄴 𑄘𑄨 𑄜𑄮𑄟𑄬𑄚𑄴𑄖𑄮),
			},
		},
		'CLP' => {
			symbol => 'CLP',
			display_name => {
				'currency' => q(𑄌𑄨𑄣𑄨 𑄛𑄬𑄥𑄮),
				'one' => q(𑄌𑄨𑄣𑄨 𑄛𑄬𑄥𑄮),
				'other' => q(𑄌𑄨𑄣𑄨 𑄛𑄬𑄥𑄮),
			},
		},
		'CNY' => {
			symbol => 'CN¥',
			display_name => {
				'currency' => q(𑄌𑄩𑄚 𑄠𑄪𑄠𑄚𑄴),
				'one' => q(𑄌𑄩𑄚 𑄠𑄪𑄠𑄚𑄴),
				'other' => q(𑄌𑄩𑄚 𑄠𑄪𑄠𑄚𑄴),
			},
		},
		'COP' => {
			symbol => 'COP',
			display_name => {
				'currency' => q(𑄇𑄧𑄣𑄮𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄛𑄬𑄥𑄮),
				'one' => q(𑄇𑄧𑄣𑄮𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄛𑄬𑄥𑄮),
				'other' => q(𑄇𑄧𑄣𑄮𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄛𑄬𑄥𑄮),
			},
		},
		'COU' => {
			display_name => {
				'currency' => q(𑄃𑄪𑄚𑄨𑄘𑄖𑄴 𑄘𑄨 𑄞𑄳𑄠𑄣𑄮𑄢𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
			},
		},
		'CRC' => {
			symbol => 'CRC',
			display_name => {
				'currency' => q(𑄇𑄮𑄥𑄴𑄑𑄢𑄨𑄇 𑄇𑄮𑄣𑄮𑄚𑄴),
				'one' => q(𑄇𑄮𑄥𑄴𑄑𑄢𑄨𑄇 𑄇𑄮𑄣𑄮𑄚𑄴),
				'other' => q(𑄇𑄮𑄥𑄴𑄑𑄢𑄨𑄇 𑄇𑄮𑄣𑄮𑄚𑄴),
			},
		},
		'CSD' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄢𑄮𑄚𑄨 𑄥𑄢𑄴𑄝𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'CSK' => {
			display_name => {
				'currency' => q(𑄌𑄬𑄇𑄮𑄥𑄳𑄣𑄮𑄞𑄇𑄴 𑄦𑄢𑄴𑄓𑄴 𑄇𑄮𑄢𑄪𑄚),
			},
		},
		'CUC' => {
			symbol => 'CUC',
			display_name => {
				'currency' => q(𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄝𑄮𑄘𑄮𑄣𑄨𑄛𑄢𑄬 𑄛𑄬𑄥𑄮),
				'one' => q(𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄝𑄮𑄘𑄮𑄣𑄨𑄛𑄢𑄬 𑄛𑄬𑄥𑄮),
				'other' => q(𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄝𑄮𑄘𑄮𑄣𑄨𑄛𑄢𑄬 𑄛𑄬𑄥𑄮),
			},
		},
		'CUP' => {
			symbol => 'CUP',
			display_name => {
				'currency' => q(𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄛𑄬𑄥𑄮),
				'one' => q(𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄛𑄬𑄥𑄮),
				'other' => q(𑄇𑄨𑄅𑄪𑄝𑄚𑄴 𑄛𑄬𑄥𑄮),
			},
		},
		'CVE' => {
			symbol => 'CVE',
			display_name => {
				'currency' => q(𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄬 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮),
				'one' => q(𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄬 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮),
				'other' => q(𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄬 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮),
			},
		},
		'CYP' => {
			display_name => {
				'currency' => q(𑄥𑄭𑄛𑄳𑄢𑄥𑄴 𑄛𑄃𑄪𑄚𑄴𑄓𑄴),
			},
		},
		'CZK' => {
			symbol => 'CZK',
			display_name => {
				'currency' => q(𑄌𑄬𑄇𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧 𑄇𑄮𑄢𑄪𑄚),
				'one' => q(𑄌𑄬𑄇𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧 𑄇𑄮𑄢𑄪𑄚),
				'other' => q(𑄌𑄬𑄇𑄴 𑄛𑄳𑄢𑄧𑄎𑄖𑄧𑄚𑄴𑄖𑄳𑄢𑄧 𑄇𑄮𑄢𑄪𑄚),
			},
		},
		'DDM' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄉𑄬𑄘𑄨 𑄎𑄢𑄴𑄟𑄚𑄴 𑄟𑄢𑄴𑄇𑄴),
			},
		},
		'DEM' => {
			display_name => {
				'currency' => q(𑄓𑄧𑄠𑄧𑄌𑄴 𑄟𑄢𑄴𑄇𑄴),
			},
		},
		'DJF' => {
			symbol => 'DJF',
			display_name => {
				'currency' => q(𑄎𑄨𑄝𑄪𑄖𑄨 𑄜𑄳𑄢𑄁𑄇𑄴),
				'one' => q(𑄎𑄨𑄝𑄪𑄖𑄨 𑄜𑄳𑄢𑄁𑄇𑄴),
				'other' => q(𑄎𑄨𑄝𑄪𑄖𑄨 𑄜𑄳𑄢𑄁),
			},
		},
		'DKK' => {
			symbol => 'DKK',
			display_name => {
				'currency' => q(𑄓𑄳𑄠𑄚𑄨𑄌𑄴 𑄇𑄳𑄢𑄯𑄚𑄴),
				'one' => q(𑄓𑄳𑄠𑄚𑄨𑄌𑄴 𑄇𑄳𑄢𑄯𑄚𑄴),
				'other' => q(𑄓𑄳𑄠𑄚𑄨𑄌𑄴 𑄇𑄳𑄢𑄯𑄚𑄴),
			},
		},
		'DOP' => {
			symbol => 'DOP',
			display_name => {
				'currency' => q(𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮),
				'one' => q(𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮),
				'other' => q(𑄓𑄮𑄟𑄨𑄚𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮),
			},
		},
		'DZD' => {
			symbol => 'DZD',
			display_name => {
				'currency' => q(𑄃𑄢𑄴𑄎𑄬𑄢𑄩𑄠𑄧 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄃𑄢𑄴𑄎𑄬𑄢𑄩𑄠𑄧 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄃𑄢𑄴𑄎𑄬𑄢𑄩𑄠𑄧 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'ECS' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄇𑄪𑄠𑄓𑄮𑄢𑄴 𑄥𑄪𑄇𑄳𑄢𑄬),
			},
		},
		'ECV' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄇𑄪𑄠𑄓𑄮𑄢𑄴 𑄃𑄪𑄚𑄨𑄘𑄘𑄬𑄌𑄴 𑄘𑄨 𑄞𑄬𑄣𑄧𑄢𑄴 𑄇𑄧𑄚𑄴𑄥𑄴𑄖𑄚𑄴𑄖𑄬 \(𑄃𑄨𑄅𑄪𑄞𑄨𑄥𑄨\)),
			},
		},
		'EEK' => {
			display_name => {
				'currency' => q(𑄃𑄬𑄌𑄴𑄖𑄮𑄚𑄨𑄠 𑄇𑄳𑄢𑄪𑄚𑄨),
			},
		},
		'EGP' => {
			symbol => 'EGP',
			display_name => {
				'currency' => q(𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄴 𑄛𑄅𑄪𑄚𑄴𑄓𑄴),
				'one' => q(𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄴 𑄛𑄅𑄪𑄚𑄴𑄓𑄴),
				'other' => q(𑄟𑄨𑄥𑄧𑄢𑄩𑄠𑄴 𑄛𑄅𑄪𑄚𑄴𑄓𑄴),
			},
		},
		'ERN' => {
			symbol => 'ERN',
			display_name => {
				'currency' => q(𑄃𑄬𑄢𑄨𑄑𑄳𑄢𑄨𑄠𑄬𑄚𑄴 𑄚𑄇𑄴𑄜),
				'one' => q(𑄃𑄬𑄢𑄨𑄑𑄳𑄢𑄨𑄠𑄬𑄚𑄴 𑄚𑄇𑄴𑄜),
				'other' => q(𑄃𑄬𑄢𑄨𑄑𑄳𑄢𑄨𑄠𑄬𑄚𑄴 𑄚𑄇𑄴𑄜),
			},
		},
		'ESA' => {
			display_name => {
				'currency' => q(𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄥𑄴 𑄛𑄬𑄥𑄬𑄖 \(𑄃𑄬𑄇𑄴𑄇𑄭𑄪 𑄦𑄨𑄎𑄬𑄛𑄴\)),
			},
		},
		'ESB' => {
			display_name => {
				'currency' => q(𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄥𑄴 𑄛𑄬𑄥𑄬𑄖 \(𑄝𑄮𑄘𑄮𑄣𑄬𑄭 𑄛𑄢𑄬 𑄦𑄨𑄎𑄬𑄛𑄴\)),
			},
		},
		'ESP' => {
			display_name => {
				'currency' => q(𑄥𑄳𑄛𑄳𑄠𑄚𑄨𑄥𑄴 𑄛𑄬𑄥𑄬𑄖),
			},
		},
		'ETB' => {
			symbol => 'ETB',
			display_name => {
				'currency' => q(𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄠𑄚𑄴 𑄝𑄨𑄢𑄴),
				'one' => q(𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄠𑄚𑄴 𑄝𑄨𑄢𑄴),
				'other' => q(𑄃𑄨𑄗𑄨𑄃𑄮𑄛𑄨𑄠𑄚𑄴 𑄝𑄨𑄢𑄴),
			},
		},
		'EUR' => {
			symbol => '€',
			display_name => {
				'currency' => q(𑄃𑄨𑄅𑄪𑄢𑄮),
				'one' => q(𑄃𑄨𑄅𑄪𑄢𑄮),
				'other' => q(𑄃𑄨𑄅𑄪𑄢𑄮),
			},
		},
		'FIM' => {
			display_name => {
				'currency' => q(𑄜𑄨𑄚𑄨𑄥𑄴 𑄟𑄢𑄴𑄇),
			},
		},
		'FJD' => {
			symbol => 'FJD',
			display_name => {
				'currency' => q(𑄜𑄨𑄎𑄨 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄜𑄨𑄎𑄨 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄜𑄨𑄎𑄨 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'FKP' => {
			symbol => 'FKP',
			display_name => {
				'currency' => q(𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄛𑄃𑄪𑄚𑄴𑄓𑄴),
				'one' => q(𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄛𑄃𑄪𑄚𑄴𑄓𑄴),
				'other' => q(𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄛𑄃𑄪𑄚𑄴𑄓𑄴),
			},
		},
		'FRF' => {
			display_name => {
				'currency' => q(𑄜𑄧𑄢𑄥𑄨 𑄜𑄳𑄢𑄁𑄇𑄴),
			},
		},
		'GBP' => {
			symbol => '£',
			display_name => {
				'currency' => q(𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄛𑄃𑄪𑄚𑄴),
				'one' => q(𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄛𑄃𑄪𑄚𑄴),
				'other' => q(𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄛𑄃𑄪𑄚𑄴),
			},
		},
		'GEK' => {
			display_name => {
				'currency' => q(𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄇𑄪𑄛𑄧𑄚𑄴 𑄣𑄢𑄨𑄖𑄴),
			},
		},
		'GEL' => {
			symbol => 'GEL',
			display_name => {
				'currency' => q(𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄣𑄢𑄨),
				'one' => q(𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄣𑄢𑄨),
				'other' => q(𑄎𑄧𑄢𑄴𑄎𑄨𑄠𑄚𑄴 𑄣𑄢𑄨),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(𑄊𑄚 𑄥𑄬𑄓𑄨 \(𑄷𑄿𑄽𑄿-𑄸𑄶𑄶𑄽\)),
			},
		},
		'GHS' => {
			symbol => 'GHS',
			display_name => {
				'currency' => q(𑄊𑄚 𑄥𑄬𑄓𑄨),
				'one' => q(𑄊𑄚 𑄥𑄬𑄓𑄨),
				'other' => q(𑄊𑄚 𑄥𑄬𑄓𑄨),
			},
		},
		'GIP' => {
			symbol => 'GIP',
			display_name => {
				'currency' => q(𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
				'one' => q(𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
				'other' => q(𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'GMD' => {
			symbol => 'GMD',
			display_name => {
				'currency' => q(𑄉𑄟𑄴𑄝𑄨𑄠 𑄓𑄣𑄥𑄨),
				'one' => q(𑄉𑄟𑄴𑄝𑄨𑄠 𑄓𑄣𑄥𑄨),
				'other' => q(𑄉𑄟𑄴𑄝𑄨𑄠 𑄓𑄣𑄥𑄨),
			},
		},
		'GNF' => {
			symbol => 'GNF',
			display_name => {
				'currency' => q(𑄉𑄨𑄚𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
				'one' => q(𑄉𑄨𑄚𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
				'other' => q(𑄉𑄨𑄚𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'GNS' => {
			display_name => {
				'currency' => q(𑄉𑄨𑄚𑄨 𑄥𑄭𑄣𑄨),
			},
		},
		'GQE' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄇𑄪𑄠𑄬𑄑𑄮𑄢𑄨𑄠𑄣𑄴 𑄉𑄨𑄚𑄨 𑄃𑄨𑄇𑄪𑄠𑄨𑄣𑄨),
			},
		},
		'GRD' => {
			display_name => {
				'currency' => q(𑄉𑄳𑄢𑄩𑄇𑄴 𑄘𑄳𑄢𑄌𑄴𑄟),
			},
		},
		'GTQ' => {
			symbol => 'GTQ',
			display_name => {
				'currency' => q(𑄉𑄪𑄠𑄖𑄬𑄟𑄣𑄧 𑄇𑄪𑄠𑄬𑄖𑄴𑄎𑄣𑄴),
				'one' => q(𑄉𑄪𑄠𑄖𑄬𑄟𑄣𑄧 𑄇𑄪𑄠𑄬𑄖𑄴𑄎𑄣𑄴),
				'other' => q(𑄉𑄪𑄠𑄖𑄬𑄟𑄣𑄧 𑄇𑄪𑄠𑄬𑄖𑄴𑄎𑄣𑄴),
			},
		},
		'GWE' => {
			display_name => {
				'currency' => q(𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄎𑄴 𑄉𑄨𑄚𑄨 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮),
			},
		},
		'GWP' => {
			display_name => {
				'currency' => q(𑄉𑄨𑄚𑄨 𑄥𑄨𑄥𑄅𑄪 𑄛𑄬𑄥𑄮),
			},
		},
		'GYD' => {
			symbol => 'GYD',
			display_name => {
				'currency' => q(𑄉𑄭𑄠𑄬𑄚 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄉𑄭𑄠𑄬𑄚 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄉𑄭𑄠𑄬𑄚 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'HKD' => {
			symbol => 'HK$',
			display_name => {
				'currency' => q(𑄦𑄧𑄁𑄇𑄧𑄁 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄦𑄧𑄁𑄇𑄧𑄁 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄦𑄧𑄁𑄇𑄧𑄁 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'HNL' => {
			symbol => 'HNL',
			display_name => {
				'currency' => q(𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴 𑄣𑄬𑄟𑄴𑄛𑄨𑄢),
				'one' => q(𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴 𑄣𑄬𑄟𑄴𑄛𑄨𑄢),
				'other' => q(𑄦𑄪𑄚𑄴𑄓𑄪𑄢𑄥𑄴 𑄣𑄬𑄟𑄴𑄛𑄨𑄢),
			},
		},
		'HRD' => {
			display_name => {
				'currency' => q(𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'HRK' => {
			symbol => 'HRK',
			display_name => {
				'currency' => q(𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄇𑄪𑄚),
				'one' => q(𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄇𑄪𑄚),
				'other' => q(𑄇𑄳𑄢𑄮𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄇𑄪𑄚),
			},
		},
		'HTG' => {
			symbol => 'HTG',
			display_name => {
				'currency' => q(𑄦𑄭𑄖𑄨 𑄉𑄯𑄢𑄴𑄘𑄬),
				'one' => q(𑄦𑄭𑄖𑄨 𑄉𑄯𑄢𑄴𑄘𑄬),
				'other' => q(𑄦𑄭𑄖𑄨 𑄉𑄯𑄢𑄴𑄘𑄬),
			},
		},
		'HUF' => {
			symbol => 'HUF',
			display_name => {
				'currency' => q(𑄦𑄋𑄴𑄉𑄬𑄢𑄨𑄠𑄚𑄴 𑄜𑄮𑄢𑄨𑄚𑄳𑄑𑄴),
				'one' => q(𑄦𑄋𑄴𑄉𑄬𑄢𑄨𑄠𑄚𑄴 𑄜𑄮𑄢𑄨𑄚𑄳𑄑𑄴),
				'other' => q(𑄦𑄋𑄴𑄉𑄬𑄢𑄨𑄠𑄚𑄴 𑄜𑄮𑄢𑄨𑄚𑄳𑄑𑄴),
			},
		},
		'IDR' => {
			symbol => 'IDR',
			display_name => {
				'currency' => q(𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨𑄠𑄳𑄦𑄴),
				'one' => q(𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨𑄠𑄳𑄦𑄴),
				'other' => q(𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨𑄠𑄳𑄦𑄴),
			},
		},
		'IEP' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄢𑄨𑄌𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'ILP' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄥𑄳𑄢𑄭𑄣𑄨 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'ILS' => {
			symbol => '₪',
			display_name => {
				'currency' => q(𑄃𑄨𑄥𑄳𑄢𑄭𑄣𑄨 𑄚𑄱 𑄥𑄬𑄇𑄬𑄣𑄴),
				'one' => q(𑄃𑄨𑄥𑄳𑄢𑄭𑄣𑄨 𑄚𑄱 𑄥𑄬𑄇𑄬𑄣𑄴),
				'other' => q(𑄃𑄨𑄥𑄳𑄢𑄭𑄣𑄨 𑄚𑄱 𑄥𑄬𑄇𑄬𑄣𑄴),
			},
		},
		'INR' => {
			symbol => '₹',
			display_name => {
				'currency' => q(𑄃𑄨𑄚𑄴𑄘𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨),
				'one' => q(𑄃𑄨𑄚𑄴𑄘𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨),
				'other' => q(𑄃𑄨𑄚𑄴𑄘𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨),
			},
		},
		'IQD' => {
			symbol => 'IQD',
			display_name => {
				'currency' => q(𑄃𑄨𑄢𑄇𑄨 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄃𑄨𑄢𑄇𑄨 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄃𑄨𑄢𑄇𑄨 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'IRR' => {
			symbol => 'IRR',
			display_name => {
				'currency' => q(𑄃𑄨𑄢𑄚𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄣𑄴),
				'one' => q(𑄃𑄨𑄢𑄚𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄣𑄴),
				'other' => q(𑄃𑄨𑄢𑄚𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄣𑄴),
			},
		},
		'ISK' => {
			symbol => 'ISK',
			display_name => {
				'currency' => q(𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄇𑄳𑄢𑄯𑄚𑄴),
				'one' => q(𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄇𑄳𑄢𑄯𑄚𑄴),
				'other' => q(𑄃𑄭𑄥𑄴𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄇𑄳𑄢𑄯𑄚𑄴),
			},
		},
		'ITL' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄖𑄣𑄨𑄠𑄧 𑄣𑄨𑄢),
			},
		},
		'JMD' => {
			symbol => 'JMD',
			display_name => {
				'currency' => q(𑄎𑄟𑄭𑄇𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄎𑄟𑄭𑄇𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄎𑄟𑄭𑄇𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'JOD' => {
			symbol => 'JOD',
			display_name => {
				'currency' => q(𑄎𑄧𑄢𑄴𑄓𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄎𑄧𑄢𑄴𑄓𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄎𑄧𑄢𑄴𑄓𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'JPY' => {
			symbol => 'JP¥',
			display_name => {
				'currency' => q(𑄎𑄛𑄚𑄨 𑄃𑄨𑄠𑄬𑄚𑄴),
				'one' => q(𑄎𑄛𑄚𑄨 𑄃𑄨𑄠𑄬𑄚𑄴),
				'other' => q(𑄎𑄛𑄚𑄨 𑄃𑄨𑄠𑄬𑄚𑄴),
			},
		},
		'KES' => {
			symbol => 'KES',
			display_name => {
				'currency' => q(𑄇𑄬𑄚𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
				'one' => q(𑄇𑄬𑄚𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
				'other' => q(𑄇𑄬𑄚𑄨𑄠𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
			},
		},
		'KGS' => {
			symbol => 'KGS',
			display_name => {
				'currency' => q(𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄴𑄃𑄨𑄥𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄴),
				'one' => q(𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄴𑄃𑄨𑄥𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄴),
				'other' => q(𑄇𑄨𑄢𑄴𑄉𑄨𑄎𑄴𑄃𑄨𑄥𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄴),
			},
		},
		'KHR' => {
			symbol => 'KHR',
			display_name => {
				'currency' => q(𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
				'one' => q(𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
				'other' => q(𑄇𑄧𑄟𑄴𑄝𑄮𑄓𑄨𑄠𑄚𑄴 𑄢𑄨𑄠𑄬𑄣𑄴),
			},
		},
		'KMF' => {
			symbol => 'KMF',
			display_name => {
				'currency' => q(𑄇𑄧𑄟𑄴𑄝𑄮𑄢𑄮 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
				'one' => q(𑄇𑄧𑄟𑄴𑄝𑄮𑄢𑄮 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
				'other' => q(𑄇𑄧𑄟𑄴𑄝𑄮𑄢𑄮 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'KPW' => {
			symbol => 'KPW',
			display_name => {
				'currency' => q(𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴),
				'one' => q(𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴),
				'other' => q(𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴),
			},
		},
		'KRW' => {
			symbol => '₩',
			display_name => {
				'currency' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴),
				'one' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴),
				'other' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄇𑄮𑄢𑄨𑄠𑄢𑄴 𑄃𑄮𑄚𑄴),
			},
		},
		'KWD' => {
			symbol => 'KWD',
			display_name => {
				'currency' => q(𑄇𑄪𑄠𑄬𑄖𑄨 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄇𑄪𑄠𑄬𑄖𑄨 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄇𑄪𑄠𑄬𑄖𑄨 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'KYD' => {
			symbol => 'KYD',
			display_name => {
				'currency' => q(𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄇𑄬𑄟𑄳𑄠𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'KZT' => {
			symbol => 'KZT',
			display_name => {
				'currency' => q(𑄇𑄎𑄈𑄥𑄴𑄖𑄚𑄨 𑄑𑄬𑄋𑄴𑄉𑄬),
				'one' => q(𑄇𑄎𑄈𑄥𑄴𑄖𑄚𑄨 𑄑𑄬𑄋𑄴𑄉𑄬),
				'other' => q(𑄇𑄎𑄈𑄥𑄴𑄖𑄚𑄨 𑄑𑄬𑄋𑄴𑄉𑄬),
			},
		},
		'LAK' => {
			symbol => 'LAK',
			display_name => {
				'currency' => q(𑄣𑄬𑄅𑄪𑄥𑄚𑄴 𑄇𑄨𑄛𑄴),
				'one' => q(𑄣𑄬𑄅𑄪𑄥𑄚𑄴 𑄇𑄨𑄛𑄴),
				'other' => q(𑄣𑄬𑄅𑄪𑄥𑄚𑄴 𑄇𑄨𑄛𑄴),
			},
		},
		'LBP' => {
			symbol => 'LBP',
			display_name => {
				'currency' => q(𑄣𑄬𑄝𑄚𑄨𑄎𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
				'one' => q(𑄣𑄬𑄝𑄚𑄨𑄎𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
				'other' => q(𑄣𑄬𑄝𑄚𑄨𑄎𑄴 𑄛𑄅𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'LKR' => {
			symbol => 'LKR',
			display_name => {
				'currency' => q(𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇𑄚𑄴 𑄢𑄪𑄛𑄨),
				'one' => q(𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇𑄚𑄴 𑄢𑄪𑄛𑄨),
				'other' => q(𑄥𑄳𑄢𑄨𑄣𑄧𑄁𑄇𑄚𑄴 𑄢𑄪𑄛𑄨),
			},
		},
		'LRD' => {
			symbol => 'LRD',
			display_name => {
				'currency' => q(𑄣𑄨𑄝𑄬𑄢𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄣𑄨𑄝𑄬𑄢𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄣𑄨𑄝𑄬𑄢𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(𑄣𑄬𑄥𑄪𑄑𑄪 𑄣𑄮𑄑𑄨),
			},
		},
		'LTL' => {
			symbol => 'LTL',
			display_name => {
				'currency' => q(𑄣𑄨𑄗𑄭𑄪𑄚𑄨𑄠𑄚𑄴 𑄣𑄨𑄑),
				'one' => q(𑄣𑄨𑄗𑄭𑄪𑄚𑄨𑄠𑄚𑄴 𑄣𑄨𑄑),
				'other' => q(𑄣𑄨𑄗𑄭𑄪𑄚𑄨𑄠𑄚𑄴 𑄣𑄨𑄑),
			},
		},
		'LTT' => {
			display_name => {
				'currency' => q(𑄣𑄨𑄗𑄭𑄪𑄚𑄨𑄠𑄚𑄴 𑄑𑄣𑄮𑄚𑄳𑄠𑄥𑄴),
			},
		},
		'LUC' => {
			display_name => {
				'currency' => q(𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴 𑄝𑄮𑄘𑄮𑄣𑄬𑄝𑄢𑄴 𑄜𑄳𑄢𑄇𑄳𑄋𑄴),
			},
		},
		'LUF' => {
			display_name => {
				'currency' => q(𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴 𑄜𑄳𑄢𑄇𑄳𑄋𑄴),
			},
		},
		'LUL' => {
			display_name => {
				'currency' => q(𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴 𑄜𑄭𑄚𑄬𑄚𑄴𑄥𑄨𑄠𑄣𑄴 𑄜𑄳𑄢𑄇𑄳𑄋𑄴),
			},
		},
		'LVL' => {
			symbol => 'LVL',
			display_name => {
				'currency' => q(𑄣𑄳𑄠𑄑𑄴𑄞𑄨𑄠𑄚𑄴 𑄣𑄳𑄠𑄑𑄴𑄥𑄴),
				'one' => q(𑄣𑄳𑄠𑄑𑄴𑄞𑄨𑄠𑄚𑄴 𑄣𑄳𑄠𑄑𑄴𑄥𑄴),
				'other' => q(𑄣𑄳𑄠𑄑𑄴𑄞𑄨𑄠𑄚𑄴 𑄣𑄳𑄠𑄑𑄴𑄥𑄴),
			},
		},
		'LVR' => {
			display_name => {
				'currency' => q(𑄣𑄳𑄠𑄑𑄴𑄞𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄧𑄣𑄴),
			},
		},
		'LYD' => {
			symbol => 'LYD',
			display_name => {
				'currency' => q(𑄣𑄨𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄣𑄨𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄣𑄨𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'MAD' => {
			symbol => 'MAD',
			display_name => {
				'currency' => q(𑄟𑄮𑄢𑄮𑄇𑄳𑄦𑄚𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴),
				'one' => q(𑄟𑄮𑄢𑄮𑄇𑄳𑄦𑄚𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴),
				'other' => q(𑄟𑄮𑄢𑄮𑄇𑄳𑄦𑄚𑄴 𑄘𑄨𑄢𑄴𑄦𑄟𑄴),
			},
		},
		'MAF' => {
			display_name => {
				'currency' => q(𑄟𑄮𑄢𑄮𑄇𑄳𑄦𑄚𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'MDL' => {
			symbol => 'MDL',
			display_name => {
				'currency' => q(𑄟𑄮𑄣𑄴𑄓𑄮𑄞𑄚𑄴 𑄣𑄬𑄠𑄪),
				'one' => q(𑄟𑄮𑄣𑄴𑄓𑄮𑄞𑄚𑄴 𑄣𑄬𑄠𑄪),
				'other' => q(𑄟𑄮𑄣𑄴𑄓𑄮𑄞𑄚𑄴 𑄣𑄬𑄠𑄪),
			},
		},
		'MGA' => {
			symbol => 'MGA',
			display_name => {
				'currency' => q(𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴 𑄃𑄢𑄨𑄠𑄢𑄨),
				'one' => q(𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴 𑄃𑄢𑄨𑄠𑄢𑄨),
				'other' => q(𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴 𑄃𑄢𑄨𑄠𑄢𑄨),
			},
		},
		'MGF' => {
			display_name => {
				'currency' => q(𑄟𑄘𑄉𑄌𑄴𑄇𑄢𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'MKD' => {
			symbol => 'MKD',
			display_name => {
				'currency' => q(𑄟𑄳𑄠𑄥𑄬𑄓𑄮𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄟𑄳𑄠𑄥𑄬𑄓𑄮𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄟𑄳𑄠𑄥𑄬𑄓𑄮𑄚𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'MLF' => {
			display_name => {
				'currency' => q(𑄟𑄣𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'MMK' => {
			symbol => 'MMK',
			display_name => {
				'currency' => q(𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄇𑄨𑄠𑄖𑄴),
				'one' => q(𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄇𑄨𑄠𑄖𑄴),
				'other' => q(𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄇𑄨𑄠𑄖𑄴),
			},
		},
		'MNT' => {
			symbol => 'MNT',
			display_name => {
				'currency' => q(𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠𑄚𑄴 𑄖𑄪𑄇𑄴𑄢𑄨𑄇𑄴),
				'one' => q(𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠𑄚𑄴 𑄖𑄪𑄇𑄴𑄢𑄨𑄇𑄴),
				'other' => q(𑄟𑄧𑄋𑄴𑄉𑄮𑄣𑄨𑄠𑄚𑄴 𑄖𑄪𑄇𑄴𑄢𑄨𑄇𑄴),
			},
		},
		'MOP' => {
			symbol => 'MOP',
			display_name => {
				'currency' => q(𑄟𑄳𑄠𑄇𑄳𑄠𑄃𑄮 𑄛𑄑𑄇),
				'one' => q(𑄟𑄳𑄠𑄇𑄳𑄠𑄃𑄮 𑄛𑄑𑄇),
				'other' => q(𑄟𑄳𑄠𑄇𑄳𑄠𑄃𑄮 𑄛𑄑𑄇),
			},
		},
		'MRO' => {
			symbol => 'MRO',
			display_name => {
				'currency' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠 \(1973–2017\)),
				'one' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠 \(1973–2017\)),
				'other' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠 \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠),
				'one' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠),
				'other' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄃𑄮𑄃𑄪𑄉𑄭𑄪𑄠),
			},
		},
		'MTL' => {
			display_name => {
				'currency' => q(𑄟𑄣𑄴𑄑 𑄣𑄨𑄢),
			},
		},
		'MTP' => {
			display_name => {
				'currency' => q(𑄟𑄣𑄴𑄑 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'MUR' => {
			symbol => 'MUR',
			display_name => {
				'currency' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨),
				'one' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨),
				'other' => q(𑄟𑄯𑄢𑄨𑄖𑄚𑄨𑄠𑄚𑄴 𑄢𑄪𑄛𑄨),
			},
		},
		'MVR' => {
			symbol => 'MVR',
			display_name => {
				'currency' => q(𑄟𑄣𑄴𑄘𑄨𑄞𑄨𑄠𑄚𑄴 𑄢𑄪𑄜𑄨𑄠),
				'one' => q(𑄟𑄣𑄴𑄘𑄨𑄞𑄨𑄠𑄚𑄴 𑄢𑄪𑄜𑄨𑄠),
				'other' => q(𑄟𑄣𑄴𑄘𑄨𑄞𑄨𑄠𑄚𑄴 𑄢𑄪𑄜𑄨𑄠),
			},
		},
		'MWK' => {
			symbol => 'MWK',
			display_name => {
				'currency' => q(𑄟𑄣𑄃𑄪𑄃𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌𑄴),
				'one' => q(𑄟𑄣𑄃𑄪𑄃𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌𑄴),
				'other' => q(𑄟𑄣𑄃𑄪𑄃𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌𑄴),
			},
		},
		'MXN' => {
			symbol => 'MX$',
			display_name => {
				'currency' => q(𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮),
				'one' => q(𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮),
				'other' => q(𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄬𑄥𑄮),
			},
		},
		'MXP' => {
			display_name => {
				'currency' => q(𑄟𑄳𑄠𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄥𑄨𑄣𑄴𑄞𑄢𑄴 𑄛𑄬𑄥𑄮 \(𑄷𑄾𑄼𑄷-𑄷𑄿𑄿𑄸\)),
			},
		},
		'MXV' => {
			display_name => {
				'currency' => q(𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄃𑄪𑄚𑄨𑄘𑄖𑄴 𑄘𑄨 𑄃𑄨𑄚𑄴𑄞𑄢𑄴𑄥𑄧𑄚𑄴\(UDI\)),
			},
		},
		'MYR' => {
			symbol => 'MYR',
			display_name => {
				'currency' => q(𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄨𑄁𑄉𑄨𑄖𑄴),
				'one' => q(𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄨𑄁𑄉𑄨𑄖𑄴),
				'other' => q(𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠𑄚𑄴 𑄢𑄨𑄁𑄉𑄨𑄖𑄴),
			},
		},
		'MZE' => {
			display_name => {
				'currency' => q(𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮),
			},
		},
		'MZM' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄢𑄮𑄚𑄨 𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄟𑄬𑄑𑄨𑄇𑄬𑄣𑄴),
			},
		},
		'MZN' => {
			symbol => 'MZN',
			display_name => {
				'currency' => q(𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄟𑄬𑄑𑄨𑄇𑄬𑄣𑄴),
				'one' => q(𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄟𑄬𑄑𑄨𑄇𑄬𑄣𑄴),
				'other' => q(𑄟𑄮𑄎𑄟𑄴𑄝𑄨𑄇𑄴 𑄟𑄬𑄑𑄨𑄇𑄬𑄣𑄴),
			},
		},
		'NAD' => {
			symbol => 'NAD',
			display_name => {
				'currency' => q(𑄚𑄟𑄨𑄝𑄨𑄠 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄚𑄟𑄨𑄝𑄨𑄠 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄚𑄟𑄨𑄝𑄨𑄠 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'NGN' => {
			symbol => 'NGN',
			display_name => {
				'currency' => q(𑄚𑄭𑄎𑄬𑄢𑄨𑄠𑄚𑄴 𑄚𑄠𑄴𑄢),
				'one' => q(𑄚𑄭𑄎𑄬𑄢𑄨𑄠𑄚𑄴 𑄚𑄠𑄴𑄢),
				'other' => q(𑄚𑄭𑄎𑄬𑄢𑄨𑄠𑄚𑄴 𑄚𑄠𑄴𑄢),
			},
		},
		'NIC' => {
			display_name => {
				'currency' => q(𑄚𑄨𑄇𑄢𑄉𑄪𑄠𑄚 𑄇𑄧𑄢𑄴𑄓𑄮𑄝\(𑄷𑄿𑄾𑄾-𑄷𑄿𑄿𑄷\)),
			},
		},
		'NIO' => {
			symbol => 'NIO',
			display_name => {
				'currency' => q(𑄚𑄨𑄇𑄢𑄉𑄪𑄠𑄚 𑄇𑄧𑄢𑄴𑄓𑄮𑄝),
				'one' => q(𑄚𑄨𑄇𑄢𑄉𑄪𑄠𑄚 𑄇𑄧𑄢𑄴𑄓𑄮𑄝),
				'other' => q(𑄚𑄨𑄇𑄢𑄉𑄪𑄠𑄚 𑄇𑄧𑄢𑄴𑄓𑄮𑄝),
			},
		},
		'NLG' => {
			display_name => {
				'currency' => q(𑄚𑄬𑄘𑄢𑄴𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄉𑄪𑄣𑄴𑄓𑄬𑄢𑄴),
			},
		},
		'NOK' => {
			symbol => 'NOK',
			display_name => {
				'currency' => q(𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬 𑄇𑄳𑄢𑄯𑄚𑄴),
				'one' => q(𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬 𑄇𑄳𑄢𑄯𑄚𑄴),
				'other' => q(𑄚𑄧𑄢𑄴𑄃𑄮𑄠𑄬 𑄇𑄳𑄢𑄯𑄚𑄴),
			},
		},
		'NPR' => {
			symbol => 'NPR',
			display_name => {
				'currency' => q(𑄚𑄬𑄛𑄣𑄨 𑄢𑄪𑄛𑄨),
				'one' => q(𑄚𑄬𑄛𑄣𑄨 𑄢𑄪𑄛𑄨),
				'other' => q(𑄚𑄬𑄛𑄣𑄨 𑄢𑄪𑄛𑄨),
			},
		},
		'NZD' => {
			symbol => 'NZ$',
			display_name => {
				'currency' => q(𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'OMR' => {
			symbol => 'OMR',
			display_name => {
				'currency' => q(𑄃𑄮𑄟𑄚𑄨 𑄢𑄨𑄠𑄣𑄴),
				'one' => q(𑄃𑄮𑄟𑄚𑄨 𑄢𑄨𑄠𑄣𑄴),
				'other' => q(𑄃𑄮𑄟𑄚𑄨 𑄢𑄨𑄠𑄣𑄴),
			},
		},
		'PAB' => {
			symbol => 'PAB',
			display_name => {
				'currency' => q(𑄛𑄚𑄟 𑄝𑄬𑄣𑄴𑄝𑄮𑄠),
				'one' => q(𑄛𑄚𑄟 𑄝𑄬𑄣𑄴𑄝𑄮𑄠),
				'other' => q(𑄛𑄚𑄟 𑄝𑄬𑄣𑄴𑄝𑄮𑄠),
			},
		},
		'PEI' => {
			display_name => {
				'currency' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄃𑄨𑄚𑄴𑄖𑄨),
			},
		},
		'PEN' => {
			symbol => 'PEN',
			display_name => {
				'currency' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴),
				'one' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴),
				'other' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴),
			},
		},
		'PES' => {
			display_name => {
				'currency' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴\(𑄷𑄾𑄼𑄹-𑄷𑄿𑄼𑄻\)),
				'one' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴\(𑄷𑄾𑄼𑄹-𑄷𑄿𑄼𑄻\)),
				'other' => q(𑄛𑄬𑄢𑄪𑄞𑄨𑄠𑄚𑄴 𑄥𑄮𑄣𑄴\(𑄷𑄾𑄼𑄹-𑄷𑄿𑄼𑄻\)),
			},
		},
		'PGK' => {
			symbol => 'PGK',
			display_name => {
				'currency' => q(𑄛𑄛𑄱 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨 𑄉𑄨𑄚𑄨𑄠𑄚𑄴 𑄇𑄨𑄚),
				'one' => q(𑄛𑄛𑄱 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨 𑄉𑄨𑄚𑄨𑄠𑄚𑄴 𑄇𑄨𑄚),
				'other' => q(𑄛𑄛𑄱 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨 𑄉𑄨𑄚𑄨𑄠𑄚𑄴 𑄇𑄨𑄚),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄛𑄬𑄥𑄮),
				'one' => q(𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄛𑄬𑄥𑄮),
				'other' => q(𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄛𑄬𑄥𑄮),
			},
		},
		'PKR' => {
			symbol => 'PKR',
			display_name => {
				'currency' => q(𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄨 𑄢𑄪𑄛𑄨),
				'one' => q(𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄨 𑄢𑄪𑄛𑄨),
				'other' => q(𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄨 𑄢𑄪𑄛𑄨),
			},
		},
		'PLN' => {
			symbol => 'PLN',
			display_name => {
				'currency' => q(𑄛𑄮𑄣𑄨𑄌𑄴 𑄎𑄧𑄣𑄮𑄑𑄨),
				'one' => q(𑄛𑄮𑄣𑄨𑄌𑄴 𑄎𑄧𑄣𑄮𑄑𑄨),
				'other' => q(𑄛𑄮𑄣𑄨𑄌𑄴 𑄎𑄧𑄣𑄮𑄑𑄨),
			},
		},
		'PLZ' => {
			display_name => {
				'currency' => q(𑄛𑄮𑄣𑄨𑄌𑄴 𑄎𑄧𑄣𑄮𑄑𑄨\(𑄷𑄿𑄻𑄶-𑄷𑄿𑄿𑄻\)),
			},
		},
		'PTE' => {
			display_name => {
				'currency' => q(𑄛𑄧𑄢𑄴𑄖𑄪𑄉𑄨𑄌𑄴 𑄃𑄬𑄥𑄴𑄇𑄪𑄓𑄮),
			},
		},
		'PYG' => {
			symbol => 'PYG',
			display_name => {
				'currency' => q(𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄚𑄴 𑄉𑄪𑄠𑄢𑄚𑄨),
				'one' => q(𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄚𑄴 𑄉𑄪𑄠𑄢𑄚𑄨),
				'other' => q(𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄚𑄴 𑄉𑄪𑄠𑄢𑄚𑄨),
			},
		},
		'QAR' => {
			symbol => 'QAR',
			display_name => {
				'currency' => q(𑄇𑄖𑄢𑄴 𑄢𑄨𑄠𑄳𑄠𑄣𑄴),
				'one' => q(𑄇𑄖𑄢𑄴 𑄢𑄨𑄠𑄳𑄠𑄣𑄴),
				'other' => q(𑄇𑄖𑄢𑄴 𑄢𑄨𑄠𑄳𑄠𑄣𑄴),
			},
		},
		'RHD' => {
			display_name => {
				'currency' => q(𑄢𑄮𑄓𑄬𑄥𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'ROL' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄢𑄮𑄚𑄨 𑄢𑄪𑄟𑄚𑄨𑄠 𑄣𑄬𑄠𑄪),
			},
		},
		'RON' => {
			symbol => 'RON',
			display_name => {
				'currency' => q(𑄢𑄪𑄟𑄚𑄨𑄠 𑄣𑄬𑄠𑄪),
				'one' => q(𑄢𑄪𑄟𑄚𑄨𑄠 𑄣𑄬𑄠𑄪),
				'other' => q(𑄢𑄪𑄟𑄚𑄨𑄠 𑄣𑄬𑄠𑄪),
			},
		},
		'RSD' => {
			symbol => 'RSD',
			display_name => {
				'currency' => q(𑄥𑄢𑄴𑄝𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄥𑄢𑄴𑄝𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄥𑄢𑄴𑄝𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'RUB' => {
			symbol => 'RUB',
			display_name => {
				'currency' => q(𑄢𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴),
				'one' => q(𑄢𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴),
				'other' => q(𑄢𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄬𑄣𑄴),
			},
		},
		'RUR' => {
			display_name => {
				'currency' => q(𑄢𑄥𑄨𑄠𑄚𑄴 𑄢𑄪𑄝𑄧𑄣𑄴\(𑄷𑄿𑄿𑄷-𑄷𑄿𑄿𑄾\)),
			},
		},
		'RWF' => {
			symbol => 'RWF',
			display_name => {
				'currency' => q(𑄢𑄪𑄠𑄚𑄴𑄓𑄚𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
				'one' => q(𑄢𑄪𑄠𑄚𑄴𑄓𑄚𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
				'other' => q(𑄢𑄪𑄠𑄚𑄴𑄓𑄚𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'SAR' => {
			symbol => 'SAR',
			display_name => {
				'currency' => q(𑄥𑄯𑄘𑄨 𑄢𑄨𑄠𑄣𑄴),
				'one' => q(𑄥𑄯𑄘𑄨 𑄢𑄨𑄠𑄣𑄴),
				'other' => q(𑄥𑄯𑄘𑄨 𑄢𑄨𑄠𑄣𑄴),
			},
		},
		'SBD' => {
			symbol => 'SBD',
			display_name => {
				'currency' => q(𑄥𑄧𑄣𑄮𑄟𑄧𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄥𑄧𑄣𑄮𑄟𑄧𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄥𑄧𑄣𑄮𑄟𑄧𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'SCR' => {
			symbol => 'SCR',
			display_name => {
				'currency' => q(𑄥𑄬𑄠𑄧𑄥𑄬𑄣𑄴𑄣𑄮𑄃𑄨𑄌𑄴 𑄢𑄪𑄛𑄨),
				'one' => q(𑄥𑄬𑄠𑄧𑄥𑄬𑄣𑄴𑄣𑄮𑄃𑄨𑄌𑄴 𑄢𑄪𑄛𑄨),
				'other' => q(𑄥𑄬𑄠𑄧𑄥𑄬𑄣𑄴𑄣𑄮𑄃𑄨𑄌𑄴 𑄢𑄪𑄛𑄨),
			},
		},
		'SDD' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄢𑄮𑄚𑄨 𑄥𑄪𑄘𑄚𑄨 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'SDG' => {
			symbol => 'SDG',
			display_name => {
				'currency' => q(𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'one' => q(𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'other' => q(𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄢𑄮𑄚𑄨 𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'SEK' => {
			symbol => 'SEK',
			display_name => {
				'currency' => q(𑄥𑄭𑄪𑄓𑄨𑄥𑄴 𑄇𑄳𑄢𑄮𑄚),
				'one' => q(𑄥𑄭𑄪𑄓𑄨𑄥𑄴 𑄇𑄳𑄢𑄮𑄚),
				'other' => q(𑄥𑄭𑄪𑄓𑄨𑄥𑄴 𑄇𑄳𑄢𑄮𑄚),
			},
		},
		'SGD' => {
			symbol => 'SGD',
			display_name => {
				'currency' => q(𑄥𑄨𑄁𑄉𑄛𑄪𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄥𑄨𑄁𑄉𑄛𑄪𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄥𑄨𑄁𑄉𑄛𑄪𑄢𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'SHP' => {
			symbol => 'SHP',
			display_name => {
				'currency' => q(𑄥𑄬𑄚𑄳𑄑𑄴 𑄦𑄬𑄣𑄬𑄚 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'one' => q(𑄥𑄬𑄚𑄴 𑄦𑄬𑄣𑄬𑄚 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'other' => q(𑄥𑄬𑄚𑄴 𑄦𑄬𑄣𑄬𑄚 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'SIT' => {
			display_name => {
				'currency' => q(𑄥𑄳𑄣𑄮𑄞𑄚𑄨𑄠 𑄑𑄮𑄣𑄢𑄴),
			},
		},
		'SKK' => {
			display_name => {
				'currency' => q(𑄥𑄳𑄣𑄮𑄞𑄇𑄴 𑄇𑄮𑄢𑄪𑄚),
			},
		},
		'SLL' => {
			symbol => 'SLL',
			display_name => {
				'currency' => q(𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄠𑄧𑄚𑄴 𑄣𑄨𑄠𑄧𑄚𑄴),
				'one' => q(𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄠𑄧𑄚𑄴 𑄣𑄨𑄠𑄧𑄚𑄴),
				'other' => q(𑄥𑄨𑄠𑄬𑄢𑄣𑄨𑄠𑄧𑄚𑄴 𑄣𑄨𑄠𑄧𑄚𑄴),
			},
		},
		'SOS' => {
			symbol => 'SOS',
			display_name => {
				'currency' => q(𑄥𑄮𑄟𑄣𑄨 𑄥𑄨𑄣𑄨𑄁),
				'one' => q(𑄥𑄮𑄟𑄣𑄨 𑄥𑄨𑄣𑄨𑄁),
				'other' => q(𑄥𑄮𑄟𑄣𑄨 𑄥𑄨𑄣𑄨𑄁),
			},
		},
		'SRD' => {
			symbol => 'SRD',
			display_name => {
				'currency' => q(𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'SRG' => {
			display_name => {
				'currency' => q(𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄉𑄨𑄣𑄴𑄓𑄢𑄴),
			},
		},
		'SSP' => {
			symbol => 'SSP',
			display_name => {
				'currency' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'one' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'other' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄥𑄪𑄘𑄚𑄨 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'STD' => {
			symbol => 'STD',
			display_name => {
				'currency' => q(𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢 \(1977–2017\)),
				'one' => q(𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢 \(1977–2017\)),
				'other' => q(𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢 \(1977–2017\)),
			},
		},
		'STN' => {
			symbol => 'Db',
			display_name => {
				'currency' => q(𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢),
				'one' => q(𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢),
				'other' => q(𑄥𑄃𑄮 𑄑𑄮𑄟𑄬 𑄃𑄳𑄃 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄨𑄛𑄬 𑄓𑄮𑄛𑄴𑄢),
			},
		},
		'SUR' => {
			display_name => {
				'currency' => q(𑄥𑄮𑄣𑄨𑄠𑄬𑄖𑄴 𑄢𑄪𑄝𑄧𑄣𑄴),
			},
		},
		'SVC' => {
			display_name => {
				'currency' => q(𑄃𑄬𑄣𑄴 𑄥𑄳𑄠𑄣𑄴𑄞𑄮𑄓𑄮𑄢𑄴 𑄇𑄮𑄣𑄮𑄚𑄴),
			},
		},
		'SYP' => {
			symbol => 'SYP',
			display_name => {
				'currency' => q(𑄥𑄨𑄢𑄨𑄠𑄚𑄴 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'one' => q(𑄥𑄨𑄢𑄨𑄠𑄚𑄴 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
				'other' => q(𑄥𑄨𑄢𑄨𑄠𑄚𑄴 𑄛𑄃𑄪𑄚𑄳𑄓𑄴),
			},
		},
		'SZL' => {
			symbol => 'SZL',
			display_name => {
				'currency' => q(𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄣𑄨𑄣𑄋𑄴𑄉𑄬𑄚𑄨),
				'one' => q(𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄣𑄨𑄣𑄋𑄴𑄉𑄬𑄚𑄨),
				'other' => q(𑄥𑄮𑄠𑄎𑄨𑄣𑄳𑄠𑄚𑄳𑄓𑄴 𑄣𑄨𑄣𑄋𑄴𑄉𑄬𑄚𑄨),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(𑄗𑄭 𑄝𑄖𑄴),
				'one' => q(𑄗𑄭 𑄝𑄖𑄴),
				'other' => q(𑄗𑄭 𑄝𑄖𑄴),
			},
		},
		'TJR' => {
			display_name => {
				'currency' => q(𑄖𑄎𑄨𑄇𑄨𑄌𑄴𑄖𑄚𑄴 𑄢𑄪𑄝𑄧𑄣𑄴),
			},
		},
		'TJS' => {
			symbol => 'TJS',
			display_name => {
				'currency' => q(𑄖𑄎𑄨𑄇𑄨𑄌𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄮𑄚𑄨),
				'one' => q(𑄖𑄎𑄨𑄇𑄨𑄌𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄮𑄚𑄨),
				'other' => q(𑄖𑄎𑄨𑄇𑄨𑄌𑄴𑄖𑄚𑄴 𑄥𑄮𑄟𑄮𑄚𑄨),
			},
		},
		'TMM' => {
			symbol => 'TMM',
			display_name => {
				'currency' => q(𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴\(𑄷𑄿𑄿𑄹-𑄸𑄶𑄶𑄿\)),
				'one' => q(𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴\(𑄷𑄿𑄿𑄹-𑄸𑄶𑄶𑄿\)),
				'other' => q(𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴\(𑄷𑄿𑄿𑄹-𑄸𑄶𑄶𑄿\)),
			},
		},
		'TMT' => {
			symbol => 'TMT',
			display_name => {
				'currency' => q(𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴),
				'one' => q(𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴),
				'other' => q(𑄖𑄪𑄢𑄴𑄇𑄧𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄨 𑄟𑄚𑄖𑄴),
			},
		},
		'TND' => {
			symbol => 'TND',
			display_name => {
				'currency' => q(𑄖𑄨𑄃𑄪𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'one' => q(𑄖𑄨𑄃𑄪𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
				'other' => q(𑄖𑄨𑄃𑄪𑄚𑄬𑄥𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'TOP' => {
			symbol => 'TOP',
			display_name => {
				'currency' => q(𑄑𑄮𑄋𑄴𑄉 𑄛𑄳𑄃 𑄃𑄋𑄴𑄉),
				'one' => q(𑄑𑄮𑄋𑄴𑄉 𑄛𑄳𑄃 𑄃𑄋𑄴𑄉),
				'other' => q(𑄑𑄮𑄋𑄴𑄉 𑄛𑄳𑄃 𑄃𑄋𑄴𑄉),
			},
		},
		'TPE' => {
			display_name => {
				'currency' => q(𑄖𑄨𑄟𑄪𑄢𑄴 𑄃𑄬𑄌𑄴𑄇𑄪𑄓𑄮),
			},
		},
		'TRL' => {
			display_name => {
				'currency' => q(𑄛𑄪𑄢𑄮𑄚𑄴 𑄖𑄪𑄢𑄴𑄇𑄨 𑄣𑄨𑄢),
			},
		},
		'TRY' => {
			symbol => 'TRY',
			display_name => {
				'currency' => q(𑄖𑄪𑄢𑄴𑄇𑄨 𑄣𑄨𑄢),
				'one' => q(𑄖𑄪𑄢𑄴𑄇𑄨 𑄣𑄨𑄢),
				'other' => q(𑄖𑄪𑄢𑄴𑄇𑄨 𑄣𑄨𑄢),
			},
		},
		'TTD' => {
			symbol => 'TTD',
			display_name => {
				'currency' => q(𑄖𑄳𑄢𑄨𑄚𑄨𑄘𑄖𑄴 𑄃𑄳𑄃 𑄑𑄮𑄝𑄉𑄮 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄖𑄳𑄢𑄨𑄚𑄨𑄘𑄖𑄴 𑄃𑄳𑄃 𑄑𑄮𑄝𑄉𑄮 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄖𑄳𑄢𑄨𑄚𑄨𑄘𑄖𑄴 𑄃𑄳𑄃 𑄑𑄮𑄝𑄉𑄮 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(𑄚𑄱 𑄦𑄭𑄤𑄚𑄴𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄚𑄱 𑄦𑄭𑄤𑄚𑄴𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄚𑄱 𑄦𑄭𑄤𑄚𑄴𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'TZS' => {
			symbol => 'TZS',
			display_name => {
				'currency' => q(𑄖𑄚𑄴𑄎𑄚𑄨𑄠 𑄥𑄨𑄣𑄨𑄁),
				'one' => q(𑄖𑄚𑄴𑄎𑄚𑄨𑄠 𑄥𑄨𑄣𑄨𑄁),
				'other' => q(𑄖𑄚𑄴𑄎𑄚𑄨𑄠 𑄥𑄨𑄣𑄨𑄁),
			},
		},
		'UAH' => {
			symbol => 'UAH',
			display_name => {
				'currency' => q(ই𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄭𑄚𑄴 𑄢𑄨𑄛𑄴𑄚𑄨𑄠),
				'one' => q(𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄭𑄚𑄴 𑄢𑄨𑄛𑄴𑄚𑄨𑄠),
				'other' => q(𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄭𑄚𑄴 𑄢𑄨𑄛𑄴𑄚𑄨𑄠),
			},
		},
		'UAK' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄃𑄪𑄇𑄳𑄢𑄭𑄚𑄴 𑄇𑄢𑄴𑄝𑄮𑄞𑄳𑄠𑄚𑄴𑄑𑄧𑄌𑄴),
			},
		},
		'UGS' => {
			display_name => {
				'currency' => q(𑄃𑄪𑄉𑄚𑄴𑄓𑄚𑄴 𑄥𑄨𑄣𑄨𑄁 \(𑄷𑄿𑄼𑄼-𑄷𑄿𑄾𑄽\)),
			},
		},
		'UGX' => {
			symbol => 'UGX',
			display_name => {
				'currency' => q(𑄃𑄪𑄉𑄚𑄴𑄓𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
				'one' => q(𑄃𑄪𑄉𑄚𑄴𑄓𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
				'other' => q(𑄃𑄪𑄉𑄚𑄴𑄓𑄚𑄴 𑄥𑄨𑄣𑄨𑄁),
			},
		},
		'USD' => {
			symbol => 'US$',
			display_name => {
				'currency' => q(𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'USN' => {
			display_name => {
				'currency' => q(𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴 \(𑄛𑄧𑄢𑄬 𑄘𑄨𑄚𑄴\)),
			},
		},
		'USS' => {
			display_name => {
				'currency' => q(𑄟𑄢𑄴𑄇𑄨𑄚𑄴 𑄓𑄧𑄣𑄢𑄴 \(𑄃𑄬𑄇𑄴𑄇𑄰𑄪 𑄘𑄨𑄚𑄴\)),
			},
		},
		'UYI' => {
			display_name => {
				'currency' => q(𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄚𑄴 𑄛𑄬𑄥𑄮 𑄃𑄬𑄚𑄴 𑄃𑄪𑄚𑄨𑄘𑄘𑄬𑄌𑄴 𑄃𑄨𑄚𑄴𑄓𑄬𑄇𑄴𑄥𑄬𑄓𑄥𑄴),
			},
		},
		'UYP' => {
			display_name => {
				'currency' => q(𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄛𑄬𑄥𑄮 \(𑄷𑄿𑄽𑄻-𑄷𑄿𑄿𑄹\)),
			},
		},
		'UYU' => {
			symbol => 'UYU',
			display_name => {
				'currency' => q(𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄛𑄬𑄥𑄮),
				'one' => q(𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄛𑄬𑄥𑄮),
				'other' => q(𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄛𑄬𑄥𑄮),
			},
		},
		'UZS' => {
			symbol => 'UZS',
			display_name => {
				'currency' => q(𑄃𑄪𑄌𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄨 𑄥𑄮𑄟𑄴),
				'one' => q(𑄃𑄪𑄌𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄨 𑄥𑄮𑄟𑄴),
				'other' => q(𑄃𑄪𑄌𑄴𑄝𑄬𑄇𑄨𑄌𑄴𑄖𑄚𑄨 𑄥𑄮𑄟𑄴),
			},
		},
		'VEB' => {
			display_name => {
				'currency' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴\(𑄷𑄾𑄽𑄷-𑄸𑄶𑄶𑄾\)),
			},
		},
		'VEF' => {
			symbol => 'VEF',
			display_name => {
				'currency' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴 \(2008–2018\)),
				'one' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴 \(2008–2018\)),
				'other' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴 \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴),
				'one' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴),
				'other' => q(𑄞𑄬𑄚𑄨𑄎𑄪𑄔𑄮𑄣𑄚𑄴 𑄝𑄧𑄣𑄨𑄞𑄢𑄴),
			},
		},
		'VND' => {
			symbol => '₫',
			display_name => {
				'currency' => q(𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄨 𑄓𑄧𑄋𑄴𑄉𑄧),
				'one' => q(𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄨 𑄓𑄧𑄋𑄴𑄉𑄧),
				'other' => q(𑄞𑄨𑄠𑄬𑄖𑄴𑄚𑄟𑄨 𑄓𑄧𑄋𑄴𑄉𑄧),
			},
		},
		'VUV' => {
			symbol => 'VUV',
			display_name => {
				'currency' => q(𑄞𑄚𑄪𑄠𑄖𑄪 𑄞𑄖𑄪),
				'one' => q(𑄞𑄚𑄪𑄠𑄖𑄪 𑄞𑄖𑄪),
				'other' => q(𑄞𑄚𑄪𑄠𑄖𑄪 𑄞𑄖𑄪),
			},
		},
		'WST' => {
			symbol => 'WST',
			display_name => {
				'currency' => q(𑄥𑄟𑄮𑄠𑄚𑄴 𑄑𑄣),
				'one' => q(𑄥𑄟𑄮𑄠𑄚𑄴 𑄑𑄣),
				'other' => q(𑄥𑄟𑄮𑄠𑄚𑄴 𑄑𑄣),
			},
		},
		'XAF' => {
			symbol => 'FCFA',
			display_name => {
				'currency' => q(𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴[CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
				'one' => q(𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴[CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
				'other' => q(𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴[CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
			},
		},
		'XAG' => {
			display_name => {
				'currency' => q(𑄥𑄨𑄣𑄴𑄞𑄢𑄴),
			},
		},
		'XAU' => {
			display_name => {
				'currency' => q(𑄉𑄮𑄣𑄳𑄓𑄴),
			},
		},
		'XCD' => {
			symbol => 'EC$',
			display_name => {
				'currency' => q(𑄛𑄪𑄉𑄬𑄘𑄨 𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'one' => q(𑄛𑄪𑄉𑄬𑄘𑄨 𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
				'other' => q(𑄛𑄪𑄉𑄬𑄘𑄨 𑄇𑄳𑄠𑄢𑄝𑄨𑄠𑄚𑄴 𑄓𑄧𑄣𑄢𑄴),
			},
		},
		'XEU' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄃𑄪𑄢𑄮𑄛𑄨𑄠𑄚𑄴 𑄑𑄬𑄋𑄢𑄴 𑄃𑄬𑄇𑄧𑄇𑄴),
			},
		},
		'XFO' => {
			display_name => {
				'currency' => q(𑄜𑄧𑄢𑄥𑄨 𑄉𑄮𑄣𑄳𑄓𑄴 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'XFU' => {
			display_name => {
				'currency' => q(𑄜𑄧𑄢𑄥𑄨 𑄃𑄨𑄃𑄪𑄃𑄭𑄥𑄨 𑄜𑄳𑄢𑄋𑄳𑄇𑄴),
			},
		},
		'XOF' => {
			symbol => 'CFA',
			display_name => {
				'currency' => q(𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 [CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
				'one' => q(𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 [CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
				'other' => q(𑄛𑄧𑄎𑄨𑄟𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 [CFA] 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
			},
		},
		'XPD' => {
			display_name => {
				'currency' => q(𑄛𑄳𑄠𑄣𑄬𑄓𑄨𑄠𑄟𑄴),
			},
		},
		'XPF' => {
			symbol => 'CFPF',
			display_name => {
				'currency' => q(𑄥𑄨𑄃𑄬𑄛𑄴𑄛𑄨 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
				'one' => q(𑄥𑄨𑄃𑄬𑄛𑄴𑄛𑄨 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
				'other' => q(𑄥𑄨𑄃𑄬𑄛𑄴𑄛𑄨 𑄜𑄳𑄢𑄳𑄠𑄋𑄳𑄇𑄴),
			},
		},
		'XPT' => {
			display_name => {
				'currency' => q(𑄛𑄳𑄣𑄑𑄨𑄚𑄟𑄴),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(𑄦𑄧𑄝𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄑𑄬𑄋),
				'one' => q(𑄦𑄧𑄝𑄧𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄃𑄳𑄃 𑄞𑄪𑄣𑄴 𑄑𑄬𑄋),
				'other' => q(𑄦𑄧𑄝𑄧𑄢𑄴 𑄚𑄧𑄛𑄬𑄠𑄬 𑄑𑄬𑄋),
			},
		},
		'YDD' => {
			display_name => {
				'currency' => q(𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄨 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'YER' => {
			symbol => 'YER',
			display_name => {
				'currency' => q(𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄨 𑄢𑄨𑄠𑄣𑄴),
				'one' => q(𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄨 𑄢𑄨𑄠𑄣𑄴),
				'other' => q(𑄃𑄨𑄠𑄬𑄟𑄬𑄚𑄨 𑄢𑄨𑄠𑄣𑄴),
			},
		},
		'YUD' => {
			display_name => {
				'currency' => q(𑄡𑄪𑄉𑄮𑄥𑄳𑄣𑄞𑄨𑄠𑄧 𑄦𑄢𑄴𑄓𑄴 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'YUM' => {
			display_name => {
				'currency' => q(𑄡𑄪𑄉𑄮𑄥𑄳𑄣𑄞𑄨𑄠𑄧 𑄚𑄮𑄞𑄨 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'YUN' => {
			display_name => {
				'currency' => q(𑄡𑄪𑄉𑄮𑄥𑄳𑄣𑄞𑄨𑄠𑄧 𑄝𑄮𑄘𑄮𑄣𑄬𑄭𑄛𑄢𑄬 𑄘𑄨𑄚𑄢𑄴),
			},
		},
		'ZAR' => {
			symbol => 'ZAR',
			display_name => {
				'currency' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 𑄢𑄳𑄠𑄚𑄳𑄓𑄴),
				'one' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 𑄢𑄳𑄠𑄚𑄳𑄓𑄴),
				'other' => q(𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇𑄚𑄴 𑄢𑄳𑄠𑄚𑄳𑄓𑄴),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(𑄎𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌 \(𑄷𑄿𑄼𑄾-𑄸𑄶𑄷𑄸\)),
			},
		},
		'ZMW' => {
			symbol => 'ZMW',
			display_name => {
				'currency' => q(𑄎𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌),
				'one' => q(𑄎𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌),
				'other' => q(𑄎𑄟𑄴𑄝𑄨𑄠𑄚𑄴 𑄇𑄧𑄤𑄌),
			},
		},
		'ZRN' => {
			display_name => {
				'currency' => q(𑄎𑄭𑄢𑄨𑄠𑄚𑄴 𑄚𑄨𑄅𑄪 𑄎𑄭𑄢𑄬 \(𑄷𑄿𑄿𑄹-𑄷𑄿𑄿𑄾\)),
			},
		},
		'ZRZ' => {
			display_name => {
				'currency' => q(𑄎𑄭𑄢𑄨𑄠𑄚𑄴 𑄚𑄨𑄅𑄪 𑄎𑄭𑄢𑄬 \(𑄷𑄿𑄽𑄷-𑄷𑄿𑄿𑄹\)),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬 𑄓𑄧𑄣𑄢𑄴 \(𑄷𑄿𑄾𑄶-𑄸𑄶𑄶𑄾\)),
			},
		},
		'ZWL' => {
			display_name => {
				'currency' => q(𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬 𑄓𑄧𑄣𑄢𑄴 \(𑄸𑄶𑄶𑄿\)),
			},
		},
		'ZWR' => {
			display_name => {
				'currency' => q(𑄎𑄨𑄟𑄴𑄝𑄝𑄪𑄠𑄬 𑄓𑄧𑄣𑄢𑄴 \(𑄸𑄶𑄶𑄾\)),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'𑄎𑄚𑄪',
							'𑄜𑄬𑄛𑄴',
							'𑄟𑄢𑄴𑄌𑄧',
							'𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴',
							'𑄟𑄬',
							'𑄎𑄪𑄚𑄴',
							'𑄎𑄪𑄣𑄭',
							'𑄃𑄉𑄧𑄌𑄴𑄑𑄴',
							'𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴',
							'𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄢𑄴'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'𑄎',
							'𑄜𑄬',
							'𑄟',
							'𑄃𑄬',
							'𑄟𑄬',
							'𑄎𑄪𑄚𑄴',
							'𑄎𑄪',
							'𑄃',
							'𑄥𑄬',
							'𑄃𑄧',
							'𑄚𑄧',
							'𑄓𑄨'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'𑄎𑄚𑄪𑄠𑄢𑄨',
							'𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨',
							'𑄟𑄢𑄴𑄌𑄧',
							'𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴',
							'𑄟𑄬',
							'𑄎𑄪𑄚𑄴',
							'𑄎𑄪𑄣𑄭',
							'𑄃𑄉𑄧𑄌𑄴𑄑𑄴',
							'𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄃𑄧𑄇𑄴𑄑𑄬𑄝𑄧𑄢𑄴',
							'𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					abbreviated => {
						nonleap => [
							'𑄎𑄚𑄪𑄠𑄢𑄨',
							'𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨',
							'𑄟𑄢𑄴𑄌𑄧',
							'𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴',
							'𑄟𑄬',
							'𑄎𑄪𑄚𑄴',
							'𑄎𑄪𑄣𑄭',
							'𑄃𑄉𑄧𑄌𑄴𑄑𑄴',
							'𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴',
							'𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴'
						],
						leap => [
							
						],
					},
					narrow => {
						nonleap => [
							'𑄎',
							'𑄜𑄬',
							'𑄟',
							'𑄃𑄬',
							'𑄟𑄬',
							'𑄎𑄪𑄚𑄴',
							'𑄎𑄪',
							'𑄃',
							'𑄥𑄬',
							'𑄃𑄧',
							'𑄚𑄧',
							'𑄓𑄨'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'𑄎𑄚𑄪𑄠𑄢𑄨',
							'𑄜𑄬𑄛𑄴𑄝𑄳𑄢𑄪𑄠𑄢𑄨',
							'𑄟𑄢𑄴𑄌𑄧',
							'𑄃𑄬𑄛𑄳𑄢𑄨𑄣𑄴',
							'𑄟𑄬',
							'𑄎𑄪𑄚𑄴',
							'𑄎𑄪𑄣𑄭',
							'𑄃𑄉𑄧𑄌𑄴𑄑𑄴',
							'𑄥𑄬𑄛𑄴𑄑𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄃𑄧𑄇𑄴𑄑𑄮𑄝𑄧𑄢𑄴',
							'𑄚𑄧𑄞𑄬𑄟𑄴𑄝𑄧𑄢𑄴',
							'𑄓𑄨𑄥𑄬𑄟𑄴𑄝𑄧𑄢𑄴'
						],
						leap => [
							
						],
					},
				},
			},
			'indian' => {
				'format' => {
					wide => {
						nonleap => [
							'𑄌𑄮𑄖𑄴',
							'𑄝𑄮𑄎𑄬𑄇𑄴',
							'𑄎𑄳𑄠𑄬𑄖𑄴',
							'𑄃𑄏𑄢𑄴',
							'𑄥𑄉𑄮𑄚𑄴',
							'𑄞𑄘𑄧',
							'𑄃𑄏𑄨𑄚𑄴',
							'𑄇𑄘𑄨',
							'𑄃𑄊𑄮𑄚𑄴',
							'𑄛𑄪𑄌𑄴',
							'𑄟𑄇𑄴',
							'𑄜𑄉𑄪𑄚𑄴'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'𑄷',
							'𑄸',
							'𑄹',
							'𑄺',
							'𑄻',
							'𑄼',
							'𑄽',
							'𑄾',
							'𑄿',
							'𑄷𑄶',
							'𑄷𑄷',
							'𑄷𑄸'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'𑄟𑄧𑄦𑄧𑄢𑄧𑄟𑄴',
							'𑄥𑄧𑄜𑄢𑄴',
							'𑄢𑄧𑄝𑄨𑄅𑄣𑄴 𑄃𑄃𑄪𑄠𑄣𑄴',
							'𑄢𑄧𑄝𑄨𑄅𑄥𑄴 𑄥𑄚𑄨',
							'𑄎𑄧𑄟𑄘𑄨𑄅𑄣𑄴 𑄃𑄃𑄪𑄠𑄣𑄴',
							'𑄎𑄧𑄟𑄘𑄨𑄅𑄌𑄴 𑄥𑄚𑄨',
							'𑄢𑄧𑄎𑄧𑄝𑄴',
							'𑄥𑄳𑄃𑄝𑄧𑄚𑄴',
							'𑄢𑄧𑄟𑄴𑄎𑄚𑄴',
							'𑄥𑄤𑄣𑄴',
							'𑄎𑄨𑄣𑄴𑄇𑄧𑄘𑄴',
							'𑄎𑄨𑄣𑄴𑄦𑄧𑄎𑄴𑄎𑄧'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'𑄷',
							'𑄸',
							'𑄹',
							'𑄺',
							'𑄻',
							'𑄼',
							'𑄽',
							'𑄾',
							'𑄿',
							'𑄷𑄶',
							'𑄷𑄷',
							'𑄷𑄸'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => '𑄥𑄧𑄟𑄴',
						tue => '𑄟𑄧𑄁𑄉𑄧𑄣𑄴',
						wed => '𑄝𑄪𑄖𑄴',
						thu => '𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴',
						fri => '𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴',
						sat => '𑄥𑄧𑄚𑄨',
						sun => '𑄢𑄧𑄝𑄨'
					},
					narrow => {
						mon => '𑄥𑄧',
						tue => '𑄟𑄧',
						wed => '𑄝𑄪',
						thu => '𑄝𑄳𑄢𑄨',
						fri => '𑄥𑄪',
						sat => '𑄥𑄧',
						sun => '𑄢𑄧'
					},
					wide => {
						mon => '𑄥𑄧𑄟𑄴𑄝𑄢𑄴',
						tue => '𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴',
						wed => '𑄝𑄪𑄖𑄴𑄝𑄢𑄴',
						thu => '𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴',
						fri => '𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴',
						sat => '𑄥𑄧𑄚𑄨𑄝𑄢𑄴',
						sun => '𑄢𑄧𑄝𑄨𑄝𑄢𑄴'
					},
				},
				'stand-alone' => {
					abbreviated => {
						mon => '𑄥𑄧𑄟𑄴',
						tue => '𑄟𑄧𑄁𑄉𑄧𑄣𑄴',
						wed => '𑄝𑄪𑄖𑄴',
						thu => '𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴',
						fri => '𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴',
						sat => '𑄥𑄧𑄚𑄨',
						sun => '𑄢𑄧𑄝𑄨'
					},
					narrow => {
						mon => '𑄥𑄧',
						tue => '𑄟𑄧',
						wed => '𑄝𑄪',
						thu => '𑄝𑄳𑄢𑄨',
						fri => '𑄥𑄪',
						sat => '𑄥𑄧',
						sun => '𑄢𑄧'
					},
					wide => {
						mon => '𑄥𑄧𑄟𑄴𑄝𑄢𑄴',
						tue => '𑄟𑄧𑄁𑄉𑄧𑄣𑄴𑄝𑄢𑄴',
						wed => '𑄝𑄪𑄖𑄴𑄝𑄢𑄴',
						thu => '𑄝𑄳𑄢𑄨𑄥𑄪𑄛𑄴𑄝𑄢𑄴',
						fri => '𑄥𑄪𑄇𑄴𑄇𑄮𑄢𑄴𑄝𑄢𑄴',
						sat => '𑄥𑄧𑄚𑄨𑄝𑄢𑄴',
						sun => '𑄢𑄧𑄝𑄨𑄝𑄢𑄴'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '𑄷',
						1 => '𑄸',
						2 => '𑄹',
						3 => '𑄺'
					},
					wide => {0 => '𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴',
						1 => '𑄘𑄨 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴',
						2 => '𑄖𑄨𑄚𑄴 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴',
						3 => '𑄌𑄳𑄆𑄬𑄢𑄴 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴'
					},
				},
				'stand-alone' => {
					abbreviated => {0 => 'Q1',
						1 => 'Q2',
						2 => 'Q3',
						3 => 'Q4'
					},
					narrow => {0 => '𑄷',
						1 => '𑄸',
						2 => '𑄹',
						3 => '𑄺'
					},
					wide => {0 => '𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴',
						1 => '𑄘𑄨 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴',
						2 => '𑄖𑄨𑄚𑄴 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴',
						3 => '𑄌𑄳𑄆𑄬𑄢𑄴 𑄛𑄳𑄆𑄘𑄳𑄠𑄬 𑄖𑄨𑄚𑄴𑄟𑄎𑄧𑄢𑄴'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'indian') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'selection') {
					return 'morning1' if $time >= 400
						&& $time < 600;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
				}
				if($day_period_type eq 'default') {
					return 'afternoon2' if $time >= 1600
						&& $time < 1800;
					return 'night1' if $time >= 2000;
					return 'night1' if $time < 400;
					return 'evening1' if $time >= 1800
						&& $time < 2000;
					return 'morning2' if $time >= 600
						&& $time < 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1600;
					return 'morning1' if $time >= 400
						&& $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
	my ($orig, $self) = @_;
	return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'night1' => q{𑄢𑄬𑄖𑄴},
					'afternoon2' => q{𑄝𑄬𑄣𑄳𑄠𑄬},
					'evening1' => q{𑄥𑄎𑄧𑄚𑄳𑄠},
					'morning2' => q{𑄝𑄬𑄚𑄳𑄠𑄬},
					'am' => q{AM},
					'pm' => q{PM},
					'morning1' => q{𑄛𑄧𑄖𑄳𑄠𑄃𑄟𑄧𑄣𑄳𑄠𑄬},
					'afternoon1' => q{𑄘𑄨𑄝𑄪𑄎𑄳𑄠},
				},
				'narrow' => {
					'evening1' => q{𑄥𑄎𑄧𑄚𑄳𑄠},
					'morning2' => q{𑄝𑄬𑄚𑄳𑄠𑄬},
					'afternoon2' => q{𑄝𑄬𑄣𑄳𑄠𑄬},
					'night1' => q{𑄢𑄬𑄖𑄴},
					'am' => q{AM},
					'pm' => q{PM},
					'afternoon1' => q{𑄘𑄨𑄝𑄪𑄎𑄳𑄠},
					'morning1' => q{𑄛𑄧𑄖𑄳𑄠𑄃𑄟𑄧𑄣𑄳𑄠𑄬},
				},
				'wide' => {
					'afternoon1' => q{𑄘𑄨𑄝𑄪𑄎𑄳𑄠},
					'pm' => q{PM},
					'morning1' => q{𑄛𑄧𑄖𑄳𑄠𑄃𑄟𑄧𑄣𑄳𑄠𑄬},
					'am' => q{AM},
					'afternoon2' => q{𑄝𑄬𑄣𑄳𑄠𑄬},
					'night1' => q{𑄢𑄬𑄖𑄴},
					'morning2' => q{𑄝𑄬𑄚𑄳𑄠𑄬},
					'evening1' => q{𑄥𑄎𑄧𑄚𑄳𑄠},
				},
			},
			'stand-alone' => {
				'narrow' => {
					'am' => q{AM},
					'morning1' => q{𑄛𑄧𑄖𑄳𑄠𑄃𑄟𑄧𑄣𑄳𑄠𑄬},
					'afternoon1' => q{𑄘𑄨𑄝𑄪𑄎𑄳𑄠},
					'pm' => q{PM},
					'evening1' => q{𑄥𑄎𑄧𑄚𑄳𑄠},
					'morning2' => q{𑄝𑄬𑄚𑄳𑄠𑄬},
					'afternoon2' => q{𑄝𑄬𑄣𑄳𑄠𑄬},
					'night1' => q{𑄢𑄬𑄖𑄴},
				},
				'wide' => {
					'night1' => q{𑄢𑄬𑄖𑄴},
					'afternoon2' => q{𑄝𑄬𑄣𑄳𑄠𑄬},
					'evening1' => q{𑄥𑄎𑄧𑄚𑄳𑄠},
					'morning2' => q{𑄝𑄬𑄚𑄳𑄠𑄬},
					'morning1' => q{𑄛𑄧𑄖𑄳𑄠𑄃𑄟𑄧𑄣𑄳𑄠𑄬},
					'afternoon1' => q{𑄘𑄨𑄝𑄪𑄎𑄳𑄠},
					'pm' => q{PM},
					'am' => q{AM},
				},
				'abbreviated' => {
					'morning1' => q{𑄛𑄧𑄖𑄳𑄠𑄃𑄟𑄧𑄣𑄳𑄠𑄬},
					'afternoon1' => q{𑄘𑄨𑄝𑄪𑄎𑄳𑄠},
					'pm' => q{PM},
					'am' => q{AM},
					'evening1' => q{𑄥𑄎𑄧𑄚𑄳𑄠},
					'morning2' => q{𑄝𑄬𑄚𑄳𑄠𑄬},
					'night1' => q{𑄢𑄬𑄖𑄴},
					'afternoon2' => q{𑄝𑄬𑄣𑄳𑄠𑄬},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => '𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄴𑄛𑄫𑄢𑄴𑄝𑄧',
				'1' => '𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄛𑄴𑄘𑄧'
			},
			wide => {
				'0' => '𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄴𑄛𑄫𑄢𑄴𑄝𑄧',
				'1' => '𑄈𑄳𑄢𑄨𑄌𑄴𑄑𑄛𑄴𑄘𑄧'
			},
		},
		'indian' => {
			abbreviated => {
				'0' => '𑄥𑄣𑄴'
			},
		},
		'islamic' => {
			abbreviated => {
				'0' => '𑄡𑄪𑄇𑄴'
			},
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{EEEE, d MMMM, y G},
			'long' => q{d MMMM, y G},
			'medium' => q{d MMM, y G},
			'short' => q{d/M/y GGGGG},
		},
		'gregorian' => {
			'full' => q{EEEE, d MMMM, y},
			'long' => q{d MMMM, y},
			'medium' => q{d MMM, y},
			'short' => q{d/M/yy},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'indian' => {
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			E => q{ccc},
			Ed => q{d E},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			ms => q{mm:ss},
			y => q{y G},
			yyyy => q{y G},
			yyyyM => q{M/y G},
			yyyyMEd => q{E, d/M/y G},
			yyyyMM => q{MM-y G},
			yyyyMMM => q{MMM y G},
			yyyyMMMEd => q{E, d MMM, y G},
			yyyyMMMM => q{MMMM y G},
			yyyyMMMd => q{d MMM, y G},
			yyyyMd => q{d/M/y G},
			yyyyQQQ => q{QQQ y G},
			yyyyQQQQ => q{QQQQ y G},
		},
		'gregorian' => {
			E => q{ccc},
			EHm => q{E HH:mm},
			EHms => q{E HH:mm:ss},
			Ed => q{d E},
			Ehm => q{E h:mm a},
			Ehms => q{E h:mm:ss a},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMMMEd => q{E, d MMM, y G},
			GyMMMd => q{d MMM, y G},
			H => q{HH},
			Hm => q{HH:mm},
			Hms => q{HH:mm:ss},
			Hmsv => q{HH:mm:ss v},
			Hmv => q{HH:mm v},
			M => q{L},
			MEd => q{E, d-M},
			MMM => q{LLL},
			MMMEd => q{E d MMM},
			MMMMEd => q{E d MMMM},
			MMMMW => q{MMMM 𑄃𑄬𑄢𑄴 𑄠𑄴 𑄥𑄛𑄴𑄖 W},
			MMMMd => q{d MMMM},
			MMMd => q{d MMM},
			MMdd => q{dd-MM},
			Md => q{d/M},
			d => q{d},
			h => q{h a},
			hm => q{h:mm a},
			hms => q{h:mm:ss a},
			hmsv => q{h:mm:ss a v},
			hmv => q{h:mm a v},
			ms => q{mm:ss},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E, d/M/y},
			yMM => q{MM-y},
			yMMM => q{MMM y},
			yMMMEd => q{E, d MMM, y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM, y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yw => q{Y 𑄃𑄬𑄢𑄴 𑄖𑄧𑄟𑄴 𑄥𑄛𑄴𑄖 w},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'Timezone' => '{0} {1}',
		},
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y G},
			},
			yM => {
				M => q{M/y – M/y G},
				y => q{M/y – M/y G},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y G},
				d => q{E, d/M/y – E, d/M/y G},
				y => q{E, d/M/y – E, d/M/y G},
			},
			yMMM => {
				M => q{MMM–MMM y G},
				y => q{MMM y – MMM y G},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y G},
				d => q{E, d MMM – E, d MMM, y G},
				y => q{E, d MMM, y – E, d MMM, y G},
			},
			yMMMM => {
				M => q{MMMM–MMMM y G},
				y => q{MMMM y – MMMM y G},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y G},
				d => q{d–d MMM, y G},
				y => q{d MMM, y – d MMM, y G},
			},
			yMd => {
				M => q{d/M/y – d/M/y G},
				d => q{d/M/y – d/M/y G},
				y => q{d/M/y – d/M/y G},
			},
		},
		'gregorian' => {
			H => {
				H => q{HH–HH},
			},
			Hm => {
				H => q{HH:mm–HH:mm},
				m => q{HH:mm–HH:mm},
			},
			Hmv => {
				H => q{HH:mm–HH:mm v},
				m => q{HH:mm–HH:mm v},
			},
			Hv => {
				H => q{HH–HH v},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E, d/M – E, d/M},
				d => q{E, d/M – E, d/M},
			},
			MMM => {
				M => q{MMM – MMM},
			},
			MMMEd => {
				M => q{E, d MMM – E, d MMM},
				d => q{E, d MMM – E, d MMM},
			},
			MMMd => {
				M => q{d MMM – d MMM},
				d => q{d–d MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d/M – d/M},
			},
			d => {
				d => q{d–d},
			},
			fallback => '{0} – {1}',
			h => {
				a => q{h a – h a},
				h => q{h–h a},
			},
			hm => {
				a => q{h:mm a – h:mm a},
				h => q{h:mm–h:mm a},
				m => q{h:mm–h:mm a},
			},
			hmv => {
				a => q{h:mm a – h:mm a v},
				h => q{h:mm–h:mm a v},
				m => q{h:mm–h:mm a v},
			},
			hv => {
				a => q{h a – h a v},
				h => q{h–h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E, d/M/y – E, d/M/y},
				d => q{E, d/M/y – E, d/M/y},
				y => q{E, d/M/y – E, d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E, d MMM – E, d MMM, y},
				d => q{E, d MMM – E, d MMM, y},
				y => q{E, d MMM, y – E, d MMM, y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{d MMM – d MMM, y},
				d => q{d–d MMM, y},
				y => q{d MMM, y – d MMM, y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HH:mm;-HH:mm),
		gmtFormat => q(GMT {0}),
		gmtZeroFormat => q(GMT),
		regionFormat => q({0} 𑄃𑄧𑄇𑄴𑄖𑄧),
		regionFormat => q({0} 𑄘𑄨𑄝𑄪𑄌𑄴𑄎𑄳𑄠 𑄃𑄧𑄇𑄴𑄖𑄧𑄖𑄴),
		regionFormat => q({0} 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧𑄖𑄴),
		fallbackFormat => q({1} ({0})),
		'Acre' => {
			long => {
				'daylight' => q#𑄃𑄬𑄉𑄧𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄬𑄉𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄬𑄉𑄧𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Afghanistan' => {
			long => {
				'standard' => q#𑄃𑄛𑄴𑄉𑄚𑄨𑄌𑄴𑄖𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#𑄃𑄝𑄨𑄘𑄴𑄎𑄚𑄴#,
		},
		'Africa/Accra' => {
			exemplarCity => q#𑄃𑄇𑄳𑄢#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#𑄃𑄓𑄳𑄓𑄨𑄌𑄴 𑄃𑄝𑄝#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#𑄃𑄣𑄴𑄎𑄨𑄠𑄢𑄴𑄥𑄴#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#𑄃𑄳𑄠𑄥𑄴𑄟𑄬𑄢#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#𑄝𑄟𑄳𑄠𑄇𑄮#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#𑄝𑄋𑄴𑄉𑄭𑄪#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#𑄝𑄚𑄎𑄪𑄣𑄴#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#𑄝𑄥𑄃𑄪#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#𑄝𑄳𑄣𑄳𑄠𑄚𑄴𑄑𑄠𑄬𑄢𑄴#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#𑄝𑄳𑄢𑄎𑄴𑄞𑄨𑄣𑄴#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#𑄝𑄪𑄎𑄪𑄟𑄴𑄝𑄪𑄢𑄴𑄦𑄪#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#𑄇𑄠𑄴𑄢𑄮#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#𑄇𑄥𑄝𑄳𑄣𑄁𑄇#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#𑄥𑄬𑄃𑄪𑄑#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#𑄇𑄧𑄚𑄇𑄳𑄢𑄨#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#𑄓𑄇𑄢𑄴#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#𑄘𑄢𑄴 𑄃𑄬𑄌𑄴 𑄥𑄣𑄟𑄴#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#𑄎𑄨𑄝𑄪𑄑𑄨#,
		},
		'Africa/Douala' => {
			exemplarCity => q#𑄓𑄮𑄠𑄣#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#𑄃𑄬𑄣𑄴 𑄃𑄦𑄴𑄃𑄨𑄃𑄪𑄚𑄴#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#𑄜𑄳𑄢𑄨𑄑𑄅𑄪𑄚𑄴#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#𑄉𑄳𑄠𑄝𑄪𑄢𑄧𑄚𑄨#,
		},
		'Africa/Harare' => {
			exemplarCity => q#𑄦𑄢𑄢𑄬#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#𑄎𑄮𑄦𑄚𑄬𑄥𑄴𑄝𑄢𑄴𑄉𑄴#,
		},
		'Africa/Juba' => {
			exemplarCity => q#𑄎𑄪𑄝#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#𑄇𑄟𑄴𑄛𑄣#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#𑄈𑄢𑄴𑄖𑄪𑄟𑄴#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#𑄇𑄨𑄉𑄣𑄨#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#𑄇𑄨𑄚𑄴𑄥𑄥#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#𑄣𑄉𑄮𑄌𑄴#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#𑄣𑄨𑄝𑄳𑄢𑄪𑄞𑄨𑄣𑄴#,
		},
		'Africa/Lome' => {
			exemplarCity => q#𑄣𑄮𑄟𑄬#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#𑄣𑄮𑄠𑄚𑄴𑄓#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#𑄣𑄪𑄝𑄪𑄟𑄴𑄝𑄥𑄨#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#𑄣𑄪𑄥𑄇#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#𑄟𑄣𑄝𑄮#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#𑄟𑄛𑄪𑄖𑄮#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#𑄟𑄦𑄴𑄥𑄬𑄢𑄪#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#𑄃𑄧𑄟𑄴𑄝𑄝𑄚𑄴#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#𑄟𑄮𑄉𑄘𑄨𑄥𑄪#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#𑄟𑄧𑄚𑄴𑄢𑄮𑄞𑄨𑄠#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#𑄚𑄭𑄢𑄮𑄝𑄨#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#𑄃𑄬𑄚𑄴𑄎𑄧𑄟𑄬𑄚#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#𑄚𑄨𑄠𑄟𑄬#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#𑄚𑄮𑄠𑄇𑄴𑄥𑄧𑄑𑄴#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#𑄤𑄦𑄪𑄉𑄪𑄓𑄮𑄉𑄪#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#𑄛𑄮𑄢𑄴𑄑𑄮-𑄚𑄮𑄞𑄮#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#𑄥𑄃𑄮 𑄑𑄮𑄟𑄴#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#𑄖𑄳𑄢𑄨𑄛𑄮𑄣𑄨#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#𑄑𑄨𑄅𑄪𑄚𑄨𑄌𑄴#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#𑄃𑄪𑄃𑄨𑄚𑄴𑄙𑄮𑄇𑄴#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄜𑄳𑄢𑄨𑄇 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄜𑄳𑄢𑄨𑄇 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄜𑄳𑄢𑄨𑄇 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄜𑄳𑄢𑄨𑄇 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄜𑄳𑄢𑄨𑄇 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄜𑄳𑄢𑄨𑄇 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#𑄃𑄣𑄌𑄴𑄇 𑄘𑄨𑄚𑄮𑄃𑄣𑄮 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄣𑄌𑄴𑄇 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄣𑄌𑄴𑄇 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Almaty' => {
			long => {
				'daylight' => q#𑄃𑄣𑄴𑄟𑄑𑄨 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄣𑄴𑄟𑄑𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄣𑄴𑄟𑄑𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#𑄃𑄳𑄠𑄟𑄎𑄧𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄳𑄠𑄟𑄎𑄧𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄳𑄠𑄟𑄎𑄧𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#𑄃𑄓𑄇𑄴#,
		},
		'America/Anchorage' => {
			exemplarCity => q#𑄃𑄬𑄚𑄴𑄇𑄮𑄢𑄬𑄌𑄴#,
		},
		'America/Anguilla' => {
			exemplarCity => q#𑄃𑄳𑄃𑄋𑄴𑄉𑄪𑄃𑄨𑄣#,
		},
		'America/Antigua' => {
			exemplarCity => q#𑄃𑄳𑄃𑄚𑄴𑄑𑄨𑄉𑄪𑄠𑄉#,
		},
		'America/Araguaina' => {
			exemplarCity => q#𑄃𑄢𑄉𑄪𑄠𑄭𑄚#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#𑄣 𑄢𑄨𑄃𑄮𑄦#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#𑄢𑄨𑄃𑄮 𑄉𑄠𑄬𑄉𑄮𑄌𑄴#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#𑄥𑄳𑄠𑄣𑄴𑄑#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#𑄥𑄚𑄴 𑄦𑄪𑄠𑄚𑄴#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#𑄥𑄚𑄴 𑄣𑄭𑄪𑄌𑄴#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#𑄑𑄪𑄇𑄪𑄟𑄚𑄴#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#𑄅𑄥𑄪𑄠𑄭𑄠#,
		},
		'America/Aruba' => {
			exemplarCity => q#𑄃𑄬𑄢𑄪𑄝#,
		},
		'America/Asuncion' => {
			exemplarCity => q#𑄃𑄥𑄪𑄚𑄴𑄥𑄨𑄠𑄧𑄚𑄴#,
		},
		'America/Bahia' => {
			exemplarCity => q#𑄝𑄦𑄨𑄠#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#𑄝𑄦𑄨𑄠 𑄝𑄚𑄴𑄓𑄬𑄢𑄌𑄴#,
		},
		'America/Barbados' => {
			exemplarCity => q#𑄝𑄢𑄴𑄝𑄓𑄮𑄎𑄴#,
		},
		'America/Belem' => {
			exemplarCity => q#𑄝𑄬𑄣𑄬𑄟𑄴#,
		},
		'America/Belize' => {
			exemplarCity => q#𑄝𑄬𑄣𑄨𑄎𑄴#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#𑄝𑄳𑄣𑄁𑄇𑄴-𑄥𑄝𑄳𑄣𑄮𑄚𑄴#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#𑄝𑄱 𑄞𑄨𑄌𑄴𑄖#,
		},
		'America/Bogota' => {
			exemplarCity => q#𑄝𑄮𑄉𑄮𑄑#,
		},
		'America/Boise' => {
			exemplarCity => q#𑄝𑄧𑄠𑄧𑄎𑄨#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#𑄝𑄪𑄠𑄬𑄚𑄮𑄌𑄴 𑄃𑄠𑄬𑄢𑄬𑄌𑄴#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#𑄇𑄬𑄟𑄴𑄝𑄳𑄢𑄨𑄎𑄴 𑄝𑄬#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#𑄇𑄟𑄴𑄛𑄮 𑄉𑄳𑄢𑄚𑄴𑄓𑄬#,
		},
		'America/Cancun' => {
			exemplarCity => q#𑄇𑄳𑄠𑄚𑄴𑄇𑄪𑄚𑄴#,
		},
		'America/Caracas' => {
			exemplarCity => q#𑄇𑄳𑄠𑄢𑄇𑄌𑄴#,
		},
		'America/Catamarca' => {
			exemplarCity => q#𑄇𑄳𑄠𑄑𑄟𑄢𑄴𑄇#,
		},
		'America/Cayenne' => {
			exemplarCity => q#𑄇𑄦𑄬𑄚𑄴#,
		},
		'America/Cayman' => {
			exemplarCity => q#𑄇𑄟𑄬𑄚𑄴#,
		},
		'America/Chicago' => {
			exemplarCity => q#𑄥𑄨𑄇𑄉𑄮#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#𑄌𑄨𑄦𑄪𑄠𑄦𑄪𑄠#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#𑄇𑄮𑄢𑄣𑄴 𑄦𑄢𑄴𑄝𑄢𑄴#,
		},
		'America/Cordoba' => {
			exemplarCity => q#𑄇𑄧𑄢𑄴𑄓𑄮𑄝#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#𑄇𑄮𑄌𑄴𑄑𑄢𑄨𑄇#,
		},
		'America/Creston' => {
			exemplarCity => q#𑄇𑄳𑄢𑄨𑄌𑄴𑄑𑄚𑄴#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#𑄇𑄭𑄪𑄠𑄝#,
		},
		'America/Curacao' => {
			exemplarCity => q#𑄇𑄪𑄢𑄥𑄃𑄮#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#𑄓𑄚𑄴𑄟𑄢𑄴𑄇𑄴𑄥𑄳𑄠𑄞𑄧𑄚𑄴#,
		},
		'America/Dawson' => {
			exemplarCity => q#𑄓𑄧𑄥𑄮𑄚𑄴#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#𑄓𑄧𑄥𑄮𑄚𑄴 𑄇𑄳𑄢𑄨𑄇𑄴#,
		},
		'America/Denver' => {
			exemplarCity => q#𑄓𑄬𑄚𑄴𑄞𑄢𑄴#,
		},
		'America/Detroit' => {
			exemplarCity => q#𑄓𑄬𑄑𑄳𑄢𑄮𑄃𑄨𑄑𑄴#,
		},
		'America/Dominica' => {
			exemplarCity => q#𑄓𑄮𑄟𑄨𑄚𑄨𑄇#,
		},
		'America/Edmonton' => {
			exemplarCity => q#𑄃𑄬𑄓𑄴𑄟𑄧𑄚𑄴𑄑𑄮𑄚𑄴#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#𑄃𑄭𑄢𑄪𑄚𑄬𑄛𑄬#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#𑄃𑄬𑄣𑄴 𑄥𑄣𑄴𑄞𑄘𑄮𑄢𑄴#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#𑄜𑄮𑄢𑄴𑄑𑄴 𑄚𑄬𑄣𑄴𑄥𑄧𑄚𑄴#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#𑄜𑄢𑄴𑄑𑄣𑄬𑄎#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#𑄉𑄳𑄣𑄌𑄴 𑄝𑄬#,
		},
		'America/Godthab' => {
			exemplarCity => q#𑄚𑄪𑄇𑄴#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#𑄉𑄪𑄌𑄴 𑄝𑄬#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#𑄉𑄳𑄢𑄳𑄠𑄚𑄴𑄓𑄴 𑄖𑄪𑄢𑄴𑄇𑄴#,
		},
		'America/Grenada' => {
			exemplarCity => q#𑄉𑄳𑄢𑄬𑄚𑄓#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#𑄉𑄱𑄘𑄬𑄣𑄮𑄛𑄴#,
		},
		'America/Guatemala' => {
			exemplarCity => q#𑄉𑄱𑄖𑄬𑄟𑄣#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#𑄉𑄮𑄠𑄃𑄨𑄠𑄇𑄨𑄣𑄴#,
		},
		'America/Guyana' => {
			exemplarCity => q#𑄉𑄠𑄚#,
		},
		'America/Halifax' => {
			exemplarCity => q#𑄦𑄳𑄠𑄣𑄨𑄜𑄳𑄠𑄇𑄴𑄥𑄴#,
		},
		'America/Havana' => {
			exemplarCity => q#𑄦𑄞𑄚#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#𑄦𑄢𑄴𑄟𑄮𑄥𑄨𑄣𑄳𑄣𑄮#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#𑄚𑄧𑄇𑄴𑄥𑄴, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#𑄟𑄢𑄬𑄋𑄴𑄉𑄮, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#𑄛𑄨𑄑𑄢𑄴𑄥𑄴𑄝𑄢𑄴𑄉𑄴, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#𑄑𑄬𑄣𑄴𑄥𑄨𑄑𑄨, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#𑄞𑄬𑄞𑄬𑄠𑄴, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄚𑄬𑄌𑄴, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#𑄃𑄪𑄃𑄨𑄚𑄟𑄳𑄠𑄇𑄴, 𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#𑄃𑄨𑄚𑄴𑄓𑄨𑄠𑄚𑄛𑄮𑄣𑄨𑄌𑄴#,
		},
		'America/Inuvik' => {
			exemplarCity => q#𑄃𑄨𑄚𑄪𑄞𑄳𑄠𑄇𑄴#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#𑄃𑄨𑄇𑄱𑄣𑄪𑄃𑄨𑄑𑄴#,
		},
		'America/Jamaica' => {
			exemplarCity => q#𑄎𑄟𑄭𑄇#,
		},
		'America/Jujuy' => {
			exemplarCity => q#𑄦𑄪𑄦𑄪𑄃𑄨#,
		},
		'America/Juneau' => {
			exemplarCity => q#𑄎𑄪𑄚𑄮#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#𑄟𑄧𑄚𑄴𑄑𑄨𑄌𑄬𑄣𑄮, 𑄇𑄬𑄚𑄴𑄑𑄇𑄨#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#𑄇𑄳𑄢𑄬𑄣𑄬𑄚𑄴𑄓𑄎𑄨𑄇𑄴#,
		},
		'America/La_Paz' => {
			exemplarCity => q#𑄣 𑄛𑄎𑄴#,
		},
		'America/Lima' => {
			exemplarCity => q#𑄣𑄨𑄟#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#𑄣𑄧𑄌𑄴 𑄃𑄳𑄠𑄚𑄴𑄎𑄬𑄣𑄧𑄌𑄴#,
		},
		'America/Louisville' => {
			exemplarCity => q#𑄣𑄭𑄪𑄥𑄴𑄞𑄨𑄣𑄴#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#𑄣𑄮𑄠𑄢𑄴 𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄬𑄌𑄴 𑄇𑄮𑄠𑄢𑄴𑄑𑄢𑄴#,
		},
		'America/Maceio' => {
			exemplarCity => q#𑄟𑄥𑄬𑄠𑄮#,
		},
		'America/Managua' => {
			exemplarCity => q#𑄟𑄚𑄉𑄱#,
		},
		'America/Manaus' => {
			exemplarCity => q#𑄟𑄚𑄃𑄪𑄌𑄴#,
		},
		'America/Marigot' => {
			exemplarCity => q#𑄟𑄢𑄨𑄉𑄮#,
		},
		'America/Martinique' => {
			exemplarCity => q#𑄟𑄢𑄴𑄑𑄨𑄚𑄨𑄇𑄴#,
		},
		'America/Matamoros' => {
			exemplarCity => q#𑄟𑄖𑄟𑄮𑄢𑄮𑄌𑄴#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#𑄟𑄎𑄖𑄴𑄣𑄚𑄴#,
		},
		'America/Mendoza' => {
			exemplarCity => q#𑄟𑄬𑄚𑄴𑄓𑄮𑄎#,
		},
		'America/Menominee' => {
			exemplarCity => q#𑄟𑄬𑄚𑄮𑄟𑄨𑄚𑄨#,
		},
		'America/Merida' => {
			exemplarCity => q#𑄟𑄬𑄢𑄨𑄓#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#𑄇𑄳𑄠𑄇𑄴𑄤𑄢𑄨#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮 𑄥𑄧𑄦𑄧𑄢𑄴#,
		},
		'America/Miquelon' => {
			exemplarCity => q#𑄟𑄨𑄣𑄪𑄣𑄧𑄚𑄴#,
		},
		'America/Moncton' => {
			exemplarCity => q#𑄟𑄧𑄋𑄴𑄑𑄮𑄚𑄴#,
		},
		'America/Monterrey' => {
			exemplarCity => q#𑄟𑄧𑄚𑄴𑄑𑄬𑄢𑄨#,
		},
		'America/Montevideo' => {
			exemplarCity => q#𑄟𑄧𑄚𑄴𑄑𑄬𑄞𑄨𑄓𑄨𑄃𑄮#,
		},
		'America/Montserrat' => {
			exemplarCity => q#𑄟𑄧𑄚𑄴𑄖𑄴𑄥𑄬𑄢𑄖𑄴#,
		},
		'America/Nassau' => {
			exemplarCity => q#𑄚𑄥𑄃𑄪#,
		},
		'America/New_York' => {
			exemplarCity => q#𑄚𑄨𑄅𑄪𑄃𑄨𑄠𑄧𑄢𑄴𑄇𑄴#,
		},
		'America/Nipigon' => {
			exemplarCity => q#𑄚𑄨𑄛𑄨𑄉𑄮𑄚𑄴#,
		},
		'America/Nome' => {
			exemplarCity => q#𑄚𑄮𑄟𑄴#,
		},
		'America/Noronha' => {
			exemplarCity => q#𑄚𑄧𑄢𑄮𑄢𑄴𑄦#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#𑄝𑄬𑄃𑄪𑄣, 𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄓𑄇𑄮𑄑#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#𑄟𑄧𑄖𑄴𑄙𑄳𑄠, 𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄓𑄇𑄮𑄑#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#𑄚𑄨𑄃𑄪 𑄥𑄣𑄬𑄟𑄴, 𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄓𑄇𑄮𑄑#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#𑄃𑄮𑄎𑄨𑄋𑄴𑄉#,
		},
		'America/Panama' => {
			exemplarCity => q#𑄛𑄚𑄟#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#𑄛𑄳𑄠𑄋𑄴𑄉𑄧𑄚𑄨𑄢𑄴𑄑𑄪𑄁#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#𑄛𑄳𑄠𑄢𑄟𑄬𑄢𑄨𑄝𑄮#,
		},
		'America/Phoenix' => {
			exemplarCity => q#𑄜𑄮𑄚𑄨𑄇𑄴𑄥𑄴#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#𑄛𑄮𑄢𑄴𑄑𑄴-𑄦𑄧-𑄛𑄳𑄢𑄨𑄚𑄴𑄥𑄴#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#𑄛𑄮𑄢𑄴𑄑𑄴 𑄃𑄧𑄜𑄴 𑄥𑄳𑄛𑄬𑄚𑄴#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#𑄛𑄮𑄢𑄴𑄖𑄮 𑄞𑄬𑄣𑄴𑄦𑄮#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#𑄛𑄪𑄠𑄬𑄢𑄴𑄖𑄮 𑄢𑄨𑄇𑄮#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#𑄣𑄬𑄭𑄚𑄨 𑄢𑄨𑄞𑄢𑄴#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#𑄢𑄳𑄠𑄋𑄴𑄇𑄨𑄚𑄴 𑄃𑄨𑄚𑄴𑄣𑄬𑄑𑄴#,
		},
		'America/Recife' => {
			exemplarCity => q#𑄢𑄬𑄥𑄨𑄜𑄬#,
		},
		'America/Regina' => {
			exemplarCity => q#𑄢𑄬𑄎𑄨𑄚#,
		},
		'America/Resolute' => {
			exemplarCity => q#𑄢𑄬𑄥𑄮𑄣𑄪𑄑𑄴#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#𑄢𑄨𑄃𑄮 𑄝𑄳𑄢𑄋𑄴𑄇𑄮#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#𑄥𑄚𑄴𑄖 𑄃𑄨𑄥𑄝𑄬𑄣𑄴#,
		},
		'America/Santarem' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄪𑄢𑄬𑄟𑄴#,
		},
		'America/Santiago' => {
			exemplarCity => q#𑄥𑄚𑄴𑄑𑄨𑄠𑄉𑄮#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#𑄥𑄳𑄠𑄚𑄴𑄑𑄮 𑄓𑄮𑄟𑄨𑄁𑄉𑄮#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#𑄥𑄃𑄮 𑄛𑄃𑄪𑄣𑄮#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#𑄃𑄨𑄑𑄴𑄇𑄪𑄠𑄮𑄢𑄴𑄑𑄪𑄢𑄴𑄟𑄨𑄑𑄴#,
		},
		'America/Sitka' => {
			exemplarCity => q#𑄥𑄨𑄑𑄴𑄇#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴. 𑄝𑄢𑄴𑄗𑄬𑄣𑄬𑄟𑄨#,
		},
		'America/St_Johns' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄎𑄧𑄚𑄴𑄥𑄴#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴. 𑄇𑄨𑄑𑄴𑄥𑄴#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴. 𑄣𑄪𑄥𑄨𑄠#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄗𑄧𑄟𑄌𑄴#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄞𑄨𑄚𑄴𑄥𑄬𑄚𑄴𑄑𑄴#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#𑄥𑄭𑄪𑄜𑄴𑄑𑄴 𑄇𑄢𑄬𑄚𑄳𑄑𑄴#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#𑄖𑄬𑄉𑄪𑄥𑄨𑄉𑄣𑄴𑄛#,
		},
		'America/Thule' => {
			exemplarCity => q#𑄗𑄪𑄣𑄨#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#𑄐𑄚𑄴𑄓𑄢𑄴 𑄝𑄬#,
		},
		'America/Tijuana' => {
			exemplarCity => q#𑄖𑄨𑄎𑄪𑄠𑄚#,
		},
		'America/Toronto' => {
			exemplarCity => q#𑄑𑄮𑄢𑄧𑄚𑄴𑄑𑄮#,
		},
		'America/Tortola' => {
			exemplarCity => q#𑄑𑄧𑄢𑄴𑄑𑄮𑄣#,
		},
		'America/Vancouver' => {
			exemplarCity => q#𑄞𑄳𑄠𑄚𑄴𑄇𑄪𑄞𑄢𑄴#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#𑄦𑄠𑄭𑄑𑄴𑄦𑄧𑄢𑄴𑄥𑄴#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#𑄃𑄪𑄃𑄨𑄚𑄨𑄛𑄬𑄉𑄴#,
		},
		'America/Yakutat' => {
			exemplarCity => q#𑄃𑄨𑄠𑄇𑄪𑄑𑄑𑄴#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#𑄃𑄨𑄠𑄬𑄣𑄮𑄚𑄭𑄜𑄴#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦 𑄘𑄨𑄚𑄮𑄃𑄣𑄮 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄏𑄧𑄣𑄴 𑄉𑄢𑄳𑄦 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#𑄛𑄪𑄉𑄮 𑄞𑄨𑄘𑄬𑄢𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄪𑄉𑄮 𑄞𑄨𑄘𑄬𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄪𑄉𑄮 𑄞𑄨𑄘𑄬𑄢𑄴 𑄛𑄳𑄢𑄧𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#𑄦𑄨𑄣𑄧𑄧𑄱 𑄞𑄨𑄘𑄬𑄢𑄴 𑄘𑄨𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄦𑄨𑄣𑄧𑄧𑄱 𑄞𑄨𑄘𑄬𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄦𑄨𑄣𑄧𑄧𑄱 𑄞𑄨𑄘𑄬𑄢𑄴 𑄛𑄳𑄢𑄧𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#𑄛𑄳𑄢𑄧𑄥𑄚𑄴𑄖𑄧 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄞𑄨𑄘𑄬𑄢𑄴 𑄘𑄨𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄳𑄢𑄧𑄥𑄚𑄴𑄖𑄧 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄞𑄨𑄘𑄬𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄳𑄢𑄧𑄥𑄚𑄴𑄖𑄧 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄞𑄨𑄘𑄬𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#𑄃𑄧𑄚𑄴𑄘𑄠𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄧𑄚𑄴𑄘𑄠𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄧𑄚𑄴𑄘𑄠𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#𑄇𑄳𑄆𑄬𑄥𑄨#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#𑄓𑄬𑄞𑄨𑄥𑄴#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#𑄓𑄪𑄟𑄧𑄚𑄴𑄑𑄴 𑄓𑄨𑄃𑄪𑄢𑄧𑄞𑄨𑄣𑄴#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#𑄟𑄳𑄠𑄇𑄴𑄅𑄠𑄳𑄠𑄢𑄨#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#𑄟𑄧𑄥𑄮𑄚𑄴#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#𑄟𑄳𑄠𑄇𑄴𑄟𑄪𑄢𑄴𑄓𑄮#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#𑄛𑄣𑄴𑄟𑄢𑄴#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#𑄢𑄧𑄗𑄬𑄢#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#𑄥𑄨𑄤#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#𑄑𑄳𑄢𑄧𑄣𑄴#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#𑄞𑄧𑄌𑄴𑄑𑄮𑄇𑄴#,
		},
		'Apia' => {
			long => {
				'daylight' => q#𑄃𑄧𑄛𑄨𑄠 𑄘𑄨𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄧𑄛𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄧𑄛𑄨𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Aqtau' => {
			long => {
				'daylight' => q#𑄃𑄇𑄴𑄑𑄃𑄮 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄇𑄴𑄑𑄃𑄮 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄇𑄴𑄑𑄃𑄮 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Aqtobe' => {
			long => {
				'daylight' => q#𑄃𑄇𑄴𑄑𑄮𑄝𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄇𑄴𑄑𑄮𑄝𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄇𑄴𑄑𑄮𑄝𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#𑄃𑄢𑄧𑄝𑄨 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄢𑄧𑄝𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄢𑄧𑄝𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#𑄣𑄧𑄁𑄉𑄨𑄠𑄢𑄴𑄝𑄨𑄠𑄬𑄚𑄴#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄢𑄴𑄎𑄬𑄚𑄴𑄑𑄨𑄚 𑄛𑄳𑄢𑄧𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄢𑄴𑄟𑄬𑄚𑄨𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#𑄃𑄦𑄴𑄘𑄬𑄚𑄴#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#𑄃𑄣𑄴𑄟𑄑𑄨#,
		},
		'Asia/Amman' => {
			exemplarCity => q#𑄃𑄟𑄳𑄦𑄴𑄚𑄴#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#𑄃𑄳𑄠𑄚𑄓𑄨𑄢𑄴#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#𑄃𑄇𑄴𑄑𑄃𑄪#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#𑄃𑄇𑄴𑄑𑄮𑄝𑄬#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#𑄃𑄌𑄴𑄉𑄪𑄝𑄖𑄴#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#𑄝𑄇𑄴𑄘𑄖𑄴#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#𑄝𑄦𑄧𑄢𑄨𑄚𑄴#,
		},
		'Asia/Baku' => {
			exemplarCity => q#𑄝𑄇𑄪#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#𑄝𑄳𑄠𑄁𑄇𑄧𑄇𑄴#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#𑄝𑄢𑄴𑄚𑄯𑄣𑄴#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#𑄝𑄬𑄭𑄢𑄪𑄑𑄴#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#𑄝𑄨𑄥𑄴𑄇𑄬𑄇𑄴#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#𑄝𑄳𑄢𑄪𑄚𑄬𑄭#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#𑄇𑄧𑄣𑄴𑄉𑄘#,
		},
		'Asia/Chita' => {
			exemplarCity => q#𑄌𑄨𑄖#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#𑄌𑄰𑄱𑄝𑄣𑄴𑄥𑄳𑄠𑄚𑄴#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#𑄇𑄧𑄣𑄧𑄟𑄳𑄝𑄧𑄧𑄱𑄱#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#𑄘𑄟𑄌𑄴𑄇𑄌𑄴#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#𑄔𑄇#,
		},
		'Asia/Dili' => {
			exemplarCity => q#𑄘𑄨𑄣𑄨#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#𑄘𑄪𑄝𑄭#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#𑄘𑄪𑄥𑄚𑄴𑄝𑄬#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#𑄉𑄎#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#𑄦𑄬𑄝𑄳𑄢𑄮𑄚𑄴#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#𑄦𑄧𑄁 𑄇𑄧𑄁#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#𑄦𑄮𑄞𑄴𑄓𑄴#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#𑄃𑄨𑄢𑄴𑄇𑄪𑄑𑄴𑄥𑄴𑄇𑄴#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#𑄎𑄇𑄢𑄴𑄖#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#𑄎𑄧𑄠𑄛𑄪𑄢#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#𑄎𑄬𑄢𑄪𑄎𑄣𑄬𑄟𑄴#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#𑄇𑄝𑄪𑄣𑄴#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#𑄇𑄟𑄴𑄌𑄑𑄴𑄇#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#𑄇𑄧𑄢𑄌𑄨#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#𑄇𑄖𑄴𑄟𑄪𑄚𑄴𑄓𑄪#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#𑄈𑄚𑄴𑄘𑄨𑄠𑄉#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#𑄇𑄳𑄢𑄌𑄴𑄚𑄮𑄠𑄢𑄴𑄥𑄴𑄇𑄴#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#𑄇𑄪𑄠𑄣𑄣𑄟𑄴𑄛𑄪𑄢𑄴#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#𑄇𑄪𑄌𑄨𑄁#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#𑄇𑄪𑄠𑄬𑄖𑄴#,
		},
		'Asia/Macau' => {
			exemplarCity => q#𑄟𑄳𑄠𑄇𑄃𑄮#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#𑄟𑄳𑄠𑄉𑄓𑄚𑄴#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#𑄟𑄇𑄥𑄴𑄥𑄢𑄴#,
		},
		'Asia/Manila' => {
			exemplarCity => q#𑄟𑄳𑄠𑄚𑄨𑄣#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#𑄟𑄥𑄴𑄇𑄖𑄴#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#𑄚𑄨𑄇𑄮𑄥𑄨𑄠#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#𑄚𑄮𑄞𑄮𑄇𑄪𑄎𑄴𑄚𑄬𑄑𑄴𑄥𑄴𑄇𑄴#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#𑄚𑄧𑄞𑄮𑄥𑄨𑄝𑄨𑄢𑄴𑄥𑄴𑄇𑄴#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#𑄃𑄮𑄟𑄧𑄥𑄴𑄇𑄴#,
		},
		'Asia/Oral' => {
			exemplarCity => q#𑄃𑄮𑄢𑄣𑄴#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#𑄚𑄧𑄟𑄴 𑄛𑄬𑄚𑄴#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#𑄛𑄧𑄚𑄴𑄖𑄨𑄠𑄚𑄳𑄠𑄇𑄴#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#𑄛𑄨𑄠𑄧𑄁 𑄃𑄨𑄠𑄧𑄁#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#𑄇𑄖𑄢𑄴#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#𑄇𑄨𑄎𑄨𑄣𑄧𑄢𑄴𑄓#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#𑄢𑄬𑄋𑄴𑄉𑄪𑄚𑄴#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#𑄢𑄨𑄠𑄙𑄴#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#𑄦𑄮 𑄌𑄨 𑄟𑄨𑄚𑄴 𑄥𑄧𑄦𑄧𑄢𑄴#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#𑄥𑄈𑄣𑄨𑄚𑄴#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#𑄥𑄧𑄟𑄧𑄢𑄴𑄈𑄧𑄚𑄴𑄘𑄧#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#𑄥𑄨𑄃𑄮𑄣𑄴#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#𑄥𑄁𑄊𑄭#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#𑄥𑄨𑄋𑄴𑄉𑄛𑄪𑄢𑄴#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#𑄥𑄳𑄢𑄬𑄓𑄴𑄚𑄬𑄇𑄮𑄣𑄧𑄠𑄴𑄟𑄧𑄥𑄴𑄇𑄴#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#𑄖𑄭𑄛𑄳𑄆𑄬#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#𑄖𑄌𑄴𑄈𑄧𑄚𑄴𑄘𑄧#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#𑄖𑄪𑄝𑄪𑄣𑄨𑄥𑄨#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#𑄖𑄬𑄦𑄬𑄢𑄚𑄴#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#𑄗𑄨𑄟𑄴𑄜𑄪#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#𑄑𑄮𑄇𑄨𑄃𑄮#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#𑄖𑄮𑄟𑄧𑄌𑄴𑄇𑄴#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#𑄃𑄪𑄣𑄚𑄴𑄝𑄖𑄢𑄴#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#𑄃𑄪𑄢𑄪𑄟𑄴𑄇𑄨#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#𑄅𑄪𑄌𑄴𑄖𑄧 𑄚𑄬𑄢#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#𑄞𑄨𑄠𑄬𑄚𑄴𑄖𑄨𑄠𑄬𑄚𑄴#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#𑄞𑄳𑄣𑄘𑄨𑄞𑄧𑄌𑄴𑄑𑄧𑄇𑄴#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#𑄠𑄇𑄪𑄖𑄴𑄥𑄴𑄇𑄴#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#𑄃𑄨𑄠𑄬𑄇𑄑𑄬𑄢𑄨𑄚𑄴𑄝𑄢𑄴𑄉𑄴#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#𑄃𑄨𑄠𑄬𑄢𑄞𑄚𑄴#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#𑄃𑄑𑄴𑄣𑄚𑄴𑄖𑄨𑄉𑄮𑄢𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄑𑄴𑄣𑄚𑄴𑄖𑄨𑄉𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄑𑄴𑄣𑄚𑄴𑄖𑄨𑄉𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#𑄃𑄎𑄮𑄢𑄬𑄌𑄴#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#𑄝𑄢𑄴𑄟𑄪𑄓#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#𑄇𑄚𑄬𑄢𑄨#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄓𑄬#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#𑄜𑄳𑄠𑄢𑄮#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#𑄟𑄓𑄬𑄭𑄢#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#𑄢𑄨𑄇𑄴𑄎𑄞𑄨𑄇𑄴#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄦𑄬𑄣𑄬𑄚#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#𑄥𑄳𑄑𑄚𑄴𑄣𑄨#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#𑄃𑄳𑄠𑄓𑄬𑄣𑄬𑄭𑄓𑄴#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#𑄝𑄳𑄢𑄨𑄥𑄴𑄝𑄬𑄚𑄴#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#𑄝𑄳𑄢𑄮𑄇𑄬𑄚𑄴 𑄦𑄨𑄣𑄴#,
		},
		'Australia/Currie' => {
			exemplarCity => q#𑄇𑄨𑄃𑄪𑄢𑄨#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#𑄓𑄢𑄴𑄃𑄪𑄃𑄨𑄚𑄴#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#𑄃𑄨𑄃𑄪𑄇𑄳𑄣#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#𑄦𑄮𑄝𑄢𑄴𑄑𑄴#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#𑄣𑄨𑄚𑄴𑄓𑄬𑄟𑄳𑄠𑄚𑄴#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#𑄣𑄧𑄢𑄴𑄓𑄴 𑄦𑄃𑄮#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#𑄟𑄬𑄣𑄴𑄝𑄢𑄴𑄚𑄴#,
		},
		'Australia/Perth' => {
			exemplarCity => q#𑄛𑄢𑄴𑄗𑄧#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#𑄥𑄨𑄓𑄴𑄚𑄨#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦𑄢𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦𑄢𑄴 𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦𑄢𑄴 𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦𑄢𑄴 𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄏𑄧𑄣𑄴 𑄉𑄧𑄢𑄳𑄦𑄢𑄴 𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄛𑄪𑄉𑄬𑄘𑄨 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄛𑄪𑄉𑄬𑄘𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄧𑄌𑄴𑄑𑄳𑄢𑄬𑄣𑄨𑄠𑄧 𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄎𑄢𑄴𑄝𑄭𑄎𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#𑄃𑄬𑄎𑄮𑄢𑄬𑄌𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄬𑄎𑄮𑄢𑄬𑄌𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄬𑄎𑄮𑄢𑄬𑄌𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#𑄝𑄁𑄣𑄘𑄬𑄌𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄝𑄁𑄣𑄘𑄬𑄌𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄝𑄁𑄣𑄘𑄬𑄌𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#𑄞𑄪𑄑𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#𑄝𑄮𑄣𑄨𑄞𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#𑄝𑄳𑄢𑄥𑄨𑄣𑄨𑄠 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄝𑄳𑄢𑄥𑄨𑄣𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄝𑄳𑄢𑄥𑄨𑄣𑄨𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#𑄝𑄳𑄢𑄪𑄚𑄬𑄭 𑄘𑄢𑄪𑄌𑄴𑄥𑄣𑄟𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄬𑄛𑄴 𑄞𑄢𑄴𑄘𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#𑄌𑄟𑄬𑄢𑄮 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#𑄌𑄳𑄠𑄗𑄟𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄌𑄳𑄠𑄗𑄟𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄌𑄳𑄠𑄗𑄟𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#𑄌𑄨𑄣𑄨 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄌𑄨𑄣𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄌𑄨𑄣𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#𑄌𑄨𑄚𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄌𑄨𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄌𑄨𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#𑄌𑄧𑄠𑄴𑄝𑄣𑄴𑄥𑄧𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄌𑄧𑄠𑄴𑄝𑄣𑄴𑄥𑄧𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄌𑄧𑄠𑄴𑄝𑄣𑄴𑄥𑄧𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#𑄇𑄳𑄢𑄨𑄌𑄴𑄟𑄥𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#𑄇𑄮𑄇𑄮𑄌𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#𑄇𑄧𑄣𑄧𑄟𑄴𑄝𑄨𑄠 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄧𑄣𑄧𑄟𑄴𑄝𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄧𑄣𑄧𑄟𑄴𑄝𑄨𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#𑄇𑄪𑄇𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄖𑄴𑄙𑄬𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄪𑄇𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄪𑄇𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#𑄇𑄨𑄃𑄪𑄝 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄨𑄃𑄪𑄝𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄨𑄃𑄪𑄝 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#𑄓𑄬𑄞𑄨𑄥𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#𑄓𑄪𑄟𑄧𑄚𑄴𑄑𑄴-𑄘𑄳𑄠𑄧 𑄅𑄪𑄢𑄴𑄞𑄨𑄣𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄑𑄨𑄟𑄪𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#𑄃𑄨𑄥𑄴𑄑𑄢𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄨𑄥𑄴𑄑𑄢𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄨𑄥𑄴𑄑𑄢𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#𑄃𑄨𑄇𑄪𑄠𑄬𑄓𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#𑄘𑄇𑄴𑄘𑄨𑄠 𑄛𑄨𑄖𑄴𑄗𑄨𑄟𑄨𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#𑄃𑄧𑄌𑄨𑄚𑄴 𑄥𑄧𑄦𑄧𑄢𑄴#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#𑄃𑄟𑄧𑄌𑄴𑄑𑄢𑄴𑄓𑄟𑄴#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#𑄃𑄳𑄃𑄚𑄴𑄓𑄮𑄢#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#𑄃𑄌𑄴𑄑𑄳𑄢𑄈𑄚𑄴#,
		},
		'Europe/Athens' => {
			exemplarCity => q#𑄃𑄬𑄗𑄬𑄚𑄴𑄌𑄴#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#𑄝𑄬𑄣𑄴𑄉𑄳𑄢𑄬𑄓𑄴#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#𑄝𑄢𑄴𑄣𑄨𑄚𑄴#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#𑄝𑄳𑄢𑄖𑄨𑄥𑄳𑄣𑄞#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#𑄝𑄳𑄢𑄥𑄬𑄣𑄴𑄥𑄴#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#𑄝𑄪𑄈𑄢𑄬𑄌𑄴𑄑𑄴#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#𑄝𑄪𑄓𑄛𑄬𑄌𑄴𑄑𑄴#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#𑄝𑄪𑄥𑄨𑄚𑄴𑄉𑄬𑄚𑄴#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#𑄇𑄨𑄥𑄨𑄚𑄦𑄪#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#𑄎𑄮𑄛𑄬𑄚𑄴𑄦𑄬𑄉𑄬𑄚𑄴#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#𑄓𑄛𑄴𑄣𑄨𑄚𑄴#,
			long => {
				'daylight' => q#𑄃𑄭𑄢𑄨𑄌𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#𑄎𑄨𑄝𑄳𑄢𑄣𑄴𑄑𑄢𑄴#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#𑄉𑄬𑄢𑄬𑄚𑄴𑄎𑄨#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#𑄦𑄬𑄣𑄴𑄥𑄨𑄁𑄇𑄨#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#𑄃𑄭𑄣𑄴 𑄃𑄧𑄜𑄴 𑄟𑄳𑄠𑄚𑄴#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#𑄃𑄨𑄌𑄴𑄖𑄚𑄴𑄝𑄪𑄣𑄴#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#𑄎𑄢𑄴𑄥𑄨#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#𑄇𑄣𑄨𑄚𑄨𑄋𑄴𑄉𑄳𑄢𑄓𑄴#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#𑄇𑄨𑄠𑄬𑄞𑄴#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#𑄇𑄨𑄢𑄬𑄞𑄴#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#𑄣𑄨𑄌𑄴𑄝𑄧𑄚𑄴#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#𑄣𑄪𑄝𑄴𑄣𑄨𑄠𑄚#,
		},
		'Europe/London' => {
			exemplarCity => q#𑄣𑄧𑄚𑄴𑄓𑄧𑄚𑄴#,
			long => {
				'daylight' => q#𑄝𑄳𑄢𑄨𑄑𑄨𑄌𑄴 𑄉𑄧𑄢𑄧𑄟𑄧 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#𑄣𑄪𑄇𑄴𑄥𑄬𑄟𑄴𑄝𑄢𑄴𑄉𑄴#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#𑄟𑄓𑄳𑄢𑄨𑄓𑄴#,
		},
		'Europe/Malta' => {
			exemplarCity => q#𑄟𑄧𑄣𑄴𑄑#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#𑄟𑄧𑄢𑄨𑄠𑄬𑄦𑄟𑄬𑄚𑄴#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#𑄟𑄨𑄚𑄴𑄥𑄳𑄇𑄴#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#𑄟𑄮𑄚𑄇𑄮#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#𑄟𑄧𑄌𑄴𑄇𑄮#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#𑄃𑄧𑄥𑄴𑄣𑄮#,
		},
		'Europe/Paris' => {
			exemplarCity => q#𑄛𑄳𑄠𑄢𑄨𑄌𑄴#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#𑄛𑄧𑄓𑄴𑄉𑄧𑄢𑄨𑄇#,
		},
		'Europe/Prague' => {
			exemplarCity => q#𑄛𑄳𑄢𑄉𑄴#,
		},
		'Europe/Riga' => {
			exemplarCity => q#𑄢𑄨𑄉#,
		},
		'Europe/Rome' => {
			exemplarCity => q#𑄢𑄮𑄟𑄴#,
		},
		'Europe/Samara' => {
			exemplarCity => q#𑄥𑄟𑄢#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#𑄥𑄚𑄴 𑄟𑄬𑄢𑄨𑄚𑄮#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#𑄥𑄢𑄎𑄨𑄞𑄮#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#𑄥𑄨𑄟𑄴𑄜𑄬𑄢𑄮𑄛𑄮𑄣𑄴#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#𑄥𑄳𑄇𑄧𑄛𑄴𑄡𑄬#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#𑄥𑄮𑄜𑄨𑄠#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#𑄥𑄳𑄑𑄧𑄇𑄴𑄦𑄮𑄟𑄴#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#𑄦𑄣𑄨𑄚𑄴#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#𑄖𑄨𑄢𑄚#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#𑄅𑄪𑄣𑄨𑄠𑄚𑄮𑄞𑄴𑄥𑄴𑄇𑄴#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#𑄅𑄪𑄏𑄴𑄉𑄮𑄢𑄮𑄓𑄴#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#𑄞𑄘𑄪𑄎𑄴#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#𑄞𑄑𑄨𑄇𑄚𑄴#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#𑄞𑄨𑄠𑄬𑄚#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#𑄞𑄨𑄣𑄴𑄚𑄨𑄠𑄌𑄴#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#𑄞𑄮𑄣𑄴𑄉𑄮𑄉𑄳𑄢𑄖𑄴#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#𑄤𑄢𑄴𑄥𑄧#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#𑄎𑄉𑄳𑄢𑄬𑄛𑄴#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#𑄎𑄬𑄛𑄮𑄢𑄮𑄎𑄭𑄠𑄭#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#𑄎𑄪𑄢𑄨𑄈𑄴#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄟𑄧𑄖𑄴𑄙𑄳𑄠 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#𑄃𑄬𑄇𑄴𑄉𑄮𑄙𑄳𑄆𑄬𑄣𑄴 𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#𑄛𑄧𑄏𑄬𑄟𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄨𑄃𑄪𑄢𑄮𑄝𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄜𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#𑄜𑄨𑄎𑄨 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄜𑄨𑄎𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄜𑄨𑄎𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#𑄜𑄧𑄢𑄥𑄨 𑄉𑄠𑄚 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#𑄜𑄧𑄢𑄥𑄨 𑄘𑄧𑄉𑄨𑄚𑄴 𑄃𑄳𑄃 𑄃𑄚𑄴𑄑𑄢𑄴𑄇𑄧𑄑𑄨𑄇 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#𑄉𑄳𑄢𑄨𑄚𑄨𑄌𑄴 𑄟𑄨𑄚𑄴 𑄑𑄬𑄟𑄴#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#𑄉𑄣𑄛𑄉𑄮𑄌𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#𑄉𑄳𑄠𑄟𑄴𑄝𑄨𑄠𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#𑄉𑄨𑄣𑄴𑄝𑄢𑄴𑄑𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄉𑄳𑄢𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄉𑄳𑄢𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄉𑄳𑄢𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄉𑄳𑄢𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄨𑄏𑄬𑄟𑄴𑄘𑄨 𑄉𑄳𑄢𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄉𑄳𑄢𑄨𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Guam' => {
			long => {
				'standard' => q#𑄉𑄪𑄠𑄟𑄴 𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#𑄃𑄪𑄛𑄧𑄥𑄉𑄧𑄢𑄨𑄠𑄧 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#𑄉𑄪𑄠𑄚 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#𑄦𑄧𑄃𑄮𑄠𑄭-𑄃𑄣𑄬𑄃𑄪𑄖𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄦𑄃𑄮𑄠𑄭 𑄃𑄳𑄠𑄣𑄨𑄃𑄪𑄑𑄨𑄠𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄦𑄧𑄃𑄮𑄠𑄭-𑄃𑄣𑄬𑄃𑄪𑄖𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#𑄦𑄧𑄁 𑄇𑄧𑄁 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄦𑄧𑄁 𑄇𑄧𑄁 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄦𑄧𑄁 𑄇𑄧𑄁 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#𑄦𑄮𑄞𑄧𑄓𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄦𑄮𑄞𑄧𑄓𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄦𑄮𑄞𑄧𑄓𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'India' => {
			long => {
				'standard' => q#𑄃𑄨𑄚𑄴𑄘𑄨𑄠𑄬 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
			short => {
				'standard' => q#IST#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#𑄃𑄚𑄴𑄖𑄚𑄚𑄢𑄨𑄞𑄮#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#𑄍𑄉𑄮𑄌𑄴#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#𑄡𑄪𑄥𑄪𑄢𑄴 𑄎𑄧𑄚𑄧𑄟𑄴𑄘𑄨𑄚𑄴#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#𑄇𑄮𑄇𑄮𑄌𑄴#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#𑄇𑄮𑄟𑄮𑄢𑄮#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#𑄇𑄢𑄴𑄉𑄪𑄣𑄬𑄚𑄴#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#𑄟𑄦𑄬#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#𑄟𑄣𑄴𑄘𑄨𑄛𑄴#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#𑄟𑄧𑄢𑄨𑄥𑄥𑄴#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#𑄟𑄠𑄮𑄖𑄮#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#𑄢𑄨𑄃𑄨𑄅𑄪𑄚𑄨𑄠𑄧𑄚𑄴#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#𑄃𑄨𑄚𑄴𑄘𑄨𑄠𑄬 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#𑄃𑄨𑄚𑄴𑄘𑄮𑄌𑄩𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#𑄃𑄏𑄧𑄣𑄴 𑄉𑄢𑄳𑄦 𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄃𑄨𑄚𑄴𑄘𑄮𑄚𑄬𑄥𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#𑄃𑄨𑄢𑄚𑄴 𑄘𑄨𑄚𑄬𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄨𑄢𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄨𑄢𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#𑄃𑄨𑄢𑄴𑄖𑄪𑄑𑄴𑄥𑄴𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄨𑄢𑄴𑄖𑄪𑄑𑄴𑄥𑄴𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄨𑄢𑄴𑄖𑄪𑄑𑄴𑄥𑄴𑄇𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#𑄃𑄨𑄎𑄴𑄢𑄠𑄬𑄣𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄨𑄎𑄢𑄠𑄬𑄣𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄨𑄎𑄴𑄢𑄠𑄬𑄣𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#𑄎𑄛𑄚𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄎𑄛𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄎𑄛𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#𑄛𑄨𑄖𑄳𑄢𑄬𑄛𑄳𑄠𑄞𑄧𑄣𑄧𑄥𑄴𑄇𑄴-𑄇𑄳𑄠𑄟𑄴𑄌𑄳𑄠𑄑𑄴𑄃𑄨𑄥𑄴𑄇𑄨 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄨𑄖𑄳𑄢𑄬𑄛𑄳𑄠𑄞𑄧𑄣𑄧𑄥𑄴𑄇𑄴-𑄇𑄳𑄠𑄟𑄴𑄌𑄳𑄠𑄑𑄴𑄃𑄨𑄥𑄴𑄇𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄨𑄖𑄳𑄢𑄬𑄛𑄳𑄠𑄞𑄧𑄣𑄧𑄥𑄴𑄇𑄴-𑄇𑄳𑄠𑄟𑄴𑄌𑄳𑄠𑄑𑄴𑄃𑄨𑄥𑄴𑄇𑄨 𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#𑄛𑄪𑄉𑄬𑄘𑄨 𑄇𑄎𑄇𑄴𑄥𑄳𑄖𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#𑄛𑄧𑄏𑄨𑄟𑄬𑄘𑄨 𑄇𑄎𑄇𑄴𑄥𑄳𑄖𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#𑄇𑄮𑄢𑄨𑄠𑄚𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄮𑄢𑄨𑄠𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄮𑄢𑄨𑄠𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#𑄇𑄮𑄌𑄴𑄢𑄳𑄆𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#𑄇𑄳𑄢𑄥𑄴𑄚𑄮𑄠𑄢𑄴𑄥𑄴𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄳𑄢𑄥𑄴𑄚𑄮𑄠𑄢𑄴𑄥𑄴𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄳𑄢𑄥𑄴𑄚𑄮𑄠𑄢𑄴𑄥𑄴𑄇𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#𑄇𑄨𑄢𑄴𑄉𑄨𑄥𑄴𑄖𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Lanka' => {
			long => {
				'standard' => q#𑄣𑄧𑄁𑄇 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#𑄣𑄭𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#𑄣𑄧𑄢𑄴𑄓𑄴 𑄦𑄤𑄬 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄣𑄧𑄢𑄴𑄓𑄴 𑄦𑄤𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄣𑄧𑄢𑄴𑄓𑄴 𑄦𑄤𑄬 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Macau' => {
			long => {
				'daylight' => q#𑄟𑄇𑄃𑄮 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄟𑄇𑄃𑄮 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄟𑄇𑄃𑄮 𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#𑄟𑄳𑄠𑄇𑄴𑄇𑄪𑄢𑄨 𑄉𑄭 𑄉𑄭 𑄞𑄬𑄘 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#𑄟𑄳𑄠𑄉𑄓𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄟𑄳𑄠𑄉𑄓𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄟𑄳𑄠𑄉𑄓𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#𑄟𑄣𑄴𑄠𑄬𑄥𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#𑄟𑄣𑄴𑄘𑄨𑄛𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#𑄟𑄢𑄴𑄇𑄬𑄥𑄥𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#𑄟𑄢𑄴𑄥𑄣𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#𑄟𑄧𑄢𑄨𑄥𑄥𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄟𑄧𑄢𑄨𑄥𑄥𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄟𑄧𑄢𑄨𑄥𑄥𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#𑄟𑄧𑄥𑄳𑄦𑄧𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄛𑄧𑄏𑄨𑄟𑄴 𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮𑄢𑄴 𑄘𑄨𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄛𑄧𑄏𑄨𑄟𑄴 𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄛𑄧𑄏𑄨𑄟𑄴 𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄥𑄚𑄴𑄖𑄧 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄥𑄚𑄴𑄖𑄧 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄟𑄬𑄇𑄴𑄥𑄨𑄇𑄚𑄴 𑄛𑄳𑄢𑄧𑄥𑄚𑄴𑄖𑄧 𑄟𑄧𑄦𑄥𑄉𑄧𑄢𑄧𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#𑄃𑄪𑄣𑄚𑄴 𑄝𑄖𑄮𑄢𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄪𑄣𑄚𑄴 𑄝𑄖𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄪𑄣𑄚𑄴 𑄝𑄖𑄮𑄢𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#𑄟𑄧𑄥𑄴𑄇𑄮 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄟𑄧𑄥𑄴𑄇𑄮 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄟𑄧𑄥𑄴𑄇𑄮 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#𑄟𑄠𑄚𑄴𑄟𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#𑄚𑄃𑄪𑄢𑄪 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#𑄚𑄬𑄛𑄣𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#𑄚𑄨𑄃𑄪 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄚𑄨𑄃𑄪 𑄃𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄚𑄨𑄃𑄪 𑄇𑄳𑄠𑄣𑄬𑄓𑄮𑄚𑄨𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄚𑄨𑄃𑄪𑄎𑄨𑄣𑄳𑄠𑄚𑄴𑄓𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#𑄚𑄨𑄃𑄪𑄜𑄃𑄪𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄚𑄨𑄃𑄪𑄜𑄃𑄪𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄚𑄨𑄃𑄪𑄜𑄃𑄪𑄚𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄨 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#𑄚𑄨𑄃𑄪𑄃𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Norfolk' => {
			long => {
				'standard' => q#𑄚𑄧𑄢𑄴𑄜𑄮𑄇𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#𑄜𑄢𑄴𑄚𑄚𑄴𑄘𑄮𑄓𑄨 𑄚𑄮𑄢𑄮𑄚𑄴𑄦 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄜𑄢𑄴𑄚𑄚𑄴𑄘𑄮𑄓𑄨 𑄚𑄮𑄢𑄮𑄚𑄴𑄦 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄜𑄢𑄴𑄚𑄚𑄴𑄘𑄮𑄓𑄨 𑄚𑄮𑄢𑄮𑄚𑄴𑄦 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'North_Mariana' => {
			long => {
				'standard' => q#𑄅𑄪𑄖𑄴𑄖𑄮𑄢𑄴 𑄟𑄬𑄢𑄨𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#𑄚𑄮𑄞𑄮𑄥𑄨𑄝𑄨𑄢𑄴𑄥𑄴𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄚𑄮𑄞𑄮𑄥𑄨𑄝𑄨𑄢𑄴𑄥𑄴𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄚𑄮𑄞𑄮𑄥𑄨𑄝𑄨𑄢𑄴𑄥𑄴𑄇𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#𑄃𑄮𑄟𑄧𑄥𑄴𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄮𑄟𑄧𑄥𑄴𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄮𑄟𑄧𑄥𑄴𑄇𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#𑄃𑄛𑄨𑄠#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#𑄃𑄧𑄇𑄴𑄣𑄳𑄠𑄚𑄴𑄓𑄴#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#𑄝𑄪𑄉𑄬𑄚𑄴𑄞𑄨𑄣𑄬#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#𑄌𑄳𑄠𑄗𑄟𑄴#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#𑄃𑄨𑄌𑄴𑄑𑄢𑄴#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#𑄃𑄨𑄜𑄖𑄬#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#𑄃𑄬𑄚𑄴𑄓𑄢𑄴𑄝𑄢𑄨#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#𑄜𑄳𑄠𑄇𑄃𑄮𑄜𑄮#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#𑄜𑄨𑄎𑄨#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#𑄜𑄪𑄚𑄜𑄪𑄑𑄨#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#𑄉𑄳𑄠𑄣𑄛𑄳𑄠𑄉𑄮𑄌𑄴#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#𑄉𑄟𑄴𑄝𑄨𑄠𑄬𑄢𑄴#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#𑄉𑄮𑄠𑄘𑄣𑄘𑄇𑄚𑄣𑄴#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#𑄉𑄱𑄟𑄴#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#𑄦𑄧𑄚𑄮𑄣𑄪𑄣𑄪#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#𑄎𑄧𑄚𑄴𑄥𑄳𑄑𑄧𑄚𑄴#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#𑄇𑄨𑄢𑄨𑄖𑄨𑄟𑄖𑄨#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#𑄇𑄮𑄌𑄴𑄢𑄠𑄴#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#𑄇𑄱𑄎𑄣𑄬𑄭𑄚𑄴#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#𑄟𑄎𑄪𑄢𑄮#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#𑄟𑄢𑄴𑄇𑄬𑄥𑄥𑄴#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#𑄟𑄨𑄓𑄴𑄃𑄮𑄠𑄬#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#𑄚𑄃𑄪𑄢𑄪#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#𑄚𑄨𑄃𑄪𑄠𑄨#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#𑄚𑄧𑄢𑄴𑄜𑄮𑄇𑄴#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#𑄚𑄪𑄟𑄨𑄠#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#𑄛𑄳𑄠𑄉𑄮 𑄜𑄳𑄠𑄉𑄮#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#𑄛𑄣𑄅𑄪#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#𑄛𑄨𑄖𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#𑄛𑄮𑄚𑄛𑄬#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#𑄛𑄮𑄢𑄴𑄑𑄴 𑄟𑄯𑄢𑄬𑄎𑄴𑄝𑄨#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#𑄢𑄢𑄧𑄑𑄮𑄁𑄉#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#𑄥𑄭𑄛𑄚𑄴#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#𑄖𑄦𑄨𑄖𑄨#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#𑄑𑄢𑄤#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#𑄑𑄮𑄁𑄉𑄑𑄛𑄪#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#𑄑𑄳𑄢𑄪𑄇𑄴#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#𑄃𑄮𑄠𑄬𑄇𑄴#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#𑄃𑄮𑄣𑄨𑄌𑄴#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄇𑄨𑄥𑄴𑄖𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#𑄛𑄣𑄅𑄪 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#𑄛𑄛𑄪𑄠 𑄚𑄨𑄃𑄪 𑄉𑄨𑄚𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄳𑄠𑄢𑄉𑄪𑄠𑄬 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#𑄛𑄬𑄢𑄪 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄛𑄬𑄢𑄪 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄛𑄬𑄢𑄪 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄜𑄨𑄣𑄨𑄛𑄭𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#𑄜𑄮𑄚𑄨𑄇𑄴𑄥𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄇𑄬𑄣𑄧𑄚𑄴 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄇𑄬𑄣𑄧𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄥𑄬𑄚𑄴𑄑𑄴 𑄛𑄨𑄠𑄬𑄢𑄴 𑄃𑄮 𑄟𑄨𑄇𑄬𑄣𑄧𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#𑄛𑄨𑄖𑄴𑄇𑄬𑄠𑄢𑄴𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#𑄛𑄮𑄚𑄛𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#𑄛𑄨𑄠𑄧𑄁 𑄃𑄨𑄠𑄁 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Qyzylorda' => {
			long => {
				'daylight' => q#𑄇𑄨𑄎𑄨𑄣𑄮𑄢𑄴𑄓 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄇𑄨𑄎𑄨𑄣𑄮𑄢𑄴𑄓 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄇𑄨𑄎𑄨𑄣𑄮𑄢𑄴𑄓 𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#𑄢𑄨𑄃𑄨𑄃𑄪𑄚𑄨𑄠𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#𑄢𑄧𑄗𑄬𑄢 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#𑄥𑄈𑄣𑄨𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄥𑄈𑄣𑄨𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄥𑄈𑄣𑄨𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#𑄥𑄟𑄢 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄥𑄟𑄢 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄥𑄟𑄢 𑄟𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#𑄥𑄟𑄮𑄠 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄥𑄟𑄮𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄥𑄟𑄮𑄠 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#𑄥𑄬𑄥𑄬𑄣𑄧𑄥𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#𑄥𑄨𑄁𑄉𑄛𑄪𑄢 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#𑄥𑄧𑄣𑄮𑄟𑄧𑄚𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬𑄉𑄪𑄚𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#𑄘𑄧𑄉𑄨𑄚𑄴 𑄎𑄧𑄢𑄴𑄎𑄨𑄠 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#𑄥𑄪𑄢𑄨𑄚𑄟𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#𑄥𑄠𑄮𑄤 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#𑄖𑄦𑄨𑄖𑄨 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#𑄖𑄭𑄛𑄳𑄆𑄬 𑄘𑄨𑄚𑄮𑄃𑄣𑄮𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄖𑄭𑄛𑄳𑄆𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄖𑄭𑄛𑄳𑄆𑄬 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#𑄖𑄎𑄈𑄥𑄴𑄖𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#𑄑𑄮𑄇𑄬𑄣𑄃𑄪 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#𑄑𑄮𑄋𑄴𑄉 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄑𑄮𑄋𑄴𑄉 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄑𑄮𑄋𑄴𑄉 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#𑄌𑄪𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#𑄖𑄪𑄢𑄴𑄇𑄴𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄖𑄪𑄢𑄴𑄇𑄴𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄖𑄪𑄢𑄴𑄇𑄴𑄟𑄬𑄚𑄨𑄌𑄴𑄖𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#𑄑𑄪𑄞𑄣𑄪 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄪𑄢𑄪𑄉𑄪𑄠𑄬 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄖𑄚𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄖𑄚𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄪𑄎𑄴𑄝𑄬𑄇𑄨𑄖𑄚𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#𑄞𑄚𑄪𑄠𑄖𑄪 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄞𑄚𑄪𑄠𑄖𑄪 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄞𑄚𑄪𑄠𑄖𑄪 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#𑄞𑄬𑄚𑄬𑄎𑄪𑄠𑄬𑄣 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#𑄝𑄳𑄣𑄘𑄨𑄝𑄮𑄥𑄴𑄖𑄮𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄝𑄳𑄣𑄘𑄨𑄝𑄮𑄥𑄴𑄖𑄮𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄝𑄳𑄣𑄘𑄨𑄝𑄮𑄥𑄴𑄖𑄮𑄇𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#𑄞𑄧𑄣𑄴𑄉𑄮𑄉𑄳𑄢𑄓𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄞𑄧𑄣𑄴𑄉𑄮𑄉𑄳𑄢𑄓𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄞𑄧𑄣𑄴𑄉𑄮𑄉𑄳𑄢𑄓𑄴 𑄟𑄧𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#𑄞𑄧𑄥𑄴𑄑𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#𑄃𑄮𑄠𑄬𑄇𑄴 𑄉𑄭 𑄉𑄭 𑄞𑄨𑄘𑄬 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#𑄤𑄣𑄨𑄥𑄴 𑄃𑄳𑄃 𑄜𑄪𑄑𑄪𑄚 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#𑄠𑄇𑄪𑄖𑄴𑄥𑄴𑄇𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄠𑄇𑄪𑄖𑄴𑄥𑄴𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄠𑄇𑄪𑄖𑄴𑄥𑄴𑄇𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#𑄃𑄨𑄠𑄬𑄇𑄖𑄬𑄢𑄨𑄚𑄴𑄝𑄪𑄢𑄴𑄉𑄴 𑄉𑄧𑄢𑄧𑄟𑄴𑄇𑄣𑄧𑄢𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'generic' => q#𑄃𑄨𑄠𑄬𑄇𑄖𑄬𑄢𑄨𑄚𑄴𑄝𑄪𑄢𑄴𑄉𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
				'standard' => q#𑄃𑄨𑄠𑄬𑄇𑄖𑄬𑄢𑄨𑄚𑄴𑄝𑄪𑄢𑄴𑄉𑄴 𑄟𑄚𑄧𑄇𑄴 𑄃𑄧𑄇𑄴𑄖𑄧#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
