use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Bundle::Locale::CLDR::Transformations',
    license             => 'perl',
    requires        => {
        'Locale::CLDR'              => '0.27.2'
    },
    dist_author         => q{John Imrie <john.imrie1@gmail.com>},
    dist_version        => '0.27.2',
    add_to_cleanup      => [ 'Build-Locale-CLDR-Transformations-*' ],
	configure_requires => { 'Module::Build' => '0.40' },
    create_makefile_pl => 'traditional',
	release_status => 'unstable',
	dist_abstract => 'Bundle::Locale::CLDR::Transformations - Bundle file for transformations',
	meta_add => {
		keywords => [ qw( locale CLDR ) ],
		resources => {
			homepage => 'https://github.com/ThePilgrim/perlcldr',
			bugtracker => 'https://github.com/ThePilgrim/perlcldr/issues',
			repository => 'https://github.com/ThePilgrim/perlcldr.git',
		},
	},
);

$builder->create_build_script();
