#
# (c) Jan Gehring <jan.gehring@gmail.com>
# 
# vim: set ts=3 sw=3 tw=0:
# vim: set expandtab:
   
package Rex::Virtualization::VBox::status;

use strict;
use warnings;

use Rex::Virtualization::VBox::list;

sub execute {
   my ($class, $arg1, %opt) = @_;

   my $vms = Rex::Virtualization::VBox::list->execute("all");

   my ($vm) = grep { $_->{name} eq $arg1 } @{ $vms };

   if($vm->{status} eq "poweroff") {
      return "stopped";
   }
   else {
      return "running";
   }
} 

1;
