#ifndef MATRIX_READER_H
#define MATRIX_READER_H

#include <utils/matrix.h>

class matrix_node {
    public:
        matrix *my_matrix;
        matrix_node *next;

        matrix_node();
};

class matrix_reader {
    private:
        int size;

        matrix_node *head;
        matrix_node *current_matrix_node;

    public:
        matrix_reader(char *filename);

        void   start_foreach();
        void   next_matrix();
        int    has_a_matrix();
        int    has_a_next_matrix();

        real  *query_current_matrix_as_vector();
        real **query_current_matrix_as_matrix();
        int    query_current_matrix_rows();
        int    query_current_matrix_cols();
        int    query_current_matrix_size();
        void    show_current_matrix_graphically();
        
        void start_new_matrix();
        void add_element_to_current_matrix(real v);
        void start_new_row_in_current_matrix();

        int query_size();
};

#endif
