#!/usr/bin/perl 

use strict;
use Getopt::Long;

use IMDB::Local;

my ($opt_help,
    $opt_imdbDir,
    $opt_import,
    $opt_quiet,
    $opt_download);

GetOptions('help'             => \$opt_help,
	   'imdbdir=s'        => \$opt_imdbDir,
	   'import=s'         => \$opt_import,
	   'quiet'            => \$opt_quiet,
	   'download'         => \$opt_download
    ) or usage(0);

if ( $opt_help ) {
    die "no usage implemented";
}

if ( ! defined($opt_imdbDir) ) {
    die "imdbdir flag is required";
}

$opt_quiet=(defined($opt_quiet));

# lets put list files below the imdbDir
my $listsDir="$opt_imdbDir/lists";

if ( $opt_download ) {
    use IMDB::Local::Download;
    
    if ( ! -d $listsDir ) {
	mkdir($listsDir, 0777) or die "cannot mkdir $listsDir: $!";
    }
    
    my $n=new IMDB::Local::Download('listsDir' => $listsDir,
				    'verbose' => !$opt_quiet);
    $n->download();
}

if ( defined($opt_import) ) {
    my $n=new IMDB::Local('listsDir' =>  $listsDir,
			  'imdbDir'  =>  $opt_imdbDir,
			  'verbose'  => !$opt_quiet,
			  'showProgressBar' => !$opt_quiet);
    
    if ( $opt_import eq 'all' ) {
	for my $type ( $n->listTypes() ) {
	    my $ret=$n->importList($type);
	    if ( $ret == 0 ) {
		if ( $n->{errorCountInLog} == 0 ) {
		    $n->status("list import $type succeeded with no errors");
		}
		else {
		    $n->status("list import $type succeeded with $n->{errorCountInLog} errors in $n->{imdbDir}/stage-$type.log");
		}
	    }
	    elsif ( $n->{errorCountInLog} == 0 ) {
		$n->status("list import $type failed (with no logged errors)");
	    }
	    else {
		$n->status("list import $type failed with $n->{errorCountInLog} errors in $n->{imdbDir}/stage-$type.log");
	    }
        }
    }
    else {
	my $type=$opt_import;

	my $ret=$n->importList($type);
	if ( $ret == 0 ) {
	    if ( $n->{errorCountInLog} == 0 ) {
		$n->status("list import $type succeeded with no errors");
	    }
	    else {
		$n->status("list import $type succeeded with $n->{errorCountInLog} errors in $n->{imdbDir}/stage-$type.log");
	    }
	}
	elsif ( $n->{errorCountInLog} == 0 ) {
	    $n->status("list import $type failed (with no logged errors)");
	}
	else {
	    $n->status("list import $type failed with $n->{errorCountInLog} errors in $n->{imdbDir}/stage-$type.log");
	}
    }
}

exit(0);
