# Copyright (c) 2015 Jerry Lundström <lundstrom.jerry@gmail.com>
# Copyright (c) 2015 .SE (The Internet Infrastructure Foundation)
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

package Crypt::PKCS11;

use 5.008000;
use strict;
use warnings;
use Carp;

use constant CRYPTOKI_VERSION_MAJOR => 2;
use constant CRYPTOKI_VERSION_MINOR => 30;
use constant CRYPTOKI_VERSION_AMENDMENT => 0;

# constants since cryptoki v2.20.3

use constant CK_TRUE => 1;
use constant CK_FALSE => 0;
use constant FALSE => CK_FALSE;
use constant TRUE => CK_TRUE;
use constant CK_UNAVAILABLE_INFORMATION => ~0;
use constant CK_EFFECTIVELY_INFINITE => 0;
use constant CK_INVALID_HANDLE => 0;
use constant CKN_SURRENDER => 0;
use constant CKN_OTP_CHANGED => 1;
use constant CKF_TOKEN_PRESENT => 0x00000001;
use constant CKF_REMOVABLE_DEVICE => 0x00000002;
use constant CKF_HW_SLOT => 0x00000004;
use constant CKF_RNG => 0x00000001;
use constant CKF_WRITE_PROTECTED => 0x00000002;
use constant CKF_LOGIN_REQUIRED => 0x00000004;
use constant CKF_USER_PIN_INITIALIZED => 0x00000008;
use constant CKF_RESTORE_KEY_NOT_NEEDED => 0x00000020;
use constant CKF_CLOCK_ON_TOKEN => 0x00000040;
use constant CKF_PROTECTED_AUTHENTICATION_PATH => 0x00000100;
use constant CKF_DUAL_CRYPTO_OPERATIONS => 0x00000200;
use constant CKF_TOKEN_INITIALIZED => 0x00000400;
use constant CKF_SECONDARY_AUTHENTICATION => 0x00000800;
use constant CKF_USER_PIN_COUNT_LOW => 0x00010000;
use constant CKF_USER_PIN_FINAL_TRY => 0x00020000;
use constant CKF_USER_PIN_LOCKED => 0x00040000;
use constant CKF_USER_PIN_TO_BE_CHANGED => 0x00080000;
use constant CKF_SO_PIN_COUNT_LOW => 0x00100000;
use constant CKF_SO_PIN_FINAL_TRY => 0x00200000;
use constant CKF_SO_PIN_LOCKED => 0x00400000;
use constant CKF_SO_PIN_TO_BE_CHANGED => 0x00800000;
use constant CKU_SO => 0;
use constant CKU_USER => 1;
use constant CKU_CONTEXT_SPECIFIC => 2;
use constant CKS_RO_PUBLIC_SESSION => 0;
use constant CKS_RO_USER_FUNCTIONS => 1;
use constant CKS_RW_PUBLIC_SESSION => 2;
use constant CKS_RW_USER_FUNCTIONS => 3;
use constant CKS_RW_SO_FUNCTIONS => 4;
use constant CKF_RW_SESSION => 0x00000002;
use constant CKF_SERIAL_SESSION => 0x00000004;
use constant CKO_DATA => 0x00000000;
use constant CKO_CERTIFICATE => 0x00000001;
use constant CKO_PUBLIC_KEY => 0x00000002;
use constant CKO_PRIVATE_KEY => 0x00000003;
use constant CKO_SECRET_KEY => 0x00000004;
use constant CKO_HW_FEATURE => 0x00000005;
use constant CKO_DOMAIN_PARAMETERS => 0x00000006;
use constant CKO_MECHANISM => 0x00000007;
use constant CKO_OTP_KEY => 0x00000008;
use constant CKO_VENDOR_DEFINED => 0x80000000;
use constant CKH_MONOTONIC_COUNTER => 0x00000001;
use constant CKH_CLOCK => 0x00000002;
use constant CKH_USER_INTERFACE => 0x00000003;
use constant CKH_VENDOR_DEFINED => 0x80000000;
use constant CKK_RSA => 0x00000000;
use constant CKK_DSA => 0x00000001;
use constant CKK_DH => 0x00000002;
use constant CKK_ECDSA => 0x00000003;
use constant CKK_EC => 0x00000003;
use constant CKK_X9_42_DH => 0x00000004;
use constant CKK_KEA => 0x00000005;
use constant CKK_GENERIC_SECRET => 0x00000010;
use constant CKK_RC2 => 0x00000011;
use constant CKK_RC4 => 0x00000012;
use constant CKK_DES => 0x00000013;
use constant CKK_DES2 => 0x00000014;
use constant CKK_DES3 => 0x00000015;
use constant CKK_CAST => 0x00000016;
use constant CKK_CAST3 => 0x00000017;
use constant CKK_CAST5 => 0x00000018;
use constant CKK_CAST128 => 0x00000018;
use constant CKK_RC5 => 0x00000019;
use constant CKK_IDEA => 0x0000001A;
use constant CKK_SKIPJACK => 0x0000001B;
use constant CKK_BATON => 0x0000001C;
use constant CKK_JUNIPER => 0x0000001D;
use constant CKK_CDMF => 0x0000001E;
use constant CKK_AES => 0x0000001F;
use constant CKK_BLOWFISH => 0x00000020;
use constant CKK_TWOFISH => 0x00000021;
use constant CKK_SECURID => 0x00000022;
use constant CKK_HOTP => 0x00000023;
use constant CKK_ACTI => 0x00000024;
use constant CKK_CAMELLIA => 0x00000025;
use constant CKK_ARIA => 0x00000026;
use constant CKK_VENDOR_DEFINED => 0x80000000;
use constant CKC_X_509 => 0x00000000;
use constant CKC_X_509_ATTR_CERT => 0x00000001;
use constant CKC_WTLS => 0x00000002;
use constant CKC_VENDOR_DEFINED => 0x80000000;
use constant CKF_ARRAY_ATTRIBUTE => 0x40000000;
use constant CK_OTP_FORMAT_DECIMAL => 0;
use constant CK_OTP_FORMAT_HEXADECIMAL => 1;
use constant CK_OTP_FORMAT_ALPHANUMERIC => 2;
use constant CK_OTP_FORMAT_BINARY => 3;
use constant CK_OTP_PARAM_IGNORED => 0;
use constant CK_OTP_PARAM_OPTIONAL => 1;
use constant CK_OTP_PARAM_MANDATORY => 2;
use constant CKA_CLASS => 0x00000000;
use constant CKA_TOKEN => 0x00000001;
use constant CKA_PRIVATE => 0x00000002;
use constant CKA_LABEL => 0x00000003;
use constant CKA_APPLICATION => 0x00000010;
use constant CKA_VALUE => 0x00000011;
use constant CKA_OBJECT_ID => 0x00000012;
use constant CKA_CERTIFICATE_TYPE => 0x00000080;
use constant CKA_ISSUER => 0x00000081;
use constant CKA_SERIAL_NUMBER => 0x00000082;
use constant CKA_AC_ISSUER => 0x00000083;
use constant CKA_OWNER => 0x00000084;
use constant CKA_ATTR_TYPES => 0x00000085;
use constant CKA_TRUSTED => 0x00000086;
use constant CKA_CERTIFICATE_CATEGORY => 0x00000087;
use constant CKA_JAVA_MIDP_SECURITY_DOMAIN => 0x00000088;
use constant CKA_URL => 0x00000089;
use constant CKA_HASH_OF_SUBJECT_PUBLIC_KEY => 0x0000008A;
use constant CKA_HASH_OF_ISSUER_PUBLIC_KEY => 0x0000008B;
use constant CKA_CHECK_VALUE => 0x00000090;
use constant CKA_KEY_TYPE => 0x00000100;
use constant CKA_SUBJECT => 0x00000101;
use constant CKA_ID => 0x00000102;
use constant CKA_SENSITIVE => 0x00000103;
use constant CKA_ENCRYPT => 0x00000104;
use constant CKA_DECRYPT => 0x00000105;
use constant CKA_WRAP => 0x00000106;
use constant CKA_UNWRAP => 0x00000107;
use constant CKA_SIGN => 0x00000108;
use constant CKA_SIGN_RECOVER => 0x00000109;
use constant CKA_VERIFY => 0x0000010A;
use constant CKA_VERIFY_RECOVER => 0x0000010B;
use constant CKA_DERIVE => 0x0000010C;
use constant CKA_START_DATE => 0x00000110;
use constant CKA_END_DATE => 0x00000111;
use constant CKA_MODULUS => 0x00000120;
use constant CKA_MODULUS_BITS => 0x00000121;
use constant CKA_PUBLIC_EXPONENT => 0x00000122;
use constant CKA_PRIVATE_EXPONENT => 0x00000123;
use constant CKA_PRIME_1 => 0x00000124;
use constant CKA_PRIME_2 => 0x00000125;
use constant CKA_EXPONENT_1 => 0x00000126;
use constant CKA_EXPONENT_2 => 0x00000127;
use constant CKA_COEFFICIENT => 0x00000128;
use constant CKA_PRIME => 0x00000130;
use constant CKA_SUBPRIME => 0x00000131;
use constant CKA_BASE => 0x00000132;
use constant CKA_PRIME_BITS => 0x00000133;
use constant CKA_SUBPRIME_BITS => 0x00000134;
use constant CKA_SUB_PRIME_BITS => CKA_SUBPRIME_BITS;
use constant CKA_VALUE_BITS => 0x00000160;
use constant CKA_VALUE_LEN => 0x00000161;
use constant CKA_EXTRACTABLE => 0x00000162;
use constant CKA_LOCAL => 0x00000163;
use constant CKA_NEVER_EXTRACTABLE => 0x00000164;
use constant CKA_ALWAYS_SENSITIVE => 0x00000165;
use constant CKA_KEY_GEN_MECHANISM => 0x00000166;
use constant CKA_MODIFIABLE => 0x00000170;
use constant CKA_ECDSA_PARAMS => 0x00000180;
use constant CKA_EC_PARAMS => 0x00000180;
use constant CKA_EC_POINT => 0x00000181;
use constant CKA_SECONDARY_AUTH => 0x00000200;
use constant CKA_AUTH_PIN_FLAGS => 0x00000201;
use constant CKA_ALWAYS_AUTHENTICATE => 0x00000202;
use constant CKA_WRAP_WITH_TRUSTED => 0x00000210;
use constant CKA_WRAP_TEMPLATE => (CKF_ARRAY_ATTRIBUTE|0x00000211);
use constant CKA_UNWRAP_TEMPLATE => (CKF_ARRAY_ATTRIBUTE|0x00000212);
use constant CKA_OTP_FORMAT => 0x00000220;
use constant CKA_OTP_LENGTH => 0x00000221;
use constant CKA_OTP_TIME_INTERVAL => 0x00000222;
use constant CKA_OTP_USER_FRIENDLY_MODE => 0x00000223;
use constant CKA_OTP_CHALLENGE_REQUIREMENT => 0x00000224;
use constant CKA_OTP_TIME_REQUIREMENT => 0x00000225;
use constant CKA_OTP_COUNTER_REQUIREMENT => 0x00000226;
use constant CKA_OTP_PIN_REQUIREMENT => 0x00000227;
use constant CKA_OTP_COUNTER => 0x0000022E;
use constant CKA_OTP_TIME => 0x0000022F;
use constant CKA_OTP_USER_IDENTIFIER => 0x0000022A;
use constant CKA_OTP_SERVICE_IDENTIFIER => 0x0000022B;
use constant CKA_OTP_SERVICE_LOGO => 0x0000022C;
use constant CKA_OTP_SERVICE_LOGO_TYPE => 0x0000022D;
use constant CKA_HW_FEATURE_TYPE => 0x00000300;
use constant CKA_RESET_ON_INIT => 0x00000301;
use constant CKA_HAS_RESET => 0x00000302;
use constant CKA_PIXEL_X => 0x00000400;
use constant CKA_PIXEL_Y => 0x00000401;
use constant CKA_RESOLUTION => 0x00000402;
use constant CKA_CHAR_ROWS => 0x00000403;
use constant CKA_CHAR_COLUMNS => 0x00000404;
use constant CKA_COLOR => 0x00000405;
use constant CKA_BITS_PER_PIXEL => 0x00000406;
use constant CKA_CHAR_SETS => 0x00000480;
use constant CKA_ENCODING_METHODS => 0x00000481;
use constant CKA_MIME_TYPES => 0x00000482;
use constant CKA_MECHANISM_TYPE => 0x00000500;
use constant CKA_REQUIRED_CMS_ATTRIBUTES => 0x00000501;
use constant CKA_DEFAULT_CMS_ATTRIBUTES => 0x00000502;
use constant CKA_SUPPORTED_CMS_ATTRIBUTES => 0x00000503;
use constant CKA_ALLOWED_MECHANISMS => (CKF_ARRAY_ATTRIBUTE|0x00000600);
use constant CKA_VENDOR_DEFINED => 0x80000000;
use constant CKM_RSA_PKCS_KEY_PAIR_GEN => 0x00000000;
use constant CKM_RSA_PKCS => 0x00000001;
use constant CKM_RSA_9796 => 0x00000002;
use constant CKM_RSA_X_509 => 0x00000003;
use constant CKM_MD2_RSA_PKCS => 0x00000004;
use constant CKM_MD5_RSA_PKCS => 0x00000005;
use constant CKM_SHA1_RSA_PKCS => 0x00000006;
use constant CKM_RIPEMD128_RSA_PKCS => 0x00000007;
use constant CKM_RIPEMD160_RSA_PKCS => 0x00000008;
use constant CKM_RSA_PKCS_OAEP => 0x00000009;
use constant CKM_RSA_X9_31_KEY_PAIR_GEN => 0x0000000A;
use constant CKM_RSA_X9_31 => 0x0000000B;
use constant CKM_SHA1_RSA_X9_31 => 0x0000000C;
use constant CKM_RSA_PKCS_PSS => 0x0000000D;
use constant CKM_SHA1_RSA_PKCS_PSS => 0x0000000E;
use constant CKM_DSA_KEY_PAIR_GEN => 0x00000010;
use constant CKM_DSA => 0x00000011;
use constant CKM_DSA_SHA1 => 0x00000012;
use constant CKM_DH_PKCS_KEY_PAIR_GEN => 0x00000020;
use constant CKM_DH_PKCS_DERIVE => 0x00000021;
use constant CKM_X9_42_DH_KEY_PAIR_GEN => 0x00000030;
use constant CKM_X9_42_DH_DERIVE => 0x00000031;
use constant CKM_X9_42_DH_HYBRID_DERIVE => 0x00000032;
use constant CKM_X9_42_MQV_DERIVE => 0x00000033;
use constant CKM_SHA256_RSA_PKCS => 0x00000040;
use constant CKM_SHA384_RSA_PKCS => 0x00000041;
use constant CKM_SHA512_RSA_PKCS => 0x00000042;
use constant CKM_SHA256_RSA_PKCS_PSS => 0x00000043;
use constant CKM_SHA384_RSA_PKCS_PSS => 0x00000044;
use constant CKM_SHA512_RSA_PKCS_PSS => 0x00000045;
use constant CKM_SHA224_RSA_PKCS => 0x00000046;
use constant CKM_SHA224_RSA_PKCS_PSS => 0x00000047;
use constant CKM_RC2_KEY_GEN => 0x00000100;
use constant CKM_RC2_ECB => 0x00000101;
use constant CKM_RC2_CBC => 0x00000102;
use constant CKM_RC2_MAC => 0x00000103;
use constant CKM_RC2_MAC_GENERAL => 0x00000104;
use constant CKM_RC2_CBC_PAD => 0x00000105;
use constant CKM_RC4_KEY_GEN => 0x00000110;
use constant CKM_RC4 => 0x00000111;
use constant CKM_DES_KEY_GEN => 0x00000120;
use constant CKM_DES_ECB => 0x00000121;
use constant CKM_DES_CBC => 0x00000122;
use constant CKM_DES_MAC => 0x00000123;
use constant CKM_DES_MAC_GENERAL => 0x00000124;
use constant CKM_DES_CBC_PAD => 0x00000125;
use constant CKM_DES2_KEY_GEN => 0x00000130;
use constant CKM_DES3_KEY_GEN => 0x00000131;
use constant CKM_DES3_ECB => 0x00000132;
use constant CKM_DES3_CBC => 0x00000133;
use constant CKM_DES3_MAC => 0x00000134;
use constant CKM_DES3_MAC_GENERAL => 0x00000135;
use constant CKM_DES3_CBC_PAD => 0x00000136;
use constant CKM_CDMF_KEY_GEN => 0x00000140;
use constant CKM_CDMF_ECB => 0x00000141;
use constant CKM_CDMF_CBC => 0x00000142;
use constant CKM_CDMF_MAC => 0x00000143;
use constant CKM_CDMF_MAC_GENERAL => 0x00000144;
use constant CKM_CDMF_CBC_PAD => 0x00000145;
use constant CKM_DES_OFB64 => 0x00000150;
use constant CKM_DES_OFB8 => 0x00000151;
use constant CKM_DES_CFB64 => 0x00000152;
use constant CKM_DES_CFB8 => 0x00000153;
use constant CKM_MD2 => 0x00000200;
use constant CKM_MD2_HMAC => 0x00000201;
use constant CKM_MD2_HMAC_GENERAL => 0x00000202;
use constant CKM_MD5 => 0x00000210;
use constant CKM_MD5_HMAC => 0x00000211;
use constant CKM_MD5_HMAC_GENERAL => 0x00000212;
use constant CKM_SHA_1 => 0x00000220;
use constant CKM_SHA_1_HMAC => 0x00000221;
use constant CKM_SHA_1_HMAC_GENERAL => 0x00000222;
use constant CKM_RIPEMD128 => 0x00000230;
use constant CKM_RIPEMD128_HMAC => 0x00000231;
use constant CKM_RIPEMD128_HMAC_GENERAL => 0x00000232;
use constant CKM_RIPEMD160 => 0x00000240;
use constant CKM_RIPEMD160_HMAC => 0x00000241;
use constant CKM_RIPEMD160_HMAC_GENERAL => 0x00000242;
use constant CKM_SHA256 => 0x00000250;
use constant CKM_SHA256_HMAC => 0x00000251;
use constant CKM_SHA256_HMAC_GENERAL => 0x00000252;
use constant CKM_SHA224 => 0x00000255;
use constant CKM_SHA224_HMAC => 0x00000256;
use constant CKM_SHA224_HMAC_GENERAL => 0x00000257;
use constant CKM_SHA384 => 0x00000260;
use constant CKM_SHA384_HMAC => 0x00000261;
use constant CKM_SHA384_HMAC_GENERAL => 0x00000262;
use constant CKM_SHA512 => 0x00000270;
use constant CKM_SHA512_HMAC => 0x00000271;
use constant CKM_SHA512_HMAC_GENERAL => 0x00000272;
use constant CKM_SECURID_KEY_GEN => 0x00000280;
use constant CKM_SECURID => 0x00000282;
use constant CKM_HOTP_KEY_GEN => 0x00000290;
use constant CKM_HOTP => 0x00000291;
use constant CKM_ACTI => 0x000002A0;
use constant CKM_ACTI_KEY_GEN => 0x000002A1;
use constant CKM_CAST_KEY_GEN => 0x00000300;
use constant CKM_CAST_ECB => 0x00000301;
use constant CKM_CAST_CBC => 0x00000302;
use constant CKM_CAST_MAC => 0x00000303;
use constant CKM_CAST_MAC_GENERAL => 0x00000304;
use constant CKM_CAST_CBC_PAD => 0x00000305;
use constant CKM_CAST3_KEY_GEN => 0x00000310;
use constant CKM_CAST3_ECB => 0x00000311;
use constant CKM_CAST3_CBC => 0x00000312;
use constant CKM_CAST3_MAC => 0x00000313;
use constant CKM_CAST3_MAC_GENERAL => 0x00000314;
use constant CKM_CAST3_CBC_PAD => 0x00000315;
use constant CKM_CAST5_KEY_GEN => 0x00000320;
use constant CKM_CAST128_KEY_GEN => 0x00000320;
use constant CKM_CAST5_ECB => 0x00000321;
use constant CKM_CAST128_ECB => 0x00000321;
use constant CKM_CAST5_CBC => 0x00000322;
use constant CKM_CAST128_CBC => 0x00000322;
use constant CKM_CAST5_MAC => 0x00000323;
use constant CKM_CAST128_MAC => 0x00000323;
use constant CKM_CAST5_MAC_GENERAL => 0x00000324;
use constant CKM_CAST128_MAC_GENERAL => 0x00000324;
use constant CKM_CAST5_CBC_PAD => 0x00000325;
use constant CKM_CAST128_CBC_PAD => 0x00000325;
use constant CKM_RC5_KEY_GEN => 0x00000330;
use constant CKM_RC5_ECB => 0x00000331;
use constant CKM_RC5_CBC => 0x00000332;
use constant CKM_RC5_MAC => 0x00000333;
use constant CKM_RC5_MAC_GENERAL => 0x00000334;
use constant CKM_RC5_CBC_PAD => 0x00000335;
use constant CKM_IDEA_KEY_GEN => 0x00000340;
use constant CKM_IDEA_ECB => 0x00000341;
use constant CKM_IDEA_CBC => 0x00000342;
use constant CKM_IDEA_MAC => 0x00000343;
use constant CKM_IDEA_MAC_GENERAL => 0x00000344;
use constant CKM_IDEA_CBC_PAD => 0x00000345;
use constant CKM_GENERIC_SECRET_KEY_GEN => 0x00000350;
use constant CKM_CONCATENATE_BASE_AND_KEY => 0x00000360;
use constant CKM_CONCATENATE_BASE_AND_DATA => 0x00000362;
use constant CKM_CONCATENATE_DATA_AND_BASE => 0x00000363;
use constant CKM_XOR_BASE_AND_DATA => 0x00000364;
use constant CKM_EXTRACT_KEY_FROM_KEY => 0x00000365;
use constant CKM_SSL3_PRE_MASTER_KEY_GEN => 0x00000370;
use constant CKM_SSL3_MASTER_KEY_DERIVE => 0x00000371;
use constant CKM_SSL3_KEY_AND_MAC_DERIVE => 0x00000372;
use constant CKM_SSL3_MASTER_KEY_DERIVE_DH => 0x00000373;
use constant CKM_TLS_PRE_MASTER_KEY_GEN => 0x00000374;
use constant CKM_TLS_MASTER_KEY_DERIVE => 0x00000375;
use constant CKM_TLS_KEY_AND_MAC_DERIVE => 0x00000376;
use constant CKM_TLS_MASTER_KEY_DERIVE_DH => 0x00000377;
use constant CKM_TLS_PRF => 0x00000378;
use constant CKM_SSL3_MD5_MAC => 0x00000380;
use constant CKM_SSL3_SHA1_MAC => 0x00000381;
use constant CKM_MD5_KEY_DERIVATION => 0x00000390;
use constant CKM_MD2_KEY_DERIVATION => 0x00000391;
use constant CKM_SHA1_KEY_DERIVATION => 0x00000392;
use constant CKM_SHA256_KEY_DERIVATION => 0x00000393;
use constant CKM_SHA384_KEY_DERIVATION => 0x00000394;
use constant CKM_SHA512_KEY_DERIVATION => 0x00000395;
use constant CKM_SHA224_KEY_DERIVATION => 0x00000396;
use constant CKM_PBE_MD2_DES_CBC => 0x000003A0;
use constant CKM_PBE_MD5_DES_CBC => 0x000003A1;
use constant CKM_PBE_MD5_CAST_CBC => 0x000003A2;
use constant CKM_PBE_MD5_CAST3_CBC => 0x000003A3;
use constant CKM_PBE_MD5_CAST5_CBC => 0x000003A4;
use constant CKM_PBE_MD5_CAST128_CBC => 0x000003A4;
use constant CKM_PBE_SHA1_CAST5_CBC => 0x000003A5;
use constant CKM_PBE_SHA1_CAST128_CBC => 0x000003A5;
use constant CKM_PBE_SHA1_RC4_128 => 0x000003A6;
use constant CKM_PBE_SHA1_RC4_40 => 0x000003A7;
use constant CKM_PBE_SHA1_DES3_EDE_CBC => 0x000003A8;
use constant CKM_PBE_SHA1_DES2_EDE_CBC => 0x000003A9;
use constant CKM_PBE_SHA1_RC2_128_CBC => 0x000003AA;
use constant CKM_PBE_SHA1_RC2_40_CBC => 0x000003AB;
use constant CKM_PKCS5_PBKD2 => 0x000003B0;
use constant CKM_PBA_SHA1_WITH_SHA1_HMAC => 0x000003C0;
use constant CKM_WTLS_PRE_MASTER_KEY_GEN => 0x000003D0;
use constant CKM_WTLS_MASTER_KEY_DERIVE => 0x000003D1;
use constant CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC => 0x000003D2;
use constant CKM_WTLS_PRF => 0x000003D3;
use constant CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE => 0x000003D4;
use constant CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE => 0x000003D5;
use constant CKM_KEY_WRAP_LYNKS => 0x00000400;
use constant CKM_KEY_WRAP_SET_OAEP => 0x00000401;
use constant CKM_CMS_SIG => 0x00000500;
use constant CKM_KIP_DERIVE => 0x00000510;
use constant CKM_KIP_WRAP => 0x00000511;
use constant CKM_KIP_MAC => 0x00000512;
use constant CKM_CAMELLIA_KEY_GEN => 0x00000550;
use constant CKM_CAMELLIA_ECB => 0x00000551;
use constant CKM_CAMELLIA_CBC => 0x00000552;
use constant CKM_CAMELLIA_MAC => 0x00000553;
use constant CKM_CAMELLIA_MAC_GENERAL => 0x00000554;
use constant CKM_CAMELLIA_CBC_PAD => 0x00000555;
use constant CKM_CAMELLIA_ECB_ENCRYPT_DATA => 0x00000556;
use constant CKM_CAMELLIA_CBC_ENCRYPT_DATA => 0x00000557;
use constant CKM_CAMELLIA_CTR => 0x00000558;
use constant CKM_ARIA_KEY_GEN => 0x00000560;
use constant CKM_ARIA_ECB => 0x00000561;
use constant CKM_ARIA_CBC => 0x00000562;
use constant CKM_ARIA_MAC => 0x00000563;
use constant CKM_ARIA_MAC_GENERAL => 0x00000564;
use constant CKM_ARIA_CBC_PAD => 0x00000565;
use constant CKM_ARIA_ECB_ENCRYPT_DATA => 0x00000566;
use constant CKM_ARIA_CBC_ENCRYPT_DATA => 0x00000567;
use constant CKM_SKIPJACK_KEY_GEN => 0x00001000;
use constant CKM_SKIPJACK_ECB64 => 0x00001001;
use constant CKM_SKIPJACK_CBC64 => 0x00001002;
use constant CKM_SKIPJACK_OFB64 => 0x00001003;
use constant CKM_SKIPJACK_CFB64 => 0x00001004;
use constant CKM_SKIPJACK_CFB32 => 0x00001005;
use constant CKM_SKIPJACK_CFB16 => 0x00001006;
use constant CKM_SKIPJACK_CFB8 => 0x00001007;
use constant CKM_SKIPJACK_WRAP => 0x00001008;
use constant CKM_SKIPJACK_PRIVATE_WRAP => 0x00001009;
use constant CKM_SKIPJACK_RELAYX => 0x0000100a;
use constant CKM_KEA_KEY_PAIR_GEN => 0x00001010;
use constant CKM_KEA_KEY_DERIVE => 0x00001011;
use constant CKM_FORTEZZA_TIMESTAMP => 0x00001020;
use constant CKM_BATON_KEY_GEN => 0x00001030;
use constant CKM_BATON_ECB128 => 0x00001031;
use constant CKM_BATON_ECB96 => 0x00001032;
use constant CKM_BATON_CBC128 => 0x00001033;
use constant CKM_BATON_COUNTER => 0x00001034;
use constant CKM_BATON_SHUFFLE => 0x00001035;
use constant CKM_BATON_WRAP => 0x00001036;
use constant CKM_ECDSA_KEY_PAIR_GEN => 0x00001040;
use constant CKM_EC_KEY_PAIR_GEN => 0x00001040;
use constant CKM_ECDSA => 0x00001041;
use constant CKM_ECDSA_SHA1 => 0x00001042;
use constant CKM_ECDH1_DERIVE => 0x00001050;
use constant CKM_ECDH1_COFACTOR_DERIVE => 0x00001051;
use constant CKM_ECMQV_DERIVE => 0x00001052;
use constant CKM_JUNIPER_KEY_GEN => 0x00001060;
use constant CKM_JUNIPER_ECB128 => 0x00001061;
use constant CKM_JUNIPER_CBC128 => 0x00001062;
use constant CKM_JUNIPER_COUNTER => 0x00001063;
use constant CKM_JUNIPER_SHUFFLE => 0x00001064;
use constant CKM_JUNIPER_WRAP => 0x00001065;
use constant CKM_FASTHASH => 0x00001070;
use constant CKM_AES_KEY_GEN => 0x00001080;
use constant CKM_AES_ECB => 0x00001081;
use constant CKM_AES_CBC => 0x00001082;
use constant CKM_AES_MAC => 0x00001083;
use constant CKM_AES_MAC_GENERAL => 0x00001084;
use constant CKM_AES_CBC_PAD => 0x00001085;
use constant CKM_AES_CTR => 0x00001086;
use constant CKM_BLOWFISH_KEY_GEN => 0x00001090;
use constant CKM_BLOWFISH_CBC => 0x00001091;
use constant CKM_TWOFISH_KEY_GEN => 0x00001092;
use constant CKM_TWOFISH_CBC => 0x00001093;
use constant CKM_DES_ECB_ENCRYPT_DATA => 0x00001100;
use constant CKM_DES_CBC_ENCRYPT_DATA => 0x00001101;
use constant CKM_DES3_ECB_ENCRYPT_DATA => 0x00001102;
use constant CKM_DES3_CBC_ENCRYPT_DATA => 0x00001103;
use constant CKM_AES_ECB_ENCRYPT_DATA => 0x00001104;
use constant CKM_AES_CBC_ENCRYPT_DATA => 0x00001105;
use constant CKM_DSA_PARAMETER_GEN => 0x00002000;
use constant CKM_DH_PKCS_PARAMETER_GEN => 0x00002001;
use constant CKM_X9_42_DH_PARAMETER_GEN => 0x00002002;
use constant CKM_VENDOR_DEFINED => 0x80000000;
use constant CKF_HW => 0x00000001;
use constant CKF_ENCRYPT => 0x00000100;
use constant CKF_DECRYPT => 0x00000200;
use constant CKF_DIGEST => 0x00000400;
use constant CKF_SIGN => 0x00000800;
use constant CKF_SIGN_RECOVER => 0x00001000;
use constant CKF_VERIFY => 0x00002000;
use constant CKF_VERIFY_RECOVER => 0x00004000;
use constant CKF_GENERATE => 0x00008000;
use constant CKF_GENERATE_KEY_PAIR => 0x00010000;
use constant CKF_WRAP => 0x00020000;
use constant CKF_UNWRAP => 0x00040000;
use constant CKF_DERIVE => 0x00080000;
use constant CKF_EC_F_P => 0x00100000;
use constant CKF_EC_F_2M => 0x00200000;
use constant CKF_EC_ECPARAMETERS => 0x00400000;
use constant CKF_EC_NAMEDCURVE => 0x00800000;
use constant CKF_EC_UNCOMPRESS => 0x01000000;
use constant CKF_EC_COMPRESS => 0x02000000;
use constant CKF_EXTENSION => 0x80000000;
use constant CKR_OK => 0x00000000;
use constant CKR_CANCEL => 0x00000001;
use constant CKR_HOST_MEMORY => 0x00000002;
use constant CKR_SLOT_ID_INVALID => 0x00000003;
use constant CKR_GENERAL_ERROR => 0x00000005;
use constant CKR_FUNCTION_FAILED => 0x00000006;
use constant CKR_ARGUMENTS_BAD => 0x00000007;
use constant CKR_NO_EVENT => 0x00000008;
use constant CKR_NEED_TO_CREATE_THREADS => 0x00000009;
use constant CKR_CANT_LOCK => 0x0000000A;
use constant CKR_ATTRIBUTE_READ_ONLY => 0x00000010;
use constant CKR_ATTRIBUTE_SENSITIVE => 0x00000011;
use constant CKR_ATTRIBUTE_TYPE_INVALID => 0x00000012;
use constant CKR_ATTRIBUTE_VALUE_INVALID => 0x00000013;
use constant CKR_DATA_INVALID => 0x00000020;
use constant CKR_DATA_LEN_RANGE => 0x00000021;
use constant CKR_DEVICE_ERROR => 0x00000030;
use constant CKR_DEVICE_MEMORY => 0x00000031;
use constant CKR_DEVICE_REMOVED => 0x00000032;
use constant CKR_ENCRYPTED_DATA_INVALID => 0x00000040;
use constant CKR_ENCRYPTED_DATA_LEN_RANGE => 0x00000041;
use constant CKR_FUNCTION_CANCELED => 0x00000050;
use constant CKR_FUNCTION_NOT_PARALLEL => 0x00000051;
use constant CKR_FUNCTION_NOT_SUPPORTED => 0x00000054;
use constant CKR_KEY_HANDLE_INVALID => 0x00000060;
use constant CKR_KEY_SIZE_RANGE => 0x00000062;
use constant CKR_KEY_TYPE_INCONSISTENT => 0x00000063;
use constant CKR_KEY_NOT_NEEDED => 0x00000064;
use constant CKR_KEY_CHANGED => 0x00000065;
use constant CKR_KEY_NEEDED => 0x00000066;
use constant CKR_KEY_INDIGESTIBLE => 0x00000067;
use constant CKR_KEY_FUNCTION_NOT_PERMITTED => 0x00000068;
use constant CKR_KEY_NOT_WRAPPABLE => 0x00000069;
use constant CKR_KEY_UNEXTRACTABLE => 0x0000006A;
use constant CKR_MECHANISM_INVALID => 0x00000070;
use constant CKR_MECHANISM_PARAM_INVALID => 0x00000071;
use constant CKR_OBJECT_HANDLE_INVALID => 0x00000082;
use constant CKR_OPERATION_ACTIVE => 0x00000090;
use constant CKR_OPERATION_NOT_INITIALIZED => 0x00000091;
use constant CKR_PIN_INCORRECT => 0x000000A0;
use constant CKR_PIN_INVALID => 0x000000A1;
use constant CKR_PIN_LEN_RANGE => 0x000000A2;
use constant CKR_PIN_EXPIRED => 0x000000A3;
use constant CKR_PIN_LOCKED => 0x000000A4;
use constant CKR_SESSION_CLOSED => 0x000000B0;
use constant CKR_SESSION_COUNT => 0x000000B1;
use constant CKR_SESSION_HANDLE_INVALID => 0x000000B3;
use constant CKR_SESSION_PARALLEL_NOT_SUPPORTED => 0x000000B4;
use constant CKR_SESSION_READ_ONLY => 0x000000B5;
use constant CKR_SESSION_EXISTS => 0x000000B6;
use constant CKR_SESSION_READ_ONLY_EXISTS => 0x000000B7;
use constant CKR_SESSION_READ_WRITE_SO_EXISTS => 0x000000B8;
use constant CKR_SIGNATURE_INVALID => 0x000000C0;
use constant CKR_SIGNATURE_LEN_RANGE => 0x000000C1;
use constant CKR_TEMPLATE_INCOMPLETE => 0x000000D0;
use constant CKR_TEMPLATE_INCONSISTENT => 0x000000D1;
use constant CKR_TOKEN_NOT_PRESENT => 0x000000E0;
use constant CKR_TOKEN_NOT_RECOGNIZED => 0x000000E1;
use constant CKR_TOKEN_WRITE_PROTECTED => 0x000000E2;
use constant CKR_UNWRAPPING_KEY_HANDLE_INVALID => 0x000000F0;
use constant CKR_UNWRAPPING_KEY_SIZE_RANGE => 0x000000F1;
use constant CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT => 0x000000F2;
use constant CKR_USER_ALREADY_LOGGED_IN => 0x00000100;
use constant CKR_USER_NOT_LOGGED_IN => 0x00000101;
use constant CKR_USER_PIN_NOT_INITIALIZED => 0x00000102;
use constant CKR_USER_TYPE_INVALID => 0x00000103;
use constant CKR_USER_ANOTHER_ALREADY_LOGGED_IN => 0x00000104;
use constant CKR_USER_TOO_MANY_TYPES => 0x00000105;
use constant CKR_WRAPPED_KEY_INVALID => 0x00000110;
use constant CKR_WRAPPED_KEY_LEN_RANGE => 0x00000112;
use constant CKR_WRAPPING_KEY_HANDLE_INVALID => 0x00000113;
use constant CKR_WRAPPING_KEY_SIZE_RANGE => 0x00000114;
use constant CKR_WRAPPING_KEY_TYPE_INCONSISTENT => 0x00000115;
use constant CKR_RANDOM_SEED_NOT_SUPPORTED => 0x00000120;
use constant CKR_RANDOM_NO_RNG => 0x00000121;
use constant CKR_DOMAIN_PARAMS_INVALID => 0x00000130;
use constant CKR_BUFFER_TOO_SMALL => 0x00000150;
use constant CKR_SAVED_STATE_INVALID => 0x00000160;
use constant CKR_INFORMATION_SENSITIVE => 0x00000170;
use constant CKR_STATE_UNSAVEABLE => 0x00000180;
use constant CKR_CRYPTOKI_NOT_INITIALIZED => 0x00000190;
use constant CKR_CRYPTOKI_ALREADY_INITIALIZED => 0x00000191;
use constant CKR_MUTEX_BAD => 0x000001A0;
use constant CKR_MUTEX_NOT_LOCKED => 0x000001A1;
use constant CKR_NEW_PIN_MODE => 0x000001B0;
use constant CKR_NEXT_OTP => 0x000001B1;
use constant CKR_FUNCTION_REJECTED => 0x00000200;
use constant CKR_VENDOR_DEFINED => 0x80000000;
use constant CKF_LIBRARY_CANT_CREATE_OS_THREADS => 0x00000001;
use constant CKF_OS_LOCKING_OK => 0x00000002;
use constant CKF_DONT_BLOCK => 1;
use constant CKG_MGF1_SHA1 => 0x00000001;
use constant CKG_MGF1_SHA256 => 0x00000002;
use constant CKG_MGF1_SHA384 => 0x00000003;
use constant CKG_MGF1_SHA512 => 0x00000004;
use constant CKG_MGF1_SHA224 => 0x00000005;
use constant CKZ_DATA_SPECIFIED => 0x00000001;
use constant CKD_NULL => 0x00000001;
use constant CKD_SHA1_KDF => 0x00000002;
use constant CKD_SHA1_KDF_ASN1 => 0x00000003;
use constant CKD_SHA1_KDF_CONCATENATE => 0x00000004;
use constant CKP_PKCS5_PBKD2_HMAC_SHA1 => 0x00000001;
use constant CKZ_SALT_SPECIFIED => 0x00000001;
use constant CK_OTP_VALUE => 0;
use constant CK_OTP_PIN => 1;
use constant CK_OTP_CHALLENGE => 2;
use constant CK_OTP_TIME => 3;
use constant CK_OTP_COUNTER => 4;
use constant CK_OTP_FLAGS => 5;
use constant CK_OTP_OUTPUT_LENGTH => 6;
use constant CK_OTP_OUTPUT_FORMAT => 7;
use constant CKF_NEXT_OTP => 0x00000001;
use constant CKF_EXCLUDE_TIME => 0x00000002;
use constant CKF_EXCLUDE_COUNTER => 0x00000004;
use constant CKF_EXCLUDE_CHALLENGE => 0x00000008;
use constant CKF_EXCLUDE_PIN => 0x00000010;
use constant CKF_USER_FRIENDLY_OTP => 0x00000020;

# constants since cryptoki v2.30.0

use constant CKF_ERROR_STATE => 0x01000000;
use constant CKK_MD5_HMAC => 0x00000027;
use constant CKK_SHA_1_HMAC => 0x00000028;
use constant CKK_RIPEMD128_HMAC => 0x00000029;
use constant CKK_RIPEMD160_HMAC => 0x0000002A;
use constant CKK_SHA256_HMAC => 0x0000002B;
use constant CKK_SHA384_HMAC => 0x0000002C;
use constant CKK_SHA512_HMAC => 0x0000002D;
use constant CKK_SHA224_HMAC => 0x0000002E;
use constant CKK_SEED => 0x0000002F;
use constant CKK_GOSTR3410 => 0x00000030;
use constant CKK_GOSTR3411 => 0x00000031;
use constant CKK_GOST28147 => 0x00000032;
use constant CKA_DERIVE_TEMPLATE => (CKF_ARRAY_ATTRIBUTE|0x00000213);
use constant CKA_GOSTR3410_PARAMS => 0x00000250;
use constant CKA_GOSTR3411_PARAMS => 0x00000251;
use constant CKA_GOST28147_PARAMS => 0x00000252;
use constant CKM_DSA_SHA224 => 0x00000013;
use constant CKM_DSA_SHA256 => 0x00000014;
use constant CKM_DSA_SHA384 => 0x00000015;
use constant CKM_DSA_SHA512 => 0x00000016;
use constant CKM_DES3_CMAC_GENERAL => 0x00000137;
use constant CKM_DES3_CMAC => 0x00000138;
use constant CKM_SEED_KEY_GEN => 0x00000650;
use constant CKM_SEED_ECB => 0x00000651;
use constant CKM_SEED_CBC => 0x00000652;
use constant CKM_SEED_MAC => 0x00000653;
use constant CKM_SEED_MAC_GENERAL => 0x00000654;
use constant CKM_SEED_CBC_PAD => 0x00000655;
use constant CKM_SEED_ECB_ENCRYPT_DATA => 0x00000656;
use constant CKM_SEED_CBC_ENCRYPT_DATA => 0x00000657;
use constant CKM_ECDSA_SHA224 => 0x00001043;
use constant CKM_ECDSA_SHA256 => 0x00001044;
use constant CKM_ECDSA_SHA384 => 0x00001045;
use constant CKM_ECDSA_SHA512 => 0x00001046;
use constant CKM_AES_CTS => 0x00001089;
use constant CKM_AES_CMAC => 0x0000108A;
use constant CKM_AES_CMAC_GENERAL => 0x0000108B;
use constant CKM_AES_GCM => 0x00001087;
use constant CKM_AES_CCM => 0x00001088;
use constant CKM_AES_KEY_WRAP => 0x00001090;
use constant CKM_AES_KEY_WRAP_PAD => 0x00001091;
use constant CKM_BLOWFISH_CBC_PAD => 0x00001094;
use constant CKM_TWOFISH_CBC_PAD => 0x00001095;
use constant CKM_GOSTR3410_KEY_PAIR_GEN => 0x00001200;
use constant CKM_GOSTR3410 => 0x00001201;
use constant CKM_GOSTR3410_WITH_GOSTR3411 => 0x00001202;
use constant CKM_GOSTR3410_KEY_WRAP => 0x00001203;
use constant CKM_GOSTR3410_DERIVE => 0x00001204;
use constant CKM_GOSTR3411 => 0x00001210;
use constant CKM_GOSTR3411_HMAC => 0x00001211;
use constant CKM_GOST28147_KEY_GEN => 0x00001220;
use constant CKM_GOST28147_ECB => 0x00001221;
use constant CKM_GOST28147 => 0x00001222;
use constant CKM_GOST28147_MAC => 0x00001223;
use constant CKM_GOST28147_KEY_WRAP => 0x00001224;
use constant CKM_AES_OFB => 0x00002104;
use constant CKM_AES_CFB64 => 0x00002105;
use constant CKM_AES_CFB8 => 0x00002106;
use constant CKM_AES_CFB128 => 0x00002107;
use constant CKM_RSA_PKCS_TPM_1_1 => 0x00004001;
use constant CKM_RSA_PKCS_OAEP_TPM_1_1 => 0x00004002;
use constant CKR_EXCEEDED_MAX_ITERATIONS => 0x000001B5;
use constant CKR_FIPS_SELF_TEST_FAILED => 0x000001B6;
use constant CKR_LIBRARY_LOAD_FAILED => 0x000001B7;
use constant CKR_PIN_TOO_WEAK => 0x000001B8;
use constant CKR_PUBLIC_KEY_INVALID => 0x000001B9;
use constant CKD_SHA224_KDF => 0x00000005;
use constant CKD_SHA256_KDF => 0x00000006;
use constant CKD_SHA384_KDF => 0x00000007;
use constant CKD_SHA512_KDF => 0x00000008;
use constant CKD_CPDIVERSIFY_KDF => 0x00000009;

# constants missing from .h files but defined in v2.30 documentation

use constant CKA_NAME_HASH_ALGORITHM => 0x0000008C;
use constant CKA_COPYABLE => 0x00000171;

# Constant to name hashes

our %CKA_NAME = (
    CKA_AC_ISSUER() => 'CKA_AC_ISSUER',
    CKA_ALLOWED_MECHANISMS() => 'CKA_ALLOWED_MECHANISMS',
    CKA_ALWAYS_AUTHENTICATE() => 'CKA_ALWAYS_AUTHENTICATE',
    CKA_ALWAYS_SENSITIVE() => 'CKA_ALWAYS_SENSITIVE',
    CKA_APPLICATION() => 'CKA_APPLICATION',
    CKA_ATTR_TYPES() => 'CKA_ATTR_TYPES',
    CKA_AUTH_PIN_FLAGS() => 'CKA_AUTH_PIN_FLAGS',
    CKA_BASE() => 'CKA_BASE',
    CKA_BITS_PER_PIXEL() => 'CKA_BITS_PER_PIXEL',
    CKA_CERTIFICATE_CATEGORY() => 'CKA_CERTIFICATE_CATEGORY',
    CKA_CERTIFICATE_TYPE() => 'CKA_CERTIFICATE_TYPE',
    CKA_CHAR_COLUMNS() => 'CKA_CHAR_COLUMNS',
    CKA_CHAR_ROWS() => 'CKA_CHAR_ROWS',
    CKA_CHAR_SETS() => 'CKA_CHAR_SETS',
    CKA_CLASS() => 'CKA_CLASS',
    CKA_COEFFICIENT() => 'CKA_COEFFICIENT',
    CKA_COLOR() => 'CKA_COLOR',
    CKA_COPYABLE() => 'CKA_COPYABLE',
    CKA_DECRYPT() => 'CKA_DECRYPT',
    CKA_DEFAULT_CMS_ATTRIBUTES() => 'CKA_DEFAULT_CMS_ATTRIBUTES',
    CKA_DERIVE() => 'CKA_DERIVE',
    CKA_DERIVE_TEMPLATE() => 'CKA_DERIVE_TEMPLATE',
    CKA_ECDSA_PARAMS() => 'CKA_ECDSA_PARAMS',
    CKA_EC_PARAMS() => 'CKA_EC_PARAMS',
    CKA_EC_POINT() => 'CKA_EC_POINT',
    CKA_ENCODING_METHODS() => 'CKA_ENCODING_METHODS',
    CKA_ENCRYPT() => 'CKA_ENCRYPT',
    CKA_END_DATE() => 'CKA_END_DATE',
    CKA_EXPONENT_1() => 'CKA_EXPONENT_1',
    CKA_EXPONENT_2() => 'CKA_EXPONENT_2',
    CKA_EXTRACTABLE() => 'CKA_EXTRACTABLE',
    CKA_GOST28147_PARAMS() => 'CKA_GOST28147_PARAMS',
    CKA_GOSTR3410_PARAMS() => 'CKA_GOSTR3410_PARAMS',
    CKA_GOSTR3411_PARAMS() => 'CKA_GOSTR3411_PARAMS',
    CKA_HASH_OF_ISSUER_PUBLIC_KEY() => 'CKA_HASH_OF_ISSUER_PUBLIC_KEY',
    CKA_HASH_OF_SUBJECT_PUBLIC_KEY() => 'CKA_HASH_OF_SUBJECT_PUBLIC_KEY',
    CKA_HAS_RESET() => 'CKA_HAS_RESET',
    CKA_HW_FEATURE_TYPE() => 'CKA_HW_FEATURE_TYPE',
    CKA_ID() => 'CKA_ID',
    CKA_ISSUER() => 'CKA_ISSUER',
    CKA_JAVA_MIDP_SECURITY_DOMAIN() => 'CKA_JAVA_MIDP_SECURITY_DOMAIN',
    CKA_KEY_GEN_MECHANISM() => 'CKA_KEY_GEN_MECHANISM',
    CKA_KEY_TYPE() => 'CKA_KEY_TYPE',
    CKA_LABEL() => 'CKA_LABEL',
    CKA_LOCAL() => 'CKA_LOCAL',
    CKA_MECHANISM_TYPE() => 'CKA_MECHANISM_TYPE',
    CKA_MIME_TYPES() => 'CKA_MIME_TYPES',
    CKA_MODIFIABLE() => 'CKA_MODIFIABLE',
    CKA_MODULUS() => 'CKA_MODULUS',
    CKA_MODULUS_BITS() => 'CKA_MODULUS_BITS',
    CKA_NAME_HASH_ALGORITHM() => 'CKA_NAME_HASH_ALGORITHM',
    CKA_NEVER_EXTRACTABLE() => 'CKA_NEVER_EXTRACTABLE',
    CKA_OBJECT_ID() => 'CKA_OBJECT_ID',
    CKA_OTP_CHALLENGE_REQUIREMENT() => 'CKA_OTP_CHALLENGE_REQUIREMENT',
    CKA_OTP_COUNTER() => 'CKA_OTP_COUNTER',
    CKA_OTP_COUNTER_REQUIREMENT() => 'CKA_OTP_COUNTER_REQUIREMENT',
    CKA_OTP_FORMAT() => 'CKA_OTP_FORMAT',
    CKA_OTP_LENGTH() => 'CKA_OTP_LENGTH',
    CKA_OTP_PIN_REQUIREMENT() => 'CKA_OTP_PIN_REQUIREMENT',
    CKA_OTP_SERVICE_IDENTIFIER() => 'CKA_OTP_SERVICE_IDENTIFIER',
    CKA_OTP_SERVICE_LOGO() => 'CKA_OTP_SERVICE_LOGO',
    CKA_OTP_SERVICE_LOGO_TYPE() => 'CKA_OTP_SERVICE_LOGO_TYPE',
    CKA_OTP_TIME() => 'CKA_OTP_TIME',
    CKA_OTP_TIME_INTERVAL() => 'CKA_OTP_TIME_INTERVAL',
    CKA_OTP_TIME_REQUIREMENT() => 'CKA_OTP_TIME_REQUIREMENT',
    CKA_OTP_USER_FRIENDLY_MODE() => 'CKA_OTP_USER_FRIENDLY_MODE',
    CKA_OTP_USER_IDENTIFIER() => 'CKA_OTP_USER_IDENTIFIER',
    CKA_OWNER() => 'CKA_OWNER',
    CKA_PIXEL_X() => 'CKA_PIXEL_X',
    CKA_PIXEL_Y() => 'CKA_PIXEL_Y',
    CKA_PRIME() => 'CKA_PRIME',
    CKA_PRIME_1() => 'CKA_PRIME_1',
    CKA_PRIME_2() => 'CKA_PRIME_2',
    CKA_PRIME_BITS() => 'CKA_PRIME_BITS',
    CKA_PRIVATE() => 'CKA_PRIVATE',
    CKA_PRIVATE_EXPONENT() => 'CKA_PRIVATE_EXPONENT',
    CKA_PUBLIC_EXPONENT() => 'CKA_PUBLIC_EXPONENT',
    CKA_REQUIRED_CMS_ATTRIBUTES() => 'CKA_REQUIRED_CMS_ATTRIBUTES',
    CKA_RESET_ON_INIT() => 'CKA_RESET_ON_INIT',
    CKA_RESOLUTION() => 'CKA_RESOLUTION',
    CKA_SECONDARY_AUTH() => 'CKA_SECONDARY_AUTH',
    CKA_SENSITIVE() => 'CKA_SENSITIVE',
    CKA_SERIAL_NUMBER() => 'CKA_SERIAL_NUMBER',
    CKA_SIGN() => 'CKA_SIGN',
    CKA_SIGN_RECOVER() => 'CKA_SIGN_RECOVER',
    CKA_START_DATE() => 'CKA_START_DATE',
    CKA_SUBJECT() => 'CKA_SUBJECT',
    CKA_SUBPRIME() => 'CKA_SUBPRIME',
    CKA_SUB_PRIME_BITS() => 'CKA_SUB_PRIME_BITS',
    CKA_SUBPRIME_BITS() => 'CKA_SUBPRIME_BITS',
    CKA_SUPPORTED_CMS_ATTRIBUTES() => 'CKA_SUPPORTED_CMS_ATTRIBUTES',
    CKA_TOKEN() => 'CKA_TOKEN',
    CKA_TRUSTED() => 'CKA_TRUSTED',
    CKA_UNWRAP() => 'CKA_UNWRAP',
    CKA_UNWRAP_TEMPLATE() => 'CKA_UNWRAP_TEMPLATE',
    CKA_URL() => 'CKA_URL',
    CKA_VALUE() => 'CKA_VALUE',
    CKA_VALUE_BITS() => 'CKA_VALUE_BITS',
    CKA_VALUE_LEN() => 'CKA_VALUE_LEN',
    CKA_VENDOR_DEFINED() => 'CKA_VENDOR_DEFINED',
    CKA_VERIFY() => 'CKA_VERIFY',
    CKA_VERIFY_RECOVER() => 'CKA_VERIFY_RECOVER',
    CKA_WRAP() => 'CKA_WRAP',
    CKA_WRAP_TEMPLATE() => 'CKA_WRAP_TEMPLATE',
    CKA_WRAP_WITH_TRUSTED() => 'CKA_WRAP_WITH_TRUSTED',
);

our %CKC_NAME = (
    CKC_VENDOR_DEFINED() => 'CKC_VENDOR_DEFINED',
    CKC_WTLS() => 'CKC_WTLS',
    CKC_X_509() => 'CKC_X_509',
    CKC_X_509_ATTR_CERT() => 'CKC_X_509_ATTR_CERT',
);

our %CKD_NAME = (
    CKD_CPDIVERSIFY_KDF() => 'CKD_CPDIVERSIFY_KDF',
    CKD_NULL() => 'CKD_NULL',
    CKD_SHA1_KDF() => 'CKD_SHA1_KDF',
    CKD_SHA1_KDF_ASN1() => 'CKD_SHA1_KDF_ASN1',
    CKD_SHA1_KDF_CONCATENATE() => 'CKD_SHA1_KDF_CONCATENATE',
    CKD_SHA224_KDF() => 'CKD_SHA224_KDF',
    CKD_SHA256_KDF() => 'CKD_SHA256_KDF',
    CKD_SHA384_KDF() => 'CKD_SHA384_KDF',
    CKD_SHA512_KDF() => 'CKD_SHA512_KDF',
);

our %CKF_NAME = (
    CKF_ARRAY_ATTRIBUTE() => 'CKF_ARRAY_ATTRIBUTE',
    CKF_DECRYPT() => 'CKF_DECRYPT',
    CKF_DERIVE() => 'CKF_DERIVE',
    CKF_DIGEST() => 'CKF_DIGEST',
    CKF_DONT_BLOCK() => 'CKF_DONT_BLOCK',
    CKF_DUAL_CRYPTO_OPERATIONS() => 'CKF_DUAL_CRYPTO_OPERATIONS',
    CKF_EC_COMPRESS() => 'CKF_EC_COMPRESS',
    CKF_EC_ECPARAMETERS() => 'CKF_EC_ECPARAMETERS',
    CKF_EC_F_2M() => 'CKF_EC_F_2M',
    CKF_EC_F_P() => 'CKF_EC_F_P',
    CKF_EC_NAMEDCURVE() => 'CKF_EC_NAMEDCURVE',
    CKF_EC_UNCOMPRESS() => 'CKF_EC_UNCOMPRESS',
    CKF_ENCRYPT() => 'CKF_ENCRYPT',
    CKF_ERROR_STATE() => 'CKF_ERROR_STATE',
    CKF_EXCLUDE_CHALLENGE() => 'CKF_EXCLUDE_CHALLENGE',
    CKF_EXCLUDE_COUNTER() => 'CKF_EXCLUDE_COUNTER',
    CKF_EXCLUDE_PIN() => 'CKF_EXCLUDE_PIN',
    CKF_EXCLUDE_TIME() => 'CKF_EXCLUDE_TIME',
    CKF_EXTENSION() => 'CKF_EXTENSION',
    CKF_GENERATE() => 'CKF_GENERATE',
    CKF_GENERATE_KEY_PAIR() => 'CKF_GENERATE_KEY_PAIR',
    CKF_HW() => 'CKF_HW',
    CKF_HW_SLOT() => 'CKF_HW_SLOT',
    CKF_LIBRARY_CANT_CREATE_OS_THREADS() => 'CKF_LIBRARY_CANT_CREATE_OS_THREADS',
    CKF_LOGIN_REQUIRED() => 'CKF_LOGIN_REQUIRED',
    CKF_NEXT_OTP() => 'CKF_NEXT_OTP',
    CKF_OS_LOCKING_OK() => 'CKF_OS_LOCKING_OK',
    CKF_PROTECTED_AUTHENTICATION_PATH() => 'CKF_PROTECTED_AUTHENTICATION_PATH',
    CKF_REMOVABLE_DEVICE() => 'CKF_REMOVABLE_DEVICE',
    CKF_RESTORE_KEY_NOT_NEEDED() => 'CKF_RESTORE_KEY_NOT_NEEDED',
    CKF_RNG() => 'CKF_RNG',
    CKF_RW_SESSION() => 'CKF_RW_SESSION',
    CKF_SECONDARY_AUTHENTICATION() => 'CKF_SECONDARY_AUTHENTICATION',
    CKF_SERIAL_SESSION() => 'CKF_SERIAL_SESSION',
    CKF_SIGN() => 'CKF_SIGN',
    CKF_SIGN_RECOVER() => 'CKF_SIGN_RECOVER',
    CKF_SO_PIN_COUNT_LOW() => 'CKF_SO_PIN_COUNT_LOW',
    CKF_SO_PIN_FINAL_TRY() => 'CKF_SO_PIN_FINAL_TRY',
    CKF_SO_PIN_LOCKED() => 'CKF_SO_PIN_LOCKED',
    CKF_SO_PIN_TO_BE_CHANGED() => 'CKF_SO_PIN_TO_BE_CHANGED',
    CKF_TOKEN_INITIALIZED() => 'CKF_TOKEN_INITIALIZED',
    CKF_TOKEN_PRESENT() => 'CKF_TOKEN_PRESENT',
    CKF_UNWRAP() => 'CKF_UNWRAP',
    CKF_USER_FRIENDLY_OTP() => 'CKF_USER_FRIENDLY_OTP',
    CKF_USER_PIN_COUNT_LOW() => 'CKF_USER_PIN_COUNT_LOW',
    CKF_USER_PIN_FINAL_TRY() => 'CKF_USER_PIN_FINAL_TRY',
    CKF_USER_PIN_INITIALIZED() => 'CKF_USER_PIN_INITIALIZED',
    CKF_USER_PIN_LOCKED() => 'CKF_USER_PIN_LOCKED',
    CKF_USER_PIN_TO_BE_CHANGED() => 'CKF_USER_PIN_TO_BE_CHANGED',
    CKF_VERIFY() => 'CKF_VERIFY',
    CKF_VERIFY_RECOVER() => 'CKF_VERIFY_RECOVER',
    CKF_WRAP() => 'CKF_WRAP',
    CKF_WRITE_PROTECTED() => 'CKF_WRITE_PROTECTED',
);

our %CKG_NAME = (
    CKG_MGF1_SHA1() => 'CKG_MGF1_SHA1',
    CKG_MGF1_SHA224() => 'CKG_MGF1_SHA224',
    CKG_MGF1_SHA256() => 'CKG_MGF1_SHA256',
    CKG_MGF1_SHA384() => 'CKG_MGF1_SHA384',
    CKG_MGF1_SHA512() => 'CKG_MGF1_SHA512',
);

our %CKH_NAME = (
    CKH_CLOCK() => 'CKH_CLOCK',
    CKH_MONOTONIC_COUNTER() => 'CKH_MONOTONIC_COUNTER',
    CKH_USER_INTERFACE() => 'CKH_USER_INTERFACE',
    CKH_VENDOR_DEFINED() => 'CKH_VENDOR_DEFINED',
);

our %CKK_NAME = (
    CKK_ACTI() => 'CKK_ACTI',
    CKK_AES() => 'CKK_AES',
    CKK_ARIA() => 'CKK_ARIA',
    CKK_BATON() => 'CKK_BATON',
    CKK_BLOWFISH() => 'CKK_BLOWFISH',
    CKK_CAMELLIA() => 'CKK_CAMELLIA',
    CKK_CAST() => 'CKK_CAST',
    CKK_CAST128() => 'CKK_CAST128',
    CKK_CAST3() => 'CKK_CAST3',
    CKK_CAST5() => 'CKK_CAST5',
    CKK_CDMF() => 'CKK_CDMF',
    CKK_DES() => 'CKK_DES',
    CKK_DES2() => 'CKK_DES2',
    CKK_DES3() => 'CKK_DES3',
    CKK_DH() => 'CKK_DH',
    CKK_DSA() => 'CKK_DSA',
    CKK_EC() => 'CKK_EC',
    CKK_ECDSA() => 'CKK_ECDSA',
    CKK_GENERIC_SECRET() => 'CKK_GENERIC_SECRET',
    CKK_GOST28147() => 'CKK_GOST28147',
    CKK_GOSTR3410() => 'CKK_GOSTR3410',
    CKK_GOSTR3411() => 'CKK_GOSTR3411',
    CKK_HOTP() => 'CKK_HOTP',
    CKK_IDEA() => 'CKK_IDEA',
    CKK_JUNIPER() => 'CKK_JUNIPER',
    CKK_KEA() => 'CKK_KEA',
    CKK_MD5_HMAC() => 'CKK_MD5_HMAC',
    CKK_RC2() => 'CKK_RC2',
    CKK_RC4() => 'CKK_RC4',
    CKK_RC5() => 'CKK_RC5',
    CKK_RIPEMD128_HMAC() => 'CKK_RIPEMD128_HMAC',
    CKK_RIPEMD160_HMAC() => 'CKK_RIPEMD160_HMAC',
    CKK_RSA() => 'CKK_RSA',
    CKK_SECURID() => 'CKK_SECURID',
    CKK_SEED() => 'CKK_SEED',
    CKK_SHA_1_HMAC() => 'CKK_SHA_1_HMAC',
    CKK_SHA224_HMAC() => 'CKK_SHA224_HMAC',
    CKK_SHA256_HMAC() => 'CKK_SHA256_HMAC',
    CKK_SHA384_HMAC() => 'CKK_SHA384_HMAC',
    CKK_SHA512_HMAC() => 'CKK_SHA512_HMAC',
    CKK_SKIPJACK() => 'CKK_SKIPJACK',
    CKK_TWOFISH() => 'CKK_TWOFISH',
    CKK_VENDOR_DEFINED() => 'CKK_VENDOR_DEFINED',
    CKK_X9_42_DH() => 'CKK_X9_42_DH',
);

our %CKM_NAME = (
    CKM_ACTI() => 'CKM_ACTI',
    CKM_ACTI_KEY_GEN() => 'CKM_ACTI_KEY_GEN',
    CKM_AES_CBC() => 'CKM_AES_CBC',
    CKM_AES_CBC_ENCRYPT_DATA() => 'CKM_AES_CBC_ENCRYPT_DATA',
    CKM_AES_CBC_PAD() => 'CKM_AES_CBC_PAD',
    CKM_AES_CCM() => 'CKM_AES_CCM',
    CKM_AES_CFB128() => 'CKM_AES_CFB128',
    CKM_AES_CFB64() => 'CKM_AES_CFB64',
    CKM_AES_CFB8() => 'CKM_AES_CFB8',
    CKM_AES_CMAC() => 'CKM_AES_CMAC',
    CKM_AES_CMAC_GENERAL() => 'CKM_AES_CMAC_GENERAL',
    CKM_AES_CTR() => 'CKM_AES_CTR',
    CKM_AES_CTS() => 'CKM_AES_CTS',
    CKM_AES_ECB() => 'CKM_AES_ECB',
    CKM_AES_ECB_ENCRYPT_DATA() => 'CKM_AES_ECB_ENCRYPT_DATA',
    CKM_AES_GCM() => 'CKM_AES_GCM',
    CKM_AES_KEY_GEN() => 'CKM_AES_KEY_GEN',
    CKM_AES_KEY_WRAP() => 'CKM_AES_KEY_WRAP',
    CKM_AES_KEY_WRAP_PAD() => 'CKM_AES_KEY_WRAP_PAD',
    CKM_AES_MAC() => 'CKM_AES_MAC',
    CKM_AES_MAC_GENERAL() => 'CKM_AES_MAC_GENERAL',
    CKM_AES_OFB() => 'CKM_AES_OFB',
    CKM_ARIA_CBC() => 'CKM_ARIA_CBC',
    CKM_ARIA_CBC_ENCRYPT_DATA() => 'CKM_ARIA_CBC_ENCRYPT_DATA',
    CKM_ARIA_CBC_PAD() => 'CKM_ARIA_CBC_PAD',
    CKM_ARIA_ECB() => 'CKM_ARIA_ECB',
    CKM_ARIA_ECB_ENCRYPT_DATA() => 'CKM_ARIA_ECB_ENCRYPT_DATA',
    CKM_ARIA_KEY_GEN() => 'CKM_ARIA_KEY_GEN',
    CKM_ARIA_MAC() => 'CKM_ARIA_MAC',
    CKM_ARIA_MAC_GENERAL() => 'CKM_ARIA_MAC_GENERAL',
    CKM_BATON_CBC128() => 'CKM_BATON_CBC128',
    CKM_BATON_COUNTER() => 'CKM_BATON_COUNTER',
    CKM_BATON_ECB128() => 'CKM_BATON_ECB128',
    CKM_BATON_ECB96() => 'CKM_BATON_ECB96',
    CKM_BATON_KEY_GEN() => 'CKM_BATON_KEY_GEN',
    CKM_BATON_SHUFFLE() => 'CKM_BATON_SHUFFLE',
    CKM_BATON_WRAP() => 'CKM_BATON_WRAP',
    CKM_BLOWFISH_CBC() => 'CKM_BLOWFISH_CBC',
    CKM_BLOWFISH_CBC_PAD() => 'CKM_BLOWFISH_CBC_PAD',
    CKM_BLOWFISH_KEY_GEN() => 'CKM_BLOWFISH_KEY_GEN',
    CKM_CAMELLIA_CBC() => 'CKM_CAMELLIA_CBC',
    CKM_CAMELLIA_CBC_ENCRYPT_DATA() => 'CKM_CAMELLIA_CBC_ENCRYPT_DATA',
    CKM_CAMELLIA_CBC_PAD() => 'CKM_CAMELLIA_CBC_PAD',
    CKM_CAMELLIA_CTR() => 'CKM_CAMELLIA_CTR',
    CKM_CAMELLIA_ECB() => 'CKM_CAMELLIA_ECB',
    CKM_CAMELLIA_ECB_ENCRYPT_DATA() => 'CKM_CAMELLIA_ECB_ENCRYPT_DATA',
    CKM_CAMELLIA_KEY_GEN() => 'CKM_CAMELLIA_KEY_GEN',
    CKM_CAMELLIA_MAC() => 'CKM_CAMELLIA_MAC',
    CKM_CAMELLIA_MAC_GENERAL() => 'CKM_CAMELLIA_MAC_GENERAL',
    CKM_CAST128_CBC() => 'CKM_CAST128_CBC',
    CKM_CAST128_CBC_PAD() => 'CKM_CAST128_CBC_PAD',
    CKM_CAST128_ECB() => 'CKM_CAST128_ECB',
    CKM_CAST128_KEY_GEN() => 'CKM_CAST128_KEY_GEN',
    CKM_CAST128_MAC() => 'CKM_CAST128_MAC',
    CKM_CAST128_MAC_GENERAL() => 'CKM_CAST128_MAC_GENERAL',
    CKM_CAST3_CBC() => 'CKM_CAST3_CBC',
    CKM_CAST3_CBC_PAD() => 'CKM_CAST3_CBC_PAD',
    CKM_CAST3_ECB() => 'CKM_CAST3_ECB',
    CKM_CAST3_KEY_GEN() => 'CKM_CAST3_KEY_GEN',
    CKM_CAST3_MAC() => 'CKM_CAST3_MAC',
    CKM_CAST3_MAC_GENERAL() => 'CKM_CAST3_MAC_GENERAL',
    CKM_CAST5_CBC() => 'CKM_CAST5_CBC',
    CKM_CAST5_CBC_PAD() => 'CKM_CAST5_CBC_PAD',
    CKM_CAST5_ECB() => 'CKM_CAST5_ECB',
    CKM_CAST5_KEY_GEN() => 'CKM_CAST5_KEY_GEN',
    CKM_CAST5_MAC() => 'CKM_CAST5_MAC',
    CKM_CAST5_MAC_GENERAL() => 'CKM_CAST5_MAC_GENERAL',
    CKM_CAST_CBC() => 'CKM_CAST_CBC',
    CKM_CAST_CBC_PAD() => 'CKM_CAST_CBC_PAD',
    CKM_CAST_ECB() => 'CKM_CAST_ECB',
    CKM_CAST_KEY_GEN() => 'CKM_CAST_KEY_GEN',
    CKM_CAST_MAC() => 'CKM_CAST_MAC',
    CKM_CAST_MAC_GENERAL() => 'CKM_CAST_MAC_GENERAL',
    CKM_CDMF_CBC() => 'CKM_CDMF_CBC',
    CKM_CDMF_CBC_PAD() => 'CKM_CDMF_CBC_PAD',
    CKM_CDMF_ECB() => 'CKM_CDMF_ECB',
    CKM_CDMF_KEY_GEN() => 'CKM_CDMF_KEY_GEN',
    CKM_CDMF_MAC() => 'CKM_CDMF_MAC',
    CKM_CDMF_MAC_GENERAL() => 'CKM_CDMF_MAC_GENERAL',
    CKM_CMS_SIG() => 'CKM_CMS_SIG',
    CKM_CONCATENATE_BASE_AND_DATA() => 'CKM_CONCATENATE_BASE_AND_DATA',
    CKM_CONCATENATE_BASE_AND_KEY() => 'CKM_CONCATENATE_BASE_AND_KEY',
    CKM_CONCATENATE_DATA_AND_BASE() => 'CKM_CONCATENATE_DATA_AND_BASE',
    CKM_DES2_KEY_GEN() => 'CKM_DES2_KEY_GEN',
    CKM_DES3_CBC() => 'CKM_DES3_CBC',
    CKM_DES3_CBC_ENCRYPT_DATA() => 'CKM_DES3_CBC_ENCRYPT_DATA',
    CKM_DES3_CBC_PAD() => 'CKM_DES3_CBC_PAD',
    CKM_DES3_CMAC() => 'CKM_DES3_CMAC',
    CKM_DES3_CMAC_GENERAL() => 'CKM_DES3_CMAC_GENERAL',
    CKM_DES3_ECB() => 'CKM_DES3_ECB',
    CKM_DES3_ECB_ENCRYPT_DATA() => 'CKM_DES3_ECB_ENCRYPT_DATA',
    CKM_DES3_KEY_GEN() => 'CKM_DES3_KEY_GEN',
    CKM_DES3_MAC() => 'CKM_DES3_MAC',
    CKM_DES3_MAC_GENERAL() => 'CKM_DES3_MAC_GENERAL',
    CKM_DES_CBC() => 'CKM_DES_CBC',
    CKM_DES_CBC_ENCRYPT_DATA() => 'CKM_DES_CBC_ENCRYPT_DATA',
    CKM_DES_CBC_PAD() => 'CKM_DES_CBC_PAD',
    CKM_DES_CFB64() => 'CKM_DES_CFB64',
    CKM_DES_CFB8() => 'CKM_DES_CFB8',
    CKM_DES_ECB() => 'CKM_DES_ECB',
    CKM_DES_ECB_ENCRYPT_DATA() => 'CKM_DES_ECB_ENCRYPT_DATA',
    CKM_DES_KEY_GEN() => 'CKM_DES_KEY_GEN',
    CKM_DES_MAC() => 'CKM_DES_MAC',
    CKM_DES_MAC_GENERAL() => 'CKM_DES_MAC_GENERAL',
    CKM_DES_OFB64() => 'CKM_DES_OFB64',
    CKM_DES_OFB8() => 'CKM_DES_OFB8',
    CKM_DH_PKCS_DERIVE() => 'CKM_DH_PKCS_DERIVE',
    CKM_DH_PKCS_KEY_PAIR_GEN() => 'CKM_DH_PKCS_KEY_PAIR_GEN',
    CKM_DH_PKCS_PARAMETER_GEN() => 'CKM_DH_PKCS_PARAMETER_GEN',
    CKM_DSA() => 'CKM_DSA',
    CKM_DSA_KEY_PAIR_GEN() => 'CKM_DSA_KEY_PAIR_GEN',
    CKM_DSA_PARAMETER_GEN() => 'CKM_DSA_PARAMETER_GEN',
    CKM_DSA_SHA1() => 'CKM_DSA_SHA1',
    CKM_DSA_SHA224() => 'CKM_DSA_SHA224',
    CKM_DSA_SHA256() => 'CKM_DSA_SHA256',
    CKM_DSA_SHA384() => 'CKM_DSA_SHA384',
    CKM_DSA_SHA512() => 'CKM_DSA_SHA512',
    CKM_ECDH1_COFACTOR_DERIVE() => 'CKM_ECDH1_COFACTOR_DERIVE',
    CKM_ECDH1_DERIVE() => 'CKM_ECDH1_DERIVE',
    CKM_ECDSA() => 'CKM_ECDSA',
    CKM_ECDSA_KEY_PAIR_GEN() => 'CKM_ECDSA_KEY_PAIR_GEN',
    CKM_ECDSA_SHA1() => 'CKM_ECDSA_SHA1',
    CKM_ECDSA_SHA224() => 'CKM_ECDSA_SHA224',
    CKM_ECDSA_SHA256() => 'CKM_ECDSA_SHA256',
    CKM_ECDSA_SHA384() => 'CKM_ECDSA_SHA384',
    CKM_ECDSA_SHA512() => 'CKM_ECDSA_SHA512',
    CKM_EC_KEY_PAIR_GEN() => 'CKM_EC_KEY_PAIR_GEN',
    CKM_ECMQV_DERIVE() => 'CKM_ECMQV_DERIVE',
    CKM_EXTRACT_KEY_FROM_KEY() => 'CKM_EXTRACT_KEY_FROM_KEY',
    CKM_FASTHASH() => 'CKM_FASTHASH',
    CKM_FORTEZZA_TIMESTAMP() => 'CKM_FORTEZZA_TIMESTAMP',
    CKM_GENERIC_SECRET_KEY_GEN() => 'CKM_GENERIC_SECRET_KEY_GEN',
    CKM_GOST28147() => 'CKM_GOST28147',
    CKM_GOST28147_ECB() => 'CKM_GOST28147_ECB',
    CKM_GOST28147_KEY_GEN() => 'CKM_GOST28147_KEY_GEN',
    CKM_GOST28147_KEY_WRAP() => 'CKM_GOST28147_KEY_WRAP',
    CKM_GOST28147_MAC() => 'CKM_GOST28147_MAC',
    CKM_GOSTR3410() => 'CKM_GOSTR3410',
    CKM_GOSTR3410_DERIVE() => 'CKM_GOSTR3410_DERIVE',
    CKM_GOSTR3410_KEY_PAIR_GEN() => 'CKM_GOSTR3410_KEY_PAIR_GEN',
    CKM_GOSTR3410_KEY_WRAP() => 'CKM_GOSTR3410_KEY_WRAP',
    CKM_GOSTR3410_WITH_GOSTR3411() => 'CKM_GOSTR3410_WITH_GOSTR3411',
    CKM_GOSTR3411() => 'CKM_GOSTR3411',
    CKM_GOSTR3411_HMAC() => 'CKM_GOSTR3411_HMAC',
    CKM_HOTP() => 'CKM_HOTP',
    CKM_HOTP_KEY_GEN() => 'CKM_HOTP_KEY_GEN',
    CKM_IDEA_CBC() => 'CKM_IDEA_CBC',
    CKM_IDEA_CBC_PAD() => 'CKM_IDEA_CBC_PAD',
    CKM_IDEA_ECB() => 'CKM_IDEA_ECB',
    CKM_IDEA_KEY_GEN() => 'CKM_IDEA_KEY_GEN',
    CKM_IDEA_MAC() => 'CKM_IDEA_MAC',
    CKM_IDEA_MAC_GENERAL() => 'CKM_IDEA_MAC_GENERAL',
    CKM_JUNIPER_CBC128() => 'CKM_JUNIPER_CBC128',
    CKM_JUNIPER_COUNTER() => 'CKM_JUNIPER_COUNTER',
    CKM_JUNIPER_ECB128() => 'CKM_JUNIPER_ECB128',
    CKM_JUNIPER_KEY_GEN() => 'CKM_JUNIPER_KEY_GEN',
    CKM_JUNIPER_SHUFFLE() => 'CKM_JUNIPER_SHUFFLE',
    CKM_JUNIPER_WRAP() => 'CKM_JUNIPER_WRAP',
    CKM_KEA_KEY_DERIVE() => 'CKM_KEA_KEY_DERIVE',
    CKM_KEA_KEY_PAIR_GEN() => 'CKM_KEA_KEY_PAIR_GEN',
    CKM_KEY_WRAP_LYNKS() => 'CKM_KEY_WRAP_LYNKS',
    CKM_KEY_WRAP_SET_OAEP() => 'CKM_KEY_WRAP_SET_OAEP',
    CKM_KIP_DERIVE() => 'CKM_KIP_DERIVE',
    CKM_KIP_MAC() => 'CKM_KIP_MAC',
    CKM_KIP_WRAP() => 'CKM_KIP_WRAP',
    CKM_MD2() => 'CKM_MD2',
    CKM_MD2_HMAC() => 'CKM_MD2_HMAC',
    CKM_MD2_HMAC_GENERAL() => 'CKM_MD2_HMAC_GENERAL',
    CKM_MD2_KEY_DERIVATION() => 'CKM_MD2_KEY_DERIVATION',
    CKM_MD2_RSA_PKCS() => 'CKM_MD2_RSA_PKCS',
    CKM_MD5() => 'CKM_MD5',
    CKM_MD5_HMAC() => 'CKM_MD5_HMAC',
    CKM_MD5_HMAC_GENERAL() => 'CKM_MD5_HMAC_GENERAL',
    CKM_MD5_KEY_DERIVATION() => 'CKM_MD5_KEY_DERIVATION',
    CKM_MD5_RSA_PKCS() => 'CKM_MD5_RSA_PKCS',
    CKM_PBA_SHA1_WITH_SHA1_HMAC() => 'CKM_PBA_SHA1_WITH_SHA1_HMAC',
    CKM_PBE_MD2_DES_CBC() => 'CKM_PBE_MD2_DES_CBC',
    CKM_PBE_MD5_CAST128_CBC() => 'CKM_PBE_MD5_CAST128_CBC',
    CKM_PBE_MD5_CAST3_CBC() => 'CKM_PBE_MD5_CAST3_CBC',
    CKM_PBE_MD5_CAST5_CBC() => 'CKM_PBE_MD5_CAST5_CBC',
    CKM_PBE_MD5_CAST_CBC() => 'CKM_PBE_MD5_CAST_CBC',
    CKM_PBE_MD5_DES_CBC() => 'CKM_PBE_MD5_DES_CBC',
    CKM_PBE_SHA1_CAST128_CBC() => 'CKM_PBE_SHA1_CAST128_CBC',
    CKM_PBE_SHA1_CAST5_CBC() => 'CKM_PBE_SHA1_CAST5_CBC',
    CKM_PBE_SHA1_DES2_EDE_CBC() => 'CKM_PBE_SHA1_DES2_EDE_CBC',
    CKM_PBE_SHA1_DES3_EDE_CBC() => 'CKM_PBE_SHA1_DES3_EDE_CBC',
    CKM_PBE_SHA1_RC2_128_CBC() => 'CKM_PBE_SHA1_RC2_128_CBC',
    CKM_PBE_SHA1_RC2_40_CBC() => 'CKM_PBE_SHA1_RC2_40_CBC',
    CKM_PBE_SHA1_RC4_128() => 'CKM_PBE_SHA1_RC4_128',
    CKM_PBE_SHA1_RC4_40() => 'CKM_PBE_SHA1_RC4_40',
    CKM_PKCS5_PBKD2() => 'CKM_PKCS5_PBKD2',
    CKM_RC2_CBC() => 'CKM_RC2_CBC',
    CKM_RC2_CBC_PAD() => 'CKM_RC2_CBC_PAD',
    CKM_RC2_ECB() => 'CKM_RC2_ECB',
    CKM_RC2_KEY_GEN() => 'CKM_RC2_KEY_GEN',
    CKM_RC2_MAC() => 'CKM_RC2_MAC',
    CKM_RC2_MAC_GENERAL() => 'CKM_RC2_MAC_GENERAL',
    CKM_RC4() => 'CKM_RC4',
    CKM_RC4_KEY_GEN() => 'CKM_RC4_KEY_GEN',
    CKM_RC5_CBC() => 'CKM_RC5_CBC',
    CKM_RC5_CBC_PAD() => 'CKM_RC5_CBC_PAD',
    CKM_RC5_ECB() => 'CKM_RC5_ECB',
    CKM_RC5_KEY_GEN() => 'CKM_RC5_KEY_GEN',
    CKM_RC5_MAC() => 'CKM_RC5_MAC',
    CKM_RC5_MAC_GENERAL() => 'CKM_RC5_MAC_GENERAL',
    CKM_RIPEMD128() => 'CKM_RIPEMD128',
    CKM_RIPEMD128_HMAC() => 'CKM_RIPEMD128_HMAC',
    CKM_RIPEMD128_HMAC_GENERAL() => 'CKM_RIPEMD128_HMAC_GENERAL',
    CKM_RIPEMD128_RSA_PKCS() => 'CKM_RIPEMD128_RSA_PKCS',
    CKM_RIPEMD160() => 'CKM_RIPEMD160',
    CKM_RIPEMD160_HMAC() => 'CKM_RIPEMD160_HMAC',
    CKM_RIPEMD160_HMAC_GENERAL() => 'CKM_RIPEMD160_HMAC_GENERAL',
    CKM_RIPEMD160_RSA_PKCS() => 'CKM_RIPEMD160_RSA_PKCS',
    CKM_RSA_9796() => 'CKM_RSA_9796',
    CKM_RSA_PKCS() => 'CKM_RSA_PKCS',
    CKM_RSA_PKCS_KEY_PAIR_GEN() => 'CKM_RSA_PKCS_KEY_PAIR_GEN',
    CKM_RSA_PKCS_OAEP() => 'CKM_RSA_PKCS_OAEP',
    CKM_RSA_PKCS_OAEP_TPM_1_1() => 'CKM_RSA_PKCS_OAEP_TPM_1_1',
    CKM_RSA_PKCS_PSS() => 'CKM_RSA_PKCS_PSS',
    CKM_RSA_PKCS_TPM_1_1() => 'CKM_RSA_PKCS_TPM_1_1',
    CKM_RSA_X_509() => 'CKM_RSA_X_509',
    CKM_RSA_X9_31() => 'CKM_RSA_X9_31',
    CKM_RSA_X9_31_KEY_PAIR_GEN() => 'CKM_RSA_X9_31_KEY_PAIR_GEN',
    CKM_SECURID() => 'CKM_SECURID',
    CKM_SECURID_KEY_GEN() => 'CKM_SECURID_KEY_GEN',
    CKM_SEED_CBC() => 'CKM_SEED_CBC',
    CKM_SEED_CBC_ENCRYPT_DATA() => 'CKM_SEED_CBC_ENCRYPT_DATA',
    CKM_SEED_CBC_PAD() => 'CKM_SEED_CBC_PAD',
    CKM_SEED_ECB() => 'CKM_SEED_ECB',
    CKM_SEED_ECB_ENCRYPT_DATA() => 'CKM_SEED_ECB_ENCRYPT_DATA',
    CKM_SEED_KEY_GEN() => 'CKM_SEED_KEY_GEN',
    CKM_SEED_MAC() => 'CKM_SEED_MAC',
    CKM_SEED_MAC_GENERAL() => 'CKM_SEED_MAC_GENERAL',
    CKM_SHA_1() => 'CKM_SHA_1',
    CKM_SHA_1_HMAC() => 'CKM_SHA_1_HMAC',
    CKM_SHA_1_HMAC_GENERAL() => 'CKM_SHA_1_HMAC_GENERAL',
    CKM_SHA1_KEY_DERIVATION() => 'CKM_SHA1_KEY_DERIVATION',
    CKM_SHA1_RSA_PKCS() => 'CKM_SHA1_RSA_PKCS',
    CKM_SHA1_RSA_PKCS_PSS() => 'CKM_SHA1_RSA_PKCS_PSS',
    CKM_SHA1_RSA_X9_31() => 'CKM_SHA1_RSA_X9_31',
    CKM_SHA224() => 'CKM_SHA224',
    CKM_SHA224_HMAC() => 'CKM_SHA224_HMAC',
    CKM_SHA224_HMAC_GENERAL() => 'CKM_SHA224_HMAC_GENERAL',
    CKM_SHA224_KEY_DERIVATION() => 'CKM_SHA224_KEY_DERIVATION',
    CKM_SHA224_RSA_PKCS() => 'CKM_SHA224_RSA_PKCS',
    CKM_SHA224_RSA_PKCS_PSS() => 'CKM_SHA224_RSA_PKCS_PSS',
    CKM_SHA256() => 'CKM_SHA256',
    CKM_SHA256_HMAC() => 'CKM_SHA256_HMAC',
    CKM_SHA256_HMAC_GENERAL() => 'CKM_SHA256_HMAC_GENERAL',
    CKM_SHA256_KEY_DERIVATION() => 'CKM_SHA256_KEY_DERIVATION',
    CKM_SHA256_RSA_PKCS() => 'CKM_SHA256_RSA_PKCS',
    CKM_SHA256_RSA_PKCS_PSS() => 'CKM_SHA256_RSA_PKCS_PSS',
    CKM_SHA384() => 'CKM_SHA384',
    CKM_SHA384_HMAC() => 'CKM_SHA384_HMAC',
    CKM_SHA384_HMAC_GENERAL() => 'CKM_SHA384_HMAC_GENERAL',
    CKM_SHA384_KEY_DERIVATION() => 'CKM_SHA384_KEY_DERIVATION',
    CKM_SHA384_RSA_PKCS() => 'CKM_SHA384_RSA_PKCS',
    CKM_SHA384_RSA_PKCS_PSS() => 'CKM_SHA384_RSA_PKCS_PSS',
    CKM_SHA512() => 'CKM_SHA512',
    CKM_SHA512_HMAC() => 'CKM_SHA512_HMAC',
    CKM_SHA512_HMAC_GENERAL() => 'CKM_SHA512_HMAC_GENERAL',
    CKM_SHA512_KEY_DERIVATION() => 'CKM_SHA512_KEY_DERIVATION',
    CKM_SHA512_RSA_PKCS() => 'CKM_SHA512_RSA_PKCS',
    CKM_SHA512_RSA_PKCS_PSS() => 'CKM_SHA512_RSA_PKCS_PSS',
    CKM_SSL3_KEY_AND_MAC_DERIVE() => 'CKM_SSL3_KEY_AND_MAC_DERIVE',
    CKM_SSL3_MASTER_KEY_DERIVE() => 'CKM_SSL3_MASTER_KEY_DERIVE',
    CKM_SSL3_MASTER_KEY_DERIVE_DH() => 'CKM_SSL3_MASTER_KEY_DERIVE_DH',
    CKM_SSL3_MD5_MAC() => 'CKM_SSL3_MD5_MAC',
    CKM_SSL3_PRE_MASTER_KEY_GEN() => 'CKM_SSL3_PRE_MASTER_KEY_GEN',
    CKM_SSL3_SHA1_MAC() => 'CKM_SSL3_SHA1_MAC',
    CKM_TLS_KEY_AND_MAC_DERIVE() => 'CKM_TLS_KEY_AND_MAC_DERIVE',
    CKM_TLS_MASTER_KEY_DERIVE() => 'CKM_TLS_MASTER_KEY_DERIVE',
    CKM_TLS_MASTER_KEY_DERIVE_DH() => 'CKM_TLS_MASTER_KEY_DERIVE_DH',
    CKM_TLS_PRE_MASTER_KEY_GEN() => 'CKM_TLS_PRE_MASTER_KEY_GEN',
    CKM_TLS_PRF() => 'CKM_TLS_PRF',
    CKM_TWOFISH_CBC() => 'CKM_TWOFISH_CBC',
    CKM_TWOFISH_CBC_PAD() => 'CKM_TWOFISH_CBC_PAD',
    CKM_TWOFISH_KEY_GEN() => 'CKM_TWOFISH_KEY_GEN',
    CKM_VENDOR_DEFINED() => 'CKM_VENDOR_DEFINED',
    CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE() => 'CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE',
    CKM_WTLS_MASTER_KEY_DERIVE() => 'CKM_WTLS_MASTER_KEY_DERIVE',
    CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC() => 'CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC',
    CKM_WTLS_PRE_MASTER_KEY_GEN() => 'CKM_WTLS_PRE_MASTER_KEY_GEN',
    CKM_WTLS_PRF() => 'CKM_WTLS_PRF',
    CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE() => 'CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE',
    CKM_X9_42_DH_DERIVE() => 'CKM_X9_42_DH_DERIVE',
    CKM_X9_42_DH_HYBRID_DERIVE() => 'CKM_X9_42_DH_HYBRID_DERIVE',
    CKM_X9_42_DH_KEY_PAIR_GEN() => 'CKM_X9_42_DH_KEY_PAIR_GEN',
    CKM_X9_42_DH_PARAMETER_GEN() => 'CKM_X9_42_DH_PARAMETER_GEN',
    CKM_X9_42_MQV_DERIVE() => 'CKM_X9_42_MQV_DERIVE',
    CKM_XOR_BASE_AND_DATA() => 'CKM_XOR_BASE_AND_DATA',
);

our %CKN_NAME = (
    CKN_OTP_CHANGED() => 'CKN_OTP_CHANGED',
    CKN_SURRENDER() => 'CKN_SURRENDER',
);

our %CKO_NAME = (
    CKO_CERTIFICATE() => 'CKO_CERTIFICATE',
    CKO_DATA() => 'CKO_DATA',
    CKO_DOMAIN_PARAMETERS() => 'CKO_DOMAIN_PARAMETERS',
    CKO_HW_FEATURE() => 'CKO_HW_FEATURE',
    CKO_MECHANISM() => 'CKO_MECHANISM',
    CKO_OTP_KEY() => 'CKO_OTP_KEY',
    CKO_PRIVATE_KEY() => 'CKO_PRIVATE_KEY',
    CKO_PUBLIC_KEY() => 'CKO_PUBLIC_KEY',
    CKO_SECRET_KEY() => 'CKO_SECRET_KEY',
    CKO_VENDOR_DEFINED() => 'CKO_VENDOR_DEFINED',
);

our %CKP_NAME = (
    CKP_PKCS5_PBKD2_HMAC_SHA1() => 'CKP_PKCS5_PBKD2_HMAC_SHA1',
);

our %CKR_NAME = (
    CKR_ARGUMENTS_BAD() => 'CKR_ARGUMENTS_BAD',
    CKR_ATTRIBUTE_READ_ONLY() => 'CKR_ATTRIBUTE_READ_ONLY',
    CKR_ATTRIBUTE_SENSITIVE() => 'CKR_ATTRIBUTE_SENSITIVE',
    CKR_ATTRIBUTE_TYPE_INVALID() => 'CKR_ATTRIBUTE_TYPE_INVALID',
    CKR_ATTRIBUTE_VALUE_INVALID() => 'CKR_ATTRIBUTE_VALUE_INVALID',
    CKR_BUFFER_TOO_SMALL() => 'CKR_BUFFER_TOO_SMALL',
    CKR_CANCEL() => 'CKR_CANCEL',
    CKR_CANT_LOCK() => 'CKR_CANT_LOCK',
    CKR_CRYPTOKI_ALREADY_INITIALIZED() => 'CKR_CRYPTOKI_ALREADY_INITIALIZED',
    CKR_CRYPTOKI_NOT_INITIALIZED() => 'CKR_CRYPTOKI_NOT_INITIALIZED',
    CKR_DATA_INVALID() => 'CKR_DATA_INVALID',
    CKR_DATA_LEN_RANGE() => 'CKR_DATA_LEN_RANGE',
    CKR_DEVICE_ERROR() => 'CKR_DEVICE_ERROR',
    CKR_DEVICE_MEMORY() => 'CKR_DEVICE_MEMORY',
    CKR_DEVICE_REMOVED() => 'CKR_DEVICE_REMOVED',
    CKR_DOMAIN_PARAMS_INVALID() => 'CKR_DOMAIN_PARAMS_INVALID',
    CKR_ENCRYPTED_DATA_INVALID() => 'CKR_ENCRYPTED_DATA_INVALID',
    CKR_ENCRYPTED_DATA_LEN_RANGE() => 'CKR_ENCRYPTED_DATA_LEN_RANGE',
    CKR_EXCEEDED_MAX_ITERATIONS() => 'CKR_EXCEEDED_MAX_ITERATIONS',
    CKR_FIPS_SELF_TEST_FAILED() => 'CKR_FIPS_SELF_TEST_FAILED',
    CKR_FUNCTION_CANCELED() => 'CKR_FUNCTION_CANCELED',
    CKR_FUNCTION_FAILED() => 'CKR_FUNCTION_FAILED',
    CKR_FUNCTION_NOT_PARALLEL() => 'CKR_FUNCTION_NOT_PARALLEL',
    CKR_FUNCTION_NOT_SUPPORTED() => 'CKR_FUNCTION_NOT_SUPPORTED',
    CKR_FUNCTION_REJECTED() => 'CKR_FUNCTION_REJECTED',
    CKR_GENERAL_ERROR() => 'CKR_GENERAL_ERROR',
    CKR_HOST_MEMORY() => 'CKR_HOST_MEMORY',
    CKR_INFORMATION_SENSITIVE() => 'CKR_INFORMATION_SENSITIVE',
    CKR_KEY_CHANGED() => 'CKR_KEY_CHANGED',
    CKR_KEY_FUNCTION_NOT_PERMITTED() => 'CKR_KEY_FUNCTION_NOT_PERMITTED',
    CKR_KEY_HANDLE_INVALID() => 'CKR_KEY_HANDLE_INVALID',
    CKR_KEY_INDIGESTIBLE() => 'CKR_KEY_INDIGESTIBLE',
    CKR_KEY_NEEDED() => 'CKR_KEY_NEEDED',
    CKR_KEY_NOT_NEEDED() => 'CKR_KEY_NOT_NEEDED',
    CKR_KEY_NOT_WRAPPABLE() => 'CKR_KEY_NOT_WRAPPABLE',
    CKR_KEY_SIZE_RANGE() => 'CKR_KEY_SIZE_RANGE',
    CKR_KEY_TYPE_INCONSISTENT() => 'CKR_KEY_TYPE_INCONSISTENT',
    CKR_KEY_UNEXTRACTABLE() => 'CKR_KEY_UNEXTRACTABLE',
    CKR_LIBRARY_LOAD_FAILED() => 'CKR_LIBRARY_LOAD_FAILED',
    CKR_MECHANISM_INVALID() => 'CKR_MECHANISM_INVALID',
    CKR_MECHANISM_PARAM_INVALID() => 'CKR_MECHANISM_PARAM_INVALID',
    CKR_MUTEX_BAD() => 'CKR_MUTEX_BAD',
    CKR_MUTEX_NOT_LOCKED() => 'CKR_MUTEX_NOT_LOCKED',
    CKR_NEED_TO_CREATE_THREADS() => 'CKR_NEED_TO_CREATE_THREADS',
    CKR_NEW_PIN_MODE() => 'CKR_NEW_PIN_MODE',
    CKR_NEXT_OTP() => 'CKR_NEXT_OTP',
    CKR_NO_EVENT() => 'CKR_NO_EVENT',
    CKR_OBJECT_HANDLE_INVALID() => 'CKR_OBJECT_HANDLE_INVALID',
    CKR_OK() => 'CKR_OK',
    CKR_OPERATION_ACTIVE() => 'CKR_OPERATION_ACTIVE',
    CKR_OPERATION_NOT_INITIALIZED() => 'CKR_OPERATION_NOT_INITIALIZED',
    CKR_PIN_EXPIRED() => 'CKR_PIN_EXPIRED',
    CKR_PIN_INCORRECT() => 'CKR_PIN_INCORRECT',
    CKR_PIN_INVALID() => 'CKR_PIN_INVALID',
    CKR_PIN_LEN_RANGE() => 'CKR_PIN_LEN_RANGE',
    CKR_PIN_LOCKED() => 'CKR_PIN_LOCKED',
    CKR_PIN_TOO_WEAK() => 'CKR_PIN_TOO_WEAK',
    CKR_PUBLIC_KEY_INVALID() => 'CKR_PUBLIC_KEY_INVALID',
    CKR_RANDOM_NO_RNG() => 'CKR_RANDOM_NO_RNG',
    CKR_RANDOM_SEED_NOT_SUPPORTED() => 'CKR_RANDOM_SEED_NOT_SUPPORTED',
    CKR_SAVED_STATE_INVALID() => 'CKR_SAVED_STATE_INVALID',
    CKR_SESSION_CLOSED() => 'CKR_SESSION_CLOSED',
    CKR_SESSION_COUNT() => 'CKR_SESSION_COUNT',
    CKR_SESSION_EXISTS() => 'CKR_SESSION_EXISTS',
    CKR_SESSION_HANDLE_INVALID() => 'CKR_SESSION_HANDLE_INVALID',
    CKR_SESSION_PARALLEL_NOT_SUPPORTED() => 'CKR_SESSION_PARALLEL_NOT_SUPPORTED',
    CKR_SESSION_READ_ONLY() => 'CKR_SESSION_READ_ONLY',
    CKR_SESSION_READ_ONLY_EXISTS() => 'CKR_SESSION_READ_ONLY_EXISTS',
    CKR_SESSION_READ_WRITE_SO_EXISTS() => 'CKR_SESSION_READ_WRITE_SO_EXISTS',
    CKR_SIGNATURE_INVALID() => 'CKR_SIGNATURE_INVALID',
    CKR_SIGNATURE_LEN_RANGE() => 'CKR_SIGNATURE_LEN_RANGE',
    CKR_SLOT_ID_INVALID() => 'CKR_SLOT_ID_INVALID',
    CKR_STATE_UNSAVEABLE() => 'CKR_STATE_UNSAVEABLE',
    CKR_TEMPLATE_INCOMPLETE() => 'CKR_TEMPLATE_INCOMPLETE',
    CKR_TEMPLATE_INCONSISTENT() => 'CKR_TEMPLATE_INCONSISTENT',
    CKR_TOKEN_NOT_PRESENT() => 'CKR_TOKEN_NOT_PRESENT',
    CKR_TOKEN_NOT_RECOGNIZED() => 'CKR_TOKEN_NOT_RECOGNIZED',
    CKR_TOKEN_WRITE_PROTECTED() => 'CKR_TOKEN_WRITE_PROTECTED',
    CKR_UNWRAPPING_KEY_HANDLE_INVALID() => 'CKR_UNWRAPPING_KEY_HANDLE_INVALID',
    CKR_UNWRAPPING_KEY_SIZE_RANGE() => 'CKR_UNWRAPPING_KEY_SIZE_RANGE',
    CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT() => 'CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT',
    CKR_USER_ALREADY_LOGGED_IN() => 'CKR_USER_ALREADY_LOGGED_IN',
    CKR_USER_ANOTHER_ALREADY_LOGGED_IN() => 'CKR_USER_ANOTHER_ALREADY_LOGGED_IN',
    CKR_USER_NOT_LOGGED_IN() => 'CKR_USER_NOT_LOGGED_IN',
    CKR_USER_PIN_NOT_INITIALIZED() => 'CKR_USER_PIN_NOT_INITIALIZED',
    CKR_USER_TOO_MANY_TYPES() => 'CKR_USER_TOO_MANY_TYPES',
    CKR_USER_TYPE_INVALID() => 'CKR_USER_TYPE_INVALID',
    CKR_VENDOR_DEFINED() => 'CKR_VENDOR_DEFINED',
    CKR_WRAPPED_KEY_INVALID() => 'CKR_WRAPPED_KEY_INVALID',
    CKR_WRAPPED_KEY_LEN_RANGE() => 'CKR_WRAPPED_KEY_LEN_RANGE',
    CKR_WRAPPING_KEY_HANDLE_INVALID() => 'CKR_WRAPPING_KEY_HANDLE_INVALID',
    CKR_WRAPPING_KEY_SIZE_RANGE() => 'CKR_WRAPPING_KEY_SIZE_RANGE',
    CKR_WRAPPING_KEY_TYPE_INCONSISTENT() => 'CKR_WRAPPING_KEY_TYPE_INCONSISTENT',
);

our %CKS_NAME = (
    CKS_RO_PUBLIC_SESSION() => 'CKS_RO_PUBLIC_SESSION',
    CKS_RO_USER_FUNCTIONS() => 'CKS_RO_USER_FUNCTIONS',
    CKS_RW_PUBLIC_SESSION() => 'CKS_RW_PUBLIC_SESSION',
    CKS_RW_SO_FUNCTIONS() => 'CKS_RW_SO_FUNCTIONS',
    CKS_RW_USER_FUNCTIONS() => 'CKS_RW_USER_FUNCTIONS',
);

our %CKU_NAME = (
    CKU_CONTEXT_SPECIFIC() => 'CKU_CONTEXT_SPECIFIC',
    CKU_SO() => 'CKU_SO',
    CKU_USER() => 'CKU_USER',
);

our %CKZ_NAME = (
    CKZ_DATA_SPECIFIED() => 'CKZ_DATA_SPECIFIED',
    CKZ_SALT_SPECIFIED() => 'CKZ_SALT_SPECIFIED',
);

our $VERSION = '0.99_01';

our (@ISA, %EXPORT_TAGS, @EXPORT_OK);
BEGIN {
    require Exporter;
    @ISA = qw(Exporter);
    %EXPORT_TAGS = ( constant => [qw(
CK_ULONG_SIZE

CRYPTOKI_VERSION_MAJOR CRYPTOKI_VERSION_MINOR CRYPTOKI_VERSION_AMENDMENT
CK_TRUE CK_FALSE FALSE TRUE CK_UNAVAILABLE_INFORMATION CK_EFFECTIVELY_INFINITE
CK_INVALID_HANDLE CKN_SURRENDER CKN_OTP_CHANGED CKF_TOKEN_PRESENT
CKF_REMOVABLE_DEVICE CKF_HW_SLOT CKF_RNG CKF_WRITE_PROTECTED CKF_LOGIN_REQUIRED
CKF_USER_PIN_INITIALIZED CKF_RESTORE_KEY_NOT_NEEDED CKF_CLOCK_ON_TOKEN
CKF_PROTECTED_AUTHENTICATION_PATH CKF_DUAL_CRYPTO_OPERATIONS
CKF_TOKEN_INITIALIZED CKF_SECONDARY_AUTHENTICATION CKF_USER_PIN_COUNT_LOW
CKF_USER_PIN_FINAL_TRY CKF_USER_PIN_LOCKED CKF_USER_PIN_TO_BE_CHANGED
CKF_SO_PIN_COUNT_LOW CKF_SO_PIN_FINAL_TRY CKF_SO_PIN_LOCKED
CKF_SO_PIN_TO_BE_CHANGED CKU_SO CKU_USER CKU_CONTEXT_SPECIFIC
CKS_RO_PUBLIC_SESSION CKS_RO_USER_FUNCTIONS CKS_RW_PUBLIC_SESSION
CKS_RW_USER_FUNCTIONS CKS_RW_SO_FUNCTIONS CKF_RW_SESSION CKF_SERIAL_SESSION
CKO_DATA CKO_CERTIFICATE CKO_PUBLIC_KEY CKO_PRIVATE_KEY CKO_SECRET_KEY
CKO_HW_FEATURE CKO_DOMAIN_PARAMETERS CKO_MECHANISM CKO_OTP_KEY
CKO_VENDOR_DEFINED CKH_MONOTONIC_COUNTER CKH_CLOCK CKH_USER_INTERFACE
CKH_VENDOR_DEFINED CKK_RSA CKK_DSA CKK_DH CKK_ECDSA CKK_EC CKK_X9_42_DH CKK_KEA
CKK_GENERIC_SECRET CKK_RC2 CKK_RC4 CKK_DES CKK_DES2 CKK_DES3 CKK_CAST CKK_CAST3
CKK_CAST5 CKK_CAST128 CKK_RC5 CKK_IDEA CKK_SKIPJACK CKK_BATON CKK_JUNIPER
CKK_CDMF CKK_AES CKK_BLOWFISH CKK_TWOFISH CKK_SECURID CKK_HOTP CKK_ACTI
CKK_CAMELLIA CKK_ARIA CKK_VENDOR_DEFINED CKC_X_509 CKC_X_509_ATTR_CERT CKC_WTLS
CKC_VENDOR_DEFINED CKF_ARRAY_ATTRIBUTE CK_OTP_FORMAT_DECIMAL
CK_OTP_FORMAT_HEXADECIMAL CK_OTP_FORMAT_ALPHANUMERIC CK_OTP_FORMAT_BINARY
CK_OTP_PARAM_IGNORED CK_OTP_PARAM_OPTIONAL CK_OTP_PARAM_MANDATORY CKA_CLASS
CKA_TOKEN CKA_PRIVATE CKA_LABEL CKA_APPLICATION CKA_VALUE CKA_OBJECT_ID
CKA_CERTIFICATE_TYPE CKA_ISSUER CKA_SERIAL_NUMBER CKA_AC_ISSUER CKA_OWNER
CKA_ATTR_TYPES CKA_TRUSTED CKA_CERTIFICATE_CATEGORY
CKA_JAVA_MIDP_SECURITY_DOMAIN CKA_URL CKA_HASH_OF_SUBJECT_PUBLIC_KEY
CKA_HASH_OF_ISSUER_PUBLIC_KEY CKA_CHECK_VALUE CKA_KEY_TYPE CKA_SUBJECT CKA_ID
CKA_SENSITIVE CKA_ENCRYPT CKA_DECRYPT CKA_WRAP CKA_UNWRAP CKA_SIGN
CKA_SIGN_RECOVER CKA_VERIFY CKA_VERIFY_RECOVER CKA_DERIVE CKA_START_DATE
CKA_END_DATE CKA_MODULUS CKA_MODULUS_BITS CKA_PUBLIC_EXPONENT
CKA_PRIVATE_EXPONENT CKA_PRIME_1 CKA_PRIME_2 CKA_EXPONENT_1 CKA_EXPONENT_2
CKA_COEFFICIENT CKA_PRIME CKA_SUBPRIME CKA_BASE CKA_PRIME_BITS
CKA_SUBPRIME_BITS CKA_SUB_PRIME_BITS CKA_VALUE_BITS CKA_VALUE_LEN
CKA_EXTRACTABLE CKA_LOCAL CKA_NEVER_EXTRACTABLE CKA_ALWAYS_SENSITIVE
CKA_KEY_GEN_MECHANISM CKA_MODIFIABLE CKA_ECDSA_PARAMS CKA_EC_PARAMS
CKA_EC_POINT CKA_SECONDARY_AUTH CKA_AUTH_PIN_FLAGS CKA_ALWAYS_AUTHENTICATE
CKA_WRAP_WITH_TRUSTED CKA_WRAP_TEMPLATE CKA_UNWRAP_TEMPLATE CKA_OTP_FORMAT
CKA_OTP_LENGTH CKA_OTP_TIME_INTERVAL CKA_OTP_USER_FRIENDLY_MODE
CKA_OTP_CHALLENGE_REQUIREMENT CKA_OTP_TIME_REQUIREMENT
CKA_OTP_COUNTER_REQUIREMENT CKA_OTP_PIN_REQUIREMENT CKA_OTP_COUNTER
CKA_OTP_TIME CKA_OTP_USER_IDENTIFIER CKA_OTP_SERVICE_IDENTIFIER
CKA_OTP_SERVICE_LOGO CKA_OTP_SERVICE_LOGO_TYPE CKA_HW_FEATURE_TYPE
CKA_RESET_ON_INIT CKA_HAS_RESET CKA_PIXEL_X CKA_PIXEL_Y CKA_RESOLUTION
CKA_CHAR_ROWS CKA_CHAR_COLUMNS CKA_COLOR CKA_BITS_PER_PIXEL CKA_CHAR_SETS
CKA_ENCODING_METHODS CKA_MIME_TYPES CKA_MECHANISM_TYPE
CKA_REQUIRED_CMS_ATTRIBUTES CKA_DEFAULT_CMS_ATTRIBUTES
CKA_SUPPORTED_CMS_ATTRIBUTES CKA_ALLOWED_MECHANISMS CKA_VENDOR_DEFINED
CKM_RSA_PKCS_KEY_PAIR_GEN CKM_RSA_PKCS CKM_RSA_9796 CKM_RSA_X_509
CKM_MD2_RSA_PKCS CKM_MD5_RSA_PKCS CKM_SHA1_RSA_PKCS CKM_RIPEMD128_RSA_PKCS
CKM_RIPEMD160_RSA_PKCS CKM_RSA_PKCS_OAEP CKM_RSA_X9_31_KEY_PAIR_GEN
CKM_RSA_X9_31 CKM_SHA1_RSA_X9_31 CKM_RSA_PKCS_PSS CKM_SHA1_RSA_PKCS_PSS
CKM_DSA_KEY_PAIR_GEN CKM_DSA CKM_DSA_SHA1 CKM_DH_PKCS_KEY_PAIR_GEN
CKM_DH_PKCS_DERIVE CKM_X9_42_DH_KEY_PAIR_GEN CKM_X9_42_DH_DERIVE
CKM_X9_42_DH_HYBRID_DERIVE CKM_X9_42_MQV_DERIVE CKM_SHA256_RSA_PKCS
CKM_SHA384_RSA_PKCS CKM_SHA512_RSA_PKCS CKM_SHA256_RSA_PKCS_PSS
CKM_SHA384_RSA_PKCS_PSS CKM_SHA512_RSA_PKCS_PSS CKM_SHA224_RSA_PKCS
CKM_SHA224_RSA_PKCS_PSS CKM_RC2_KEY_GEN CKM_RC2_ECB CKM_RC2_CBC CKM_RC2_MAC
CKM_RC2_MAC_GENERAL CKM_RC2_CBC_PAD CKM_RC4_KEY_GEN CKM_RC4 CKM_DES_KEY_GEN
CKM_DES_ECB CKM_DES_CBC CKM_DES_MAC CKM_DES_MAC_GENERAL CKM_DES_CBC_PAD
CKM_DES2_KEY_GEN CKM_DES3_KEY_GEN CKM_DES3_ECB CKM_DES3_CBC CKM_DES3_MAC
CKM_DES3_MAC_GENERAL CKM_DES3_CBC_PAD CKM_CDMF_KEY_GEN CKM_CDMF_ECB
CKM_CDMF_CBC CKM_CDMF_MAC CKM_CDMF_MAC_GENERAL CKM_CDMF_CBC_PAD CKM_DES_OFB64
CKM_DES_OFB8 CKM_DES_CFB64 CKM_DES_CFB8 CKM_MD2 CKM_MD2_HMAC
CKM_MD2_HMAC_GENERAL CKM_MD5 CKM_MD5_HMAC CKM_MD5_HMAC_GENERAL CKM_SHA_1
CKM_SHA_1_HMAC CKM_SHA_1_HMAC_GENERAL CKM_RIPEMD128 CKM_RIPEMD128_HMAC
CKM_RIPEMD128_HMAC_GENERAL CKM_RIPEMD160 CKM_RIPEMD160_HMAC
CKM_RIPEMD160_HMAC_GENERAL CKM_SHA256 CKM_SHA256_HMAC CKM_SHA256_HMAC_GENERAL
CKM_SHA224 CKM_SHA224_HMAC CKM_SHA224_HMAC_GENERAL CKM_SHA384 CKM_SHA384_HMAC
CKM_SHA384_HMAC_GENERAL CKM_SHA512 CKM_SHA512_HMAC CKM_SHA512_HMAC_GENERAL
CKM_SECURID_KEY_GEN CKM_SECURID CKM_HOTP_KEY_GEN CKM_HOTP CKM_ACTI
CKM_ACTI_KEY_GEN CKM_CAST_KEY_GEN CKM_CAST_ECB CKM_CAST_CBC CKM_CAST_MAC
CKM_CAST_MAC_GENERAL CKM_CAST_CBC_PAD CKM_CAST3_KEY_GEN CKM_CAST3_ECB
CKM_CAST3_CBC CKM_CAST3_MAC CKM_CAST3_MAC_GENERAL CKM_CAST3_CBC_PAD
CKM_CAST5_KEY_GEN CKM_CAST128_KEY_GEN CKM_CAST5_ECB CKM_CAST128_ECB
CKM_CAST5_CBC CKM_CAST128_CBC CKM_CAST5_MAC CKM_CAST128_MAC
CKM_CAST5_MAC_GENERAL CKM_CAST128_MAC_GENERAL CKM_CAST5_CBC_PAD
CKM_CAST128_CBC_PAD CKM_RC5_KEY_GEN CKM_RC5_ECB CKM_RC5_CBC CKM_RC5_MAC
CKM_RC5_MAC_GENERAL CKM_RC5_CBC_PAD CKM_IDEA_KEY_GEN CKM_IDEA_ECB CKM_IDEA_CBC
CKM_IDEA_MAC CKM_IDEA_MAC_GENERAL CKM_IDEA_CBC_PAD CKM_GENERIC_SECRET_KEY_GEN
CKM_CONCATENATE_BASE_AND_KEY CKM_CONCATENATE_BASE_AND_DATA
CKM_CONCATENATE_DATA_AND_BASE CKM_XOR_BASE_AND_DATA CKM_EXTRACT_KEY_FROM_KEY
CKM_SSL3_PRE_MASTER_KEY_GEN CKM_SSL3_MASTER_KEY_DERIVE
CKM_SSL3_KEY_AND_MAC_DERIVE CKM_SSL3_MASTER_KEY_DERIVE_DH
CKM_TLS_PRE_MASTER_KEY_GEN CKM_TLS_MASTER_KEY_DERIVE CKM_TLS_KEY_AND_MAC_DERIVE
CKM_TLS_MASTER_KEY_DERIVE_DH CKM_TLS_PRF CKM_SSL3_MD5_MAC CKM_SSL3_SHA1_MAC
CKM_MD5_KEY_DERIVATION CKM_MD2_KEY_DERIVATION CKM_SHA1_KEY_DERIVATION
CKM_SHA256_KEY_DERIVATION CKM_SHA384_KEY_DERIVATION CKM_SHA512_KEY_DERIVATION
CKM_SHA224_KEY_DERIVATION CKM_PBE_MD2_DES_CBC CKM_PBE_MD5_DES_CBC
CKM_PBE_MD5_CAST_CBC CKM_PBE_MD5_CAST3_CBC CKM_PBE_MD5_CAST5_CBC
CKM_PBE_MD5_CAST128_CBC CKM_PBE_SHA1_CAST5_CBC CKM_PBE_SHA1_CAST128_CBC
CKM_PBE_SHA1_RC4_128 CKM_PBE_SHA1_RC4_40 CKM_PBE_SHA1_DES3_EDE_CBC
CKM_PBE_SHA1_DES2_EDE_CBC CKM_PBE_SHA1_RC2_128_CBC CKM_PBE_SHA1_RC2_40_CBC
CKM_PKCS5_PBKD2 CKM_PBA_SHA1_WITH_SHA1_HMAC CKM_WTLS_PRE_MASTER_KEY_GEN
CKM_WTLS_MASTER_KEY_DERIVE CKM_WTLS_MASTER_KEY_DERIVE_DH_ECC CKM_WTLS_PRF
CKM_WTLS_SERVER_KEY_AND_MAC_DERIVE CKM_WTLS_CLIENT_KEY_AND_MAC_DERIVE
CKM_KEY_WRAP_LYNKS CKM_KEY_WRAP_SET_OAEP CKM_CMS_SIG CKM_KIP_DERIVE
CKM_KIP_WRAP CKM_KIP_MAC CKM_CAMELLIA_KEY_GEN CKM_CAMELLIA_ECB CKM_CAMELLIA_CBC
CKM_CAMELLIA_MAC CKM_CAMELLIA_MAC_GENERAL CKM_CAMELLIA_CBC_PAD
CKM_CAMELLIA_ECB_ENCRYPT_DATA CKM_CAMELLIA_CBC_ENCRYPT_DATA CKM_CAMELLIA_CTR
CKM_ARIA_KEY_GEN CKM_ARIA_ECB CKM_ARIA_CBC CKM_ARIA_MAC CKM_ARIA_MAC_GENERAL
CKM_ARIA_CBC_PAD CKM_ARIA_ECB_ENCRYPT_DATA CKM_ARIA_CBC_ENCRYPT_DATA
CKM_SKIPJACK_KEY_GEN CKM_SKIPJACK_ECB64 CKM_SKIPJACK_CBC64 CKM_SKIPJACK_OFB64
CKM_SKIPJACK_CFB64 CKM_SKIPJACK_CFB32 CKM_SKIPJACK_CFB16 CKM_SKIPJACK_CFB8
CKM_SKIPJACK_WRAP CKM_SKIPJACK_PRIVATE_WRAP CKM_SKIPJACK_RELAYX
CKM_KEA_KEY_PAIR_GEN CKM_KEA_KEY_DERIVE CKM_FORTEZZA_TIMESTAMP
CKM_BATON_KEY_GEN CKM_BATON_ECB128 CKM_BATON_ECB96 CKM_BATON_CBC128
CKM_BATON_COUNTER CKM_BATON_SHUFFLE CKM_BATON_WRAP CKM_ECDSA_KEY_PAIR_GEN
CKM_EC_KEY_PAIR_GEN CKM_ECDSA CKM_ECDSA_SHA1 CKM_ECDH1_DERIVE
CKM_ECDH1_COFACTOR_DERIVE CKM_ECMQV_DERIVE CKM_JUNIPER_KEY_GEN
CKM_JUNIPER_ECB128 CKM_JUNIPER_CBC128 CKM_JUNIPER_COUNTER CKM_JUNIPER_SHUFFLE
CKM_JUNIPER_WRAP CKM_FASTHASH CKM_AES_KEY_GEN CKM_AES_ECB CKM_AES_CBC
CKM_AES_MAC CKM_AES_MAC_GENERAL CKM_AES_CBC_PAD CKM_AES_CTR
CKM_BLOWFISH_KEY_GEN CKM_BLOWFISH_CBC CKM_TWOFISH_KEY_GEN CKM_TWOFISH_CBC
CKM_DES_ECB_ENCRYPT_DATA CKM_DES_CBC_ENCRYPT_DATA CKM_DES3_ECB_ENCRYPT_DATA
CKM_DES3_CBC_ENCRYPT_DATA CKM_AES_ECB_ENCRYPT_DATA CKM_AES_CBC_ENCRYPT_DATA
CKM_DSA_PARAMETER_GEN CKM_DH_PKCS_PARAMETER_GEN CKM_X9_42_DH_PARAMETER_GEN
CKM_VENDOR_DEFINED CKF_HW CKF_ENCRYPT CKF_DECRYPT CKF_DIGEST CKF_SIGN
CKF_SIGN_RECOVER CKF_VERIFY CKF_VERIFY_RECOVER CKF_GENERATE
CKF_GENERATE_KEY_PAIR CKF_WRAP CKF_UNWRAP CKF_DERIVE CKF_EC_F_P CKF_EC_F_2M
CKF_EC_ECPARAMETERS CKF_EC_NAMEDCURVE CKF_EC_UNCOMPRESS CKF_EC_COMPRESS
CKF_EXTENSION CKR_OK CKR_CANCEL CKR_HOST_MEMORY CKR_SLOT_ID_INVALID
CKR_GENERAL_ERROR CKR_FUNCTION_FAILED CKR_ARGUMENTS_BAD CKR_NO_EVENT
CKR_NEED_TO_CREATE_THREADS CKR_CANT_LOCK CKR_ATTRIBUTE_READ_ONLY
CKR_ATTRIBUTE_SENSITIVE CKR_ATTRIBUTE_TYPE_INVALID CKR_ATTRIBUTE_VALUE_INVALID
CKR_DATA_INVALID CKR_DATA_LEN_RANGE CKR_DEVICE_ERROR CKR_DEVICE_MEMORY
CKR_DEVICE_REMOVED CKR_ENCRYPTED_DATA_INVALID CKR_ENCRYPTED_DATA_LEN_RANGE
CKR_FUNCTION_CANCELED CKR_FUNCTION_NOT_PARALLEL CKR_FUNCTION_NOT_SUPPORTED
CKR_KEY_HANDLE_INVALID CKR_KEY_SIZE_RANGE CKR_KEY_TYPE_INCONSISTENT
CKR_KEY_NOT_NEEDED CKR_KEY_CHANGED CKR_KEY_NEEDED CKR_KEY_INDIGESTIBLE
CKR_KEY_FUNCTION_NOT_PERMITTED CKR_KEY_NOT_WRAPPABLE CKR_KEY_UNEXTRACTABLE
CKR_MECHANISM_INVALID CKR_MECHANISM_PARAM_INVALID CKR_OBJECT_HANDLE_INVALID
CKR_OPERATION_ACTIVE CKR_OPERATION_NOT_INITIALIZED CKR_PIN_INCORRECT
CKR_PIN_INVALID CKR_PIN_LEN_RANGE CKR_PIN_EXPIRED CKR_PIN_LOCKED
CKR_SESSION_CLOSED CKR_SESSION_COUNT CKR_SESSION_HANDLE_INVALID
CKR_SESSION_PARALLEL_NOT_SUPPORTED CKR_SESSION_READ_ONLY CKR_SESSION_EXISTS
CKR_SESSION_READ_ONLY_EXISTS CKR_SESSION_READ_WRITE_SO_EXISTS
CKR_SIGNATURE_INVALID CKR_SIGNATURE_LEN_RANGE CKR_TEMPLATE_INCOMPLETE
CKR_TEMPLATE_INCONSISTENT CKR_TOKEN_NOT_PRESENT CKR_TOKEN_NOT_RECOGNIZED
CKR_TOKEN_WRITE_PROTECTED CKR_UNWRAPPING_KEY_HANDLE_INVALID
CKR_UNWRAPPING_KEY_SIZE_RANGE CKR_UNWRAPPING_KEY_TYPE_INCONSISTENT
CKR_USER_ALREADY_LOGGED_IN CKR_USER_NOT_LOGGED_IN CKR_USER_PIN_NOT_INITIALIZED
CKR_USER_TYPE_INVALID CKR_USER_ANOTHER_ALREADY_LOGGED_IN
CKR_USER_TOO_MANY_TYPES CKR_WRAPPED_KEY_INVALID CKR_WRAPPED_KEY_LEN_RANGE
CKR_WRAPPING_KEY_HANDLE_INVALID CKR_WRAPPING_KEY_SIZE_RANGE
CKR_WRAPPING_KEY_TYPE_INCONSISTENT CKR_RANDOM_SEED_NOT_SUPPORTED
CKR_RANDOM_NO_RNG CKR_DOMAIN_PARAMS_INVALID CKR_BUFFER_TOO_SMALL
CKR_SAVED_STATE_INVALID CKR_INFORMATION_SENSITIVE CKR_STATE_UNSAVEABLE
CKR_CRYPTOKI_NOT_INITIALIZED CKR_CRYPTOKI_ALREADY_INITIALIZED CKR_MUTEX_BAD
CKR_MUTEX_NOT_LOCKED CKR_NEW_PIN_MODE CKR_NEXT_OTP CKR_FUNCTION_REJECTED
CKR_VENDOR_DEFINED CKF_LIBRARY_CANT_CREATE_OS_THREADS CKF_OS_LOCKING_OK
CKF_DONT_BLOCK CKG_MGF1_SHA1 CKG_MGF1_SHA256 CKG_MGF1_SHA384 CKG_MGF1_SHA512
CKG_MGF1_SHA224 CKZ_DATA_SPECIFIED CKD_NULL CKD_SHA1_KDF CKD_SHA1_KDF_ASN1
CKD_SHA1_KDF_CONCATENATE CKP_PKCS5_PBKD2_HMAC_SHA1 CKZ_SALT_SPECIFIED
CK_OTP_VALUE CK_OTP_PIN CK_OTP_CHALLENGE CK_OTP_TIME CK_OTP_COUNTER
CK_OTP_FLAGS CK_OTP_OUTPUT_LENGTH CK_OTP_OUTPUT_FORMAT CKF_NEXT_OTP
CKF_EXCLUDE_TIME CKF_EXCLUDE_COUNTER CKF_EXCLUDE_CHALLENGE CKF_EXCLUDE_PIN
CKF_USER_FRIENDLY_OTP

CKF_ERROR_STATE CKK_MD5_HMAC CKK_SHA_1_HMAC CKK_RIPEMD128_HMAC
CKK_RIPEMD160_HMAC CKK_SHA256_HMAC CKK_SHA384_HMAC CKK_SHA512_HMAC
CKK_SHA224_HMAC CKK_SEED CKK_GOSTR3410 CKK_GOSTR3411 CKK_GOST28147
CKA_DERIVE_TEMPLATE CKA_GOSTR3410_PARAMS CKA_GOSTR3411_PARAMS
CKA_GOST28147_PARAMS CKM_DSA_SHA224 CKM_DSA_SHA256 CKM_DSA_SHA384
CKM_DSA_SHA512 CKM_DES3_CMAC_GENERAL CKM_DES3_CMAC CKM_SEED_KEY_GEN
CKM_SEED_ECB CKM_SEED_CBC CKM_SEED_MAC CKM_SEED_MAC_GENERAL CKM_SEED_CBC_PAD
CKM_SEED_ECB_ENCRYPT_DATA CKM_SEED_CBC_ENCRYPT_DATA CKM_ECDSA_SHA224
CKM_ECDSA_SHA256 CKM_ECDSA_SHA384 CKM_ECDSA_SHA512 CKM_AES_CTS CKM_AES_CMAC
CKM_AES_CMAC_GENERAL CKM_AES_GCM CKM_AES_CCM CKM_AES_KEY_WRAP
CKM_AES_KEY_WRAP_PAD CKM_BLOWFISH_CBC_PAD CKM_TWOFISH_CBC_PAD
CKM_GOSTR3410_KEY_PAIR_GEN CKM_GOSTR3410 CKM_GOSTR3410_WITH_GOSTR3411
CKM_GOSTR3410_KEY_WRAP CKM_GOSTR3410_DERIVE CKM_GOSTR3411 CKM_GOSTR3411_HMAC
CKM_GOST28147_KEY_GEN CKM_GOST28147_ECB CKM_GOST28147 CKM_GOST28147_MAC
CKM_GOST28147_KEY_WRAP CKM_AES_OFB CKM_AES_CFB64 CKM_AES_CFB8 CKM_AES_CFB128
CKM_RSA_PKCS_TPM_1_1 CKM_RSA_PKCS_OAEP_TPM_1_1 CKR_EXCEEDED_MAX_ITERATIONS
CKR_FIPS_SELF_TEST_FAILED CKR_LIBRARY_LOAD_FAILED CKR_PIN_TOO_WEAK
CKR_PUBLIC_KEY_INVALID CKD_SHA224_KDF CKD_SHA256_KDF CKD_SHA384_KDF
CKD_SHA512_KDF CKD_CPDIVERSIFY_KDF

CKA_NAME_HASH_ALGORITHM CKA_COPYABLE)],
        constant_names => [qw(
%CKA_NAME %CKC_NAME %CKD_NAME %CKF_NAME %CKG_NAME %CKH_NAME %CKK_NAME %CKM_NAME
%CKN_NAME %CKO_NAME %CKP_NAME %CKR_NAME %CKS_NAME %CKU_NAME %CKZ_NAME
        )]
    );
    @EXPORT_OK = (
        @{ $EXPORT_TAGS{constant} },
        @{ $EXPORT_TAGS{constant_names} }
    );
}

require XSLoader;
XSLoader::load('Crypt::PKCS11', $VERSION);

use Crypt::PKCS11::Session;

sub new {
    my $this = shift;
    my $class = ref($this) || $this;
    my $self = {
        pkcs11xs => undef,
        rv => CKR_OK
    };
    bless $self, $class;

    # uncoverable branch true
    unless (defined($self->{pkcs11xs} = Crypt::PKCS11::XS->new())) {
        confess __PACKAGE__, 'Unable to create Crypt::PKCS11::XS object';
    }

    return $self;
}

END {
    Crypt::PKCS11::XS::clearCreateMutex();
    Crypt::PKCS11::XS::clearDestroyMutex();
    Crypt::PKCS11::XS::clearLockMutex();
    Crypt::PKCS11::XS::clearUnlockMutex();
}

sub load {
    my ($self, $so) = @_;

    unless (defined $so) {
        confess '$so must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->load($so);
    return $self->{rv} == CKR_OK ? 1 : undef;
}

sub unload {
    my ($self) = @_;

    $self->{rv} = $self->{pkcs11xs}->unload;
    return $self->{rv} == CKR_OK ? 1 : undef;
}

sub Initialize {
    my ($self) = shift;
    my $args;

    if (scalar @_ == 1) {
        unless (ref($_[0]) eq 'HASH') {
            confess 'argument is not a HASH';
        }
        $args = $_[0];
    }
    else {
        $args = { @_ };
    }

    if (exists $args->{CreateMutex}
        or exists $args->{DestroyMutex}
        or exists $args->{LockMutex}
        or exists $args->{UnlockMutex})
    {
        unless (ref($args->{CreateMutex}) eq 'CODE'
            and ref($args->{DestroyMutex}) eq 'CODE'
            and ref($args->{LockMutex}) eq 'CODE'
            and ref($args->{UnlockMutex}) eq 'CODE')
        {
            confess 'Any or all of Mutex options are invalid';
        }
    }

    $self->{rv} = $self->{pkcs11xs}->C_Initialize($args);
    return $self->{rv} == CKR_OK ? 1 : undef;
}

sub Finalize {
    my ($self) = @_;

    $self->{rv} = $self->{pkcs11xs}->C_Finalize;
    return $self->{rv} == CKR_OK ? 1 : undef;
}

sub GetInfo {
    my ($self) = @_;
    my %info;

    $self->{rv} = $self->{pkcs11xs}->C_GetInfo(\%info);
    return $self->{rv} == CKR_OK ? wantarray ? %info : \%info : undef;
}

sub GetSlotList {
    my ($self, $tokenPresent) = @_;
    my @slotList;

    $self->{rv} = $self->{pkcs11xs}->C_GetSlotList($tokenPresent, \@slotList);
    return $self->{rv} == CKR_OK ? wantarray ? @slotList : \@slotList : undef;
}

sub GetSlotInfo {
    my ($self, $slotID) = @_;
    my %info;

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_GetSlotInfo($slotID, \%info);
    return $self->{rv} == CKR_OK ? wantarray ? %info : \%info : undef;
}

sub GetTokenInfo {
    my ($self, $slotID) = @_;
    my %info;

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_GetTokenInfo($slotID, \%info);
    return $self->{rv} == CKR_OK ? wantarray ? %info : \%info : undef;
}

sub GetMechanismList {
    my ($self, $slotID) = @_;
    my @mechanismList;

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_GetMechanismList($slotID, \@mechanismList);
    return $self->{rv} == CKR_OK ? wantarray ? @mechanismList : \@mechanismList : undef;
}

sub GetMechanismInfo {
    my ($self, $slotID, $mechanismType) = @_;
    my %info;

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }
    unless (defined $mechanismType) {
        confess '$mechanismType must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_GetMechanismInfo($slotID, $mechanismType, \%info);
    return $self->{rv} == CKR_OK ? wantarray ? %info : \%info : undef;
}

sub InitToken {
    my $self = shift;
    my ($slotID, $pin, $label);

    if (scalar @_ == 2) {
        ($slotID, $label) = @_;
    }
    else {
        ($slotID, $pin, $label) = @_;
    }

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }
    unless (defined $label) {
        confess '$label must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_InitToken($slotID, $pin, $label);
    return $self->{rv} == CKR_OK ? 1 : undef;
}

sub OpenSession {
    my ($self, $slotID, $flags, $notifycb) = @_;
    my $session;

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }
    if (defined $notifycb and ref($notifycb) ne 'CODE') {
        confess '$notifycb must be CODE if defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_OpenSession($slotID, defined $flags ? $flags : 0, $notifycb, $session);
    return $self->{rv} == CKR_OK ? Crypt::PKCS11::Session->new($self->{pkcs11xs}, $session) : undef;
}

sub CloseAllSessions {
    my ($self, $slotID) = @_;

    unless (defined $slotID) {
        confess '$slotID must be defined';
    }

    $self->{rv} = $self->{pkcs11xs}->C_CloseAllSessions($slotID);
    return $self->{rv} == CKR_OK ? 1 : undef;
}

sub WaitForSlotEvent {
    my ($self, $flags) = @_;
    my $slotID;

    $self->{rv} = $self->{pkcs11xs}->C_WaitForSlotEvent(defined $flags ? $flags : 0, $slotID);
    # uncoverable branch true
    return $self->{rv} == CKR_OK ? $slotID : undef;
}

sub errno {
    return $_[0]->{rv};
}

sub errstr {
    return Crypt::PKCS11::XS::rv2str($_[0]->{rv});
}

package Crypt::PKCS11::struct;
use Carp;
sub toBytes {
    confess 'unimplemented';
}
package Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_AES_CCM_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_AES_CTR_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_AES_GCM_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_CMS_SIG_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KEA_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATA;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KIP_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_MECHANISM;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_OTP_PARAM;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_OTP_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_OTP_SIGNATURE_INFO;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_PBE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC2_CBC_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC5_CBC_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC5_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_KEY_MAT_OUT;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_RANDOM_DATA;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_TLS_PRF_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_VERSION;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_KEY_MAT_OUT;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_PRF_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_RANDOM_DATA;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMS;
use base qw(Crypt::PKCS11::struct);

package Crypt::PKCS11::CK_AES_CBC_ENCRYPT_DATA_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_AES_CCM_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_AES_CTR_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_AES_GCM_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ARIA_CBC_ENCRYPT_DATA_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_CAMELLIA_CBC_ENCRYPT_DATA_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_CAMELLIA_CTR_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_CMS_SIG_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_DES_CBC_ENCRYPT_DATA_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ECDH1_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ECDH2_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_ECMQV_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KEA_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KEY_DERIVATION_STRING_DATAPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KEY_WRAP_SET_OAEP_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_KIP_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_MECHANISMPtr;
use base qw(Crypt::PKCS11::struct);
use Carp;
use Crypt::PKCS11 qw(:constant);

sub toHash {
    my ($mechanism, $pParameter);

    # uncoverable branch true
    unless ($_[0]->get_mechanism($mechanism) == CKR_OK) {
        confess 'Unable to get mechanism';
    }
    # uncoverable branch true
    unless ($_[0]->get_pParameter($pParameter) == CKR_OK) {
        confess 'Unable to get pParameter';
    }

    return {
        mechanism => $mechanism,
        (defined $pParameter ? (pParameter => $pParameter) : ())
    };
}

package Crypt::PKCS11::CK_OTP_PARAMPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_OTP_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_OTP_SIGNATURE_INFOPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_PBE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_PKCS5_PBKD2_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC2_CBC_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC2_MAC_GENERAL_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC5_CBC_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC5_MAC_GENERAL_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RC5_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RSA_PKCS_OAEP_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_RSA_PKCS_PSS_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SKIPJACK_PRIVATE_WRAP_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SKIPJACK_RELAYX_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_KEY_MAT_OUTPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_KEY_MAT_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_MASTER_KEY_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_SSL3_RANDOM_DATAPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_TLS_PRF_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_VERSIONPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_KEY_MAT_OUTPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_KEY_MAT_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_MASTER_KEY_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_PRF_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_WTLS_RANDOM_DATAPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_X9_42_DH1_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_X9_42_DH2_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);
package Crypt::PKCS11::CK_X9_42_MQV_DERIVE_PARAMSPtr;
use base qw(Crypt::PKCS11::struct);

1;

__END__
