#############################################################
# This file was automatically generated on 2016-02-10.      #
#                                                           #
# Perl Bindings Version 2.1.8                               #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletRealTimeClock - Battery-backed real-time clock

=cut

package Tinkerforge::BrickletRealTimeClock;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a Real-Time Clock Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 268;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a Real-Time Clock Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'Real-Time Clock Bricklet';


=item FUNCTION_SET_DATE_TIME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DATE_TIME => 1;

=item FUNCTION_GET_DATE_TIME

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DATE_TIME => 2;

=item FUNCTION_GET_TIMESTAMP

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_TIMESTAMP => 3;

=item FUNCTION_SET_OFFSET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_OFFSET => 4;

=item FUNCTION_GET_OFFSET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_OFFSET => 5;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant WEEKDAY_MONDAY => 1;
use constant WEEKDAY_TUESDAY => 2;
use constant WEEKDAY_WEDNESDAY => 3;
use constant WEEKDAY_THURSDAY => 4;
use constant WEEKDAY_FRIDAY => 5;
use constant WEEKDAY_SATURDAY => 6;
use constant WEEKDAY_SUNDAY => 7;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0]);

	$self->{response_expected}->{&FUNCTION_SET_DATE_TIME} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DATE_TIME} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_TIMESTAMP} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_OFFSET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_OFFSET} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;



	bless($self, $class);

	return $self;
}


=item set_date_time()

Sets the current date (including weekday) and the current time with hundredths
of a second resolution.

Possible value ranges:

* Year: 2000 to 2099
* Month: 1 to 12 (January to December)
* Day: 1 to 31
* Hour: 0 to 23
* Minute: 0 to 59
* Second: 0 to 59
* Centisecond: 0 to 99
* Weekday: 1 to 7 (Monday to Sunday)

If the backup battery is installed then the real-time clock keeps date and
time even if the Bricklet is not powered by a Brick.

The real-time clock handles leap year and inserts the 29th of February
accordingly. But leap seconds, time zones and daylight saving time are not
handled.

=cut

sub set_date_time
{
	my ($self, $year, $month, $day, $hour, $minute, $second, $centisecond, $weekday) = @_;

	$self->_send_request(&FUNCTION_SET_DATE_TIME, [$year, $month, $day, $hour, $minute, $second, $centisecond, $weekday], 'S C C C C C C C', '');
}

=item get_date_time()

Returns the current date (including weekday) and the current time of the
real-time clock with hundredths of a second resolution.

=cut

sub get_date_time
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_DATE_TIME, [], '', 'S C C C C C C C');
}

=item get_timestamp()

Returns the current date and the time of the real-time clock converted to
milliseconds. The timestamp has an effective resolution of hundredths of a
second.

=cut

sub get_timestamp
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_TIMESTAMP, [], '', 'q');
}

=item set_offset()

Sets the offset the real-time clock should compensate for in 2.17 ppm steps
between -277.76 ppm (-128) and +275.59 ppm (127).

The real-time clock time can deviate from the actual time due to the frequency
deviation of its 32.768 kHz crystal. Even without compensation (factory
default) the resulting time deviation should be at most ±20 ppm (±52.6
seconds per month).

This deviation can be calculated by comparing the same duration measured by the
real-time clock (``rtc_duration``) an accurate reference clock
(``ref_duration``).

For best results the configured offset should be set to 0 ppm first and then a
duration of at least 6 hours should be measured.

The new offset (``new_offset``) can be calculated from the currently configured
offset (``current_offset``) and the measured durations as follow::

  new_offset = current_offset - round(1000000 * (rtc_duration - ref_duration) / rtc_duration / 2.17)

If you want to calculate the offset, then we recommend using the calibration
dialog in Brick Viewer, instead of doing it manually.

The offset is saved in the EEPROM of the Bricklet and only needs to be
configured once.

=cut

sub set_offset
{
	my ($self, $offset) = @_;

	$self->_send_request(&FUNCTION_SET_OFFSET, [$offset], 'c', '');
}

=item get_offset()

Returns the offset as set by :func:`SetOffset`.

=cut

sub get_offset
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_OFFSET, [], '', 'c');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to, 
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c' or 'd'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 'Z8 Z8 a C3 C3 S');
}
=back
=cut

1;
