#############################################################
# This file was automatically generated on 2020-11-02.      #
#                                                           #
# Perl Bindings Version 2.1.28                              #
#                                                           #
# If you have a bugfix for this file and want to commit it, #
# please fix the bug in the generator. You can find a link  #
# to the generators git repository on tinkerforge.com       #
#############################################################

=pod

=encoding utf8

=head1 NAME

Tinkerforge::BrickletEPaper296x128 - Three color 296x128 e-paper display

=cut

package Tinkerforge::BrickletEPaper296x128;

use strict;
use warnings;
use Carp;
use threads;
use threads::shared;
use parent 'Tinkerforge::Device';
use Tinkerforge::IPConnection;
use Tinkerforge::Error;

=head1 CONSTANTS

=over

=item DEVICE_IDENTIFIER

This constant is used to identify a E-Paper 296x128 Bricklet.

The get_identity() subroutine and the CALLBACK_ENUMERATE callback of the
IP Connection have a device_identifier parameter to specify the Brick's or
Bricklet's type.

=cut

use constant DEVICE_IDENTIFIER => 2146;

=item DEVICE_DISPLAY_NAME

This constant represents the display name of a E-Paper 296x128 Bricklet.

=cut

use constant DEVICE_DISPLAY_NAME => 'E-Paper 296x128 Bricklet';

=item CALLBACK_DRAW_STATUS

This constant is used with the register_callback() subroutine to specify
the CALLBACK_DRAW_STATUS callback.

=cut

use constant CALLBACK_DRAW_STATUS => 11;

=item FUNCTION_DRAW

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW => 1;

=item FUNCTION_GET_DRAW_STATUS

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DRAW_STATUS => 2;

=item FUNCTION_WRITE_BLACK_WHITE_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_BLACK_WHITE_LOW_LEVEL => 3;

=item FUNCTION_READ_BLACK_WHITE_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_BLACK_WHITE_LOW_LEVEL => 4;

=item FUNCTION_WRITE_COLOR_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_COLOR_LOW_LEVEL => 5;

=item FUNCTION_READ_COLOR_LOW_LEVEL

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_COLOR_LOW_LEVEL => 6;

=item FUNCTION_FILL_DISPLAY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_FILL_DISPLAY => 7;

=item FUNCTION_DRAW_TEXT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_TEXT => 8;

=item FUNCTION_DRAW_LINE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_LINE => 9;

=item FUNCTION_DRAW_BOX

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_DRAW_BOX => 10;

=item FUNCTION_SET_UPDATE_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_UPDATE_MODE => 12;

=item FUNCTION_GET_UPDATE_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_UPDATE_MODE => 13;

=item FUNCTION_SET_DISPLAY_TYPE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_DISPLAY_TYPE => 14;

=item FUNCTION_GET_DISPLAY_TYPE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_DISPLAY_TYPE => 15;

=item FUNCTION_GET_SPITFP_ERROR_COUNT

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_SPITFP_ERROR_COUNT => 234;

=item FUNCTION_SET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_BOOTLOADER_MODE => 235;

=item FUNCTION_GET_BOOTLOADER_MODE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_BOOTLOADER_MODE => 236;

=item FUNCTION_SET_WRITE_FIRMWARE_POINTER

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_WRITE_FIRMWARE_POINTER => 237;

=item FUNCTION_WRITE_FIRMWARE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_FIRMWARE => 238;

=item FUNCTION_SET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_SET_STATUS_LED_CONFIG => 239;

=item FUNCTION_GET_STATUS_LED_CONFIG

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_STATUS_LED_CONFIG => 240;

=item FUNCTION_GET_CHIP_TEMPERATURE

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_CHIP_TEMPERATURE => 242;

=item FUNCTION_RESET

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_RESET => 243;

=item FUNCTION_WRITE_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_WRITE_UID => 248;

=item FUNCTION_READ_UID

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_READ_UID => 249;

=item FUNCTION_GET_IDENTITY

This constant is used with the get_response_expected(), set_response_expected()
and set_response_expected_all() subroutines.

=cut

use constant FUNCTION_GET_IDENTITY => 255;
use constant DRAW_STATUS_IDLE => 0;
use constant DRAW_STATUS_COPYING => 1;
use constant DRAW_STATUS_DRAWING => 2;
use constant COLOR_BLACK => 0;
use constant COLOR_WHITE => 1;
use constant COLOR_RED => 2;
use constant COLOR_GRAY => 2;
use constant FONT_6X8 => 0;
use constant FONT_6X16 => 1;
use constant FONT_6X24 => 2;
use constant FONT_6X32 => 3;
use constant FONT_12X16 => 4;
use constant FONT_12X24 => 5;
use constant FONT_12X32 => 6;
use constant FONT_18X24 => 7;
use constant FONT_18X32 => 8;
use constant FONT_24X32 => 9;
use constant ORIENTATION_HORIZONTAL => 0;
use constant ORIENTATION_VERTICAL => 1;
use constant UPDATE_MODE_DEFAULT => 0;
use constant UPDATE_MODE_BLACK_WHITE => 1;
use constant UPDATE_MODE_DELTA => 2;
use constant DISPLAY_TYPE_BLACK_WHITE_RED => 0;
use constant DISPLAY_TYPE_BLACK_WHITE_GRAY => 1;
use constant BOOTLOADER_MODE_BOOTLOADER => 0;
use constant BOOTLOADER_MODE_FIRMWARE => 1;
use constant BOOTLOADER_MODE_BOOTLOADER_WAIT_FOR_REBOOT => 2;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_REBOOT => 3;
use constant BOOTLOADER_MODE_FIRMWARE_WAIT_FOR_ERASE_AND_REBOOT => 4;
use constant BOOTLOADER_STATUS_OK => 0;
use constant BOOTLOADER_STATUS_INVALID_MODE => 1;
use constant BOOTLOADER_STATUS_NO_CHANGE => 2;
use constant BOOTLOADER_STATUS_ENTRY_FUNCTION_NOT_PRESENT => 3;
use constant BOOTLOADER_STATUS_DEVICE_IDENTIFIER_INCORRECT => 4;
use constant BOOTLOADER_STATUS_CRC_MISMATCH => 5;
use constant STATUS_LED_CONFIG_OFF => 0;
use constant STATUS_LED_CONFIG_ON => 1;
use constant STATUS_LED_CONFIG_SHOW_HEARTBEAT => 2;
use constant STATUS_LED_CONFIG_SHOW_STATUS => 3;


=back

=head1 FUNCTIONS

=over

=item new()

Creates an object with the unique device ID *uid* and adds it to
the IP Connection *ipcon*.

=cut

sub new
{
	my ($class, $uid, $ipcon) = @_;

	my $self = Tinkerforge::Device->_new($uid, $ipcon, [2, 0, 0], &DEVICE_IDENTIFIER, &DEVICE_DISPLAY_NAME);

	$self->{response_expected}->{&FUNCTION_DRAW} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DRAW_STATUS} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_WRITE_BLACK_WHITE_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_BLACK_WHITE_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_WRITE_COLOR_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_TRUE;
	$self->{response_expected}->{&FUNCTION_READ_COLOR_LOW_LEVEL} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_FILL_DISPLAY} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRAW_TEXT} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRAW_LINE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_DRAW_BOX} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_SET_UPDATE_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_UPDATE_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_DISPLAY_TYPE} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_DISPLAY_TYPE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_SPITFP_ERROR_COUNT} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_BOOTLOADER_MODE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_WRITE_FIRMWARE_POINTER} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_FIRMWARE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_SET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_GET_STATUS_LED_CONFIG} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_CHIP_TEMPERATURE} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_RESET} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_WRITE_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_FALSE;
	$self->{response_expected}->{&FUNCTION_READ_UID} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;
	$self->{response_expected}->{&FUNCTION_GET_IDENTITY} = Tinkerforge::Device->_RESPONSE_EXPECTED_ALWAYS_TRUE;

	$self->{callback_formats}->{&CALLBACK_DRAW_STATUS} = shared_clone([9, 'C']);



	bless($self, $class);

	$ipcon->_add_device($self);

	return $self;
}


=item draw()

Draws the current black/white and red or gray buffer to the e-paper display.

The Bricklet does not have any double-buffering. You should not call
this function while writing to the buffer. See :func:`Get Draw Status`.

=cut

sub draw
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DRAW, [], '', 0, '');
}

=item get_draw_status()

Returns one of three draw statuses:

* Idle
* Copying: Data is being copied from the buffer of the Bricklet to the buffer of the display.
* Drawing: The display is updating its content (during this phase the flickering etc happens).

You can write to the buffer (through one of the write or draw functions) when the status is
either *idle* or *drawing*. You should not write to the buffer while it is being *copied* to the
display. There is no double-buffering.

=cut

sub get_draw_status
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DRAW_STATUS, [], '', 9, 'C');
}

=item write_black_white_low_level()

Writes black/white pixels to the specified window into the buffer.

The pixels are written into the window line by line top to bottom
and each line is written from left to right.

The value 0 (false) corresponds to a black pixel and the value 1 (true) to a
white pixel.

This function writes the pixels into the black/white pixel buffer, to draw the
buffer to the display use :func:`Draw`.

Use :func:`Write Color` to write red or gray pixels.

=cut

sub write_black_white_low_level
{
	my ($self, $x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_BLACK_WHITE_LOW_LEVEL, [$x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data], 'S C S C S S ?432', 0, '');
}

=item read_black_white_low_level()

Returns the current content of the black/white pixel buffer for the specified window.

The pixels are read into the window line by line top to bottom and
each line is read from left to right.

The current content of the buffer does not have to be the current content of the display.
It is possible that the data was not drawn to the display yet and after a restart of
the Bricklet the buffer will be reset to black, while the display retains its content.

=cut

sub read_black_white_low_level
{
	my ($self, $x_start, $y_start, $x_end, $y_end) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_BLACK_WHITE_LOW_LEVEL, [$x_start, $y_start, $x_end, $y_end], 'S C S C', 70, 'S S ?464');
}

=item write_color_low_level()

The E-Paper 296x128 Bricklet is available with the colors black/white/red and
black/white/gray. Depending on the model this function writes either red or
gray pixels to the specified window into the buffer.

The pixels are written into the window line by line top to bottom
and each line is written from left to right.

The value 0 (false) means that this pixel does not have color. It will be either black
or white (see :func:`Write Black White`). The value 1 (true) corresponds to a red or gray
pixel, depending on the Bricklet model.

This function writes the pixels into the red or gray pixel buffer, to draw the buffer
to the display use :func:`Draw`.

Use :func:`Write Black White` to write black/white pixels.

=cut

sub write_color_low_level
{
	my ($self, $x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_COLOR_LOW_LEVEL, [$x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data], 'S C S C S S ?432', 0, '');
}

=item read_color_low_level()

Returns the current content of the red or gray pixel buffer for the specified window.

The pixels are written into the window line by line top to bottom
and each line is written from left to right.

The current content of the buffer does not have to be the current content of the display.
It is possible that the data was not drawn to the display yet and after a restart of
the Bricklet the buffer will be reset to black, while the display retains its content.

=cut

sub read_color_low_level
{
	my ($self, $x_start, $y_start, $x_end, $y_end) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_COLOR_LOW_LEVEL, [$x_start, $y_start, $x_end, $y_end], 'S C S C', 70, 'S S ?464');
}

=item fill_display()

Fills the complete content of the display with the given color.

This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
to the display use :func:`Draw`.

=cut

sub fill_display
{
	my ($self, $color) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_FILL_DISPLAY, [$color], 'C', 0, '');
}

=item draw_text()

Draws a text with up to 50 characters at the pixel position (x, y).

You can use one of 9 different font sizes and draw the text in
black/white/red|gray. The text can be drawn horizontal or vertical.

This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
to the display use :func:`Draw`.

=cut

sub draw_text
{
	my ($self, $position_x, $position_y, $font, $color, $orientation, $text) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DRAW_TEXT, [$position_x, $position_y, $font, $color, $orientation, $text], 'S C C C C Z50', 0, '');
}

=item draw_line()

Draws a line from (x, y)-start to (x, y)-end in the given color.

This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
to the display use :func:`Draw`.

=cut

sub draw_line
{
	my ($self, $position_x_start, $position_y_start, $position_x_end, $position_y_end, $color) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DRAW_LINE, [$position_x_start, $position_y_start, $position_x_end, $position_y_end, $color], 'S C S C C', 0, '');
}

=item draw_box()

Draws a box from (x, y)-start to (x, y)-end in the given color.

If you set fill to true, the box will be filled with the
color. Otherwise only the outline will be drawn.

This function writes the pixels into the black/white/red|gray pixel buffer, to draw the buffer
to the display use :func:`Draw`.

=cut

sub draw_box
{
	my ($self, $position_x_start, $position_y_start, $position_x_end, $position_y_end, $fill, $color) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_DRAW_BOX, [$position_x_start, $position_y_start, $position_x_end, $position_y_end, $fill, $color], 'S C S C ? C', 0, '');
}

=item set_update_mode()

.. note::
 The default update mode corresponds to the default e-paper display
 manufacturer settings. All of the other modes are experimental and
 will result in increased ghosting and possibly other long-term
 side effects.

 If you want to know more about the inner workings of an e-paper display
 take a look at this excellent video from Ben Krasnow:
 `https://www.youtube.com/watch?v=MsbiO8EAsGw <https://www.youtube.com/watch?v=MsbiO8EAsGw>`__.

 If you are not sure about this option, leave the update mode at default.

Currently there are three update modes available:

* Default: Settings as given by the manufacturer. An update will take about
  7.5 seconds and during the update the screen will flicker several times.
* Black/White: This will only update the black/white pixel. It uses the manufacturer
  settings for black/white and ignores the red or gray pixel buffer. With this mode the
  display will flicker once and it takes about 2.5 seconds. Compared to the default settings
  there is more ghosting.
* Delta: This will only update the black/white pixel. It uses an aggressive method where
  the changes are not applied for a whole buffer but only for the delta between the last
  and the next buffer. With this mode the display will not flicker during an update and
  it takes about 900-950ms. Compared to the other two settings there is more ghosting. This
  mode can be used for something like a flicker-free live update of a text.

With the black/white/red display if you use either the black/white or the delta mode,
after a while of going back and forth between black and white the white color will
start to appear red-ish or pink-ish.

If you use the aggressive delta mode and rapidly change the content, we recommend that you
change back to the default mode every few hours and in the default mode cycle between the
three available colors a few times. This will get rid of the ghosting and after that you can
go back to the delta mode with flicker-free updates.

=cut

sub set_update_mode
{
	my ($self, $update_mode) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_UPDATE_MODE, [$update_mode], 'C', 0, '');
}

=item get_update_mode()

Returns the update mode as set by :func:`Set Update Mode`.

=cut

sub get_update_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_UPDATE_MODE, [], '', 9, 'C');
}

=item set_display_type()

Sets the type of the display. The e-paper display is available
in black/white/red and black/white/gray. This will be factory set
during the flashing and testing phase. The value is saved in
non-volatile memory and will stay after a power cycle.

=cut

sub set_display_type
{
	my ($self, $display_type) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_DISPLAY_TYPE, [$display_type], 'C', 0, '');
}

=item get_display_type()

Returns the type of the e-paper display. It can either be
black/white/red or black/white/gray.

=cut

sub get_display_type
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_DISPLAY_TYPE, [], '', 9, 'C');
}

=item get_spitfp_error_count()

Returns the error count for the communication between Brick and Bricklet.

The errors are divided into

* ACK checksum errors,
* message checksum errors,
* framing errors and
* overflow errors.

The errors counts are for errors that occur on the Bricklet side. All
Bricks have a similar function that returns the errors on the Brick side.

=cut

sub get_spitfp_error_count
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_SPITFP_ERROR_COUNT, [], '', 24, 'L L L L');
}

=item set_bootloader_mode()

Sets the bootloader mode and returns the status after the requested
mode change was instigated.

You can change from bootloader mode to firmware mode and vice versa. A change
from bootloader mode to firmware mode will only take place if the entry function,
device identifier and CRC are present and correct.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_bootloader_mode
{
	my ($self, $mode) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_SET_BOOTLOADER_MODE, [$mode], 'C', 9, 'C');
}

=item get_bootloader_mode()

Returns the current bootloader mode, see :func:`Set Bootloader Mode`.

=cut

sub get_bootloader_mode
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_BOOTLOADER_MODE, [], '', 9, 'C');
}

=item set_write_firmware_pointer()

Sets the firmware pointer for :func:`Write Firmware`. The pointer has
to be increased by chunks of size 64. The data is written to flash
every 4 chunks (which equals to one page of size 256).

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub set_write_firmware_pointer
{
	my ($self, $pointer) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_WRITE_FIRMWARE_POINTER, [$pointer], 'L', 0, '');
}

=item write_firmware()

Writes 64 Bytes of firmware at the position as written by
:func:`Set Write Firmware Pointer` before. The firmware is written
to flash every 4 chunks.

You can only write firmware in bootloader mode.

This function is used by Brick Viewer during flashing. It should not be
necessary to call it in a normal user program.

=cut

sub write_firmware
{
	my ($self, $data) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_WRITE_FIRMWARE, [$data], 'C64', 9, 'C');
}

=item set_status_led_config()

Sets the status LED configuration. By default the LED shows
communication traffic between Brick and Bricklet, it flickers once
for every 10 received data packets.

You can also turn the LED permanently on/off or show a heartbeat.

If the Bricklet is in bootloader mode, the LED is will show heartbeat by default.

=cut

sub set_status_led_config
{
	my ($self, $config) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_SET_STATUS_LED_CONFIG, [$config], 'C', 0, '');
}

=item get_status_led_config()

Returns the configuration as set by :func:`Set Status LED Config`

=cut

sub get_status_led_config
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_STATUS_LED_CONFIG, [], '', 9, 'C');
}

=item get_chip_temperature()

Returns the temperature as measured inside the microcontroller. The
value returned is not the ambient temperature!

The temperature is only proportional to the real temperature and it has bad
accuracy. Practically it is only useful as an indicator for
temperature changes.

=cut

sub get_chip_temperature
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_GET_CHIP_TEMPERATURE, [], '', 10, 's');
}

=item reset()

Calling this function will reset the Bricklet. All configurations
will be lost.

After a reset you have to create new device objects,
calling functions on the existing ones will result in
undefined behavior!

=cut

sub reset
{
	my ($self) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_RESET, [], '', 0, '');
}

=item write_uid()

Writes a new UID into flash. If you want to set a new UID
you have to decode the Base58 encoded UID string into an
integer first.

We recommend that you use Brick Viewer to change the UID.

=cut

sub write_uid
{
	my ($self, $uid) = @_;

	$self->_check_validity();

	$self->_send_request(&FUNCTION_WRITE_UID, [$uid], 'L', 0, '');
}

=item read_uid()

Returns the current UID as an integer. Encode as
Base58 to get the usual string version.

=cut

sub read_uid
{
	my ($self) = @_;

	$self->_check_validity();

	return $self->_send_request(&FUNCTION_READ_UID, [], '', 12, 'L');
}

=item get_identity()

Returns the UID, the UID where the Bricklet is connected to,
the position, the hardware and firmware version as well as the
device identifier.

The position can be 'a', 'b', 'c', 'd', 'e', 'f', 'g' or 'h' (Bricklet Port).
A Bricklet connected to an :ref:`Isolator Bricklet <isolator_bricklet>` is always at
position 'z'.

The device identifier numbers can be found :ref:`here <device_identifier>`.
|device_identifier_constant|

=cut

sub get_identity
{
	my ($self) = @_;

	return $self->_send_request(&FUNCTION_GET_IDENTITY, [], '', 33, 'Z8 Z8 a C3 C3 S');
}

=item write_black_white()

Writes black/white pixels to the specified window into the buffer.

The pixels are written into the window line by line top to bottom
and each line is written from left to right.

The value 0 (false) corresponds to a black pixel and the value 1 (true) to a
white pixel.

This function writes the pixels into the black/white pixel buffer, to draw the
buffer to the display use :func:`Draw`.

Use :func:`Write Color` to write red or gray pixels.

=cut

sub write_black_white
{
    my ($self, $x_start, $y_start, $x_end, $y_end, $pixels) = @_;

    if(scalar(@{$pixels}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Pixels can be at most 65535 items long'));
    }

    my $pixels_length = scalar(@{$pixels});
    my $pixels_chunk_offset = 0;

    if($pixels_length == 0)
    {
        my $pixels_chunk_data = [0] x 432;

        $self->write_black_white_low_level($x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($pixels_chunk_offset < $pixels_length)
        {
            my $pixels_chunk_data = [];
            my $pixels_chunk_length = $pixels_length - $pixels_chunk_offset;

            if($pixels_chunk_length > 432) {
                $pixels_chunk_length = 432;
            }

            for(my $i = 0; $i < $pixels_chunk_length; $i++) {
                push(@{$pixels_chunk_data}, @{$pixels}[$pixels_chunk_offset + $i]);
            }

            if(scalar(@{$pixels_chunk_data}) < 432)
            {
                push(@{$pixels_chunk_data}, (0) x (432 - scalar(@{$pixels_chunk_data})));
            }

            $self->write_black_white_low_level($x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data);
            $pixels_chunk_offset += 432;
        }
    }
}

=item read_black_white()

Returns the current content of the black/white pixel buffer for the specified window.

The pixels are read into the window line by line top to bottom and
each line is read from left to right.

The current content of the buffer does not have to be the current content of the display.
It is possible that the data was not drawn to the display yet and after a restart of
the Bricklet the buffer will be reset to black, while the display retains its content.

=cut

sub read_black_white
{
    my ($self, $x_start, $y_start, $x_end, $y_end) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->read_black_white_low_level($x_start, $y_start, $x_end, $y_end);
    my $pixels_length = $ret[0];
    my $pixels_chunk_offset = $ret[1];
    my $pixels_out_of_sync = $pixels_chunk_offset != 0;
    my $pixels_data = $ret[2];

    while(!$pixels_out_of_sync && scalar(@{$pixels_data}) < $pixels_length)
    {
        @ret = $self->read_black_white_low_level($x_start, $y_start, $x_end, $y_end);
        $pixels_length = $ret[0];
        $pixels_chunk_offset = $ret[1];
        $pixels_out_of_sync = $pixels_chunk_offset != scalar(@{$pixels_data});
        push(@{$pixels_data}, @{$ret[2]});
    }

    if($pixels_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($pixels_chunk_offset + 464 < $pixels_length)
        {
            @ret = $self->read_black_white_low_level($x_start, $y_start, $x_end, $y_end);
            $pixels_length = $ret[0];
            $pixels_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Pixels stream is out-of-sync'));
    }

    splice(@{$pixels_data}, $pixels_length);

    return $pixels_data;
}

=item write_color()

The E-Paper 296x128 Bricklet is available with the colors black/white/red and
black/white/gray. Depending on the model this function writes either red or
gray pixels to the specified window into the buffer.

The pixels are written into the window line by line top to bottom
and each line is written from left to right.

The value 0 (false) means that this pixel does not have color. It will be either black
or white (see :func:`Write Black White`). The value 1 (true) corresponds to a red or gray
pixel, depending on the Bricklet model.

This function writes the pixels into the red or gray pixel buffer, to draw the buffer
to the display use :func:`Draw`.

Use :func:`Write Black White` to write black/white pixels.

=cut

sub write_color
{
    my ($self, $x_start, $y_start, $x_end, $y_end, $pixels) = @_;

    if(scalar(@{$pixels}) > 65535)
    {
        croak(Tinkerforge::Error->_new(Tinkerforge::Error->INVALID_PARAMETER, 'Pixels can be at most 65535 items long'));
    }

    my $pixels_length = scalar(@{$pixels});
    my $pixels_chunk_offset = 0;

    if($pixels_length == 0)
    {
        my $pixels_chunk_data = [0] x 432;

        $self->write_color_low_level($x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data);
    }
    else
    {
        lock(${$self->{stream_lock_ref}});

        while($pixels_chunk_offset < $pixels_length)
        {
            my $pixels_chunk_data = [];
            my $pixels_chunk_length = $pixels_length - $pixels_chunk_offset;

            if($pixels_chunk_length > 432) {
                $pixels_chunk_length = 432;
            }

            for(my $i = 0; $i < $pixels_chunk_length; $i++) {
                push(@{$pixels_chunk_data}, @{$pixels}[$pixels_chunk_offset + $i]);
            }

            if(scalar(@{$pixels_chunk_data}) < 432)
            {
                push(@{$pixels_chunk_data}, (0) x (432 - scalar(@{$pixels_chunk_data})));
            }

            $self->write_color_low_level($x_start, $y_start, $x_end, $y_end, $pixels_length, $pixels_chunk_offset, $pixels_chunk_data);
            $pixels_chunk_offset += 432;
        }
    }
}

=item read_color()

Returns the current content of the red or gray pixel buffer for the specified window.

The pixels are written into the window line by line top to bottom
and each line is written from left to right.

The current content of the buffer does not have to be the current content of the display.
It is possible that the data was not drawn to the display yet and after a restart of
the Bricklet the buffer will be reset to black, while the display retains its content.

=cut

sub read_color
{
    my ($self, $x_start, $y_start, $x_end, $y_end) = @_;

    lock(${$self->{stream_lock_ref}});

    my @ret = $self->read_color_low_level($x_start, $y_start, $x_end, $y_end);
    my $pixels_length = $ret[0];
    my $pixels_chunk_offset = $ret[1];
    my $pixels_out_of_sync = $pixels_chunk_offset != 0;
    my $pixels_data = $ret[2];

    while(!$pixels_out_of_sync && scalar(@{$pixels_data}) < $pixels_length)
    {
        @ret = $self->read_color_low_level($x_start, $y_start, $x_end, $y_end);
        $pixels_length = $ret[0];
        $pixels_chunk_offset = $ret[1];
        $pixels_out_of_sync = $pixels_chunk_offset != scalar(@{$pixels_data});
        push(@{$pixels_data}, @{$ret[2]});
    }

    if($pixels_out_of_sync) # discard remaining stream to bring it back in-sync
    {
        while($pixels_chunk_offset + 464 < $pixels_length)
        {
            @ret = $self->read_color_low_level($x_start, $y_start, $x_end, $y_end);
            $pixels_length = $ret[0];
            $pixels_chunk_offset = $ret[1];
        }

        croak(Tinkerforge::Error->_new(Tinkerforge::Error->STREAM_OUT_OF_SYNC, 'Pixels stream is out-of-sync'));
    }

    splice(@{$pixels_data}, $pixels_length);

    return $pixels_data;
}

=back
=cut

1;
