## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::Pl_qx v1.1.4;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::Pl_qx::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=head1 C<Pl_qx> hyphenation pattern class

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 Copyright

The copyright of the patterns is not covered by the copyright of this package
since this pattern is generated from the source at
L<svn://tug.org/texhyphen/trunk/hyph-utf8/tex/generic/hyph-utf8/patterns/ptex/hyph-pl.qx.tex>

The copyright of the source can be found in the DATA section in the source of
this package file.

=cut

__DATA__
% pTeX-friendly hyphenation patterns
%
% language: polish (pl)
% encoding: qx
%
% This file has been auto-generated from hyph-pl.tex
% with a script [texmf]/scripts/generic/hyph-utf8/generate-ptex-patterns.rb
% See the original file for details about author, licence etc.
%
\bgroup
\lccode"F3="F3
\lccode"A1="A1
\lccode"A2="A2
\lccode"A6="A6
\lccode"AA="AA
\lccode"AB="AB
\lccode"B1="B1
\lccode"B9="B9
\lccode"BB="BB
\patterns{
.^^a2^^a28
.^^a2^^aa8
.^^a2^^ab8
.^^a2^^b18
.^^a2^^b98
.^^a2^^bb8
.^^a28
.^^a2b8
.^^a2c8
.^^a2d8
.^^a2f8
.^^a2g8
.^^a2h8
.^^a2j8
.^^a2k8
.^^a2l8
.^^a2m8
.^^a2n8
.^^a2p8
.^^a2r8
.^^a2s8
.^^a2t8
.^^a2v8
.^^a2w8
.^^a2wier2^^a23
.^^a2x8
.^^a2z8
.^^aa^^a28
.^^aa^^aa8
.^^aa^^ab8
.^^aa^^b18
.^^aa^^b98
.^^aa^^bb8
.^^aa8
.^^aab8
.^^aac8
.^^aad8
.^^aaf8
.^^aag8
.^^aah8
.^^aaj8
.^^aak8
.^^aal8
.^^aam8
.^^aan8
.^^aap8
.^^aar8
.^^aas8
.^^aat8
.^^aav8
.^^aaw8
.^^aax8
.^^aaz8
.^^ab^^a28
.^^ab^^aa8
.^^ab^^ab8
.^^ab^^b18
.^^ab^^b98
.^^ab^^bb8
.^^ab8
.^^abb8
.^^abc8
.^^abd8
.^^abf8
.^^abg8
.^^abh8
.^^abj8
.^^abk8
.^^abl8
.^^abm8
.^^abn8
.^^abp8
.^^abr8
.^^abs8
.^^abt8
.^^abv8
.^^abw8
.^^abx8
.^^abz8
.^^b1^^a28
.^^b1^^aa8
.^^b1^^ab8
.^^b1^^b18
.^^b1^^b98
.^^b1^^bb8
.^^b18
.^^b1b8
.^^b1c8
.^^b1d8
.^^b1f8
.^^b1g8
.^^b1h8
.^^b1j8
.^^b1k8
.^^b1l8
.^^b1m8
.^^b1n8
.^^b1p8
.^^b1r^^f32d5
.^^b1r^^f3dr2
.^^b1r8
.^^b1s8
.^^b1t8
.^^b1v8
.^^b1w8
.^^b1wiat^^aao3w2
.^^b1x8
.^^b1z8
.^^b9^^a28
.^^b9^^aa8
.^^b9^^ab8
.^^b9^^b18
.^^b9^^b98
.^^b9^^bb8
.^^b98
.^^b9b8
.^^b9c8
.^^b9d^^b98
.^^b9d8
.^^b9f8
.^^b9g8
.^^b9h8
.^^b9j8
.^^b9k8
.^^b9l8
.^^b9m8
.^^b9n8
.^^b9p8
.^^b9r8
.^^b9s8
.^^b9t8
.^^b9v8
.^^b9w8
.^^b9x8
.^^b9z8
.^^bb^^a28
.^^bb^^aa8
.^^bb^^ab8
.^^bb^^b18
.^^bb^^b98
.^^bb^^bb8
.^^bb8
.^^bbb8
.^^bbc8
.^^bbd8
.^^bbf8
.^^bbg8
.^^bbh8
.^^bbj8
.^^bbk8
.^^bbl8
.^^bbm8
.^^bbn8
.^^bbp8
.^^bbr8
.^^bbs8
.^^bbt8
.^^bbv8
.^^bbw8
.^^bbx8
.^^bbz8
.a2b2s3t
.a2d3
.ad4a
.ad4e
.ad4i
.ad4o
.ad4u
.ad4y
.ad5apt
.ad5iu
.ad5op
.ad5or
.ae3ro
.aeroa2
.aeroe2
.aeroi2
.aeroo2
.aerou2
.antya2
.antye2
.antyi2
.antyo2
.antyu2
.arcy3^^aa2
.arcy3b2
.arcy3bz2
.arcy3k2
.arcy3m2
.arcya2
.arcye2
.arcyi2
.arcyo2
.arcyu2
.au3g2
.au3k2
.au3t2
.auto3ch2
.autoa2
.autoe2
.autoi2
.autoo2
.autotran2s3
.autou2
.b^^a28
.b^^aa8
.b^^ab8
.b^^b18
.b^^b98
.b^^bb8
.b8
.bb8
.bc8
.bd8
.be2z3
.be3z4an
.be3z4ec
.be3z4ik
.bezch2
.bezm2
.bezo2
.bezo2b1j
.bezw2
.bezzw2
.bf8
.bg8
.bh8
.bj8
.bk8
.bl8
.bm8
.bn8
.bp8
.br8
.brz8
.bs8
.bt8
.bv8
.bw8
.bx8
.bz8
.c^^a28
.c^^aa8
.c^^ab8
.c^^b18
.c^^b98
.c^^bb8
.c8
.ca^^aao3^^b12
.ca^^aao3k2
.cb8
.cc8
.cd8
.cf8
.cg8
.ch8
.chrz8
.cienko3w2
.ciep^^aao3kr2
.cj8
.ck8
.cl8
.cm8
.cn8
.cp8
.cr8
.cs8
.ct8
.cv8
.cw8
.cx8
.cz8
.czarno3k2
.czk8
.cztere2ch3
.czterechse2t3
.cztero3^^b12
.czw^^f32r3
.czw^^f33r4^^a1
.czw^^f33r4^^a6
.czw^^f33r4a
.czw^^f33r4e
.czw^^f33r4o
.d^^a28
.d^^aa8
.d^^aaugo3tr2
.d^^aaugo3w2
.d^^ab8
.d^^b18
.d^^b98
.d^^bb8
.d8
.daleko3w2
.db8
.dc8
.dd8
.de2z3
.de3z4a3bil
.de3z4a3wu
.de3z4el
.de3z4er
.de3z4y
.deza2
.dezo2
.df8
.dg8
.dh8
.dj8
.dk8
.dl8
.dm8
.dn8
.do3^^a22
.do3^^aa2
.do3^^b12
.do3^^b92
.do3^^bb2
.do3b2
.do3c2
.do3d2
.do3f2
.do3g2
.do3h2
.do3k2
.do3l2
.do3m2
.do3p2
.do3r2
.do3s2
.do3t2
.do3w2
.do3z2
.do4^^aa3k
.do4k3t
.do4l3n
.do4m3k
.do4r3s
.do4w3c
.do5m4k2n
.dobr2
.dobrz2
.doch2
.docz2
.dod^^b92
.dod^^bb2
.dodz2
.dogrz2
.dopch2
.doprz2
.dor^^bb2
.dorz2
.dosch2
.dosm2
.dosz2
.dotk2
.dotr2
.dp8
.dr8
.drogo3w2
.drz8
.ds8
.dt8
.dv8
.dw^^f32j3
.dw^^f33j4^^a1
.dw^^f33j4^^a6
.dw^^f33j4a
.dw^^f33j4e
.dw^^f33j4o
.dw8
.dx8
.dy2s3
.dy2z3
.dy3s4e
.dy3s4o
.dy3s4ta
.dy3s4y
.dy3sz
.dy3z4e
.dyzu2
.dz8
.dziesi^^a6cio3^^b12
.dziewi^^a6^^a2se2t3
.dziewi^^a62^^a23
.dziewi^^a6cio3^^b12
.e2k2s3
.e2m3e2s5ze2t
.e2s1e2s1ma
.e2s1ha
.e2s1t
.egoa2
.egoe2
.egoi2
.egoo2
.egou2
.eks4y
.elektroa2
.elektroe2
.elektroi2
.elektroo2
.elektrou2
.f^^a28
.f^^aa8
.f^^ab8
.f^^b18
.f^^b98
.f^^bb8
.f8
.fb8
.fc8
.fd8
.ff8
.fg8
.fh8
.fj8
.fk8
.fl8
.fm8
.fn8
.fp8
.fr8
.fs8
.ft8
.fv8
.fw8
.fx8
.fz8
.g^^a28
.g^^aa8
.g^^ab8
.g^^b18
.g^^b98
.g^^bb8
.g8
.gb8
.gc8
.gd8
.ge2o3
.gf8
.gg8
.gh8
.gj8
.gk8
.gl8
.gm8
.gn8
.go2u3
.gp8
.gr8
.grubo3w2
.grz8
.gs8
.gt8
.gv8
.gw8
.gx8
.gz8
.h^^a28
.h^^aa8
.h^^ab8
.h^^b18
.h^^b98
.h^^bb8
.h8
.hb8
.hc8
.hd8
.hf8
.hg8
.hh8
.hipe2r3
.hipe3r4o
.hipera2
.hipere2
.hj8
.hk8
.hl8
.hm8
.hn8
.hp8
.hr8
.hs8
.ht8
.hv8
.hw8
.hx8
.hz8
.i2n3
.i2s3l
.i3n4ic
.i3n4o
.i3n4u
.i4n5o2k
.in4f3lan
.ino3w2
.izoa2
.izoe2
.izoi2
.izoo2
.izou2
.j^^a28
.j^^aa8
.j^^ab8
.j^^b18
.j^^b98
.j^^bb8
.j8
.jad^^aao3w2
.jb8
.jc8
.jd8
.jf8
.jg8
.jh8
.jj8
.jk8
.jl8
.jm8
.jn8
.jp8
.jr8
.js8
.jt8
.jv8
.jw8
.jx8
.jz8
.k^^a28
.k^^aa8
.k^^ab8
.k^^b18
.k^^b98
.k^^bb8
.k8
.kb8
.kc8
.kd8
.kf8
.kg8
.kh8
.kilkuse2t3
.kilkuseto2
.kj8
.kk8
.kl8
.km8
.kn8
.ko^^aao3w2
.kon2t2r3
.kon3tr4a
.kon3tr4e
.kon3tr4o3l
.kon3tr4o3w
.kon3tr4y
.kon4tr5a2gi
.kon4tr5a2se
.kon4tr5a2sy
.kon4tr5a2ta
.kon4tr5adm
.kon4tr5akc
.kon4tr5alt
.kon4tr5arg
.kontro2
.kontru2
.kp8
.kr^^f3tko3tr2
.kr^^f3tko3w2
.kr8
.kro2^^a23
.krz8
.ks8
.kt8
.kv8
.kw8
.kx8
.kz8
.l^^a28
.l^^aa8
.l^^ab8
.l^^b18
.l^^b98
.l^^bb8
.l8
.lb8
.lc8
.ld8
.lf8
.lg8
.lh8
.lj8
.lk8
.ll8
.lm8
.ln8
.lp8
.lr8
.ls8
.lt8
.ludo3w2
.lv8
.lw8
.lx8
.lz8
.m^^a28
.m^^aa8
.m^^ab8
.m^^b18
.m^^b98
.m^^bb8
.m8
.mb8
.mc8
.md8
.mf8
.mg8
.mh8
.mili3amp
.mj8
.mk8
.ml8
.mm8
.mn8
.mo^^bbno3w2
.mp8
.mr8
.ms8
.mt8
.mv8
.mw8
.mx8
.mz8
.n^^a28
.n^^aa8
.n^^ab8
.n^^b18
.n^^b98
.n^^bb8
.n8
.na2d2
.na2j
.na3^^a22
.na3^^aa2
.na3^^b12
.na3^^b92
.na3^^bb2
.na3b2
.na3c2
.na3d^^a1
.na3d^^a6
.na3d^^b92
.na3d4^^aaub
.na3d4ir
.na3d4much
.na3d4r^^a6cz
.na3d4r2w
.na3d4repcz
.na3d4rept
.na3d4ruk
.na3d4rz
.na3d4worn
.na3daj
.na3de
.na3do
.na3dy
.na3dzi
.na3f2
.na3g2
.na3h2
.na3j^^a1
.na3j^^a6
.na3jazd
.na3je
.na3k2
.na3l2
.na3m2
.na3p2
.na3r2
.na3s2
.na3t2
.na3u2
.na3w2
.na3z2
.na4d3o2b2^^aa
.na4d3o2bojcz
.na4d3o2bowi
.na4d3o2brot
.na4d3o2drz
.na4d3o2kien
.na4d3olbrz
.na4d5rz^^a1
.na4d5rz^^a6
.na4d5rzecz
.na4d5rzy
.na4d5ziem
.na4f3c
.na4f3t
.na4j3e2f
.na4j3e2g
.na4j3e2k2s
.na4j3e2ko
.na4j3e2n
.na4j3e2r
.na4j3e2s
.na4j3e2w
.na4j3emf
.na4j3eu
.na4r3c
.na4r3d
.na4r3k
.na4r3r
.na4r3t
.nabrz2
.nach2
.nacz2
.nad^^b1rod5ziem
.nad3^^a22
.nad3^^aa2
.nad3^^b12
.nad3b2
.nad3c2
.nad3d2
.nad3e2tat
.nad3f2
.nad3g2
.nad3h2
.nad3i2
.nad3j2
.nad3k2
.nad3l2
.nad3m2
.nad3n2
.nad3p2
.nad3r2
.nad3s2
.nad3t2
.nad3u2
.nad3w2
.nad5^^bb2
.nad5z^^f3
.nad5z2mys
.nad5zo
.nad5zwycz
.nadch2
.nadcz2
.nadd^^b92
.nade3^^a22
.nade3^^aa2
.nade3^^b12
.nade3^^b92
.nade3^^bb2
.nade3b2
.nade3c2
.nade3d2
.nade3f2
.nade3g2
.nade3h2
.nade3k2
.nade3l2
.nade3m2
.nade3p2
.nade3r2
.nade3s2
.nade3t2
.nade3w2
.nade3z2
.nade4p3c
.nade4p3n
.nade4p3t
.nadech2
.nadecz2
.naded^^b92
.naded^^bb2
.nadedz2
.nader^^bb2
.naderz2
.nadesz2
.nadsz2
.nadtr2
.nadz2
.nagrz2
.naj3^^a22
.naj3^^aa2
.naj3^^b12
.naj3^^b92
.naj3^^bb2
.naj3akt
.naj3au
.naj3b2
.naj3c2
.naj3d2
.naj3f2
.naj3g2
.naj3h2
.naj3i2
.naj3k2
.naj3l2
.naj3m2
.naj3o2
.naj3o2^^a22
.naj3o2^^aa2
.naj3o2^^b12
.naj3o2^^b92
.naj3o2^^bb2
.naj3o2b2
.naj3o2c2
.naj3o2d2
.naj3o2f2
.naj3o2g2
.naj3o2h2
.naj3o2k2
.naj3o2l2
.naj3o2m2
.naj3o2p2
.naj3o2r2
.naj3o2s2
.naj3o2t2
.naj3o2w2
.naj3o2z2
.naj3p2
.naj3r2
.naj3ro2z3
.naj3s2
.naj3t2
.naj3u2
.naj3w2
.naj3z2
.najbe2z3
.najbezw2
.najch2
.najcz2
.najd^^b92
.najd^^bb2
.najdo3^^a22
.najdo3^^aa2
.najdo3^^b12
.najdo3^^b92
.najdo3^^bb2
.najdo3b2
.najdo3c2
.najdo3d2
.najdo3f2
.najdo3g2
.najdo3h2
.najdo3k2
.najdo3l2
.najdo3m2
.najdo3p2
.najdo3r2
.najdo3s2
.najdo3t2
.najdo3w2
.najdo3z2
.najdoch2
.najdocz2
.najdod^^b92
.najdod^^bb2
.najdodz2
.najdorz2
.najdosz2
.najdotk2
.najdz2
.najkr2
.najob3^^a22
.najob3^^aa2
.najob3^^b12
.najob3^^b92
.najob3^^bb2
.najob3c2
.najob3d2
.najob3f2
.najob3g2
.najob3h2
.najob3j2
.najob3k2
.najob3l2
.najob3m2
.najob3n2
.najob3p2
.najob3s2
.najob3t2
.najob3w2
.najobch2
.najobcz2
.najobd^^b92
.najobd^^bb2
.najobdz2
.najobrz2
.najobsz2
.najoch2
.najocz2
.najod^^b92
.najod3^^a22
.najod3^^b12
.najod3c2
.najod3d2
.najod3f2
.najod3g2
.najod3h2
.najod3j2
.najod3k2
.najod3l2
.najod3m2
.najod3n2
.najod3p2
.najod3s2
.najod3t2
.najod3w2
.najod5^^bb2
.najodch2
.najodcz2
.najodd^^b92
.najodd^^bb2
.najoddz2
.najodsz2
.najodz2
.najorz2
.najosz2
.najro3z4u
.najrz2
.najsm2
.najsz2
.najtk2
.najtr2
.najucz2
.najzw2
.nakr2
.napo2d2
.napo3^^a22
.napo3^^aa2
.napo3^^b12
.napo3^^b92
.napo3^^bb2
.napo3b2
.napo3c2
.napo3f2
.napo3g2
.napo3h2
.napo3k2
.napo3l2
.napo3m2
.napo3p2
.napo3r2
.napo3s2
.napo3t2
.napo3w2
.napo3z2
.napo4m3p
.napoch2
.napocz2
.napod^^b92
.napod^^bb2
.napod3d
.napomk2
.naporz2
.naposz2
.naprz2
.nar^^bb2
.naro2z3
.narz2
.nasm2
.nasz2
.natch2
.natk2
.naz3m2
.nazw2
.nb8
.nc8
.nd8
.ne2o3
.nf8
.ng8
.nh8
.nie3^^a22
.nie3^^aa2
.nie3^^b12
.nie3^^b92
.nie3^^bb2
.nie3b2
.nie3c2
.nie3d2
.nie3f2
.nie3g2
.nie3h2
.nie3k2
.nie3l2
.nie3m2
.nie3p2
.nie3r2
.nie3s2
.nie3t2
.nie3u2
.nie3w2
.nie3z2
.nie4c3c
.nie4c3k
.nie4d^^b93
.nie4m3c
.nie4m3k
.niech2
.niecz2
.nied^^bb2
.niedo3^^a22
.niedo3^^aa2
.niedo3^^b12
.niedo3^^b92
.niedo3^^bb2
.niedo3b2
.niedo3c2
.niedo3d2
.niedo3f2
.niedo3g2
.niedo3h2
.niedo3k2
.niedo3l2
.niedo3m2
.niedo3p2
.niedo3r2
.niedo3s2
.niedo3t2
.niedo3w2
.niedo3z2
.niedobrz2
.niedoch2
.niedocz2
.niedod^^b92
.niedod^^bb2
.niedodz2
.niedokr2
.niedomk2
.niedopch2
.niedorz2
.niedosz2
.niedotk2
.niedz2
.nieo^^a22
.nieo^^aa2
.nieo^^b12
.nieo^^b92
.nieo^^bb2
.nieo2
.nieob2
.nieob3^^a22
.nieob3^^b12
.nieob3^^b92
.nieob3^^bb2
.nieob3c2
.nieob3d2
.nieob3f2
.nieob3g2
.nieob3h2
.nieob3j2
.nieob3k2
.nieob3m2
.nieob3p2
.nieob3s2
.nieob3w2
.nieobch2
.nieobcz2
.nieobd^^b92
.nieobd^^bb2
.nieobdz2
.nieobsz2
.nieoc2
.nieoch2
.nieocz2
.nieod^^b92
.nieod2
.nieod3^^a22
.nieod3^^aa2
.nieod3^^b12
.nieod3c2
.nieod3d2
.nieod3f2
.nieod3g2
.nieod3h2
.nieod3j2
.nieod3k2
.nieod3l2
.nieod3n2
.nieod3p2
.nieod3s2
.nieod3t2
.nieod3wr
.nieod5^^bb2
.nieodch2
.nieodcz2
.nieodd^^b92
.nieodd^^bb2
.nieoddz2
.nieodsz2
.nieodw2
.nieodz2
.nieof2
.nieog2
.nieoh2
.nieok2
.nieol2
.nieom2
.nieop2
.nieor2
.nieorz2
.nieos2
.nieosz2
.nieot2
.nieow2
.nieoz2
.niepo2d2
.niepo3^^a22
.niepo3^^aa2
.niepo3^^b12
.niepo3^^b92
.niepo3^^bb2
.niepo3b2
.niepo3c2
.niepo3d^^b92
.niepo3d4^^aau
.niepo3d4much
.niepo3d4r^^a6cz
.niepo3d4ra^^bb
.niepo3d4rap
.niepo3d4repcz
.niepo3d4rept
.niepo3d4waj
.niepo3d4woj
.niepo3do
.niepo3du
.niepo3dz2
.niepo3f2
.niepo3g2
.niepo3h2
.niepo3k2
.niepo3l2
.niepo3m2
.niepo3p2
.niepo3r2
.niepo3s2
.niepo3t2
.niepo3w2
.niepo3z2
.niepo4d3o2choc
.niepo4d3o2strz
.niepoch2
.niepocz2
.niepod3^^a22
.niepod3^^aa2
.niepod3^^b12
.niepod3b2
.niepod3c2
.niepod3d2
.niepod3f2
.niepod3g2
.niepod3h2
.niepod3j2
.niepod3k2
.niepod3l2
.niepod3m2
.niepod3n2
.niepod3p2
.niepod3r2
.niepod3s2
.niepod3t2
.niepod3w2
.niepod5^^bb
.niepodch2
.niepodcz2
.niepodd^^b92
.niepodd^^bb2
.niepodsm2
.niepodsz2
.nieporz2
.nieposm2
.nieposz2
.nieprze^^aak2
.nieprze2d2
.nieprze3^^a22
.nieprze3^^aa2
.nieprze3^^b12
.nieprze3^^b92
.nieprze3^^bb2
.nieprze3b2
.nieprze3brz2
.nieprze3c2
.nieprze3d^^b92
.nieprze3d4^^aau^^bb
.nieprze3d4much
.nieprze3d4ramat
.nieprze3d4ruk
.nieprze3d4ryl
.nieprze3d4rz2
.nieprze3d4um
.nieprze3dy
.nieprze3dz2
.nieprze3e2k2s3
.nieprze3f2
.nieprze3g2
.nieprze3h2
.nieprze3k2
.nieprze3l2
.nieprze3m2
.nieprze3n2
.nieprze3p2
.nieprze3r2
.nieprze3s2
.nieprze3t2
.nieprze3w2
.nieprze3z2
.nieprze4d5^^aau^^bbyc
.nieprze4d5^^bb2
.nieprze4d5z2a
.nieprze4d5zg2
.nieprze4d5zim
.nieprze4d5zj
.nieprze4d5zl
.nieprze4d5zw2r
.nieprze4d5zwoj
.nieprzech2
.nieprzecz2
.nieprzed3^^a22
.nieprzed3^^aa2
.nieprzed3^^b12
.nieprzed3c2
.nieprzed3d2
.nieprzed3f2
.nieprzed3g2
.nieprzed3h2
.nieprzed3i2
.nieprzed3j2
.nieprzed3k2
.nieprzed3l2
.nieprzed3m2
.nieprzed3n2
.nieprzed3p2
.nieprzed3r2
.nieprzed3s2
.nieprzed3sz2
.nieprzed3t2
.nieprzed3u2
.nieprzed3w2
.nieprzedch2
.nieprzedcz2
.nieprzedd^^b92
.nieprzedd^^bb2
.nieprzeddz2
.nieprzegrz2
.nieprzekl2
.nieprzekr2
.nieprzepch2
.nieprzer^^bb2
.nieprzerz2
.nieprzesch2
.nieprzesm2
.nieprzesz2
.nieprzetk2
.nieprzetr2
.niero2z3
.niero3z4e
.niero3z4u
.nieroz^^b12
.nierozbrz2
.nieroze3r2
.nierozm2
.nieroztr2
.nierz2
.niesu2b3
.niesu3b4ie
.niesz2
.nietk2
.nietr2
.nieucz2
.nieuw2
.niewy3^^a22
.niewy3^^aa2
.niewy3^^b12
.niewy3^^b92
.niewy3^^bb2
.niewy3b2
.niewy3c2
.niewy3d2
.niewy3f2
.niewy3g2
.niewy3h2
.niewy3k2
.niewy3l2
.niewy3m2
.niewy3p2
.niewy3r2
.niewy3s2
.niewy3t2
.niewy3w2
.niewy3z2
.niewybrz2
.niewych2
.niewycz2
.niewyd^^b92
.niewyd^^bb2
.niewydz2
.niewyrz2
.niewysz2
.niewytk2
.niewytr2
.niezw2
.nj8
.nk8
.nl8
.nm8
.nn8
.np8
.nr8
.ns8
.nt8
.nv8
.nw8
.nx8
.nz8
.o^^a22
.o^^b12
.o^^b1mio3^^b12
.o^^b92
.o^^bb2
.o2b2
.o2d2
.o2t3ch^^aa
.o3b4^^aa^^a1
.o3b4^^aa^^a6
.o3b4^^aaoc
.o3b4luzg
.o3b4ra^^a2
.o3b4raso
.o3b4ro^^ab
.o3b4ron
.o3b4ry^^b9
.o3b4ryz
.o3b4rz2
.o3be
.o3bi
.o3d4iu
.o3d4r^^a6t
.o3d4rap
.o3d4robin
.o3d4rut
.o3d4rwi
.o3d4rze^^a2
.o3d4rzw
.o3d6zia
.o3d6zie
.o3de
.o3l2^^b1n
.o4b5^^aaocz
.o4b5rz^^a1
.o4b5rz^^a6d
.o4b5rzez
.o4b5rzuc
.o4b5rzut
.o4b5rzyn
.o4d7ziar
.o4d7ziem
.oa3z
.ob3^^a22
.ob3^^aa2
.ob3^^b12
.ob3^^b92
.ob3^^bb2
.ob3c2
.ob3d2
.ob3f2
.ob3g2
.ob3h2
.ob3j2
.ob3k2
.ob3l2
.ob3m2
.ob3n2
.ob3o2strz
.ob3p2
.ob3r
.ob3s2
.ob3t2
.ob3u2m2
.ob3w2
.obch2
.obcz2
.obd^^b92
.obd^^bb2
.obdz2
.obe3^^a22
.obe3^^aa2
.obe3^^b12
.obe3^^b92
.obe3^^bb2
.obe3b2
.obe3c2
.obe3d2
.obe3f2
.obe3g2
.obe3h2
.obe3k2
.obe3l2
.obe3m2
.obe3p2
.obe3r2
.obe3r3t
.obe3s2
.obe3t2
.obe3w2
.obe3z2
.obe4c3n
.obe4z3w
.obech2
.obecz2
.obed^^b92
.obed^^bb2
.obedz2
.ober^^bb2
.ober3m
.oberz2
.obesch2
.obesz2
.obetk2
.obi3b2
.obsz2
.oc2
.och2
.ochrz2
.ocz2
.od^^b92
.od3^^a22
.od3^^b12
.od3au
.od3b2
.od3c2
.od3d2
.od3f2
.od3g2
.od3h2
.od3i2
.od3i2zo
.od3j2
.od3k2
.od3l2
.od3m2
.od3n2
.od3o2s
.od3p2
.od3r2
.od3s2
.od3t2
.od3u2cz
.od3u2m2
.od3w2
.od5^^bb2
.od5z2
.odbe2z3
.odch2
.odcz2
.odd^^b92
.odd^^bb2
.oddz2
.ode3^^a22
.ode3^^aa2
.ode3^^b12
.ode3^^b92
.ode3^^bb2
.ode3b2
.ode3c2
.ode3d2
.ode3f2
.ode3g2
.ode3h2
.ode3k2
.ode3l2
.ode3m2
.ode3mk2
.ode3p2
.ode3r2
.ode3s2
.ode3t2
.ode3w2
.ode3z2
.odech2
.odecz2
.oded^^b92
.oded^^bb2
.odedz2
.odepch2
.oder^^bb2
.oderz2
.odesz2
.odetch2
.odetk2
.odkrz2
.odrz2
.odsz2
.of2
.og^^f3lno3k2
.og2
.ognio3tr2
.oh2
.ok2
.oka3m2
.okr2
.ole2o3
.om2
.op2
.opch2
.or2^^bb2
.or2t^^a6
.or2z2
.os2
.osie2m3
.osiemse2t3
.osz2
.ot2
.ow2
.oz2
.p^^a28
.p^^aa8
.p^^aaasko3w2
.p^^ab8
.p^^f3^^aak2
.p^^f3^^aakr2
.p^^f3^^aam2
.p^^f3^^aao2
.p^^f3^^aaob3r
.p^^f3^^aaom2d
.p^^f3^^aaprzy3m2k
.p^^f32^^aa3
.p^^f33^^aa4^^a1
.p^^f33^^aa4^^a6
.p^^f33^^aa4ecz
.p^^f33^^aa4y
.p^^b18
.p^^b98
.p^^bb8
.p8
.pb8
.pc8
.pch8
.pd8
.pe^^aano3kr2
.pe2r3
.pe3c2k
.pe3r4e
.pe3r4i
.pe3r4o
.pe3r4u
.pe3r4y
.pe4r5i2n
.pee2se2l
.pepee2r
.pepee2s
.peze2t1pee2r
.pf8
.pg8
.ph8
.pi^^a6^^a2se2t3
.pi^^a62^^a23
.pi^^a6cio3^^b12
.pierwo3w2
.piono3w2
.pj8
.pk8
.pl8
.pm8
.pn8
.po^^aak2
.po2d2
.po3^^a22
.po3^^aa2
.po3^^b12
.po3^^b92
.po3^^bb2
.po3b2
.po3c2
.po3d^^a1
.po3d^^a6
.po3d^^b92
.po3d4^^aau
.po3d4much
.po3d4naw
.po3d4r^^a6cz
.po3d4r^^a6tw
.po3d4r^^f3^^bb
.po3d4r2wi
.po3d4ra^^bb
.po3d4rap
.po3d4repcz
.po3d4rept
.po3d4ro^^bb
.po3d4rob^^f3
.po3d4roba
.po3d4robo
.po3d4roby
.po3d4rocz
.po3d4ruzg
.po3d4ryg
.po3d4rze
.po3d4w^^f3jn
.po3d4w^^f3r
.po3d4waj
.po3d4woi
.po3d4woj
.po3d4worz
.po3da
.po3de
.po3dej
.po3diu
.po3do
.po3du
.po3dy
.po3dz2
.po3e2k2s3
.po3f2
.po3g2
.po3h2
.po3k2
.po3l2
.po3m2
.po3p2
.po3r^^bb
.po3r2
.po3s2
.po3t2
.po3w2
.po3z2
.po4^^ab3c
.po4cz3d
.po4cz3t
.po4d3^^f3w
.po4d3e4k2s3
.po4d3o2b^^f3z
.po4d3o2biad
.po4d3o2bojcz
.po4d3o2braz
.po4d3o2choc
.po4d3o2dm
.po4d3o2f
.po4d3o2g
.po4d3o2kien
.po4d3o2kn
.po4d3o2kr^^a6g
.po4d3o2kres
.po4d3o2piecz
.po4d3o2ryw
.po4d3o2siniak
.po4d3o2strz
.po4d3obsz
.po4d3odd
.po4d3olbrz
.po4d3u2cz
.po4d3u2dz
.po4d3u2pa
.po4d3u2ral
.po4d3u2sta
.po4d3u2szcz
.po4d5r^^a6czn
.po4d5zakr
.po4d5zam
.po4d5zast
.po4d5zbi
.po4d5ze
.po4d5zieleni^^a1
.po4d5zieleni^^a2
.po4d5zieleni^^a6
.po4d5zieleni^^aa
.po4d5zielenic
.po4d5zielenien
.po4d5zielenil
.po4d5zielenim
.po4d5zielenio
.po4d5zielenis
.po4d5ziem
.po4d5ziom
.po4d5zw2r
.po4l3s
.po4m3p
.po4r3c
.po4r3f
.po4r3n
.po4r3t
.po4st3d
.po4st3f
.po4st3g
.po4st3h
.po4st3i2
.po4st3k
.po4st3l
.po4st3m
.po4st3p
.po4st3rom
.po4st3s
.po5d4uszczyn
.po5r4t^^a6
.pobr2
.pobrz2
.poch2
.pochrz2
.pocz2
.pod3^^a22
.pod3^^aa2
.pod3^^b12
.pod3^^b1r^^f32d5
.pod3alp
.pod3b2
.pod3c2
.pod3d2
.pod3f2
.pod3g2
.pod3h2
.pod3i2n
.pod3j2
.pod3k2
.pod3l2
.pod3m2
.pod3n2
.pod3p2
.pod3r2
.pod3s2
.pod3t2
.pod3w2
.pod5^^bb2
.podch2
.podcz2
.podd^^b92
.podd^^bb2
.pode3^^a22
.pode3^^aa2
.pode3^^b12
.pode3^^b92
.pode3^^bb2
.pode3b2
.pode3c2
.pode3d2
.pode3f2
.pode3g2
.pode3h2
.pode3k2
.pode3l2
.pode3m2
.pode3p2
.pode3r2
.pode3s2
.pode3t2
.pode3tk2
.pode3w2
.pode3z2
.podech2
.podecz2
.poded^^b92
.poded^^bb2
.podedz2
.podepch2
.poder^^bb2
.poderz2
.podesch2
.podesz2
.podro2z3
.podsm2
.podsz2
.pogrz2
.pokl2
.pokr2
.pom4pk
.pomk2
.pona2d2
.pona3^^a22
.pona3^^aa2
.pona3^^b12
.pona3^^b92
.pona3^^bb2
.pona3b2
.pona3c2
.pona3cz2
.pona3d^^b92
.pona3do
.pona3f2
.pona3g2
.pona3h2
.pona3k2
.pona3l2
.pona3m2
.pona3p2
.pona3r2
.pona3s2
.pona3t2
.pona3w2
.pona3z2
.pona4f3t
.ponabrz2
.ponach2
.ponad3^^a22
.ponad3^^b12
.ponad3c2
.ponad3ch2
.ponad3cz2
.ponad3d^^b92
.ponad3f2
.ponad3g2
.ponad3h2
.ponad3j2
.ponad3k2
.ponad3l2
.ponad3p2
.ponad3s2
.ponad3t2
.ponadz2
.ponarz2
.ponasm2
.ponasz2
.ponaz3m2
.ponazw2
.ponie3k2
.ponie3w2
.popch2
.popo3w2
.poprz2
.por4t1w
.por4tf
.por4tm
.poro2z3
.poro3z4u
.porz2
.posch2
.posm2
.posz2
.potk2
.potr2
.poz4m2
.poza3u2
.pozw2
.pp8
.pr8
.pra3s2
.pra3w2nu
.pra3w2z
.prapra3w2nu
.predy2s3po
.prz8
.prze^^aak2
.prze2d2
.prze3^^a22
.prze3^^aa2
.prze3^^b12
.prze3^^b92
.prze3^^bb2
.prze3b2
.prze3c2
.prze3d^^a1
.prze3d^^a6
.prze3d^^b92
.prze3d4^^aau^^bb
.prze3d4much
.prze3d4o3br
.prze3d4o3st
.prze3d4o3zo
.prze3d4ramat
.prze3d4ruk
.prze3d4ryl
.prze3d4rz2
.prze3d4um
.prze3dy
.prze3dz2
.prze3e2k2s3
.prze3f2
.prze3g2
.prze3h2
.prze3k2
.prze3l2
.prze3m2
.prze3n2
.prze3p2
.prze3r2
.prze3s2
.prze3t2
.prze3u2
.prze3w2
.prze3z2
.prze4d5^^aau^^bbyc
.prze4d5^^bb2
.prze4d5o4stat
.prze4d5za
.prze4d5zg2
.prze4d5zim
.prze4d5zj
.prze4d5zl
.prze4d5zw2r
.prze4d5zwoj
.przebr2
.przebrz2
.przech2
.przechrz2
.przeci2w3
.przeci3w4ie
.przeciwa2
.przeciww2
.przecz2
.przed3^^a22
.przed3^^aa2
.przed3^^b12
.przed3a2gon
.przed3a2kc
.przed3alp
.przed3b2
.przed3c2
.przed3d2
.przed3e2gz
.przed3e2mer
.przed3f2
.przed3g2
.przed3h2
.przed3i2
.przed3j2
.przed3k2
.przed3l2
.przed3m2
.przed3n2
.przed3o2
.przed3p2
.przed3r2
.przed3s2
.przed3si^^a63w2
.przed3sz2
.przed3t2
.przed3u2
.przed3w2
.przedch2
.przedcz2
.przedd^^b92
.przedd^^bb2
.przeddz2
.przedgrz2
.przedy2s3ku
.przegrz2
.przekl2
.przekr2
.przemk2
.przepch2
.przer^^bb2
.przerz2
.przesch2
.przesm2
.przesz2
.przetk2
.przetr2
.przetran2s3
.przy3^^a22
.przy3^^aa2
.przy3^^b12
.przy3^^b92
.przy3^^bb2
.przy3b2
.przy3c2
.przy3d2
.przy3f2
.przy3g2
.przy3h2
.przy3k2
.przy3l2
.przy3m2
.przy3p2
.przy3r2
.przy3s2
.przy3t2
.przy3w2
.przy3z2
.przybr2
.przych2
.przycz2
.przyd^^b92
.przyd^^bb2
.przydz2
.przygrz2
.przymk2
.przyoz2
.przypch2
.przyr^^bb2
.przyrz2
.przysch2
.przysz2
.przytk2
.ps8
.pt8
.pv8
.pw8
.px8
.pz8
.r^^a28
.r^^aa8
.r^^ab8
.r^^b18
.r^^b98
.r^^bb8
.r8
.rb8
.rc8
.rd8
.retran2s3
.rf8
.rg8
.rh8
.rj8
.rk8
.rl8
.rm8
.rn8
.ro2z3
.ro3z4a
.ro3z4e
.ro3z4e3^^a22
.ro3z4e3^^aa2
.ro3z4e3^^b12
.ro3z4e3^^b92
.ro3z4e3^^bb2
.ro3z4e3b2
.ro3z4e3c2
.ro3z4e3d2
.ro3z4e3f2
.ro3z4e3g2
.ro3z4e3h2
.ro3z4e3k2
.ro3z4e3l2
.ro3z4e3m2
.ro3z4e3p2
.ro3z4e3r2
.ro3z4e3s2
.ro3z4e3t2
.ro3z4e3w2
.ro3z4e3z2
.ro3z4ej
.ro3z4u
.ro4z5a2gi
.ro4z5a2nie
.ro4z5e2mo
.ro4z5e4g3z
.ro4z5e4n3t
.roz^^b12
.rozbrz2
.rozd2
.rozech2
.rozecz2
.rozed^^b92
.rozed^^bb2
.rozedz2
.rozepch2
.rozer^^bb2
.rozerz2
.rozesch2
.rozesz2
.rozi2
.rozm2
.rozo2
.rozpo3w2
.rozt2
.roztr2
.rozw2
.rp8
.rr8
.rs8
.rt8
.rv8
.rw8
.rx8
.rz8
.s^^a28
.s^^aa8
.s^^ab8
.s^^b18
.s^^b98
.s^^bb8
.s8
.samo3ch2
.samo3k2
.samo3p2
.samo3w2
.samoro2z3
.sb8
.sc8
.sch8
.sd8
.sf8
.sg8
.sh8
.siede2m3
.siedemse2t3
.siedmio3^^b12
.sj8
.sk^^a12d5^^bbe
.sk8
.skl8
.skr8
.sl8
.sm8
.sn8
.sobo3w2
.sp^^f32^^aa3
.sp8
.spo2d2
.spo3^^a22
.spo3^^aa2
.spo3^^b12
.spo3^^b92
.spo3^^bb2
.spo3b2
.spo3c2
.spo3dz2
.spo3f2
.spo3g2
.spo3h2
.spo3k2
.spo3l2
.spo3m2
.spo3p2
.spo3r2
.spo3s2
.spo3t2
.spo3w2
.spo3z2
.spo4r3n
.spo4r3t
.spoch2
.spocz2
.spod^^b92
.spod^^bb2
.spod3d
.sporz2
.sposz2
.sr8
.ss8
.st8
.stere2o3
.stereoa2
.stereoe2
.stereoi2
.stereoo2
.stereou2
.su2b3
.su3b4ie
.su3b4otn
.supe2r3
.supe3r4at
.supe3r4io
.supe4r5a2tr
.super5z2b
.supere2
.supero2d1rzut
.sv8
.sw8
.sx8
.sz8
.sze^^b1^^a2se2t3
.sze^^b1cio3^^b12
.sze2^^b12^^a23
.sze2s3
.t^^a28
.t^^aa8
.t^^ab8
.t^^b18
.t^^b98
.t^^bb8
.t8
.ta2o3
.ta2r7zan
.tb8
.tc8
.tch8
.td8
.te2o3
.tf8
.tg8
.th8
.tj8
.tk8
.tl8
.tm8
.tn8
.toa3
.tp8
.tr^^f32j3
.tr^^f33j4^^a1
.tr^^f33j4^^a6
.tr^^f33j4ecz
.tr8
.tran2s3
.tran3s4e
.tran3s4ie
.tran3s4y
.tran3sz
.tran4s5eu
.transa2
.transo2
.trz8
.trze2ch3
.trzechse2t3
.ts8
.tt8
.tv8
.tw8
.tx8
.tysi^^a12c3
.tysi^^a13c4a
.tysi^^a13c4e
.tysi^^a13cz
.tysi^^a14c5z^^aa
.tz8
.u^^a22
.u^^b12
.u3^^aa2
.u3^^b92
.u3^^bb2
.u3b2
.u3c2
.u3d2
.u3f2
.u3g2
.u3h2
.u3k2
.u3l2
.u3m2
.u3n2
.u3p2
.u3r2
.u3s2
.u3t2
.u3w2
.u3z2
.u4d3k
.u4f3n
.u4k3lej
.u4l3s
.u4l3t
.u4m3br
.u4n3c
.u4n3d
.u4p3p2s
.u4r3s
.u4st3n
.u4stc
.u4stk
.u4z3be
.ube2z3
.ubezw2
.ubr2
.uch2
.ucz2
.ud^^b92
.ud^^bb2
.udz2
.ukr2
.umk2
.upch2
.upo2d2
.upo3^^a22
.upo3^^aa2
.upo3^^b12
.upo3^^b92
.upo3^^bb2
.upo3b2
.upo3c2
.upo3da
.upo3f2
.upo3g2
.upo3h2
.upo3k2
.upo3l2
.upo3m2
.upo3p2
.upo3r2
.upo3s2
.upo3t2
.upo3w2
.upo3z2
.upoch2
.upocz2
.upod^^b92
.upod^^bb2
.upod3d
.uporz2
.uposz2
.ur^^bb2
.uro2z3
.urz2
.usch2
.usz2
.utk2
.utr2
.uze3w2
.v^^a28
.v^^aa8
.v^^ab8
.v^^b18
.v^^b98
.v^^bb8
.v8
.vb8
.vc8
.vd8
.vf8
.vg8
.vh8
.vj8
.vk8
.vl8
.vm8
.vn8
.vp8
.vr8
.vs8
.vt8
.vv8
.vw8
.vx8
.vz8
.w^^a28
.w^^aa8
.w^^ab8
.w^^b18
.w^^b98
.w^^bb8
.w8
.wb8
.wc8
.wd8
.we3^^a22
.we3^^aa2
.we3^^b12
.we3^^bb2
.we3b2
.we3c2
.we3d2
.we3f2
.we3g2
.we3h2
.we3k2
.we3l2
.we3m2
.we3n2
.we3p2
.we3r2
.we3s2
.we3t2
.we3w2
.we3z2
.we4^^aa3n
.we4k3t
.we4l3w
.we4n3d
.we4n3t
.we4r3b
.we4r3d
.we4r3n
.we4r3s
.we4r3t
.we4s3prz
.we4s3tch2
.we4z3br
.we4z3g^^aa
.wech2
.wecz2
.wed^^b92
.wed^^bb2
.wedz2
.wemk2
.wepch2
.werz2
.wesz2
.wetk2
.wewn^^a12trz3
.wf8
.wg8
.wh8
.wielo3^^b12
.wielo3d2
.wielo3k2
.wieluse2t3
.wilczo3m2
.wj8
.wk8
.wl8
.wm8
.wn8
.wniebo3w2
.wodo3w2
.wp8
.wr8
.ws8
.wsp^^f3^^aai2
.wsp^^f3^^aao2b3w
.wsp^^f3^^aau2
.wsp^^f3^^aaw2
.wsp^^f32^^aa3
.wsze2ch3
.wszecho2
.wszechw2
.wt8
.wv8
.ww8
.wx8
.wy3^^a22
.wy3^^aa2
.wy3^^b12
.wy3^^b92
.wy3^^bb2
.wy3b2
.wy3c2
.wy3d2
.wy3f2
.wy3g2
.wy3h2
.wy3k2
.wy3l2
.wy3m2
.wy3o2d3r
.wy3p2
.wy3r2
.wy3s2
.wy3t2
.wy3w2
.wy3z2
.wy4^^bb3sz
.wy4cz3ha
.wybr2
.wybrz2
.wych2
.wycz2
.wyd^^b92
.wyd^^bb2
.wydr2
.wydz2
.wye2k2s3
.wygrz2
.wyi2zo
.wykl2
.wykr2
.wykrz2
.wymk2
.wypch2
.wyprz2
.wyr^^bb2
.wyrz2
.wysch2
.wysm2
.wysz2
.wytch2
.wytk2
.wytr2
.wz8
.x^^a28
.x^^aa8
.x^^ab8
.x^^b18
.x^^b98
.x^^bb8
.x8
.xb8
.xc8
.xd8
.xf8
.xg8
.xh8
.xj8
.xk8
.xl8
.xm8
.xn8
.xp8
.xr8
.xs8
.xt8
.xv8
.xw8
.xx8
.xz8
.z^^a28
.z^^aa8
.z^^aao3w2
.z^^ab8
.z^^b18
.z^^b98
.z^^bb8
.z8
.za3^^a22
.za3^^aa2
.za3^^b12
.za3^^b92
.za3^^bb2
.za3b2
.za3c2
.za3d2
.za3f2
.za3g2
.za3h2
.za3k2
.za3l2
.za3m2
.za3o2b3r
.za3o2b3s
.za3p2
.za3r2
.za3s2
.za3t2
.za3u2
.za3w2
.za3z2
.za4k3t
.za4l3g
.za4l3k
.za4l3t
.za4m3k
.za4r3ch
.za4uto
.za5m4k2n
.zabr2
.zabrz2
.zach2
.zacz2
.zad^^b92
.zad^^bb2
.zado^^b1^^a2u4
.zado2^^b1^^a23
.zadr2
.zady2s3po
.zadz2
.zagrz2
.zai2n3
.zai2zo
.zain4ic
.zakl2
.zakr2
.zakrz2
.zanie3d2
.zar^^bb2
.zarz2
.zasch2
.zasm2
.zasz2
.zatk2
.zatr2
.zb8
.zc8
.zd8
.zde2z3
.zde3z4awu
.zde3z4el
.zde3z4er
.zde3z4y
.zdy2s3kont
.zdy2s3kred
.zdy2s3kwal
.ze3^^a22
.ze3^^aa2
.ze3^^b12
.ze3^^b92
.ze3^^bb2
.ze3b2
.ze3c2
.ze3d2
.ze3f2
.ze3g2
.ze3h2
.ze3k2
.ze3l2
.ze3m2
.ze3p2
.ze3r2
.ze3s2
.ze3t2
.ze3tk2
.ze3w2
.ze3z2
.ze4r3k
.ze4t3e2m1e2s
.ze4t3e2s1e2l
.ze4t3emp
.ze4t3hap
.zech2
.zecz2
.zed^^b92
.zed^^bb2
.zedz2
.zekl2
.zepch2
.zer^^bb2
.zerz2
.zesch2
.zesm4
.zesz2
.zf8
.zg8
.zh8
.zimno3kr2
.zj8
.zk8
.zl8
.zm8
.zmartwy2ch3
.zmartwychw2
.zn8
.znie3^^a22
.znie3^^aa2
.znie3^^ab2
.znie3^^b12
.znie3^^b92
.znie3^^bb2
.znie3b2
.znie3c2
.znie3d2
.znie3f2
.znie3g2
.znie3h2
.znie3k2
.znie3l2
.znie3m2
.znie3n2
.znie3p2
.znie3r2
.znie3s2
.znie3t2
.znie3w2
.znie3z2
.znie4d^^b93
.znie4m3c
.zniech2
.zniecz2
.znied^^bb2
.zniedz2
.znierz2
.zniesz2
.zo2o3
.zp8
.zr8
.zro2z3
.zro3z4u
.zs8
.zt8
.zv8
.zw8
.zx8
.zz8
^^a11
^^a61
^^f31
^^f34w3cz
^^b11c
^^b92d^^b9
1^^b12ci
2^^a21^^ab
2^^a21^^b1
2^^a21^^b9
2^^a21^^bb
2^^a21b
2^^a21c
2^^a21d
2^^a21f
2^^a21g
2^^a21k
2^^a21m
2^^a21n
2^^a21p
2^^a21s
2^^a21t
2^^a21z
2^^aa1^^a2
2^^aa1^^ab
2^^aa1^^b1
2^^aa1^^b9
2^^aa1^^bb
2^^aa1b
2^^aa1c
2^^aa1d
2^^aa1f
2^^aa1g
2^^aa1h
2^^aa1j
2^^aa1k
2^^aa1l
2^^aa1m
2^^aa1n
2^^aa1p
2^^aa1r
2^^aa1s
2^^aa1t
2^^aa1w
2^^aa1z
2^^ab1^^a2
2^^ab1^^aa
2^^ab1^^ab
2^^ab1^^b1
2^^ab1^^b9
2^^ab1^^bb
2^^ab1b
2^^ab1c
2^^ab1d
2^^ab1f
2^^ab1g
2^^ab1h
2^^ab1j
2^^ab1k
2^^ab1l
2^^ab1m
2^^ab1n
2^^ab1p
2^^ab1r
2^^ab1s
2^^ab1t
2^^ab1w
2^^ab1z
2^^b1^^a2c
2^^b11^^b1
2^^b11^^b9
2^^b11^^bb
2^^b11b
2^^b11d
2^^b11f
2^^b11g
2^^b11k
2^^b11p
2^^b11s
2^^b11t
2^^b11z
2^^b1lm
2^^b1ln
2^^b91^^a2
2^^b91^^b1
2^^b91^^bb
2^^b91b
2^^b91c
2^^b91d
2^^b91f
2^^b91g
2^^b91k
2^^b91l
2^^b91m
2^^b91n
2^^b91p
2^^b91s
2^^b91t
2^^b91w
2^^b91z
2^^bb1^^a2
2^^bb1^^aa
2^^bb1^^ab
2^^bb1^^b1
2^^bb1^^b9
2^^bb1b
2^^bb1c
2^^bb1d
2^^bb1f
2^^bb1g
2^^bb1j
2^^bb1k
2^^bb1l
2^^bb1m
2^^bb1n
2^^bb1p
2^^bb1r
2^^bb1s
2^^bb1t
2^^bb1w
2^^bb1z
2b^^aak
2b1^^a2
2b1^^ab
2b1^^b1
2b1^^b9
2b1^^bb
2b1c
2b1d
2b1f
2b1g
2b1k
2b1m
2b1n
2b1p
2b1s
2b1t
2b1z
2brn
2c1^^a2
2c1^^ab
2c1^^b1
2c1^^b9
2c1^^bb
2c1b
2c1d
2c1f
2c1g
2c1k
2c1l
2c1m
2c1n
2c1p
2c1s
2c1t
2ch1^^a2
2ch1^^ab
2ch1^^b1
2ch1^^b9
2ch1^^bb
2ch1b
2ch1c
2ch1d
2ch1f
2ch1g
2ch1k
2ch1m
2ch1n
2ch1p
2ch1s
2ch1t
2ch1z
2cz1^^a2
2cz1^^ab
2cz1^^b1
2cz1^^b9
2cz1^^bb
2cz1b
2cz1c
2cz1d
2cz1f
2cz1g
2cz1k
2cz1l
2cz1m
2cz1n
2cz1p
2cz1s
2cz1t
2cz1z
2d^^aab
2d^^aasz
2d^^b91^^a2
2d^^b91^^ab
2d^^b91^^b1
2d^^b91^^b9
2d^^b91^^bb
2d^^b91b
2d^^b91c
2d^^b91d
2d^^b91f
2d^^b91g
2d^^b91k
2d^^b91m
2d^^b91n
2d^^b91p
2d^^b91s
2d^^b91t
2d^^b91z
2d^^bb1^^a2
2d^^bb1^^ab
2d^^bb1^^b1
2d^^bb1^^b9
2d^^bb1^^bb
2d^^bb1b
2d^^bb1c
2d^^bb1d
2d^^bb1f
2d^^bb1g
2d^^bb1k
2d^^bb1m
2d^^bb1n
2d^^bb1p
2d^^bb1s
2d^^bb1t
2d^^bb1z
2d1^^a2
2d1^^ab
2d1^^b1
2d1b
2d1c
2d1f
2d1g
2d1k
2d1m
2d1n
2d1p
2d1s
2d1t
2drn
2dz1^^a2
2dz1^^ab
2dz1^^b1
2dz1^^b9
2dz1^^bb
2dz1b
2dz1c
2dz1d
2dz1f
2dz1g
2dz1k
2dz1l
2dz1m
2dz1n
2dz1p
2dz1s
2dz1t
2dz1z
2f1c
2f1k
2f1m
2f1n
2g^^aab
2g1^^a2
2g1^^ab
2g1^^b1
2g1^^b9
2g1^^bb
2g1b
2g1c
2g1d
2g1f
2g1k
2g1m
2g1p
2g1s
2g1t
2g1z
2h1^^a2
2h1^^aa
2h1^^ab
2h1^^b1
2h1^^b9
2h1^^bb
2h1b
2h1c
2h1d
2h1f
2h1g
2h1j
2h1k
2h1l
2h1m
2h1n
2h1p
2h1r
2h1s
2h1t
2h1w
2h1z
2j1^^a2
2j1^^aa
2j1^^ab
2j1^^b1
2j1^^b9
2j1^^bb
2j1b
2j1c
2j1d
2j1f
2j1g
2j1h
2j1k
2j1l
2j1m
2j1n
2j1p
2j1r
2j1s
2j1t
2j1w
2j1z
2k^^aab
2k1^^a2
2k1^^ab
2k1^^b1
2k1^^b9
2k1^^bb
2k1b
2k1c
2k1d
2k1f
2k1g
2k1m
2k1n
2k1p
2k1s
2k1sz
2k1t
2k1z
2l1^^a2
2l1^^aa
2l1^^ab
2l1^^b1
2l1^^b9
2l1^^bb
2l1b
2l1c
2l1d
2l1f
2l1g
2l1h
2l1j
2l1k
2l1m
2l1n
2l1p
2l1r
2l1s
2l1t
2l1w
2l1z
2m1^^a2
2m1^^aa
2m1^^ab
2m1^^b1
2m1^^b9
2m1^^bb
2m1b
2m1c
2m1d
2m1f
2m1g
2m1h
2m1j
2m1k
2m1l
2m1n
2m1p
2m1r
2m1s
2m1t
2m1w
2m1z
2n1^^a2
2n1^^aa
2n1^^ab
2n1^^b1
2n1^^b9
2n1^^bb
2n1b
2n1c
2n1d
2n1f
2n1g
2n1h
2n1j
2n1k
2n1l
2n1m
2n1p
2n1r
2n1s
2n1t
2n1w
2n1z
2ntn
2p1^^a2
2p1^^ab
2p1^^b1
2p1^^b9
2p1^^bb
2p1b
2p1c
2p1d
2p1f
2p1g
2p1k
2p1m
2p1n
2p1s
2p1sz
2p1t
2p1z
2pln
2r1^^a2
2r1^^aa
2r1^^ab
2r1^^b1
2r1^^b9
2r1^^bb
2r1b
2r1c
2r1d
2r1f
2r1g
2r1h
2r1j
2r1k
2r1l
2r1m
2r1n
2r1p
2r1s
2r1t
2r1w
2rz1^^a2
2rz1^^aa
2rz1^^ab
2rz1^^b1
2rz1^^b9
2rz1^^bb
2rz1b
2rz1c
2rz1d
2rz1f
2rz1g
2rz1h
2rz1j
2rz1k
2rz1l
2rz1m
2rz1n
2rz1p
2rz1r
2rz1s
2rz1t
2rz1w
2s^^aab
2s1^^b9
2s1^^bb
2s1b
2s1d
2s1f
2s1g
2s1s
2snk
2stk
2stn
2stsz
2sz1^^a2
2sz1^^b1
2sz1c
2sz1f
2sz1k
2sz1l
2sz1m
2sz1n
2sz1p
2sz1s
2sz1t
2sz1w
2sz1z
2szln
2t1^^a2
2t1^^ab
2t1^^b1
2t1^^b9
2t1^^bb
2t1b
2t1c
2t1d
2t1f
2t1g
2t1k
2t1m
2t1n
2t1p
2t1s
2t1z
2tln
2trk
2trzn
2w1^^a2
2w1^^aa
2w1^^ab
2w1^^b1
2w1^^b9
2w1^^bb
2w1b
2w1c
2w1d
2w1f
2w1g
2w1j
2w1k
2w1l
2w1m
2w1n
2w1p
2w1r
2w1s
2w1t
2w1z
2z1^^a2
2z1^^b1
2z1c
2z1d
2z1f
2z1k
2z1p
2z1s
2z1t
2zdk
2zdn
3d2niow
3k2sz2t
3m2k2n
3m2nest
3m2nezj
3m2sk2n
3p2neu
3w2^^aaad
3w2^^aaos
3w2czas
4^^a23^^a2
4^^aa3^^aa
4^^b93^^b9
4^^bb3^^bb
4b3b
4c3c
4d3d
4f3f
4g3g
4h3h
4j3j
4k3k
4l3l
4m3m
4n3n
4p3p
4r3r
4t3t
4w3w
4z3z
8^^a2.
8^^a2^^a2.
8^^a2^^aa.
8^^a2^^ab.
8^^a2^^b1.
8^^a2^^b9.
8^^a2^^bb.
8^^a2b.
8^^a2c.
8^^a2d.
8^^a2f.
8^^a2g.
8^^a2h.
8^^a2j.
8^^a2k.
8^^a2l.
8^^a2m.
8^^a2n.
8^^a2p.
8^^a2r.
8^^a2s.
8^^a2t.
8^^a2v.
8^^a2w.
8^^a2x.
8^^a2z.
8^^aa.
8^^aa^^a2.
8^^aa^^aa.
8^^aa^^ab.
8^^aa^^b1.
8^^aa^^b9.
8^^aa^^bb.
8^^aab.
8^^aac.
8^^aad.
8^^aaf.
8^^aag.
8^^aah.
8^^aaj.
8^^aak.
8^^aal.
8^^aam.
8^^aan.
8^^aap.
8^^aar.
8^^aas.
8^^aat.
8^^aav.
8^^aaw.
8^^aax.
8^^aaz.
8^^ab.
8^^ab^^a2.
8^^ab^^aa.
8^^ab^^ab.
8^^ab^^b1.
8^^ab^^b9.
8^^ab^^bb.
8^^abb.
8^^abc.
8^^abd.
8^^abf.
8^^abg.
8^^abh.
8^^abj.
8^^abk.
8^^abl.
8^^abm.
8^^abn.
8^^abp.
8^^abr.
8^^abs.
8^^abt.
8^^abv.
8^^abw.
8^^abx.
8^^abz.
8^^b1.
8^^b1^^a2.
8^^b1^^aa.
8^^b1^^ab.
8^^b1^^b1.
8^^b1^^b9.
8^^b1^^bb.
8^^b1b.
8^^b1c.
8^^b1d.
8^^b1f.
8^^b1g.
8^^b1h.
8^^b1j.
8^^b1k.
8^^b1l.
8^^b1m.
8^^b1n.
8^^b1p.
8^^b1r.
8^^b1s.
8^^b1t.
8^^b1v.
8^^b1w.
8^^b1x.
8^^b1z.
8^^b9.
8^^b9^^a2.
8^^b9^^aa.
8^^b9^^ab.
8^^b9^^b1.
8^^b9^^b9.
8^^b9^^bb.
8^^b9b.
8^^b9c.
8^^b9d.
8^^b9f.
8^^b9g.
8^^b9h.
8^^b9j.
8^^b9k.
8^^b9l.
8^^b9m.
8^^b9n.
8^^b9p.
8^^b9r.
8^^b9s.
8^^b9t.
8^^b9v.
8^^b9w.
8^^b9x.
8^^b9z.
8^^bb.
8^^bb^^a2.
8^^bb^^aa.
8^^bb^^ab.
8^^bb^^b1.
8^^bb^^b9.
8^^bb^^bb.
8^^bbb.
8^^bbc.
8^^bbd.
8^^bbf.
8^^bbg.
8^^bbh.
8^^bbj.
8^^bbk.
8^^bbl.
8^^bbm.
8^^bbn.
8^^bbp.
8^^bbr.
8^^bbs.
8^^bbt.
8^^bbv.
8^^bbw.
8^^bbx.
8^^bbz.
8b.
8b^^a2.
8b^^aa.
8b^^ab.
8b^^b1.
8b^^b9.
8b^^bb.
8bb.
8bc.
8bd.
8bf.
8bg.
8bh.
8bj.
8bk.
8bl.
8bm.
8bn.
8bp.
8br.
8brz.
8bs.
8bt.
8bv.
8bw.
8bx.
8bz.
8c.
8c^^a2.
8c^^aa.
8c^^ab.
8c^^b1.
8c^^b9.
8c^^bb.
8cb.
8cc.
8cd.
8cf.
8cg.
8ch.
8ch^^aa.
8chrz.
8chw.
8cj.
8ck.
8cl.
8cm.
8cn.
8cp.
8cr.
8cs.
8ct.
8cv.
8cw.
8cx.
8cz.
8czt.
8d.
8d^^a2.
8d^^aa.
8d^^ab.
8d^^b1.
8d^^b9.
8d^^bb.
8db.
8dc.
8dd.
8df.
8dg.
8dh.
8dj.
8dk.
8dl.
8dm.
8dn.
8dp.
8dr.
8drz.
8ds.
8dt.
8dv.
8dw.
8dx.
8dz.
8f.
8f^^a2.
8f^^aa.
8f^^ab.
8f^^b1.
8f^^b9.
8f^^bb.
8fb.
8fc.
8fd.
8ff.
8fg.
8fh.
8fj.
8fk.
8fl.
8fm.
8fn.
8fp.
8fr.
8fs.
8ft.
8fv.
8fw.
8fx.
8fz.
8g.
8g^^a2.
8g^^aa.
8g^^ab.
8g^^b1.
8g^^b9.
8g^^bb.
8gb.
8gc.
8gd.
8gf.
8gg.
8gh.
8gj.
8gk.
8gl.
8gm.
8gn.
8gp.
8gr.
8gs.
8gt.
8gv.
8gw.
8gx.
8gz.
8h.
8h^^a2.
8h^^aa.
8h^^ab.
8h^^b1.
8h^^b9.
8h^^bb.
8hb.
8hc.
8hd.
8hf.
8hg.
8hh.
8hj.
8hk.
8hl.
8hm.
8hn.
8hp.
8hr.
8hs.
8ht.
8hv.
8hw.
8hx.
8hz.
8j.
8j^^a2.
8j^^aa.
8j^^ab.
8j^^b1.
8j^^b9.
8j^^bb.
8jb.
8jc.
8jd.
8jf.
8jg.
8jh.
8jj.
8jk.
8jl.
8jm.
8jn.
8jp.
8jr.
8js.
8jt.
8jv.
8jw.
8jx.
8jz.
8k.
8k^^a2.
8k^^aa.
8k^^ab.
8k^^b1.
8k^^b9.
8k^^bb.
8kb.
8kc.
8kd.
8kf.
8kg.
8kh.
8kj.
8kk.
8kl.
8km.
8kn.
8kp.
8kr.
8ks.
8kst.
8kt.
8kv.
8kw.
8kx.
8kz.
8l.
8l^^a2.
8l^^aa.
8l^^ab.
8l^^b1.
8l^^b9.
8l^^bb.
8lb.
8lc.
8ld.
8lf.
8lg.
8lh.
8lj.
8lk.
8ll.
8lm.
8ln.
8lp.
8lr.
8ls.
8lt.
8lv.
8lw.
8lx.
8lz.
8m.
8m^^a2.
8m^^aa.
8m^^ab.
8m^^b1.
8m^^b9.
8m^^bb.
8mb.
8mc.
8md.
8mf.
8mg.
8mh.
8mj.
8mk.
8ml.
8mm.
8mn.
8mp.
8mr.
8ms.
8mst.
8mt.
8mv.
8mw.
8mx.
8mz.
8n.
8n^^a2.
8n^^aa.
8n^^ab.
8n^^b1.
8n^^b9.
8n^^bb.
8nb.
8nc.
8nd.
8nf.
8ng.
8nh.
8nj.
8nk.
8nl.
8nm.
8nn.
8np.
8nr.
8ns.
8nt.
8nv.
8nw.
8nx.
8nz.
8p.
8p^^a2.
8p^^aa.
8p^^ab.
8p^^b1.
8p^^b9.
8p^^bb.
8pb.
8pc.
8pd.
8pf.
8pg.
8ph.
8pj.
8pk.
8pl.
8pm.
8pn.
8pp.
8pr.
8prz.
8ps.
8pt.
8pv.
8pw.
8px.
8pz.
8r.
8r^^a2.
8r^^aa.
8r^^ab.
8r^^b1.
8r^^b9.
8r^^bb.
8rb.
8rc.
8rd.
8rf.
8rg.
8rh.
8rj.
8rk.
8rl.
8rm.
8rn.
8rp.
8rr.
8rs.
8rsz.
8rt.
8rv.
8rw.
8rx.
8rz.
8rz^^aa.
8s.
8s^^a2.
8s^^aa.
8s^^ab.
8s^^b1.
8s^^b9.
8s^^bb.
8sb.
8sc.
8sch.
8sd.
8sf.
8sg.
8sh.
8sj.
8sk.
8skrz.
8sl.
8sm.
8sn.
8sp.
8sr.
8ss.
8st.
8str.
8strz.
8stw.
8sv.
8sw.
8sx.
8sz.
8szcz.
8szczb.
8szk.
8szn.
8szt.
8sztr.
8t.
8t^^a2.
8t^^aa.
8t^^ab.
8t^^b1.
8t^^b9.
8t^^bb.
8tb.
8tc.
8td.
8tf.
8tg.
8th.
8tj.
8tk.
8tl.
8tm.
8tn.
8tp.
8tr.
8trz.
8ts.
8tt.
8tv.
8tw.
8tx.
8tz.
8v.
8v^^a2.
8v^^aa.
8v^^ab.
8v^^b1.
8v^^b9.
8v^^bb.
8vb.
8vc.
8vd.
8vf.
8vg.
8vh.
8vj.
8vk.
8vl.
8vm.
8vn.
8vp.
8vr.
8vs.
8vt.
8vv.
8vw.
8vx.
8vz.
8w.
8w^^a2.
8w^^aa.
8w^^ab.
8w^^b1.
8w^^b9.
8w^^bb.
8wb.
8wc.
8wd.
8wf.
8wg.
8wh.
8wj.
8wk.
8wl.
8wm.
8wn.
8wp.
8wr.
8ws.
8wt.
8wv.
8ww.
8wx.
8wz.
8x.
8x^^a2.
8x^^aa.
8x^^ab.
8x^^b1.
8x^^b9.
8x^^bb.
8xb.
8xc.
8xd.
8xf.
8xg.
8xh.
8xj.
8xk.
8xl.
8xm.
8xn.
8xp.
8xr.
8xs.
8xt.
8xv.
8xw.
8xx.
8xz.
8z.
8z^^a2.
8z^^aa.
8z^^ab.
8z^^b1.
8z^^b9.
8z^^bb.
8zb.
8zc.
8zd.
8zdr.
8zdrz.
8zf.
8zg.
8zh.
8zj.
8zk.
8zl.
8zm.
8zn.
8zp.
8zr.
8zs.
8zt.
8zv.
8zw.
8zx.
8zz.
a1
a2u
a2y
aa2
ae2
ai2
ao2
be2eth
be2f3sz2
be2k1hend
bi2n3o2ku
bi2sz3kop
bi2z3ne2s3m
bi2z3nes
birmin2g1ham
blo2k1hauz
bo2s3ma
br2d
bro2a2d3way
bu2sz3me
buk2sz3pan
busine2ss3m
busines2s
c4h
c4z
cal2d1well
ch2^^aa
ch2j
ch2l
ch2r
ch2w
chus1t
cu2r7zon
d^^bb2^^aa
d^^bb2j
d^^bb2l
d^^bb2r
d^^bb2w
d^^bbe4z3b
d^^bbe4z3m
d4^^b9
d4^^bb
d4z
deut4sch3land
drz2w
du2sz3past
e1
e2r5zac
e2u
e2y
e3u2sz
ea2
ee2
ei2
eo2
fi2s3harm
fi2sz3bin
fo2k2s3t
fo2r5zac
fol2k1lor
fos2f1a2zot
ga3d2get
gado3p2ta
gol2f3s
golfsz2
gran2d1ilo
gro4t3r
hi2sz3p
hu2cz1w
hu2x3ley
i1
i2^^a1
i2^^a6
i2^^f3
i2a
i2e
i2i
i2o
i2u
i2y
in4nsbruck
in4sbruc
j2t1^^aa
j2t1r
ja4z4z3b
ja4z4z3m
karl2s1kron
karl2s1ruhe
kir2chhoff
kongre2s3m
led1w
lu2ft3waffe
lu2ks1fer
ly2o
ma2r5z^^aa
ma2r5zl
ma2r5zn
mi2sz1masz
mie2r5z^^aa
mie2r5zi
mon2t3real
moza2i3k
mu2r7zasich3l
na4^^aa3kows
na4r3v
o1
o2y
oa2
och3mistrz
oe2
of2f3set
oi2
oo2
ou2
pa2n3a2mer
pa2s3cal
pa2s3ch
po^^aau3d2ni
po3d4nieprz
po3m2n^^a1
po3m2n^^a6
po3m2ni
po4rt2s3mo2uth
po4rt3land
poli3e2t
poli3u2re
powsze3d2ni
pr2chal
pre2sz3pa
r4z
ro2e3nt2gen
ro2k3rocz
ro2s3to3c2k
s4z
se2t3le
sko2r5zoner
sm2r
sowi3z2
sy2n3opt
sy2s1tem
sza2sz1^^aay
sze2z1long
sze4^^b1^^a2
szto2k1holm
szyn2k1was
to3y2o3t
turboo2d3rzut
tygo3d2ni
u1
u2y
ua2
ue2
ui2
uo2
uu2
vo2lk2s3
we2e2k1end
we4st3f
we4st3m
y1
ya2
ye2
yi2
yo2
yu2
ze4p3p
}
\hyphenation{
be-zach
be-zami
by-naj-mniej
gdzie-nie-gdzie
ina-czej
na-dal
ni-gdy
ni-gdzie
niech-^^bbe
niech-by
ow-szem
p^^f3-^^aaach
p^^f3-^^aaami
p^^f3-^^aaek
pod-^^f3w-czas
przy-naj-mniej
sk^^a1d-in^^a1d
tr^^f3-jach
tr^^f3-jami
tr^^f3-jek
}
\egroup

