# WARNING: This file is autogenerated from following files:
#
#            lib/HTTP/WebTest.pm.in
#            lib/HTTP/WebTest.pm.in
#            lib/HTTP/WebTest/Plugin/Click.pm
#            lib/HTTP/WebTest/Plugin/ContentSizeTest.pm
#            lib/HTTP/WebTest/Plugin/Cookies.pm
#            lib/HTTP/WebTest/Plugin/DefaultReport.pm
#            lib/HTTP/WebTest/Plugin/Delay.pm
#            lib/HTTP/WebTest/Plugin/HarnessReport.pm
#            lib/HTTP/WebTest/Plugin/Hooks.pm
#            lib/HTTP/WebTest/Plugin/Loader.pm
#            lib/HTTP/WebTest/Plugin/ResponseTimeTest.pm
#            lib/HTTP/WebTest/Plugin/SetRequest.pm
#            lib/HTTP/WebTest/Plugin/StatusTest.pm
#            lib/HTTP/WebTest/Plugin/TextMatchTest.pm
#            lib/HTTP/WebTest/ReportPlugin.pm
#
# Do not modify this file but edit those files. All changes in this
# file will be lost.


# This is a -*-perl-*- source file


package HTTP::WebTest;

$VERSION = '2.02';

# actual content of HTTP::WebTest package is in HTTP::WebTest::API
require HTTP::WebTest::API;

=head1 NAME

HTTP::WebTest - Testing static and dynamic web content

=head1 SYNOPSIS

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;

    # run test from file
    $webtest->run_wtscript('script.wt');

    # or (to pass test parameters as method arguments)
    $webtest->run_tests($tests);

=head1 DESCRIPTION

=head2 Introduction

This module runs tests on remote URLs containing
Perl/JSP/HTML/JavaScript/etc. and generates a detailed test report.
This module can be used "as-is" or its functionality can be extended
using plugins.  Plugins can define test types and provide additional
report capabilities.  This module comes with a set of default plugins
but can be easily extended with third party plugins.

The L<wt|wt> script is provided for running C<HTTP::WebTest> from the
command line.

The test specifications can be read from a parameter file in wtscript
format or input as method arguments.  The test results can be
displayed on the terminal, directed to a file, stored in a scalar
variable.  The test results can also be emailed.  The report can be
modified and extended using report plugins.

Each URL/web file is tested by fetching it from the web server using a
local instance of an HTTP user agent.  The basic test is simply
whether or not the fetch was successful.  You may also test using
literal strings or regular expressions that are either required to
exist or forbidden to exist in the fetched page.  You may also specify
tests for the minimum and maximum number of bytes in the returned
page.  You may also specify tests for the minimum and maximum web
server response time.

Data flow for C<HTTP::WebTest>:

          --------------              -------------
          |            |              |           |
          | Input      |------------->|  WebTest  |
          | parameters |              |           |
          |            |              -------------
          --------------                  |   ^
                                          |   |
                                          V   |
          -------------               ------------
          |           |    request    |          |
          | Remote    |<--------------|   HTTP   |
          | webserver |-------------->|   user   |
          |           |    response   |   agent  |
          -------------               |          |
                                      ------------

=head2 Getting started

This module has complex functionality, but using it to run simple
tests is simple.  Create a file of test parameters in the
L<wtscript format|Running HTTP::WebTest using a parameter file> and use the
L<wt|wt> program to process the file using the command C<wt
filename>.  The only required parameters are C<test_name> and C<url>.

This document describes:

=over 4

=item *

How tests can be specified.  See section
L<TEST SPECIFICATION|TEST SPECIFICATION>.

=item *

All test parameters supported by core C<HTTP::WebTest>
plugins.  See section L<TEST PARAMETERS|TEST PARAMETERS>.

=back

See L<"perldoc wt"|wt> for documentation on the wt program.

Other useful documentation is:

=over 4

=item *

L<perldoc HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook> - examples
of wtscript files and examples of C<HTTP::WebTest> API usage.

=item *

L<perldoc HTTP::WebTest::API|HTTP::WebTest::API> - full documentaion
on API of C<HTTP::WebTest>.

=item *

L<perldoc HTTP::WebTest::Plugins|HTTP::WebTest::Plugins> - for
developers of C<HTTP::WebTest> plugins.

=back

=head1 TEST SPECIFICATION

The test specifications can be read from a parameter file (in the
wtscript format described below) or passed as method arguments as an
array of hashes.

=head2 Running HTTP::WebTest using a parameter file

C<HTTP::WebTest> can read test specification from file
in format called as C<wtscript>.

Tests defined by wtscript file can be
run either using Perl API of C<HTTP::WebTest>

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;
    $webtest->run_wtscript('script.wt');

or by using program L<wt|wt> supplied with this module.

If you are running dozens of tests, you may want to divide them into
several parameter files.  This will organize the tests and reduce the
size of the output and e-mail messages.  However, cookies passed to or
received from the web server(s) are not shared between tests in
different parameter files.

=head3 File format

The wtscript file is a text file containing global parameters and test
blocks containing test block parameters.  A test block begins with a
test_name parameter and ends with an end_test directive.  The order of
the parameters and test blocks is arbitrary.

Test block parameters MUST occur between a test_name parameter and an
end_test directive.  (Test block parameters affect only an individual
test.) Global parameters must NOT occur between a test_name parameter
and an end_test directive.  (This requirement does not apply to
certain parameters that are both global and test block parameters.)

The following lines are ignored:

=over 4

=item *

lines consisting of nothing but white space (blanks or tabs)

=item *

lines beginning with a number sign (C<#>)

=item *

lines beginning with white space (blanks or tabs) followed by a number
sign

=back

Parameters are either scalar (single-valued) or lists (single-valued,
multi-valued or nested).

You can specify scalar parameters using forms such as:

    name=value
    name =
           value
    name = 'value'

You can specify list parameters using forms such as:

    name = ( first value
             second value )
    name=( first value => second value
           third value => fourth value
         )
    name = ( first value => second value )
    name = (
             'first value'
             'second value' )
    name= (
             first value
             second value
             third value => 'fourth value'
          )
    name =
           ( first value
             'second value' )
    name = (
             'first value'
             'second value'
           )

Lists can be nested. For example:

    name = ( ( first value
               second value ) )

    name = ( 'third value'
             ( fourth value => fifth value ) )

    name = (
             ( first value
               second value )
             third value
             ( fourth value => fifth value )
           )

You can specify a null (placeholder) value using '' or "".  Within
single or double quotes, the usual Perl string quoting rules apply.
Thus, single quotes mean that all enclosed characters are interpreted
literally: '\n' is backslash-n rather than a newline character.
Double quotes mean that Perl metasymbols are interpreted: "\n\t" is a
newline and a tab.  Double quoted strings can also contain Perl
variables that will be evaluated by Perl.  For example, if the variable
$myvar contains the string 'foobar', "$myvar" will be replaced by foobar
at runtime.  Perl variables can be defined by plugin
modules or in code sections in the parameter file as described below.

It is also possible to specify a Perl expression in place of a scalar
value, one of a list parameter's values or an entire list.  Curly
brackets are used to denote Perl code inside wtscript files.
C<HTTP::WebTest> compiles this Perl code as anonymous subroutines
which are called when values of corresponding test parameters are
required.  When these subroutines are called C<HTTP::WebTest> object
is passed to them as the first argument.

Some examples of syntax:

    # scalar value
    name = { 1 + 1 }

    # element of a list
    name = (
             'first value'
             { "second " . "value" }
           )

    # entire list (must be a reference to an array)
    name = { [ a => 'b', c => 'd' ] }

    # accessing HTTP::WebTest object
    name = { my $webtest = shift; ..... }

=head3 Examples of wtscript files

The parameters below specify tests.  The tests specified by the
C<text_forbid> parameter apply to both the "MyCompany home page" and
the "Yahoo home page" tests.  Hence, if either returned page contains
one of the case-insensitive strings in text_forbid, the test fails.
If any test fails or the fetch of the URL fails, an e-mail will be
sent to tester@mycompany.com.


    apache_exec = /usr/sbin/apache
    ignore_case = yes
    mail = errors
    mail_addresses = ( tester@mycompany.com )
    mail_server = mailhost.mycompany.com
    text_forbid = ( Premature end of script headers
                    an error occurred while processing this directive
                  )

    test_name = 'MyCompany home page (static)'
        file_path = ( raycosoft_home.html => . )
        text_require = (
            <a href="/dept/peopledev/new_employee/"><font color="#0033cc">
            <a href="https://www.raycosoft.com/"><font color=
                       )
    end_test

    test_name = Yahoo home page
        url = www.yahoo.com
        text_require = ( <a href=r/qt>Quotations</a>...<br> )
        min_bytes = 13000
        max_bytes = 99000
        min_rtime = 0.010
        max_rtime = 30.0
    end_test

=head2 Calling HTTP::WebTest from a Perl program

If you are using the Perl API of C<HTTP::WebTest>, the test parameters
can be defined as an array of hashes.

Each hash in the array defines tests for one URL.  Keys in the hashes
are test parameter names and values in hashes are values of test
parameters.  Optional global test parameters can be passed in a hash
passed as the second argument.

Subroutine references can be specified instead of test parameter values.
Referenced subroutines are called during test run when
values of corresponding test parameters are required.  These subroutines are
called in an object-oriented fashion, so the C<HTTP::WebTest> object is passed
as the first argument.

Tests can be run as

    use HTTP::WebTest;

    my $webtest = new HTTP::WebTest;
    $webtest->run_tests(
                        [ # test 1
                          { param1 => value1,
                            param2 => value2 },
                          # test 2
                          { param1 => value1,
                            param2 => value2 },
                        ],
                        { global_param1 => value1,
                          global_param2 => value2 }
                       );

=head3 Example

This Perl script tests Yahoo home page and sends full test report to
C<tester@mycompany.com>.

    use HTTP::WebTest;

    my $tests = [
                 { test_name    => 'Yahoo home page',
                   url          => 'http://www.yahoo.com',
                   text_require => [ '<a href=r/qt>Quotations</a>...<br>' ],
                   min_bytes    => 13000,
                   max_bytes    => 99000,
                 }
                ];

    my $params = { mail_server    => 'mailhost.mycompany.com',
                   mail_addresses => [ 'tester@mycompany.com' ],
                   mail           => 'all',
                   ignore_case    => 'yes',
                 };

    my $webtest = new HTTP::WebTest;
    $webtest->run_tests($tests, $params);

=head1 PLUGIN MODULES

=head2 Core plugin modules

C<HTTP::WebTest> is implemented in a modular structure that allows
programmers to easily add modules to run additional tests or define
additional simple tests without writing a module.  C<HTTP::WebTest>
provides a number of core plugin modules which are loaded by default:

=over 4

=item L<HTTP::WebTest::Plugin::ContentSizeTest|HTTP::WebTest::Plugin::ContentSizeTest>

This plugin checks the size of the fetched web page.

=item L<HTTP::WebTest::Plugin::Cookies|HTTP::WebTest::Plugin::Cookies>

This plugin controls sending and receiving cookies.

=item L<HTTP::WebTest::Plugin::DefaultReport|HTTP::WebTest::Plugin::DefaultReport>

This plugin manages the test report.

=item L<HTTP::WebTest::Plugin::Loader|HTTP::WebTest::Plugin::Loader>

This plugin supports adding external plugin modules.

=item L<HTTP::WebTest::Plugin::ResponseTimeTest|HTTP::WebTest::Plugin::ResponseTimeTest>

This plugin tests the response times of the web server.

=item L<HTTP::WebTest::Plugin::SetRequest|HTTP::WebTest::Plugin::SetRequest>

This plugin initializes the HTTP requests.

=item L<HTTP::WebTest::Plugin::StatusTest|HTTP::WebTest::Plugin::StatusTest>

This plugin checks the status of the HTTP responses.

=item L<HTTP::WebTest::Plugin::TextMatchTest|HTTP::WebTest::Plugin::TextMatchTest>

This plugin tests whether the content of the HTTP response matches or doesn't
match selected text or regular expressions.

=back

Information about test parameters supported by core plugins is
summarized below in the section L<TEST PARAMETERS|TEST PARAMETERS>.

=head2 Other plugin modules bundled with HTTP::WebTest

Following plugin modules come with HTTP::WebTest but they are not
loaded by default.  To use such plugin module load it using global
test parameter C<plugins>.

=over 4

=item L<HTTP::WebTest::Plugin::Click|HTTP::WebTest::Plugin::Click>

This plugin supports using names of links and buttons on HTML pages to
build additional tests.

=item L<HTTP::WebTest::Plugin::Delay|HTTP::WebTest::Plugin::Delay>

This plugin module allows the user to specify pauses in the test sequence.

=item L<HTTP::WebTest::Plugin::HarnessReport|HTTP::WebTest::Plugin::HarnessReport>

This report plugin can generate test reports that are compatible with
L<Test::Harness|Test::Harness>.

=item L<HTTP::WebTest::Plugin::Hooks|HTTP::WebTest::Plugin::Hooks>

This plugin allows the user to define callback parameters that are
evaluated at runtime.  This allows the user to define additional tests
without writing a plugin module.

=back

Information about test parameters supported by add-on plugin modules
is summarized below in section L<TEST PARAMETERS|TEST PARAMETERS>.

=head2 Plugin modules released separately from HTTP::WebTest

Following additional C<HTTP::WebTest> plugins are avialable separately
from CPAN.

=over 4

=item L<HTTP::WebTest::Plugin::Apache|HTTP::WebTest::Plugin::Apache>

This plugin supports testing web files using a local instance of Apache.

=item L<HTTP::WebTest::Plugin::TagAttTest|HTTP::WebTest::Plugin::TagAttTest>

This plugin allows to forbid or require tags and/or attributes in a web page.

=item L<HTTP::WebTest::Plugin::DateTest|HTTP::WebTest::Plugin::DateTest>

Evaluate the "age" of embedded date strings in response body.

=item L<HTTP::WebTest::Plugin::XMLReport|HTTP::WebTest::Plugin::XMLReport>

Report plugin for HTTP::WebTest, generates output in XML format.

=back

=head2 Writing plugin modules

See L<perldoc HTTP::WebTest::Plugins|HTTP::WebTest::Plugins> for
information about writing L<HTTP::WebTest|HTTP::WebTest> plugin modules.

=head1 TEST PARAMETERS

Most parameters can be used as both global and test block
parameters.  If you specify such parameter outside a test block, that value
is the default value for all test blocks.  The global value can be
overriden in each test block by specifying the parameter within the test
block.

Parameters marked as I<GLOBAL PARAMETER> can be used only as global
and cannot be overriden in test blocks.

Parameters marked as I<NON-CORE PARAMETER> are defined in add-on
plugin modules which must be loaded explicitly using the parameter
C<plugins>.

=head2 accept_cookies

Option to accept cookies from the web server.

These cookies exist only while the program is executing and do not
affect subsequent runs.  These cookies do not affect your browser or
any software other than the test program.  These cookies are only
accessible to other tests executed during test sequence execution.

See also the <send_cookies> parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 auth

A list which contains two elements: userid/password pair to be used
for web page access authorization.

=head2 click_button

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Click>

Given name of submit button (i.e. C<<input type="submit"E<gt>> tag or
C<<input type="image"E<gt>> inside of C<<formE<gt>> tag) on previously
requested HTML page, builds test request to the submitted page.

Note that you still need to pass all form parameters yourself using
C<params> test parameter.

=head3 Example

See example in L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>.

=head2 click_link

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Click>

Given name of link (i.e. C<<aE<gt>> tag) on previosly requested HTML
page, builds test request to the linked page.

=head3 Example

See example in L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>.

=head2 cookie

Synonym to C<cookies>.

It is deprecated parameter and may be removed in future versions of
L<HTTP::WebTest|HTTP::WebTest>.

=head2 cookies

This is a list parameter that specifies cookies to send to the web
server:

    cookies = ( cookie1_spec
                cookie2_spec
                ...
                cookieN_spec )

Currently there are two ways to specify a cookie.

=over 4

=item * Named style

A cookie is specified by a set of C<param =E<gt> value> pairs:

    (
      param => value
      ...
    )

List of all supported C<param =E<gt> value> pairs:

=over 4

=item version => VERSION

Version number of cookie spec to use, usually 0.

=item name => NAME (REQUIRED)

Name of cookie.  Cannot begin with a $ character.

=item value => VALUE (REQUIRED)

Value of cookie.

=item path => PATH (REQUIRED)

URL path name for which this cookie applies.  Must begin with a /
character.  See also path_spec.

=item domain => DOMAIN (REQUIRED)

Domain for which cookie is valid.  Must either contain two periods or
be equal to C<.local>.

=item port => PORT

List of allowed port numbers that the cookie may be returned to.  If
not specified, cookie can be returned to any port.  Must be specified
using the format C<N> or C<N, N, ..., N> where N is one or more
digits.

=item path_spec => PATH_SPEC

Ignored if version is less than 1.  Option to ignore the value of
path.  Default value is 0.

=over 4

=item * 1

Use the value of path.

=item * 0

Ignore the specified value of path.

=back

=item secure => SECURE

Option to require secure protocols for cookie transmission.  Default
value is 0.

=over 4

=item * 1

Use only secure protocols to transmit this cookie.

=item * 0

Secure protocols are not required for transmission.

=back

=item maxage => MAXAGE

Number of seconds until cookie expires.

=item discard => DISCARD

Option to discard cookie when the program finishes.  Default is 0.
(The cookie will be discarded regardless of the value of this
element.)

=over 4

=item * 1

Discard cookie when the program finishes.

=item * 0

Don't discard cookie.

=back

=item rest => NAME_VALUE_LIST

Defines additional cookie attributes.

Zero, one or several name/value pairs may be specified.  The name
parameters are words such as Comment or CommentURL and the value
parameters are strings that may contain embedded blanks.

=back

Example (wtscript file):

    cookies = ( ( name   => Cookie1
                  value  => cookie value )

                ( name   => Cookie2
                  value  => cookie value
                  path   => /
                  domain => .company.com ) )

                ( name   => Cookie2
                  value  => cookie value
                  rest   => ( Comment => this is a comment ) )

Example (Perl script):

    my $tests = [
                  ...
                  {
                    test_name => 'cookie',
                    cookies   => [ [
                                     name  => 'Cookie1',
                                     value => 'Value',
                                   ],
                                   [
                                     name  => 'Cookie2',
                                     value => 'Value',
                                     path  => '/',
                                   ] ],
                    ...
                  }
                  ...
                ]

=item * Row list style

This style of cookie specification is deprecated and may be removed in
future versions of L<HTTP::WebTest|HTTP::WebTest>.

Each cookie is specified by following list:

    ( VERSION
      NAME
      VALUE
      PATH
      DOMAIN
      PORT
      PATH_SPEC
      SECURE
      MAXAGE
      DISCARD
      NAME1
      VALUE1
      NAME2
      VALUE2
      ...
    )


Any element not marked below as REQUIRED may be defaulted by
specifying a null value or ''.

=over 4

=item * VERSION (REQUIRED)

Version number of cookie spec to use, usually 0.

=item * NAME (REQUIRED)

Name of cookie.  Cannot begin with a $ character.

=item * VALUE (REQUIRED)

Value of cookie.

=item * PATH (REQUIRED)

URL path name for which this cookie applies.  Must begin with a /
character.  See also path_spec.

=item * DOMAIN (REQUIRED)

Domain for which cookie is valid.  Must either contain two periods or
be equal to C<.local>.

=item * PORT

List of allowed port numbers that the cookie may be returned to.  If
not specified, cookie can be returned to any port.  Must be specified
using the format C<N> or C<N, N, ..., N> where N is one or more
digits.

=item * PATH_SPEC

Ignored if version is less than 1.  Option to ignore the value of
path.  Default value is 0.

=over 4

=item * 1

Use the value of path.

=item * 0

Ignore the specified value of path.

=back

=item * SECURE

Option to require secure protocols for cookie transmission.  Default
value is 0.

=over 4

=item * 1

Use only secure protocols to transmit this cookie.

=item * 0

Secure protocols are not required for transmission.

=back

=item * MAXAGE

Number of seconds until cookie expires.

=item * DISCARD

Option to discard cookie when the program finishes.  Default is 0.
(The cookie will be discarded regardless of the value of this
element.)

=over 4

=item * 1

Discard cookie when the program finishes.

=item * 0

Don't discard cookie.

=back

=item * name/value

Zero, one or several name/value pairs may be specified.  The name
parameters are words such as Comment or CommentURL and the value
parameters are strings that may contain embedded blanks.

=back

An example cookie would look like:

    cookies = ( ( 0
                  WebTest cookie #1
                  cookie value
                  /
                  .mycompany.com
                  ''
                  0
                  0
                  200
                  1
                ) )

=back

See RFC 2965 for details (ftp://ftp.isi.edu/in-notes/rfc2965.txt).

=head2 default_report

I<GLOBAL PARAMETER>

This parameter controls whether the default report plugin is used for
test report creation.  Value C<yes> means that default report plugin
will be used, value C<no> means that it will not.
It can also be used to disable all output 
(i.e. if this parameter has value C<no> and no other report plugins
are loaded).

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 delay

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Delay>

Duration of pause (in seconds) before running test.

=head3 Allowed values

Any number greater that zero.

=head2 end_test

This is not really a parameter, it is part of
L<wtscript format|Running HTTP::WebTest using a parameter file>.
It marks the end of test block.

=head2 fh_out

I<GLOBAL PARAMETER>

A filehandle (or anything else that supports C<print>) to use for test
report output.  This parameter is ignored if test parameter
C<output_ref> is specified also.

This parameter can be used only when passing the test parameters
as arguments from a calling Perl script.

=head2 form_name

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Click>

Give form name attribute (i.e. C<<form name="foo"E<gt>>) on previously
 requested HTML page, builds test request to the submitted page.

Note that you still need to pass all form parameters yourself using
C<params> test parameter.

=head2 handle_redirects

If set to C<yes> then HTTP-WebTest automatically follows redirects.
It means that you never see HTTP responses with status codes 301 and
302.  This feature is disabled if this test parameter is set to C<no>.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 http_headers

A list of HTTP header/value pairs.  Can be used to override default
HTTP headers or to add additional HTTP headers.

=head3 Example

    http_headers = ( Accept => text/plain, text/html )

=head2 ignore_case

Option to do case-insensitive string matching for C<text_forbid>,
C<text_require>, C<regex_forbid> and C<regex_require> test parameters.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 mail

I<GLOBAL PARAMETER>

Option to e-mail output to one or more addresses specified by
C<mail_addresses> test parameter.

=over 4

=item * all

Send e-mail containing test results.

=item * errors

Send e-mail only if one or more tests fails.

=item * no

Do not send e-mail.

=head3 Default value

C<no>

=back

=head2 mail_addresses

I<GLOBAL PARAMETER>

A list of e-mail addresses where report will be send (if sending
report is enabled with C<mail> test parameter).

=head2 mail_from

I<GLOBAL PARAMETER>

Sets From: header for test report e-mails.

=head3 Default Value

Name of user under which test script runs.

=head2 mail_server

I<GLOBAL PARAMETER>

Fully-qualified name of of the mail server (e.g., mailhost.mycompany.com).

=head3 Default value

C<localhost>

=head2 max_bytes

Maximum number of bytes expected in returned page.

=head3 Allowed values

Any integer greater that zero and greater than C<min_bytes> (if
C<min_bytes> is specified).

=head2 max_rtime

Maximum web server response time (seconds) expected.

=head3 Allowed values

Any number greater that zero and greater than C<min_rtime> (if
C<min_rtime> is specified).

=head2 method

HTTP request method.

See RFC 2616 (HTTP/1.1 protocol).

=head3 Allowed values

C<GET>, C<POST>

=head3 Default value

C<GET>

=head2 min_bytes

Minimum number of bytes expected in returned page.

=head3 Allowed values

Any integer less than C<max_bytes> (if C<max_bytes> is specified).

=head2 min_rtime

Minimum web server response time (seconds) expected.

=head3 Allowed values

Any number less than C<max_rtime> (if C<max_rtime> is specified).

=head2 on_finish

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Hooks>

The value of this test parameter is ignored.  However, it is evaluted
before the test sequence is run, so it can be used to run finalization
code when the test sequence is finished.

=head3 Example

See example in L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>.

=head2 on_request

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Hooks>

The value of this test parameter is ignored.  However, it is evaluted
before the HTTP request is done, so it can be used to do
initalization before the request.

=head2 on_response

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Hooks>

This is a list parameter which is treated as test result.  It is
evaluted when the HTTP response for the test request is received.

It can be used to define custom tests without writing new plugins.
It can also be used to run some code when the HTTP response for the test
request is received.

=head3 Allowed values

    ( YESNO1, COMMENT1
      YESNO2, COMMENT2
      ....
      YESNON, COMMENTN )

Here C<YESNO>, C<COMMENT> is a test result.  C<YESNO> is either
C<yes> if test is successful or C<no> if it is not.  C<COMMENT> is a
comment associated with this test.

=head3 Example

See example in L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>.

=head2 on_start

I<NON-CORE PARAMETER> from L<HTTP::WebTest::Plugin::Hooks>

The value of this test parameter is ignored.  However, it is evaluted
before the test sequence is run, so it can be used to do initalization
before the test sequence run.

=head3 Example

See example in L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>.

=head2 output_ref

I<GLOBAL PARAMETER>

A reference to a scalar that accumulates text of test report.  If this
test parameter is specified then value of test parameter C<fh_out> is
ignore.

This parameter can be used only when passing the test parameters
as arguments from a calling Perl script.

=head2 params

A list of name/value pairs to be passed as parameters to the URL.
(This element is used to test pages that process input from forms.)

If the method key is set to C<GET>, these pairs are URI-escaped and
appended to the requested URL.

Example (wtscript file):

    url = http://www.hotmail.com/cgi-bin/hmhome
    params = ( curmbox
               F001 A005
               from
               HotMail )

generates the HTTP request with URI:

    http://www.hotmail.com/cgi-bin/hmhome?curmbox=F001%20A005&from=HotMail

If the method key is set to C<POST>, as long as all values are scalars
they are URI-escaped and put into content of the HTTP request.
C<application/x-www-form-urlencoded> content type is set for such HTTP
request.

If the method key is set to C<POST>, some values may be defined as
lists.  In this case L<HTTP::WebTest|HTTP::WebTest> uses
C<multipart/form-data> content type used for C<Form-based File Upload>
as specified in RFC 1867.  Each parameter with list value is treated
as file part specification with the following interpretation:

    ( FILE, FILENAME, HEADER => VALUE... )

where

=over 4

=item * FILE

The name of a file to open. This file will be read and its content
placed in the request.

=item * FILENAME

The optional filename to be reported in the request.  If it is not
specified than basename of C<FILE> is used.

=item * HEADER => VALUE

Additional optional headers for file part.

=back

Example (wtscript file):

    url = http://www.server.com/upload.pl
    method = post
    params = ( submit => ok
               file   => ( '/home/ilya/file.txt', 'myfile.txt' ) )

It generates HTTP request with C</home/ilya/file.txt> file included
and reported under name C<myfile.txt>.

=head2 pauth

A list which contains two elements: userid/password pair to be used
for proxy server access authorization.

=head2 plugins

I<GLOBAL PARAMETER>

A list of module names.  Loads these modules and registers them as
L<HTTP::WebTest|HTTP::WebTest> plugins.  If the name of the plugin starts with
C<::>, it is prepended with C<HTTP::WebTest::Plugin>.  So

    plugins = ( ::Click )

is equal to

    plugins = ( HTTP::WebTest::Plugin::Click )

=head2 proxies

A list of service name/proxy URL pairs that specify proxy servers to
use for requests.

=head3 Example

    proxies = ( http => http://http_proxy.mycompany.com
                ftp  => http://ftp_proxy.mycompany.com )

=head2 regex_forbid

List of regular expressions that are forbidden to exist in the
returned page.

For more information, see L<perldoc perlre|perlre> or see Programming
Perl, 3rd edition, Chapter 5.

See also the C<text_forbid> and C<ignore_case> parameters.

=head2 regex_require

List of regular expressions that are required to exist in the
returned page.

For more information, see L<perldoc perlre|perlre> or see Programming Perl,
3rd edition, Chapter 5.

See also the C<text_require> and C<ignore_case> parameters.

=head2 relative_urls

If set to C<yes> than C<HTTP-WebTest> supports relative URLs.  See
test parameter C<url> for more information.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 send_cookies

Option to send cookies to web server.  This applies to cookies
received from the web server or cookies specified using the C<cookies>
test parameter.

This does NOT give the web server(s) access to cookies created with a
browser or any user agent software other than this program.  The
cookies created while this program is running are only accessible to
other tests in the same test sequence.

See also the <accept_cookies> parameter.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<yes>

=head2 show_cookies

Option to display any cookies sent or received.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 show_headers

Include request and response headers in the test report.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 show_html

Include content of HTTP response in the test report.

=head3 Allowed values

C<yes>, C<no>

=head3 Default value

C<no>

=head2 status_code

Given numeric HTTP Status Code, tests response returned that value.

=head3 Default value

C<200> (OK).

=head2 terse

Option to display shorter test report.

=over 4

=item * summary

Only a one-line summary for each URL

=item * failed_only

Only tests that failed and the summary

=item * no

Show all tests and the summary

=head3 Default value

C<no>

=back

=head2 test_name

Name associated with this URL in the test report and error messages.

=head2 text_forbid

List of text strings that are forbidden to exist in the returned
page.

See also the C<regex_forbid> and C<ignore_case> parameters.

=head2 text_require

List of text strings that are required to exist in the returned
page.

See also the C<regex_require> and C<ignore_case> parameters.

=head2 timeout

Set the timeout value in seconds.

=head3 Default value

C<180>

=head2 url

URL to test.

If test parameter C<relative_urls> is set to C<yes> than URL for each
test is treated as relative to the URL in the previous test.  URL in
the first test is treated as relative to C<http://localhost>.

If test parameter C<relative_urls> is set to C<no> than each URL is
treated as absolute.  In this case if schema part of URL is omitted
(i.e. URL doesn't start with C<http://>, C<ftp://>, etc) then
C<http://> is implied.

=head2 user_agent

Set the product token that is used to identify the user agent on
the network.

=head3 Default value

C<HTTP-WebTest/NN>

where C<NN> is version number of HTTP-WebTest.


=cut

=head1 RESTRICTIONS / BUGS

This module have been tested only on Unix (e.g., Solaris, Linux, AIX,
etc.) but it should work on Win32 systems.

If you want to test https:// web sites you may have to install
additional modules to enable SSL support in L<LWP>.  In short you may
have to install L<Crypt::SSLeay> module.  For details see README.SSL
file in L<LWP> distro.

=head1 AUTHORS

Richard Anderson <richard@richard-anderson.org> wrote
C<HTTP::WebTest 1.xx>, using some ideas from the CPAN Monkeywrench module.

Ilya Martynov <ilya@martynov.org> implemented the plug-in concept, the
extended API and completely rewrote C<HTTP::WebTest>.

Please don't email authors directly.  Use the SourceForge
C<HTTP::WebTest> mail list (see SUPPORT, next section).

=head1 SUPPORT

Please email bug reports, suggestions, questions, etc. to the SourceForge
C<HTTP::WebTest> maillist.
You can sign up at
http://lists.sourceforge.net/lists/listinfo/http-webtest-general .
The email address is C<http-webtest-general@lists.sourceforge.net>.

=head1 COPYRIGHT

Copyright (c) 2000-2001 Richard Anderson.  All rights reserved.

Copyright (c) 2001-2003 Ilya Martynov.  All rights reserved.

This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=head1 SEE ALSO

L<HTTP::WebTest::Cookbook|HTTP::WebTest::Cookbook>

L<HTTP::WebTest::API|HTTP::WebTest::API>

L<HTTP::WebTest::Plugins|HTTP::WebTest::Plugins>

L<wt|wt>

=cut

1;
