class NESMusicAgent is MusicAgent
{	
	method BUILD($stat) {
		super.BUILD($stat);
		say "Use the \"parse music roms\" command at your own risk.
			Note that parsing copyrighted ROMs is illegal unless
			you are a Nintendo hacker! \n";

	}

	method ask(%args) {
		my $string = super.ask(%args) . 
				"ask about music roms\n" .
				"get music roms\n" .
				"add music roms\n" .
				"list music roms\n" .
				"parse music roms\n" .
				"deploy music roms\n" .
				"agent\n";
		
		return $string;
	}


	method ask_music_roms(%args) {
		my $string;

		for %args.kv -> $key,$value {
			if (.musicdb.search($key) {
				$string .= $key;
			}
		}
		return $string;
	}

	method get_music_roms(%args) {
		my @roms = <>;

		for %args.kv -> $key,$value {
			push(@roms, .musicdb.search($key));
		}
		return @roms;
	}

	### write NES music roms to disk (in local directory)

	method deploy_roms(%args) {

		say "Note that you have to be a Nintendo hacker to own their\n
			ROMs. There are also free ROMs available on the internet.\n";

		for %.romdb.kv -> $key,$value {
			my $fh = open "$key", :w;

			if ($fh) {
				print "deploying file in local directory : " . "$key" . "\n";
			} else {
				next;
			}
			$fh.print($value);
			$fh.close();
		}
	}

	### agent dispatched
	method dispatch_agent($agent) {

		### process music or anything from $agent here

		return &$agent.dispatch;
	} 

	method parse_rom(%args) {
		for .romdb.kv -> $key,$value {

			### Check if a ROM includes music

			if ($key == %args{$key}) {
				say "Parsing ROM ". $key . "...\n";
				if (search_sound_init(.romdb{$value})) {
					say "Your ROM named " . $key " includes NES music\n";
				}
			}
		}
		say "Nothing found.\n";
	}

	### endianess
	method transform8to16bit($string) {
		my $str = $string.split: //;
		my $value = "";
		loop (my $i = 0; $i < $str.length; $i+=2) {
			if (str[$i] > 0) {
				$value .= Str.new(chr(ord($str[$i])+1 
						+ ord($str[$i+1)));
			} else if (str[$i] == 0) {
				$value .= Str.new(chr(ord($str[$i+1)));
			} 	
		}

		return $value;	
	}

	method search_sound_init($rom) {
		my $loadopcode = 0xA9;
		my $loadarg = 0x0F;
		my $storeopcode = 0x4015; ### enable Square 1, Square 2, Triangle and Noise channels
		sound_search_for_enable(self.tranform8to16bit("$rom"), $storeopcode);
	}			

	### search for sound enable
	method sound_search_for_enable($romstring, $opcode) {
		loop (my $i = 0; $i < $romstring.length-9; $i++) {

			if ($romstring[$i] == 10 and $romstring[$i+1] == 9) {
				if ($romstring[$i+2] == 0 and $romstring[$i+3] == 15) { ### LDA 0x0F
					$i += 4;  

					if ($romstring[$i] == 4 && $romstring[$i+1] == 4 && ### STA==$44
					$romstring[$i+2] == 5 && $romstring[$i+3] == 1 && ### STA $4015
					$romstring[$i+4] == 0 && $romstring[$i+5] == 4) {
						return $i;	
					}
				}		
			}
		}
		return False;
	}

	### search for sound disable
	method sound_search_for_disable($romstring, $opcode) {
		loop (my $i = 0; $i < $romstring.length-9; $i++) {
			if ($romstring[$i] == 10 and $romstring[$i+1] == 9) {
				if ($romstring[$i+2] == 0 and $romstring[$i+3] == 0) { ### LDA 0x00
					if ($romstring[$i] == 4 && $romstring[$i+1] == 4 && ### STA==$44
						$romstring[$i+2] == 5 && $romstring[$i+3] == 1 && ### STA $4015
						$romstring[$i+4] == 0 && $romstring[$i+5] == 4) {
						return $i;	
					}	
				}
			}
		}		
		return False;
	}

	method dispatch($msg, %optargs) {

		say "Note that parsing copyrighted ROMs is illegal unless
			you are a Nintendo NES hacker!\n";

		given $msg {
		when "ask" { self.ask(%optargs) }
		when "ask about music roms" { self.ask_music_roms(%optargs) }
		when "get music roms" { self.get_music_roms(%optargs) }
		when "add music roms" { self.add_music(%optargs) }
		when "list music roms" { self.list_musicdb_keys(%optargs) } 
		when "parse music roms" { self.parse_rom(%optargs) } 
		when "deploy music roms" { self.deploy_roms(%optargs) } 
		when "agent" { self.agent(%optargs); }
		default { $status = 0; return; }
		$status = 1;
	}
}
