#!perl

use strict;
use utf8;
use Test::More 0.82;
BEGIN { use_ok('Map::Tube::KoelnBonn') || print "Bail out!\n"; }

SKIP: {
  eval 'use XML::LibXML';
  if ($@) {
    diag( 'XML::LibXML required for this test' );
    skip( 'XML::LibXML required for this test', 1 );
  }

  my $map = new_ok( 'Map::Tube::KoelnBonn' );
  my $dom = XML::LibXML->load_xml( location => $map->xml() );

  ok( $dom->findnodes('/tube'), 'There should be a <tube> tag at the top level' );
  is( scalar( @{ $dom->findnodes('/tube/stations') } ), 1, 'There should be exactly one <stations> tag directly under the top level' );
  is( scalar( @{ $dom->findnodes('/tube/lines')    } ), 1, 'There should be exactly one <lines> tag directly under the top level' );

  cmp_ok( scalar( @{ $dom->findnodes('/tube/stations/station') } ), '>=', 5, 'There should be several <station> tags directly under <station>' );
  cmp_ok( scalar( @{ $dom->findnodes('/tube/lines/line'      ) } ), '>=', 5, 'There should be several <line> tags directly under <line>' );

  for my $station( $dom->findnodes('/tube/stations/station') ) {
    ok( $station->getAttribute('id'),   '<station> tags should have an id attribute'  );
    ok( $station->getAttribute('name'), '<station> tags should have a name attribute' );
    ok( $station->getAttribute('line'), '<station> tags should have a line attribute' );
    ok( $station->getAttribute('link'), '<station> tags should have a link attribute' );
  }

  for my $line( $dom->findnodes('/tube/lines/line') ) {
    ok( $line->getAttribute('id'),    '<line> tags should have an id attribute'   );
    ok( $line->getAttribute('name'),  '<line> tags should have a name attribute'  );
    ok( $line->getAttribute('color'), '<line> tags should have a color attribute' );
    like( $line->getAttribute('color'), qr/^#[0-9A-F]{6}$/i, 'color attribute of <line> should be hex format HTML color spec' );
  }
}

done_testing();
