@rem = '--*-Perl-*--
@echo off
perl\bin\perl -x -S %0 %1 %2 %3 %4 %5 %6 %7 %8 %9
goto endofperl
@rem ';
#!.\perl\bin\perl -w
#line 8
#
# Install Perl binary distribution.
# Takes care of munging a Config.pm template.
#

use Cwd;
use File::Path;

my %OPT = ();
my $PWD = cwd;
$PWD =~ s|/|\\|g;
my $FROM = "$PWD\\perl";
my $TO = shift;
die "usage: $0 [g:\\your\\top\\level\\install\\dir]\n"
	if $TO and $TO =~ /^-/;

die "Please run $0 from the top level directory of Perl binary distribution.\n"
	unless -e $FROM;


print <<EOT;

Welcome to the Perl Binary Distribution for the Intel Win32
platform!

Before proceeding, please make sure you have at least 20MB of
free space on the destination volume.

It is an excellent idea to actually read the README file before
getting on with it.  Hope you managed to.

EOT

if ($TO) {
    print "You've asked that the stuff be installed into `$TO'.\n";
    $TO = "" unless yes_or_no("Proceed?");
}

TOP:
if (not $TO) {
    $TO = ask_for_it("Where do you want Perl to be installed?", "c:\\perl");
}

if ($TO =~ /[\s;,!|<>~\@\%\&\$\*\?\+]/) {
    print <<EOT;

Looks like you are trying to install Perl into a path that contains
spaces or other special characters.  Though the latest Windows
operating systems claim to support filenames with such special
characters, many existing utilities will have trouble with such
path names.  Chances are that you will find this is simply too
much of a bad idea to be worth it.

EOT

    $TO = "" if yes_or_no("Want to change your mind before it is too late?");
}

try_again("TOP") unless $TO;

$OPT{INST_DRV} = ($TO =~ /^([A-Z]:)/i or $FROM =~ /^([A-Z]:)/i ? $1 : "c:");
$TO = "$PWD\\$TO" unless $TO =~ /^([\/\\]|[A-Z]:)/i; 
$OPT{INST_TOP} = $TO;
$OPT{CCTOP} = "c:\\bc5";
$OPT{CCINCDIR} = "$OPT{CCTOP}\\include";
$OPT{CCLIBDIR} = "$OPT{CCTOP}\\lib";

unless (-d $TO) {
    undef($TO), try_again("TOP") unless yes_or_no("Ok to create `$TO'?");
    mkpath($TO, 1, 0777);
    mkpath($TO."\\lib", 1, 0777);
    warn("Failed to create `$TO': $!\n"), undef($TO), try_again("TOP") unless -d $TO;
}

CC1:
if (yes_or_no("Do you have the Borland C++ 5.x compiler?")) {
    my $top = ask_for_it("Where is Borland C++ installed?","c:\\bc5");
    warn("Sorry, `$top' doesn't exist.\n"), try_again("CC1") unless (-d $top);
    my $inc = ask_for_it("The compiler's include files are in...",
                         "$top\\include");
    warn("Sorry, `$inc' doesn't exist.\n"), try_again("CC1") unless (-d $inc);
    my $lib = ask_for_it("The compiler's libraries are in...",
                         "$top\\lib");
    warn("Sorry, `$lib' doesn't exist.\n"), try_again("CC1") unless (-d $lib);

    $OPT{CCTOP} = $top;
    $OPT{CCINCDIR} = $inc;
    $OPT{CCLIBDIR} = $lib;
}

print <<EOT;

We're now ready to copy files.

Perl will be installed in `$TO'.

EOT

yes_or_die("Proceed?");

print "Copying distribution from `$FROM' to `$TO'\n\n";
system(qq[xcopy /f /r /i /e /d "$FROM" "$TO"]) and die "Copy failed! : $!";

my $CFGPM = "$TO\\lib\\Config.pm";
print "Generating new `$CFGPM'\n";

my $TEMPLATE = shift || "$PWD\\Configpm.tpl";

open(T, "<$TEMPLATE") or die "Can't open $TEMPLATE: $!";
open(C, ">$CFGPM") or die "Can't open $CFGPM: $!";
while (<T>) {
    s/~(\w+)~/$OPT{$1}/g;
    print C $_;
}
close T; close C;

print <<EOT;

Perl has been successfully installed at `$TO'.

To start using this Perl please add `$TO\\bin'
to your `Path' environment variable.  You can do this in the `Environment'
tab of the `System' Control Panel (accessible by mousing "Start" ->
"Settings" -> "Control Panel").

You can also set the `PERL5LIB' environment variable to a `;' separated
list of paths if you install modules in locations other than
`$TO'.

Setting PERL5LIB should not be required if you want to simply use the
stuff that got installed just now.

Have a nice day.

EOT

$_ = <STDIN>;		# hang around in case they ran it from Explorer

sub yes_or_die {
    my $m = shift || "Proceed?";
    print "$m [y] ";
    die "Bailing out\n" if scalar(<STDIN>) !~ /^\s*(y|$)/i;
}

sub yes_or_no {
    my $m = shift || "Which?";
    print "$m [y] ";
    return 1 if scalar(<STDIN>) =~ /^\s*(y|$)/i;
}

sub ask_for_it {
    my $m = shift || "Enter value";
    my $def = shift;
    $def = "" unless defined $def;
    print "$m \[$def\] ";
    my $v = <STDIN>;
    chomp $v;
    return ($v =~ /^\s*$/ ? $def : $v);
}

sub try_again {
    print "Let's try this again.\n";
    goto shift;
}

__END__
:endofperl
