'\"
.so man.macros
.TH Tk n 4.0 Tk "Perl/Tk Constructs"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH "NAME"
\fBTk\fR \- An overview of an Object Oriented Tk4.0 extension for perl5
.SH "SYNOPSIS"
.PP
\&    use Tk;
.br
\&    $main = MainWindow->new();
.br
\&    $widget = $main->\fIWidget\fR(...);
.br
\&    $widget->pack(...);
.br
\&    ...
.br
\&    MainLoop;
.br
.BE
.SH "DESCRIPTION"
In writing the perl Tk extension, the goals were to provide a complete
interface to the latest production version of John Ousterhout's Tk, while providing 
an Object Oriented interface to perl code.
.SH "CONTENTS"
The package is composed of three loosely connected parts:
.IP "\fIpTk\fR \- Converted Tk source" 4
The \fIpTk\fR sub-directory is a copy of the C code of Tk4.0, modified
to allow use by languages other than the original Tcl.
(The pTk can be read as 'perl' Tk or 'portable' Tk, depending on
your sensibilities.) 
.sp 1
.IP "\fBTk\fR to Perl 'Glue'" 4
The top level directory provides \fITk.xs\fR and \fItkGlue.c\fR
which provide the perl-callable interfaces to pTk
.sp 1
.IP "Perl code for 'Widget' Classes" 4
The \fITk/Tk\fR sub-directory contains the various perl modules that comprise
the "Classes" that are visible to Tk applications.
.sp 1
The "major" widgets such as \fBTk::Text\fR are actually in separate directories
at the top level (e.g. \fIText/*\fR for \fBTk::Text\fR) and are dynamically
loaded as needed on platforms which support perl5's \fBDynaLoader\fR.
.SH "CLASS HIERARCHY"
.sp 1
.IP "\fBpackage Tk;\fR \- the 'base class'" 4
All the "command names" documented in Tcl/Tk are made to look like perl
sub's and reside in the Tk package. Their names are all lower case.
Typically there are very few commands at this level which are called 
directly by applications.
.sp 1
.IP "\fBpackage Tk::Widget;\fR \- the 'Widget class'" 4
There are no actual objects of the \fBTk::Widget\fR class; however all 
the various Tk window "widgets" inherit from it, and it in turn
inherits all the core Tk functions from Tk.
.sp 1
\fBTk::Widget\fR provides various functions and interfaces which are 
common to all Widgets.
.sp 1
A widget is represented to perl as a blessed reference to a hash. There are some
members of the hash which are private to Tk and its tkGlue code.  Keys
starting with \fB'.'\fR and of the form  \fB/_[A-Z][A-Za-z_]+_/\fR
(i.e. starting and ending in _ and with  first char after _ being upper case) should be
considered reserved to \fBTk\fR.
.sp 1
.IP "\fBTk::Button\fR, \fBTk::Entry\fR, \fBTk::Text\fR ..." 4
There is one class for each of the "Tk" widget item types.
Some of them like \fBTk::Frame\fR do very little indeed, and really 
only exist so that they can be derived from or so that focus or menu
traversal can discover the "kind" of window being processed.
.sp 1
Other classes, \fBTk::Text\fR for example, provide a lot of methods 
used with Tk's "bind" to provide a rich keyboard/mouse interface
to the widgets' data.
.sp 1
These widget classes also include conversions of the Tcl code for 
event bindings, keyboard focus traversal, menu bars, and menu keyboard
traversal. All the Tcl functions have been converted, but the names have
changed (systematically) and they have been split up between the various
classes in what I hope is an appropriate manner.
Name changes are normally: dropping initial tk_ as the Tk-ness is implicit
in the \fBTk::\fR prefix, and similarly dropping say Menu from the name if it
has been moved the Tk::Menu class.
Thus 'proc tkMenuNextEntry' becomes 'sub NextEntry' in the Tk::Menu package. 
.sp 1
.IP "\fBTk::Image\fR" 4
This does for Tk4.0's "images" what \fBTk::Widget\fR does for widgets.
Images are new to Tk4.0 and the class structure is not mature either.
.sp 1
There are three sub-classes \fBTk::Bitmap\fR, \fBTk::Pixmap\fR and \fBTk::Photo\fR.
.sp 1
It is expected that \fBTk::Image\fR hierarchy will evolve during the "beta"
phase of Tk to allow dynamic or auto-loaded image types or photo formats
(e.g. support for JPEG format for photos).
.sp 1
.IP "Composite Widgets" 4
A composite is some kind of 'frame' with subwidgets which give it useful behaviour.
\fBTk::Dialog\fR is an example of 
a composite widget classes built from the basic \fBTk\fR ones. 
It is intended that user code should not need to be aware that a particular
class is a composite, and create and configure such widgets in the same manner
as any other kind. The \fBconfigure\fR mechanism and the methods of the 
class manipulate the subwidgets as required.
.sp 1
Composite widgets are implemented via \fBTk::Frame\fR and multiple inheritance.
The two 'frame' base classes \fBTk::Frame\fR and
\fBTk::Toplevel\fR include the additional class \fBTk::Derived\fP 
in their inheritance. \fBTk::Derived\fP provides methods to allow additional
\fBconfigure\fR options to be defined for a widget.
.sp 1
A Composite widget is typically defined as derived
from \fBTk::Frame\fR or \fBTk::Toplevel\fR 
(e.g. \fBTk::Dialog\fR).

.PP
