# NOTE: Derived from blib/lib/IPC/Shareable.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package IPC::Shareable;

#line 1412 "blib/lib/IPC/Shareable.pm (autosplit into blib/lib/auto/IPC/Shareable/create_magic_tie.al)"
# --- Autoloaded methods
sub create_magic_tie {
    # --- Ties an implicitly created thingy
    my($variable, $ref_type, $thingy, $key) = @_;
    my($options,$anon_key, $anon_refs, $shmid);
    debug "for a $ref_type called on $variable, $thingy" if ($Debug);

    debug "remembering the referenced thingy as $thingy" if ($Debug);

    # --- Get some glue for the upcoming tie() call
    if ($Shm_Info{$$variable}{'key'} != IPC_PRIVATE) {
	if ($Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}) {
	    $anon_key = $Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}{'key'};
	} else {
	    $anon_refs = scalar(keys %{$Shm_Info{$$variable}{'DATA'}{'internal'}}) + 1;
	    $anon_key = $Shm_Info{$$variable}{'key'} - $anon_refs;
	    $Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}{'key'} = $anon_key;
	}
	debug "chose $anon_key as the glue for tie()" if ($Debug);
    } else {
	$anon_key = IPC_PRIVATE;
	$Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}{'key'} = $anon_key;
    }

    # --- Tie it
    $options = $Shm_Info{$$variable}{'options'};
    if ($ref_type eq 'HASH') {
	tie(%$thingy, 'IPC::Shareable', $anon_key, $options) or
	    croak "$Package\:\:create_magic_tie: couldn't tie hash-type thingy referenced by $thingy";
	$shmid = (tied %$thingy)->_shm_id;
    } else {
	tie($$thingy, 'IPC::Shareable', $anon_key, $options) or
	    croak "$Package\:\:create_magic_tie: couldn't tie scalar-type thingy referenced by $thingy";
	$shmid = (tied $$thingy)->_shm_id;
    }

    # --- Store some info about the thingy being referenced
    $Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}{'ref_type'} = $ref_type; # - What is being reffed
    $Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}{'hash_key'} = $key
	if $Shm_Info{$$variable}{'type'} eq 'HASH'; # - Where in our hash the thingy lives
    $Shm_Info{$$variable}{'DATA'}{'internal'}{"$thingy"}{'shm_id'} = $shmid; # - Where in shared memory the thingy lives

    1;
}

# end of IPC::Shareable::create_magic_tie
1;
