# NOTE: Derived from blib/lib/IPC/Shareable.pm.
# Changes made here will be lost when autosplit again.
# See AutoSplit.pm.
package IPC::Shareable;

#line 1456 "blib/lib/IPC/Shareable.pm (autosplit into blib/lib/auto/IPC/Shareable/attach_magic_tie.al)"
sub attach_magic_tie {
    my($variable, $type) = @_;
    my($thingy, $thingy_info);
    my($anon_key, $ref_type, $hash_key, $wanted_shmid, $wanted_semid);
    my($dummy, $thingy_ref, $arg, $shm_info);
    debug "tie called on $variable $type" if ($Debug);

    # --- Loop through all possible attached structures
    while (($thingy, $thingy_info) = each %{$Shm_Info{$$variable}{'DATA'}{'internal'}}) {

	# --- Check to see if we've tied this one already
	next if $Shm_Info{$$variable}{'attached'}{$thingy};
	
	# --- Get some important information about the thingy
	$anon_key = $thingy_info->{'key'}; # - The shmid of the referenced thingy
	$ref_type = $thingy_info->{'ref_type'}; # - What the referenced thingy is
	$hash_key = $Shm_Info{$$variable}{'DATA'}{'internal'}{$thingy}{'hash_key'}; # - Where in our hash it is found
	$wanted_shmid = $Shm_Info{$$variable}{'DATA'}{'internal'}{$thingy}{'shm_id'}; # - Where in shmem the thingy is
	debug "data in $$variable wants to attach to a $ref_type at $anon_key"
          if ($Debug);
	debug "$thingy will live at $hash_key" 
          if (($type eq 'HASH') and ($Debug));
	debug "the thingy $$variable wants to attach to lives at $wanted_shmid"
          if ($Debug);

	# --- Get the semaphore set associated with this variable
	debug "getting semaphore set for $thingy" if ($Debug);
	debug "calling semget($anon_key, 3, $Shm_Info{$$variable}{'flags'})"
          if ($Debug);
	defined($wanted_semid = semget($anon_key, 3, $Shm_Info{$$variable}{'flags'})) or
	    croak "$Package\:\:attach_magic_tie: semget returned undef ($wanted_semid/$!)";
	debug "temporarily got a semid of $wanted_semid for $wanted_shmid"
          if ($Debug);
	$Shm_Info{$wanted_shmid}{'sem_id'} = $wanted_semid;

	# --- Get the thingy we need to tie
	$dummy = read_shm_variable(\$wanted_shmid);
	$thingy_ref = $dummy->{'user'};
	debug "found a $thingy_ref at $wanted_shmid" if ($Debug);
	ref($thingy_ref) eq $ref_type or
	    croak "$Package\:\:attach_magic_tie: expected to find a $ref_type at $wanted_shmid but found a ", ref($thingy_ref), "instead";
	debug "$thingy_ref is indded a $ref_type" if ($Debug);

	# --- Tie the thingy
	debug "$Package\:\:attach_magic_tie: about to tie $thingy to $anon_key"
          if ($Debug);
	if ($ref_type eq 'HASH') {
	    tie(%$thingy_ref, 'IPC::Shareable', $anon_key, $Shm_Info{$$variable}{'options'}) or
		croak "$Package\:\:attach_magic_tie: couldn't attach to thingy referenced by $variable";
	} elsif ($ref_type eq 'HASH') {
	    tie($$thingy_ref, 'IPC::Shareable', $anon_key, $Shm_Info{$$variable}{'options'}) or
		croak "$Package\:\:attach_magic_tie: couldn't attach to thingy referenced by $variable";
	}

	# --- Now assign to the right place
	if ($type eq 'HASH') {
	    debug "assigning $thingy_ref to $$variable/$hash_key" if ($Debug);
	    $Shm_Info{$$variable}{'DATA'}{'user'}{$hash_key} = $thingy_ref;
	} elsif ($type eq 'SCALAR') {
	    debug "assigning \\$thingy_ref to $$variable" if ($Debug);
	    $Shm_Info{$$variable}{'DATA'}{'user'} = \$thingy_ref;
	}
	
	# --- Record the fact that we've tied it
	$Shm_Info{$$variable}{'attached'}{$thingy}++;
    }

    # --- Done
    1;
}

# end of IPC::Shareable::attach_magic_tie
1;
