package App::Manoc::Search::Driver::VlanRange;

use Moose;

our $VERSION = '2.99.2'; ##TRIAL VERSION

use App::Manoc::Search::Item::VlanRange;

extends 'App::Manoc::Search::Driver';

sub search_inventory {
    my ( $self, $query, $result ) = @_;
    my ( $it, $e );
    my $pattern = $query->sql_pattern;
    my $schema  = $self->engine->schema;

    $it = $schema->resultset('VlanRange')
        ->search( { name => { '-like' => $pattern } }, { order_by => 'id' } );

    while ( $e = $it->next ) {

        my $item = App::Manoc::Search::Item::VlanRange->new(
            {
                name  => $e->name,
                match => $e->name,
            }
        );
        $result->add_item($item);
    }
}

no Moose;
__PACKAGE__->meta->make_immutable;

__END__

=pod

=head1 NAME

App::Manoc::Search::Driver::VlanRange

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
