#!perl
#
# This file is part of App-SpreadRevolutionaryDate
#
# This software is Copyright (c) 2019 by Gérald Sédrati-Dinet.
#
# This is free software, licensed under:
#
#   The GNU General Public License, Version 3, June 2007
#

use Test::More;
use Test::Output;

unless(   -f $ENV{HOME} . '/.config/spread-revolutionary-date/spread-revolutionary-date.conf'
       || -f $ENV{HOME} . '/.spread-revolutionary-date.conf') {
  plan skip_all => 'No user config file found';
} else {
  plan tests => 1;
}

use App::SpreadRevolutionaryDate;

@ARGV = ('--test', '--mastodon');
my $spread_revolutionary_date = App::SpreadRevolutionaryDate->new;

stdout_like { $spread_revolutionary_date->spread } qr/Spread to Mastodon/, 'Spread to Mastodon';
