#!perl -w
use strict;
use Test::More;

use Text::Xslate;

my $tx = Text::Xslate->new();

my @data = (
    ['<:= $value10 == 10 ? 3 : 5 :>', 3],
    ['<:= $value10 == 20 ? 3 : 5 :>', 5],
    ['<:= $value20 == 10 ? 3 : 5 :>', 5],
    ['<:= $value20 == 20 ? 3 : 5 :>', 3],

    ['<:= $value10 == 10 && $value20 == 20 ? 3 : 5 :>', 3],
    ['<:= $value10 == 10 || $value20 == 20 ? 3 : 5 :>', 3],

    ['<:= ($value10 == 10 && $value20 == 20) ? 3 : 5 :>', 3],
    ['<:= ($value10 == 10 || $value20 == 20) ? 3 : 5 :>', 3],

    ['<:= ($value10 == 10 && $value20 == 20) && 5 :>',  5],
    ['<:= ($value10 == 10 && $value20 != 20) && 5 :>',  ''],
    ['<:= ($value10 == 10 && $value20 == 20) || 5 :>',  1],
    ['<:= ($value10 == 10 && $value20 != 20) || 5 :>',  5],
    ['<:= ($value10 != 10 && $value20 != 20) && 5 :>',  ''],
    ['<:= ($value10 != 10 && $value20 != 20) || 5 :>',  5],

    ['<:= ($value10 == 10 || $value20 == 20) && 5 :>',  5],
    ['<:= ($value10 == 10 || $value20 != 20) && 5 :>',  5],
    ['<:= ($value10 == 10 || $value20 == 20) || 5 :>',  1],
    ['<:= ($value10 == 10 || $value20 != 20) || 5 :>',  1],
    ['<:= ($value10 != 10 || $value20 != 20) && 5 :>',  ''],
    ['<:= ($value10 != 10 || $value20 != 20) || 5 :>',  5],

    ['<:= $value0  && 20 :>',  0 ],
    ['<:= $value10 && 20 :>', 20 ],
    ['<:= ""       && 20 :>', "" ],
    ['<:= (nil && 20) == nil :>', 1 ], # cannot print nil (undef)

    ['<:= $value0  and 20 :>',  0 ],
    ['<:= $value10 and 20 :>', 20 ],
    ['<:= ""       and 20 :>', "" ],
    ['<:= (nil and 20) == nil :>', 1 ], # cannot print nil (undef)

    ['<:= $value0  || 20 :>', 20 ],
    ['<:= $value10 || 20 :>', 10 ],
    ['<:= ""       || 20 :>', 20 ],
    ['<:= nil      || 20 :>', 20 ],

    ['<:= $value0  or 20 :>', 20 ],
    ['<:= $value10 or 20 :>', 10 ],
    ['<:= ""       or 20 :>', 20 ],
    ['<:= nil      or 20 :>', 20 ],

    ['<:= $value0  // 20 :>',  0 ],
    ['<:= $value10 // 20 :>', 10 ],
    ['<:= ""       // 20 :>', "" ],
    ['<:= nil      // 20 :>', 20 ],

    ['<:=    !$value0  || 20 :>',  1 ],
    ['<:=    !$value10 || 20 :>', 20 ],
    ['<:= not $value0  || 20 :>', "" ],
    ['<:= not $value10 || 0 :>',  "" ],

    ['<:= $value0  == 10 ? 100 :   0 || 200 :>', ( 0 == 10 ? 100 :   0 || 200 ) ],
    ['<:= $value10 == 10 ? 100 :   0 || 200 :>', (10 == 10 ? 100 :   0 || 200 ) ],
    ['<:= $value0  == 10 ?   0 : 100 || 200 :>', ( 0 == 10 ?   0 : 100 || 200 ) ],
    ['<:= $value10 == 10 ?   0 : 100 || 200 :>', (10 == 10 ?   0 : 100 || 200 ) ],

    ['<:= $value0  == 10 ? 100 :   0 or 200 :>', ( 0 == 10 ? 100 :   0 or 200 ) ],
    ['<:= $value10 == 10 ? 100 :   0 or 200 :>', (10 == 10 ? 100 :   0 or 200 ) ],
    ['<:= $value0  == 10 ?   0 : 100 or 200 :>', ( 0 == 10 ?   0 : 100 or 200 ) ],
    ['<:= $value10 == 10 ?   0 : 100 or 200 :>', (10 == 10 ?   0 : 100 or 200 ) ],

    ['<:   $value10 == 10 ? 100
         : $value10 == 20 ? 200
         : $value10 == 30 ? 300
         :                  400 :>', 100 ],

    ['<:   $value20 == 10 ? 100
         : $value20 == 20 ? 200
         : $value20 == 30 ? 300
         :                  400 :>', 200 ],

    ['<:   $value0  == 10 ? 100
         : $value0  == 20 ? 200
         : $value0  == 30 ? 300
         :                  400 :>', 400 ],
);

foreach my $pair(@data) {
    my($in, $out) = @$pair;
    my %vars = (
        value0  =>  0,
        value10 => 10,
        value20 => 20,
    );
    is $tx->render_string($in, \%vars), $out or diag $in;
}

done_testing;
