#ifndef PERLIO_UTIL_H
#define PERLIO_UTIL_H

#define  PERLIO_FUNCS_CONST

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "perliol.h"

#define LayerFetch(layer, n) ((layer)->array[n].funcs)
#define LayerFetchSafe(layer, n) ( ((n) >= 0 && (n) < (layer)->cur) \
				? (layer)->array[n].funcs : (PerlIO_funcs*)0 )

#ifndef PERLIO_FUNCS_DECL
#define PERLIO_FUNCS_DECL(funcs) const PerlIO_funcs funcs
#define PERLIO_FUNCS_CAST(funcs) (PerlIO_funcs*)(funcs)
#endif

#include "ppport.h"

PerlIO*
PerlIOTee_teeout(pTHX_ const PerlIO* tee);

void
dump_perlio(pTHX_ PerlIO* f, int level);


PERLIO_FUNCS_DECL(PerlIO_flock);
PERLIO_FUNCS_DECL(PerlIO_creat);
PERLIO_FUNCS_DECL(PerlIO_excl);
PERLIO_FUNCS_DECL(PerlIO_tee);


#endif /*PERLIO_UTIL_H*/
