package Test::Class::Moose::Role::ParameterizedInstances;

# ABSTRACT: run tests against multiple instances of a test class

use 5.10.0;

our $VERSION = '0.67';

use Moose::Role;

requires '_constructor_parameter_sets';

sub _tcm_make_test_class_instances {
    my $class     = shift;
    my %base_args = @_;

    my %sets = $class->_constructor_parameter_sets;
    return map { $_ => $class->new( %{ $sets{$_} }, %base_args ) }
      keys %sets;
}

1;

__END__

=pod

=head1 NAME

Test::Class::Moose::Role::ParameterizedInstances - run tests against multiple instances of a test class

=head1 VERSION

version 0.67

=head1 AUTHORS

=over 4

=item *

Curtis "Ovid" Poe <ovid@cpan.org>

=item *

Dave Rolsky <autarch@urth.org>

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2012 - 2015 by Curtis "Ovid" Poe.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
