

use Test::More;

BEGIN {
    unless ( $ENV{RELEASE_TESTING} ) {
        plan skip_all => 'these tests are for testing by the release';
    }

    $ENV{PV_TEST_PERL} = 1;
}

use strict;
use warnings;

use Test::Requires {
    Readonly => 0,
};

use Params::Validate qw(validate validate_pos SCALAR);
use Test::More;

{
    Readonly my $spec => { foo => 1 };
    my @p = ( foo => 'hello' );

    eval { validate( @p, $spec ) };
    is( $@, q{}, 'validate() call succeeded with Readonly spec hashref' );
}

{
    Readonly my $spec => { type => SCALAR };
    my @p = 'hello';

    eval { validate_pos( @p, $spec ) };
    is( $@, q{}, 'validate_pos() call succeeded with Readonly spec hashref' );
}

{
    Readonly my %spec => ( foo => { type => SCALAR } );
    my @p = ( foo => 'hello' );

    eval { validate( @p, \%spec ) };
    is( $@, q{}, 'validate() call succeeded with Readonly spec hash' );
}

done_testing();

