###########################################################################
#
# This file is auto-generated by the Perl DateTime Suite locale
# generator (0.05).  This code generator comes with the
# DateTime::Locale distribution in the tools/ directory, and is called
# generate-from-cldr.
#
# This file as generated from the CLDR XML locale data.  See the
# LICENSE.cldr file included in this distribution for license details.
#
# This file was generated from the source file to.xml
# The source file version number was 1.11, generated on
# 2008/06/26 03:47:58.
#
# Do not edit this file directly.
#
###########################################################################

package DateTime::Locale::to;

use strict;
use warnings;
use utf8;

use base 'DateTime::Locale::root';

sub cldr_version { return "1\.6" }

{
    my $am_pm_abbreviated = [ "HH", "EA" ];
    sub am_pm_abbreviated { return $am_pm_abbreviated }
}
{
    my $date_format_full = "EEEE\ d\ MMMM\ yyyy";
    sub date_format_full { return $date_format_full }
}

{
    my $date_format_long = "d\ MMMM\ yyyy";
    sub date_format_long { return $date_format_long }
}

{
    my $date_format_medium = "d\ MMM\ yyyy";
    sub date_format_medium { return $date_format_medium }
}

{
    my $date_format_short = "dd\-MM\-yyyy";
    sub date_format_short { return $date_format_short }
}

{
    my $datetime_format = "\{1\}\ \{0\}";
    sub datetime_format { return $datetime_format }
}

{
    my $day_format_abbreviated = [ "Mōn", "Tus", "Pul", "Tuʻa", "Fal", "Tok", "Sāp" ];
    sub day_format_abbreviated { return $day_format_abbreviated }
}

sub day_format_narrow { $_[0]->day_stand_alone_narrow() }

{
    my $day_format_wide = [ "Mōnite", "Tusite", "Pulelulu", "Tuʻapulelulu", "Falaite", "Tokonaki", "Sāpate" ];
    sub day_format_wide { return $day_format_wide }
}

sub day_stand_alone_abbreviated { $_[0]->day_format_abbreviated() }

{
    my $day_stand_alone_narrow = [ "M", "T", "P", "T", "F", "T", "S" ];
    sub day_stand_alone_narrow { return $day_stand_alone_narrow }
}

sub day_stand_alone_wide { $_[0]->day_format_wide() }

{
    my $era_abbreviated = [ "KM", "TS" ];
    sub era_abbreviated { return $era_abbreviated }
}
{
    my $era_narrow = [ "KāMā", "TāSā" ];
    sub era_narrow { return $era_narrow }
}
{
    my $era_wide = [ "ki\ muʻa", "taʻu\ ʻo\ Sīsū" ];
    sub era_wide { return $era_wide }
}
{
    my $first_day_of_week = 1;
    sub first_day_of_week { return $first_day_of_week }
}

{
    my $month_format_abbreviated = [ "Sān", "Fēp", "Maʻa", "ʻEpe", "Mē", "Sun", "Siu", "ʻAok", "Sēp", "ʻOka", "Nōv", "Tis" ];
    sub month_format_abbreviated { return $month_format_abbreviated }
}

sub month_format_narrow { $_[0]->month_stand_alone_narrow() }

{
    my $month_format_wide = [ "Sānuali", "Fēpueli", "Maʻasi", "ʻEpeleli", "Mē", "Sune", "Siulai", "ʻAokosi", "Sēpitema", "ʻOkatopa", "Nōvema", "Tisema" ];
    sub month_format_wide { return $month_format_wide }
}

sub month_stand_alone_abbreviated { $_[0]->month_format_abbreviated() }

{
    my $month_stand_alone_narrow = [ "S", "F", "M", "E", "M", "S", "S", "A", "S", "O", "N", "T" ];
    sub month_stand_alone_narrow { return $month_stand_alone_narrow }
}

sub month_stand_alone_wide { $_[0]->month_format_wide() }

{
    my $quarter_format_abbreviated = [ "K1", "K2", "K3", "K4" ];
    sub quarter_format_abbreviated { return $quarter_format_abbreviated }
}

sub quarter_format_narrow { $_[0]->quarter_stand_alone_narrow() }

{
    my $quarter_format_wide = [ "kuata\ ʻuluaki", "kuata\ ua", "kuata\ tolu", "kuata\ fā" ];
    sub quarter_format_wide { return $quarter_format_wide }
}

sub quarter_stand_alone_abbreviated { $_[0]->quarter_format_abbreviated() }

{
    my $quarter_stand_alone_narrow = [ "1", "2", "3", "4" ];
    sub quarter_stand_alone_narrow { return $quarter_stand_alone_narrow }
}
{
    my $quarter_stand_alone_wide = [ "kuata\ 1", "kuata\ 2", "kuata\ 3", "kuata\ 4" ];
    sub quarter_stand_alone_wide { return $quarter_stand_alone_wide }
}
{
    my $time_format_full = "HH\:mm\:ss\ v";
    sub time_format_full { return $time_format_full }
}

{
    my $time_format_long = "HH\:mm\:ss\ z";
    sub time_format_long { return $time_format_long }
}

{
    my $time_format_medium = "HH\:mm\:ss";
    sub time_format_medium { return $time_format_medium }
}

{
    my $time_format_short = "HH\:mm";
    sub time_format_short { return $time_format_short }
}

{
    my $_format_for_Hm = "H\:mm";
    sub _format_for_Hm { return $_format_for_Hm }
}

{
    my $_format_for_M = "L";
    sub _format_for_M { return $_format_for_M }
}

{
    my $_format_for_MEd = "E\ d\-M";
    sub _format_for_MEd { return $_format_for_MEd }
}

{
    my $_format_for_MMM = "LLL";
    sub _format_for_MMM { return $_format_for_MMM }
}

{
    my $_format_for_MMMEd = "E\ d\ MMM";
    sub _format_for_MMMEd { return $_format_for_MMMEd }
}

{
    my $_format_for_MMMMEd = "E\ d\ MMMM";
    sub _format_for_MMMMEd { return $_format_for_MMMMEd }
}

{
    my $_format_for_MMMMd = "d\ MMMM";
    sub _format_for_MMMMd { return $_format_for_MMMMd }
}

{
    my $_format_for_MMMd = "d\ MMM";
    sub _format_for_MMMd { return $_format_for_MMMd }
}

{
    my $_format_for_Md = "d\-M";
    sub _format_for_Md { return $_format_for_Md }
}

{
    my $_format_for_d = "d";
    sub _format_for_d { return $_format_for_d }
}

{
    my $_format_for_ms = "mm\:ss";
    sub _format_for_ms { return $_format_for_ms }
}

{
    my $_format_for_y = "yyyy";
    sub _format_for_y { return $_format_for_y }
}

{
    my $_format_for_yM = "M\-yyyy";
    sub _format_for_yM { return $_format_for_yM }
}

{
    my $_format_for_yMEd = "EEE\ d\-M\-yyyy";
    sub _format_for_yMEd { return $_format_for_yMEd }
}

{
    my $_format_for_yMMM = "MMM\ yyyy";
    sub _format_for_yMMM { return $_format_for_yMMM }
}

{
    my $_format_for_yMMMEd = "EEE\ d\ MMM\ yyyy";
    sub _format_for_yMMMEd { return $_format_for_yMMMEd }
}

{
    my $_format_for_yMMMM = "MMMM\ yyyy";
    sub _format_for_yMMMM { return $_format_for_yMMMM }
}

{
    my $_format_for_yQ = "yyyy\ Q";
    sub _format_for_yQ { return $_format_for_yQ }
}

{
    my $_format_for_yQQQ = "yyyy\ QQQ";
    sub _format_for_yQQQ { return $_format_for_yQQQ }
}

{
    my $_format_for_yyMM = "MM\-yy";
    sub _format_for_yyMM { return $_format_for_yyMM }
}

{
    my $_format_for_yyMMM = "MMM\ yy";
    sub _format_for_yyMMM { return $_format_for_yyMMM }
}

{
    my $_format_for_yyQ = "Q\ yy";
    sub _format_for_yyQ { return $_format_for_yyQ }
}

{
    my $_available_formats =
        {
          "Hm" => "H\:mm",
          "M" => "L",
          "MEd" => "E\ d\-M",
          "MMM" => "LLL",
          "MMMEd" => "E\ d\ MMM",
          "MMMMEd" => "E\ d\ MMMM",
          "MMMMd" => "d\ MMMM",
          "MMMd" => "d\ MMM",
          "Md" => "d\-M",
          "d" => "d",
          "ms" => "mm\:ss",
          "y" => "yyyy",
          "yM" => "M\-yyyy",
          "yMEd" => "EEE\ d\-M\-yyyy",
          "yMMM" => "MMM\ yyyy",
          "yMMMEd" => "EEE\ d\ MMM\ yyyy",
          "yMMMM" => "MMMM\ yyyy",
          "yQ" => "yyyy\ Q",
          "yQQQ" => "yyyy\ QQQ",
          "yyMM" => "MM\-yy",
          "yyMMM" => "MMM\ yy",
          "yyQ" => "Q\ yy"
        };
    sub _available_formats { return $_available_formats }
}

1;

__END__


=pod

=encoding utf8

=head1 NAME

DateTime::Locale::to

=head1 SYNOPSIS

  use DateTime;

  my $dt = DateTime->now( locale => 'to' );
  print $dt->month_name();

=head1 DESCRIPTION

This is the DateTime locale package for Tonga.

=head1 DATA

This locale inherits from the L<DateTime::Locale::root> locale.

It contains the following data.

=head2 Days

=head3 Wide (format)

  Mōnite
  Tusite
  Pulelulu
  Tuʻapulelulu
  Falaite
  Tokonaki
  Sāpate

=head3 Abbreviated (format)

  Mōn
  Tus
  Pul
  Tuʻa
  Fal
  Tok
  Sāp

=head3 Narrow (format)

  M
  T
  P
  T
  F
  T
  S

=head3 Wide (stand-alone)

  Mōnite
  Tusite
  Pulelulu
  Tuʻapulelulu
  Falaite
  Tokonaki
  Sāpate

=head3 Abbreviated (stand-alone)

  Mōn
  Tus
  Pul
  Tuʻa
  Fal
  Tok
  Sāp

=head3 Narrow (stand-alone)

  M
  T
  P
  T
  F
  T
  S

=head2 Months

=head3 Wide (format)

  Sānuali
  Fēpueli
  Maʻasi
  ʻEpeleli
  Mē
  Sune
  Siulai
  ʻAokosi
  Sēpitema
  ʻOkatopa
  Nōvema
  Tisema

=head3 Abbreviated (format)

  Sān
  Fēp
  Maʻa
  ʻEpe
  Mē
  Sun
  Siu
  ʻAok
  Sēp
  ʻOka
  Nōv
  Tis

=head3 Narrow (format)

  S
  F
  M
  E
  M
  S
  S
  A
  S
  O
  N
  T

=head3 Wide (stand-alone)

  Sānuali
  Fēpueli
  Maʻasi
  ʻEpeleli
  Mē
  Sune
  Siulai
  ʻAokosi
  Sēpitema
  ʻOkatopa
  Nōvema
  Tisema

=head3 Abbreviated (stand-alone)

  Sān
  Fēp
  Maʻa
  ʻEpe
  Mē
  Sun
  Siu
  ʻAok
  Sēp
  ʻOka
  Nōv
  Tis

=head3 Narrow (stand-alone)

  S
  F
  M
  E
  M
  S
  S
  A
  S
  O
  N
  T

=head2 Quarters

=head3 Wide (format)

  kuata ʻuluaki
  kuata ua
  kuata tolu
  kuata fā

=head3 Abbreviated (format)

  K1
  K2
  K3
  K4

=head3 Narrow (format)

  1
  2
  3
  4

=head3 Wide (stand-alone)

  kuata 1
  kuata 2
  kuata 3
  kuata 4

=head3 Abbreviated (stand-alone)

  K1
  K2
  K3
  K4

=head3 Narrow (stand-alone)

  1
  2
  3
  4

=head2 Eras

=head3 Wide

  ki muʻa
  taʻu ʻo Sīsū

=head3 Abbreviated

  KM
  TS

=head3 Narrow

  KāMā
  TāSā

=head2 Date Formats

=head3 Full

   2008-02-05T12:30:30 = Tusite 5 Fēpueli 2008
   1995-12-22T09:05:02 = Falaite 22 Tisema 1995
  -0010-09-15T04:44:23 = Tokonaki 15 Sēpitema -010

=head3 Long

   2008-02-05T12:30:30 = 5 Fēpueli 2008
   1995-12-22T09:05:02 = 22 Tisema 1995
  -0010-09-15T04:44:23 = 15 Sēpitema -010

=head3 Medium

   2008-02-05T12:30:30 = 5 Fēp 2008
   1995-12-22T09:05:02 = 22 Tis 1995
  -0010-09-15T04:44:23 = 15 Sēp -010

=head3 Short

   2008-02-05T12:30:30 = 05-02-2008
   1995-12-22T09:05:02 = 22-12-1995
  -0010-09-15T04:44:23 = 15-09--010

=head3 Default

   2008-02-05T12:30:30 = 5 Fēp 2008
   1995-12-22T09:05:02 = 22 Tis 1995
  -0010-09-15T04:44:23 = 15 Sēp -010

=head2 Time Formats

=head3 Full

   2008-02-05T12:30:30 = 12:30:30 UTC
   1995-12-22T09:05:02 = 09:05:02 UTC
  -0010-09-15T04:44:23 = 04:44:23 UTC

=head3 Long

   2008-02-05T12:30:30 = 12:30:30 UTC
   1995-12-22T09:05:02 = 09:05:02 UTC
  -0010-09-15T04:44:23 = 04:44:23 UTC

=head3 Medium

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head3 Short

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 09:05
  -0010-09-15T04:44:23 = 04:44

=head3 Default

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head2 Datetime Formats

=head3 Full

   2008-02-05T12:30:30 = Tusite 5 Fēpueli 2008 12:30:30 UTC
   1995-12-22T09:05:02 = Falaite 22 Tisema 1995 09:05:02 UTC
  -0010-09-15T04:44:23 = Tokonaki 15 Sēpitema -010 04:44:23 UTC

=head3 Long

   2008-02-05T12:30:30 = 5 Fēpueli 2008 12:30:30 UTC
   1995-12-22T09:05:02 = 22 Tisema 1995 09:05:02 UTC
  -0010-09-15T04:44:23 = 15 Sēpitema -010 04:44:23 UTC

=head3 Medium

   2008-02-05T12:30:30 = 5 Fēp 2008 12:30:30
   1995-12-22T09:05:02 = 22 Tis 1995 09:05:02
  -0010-09-15T04:44:23 = 15 Sēp -010 04:44:23

=head3 Short

   2008-02-05T12:30:30 = 05-02-2008 12:30
   1995-12-22T09:05:02 = 22-12-1995 09:05
  -0010-09-15T04:44:23 = 15-09--010 04:44

=head3 Default

   2008-02-05T12:30:30 = 5 Fēp 2008 12:30:30
   1995-12-22T09:05:02 = 22 Tis 1995 09:05:02
  -0010-09-15T04:44:23 = 15 Sēp -010 04:44:23

=head2 Available Formats

=head3 Hm (H:mm)

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 9:05
  -0010-09-15T04:44:23 = 4:44

=head3 M (L)

   2008-02-05T12:30:30 = 2
   1995-12-22T09:05:02 = 12
  -0010-09-15T04:44:23 = 9

=head3 MEd (E d-M)

   2008-02-05T12:30:30 = Tus 5-2
   1995-12-22T09:05:02 = Fal 22-12
  -0010-09-15T04:44:23 = Tok 15-9

=head3 MMM (LLL)

   2008-02-05T12:30:30 = Fēp
   1995-12-22T09:05:02 = Tis
  -0010-09-15T04:44:23 = Sēp

=head3 MMMEd (E d MMM)

   2008-02-05T12:30:30 = Tus 5 Fēp
   1995-12-22T09:05:02 = Fal 22 Tis
  -0010-09-15T04:44:23 = Tok 15 Sēp

=head3 MMMMEd (E d MMMM)

   2008-02-05T12:30:30 = Tus 5 Fēpueli
   1995-12-22T09:05:02 = Fal 22 Tisema
  -0010-09-15T04:44:23 = Tok 15 Sēpitema

=head3 MMMMd (d MMMM)

   2008-02-05T12:30:30 = 5 Fēpueli
   1995-12-22T09:05:02 = 22 Tisema
  -0010-09-15T04:44:23 = 15 Sēpitema

=head3 MMMd (d MMM)

   2008-02-05T12:30:30 = 5 Fēp
   1995-12-22T09:05:02 = 22 Tis
  -0010-09-15T04:44:23 = 15 Sēp

=head3 Md (d-M)

   2008-02-05T12:30:30 = 5-2
   1995-12-22T09:05:02 = 22-12
  -0010-09-15T04:44:23 = 15-9

=head3 d (d)

   2008-02-05T12:30:30 = 5
   1995-12-22T09:05:02 = 22
  -0010-09-15T04:44:23 = 15

=head3 ms (mm:ss)

   2008-02-05T12:30:30 = 30:30
   1995-12-22T09:05:02 = 05:02
  -0010-09-15T04:44:23 = 44:23

=head3 y (yyyy)

   2008-02-05T12:30:30 = 2008
   1995-12-22T09:05:02 = 1995
  -0010-09-15T04:44:23 = -010

=head3 yM (M-yyyy)

   2008-02-05T12:30:30 = 2-2008
   1995-12-22T09:05:02 = 12-1995
  -0010-09-15T04:44:23 = 9--010

=head3 yMEd (EEE d-M-yyyy)

   2008-02-05T12:30:30 = Tus 5-2-2008
   1995-12-22T09:05:02 = Fal 22-12-1995
  -0010-09-15T04:44:23 = Tok 15-9--010

=head3 yMMM (MMM yyyy)

   2008-02-05T12:30:30 = Fēp 2008
   1995-12-22T09:05:02 = Tis 1995
  -0010-09-15T04:44:23 = Sēp -010

=head3 yMMMEd (EEE d MMM yyyy)

   2008-02-05T12:30:30 = Tus 5 Fēp 2008
   1995-12-22T09:05:02 = Fal 22 Tis 1995
  -0010-09-15T04:44:23 = Tok 15 Sēp -010

=head3 yMMMM (MMMM yyyy)

   2008-02-05T12:30:30 = Fēpueli 2008
   1995-12-22T09:05:02 = Tisema 1995
  -0010-09-15T04:44:23 = Sēpitema -010

=head3 yQ (yyyy Q)

   2008-02-05T12:30:30 = 2008 1
   1995-12-22T09:05:02 = 1995 4
  -0010-09-15T04:44:23 = -010 3

=head3 yQQQ (yyyy QQQ)

   2008-02-05T12:30:30 = 2008 K1
   1995-12-22T09:05:02 = 1995 K4
  -0010-09-15T04:44:23 = -010 K3

=head3 yyMM (MM-yy)

   2008-02-05T12:30:30 = 02-8
   1995-12-22T09:05:02 = 12-95
  -0010-09-15T04:44:23 = 09-10

=head3 yyMMM (MMM yy)

   2008-02-05T12:30:30 = Fēp 8
   1995-12-22T09:05:02 = Tis 95
  -0010-09-15T04:44:23 = Sēp 10

=head3 yyQ (Q yy)

   2008-02-05T12:30:30 = 1 8
   1995-12-22T09:05:02 = 4 95
  -0010-09-15T04:44:23 = 3 10

=head2 Miscellaneous

=head3 Prefers 24 hour time?

Yes

=head3 Local first day of the week

Mōnite


=head1 SUPPORT

See L<DateTime::Locale>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT

Copyright (c) 2008 David Rolsky. All rights reserved. This program is
free software; you can redistribute it and/or modify it under the same
terms as Perl itself.

This module was generated from data provided by the CLDR project, see
the LICENSE.cldr in this distribution for details on the CLDR data's
license.

=cut
