###########################################################################
#
# This file is auto-generated by the Perl DateTime Suite locale
# generator (0.05).  This code generator comes with the
# DateTime::Locale distribution in the tools/ directory, and is called
# generate-from-cldr.
#
# This file as generated from the CLDR XML locale data.  See the
# LICENSE.cldr file included in this distribution for license details.
#
# This file was generated from the source file hr.xml
# The source file version number was 1.90, generated on
# 2008/06/26 03:47:57.
#
# Do not edit this file directly.
#
###########################################################################

package DateTime::Locale::hr;

use strict;
use warnings;
use utf8;

use base 'DateTime::Locale::root';

sub cldr_version { return "1\.6" }

{
    my $am_pm_abbreviated = [ "AM", "PM" ];
    sub am_pm_abbreviated { return $am_pm_abbreviated }
}
{
    my $date_format_full = "EEEE\,\ d\.\ MMMM\ yyyy\.";
    sub date_format_full { return $date_format_full }
}

{
    my $date_format_long = "d\.\ MMMM\ yyyy\.";
    sub date_format_long { return $date_format_long }
}

{
    my $date_format_medium = "d\.\ MMM\.\ yyyy\.";
    sub date_format_medium { return $date_format_medium }
}

{
    my $date_format_short = "dd\.MM\.yyyy\.";
    sub date_format_short { return $date_format_short }
}

{
    my $datetime_format = "\{1\}\ \{0\}";
    sub datetime_format { return $datetime_format }
}

{
    my $day_format_abbreviated = [ "pon", "uto", "sri", "čet", "pet", "sub", "ned" ];
    sub day_format_abbreviated { return $day_format_abbreviated }
}

sub day_format_narrow { $_[0]->day_stand_alone_narrow() }

{
    my $day_format_wide = [ "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota", "nedjelja" ];
    sub day_format_wide { return $day_format_wide }
}

sub day_stand_alone_abbreviated { $_[0]->day_format_abbreviated() }

{
    my $day_stand_alone_narrow = [ "p", "u", "s", "č", "p", "s", "n" ];
    sub day_stand_alone_narrow { return $day_stand_alone_narrow }
}

sub day_stand_alone_wide { $_[0]->day_format_wide() }

{
    my $era_abbreviated = [ "pr\.n\.e\.", "AD" ];
    sub era_abbreviated { return $era_abbreviated }
}

sub era_narrow { $_[0]->era_abbreviated() }

{
    my $era_wide = [ "Prije\ Krista", "Poslije\ Krista" ];
    sub era_wide { return $era_wide }
}
{
    my $first_day_of_week = 1;
    sub first_day_of_week { return $first_day_of_week }
}

{
    my $month_format_abbreviated = [ "sij", "vel", "ožu", "tra", "svi", "lip", "srp", "kol", "ruj", "lis", "stu", "pro" ];
    sub month_format_abbreviated { return $month_format_abbreviated }
}

sub month_format_narrow { $_[0]->month_stand_alone_narrow() }

{
    my $month_format_wide = [ "siječnja", "veljače", "ožujka", "travnja", "svibnja", "lipnja", "srpnja", "kolovoza", "rujna", "listopada", "studenoga", "prosinca" ];
    sub month_format_wide { return $month_format_wide }
}

sub month_stand_alone_abbreviated { $_[0]->month_format_abbreviated() }

{
    my $month_stand_alone_narrow = [ "s", "v", "o", "t", "s", "l", "s", "k", "r", "l", "s", "p" ];
    sub month_stand_alone_narrow { return $month_stand_alone_narrow }
}
{
    my $month_stand_alone_wide = [ "siječanj", "veljača", "ožujak", "travanj", "svibanj", "lipanj", "srpanj", "kolovoz", "rujan", "listopad", "studeni", "prosinac" ];
    sub month_stand_alone_wide { return $month_stand_alone_wide }
}
{
    my $quarter_format_abbreviated = [ "1kv", "2kv", "3kv", "4kv" ];
    sub quarter_format_abbreviated { return $quarter_format_abbreviated }
}
{
    my $quarter_format_wide = [ "1\.\ kvartal", "2\.\ kvartal", "3\.\ kvartal", "4\.\ kvartal" ];
    sub quarter_format_wide { return $quarter_format_wide }
}

sub quarter_stand_alone_abbreviated { $_[0]->quarter_format_abbreviated() }


sub quarter_stand_alone_wide { $_[0]->quarter_format_wide() }

{
    my $time_format_full = "HH\:mm\:ss\ v";
    sub time_format_full { return $time_format_full }
}

{
    my $time_format_long = "HH\:mm\:ss\ z";
    sub time_format_long { return $time_format_long }
}

{
    my $time_format_medium = "HH\:mm\:ss";
    sub time_format_medium { return $time_format_medium }
}

{
    my $time_format_short = "HH\:mm";
    sub time_format_short { return $time_format_short }
}

{
    my $_format_for_HHmm = "HH\:mm";
    sub _format_for_HHmm { return $_format_for_HHmm }
}

{
    my $_format_for_HHmmss = "HH\:mm\:ss";
    sub _format_for_HHmmss { return $_format_for_HHmmss }
}

{
    my $_format_for_MMMMdd = "MMMM\ dd";
    sub _format_for_MMMMdd { return $_format_for_MMMMdd }
}

{
    my $_format_for_MMdd = "MM\.dd";
    sub _format_for_MMdd { return $_format_for_MMdd }
}

{
    my $_format_for_hhmm = "hh\:mm\ a";
    sub _format_for_hhmm { return $_format_for_hhmm }
}

{
    my $_format_for_hhmmss = "hh\:mm\:ss\ a";
    sub _format_for_hhmmss { return $_format_for_hhmmss }
}

{
    my $_format_for_yyMMMEEEd = "EEE\ yy\.MMM\ d";
    sub _format_for_yyMMMEEEd { return $_format_for_yyMMMEEEd }
}

{
    my $_format_for_yyQ = "Q\ yy";
    sub _format_for_yyQ { return $_format_for_yyQ }
}

{
    my $_format_for_yyQQQQ = "QQQQ\ yy";
    sub _format_for_yyQQQQ { return $_format_for_yyQQQQ }
}

{
    my $_format_for_yyyyMM = "yyyy\.MM";
    sub _format_for_yyyyMM { return $_format_for_yyyyMM }
}

{
    my $_format_for_yyyyMMMM = "yyyy\.\ MMMM";
    sub _format_for_yyyyMMMM { return $_format_for_yyyyMMMM }
}

{
    my $_available_formats =
        {
          "HHmm" => "HH\:mm",
          "HHmmss" => "HH\:mm\:ss",
          "MMMMdd" => "MMMM\ dd",
          "MMdd" => "MM\.dd",
          "hhmm" => "hh\:mm\ a",
          "hhmmss" => "hh\:mm\:ss\ a",
          "yyMMMEEEd" => "EEE\ yy\.MMM\ d",
          "yyQ" => "Q\ yy",
          "yyQQQQ" => "QQQQ\ yy",
          "yyyyMM" => "yyyy\.MM",
          "yyyyMMMM" => "yyyy\.\ MMMM"
        };
    sub _available_formats { return $_available_formats }
}

1;

__END__


=pod

=encoding utf8

=head1 NAME

DateTime::Locale::hr

=head1 SYNOPSIS

  use DateTime;

  my $dt = DateTime->now( locale => 'hr' );
  print $dt->month_name();

=head1 DESCRIPTION

This is the DateTime locale package for Croatian.

=head1 DATA

This locale inherits from the L<DateTime::Locale::root> locale.

It contains the following data.

=head2 Days

=head3 Wide (format)

  ponedjeljak
  utorak
  srijeda
  četvrtak
  petak
  subota
  nedjelja

=head3 Abbreviated (format)

  pon
  uto
  sri
  čet
  pet
  sub
  ned

=head3 Narrow (format)

  p
  u
  s
  č
  p
  s
  n

=head3 Wide (stand-alone)

  ponedjeljak
  utorak
  srijeda
  četvrtak
  petak
  subota
  nedjelja

=head3 Abbreviated (stand-alone)

  pon
  uto
  sri
  čet
  pet
  sub
  ned

=head3 Narrow (stand-alone)

  p
  u
  s
  č
  p
  s
  n

=head2 Months

=head3 Wide (format)

  siječnja
  veljače
  ožujka
  travnja
  svibnja
  lipnja
  srpnja
  kolovoza
  rujna
  listopada
  studenoga
  prosinca

=head3 Abbreviated (format)

  sij
  vel
  ožu
  tra
  svi
  lip
  srp
  kol
  ruj
  lis
  stu
  pro

=head3 Narrow (format)

  s
  v
  o
  t
  s
  l
  s
  k
  r
  l
  s
  p

=head3 Wide (stand-alone)

  siječanj
  veljača
  ožujak
  travanj
  svibanj
  lipanj
  srpanj
  kolovoz
  rujan
  listopad
  studeni
  prosinac

=head3 Abbreviated (stand-alone)

  sij
  vel
  ožu
  tra
  svi
  lip
  srp
  kol
  ruj
  lis
  stu
  pro

=head3 Narrow (stand-alone)

  s
  v
  o
  t
  s
  l
  s
  k
  r
  l
  s
  p

=head2 Quarters

=head3 Wide (format)

  1. kvartal
  2. kvartal
  3. kvartal
  4. kvartal

=head3 Abbreviated (format)

  1kv
  2kv
  3kv
  4kv

=head3 Narrow (format)

  1
  2
  3
  4

=head3 Wide (stand-alone)

  1. kvartal
  2. kvartal
  3. kvartal
  4. kvartal

=head3 Abbreviated (stand-alone)

  1kv
  2kv
  3kv
  4kv

=head3 Narrow (stand-alone)

  1
  2
  3
  4

=head2 Eras

=head3 Wide

  Prije Krista
  Poslije Krista

=head3 Abbreviated

  pr.n.e.
  AD

=head3 Narrow

  pr.n.e.
  AD

=head2 Date Formats

=head3 Full

   2008-02-05T12:30:30 = utorak, 5. veljače 2008.
   1995-12-22T09:05:02 = petak, 22. prosinca 1995.
  -0010-09-15T04:44:23 = subota, 15. rujna -010.

=head3 Long

   2008-02-05T12:30:30 = 5. veljače 2008.
   1995-12-22T09:05:02 = 22. prosinca 1995.
  -0010-09-15T04:44:23 = 15. rujna -010.

=head3 Medium

   2008-02-05T12:30:30 = 5. vel. 2008.
   1995-12-22T09:05:02 = 22. pro. 1995.
  -0010-09-15T04:44:23 = 15. ruj. -010.

=head3 Short

   2008-02-05T12:30:30 = 05.02.2008.
   1995-12-22T09:05:02 = 22.12.1995.
  -0010-09-15T04:44:23 = 15.09.-010.

=head3 Default

   2008-02-05T12:30:30 = 5. vel. 2008.
   1995-12-22T09:05:02 = 22. pro. 1995.
  -0010-09-15T04:44:23 = 15. ruj. -010.

=head2 Time Formats

=head3 Full

   2008-02-05T12:30:30 = 12:30:30 UTC
   1995-12-22T09:05:02 = 09:05:02 UTC
  -0010-09-15T04:44:23 = 04:44:23 UTC

=head3 Long

   2008-02-05T12:30:30 = 12:30:30 UTC
   1995-12-22T09:05:02 = 09:05:02 UTC
  -0010-09-15T04:44:23 = 04:44:23 UTC

=head3 Medium

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head3 Short

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 09:05
  -0010-09-15T04:44:23 = 04:44

=head3 Default

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head2 Datetime Formats

=head3 Full

   2008-02-05T12:30:30 = utorak, 5. veljače 2008. 12:30:30 UTC
   1995-12-22T09:05:02 = petak, 22. prosinca 1995. 09:05:02 UTC
  -0010-09-15T04:44:23 = subota, 15. rujna -010. 04:44:23 UTC

=head3 Long

   2008-02-05T12:30:30 = 5. veljače 2008. 12:30:30 UTC
   1995-12-22T09:05:02 = 22. prosinca 1995. 09:05:02 UTC
  -0010-09-15T04:44:23 = 15. rujna -010. 04:44:23 UTC

=head3 Medium

   2008-02-05T12:30:30 = 5. vel. 2008. 12:30:30
   1995-12-22T09:05:02 = 22. pro. 1995. 09:05:02
  -0010-09-15T04:44:23 = 15. ruj. -010. 04:44:23

=head3 Short

   2008-02-05T12:30:30 = 05.02.2008. 12:30
   1995-12-22T09:05:02 = 22.12.1995. 09:05
  -0010-09-15T04:44:23 = 15.09.-010. 04:44

=head3 Default

   2008-02-05T12:30:30 = 5. vel. 2008. 12:30:30
   1995-12-22T09:05:02 = 22. pro. 1995. 09:05:02
  -0010-09-15T04:44:23 = 15. ruj. -010. 04:44:23

=head2 Available Formats

=head3 HHmm (HH:mm)

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 09:05
  -0010-09-15T04:44:23 = 04:44

=head3 HHmmss (HH:mm:ss)

   2008-02-05T12:30:30 = 12:30:30
   1995-12-22T09:05:02 = 09:05:02
  -0010-09-15T04:44:23 = 04:44:23

=head3 Hm (H:mm)

   2008-02-05T12:30:30 = 12:30
   1995-12-22T09:05:02 = 9:05
  -0010-09-15T04:44:23 = 4:44

=head3 M (L)

   2008-02-05T12:30:30 = 2
   1995-12-22T09:05:02 = 12
  -0010-09-15T04:44:23 = 9

=head3 MEd (E, M-d)

   2008-02-05T12:30:30 = uto, 2-5
   1995-12-22T09:05:02 = pet, 12-22
  -0010-09-15T04:44:23 = sub, 9-15

=head3 MMM (LLL)

   2008-02-05T12:30:30 = vel
   1995-12-22T09:05:02 = pro
  -0010-09-15T04:44:23 = ruj

=head3 MMMEd (E MMM d)

   2008-02-05T12:30:30 = uto vel 5
   1995-12-22T09:05:02 = pet pro 22
  -0010-09-15T04:44:23 = sub ruj 15

=head3 MMMMEd (E MMMM d)

   2008-02-05T12:30:30 = uto veljače 5
   1995-12-22T09:05:02 = pet prosinca 22
  -0010-09-15T04:44:23 = sub rujna 15

=head3 MMMMd (MMMM d)

   2008-02-05T12:30:30 = veljače 5
   1995-12-22T09:05:02 = prosinca 22
  -0010-09-15T04:44:23 = rujna 15

=head3 MMMMdd (MMMM dd)

   2008-02-05T12:30:30 = veljače 05
   1995-12-22T09:05:02 = prosinca 22
  -0010-09-15T04:44:23 = rujna 15

=head3 MMMd (MMM d)

   2008-02-05T12:30:30 = vel 5
   1995-12-22T09:05:02 = pro 22
  -0010-09-15T04:44:23 = ruj 15

=head3 MMdd (MM.dd)

   2008-02-05T12:30:30 = 02.05
   1995-12-22T09:05:02 = 12.22
  -0010-09-15T04:44:23 = 09.15

=head3 Md (M-d)

   2008-02-05T12:30:30 = 2-5
   1995-12-22T09:05:02 = 12-22
  -0010-09-15T04:44:23 = 9-15

=head3 d (d)

   2008-02-05T12:30:30 = 5
   1995-12-22T09:05:02 = 22
  -0010-09-15T04:44:23 = 15

=head3 hhmm (hh:mm a)

   2008-02-05T12:30:30 = 12:30 PM
   1995-12-22T09:05:02 = 09:05 AM
  -0010-09-15T04:44:23 = 04:44 AM

=head3 hhmmss (hh:mm:ss a)

   2008-02-05T12:30:30 = 12:30:30 PM
   1995-12-22T09:05:02 = 09:05:02 AM
  -0010-09-15T04:44:23 = 04:44:23 AM

=head3 ms (mm:ss)

   2008-02-05T12:30:30 = 30:30
   1995-12-22T09:05:02 = 05:02
  -0010-09-15T04:44:23 = 44:23

=head3 y (yyyy)

   2008-02-05T12:30:30 = 2008
   1995-12-22T09:05:02 = 1995
  -0010-09-15T04:44:23 = -010

=head3 yM (yyyy-M)

   2008-02-05T12:30:30 = 2008-2
   1995-12-22T09:05:02 = 1995-12
  -0010-09-15T04:44:23 = -010-9

=head3 yMEd (EEE, yyyy-M-d)

   2008-02-05T12:30:30 = uto, 2008-2-5
   1995-12-22T09:05:02 = pet, 1995-12-22
  -0010-09-15T04:44:23 = sub, -010-9-15

=head3 yMMM (yyyy MMM)

   2008-02-05T12:30:30 = 2008 vel
   1995-12-22T09:05:02 = 1995 pro
  -0010-09-15T04:44:23 = -010 ruj

=head3 yMMMEd (EEE, yyyy MMM d)

   2008-02-05T12:30:30 = uto, 2008 vel 5
   1995-12-22T09:05:02 = pet, 1995 pro 22
  -0010-09-15T04:44:23 = sub, -010 ruj 15

=head3 yMMMM (yyyy MMMM)

   2008-02-05T12:30:30 = 2008 veljače
   1995-12-22T09:05:02 = 1995 prosinca
  -0010-09-15T04:44:23 = -010 rujna

=head3 yQ (yyyy Q)

   2008-02-05T12:30:30 = 2008 1
   1995-12-22T09:05:02 = 1995 4
  -0010-09-15T04:44:23 = -010 3

=head3 yQQQ (yyyy QQQ)

   2008-02-05T12:30:30 = 2008 1kv
   1995-12-22T09:05:02 = 1995 4kv
  -0010-09-15T04:44:23 = -010 3kv

=head3 yyMMMEEEd (EEE yy.MMM d)

   2008-02-05T12:30:30 = uto 8.vel 5
   1995-12-22T09:05:02 = pet 95.pro 22
  -0010-09-15T04:44:23 = sub 10.ruj 15

=head3 yyQ (Q yy)

   2008-02-05T12:30:30 = 1 8
   1995-12-22T09:05:02 = 4 95
  -0010-09-15T04:44:23 = 3 10

=head3 yyQQQQ (QQQQ yy)

   2008-02-05T12:30:30 = 1. kvartal 8
   1995-12-22T09:05:02 = 4. kvartal 95
  -0010-09-15T04:44:23 = 3. kvartal 10

=head3 yyyyMM (yyyy.MM)

   2008-02-05T12:30:30 = 2008.02
   1995-12-22T09:05:02 = 1995.12
  -0010-09-15T04:44:23 = -010.09

=head3 yyyyMMMM (yyyy. MMMM)

   2008-02-05T12:30:30 = 2008. veljače
   1995-12-22T09:05:02 = 1995. prosinca
  -0010-09-15T04:44:23 = -010. rujna

=head2 Miscellaneous

=head3 Prefers 24 hour time?

Yes

=head3 Local first day of the week

ponedjeljak


=head1 SUPPORT

See L<DateTime::Locale>.

=head1 AUTHOR

Dave Rolsky <autarch@urth.org>

=head1 COPYRIGHT

Copyright (c) 2008 David Rolsky. All rights reserved. This program is
free software; you can redistribute it and/or modify it under the same
terms as Perl itself.

This module was generated from data provided by the CLDR project, see
the LICENSE.cldr in this distribution for details on the CLDR data's
license.

=cut
