
use strict;
use warnings;

BEGIN { require 5.006; }

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  'ABSTRACT' => 'application class for managing a simple sysadmin log',
  'AUTHOR' => 'Mike Doherty <doherty@cpan.org>',
  'BUILD_REQUIRES' => {
    'File::Find' => '0',
    'File::Temp' => '0',
    'IO::Scalar' => '0',
    'Test::More' => '0',
    'Test::Output' => '0'
  },
  'CONFIGURE_REQUIRES' => {
    'ExtUtils::MakeMaker' => '6.30'
  },
  'DISTNAME' => 'App-Sysadmin-Log-Simple',
  'EXE_FILES' => [
    'bin/log'
  ],
  'LICENSE' => 'perl',
  'NAME' => 'App::Sysadmin::Log::Simple',
  'PREREQ_PM' => {
    'File::Find::Rule' => '0',
    'File::HomeDir' => '0',
    'File::Path' => '2.07',
    'Getopt::Long' => '0',
    'IO::Pager' => '0',
    'IO::Socket' => '0',
    'Module::Pluggable' => '0',
    'Pod::Usage' => '0',
    'perl5i::2' => '0'
  },
  'VERSION' => '0.004',
  'test' => {
    'TESTS' => 't/*.t'
  }
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.56) } ) {
  my $br = delete $WriteMakefileArgs{BUILD_REQUIRES};
  my $pp = $WriteMakefileArgs{PREREQ_PM};
  for my $mod ( keys %$br ) {
    if ( exists $pp->{$mod} ) {
      $pp->{$mod} = $br->{$mod} if $br->{$mod} > $pp->{$mod};
    }
    else {
      $pp->{$mod} = $br->{$mod};
    }
  }
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



