package Locales::DB::Language::ga;

# Auto generated from CLDR

$Locales::DB::Language::ga::VERSION = '0.02';

$Locales::DB::Language::ga::cldr_version = '1.7.1';

%Locales::DB::Language::ga::misc_info = (
    'cldr_formats' => {
        'decimal'   => "\#\,\#\#0\.\#\#\#",
        'language'  => "Language\:\ \{0\}",
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [ 'en_IE' ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr' => {
            'content' => "níl\:n",
            'draft'   => 'unconfirmed'
        },
        'yesstr' => {
            'content' => "tá\:t",
            'draft'   => 'unconfirmed'
        }
    },
);

%Locales::DB::Language::ga::code_to_name = (
    'aa'    => 'aa',
    'ab'    => 'Abcáisis',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Aivéistis',
    'af'    => 'Afracáinis',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'Amarais',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'Araibis',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'Asaimis',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'Asarbaiseáinis',
    'ba'    => 'Baiscíris',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'Bealarúisis',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'Bulgáiris',
    'bh'    => 'Bihairis',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'Beangáilis',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibéadais',
    'br'    => 'Briotáinis',
    'bra'   => 'Braj',
    'bs'    => 'Boisnis',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'Catalóinis',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Sisinis',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsaicis',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Craíais',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'Seicis',
    'csb'   => 'Kashubian',
    'cu'    => "Slavais\ na\ hEaglaise",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Suvaisis',
    'cy'    => 'Breatnais',
    'da'    => 'Danmhairgis',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'Gearmáinis',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'Gréigis',
    'elx'   => 'Elamite',
    'en'    => 'Béarla',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'Esperanto',
    'es'    => 'Spáinnis',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'Eastóinis',
    'eu'    => 'Bascais',
    'ewo'   => 'Ewondo',
    'fa'    => 'Peirsis',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'Fionlainnis',
    'fil'   => 'fil',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fidsis',
    'fo'    => 'Faróis',
    'fon'   => 'Fon',
    'fr'    => 'Fraincis',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "Freaslainnis\ Iartharach",
    'ga'    => 'Gaeilge',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "Gaeilge\ na\ hAlban",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'Gailísis',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'Guaráinis',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'Gúisearáitis',
    'gv'    => 'Mannainis',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Haváíais',
    'he'    => 'Eabhrais',
    'hi'    => 'Hiondúis',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'Cróitis',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'Ungáiris',
    'hup'   => 'Hupa',
    'hy'    => 'Airméinis',
    'hz'    => 'Herero',
    'ia'    => 'Interlingua',
    'iba'   => 'Iban',
    'id'    => 'Indinéisis',
    'ie'    => 'Interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'Íoslainnis',
    'it'    => 'Iodáilis',
    'iu'    => 'Ionúitis',
    'ja'    => 'Seapáinis',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'Iávais',
    'ka'    => 'Seoirsis',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Casachais',
    'kl'    => 'Kalaallisut',
    'km'    => 'Cambóidis',
    'kmb'   => 'Kimbundu',
    'kn'    => 'Cannadais',
    'ko'    => 'Cóiréis',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Caismíris',
    'ku'    => 'Coirdis',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornais',
    'ky'    => 'Cirgeasais',
    'la'    => 'Laidin',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Leitseabuirgis',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'ln',
    'lo'    => 'Laosais',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'Liotuáinis',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'Laitvis',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagásais',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maorais',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'Macadóinis',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'Mailéalaimis',
    'mn'    => 'Mongóilis',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldáivis',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'Maraitis',
    'ms'    => 'Malaeis',
    'mt'    => 'Maltais',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmais',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nárúis',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Ioruais\ Bokmål",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'Neipealais',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'Ollainnis',
    'nl_be' => 'Flemish',
    'nn'    => "Ioruais\ Nynorsk",
    'no'    => 'Ioruais',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navachóis',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'Ocatáinis',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'Oraisis',
    'os'    => 'Óiséitis',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'Puinseáibis',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'Polainnis',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'Paistis',
    'pt'    => 'Portaingéilis',
    'pt_br' => "Portaingéilis\ Bhrasaíleach",
    'pt_pt' => "Portaingéilis\ Ibéireach",
    'qu'    => 'Ceatsuais',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'Rómáinis',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'Rúisis',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'Sanscrait',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sairdínis',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'Sindis',
    'se'    => "Sáimis\ Thuaidh",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "Seirbea\-Chróitis",
    'shn'   => 'Shan',
    'si'    => 'Siolóinis',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'Slóvaicis',
    'sl'    => 'Slóivéinis',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samóis',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'Somáilis',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'Albáinis',
    'sr'    => 'Seirbis',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Sótais\ Dheisceartach",
    'su'    => 'Sundais',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'Sualainnis',
    'sw'    => 'Svahaílis',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'Tamailis',
    'tai'   => "Tai\ Language",
    'te'    => 'Teileagúis',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'Téalainnis',
    'ti'    => 'Tigrinis',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'Tuircméinis',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagálaigis',
    'tlh'   => 'Klingon',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'Tuircis',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatarais',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'Tvís',
    'ty'    => 'Taihítis',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'ug',
    'uga'   => 'Ugaritic',
    'uk'    => 'Úcráinis',
    'umb'   => 'Umbundu',
    'und'   => "Teanga\ Anaithnid\ nó\ Neamhbhailí",
    'ur'    => 'Urdais',
    'uz'    => 'Úisbéicis',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'Vítneamais',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Vallúnais',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'Cósais',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'Giúdais',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Sínis',
    'znd'   => 'Zande',
    'zu'    => 'Súlúis',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ga::name_to_code = (
    'aa'                             => 'aa',
    'abcáisis'                      => 'ab',
    'achinese'                       => 'ace',
    'acoli'                          => 'ach',
    'adangme'                        => 'ada',
    'adyghe'                         => 'ady',
    'afracáinis'                    => 'af',
    'afrihili'                       => 'afh',
    'afroasiaticlanguage'            => 'afa',
    'ainu'                           => 'ain',
    'airméinis'                     => 'hy',
    'aivéistis'                     => 'ae',
    'akan'                           => 'ak',
    'akkadian'                       => 'akk',
    'albáinis'                      => 'sq',
    'aleut'                          => 'ale',
    'algonquianlanguage'             => 'alg',
    'altaiclanguage'                 => 'tut',
    'amarais'                        => 'am',
    'ancientegyptian'                => 'egy',
    'ancientgreek'                   => 'grc',
    'angika'                         => 'anp',
    'apachelanguage'                 => 'apa',
    'aragonese'                      => 'an',
    'araibis'                        => 'ar',
    'aramaic'                        => 'arc',
    'arapaho'                        => 'arp',
    'araucanian'                     => 'arn',
    'arawak'                         => 'arw',
    'aromanian'                      => 'rup',
    'artificiallanguage'             => 'art',
    'asaimis'                        => 'as',
    'asarbaiseáinis'                => 'az',
    'asturian'                       => 'ast',
    'athapascanlanguage'             => 'ath',
    'atsam'                          => 'cch',
    'australianenglish'              => 'en_au',
    'australianlanguage'             => 'aus',
    'austriangerman'                 => 'de_at',
    'austronesianlanguage'           => 'map',
    'avaric'                         => 'av',
    'awadhi'                         => 'awa',
    'aymara'                         => 'ay',
    'baiscíris'                     => 'ba',
    'balinese'                       => 'ban',
    'balticlanguage'                 => 'bat',
    'baluchi'                        => 'bal',
    'bambara'                        => 'bm',
    'bamilekelanguage'               => 'bai',
    'banda'                          => 'bad',
    'bantu'                          => 'bnt',
    'basa'                           => 'bas',
    'bascais'                        => 'eu',
    'batak'                          => 'btk',
    'bealarúisis'                   => 'be',
    'beangáilis'                    => 'bn',
    'beja'                           => 'bej',
    'bemba'                          => 'bem',
    'berber'                         => 'ber',
    'bhojpuri'                       => 'bho',
    'bihairis'                       => 'bh',
    'bikol'                          => 'bik',
    'bini'                           => 'bin',
    'bislama'                        => 'bi',
    'blin'                           => 'byn',
    'blissymbols'                    => 'zbl',
    'boisnis'                        => 'bs',
    'braj'                           => 'bra',
    'breatnais'                      => 'cy',
    'briotáinis'                    => 'br',
    'britishenglish'                 => 'en_gb',
    'buginese'                       => 'bug',
    'bulgáiris'                     => 'bg',
    'buriat'                         => 'bua',
    'burmais'                        => 'my',
    'béarla'                        => 'en',
    'caddo'                          => 'cad',
    'caismíris'                     => 'ks',
    'cambóidis'                     => 'km',
    'canadianenglish'                => 'en_ca',
    'canadianfrench'                 => 'fr_ca',
    'cannadais'                      => 'kn',
    'carib'                          => 'car',
    'casachais'                      => 'kk',
    'catalóinis'                    => 'ca',
    'caucasianlanguage'              => 'cau',
    'ceatsuais'                      => 'qu',
    'cebuano'                        => 'ceb',
    'celticlanguage'                 => 'cel',
    'centralamericanindianlanguage'  => 'cai',
    'chagatai'                       => 'chg',
    'chamiclanguage'                 => 'cmc',
    'chamorro'                       => 'ch',
    'cherokee'                       => 'chr',
    'cheyenne'                       => 'chy',
    'chibcha'                        => 'chb',
    'chinookjargon'                  => 'chn',
    'chipewyan'                      => 'chp',
    'choctaw'                        => 'cho',
    'chuukese'                       => 'chk',
    'cirgeasais'                     => 'ky',
    'classicalnewari'                => 'nwc',
    'classicalsyriac'                => 'syc',
    'coirdis'                        => 'ku',
    'coptic'                         => 'cop',
    'cornais'                        => 'kw',
    'corsaicis'                      => 'co',
    'craíais'                       => 'cr',
    'creek'                          => 'mus',
    'creoleorpidgin'                 => 'crp',
    'crimeanturkish'                 => 'crh',
    'cróitis'                       => 'hr',
    'cushiticlanguage'               => 'cus',
    'cóiréis'                      => 'ko',
    'cósais'                        => 'xh',
    'dakota'                         => 'dak',
    'danmhairgis'                    => 'da',
    'dargwa'                         => 'dar',
    'dayak'                          => 'day',
    'delaware'                       => 'del',
    'dinka'                          => 'din',
    'divehi'                         => 'dv',
    'dogri'                          => 'doi',
    'dogrib'                         => 'dgr',
    'dravidianlanguage'              => 'dra',
    'duala'                          => 'dua',
    'dyula'                          => 'dyu',
    'dzongkha'                       => 'dz',
    'eabhrais'                       => 'he',
    'easternfrisian'                 => 'frs',
    'eastóinis'                     => 'et',
    'efik'                           => 'efi',
    'ekajuk'                         => 'eka',
    'elamite'                        => 'elx',
    'englishbasedcreoleorpidgin'     => 'cpe',
    'erzya'                          => 'myv',
    'esperanto'                      => 'eo',
    'ewe'                            => 'ee',
    'ewondo'                         => 'ewo',
    'fang'                           => 'fan',
    'fanti'                          => 'fat',
    'faróis'                        => 'fo',
    'fidsis'                         => 'fj',
    'fil'                            => 'fil',
    'finnougrianlanguage'            => 'fiu',
    'fionlainnis'                    => 'fi',
    'flemish'                        => 'nl_be',
    'fon'                            => 'fon',
    'fraincis'                       => 'fr',
    'freaslainnisiartharach'         => 'fy',
    'frenchbasedcreoleorpidgin'      => 'cpf',
    'friulian'                       => 'fur',
    'fulah'                          => 'ff',
    'ga'                             => 'gaa',
    'gaeilge'                        => 'ga',
    'gaeilgenahalban'                => 'gd',
    'gailísis'                      => 'gl',
    'ganda'                          => 'lg',
    'gayo'                           => 'gay',
    'gbaya'                          => 'gba',
    'gearmáinis'                    => 'de',
    'geez'                           => 'gez',
    'germaniclanguage'               => 'gem',
    'gilbertese'                     => 'gil',
    'giúdais'                       => 'yi',
    'gondi'                          => 'gon',
    'gorontalo'                      => 'gor',
    'gothic'                         => 'got',
    'grebo'                          => 'grb',
    'gréigis'                       => 'el',
    'guaráinis'                     => 'gn',
    "gwich\Ê\¼in"                  => 'gwi',
    'gúisearáitis'                 => 'gu',
    'haida'                          => 'hai',
    'haitian'                        => 'ht',
    'hausa'                          => 'ha',
    'haváíais'                     => 'haw',
    'herero'                         => 'hz',
    'hiligaynon'                     => 'hil',
    'himachali'                      => 'him',
    'hiondúis'                      => 'hi',
    'hirimotu'                       => 'ho',
    'hittite'                        => 'hit',
    'hmong'                          => 'hmn',
    'hupa'                           => 'hup',
    'iban'                           => 'iba',
    'iberianspanish'                 => 'es_es',
    'ido'                            => 'io',
    'igbo'                           => 'ig',
    'ijo'                            => 'ijo',
    'iloko'                          => 'ilo',
    'inarisami'                      => 'smn',
    'indiclanguage'                  => 'inc',
    'indinéisis'                    => 'id',
    'indoeuropeanlanguage'           => 'ine',
    'ingush'                         => 'inh',
    'interlingua'                    => 'ia',
    'interlingue'                    => 'ie',
    'inupiaq'                        => 'ik',
    'iodáilis'                      => 'it',
    'ionúitis'                      => 'iu',
    'ioruais'                        => 'no',
    'ioruaisbokmål'                 => 'nb',
    'ioruaisnynorsk'                 => 'nn',
    'iranianlanguage'                => 'ira',
    'iroquoianlanguage'              => 'iro',
    'iávais'                        => 'jv',
    'jju'                            => 'kaj',
    'judeoarabic'                    => 'jrb',
    'judeopersian'                   => 'jpr',
    'kabardian'                      => 'kbd',
    'kabyle'                         => 'kab',
    'kachin'                         => 'kac',
    'kalaallisut'                    => 'kl',
    'kalmyk'                         => 'xal',
    'kamba'                          => 'kam',
    'kanuri'                         => 'kr',
    'karachaybalkar'                 => 'krc',
    'karakalpak'                     => 'kaa',
    'karelian'                       => 'krl',
    'karen'                          => 'kar',
    'kashubian'                      => 'csb',
    'kawi'                           => 'kaw',
    'khasi'                          => 'kha',
    'khoisanlanguage'                => 'khi',
    'khotanese'                      => 'kho',
    'kikuyu'                         => 'ki',
    'kimbundu'                       => 'kmb',
    'kinyarwanda'                    => 'rw',
    'klingon'                        => 'tlh',
    'komi'                           => 'kv',
    'kongo'                          => 'kg',
    'konkani'                        => 'kok',
    'koro'                           => 'kfo',
    'kosraean'                       => 'kos',
    'kpelle'                         => 'kpe',
    'kru'                            => 'kro',
    'kuanyama'                       => 'kj',
    'kumyk'                          => 'kum',
    'kurukh'                         => 'kru',
    'kutenai'                        => 'kut',
    'ladino'                         => 'lad',
    'lahnda'                         => 'lah',
    'laidin'                         => 'la',
    'laitvis'                        => 'lv',
    'lamba'                          => 'lam',
    'laosais'                        => 'lo',
    'leitseabuirgis'                 => 'lb',
    'lezghian'                       => 'lez',
    'limburgish'                     => 'li',
    'liotuáinis'                    => 'lt',
    'ln'                             => 'ln',
    'lojban'                         => 'jbo',
    'lowersorbian'                   => 'dsb',
    'lowgerman'                      => 'nds',
    'lozi'                           => 'loz',
    'lubakatanga'                    => 'lu',
    'lubalulua'                      => 'lua',
    'luiseno'                        => 'lui',
    'lulesami'                       => 'smj',
    'lunda'                          => 'lun',
    'luo'                            => 'luo',
    'lushai'                         => 'lus',
    'macadóinis'                    => 'mk',
    'madurese'                       => 'mad',
    'magahi'                         => 'mag',
    'mailéalaimis'                  => 'ml',
    'maithili'                       => 'mai',
    'makasar'                        => 'mak',
    'malaeis'                        => 'ms',
    'malagásais'                    => 'mg',
    'maltais'                        => 'mt',
    'manchu'                         => 'mnc',
    'mandar'                         => 'mdr',
    'mandingo'                       => 'man',
    'manipuri'                       => 'mni',
    'mannainis'                      => 'gv',
    'manobolanguage'                 => 'mno',
    'maorais'                        => 'mi',
    'maraitis'                       => 'mr',
    'mari'                           => 'chm',
    'marshallese'                    => 'mh',
    'marwari'                        => 'mwr',
    'masai'                          => 'mas',
    'mayanlanguage'                  => 'myn',
    'mende'                          => 'men',
    'micmac'                         => 'mic',
    'middledutch'                    => 'dum',
    'middleenglish'                  => 'enm',
    'middlefrench'                   => 'frm',
    'middlehighgerman'               => 'gmh',
    'middleirish'                    => 'mga',
    'minangkabau'                    => 'min',
    'mirandese'                      => 'mwl',
    'miscellaneouslanguage'          => 'mis',
    'mohawk'                         => 'moh',
    'moksha'                         => 'mdf',
    'moldáivis'                     => 'mo',
    'mongo'                          => 'lol',
    'mongóilis'                     => 'mn',
    'monkhmerlanguage'               => 'mkh',
    'morisyen'                       => 'mfe',
    'mossi'                          => 'mos',
    'multiplelanguages'              => 'mul',
    'mundalanguage'                  => 'mun',
    'nahuatl'                        => 'nah',
    'navachóis'                     => 'nv',
    'ndonga'                         => 'ng',
    'neapolitan'                     => 'nap',
    'neipealais'                     => 'ne',
    'newari'                         => 'new',
    'nias'                           => 'nia',
    'nigerkordofanianlanguage'       => 'nic',
    'nilosaharanlanguage'            => 'ssa',
    'niuean'                         => 'niu',
    'nogai'                          => 'nog',
    'nolinguisticcontent'            => 'zxx',
    'northamericanindianlanguage'    => 'nai',
    'northernfrisian'                => 'frr',
    'northernsotho'                  => 'nso',
    'northndebele'                   => 'nd',
    'nubianlanguage'                 => 'nub',
    'nyamwezi'                       => 'nym',
    'nyanja'                         => 'ny',
    'nyankole'                       => 'nyn',
    'nyasatonga'                     => 'tog',
    'nyoro'                          => 'nyo',
    'nzima'                          => 'nzi',
    'nárúis'                       => 'na',
    "n\â\\ko"                   => 'nqo',
    'ocatáinis'                     => 'oc',
    'ojibwa'                         => 'oj',
    'oldenglish'                     => 'ang',
    'oldfrench'                      => 'fro',
    'oldhighgerman'                  => 'goh',
    'oldirish'                       => 'sga',
    'oldnorse'                       => 'non',
    'oldpersian'                     => 'peo',
    "oldproven\Ã\§al"              => 'pro',
    'ollainnis'                      => 'nl',
    'oraisis'                        => 'or',
    'oromo'                          => 'om',
    'osage'                          => 'osa',
    'otomianlanguage'                => 'oto',
    'ottomanturkish'                 => 'ota',
    'pahlavi'                        => 'pal',
    'paistis'                        => 'ps',
    'palauan'                        => 'pau',
    'pali'                           => 'pi',
    'pampanga'                       => 'pam',
    'pangasinan'                     => 'pag',
    'papiamento'                     => 'pap',
    'papuanlanguage'                 => 'paa',
    'peirsis'                        => 'fa',
    'philippinelanguage'             => 'phi',
    'phoenician'                     => 'phn',
    'pohnpeian'                      => 'pon',
    'polainnis'                      => 'pl',
    'portaingéilis'                 => 'pt',
    'portaingéilisbhrasaíleach'    => 'pt_br',
    'portaingéilisibéireach'       => 'pt_pt',
    'portuguesebasedcreoleorpidgin'  => 'cpp',
    'prakritlanguage'                => 'pra',
    'puinseáibis'                   => 'pa',
    'rajasthani'                     => 'raj',
    'rapanui'                        => 'rap',
    'rarotongan'                     => 'rar',
    'rhaetoromance'                  => 'rm',
    'romancelanguage'                => 'roa',
    'romany'                         => 'rom',
    'rundi'                          => 'rn',
    'rómáinis'                     => 'ro',
    'rúisis'                        => 'ru',
    'sairdínis'                     => 'sc',
    'salishanlanguage'               => 'sal',
    'samaritanaramaic'               => 'sam',
    'samilanguage'                   => 'smi',
    'samóis'                        => 'sm',
    'sandawe'                        => 'sad',
    'sango'                          => 'sg',
    'sanscrait'                      => 'sa',
    'santali'                        => 'sat',
    'sasak'                          => 'sas',
    'scots'                          => 'sco',
    'seapáinis'                     => 'ja',
    'seicis'                         => 'cs',
    'seirbeachróitis'               => 'sh',
    'seirbis'                        => 'sr',
    'selkup'                         => 'sel',
    'semiticlanguage'                => 'sem',
    'seoirsis'                       => 'ka',
    'serer'                          => 'srr',
    'shan'                           => 'shn',
    'shona'                          => 'sn',
    'sichuanyi'                      => 'ii',
    'sicilian'                       => 'scn',
    'sidamo'                         => 'sid',
    'signlanguage'                   => 'sgn',
    'siksika'                        => 'bla',
    'sindis'                         => 'sd',
    'sinotibetanlanguage'            => 'sit',
    'siolóinis'                     => 'si',
    'siouanlanguage'                 => 'sio',
    'sisinis'                        => 'ce',
    'skoltsami'                      => 'sms',
    'slavaisnaheaglaise'             => 'cu',
    'slave'                          => 'den',
    'slaviclanguage'                 => 'sla',
    'slóivéinis'                   => 'sl',
    'slóvaicis'                     => 'sk',
    'sogdien'                        => 'sog',
    'somáilis'                      => 'so',
    'songhai'                        => 'son',
    'soninke'                        => 'snk',
    'sorbianlanguage'                => 'wen',
    'southamericanindianlanguage'    => 'sai',
    'southernaltai'                  => 'alt',
    'southernsami'                   => 'sma',
    'southndebele'                   => 'nr',
    'spáinnis'                      => 'es',
    'sranantongo'                    => 'srn',
    'sualainnis'                     => 'sv',
    'sukuma'                         => 'suk',
    'sumerian'                       => 'sux',
    'sundais'                        => 'su',
    'susu'                           => 'sus',
    'suvaisis'                       => 'cv',
    'svahaílis'                     => 'sw',
    'swati'                          => 'ss',
    'swissfrench'                    => 'fr_ch',
    'swissgerman'                    => 'gsw',
    'swisshighgerman'                => 'de_ch',
    'syriac'                         => 'syr',
    'sáimisthuaidh'                 => 'se',
    'sínis'                         => 'zh',
    'sótaisdheisceartach'           => 'st',
    'súlúis'                       => 'zu',
    'tagálaigis'                    => 'tl',
    'taihítis'                      => 'ty',
    'tailanguage'                    => 'tai',
    'tajik'                          => 'tg',
    'tamailis'                       => 'ta',
    'tamashek'                       => 'tmh',
    'taroko'                         => 'trv',
    'tatarais'                       => 'tt',
    'teangaanaithnidnóneamhbhailí' => 'und',
    'teileagúis'                    => 'te',
    'tereno'                         => 'ter',
    'tetum'                          => 'tet',
    'tibéadais'                     => 'bo',
    'tigre'                          => 'tig',
    'tigrinis'                       => 'ti',
    'timne'                          => 'tem',
    'tiv'                            => 'tiv',
    'tlingit'                        => 'tli',
    'tokelau'                        => 'tkl',
    'tokpisin'                       => 'tpi',
    'tonga'                          => 'to',
    'tsimshian'                      => 'tsi',
    'tsonga'                         => 'ts',
    'tswana'                         => 'tn',
    'tuircis'                        => 'tr',
    'tuircméinis'                   => 'tk',
    'tumbuka'                        => 'tum',
    'tupilanguage'                   => 'tup',
    'tuvalu'                         => 'tvl',
    'tuvinian'                       => 'tyv',
    'tvís'                          => 'tw',
    'tyap'                           => 'kcg',
    'téalainnis'                    => 'th',
    "u\.s\.english"                  => 'en_us',
    'udmurt'                         => 'udm',
    'ug'                             => 'ug',
    'ugaritic'                       => 'uga',
    'umbundu'                        => 'umb',
    'ungáiris'                      => 'hu',
    'uppersorbian'                   => 'hsb',
    'urdais'                         => 'ur',
    'vai'                            => 'vai',
    'vallúnais'                     => 'wa',
    'venda'                          => 've',
    "volap\Ã\¼k"                   => 'vo',
    'votic'                          => 'vot',
    'vítneamais'                    => 'vi',
    'wakashanlanguage'               => 'wak',
    'walamo'                         => 'wal',
    'waray'                          => 'war',
    'washo'                          => 'was',
    'wolof'                          => 'wo',
    'yakut'                          => 'sah',
    'yao'                            => 'yao',
    'yapese'                         => 'yap',
    'yoruba'                         => 'yo',
    'yupiklanguage'                  => 'ypk',
    'zande'                          => 'znd',
    'zapotec'                        => 'zap',
    'zaza'                           => 'zza',
    'zenaga'                         => 'zen',
    'zhuang'                         => 'za',
    'zuni'                           => 'zun',
    'Íoslainnis'                    => 'is',
    'Óiséitis'                     => 'os',
    'Úcráinis'                     => 'uk',
    'Úisbéicis'                    => 'uz',
);

1;
