package Locales::DB::Language::et;

# Auto generated from CLDR

$Locales::DB::Language::et::VERSION = '0.01';

$Locales::DB::Language::et::cldr_version = '1.7.1';

%Locales::DB::Language::et::misc_info = (
    'cldr_formats' => {
        'decimal'  => "\#\,\#\#0\.\#\#\#",
        'language' => "Language\:\ \{0\}",
        'locale'   => "\{0\}\ \(\{1\}\)",
        'percent'  => [
            "\#\,\#\#0\%",
            {
                'alt'     => "proposed\-x1001",
                'content' => "\#\,\#\#0 \%",
                'draft'   => 'unconfirmed'
            }
        ],
        'territory' => "Region\:\ \{0\}"
    },
    'fallback'    => [ "en\ fi" ],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "ei\:e",
        'yesstr' => "jah\:j"
    },
);

%Locales::DB::Language::et::code_to_name = (
    'aa'    => 'afari',
    'ab'    => 'abhaasi',
    'ace'   => 'atšehi',
    'ach'   => 'akoli',
    'ada'   => 'adangme',
    'ady'   => 'adõgee',
    'ae'    => 'avesta',
    'af'    => 'afrikaani',
    'afa'   => "muu\ afroaasia",
    'afh'   => 'afrihili',
    'ain'   => 'ainu',
    'ak'    => 'akani',
    'akk'   => 'akadi',
    'ale'   => 'aleuudi',
    'alg'   => "algonkini\ keel",
    'alt'   => 'altai',
    'am'    => 'amhari',
    'an'    => 'aragoni',
    'ang'   => 'vanainglise',
    'anp'   => 'angika',
    'apa'   => "apatši\ keel",
    'ar'    => 'araabia',
    'arc'   => 'aramea',
    'arn'   => 'araukaani',
    'arp'   => 'arapaho',
    'art'   => "muu\ tehiskeel",
    'arw'   => 'aravaki',
    'as'    => 'assami',
    'ast'   => 'astuuria',
    'ath'   => "atapaski\ keeled",
    'aus'   => "austraali\ keel",
    'av'    => 'avaari',
    'awa'   => 'avadhi',
    'ay'    => 'aimara',
    'az'    => 'aserbaidžaani',
    'ba'    => 'baškiiri',
    'bad'   => 'banda',
    'bai'   => "bamileke\ keel",
    'bal'   => 'belutši',
    'ban'   => 'bali',
    'bas'   => 'basa',
    'bat'   => "balti\ keel",
    'be'    => 'valgevene',
    'bej'   => 'bedža',
    'bem'   => 'bemba',
    'ber'   => 'berberi',
    'bg'    => 'bulgaaria',
    'bh'    => 'bihaari',
    'bho'   => 'bhodžpuri',
    'bi'    => 'bislama',
    'bik'   => 'bikoli',
    'bin'   => 'edo',
    'bla'   => 'siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'bantu',
    'bo'    => 'tiibeti',
    'br'    => 'bretooni',
    'bra'   => 'bradži',
    'bs'    => 'bosnia',
    'btk'   => 'bataki',
    'bua'   => 'burjaadi',
    'bug'   => 'bugi',
    'byn'   => 'bilini',
    'ca'    => 'katalaani',
    'cad'   => 'kado',
    'cai'   => "Kesk\-Ameerika\ indiaani\ keel",
    'car'   => 'kariibi',
    'cau'   => "kaukaasia\ keel",
    'cch'   => 'atsam',
    'ce'    => 'tšetšeeni',
    'ceb'   => 'sebu',
    'cel'   => "keldi\ keel",
    'ch'    => 'tšamorro',
    'chb'   => 'tšibtša',
    'chg'   => 'tšagatai',
    'chk'   => 'tšuugi',
    'chm'   => 'mari',
    'chn'   => "tšinuki\ žargoon",
    'cho'   => 'tšokto',
    'chp'   => 'tšipevai',
    'chr'   => 'tšerokii',
    'chy'   => 'šaieeni',
    'cmc'   => "tšami\ keeled",
    'co'    => 'korsika',
    'cop'   => 'kopti',
    'cpe'   => "inglispõhjalised\ kreool\/pidžinkeel",
    'cpf'   => "prantsuspõhjalised\ kreool\/pidžinkeel",
    'cpp'   => "portugalipõhjalised\ kreool\/pidžinkeel",
    'cr'    => 'krii',
    'crh'   => 'krimmitatari',
    'crp'   => "kreool\/pidžinkeel",
    'cs'    => 'tšehhi',
    'csb'   => 'kašuubi',
    'cu'    => 'kirikuslaavi',
    'cus'   => "muu\ kuši\ keel",
    'cv'    => 'tšuvaši',
    'cy'    => 'kõmri',
    'da'    => 'taani',
    'dak'   => 'siuu',
    'dar'   => 'dargi',
    'day'   => 'bidayuhkeel',
    'de'    => 'saksa',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'delavari',
    'den'   => 'sleivi',
    'dgr'   => 'dogribi',
    'din'   => 'dinka',
    'doi'   => 'dogri',
    'dra'   => "draviidi\ keel",
    'dsb'   => 'alamsorbi',
    'dua'   => 'duala',
    'dum'   => 'keskhollandi',
    'dv'    => 'maldiivi',
    'dyu'   => 'djula',
    'dz'    => 'bhutani',
    'ee'    => 'eve',
    'efi'   => 'ibibio',
    'egy'   => 'muinasegiptuse',
    'eka'   => 'ekadžuki',
    'el'    => 'kreeka',
    'elx'   => 'eelami',
    'en'    => 'inglise',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "inglise\ \(USA\)",
    'enm'   => 'keskinglise',
    'eo'    => 'esperanto',
    'es'    => 'hispaania',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'eesti',
    'eu'    => 'baski',
    'ewo'   => 'evondo',
    'fa'    => 'pärsia',
    'fan'   => 'fangi',
    'fat'   => 'fanti',
    'ff'    => 'fulbe',
    'fi'    => 'soome',
    'fil'   => 'filipino',
    'fiu'   => "soomeugri\ keel",
    'fj'    => 'fidži',
    'fo'    => 'fääri',
    'fon'   => 'foni',
    'fr'    => 'prantsuse',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => 'keskprantsuse',
    'fro'   => 'vanaprantsuse',
    'frr'   => 'põhjafriisi',
    'frs'   => 'idafriisi',
    'fur'   => 'friuuli',
    'fy'    => 'läänefriisi',
    'ga'    => 'iiri',
    'gaa'   => 'gaa',
    'gay'   => 'gajo',
    'gba'   => 'gbaja',
    'gd'    => 'gaeli',
    'gem'   => "germaani\ keel",
    'gez'   => 'etioopia',
    'gil'   => 'kiribati',
    'gl'    => 'galeegi',
    'gmh'   => 'keskülemsaksa',
    'gn'    => 'guaranii',
    'goh'   => 'vanaülemsaksa',
    'gon'   => 'gondi',
    'gor'   => 'gorontalo',
    'got'   => 'gooti',
    'grb'   => 'grebo',
    'grc'   => 'vanakreeka',
    'gsw'   => 'alemanni',
    'gu'    => 'gudžarati',
    'gv'    => 'mänksi',
    'gwi'   => 'gvitšini',
    'ha'    => 'hausa',
    'hai'   => 'haida',
    'haw'   => 'havai',
    'he'    => 'heebrea',
    'hi'    => 'hindi',
    'hil'   => 'hiligainoni',
    'him'   => 'himtšali',
    'hit'   => 'heti',
    'hmn'   => 'hmongi',
    'ho'    => 'motu',
    'hr'    => 'horvaadi',
    'hsb'   => 'ülemsorbi',
    'ht'    => 'haiti',
    'hu'    => 'ungari',
    'hup'   => 'hupa',
    'hy'    => 'armeenia',
    'hz'    => 'herero',
    'ia'    => 'interlingua',
    'iba'   => 'ibani',
    'id'    => 'indoneesia',
    'ie'    => 'interlingue',
    'ig'    => 'ibo',
    'ii'    => "Sichuani\ jii",
    'ijo'   => 'idžo',
    'ik'    => 'injupiaki',
    'ilo'   => 'iloko',
    'inc'   => "india\ keel",
    'ine'   => "indoeuroopa\ keel",
    'inh'   => 'inguši',
    'io'    => 'ido',
    'ira'   => "muu\ Iraani",
    'iro'   => "irokeesi\ keel",
    'is'    => 'islandi',
    'it'    => 'itaalia',
    'iu'    => 'inuktituti',
    'ja'    => 'jaapani',
    'jbo'   => 'lojbani',
    'jpr'   => 'juudipärsia',
    'jrb'   => 'juudiaraabia',
    'jv'    => 'jaava',
    'ka'    => 'gruusia',
    'kaa'   => 'karakalpaki',
    'kab'   => 'kabiili',
    'kac'   => 'katšini',
    'kaj'   => 'jju',
    'kam'   => 'kamba',
    'kar'   => "kareni\ keel",
    'kaw'   => 'kaavi',
    'kbd'   => "kabardi\-tšerkessi",
    'kcg'   => 'tyap',
    'kfo'   => 'koro',
    'kg'    => 'kongo',
    'kha'   => 'khasi',
    'khi'   => "khoisani\ keel",
    'kho'   => 'saki',
    'ki'    => 'kikuju',
    'kj'    => 'ambo',
    'kk'    => 'kasahhi',
    'kl'    => 'grööni',
    'km'    => 'khmeeri',
    'kmb'   => 'mbundu',
    'kn'    => 'kannada',
    'ko'    => 'korea',
    'kok'   => 'konkani',
    'kos'   => 'kosrae',
    'kpe'   => 'kpelle',
    'kr'    => 'kanuri',
    'krc'   => "karatšai\-balkaari",
    'krl'   => 'karjala',
    'kro'   => 'kruu',
    'kru'   => 'oraoni',
    'ks'    => 'kašmiiri',
    'ku'    => 'kurdi',
    'kum'   => 'kumõki',
    'kut'   => 'kutenai',
    'kv'    => 'komi',
    'kw'    => 'korni',
    'ky'    => 'kirgiisi',
    'la'    => 'ladina',
    'lad'   => 'ladiino',
    'lah'   => 'lahnda',
    'lam'   => 'lamba',
    'lb'    => 'letseburgi',
    'lez'   => 'lesgi',
    'lg'    => 'ganda',
    'li'    => 'limburgi',
    'ln'    => 'lingala',
    'lo'    => 'lao',
    'lol'   => 'mongo',
    'loz'   => 'lozi',
    'lt'    => 'leedu',
    'lu'    => 'luba',
    'lua'   => 'lulua',
    'lui'   => 'luisenjo',
    'lun'   => 'lunda',
    'luo'   => 'luo',
    'lus'   => 'lušei',
    'lv'    => 'läti',
    'mad'   => 'madura',
    'mag'   => 'magali',
    'mai'   => 'maithili',
    'mak'   => 'makassari',
    'man'   => 'malinke',
    'map'   => "austroneesia\ keel",
    'mas'   => 'masai',
    'mdf'   => 'mokša',
    'mdr'   => 'mandari',
    'men'   => 'mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'malagassi',
    'mga'   => 'keskiiri',
    'mh'    => 'maršalli',
    'mi'    => 'maoori',
    'mic'   => 'mikmaki',
    'min'   => 'minangkabau',
    'mis'   => 'üksikkeeled',
    'mk'    => 'makedoonia',
    'mkh'   => "moni\-khmeeri\ keel",
    'ml'    => 'malajalami',
    'mn'    => 'mongoli',
    'mnc'   => 'mandžu',
    'mni'   => 'manipuri',
    'mno'   => "manobo\ keel",
    'mo'    => 'moldova',
    'moh'   => 'mohoogi',
    'mos'   => 'more',
    'mr'    => 'marathi',
    'ms'    => 'malai',
    'mt'    => 'malta',
    'mul'   => "mitu\ keelt",
    'mun'   => "munda\ keel",
    'mus'   => 'maskogi',
    'mwl'   => 'miranda',
    'mwr'   => 'marvari',
    'my'    => 'birma',
    'myn'   => "maia\ keeled",
    'myv'   => 'ersa',
    'na'    => 'nauru',
    'nah'   => 'nahua',
    'nai'   => "Põhja\-Ameerika\ indiaani\ keel",
    'nap'   => 'napoli',
    'nb'    => "norra\ bokmål",
    'nd'    => 'põhjandebele',
    'nds'   => 'alamsaksa',
    'ne'    => 'nepali',
    'new'   => 'nevari',
    'ng'    => 'ndonga',
    'nia'   => 'niasi',
    'nic'   => "Nigeri\-Kordofani\ keel",
    'niu'   => 'niue',
    'nl'    => 'hollandi',
    'nl_be' => 'Flemish',
    'nn'    => "norra\ nynorsk",
    'no'    => 'norra',
    'nog'   => 'nogai',
    'non'   => 'vanapõhjala',
    'nqo'   => 'nkoo',
    'nr'    => 'lõunandebele',
    'nso'   => 'pedi',
    'nub'   => "nuubia\ keel",
    'nv'    => 'navaho',
    'nwc'   => 'vananevari',
    'ny'    => 'njandža',
    'nym'   => 'njamvesi',
    'nyn'   => 'nkole',
    'nyo'   => 'njoro',
    'nzi'   => 'nzima',
    'oc'    => 'oksitaani',
    'oj'    => 'odžibvei',
    'om'    => 'oromo',
    'or'    => 'oria',
    'os'    => 'osseedi',
    'osa'   => 'oseidži',
    'ota'   => 'osmanitürgi',
    'oto'   => "otomi\ keel",
    'pa'    => 'pandžabi',
    'paa'   => "paapua\ keel",
    'pag'   => 'pangasinani',
    'pal'   => 'pahlavi',
    'pam'   => 'pampanga',
    'pap'   => 'papiamento',
    'pau'   => 'belau',
    'peo'   => 'vanapärsia',
    'phi'   => "flipiini\ keel",
    'phn'   => 'foiniikia',
    'pi'    => 'paali',
    'pl'    => 'poola',
    'pon'   => 'poonpei',
    'pra'   => "praakriti\ keel",
    'pro'   => 'vanaprovansi',
    'ps'    => 'puštu',
    'pt'    => 'portugali',
    'pt_br' => "Brazilian\ Portuguese",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'ketšua',
    'raj'   => 'radžastani',
    'rap'   => 'rapanui',
    'rar'   => 'rarotonga',
    'rm'    => 'retoromaani',
    'rn'    => 'rundi',
    'ro'    => 'rumeenia',
    'roa'   => "romaani\ keel",
    'rom'   => 'mustlaskeel',
    'ru'    => 'vene',
    'rup'   => 'aromuuni',
    'rw'    => 'ruanda',
    'sa'    => 'sanskriti',
    'sad'   => 'sandave',
    'sah'   => 'jakuudi',
    'sai'   => "Lõuna\-Ameerika\ indiaani\ keel",
    'sal'   => "sališi\ keel",
    'sam'   => "samaaria\ aramea",
    'sas'   => 'sasaki',
    'sat'   => 'santali',
    'sc'    => 'sardiinia',
    'scn'   => 'sitsiilia',
    'sco'   => 'šoti',
    'sd'    => 'sindhi',
    'se'    => 'põhjasaami',
    'sel'   => 'sölkupi',
    'sem'   => "semi\ keel",
    'sg'    => 'sango',
    'sga'   => 'vanaiiri',
    'sgn'   => 'viipekeel',
    'sh'    => "serbia\-horvaadi",
    'shn'   => 'šani',
    'si'    => 'singali',
    'sid'   => 'sidamo',
    'sio'   => "siuu\ keel",
    'sit'   => "hiina\-tiibeti\ keel",
    'sk'    => 'slovaki',
    'sl'    => 'sloveeni',
    'sla'   => "slaavi\ keel",
    'sm'    => 'samoa',
    'sma'   => 'lõunasaami',
    'smi'   => "muu\ saami",
    'smj'   => "Lule\ saami",
    'smn'   => "Inari\ saami",
    'sms'   => 'koltasaami',
    'sn'    => 'šona',
    'snk'   => 'soninke',
    'so'    => 'somaali',
    'sog'   => 'sogdi',
    'son'   => 'songai',
    'sq'    => 'albaania',
    'sr'    => 'serbia',
    'srn'   => 'sranani',
    'srr'   => 'sereri',
    'ss'    => 'svaasi',
    'ssa'   => "Niiluse\-Sahara\ keel",
    'st'    => 'lõunasotho',
    'su'    => 'sunda',
    'suk'   => 'sukuma',
    'sus'   => 'susu',
    'sux'   => 'sumeri',
    'sv'    => 'rootsi',
    'sw'    => 'suahiili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'süüria',
    'ta'    => 'tamili',
    'tai'   => "tai\ keel",
    'te'    => 'telugu',
    'tem'   => 'temne',
    'ter'   => 'tereno',
    'tet'   => 'tetumi',
    'tg'    => 'tadžiki',
    'th'    => 'tai',
    'ti'    => 'tigrinja',
    'tig'   => 'tigree',
    'tiv'   => 'tivi',
    'tk'    => 'türkmeeni',
    'tkl'   => 'tokelau',
    'tl'    => 'tagalogi',
    'tlh'   => 'klingoni',
    'tli'   => 'tlingiti',
    'tmh'   => 'tamašeki',
    'tn'    => 'tsvana',
    'to'    => 'tonga',
    'tog'   => 'tšitonga',
    'tpi'   => 'uusmelaneesia',
    'tr'    => 'türgi',
    'trv'   => 'Taroko',
    'ts'    => 'tsonga',
    'tsi'   => 'tšimši',
    'tt'    => 'tatari',
    'tum'   => 'tumbuka',
    'tup'   => "tupii\ keeled",
    'tut'   => "altai\ keel",
    'tvl'   => 'tuvalu',
    'tw'    => 'tvii',
    'ty'    => 'tahiti',
    'tyv'   => 'tõva',
    'udm'   => 'udmurdi',
    'ug'    => 'uiguuri',
    'uga'   => 'ugariti',
    'uk'    => 'ukraina',
    'umb'   => 'umbundu',
    'und'   => 'määramata',
    'ur'    => 'urdu',
    'uz'    => 'usbeki',
    'vai'   => 'vai',
    've'    => 'venda',
    'vi'    => 'vietnami',
    'vo'    => 'volapüki',
    'vot'   => 'vadja',
    'wa'    => 'vallooni',
    'wak'   => "vakaši\ keel",
    'wal'   => 'volamo',
    'war'   => 'varai',
    'was'   => 'vašo',
    'wen'   => "sorbi\ keel",
    'wo'    => 'volofi',
    'xal'   => 'kalmõki',
    'xh'    => 'koosa',
    'yao'   => 'jao',
    'yap'   => 'japi',
    'yi'    => 'jidiši',
    'yo'    => 'joruba',
    'ypk'   => "jupiki\ keel",
    'za'    => 'tšuangi',
    'zap'   => 'sapoteegi',
    'zbl'   => 'Blissymbols',
    'zen'   => 'zenaga',
    'zh'    => 'hiina',
    'znd'   => 'zande',
    'zu'    => 'suulu',
    'zun'   => 'sunji',
    'zxx'   => 'mittekeeleline',
    'zza'   => 'Zaza',
);

%Locales::DB::Language::et::name_to_code = (
    'abhaasi'                             => 'ab',
    'adangme'                             => 'ada',
    'adgee'                               => 'ady',
    'afari'                               => 'aa',
    'afrihili'                            => 'afh',
    'afrikaani'                           => 'af',
    'aieeni'                              => 'chy',
    'aimara'                              => 'ay',
    'ainu'                                => 'ain',
    'akadi'                               => 'akk',
    'akani'                               => 'ak',
    'akoli'                               => 'ach',
    'alamsaksa'                           => 'nds',
    'alamsorbi'                           => 'dsb',
    'albaania'                            => 'sq',
    'alemanni'                            => 'gsw',
    'aleuudi'                             => 'ale',
    "algonkini\ keel"                     => 'alg',
    'altai'                               => 'alt',
    "altai\ keel"                         => 'tut',
    'ambo'                                => 'kj',
    'amhari'                              => 'am',
    'angika'                              => 'anp',
    'ani'                                 => 'shn',
    "apati\ keel"                         => 'apa',
    'araabia'                             => 'ar',
    'aragoni'                             => 'an',
    'aramea'                              => 'arc',
    'arapaho'                             => 'arp',
    'araukaani'                           => 'arn',
    'aravaki'                             => 'arw',
    'armeenia'                            => 'hy',
    'aromuuni'                            => 'rup',
    'aserbaidaani'                        => 'az',
    'assami'                              => 'as',
    'astuuria'                            => 'ast',
    "atapaski\ keeled"                    => 'ath',
    'atehi'                               => 'ace',
    'atsam'                               => 'cch',
    "austraali\ keel"                     => 'aus',
    "australian\ english"                 => 'en_au',
    "austrian\ german"                    => 'de_at',
    "austroneesia\ keel"                  => 'map',
    'avaari'                              => 'av',
    'avadhi'                              => 'awa',
    'avesta'                              => 'ae',
    'bakiiri'                             => 'ba',
    'bali'                                => 'ban',
    "balti\ keel"                         => 'bat',
    'bambara'                             => 'bm',
    "bamileke\ keel"                      => 'bai',
    'banda'                               => 'bad',
    'bantu'                               => 'bnt',
    'basa'                                => 'bas',
    'baski'                               => 'eu',
    'bataki'                              => 'btk',
    'beda'                                => 'bej',
    'belau'                               => 'pau',
    'beluti'                              => 'bal',
    'bemba'                               => 'bem',
    'bengali'                             => 'bn',
    'berberi'                             => 'ber',
    'bhodpuri'                            => 'bho',
    'bhutani'                             => 'dz',
    'bidayuhkeel'                         => 'day',
    'bihaari'                             => 'bh',
    'bikoli'                              => 'bik',
    'bilini'                              => 'byn',
    'birma'                               => 'my',
    'bislama'                             => 'bi',
    'blissymbols'                         => 'zbl',
    'bosnia'                              => 'bs',
    'bradi'                               => 'bra',
    "brazilian\ portuguese"               => 'pt_br',
    'bretooni'                            => 'br',
    "british\ english"                    => 'en_gb',
    'bugi'                                => 'bug',
    'bulgaaria'                           => 'bg',
    'burjaadi'                            => 'bua',
    "canadian\ english"                   => 'en_ca',
    "canadian\ french"                    => 'fr_ca',
    "classical\ syriac"                   => 'syc',
    'dargi'                               => 'dar',
    'delavari'                            => 'del',
    'dinka'                               => 'din',
    'djula'                               => 'dyu',
    'dogri'                               => 'doi',
    'dogribi'                             => 'dgr',
    "draviidi\ keel"                      => 'dra',
    'duala'                               => 'dua',
    'edo'                                 => 'bin',
    'eelami'                              => 'elx',
    'eesti'                               => 'et',
    'ekaduki'                             => 'eka',
    'ersa'                                => 'myv',
    'esperanto'                           => 'eo',
    'etioopia'                            => 'gez',
    'eve'                                 => 'ee',
    'evondo'                              => 'ewo',
    'fangi'                               => 'fan',
    'fanti'                               => 'fat',
    'fidi'                                => 'fj',
    'filipino'                            => 'fil',
    'flemish'                             => 'nl_be',
    "flipiini\ keel"                      => 'phi',
    'foiniikia'                           => 'phn',
    'foni'                                => 'fon',
    'fri'                                 => 'fo',
    'friuuli'                             => 'fur',
    'fulbe'                               => 'ff',
    'gaa'                                 => 'gaa',
    'gaeli'                               => 'gd',
    'gajo'                                => 'gay',
    'galeegi'                             => 'gl',
    'ganda'                               => 'lg',
    'gbaja'                               => 'gba',
    "germaani\ keel"                      => 'gem',
    'gondi'                               => 'gon',
    'gooti'                               => 'got',
    'gorontalo'                           => 'gor',
    'grebo'                               => 'grb',
    'grni'                                => 'kl',
    'gruusia'                             => 'ka',
    'guaranii'                            => 'gn',
    'gudarati'                            => 'gu',
    'gvitini'                             => 'gwi',
    'haida'                               => 'hai',
    'haiti'                               => 'ht',
    'hausa'                               => 'ha',
    'havai'                               => 'haw',
    'heebrea'                             => 'he',
    'herero'                              => 'hz',
    'heti'                                => 'hit',
    'hiina'                               => 'zh',
    "hiinatiibeti\ keel"                  => 'sit',
    'hiligainoni'                         => 'hil',
    'himtali'                             => 'him',
    'hindi'                               => 'hi',
    'hispaania'                           => 'es',
    'hmongi'                              => 'hmn',
    'hollandi'                            => 'nl',
    'horvaadi'                            => 'hr',
    'hupa'                                => 'hup',
    'ibani'                               => 'iba',
    "iberian\ portuguese"                 => 'pt_pt',
    "iberian\ spanish"                    => 'es_es',
    'ibibio'                              => 'efi',
    'ibo'                                 => 'ig',
    'idafriisi'                           => 'frs',
    'ido'                                 => 'io',
    'iiri'                                => 'ga',
    'iloko'                               => 'ilo',
    "inari\ saami"                        => 'smn',
    "india\ keel"                         => 'inc',
    "indoeuroopa\ keel"                   => 'ine',
    'indoneesia'                          => 'id',
    'inglise'                             => 'en',
    "inglise\ usa"                        => 'en_us',
    "inglisphjalised\ kreoolpidinkeel"    => 'cpe',
    'ingui'                               => 'inh',
    'injupiaki'                           => 'ik',
    'interlingua'                         => 'ia',
    'interlingue'                         => 'ie',
    'inuktituti'                          => 'iu',
    "irokeesi\ keel"                      => 'iro',
    'islandi'                             => 'is',
    'itaalia'                             => 'it',
    'jaapani'                             => 'ja',
    'jaava'                               => 'jv',
    'jakuudi'                             => 'sah',
    'jao'                                 => 'yao',
    'japi'                                => 'yap',
    'jidii'                               => 'yi',
    'jju'                                 => 'kaj',
    'joruba'                              => 'yo',
    "jupiki\ keel"                        => 'ypk',
    'juudiaraabia'                        => 'jrb',
    'juudiprsia'                          => 'jpr',
    'kaavi'                               => 'kaw',
    'kabarditerkessi'                     => 'kbd',
    'kabiili'                             => 'kab',
    'kado'                                => 'cad',
    'kalmki'                              => 'xal',
    'kamba'                               => 'kam',
    'kamiiri'                             => 'ks',
    'kannada'                             => 'kn',
    'kanuri'                              => 'kr',
    'karakalpaki'                         => 'kaa',
    'karataibalkaari'                     => 'krc',
    "kareni\ keel"                        => 'kar',
    'kariibi'                             => 'car',
    'karjala'                             => 'krl',
    'kasahhi'                             => 'kk',
    'katalaani'                           => 'ca',
    'katini'                              => 'kac',
    "kaukaasia\ keel"                     => 'cau',
    'kauubi'                              => 'csb',
    "keldi\ keel"                         => 'cel',
    "keskameerika\ indiaani\ keel"        => 'cai',
    'keskhollandi'                        => 'dum',
    'keskiiri'                            => 'mga',
    'keskinglise'                         => 'enm',
    'kesklemsaksa'                        => 'gmh',
    'keskprantsuse'                       => 'frm',
    'ketua'                               => 'qu',
    'khasi'                               => 'kha',
    'khmeeri'                             => 'km',
    "khoisani\ keel"                      => 'khi',
    'kikuju'                              => 'ki',
    'kirgiisi'                            => 'ky',
    'kiribati'                            => 'gil',
    'kirikuslaavi'                        => 'cu',
    'klingoni'                            => 'tlh',
    'kmri'                                => 'cy',
    'koltasaami'                          => 'sms',
    'komi'                                => 'kv',
    'kongo'                               => 'kg',
    'konkani'                             => 'kok',
    'koosa'                               => 'xh',
    'kopti'                               => 'cop',
    'korea'                               => 'ko',
    'korni'                               => 'kw',
    'koro'                                => 'kfo',
    'korsika'                             => 'co',
    'kosrae'                              => 'kos',
    'kpelle'                              => 'kpe',
    'kreeka'                              => 'el',
    'kreoolpidinkeel'                     => 'crp',
    'krii'                                => 'cr',
    'krimmitatari'                        => 'crh',
    'kruu'                                => 'kro',
    'ksikkeeled'                          => 'mis',
    'kumki'                               => 'kum',
    'kurdi'                               => 'ku',
    'kutenai'                             => 'kut',
    'ladiino'                             => 'lad',
    'ladina'                              => 'la',
    'lahnda'                              => 'lah',
    'lamba'                               => 'lam',
    'lao'                                 => 'lo',
    'leedu'                               => 'lt',
    'lemsorbi'                            => 'hsb',
    'lesgi'                               => 'lez',
    'letseburgi'                          => 'lb',
    'limburgi'                            => 'li',
    'lingala'                             => 'ln',
    'lnefriisi'                           => 'fy',
    'lojbani'                             => 'jbo',
    'lozi'                                => 'loz',
    'lti'                                 => 'lv',
    'luba'                                => 'lu',
    'luei'                                => 'lus',
    'luisenjo'                            => 'lui',
    "lule\ saami"                         => 'smj',
    'lulua'                               => 'lua',
    "lunaameerika\ indiaani\ keel"        => 'sai',
    'lunandebele'                         => 'nr',
    'lunasaami'                           => 'sma',
    'lunasotho'                           => 'st',
    'lunda'                               => 'lun',
    'luo'                                 => 'luo',
    'madura'                              => 'mad',
    'magali'                              => 'mag',
    "maia\ keeled"                        => 'myn',
    'maithili'                            => 'mai',
    'makassari'                           => 'mak',
    'makedoonia'                          => 'mk',
    'malagassi'                           => 'mg',
    'malai'                               => 'ms',
    'malajalami'                          => 'ml',
    'maldiivi'                            => 'dv',
    'malinke'                             => 'man',
    'malta'                               => 'mt',
    'mandari'                             => 'mdr',
    'mandu'                               => 'mnc',
    'manipuri'                            => 'mni',
    "manobo\ keel"                        => 'mno',
    'maoori'                              => 'mi',
    'maralli'                             => 'mh',
    'marathi'                             => 'mr',
    'mari'                                => 'chm',
    'marvari'                             => 'mwr',
    'masai'                               => 'mas',
    'maskogi'                             => 'mus',
    'mbundu'                              => 'kmb',
    'mende'                               => 'men',
    'mikmaki'                             => 'mic',
    'minangkabau'                         => 'min',
    'miranda'                             => 'mwl',
    'mittekeeleline'                      => 'zxx',
    "mitu\ keelt"                         => 'mul',
    'mnksi'                               => 'gv',
    'mohoogi'                             => 'moh',
    'moka'                                => 'mdf',
    'moldova'                             => 'mo',
    'mongo'                               => 'lol',
    'mongoli'                             => 'mn',
    "monikhmeeri\ keel"                   => 'mkh',
    'more'                                => 'mos',
    'morisyen'                            => 'mfe',
    'motu'                                => 'ho',
    'mramata'                             => 'und',
    'muinasegiptuse'                      => 'egy',
    "munda\ keel"                         => 'mun',
    'mustlaskeel'                         => 'rom',
    "muu\ afroaasia"                      => 'afa',
    "muu\ iraani"                         => 'ira',
    "muu\ kui\ keel"                      => 'cus',
    "muu\ saami"                          => 'smi',
    "muu\ tehiskeel"                      => 'art',
    'nahua'                               => 'nah',
    'napoli'                              => 'nap',
    'nauru'                               => 'na',
    'navaho'                              => 'nv',
    'ndonga'                              => 'ng',
    'nepali'                              => 'ne',
    'nevari'                              => 'new',
    'niasi'                               => 'nia',
    "nigerikordofani\ keel"               => 'nic',
    "niilusesahara\ keel"                 => 'ssa',
    'niue'                                => 'niu',
    'njamvesi'                            => 'nym',
    'njanda'                              => 'ny',
    'njoro'                               => 'nyo',
    'nkole'                               => 'nyn',
    'nkoo'                                => 'nqo',
    'nogai'                               => 'nog',
    'norra'                               => 'no',
    "norra\ bokml"                        => 'nb',
    "norra\ nynorsk"                      => 'nn',
    "nuubia\ keel"                        => 'nub',
    'nzima'                               => 'nzi',
    'odibvei'                             => 'oj',
    'oksitaani'                           => 'oc',
    'ona'                                 => 'sn',
    'oraoni'                              => 'kru',
    'oria'                                => 'or',
    'oromo'                               => 'om',
    'oseidi'                              => 'osa',
    'osmanitrgi'                          => 'ota',
    'osseedi'                             => 'os',
    'oti'                                 => 'sco',
    "otomi\ keel"                         => 'oto',
    'paali'                               => 'pi',
    "paapua\ keel"                        => 'paa',
    'pahlavi'                             => 'pal',
    'pampanga'                            => 'pam',
    'pandabi'                             => 'pa',
    'pangasinani'                         => 'pag',
    'papiamento'                          => 'pap',
    'pedi'                                => 'nso',
    "phjaameerika\ indiaani\ keel"        => 'nai',
    'phjafriisi'                          => 'frr',
    'phjandebele'                         => 'nd',
    'phjasaami'                           => 'se',
    'poola'                               => 'pl',
    'poonpei'                             => 'pon',
    'portugali'                           => 'pt',
    "portugaliphjalised\ kreoolpidinkeel" => 'cpp',
    "praakriti\ keel"                     => 'pra',
    'prantsuse'                           => 'fr',
    "prantsusphjalised\ kreoolpidinkeel"  => 'cpf',
    'prsia'                               => 'fa',
    'putu'                                => 'ps',
    'radastani'                           => 'raj',
    'rapanui'                             => 'rap',
    'rarotonga'                           => 'rar',
    'retoromaani'                         => 'rm',
    "romaani\ keel"                       => 'roa',
    'rootsi'                              => 'sv',
    'ruanda'                              => 'rw',
    'rumeenia'                            => 'ro',
    'rundi'                               => 'rn',
    'saki'                                => 'kho',
    'saksa'                               => 'de',
    "salii\ keel"                         => 'sal',
    "samaaria\ aramea"                    => 'sam',
    'samoa'                               => 'sm',
    'sandave'                             => 'sad',
    'sango'                               => 'sg',
    'sanskriti'                           => 'sa',
    'santali'                             => 'sat',
    'sapoteegi'                           => 'zap',
    'sardiinia'                           => 'sc',
    'sasaki'                              => 'sas',
    'sebu'                                => 'ceb',
    "semi\ keel"                          => 'sem',
    'serbia'                              => 'sr',
    'serbiahorvaadi'                      => 'sh',
    'sereri'                              => 'srr',
    "sichuani\ jii"                       => 'ii',
    'sidamo'                              => 'sid',
    'siksika'                             => 'bla',
    'sindhi'                              => 'sd',
    'singali'                             => 'si',
    'sitsiilia'                           => 'scn',
    'siuu'                                => 'dak',
    "siuu\ keel"                          => 'sio',
    "slaavi\ keel"                        => 'sla',
    'sleivi'                              => 'den',
    'slkupi'                              => 'sel',
    'slovaki'                             => 'sk',
    'sloveeni'                            => 'sl',
    'sogdi'                               => 'sog',
    'somaali'                             => 'so',
    'songai'                              => 'son',
    'soninke'                             => 'snk',
    'soome'                               => 'fi',
    "soomeugri\ keel"                     => 'fiu',
    "sorbi\ keel"                         => 'wen',
    'sranani'                             => 'srn',
    'sria'                                => 'syr',
    'suahiili'                            => 'sw',
    'sukuma'                              => 'suk',
    'sumeri'                              => 'sux',
    'sunda'                               => 'su',
    'sunji'                               => 'zun',
    'susu'                                => 'sus',
    'suulu'                               => 'zu',
    'svaasi'                              => 'ss',
    "swiss\ french"                       => 'fr_ch',
    "swiss\ high\ german"                 => 'de_ch',
    'taani'                               => 'da',
    'tadiki'                              => 'tg',
    'tagalogi'                            => 'tl',
    'tagatai'                             => 'chg',
    'tahiti'                              => 'ty',
    'tai'                                 => 'th',
    "tai\ keel"                           => 'tai',
    'tamaeki'                             => 'tmh',
    "tami\ keeled"                        => 'cmc',
    'tamili'                              => 'ta',
    'tamorro'                             => 'ch',
    'taroko'                              => 'trv',
    'tatari'                              => 'tt',
    'tehhi'                               => 'cs',
    'telugu'                              => 'te',
    'temne'                               => 'tem',
    'tereno'                              => 'ter',
    'terokii'                             => 'chr',
    'teteeni'                             => 'ce',
    'tetumi'                              => 'tet',
    'tibta'                               => 'chb',
    'tigree'                              => 'tig',
    'tigrinja'                            => 'ti',
    'tiibeti'                             => 'bo',
    'timi'                                => 'tsi',
    "tinuki\ argoon"                      => 'chn',
    'tipevai'                             => 'chp',
    'titonga'                             => 'tog',
    'tivi'                                => 'tiv',
    'tlingiti'                            => 'tli',
    'tokelau'                             => 'tkl',
    'tokto'                               => 'cho',
    'tonga'                               => 'to',
    'trgi'                                => 'tr',
    'trkmeeni'                            => 'tk',
    'tsonga'                              => 'ts',
    'tsvana'                              => 'tn',
    'tuangi'                              => 'za',
    'tumbuka'                             => 'tum',
    "tupii\ keeled"                       => 'tup',
    'tuugi'                               => 'chk',
    'tuvai'                               => 'cv',
    'tuvalu'                              => 'tvl',
    'tva'                                 => 'tyv',
    'tvii'                                => 'tw',
    'tyap'                                => 'kcg',
    'udmurdi'                             => 'udm',
    'ugariti'                             => 'uga',
    'uiguuri'                             => 'ug',
    'ukraina'                             => 'uk',
    'umbundu'                             => 'umb',
    'ungari'                              => 'hu',
    'urdu'                                => 'ur',
    'usbeki'                              => 'uz',
    'uusmelaneesia'                       => 'tpi',
    'vadja'                               => 'vot',
    'vai'                                 => 'vai',
    "vakai\ keel"                         => 'wak',
    'valgevene'                           => 'be',
    'vallooni'                            => 'wa',
    'vanaiiri'                            => 'sga',
    'vanainglise'                         => 'ang',
    'vanakreeka'                          => 'grc',
    'vanalemsaksa'                        => 'goh',
    'vananevari'                          => 'nwc',
    'vanaphjala'                          => 'non',
    'vanaprantsuse'                       => 'fro',
    'vanaprovansi'                        => 'pro',
    'vanaprsia'                           => 'peo',
    'vao'                                 => 'was',
    'varai'                               => 'war',
    'venda'                               => 've',
    'vene'                                => 'ru',
    'vietnami'                            => 'vi',
    'viipekeel'                           => 'sgn',
    'volamo'                              => 'wal',
    'volapki'                             => 'vo',
    'volofi'                              => 'wo',
    'zande'                               => 'znd',
    'zaza'                                => 'zza',
    'zenaga'                              => 'zen',
);

1;
