
BEGIN {
  unless ($ENV{AUTHOR_TESTING}) {
    print qq{1..0 # SKIP these tests are for testing by the author\n};
    exit
  }
}

use strict;
use warnings;

# this test was generated with Dist::Zilla::Plugin::Test::EOL 0.19

use Test::More 0.88;
use Test::EOL;

my @files = (
    'lib/Net/DHCP.pm',
    'lib/Net/DHCP/Constants.pm',
    'lib/Net/DHCP/Packet.pm',
    'lib/Net/DHCP/Packet/Attributes.pm',
    'lib/Net/DHCP/Packet/IPv4Utils.pm',
    'lib/Net/DHCP/Packet/OrderOptions.pm',
    't/000-load.t',
    't/003-manifest.t',
    't/021-net-dhcp-packet-packinet.t',
    't/022-net-dhcp-packet-options.t',
    't/030-net-dhcp-constants-coverage.t',
    't/051-net-dhcp-packet-new-basic.t',
    't/052-net-dhcp-packet-new-empty.t',
    't/053-net-dhcp-packet-new-broken.t',
    't/102-discover-offer-request-ack.t',
    't/103-real-nak.t',
    't/104-offer-o90-o120.t',
    't/105-discover-offer-o122-o82.t',
    't/106-discover-offer-o60-o43-o82.t',
    't/107-query-active-qry-unass-qry-unk.t',
    't/author-critic.t',
    't/author-distmeta.t',
    't/author-eof.t',
    't/author-eol.t',
    't/author-no-breakpoints.t',
    't/author-pod-coverage.t',
    't/author-pod-syntax.t',
    't/author-portability.t',
    't/data/DHCP-DISCOVER-OFFER-REQUEST-ACK.cap',
    't/data/DHCP-NAK-SMALL.cap',
    't/data/DHCP-O122-O82.cap',
    't/data/DHCP-O60-O43-O82.cap',
    't/data/DHCP-O90-O120.cap',
    't/data/DHCP_Inter_VLAN.cap',
    't/data/DHCP_MessageType_10_11_12_13.cap',
    't/release-kwalitee.t',
    't/release-unused-vars.t'
);

eol_unix_ok($_, { trailing_whitespace => 1 }) foreach @files;
done_testing;
