#! perl

use Test2::V0;
use Test::Lib;

package main::form {
    use Types::Standard 'Str', 'Bool';
    use Form::Tiny plugins => ['+CXC::Form::Tiny::Plugin::OptArgs2'];

    form_field foo => ( type => Str, default => sub { 'FOO' } );
    option( comment => 'Foo' );

    form_field bar => ( type => Str, default => sub { 'BAR' }  );
    option( comment => 'Bar');

    form_field baz => ( type => Str, default => sub { 'BAZ' } );
    option( comment => 'Baz' );

    form_field config => ( type => Bool );
    option( comment => 'Config' );
}

use aliased 'CXC::Form::Tiny::OptArgs2';
local @ARGV = ( '--foo' => 'foo', '--config' );
my $obj = OptArgs2->new(
    config_option => 'config',
    read_config   => sub {
       { command => { bar => 'bar' } };
    }
);
my $optargs = $obj->optargs( { validate => 1 } , comment => 'this is a thing' );

is(
    $optargs,
    hash {
        field foo    => 'foo';
        field bar    => 'bar';
        field baz    => 'BAZ';
        field config => T();
        end;
    }
);


done_testing;

