#!/usr/bin/env perl
use strict;
use warnings;
use lib 'lib';
use Test::More;
use Catan::Game::Bank;

ok my $bank = Catan::Game::Bank->new, 'constructor';
ok my @deck = @{$bank->deck}, 'get the deck';
ok my $code = $bank->deck_draw, 'draw a card';
cmp_ok @{$bank->deck}, '==', @deck - 1, 'the deck size has reduced by 1 card'; 
cmp_ok keys %{$bank->{resources}}, '==', 5, 'the bank has 5 resource types';

done_testing;
