#!perl -T

use strict;
use warnings;
use Test::More tests => 23;
use Archive::Har();
use JSON();

my $har = Archive::Har->new();

my $checking = <<'_CHECK_';
{
  "log": {
   }
}
_CHECK_
$har->string($checking);
my $hash = JSON::decode_json($har->string());
ok($hash, "Successfully read empty har archive");
ok($hash->{log}->{version}, "version is defined for har archive:$hash->{log}->{version}");
ok((defined $hash->{log}->{creator} and ref $hash->{log}->{creator} eq 'HASH' and $hash->{log}->{creator}->{name} && $hash->{log}->{creator}->{version}), "creator is defined as a HASH");
ok(!defined $hash->{log}->{browser}, "browser is not defined");
foreach my $field (qw(pages entries)) {
	ok((defined $hash->{log}->{$field} and (ref $hash->{log}->{$field} eq 'ARRAY') and (@{$hash->{log}->{$field}} == 0)), "$field is defined as an empty ARRAY");
}
$checking = <<'_CHECK_';
{
  "log": {
	"pages": [ {} ]
   }
}
_CHECK_
$har->string($checking);
$hash = JSON::decode_json($har->string());
ok($hash, "Successfully read empty page element in har archive");
ok($hash->{log}->{pages}->[0]->{startedDateTime} =~ /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d+\+\d{2}:\d{2}$/smx, "page->startedDateTime is defined as a datetime:$hash->{log}->{pages}->[0]->{startedDateTime}");
ok($hash->{log}->{pages}->[0]->{id} eq 'page_0', "page->id is defined as page_0:$hash->{log}->{pages}->[0]->{id}");
ok(length $hash->{log}->{pages}->[0]->{title}, "page->title is defined:$hash->{log}->{pages}->[0]->{title}");
ok((defined $hash->{log}->{pages}->[0]->{pageTimings} and ref $hash->{log}->{pages}->[0]->{pageTimings} eq 'HASH'), "page->pageTimings is defined as a HASH");

# entries

$checking = <<'_CHECK_';
{
  "log": {
	"entries": [ {} ]
   }
}
_CHECK_

$har->string($checking);
$hash = JSON::decode_json($har->string());
ok($hash, "Successfully read empty entry element in har archive");
ok($hash->{log}->{entries}->[0]->{startedDateTime} =~ /^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}\.\d+\+\d{2}:\d{2}$/smx, "entry->startedDateTime is defined as a datetime:$hash->{log}->{entries}->[0]->{startedDateTime}");
foreach my $name (qw(request response cache timings)) {
	ok((defined $hash->{log}->{entries}->[0]->{$name} and ref $hash->{log}->{entries}->[0]->{$name} eq 'HASH'), "page->$name is defined as a HASH");
}
ok($hash->{log}->{entries}->[0]->{time} =~ /^\-?\d+$/smx, "entry->time is defined as a number:$hash->{log}->{entries}->[0]->{time}");

# request

ok(($hash->{log}->{entries}->[0]->{request}->{method} eq 'GET'), "request->method is GET by default");
ok(($hash->{log}->{entries}->[0]->{request}->{url} eq 'http://example.com/'), "request->url is http://example.com/ by default");
ok(($hash->{log}->{entries}->[0]->{request}->{httpVersion} eq 'HTTP/0.9'), "request->httpVersion is HTTP/0.9 by default");
ok(($hash->{log}->{entries}->[0]->{request}->{headersSize} == -1), "request->headersSize is -1 by default");
ok(($hash->{log}->{entries}->[0]->{request}->{bodySize} == -1), "request->bodySize is -1 by default");
