# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::KZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154352;

my $formatters = [];

my $validators = {
                'fixed_line' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'mobile' => '
          7(?:
            0[0-25-8]|
            47|
            6[0-4]|
            7[15-8]|
            85
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(809\\d{7})',
                'toll_free' => '
          8(?:
            00|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => '751\\d{7}'
              };
my %areanames = ();
$areanames{ru} = {"771230", "Атырауская\ область",
"771043", "Жайрем\ \(поселок\)",
"7491", "Рязанская\ обл\.",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"77224", "Эмельтау",
"772836", "Ескельдинский\ р\-н",
"771149", "Акжаикский\ р\-н",
"771642", "Егиндыкольский\ р\-н",
"771435", "Житикаринский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"772643", "Шуский\ р\-н",
"772545", "Икан",
"772631", "Турара\ Рыскулова\ р\-н",
"772144", "Нуринский\ р\-н",
"772548", "Шаян",
"771840", "Баянаульский\ р\-н",
"77279", "Алматы",
"77112", "Уральск",
"771031", "Шетский\ р\-н",
"7474", "Липецкая\ обл\.",
"7416", "Амурская\ обл\.",
"772771", "Карасайский\ р\-н",
"771348", "Шалкарский\ р\-н",
"771455", "Костанайский\ р\-н",
"771458", "Костанайская\ область",
"771345", "Байганинский\ р\-н",
"7815", "Мурманская\ обл\.",
"772436", "Сырдарьинский\ р\-н",
"77245", "Кызылординская\ область",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771838", "Майский\ р\-он",
"772530", "Темирлановка",
"771330", "Хромтауский\ р\-н",
"771649", "Жаксынский\ р\-н",
"771142", "Акжаикский\ р\-н",
"772757", "Акший",
"7341", "Республика\ Удмуртская",
"772147", "Каркаралинский\ р\-н",
"7496", "г\.\ Москва",
"7411", "Республика\ Саха\ \/Якутия\/",
"77162", "Кокшетау",
"772131", "Абайский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"772644", "Таласский\ р\-н",
"771546", "Акжарский\ р\-н",
"7394", "Республика\ Тыва",
"771440", "Амангельдинский\ р\-н",
"7342", "Пермский\ край",
"7493", "Ивановская\ обл\.",
"772251", "Курчатов",
"771349", "Шалкарский\ р\-н",
"772841", "Аксуский\ р\-н",
"771459", "Костанайская\ область",
"771630", "Боровое",
"77272956", "Талгар",
"772344", "Тарбагатайский\ р\-н",
"772937", "Каракиянский\ р\-н",
"771832", "Иртышский\ р\-н",
"772833", "Алакольский\ р\-н",
"772837", "Алакольский\ р\-н",
"77132", "Актобе\/Актюбинск",
"77252", "Шымкент",
"771439", "Джангильдинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"771544", "Жамбылский\ р\-н",
"771547", "Жамбылский\ р\-н",
"772542", "Асыката",
"771543", "Есильский\ р\-н",
"772351", "Бородулихинский\ р\-н",
"7492", "Владимирская\ обл\.",
"771452", "Карасуский\ р\-н",
"772343", "Курчумский\ р\-н",
"771130", "Зеленовский\ р\-н",
"771342", "Каргалинский\ р\-н",
"7865", "Ставропольский\ край",
"772834", "Каратальский\ р\-н",
"740", "Калининградская\ обл\.",
"7343", "Свердловская\ обл",
"7821", "Республика\ Коми",
"772934", "Жанаозен",
"772347", "Жарминский\ р\-н",
"7413", "Магаданская\ обл\.",
"7485", "Ярославская\ обл\.",
"772146", "Каркаралинск",
"77273", "Алма\-Ата",
"772331", "Глубоковский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"771645", "Степногорск",
"772433", "Аральский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"77122", "Атырау",
"772437", "Кармакшинский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"77232", "Усть\-Каменогорск",
"771837", "Аксуский\ р\-н",
"77149", "Костанай",
"772832", "Аксуский\ р\-н",
"7482", "Тверская\ обл\.",
"771646", "Буландинский\ р\-н",
"771833", "Качирский\ р\-н",
"771454", "Наурзумский\ р\-н",
"772148", "Осакаровский\ р\-н",
"772544", "Шаульдер",
"772439", "Аральский\ р\-н",
"771231", "Исатайский\ р\-н",
"77152", "Петропавловск",
"772770", "Жамбылский\ р\-н",
"77145834", "Красногорск",
"7495", "Московская\ обл\.",
"7844", "Волгоградская\ обл\.",
"771434", "Денисовский\ р\-н",
"7820", "Вологодская\ обл\.",
"771841", "Актогайский\ р\-н",
"7836", "Республика\ Марий\ Эл",
"771030", "Жана\-Аркинский\ р\-н",
"7351", "Челябинская\ обл\.",
"7816", "Новгородская\ обл\.",
"7862", "Краснодарский\ край",
"772839", "Саркандский\ р\-н",
"771331", "Мартукский\ р\-н",
"771146", "Акжаикский\ р\-н",
"7423", "Приморский\ край",
"771437", "Камыстинский\ р\-н",
"7415", "Камчатский\ край",
"7483", "Брянская\ обл\.",
"772432", "Шиелийский\ р\-н",
"772531", "Аксукент",
"77222", "Семипалатинск",
"771433", "Лисаковск",
"771542", "Уалихановский\ р\-н",
"7863", "Ростовская\ обл\.",
"771441", "Карабалыкский\ р\-н",
"7879", "Ставропольский\ край",
"772543", "Аксумбе",
"772547", "Ленгер",
"7345", "Тюменская\ обл\.",
"7878", "Республика\ Карачаево\-Черкесская",
"7811", "Псковская\ обл\.",
"771457", "Джангильдинский\ р\-н",
"771347", "Айтекебийский\ р\-н",
"7848", "Самарская\ обл\.",
"771343", "Иргизский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771834", "Успенский\ р\-н",
"771453", "Аулиекольский\ р\-н",
"772342", "Катон\-Карагайский\ р\-н",
"77212", "Караганда",
"7426", "Еврейская\ автономная\ обл\.",
"771144", "Казталовский\ р\-н",
"771631", "Шортандинский\ р\-н",
"771545", "Жамбылский\ р\-н",
"772840", "Кербулакский\ р\-н",
"772348", "Кокпектинский\ р\-н",
"772345", "Жарминский\ р\-н",
"7486", "Орловская\ обл\.",
"772230", "Урджарский\ р\-н",
"771651", "Целиноградский\ р\-н",
"7847", "Республика\ Калмыкия",
"7812", "г\.\ Санкт\-Петербург",
"7866", "Республика\ Кабардино\-Балкарская",
"772435", "Жанакорганский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"772149", "Осакаровский\ р\-н",
"771836", "Щербактинский\ р\-н",
"77185", "Шалдай",
"771643", "Атбасарский\ р\-н",
"772438", "Казалинский\ р\-н",
"7384", "Кемеровская\ обл\.",
"772759", "Алматинская\ область",
"771647", "Есильский\ р\-н",
"7353", "Оренбургская\ обл\.",
"7877", "Республика\ Адыгея",
"771042", "Акой",
"771456", "Качар",
"77102", "Жезказган",
"771644", "Аршалынский\ р\-н",
"771346", "Темирский\ р\-н",
"771131", "Зеленовский\ р\-н",
"7421", "Хабаровский\ край",
"77262", "Тараз",
"7481", "Смоленская\ обл\.",
"772546", "Шолаккорган",
"77272983", "Каскелен",
"771436", "Тарановский\ р\-н",
"7861", "Краснодарский\ край",
"772835", "Текели",
"7352", "Курганская\ обл\.",
"7388", "Республика\ Алтай",
"772838", "Коксуский\ р\-н",
"772935", "Каракиянский\ р\-н",
"772938", "Тупкараганский\ р\-н",
"7813", "Ленинградская\ обл\.",
"771147", "Акжаикский\ р\-н",
"7833", "Кировская\ обл\.",
"771143", "Теректинский\ р\-н",
"772752", "Илийский\ р\-н",
"772330", "Зыряновский\ р\-н",
"7873", "Республика\ Ингушетия",
"7869", "г\.\ Севастополь",
"7381", "Омская\ обл\.",
"772138", "Бухар\-Жырауский\ р\-н",
"772534", "Жетысай",
"772842", "Кербулакский\ р\-н",
"771636", "Щучинский\ р\-н",
"771334", "Мугалжарский\ р\-н",
"771843", "Майский\ р\-н",
"7843", "Республика\ Татарстан",
"772252", "Абайский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"7390", "Республика\ Хакасия",
"772339", "Курчумский\ р\-н",
"771831", "Железинский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"771237", "Жылыойский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"771444", "Узункольский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"77242", "Кызылорда",
"772541", "Мырзакент",
"772635", "Жуалынский\ р\-н",
"772638", "Шуский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"771447", "Карабалыкский\ р\-н",
"7842", "Ульяновская\ обл\.",
"771038", "Сыры\-Шаган",
"771234", "Индерский\ р\-н",
"771035", "Улытауский\ р\-н",
"7817", "Вологодская\ обл\.",
"772778", "Уйгурский\ р\-н",
"772775", "Енбекшиказахский\ р\-н",
"771451", "Сарыкольский\ р\-н",
"7717", "Астана",
"771341", "Хобдинский\ р\-н",
"771136", "Акжаикский\ р\-н",
"7872", "Республика\ Дагестан",
"771333", "Мугалжарский\ р\-н",
"771844", "Иртышский\ р\-н",
"772332", "Шемонаихинский\ р\-н",
"77292", "Актау",
"7484", "Калужская\ обл\.",
"77282", "Талдыкорган",
"771337", "Алгинский\ р\-н",
"772537", "Сарыагаш",
"772239", "Урджарский\ р\-н",
"7424", "Сахалинская\ обл\.",
"771431", "Рудный",
"771532", "Аккайынский\ р\-н",
"772533", "Туркестан",
"7871", "Республика\ Чеченская",
"771236", "Махамбетский\ р\-н",
"77125", "Атырауская\ область",
"772159", "Карагандинская\ область",
"7383", "Новосибирская\ обл\.",
"772338", "Уланский\ р\-н",
"772335", "Зыряновск",
"771134", "Сырымский\ р\-н",
"771535", "Габита\ Мусрепова\ р\-н",
"771641", "Астраханский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"7841", "Пензенская\ обл\.",
"772830", "Алакольский\ р\-н",
"7818", "Архангельская\ обл\.",
"771637", "Коргалжынский\ р\-н",
"771032", "Каражал",
"7475", "Тамбовская\ обл\.",
"772632", "Меркенский\ р\-н",
"771633", "Ерейментауский\ р\-н",
"772772", "Капчагай",
"77272", "Алма\-Ата",
"7855", "Республика\ Татарстан",
"772536", "Кентау",
"7834", "Республика\ Мордовия",
"7814", "Республика\ Карелия",
"7382", "Томская\ обл\.",
"7846", "Самарская\ обл\.",
"77135", "Актюбинская\ область",
"771336", "Хромтауский\ р\-н",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771141", "Жангалинский\ р\-н",
"771133", "Бурлинский\ р\-н",
"772340", "Зайсанский\ р\-н",
"772132", "Нуринский\ р\-н",
"772639", "Сарысуский\ р\-н",
"771039", "Приозерск",
"7487", "Тульская\ обл\.",
"771137", "Чингирлауский\ р\-н",
"772779", "Райымбекский\ р\-н",
"77187", "Экибастуз",
"7427", "Чукотский\ АО",
"771446", "Узункольский\ р\-н",
"7395", "Иркутская\ обл\.",
"771540", "Уалихановский\ р\-н",
"736", "Республика\ Крым",
"771445", "Алтынсаринский\ р\-н",
"771139", "Таскалинский\ р\-н",
"771632", "Зерендинский\ р\-н",
"771448", "Карасуский\ р\-н",
"771037", "Актогайский\ р\-н",
"772633", "Жамбылский\ р\-н",
"772637", "Байзакский\ р\-н",
"772256", "Алгабас",
"771033", "Шетский\ р\-н",
"772773", "Балхашский\ р\-н",
"7473", "Воронежская\ обл\.",
"772154", "Бухар\-Жырауский\ р\-н",
"772777", "Райымбекский\ р\-н",
"771335", "Шалкарский\ р\-н",
"772236", "Бескарагайский\ р\-н",
"7301", "Республика\ Бурятия",
"7712302", "Тенгизшевройл",
"771041", "Актау\,\ Жезказган",
"772641", "Таласский\ р\-н",
"772535", "Шардара",
"7385", "Алтайский\ край",
"772538", "имени\ Турара\ Рыскулова",
"772137", "Сарань",
"771340", "Хобдинский\ р\-н",
"7472", "Белгородская\ обл\.",
"771132", "Теректинский\ р\-н",
"771639", "Енбекшилдерский\ р\-н",
"771845", "Павлодар",
"772540", "Арыс",
"77106", "Сатпаев",
"772725", "Отеген\-Батыр",
"772774", "Талгарский\ р\-н",
"7347", "Республика\ Башкортостан",
"771536", "Тайыншинский\ р\-н",
"772153", "Абайский\ р\-н",
"771430", "Аркалык",
"772634", "Жанатас",
"772336", "Риддер",
"771235", "Макатский\ р\-н",
"771034", "Улытауский\ р\-н",
"771238", "Кзылкогинский\ р\-н",
"771339", "Айтекебийский\ р\-н",
"772831", "Панфиловский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"772931", "Мангистауский\ р\-н",
"7471", "Курская\ обл\.",
"771232", "Атырауская\ область",
"77142", "Костанай",
"772237", "Аязог",
"733", "Байконыр",
"772539", "Казыгурт",
"771138", "Казталовский\ р\-н",
"7845", "Саратовская\ обл\.",
"771135", "Жанибекский\ р\-н",
"771449", "Тарановский\ р\-н",
"771534", "Шал\ Акына\ р\-н",
"772776", "Енбекшиказахский\ р\-н",
"7494", "Костромская\ обл\.",
"771036", "Балхаш",
"772334", "Уланский\ р\-н",
"772636", "Кордай",
"772257", "Шульбинск",
"7712303", "Тензиз",
"771842", "Майский\ р\-он",
"7349", "Ямало\-Ненецкий\ АО",
"772843", "Лепсы",
"77182", "Павлодар",
"772337", "Серебрянск",
"772333", "Кокпектинский\ р\-н",
"771140", "Бокейординский\ р\-н",
"771332", "Уилский\ р\-н",
"7391", "Красноярский\ край",
"772532", "Абая",
"772431", "Жалагашский\ р\-н",
"77213", "Темиртау",
"772156", "Шахтинск",
"771533", "Айыртауский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"771239", "Макатский\ р\-н",
"771635", "Жаксынский\ р\-н",
"771541", "Мамлютский\ р\-н",
"771442", "Федоровский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"771638", "Аккольский\ р\-н",
"7499", "г\.\ Москва",
"77274", "Карасайский\ р\-н",
"7302", "Забайкальский\ край",
"7851", "Астраханская\ обл\.",
"772341", "Катон\-Карагайский\ р\-н",
"7498", "Московская\ обл\.",};
$areanames{en} = {"7413", "Magadan",
"7485", "Yaroslavl",
"772146", "Karkaralinsk",
"77273", "Almaty",
"772331", "Glubokoye",
"771839", "Akku",
"772433", "Aralsk",
"771648", "Derzhavinsk",
"77122", "Atyrau",
"771645", "Stepnogorsk",
"771531", "Bulayevo",
"772437", "Zhosaly",
"771547", "Zhambylsky\ District",
"7492", "Vladimir",
"772351", "Borodulikha",
"771543", "Yavlenka",
"772542", "Asykata",
"7865", "Stavropol\ territory",
"771342", "Badamsha",
"772834", "Ushtobe",
"771452", "Karasu",
"772343", "Terekty",
"771130", "Peremetnoye",
"772934", "Zhanaozen",
"772347", "Kalbatau",
"7343", "Ekaterinburg",
"740", "Kaliningrad",
"7821", "Komi\ Republic",
"772833", "Usharal",
"772344", "Akzhar",
"771832", "Irtyshsk",
"772937", "Kuryk",
"772837", "Kabanbai",
"77132", "Aktobe\/Kargalinskoye",
"77252", "Shymkent",
"771145", "Karatobe\ District",
"771439", "Torgai",
"771544", "Presnovka",
"7342", "Perm",
"772251", "Kurchatov",
"771459", "Kostanai\ Region",
"77272956", "Talgar",
"771630", "Burabay",
"772841", "Kapal",
"771349", "Shalkarsky\ District",
"77162", "Kokshetau\/Krasni\ Yar",
"7411", "Republic\ of\ Sakha",
"772131", "Abai",
"772644", "Karatau",
"772346", "Aksuat",
"771440", "Amangeldy",
"771546", "Talshik",
"7394", "Republic\ of\ Tuva",
"7815", "Murmansk",
"7835", "Chuvashi\ Republic",
"77245", "Kyzylorda\ Region",
"772530", "Temirlanovka",
"771838", "Koktobe",
"772436", "Terenozek",
"771649", "Zhaksynsky\ District",
"771142", "Taipak",
"771330", "Khromtau\ District",
"772147", "Egindybulak",
"7496", "Moscow",
"7341", "Udmurtian\ Republic",
"772757", "Akshi",
"771840", "Bayanaul",
"772548", "Shayan",
"772631", "Kulan",
"772545", "Ikan",
"772144", "Kiyevka",
"771031", "Aksu\-Ayuly",
"7416", "Amur\ Region",
"7474", "Lipetsk",
"77279", "Almaty",
"77112", "Uralsk",
"772771", "Kaskelen",
"771458", "Kostanai\ Region",
"771345", "Karauylkeldy",
"771348", "Shalkarsky\ District",
"771455", "Zatobolsk",
"771230", "Atyrau\ Region",
"7346", "Surgut",
"77224", "Barshatas",
"771043", "Zhairem",
"7491", "Ryazan",
"771438", "Amangeldy",
"772643", "Shu",
"772836", "Karabulak",
"771435", "Zhitikara",
"771149", "Zelenovsky\ District",
"771642", "Egendykol",
"772838", "Balpyk\ bi",
"7388", "Republic\ of\ Altai",
"7352", "Kurgan",
"771436", "Taranovskoye",
"772835", "Tekeli",
"7861", "Krasnodar\ Territory",
"772938", "Fort\ Shevchenko",
"772935", "Zhetybai",
"771147", "Akzhaiksky\ District",
"7813", "Leningrad\ region",
"771143", "Akzhaik",
"7833", "Kirov",
"772330", "Zyryanovsky\ District",
"772752", "Otegen\ Batyra",
"771346", "Shubarkuduk",
"771644", "Arshaly",
"771131", "Darinskoye",
"771456", "Kachar",
"77102", "Zhezkazgan",
"77262", "Taraz",
"7421", "Khabarovsk\ Territory",
"7481", "Smolensk",
"77272983", "Kaskelen",
"772546", "Sholakkorgan",
"772230", "Urdzhar",
"7812", "St\ Petersburg",
"7866", "Kabardino\-Balkarian\ Republic",
"7847", "Republic\ of\ Kalmykia",
"771651", "Kabanbai\ Batyr",
"771643", "Atbasar",
"77185", "Shaldai",
"7384", "Kemerovo",
"772759", "Almaty\ Region",
"772438", "Aiteke\ bi",
"772642", "Moiynkum",
"772149", "Osakarovka",
"772435", "Zhanakorgan",
"771836", "Sharbakty",
"771042", "Zharyk",
"7877", "Republic\ of\ Adygeya",
"7353", "Orenburg",
"771647", "Esil",
"7426", "Jewish\ Autonomous\ Region",
"77212", "Karaganda",
"772840", "Saryozek",
"771144", "Kaztalovka",
"771545", "Zhambylsky\ District",
"771631", "Shortandy",
"772345", "Shar",
"772348", "Kokpekty",
"7486", "Orel",
"7879", "Mineranye\ Vody",
"772543", "Aqsumbe",
"7863", "Rostov",
"771542", "Kishkenekol",
"771441", "Karabalyk",
"7345", "Tyumen",
"7878", "Karachayevo\-Cherkessian\ Republic",
"772547", "Lenger",
"771347", "Aitekebisky\ District",
"771457", "Dzhangildinsky\ District",
"7811", "Pskov",
"771834", "Uspenka",
"772342", "Katon\-Karagai",
"771453", "Auliekol",
"7848", "Tolyatti",
"7831", "Nizhni\ Novgorod",
"771343", "Irgiz",
"772839", "Sarkand",
"771331", "Martuk",
"771146", "Akzhaiksky\ District",
"7423", "Primorie\ territory",
"7415", "Kamchatka\ Region",
"7483", "Bryansk",
"771437", "Kamysty",
"77222", "Semey",
"771433", "Lisakovsk",
"772531", "Aksukent",
"772432", "Shiyeli",
"77145834", "Krasnogorsk",
"7495", "Moscow",
"772770", "Uzynagash",
"771434", "Denisovka",
"7844", "Volgograd",
"7836", "Republic\ of\ Marij\ El",
"7820", "Cherepovets",
"771841", "Aktogai",
"7816", "Veliky\ Novgorod",
"7862", "Sochi",
"771030", "Atasu",
"7351", "Chelyabinsk",
"77232", "Ust\-Kamenogorsk",
"771837", "Aksu",
"77149", "Kostanai",
"772932", "Beineu",
"771833", "Terenkol",
"771454", "Karamendy",
"7482", "Tver",
"772832", "Zhansugurov",
"771646", "Makinsk",
"772544", "Shaulder",
"772439", "Aralsky\ District",
"772148", "Molodezhnoye",
"77152", "Petropavlovsk",
"771231", "Akkystau",
"772639", "Saudakent",
"772132", "Nurinsky\ District",
"771133", "Aksai",
"772340", "Zaisan",
"771137", "Chingirlau",
"771039", "Priozersk",
"7487", "Tula",
"7427", "Chukotka\ Autonomous\ District",
"772779", "Narynkol",
"77187", "Ekibastuz",
"771540", "Kishkenekol",
"7395", "Irkutsk",
"771446", "Uzunkolsky\ District",
"7834", "Republic\ of\ Mordovia",
"7855", "Naberezhnye\ Chelny",
"772536", "Kentau",
"7814", "Republic\ of\ Karelia",
"7382", "Tomsk",
"7867", "Republic\ of\ North\ Ossetia",
"771336", "Khromtau",
"771141", "Zhangala",
"7846", "Samara",
"77135", "Aktobe\ Region",
"771032", "Karazhal",
"7475", "Tambov",
"771637", "Korgalzhyn",
"771633", "Ereimentau",
"772632", "Merke",
"772772", "Kapchagai",
"77272", "Almaty",
"77125", "Atyrau\ Region",
"771236", "Makhambet",
"7871", "Chechen\ Republic",
"772335", "Zyryanovsk",
"772159", "Karaganda\ Region",
"772338", "Bozanbai\/Molodezhnyi",
"7383", "Novosibirsk",
"772830", "Alakolsky\ District",
"771538", "Beskol",
"7841", "Penza",
"771134", "Zhympity",
"771641", "Astrakhanka",
"771535", "Novoishimski",
"7818", "Arkhangelsk",
"771844", "Irtyshsky\ District",
"77292", "Aktau",
"772332", "Shemonaikha",
"771333", "Kandyagash",
"77282", "Taldykorgan",
"771337", "Alga",
"7484", "Kaluga",
"772239", "Makanchi",
"7424", "Sakhalin\ Region",
"772537", "Saryagash",
"772533", "Turkestan",
"771431", "Rudny",
"771532", "Smirnovo",
"772638", "Tole\ bi",
"771443", "Borovskoi",
"772635", "Bauyrzhan\ Mamyshuly",
"772541", "Myrzakent",
"771234", "Indernborski",
"7817", "Vologda",
"771035", "Ulytau",
"7842", "Ulyanovsk",
"771038", "Shashubai",
"771447", "Karabalyksky\ District",
"772775", "Esik",
"772778", "Chundzha",
"771341", "Khobda",
"7872", "Republic\ of\ Daghestan",
"771136", "Chapayev",
"771451", "Sarykol",
"7717", "Astana",
"7390", "Republic\ of\ Khakassia",
"771040", "Zhairem\ \(GOK\)",
"772640", "Moiynkumsky\ District",
"771831", "Zhelezinka",
"772339", "Kurchum",
"771539", "Beskol",
"771444", "Uzunkol",
"771237", "Kulsary",
"771233", "Ganyushkino",
"77242", "Kyzylorda",
"7869", "Sevastopol",
"7873", "Ingushi\ Republic",
"772534", "Zhetysai",
"772138", "Gabidena\ Mustafina",
"7381", "Omsk",
"771843", "Maisky\ District",
"7843", "Republic\ of\ Tatarstan",
"772842", "Kogaly",
"771334", "Emba",
"771636", "Shuchinsk",
"772252", "Karaul",
"771638", "Akkol",
"771442", "Fyodorovka",
"771541", "Mamlutka",
"772353", "Novaya\ Shulba",
"771635", "Zhaksy",
"77274", "Karassaisky\ District",
"7499", "Moscow",
"772341", "Ulken\ Naryn",
"7851", "Astrakhan",
"7302", "Chita",
"7498", "Moscow",
"772337", "Serebryansk",
"77182", "Pavlodar",
"771332", "Uil",
"7391", "Krasnoyarsk\ Territory",
"772333", "Samarskoye",
"771140", "Saikhin",
"772156", "Shakhtinsk",
"771533", "Saumalkol",
"77213", "Aktau\/Temirtau",
"772532", "Abai",
"772431", "Zhalagash",
"771239", "Makat",
"771537", "Timiryazevo",
"771449", "Taranovskoye",
"771135", "Zhanibek",
"771534", "Sergeyevka",
"7845", "Saratov",
"771138", "Zhalpaktal",
"7494", "Kostroma",
"772776", "Shelek",
"771036", "Balkhash",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"772843", "Lepsy",
"772257", "Shulbinsk",
"772636", "Kordai",
"772334", "Tavricheskoye",
"7712303", "Tengizs",
"771842", "Koktobe",
"771640", "Balkashino",
"771339", "Komsomolskoye",
"772831", "Zharkent",
"772931", "Shetpe",
"77142", "Kostanai",
"7471", "Kursk",
"771232", "Atyrau\ Region",
"772539", "Kazygurt",
"772237", "Ayagoz",
"733", "Baikonur",
"7347", "Republic\ of\ Bashkortostan",
"772774", "Talgar",
"772725", "Otegen\ Batyra",
"771430", "Arkalyk",
"771536", "Taiynsha",
"772153", "Topar",
"772336", "Ridder",
"772634", "Zhanatas",
"771238", "Miyaly",
"771235", "Dossor",
"771034", "Zhezdy",
"772137", "Saran",
"7472", "Belgorod",
"771132", "Fyodorovka",
"771639", "Stepnyak",
"771340", "Khobdinsky\ District",
"772540", "Arys",
"771845", "Pavlodar\ Area",
"77106", "Satpaev",
"771335", "Shalkar",
"7712302", "Tengizshevroil",
"772236", "Beskaragai",
"7301", "Republic\ of\ Buryatia",
"771041", "Aktau\,\ Zhezkazgan",
"772538", "Turara\ Ryskulova",
"7385", "Altai\ Territory",
"772535", "Shardara",
"772641", "Akkol",
"771037", "Aktogai",
"771448", "Oktyabrskoye",
"772633", "Asa",
"771632", "Zerenda",
"771139", "Taskala",
"736", "Simferopol",
"771445", "Ubaganskoye",
"772256", "Kainar",
"772637", "Sarykemer",
"771033", "Agadyr",
"7473", "Voronezh",
"772773", "Bakanas",
"772777", "Kegen",
"772154", "Botakara",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;