# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154351;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]
            )|
            9(?:
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3(?:
                [045]|
                9(?:
                  [0-58]|
                  6[4-9]|
                  7[0-35689]
                )
              )|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9[0169]
              )|
              3(?:
                [29]|
                60|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[2-57-9]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                7(?:
                  2[2-468]|
                  3[78]
                )|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              8294|
              96
            )[1-3]|
            2(?:
              57|
              93
            )[015-9]|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              8292|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{ja} = {"8125488", "津川",
"817906", "播磨山崎",
"811868", "鷹巣",
"811852", "男鹿",
"812247", "大河原",
"812243", "白石",
"817238", "寝屋川",
"8182943", "広島",
"81531", "田原",
"811952", "二戸",
"815366", "設楽",
"818549", "石見大田",
"81577", "高山",
"812646", "長野",
"81728", "寝屋川",
"81249", "郡山",
"817945", "加古川",
"8198295", "日向",
"81563", "西尾",
"818676", "久世",
"811547", "白糠",
"818896", "須崎",
"819573", "諫早",
"812794", "渋川",
"819577", "島原",
"811543", "釧路",
"812785", "沼田",
"811465", "静内",
"812834", "宇都宮",
"812374", "村山",
"812934", "高萩",
"815584", "下田",
"819932", "指宿",
"81932", "北九州",
"815973", "尾鷲",
"81896", "伊予三島",
"818954", "宇和島",
"81886", "徳島",
"812489", "須賀川",
"819735", "日田",
"815977", "熊野",
"817355", "新宮",
"811645", "留萌",
"819675", "熊本一の宮",
"812579", "小出",
"8125480", "村上",
"817724", "宮津",
"819962", "川内",
"812964", "下館",
"812647", "長野",
"812643", "木曾福島",
"814775", "船橋",
"815367", "設楽",
"81482", "川口",
"812545", "村上",
"81492", "川越",
"815363", "新城",
"81893", "大洲",
"817907", "播磨山崎",
"815562", "鰍沢青柳",
"812246", "大河原",
"815744", "美濃加茂",
"817903", "福崎",
"811378", "今金",
"8186995", "岡山瀬戸",
"811938", "宮古",
"81234", "酒田",
"81544", "富士宮",
"81742", "奈良",
"817472", "五条",
"81188", "秋田",
"818677", "新見",
"811546", "釧路",
"81566", "刈谷",
"819576", "島原",
"818893", "佐川",
"818673", "福渡",
"815362", "新城",
"81426", "八王子",
"81848", "尾道",
"8186993", "備前",
"817902", "福崎",
"811856", "能代",
"8183766", "下関",
"81857", "鳥取",
"815563", "鰍沢青柳",
"811956", "岩手",
"817705", "小浜",
"811734", "五所川原",
"814708", "大原",
"812580", "十日町",
"819967", "出水",
"81927", "福岡",
"812642", "木曾福島",
"81124", "芦別",
"819963", "川内",
"814220", "国分寺",
"81143", "室蘭",
"812855", "小山",
"81220", "迫",
"819208", "対馬佐賀",
"817473", "五条",
"812955", "常陸大宮",
"819936", "加世田",
"818672", "福渡",
"81463", "平塚",
"818892", "佐川",
"818248", "庄原",
"81862", "岡山",
"81439", "木更津",
"817614", "小松",
"818660", "岡山瀬戸",
"817685", "輪島",
"818795", "三本松",
"818375", "美祢",
"811524", "網走",
"8199331", "鹿児島",
"818835", "脇町",
"819966", "出水",
"811454", "鵡川",
"81559", "沼津",
"818544", "木次",
"819788", "国東",
"8112397", "栗山",
"814297", "飯能",
"81466", "藤沢",
"811953", "二戸",
"811857", "能代",
"815566", "身延",
"812678", "佐久",
"812242", "白石",
"812898", "鹿沼",
"81989", "那覇",
"811853", "男鹿",
"817364", "和歌山橋本",
"812998", "潮来",
"811957", "岩手",
"818204", "柳井",
"81551", "韮崎",
"812415", "柳津",
"812839", "佐野",
"81822", "広島",
"81582", "岐阜",
"81423", "国分寺",
"812939", "水戸",
"81592", "津",
"815589", "修善寺大仁",
"815972", "尾鷲",
"812799", "長野原",
"81260", "阿南町",
"819434", "八女",
"8186552", "倉敷",
"815395", "浜松",
"811542", "釧路",
"814288", "青梅",
"819572", "諫早",
"81952", "佐賀",
"812574", "柏崎",
"819933", "指宿",
"817476", "下市",
"812484", "白河",
"812551", "上越",
"819937", "加世田",
"8198293", "延岡",
"817966", "八鹿",
"8128798", "大田原",
"811236", "千歳",
"814794", "銚子",
"818978", "伯方",
"812830", "宇都宮",
"811535", "厚岸",
"812930", "水戸",
"818878", "嶺北",
"818698", "備前",
"811393", "松前",
"814756", "東金",
"811637", "北見枝幸",
"81935", "北九州",
"811397", "奥尻",
"819743", "三重",
"812563", "三条",
"812567", "巻",
"8186691", "倉敷",
"819747", "竹田",
"812659", "伊那",
"815986", "松阪",
"819555", "唐津",
"818475", "府中",
"8167", "大阪",
"815768", "下呂",
"815752", "関",
"818594", "米子",
"817717", "園部",
"812235", "仙台",
"81554", "大月",
"818585", "倉吉",
"817713", "亀岡",
"818514", "海士",
"815955", "上野",
"818683", "津山",
"818687", "美作",
"8125487", "津川",
"818556", "江津",
"81984", "小林",
"817482", "八日市",
"815998", "阿児",
"81434", "千葉",
"818942", "八幡浜",
"812566", "三条",
"818298", "廿日市",
"818842", "阿南",
"819746", "竹田",
"814757", "東金",
"811559", "帯広",
"811636", "北見枝幸",
"817464", "吉野",
"818490", "尾道",
"819802", "南大東",
"815738", "中津川",
"814753", "茂原",
"811396", "江差",
"819598", "福江",
"81259", "佐渡",
"817967", "八鹿",
"818669", "総社",
"811237", "栗山",
"811354", "余市",
"81727", "池田",
"811233", "千歳",
"81578", "神岡",
"817963", "豊岡",
"812384", "米沢",
"818553", "浜田",
"818557", "川本",
"81485", "熊谷",
"812612", "大町",
"818686", "津山",
"81495", "本庄",
"818368", "宇部",
"81292", "水戸",
"812972", "水海道",
"817716", "園部",
"812589", "長岡",
"819685", "玉名",
"819974", "屋久島",
"812872", "大田原",
"811944", "岩泉",
"812692", "中野",
"819828", "高千穂",
"81282", "栃木",
"814229", "武蔵野三鷹",
"815987", "三瀬谷",
"818655", "鴨方",
"815983", "松阪",
"81776", "福井",
"811554", "帯広",
"81549", "静岡",
"81420", "所沢",
"819724", "佐伯",
"81277", "桐生",
"817958", "丹波柏原",
"817962", "豊岡",
"811232", "千歳",
"81263", "松本",
"818947", "宇和",
"818664", "高梁",
"818843", "阿南",
"8186996", "岡山瀬戸",
"818847", "牟岐",
"818943", "八幡浜",
"814752", "茂原",
"819803", "名護",
"819807", "沖縄宮古",
"815756", "郡上八幡",
"812977", "竜ケ崎",
"81226", "気仙沼",
"812693", "中野",
"812873", "大田原",
"812877", "黒磯",
"811658", "上川",
"812697", "飯山",
"8199347", "鹿児島",
"812973", "水海道",
"817455", "大和高田",
"815982", "松阪",
"814701", "鴨川",
"812389", "米沢",
"81942", "久留米",
"812474", "石川",
"818568", "津和野",
"818552", "浜田",
"811365", "倶知安",
"817486", "水口",
"812584", "長岡",
"819979", "徳之島",
"812613", "大町",
"812617", "大町",
"814224", "武蔵野三鷹",
"814281", "相模原",
"811632", "天塩",
"8112390", "夕張",
"819806", "沖縄宮古",
"811392", "木古内",
"818946", "宇和",
"81172", "弘前",
"81460", "小田原",
"812562", "三条",
"812558", "新井",
"818846", "丹生谷",
"812744", "藤岡",
"819742", "三重",
"811975", "水沢",
"81928", "福岡",
"811875", "角館",
"819945", "鹿屋",
"8153963", "天竜",
"817498", "長浜",
"812570", "小出",
"818264", "安芸吉田",
"81825", "広島",
"81585", "揖斐川",
"818805", "土佐中村",
"8152", "名古屋",
"817915", "相生",
"818682", "津山",
"812616", "大町",
"812654", "飯田",
"817483", "八日市",
"819668", "水俣",
"81266", "諏訪",
"8198296", "日向",
"817487", "水口",
"81478", "佐原",
"814998", "小笠原",
"81534", "浜松",
"811588", "興部",
"818385", "萩",
"817735", "福知山",
"815757", "郡上八幡",
"817995", "洲本",
"817712", "亀岡",
"812976", "竜ケ崎",
"81244", "原町",
"8112398", "栗山",
"812876", "黒磯",
"817675", "七尾",
"812911", "鉾田",
"812696", "飯山",
"815753", "関",
"811865", "大館",
"812560", "糸魚川",
"819432", "八女",
"815974", "尾鷲",
"818953", "宇和島",
"818957", "御荘",
"81864", "倉敷",
"812833", "宇都宮",
"815587", "修善寺大仁",
"812937", "水戸",
"812377", "寒河江",
"812482", "白河",
"812373", "村山",
"817948", "三木",
"8125481", "村上",
"812933", "高萩",
"815583", "下田",
"812837", "佐野",
"81252", "新潟",
"812572", "柏崎",
"819574", "諫早",
"812793", "渋川",
"811544", "釧路",
"812797", "渋川",
"817726", "峰山",
"812788", "前橋",
"81281", "宇都宮",
"818542", "安来",
"818680", "岡山",
"81875", "観音寺",
"811452", "早来",
"819738", "玖珠",
"81273", "高崎",
"818202", "柳井",
"811648", "焼尻",
"817362", "和歌山橋本",
"814240", "国分寺",
"8186697", "倉敷",
"815746", "美濃加茂",
"812244", "白石",
"8112392", "夕張",
"819678", "矢部",
"817612", "小松",
"81594", "桑名",
"812796", "渋川",
"818894", "須崎",
"818674", "久世",
"817960", "八鹿",
"81584", "大垣",
"815586", "下田",
"812936", "水戸",
"819955", "加治木",
"812376", "寒河江",
"812836", "佐野",
"8188093", "窪川",
"81276", "太田",
"818956", "宇和島",
"818493", "尾道",
"81468", "横須賀",
"811522", "斜里",
"81157", "北見",
"81792", "姫路",
"811935", "釜石",
"815743", "美濃加茂",
"811375", "八雲",
"815747", "美濃白川",
"81245", "福島",
"817904", "福崎",
"81535", "浜松",
"819969", "中甑",
"81162", "稚内",
"812963", "下館",
"812967", "笠間",
"812644", "木曾福島",
"81227", "仙台",
"8124196", "柳津",
"817727", "峰山",
"811732", "五所川原",
"817723", "宮津",
"811523", "斜里",
"81179", "三戸",
"811527", "美幌",
"81183", "湯沢",
"81934", "北九州",
"818679", "新見",
"81726", "茨木",
"817617", "加賀",
"812576", "十日町",
"817613", "小松",
"812486", "須賀川",
"814705", "館山",
"817474", "五条",
"8166", "大阪",
"81763", "福野",
"819205", "厳原",
"818546", "掛合",
"81985", "宮崎",
"812858", "真岡",
"8147955", "八日市場",
"811456", "門別富川",
"812962", "下館",
"81739", "田辺",
"819964", "川内",
"818245", "三次",
"81898", "今治",
"811737", "鰺ケ沢",
"817722", "宮津",
"811733", "五所川原",
"81888", "高知",
"817688", "能都",
"817366", "岩出",
"818798", "土庄",
"815742", "美濃加茂",
"815564", "鰍沢青柳",
"8188095", "土佐清水",
"81555", "吉田",
"818378", "下関",
"812649", "長野",
"818206", "柳井",
"818838", "阿波池田",
"819934", "指宿",
"815979", "熊野",
"815582", "下田",
"812932", "高萩",
"812372", "村山",
"812487", "須賀川",
"812483", "白河",
"81766", "高岡",
"812832", "佐野",
"817616", "小松",
"812577", "六日町",
"81542", "静岡",
"819785", "豊後高田",
"812792", "渋川",
"812573", "柏崎",
"812895", "宇都宮",
"812675", "佐久",
"819437", "田主丸",
"819433", "八女",
"811549", "釧路",
"81744", "大和高田",
"812995", "石岡",
"8162", "大阪",
"8126177", "長野",
"818952", "宇和島",
"811526", "網走",
"818203", "柳井",
"8112394", "夕張",
"812418", "会津山口",
"818207", "久賀",
"81568", "春日井",
"8112399", "栗山",
"81723", "堺",
"811954", "二戸",
"817367", "岩出",
"81196", "盛岡",
"817363", "和歌山橋本",
"811854", "男鹿",
"8111", "札幌",
"814285", "相模原",
"815398", "浜松",
"81494", "秩父",
"811736", "五所川原",
"81484", "川口",
"818547", "掛合",
"81949", "直方",
"811457", "門別富川",
"811453", "早来",
"818543", "安来",
"81125", "滝川",
"812386", "長井",
"812652", "飯田",
"811538", "根室標津",
"8186698", "倉敷",
"818975", "新居浜",
"818684", "津山",
"818695", "岡山瀬戸",
"818875", "土佐山田",
"818593", "米子",
"81473", "市川",
"811946", "久慈",
"819976", "名瀬",
"81944", "瀬高",
"818597", "根雨",
"817714", "亀岡",
"81467", "藤沢",
"81489", "草加",
"8125489", "津川",
"8125484", "村上",
"819744", "三重",
"819558", "唐津",
"812742", "藤岡",
"812564", "三条",
"818478", "東城",
"811394", "松前",
"81923", "福岡",
"812238", "仙台",
"815765", "下呂",
"817466", "十津川",
"811634", "浜頓別",
"818588", "郡家",
"815958", "亀山",
"818262", "加計",
"81228", "築館",
"814797", "八日市場",
"814793", "銚子",
"811356", "岩内",
"81853", "出雲",
"8188096", "土佐清水",
"815995", "阿児",
"818295", "廿日市",
"815984", "松阪",
"812619", "大町",
"811947", "久慈",
"819973", "種子島",
"81734", "和歌山",
"819977", "瀬戸内",
"811943", "岩泉",
"815735", "恵那",
"818596", "米子",
"81926", "福岡",
"81427", "相模原",
"819595", "有川",
"814222", "武蔵野三鷹",
"81270", "伊勢崎",
"812879", "烏山",
"81532", "豊橋",
"812640", "長野",
"812979", "竜ケ崎",
"812582", "長岡",
"812383", "米沢",
"818554", "浜田",
"81242", "会津若松",
"812387", "長井",
"812472", "石川",
"81963", "熊本",
"811353", "余市",
"814796", "八日市場",
"81939", "北九州",
"811234", "千歳",
"811357", "岩内",
"818949", "宇和",
"817964", "豊岡",
"819722", "佐伯",
"81977", "別府",
"819809", "八重山",
"81174", "蟹田",
"818365", "宇部",
"811552", "帯広",
"819688", "玉名",
"81268", "上田",
"817463", "吉野",
"81476", "成田",
"814754", "茂原",
"819825", "日向",
"814771", "市川",
"818662", "高梁",
"812583", "長岡",
"814227", "武蔵野三鷹",
"812614", "大町",
"814223", "武蔵野三鷹",
"812587", "長岡",
"812473", "石川",
"817955", "三田",
"812382", "米沢",
"812477", "三春",
"81552", "甲府",
"812656", "伊那",
"818559", "川本",
"812694", "中野",
"811942", "岩泉",
"812874", "大田原",
"819972", "種子島",
"81992", "鹿児島",
"812974", "水海道",
"819804", "名護",
"817458", "大和榛原",
"811655", "名寄",
"818663", "総社",
"81567", "津島",
"812746", "富岡",
"818844", "阿南",
"817969", "浜坂",
"818944", "八幡浜",
"818667", "井原",
"81581", "高富",
"81591", "津",
"811352", "余市",
"818565", "益田",
"811553", "帯広",
"819727", "臼杵",
"819723", "佐伯",
"818266", "千代田",
"811557", "十勝池田",
"8125482", "村上",
"818689", "岡山",
"81138", "函館",
"818592", "米子",
"815754", "関",
"818397", "小郡",
"812555", "糸魚川",
"817484", "八日市",
"81284", "足利",
"812653", "飯田",
"811978", "北上",
"819948", "志布志",
"81294", "常陸太田",
"812476", "三春",
"817495", "長浜",
"812657", "伊那",
"811878", "大曲",
"818808", "土佐清水",
"814226", "武蔵野三鷹",
"818512", "西郷",
"812586", "長岡",
"818263", "加計",
"819726", "臼杵",
"81778", "武生",
"811639", "利尻礼文",
"81432", "千葉",
"81833", "下松",
"811556", "帯広",
"818267", "千代田",
"8112391", "夕張",
"819665", "人吉",
"812569", "巻",
"814792", "銚子",
"812747", "富岡",
"81545", "富士",
"817738", "舞鶴",
"812743", "藤岡",
"818388", "田万川",
"818666", "井原",
"811585", "遠軽",
"817998", "津名",
"81235", "鶴岡",
"817678", "七尾",
"812549", "津川",
"811984", "花巻",
"81565", "豊田",
"817704", "敦賀",
"818243", "東広島",
"818247", "庄原",
"814286", "相模原",
"818466", "木江",
"811735", "五所川原",
"8183768", "下関",
"811372", "鹿部",
"811932", "釜石",
"8188092", "窪川",
"81849", "福山",
"819547", "鹿島",
"81480", "久喜",
"819543", "武雄",
"818374", "長門",
"8165", "大阪",
"811525", "網走",
"818834", "鴨島",
"812996", "潮来",
"817684", "輪島",
"812676", "佐久",
"812896", "鹿沼",
"818794", "三本松",
"81438", "木更津",
"817615", "小松",
"819786", "杵築",
"812854", "小山",
"8186997", "岡山瀬戸",
"814703", "館山",
"81286", "宇都宮",
"814707", "大原",
"81740", "今津",
"819968", "出水",
"819952", "大口",
"8198297", "日向",
"81885", "小松島",
"819546", "鹿島",
"818205", "柳井",
"817949", "加古川",
"81998", "鹿児島",
"81988", "那覇",
"817365", "和歌山橋本",
"81547", "島田",
"818463", "竹原",
"814283", "青梅",
"814287", "青梅",
"818246", "三次",
"818467", "木江",
"819938", "加世田",
"818545", "木次",
"811455", "鵡川",
"81930", "行橋",
"8153960", "天竜",
"812485", "白河",
"814706", "大原",
"81834", "徳山",
"819783", "豊後高田",
"812917", "水戸",
"815394", "浜松",
"812575", "十日町",
"814298", "飯能",
"819940", "志布志",
"812913", "鉾田",
"819787", "国東",
"819679", "高森",
"812997", "潮来",
"811958", "岩手",
"812893", "宇都宮",
"812673", "小諸",
"811862", "鹿角",
"811858", "能代",
"812677", "佐久",
"812897", "鹿沼",
"812789", "前橋",
"819435", "八女",
"8112393", "夕張",
"812993", "石岡",
"812414", "柳津",
"81538", "磐田",
"819578", "島原",
"811754", "むつ",
"814282", "青梅",
"811548", "弟子屈",
"818462", "竹原",
"81176", "十和田",
"81729", "八尾",
"817944", "加古川",
"812230", "仙台",
"815978", "熊野",
"8112395", "栗山",
"81721", "富田林",
"8125486", "津川",
"81474", "船橋",
"811376", "八雲",
"811936", "宮古",
"812992", "石岡",
"811644", "留萌",
"815399", "天竜",
"811863", "鹿角",
"817354", "新宮",
"812672", "小諸",
"811867", "鷹巣",
"812892", "宇都宮",
"81924", "福岡",
"81262", "長野",
"812248", "大河原",
"819674", "熊本一の宮",
"818955", "宇和島",
"819734", "日田",
"811464", "静内",
"812835", "佐野",
"812419", "田島",
"815585", "下田",
"812375", "村山",
"819956", "加治木",
"812935", "水戸",
"812795", "渋川",
"81465", "小田原",
"81950", "平戸",
"812784", "沼田",
"819782", "豊後高田",
"811933", "釜石",
"815745", "美濃加茂",
"8188099", "土佐清水",
"8188094", "窪川",
"81878", "高松",
"81797", "西宮",
"811377", "八雲",
"811937", "宮古",
"81975", "大分",
"812544", "新発田",
"819542", "武雄",
"812965", "下館",
"818678", "新見",
"818242", "東広島",
"817725", "宮津",
"819953", "大口",
"81167", "富良野",
"81222", "仙台",
"812648", "長野",
"81964", "松橋",
"81199", "盛岡",
"814702", "館山",
"819957", "加治木",
"812859", "小山",
"81425", "立川",
"815368", "設楽",
"81191", "一関",
"8163", "大阪",
"811866", "鷹巣",
"81946", "甘木",
"817908", "播磨山崎",
"81987", "日南",
"812878", "烏山",
"819822", "延岡",
"81969", "天草",
"812698", "飯山",
"811653", "士別",
"81184", "本荘",
"81933", "北九州",
"812978", "竜ケ崎",
"81775", "大津",
"811586", "中湧別",
"818665", "高梁",
"8186998", "岡山瀬戸",
"814996", "八丈島",
"818567", "津和野",
"819666", "水俣",
"81557", "伊東",
"818563", "益田",
"818362", "宇部",
"811555", "帯広",
"812618", "大町",
"8199343", "鹿児島",
"81486", "浦和",
"81548", "榛原",
"819725", "佐伯",
"8183767", "下関",
"812585", "長岡",
"814225", "武蔵野三鷹",
"819592", "大瀬戸",
"812475", "石川",
"817496", "長浜",
"817953", "西脇",
"811364", "倶知安",
"81764", "富山",
"817957", "丹波柏原",
"8153977", "天竜",
"812556", "糸魚川",
"81562", "尾張横須賀",
"818848", "牟岐",
"818292", "広島",
"818948", "宇和",
"815992", "鳥羽",
"815732", "恵那",
"819808", "八重山",
"81280", "古河",
"817454", "大和高田",
"818804", "土佐中村",
"818265", "安芸吉田",
"817488", "水口",
"8198290", "延岡",
"819663", "人吉",
"81929", "福岡",
"811974", "水沢",
"819944", "鹿屋",
"819667", "水俣",
"811874", "角館",
"811587", "中湧別",
"811583", "紋別",
"812745", "藤岡",
"811539", "根室標津",
"81743", "奈良",
"811656", "美深",
"814291", "飯能",
"815758", "郡上八幡",
"815762", "下呂",
"81936", "北九州",
"815959", "亀山",
"817994", "洲本",
"81724", "岸和田貝塚",
"819233", "前原",
"8112396", "栗山",
"8164", "大阪",
"817674", "羽咋",
"81471", "柏",
"812557", "新井",
"818384", "萩",
"817734", "福知山",
"8125485", "津川",
"812553", "上越",
"817497", "長浜",
"812655", "飯田",
"8198298", "日向",
"818479", "東城",
"817956", "三田",
"817493", "彦根",
"812239", "仙台",
"817914", "相生",
"818872", "室戸",
"818692", "邑久",
"81493", "東松山",
"81892", "久万",
"818972", "新居浜",
"81462", "厚木",
"811582", "紋別",
"81863", "玉野",
"819949", "大根占",
"81839", "山口",
"814992", "伊豆大島",
"81798", "西宮",
"81877", "丸亀",
"815763", "下呂",
"81142", "伊達",
"8125483", "村上",
"819826", "日向",
"815767", "下呂",
"817718", "園部",
"818366", "宇部",
"811534", "中標津",
"8175", "京都",
"818688", "美作",
"819662", "人吉",
"812780", "前橋",
"814795", "銚子",
"817492", "彦根",
"818973", "新居浜",
"81596", "伊勢",
"818877", "嶺北",
"818697", "備前",
"815954", "上野",
"817940", "加古川",
"81586", "一宮",
"818693", "邑久",
"819596", "福江",
"818873", "安芸",
"818977", "伯方",
"812234", "仙台",
"815736", "中津川",
"811398", "熊石",
"819232", "前原",
"818595", "米子",
"811638", "利尻礼文",
"818584", "倉吉",
"811541", "弟子屈",
"819554", "伊万里",
"812552", "上越",
"81956", "佐世保",
"812568", "巻",
"818296", "広島",
"818474", "府中",
"815996", "阿児",
"818558", "川本",
"818562", "益田",
"818367", "宇部",
"81583", "岐阜",
"81823", "呉",
"8188091", "窪川",
"81537", "掛川",
"818363", "宇部",
"81593", "四日市",
"817465", "吉野",
"811652", "士別",
"819827", "高千穂",
"81225", "石巻",
"819823", "延岡",
"815766", "下呂",
"815988", "三瀬谷",
"815993", "鳥羽",
"818297", "廿日市",
"818293", "廿日市",
"818654", "鴨方",
"815997", "阿児",
"819684", "山鹿",
"815737", "中津川",
"819975", "名瀬",
"811945", "久慈",
"814758", "東金",
"815733", "恵那",
"818876", "土佐山田",
"819593", "大瀬戸",
"818696", "備前",
"817459", "大和榛原",
"814770", "市川",
"819597", "福江",
"811564", "上士幌",
"818976", "新居浜",
"812385", "米沢",
"811238", "栗山",
"8199345", "鹿児島",
"817968", "浜坂",
"817952", "西脇",
"81940", "宗像",
"81922", "福岡",
"812853", "小山",
"814704", "館山",
"812957", "大子",
"817475", "下市",
"812857", "真岡",
"815396", "浜松",
"811738", "鰺ケ沢",
"8186994", "岡山瀬戸",
"817683", "輪島",
"818797", "土庄",
"81246", "いわき",
"818793", "三本松",
"8186999", "岡山瀬戸",
"817687", "能都",
"81852", "松江",
"818837", "阿波池田",
"818373", "長門",
"818377", "下関",
"812416", "田島",
"81178", "八戸",
"818833", "鴨島",
"811528", "美幌",
"819544", "武雄",
"812542", "新発田",
"811551", "十勝池田",
"815565", "鰍沢青柳",
"817950", "三田",
"811939", "宮古",
"818244", "三次",
"817703", "敦賀",
"817707", "小浜",
"81899", "松山",
"817618", "加賀",
"81738", "御坊",
"814772", "市川",
"811987", "遠野",
"819204", "郷ノ浦",
"819965", "川内",
"811983", "花巻",
"818208", "久賀",
"818836", "脇町",
"812413", "喜多方",
"819732", "日田",
"812417", "会津山口",
"818376", "美祢",
"81962", "熊本",
"8153961", "天竜",
"819672", "熊本一の宮",
"818796", "土庄",
"812894", "宇都宮",
"812674", "小諸",
"817352", "新宮",
"817368", "岩出",
"8182942", "広島",
"817686", "能都",
"811642", "石狩深川",
"812994", "石岡",
"819784", "豊後高田",
"811869", "大館",
"815393", "浜松",
"812782", "沼田",
"819912", "中之島",
"815397", "浜松",
"817239", "寝屋川",
"81250", "新津",
"812914", "鉾田",
"818391", "小郡",
"812956", "常陸大宮",
"819935", "加世田",
"811462", "浦河",
"818548", "石見大田",
"812856", "真岡",
"81561", "瀬戸",
"817942", "加古川",
"811986", "遠野",
"81948", "飯塚",
"812488", "須賀川",
"8198294", "延岡",
"818464", "竹原",
"814284", "立川",
"811752", "むつ",
"81845", "因島",
"817706", "小浜",
"8198299", "日向",
"812578", "六日町",
"811955", "二戸",
"812550", "安塚",
"81243", "二本松",
"819438", "田主丸",
"811855", "能代",
"81569", "半田",
"81587", "一宮",
"81827", "岩国",
"81533", "豊橋",
"81429", "所沢",
"819575", "諫早",
"812679", "佐久",
"819913", "硫黄島",
"812899", "鹿沼",
"812787", "沼田",
"812783", "沼田",
"815392", "浜松",
"812999", "潮来",
"811545", "釧路",
"811463", "浦河",
"81572", "多治見",
"819737", "玖珠",
"819733", "日田",
"812412", "喜多方",
"81774", "宇治",
"819789", "杵築",
"819677", "矢部",
"811643", "石狩深川",
"811864", "大館",
"817353", "新宮",
"817357", "串本",
"811647", "羽幌",
"819673", "熊本一の宮",
"81288", "今市",
"814289", "青梅",
"81298", "土浦",
"8186553", "倉敷",
"812245", "大河原",
"81553", "山梨",
"818958", "御荘",
"81436", "市原",
"812546", "村上",
"81765", "魚津",
"81983", "高鍋",
"812838", "佐野",
"817947", "三木",
"814776", "船橋",
"81134", "小樽",
"8198292", "延岡",
"812938", "水戸",
"817943", "加古川",
"818690", "岡山",
"812378", "寒河江",
"81937", "北九州",
"815588", "修善寺大仁",
"8161", "大阪",
"812798", "長野原",
"81979", "中津",
"811757", "野辺地",
"811753", "むつ",
"819676", "高森",
"815748", "美濃白川",
"818792", "三本松",
"817356", "串本",
"817682", "輪島",
"811646", "羽幌",
"81487", "浦和",
"814709", "鴨川",
"818832", "鴨島",
"81433", "千葉",
"8186992", "備前",
"81832", "下関",
"818372", "長門",
"819954", "加治木",
"812968", "笠間",
"811466", "えりも",
"818360", "小郡",
"812852", "小山",
"81986", "都城",
"812786", "沼田",
"8144", "川崎",
"817728", "峰山",
"818895", "須崎",
"818675", "久世",
"813", "東京",
"811756", "野辺地",
"817702", "敦賀",
"814777", "船橋",
"811982", "花巻",
"817946", "三木",
"8188097", "土佐清水",
"812645", "木曾福島",
"812543", "新発田",
"812547", "村上",
"811934", "釜石",
"81725", "和泉",
"811374", "森",
"8147957", "八日市場",
"818249", "東広島",
"817905", "福崎",
"818290", "広島",
"8178", "神戸",
"817676", "七尾",
"812695", "中野",
"812875", "大田原",
"817457", "大和高田",
"819599", "大瀬戸",
"817996", "津名",
"812975", "水海道",
"817453", "大和高田",
"819682", "山鹿",
"818652", "倉敷",
"818668", "井原",
"817736", "舞鶴",
"815999", "津",
"817954", "西脇",
"81240", "磐城富岡",
"811367", "寿都",
"818240", "東広島",
"811363", "倶知安",
"818299", "広島",
"812615", "大町",
"8153974", "天竜",
"811562", "本別",
"811558", "広尾",
"819728", "臼杵",
"81272", "前橋",
"817916", "竜野",
"814700", "鴨川",
"81958", "長崎",
"812588", "長岡",
"818806", "宿毛",
"81464", "厚木",
"814228", "武蔵野三鷹",
"811876", "大曲",
"812478", "三春",
"819946", "鹿屋",
"81947", "田川",
"81144", "苫小牧",
"811976", "北上",
"811336", "石狩",
"818564", "益田",
"818845", "丹生谷",
"81253", "新潟",
"818945", "八幡浜",
"81828", "広島",
"819805", "名護",
"81925", "福岡",
"811654", "名寄",
"818369", "宇部",
"81166", "旭川",
"818268", "千代田",
"815952", "上野",
"817917", "竜野",
"8169", "大阪",
"817485", "八日市",
"814280", "立川",
"811366", "寿都",
"817494", "彦根",
"8168", "大阪",
"817737", "舞鶴",
"818387", "田万川",
"81177", "青森",
"818472", "甲山",
"812748", "富岡",
"818383", "萩",
"812554", "上越",
"817733", "福知山",
"819552", "伊万里",
"817677", "七尾",
"818582", "倉吉",
"817456", "大和高田",
"817993", "洲本",
"818879", "室戸",
"8182920", "廿日市",
"817997", "津名",
"815755", "関",
"812571", "六日町",
"817673", "羽咋",
"812232", "岩沼",
"8198291", "延岡",
"814994", "三宅",
"818398", "小郡",
"812890", "宇都宮",
"811584", "遠軽",
"81424", "武蔵野三鷹",
"811877", "大曲",
"81965", "八代",
"812658", "伊那",
"811333", "当別",
"811973", "水沢",
"819664", "人吉",
"819947", "志布志",
"81737", "湯浅",
"819943", "鹿屋",
"811977", "北上",
"81793", "姫路",
"811337", "石狩",
"811873", "角館",
"81126", "岩見沢",
"815769", "荘川",
"818803", "土佐中村",
"81779", "大野",
"818807", "宿毛",
"811532", "根室",
"819553", "伊万里",
"818656", "笠岡",
"817732", "福知山",
"818382", "萩",
"818477", "東城",
"818473", "甲山",
"81546", "静岡",
"81488", "浦和",
"819557", "唐津",
"812233", "岩沼",
"817672", "羽咋",
"81762", "金沢",
"818587", "郡家",
"817715", "亀岡",
"817992", "洲本",
"81236", "山形",
"818583", "倉吉",
"812237", "仙台",
"819686", "玉名",
"818974", "新居浜",
"811566", "十勝清水",
"818685", "津山",
"815953", "上野",
"818694", "岡山",
"815957", "上野",
"817912", "相生",
"818874", "安芸",
"81564", "岡崎",
"8182941", "広島",
"8145", "横浜",
"812559", "安塚",
"8153962", "天竜",
"814798", "八日市場",
"81182", "横手",
"819942", "大根占",
"811589", "興部",
"811972", "水沢",
"81192", "大船渡",
"811332", "当別",
"81229", "古川",
"811533", "根室",
"818802", "窪川",
"811537", "中標津",
"818598", "根雨",
"815764", "下呂",
"811395", "江差",
"811635", "浜頓別",
"812565", "三条",
"817230", "寝屋川",
"81550", "御殿場",
"81722", "堺",
"818555", "江津",
"811362", "倶知安",
"811567", "十勝清水",
"819594", "有川",
"815956", "上野",
"811563", "本別",
"819683", "山鹿",
"818586", "倉吉",
"817468", "上北山",
"817452", "大和高田",
"8124197", "柳津",
"812236", "仙台",
"815734", "恵那",
"819687", "玉名",
"8188098", "土佐清水",
"817959", "三田",
"818657", "笠岡",
"815994", "阿児",
"818476", "府中",
"815985", "松阪",
"818294", "廿日市",
"819556", "唐津",
"81543", "静岡",
"8188090", "窪川",
"819978", "徳之島",
"81233", "新庄",
"819824", "延岡",
"814755", "東金",
"8147950", "八日市場",
"81835", "防府",
"811536", "厚岸",
"818364", "宇部",
"812388", "長井",
"81938", "北九州",
"817965", "豊岡",
"811235", "夕張",};
$areanames{en} = {"812373", "Murayama\,\ Yamagata",
"817948", "Miki\,\ Hyogo",
"8125481", "Murakami\,\ Niigata",
"812933", "Takahagi\,\ Ibaraki",
"8186999", "Seto\,\ Okayama",
"815583", "Shimoda\,\ Shizuoka",
"81852", "Matsue\,\ Shimane",
"817687", "Noto\,\ Ishikawa",
"812837", "Sano\,\ Tochigi",
"8153971", "Hamamatsu\,\ Shizuoka",
"8186994", "Seto\,\ Okayama",
"812833", "Utsunomiya\,\ Tochigi",
"817683", "Wajima\,\ Ishikawa",
"812937", "Mito\,\ Ibaraki",
"818797", "Tonosho\,\ Kagawa",
"812377", "Sagae\,\ Yamagata",
"812482", "Shirakawa\,\ Fukushima",
"81246", "Iwaki\,\ Fukushima",
"811544", "Kushiro\,\ Hokkaido",
"812797", "Shibukawa\,\ Gunma",
"818377", "Shimonoseki\,\ Yamaguchi",
"812416", "Tajima\,\ Fukushima",
"81178", "Hachinohe\,\ Aomori",
"818833", "Kamojima\,\ Tokushima",
"81252", "Niigata\,\ Niigata",
"812572", "Kashiwazaki\,\ Niigata",
"818373", "Nagato\,\ Yamaguchi",
"812793", "Shibukawa\,\ Gunma",
"819574", "Isahaya\,\ Nagasaki",
"817475", "Shimonoseki\,\ Yamaguchi",
"812857", "Mooka\,\ Tochigi",
"81922", "Fukuoka\,\ Fukuoka",
"812853", "Oyama\,\ Tochigi",
"814704", "Tateyama\,\ Chiba",
"811865", "Odate\,\ Akita",
"812957", "Daigo\,\ Ibaraki",
"812560", "Itoigawa\,\ Niigata",
"819432", "Yame\,\ Fukuoka",
"818957", "Misho\,\ Ehime",
"81864", "Kurashiki\,\ Okayama",
"815974", "Owase\,\ Mie",
"818953", "Uwajima\,\ Ehime",
"81273", "Takasaki\,\ Gunma",
"819738", "Kusu\,\ Oita",
"817707", "Obama\,\ Fukui",
"81899", "Matsuyama\,\ Ehime",
"817618", "Kaga\,\ Ishikawa",
"818202", "Yanai\,\ Yamaguchi",
"817950", "Sanda\,\ Hyogo",
"811939", "Miyako\,\ Iwate",
"818244", "Miyoshi\,\ Hiroshima",
"817703", "Tsuruga\,\ Fukui",
"819965", "Satsumasendai\,\ Kagoshima",
"815746", "Minokamo\,\ Gifu",
"8186697", "Kurashiki\,\ Okayama",
"812244", "Shiroishi\,\ Miyagi",
"811983", "Hanamaki\,\ Iwate",
"8112392", "Yubari\,\ Hokkaido",
"814772", "Ichikawa\,\ Chiba",
"81738", "Gobo\,\ Wakayama",
"814240", "Kokubunji\,\ Tokyo",
"811987", "Tono\,\ Iwate",
"819544", "Takeo\,\ Saga",
"812788", "Maebashi\,\ Gunma",
"812542", "Shibata\,\ Niigata",
"81281", "Utsunomiya\,\ Tochigi",
"811528", "Bihoro\,\ Hokkaido",
"818542", "Yasugi\,\ Shimane",
"818680", "Okayama\,\ Okayama",
"81875", "Kan\'onji\,\ Kagawa",
"811452", "Hayakita\,\ Hokkaido",
"818956", "Uwajima\,\ Ehime",
"817239", "Neyagawa\,\ Osaka",
"818493", "Onomichi\,\ Hiroshima",
"81468", "Yokosuka\,\ Kanagawa",
"81250", "Niitsu\,\ Niigata",
"812914", "Hokota\,\ Ibaraki",
"811522", "Shari\,\ Hokkaido",
"81157", "Kitami\,\ Hokkaido",
"819784", "Bungotakada\,\ Oita",
"811869", "Odate\,\ Akita",
"815393", "Hamamatsu\,\ Shizuoka",
"812782", "Numata\,\ Gunma",
"81276", "Ota\,\ Gunma",
"81792", "Himeji\,\ Hyogo",
"811462", "Urakawa\,\ Hokkaido",
"812856", "Mooka\,\ Tochigi",
"818391", "Ogori\,\ Yamaguchi",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"819935", "Kaseda\,\ Kagoshima",
"812796", "Shibukawa\,\ Gunma",
"818894", "Susaki\,\ Kochi",
"818674", "Kuse\,\ Okayama",
"818376", "Mine\,\ Yamaguchi",
"81584", "Ogaki\,\ Gifu",
"817612", "Komatsu\,\ Ishikawa",
"818836", "Mima\,\ Tokushima",
"812413", "Kitakata\,\ Fukushima",
"81594", "Kuwana\,\ Mie",
"819732", "Hita\,\ Oita",
"817352", "Shingu\,\ Fukuoka",
"817368", "Iwade\,\ Wakayama",
"8182942", "Hiroshima\,\ Hiroshima",
"817686", "Noto\,\ Ishikawa",
"812994", "Ishioka\,\ Ibaraki",
"812836", "Sano\,\ Tochigi",
"81962", "Kumamoto\,\ Kumamoto",
"815586", "Shimoda\,\ Shizuoka",
"818796", "Tonosho\,\ Kagawa",
"812894", "Utsunomiya\,\ Tochigi",
"812936", "Mito\,\ Ibaraki",
"819955", "Kajiki\,\ Kagoshima",
"812674", "Komoro\,\ Nagano",
"812376", "Sagae\,\ Yamagata",
"812967", "Kasama\,\ Ibaraki",
"812550", "Yasuzuka\,\ Niigata",
"81243", "Nihonmatsu\,\ Fukushima",
"819438", "Tanushimaru\,\ Fukuoka",
"811855", "Noshiro\,\ Akita",
"81227", "Sendai\,\ Miyagi",
"81162", "Wakkanai\,\ Hokkaido",
"811955", "Ninohe\,\ Iwate",
"812963", "Shimodate\,\ Ibaraki",
"817723", "Miyazu\,\ Kyoto",
"81533", "Toyohashi\,\ Aichi",
"81569", "Handa\,\ Aichi",
"81587", "Ichinomiya\,\ Aichi",
"81827", "Iwakuni\,\ Yamaguchi",
"8124196", "Yanaizu\,\ Fukushima",
"811732", "Goshogawara\,\ Aomori",
"81245", "Fukushima\,\ Fukushima",
"81948", "Iizuka\,\ Fukuoka",
"812488", "Sukagawa\,\ Fukushima",
"8126173", "Omachi\,\ Nagano",
"817904", "Fukusaki\,\ Hyogo",
"81561", "Seto\,\ Aichi",
"817942", "Kakogawa\,\ Hyogo",
"811935", "Kamaishi\,\ Iwate",
"811986", "Tono\,\ Iwate",
"815743", "Minokamo\,\ Gifu",
"811375", "Yakumo\,\ Hokkaido",
"81535", "Hamamatsu\,\ Shizuoka",
"817706", "Obama\,\ Fukui",
"8198299", "Hyuga\,\ Miyazaki",
"812578", "Muika\,\ Niigata",
"8198294", "Nobeoka\,\ Miyazaki",
"818464", "Takehara\,\ Hiroshima",
"814284", "Tachikawa\,\ Tokyo",
"81845", "Innoshima\,\ Hiroshima",
"811752", "Mutsu\,\ Aomori",
"819733", "Hita\,\ Oita",
"81774", "Uji\,\ Kyoto",
"812412", "Kitakata\,\ Fukushima",
"817613", "Komatsu\,\ Ishikawa",
"817617", "Kaga\,\ Ishikawa",
"812576", "Tokamachi\,\ Niigata",
"819737", "Kusu\,\ Oita",
"817357", "Kushimoto\,\ Wakayama",
"811647", "Haboro\,\ Hokkaido",
"8166", "Osaka\,\ Osaka",
"819789", "Kitsuki\,\ Oita",
"812486", "Sukagawa\,\ Fukushima",
"817353", "Shingu\,\ Fukuoka",
"811864", "Odate\,\ Akita",
"814705", "Tateyama\,\ Chiba",
"812783", "Numata\,\ Gunma",
"815392", "Hamamatsu\,\ Shizuoka",
"812999", "Itako\,\ Ibaraki",
"811545", "Kushiro\,\ Hokkaido",
"811527", "Bihoro\,\ Hokkaido",
"8126175", "Omachi\,\ Nagano",
"811523", "Shari\,\ Hokkaido",
"81429", "Tokorozawa\,\ Saitama",
"819575", "Isahaya\,\ Nagasaki",
"812679", "Saku\,\ Nagano",
"81179", "Sannohe\,\ Aomori",
"812899", "Kanuma\,\ Tochigi",
"812787", "Numata\,\ Gunma",
"818679", "Niimi\,\ Okayama",
"81726", "Ibaraki\,\ Osaka",
"81183", "Yuzawa\,\ Akita",
"811463", "Urakawa\,\ Hokkaido",
"81934", "Kitakyushu\,\ Fukuoka",
"81572", "Tajimi\,\ Gifu",
"8198292", "Nobeoka\,\ Miyazaki",
"818798", "Tonosho\,\ Kagawa",
"812938", "Mito\,\ Ibaraki",
"815742", "Minokamo\,\ Gifu",
"817943", "Kakogawa\,\ Hyogo",
"81937", "Kitakyushu\,\ Fukuoka",
"8188095", "Tosashimizu\,\ Kochi",
"818690", "Okayama\,\ Okayama",
"812378", "Sagae\,\ Yamagata",
"81555", "Fujiyoshida\,\ Yamanashi",
"81765", "Uozu\,\ Toyama",
"817688", "Noto\,\ Ishikawa",
"81983", "Takanabe\,\ Miyazaki",
"812838", "Sano\,\ Tochigi",
"817947", "Miki\,\ Hyogo",
"817366", "Iwade\,\ Wakayama",
"81134", "Otaru\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"811753", "Mutsu\,\ Aomori",
"812649", "Nagano\,\ Nagano",
"818206", "Yanai\,\ Yamaguchi",
"8161", "Osaka\,\ Osaka",
"81979", "Nakatsu\,\ Oita",
"812798", "Naganohara\,\ Gunma",
"811757", "Noheji\,\ Aomori",
"818378", "Shimonoseki\,\ Yamaguchi",
"81298", "Tsuchiura\,\ Ibaraki",
"812962", "Shimodate\,\ Ibaraki",
"81739", "Tanabe\,\ Wakayama",
"8186553", "Kurashiki\,\ Okayama",
"819964", "Satsumasendai\,\ Kagoshima",
"812245", "Ogawara\,\ Miyagi",
"81553", "Yamanashi\,\ Yamanashi",
"818546", "Kakeya\,\ Shimane",
"81763", "Fukuno\,\ Toyama",
"81985", "Miyazaki\,\ Miyazaki",
"812858", "Mooka\,\ Tochigi",
"81288", "Imabari\,\ Ehime",
"814289", "Ome\,\ Tokyo",
"8147955", "Yokaichiba\,\ Chiba",
"811733", "Goshogawara\,\ Aomori",
"812546", "Murakami\,\ Niigata",
"81888", "Kochi\,\ Kochi",
"818245", "Miyoshi\,\ Hiroshima",
"81436", "Ichihara\,\ Chiba",
"81898", "Imabari\,\ Ehime",
"818958", "Misho\,\ Ehime",
"817722", "Miyazu\,\ Kyoto",
"819433", "Yame\,\ Fukuoka",
"81744", "Yamatotakada\,\ Nara",
"811549", "Kushiro\,\ Hokkaido",
"811466", "Erimo\,\ Hokkaido",
"812995", "Ishioka\,\ Ibaraki",
"818360", "Ogori\,\ Yamaguchi",
"81986", "Miyakonojo\,\ Miyazaki",
"812852", "Oyama\,\ Tochigi",
"8162", "Osaka\,\ Osaka",
"819954", "Kajiki\,\ Kagoshima",
"812895", "Utsunomiya\,\ Tochigi",
"812675", "Saku\,\ Nagano",
"812968", "Kasama\,\ Ibaraki",
"819437", "Tanushimaru\,\ Fukuoka",
"818952", "Uwajima\,\ Ehime",
"8144", "Kawasaki\,\ Kanagawa",
"811526", "Abashiri\,\ Hokkaido",
"818895", "Susaki\,\ Kochi",
"818675", "Kuse\,\ Okayama",
"812786", "Numata\,\ Gunma",
"817356", "Kushimoto\,\ Wakayama",
"812483", "Shirakawa\,\ Fukushima",
"81766", "Takaoka\,\ Toyama",
"817682", "Wajima\,\ Ishikawa",
"811646", "Haboro\,\ Hokkaido",
"812832", "Sano\,\ Tochigi",
"819934", "Ibusuki\,\ Kagoshima",
"815979", "Kumano\,\ Mie",
"819676", "Takamori\,\ Kumamoto",
"815582", "Shimoda\,\ Shizuoka",
"812932", "Takahagi\,\ Ibaraki",
"812372", "Murayama\,\ Yamagata",
"812487", "Sukagawa\,\ Fukushima",
"81433", "Chiba\,\ Chiba",
"8186992", "Bizen\,\ Okayama",
"812792", "Shibukawa\,\ Gunma",
"81832", "Shimonoseki\,\ Yamaguchi",
"818372", "Nagato\,\ Yamaguchi",
"812573", "Kashiwazaki\,\ Niigata",
"814709", "Kamogawa\,\ Chiba",
"81487", "Urawa\,\ Saitama",
"817616", "Komatsu\,\ Ishikawa",
"818832", "Kamojima\,\ Tokushima",
"812577", "Muika\,\ Niigata",
"81542", "Shizuoka\,\ Shizuoka",
"819785", "Bungotakada\,\ Oita",
"812547", "Murakami\,\ Niigata",
"81484", "Kawaguchi\,\ Saitama",
"8111", "Sapporo\,\ Hokkaido",
"814285", "Sagamihara\,\ Kanagawa",
"812543", "Shibata\,\ Niigata",
"815398", "Hamamatsu\,\ Shizuoka",
"81494", "Chichibu\,\ Saitama",
"811736", "Goshogawara\,\ Aomori",
"817905", "Fukusaki\,\ Hyogo",
"811453", "Hayakita\,\ Hokkaido",
"818290", "Hiroshima\,\ Hiroshima",
"8178", "Kobe\,\ Hyogo",
"818543", "Yasugi\,\ Shimane",
"818547", "Kakeya\,\ Shimane",
"811934", "Kamaishi\,\ Iwate",
"81725", "Izumi\,\ Osaka",
"811374", "Mori\,\ Hokkaido",
"81949", "Nogata\,\ Fukuoka",
"8147957", "Yokaichiba\,\ Chiba",
"818249", "Higashi\-ku\,\ Hiroshima",
"817702", "Tsuruga\,\ Fukui",
"81568", "Kasugai\,\ Aichi",
"8112399", "Kuriyama\,\ Hokkaido",
"818203", "Yanai\,\ Yamaguchi",
"8112394", "Yubari\,\ Hokkaido",
"813", "Tokyo",
"811756", "Noheji\,\ Aomori",
"811854", "Oga\,\ Akita",
"8188097", "Tosashimizu\,\ Kochi",
"81723", "Sakai\,\ Osaka",
"811954", "Ninohe\,\ Iwate",
"814777", "Funabashi\,\ Chiba",
"817367", "Iwade\,\ Wakayama",
"817946", "Miki\,\ Hyogo",
"811982", "Hanamaki\,\ Iwate",
"81196", "Morioka\,\ Iwate",
"819976", "Naze\,\ Kagoshima",
"811363", "Kutchan\,\ Hokkaido",
"81944", "Setaka\,\ Fukuoka",
"818299", "Hiroshima\,\ Hiroshima",
"817714", "Kameoka\,\ Kyoto",
"815999", "Tsu\,\ Mie",
"817954", "Nishiwaki\,\ Hyogo",
"818593", "Yonago\,\ Tottori",
"81473", "Ichikawa\,\ Chiba",
"811367", "Suttsu\,\ Hokkaido",
"818240", "Higashi\-ku\,\ Hiroshima",
"811946", "Kuji\,\ Iwate",
"81272", "Maebashi\,\ Gunma",
"819728", "Usuki\,\ Oita",
"8125484", "Murakami\,\ Niigata",
"8153979", "Hamamatsu\,\ Shizuoka",
"81467", "Fujisawa\,\ Kanagawa",
"81489", "Soka\,\ Saitama",
"811562", "Honbetsu\,\ Hokkaido",
"811558", "Hiroo\,\ Hokkaido",
"812615", "Omachi\,\ Nagano",
"8125489", "Tsugawa\,\ Niigata",
"817996", "Tsuna\,\ Hyogo",
"817453", "Yamatotakada\,\ Nara",
"812386", "Nagai\,\ Yamagata",
"812652", "Iida\,\ Nagano",
"819682", "Yamaga\,\ Kumamoto",
"817676", "Nanao\,\ Ishikawa",
"812695", "Nakano\,\ Nagano",
"812875", "Otawara\,\ Tochigi",
"81125", "Takikawa\,\ Hokkaido",
"817457", "Yamatotakada\,\ Nara",
"819599", "Oseto\,\ Nagasaki",
"818695", "Seto\,\ Okayama",
"818652", "Kurashiki\,\ Okayama",
"818668", "Ibara\,\ Okayama",
"8186698", "Kurashiki\,\ Okayama",
"817736", "Maizuru\,\ Kyoto",
"818975", "Niihama\,\ Ehime",
"818684", "Tsuyama\,\ Okayama",
"818945", "Yawatahama\,\ Ehime",
"81828", "Hiroshima\,\ Hiroshima",
"818262", "Kake\,\ Hiroshima",
"81253", "Niigata\,\ Niigata",
"815958", "Kameyama\,\ Mie",
"814793", "Choshi\,\ Chiba",
"811356", "Iwanai\,\ Hokkaido",
"811654", "Nayoro\,\ Hokkaido",
"818369", "Ube\,\ Yamaguchi",
"81853", "Izumo\,\ Shimane",
"81166", "Asahikawa\,\ Hokkaido",
"819805", "Nago\,\ Okinawa",
"81925", "Fukuoka\,\ Fukuoka",
"814797", "Yokaichiba\,\ Chiba",
"818478", "Tojo\,\ Hiroshima",
"818806", "Sukumo\,\ Kochi",
"81464", "Atsugi\,\ Kanagawa",
"819744", "Mie\,\ Oita",
"814700", "Kamogawa\,\ Chiba",
"819558", "Karatsu\,\ Saga",
"81958", "Nagasaki\,\ Nagasaki",
"812588", "Nagaoka\,\ Niigata",
"812742", "Fujioka\,\ Gunma",
"812564", "Sanjo\,\ Niigata",
"817466", "Totsukawa\,\ Nara",
"81144", "Tomakomai\,\ Hokkaido",
"811976", "Kitakami\,\ Iwate",
"811336", "Ishikari\,\ Hokkaido",
"818564", "Masuda\,\ Shimane",
"811634", "Hamatonbetsu\,\ Hokkaido",
"818588", "Koge\,\ Tottori",
"811394", "Matsumae\,\ Hokkaido",
"811876", "Omagari\,\ Akita",
"81923", "Fukuoka\,\ Fukuoka",
"812238", "Sendai\,\ Miyagi",
"81947", "Tagawa\,\ Fukuoka",
"819946", "Kanoya\,\ Kagoshima",
"815765", "Gero\,\ Gifu",
"812478", "Miharu\,\ Fukushima",
"81532", "Toyohashi\,\ Aichi",
"812748", "Tomioka\,\ Gunma",
"818383", "Hagi\,\ Yamaguchi",
"812554", "Joetsu\,\ Niigata",
"812640", "Nagano\,\ Nagano",
"817733", "Fukuchiyama\,\ Kyoto",
"819552", "Imari\,\ Saga",
"812582", "Nagaoka\,\ Niigata",
"81427", "Sagamihara\,\ Kanagawa",
"81270", "Isesaki\,\ Gunma",
"817737", "Maizuru\,\ Kyoto",
"812879", "Nasukarasuyama\,\ Tochigi",
"818387", "Tamagawa\,\ Yamaguchi",
"81177", "Aomori\,\ Aomori",
"818879", "Muroto\,\ Kochi",
"81242", "Aizuwakamatsu\,\ Fukushima",
"817997", "Tsuna\,\ Hyogo",
"8182920", "Hatsukaichi\,\ Hiroshima",
"812387", "Nagai\,\ Yamagata",
"812472", "Ishikawa\,\ Fukushima",
"812571", "Muika\,\ Niigata",
"815755", "Sekigahara\,\ Gifu",
"817673", "Hakui\,\ Ishikawa",
"812232", "Iwanuma\,\ Miyagi",
"817677", "Nanao\,\ Ishikawa",
"818582", "Kurayoshi\,\ Tottori",
"817456", "Yamatotakada\,\ Nara",
"812383", "Yonezawa\,\ Yamagata",
"818554", "Hamada\,\ Shimane",
"817993", "Sumoto\,\ Hyogo",
"818295", "Hatsukaichi\,\ Hiroshima",
"815984", "Matsusaka\,\ Mie",
"8153969", "Hamamatsu\,\ Shizuoka",
"8153964", "Hamamatsu\,\ Shizuoka",
"8188096", "Tosashimizu\,\ Kochi",
"815995", "Ago\,\ Mie",
"819977", "Setouchi\,\ Kagoshima",
"811943", "Iwaizumi\,\ Iwate",
"815735", "Ena\,\ Gifu",
"818596", "Yonago\,\ Tottori",
"8168", "Osaka\,\ Osaka",
"817494", "Hikone\,\ Shiga",
"81926", "Fukuoka\,\ Fukuoka",
"8169", "Osaka\,\ Osaka",
"812619", "Omachi\,\ Nagano",
"817485", "Yokaichi\,\ Shiga",
"811947", "Kuji\,\ Iwate",
"81734", "Wakayama\,\ Wakayama",
"811366", "Suttsu\,\ Hokkaido",
"814280", "Tachikawa\,\ Tokyo",
"81737", "Yuasa\,\ Wakayama",
"819943", "Kanoya\,\ Kagoshima",
"81476", "Narita\,\ Chiba",
"811977", "Kitakami\,\ Iwate",
"8126176", "Omachi\,\ Nagano",
"81793", "Himeji\,\ Hyogo",
"811337", "Ishikari\,\ Hokkaido",
"811873", "Kakunodate\,\ Akita",
"814754", "Mobara\,\ Chiba",
"819825", "Hyuga\,\ Miyazaki",
"81126", "Iwamizawa\,\ Hokkaido",
"811877", "Omagari\,\ Akita",
"819688", "Tamana\,\ Kumamoto",
"81965", "Yatsushiro\,\ Kumamoto",
"81268", "Ueda\,\ Nagano",
"812658", "Ina\,\ Nagano",
"811333", "Tobetsu\,\ Hokkaido",
"817463", "Yoshino\,\ Nara",
"811973", "Mizusawa\,\ Iwate",
"819664", "Hitoyoshi\,\ Kumamoto",
"819947", "Shibushi\,\ Kagoshima",
"818807", "Sukumo\,\ Kochi",
"814771", "Ichikawa\,\ Chiba",
"818662", "Takahashi\,\ Okayama",
"811532", "Nemuro\,\ Hokkaido",
"815769", "Shokawa\,\ Gifu",
"81779", "Ono\,\ Gifu",
"81939", "Kitakyushu\,\ Fukuoka",
"811234", "Chitose\,\ Hokkaido",
"811357", "Iwanai\,\ Hokkaido",
"818949", "Uwajima\,\ Ehime",
"817964", "Toyooka\,\ Hyogo",
"8198291", "Nobeoka\,\ Miyazaki",
"81963", "Kumamoto\,\ Kumamoto",
"811353", "Yoichi\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"81174", "Kanita\,\ Aomori",
"818365", "Ube\,\ Yamaguchi",
"811584", "Engaru\,\ Hokkaido",
"811552", "Obihiro\,\ Hokkaido",
"819722", "Saiki\,\ Oita",
"818398", "Ogori\,\ Yamaguchi",
"81977", "Beppu\,\ Oita",
"819809", "Yaeyama\ District\,\ Okinawa",
"812890", "Utsunomiya\,\ Tochigi",
"818694", "Okayama\,\ Okayama",
"817912", "Aioi\,\ Hyogo",
"818874", "Aki\,\ Kochi",
"81564", "Okazaki\,\ Aichi",
"818974", "Niihama\,\ Ehime",
"818685", "Tsuyama\,\ Okayama",
"818559", "Kawamoto\,\ Shimane",
"812559", "Yasuzuka\,\ Niigata",
"81992", "Kagoshima\,\ Kagoshima",
"814798", "Yokaichiba\,\ Chiba",
"8182941", "Hiroshima\,\ Hiroshima",
"8145", "Yokohama\,\ Kanagawa",
"812694", "Nakano\,\ Nagano",
"811942", "Iwaizumi\,\ Iwate",
"812874", "Otawara\,\ Tochigi",
"81546", "Shizuoka\,\ Shizuoka",
"81488", "Urawa\,\ Saitama",
"819557", "Karatsu\,\ Saga",
"812587", "Nagaoka\,\ Niigata",
"819553", "Imari\,\ Saga",
"812583", "Nagaoka\,\ Niigata",
"818656", "Kasaoka\,\ Okayama",
"817732", "Fukuchiyama\,\ Kyoto",
"818382", "Hagi\,\ Yamaguchi",
"818477", "Tojo\,\ Hiroshima",
"812614", "Omachi\,\ Nagano",
"817715", "Kameoka\,\ Kyoto",
"817992", "Sumoto\,\ Hyogo",
"81236", "Yamagata\,\ Yamagata",
"812382", "Yonezawa\,\ Yamagata",
"812477", "Miharu\,\ Fukushima",
"81552", "Kofu\,\ Yamanashi",
"818583", "Kurayoshi\,\ Tottori",
"819686", "Tamana\,\ Kumamoto",
"812656", "Ina\,\ Nagano",
"812237", "Sendai\,\ Miyagi",
"812233", "Iwanuma\,\ Miyagi",
"817672", "Hakui\,\ Ishikawa",
"81762", "Kanazawa\,\ Ishikawa",
"818587", "Koge\,\ Tottori",
"812473", "Ishikawa\,\ Fukushima",
"817955", "Sanda\,\ Hyogo",
"81591", "Tsu\,\ Mie",
"811352", "Yoichi\,\ Hokkaido",
"811635", "Hamatonbetsu\,\ Hokkaido",
"818565", "Masuda\,\ Shimane",
"815764", "Gero\,\ Gifu",
"811395", "Esashi\,\ Hokkaido",
"819723", "Saiki\,\ Oita",
"817230", "Neyagawa\,\ Osaka",
"811553", "Obihiro\,\ Hokkaido",
"812565", "Sanjo\,\ Niigata",
"819727", "Usuki\,\ Oita",
"811972", "Mizusawa\,\ Iwate",
"811589", "Okoppe\,\ Hokkaido",
"81192", "Ofunato\,\ Iwate",
"811332", "Tobetsu\,\ Hokkaido",
"811655", "Nayoro\,\ Hokkaido",
"81182", "Yokote\,\ Akita",
"819804", "Nago\,\ Okinawa",
"817969", "Hamasaka\,\ Hyogo",
"818667", "Ibara\,\ Okayama",
"818944", "Yawatahama\,\ Ehime",
"811537", "Nakashibetsu\,\ Hokkaido",
"818663", "Soja\,\ Okayama",
"811533", "Nemuro\,\ Hokkaido",
"81567", "Tsushima\,\ Aichi",
"812746", "Tomioka\,\ Gunma",
"818844", "Anan\,\ Tokushima",
"812476", "Miharu\,\ Fukushima",
"819948", "Shibushi\,\ Kagoshima",
"81294", "Hitachiota\,\ Ibaraki",
"817495", "Nagahama\,\ Shiga",
"8124197", "Yanaizu\,\ Fukushima",
"812657", "Ina\,\ Nagano",
"819687", "Tamana\,\ Kumamoto",
"812236", "Sendai\,\ Miyagi",
"811878", "Omagari\,\ Akita",
"815734", "Ena\,\ Gifu",
"81284", "Ashikaga\,\ Tochigi",
"817484", "Yokaichi\,\ Shiga",
"819683", "Yamaga\,\ Kumamoto",
"812653", "Iida\,\ Nagano",
"818586", "Kurayoshi\,\ Tottori",
"817468", "Kamikitayama\,\ Nara",
"817452", "Yamatotakada\,\ Nara",
"811978", "Kitakami\,\ Iwate",
"8126170", "Omachi\,\ Nagano",
"815985", "Matsusaka\,\ Mie",
"818294", "Hatsukaichi\,\ Hiroshima",
"818512", "Nishigo\,\ Fukushima",
"819556", "Karatsu\,\ Saga",
"812586", "Nagaoka\,\ Niigata",
"8188098", "Tosashimizu\,\ Kochi",
"817959", "Sanda\,\ Hyogo",
"818808", "Tosashimizu\,\ Kochi",
"818657", "Kasaoka\,\ Okayama",
"815994", "Ago\,\ Mie",
"818476", "Fuchu\,\ Hiroshima",
"8153972", "Hamamatsu\,\ Shizuoka",
"818592", "Yonago\,\ Tottori",
"815754", "Sekigahara\,\ Gifu",
"81550", "Gotenba\,\ Shizuoka",
"8125482", "Murakami\,\ Niigata",
"818555", "Gotsu\,\ Shimane",
"81722", "Sakai\,\ Osaka",
"818689", "Okayama\,\ Okayama",
"81138", "Hakodate\,\ Hokkaido",
"811362", "Kutchan\,\ Hokkaido",
"818397", "Ogori\,\ Yamaguchi",
"811563", "Honbetsu\,\ Hokkaido",
"812555", "Itoigawa\,\ Niigata",
"817738", "Maizuru\,\ Kyoto",
"818388", "Tamagawa\,\ Yamaguchi",
"81835", "Hofu\,\ Yamaguchi",
"812743", "Fujioka\,\ Gunma",
"818666", "Ibara\,\ Okayama",
"811536", "Akkeshi\,\ Hokkaido",
"811585", "Engaru\,\ Hokkaido",
"818364", "Ube\,\ Yamaguchi",
"8147950", "Yokaichiba\,\ Chiba",
"812747", "Tomioka\,\ Gunma",
"81545", "Fuji\,\ Shizuoka",
"817965", "Toyooka\,\ Hyogo",
"817678", "Nanao\,\ Ishikawa",
"811235", "Yubari\,\ Hokkaido",
"817998", "Tsuna\,\ Hyogo",
"81938", "Kitakyushu\,\ Fukuoka",
"81235", "Tsuruoka\,\ Yamagata",
"812388", "Nagai\,\ Yamagata",
"81778", "Takefu\,\ Fukui",
"81432", "Chiba\,\ Chiba",
"81833", "Kudamatsu\,\ Yamaguchi",
"811556", "Obihiro\,\ Hokkaido",
"818263", "Kake\,\ Hiroshima",
"819726", "Usuki\,\ Oita",
"81543", "Shizuoka\,\ Shizuoka",
"819824", "Nobeoka\,\ Miyazaki",
"814755", "Togane\,\ Chiba",
"8126178", "Omachi\,\ Nagano",
"8112391", "Yubari\,\ Hokkaido",
"819665", "Hitoyoshi\,\ Kumamoto",
"819978", "Tokunoshima\,\ Kagoshima",
"814792", "Choshi\,\ Chiba",
"81233", "Shinjo\,\ Yamagata",
"81728", "Neyagawa\,\ Osaka",
"8183768", "Shimonoseki\,\ Yamaguchi",
"811372", "Shikabe\,\ Hokkaido",
"81249", "Koriyama\,\ Fukushima",
"811932", "Kamaishi\,\ Iwate",
"817945", "Kakogawa\,\ Hyogo",
"81577", "Takayama\,\ Gifu",
"812646", "Nagano\,\ Nagano",
"81480", "Kuki\,\ Saitama",
"819543", "Takeo\,\ Saga",
"8198295", "Hyuga\,\ Miyazaki",
"81849", "Fukuyama\,\ Hiroshima",
"81563", "Nishio\,\ Aichi",
"819547", "Kashima\,\ Saga",
"812243", "Shiroishi\,\ Miyagi",
"8153978", "Hamamatsu\,\ Shizuoka",
"817238", "Neyagawa\,\ Osaka",
"811984", "Hanamaki\,\ Iwate",
"8182943", "Hiroshima\,\ Hiroshima",
"81531", "Tahara\,\ Aichi",
"811952", "Ninohe\,\ Iwate",
"8125488", "Tsugawa\,\ Niigata",
"812549", "Tsugawa\,\ Niigata",
"811868", "Takanosu\,\ Akita",
"811852", "Oga\,\ Akita",
"812247", "Ogawara\,\ Miyagi",
"818247", "Shobara\,\ Hiroshima",
"814286", "Sagamihara\,\ Kanagawa",
"811735", "Goshogawara\,\ Aomori",
"818466", "Mima\,\ Tokushima",
"815366", "Shitara\,\ Aichi",
"81565", "Toyota\,\ Aichi",
"817704", "Tsuruga\,\ Fukui",
"818243", "Higashi\-ku\,\ Hiroshima",
"81886", "Tokushima\,\ Tokushima",
"817615", "Komatsu\,\ Ishikawa",
"812489", "Sukagawa\,\ Fukushima",
"819735", "Hita\,\ Oita",
"819786", "Kitsuki\,\ Oita",
"815977", "Kumano\,\ Mie",
"815973", "Owase\,\ Mie",
"81438", "Kisarazu\,\ Chiba",
"81896", "Iyomishima\,\ Ehime",
"818954", "Uwajima\,\ Ehime",
"81740", "Imazu\,\ Shiga",
"819952", "Okuchi\,\ Kagoshima",
"819968", "Izumi\,\ Kagoshima",
"8125480", "Murakami\,\ Niigata",
"812854", "Oyama\,\ Tochigi",
"8186997", "Seto\,\ Okayama",
"817355", "Shingu\,\ Fukuoka",
"814703", "Tateyama\,\ Chiba",
"81286", "Utsunomiya\,\ Tochigi",
"811645", "Rumoi\,\ Hokkaido",
"8153970", "Hamamatsu\,\ Shizuoka",
"819577", "Shimabara\,\ Nagasaki",
"811543", "Kushiro\,\ Hokkaido",
"818834", "Kamojima\,\ Tokushima",
"812785", "Numata\,\ Gunma",
"8165", "Osaka\,\ Osaka",
"818374", "Nagato\,\ Yamaguchi",
"818676", "Kuse\,\ Okayama",
"811547", "Shiranuka\,\ Hokkaido",
"811525", "Abashiri\,\ Hokkaido",
"812794", "Shibukawa\,\ Gunma",
"819573", "Isahaya\,\ Nagasaki",
"818896", "Susaki\,\ Kochi",
"812374", "Murayama\,\ Yamagata",
"812676", "Saku\,\ Nagano",
"812934", "Takahagi\,\ Ibaraki",
"812896", "Kanuma\,\ Tochigi",
"8126172", "Omachi\,\ Nagano",
"815584", "Shimoda\,\ Shizuoka",
"819932", "Ibusuki\,\ Kagoshima",
"81932", "Kitakyushu\,\ Fukuoka",
"812834", "Utsunomiya\,\ Tochigi",
"811465", "Shizunai\,\ Hokkaido",
"812996", "Itako\,\ Ibaraki",
"817684", "Wajima\,\ Ishikawa",
"814287", "Ome\,\ Tokyo",
"818246", "Miyoshi\,\ Hiroshima",
"818467", "Mima\,\ Tokushima",
"81492", "Kawagoe\,\ Saitama",
"815363", "Shinshiro\,\ Aichi",
"81893", "Ozu\,\ Ehime",
"815367", "Shitara\,\ Aichi",
"81547", "Shimada\,\ Shizuoka",
"818463", "Takehara\,\ Hiroshima",
"81482", "Kawaguchi\,\ Saitama",
"814283", "Ome\,\ Tokyo",
"812545", "Murakami\,\ Niigata",
"8153968", "Hamamatsu\,\ Shizuoka",
"818545", "Kisuki\,\ Shimane",
"817903", "Fukusaki\,\ Hyogo",
"811455", "Mukawa\,\ Hokkaido",
"819938", "Kaseda\,\ Kagoshima",
"815744", "Minokamo\,\ Gifu",
"812246", "Ogawara\,\ Miyagi",
"817949", "Kakogawa\,\ Hyogo",
"817724", "Miyazu\,\ Kyoto",
"8198297", "Hyuga\,\ Miyazaki",
"81885", "Komatsushima\,\ Tokushima",
"819546", "Kashima\,\ Saga",
"818205", "Yanai\,\ Yamaguchi",
"81988", "Naha\,\ Okinawa",
"814775", "Funabashi\,\ Chiba",
"81998", "Kagoshima\,\ Kagoshima",
"819962", "Satsumasendai\,\ Kagoshima",
"812964", "Shimodate\,\ Ibaraki",
"812647", "Nagano\,\ Nagano",
"812677", "Saku\,\ Nagano",
"81188", "Akita\,\ Akita",
"811862", "Kazuno\,\ Akita",
"811858", "Noshiro\,\ Akita",
"812897", "Kanuma\,\ Tochigi",
"812789", "Maebashi\,\ Gunma",
"819435", "Yame\,\ Fukuoka",
"8112393", "Yubari\,\ Hokkaido",
"812993", "Ishioka\,\ Ibaraki",
"812997", "Itako\,\ Ibaraki",
"81742", "Nara\,\ Nara",
"811958", "Iwate\,\ Iwate",
"812893", "Utsunomiya\,\ Tochigi",
"812673", "Komoro\,\ Nagano",
"818893", "Sakawa\,\ Kochi",
"819576", "Shimabara\,\ Nagasaki",
"81566", "Kariya\,\ Aichi",
"812414", "Yanaizu\,\ Fukushima",
"818677", "Niimi\,\ Okayama",
"811546", "Kushiro\,\ Hokkaido",
"812485", "Shirakawa\,\ Fukushima",
"81234", "Sakata\,\ Yamagata",
"811378", "Imakane\,\ Hokkaido",
"8186995", "Seto\,\ Okayama",
"811938", "Miyako\,\ Iwate",
"81930", "Yukuhashi\,\ Fukuoka",
"812575", "Tokamachi\,\ Niigata",
"814298", "Hanno\,\ Saitama",
"819940", "Shibushi\,\ Kagoshima",
"812913", "Hokota\,\ Ibaraki",
"819787", "Kunisaki\,\ Oita",
"819679", "Takamori\,\ Kumamoto",
"81544", "Fujinomiya\,\ Shizuoka",
"81834", "Tokuyama\,\ Yamaguchi",
"819783", "Bungotakada\,\ Oita",
"812917", "Mito\,\ Ibaraki",
"815394", "Hamamatsu\,\ Shizuoka",
"811734", "Goshogawara\,\ Aomori",
"817705", "Obama\,\ Fukui",
"812230", "Sendai\,\ Miyagi",
"815978", "Kumano\,\ Mie",
"8112395", "Kuriyama\,\ Hokkaido",
"81721", "Tondabayashi\,\ Osaka",
"81124", "Ashibetsu\,\ Hokkaido",
"8153976", "Hamamatsu\,\ Shizuoka",
"819963", "Satsumasendai\,\ Kagoshima",
"811376", "Yakumo\,\ Hokkaido",
"81474", "Funabashi\,\ Chiba",
"811936", "Miyako\,\ Iwate",
"814220", "Kokubunji\,\ Tokyo",
"819967", "Izumi\,\ Kagoshima",
"812580", "Tokamachi\,\ Niigata",
"8125486", "Tsugawa\,\ Niigata",
"81927", "Fukuoka\,\ Fukuoka",
"811754", "Mutsu\,\ Aomori",
"814282", "Ome\,\ Tokyo",
"81426", "Hachioji\,\ Tokyo",
"811548", "Teshikaga\,\ Hokkaido",
"818462", "Takehara\,\ Hiroshima",
"81848", "Onomichi\,\ Hiroshima",
"81176", "Towada\,\ Aomori",
"8186993", "Bizen\,\ Okayama",
"815362", "Shinshiro\,\ Aichi",
"81538", "Iwata\,\ Shizuoka",
"819578", "Shimabara\,\ Nagasaki",
"8183766", "Shimonoseki\,\ Yamaguchi",
"81857", "Tottori\,\ Tottori",
"817944", "Kakogawa\,\ Hyogo",
"811956", "Iwate\,\ Iwate",
"817902", "Fukusaki\,\ Hyogo",
"811856", "Noshiro\,\ Akita",
"81729", "Yao\,\ Osaka",
"815585", "Shimoda\,\ Shizuoka",
"812375", "Murayama\,\ Yamagata",
"819956", "Kajiki\,\ Kagoshima",
"812935", "Mito\,\ Ibaraki",
"818660", "Seto\,\ Okayama",
"812835", "Sano\,\ Tochigi",
"811464", "Shizunai\,\ Hokkaido",
"817685", "Wajima\,\ Ishikawa",
"812419", "Tajima\,\ Fukushima",
"8199331", "Kagoshima\,\ Kagoshima",
"812784", "Numata\,\ Gunma",
"818835", "Mima\,\ Tokushima",
"819782", "Bungotakada\,\ Oita",
"818375", "Mine\,\ Yamaguchi",
"812795", "Shibukawa\,\ Gunma",
"811524", "Abashiri\,\ Hokkaido",
"81465", "Odawara\,\ Kanagawa",
"81950", "Hirado\,\ Nagasaki",
"811867", "Takanosu\,\ Akita",
"812672", "Komoro\,\ Nagano",
"812892", "Utsunomiya\,\ Tochigi",
"81924", "Fukuoka\,\ Fukuoka",
"812248", "Ogawara\,\ Miyagi",
"81262", "Nagano\,\ Nagano",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"819936", "Kaseda\,\ Kagoshima",
"812992", "Ishioka\,\ Ibaraki",
"81143", "Muroran\,\ Hokkaido",
"811644", "Rumoi\,\ Hokkaido",
"812855", "Oyama\,\ Tochigi",
"817354", "Shingu\,\ Fukuoka",
"811863", "Kazuno\,\ Akita",
"819734", "Hita\,\ Oita",
"81439", "Kisarazu\,\ Chiba",
"817614", "Komatsu\,\ Ishikawa",
"818955", "Uwajima\,\ Ehime",
"818892", "Sakawa\,\ Kochi",
"81463", "Hiratsuka\,\ Kanagawa",
"818248", "Shobara\,\ Hiroshima",
"81862", "Okayama\,\ Okayama",
"811853", "Oga\,\ Akita",
"812998", "Itako\,\ Ibaraki",
"811957", "Iwate\,\ Iwate",
"811953", "Ninohe\,\ Iwate",
"812965", "Shimodate\,\ Ibaraki",
"811857", "Noshiro\,\ Akita",
"815566", "Minobu\,\ Yamanashi",
"812678", "Saku\,\ Nagano",
"812242", "Shiroishi\,\ Miyagi",
"812898", "Kanuma\,\ Tochigi",
"81989", "Naha\,\ Okinawa",
"818678", "Niimi\,\ Okayama",
"81551", "Nirasaki\,\ Yamanashi",
"818242", "Higashi\-ku\,\ Hiroshima",
"817725", "Miyazu\,\ Kyoto",
"818204", "Yanai\,\ Yamaguchi",
"811454", "Mukawa\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"8153966", "Hamamatsu\,\ Shizuoka",
"81878", "Takamatsu\,\ Kagawa",
"81797", "Nishinomiya\,\ Hyogo",
"811377", "Yakumo\,\ Hokkaido",
"811937", "Miyako\,\ Iwate",
"818544", "Kisuki\,\ Shimane",
"811933", "Kamaishi\,\ Iwate",
"819966", "Izumi\,\ Kagoshima",
"815745", "Minokamo\,\ Gifu",
"8188099", "Tosashimizu\,\ Kochi",
"81466", "Fujisawa\,\ Kanagawa",
"819788", "Kunisaki\,\ Oita",
"81975", "Oita\,\ Oita",
"812544", "Shibata\,\ Niigata",
"8112397", "Kuriyama\,\ Hokkaido",
"814297", "Hanno\,\ Saitama",
"819542", "Takeo\,\ Saga",
"819572", "Isahaya\,\ Nagasaki",
"81952", "Saga\,\ Saga",
"812574", "Kashiwazaki\,\ Niigata",
"815368", "Shitara\,\ Aichi",
"81191", "Ichinoseki\,\ Iwate",
"8126179", "Omachi\,\ Nagano",
"812859", "Oyama\,\ Tochigi",
"815395", "Hamamatsu\,\ Shizuoka",
"8126174", "Omachi\,\ Nagano",
"811542", "Kushiro\,\ Hokkaido",
"81425", "Tachikawa\,\ Tokyo",
"814288", "Ome\,\ Tokyo",
"811866", "Takanosu\,\ Akita",
"812484", "Shirakawa\,\ Fukushima",
"81946", "Amagi\,\ Fukuoka",
"812551", "Joetsu\,\ Niigata",
"819937", "Kaseda\,\ Kagoshima",
"8198293", "Nobeoka\,\ Miyazaki",
"8163", "Osaka\,\ Osaka",
"819933", "Ibusuki\,\ Kagoshima",
"817476", "Shimonoseki\,\ Yamaguchi",
"812939", "Mito\,\ Ibaraki",
"81592", "Tsu\,\ Mie",
"815972", "Owase\,\ Mie",
"812415", "Yanaizu\,\ Fukushima",
"812839", "Sano\,\ Tochigi",
"81582", "Gifu\,\ Gifu",
"81822", "Hiroshima\,\ Hiroshima",
"81423", "Kokubunji\,\ Tokyo",
"819434", "Yame\,\ Fukuoka",
"812648", "Nagano\,\ Nagano",
"81222", "Sendai\,\ Miyagi",
"8186552", "Kurashiki\,\ Okayama",
"81199", "Morioka\,\ Iwate",
"814702", "Tateyama\,\ Chiba",
"819957", "Kajiki\,\ Kagoshima",
"819953", "Okuchi\,\ Kagoshima",
"81167", "Furano\,\ Hokkaido",
"812799", "Naganohara\,\ Gunma",
"81260", "Anan\,\ Nagano",
"81557", "Ito\,\ Shizuoka",
"819666", "Minamata\,\ Kumamoto",
"818563", "Masuda\,\ Shimane",
"81935", "Kitakyushu\,\ Fukuoka",
"811397", "Okushiri\,\ Hokkaido",
"811393", "Matsumae\,\ Hokkaido",
"814756", "Togane\,\ Chiba",
"818567", "Tsuwano\,\ Shimane",
"8186691", "Kurashiki\,\ Okayama",
"81486", "Urawa\,\ Saitama",
"81548", "Haibara\,\ Shizuoka",
"819725", "Saiki\,\ Oita",
"819747", "Taketa\,\ Oita",
"819743", "Mie\,\ Oita",
"818362", "Ube\,\ Yamaguchi",
"812618", "Omachi\,\ Nagano",
"811555", "Obihiro\,\ Hokkaido",
"8199343", "Kagoshima\,\ Kagoshima",
"812563", "Sanjo\,\ Niigata",
"814794", "Choshi\,\ Chiba",
"811653", "Shibetsu\,\ Hokkaido",
"81184", "Yurihonjo\,\ Akita",
"81933", "Kitakyushu\,\ Fukuoka",
"8128798", "Otawara\,\ Tochigi",
"811236", "Chitose\,\ Hokkaido",
"81987", "Nichinan\,\ Miyazaki",
"812878", "Nasukarasuyama\,\ Tochigi",
"819822", "Nobeoka\,\ Miyazaki",
"81969", "Amakusa\,\ Kumamoto",
"812698", "Iiyama\,\ Nagano",
"812930", "Mito\,\ Ibaraki",
"8186998", "Seto\,\ Okayama",
"818698", "Bizen\,\ Okayama",
"818978", "Hakata\,\ Ehime",
"812830", "Utsunomiya\,\ Tochigi",
"81775", "Otsu\,\ Shiga",
"818665", "Takahashi\,\ Okayama",
"811586", "Nakayubetsu\,\ Hokkaido",
"811535", "Akkeshi\,\ Hokkaido",
"818687", "Mimasaka\,\ Okayama",
"8125487", "Tsugawa\,\ Niigata",
"818948", "Uwajima\,\ Ehime",
"815992", "Toba\,\ Mie",
"818514", "Ama\,\ Shimane",
"8153965", "Hamamatsu\,\ Shizuoka",
"812556", "Itoigawa\,\ Niigata",
"818683", "Tsuyama\,\ Okayama",
"818292", "Hiroshima\,\ Hiroshima",
"818556", "Gotsu\,\ Shimane",
"81984", "Kobayashi\,\ Miyazaki",
"817454", "Yamatotakada\,\ Nara",
"817482", "Yokaichi\,\ Shiga",
"815732", "Ena\,\ Gifu",
"81280", "Koga\,\ Ibaraki",
"819808", "Yaeyama\ District\,\ Okinawa",
"819592", "Oseto\,\ Nagasaki",
"818475", "Fuchu\,\ Hiroshima",
"8167", "Osaka\,\ Osaka",
"8183767", "Shimonoseki\,\ Yamaguchi",
"812659", "Ina\,\ Nagano",
"815986", "Matsusaka\,\ Mie",
"819555", "Karatsu\,\ Saga",
"812585", "Nagaoka\,\ Niigata",
"811364", "Kutchan\,\ Hokkaido",
"81764", "Toyama\,\ Toyama",
"818585", "Kurayoshi\,\ Tottori",
"817713", "Kameoka\,\ Kyoto",
"815768", "Gero\,\ Gifu",
"815752", "Sekigahara\,\ Gifu",
"812475", "Ishikawa\,\ Fukushima",
"817496", "Nagahama\,\ Shiga",
"817953", "Nishiwaki\,\ Hyogo",
"818594", "Yonago\,\ Tottori",
"817717", "Sonobe\,\ Kyoto",
"812235", "Sendai\,\ Miyagi",
"81554", "Otsuki\,\ Yamanashi",
"811583", "Monbetsu\,\ Hokkaido",
"812745", "Fujioka\,\ Gunma",
"811587", "Nakayubetsu\,\ Hokkaido",
"81259", "Sado\,\ Niigata",
"819598", "Fukue\,\ Nagasaki",
"811233", "Chitose\,\ Hokkaido",
"81578", "Kamioka\,\ Akita",
"815762", "Gero\,\ Gifu",
"814291", "Hanno\,\ Saitama",
"817963", "Toyooka\,\ Hyogo",
"81743", "Nara\,\ Nara",
"818669", "Soja\,\ Okayama",
"811237", "Kuriyama\,\ Hokkaido",
"811656", "Bifuka\,\ Hokkaido",
"811354", "Yoichi\,\ Hokkaido",
"81727", "Ikeda\,\ Osaka",
"812566", "Sanjo\,\ Niigata",
"818298", "Hatsukaichi\,\ Hiroshima",
"818842", "Anan\,\ Tokushima",
"819746", "Taketa\,\ Oita",
"815998", "Ago\,\ Mie",
"81434", "Chiba\,\ Chiba",
"818942", "Yawatahama\,\ Ehime",
"818490", "Onomichi\,\ Hiroshima",
"819667", "Minamata\,\ Kumamoto",
"819944", "Kanoya\,\ Kagoshima",
"819802", "Minamidaito\,\ Okinawa",
"815738", "Nakatsugawa\,\ Gifu",
"814753", "Mobara\,\ Chiba",
"811874", "Kakunodate\,\ Akita",
"811396", "Esashi\,\ Hokkaido",
"814757", "Togane\,\ Chiba",
"811559", "Obihiro\,\ Hokkaido",
"817488", "Minakuchi\,\ Shiga",
"8198290", "Nobeoka\,\ Miyazaki",
"819663", "Hitoyoshi\,\ Kumamoto",
"81929", "Fukuoka\,\ Fukuoka",
"811974", "Mizusawa\,\ Iwate",
"817464", "Yoshino\,\ Nara",
"812872", "Otawara\,\ Tochigi",
"811944", "Iwaizumi\,\ Iwate",
"8198298", "Hyuga\,\ Miyazaki",
"812692", "Nakano\,\ Nagano",
"819828", "Takachiho\,\ Miyazaki",
"81282", "Tochigi\,\ Tochigi",
"818479", "Tojo\,\ Hiroshima",
"817956", "Sanda\,\ Hyogo",
"817493", "Hikone\,\ Shiga",
"817497", "Nagahama\,\ Shiga",
"81292", "Mito\,\ Ibaraki",
"817716", "Sonobe\,\ Kyoto",
"812589", "Nagaoka\,\ Niigata",
"812655", "Iida\,\ Nagano",
"819685", "Tamana\,\ Kumamoto",
"819974", "Yakushima\,\ Kagoshima",
"818655", "Kamogata\,\ Okayama",
"815983", "Matsusaka\,\ Mie",
"81493", "Higashimatsuyama\,\ Saitama",
"81892", "Kumakogen\,\ Ehime",
"81776", "Fukui\,\ Fukui",
"818972", "Niihama\,\ Ehime",
"812239", "Sendai\,\ Miyagi",
"818872", "Muroto\,\ Kochi",
"817914", "Aioi\,\ Hyogo",
"818692", "Oku\,\ Okayama",
"818557", "Kawamoto\,\ Shimane",
"819233", "Maebaru\,\ Fukuoka",
"8112396", "Kuriyama\,\ Hokkaido",
"8164", "Osaka\,\ Osaka",
"817674", "Hakui\,\ Ishikawa",
"81936", "Kitakyushu\,\ Fukuoka",
"812384", "Yonezawa\,\ Yamagata",
"815959", "Kameyama\,\ Mie",
"818553", "Hamada\,\ Shimane",
"817994", "Sumoto\,\ Hyogo",
"818384", "Hagi\,\ Yamaguchi",
"812612", "Omachi\,\ Nagano",
"818686", "Tsuyama\,\ Okayama",
"817734", "Fukuchiyama\,\ Kyoto",
"812553", "Joetsu\,\ Niigata",
"8125485", "Tsugawa\,\ Niigata",
"818368", "Ube\,\ Yamaguchi",
"81495", "Honjo\,\ Saitama",
"8153975", "Hamamatsu\,\ Shizuoka",
"81471", "Kashiwa\,\ Chiba",
"8153967", "Hamamatsu\,\ Shizuoka",
"81485", "Kumagaya\,\ Saitama",
"8186996", "Seto\,\ Okayama",
"818943", "Yawatahama\,\ Ehime",
"818366", "Ube\,\ Yamaguchi",
"811534", "Nakashibetsu\,\ Hokkaido",
"818947", "Uwajima\,\ Ehime",
"818664", "Takahashi\,\ Okayama",
"818843", "Anan\,\ Tokushima",
"8175", "Kyoto\,\ Kyoto",
"818688", "Mimasaka\,\ Okayama",
"819662", "Hitoyoshi\,\ Kumamoto",
"812780", "Maebashi\,\ Gunma",
"814795", "Choshi\,\ Chiba",
"814752", "Mobara\,\ Chiba",
"819803", "Nago\,\ Okinawa",
"81420", "Tokorozawa\,\ Saitama",
"819724", "Saiki\,\ Oita",
"81277", "Kiryu\,\ Gunma",
"81839", "Yamaguchi\,\ Yamaguchi",
"811554", "Obihiro\,\ Hokkaido",
"81549", "Shizuoka\,\ Shizuoka",
"81462", "Atsugi\,\ Kanagawa",
"811582", "Monbetsu\,\ Hokkaido",
"81863", "Tamano\,\ Okayama",
"81263", "Matsumoto\,\ Nagano",
"8153973", "Hamamatsu\,\ Shizuoka",
"815767", "Gero\,\ Gifu",
"817718", "Sonobe\,\ Kyoto",
"817962", "Toyooka\,\ Hyogo",
"81877", "Marugame\,\ Kagawa",
"81798", "Nishinomiya\,\ Hyogo",
"815763", "Gero\,\ Gifu",
"81142", "Date\,\ Hokkaido",
"811232", "Chitose\,\ Hokkaido",
"8125483", "Murakami\,\ Niigata",
"819826", "Hyuga\,\ Miyazaki",
"818568", "Tsuwano\,\ Shimane",
"818552", "Hamada\,\ Shimane",
"818584", "Kurayoshi\,\ Tottori",
"811365", "Kutchan\,\ Hokkaido",
"817486", "Minakuchi\,\ Shiga",
"811541", "Teshikaga\,\ Hokkaido",
"815736", "Nakatsugawa\,\ Gifu",
"812234", "Sendai\,\ Miyagi",
"811398", "Kumaishi\,\ Hokkaido",
"81942", "Kurume\,\ Fukuoka",
"819232", "Maebaru\,\ Fukuoka",
"812474", "Ishikawa\,\ Fukushima",
"818595", "Yonago\,\ Tottori",
"818474", "Fuchu\,\ Hiroshima",
"815996", "Ago\,\ Mie",
"819554", "Imari\,\ Saga",
"812584", "Nagaoka\,\ Niigata",
"819979", "Tokunoshima\,\ Kagoshima",
"812552", "Joetsu\,\ Niigata",
"81956", "Sasebo\,\ Nagasaki",
"818296", "Hiroshima\,\ Hiroshima",
"812613", "Omachi\,\ Nagano",
"811658", "Kamikawa\,\ Hokkaido",
"812877", "Kuroiso\,\ Tochigi",
"812697", "Iiyama\,\ Nagano",
"8199347", "Kagoshima\,\ Kagoshima",
"817455", "Yamatotakada\,\ Nara",
"817492", "Hikone\,\ Shiga",
"81226", "Kesennuma\,\ Miyagi",
"812693", "Nakano\,\ Nagano",
"812873", "Otawara\,\ Tochigi",
"818693", "Oku\,\ Okayama",
"817940", "Kakogawa\,\ Hyogo",
"81586", "Ichinomiya\,\ Aichi",
"819596", "Fukue\,\ Nagasaki",
"818873", "Aki\,\ Kochi",
"818977", "Hakata\,\ Ehime",
"818973", "Niihama\,\ Ehime",
"81596", "Ise\,\ Mie",
"815982", "Matsusaka\,\ Mie",
"814701", "Kamogawa\,\ Chiba",
"812389", "Yonezawa\,\ Yamagata",
"818697", "Bizen\,\ Okayama",
"81928", "Fukuoka\,\ Fukuoka",
"81225", "Ishinomaki\,\ Miyagi",
"811875", "Kakunodate\,\ Akita",
"819823", "Nobeoka\,\ Miyazaki",
"819945", "Kanoya\,\ Kagoshima",
"815766", "Gero\,\ Gifu",
"817498", "Nagahama\,\ Shiga",
"817465", "Yoshino\,\ Nara",
"811975", "Mizusawa\,\ Iwate",
"811652", "Shibetsu\,\ Hokkaido",
"819827", "Takachiho\,\ Miyazaki",
"8152", "Nagoya\,\ Aichi",
"81825", "Hiroshima\,\ Hiroshima",
"81585", "Ibigawa\,\ Gifu",
"811392", "Kikonai\,\ Hokkaido",
"814281", "Sagamihara\,\ Kanagawa",
"811632", "Teshio\,\ Hokkaido",
"818562", "Masuda\,\ Shimane",
"818558", "Kawamoto\,\ Shimane",
"8112390", "Yubari\,\ Hokkaido",
"81460", "Odawara\,\ Kanagawa",
"812562", "Sanjo\,\ Niigata",
"812744", "Fujioka\,\ Gunma",
"81537", "Kakegawa\,\ Shizuoka",
"819742", "Mie\,\ Oita",
"81593", "Yokkaichi\,\ Mie",
"818363", "Ube\,\ Yamaguchi",
"818946", "Uwajima\,\ Ehime",
"818367", "Ube\,\ Yamaguchi",
"81172", "Hirosaki\,\ Aomori",
"81823", "Kure\,\ Hiroshima",
"81583", "Gifu\,\ Gifu",
"811588", "Okoppe\,\ Hokkaido",
"814770", "Ichikawa\,\ Chiba",
"819597", "Fukue\,\ Nagasaki",
"811564", "Kamishihoro\,\ Hokkaido",
"818385", "Hagi\,\ Yamaguchi",
"817735", "Fukuchiyama\,\ Kyoto",
"818976", "Niihama\,\ Ehime",
"814998", "Ogasawara\,\ Tokyo",
"81534", "Hamamatsu\,\ Shizuoka",
"819593", "Oseto\,\ Nagasaki",
"818696", "Bizen\,\ Okayama",
"8112398", "Kuriyama\,\ Hokkaido",
"812876", "Kuroiso\,\ Tochigi",
"811238", "Kuriyama\,\ Hokkaido",
"817675", "Nanao\,\ Ishikawa",
"812911", "Hokota\,\ Ibaraki",
"8199345", "Kagoshima\,\ Kagoshima",
"812696", "Iiyama\,\ Nagano",
"817952", "Nishiwaki\,\ Hyogo",
"817968", "Hamasaka\,\ Hyogo",
"81940", "Munakata\,\ Fukuoka",
"815753", "Sekigahara\,\ Gifu",
"8126171", "Omachi\,\ Nagano",
"812385", "Yonezawa\,\ Yamagata",
"817995", "Sumoto\,\ Hyogo",
"817712", "Kameoka\,\ Kyoto",
"81244", "Hobara\,\ Fukushima",
"812616", "Omachi\,\ Nagano",
"818682", "Tsuyama\,\ Okayama",
"818293", "Hatsukaichi\,\ Hiroshima",
"818654", "Kamogata\,\ Okayama",
"815997", "Ago\,\ Mie",
"817915", "Aioi\,\ Hyogo",
"815993", "Toba\,\ Mie",
"818297", "Hatsukaichi\,\ Hiroshima",
"8198296", "Hyuga\,\ Miyazaki",
"811945", "Kuji\,\ Iwate",
"817487", "Minakuchi\,\ Shiga",
"815733", "Ena\,\ Gifu",
"81478", "Sawara\,\ Chiba",
"814758", "Togane\,\ Chiba",
"812654", "Iida\,\ Nagano",
"819684", "Yamaga\,\ Kumamoto",
"815737", "Nakatsugawa\,\ Gifu",
"817483", "Yokaichi\,\ Shiga",
"819975", "Naze\,\ Kagoshima",
"819668", "Minamata\,\ Kumamoto",
"81266", "Suwa\,\ Nagano",};
my $timezones = {
               '' => [
                       'Asia/Tokyo'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      my $prefix = qr/^(?:(000[259]\d{6})$|(?:(?:003768)0?)|0)/;
      my @matches = $number =~ /$prefix/;
      if (defined $matches[-1]) {
        no warnings 'uninitialized';
        $number =~ s/$prefix/$1/;
      }
      else {
        $number =~ s/$prefix//;
      }
      $self = bless({ country_code => '81', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;