# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::BG;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240308154348;

my $formatters = [
                {
                  'format' => '$1',
                  'intl_format' => 'NA',
                  'leading_digits' => '1',
                  'pattern' => '(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3 $4',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d)(\\d{2})(\\d{2})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            43[1-6]|
            70[1-9]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '2',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [356]|
            4[124-7]|
            7[1-9]|
            8[1-6]|
            9[1-7]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{2,3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            (?:
              70|
              8
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{3})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            43[1-7]|
            7
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{2})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            [48]|
            9[08]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '9',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                }
              ];

my $validators = {
                'fixed_line' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'geographic' => '
          2\\d{5,7}|
          (?:
            43[1-6]|
            70[1-9]
          )\\d{4,5}|
          (?:
            [36]\\d|
            4[124-7]|
            [57][1-9]|
            8[1-6]|
            9[1-7]
          )\\d{5,6}
        ',
                'mobile' => '
          (?:
            43[07-9]|
            99[69]\\d
          )\\d{5}|
          (?:
            8[7-9]|
            98
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '',
                'specialrate' => '(700\\d{5})|(90\\d{6})',
                'toll_free' => '
          (?:
            00800\\d\\d|
            800
          )\\d{5}
        ',
                'voip' => ''
              };
my %areanames = ();
$areanames{bg} = {"3599740", "Септемврийци\,\ Монт\.",
"3595117", "Ботево\,\ Варна",
"3593340", "Нови\ извор",
"3597524", "Абланица\,\ Благ\.",
"3597529", "Брезница",
"3595767", "Житница\,\ Добр\.",
"3594362", "Манолово",
"3594741", "Болярово",
"35944", "Сливен",
"35991401", "Враняк",
"359336", "Първомай\,\ Пловдив",
"3597532", "Буково\,\ Благ\.",
"35930419", "Ягодина",
"35984466", "Звънарци",
"35971302", "Боженица",
"3594511", "Сливенски\ минерални\ бани",
"3596560", "Крета\,\ Плевен",
"35959400", "Дъскотна",
"3594770", "Генерал\ Инзово",
"35941335", "Могилово",
"3594595", "Сборище",
"3594730", "Княжево",
"35930475", "Стоманево",
"3596931", "Угърчин",
"3595917", "Извор\,\ Бургас",
"35966", "Габрово",
"3599554", "Чипровци",
"35937702", "Мустрак",
"3599559", "Горна\ Ковачица",
"3597058", "Стоб",
"35941356", "Рупките",
"3599525", "Долно\ Озирово",
"3597046", "Бобошево",
"3595321", "Правенци",
"3594557", "Биково",
"3596156", "Родина",
"3596148", "Павел",
"3597726", "Дрен",
"359570", "Каварна",
"3593926", "Добрич\,\ Хаск\.",
"35941149", "Ловец\,\ Ст\.\ Загора",
"35955505", "Драчево",
"3593661", "Ивайловград",
"3594738", "Хлябово",
"3594778", "Победа\,\ Ямбол",
"3596568", "Дъбован",
"3598642", "Дулово",
"3596326", "Морава",
"3596907", "Градежница",
"35931394", "Васил\ Левски\,\ Пловдив",
"3594713", "Стара\ река\,\ Ямбол",
"35969615", "Балабанско",
"3593126", "Труд",
"3594584", "Тича",
"3596065", "Бистра\,\ Търг\.",
"3598627", "Бабук",
"3599518", "Мърчево",
"3596956", "Ломец\,\ Ловеч",
"35931393", "Войнягово",
"35984721", "Липник",
"3598694", "Зебил",
"3596948", "Кърпачево",
"359558", "Айтос",
"3598699", "Търновци\,\ Силистра",
"3595136", "Брестак",
"35963567", "Градина\,\ Плевен",
"3593348", "Добралък",
"3599748", "Дългоделци",
"3597127", "Широки\ дол",
"3595519", "Зидарово",
"35937602", "Черна\ могила\,\ Хаск\.",
"3593512", "Хаджиево",
"3595783", "Котленци",
"3599111", "Челопек",
"3593053", "Хвойна",
"3596586", "Белене",
"3596570", "Девенци",
"3595749", "Крапец\,\ Добр\.",
"3598111", "Щръклево",
"3599342", "Иново",
"3596530", "Трънчовица",
"3596161", "Стражица\,\ В\.\ Търново",
"359337", "Хисаря",
"3594324", "Шипка",
"3597438", "Катунци",
"3594329", "Долно\ Сахране",
"359697", "Луковит",
"3596711", "Кози\ рог",
"3599327", "Чупрене",
"3593727", "Нова\ Надежда",
"359973", "Козлодуй",
"3594355", "Бузовград",
"35969242", "Пресяка",
"3593648", "Голямо\ Каменяне",
"3597927", "Трекляно",
"3594125", "Михайлово\,\ Ст\.\ Загора",
"35984774", "Голям\ извор\,\ Разград",
"3594332", "Ветрен\,\ Ст\.\ Загора",
"3595737", "Люляково\,\ Добр\.",
"3597142", "Костенец",
"3596023", "Подгорица",
"35953222", "Марково\,\ Шумен",
"3594154", "Медникарово",
"3596541", "Никопол",
"35971228", "Марица",
"3595166", "Доброплодно",
"35971503", "Долно\ Камарци",
"3595716", "Паскалево",
"35961405", "Петко\ Каравелово",
"35971504", "Белопопци",
"3596513", "Пордим",
"35971798", "Василовци\,Соф\.",
"3597430", "Дамяница",
"3596035", "Паламарца",
"35971398", "Осиковица",
"3595558", "Дебелт",
"3597185", "Челопеч",
"3594118", "Памукчии\,\ Ст\.\ Загора",
"3596538", "Обнова",
"3599184", "Оходен",
"3593671", "Подкова",
"3593631", "Момчилград",
"3594768", "Зимница\,\ Ямбол",
"3599189", "Паволче",
"35984768", "Синя\ вода",
"3598184", "Глоджево",
"359722", "Самоков",
"3596578", "Реселец",
"3593022", "Виево",
"3598143", "Обретеник",
"3593785", "Дряново\,\ Хаск\.",
"3593039", "Полковник\ Серафимово",
"3593074", "Ерма\ река",
"35991203", "Лик",
"3593034", "Левочево",
"3593079", "Козарка",
"3599143", "Еница",
"3594152", "Обручище",
"3597149", "Живково\,\ София",
"35992", "Враца",
"3599337", "Грамада",
"3594339", "Юлиево",
"3597428", "Габрене",
"35982", "Русе",
"3594334", "Елхово\,\ Ст\.\ Загора\,\ общ\.\ Николаево",
"35974408", "Обидим",
"3597144", "Костенец",
"35960458", "Веренци",
"3593777", "Мезек",
"3597183", "Душанци",
"35991188", "Галатин",
"359537", "Нови\ пазар\,\ Шумен",
"3596033", "Медовина",
"3595727", "Сенокос\,\ Добр\.",
"35961406", "Каранци",
"35941484", "Землен",
"3594322", "Ягода",
"3597937", "Ръждавица",
"3596515", "Славяново\,\ Плевен",
"3593744", "Сърница\,\ Хаск\.",
"3599344", "Връв",
"3597177", "Алдомировци",
"3597192", "Гинци",
"3596591", "Горник",
"3594347", "Розово\,\ Ст\.\ Загора",
"3597137", "Скравена",
"3595742", "Раковски\,\ Добр\.",
"3593749", "Гарваново",
"3595361", "Каолиново",
"3599349", "Сланотрън",
"3593514", "Черногорово\,\ Пазарджик",
"3596520", "Николаево\,\ Плевен",
"3599145", "Бреница\,\ Враца",
"3593519", "Величково\,\ Пазарджик",
"359860", "Силистра",
"3593783", "Свирково",
"3598145", "Тръстеник\,\ Русе",
"3593032", "Средногорци",
"359723", "Ботевград",
"3593581", "Белово",
"359727", "Сливница\,\ София",
"3596528", "Вълчитрън",
"3593072", "Неделино",
"3597116", "Петърч",
"3597415", "Селище\,\ Благ\.",
"3593024", "Търън",
"35959694", "Габерово",
"3593029", "Петково\,\ Смол\.",
"3593055", "Елховец",
"35961608", "Горски\ Сеновец",
"3599182", "Девене",
"3597916", "Багренци",
"3594353", "Средногорово",
"35941118", "Остра\ могила\,\ Ст\.\ Загора",
"35967303", "Батошево",
"35963579", "Ралево",
"3593558", "Исперихово",
"3593701", "Елена\,\ Хаск\.",
"3593166", "Бяла\ река\,\ Пловдив",
"35967304", "Крамолин",
"3596025", "Алваново",
"3598667", "Белица\,\ Силистра",
"3594123", "Богомилово",
"3599316", "Ново\ село\,\ Видин",
"35930257", "Вишнево",
"3596921", "Абланица\,\ Ловеч",
"3599721", "Долно\ Церовене",
"35974386", "Пирин",
"3593321", "Тополово\,\ Пловдив",
"3597547", "Вълкосел",
"3599552", "Белимел",
"3597167", "Церово\,\ София",
"3593151", "Раковски\,\ Пловдив",
"35935391", "Блатница",
"359848", "Кубрат",
"3597717", "Дивотино",
"3596990", "Малък\ извор\,\ Ловеч",
"359659", "Червен\ бряг",
"3596063", "Баячево",
"35941172", "Горно\ Ботево",
"3594715", "Калчево",
"35953234", "Златна\ нива",
"35969616", "Старо\ село\,\ Ловеч",
"3596121", "Никюп",
"3594364", "Осетеново",
"3593117", "Катуница",
"3595340", "Висока\ поляна\,\ Шумен",
"3594369", "Александрово\,\ Ст\.\ Загора",
"35959407", "Сини\ рид",
"3597751", "Брезник",
"3597522", "Дъбница",
"3593767", "Браница",
"35961104", "Водолей",
"3598637", "Малък\ Преславец",
"3593176", "Старосел",
"3593136", "Розино\,\ Пловдив",
"3595348", "Трем",
"3598677", "Сребърна",
"35984465", "Савин",
"3598692", "Стефан\ Караджа\,\ Силистра",
"3594582", "Градец\,\ Сливен",
"3595126", "Черковна\,\ Варна",
"35961103", "Русаля",
"35931324", "Мраченик",
"35963560", "Радишево",
"35961308", "Вишовград",
"3598644", "Чернолик",
"3596998", "Голям\ извор\,\ Ловеч",
"3594593", "Шивачево",
"3598649", "Яребица",
"35941355", "Яворово",
"359749", "Банско",
"3599523", "Бързия",
"35941336", "Яздач",
"35981462", "Волово",
"3594728", "Мелница",
"35930476", "Селча",
"3593936", "Горски\ извор\,\ Хаск\.",
"359726", "Своге",
"3598628", "Цар\ Асен\,\ Силистра",
"3596174", "Драганово\,\ В\.\ Търново",
"3594519", "Самуилово\,\ Сливен",
"35965165", "Писарово\,\ Плевен",
"3596352", "Долни\ Луковит",
"35931397", "Христо\ Даново",
"3599517", "Кобиляк",
"3597735", "Лева\ река",
"35963563", "Борислав",
"3594514", "Крушаре",
"3596179", "Крушето",
"3596134", "Бяла\ черква\,\ В\.\ Търново",
"3595959", "Звездец",
"3594749", "Ружица\,\ Ямбол",
"35967391", "Столът",
"3597752", "Режанци",
"3593935", "Върбица\,\ Хаск\.",
"3599747", "Мокреш\,\ Монт\.",
"3593347", "Леново",
"3597521", "Копривлен",
"3596122", "Беляковец",
"35963564", "Биволаре",
"35971306", "Рашково",
"35984462", "Острово",
"35974495", "Юруково",
"3597043", "Големо\ село",
"3594744", "Голямо\ Крушево",
"3595760", "Божурово\,\ Добр\.",
"3593135", "Кърнаре",
"3595329", "Мировци",
"3593322", "Златовръх",
"3599722", "Сталийска\ махала",
"35981465", "Батин",
"3595910", "Черни\ връх\,\ Бургас",
"3599551", "Георги\ Дамяново",
"35974409", "Места",
"359379", "Свиленград",
"3596922", "Лешница\,\ Ловеч",
"3595324", "Хърсово\,\ Шумен",
"3593175", "Дълго\ поле\,\ Пловдив",
"3596147", "Иванча\,\ В\.\ Търново",
"3596939", "Драгана",
"3595397", "Методиево\,\ Шумен",
"3594777", "Тенево",
"35935502", "Фотиново\,\ Пазарджик",
"3596908", "Глогово",
"3594792", "Ботево\,\ Ямбол",
"3596567", "Сомовит",
"35991189", "Три\ кладенци",
"3595332", "Драгоево",
"35937706", "Чернодъб",
"3595125", "Градинарово",
"3594737", "Синапово",
"3596934", "Катунец",
"35941352", "Винарово\,\ Ст\.\ Загора",
"3593123", "Калояново\,\ Пловдив",
"3594716", "Веселиново\,\ Ямбол",
"3593664", "Плевун",
"359678", "Тетевен",
"35963578", "Опанец\,\ Плевен",
"35941119", "Елхово\,\ Ст\.\ Загора",
"3596900", "Васильово",
"35931403", "Триводици",
"3597057", "Мало\ село",
"35957305", "Росица\,\ Добр\.",
"3596953", "Борима",
"3595918", "Русокастро",
"3595133", "Генерал\ Колево\,\ Варна",
"35974202", "Ключ",
"3595768", "Одринци\,\ Добр\.",
"3596153", "Златарица",
"3598691", "Силистра",
"35984269", "Недоклан",
"3595118", "Водица\,\ Варна",
"3597723", "Долни\ Раковец",
"359650", "Левски\,\ Плевен",
"3593923", "Радиево",
"35978", "Кюстендил",
"3596323", "Българско\ сливово",
"3598620", "Силистра",
"35941175", "Колена",
"3596964", "Велчево\,\ Ловеч",
"3595362", "Климент\,\ Шумен",
"3593545", "Драгиново",
"3596577", "Бресте",
"35943616", "Турия",
"3598114", "Пиргово",
"3597915", "Невестино\,\ Кюст\.",
"3596537", "Асеновци",
"35937606", "Шишманово",
"3596969", "Беклемето",
"3599119", "Тишевица",
"3596026", "Макариополско",
"3593653", "Млечино",
"35931620", "Добри\ дол\,\ Пловдив",
"3599315", "Градец\,\ Видин",
"3597120", "Долна\ баня",
"3595511", "Лукойл\ Нефтохим",
"35954", "Шумен",
"3593165", "Караджалово",
"35981268", "Кривина\,\ Русе",
"35969031", "Галата",
"35947202", "Жребино",
"3597920", "Скриняно",
"3596549", "Санадиново",
"3596544", "Новачене\,\ Плевен",
"3598150", "Семерджиево",
"3596164", "Бряговица",
"3593056", "Чепинци\,\ Смол\.",
"3596583", "Белене",
"3595557", "Бистрец\,\ Бургас",
"3594321", "Мъглиж",
"3596714", "Поповци",
"3599320", "Стакевци",
"3593720", "Маджарово",
"3596169", "Благоево\,\ В\.\ Търново",
"3597437", "Мелник",
"3593728", "Славяново\,\ Хаск\.",
"35961309", "Горско\ Калугерово",
"359470", "Тополовград",
"3599328", "Долни\ Лом",
"35984738", "Китанчево",
"35971587", "Голема\ Раковица",
"3593040", "Триград",
"3598158", "Мечка\,\ Русе",
"3598445", "Юпер",
"3597928", "Гърляно",
"3593702", "Царева\ поляна",
"3593647", "Черничево\,\ Кърдж\.",
"359306", "Рудозем",
"3599146", "Соколаре",
"3595738", "Спасово\,\ Добр\.",
"35941480", "Коларово\,\ Ст\.\ Загора",
"3597444", "Белица\,\ Благ\.",
"35975215", "Тешово",
"3593071", "Златоград",
"3595163", "Млада\ гвардия",
"3593582", "Момина\ клисура",
"3595589", "Винарско",
"3593622", "Стремци",
"3595713", "Стефаново\,\ Добр\.",
"35935258", "Цар\ Асен\,\ Пазарджик",
"3599181", "Краводер",
"3593674", "Самодива",
"3594136", "Черна\ гора\,\ Ст\.\ Загора",
"3597102", "Лопян",
"3593639", "Нановица\,\ Кърдж\.",
"3596516", "Искър\,\ Плевен",
"35961395", "Паскалевец",
"3593679", "Кирково",
"359701", "Дупница",
"3593634", "Припек\,\ Кърдж\.",
"3596712", "Гъбене",
"3593557", "Бяга",
"35931701", "Кръстевич",
"3597930", "Еремия",
"35931627", "Крушево\,\ Пловдив",
"3598668", "Попина",
"3596542", "Въбел\,\ Плевен",
"35967307", "Млечево",
"3599330", "Раброво",
"35961402", "Стефан\ Стамболово",
"3594331", "Гурково\,\ Ст\.\ Загора",
"3593786", "Навъсен",
"3593511", "Огняново\,\ Пазарджик",
"3595715", "Попгригорово",
"3596527", "Одърне",
"3595165", "Невша",
"35934", "Пазарджик",
"3596076", "Таймище",
"3599341", "Димово\,\ Видин",
"35930418", "Буйново\,\ Смол\.",
"3593741", "Мандра",
"35951106", "Осеново\,\ Варна",
"3597186", "Антон",
"35974348", "Игралище",
"3596962", "Черни\ Осъм",
"3599112", "Баница",
"3594340", "Паничерево",
"3596036", "Садина",
"3594348", "Дунавци\,\ Ст\.\ Загора",
"3593632", "Джебел",
"3598196", "Нисово",
"3597913", "Рашка\ Гращица",
"3597138", "Литаково",
"3594356", "Хаджидимитрово\,\ Ст\.\ Загора",
"3593543", "Дорково",
"3597178", "Пролеша",
"3593672", "Чорбаджийско",
"3597104", "Лъга",
"3593163", "Искра\,\ Пловдив",
"3593584", "Ветрен\,\ Пазарджик",
"3593624", "Чифлик\,\ Кърдж\.",
"3593589", "Церово\,\ Пазарджик",
"3593629", "Мост",
"3593713", "Динево",
"3594126", "Хрищени",
"3599313", "Капитановци",
"3597442", "Якоруда",
"3593704", "Брягово\,\ Хаск\.",
"3593778", "Студена\,\ Хаск\.",
"35930517", "Забърдо",
"35969245", "Деветаки",
"3599338", "Шишенци",
"3597427", "Първомай\,\ Благ\.",
"35967774", "Белица\,\ Габр\.",
"3593709", "Караманци",
"3598660", "Тутракан",
"3597938", "Долно\ Уйно",
"3592", "София",
"35991888", "Веслец\,\ Враца",
"3596585", "Белене",
"35955502", "Суходол\,\ Бургас",
"35957306", "Изворово\,\ Добр\.",
"3596066", "Буйново\,\ Търг\.",
"3594799", "Голям\ манастир",
"3595334", "Осмар",
"3593154", "Чалъкови",
"3596932", "Микре",
"3593159", "Белозем",
"3596997", "Добревци\,\ Ловеч",
"3594794", "Овчи\ кладенец",
"3593125", "Ръжево\ Конаре",
"3594727", "Малък\ манастир",
"3595135", "Стефан\ Караджа\,\ Варна",
"3599729", "Расово",
"35931390", "Московец",
"3593324", "Избеглии",
"3596955", "Дълбок\ дол",
"3599724", "Станево",
"359579", "Албена",
"3596929", "Радювене",
"3598678", "Срацимир\,\ Силистра",
"3596124", "Леденик",
"3595347", "Живково\,\ Шумен",
"3597725", "Кленовик",
"3593110", "Поповица",
"35961107", "Момин\ сбор",
"3594742", "Стефан\ Караджово",
"3594361", "Павел\ баня",
"3597754", "Кошарево",
"3596155", "Константин",
"3596129", "Габровци",
"3598638", "Богданци\,\ Силистра",
"3596359", "Глава",
"35969612", "Терзийско\,\ Ловеч",
"3594512", "Блатец\,\ Сливен",
"3596325", "Козловец",
"3596132", "Караисен",
"3597531", "Долно\ Дряново",
"35991668", "Манастирище",
"3595952", "Малко\ Търново",
"35937422", "Долни\ Главанак",
"3593925", "Крум",
"3597733", "Филиповци",
"35984769", "Гороцвет",
"35959403", "Речица",
"35951314", "Войводино",
"35974496", "Филипово\,\ Благ\.",
"3598630", "Силистра",
"3593768", "Доситеево",
"3599526", "Слатина\,\ Монт\.",
"3597045", "Голем\ Върбовник",
"35951537", "Чернево",
"3593933", "Странско",
"3593118", "Садово\,\ Пловдив",
"3598670", "Силистра",
"35959404", "Ясеново\,\ Бургас",
"35984711", "Мортагоново",
"3597548", "Годешево",
"3593173", "Паничери",
"359605", "Омуртаг",
"3595353", "Веселиново\,\ Шумен",
"35936402", "Горна\ кула",
"3593133", "Калофер",
"35937705", "Пъстрогор",
"3597718", "Драгичево",
"35941332", "Найденово",
"3595123", "Равна\,\ Варна",
"35981466", "Помен",
"3598641", "Окорш",
"3597168", "Бов",
"35930472", "Михалково",
"3593662", "Железино",
"35947193", "Могила\,\ Ямбол",
"35961605", "Ново\ градище",
"3596909", "Малка\ Желязна",
"35941179", "Хан\ Аспарухово",
"3596113", "Балван",
"3596938", "Каленик\,\ Ловеч",
"359747", "Разлог",
"35974322", "Петрово\,\ Благ\.",
"3595146", "Горен\ чифлик",
"3593105", "Манолско\ Конаре",
"3595328", "Никола\ Козлево",
"3594756", "Поляна\,\ Ямбол",
"35947354", "Каменна\ река",
"3598672", "Брадвари",
"3594748", "Воден\,\ Ямбол",
"3598697", "Сокол\,\ Силистра",
"35981262", "Бистренци",
"3593196", "Дрангово\,\ Пловдив",
"3598632", "Зафирово",
"35931387", "Пролом",
"3599163", "Хърлец",
"3596913", "Славяни",
"3596138", "Недан",
"35947353", "Българска\ поляна",
"3598629", "Смилец\,\ Силистра",
"3594518", "Тополчане",
"3594587", "Ябланово",
"3595958", "Граматиково",
"3596178", "Стрелец\,\ В\.\ Търново",
"3598624", "Калипетрово",
"35941115", "Борилово",
"3598163", "Бъзън",
"3595946", "Трънак",
"35931707", "Черноземен",
"35984732", "Йонково",
"35984", "Разград",
"3595315", "Царев\ брод",
"35995277", "Черкаски",
"35994", "Видин",
"3594510", "Желю\ войвода",
"3597036", "Баланово",
"35991185", "Пудрия",
"3595114", "Езерово\,\ Варна",
"35974405", "Краище\,\ Благ\.",
"3593341", "Конуш\,\ Пловдив",
"3597527", "Горно\ Дряново",
"3599741", "Долни\ Цибър",
"3593762", "Изворово\,\ Хаск\.",
"3595769", "Хитово",
"35967301", "Идилево",
"3595764", "Владимирово\,\ Добр\.",
"3596941", "Летница",
"3595119", "Игнатиево",
"3593112", "Марково\,\ Пловдив",
"3595914", "Атия",
"3594525", "Омарчево\,\ Сливен",
"35984766", "Каменар\,\ Разград",
"3599557", "Горно\ Церовене",
"3595320", "Пет\ могили\,\ Шумен",
"3595919", "Маринка",
"3596141", "Полски\ Тръмбеш",
"3594554", "Трапоклово",
"35953434", "Ясенково",
"3594771", "Маломир\,\ Ямбол",
"3595391", "Върбица\,\ Шумен",
"3597712", "Батановци",
"3596561", "Гулянци",
"3596986", "Дъбен",
"3596930", "Славщица",
"35935252", "Тополи\ дол",
"3597162", "Лакатник",
"3598133", "Ряхово",
"3596718", "Драгановци",
"3599173", "Галово",
"3593049", "Беден",
"3593044", "Лясково\,\ Смол\.",
"3599133", "Комарево\,\ Враца",
"3596168", "Сушица\,\ В\.\ Търново",
"3595753", "Орляк",
"3598662", "Добротица\,\ Силистра",
"3596548", "Дебово",
"35984717", "Побит\ камък\,\ Разград",
"3596556", "Горна\ Митрополия",
"3593641", "Крумовград",
"35971337", "Калугерово\,\ София",
"359729", "Годеч",
"35960384", "Гагово",
"35930457", "Късак",
"3594143", "Сърнево\,\ Ст\.\ Загора",
"35935393", "Смилец\,\ Пазарджик",
"3595576", "Лозарево",
"3595580", "Трояново\,\ Бургас",
"3593077", "Средец\,\ Смол\.",
"3593037", "Сивино",
"3595536", "Мъглен",
"359518", "Провадия",
"35960377", "Априлово\,\ Търг\.",
"35961705", "Горски\ долен\ Тръмбеш",
"3593526", "Динката",
"3596733", "Кормянско",
"3598118", "Николово\,\ Русе",
"35960383", "Берковски",
"3599187", "Лютаджик",
"359746", "Сандански",
"35941358", "Опълченец",
"35935394", "Оборище\,\ Пазарджик",
"3596968", "Добродан",
"3598187", "Тетово",
"35961305", "Лесичери",
"3594761", "Стралджа",
"3593638", "Звездел",
"3594342", "Овощник",
"3596571", "Лепица",
"3597132", "Радотина",
"3595747", "Ваклино",
"3596960", "Белиш",
"3599110", "Вировско",
"3594106", "Пъстрен",
"35967390", "Шумата",
"3597172", "Драгоман",
"3596531", "Изгрев\,\ Плевен",
"35941277", "Загоре",
"3593678", "Чакаларово",
"35963572", "Ясен\,\ Плевен",
"3596725", "Гостилица",
"3597124", "Белчински\ бани",
"3595517", "Равнец\,\ Бургас",
"3597448", "Бачево",
"3597155", "Лесново",
"3597129", "Радуил",
"3597924", "Шишковци",
"35984394", "Духовец",
"3598125", "Копривец",
"35984744", "Беловец",
"3595734", "Преселенци",
"3593772", "Момково",
"3598159", "Кошов",
"3595739", "Пчеларово\,\ Добр\.",
"3594157", "Разделна\,\ Ст\.\ Загора",
"3595774", "Коритен",
"3599332", "Раковица",
"3599125", "Горна\ Бешовица",
"3597929", "Соволяно",
"3596540", "Асеново\,\ Плевен",
"35961101", "Велчево\,\ В\.\ Търново",
"3599329", "Рабиша",
"3593729", "Криво\ поле",
"35984393", "Вазово",
"3595551", "Средец\,\ Бургас",
"3594327", "Шейново",
"3593755", "Белица\,\ Хаск\.",
"35984743", "Брестовене",
"3597932", "Шипочано",
"3599355", "Косово\,\ Видин",
"3596710", "Донино",
"3599324", "Ружинци",
"3593724", "Сусам",
"35968", "Ловеч",
"35974388", "Горно\ Спанчево",
"359750", "Боровец\,\ София",
"3595526", "Кликач",
"3595368", "Тъкач",
"3593027", "Славейно",
"35984710", "Осенец",
"3593691", "Черноочeне",
"3596006", "Пресиян",
"359318", "Съединение\,\ Пловдив",
"35969249", "Дойренци",
"3596723", "Царева\ ливада",
"35951125", "Константиново\,\ Варна",
"3593536", "Баня\,\ Пазарджик",
"3599123", "Роман",
"3593700", "Тракиец",
"3598669", "Гарван\,\ Силистра",
"3598664", "Поляна\,\ Силистра",
"3598123", "Босилковци",
"3593042", "Борино",
"359724", "Ихтиман",
"35960370", "Голямо\ градище",
"3599353", "Кошава",
"3593753", "Оряхово\,\ Хаск\.",
"35931791", "Бегово",
"3595755", "Коларци",
"3597939", "Църварица",
"3599135", "Бърдарски\ геран",
"3599322", "Орешец\,\ Видин",
"3593722", "Минерални\ бани\,\ Хаск\.",
"3595724", "Дропла\,\ Добр\.",
"3599175", "Остров",
"3597934", "Буново\,\ Кюст\.",
"3598135", "Бабово",
"35984723", "Дянково",
"359339", "Стамболийски\,\ Пловдив",
"3598152", "Красен\,\ Русе",
"3595772", "Телериг",
"3593779", "Сива\ река",
"35941270", "Малка\ Верея",
"3593708", "Орлово\,\ Хаск\.",
"3597922", "Драговищица\,\ Кюст\.",
"3594337", "Ясеново\,\ Ст\.\ Загора",
"35942", "Стара\ Загора",
"35967397", "Ряховците",
"3595732", "Петлешково",
"3597147", "Пчелин\,\ София",
"3599339", "Макреш",
"3593774", "Левка",
"3593517", "Лесичово",
"3596521", "Садовец",
"35961706", "Писарево\,\ В\.\ Търново",
"3596043", "Долно\ Новково",
"35961306", "Патреш",
"3594145", "Знаменосец",
"3593588", "Мененкьово",
"3593628", "Миладиново",
"3593747", "Татарево\,\ Хаск\.",
"3597139", "Джурово",
"3597174", "Калотина",
"3599347", "Бела\ Рада",
"359619", "Лясковец\,\ В\.\ Търново",
"35977221", "Кондофрей",
"35941338", "Целина",
"3594344", "Шаново",
"3597134", "Врачеш",
"3597179", "Големо\ Малово",
"3596590", "Ракита\,\ Плевен",
"3598622", "Алеково\,\ Силистра",
"35974406", "Добърско",
"359601", "Търговище",
"3595313", "Мадара",
"3598634", "Нова\ Черна",
"3598679", "Кайнарджа",
"35931993", "Сърнегор",
"35991186", "Баурене",
"3598639", "Коларово\,\ Силистра",
"3596128", "Хотница",
"3598674", "Професор\ Иширково",
"35971225", "Ново\ село\,\ София",
"3599728", "Сливата",
"3593566", "Бошуля",
"3593328", "Долнослав",
"3595105", "Приселци\,\ Варна",
"3596928", "Къкрина",
"3594523", "Стоил\ войвода",
"35984765", "Веселина",
"3594798", "Савино",
"3598647", "Паисиево",
"3596902", "Рибарица\,\ Ловеч",
"3595338", "Троица",
"35930412", "Девин",
"3593146", "Куртово\ Конаре",
"3597164", "Реброво",
"35984266", "Просторно",
"3595330", "Златар",
"3597719", "Ярджиловци",
"3596115", "Ресен",
"3597714", "Мещица",
"35991201", "Люти\ брод",
"35993212", "Карбинци",
"3596991", "Ябланица",
"3597169", "Томпсън",
"35961606", "Владислав",
"3597549", "Долен\,\ Благ\.",
"3594552", "Стара\ река\,\ Сливен",
"3596920", "Лесидрен",
"3595912", "Полски\ извор",
"3597544", "Осина",
"3593103", "Милево",
"3593320", "Орешец\,\ Пловдив",
"35931700", "Беловица",
"3599720", "Ковачица",
"3595341", "Хитрино",
"3599545", "Габровница",
"3593769", "Орешец\,\ Хаск\.",
"3595762", "Стефан\ Караджа\,\ Добр\.",
"3594367", "Тъжа",
"3593114", "Брестник",
"35941116", "Сладък\ Кладенец",
"3595112", "Белослав",
"3593119", "Гълъбово\,\ Пловдив",
"3593764", "Поляново\,\ Хаск\.",
"3598165", "Смирненски\,\ Русе",
"3599165", "Софрониево",
"3596915", "Смочан",
"3597054", "Рила",
"3594753", "Зорница\,\ Ямбол",
"35931108", "Богданица",
"3599546", "Славотин",
"3599558", "Гаврил\ Геново",
"3593193", "Борец",
"3599166", "Хайредин",
"3596916", "Брестово\,\ Ловеч",
"3593667", "Покрован",
"35953437", "Габрица\,\ Шумен",
"3598166", "Сваленик",
"3595943", "Вресово",
"3596901", "Гложене\,\ Ловеч",
"3596116", "Големаните",
"359418", "Гълъбово\,\ Ст\.\ Загора",
"35931258", "Главатар",
"35931704", "Иван\ Вазово",
"35981266", "Стърмен\,\ Русе",
"3598621", "Силистра",
"3595143", "Бяла\,\ Варна",
"3594580", "Боринци",
"35941145", "Арнаутито",
"3598690", "Силистра",
"35931703", "Житница\,\ Пловдив",
"35969248", "Скобелево\,\ Ловеч",
"3597528", "Хаджидимово",
"35984736", "Подайва",
"3597520", "Корница",
"359675", "Севлиево",
"3599744", "Вълчедръм",
"3593344", "Новаково\,\ Пловдив",
"3599749", "Черни\ връх\,\ Монт\.",
"3595761", "Батово",
"3593349", "Боянци",
"3595342", "Капитан\ Петко",
"3596944", "Крушуна",
"3598698", "Шуменци",
"3594747", "Денница\,\ Ямбол",
"3595106", "Аврен\,\ Варна",
"3596177", "Янтра\,\ В\.\ Търново",
"3596983", "Дерманци",
"3593145", "Кричим",
"3594588", "Филаретово",
"3599514", "Владимирово\,\ Монт\.",
"3599783", "Брусарци",
"3594517", "Ичера",
"35941339", "Димитриево",
"3596137", "Бутово",
"3595394", "Бяла\ река\,\ Шумен",
"3594739", "Радовец",
"3594774", "Крумово\,\ Ямбол",
"35932", "Пловдив",
"3596564", "Загражден\,\ Плевен",
"3596992", "Златна\ Панега",
"3597033", "Крайници",
"3596569", "Ленково",
"3594734", "Срем",
"3596937", "Соколово\,\ Ловеч",
"35930415", "Девин",
"3594779", "Ханово",
"35993342", "Киреево",
"3599550", "Митровци",
"3596149", "Куцина",
"35935256", "Сбор\,\ Пазарджик",
"3594722", "Гранитово\,\ Ямбол",
"359915", "Бяла\ Слатина",
"3594551", "Бяла\,\ Сливен",
"3595327", "Каспичан\,\ Шумен",
"3597745", "Егълница",
"3596144", "Долна\ Липница",
"3595573", "Везенково",
"3594158", "Искрица",
"35931603", "Виница",
"3594146", "Диня",
"3597422", "Тополница\,\ Благ\.",
"3593644", "Егрек",
"3595533", "Пирне",
"3597434", "Струмяни",
"3593523", "Синитево",
"3596736", "Градница\,\ Габр\.",
"35931604", "Драгойново",
"3594566", "Питово",
"3597439", "Плоски",
"3599180", "Голямо\ Пещене",
"3599176", "Лесковец\,\ Враца",
"35984720", "Топчии",
"3593677", "Дрангово\,\ Кърдж\.",
"3598136", "Стамболово\,\ Русе",
"359610", "Павликени\,\ В\.\ Търново",
"3595756", "Божан",
"3593637", "Груево",
"3599136", "Галиче",
"35941274", "Самуилово\,\ Ст\.\ Загора",
"3595748", "Дуранкулак",
"3598475", "Лозница\,\ Разград",
"3597447", "Добринище",
"3596553", "Оряховица\,\ Плевен",
"3593030", "Широка\ лъка",
"3595518", "Рудник\,\ Бургас",
"3593038", "Чокманово",
"35960387", "Глогинка",
"35960374", "Горско\ Абланово",
"35963576", "Тученица",
"3596522", "Згалево",
"3595740", "Горичане",
"3599117", "Криводол",
"3594764", "Маленово",
"3596967", "Калейца",
"3596539", "Градище\,\ Плевен",
"3596574", "Чомаковци",
"3598117", "Мартен",
"3596534", "Малчика",
"3596579", "Рупци\,\ Плевен",
"3599188", "Горно\ Пещене",
"35960373", "Посабина",
"3596167", "Кесарево",
"3594103", "Бял\ извор\,\ Ст\.\ Загора",
"35984713", "Благоево\,\ Разград",
"3595554", "Момина\ църква",
"3596717", "Лесичарка",
"3593552", "Брацигово",
"3595559", "Кубадин",
"3595525", "Деветак",
"3593721", "Стамболово\,\ Хаск\.",
"3597921", "Жиленци",
"3593535", "Левски\,\ Пазарджик",
"3595731", "Генерал\ Тошево\,\ Добр\.",
"3598151", "Просена",
"3595771", "Крушари",
"3596547", "Драгаш\ войвода",
"3599126", "Камено\ поле",
"3593587", "Сестримо",
"3593518", "Драгор",
"35957308", "Чернооково\,\ Добр\.",
"3593020", "Давидково",
"3593699", "Габрово\,\ Кърдж\.",
"35963575", "Бохот",
"3599348", "Неговановци",
"35984740", "Бисерци",
"3593748", "Лясковец\,\ Хаск\.",
"3593756", "Вълче\ поле",
"3599356", "Каленик\,\ Видин",
"35941178", "Оряховица\,\ Ст\.\ Загора",
"3595523", "Крумово\ градище",
"35967393", "Душево",
"3596003", "Преселец",
"3594105", "Бяло\ поле",
"3594338", "Крън",
"3597156", "Равно\ поле",
"3593642", "Поточница",
"3593707", "Николово\,\ Хаск\.",
"3597148", "Мухово",
"35963561", "Гривица",
"3596726", "Скалско",
"3598661", "Тутракан",
"3593533", "Бъта",
"3597424", "Кърналово",
"35967394", "Богатово",
"35984727", "Каменово\,\ Разград",
"3595535", "Лясково\,\ Бургас",
"35976", "Перник",
"359631", "Свищов",
"3595575", "Прилеп\,\ Бургас",
"3596046", "Врани\ кон",
"359391", "Димитровград",
"3594330", "Николаево\,\ Ст\.\ Загора",
"3593554", "Козарско",
"35960380", "Дриново",
"3593559", "Капитан\ Димитриево",
"3595552", "Дюлево\,\ Бургас",
"3596532", "Българене\,\ Плевен",
"3594112", "Бъдеще",
"3593740", "Пчелари",
"3599340", "Септемврийци\,\ Видин",
"3594341", "Черганово",
"35961302", "Батак\,\ В\.\ Търново",
"3594762", "Воденичане",
"3595367", "Тодор\ Икономово",
"3593028", "Арда",
"3596572", "Сухаче",
"359720", "Етрополе",
"3593510", "Овчеполци",
"35931401", "Кадиево",
"359936", "Белоградчик",
"3596524", "Петърница",
"3596529", "Коиловци",
"3596555", "Байкал",
"359309", "Пампорово",
"35974402", "Годлево",
"3598631", "Силистра",
"3593563", "Варвара\,\ Пазарджик",
"3598671", "Силистра",
"35973", "Благоевград",
"3594526", "Млекарево",
"3594368", "Търничени",
"35936702", "Горски\ извор\,\ Кърдж\.",
"35941359", "Изворово\,\ Ст\.\ Загора",
"35984735", "Свещари",
"3599785", "Василовци\,\ Монт\.",
"35991182", "Осен\,\ Враца",
"3596985", "Румянцево",
"3593143", "Перущица",
"3598640", "Правда\,\ Силистра",
"3597035", "Червен\ брег",
"35963203", "Хаджидимитрово\,\ В\.\ Търново",
"35935255", "Росен\,\ Пазарджик",
"3595316", "Салманово",
"35974346", "Цапарево",
"3597743", "Дивля",
"35961503", "Чакали",
"35984469", "Божурово\,\ Разград",
"3597052", "Пастра",
"35930416", "Гьоврен",
"35951108", "Изворско",
"35963204", "Деляновци",
"3596927", "Умаревци",
"3594724", "Раздел\,\ Ямбол",
"3593195", "Розовец",
"3596142", "Обединение",
"3593327", "Бачково",
"3594755", "Тамарино",
"3597541", "Сатовча",
"359373", "Харманли",
"3599727", "Медковец",
"3594729", "Кирилово\,\ Ямбол",
"35952", "Варна",
"3595337", "Кочово",
"3593157", "Болярино",
"3594732", "Устрем",
"3595945", "Добромир",
"35961602", "Царски\ извор",
"3597711", "Кладница",
"3595392", "Менгишево",
"3594772", "Симеоново\,\ Ямбол",
"3596562", "Гиген",
"3598648", "Секулово",
"35974325", "Лиляново",
"3596994", "Брестница\,\ Ловеч",
"3594797", "Гълъбинци",
"3595145", "Гроздьово",
"35931997", "Златосел",
"35930205", "Стърница",
"35941112", "Старозагорски\ бани",
"3599512", "Бели\ брег",
"359608", "Попово\,\ Търг\.",
"3595344", "Велино",
"3593111", "Първенец\,\ Пловдив",
"3596942", "Александрово\,\ Ловеч",
"35981886", "Черешово\,\ Русе",
"35941146", "Християново",
"3593106", "Строево",
"3599742", "Якимово",
"3593342", "Нареченски\ бани",
"3595349", "Студеница",
"35941117", "Казанка",
"359728", "Златица",
"3598124", "Новград",
"3597925", "Гюешево",
"3598663", "Ситово\,\ Силистра",
"3595590", "Житосвят",
"3595735", "Красен\,\ Добр\.",
"3599129", "Синьо\ бърдо",
"3595775", "Полковник\ Дяково",
"3598448", "Тертер",
"3599124", "Типченица",
"359519", "Девня",
"3598129", "Лом\ Черковна",
"35931992", "Пъдарско",
"35969241", "Йоглав",
"3593696", "Пчеларово\,\ Кърдж\.",
"35984760", "Трапище",
"3599172", "Селановци",
"3593754", "Лозен\,\ Хаск\.",
"3598132", "Юделник",
"3599354", "Антимово\,\ Видин",
"35953221", "Стоян\ Михайловски",
"359751", "Гоце\ Делчев",
"3596001", "Черковна\,\ Търг\.",
"3595752", "Нова\ Камена",
"3593759", "Бориславци",
"3599325", "Бело\ поле\,\ Видин",
"3599132", "Кнежа",
"3597110", "Опицвет",
"3593725", "Стамболийски\,\ Хаск\.",
"3594357", "Горно\ Сахране",
"3595521", "Венец\,\ Бургас",
"35930413", "Девин",
"3596732", "Сенник",
"3594562", "Крива\ круша",
"3597910", "Берсин",
"3596724", "Янтра\,\ Габр\.",
"3597125", "Говедарци",
"3593710", "Узунджово",
"3597426", "Марикостиново",
"3597159", "Априлово\,\ София",
"3594142", "Трояново\,\ Ст\.\ Загора",
"35930414", "Девин",
"3597154", "Столник",
"35961607", "Балканци\,\ В\.\ Търново",
"35971220", "Гуцал",
"3593787", "Тянево\,\ Хаск\.",
"3593168", "Езерово\,\ Пловдив",
"3596044", "Долно\ Козарево",
"3596049", "Камбурово",
"3593718", "Войводово\,\ Хаск\.",
"3599318", "Буковец\,\ Видин",
"3598431", "Исперих",
"3597918", "Ябълково\,\ Кюст\.",
"3597133", "Правец",
"3594343", "Конаре\,\ Ст\.\ Загора",
"359538", "Велики\ Преслав",
"3593556", "Радилово",
"3593548", "Пашово",
"3597933", "Грамаждано",
"3597118", "Драговищица\,\ София",
"3595723", "Гурково\,\ Добр\.",
"3596077", "Стеврек",
"3593045", "Доспат",
"35974407", "Кремен\,\ Благ\.",
"3597187", "Буново\,\ София",
"359702", "Бобов\ дол",
"3593773", "Капитан\ Андреево",
"35977229", "Гълъбник",
"35941144", "Калояновец",
"35958", "Добрич",
"3599333", "Бойница",
"3596526", "Върбица\,\ Плевен",
"35931705", "Горна\ махала",
"3595915", "Българово",
"35961307", "Стамболово\,\ В\.\ Търново",
"359357", "Панагюрище",
"3594524", "Каменово\,\ Сливен",
"3593130", "Каравелово\,\ Пловдив",
"3594529", "Съдиево\,\ Сливен",
"3599527", "Вършец",
"3597741", "Земен",
"35984779", "Здравец\,\ Разград",
"3596112", "Самоводене",
"35960375", "Гърчиново",
"35937701", "Сладун",
"3594597", "Боров\ дол",
"3595120", "Бозвелийско",
"3596912", "Баховица",
"3599162", "Михайлово\,\ Враца",
"3595314", "Белокопитово",
"3595319", "Друмево",
"3595115", "Генерал\ Кантарджиево",
"35967396", "Бериево",
"3598673", "Алфатар",
"359431", "Казанлък",
"3598633", "Старо\ село\,\ Силистра",
"3599542", "Смоляновци",
"3593561", "Септември",
"3595765", "Ловчанци",
"35965617", "Искър\,\ Плевен",
"3593763", "Българин",
"3593113", "Браниполе",
"3594726", "Маломирово",
"35931605", "Буково\,\ Пловдив",
"35984722", "Ясеновец",
"35959408", "Ръжица",
"3596067", "Кралево\,\ Търг\.",
"3598625", "Овен",
"3595128", "Житница\,\ Варна",
"3597713", "Рударци",
"3597163", "Искрец",
"3596905", "Дивчовото",
"3593104", "Ягодово\,\ Пловдив",
"3593178", "Красново",
"35941275", "Лясково\,\ Ст\.\ Загора",
"3595346", "Каменяк\,\ Шумен",
"3593138", "Ведраре",
"3595102", "Падина\,\ Варна",
"3593109", "Лилково",
"3599544", "Студено\ буче",
"3597720", "Прибой",
"3593115", "Куклен",
"3597056", "Мурсалево",
"35941171", "Дълбоки",
"3597048", "Блажиево",
"3596150", "Златарица",
"3599549", "Долна\ Рикса",
"3593765", "Иваново\,\ Хаск\.",
"3598164", "Писанец",
"3598623", "Голеш\,\ Силистра",
"3596919", "Слатина\,\ Ловеч",
"3595141", "Старо\ Оряхово",
"3599169", "Рогозен",
"3593920", "Златополе",
"3594717", "Чарган",
"3599164", "Крушовица\,\ Враца",
"35931606", "Воден\,\ Пловдив",
"3596914", "Сливек",
"3595312", "Дибич",
"3599719", "Аспарухово\,\ Монт\.",
"35963568", "Буковлък",
"35951127", "Разделна\,\ Варна",
"35941276", "Могила\,\ Ст\.\ Загора",
"3597165", "Миланово\,\ София",
"3595941", "Скалак\,\ Бургас",
"3596119", "Дичин",
"3596114", "Килифарево",
"3597715", "Студена\,\ Перник",
"3593120", "Храбрино",
"35960382", "Ковачевец",
"3595130", "Генерал\ Киселово",
"3593191", "Брезово\,\ Пловдив",
"35935392", "Дюлево\,\ Пазарджик",
"35941489", "Боздуганово",
"3594751", "Войника",
"3597545", "Кочан",
"3594522", "Кортен",
"3596950", "Гумощник",
"3594553", "Раково\,\ Сливен",
"35963574", "Тодорово\,\ Плевен",
"3596958", "Априлци\,\ Ловеч",
"3596946", "Чавдарци",
"359301", "Смолян",
"35960376", "Люблен",
"35930456", "Чавдар\,\ Смол\.",
"3593102", "Караджово",
"359745", "Петрич\,\ Благ\.",
"3599746", "Разград\,\ Монт\.",
"3593346", "Мулдава",
"3595138", "Добротич",
"3595913", "Крушевец",
"35963573", "Дисевица",
"35967309", "Агатово",
"3593128", "Златитрап",
"35981461", "Каран\ Върбовка",
"3597031", "Горна\ Козница",
"3599516", "Лехчево",
"3594736", "Светлина",
"35967395", "Горна\ Росица",
"3593928", "Долно\ Белево",
"3595396", "Ловец\,\ Шумен",
"3596328", "Ореш",
"3596981", "Петревене",
"3596566", "Долни\ Вит",
"35984392", "Белинци",
"3596158", "Средни\ колиби",
"3598635", "Цар\ Самуил",
"3595763", "Плачидол",
"3596146", "Полски\ Сеновец",
"3597728", "Друган",
"3598675", "Айдемир",
"3597152", "Горна\ Малина",
"35961391", "Сломер",
"3594149", "Трънково\,\ Ст\.\ Загора",
"3593646", "Токачка",
"3599147", "Борован",
"3593658", "Падина\,\ Кърдж\.",
"359556", "Обзор",
"35974324", "Струма",
"3595710", "Победа\,\ Добр\.",
"3596722", "Соколово\,\ Габр\.",
"3594144", "Ковачево\,\ Ст\.\ Загора",
"3598147", "Баниска",
"3596551", "Тръстеник\,\ Плевен",
"35951539", "Левски\,\ Варна",
"3597175", "Габер",
"35974323", "Лозеница",
"3594564", "Новоселец",
"3597436", "Левуново",
"3594345", "Радунци",
"35941110", "Старозагорски\ бани",
"3597135", "Трудовец",
"3599567", "Долна\ Вереница",
"3596734", "Петко\ Славейков",
"3596588", "Деков",
"3595754", "Зърнево",
"35971227", "Бели\ Искър",
"3599134", "Търнак",
"35981264", "Пиперково",
"3593043", "Змеица",
"3599139", "Търнава\,\ Враца",
"3593521", "Звъничево",
"35931706", "Сухозем",
"3599174", "Горни\ Вадин",
"3595759", "Кочмар",
"3593752", "Малко\ градище",
"35995276", "Драганица",
"3594137", "Верен",
"3598134", "Малко\ Враново",
"3599352", "Дружба",
"3597935", "Долно\ село",
"35930528", "Манастир\,\ Пловдив",
"3596517", "Подем",
"3599122", "Зверино",
"3599335", "Цар\ Петрово",
"3598122", "Ценово\,\ Русе",
"3595571", "Сунгурларе",
"3593775", "Генералово",
"3595968", "Каблешково\,\ Бургас",
"3595773", "Лозенец\,\ Добр\.",
"3596027", "Дралфа",
"3598665", "Искра\,\ Силистра",
"3595733", "Кардам\,\ Добр\.",
"35984734", "Тодорово\,\ Разград",
"35938", "Хасково",
"3597923", "Вратца",
"359707", "Сапарева\ баня",
"3596536", "Аспарухово\,\ Плевен",
"3599323", "Дреновец",
"3594116", "Ракитница\,\ Ст\.\ Загора",
"359618", "Горна\ Оряховица",
"35984733", "Лудогорци",
"3594101", "Опан",
"3596580", "Татари",
"3596576", "Радомирци",
"35935418", "Кръстава",
"35961109", "Въглевци",
"35936700", "Шопци",
"35963205", "Червена",
"35991180", "Лесура",
"3593057", "Пловдивци",
"3595556", "Голямо\ Буково",
"3595168", "Петров\ дол\,\ Варна",
"35960450", "Долна\ Хубавка",
"35935254", "Добровница",
"3595718", "Смолница",
"3597123", "Ковачевци\,\ София",
"3596042", "Илийно",
"35991183", "Фурен",
"3595529", "Крушово\,\ Бургас",
"3593522", "Гелеменово",
"35969032", "Български\ извор",
"3597188", "Петрич\,\ София",
"35947201", "Изгрев\,\ Ямбол",
"3596004", "Маково",
"3599351", "Извор\,\ Видин",
"3595555", "Факия",
"3593751", "Любимец",
"35960454", "Змейно",
"3597117", "Градец\,\ София",
"35974404", "Бабяк",
"3594350", "Горно\ Изворово",
"3595524", "Екзарх\ Антимово",
"35931996", "Свежен",
"3597423", "Коларово\,\ Благ\.",
"35991184", "Ракево",
"3595572", "Бероново",
"3593534", "Попинци",
"3599121", "Царевец\,\ Враца",
"3595532", "Тополица",
"35974403", "Долно\ Драглище",
"35960453", "Моравка",
"3598666", "Тутракан",
"3596552", "Долна\ Митрополия",
"3599317", "Арчар",
"3593717", "Конуш\,\ Хаск\.",
"35953435", "Изгрев\,\ Шумен",
"35961502", "Горско\ Ново\ Село",
"3593167", "Брягово\,\ Пловдив",
"35963202", "Драгомирово\,\ В\.\ Търново",
"35984730", "Голям\ Поровец",
"3593547", "Сърница\,\ Пазарджик",
"3596575", "Телиш",
"3593693", "Лясково\,\ Кърдж\.",
"3597917", "Таваличево",
"3596535", "Козар\ Белене",
"35963569", "Каменец\,\ Плевен",
"3594115", "Кирилово\,\ Ст\.\ Загора",
"3595726", "Царичино",
"35930200", "Загражден\,\ Смол\.",
"3597936", "Слокощица",
"359865", "Силистра",
"35961603", "Лозен\,\ В\.\ Търново",
"35930417", "Грохотно",
"3593776", "Райкова\ могила",
"3596523", "Крушовица\,\ Плевен",
"35961604", "Мирово\,\ В\.\ Търново",
"35974347", "Раздол",
"3599336", "Старопатица",
"35941114", "Лозен\,\ Ст\.\ Загора",
"359721", "Костинброд",
"3593645", "Аврен\,\ Кърдж\.",
"35941113", "Пряпорец\,\ Ст\.\ Загора",
"35967308", "Ловнидол",
"3596030", "Светлен\,\ Търг\.",
"3594346", "Голямо\ Дряново",
"3597435", "Склаве",
"3594358", "Скобелево\,\ Ст\.\ Загора",
"3597136", "Новачене\,\ София",
"3594102", "Ястребово\,\ Ст\.\ Загора",
"3597176", "Храбърско",
"3593553", "Батак\,\ Пазарджик",
"3595395", "Чернооково\,\ Шумен",
"3594775", "Каравелово\,\ Ямбол",
"3596565", "Милковица",
"3595127", "Манастир\,\ Варна",
"3595942", "Люляково\,\ Бургас",
"3593137", "Клисура\,\ Пловдив",
"3594752", "Първенец\,\ Ямбол",
"3598676", "Ветрен\,\ Силистра",
"35935501", "Равногор",
"3599520", "Горно\ Озирово",
"3593192", "Бабек",
"3598636", "Главиница\,\ Силистра",
"3597744", "Еловдол\,\ Перник",
"3593177", "Ново\ Железаре",
"35941351", "Партизанин",
"3596145", "Страхилово",
"3593937", "Ябълково\,\ Хаск\.",
"3593569", "Карабунар",
"3599745", "Златия\,\ Монт\.",
"3593345", "Лясково\,\ Пловдив",
"35962", "Велико\ Търново",
"3593564", "Семчиново",
"35967392", "Яворец",
"3596068", "Божурка",
"35951538", "Изгрев\,\ Варна",
"3599515", "Мадан\,\ Монт\.",
"3595311", "Градище\,\ Шумен",
"35963570", "Староселци",
"35984745", "Владимировци",
"3595142", "Долни\ чифлик",
"3593149", "Цалапица",
"35961108", "Плаково",
"3596982", "Ъглен",
"3597166", "Владо\ Тричков",
"3596060", "Овчарово\,\ Търг\.",
"3599782", "Буковец\,\ Монт\.",
"3597546", "Слащен",
"35984726", "Ушинци",
"3595343", "Венец\,\ Шумен",
"3593101", "Войводиново",
"3593766", "Бисер",
"3599528", "Гаганица",
"35961304", "Димча",
"35961704", "Правда\,\ В\.\ Търново",
"3594723", "Бояново\,\ Ямбол",
"3593116", "Крумово\,\ Пловдив",
"35961303", "Горна\ Липница",
"35960385", "Ломци",
"35935419", "Света\ Петка",
"35974201", "Капатово",
"3597032", "Яхиново",
"35961703", "Върбица\,\ В\.\ Търново",
"35984725", "Киченица",
"3598161", "Ветово",
"3595144", "Камчия",
"3596327", "Овча\ могила",
"3596906", "Черни\ Вит",
"3595149", "Голица",
"3599161", "Мизия",
"3593142", "Брестовица\,\ Пловдив",
"3596911", "Лисец\,\ Ловеч",
"359677", "Трявна",
"3593927", "Черногорово\,\ Хаск\.",
"3594710", "Болярско",
"3593562", "Славовица\,\ Пазарджик",
"3599541", "Доктор\ Йосифово",
"3595345", "Развигорово",
"3597727", "Ковачевци\,\ Перник",
"35931602", "Татарево\,\ Пловдив",
"3596157", "Сливовица",
"35937421", "Долно\ поле",
"359308", "Мадан\,\ Смол\.",
"3594725", "Лесово",
"3593194", "Зелениково\,\ Пловдив",
"35963577", "Пелишат",
"3597742", "Калище",
"3595137", "Калоян",
"3594754", "Каменец\,\ Ямбол",
"3596957", "Голяма\ Желязна",
"35960386", "Водица\,\ Търг\.",
"3597053", "Кочериново",
"3598626", "Средище\,\ Силистра",
"3595944", "Руен\,\ Бургас",
"3596111", "Къпиново\,\ В\.\ Търново",
"359817", "Бяла\,\ Русе",
"3595949", "Планиница\,\ Бургас",
"3593127", "Царацово",
"3594733", "Орлов\ дол",
"3597034", "Джерман",
"35960372", "Крепча",
"359361", "Кърджали",
"3597039", "Самораново",
"3596563", "Брест\,\ Плевен",
"35936401", "Странджево",
"3594773", "Окоп",
"3595393", "Иваново\,\ Шумен",
"35941331", "Гранит",
"3596143", "Масларево",
"3595766", "Методиево\,\ Добр\.",
"3595101", "Дъбравино",
"3595116", "Крумово\,\ Варна",
"35961203", "Емен",
"3596943", "Горско\ Сливово",
"3597047", "Усойка",
"3594556", "Сотиря",
"35931398", "Слатина\,\ Пловдив",
"3593343", "Козаново",
"3595916", "Росен\,\ Бургас",
"3594718", "Роза",
"3596989", "Торос",
"3599784", "Киселево",
"3599513", "Бойчиновци",
"3596984", "Бежаново\,\ Ловеч",
"35984712", "Костанденец",
"3593046", "Барутин",
"3593058", "Мугла",
"3599560", "Безденица",
"359971", "Лом",
"359331", "Асеновград",
"3596559", "Гостиля",
"3599140", "Габаре",
"35935257", "Сарая",
"3595717", "Ведрина",
"3596525", "Бъркач",
"3595167", "Венчан",
"3598140", "Борово\,\ Русе",
"3596554", "Крушовене",
"35996", "Монтана",
"3595579", "Ведрово",
"3595534", "Карагеоргиево",
"3596028", "Вардун",
"3593643", "Голяма\ Чинка",
"35984737", "Райнино",
"35931702", "Долна\ махала\,\ Пловдив",
"3595967", "Бата",
"3595574", "Съединение\,\ Бургас",
"35947356", "Мрамор\,\ Ямбол",
"3595539", "Черноград",
"3593532", "Стрелча",
"359453", "Котел",
"3593555", "Нова\ махала\,\ Пазарджик",
"3595751", "Тервел\,\ Добр\.",
"35984778", "Богданци\,\ Разград",
"3593529", "Мокрище",
"3595522", "Искра\,\ Бургас",
"3599131", "Добролево",
"3594130", "Спасово\,\ Ст\.\ Загора",
"3593524", "Априлци\,\ Пазарджик",
"3599171", "Оряхово\,\ Враца",
"3596510", "Тотлебен",
"359676", "Дряново\,\ Габр\.",
"3596002", "Съединение\,\ Търг\.",
"3598131", "Борисово\,\ Русе",
"3597433", "Кресна",
"359457", "Нова\ Загора",
"3594109", "Тракия",
"3596518", "Рибен",
"3594138", "Гита",
"35971224", "Шипочане",
"3595553", "Орлинци",
"3596587", "Петокладенци",
"35930410", "Брезе\,\ Смол\.",
"3594104", "Кравино",
"3593019", "Писаница",
"3597126", "Горни\ Окол",
"35931995", "Стрелци\,\ Пловдив",
"3597425", "Кулата",
"3596020", "Лиляк",
"3598156", "Червен\,\ Русе",
"3595776", "Черна\,\ Добр\.",
"35974327", "Ново\ Делчево",
"3598148", "Горно\ Абланово",
"3597926", "Коняво",
"35984764", "Сейдол",
"3595736", "Василево",
"3593657", "Жълтуша",
"3599148", "Бъркачево",
"359590", "Царево",
"3598424", "Цар\ Калоян\,\ Разград",
"3599326", "Горни\ Лом",
"3594113", "Преславен",
"3593726", "Клокотница",
"3599568", "Благово\,\ Монт\.",
"3596533", "Стежерово",
"3596573", "Койнаре",
"3593050", "Букова\ поляна",
"3593695", "Комунига",
"3594763", "Иречеково",
"35953436", "Черноглавци",
"35959409", "Череша",
"35984763", "Бели\ Лом",
"3593052", "Лъки\,\ Пловдив",
"3599185", "Бели\ Извор",
"359725", "Елин\ Пелин",
"3599343", "Гомотарци",
"3598185", "Сеново",
"35957304", "Дъбовик",
"35967193", "Кметовци",
"3593743", "Силен",
"3593784", "Константиново\,\ Хаск\.",
"3596047", "Зелена\ морава",
"3593075", "Долен\,\ Смол\.",
"35967194", "Гръблевци",
"3593035", "Върбина",
"35941337", "Сърневец",
"3595782", "Бенковски\,\ Добр\.",
"3593513", "Мало\ Конаре",
"3596022", "Пробуда\,\ Търг\.",
"3597143", "Вакарел",
"3594333", "Дъбово\,\ Ст\.\ Загора",
"35941174", "Подслон\,\ Ст\.\ Загора",
"359861", "Силистра",
"3593538", "Елшица",
"35941173", "Братя\ Кунчеви",
"3597189", "Чавдар\,\ София",
"35951429", "Солник",
"3595366", "Браничево",
"3596034", "Славяново\,\ Търг\.",
"3595528", "Невестино\,\ Бургас",
"3596074", "Любичево",
"35967398", "Дамяново",
"3596039", "Опака",
"3597184", "Копривщица",
"35963565", "Мечка\,\ Плевен",
"3594359", "Асен\,\ Ст\.\ Загора",
"3594132", "Оризово",
"3593757", "Георги\ Добрево",
"3594325", "Кънчево",
"3596512", "Горни\ Дъбник",
"3597106", "Ямна",
"35941350", "Мирово\,\ Ст\.\ Загора",
"3595520", "Черково",
"3598194", "Сандрово",
"3594354", "Зимница\,\ Ст\.\ Загора",
"35961102", "Пчелище",
"3598127", "Караманово",
"3594124", "Змейово",
"35959406", "Разбойна\,\ Бургас",
"3593530", "Поибрене",
"3594155", "Главан\,\ Ст\.\ Загора",
"3599127", "Лютидол",
"3593586", "Боримечково",
"3593626", "Перперек",
"3594129", "Маджерито",
"3596727", "Ганчовец",
"3595515", "Камено",
"3593711", "Долно\ Ботево",
"3598142", "Бъзовец\,\ Русе",
"3599311", "Кутово",
"3597157", "Саранци",
"3593706", "Тънково\,\ Хаск\.",
"3599142", "Лазарово",
"35981463", "Могилино",
"35963571", "Брестовец",
"3595745", "Вранино",
"35941018", "Княжевско",
"3593023", "Момчиловци",
"359777", "Радомир",
"3597911", "Граница",
"35981464", "Острица\,\ Русе",
"35960389", "Кардам\,\ Търг\.",
"3597533", "Осиково\,\ Благ\.",
"3596069", "Васил\ Левски\,\ Търг\.",
"3594796", "Генерал\ Тошево\,\ Ямбол",
"3594585", "Жеравна",
"3596064", "Голямо\ Ново",
"3593148", "Йоаким\ Груево",
"3595336", "Имренчево",
"3593156", "Шишманци",
"3593326", "Патриарх\ Евтимово",
"3599726", "Замфир",
"3593568", "Виноградец",
"35930256", "Гълъбово\,\ Смол\.",
"3598695", "Ножарево",
"3596926", "Горно\ Павликене",
"3594363", "Габарево",
"3593107", "Граф\ Игнатиево",
"35974321", "Хърсово\,\ Благ\.",
"3596126", "Церова\ кория",
"35951103", "Любен\ Каравелово",
"35961394", "Дъскот",
"35961393", "Горско\ Косово",
"35951104", "Долище\,\ Варна",
"35975214", "Гайтаниново",
"35984749", "Севар",
"3594599", "Червенаково",
"3595121", "Тутраканци",
"3598643", "Златоклас",
"3599529", "Боровци",
"3595351", "Смядово",
"3594527", "Загорци\,\ Сливен",
"3599555", "Копиловци\,\ Монт\.",
"35935251", "Братаница",
"359559", "Карнобат",
"3599524", "Ягодово\,\ Монт\.",
"3593931", "Каснаково",
"3597525", "Баничан",
"3594712", "Кабиле",
"3595317", "Ивански",
"35967302", "Кръвеник",
"3597731", "Трън",
"3597030", "Ресилово",
"3594516", "Кермен",
"3598645", "Межден",
"3596136", "Сухиндол",
"35937604", "Върбово\,\ Хаск\.",
"3596176", "Поликраище",
"359910", "Мездра",
"3595948", "Снягово\,\ Бургас",
"35937603", "Рогозиново",
"3594746", "Попово\,\ Ямбол",
"35930411", "Девин",
"3593198", "Чехларе",
"3599553", "Превала",
"35931708", "Песнопой\,\ Пловдив",
"3595326", "Върбяне",
"3597041", "Шатрово",
"35969243", "Казачево",
"3597523", "Гърмен",
"35953223", "Църквица",
"35931308", "Богдан\,\ Пловдив",
"3596062", "Стража\,\ Търг\.",
"359670", "Троян\,\ Ловеч",
"3596980", "Беленци",
"35969244", "Тепава",
"3595148", "Рудник\,\ Варна",
"3595140", "Шкорпиловци",
"3598167", "Церовец",
"3596321", "Горна\ Студена",
"3596988", "Пещерна",
"3594583", "Кипилово",
"359554", "Слънчев\ бряг",
"3599167", "Липница\,\ Враца",
"359748", "Симитли",
"3594714", "Дражево",
"3596917", "Българене\,\ Ловеч",
"3593666", "Попско",
"35956", "Бургас",
"3593921", "Меричлери",
"35931388", "Бегунци",
"3599547", "Винище",
"3596151", "Елена\,\ В\.\ Търново",
"3598693", "Звенимир",
"35971502", "Елешница\,\ София",
"359596", "Поморие",
"3599522", "Котеновци",
"3595131", "Вълчи\ дол",
"3593190", "Върбен\,\ Пловдив",
"35991202", "Кунино",
"359359", "Велинград",
"3594592", "Бяла\ паланка",
"3596117", "Дебелец\,\ В\.\ Търново",
"35984729", "Езерче",
"3593121", "Рогош",
"3598116", "Иваново\,\ Русе",
"3596072", "Добротица\,\ Търг\.",
"3593528", "Говедаре",
"35941330", "Ценово\,\ Ст\.\ Загора",
"3597182", "Мирково",
"35959405", "Зайчар",
"3596581", "Бяла\ вода\,\ Плевен",
"3599116", "Костелево",
"3594100", "Столетово\,\ Ст\.\ Загора",
"3594323", "Тулово",
"3596966", "Шипково",
"3596032", "Зараево",
"35963566", "Бръшляница",
"35971304", "Липница\,\ София",
"3596029", "Надарево",
"3594153", "Мъдрец\,\ Ст\.\ Загора",
"3595578", "Терзийско\,\ Бургас",
"3596024", "Руец",
"3595538", "Караново\,\ Бургас",
"3596546", "Лозица\,\ Плевен",
"35937703", "Димитровче",
"3596558", "Славовица\,\ Плевен",
"3595784", "Врачанци",
"3593782", "Калугерово\,\ Хаск\.",
"3595513", "Габър",
"3593651", "Ардино",
"3597193", "Голеш\,\ София",
"35974207", "Генерал\ Тодоров",
"3593059", "Кутела",
"3596716", "Жълтеш",
"359478", "Елхово\,\ Ямбол",
"3593025", "Баните",
"35937704", "Младиново",
"3596166", "Виноград",
"3595743", "Шабла",
"3593054", "Подвис\,\ Смол\.",
"3593745", "Малък\ извор\,\ Хаск\.",
"3599569", "Липен",
"3599345", "Винарово\,\ Видин",
"35930458", "Любча",
"3594567", "Баня\,\ Сливен",
"3599183", "Лиляче",
"35937420", "Подкрепа",
"35960378", "Цар\ Асен\,\ Търг\.",
"3599564", "Стубел",
"3596737", "Крушево\,\ Габр\.",
"3593515", "Калугерово\,\ Пазарджик",
"3595711", "Овчарово\,\ Добр\.",
"3598149", "Кацелово",
"35941357", "Зетьово\,\ Ст\.\ Загора",
"3599144", "Нивянин",
"35977222", "Горна\ Диканя",
"3599149", "Буковец\,\ Враца",
"3593073", "Старцево",
"3596550", "Ставерци",
"3595161", "Ветрино",
"3594147", "Любеново\,\ Ст\.\ Загора",
"3598144", "Батишница",
"359517", "Дългопол",
"35931792", "Черничево\,\ Пловдив",
"3595530", "Пещерско",
"359335", "Карлово",
"3595570", "Манолич",
"3597446", "Елешница\,\ Благ\.",
"3594335", "Ръжена",
"3594122", "Еленино",
"3597145", "Мирово\,\ София",
"35931392", "Дъбене",
"3594139", "Свобода\,\ Ст\.\ Загора",
"35984467", "Сеслав",
"3595757", "Безмер\,\ Добр\.",
"3596519", "Беглеж",
"3593636", "Равен",
"3599137", "Попица",
"3594108", "Васил\ Левски\,\ Ст\.\ Загора",
"3598192", "Хотанца",
"35984718", "Дряновец\,\ Разград",
"3594352", "Горно\ Черковище",
"35971338", "Осиковска\ Лакавица",
"3593520", "Мирянци",
"3594134", "Братя\ Даскалови",
"3593676", "Бенковски\,\ Кърдж\.",
"3598137", "Голямо\ Враново",
"3596514", "Долни\ Дъбник",
"3593781", "Симеоновград",
"3597445", "Баня\,\ Благ\.",
"3597158", "Доганово",
"3594336", "Долно\ Изворово",
"35931709", "Михилци",
"3597146", "Черньово",
"3593652", "Бял\ извор\,\ Кърдж\.",
"3596728", "Буря",
"35931309", "Климент\,\ Пловдив",
"35955504", "Богданово\,\ Бургас",
"3595363", "Гусла",
"3593675", "Фотиново\,\ Кърдж\.",
"3598477", "Самуил",
"35937423", "Големанци",
"3596582", "Белене",
"3593746", "Сираково\,\ Хаск\.",
"35969613", "Чифлик\,\ Ловеч",
"3599346", "Синаговци",
"3596071", "Антоново",
"3597181", "Пирдоп",
"3593758", "Йерусалимово",
"3599128", "Елисейна",
"35937424", "Козлец",
"35931395", "Иганово",
"3593516", "Црънча\,\ Пазарджик",
"3598128", "Полско\ Косово",
"35969614", "Горно\ трапе",
"35951536", "Николаевка",
"3594121", "Люляк",
"3593537", "Панагюрски\ колонии",
"3596545", "Любеново\,\ Плевен",
"35961106", "Ново\ село\,\ В\.\ Търново",
"359868", "Силистра",
"3593703", "Жълти\ бряг",
"3595599", "Хаджиите",
"3596165", "Асеново\,\ В\.\ Търново",
"3596007", "Ралица",
"3597119", "Дръмша",
"3594351", "Копринка",
"3595527", "Соколово\,\ Бургас",
"35984728", "Раковски\,\ Разград",
"3593026", "Смилян",
"3597103", "Брусен\,\ София",
"3599115", "Чирен",
"3596965", "Бели\ Осъм",
"35947192", "Завой",
"3593544", "Костандово",
"3597914", "Ваксево",
"3598115", "Червена\ вода",
"35957307", "Житен\,\ Добр\.",
"35941333", "Средно\ градище",
"3593549", "Грашево",
"3595162", "Белоградец",
"3596720", "Керека",
"3599314", "Дунавци\,\ Видин",
"3599319", "Гъмзово",
"3593719", "Книжовник",
"3595712", "Стожер",
"3593623", "Бойно",
"3593583", "Габровица",
"3596048", "Изворово\,\ Търг\.",
"3593164", "Дълбок\ извор",
"35941334", "Съединение\,\ Ст\.\ Загора",
"35961403", "Орловец",
"35931998", "Чоба",
"3597753", "Ноевци",
"35971505", "Чурек",
"359938", "Кула",
"3597042", "Коркина",
"35941279", "Стрелец\,\ Ст\.\ Загора",
"3596123", "Буковец\,\ В\.\ Търново",
"3596061", "Голямо\ Соколово",
"3595318", "Средня",
"3594793", "Бояджик",
"3593665", "Свирачи",
"3593153", "Стряма",
"3595333", "Хан\ Крум",
"3599723", "Трайково",
"3593323", "Болярци\,\ Пловдив",
"3593100", "Белащица",
"3596923", "Горан",
"359350", "Пещера\,\ Пазарджик",
"3594528", "Любенова\ махала",
"3596952", "Орешак\,\ Ловеч",
"3593134", "Сопот\,\ Пловдив",
"3594520", "Коньово",
"35953220", "Памукчии\,\ Шумен",
"35984761", "Градина\,\ Разград",
"3595354", "Риш",
"35969240", "Хлевене",
"3593108", "Бойково",
"35961397", "Мусина",
"3595325", "Войвода",
"3595132", "Михалич\,\ Варна",
"3599521", "Замфирово",
"3593174", "Старо\ Железаре",
"35984719", "Балкански",
"3593122", "Маноле",
"3595129", "Блъсково",
"3595124", "Комарево\,\ Варна",
"3596935", "Сопот\,\ Ловеч",
"35971471", "Очуша",
"3595310", "Радко\ Димитриево",
"3596175", "Първомайци",
"3593147", "Ново\ село\,\ Пловдив",
"3593922", "Брод",
"35930459", "Бръщен",
"35971221", "Ярлово",
"3594515", "Мокрен",
"3597734", "Главановци\,\ Перник",
"3598646", "Вокил",
"3596135", "Върбовка",
"3596322", "Алеково\,\ В\.\ Търново",
"3596152", "Беброво",
"3593934", "Скобелево\,\ Хаск\.",
"3593567", "Ковачево\,\ Пазарджик",
"35967306", "Градище\,\ Габр\.",
"3594745", "Шарково",
"3595323", "Плиска",
"3595100", "Синдел",
"359550", "Созопол",
"3597526", "Рибново",
"3596118", "Вонеща\ вода",
"3596933", "Голец",
"35951428", "Господиново\,\ Варна",
"35967399", "Малки\ Вършец",
"3595153", "Суворово",
"3596133", "Михалци",
"3596918", "Дренов",
"3599168", "Бутан",
"3594513", "Гавраилово",
"35960451", "Обител",
"35974401", "Горно\ Драглище",
"3599787", "Смирненски\,\ Монт\.",
"35947204", "Пчела",
"35967305", "Стоките",
"3596987", "Карлуково",
"3596173", "Долна\ Оряховица",
"3594743", "Мамарчево",
"3597044", "Бабино",
"3599548", "Крапчене",
"35984776", "Хърсово\,\ Разград",
"35947203", "Трънково\,\ Ямбол",
"3599556", "Говежда",
"3596125", "Пушево",
"3597724", "Извор\,\ Перник",
"3599540", "Белотинци",
"3596159", "Златарица",
"3597755", "Велковци\,\ Перник",
"3593932", "Бодрово",
"3596154", "Буйновци",
"35941111", "Старозагорски\ бани",
"3597729", "Долна\ Диканя",
"3593929", "Голямо\ Асеново",
"35941019", "Венец\,\ Ст\.\ Загора",
"3597732", "Вукан",
"3595147", "Пчелник\,\ Варна",
"3596324", "Вардим",
"3594711", "Безмер\,\ Ямбол",
"35969247", "Гостиня",
"3596329", "Царевец\,\ В\.\ Търново",
"3593924", "Крепост",
"35971506", "Габра",
"3596910", "Малиново",
"3599160", "Гложене\,\ Враца",
"3594586", "Нейково\,\ Сливен",
"3595122", "Славейково\,\ Варна",
"3593129", "Скутаре",
"3595335", "Миланово\,\ Шумен",
"3593155", "Момино\ село",
"3595947", "Просеник",
"359417", "Раднево",
"3593124", "Калековец",
"3594795", "Скалица",
"3596925", "Владиня",
"3593197", "Тюркмен",
"3596959", "Дебнево",
"3595134", "Червенци",
"3593325", "Червен\,\ Пловдив",
"3594757", "Недялско",
"3595139", "Оборище\,\ Варна",
"3596954", "Врабево",
"3593132", "Баня\,\ Пловдив",
"3599725", "Комощица",
"3595108", "Садово\,\ Варна",
"3595352", "Янково",
"3598696", "Суходол\,\ Силистра",
"35984463", "Прелез",
"3593705", "Въгларово",
"3596543", "Муселиево",
"3598442", "Завет\,\ Разград",
"3596021", "Буховци",
"3595516", "Индже\ войвода",
"35984464", "Веселец\,\ Разград",
"3598138", "Бръшлен",
"3596589", "Кулина\ вода",
"35963562", "Комарево\,\ Плевен",
"3596713", "Враниловци",
"35961105", "Присово",
"3595758", "Кладенци",
"3596584", "Белене",
"3595746", "Белгун",
"3596163", "Камен\,\ В\.\ Търново",
"3594107", "Средец\,\ Ст\.\ Загора",
"3599138", "Алтимир",
"3596738", "Добромирка",
"35941353", "Плодовитово",
"3598113", "Ново\ село\,\ Русе",
"35960388", "Горица\,\ Търг\.",
"3599113", "Мраморен",
"3594326", "Енина",
"3596963", "Балканец",
"3597105", "Малки\ Искър",
"3593051", "Чепеларе",
"3594156", "Априлово\,\ Ст\.\ Загора",
"35941354", "Малко\ Тръново",
"3595781", "Свобода\,\ Добр\.",
"3593625", "Широко\ поле",
"3593585", "Аканджиево",
"35974203", "Рупите",
"359454", "Твърдица\,\ Сливен",
"3595714", "Карапелит",
"35946", "Ямбол",
"3599141", "Малорад",
"3595169", "Момчилово",
"3593162", "Градина\,\ Пловдив",
"3594140", "Полски\ Градец",
"35961301", "Бяла\ река\,\ В\.\ Търново",
"3595164", "Неофит\ Рилски",
"3599312", "Брегово\,\ Видин",
"3598141", "Две\ могили",
"3596557", "Брегаре",
"3593712", "Малево\,\ Хаск\.",
"3595719", "Дончево",
"3597912", "Горна\ Гращица",
"35937707", "Щит",
"3593633", "Рогозче",
"3596770", "Плачковци",
"35974204", "Гега",
"35931402", "Скобелево\,\ Пловдив",
"359416", "Чирпан",
"3593673", "Тихомир",
"35977226", "Дебели\ лаг",
"3595365", "Лятно",
"3593542", "Ракитово",
"3599561", "Сумер",
"3599130", "Тлачене",
"35964", "Плевен",
"3595750", "Каблешково\,\ Добр\.",
"3593527", "Алеко\ Константиново",
"359953", "Берковица",
"35931396", "Домлян",
"3596511", "Победа\,\ Плевен",
"3599186", "Згориград",
"3593036", "Могилица",
"3595537", "Съдиево\,\ Бургас",
"3595969", "Гълъбец\,\ Бургас",
"3595577", "Подвис\,\ Бургас",
"3593076", "Цацаровци",};
$areanames{en} = {"3595340", "Visoka\ polyana\,\ Shumen",
"3593117", "Katunitsa",
"3594364", "Osetenovo",
"3596121", "Nikyup",
"35969616", "Staro\ selo\,\ Lovech",
"3593767", "Branitsa",
"3597522", "Dabnitsa",
"35959407", "Sini\ rid",
"3597751", "Breznik",
"3594369", "Aleksandrovo\,\ St\.\ Zagora",
"3596063", "Bayachevo",
"359659", "Cherven\ bryag",
"35953234", "Zlatna\ niva",
"3594715", "Kalchevo",
"35941172", "Gorno\ Botevo",
"3593151", "Rakovski\,\ Plovdiv",
"3597167", "Tserovo\,\ Sofia",
"3596990", "Malak\ izvor\,\ Lovech",
"3597717", "Divotino",
"359848", "Kubrat",
"35935391", "Blatnitsa",
"3596921", "Ablanitsa\,\ Lovech",
"3599552", "Belimel",
"3597547", "Valkosel",
"3593321", "Topolovo\,\ Plovdiv",
"35974386", "Pirin",
"3599721", "Dolno\ Tserovene",
"35981462", "Volovo",
"3599523", "Barzia",
"35941336", "Yazdach",
"359726", "Svoge",
"3593936", "Gorski\ izvor\,\ Hask\.",
"35930476", "Selcha",
"3594728", "Melnitsa",
"3594593", "Shivachevo",
"3598644", "Chernolik",
"3596998", "Golyam\ izvor\,\ Lovech",
"35963560", "Radishevo",
"35961308", "Vishovgrad",
"359749", "Bansko",
"35941355", "Yavorovo",
"3598649", "Yarebitsa",
"35931324", "Mrachenik",
"35961103", "Rusalya",
"3595126", "Cherkovna\,\ Varna",
"3594582", "Gradets\,\ Sliven",
"3593176", "Starosel",
"3598637", "Malak\ Preslavets",
"35961104", "Vodoley",
"3598692", "Stefan\ Karadzha\,\ Silistra",
"35984465", "Savin",
"3598677", "Srebarna",
"3595348", "Trem",
"3593136", "Rozino\,\ Plovdiv",
"3599145", "Brenitsa\,\ Vratsa",
"3596520", "Nikolaevo\,\ Pleven",
"3593514", "Chernogorovo\,\ Pazardzhik",
"3598145", "Trastenik\,\ Ruse",
"3593783", "Svirkovo",
"359860", "Silistra",
"3593519", "Velichkovo\,\ Pazardzhik",
"3597192", "Gintsi",
"3599344", "Vrav",
"3597177", "Aldomirovtsi",
"3593744", "Sarnitsa\,\ Hask\.",
"3599349", "Slanotran",
"3595361", "Kaolinovo",
"3595742", "Rakovski\,\ Dobr\.",
"3597137", "Skravena",
"3593749", "Garvanovo",
"3594347", "Rozovo\,\ St\.\ Zagora",
"3596591", "Gornik",
"359537", "Novi\ pazar\,\ Shumen",
"35991188", "Galatin",
"3597183", "Dushantsi",
"3596515", "Slavyanovo\,\ Pleven",
"3597937", "Razhdavitsa",
"3594322", "Yagoda",
"35941484", "Zemlen",
"35961406", "Karantsi",
"3595727", "Senokos\,\ Dobr\.",
"3596033", "Medovina",
"3594339", "Yulievo",
"3597428", "Gabrene",
"3599337", "Gramada",
"35992", "Vratsa",
"3597149", "Zhivkovo\,\ Sofia",
"3594152", "Obruchishte",
"3593777", "Mezek",
"35960458", "Verentsi",
"35974408", "Obidim",
"3597144", "Kostenets",
"3594334", "Elhovo\,\ St\.\ Zagora\,\ mun\.\ Nikolaevo",
"35982", "Ruse",
"35967304", "Kramolin",
"3593166", "Byala\ reka\,\ Plovdiv",
"3593701", "Elena\,\ Hask\.",
"35930257", "Vishnevo",
"3599316", "Novo\ selo\,\ Vidin",
"3594123", "Bogomilovo",
"3598667", "Belitsa\,\ Silistra",
"3596025", "Alvanovo",
"35963579", "Ralevo",
"35967303", "Batoshevo",
"35941118", "Ostra\ mogila\,\ St\.\ Zagora",
"3594353", "Srednogorovo",
"3597916", "Bagrentsi",
"3593558", "Isperihovo",
"3593024", "Taran",
"3597415", "Selishte\,\ Blag\.",
"3597116", "Petarch",
"3599182", "Devene",
"35961608", "Gorski\ Senovets",
"3593055", "Elhovets",
"3593029", "Petkovo\,\ Smol\.",
"35959694", "Gaberovo",
"3593581", "Belovo",
"359723", "Botevgrad",
"3593032", "Srednogortsi",
"3593072", "Nedelino",
"3596528", "Valchitran",
"359727", "Slivnitsa\,\ Sofia",
"35953222", "Markovo\,\ Shumen",
"3596023", "Podgoritsa",
"3595737", "Lyulyakovo\,\ Dobr\.",
"3597142", "Kostenets",
"35984774", "Golyam\ izvor\,\ Razgrad",
"3594332", "Vetren\,\ St\.\ Zagora",
"3594125", "Mihaylovo\,\ St\.\ Zagora",
"3597927", "Treklyano",
"35969242", "Presyaka",
"3593648", "Golyamo\ Kamenyane",
"3596541", "Nikopol",
"3594154", "Mednikarovo",
"3594324", "Shipka",
"359337", "Hisarya",
"3596161", "Strazhitsa\,\ V\.\ Tarnovo",
"3594355", "Buzovgrad",
"359973", "Kozloduy",
"3593727", "Nova\ Nadezhda",
"3599327", "Chuprene",
"3596711", "Kozi\ rog",
"359697", "Lukovit",
"3597438", "Katuntsi",
"3594329", "Dolno\ Sahrane",
"3593053", "Hvoyna",
"3596586", "Belene",
"3596570", "Deventsi",
"3599111", "Chelopek",
"3596530", "Tranchovitsa",
"3599342", "Inovo",
"3598111", "Shtraklevo",
"3595749", "Krapets\,\ Dobr\.",
"3597127", "Shiroki\ dol",
"3595783", "Kotlentsi",
"35937602", "Cherna\ mogila\,\ Hask\.",
"3595519", "Zidarovo",
"3593512", "Hadzhievo",
"35991203", "Lik",
"3593074", "Erma\ reka",
"3593039", "Polkovnik\ Serafimovo",
"3593785", "Dryanovo\,\ Hask\.",
"3598143", "Obretenik",
"3593079", "Kozarka",
"3599143", "Enitsa",
"3593034", "Levochevo",
"3593671", "Podkova",
"3599184", "Ohoden",
"3596538", "Obnova",
"3594118", "Pamukchii\,\ St\.\ Zagora",
"3593022", "Vievo",
"3596578", "Reselets",
"35984768", "Sinya\ voda",
"359722", "Samokov",
"3598184", "Glodzhevo",
"3599189", "Pavolche",
"3594768", "Zimnitsa\,\ Yambol",
"3593631", "Momchilgrad",
"3596035", "Palamartsa",
"3597430", "Damyanitsa",
"35971798", "Vasilovtsi\,Sof\.",
"3596513", "Pordim",
"35971504", "Belopoptsi",
"3597185", "Chelopech",
"3595558", "Debelt",
"35971398", "Osikovitsa",
"35971503", "Dolno\ Kamartsi",
"3595166", "Dobroplodno",
"35971228", "Maritsa",
"35961405", "Petko\ Karavelovo",
"3595716", "Paskalevo",
"35966", "Gabrovo",
"3599554", "Chiprovtsi",
"3595917", "Izvor\,\ Burgas",
"3595321", "Praventsi",
"3594557", "Bikovo",
"3597046", "Boboshevo",
"3599525", "Dolno\ Ozirovo",
"35941356", "Rupkite",
"3597058", "Stob",
"3599559", "Gorna\ Kovachitsa",
"35937702", "Mustrak",
"35941335", "Mogilovo",
"3594770", "General\ Inzovo",
"35959400", "Daskotna",
"3596560", "Kreta\,\ Pleven",
"3596931", "Ugarchin",
"35930475", "Stomanevo",
"3594595", "Sborishte",
"3594730", "Knyazhevo",
"35930419", "Yagodina",
"3597532", "Bukovo\,\ Blag\.",
"359336", "Parvomay\,\ Plovdiv",
"35991401", "Vranyak",
"35944", "Sliven",
"3594511", "Slivenski\ mineralni\ bani",
"35971302", "Bozhenitsa",
"35984466", "Zvanartsi",
"3597524", "Ablanitsa\,\ Blag\.",
"3593340", "Novi\ izvor",
"3595117", "Botevo\,\ Varna",
"3599740", "Septemvriytsi\,\ Mont\.",
"3594741", "Bolyarovo",
"3594362", "Manolovo",
"3595767", "Zhitnitsa\,\ Dobr\.",
"3597529", "Breznitsa",
"3596948", "Karpachevo",
"3598694", "Zebil",
"35931393", "Voynyagovo",
"35984721", "Lipnik",
"3596956", "Lomets\,\ Lovech",
"3599748", "Dalgodeltsi",
"3593348", "Dobralak",
"35963567", "Gradina\,\ Pleven",
"3595136", "Brestak",
"359558", "Aytos",
"3598699", "Tarnovtsi\,\ Silistra",
"3593126", "Trud",
"35969615", "Balabansko",
"3594713", "Stara\ reka\,\ Yambol",
"35931394", "Vasil\ Levski\,\ Plovdiv",
"3599518", "Marchevo",
"3598627", "Babuk",
"3596065", "Bistra\,\ Targ\.",
"3594584", "Ticha",
"3594738", "Hlyabovo",
"35955505", "Drachevo",
"3593661", "Ivaylovgrad",
"35941149", "Lovets\,\ St\.\ Zagora",
"3593926", "Dobrich\,\ Hask\.",
"3596907", "Gradezhnitsa",
"3596326", "Morava",
"3596568", "Dabovan",
"3598642", "Dulovo",
"3594778", "Pobeda\,\ Yambol",
"3596148", "Pavel",
"3596156", "Rodina",
"359570", "Kavarna",
"3597726", "Dren",
"3596132", "Karaisen",
"3596325", "Kozlovets",
"3594512", "Blatets\,\ Sliven",
"35969612", "Terziysko\,\ Lovech",
"3596359", "Glava",
"3593925", "Krum",
"35937422", "Dolni\ Glavanak",
"3595952", "Malko\ Tarnovo",
"35991668", "Manastirishte",
"3597531", "Dolno\ Dryanovo",
"3594361", "Pavel\ banya",
"3594742", "Stefan\ Karadzhovo",
"35961107", "Momin\ sbor",
"3597725", "Klenovik",
"3593110", "Popovitsa",
"3595347", "Zhivkovo\,\ Shumen",
"3596124", "Ledenik",
"3598678", "Sratsimir\,\ Silistra",
"3598638", "Bogdantsi\,\ Silistra",
"3596129", "Gabrovtsi",
"3596155", "Konstantin",
"3597754", "Kosharevo",
"3599729", "Rasovo",
"3595135", "Stefan\ Karadzha\,\ Varna",
"3594727", "Malak\ manastir",
"3596929", "Radyuvene",
"359579", "Albena",
"3599724", "Stanevo",
"3596955", "Dalbok\ dol",
"35931390", "Moskovets",
"3593324", "Izbeglii",
"3596932", "Mikre",
"3593154", "Chalakovi",
"3595334", "Osmar",
"3594799", "Golyam\ manastir",
"35957306", "Izvorovo\,\ Dobr\.",
"3596066", "Buynovo\,\ Targ\.",
"35955502", "Suhodol\,\ Burgas",
"3594794", "Ovchi\ kladenets",
"3593125", "Razhevo\ Konare",
"3596997", "Dobrevtsi\,\ Lovech",
"3593159", "Belozem",
"3598641", "Okorsh",
"35981466", "Pomen",
"3595123", "Ravna\,\ Varna",
"3597718", "Dragichevo",
"35941332", "Naydenovo",
"35947193", "Mogila\,\ Yambol",
"3593662", "Zhelezino",
"35930472", "Mihalkovo",
"3597168", "Bov",
"3593173", "Panicheri",
"3597548", "Godeshevo",
"35937705", "Pastrogor",
"3593133", "Kalofer",
"35936402", "Gorna\ kula",
"3595353", "Veselinovo\,\ Shumen",
"359605", "Omurtag",
"35951537", "Chernevo",
"3597045", "Golem\ Varbovnik",
"3599526", "Slatina\,\ Mont\.",
"3593768", "Dositeevo",
"3598630", "Silistra",
"35984711", "Mortagonovo",
"35959404", "Yasenovo\,\ Burgas",
"3598670", "Silistra",
"3593933", "Stransko",
"3593118", "Sadovo\,\ Plovdiv",
"3597733", "Filipovtsi",
"35974496", "Filipovo\,\ Blag\.",
"35951314", "Voyvodino",
"35959403", "Rechitsa",
"35984769", "Gorotsvet",
"3597186", "Anton",
"35951106", "Osenovo\,\ Varna",
"3593741", "Mandra",
"35930418", "Buynovo\,\ Smol\.",
"3599341", "Dimovo\,\ Vidin",
"3596076", "Taymishte",
"3596036", "Sadina",
"3594340", "Panicherevo",
"3599112", "Banitsa",
"3596962", "Cherni\ Osam",
"35974348", "Igralishte",
"3596527", "Odarne",
"3595715", "Popgrigorovo",
"3593511", "Ognyanovo\,\ Pazardzhik",
"35934", "Pazardzhik",
"3595165", "Nevsha",
"3599330", "Rabrovo",
"35967307", "Mlechevo",
"3598668", "Popina",
"3596542", "Vabel\,\ Pleven",
"3593786", "Navasen",
"3594331", "Gurkovo\,\ St\.\ Zagora",
"35961402", "Stefan\ Stambolovo",
"3593557", "Byaga",
"3596712", "Gabene",
"35931627", "Krushevo\,\ Plovdiv",
"3597930", "Eremia",
"35931701", "Krastevich",
"35991888", "Veslets\,\ Vratsa",
"3597938", "Dolno\ Uyno",
"3592", "Sofia",
"3596585", "Belene",
"35969245", "Devetaki",
"35930517", "Zabardo",
"3593778", "Studena\,\ Hask\.",
"3593704", "Bryagovo\,\ Hask\.",
"3598660", "Tutrakan",
"3593709", "Karamantsi",
"35967774", "Belitsa\,\ Gabr\.",
"3597427", "Parvomay\,\ Blag\.",
"3599338", "Shishentsi",
"3593584", "Vetren\,\ Pazardzhik",
"3593624", "Chiflik\,\ Kardzh\.",
"3593163", "Iskra\,\ Plovdiv",
"3597442", "Yakoruda",
"3599313", "Kapitanovtsi",
"3594126", "Hrishteni",
"3593713", "Dinevo",
"3593589", "Tserovo\,\ Pazardzhik",
"3593629", "Most",
"3594356", "Hadzhidimitrovo\,\ St\.\ Zagora",
"3597913", "Rashka\ Grashtitsa",
"3597138", "Litakovo",
"3598196", "Nisovo",
"3593632", "Dzhebel",
"3594348", "Dunavtsi\,\ St\.\ Zagora",
"3597104", "Laga",
"3593672", "Chorbadzhiysko",
"3597178", "Prolesha",
"3593543", "Dorkovo",
"3595557", "Bistrets\,\ Burgas",
"3594321", "Maglizh",
"3593056", "Chepintsi\,\ Smol\.",
"3596583", "Belene",
"3596164", "Bryagovitsa",
"3596169", "Blagoevo\,\ V\.\ Tarnovo",
"3593720", "Madzharovo",
"3599320", "Stakevtsi",
"3596714", "Popovtsi",
"3596549", "Sanadinovo",
"35947202", "Zhrebino",
"3597920", "Skrinyano",
"35969031", "Galata",
"35981268", "Krivina\,\ Ruse",
"3598150", "Semerdzhievo",
"3596544", "Novachene\,\ Pleven",
"3597120", "Dolna\ banya",
"3595511", "Lukoil\ Neftochim",
"3599315", "Gradets\,\ Vidin",
"35931620", "Dobri\ dol\,\ Plovdiv",
"3596026", "Makariopolsko",
"3593653", "Mlechino",
"3593165", "Karadzhalovo",
"35954", "Shumen",
"35943616", "Turia",
"3593545", "Draginovo",
"3596577", "Breste",
"3595362", "Kliment\,\ Shumen",
"3596964", "Velchevo\,\ Lovech",
"3599119", "Tishevitsa",
"3596969", "Beklemeto",
"35937606", "Shishmanovo",
"3596537", "Asenovtsi",
"3597915", "Nevestino\,\ Kyust\.",
"3598114", "Pirgovo",
"35961395", "Paskalevets",
"3596516", "Iskar\,\ Pleven",
"3593639", "Nanovitsa\,\ Kardzh\.",
"3597102", "Lopyan",
"3593674", "Samodiva",
"3594136", "Cherna\ gora\,\ St\.\ Zagora",
"3599181", "Kravoder",
"35935258", "Tsar\ Asen\,\ Pazardzhik",
"3593634", "Pripek\,\ Kardzh\.",
"359701", "Dupnitsa",
"3593679", "Kirkovo",
"3593071", "Zlatograd",
"3595163", "Mlada\ gvardia",
"35975215", "Teshovo",
"35941480", "Kolarovo\,\ St\.\ Zagora",
"3597444", "Belitsa\,\ Blag\.",
"3595713", "Stefanovo\,\ Dobr\.",
"3595589", "Vinarsko",
"3593582", "Momina\ klisura",
"3593622", "Stremtsi",
"3598158", "Mechka\,\ Ruse",
"3598445", "Yuper",
"3595738", "Spasovo\,\ Dobr\.",
"3599146", "Sokolare",
"359306", "Rudozem",
"3593647", "Chernichevo\,\ Kardzh\.",
"3597928", "Garlyano",
"3593702", "Tsareva\ polyana",
"3599328", "Dolni\ Lom",
"3593728", "Slavyanovo\,\ Hask\.",
"35961309", "Gorsko\ Kalugerovo",
"359470", "Topolovgrad",
"3597437", "Melnik",
"3593040", "Trigrad",
"35971587", "Golema\ Rakovitsa",
"35984738", "Kitanchevo",
"35991189", "Tri\ kladentsi",
"3596567", "Somovit",
"3594792", "Botevo\,\ Yambol",
"35935502", "Fotinovo\,\ Pazardzhik",
"3596908", "Glogovo",
"3594777", "Tenevo",
"3595397", "Metodievo\,\ Shumen",
"3596939", "Dragana",
"35941352", "Vinarovo\,\ St\.\ Zagora",
"3596934", "Katunets",
"3594737", "Sinapovo",
"3595125", "Gradinarovo",
"3595332", "Dragoevo",
"35937706", "Chernodab",
"3599551", "Georgi\ Damyanovo",
"3595910", "Cherni\ vrah\,\ Burgas",
"3599722", "Staliyska\ mahala",
"35981465", "Batin",
"3595329", "Mirovtsi",
"3593322", "Zlatovrah",
"3593135", "Karnare",
"3596147", "Ivancha\,\ V\.\ Tarnovo",
"3593175", "Dalgo\ pole\,\ Plovdiv",
"3595324", "Harsovo\,\ Shumen",
"3596922", "Leshnitsa\,\ Lovech",
"359379", "Svilengrad",
"35974409", "Mesta",
"3597521", "Koprivlen",
"3593347", "Lenovo",
"3599747", "Mokresh\,\ Mont\.",
"3593935", "Varbitsa\,\ Hask\.",
"3597752", "Rezhantsi",
"3594749", "Ruzhitsa\,\ Yambol",
"35967391", "Stolat",
"3595760", "Bozhurovo\,\ Dobr\.",
"3594744", "Golyamo\ Krushevo",
"35984462", "Ostrovo",
"35974495", "Yurukovo",
"3597043", "Golemo\ selo",
"35971306", "Rashkovo",
"35963564", "Bivolare",
"3596122", "Belyakovets",
"3599517", "Kobilyak",
"3596352", "Dolni\ Lukovit",
"35931397", "Hristo\ Danovo",
"35965165", "Pisarovo\,\ Pleven",
"3596174", "Draganovo\,\ V\.\ Tarnovo",
"3594519", "Samuilovo\,\ Sliven",
"3598628", "Tsar\ Asen\,\ Silistra",
"3595959", "Zvezdets",
"3596134", "Byala\ cherkva\,\ V\.\ Tarnovo",
"3597735", "Leva\ reka",
"35963563", "Borislav",
"3596179", "Krusheto",
"3594514", "Krushare",
"35978", "Kyustendil",
"3593923", "Radievo",
"359650", "Levski\,\ Pleven",
"35941175", "Kolena",
"3598620", "Silistra",
"3596323", "Balgarsko\ slivovo",
"3598691", "Silistra",
"3596153", "Zlataritsa",
"3595768", "Odrintsi\,\ Dobr\.",
"3597723", "Dolni\ Rakovets",
"3595118", "Voditsa\,\ Varna",
"35984269", "Nedoklan",
"3596953", "Borima",
"35957305", "Rositsa\,\ Dobr\.",
"3597057", "Malo\ selo",
"35974202", "Klyuch",
"3595133", "General\ Kolevo\,\ Varna",
"3595918", "Rusokastro",
"35941119", "Elhovo\,\ St\.\ Zagora",
"359678", "Teteven",
"35963578", "Opanets\,\ Pleven",
"3593664", "Plevun",
"3594716", "Veselinovo\,\ Yambol",
"3593123", "Kaloyanovo\,\ Plovdiv",
"35931403", "Trivoditsi",
"3596900", "Vasilyovo",
"3596902", "Ribaritsa\,\ Lovech",
"3598647", "Paisievo",
"3594798", "Savino",
"35984765", "Veselina",
"3593146", "Kurtovo\ Konare",
"35930412", "Devin",
"3595338", "Troitsa",
"3595105", "Priseltsi\,\ Varna",
"3593328", "Dolnoslav",
"3599728", "Slivata",
"3593566", "Boshulya",
"3594523", "Stoil\ voyvoda",
"3596928", "Kakrina",
"35931993", "Sarnegor",
"3598679", "Kaynardzha",
"3598634", "Nova\ Cherna",
"35971225", "Novo\ selo\,\ Sofia",
"3598674", "Profesor\ Ishirkovo",
"3596128", "Hotnitsa",
"3598639", "Kolarovo\,\ Silistra",
"35991186", "Baurene",
"35974406", "Dobarsko",
"3598622", "Alekovo\,\ Silistra",
"3595313", "Madara",
"359601", "Targovishte",
"3598165", "Smirnenski\,\ Ruse",
"3596915", "Smochan",
"3599165", "Sofronievo",
"3593114", "Brestnik",
"3594367", "Tazha",
"3595762", "Stefan\ Karadzha\,\ Dobr\.",
"3599545", "Gabrovnitsa",
"3593769", "Oreshets\,\ Hask\.",
"3595341", "Hitrino",
"3593764", "Polyanovo\,\ Hask\.",
"3595112", "Beloslav",
"3593119", "Galabovo\,\ Plovdiv",
"35941116", "Sladak\ Kladenets",
"3596920", "Lesidren",
"3594552", "Stara\ reka\,\ Sliven",
"3597549", "Dolen\,\ Blag\.",
"35961606", "Vladislav",
"35931700", "Belovitsa",
"3599720", "Kovachitsa",
"3593320", "Oreshets\,\ Plovdiv",
"3593103", "Milevo",
"3597544", "Osina",
"3595912", "Polski\ izvor",
"3597719", "Yardzhilovtsi",
"3595330", "Zlatar",
"35984266", "Prostorno",
"3597164", "Rebrovo",
"3597169", "Tompsan",
"35993212", "Karbintsi",
"35991201", "Lyuti\ brod",
"3596991", "Yablanitsa",
"3597714", "Meshtitsa",
"3596115", "Resen",
"35960370", "Golyamo\ gradishte",
"359724", "Ihtiman",
"3593042", "Borino",
"3593753", "Oryahovo\,\ Hask\.",
"3599353", "Koshava",
"3598669", "Garvan\,\ Silistra",
"3593700", "Trakiets",
"3599123", "Roman",
"3598123", "Bosilkovtsi",
"3598664", "Polyana\,\ Silistra",
"35951125", "Konstantinovo\,\ Varna",
"3593536", "Banya\,\ Pazardzhik",
"3596723", "Tsareva\ livada",
"35969249", "Doyrentsi",
"359318", "Saedinenie\,\ Plovdiv",
"3595368", "Takach",
"3593027", "Slaveyno",
"3595526", "Klikach",
"35974388", "Gorno\ Spanchevo",
"359750", "Borovets\,\ Sofia",
"35968", "Lovech",
"3596006", "Presian",
"3593691", "Chernoochene",
"35984710", "Osenets",
"359619", "Lyaskovets\,\ V\.\ Tarnovo",
"3597174", "Kalotina",
"3599347", "Bela\ Rada",
"3597139", "Dzhurovo",
"3593747", "Tatarevo\,\ Hask\.",
"3596590", "Rakita\,\ Pleven",
"3597179", "Golemo\ Malovo",
"3597134", "Vrachesh",
"3594344", "Shanovo",
"35977221", "Kondofrey",
"35941338", "Tselina",
"35961706", "Pisarevo\,\ V\.\ Tarnovo",
"3596521", "Sadovets",
"3593517", "Lesichovo",
"3593628", "Miladinovo",
"3593588", "Menenkyovo",
"3594145", "Znamenosets",
"35961306", "Patresh",
"3596043", "Dolno\ Novkovo",
"35941270", "Malka\ Vereya",
"3598152", "Krasen\,\ Ruse",
"3595772", "Telerig",
"3593779", "Siva\ reka",
"3593774", "Levka",
"3599339", "Makresh",
"3597147", "Pchelin\,\ Sofia",
"3595732", "Petleshkovo",
"35967397", "Ryahovtsite",
"35942", "Stara\ Zagora",
"3594337", "Yasenovo\,\ St\.\ Zagora",
"3597922", "Dragovishtitsa\,\ Kyust\.",
"3593708", "Orlovo\,\ Hask\.",
"3593722", "Mineralni\ bani\,\ Hask\.",
"3599322", "Oreshets\,\ Vidin",
"3599135", "Bardarski\ geran",
"3597939", "Tsarvaritsa",
"3595755", "Kolartsi",
"35931791", "Begovo",
"359339", "Stamboliyski\,\ Plovdiv",
"35984723", "Dyankovo",
"3598135", "Babovo",
"3597934", "Bunovo\,\ Kyust\.",
"3599175", "Ostrov",
"3595724", "Dropla\,\ Dobr\.",
"3599187", "Lyutadzhik",
"359746", "Sandanski",
"35941358", "Opalchenets",
"35935394", "Oborishte\,\ Pazardzhik",
"35960383", "Berkovski",
"3598118", "Nikolovo\,\ Ruse",
"3596733", "Kormyansko",
"35961705", "Gorski\ dolen\ Trambesh",
"3593526", "Dinkata",
"35961305", "Lesicheri",
"3598187", "Tetovo",
"3596968", "Dobrodan",
"3593077", "Sredets\,\ Smol\.",
"3595580", "Troyanovo\,\ Burgas",
"3595576", "Lozarevo",
"35935393", "Smilets\,\ Pazardzhik",
"3594143", "Sarnevo\,\ St\.\ Zagora",
"35930457", "Kasak",
"35960384", "Gagovo",
"359729", "Godech",
"35960377", "Aprilovo\,\ Targ\.",
"359518", "Provadia",
"3595536", "Maglen",
"3593037", "Sivino",
"3596556", "Gorna\ Mitropolia",
"35984717", "Pobit\ kamak\,\ Razgrad",
"3596548", "Debovo",
"3598662", "Dobrotitsa\,\ Silistra",
"35971337", "Kalugerovo\,\ Sofia",
"3593641", "Krumovgrad",
"3599173", "Galovo",
"3593049", "Beden",
"3596718", "Draganovtsi",
"3598133", "Ryahovo",
"3595753", "Orlyak",
"3596168", "Sushitsa\,\ V\.\ Tarnovo",
"3599133", "Komarevo\,\ Vratsa",
"3593044", "Lyaskovo\,\ Smol\.",
"3597932", "Shipochano",
"3599355", "Kosovo\,\ Vidin",
"35984743", "Brestovene",
"3595551", "Sredets\,\ Burgas",
"3593755", "Belitsa\,\ Hask\.",
"3594327", "Sheynovo",
"35984393", "Vazovo",
"3593729", "Krivo\ pole",
"3599329", "Rabisha",
"3593724", "Susam",
"3596710", "Donino",
"3599324", "Ruzhintsi",
"3593772", "Momkovo",
"3598159", "Koshov",
"3595734", "Preselentsi",
"35984744", "Belovets",
"3598125", "Koprivets",
"35984394", "Duhovets",
"3597924", "Shishkovtsi",
"35961101", "Velchevo\,\ V\.\ Tarnovo",
"3596540", "Asenovo\,\ Pleven",
"3597929", "Sovolyano",
"3599125", "Gorna\ Beshovitsa",
"3599332", "Rakovitsa",
"3595774", "Koriten",
"3594157", "Razdelna\,\ St\.\ Zagora",
"3595739", "Pchelarovo\,\ Dobr\.",
"3595517", "Ravnets\,\ Burgas",
"3597124", "Belchinski\ bani",
"3596725", "Gostilitsa",
"3597129", "Raduil",
"3597448", "Bachevo",
"3597155", "Lesnovo",
"3594106", "Pastren",
"3599110", "Virovsko",
"35967390", "Shumata",
"3596960", "Belish",
"3597132", "Radotina",
"3596571", "Lepitsa",
"3595747", "Vaklino",
"3594342", "Ovoshtnik",
"3593638", "Zvezdel",
"3594761", "Straldzha",
"35963572", "Yasen\,\ Pleven",
"3593678", "Chakalarovo",
"3597172", "Dragoman",
"35941277", "Zagore",
"3596531", "Izgrev\,\ Pleven",
"3594518", "Topolchane",
"3598629", "Smilets\,\ Silistra",
"3596913", "Slavyani",
"3596138", "Nedan",
"35947353", "Balgarska\ polyana",
"3599163", "Harlets",
"35931387", "Prolom",
"3598163", "Bazan",
"3595946", "Tranak",
"35941115", "Borilovo",
"3598624", "Kalipetrovo",
"3596178", "Strelets\,\ V\.\ Tarnovo",
"3595958", "Gramatikovo",
"3594587", "Yablanovo",
"3598697", "Sokol\,\ Silistra",
"3594748", "Voden\,\ Yambol",
"3598672", "Bradvari",
"35947354", "Kamenna\ reka",
"3594756", "Polyana\,\ Yambol",
"3598632", "Zafirovo",
"35981262", "Bistrentsi",
"3593196", "Drangovo\,\ Plovdiv",
"3595328", "Nikola\ Kozlevo",
"3593105", "Manolsko\ Konare",
"359747", "Razlog",
"3596938", "Kalenik\,\ Lovech",
"3596113", "Balvan",
"35941179", "Han\ Asparuhovo",
"3596909", "Malka\ Zhelyazna",
"35961605", "Novo\ gradishte",
"3595146", "Goren\ chiflik",
"35974322", "Petrovo\,\ Blag\.",
"3596986", "Daben",
"3596561", "Gulyantsi",
"3597712", "Batanovtsi",
"3595391", "Varbitsa\,\ Shumen",
"3594771", "Malomir\,\ Yambol",
"35953434", "Yasenkovo",
"3597162", "Lakatnik",
"35935252", "Topoli\ dol",
"3596930", "Slavshtitsa",
"3599557", "Gorno\ Tserovene",
"35984766", "Kamenar\,\ Razgrad",
"3594525", "Omarchevo\,\ Sliven",
"3595914", "Atia",
"3594554", "Trapoklovo",
"3596141", "Polski\ Trambesh",
"3595919", "Marinka",
"3595320", "Pet\ mogili\,\ Shumen",
"3595769", "Hitovo",
"3599741", "Dolni\ Tsibar",
"3593762", "Izvorovo\,\ Hask\.",
"3597527", "Gorno\ Dryanovo",
"3593341", "Konush\,\ Plovdiv",
"35974405", "Kraishte\,\ Blag\.",
"3595114", "Ezerovo\,\ Varna",
"3593112", "Markovo\,\ Plovdiv",
"3595119", "Ignatievo",
"3596941", "Letnitsa",
"3595764", "Vladimirovo\,\ Dobr\.",
"35967301", "Idilevo",
"3595315", "Tsarev\ brod",
"35995277", "Cherkaski",
"35984732", "Yonkovo",
"35984", "Razgrad",
"35931707", "Chernozemen",
"35991185", "Pudria",
"3597036", "Balanovo",
"3594510", "Zhelyu\ voyvoda",
"35994", "Vidin",
"35984469", "Bozhurovo\,\ Razgrad",
"35961503", "Chakali",
"3597743", "Divlya",
"35974346", "Tsaparevo",
"35963204", "Delyanovtsi",
"35951108", "Izvorsko",
"35930416", "Gyovren",
"3597052", "Pastra",
"3597035", "Cherven\ breg",
"3598640", "Pravda\,\ Silistra",
"3595316", "Salmanovo",
"35935255", "Rosen\,\ Pazardzhik",
"35963203", "Hadzhidimitrovo\,\ V\.\ Tarnovo",
"3599785", "Vasilovtsi\,\ Mont\.",
"35984735", "Sveshtari",
"35941359", "Izvorovo\,\ St\.\ Zagora",
"35936702", "Gorski\ izvor\,\ Kardzh\.",
"3593143", "Perushtitsa",
"3596985", "Rumyantsevo",
"35991182", "Osen\,\ Vratsa",
"3593563", "Varvara\,\ Pazardzhik",
"3598631", "Silistra",
"35974402", "Godlevo",
"359309", "Pamporovo",
"3594368", "Tarnicheni",
"3594526", "Mlekarevo",
"3598671", "Silistra",
"35973", "Blagoevgrad",
"35981886", "Chereshovo\,\ Ruse",
"3596942", "Aleksandrovo\,\ Lovech",
"3593111", "Parvenets\,\ Plovdiv",
"3595344", "Velino",
"3595349", "Studenitsa",
"3593342", "Narechenski\ bani",
"3599742", "Yakimovo",
"35941146", "Hristianovo",
"3593106", "Stroevo",
"35930205", "Starnitsa",
"35931997", "Zlatosel",
"3595145", "Grozdyovo",
"359608", "Popovo\,\ Targ\.",
"3599512", "Beli\ breg",
"35941112", "Starozagorski\ bani",
"35961602", "Tsarski\ izvor",
"3595945", "Dobromir",
"3594732", "Ustrem",
"3593157", "Bolyarino",
"3595337", "Kochovo",
"35952", "Varna",
"3594797", "Galabintsi",
"3598648", "Sekulovo",
"3596562", "Gigen",
"35974325", "Lilyanovo",
"3596994", "Brestnitsa\,\ Lovech",
"3594772", "Simeonovo\,\ Yambol",
"3595392", "Mengishevo",
"3597711", "Kladnitsa",
"3596142", "Obedinenie",
"3593195", "Rozovets",
"3594724", "Razdel\,\ Yambol",
"3596927", "Umarevtsi",
"3594729", "Kirilovo\,\ Yambol",
"3599727", "Medkovets",
"359373", "Harmanli",
"3597541", "Satovcha",
"3594755", "Tamarino",
"3593327", "Bachkovo",
"3597148", "Muhovo",
"35963561", "Grivitsa",
"3593707", "Nikolovo\,\ Hask\.",
"3593642", "Potochnitsa",
"3594338", "Kran",
"3597156", "Ravno\ pole",
"35984727", "Kamenovo\,\ Razgrad",
"35967394", "Bogatovo",
"3597424", "Karnalovo",
"3593533", "Bata",
"3598661", "Tutrakan",
"3596726", "Skalsko",
"3595523", "Krumovo\ gradishte",
"35941178", "Oryahovitsa\,\ St\.\ Zagora",
"3594105", "Byalo\ pole",
"35967393", "Dushevo",
"3596003", "Preselets",
"3593699", "Gabrovo\,\ Kardzh\.",
"3593020", "Davidkovo",
"3599356", "Kalenik\,\ Vidin",
"3593756", "Valche\ pole",
"3593748", "Lyaskovets\,\ Hask\.",
"35984740", "Bisertsi",
"35963575", "Bohot",
"3599348", "Negovanovtsi",
"3593587", "Sestrimo",
"3599126", "Kameno\ pole",
"35957308", "Chernookovo\,\ Dobr\.",
"3593518", "Dragor",
"35931401", "Kadievo",
"359936", "Belogradchik",
"3596524", "Petarnitsa",
"3593510", "Ovchepoltsi",
"359720", "Etropole",
"3596555", "Baykal",
"3596529", "Koilovtsi",
"3599340", "Septemvriytsi\,\ Vidin",
"3593740", "Pchelari",
"3594112", "Badeshte",
"3596532", "Balgarene\,\ Pleven",
"3596572", "Suhache",
"3593028", "Arda",
"3595367", "Todor\ Ikonomovo",
"3594762", "Vodenichane",
"3594341", "Cherganovo",
"35961302", "Batak\,\ V\.\ Tarnovo",
"3593554", "Kozarsko",
"3593559", "Kapitan\ Dimitrievo",
"3595552", "Dyulevo\,\ Burgas",
"35960380", "Drinovo",
"359631", "Svishtov",
"35976", "Pernik",
"3595535", "Lyaskovo\,\ Burgas",
"3594330", "Nikolaevo\,\ St\.\ Zagora",
"359391", "Dimitrovgrad",
"3596046", "Vrani\ kon",
"3595575", "Prilep\,\ Burgas",
"3596553", "Oryahovitsa\,\ Pleven",
"3597447", "Dobrinishte",
"3595518", "Rudnik\,\ Burgas",
"3593030", "Shiroka\ laka",
"359610", "Pavlikeni\,\ V\.\ Tarnovo",
"3598136", "Stambolovo\,\ Ruse",
"3593677", "Drangovo\,\ Kardzh\.",
"3599180", "Golyamo\ Peshtene",
"3599176", "Leskovets\,\ Vratsa",
"35984720", "Topchii",
"3598475", "Loznitsa\,\ Razgrad",
"3595748", "Durankulak",
"35941274", "Samuilovo\,\ St\.\ Zagora",
"3599136", "Galiche",
"3593637", "Gruevo",
"3595756", "Bozhan",
"35931604", "Dragoynovo",
"3596736", "Gradnitsa\,\ Gabr\.",
"3593523", "Sinitevo",
"3597434", "Strumyani",
"3597439", "Ploski",
"3594566", "Pitovo",
"3597422", "Topolnitsa\,\ Blag\.",
"3594146", "Dinya",
"35931603", "Vinitsa",
"3595573", "Vezenkovo",
"3594158", "Iskritsa",
"3595533", "Pirne",
"3593644", "Egrek",
"3595731", "General\ Toshevo\,\ Dobr\.",
"3593535", "Levski\,\ Pazardzhik",
"3597921", "Zhilentsi",
"3596547", "Dragash\ voyvoda",
"3598151", "Prosena",
"3595771", "Krushari",
"3595554", "Momina\ tsarkva",
"35984713", "Blagoevo\,\ Razgrad",
"3594103", "Byal\ izvor\,\ St\.\ Zagora",
"3596167", "Kesarevo",
"3595525", "Devetak",
"3593721", "Stambolovo\,\ Hask\.",
"3593552", "Bratsigovo",
"3595559", "Kubadin",
"3596717", "Lesicharka",
"3596574", "Chomakovtsi",
"3596539", "Gradishte\,\ Pleven",
"3596967", "Kaleytsa",
"3599117", "Krivodol",
"3594764", "Malenovo",
"3595740", "Gorichane",
"35960373", "Posabina",
"3599188", "Gorno\ Peshtene",
"3596579", "Ruptsi\,\ Pleven",
"3596534", "Malchika",
"3598117", "Marten",
"35960387", "Gloginka",
"3593038", "Chokmanovo",
"3596522", "Zgalevo",
"35963576", "Tuchenitsa",
"35960374", "Gorsko\ Ablanovo",
"35931703", "Zhitnitsa\,\ Plovdiv",
"3598690", "Silistra",
"3597528", "Hadzhidimovo",
"35969248", "Skobelevo\,\ Lovech",
"35931704", "Ivan\ Vazovo",
"35931258", "Glavatar",
"359418", "Galabovo\,\ St\.\ Zagora",
"3596116", "Golemanite",
"35941145", "Arnautito",
"3594580", "Borintsi",
"3595143", "Byala\,\ Varna",
"3598621", "Silistra",
"35981266", "Starmen\,\ Ruse",
"35953437", "Gabritsa\,\ Shumen",
"3593667", "Pokrovan",
"3596916", "Brestovo\,\ Lovech",
"3599166", "Hayredin",
"3596901", "Glozhene\,\ Lovech",
"3598166", "Svalenik",
"3595943", "Vresovo",
"3594753", "Zornitsa\,\ Yambol",
"3597054", "Rila",
"3593193", "Borets",
"3599558", "Gavril\ Genovo",
"3599546", "Slavotin",
"35931108", "Bogdanitsa",
"3596149", "Kutsina",
"3599550", "Mitrovtsi",
"35993342", "Kireevo",
"3596144", "Dolna\ Lipnitsa",
"3597745", "Egalnitsa",
"3594551", "Byala\,\ Sliven",
"3595327", "Kaspichan\,\ Shumen",
"359915", "Byala\ Slatina",
"3594722", "Granitovo\,\ Yambol",
"35935256", "Sbor\,\ Pazardzhik",
"3596564", "Zagrazhden\,\ Pleven",
"3596992", "Zlatna\ Panega",
"35932", "Plovdiv",
"3594774", "Krumovo\,\ Yambol",
"3594739", "Radovets",
"3595394", "Byala\ reka\,\ Shumen",
"3594779", "Hanovo",
"35930415", "Devin",
"3596937", "Sokolovo\,\ Lovech",
"3594734", "Srem",
"3597033", "Kraynitsi",
"3596569", "Lenkovo",
"3599514", "Vladimirovo\,\ Mont\.",
"3594588", "Filaretovo",
"3596983", "Dermantsi",
"3596177", "Yantra\,\ V\.\ Tarnovo",
"3593145", "Krichim",
"3596137", "Butovo",
"35941339", "Dimitrievo",
"3594517", "Ichera",
"3599783", "Brusartsi",
"3593344", "Novakovo\,\ Plovdiv",
"3599744", "Valchedram",
"3597520", "Kornitsa",
"35984736", "Podayva",
"359675", "Sevlievo",
"3595106", "Avren\,\ Varna",
"3594747", "Dennitsa\,\ Yambol",
"3596944", "Krushuna",
"3598698", "Shumentsi",
"3595342", "Kapitan\ Petko",
"3593349", "Boyantsi",
"3595761", "Batovo",
"3599749", "Cherni\ vrah\,\ Mont\.",
"3599335", "Tsar\ Petrovo",
"3599122", "Zverino",
"3595571", "Sungurlare",
"3593775", "Generalovo",
"3598122", "Tsenovo\,\ Ruse",
"3593043", "Zmeitsa",
"35981264", "Piperkovo",
"3599134", "Tarnak",
"35971227", "Beli\ Iskar",
"3595754", "Zarnevo",
"3596588", "Dekov",
"35930528", "Manastir\,\ Plovdiv",
"3596517", "Podem",
"3598134", "Malko\ Vranovo",
"3599352", "Druzhba",
"3597935", "Dolno\ selo",
"35995276", "Draganitsa",
"3594137", "Veren",
"3595759", "Kochmar",
"3593752", "Malko\ gradishte",
"3599174", "Gorni\ Vadin",
"35931706", "Suhozem",
"3593521", "Zvanichevo",
"3599139", "Tarnava\,\ Vratsa",
"3594564", "Novoselets",
"35974323", "Lozenitsa",
"3597175", "Gaber",
"35951539", "Levski\,\ Varna",
"3596734", "Petko\ Slaveykov",
"3599567", "Dolna\ Verenitsa",
"3597135", "Trudovets",
"35941110", "Starozagorski\ bani",
"3597436", "Levunovo",
"3594345", "Raduntsi",
"3595710", "Pobeda\,\ Dobr\.",
"35974324", "Struma",
"359556", "Obzor",
"3593658", "Padina\,\ Kardzh\.",
"3599147", "Borovan",
"3593646", "Tokachka",
"3594149", "Trankovo\,\ St\.\ Zagora",
"35961391", "Slomer",
"3597152", "Gorna\ Malina",
"3596551", "Trastenik\,\ Pleven",
"3598147", "Baniska",
"3594144", "Kovachevo\,\ St\.\ Zagora",
"3596722", "Sokolovo\,\ Gabr\.",
"35935254", "Dobrovnitsa",
"35960450", "Dolna\ Hubavka",
"3595168", "Petrov\ dol\,\ Varna",
"3596042", "Iliyno",
"3597123", "Kovachevtsi\,\ Sofia",
"3595718", "Smolnitsa",
"35963205", "Chervena",
"35936700", "Shoptsi",
"35961109", "Vaglevtsi",
"3595556", "Golyamo\ Bukovo",
"3593057", "Plovdivtsi",
"35991180", "Lesura",
"359618", "Gorna\ Oryahovitsa",
"3594116", "Rakitnitsa\,\ St\.\ Zagora",
"3599323", "Drenovets",
"3596536", "Asparuhovo\,\ Pleven",
"359707", "Sapareva\ banya",
"35935418", "Krastava",
"3596580", "Tatari",
"3596576", "Radomirtsi",
"3594101", "Opan",
"35984733", "Ludogortsi",
"3595773", "Lozenets\,\ Dobr\.",
"3595968", "Kableshkovo\,\ Burgas",
"3597923", "Vrattsa",
"35938", "Haskovo",
"35984734", "Todorovo\,\ Razgrad",
"3595733", "Kardam\,\ Dobr\.",
"3598665", "Iskra\,\ Silistra",
"3596027", "Dralfa",
"3593191", "Brezovo\,\ Plovdiv",
"3595130", "General\ Kiselovo",
"3594522", "Korten",
"3596950", "Gumoshtnik",
"3597545", "Kochan",
"3594751", "Voynika",
"35941489", "Bozduganovo",
"35935392", "Dyulevo\,\ Pazardzhik",
"3596119", "Dichin",
"3595941", "Skalak\,\ Burgas",
"3597165", "Milanovo\,\ Sofia",
"35941276", "Mogila\,\ St\.\ Zagora",
"35951127", "Razdelna\,\ Varna",
"35960382", "Kovachevets",
"3597715", "Studena\,\ Pernik",
"3593120", "Hrabrino",
"3596114", "Kilifarevo",
"3599169", "Rogozen",
"3595141", "Staro\ Oryahovo",
"3596919", "Slatina\,\ Lovech",
"3598623", "Golesh\,\ Silistra",
"3598164", "Pisanets",
"35963568", "Bukovlak",
"3599719", "Asparuhovo\,\ Mont\.",
"3595312", "Dibich",
"3596914", "Slivek",
"3594717", "Chargan",
"3599164", "Krushovitsa\,\ Vratsa",
"35931606", "Voden\,\ Plovdiv",
"3593920", "Zlatopole",
"3593115", "Kuklen",
"3597720", "Priboy",
"3599544", "Studeno\ buche",
"3599549", "Dolna\ Riksa",
"3593765", "Ivanovo\,\ Hask\.",
"3596150", "Zlataritsa",
"3597048", "Blazhievo",
"35941171", "Dalboki",
"3597056", "Mursalevo",
"3596146", "Polski\ Senovets",
"3595763", "Plachidol",
"3598635", "Tsar\ Samuil",
"3596158", "Sredni\ kolibi",
"3598675", "Aydemir",
"3597728", "Drugan",
"3593928", "Dolno\ Belevo",
"35967395", "Gorna\ Rositsa",
"3594736", "Svetlina",
"35984392", "Belintsi",
"3596566", "Dolni\ Vit",
"3596328", "Oresh",
"3596981", "Petrevene",
"3595396", "Lovets\,\ Shumen",
"3597031", "Gorna\ Koznitsa",
"35981461", "Karan\ Varbovka",
"35963573", "Disevitsa",
"3593128", "Zlatitrap",
"35967309", "Agatovo",
"3599516", "Lehchevo",
"35960376", "Lyublen",
"3596946", "Chavdartsi",
"359301", "Smolyan",
"3596958", "Apriltsi\,\ Lovech",
"35963574", "Todorovo\,\ Pleven",
"3594553", "Rakovo\,\ Sliven",
"3595913", "Krushevets",
"3595138", "Dobrotich",
"3593346", "Muldava",
"3599746", "Razgrad\,\ Mont\.",
"359745", "Petrich\,\ Blag\.",
"3593102", "Karadzhovo",
"35930456", "Chavdar\,\ Smol\.",
"359431", "Kazanlak",
"3598673", "Alfatar",
"35967396", "Berievo",
"3595115", "General\ Kantardzhievo",
"35965617", "Iskar\,\ Pleven",
"3599542", "Smolyanovtsi",
"3595765", "Lovchantsi",
"3593561", "Septemvri",
"3598633", "Staro\ selo\,\ Silistra",
"3595314", "Belokopitovo",
"3599162", "Mihaylovo\,\ Vratsa",
"3596912", "Bahovitsa",
"3595319", "Drumevo",
"35960375", "Garchinovo",
"3596112", "Samovodene",
"35984779", "Zdravets\,\ Razgrad",
"3595120", "Bozveliysko",
"35937701", "Sladun",
"3594597", "Borov\ dol",
"3593130", "Karavelovo\,\ Plovdiv",
"3594524", "Kamenovo\,\ Sliven",
"359357", "Panagyurishte",
"35961307", "Stambolovo\,\ V\.\ Tarnovo",
"3595915", "Balgarovo",
"3597741", "Zemen",
"3599527", "Varshets",
"3594529", "Sadievo\,\ Sliven",
"35941275", "Lyaskovo\,\ St\.\ Zagora",
"3593178", "Krasnovo",
"3593104", "Yagodovo\,\ Plovdiv",
"3593109", "Lilkovo",
"3595102", "Padina\,\ Varna",
"3593138", "Vedrare",
"3595346", "Kamenyak\,\ Shumen",
"3597713", "Rudartsi",
"3595128", "Zhitnitsa\,\ Varna",
"3596905", "Divchovoto",
"3597163", "Iskrets",
"35984722", "Yasenovets",
"3598625", "Oven",
"3596067", "Kralevo\,\ Targ\.",
"35959408", "Razhitsa",
"3593763", "Balgarin",
"35931605", "Bukovo\,\ Plovdiv",
"3594726", "Malomirovo",
"3593113", "Branipole",
"35930414", "Devin",
"3594142", "Troyanovo\,\ St\.\ Zagora",
"3597159", "Aprilovo\,\ Sofia",
"3597426", "Marikostinovo",
"3593710", "Uzundzhovo",
"3597125", "Govedartsi",
"3596724", "Yantra\,\ Gabr\.",
"35971220", "Gutsal",
"35961607", "Balkantsi\,\ V\.\ Tarnovo",
"3597154", "Stolnik",
"3596732", "Sennik",
"35930413", "Devin",
"3597910", "Bersin",
"3594562", "Kriva\ krusha",
"3599354", "Antimovo\,\ Vidin",
"3598132", "Yudelnik",
"3596001", "Cherkovna\,\ Targ\.",
"359751", "Gotse\ Delchev",
"35953221", "Stoyan\ Mihaylovski",
"3593754", "Lozen\,\ Hask\.",
"35984760", "Trapishte",
"3599172", "Selanovtsi",
"3593696", "Pchelarovo\,\ Kardzh\.",
"35969241", "Yoglav",
"3597110", "Opitsvet",
"3595521", "Venets\,\ Burgas",
"3593725", "Stamboliyski\,\ Hask\.",
"3594357", "Gorno\ Sahrane",
"3599132", "Knezha",
"3599325", "Belo\ pole\,\ Vidin",
"3595752", "Nova\ Kamena",
"3593759", "Borislavtsi",
"3599129", "Sinyo\ bardo",
"3595735", "Krasen\,\ Dobr\.",
"3595590", "Zhitosvyat",
"3598663", "Sitovo\,\ Silistra",
"3598124", "Novgrad",
"3597925", "Gyueshevo",
"359728", "Zlatitsa",
"35941117", "Kazanka",
"3598129", "Lom\ Cherkovna",
"35931992", "Padarsko",
"359519", "Devnya",
"3599124", "Tipchenitsa",
"3595775", "Polkovnik\ Dyakovo",
"3598448", "Terter",
"35941144", "Kaloyanovets",
"35977229", "Galabnik",
"359702", "Bobov\ dol",
"3593773", "Kapitan\ Andreevo",
"3596526", "Varbitsa\,\ Pleven",
"35931705", "Gorna\ mahala",
"3599333", "Boynitsa",
"35958", "Dobrich",
"3595723", "Gurkovo\,\ Dobr\.",
"3597933", "Gramazhdano",
"3597118", "Dragovishtitsa\,\ Sofia",
"3597187", "Bunovo\,\ Sofia",
"35974407", "Kremen\,\ Blag\.",
"3596077", "Stevrek",
"3593045", "Dospat",
"3594343", "Konare\,\ St\.\ Zagora",
"3597133", "Pravets",
"3597918", "Yabalkovo\,\ Kyust\.",
"3598431", "Isperih",
"3593548", "Pashovo",
"3593556", "Radilovo",
"359538", "Veliki\ Preslav",
"3596044", "Dolno\ Kozarevo",
"3593168", "Ezerovo\,\ Plovdiv",
"3593787", "Tyanevo\,\ Hask\.",
"3599318", "Bukovets\,\ Vidin",
"3593718", "Voyvodovo\,\ Hask\.",
"3596049", "Kamburovo",
"3599131", "Dobrolevo",
"3593529", "Mokrishte",
"3595522", "Iskra\,\ Burgas",
"35984778", "Bogdantsi\,\ Razgrad",
"3595751", "Tervel\,\ Dobr\.",
"3593555", "Nova\ mahala\,\ Pazardzhik",
"359453", "Kotel",
"359457", "Nova\ Zagora",
"3597433", "Kresna",
"3598131", "Borisovo\,\ Ruse",
"3596002", "Saedinenie\,\ Targ\.",
"359676", "Dryanovo\,\ Gabr\.",
"3596510", "Totleben",
"3599171", "Oryahovo\,\ Vratsa",
"3594130", "Spasovo\,\ St\.\ Zagora",
"3593524", "Apriltsi\,\ Pazardzhik",
"3593643", "Golyama\ Chinka",
"3596028", "Vardun",
"3595534", "Karageorgievo",
"3595579", "Vedrovo",
"3593532", "Strelcha",
"3595539", "Chernograd",
"35947356", "Mramor\,\ Yambol",
"3595574", "Saedinenie\,\ Burgas",
"3595967", "Bata",
"35984737", "Raynino",
"35931702", "Dolna\ mahala\,\ Plovdiv",
"3596525", "Barkach",
"3595717", "Vedrina",
"35935257", "Saraya",
"3596559", "Gostilya",
"3599140", "Gabare",
"3596554", "Krushovene",
"35996", "Montana",
"3595167", "Venchan",
"3598140", "Borovo\,\ Ruse",
"3593058", "Mugla",
"3593046", "Barutin",
"359331", "Asenovgrad",
"3599560", "Bezdenitsa",
"359971", "Lom",
"3596533", "Stezherovo",
"3599568", "Blagovo\,\ Mont\.",
"3593726", "Klokotnitsa",
"3594113", "Preslaven",
"3599326", "Gorni\ Lom",
"35984763", "Beli\ Lom",
"35959409", "Cheresha",
"35953436", "Chernoglavtsi",
"3594763", "Irechekovo",
"3593695", "Komuniga",
"3596573", "Koynare",
"3593050", "Bukova\ polyana",
"3598148", "Gorno\ Ablanovo",
"35974327", "Novo\ Delchevo",
"3598156", "Cherven\,\ Ruse",
"3595776", "Cherna\,\ Dobr\.",
"3598424", "Tsar\ Kaloyan\,\ Razgrad",
"3599148", "Barkachevo",
"3593657", "Zhaltusha",
"359590", "Tsarevo",
"3595736", "Vasilevo",
"35984764", "Seydol",
"3597926", "Konyavo",
"3593019", "Pisanitsa",
"3596020", "Lilyak",
"3597425", "Kulata",
"3597126", "Gorni\ Okol",
"35931995", "Streltsi\,\ Plovdiv",
"35971224", "Shipochane",
"3594138", "Gita",
"3596518", "Riben",
"3594109", "Trakia",
"35930410", "Breze\,\ Smol\.",
"3594104", "Kravino",
"3596587", "Petokladentsi",
"3595553", "Orlintsi",
"3595944", "Ruen\,\ Burgas",
"3598626", "Sredishte\,\ Silistra",
"3593127", "Tsaratsovo",
"3595949", "Planinitsa\,\ Burgas",
"359817", "Byala\,\ Ruse",
"3596111", "Kapinovo\,\ V\.\ Tarnovo",
"35963577", "Pelishat",
"3597742", "Kalishte",
"3595137", "Kaloyan",
"3593194", "Zelenikovo\,\ Plovdiv",
"3594725", "Lesovo",
"359308", "Madan\,\ Smol\.",
"3597053", "Kocherinovo",
"35960386", "Voditsa\,\ Targ\.",
"3596957", "Golyama\ Zhelyazna",
"3594754", "Kamenets\,\ Yambol",
"3597727", "Kovachevtsi\,\ Pernik",
"3595345", "Razvigorovo",
"3599541", "Doktor\ Yosifovo",
"3593562", "Slavovitsa\,\ Pazardzhik",
"35937421", "Dolno\ pole",
"3596157", "Slivovitsa",
"35931602", "Tatarevo\,\ Plovdiv",
"3596906", "Cherni\ Vit",
"3596327", "Ovcha\ mogila",
"3595144", "Kamchia",
"35984725", "Kichenitsa",
"3598161", "Vetovo",
"3594710", "Bolyarsko",
"3593927", "Chernogorovo\,\ Hask\.",
"359677", "Tryavna",
"3596911", "Lisets\,\ Lovech",
"3599161", "Mizia",
"3593142", "Brestovitsa\,\ Plovdiv",
"3595149", "Golitsa",
"3599784", "Kiselevo",
"3596989", "Toros",
"3594718", "Roza",
"35984712", "Kostandenets",
"3596984", "Bezhanovo\,\ Lovech",
"3599513", "Boychinovtsi",
"3594556", "Sotirya",
"35931398", "Slatina\,\ Plovdiv",
"3597047", "Usoyka",
"3596943", "Gorsko\ Slivovo",
"3595916", "Rosen\,\ Burgas",
"3593343", "Kozanovo",
"3595101", "Dabravino",
"3595766", "Metodievo\,\ Dobr\.",
"35941331", "Granit",
"3596143", "Maslarevo",
"35961203", "Emen",
"3595116", "Krumovo\,\ Varna",
"359361", "Kardzhali",
"35960372", "Krepcha",
"3597034", "Dzherman",
"3594733", "Orlov\ dol",
"3595393", "Ivanovo\,\ Shumen",
"3594773", "Okop",
"35936401", "Strandzhevo",
"3597039", "Samoranovo",
"3596563", "Brest\,\ Pleven",
"3595311", "Gradishte\,\ Shumen",
"35951538", "Izgrev\,\ Varna",
"3599515", "Madan\,\ Mont\.",
"3596068", "Bozhurka",
"35967392", "Yavorets",
"3595142", "Dolni\ chiflik",
"3593149", "Tsalapitsa",
"35984745", "Vladimirovtsi",
"35963570", "Staroseltsi",
"3593345", "Lyaskovo\,\ Plovdiv",
"3599745", "Zlatia\,\ Mont\.",
"3593569", "Karabunar",
"3593937", "Yabalkovo\,\ Hask\.",
"3593564", "Semchinovo",
"35962", "Veliko\ Tarnovo",
"35935501", "Ravnogor",
"3598676", "Vetren\,\ Silistra",
"3594752", "Parvenets\,\ Yambol",
"3593137", "Klisura\,\ Plovdiv",
"35941351", "Partizanin",
"3593177", "Novo\ Zhelezare",
"3596145", "Strahilovo",
"3597744", "Elovdol\,\ Pernik",
"3598636", "Glavinitsa\,\ Silistra",
"3593192", "Babek",
"3599520", "Gorno\ Ozirovo",
"3596565", "Milkovitsa",
"3594775", "Karavelovo\,\ Yambol",
"3595395", "Chernookovo\,\ Shumen",
"3595942", "Lyulyakovo\,\ Burgas",
"3595127", "Manastir\,\ Varna",
"35961303", "Gorna\ Lipnitsa",
"3597032", "Yahinovo",
"35961703", "Varbitsa\,\ V\.\ Tarnovo",
"35974201", "Kapatovo",
"35935419", "Sveta\ Petka",
"35960385", "Lomtsi",
"3599528", "Gaganitsa",
"3593766", "Biser",
"35961304", "Dimcha",
"3593101", "Voyvodinovo",
"3593116", "Krumovo\,\ Plovdiv",
"3594723", "Boyanovo\,\ Yambol",
"35961704", "Pravda\,\ V\.\ Tarnovo",
"35984726", "Ushintsi",
"3597546", "Slashten",
"3595343", "Venets\,\ Shumen",
"35961108", "Plakovo",
"3596982", "aglen",
"3599782", "Bukovets\,\ Mont\.",
"3596060", "Ovcharovo\,\ Targ\.",
"3597166", "Vlado\ Trichkov",
"3593693", "Lyaskovo\,\ Kardzh\.",
"3596575", "Telish",
"3593547", "Sarnitsa\,\ Pazardzhik",
"35984730", "Golyam\ Porovets",
"35963202", "Dragomirovo\,\ V\.\ Tarnovo",
"3594115", "Kirilovo\,\ St\.\ Zagora",
"35963569", "Kamenets\,\ Pleven",
"3596535", "Kozar\ Belene",
"3597917", "Tavalichevo",
"3593717", "Konush\,\ Hask\.",
"3599317", "Archar",
"3596552", "Dolna\ Mitropolia",
"3598666", "Tutrakan",
"3593167", "Bryagovo\,\ Plovdiv",
"35961502", "Gorsko\ Novo\ Selo",
"35953435", "Izgrev\,\ Shumen",
"3593534", "Popintsi",
"3595572", "Beronovo",
"35991184", "Rakevo",
"3597423", "Kolarovo\,\ Blag\.",
"35960453", "Moravka",
"35974403", "Dolno\ Draglishte",
"3595532", "Topolitsa",
"3599121", "Tsarevets\,\ Vratsa",
"3593751", "Lyubimets",
"3595555", "Fakia",
"3599351", "Izvor\,\ Vidin",
"3596004", "Makovo",
"3597188", "Petrich\,\ Sofia",
"35947201", "Izgrev\,\ Yambol",
"35969032", "Balgarski\ izvor",
"3595529", "Krushovo\,\ Burgas",
"3593522", "Gelemenovo",
"35991183", "Furen",
"35931996", "Svezhen",
"3595524", "Ekzarh\ Antimovo",
"3597117", "Gradets\,\ Sofia",
"35974404", "Babyak",
"3594350", "Gorno\ Izvorovo",
"35960454", "Zmeyno",
"3594102", "Yastrebovo\,\ St\.\ Zagora",
"3594358", "Skobelevo\,\ St\.\ Zagora",
"3597136", "Novachene\,\ Sofia",
"3597435", "Sklave",
"3594346", "Golyamo\ Dryanovo",
"3596030", "Svetlen\,\ Targ\.",
"35967308", "Lovnidol",
"35941113", "Pryaporets\,\ St\.\ Zagora",
"3593553", "Batak\,\ Pazardzhik",
"3597176", "Hrabarsko",
"359721", "Kostinbrod",
"35941114", "Lozen\,\ St\.\ Zagora",
"3593645", "Avren\,\ Kardzh\.",
"3593776", "Raykova\ mogila",
"35930417", "Grohotno",
"3599336", "Staropatitsa",
"35974347", "Razdol",
"35961604", "Mirovo\,\ V\.\ Tarnovo",
"3596523", "Krushovitsa\,\ Pleven",
"35930200", "Zagrazhden\,\ Smol\.",
"3597936", "Slokoshtitsa",
"3595726", "Tsarichino",
"35961603", "Lozen\,\ V\.\ Tarnovo",
"359865", "Silistra",
"35937704", "Mladinovo",
"3593025", "Banite",
"359478", "Elhovo\,\ Yambol",
"3596716", "Zhaltesh",
"35974207", "General\ Todorov",
"3597193", "Golesh\,\ Sofia",
"3593059", "Kutela",
"3593054", "Podvis\,\ Smol\.",
"3595743", "Shabla",
"3596166", "Vinograd",
"3595784", "Vrachantsi",
"3596558", "Slavovitsa\,\ Pleven",
"35937703", "Dimitrovche",
"3596546", "Lozitsa\,\ Pleven",
"3593651", "Ardino",
"3595513", "Gabar",
"3593782", "Kalugerovo\,\ Hask\.",
"3594153", "Madrets\,\ St\.\ Zagora",
"3595578", "Terziysko\,\ Burgas",
"3596029", "Nadarevo",
"35963566", "Brashlyanitsa",
"35971304", "Lipnitsa\,\ Sofia",
"3596024", "Ruets",
"3595538", "Karanovo\,\ Burgas",
"35959405", "Zaychar",
"3597182", "Mirkovo",
"35941330", "Tsenovo\,\ St\.\ Zagora",
"3593528", "Govedare",
"3596072", "Dobrotitsa\,\ Targ\.",
"3598116", "Ivanovo\,\ Ruse",
"3596032", "Zaraevo",
"3594323", "Tulovo",
"3596966", "Shipkovo",
"3594100", "Stoletovo\,\ St\.\ Zagora",
"3599116", "Kostelevo",
"3596581", "Byala\ voda\,\ Pleven",
"3594352", "Gorno\ Cherkovishte",
"35984718", "Dryanovets\,\ Razgrad",
"3599137", "Popitsa",
"3598192", "Hotantsa",
"3594108", "Vasil\ Levski\,\ St\.\ Zagora",
"3596519", "Beglezh",
"3593636", "Raven",
"3595757", "Bezmer\,\ Dobr\.",
"35984467", "Seslav",
"3594139", "Svoboda\,\ St\.\ Zagora",
"3596514", "Dolni\ Dabnik",
"3598137", "Golyamo\ Vranovo",
"3593676", "Benkovski\,\ Kardzh\.",
"3593520", "Miryantsi",
"3594134", "Bratya\ Daskalovi",
"35971338", "Osikovska\ Lakavitsa",
"3595530", "Peshtersko",
"359517", "Dalgopol",
"35931792", "Chernichevo\,\ Plovdiv",
"35931392", "Dabene",
"3597145", "Mirovo\,\ Sofia",
"3594122", "Elenino",
"3594335", "Razhena",
"3597446", "Eleshnitsa\,\ Blag\.",
"3595570", "Manolich",
"359335", "Karlovo",
"3599144", "Nivyanin",
"35941357", "Zetyovo\,\ St\.\ Zagora",
"3598149", "Katselovo",
"3595711", "Ovcharovo\,\ Dobr\.",
"3593515", "Kalugerovo\,\ Pazardzhik",
"3598144", "Batishnitsa",
"3594147", "Lyubenovo\,\ St\.\ Zagora",
"3599149", "Bukovets\,\ Vratsa",
"35977222", "Gorna\ Dikanya",
"3595161", "Vetrino",
"3593073", "Startsevo",
"3596550", "Stavertsi",
"3594567", "Banya\,\ Sliven",
"35930458", "Lyubcha",
"3599345", "Vinarovo\,\ Vidin",
"3599569", "Lipen",
"3593745", "Malak\ izvor\,\ Hask\.",
"3596737", "Krushevo\,\ Gabr\.",
"3599564", "Stubel",
"35937420", "Podkrepa",
"35960378", "Tsar\ Asen\,\ Targ\.",
"3599183", "Lilyache",
"359670", "Troyan\,\ Lovech",
"3596062", "Strazha\,\ Targ\.",
"35969244", "Tepava",
"3595148", "Rudnik\,\ Varna",
"3596980", "Belentsi",
"3597041", "Shatrovo",
"3595326", "Varbyane",
"35931708", "Pesnopoy\,\ Plovdiv",
"35931308", "Bogdan\,\ Plovdiv",
"35953223", "Tsarkvitsa",
"3597523", "Garmen",
"35969243", "Kazachevo",
"3594746", "Popovo\,\ Yambol",
"35937603", "Rogozinovo",
"3599553", "Prevala",
"35930411", "Devin",
"3593198", "Chehlare",
"35937604", "Varbovo\,\ Hask\.",
"3596136", "Suhindol",
"3598645", "Mezhden",
"3594516", "Kermen",
"3597030", "Resilovo",
"3595948", "Snyagovo\,\ Burgas",
"359910", "Mezdra",
"3596176", "Polikraishte",
"3594592", "Byala\ palanka",
"3593121", "Rogosh",
"35984729", "Ezerche",
"3596117", "Debelets\,\ V\.\ Tarnovo",
"3595131", "Valchi\ dol",
"3593190", "Varben\,\ Plovdiv",
"3599522", "Kotenovtsi",
"359596", "Pomorie",
"359359", "Velingrad",
"35991202", "Kunino",
"3599547", "Vinishte",
"35931388", "Beguntsi",
"35971502", "Eleshnitsa\,\ Sofia",
"3598693", "Zvenimir",
"3596151", "Elena\,\ V\.\ Tarnovo",
"3594583", "Kipilovo",
"3596321", "Gorna\ Studena",
"3596988", "Peshterna",
"3595140", "Shkorpilovtsi",
"3598167", "Tserovets",
"3593921", "Merichleri",
"35956", "Burgas",
"3593666", "Popsko",
"3596917", "Balgarene\,\ Lovech",
"3594714", "Drazhevo",
"3599167", "Lipnitsa\,\ Vratsa",
"359748", "Simitli",
"359554", "Sunny\ Beach",
"35975214", "Gaytaninovo",
"35951104", "Dolishte\,\ Varna",
"35961393", "Gorsko\ Kosovo",
"3593107", "Graf\ Ignatievo",
"35961394", "Daskot",
"35951103", "Lyuben\ Karavelovo",
"3596126", "Tserova\ koria",
"35974321", "Harsovo\,\ Blag\.",
"35930256", "Galabovo\,\ Smol\.",
"3598695", "Nozharevo",
"3599726", "Zamfir",
"3593568", "Vinogradets",
"3593326", "Patriarh\ Evtimovo",
"3594363", "Gabarevo",
"3596926", "Gorno\ Pavlikene",
"3594796", "General\ Toshevo\,\ Yambol",
"3596069", "Vasil\ Levski\,\ Targ\.",
"3597533", "Osikovo\,\ Blag\.",
"35960389", "Kardam\,\ Targ\.",
"3593156", "Shishmantsi",
"3595336", "Imrenchevo",
"3593148", "Yoakim\ Gruevo",
"3596064", "Golyamo\ Novo",
"3594585", "Zheravna",
"3595317", "Ivanski",
"3594712", "Kabile",
"3597731", "Tran",
"35967302", "Kravenik",
"3597525", "Banichan",
"3593931", "Kasnakovo",
"3599555", "Kopilovtsi\,\ Mont\.",
"3595351", "Smyadovo",
"3594527", "Zagortsi\,\ Sliven",
"3599529", "Borovtsi",
"3599524", "Yagodovo\,\ Mont\.",
"359559", "Karnobat",
"35935251", "Bratanitsa",
"3594599", "Chervenakovo",
"35984749", "Sevar",
"3598643", "Zlatoklas",
"3595121", "Tutrakantsi",
"3595528", "Nevestino\,\ Burgas",
"3596034", "Slavyanovo\,\ Targ\.",
"3595366", "Branichevo",
"35941173", "Bratya\ Kunchevi",
"3597189", "Chavdar\,\ Sofia",
"35951429", "Solnik",
"3597184", "Koprivshtitsa",
"3596039", "Opaka",
"35967398", "Damyanovo",
"3596074", "Lyubichevo",
"35941174", "Podslon\,\ St\.\ Zagora",
"3594333", "Dabovo\,\ St\.\ Zagora",
"3597143", "Vakarel",
"3596022", "Probuda\,\ Targ\.",
"3593538", "Elshitsa",
"359861", "Silistra",
"3596047", "Zelena\ morava",
"3593075", "Dolen\,\ Smol\.",
"3593784", "Konstantinovo\,\ Hask\.",
"3593513", "Malo\ Konare",
"3595782", "Benkovski\,\ Dobr\.",
"35941337", "Sarnevets",
"3593035", "Varbina",
"35967194", "Grablevtsi",
"359725", "Elin\ Pelin",
"3599185", "Beli\ Izvor",
"3593052", "Laki\,\ Plovdiv",
"3593743", "Silen",
"35967193", "Kmetovtsi",
"3598185", "Senovo",
"3599343", "Gomotartsi",
"35957304", "Dabovik",
"35941018", "Knyazhevsko",
"3595745", "Vranino",
"35981464", "Ostritsa\,\ Ruse",
"3597911", "Granitsa",
"359777", "Radomir",
"3593023", "Momchilovtsi",
"3599311", "Kutovo",
"3598142", "Bazovets\,\ Ruse",
"3593711", "Dolno\ Botevo",
"3595515", "Kameno",
"3596727", "Ganchovets",
"35963571", "Brestovets",
"35981463", "Mogilino",
"3599142", "Lazarovo",
"3593706", "Tankovo\,\ Hask\.",
"3597157", "Sarantsi",
"3593530", "Poibrene",
"3594124", "Zmeyovo",
"35959406", "Razboyna\,\ Burgas",
"3598127", "Karamanovo",
"3594129", "Madzherito",
"3593586", "Borimechkovo",
"3593626", "Perperek",
"3599127", "Lyutidol",
"3594155", "Glavan\,\ St\.\ Zagora",
"3597106", "Yamna",
"3596512", "Gorni\ Dabnik",
"3594325", "Kanchevo",
"3593757", "Georgi\ Dobrevo",
"3594132", "Orizovo",
"3594359", "Asen\,\ St\.\ Zagora",
"35963565", "Mechka\,\ Pleven",
"35961102", "Pchelishte",
"3594354", "Zimnitsa\,\ St\.\ Zagora",
"3598194", "Sandrovo",
"3595520", "Cherkovo",
"35941350", "Mirovo\,\ St\.\ Zagora",
"3593585", "Akandzhievo",
"3593625", "Shiroko\ pole",
"3595781", "Svoboda\,\ Dobr\.",
"35941354", "Malko\ Tranovo",
"3594156", "Aprilovo\,\ St\.\ Zagora",
"35960388", "Goritsa\,\ Targ\.",
"3598113", "Novo\ selo\,\ Ruse",
"35941353", "Plodovitovo",
"3596738", "Dobromirka",
"3593051", "Chepelare",
"3597105", "Malki\ Iskar",
"3594326", "Enina",
"3596963", "Balkanets",
"3599113", "Mramoren",
"3596713", "Vranilovtsi",
"35963562", "Komarevo\,\ Pleven",
"3596589", "Kulina\ voda",
"3598138", "Brashlen",
"35984464", "Veselets\,\ Razgrad",
"3594107", "Sredets\,\ St\.\ Zagora",
"3599138", "Altimir",
"3596163", "Kamen\,\ V\.\ Tarnovo",
"3595746", "Belgun",
"3596584", "Belene",
"3595758", "Kladentsi",
"35961105", "Prisovo",
"3596543", "Muselievo",
"3593705", "Vaglarovo",
"35984463", "Prelez",
"3595516", "Indzhe\ voyvoda",
"3596021", "Buhovtsi",
"3598442", "Zavet\,\ Razgrad",
"3595969", "Galabets\,\ Burgas",
"3595537", "Sadievo\,\ Burgas",
"3593036", "Mogilitsa",
"3593076", "Tsatsarovtsi",
"3595577", "Podvis\,\ Burgas",
"3595750", "Kableshkovo\,\ Dobr\.",
"35964", "Pleven",
"3599130", "Tlachene",
"3599186", "Zgorigrad",
"3596511", "Pobeda\,\ Pleven",
"35931396", "Domlyan",
"359953", "Berkovitsa",
"3593527", "Aleko\ Konstantinovo",
"35931402", "Skobelevo\,\ Plovdiv",
"3596770", "Plachkovtsi",
"35974204", "Gega",
"3593633", "Rogozche",
"35937707", "Shtit",
"3597912", "Gorna\ Grashtitsa",
"3593542", "Rakitovo",
"3599561", "Sumer",
"3595365", "Lyatno",
"3593673", "Tihomir",
"35977226", "Debeli\ lag",
"359416", "Chirpan",
"3595169", "Momchilovo",
"3599141", "Malorad",
"3593162", "Gradina\,\ Plovdiv",
"35946", "Yambol",
"3595714", "Karapelit",
"35974203", "Rupite",
"359454", "Tvarditsa\,\ Sliven",
"3595719", "Donchevo",
"3593712", "Malevo\,\ Hask\.",
"3598141", "Dve\ mogili",
"3596557", "Bregare",
"3599312", "Bregovo\,\ Vidin",
"3595164", "Neofit\ Rilski",
"3594140", "Polski\ Gradets",
"35961301", "Byala\ reka\,\ V\.\ Tarnovo",
"3597044", "Babino",
"3594743", "Mamarchevo",
"3599556", "Govezhda",
"35947203", "Trankovo\,\ Yambol",
"35984776", "Harsovo\,\ Razgrad",
"3599548", "Krapchene",
"3599787", "Smirnenski\,\ Mont\.",
"35974401", "Gorno\ Draglishte",
"35960451", "Obitel",
"3594513", "Gavrailovoc",
"3599168", "Butan",
"3596918", "Drenov",
"3596133", "Mihaltsi",
"3596173", "Dolna\ Oryahovitsa",
"3596987", "Karlukovo",
"35967305", "Stokite",
"35947204", "Pchela",
"35951428", "Gospodinovo\,\ Varna",
"3596118", "Voneshta\ voda",
"3596933", "Golets",
"3595153", "Suvorovo",
"35967399", "Malki\ Varshets",
"3595100", "Sindel",
"3595323", "Pliska",
"3597526", "Ribnovo",
"359550", "Sozopol",
"3596959", "Debnevo",
"3595134", "Cherventsi",
"3593197", "Tyurkmen",
"3596925", "Vladinya",
"3598696", "Suhodol\,\ Silistra",
"3595352", "Yankovo",
"3595108", "Sadovo\,\ Varna",
"3599725", "Komoshtitsa",
"3596954", "Vrabevo",
"3595139", "Oborishte\,\ Varna",
"3593132", "Banya\,\ Plovdiv",
"3593325", "Cherven\,\ Plovdiv",
"3594757", "Nedyalsko",
"3595947", "Prosenik",
"3593155", "Momino\ selo",
"3595335", "Milanovo\,\ Shumen",
"3593129", "Skutare",
"3595122", "Slaveykovo\,\ Varna",
"3594586", "Neykovo\,\ Sliven",
"3593124", "Kalekovets",
"3594795", "Skalitsa",
"359417", "Radnevo",
"3596324", "Vardim",
"3597732", "Vukan",
"3595147", "Pchelnik\,\ Varna",
"35941019", "Venets\,\ St\.\ Zagora",
"3593929", "Golyamo\ Asenovo",
"3599160", "Glozhene\,\ Vratsa",
"3596910", "Malinovo",
"35971506", "Gabra",
"3593924", "Krepost",
"3596329", "Tsarevets\,\ V\.\ Tarnovo",
"35969247", "Gostinya",
"3594711", "Bezmer\,\ Yambol",
"3596159", "Zlataritsa",
"3599540", "Belotintsi",
"3597724", "Izvor\,\ Pernik",
"3596125", "Pushevo",
"3597729", "Dolna\ Dikanya",
"35941111", "Starozagorski\ bani",
"3596154", "Buynovtsi",
"3593932", "Bodrovo",
"3597755", "Velkovtsi\,\ Pernik",
"3593100", "Belashtitsa",
"3593323", "Bolyartsi\,\ Plovdiv",
"3599723", "Traykovo",
"3594528", "Lyubenova\ mahala",
"359350", "Peshtera\,\ Pazardzhik",
"3596923", "Goran",
"3593665", "Svirachi",
"3594793", "Boyadzhik",
"3595333", "Han\ Krum",
"3593153", "Stryama",
"3595318", "Srednya",
"3596061", "Golyamo\ Sokolovo",
"3597753", "Noevtsi",
"35931998", "Choba",
"35961403", "Orlovets",
"3596123", "Bukovets\,\ V\.\ Tarnovo",
"3597042", "Korkina",
"35941279", "Strelets\,\ St\.\ Zagora",
"359938", "Kula",
"35971505", "Churek",
"3596152", "Bebrovo",
"3593934", "Skobelevo\,\ Hask\.",
"3594745", "Sharkovo",
"35967306", "Gradishte\,\ Gabr\.",
"3593567", "Kovachevo\,\ Pazardzhik",
"35930459", "Brashten",
"3593922", "Brod",
"3593147", "Novo\ selo\,\ Plovdiv",
"3596175", "Parvomaytsi",
"3595310", "Radko\ Dimitrievo",
"3596322", "Alekovo\,\ V\.\ Tarnovo",
"3596135", "Varbovka",
"3598646", "Vokil",
"3597734", "Glavanovtsi\,\ Pernik",
"3594515", "Mokren",
"35971221", "Yarlovo",
"3593122", "Manole",
"3595129", "Blaskovo",
"35984719", "Balkanski",
"35971471", "Ochusha",
"3596935", "Sopot\,\ Lovech",
"3595124", "Komarevo\,\ Varna",
"35969240", "Hlevene",
"3595354", "Rish",
"35984761", "Gradina\,\ Razgrad",
"3596952", "Oreshak\,\ Lovech",
"35953220", "Pamukchii\,\ Shumen",
"3593134", "Sopot\,\ Plovdiv",
"3594520", "Konyovo",
"3593174", "Staro\ Zhelezare",
"3599521", "Zamfirovo",
"3595132", "Mihalich\,\ Varna",
"3595325", "Voyvoda",
"35961397", "Musina",
"3593108", "Boykovo",
"35937424", "Kozlets",
"3599128", "Eliseyna",
"35951536", "Nikolaevka",
"35969614", "Gorno\ trape",
"3598128", "Polsko\ Kosovo",
"3593516", "Tsrancha\,\ Pazardzhik",
"35931395", "Iganovo",
"3596582", "Belene",
"35937423", "Golemantsi",
"3593758", "Yerusalimovo",
"3597181", "Pirdop",
"3599346", "Sinagovtsi",
"3596071", "Antonovo",
"3593746", "Sirakovo\,\ Hask\.",
"35969613", "Chiflik\,\ Lovech",
"3593675", "Fotinovo\,\ Kardzh\.",
"3595363", "Gusla",
"3598477", "Samuil",
"3593652", "Byal\ izvor\,\ Kardzh\.",
"35931709", "Mihiltsi",
"3597146", "Chernyovo",
"3597445", "Banya\,\ Blag\.",
"3597158", "Doganovo",
"3594336", "Dolno\ Izvorovo",
"3593781", "Simeonovgrad",
"35955504", "Bogdanovo\,\ Burgas",
"35931309", "Kliment\,\ Plovdiv",
"3596728", "Burya",
"3596720", "Kereka",
"3599314", "Dunavtsi\,\ Vidin",
"3595162", "Belogradets",
"35941334", "Saedinenie\,\ St\.\ Zagora",
"3593164", "Dalbok\ izvor",
"3596048", "Izvorovo\,\ Targ\.",
"3593583", "Gabrovitsa",
"3593623", "Boyno",
"3593719", "Knizhovnik",
"3595712", "Stozher",
"3599319", "Gamzovo",
"3593544", "Kostandovo",
"35947192", "Zavoy",
"3596965", "Beli\ Osam",
"3599115", "Chiren",
"3597103", "Brusen\,\ Sofia",
"3593549", "Grashevo",
"35941333", "Sredno\ gradishte",
"35957307", "Zhiten\,\ Dobr\.",
"3598115", "Chervena\ voda",
"3597914", "Vaksevo",
"3597119", "Dramsha",
"3596007", "Ralitsa",
"3596165", "Asenovo\,\ V\.\ Tarnovo",
"3593026", "Smilyan",
"35984728", "Rakovski\,\ Razgrad",
"3594351", "Koprinka",
"3595527", "Sokolovo\,\ Burgas",
"3593537", "Panagyurski\ kolonii",
"3594121", "Lyulyak",
"359868", "Silistra",
"3593703", "Zhalti\ bryag",
"3595599", "Hadzhiite",
"35961106", "Novo\ selo\,\ V\.\ Tarnovo",
"3596545", "Lyubenovo\,\ Pleven",};
my $timezones = {
               '' => [
                       'Europe/Sofia'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+359|\D)//g;
      my $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '359', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;