# automatically generated file, don't edit



# Copyright 2011 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::JP;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20210921211832;

my $formatters = [
                {
                  'format' => '$1-$2',
                  'intl_format' => 'NA',
                  'leading_digits' => '00777[01]',
                  'pattern' => '(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            (?:
              12|
              57|
              99
            )0
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{3})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              267|
              3(?:
                7[247]|
                9[278]
              )|
              466|
              5(?:
                47|
                58|
                64
              )|
              6(?:
                3[245]|
                48|
                5[4-68]
              )
            )|
            499[2468]|
            5(?:
              769|
              979[2-69]
            )|
            7468|
            8(?:
              3(?:
                8[7-9]|
                96[2457-9]
              )|
              477|
              51[2-9]|
              636[457-9]
            )|
            9(?:
              496|
              802|
              9(?:
                1[23]|
                69
              )
            )|
            1(?:
              45|
              58
            )[67]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d)(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '60',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [36]|
            4(?:
              2(?:
                0|
                9[02-69]
              )|
              7(?:
                0[019]|
                1
              )
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d)(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            1(?:
              1|
              5(?:
                4[018]|
                5[017]
              )|
              77|
              88|
              9[69]
            )|
            2(?:
              2[127]|
              3[0-269]|
              4[59]|
              5(?:
                [1-3]|
                5[0-69]|
                7[015-9]|
                9(?:
                  17|
                  99
                )
              )|
              6(?:
                2|
                4[016-9]
              )|
              7(?:
                [1-35]|
                8[0189]
              )|
              8(?:
                [16]|
                3[0134]|
                9[0-5]
              )|
              9(?:
                [028]|
                17|
                3[015-9]
              )
            )|
            4(?:
              2(?:
                [13-79]|
                8[014-6]
              )|
              3[0-57]|
              [45]|
              6[248]|
              7[2-47]|
              9[29]
            )|
            5(?:
              2|
              3[045]|
              4[0-369]|
              5[29]|
              8[02389]|
              9[0-3]
            )|
            7(?:
              2[02-46-9]|
              34|
              [58]|
              6[0249]|
              7[57]|
              9(?:
                [23]|
                4[0-59]|
                5[01569]|
                6[0167]
              )
            )|
            8(?:
              2(?:
                [1258]|
                4[0-39]|
                9(?:
                  [019]|
                  4[1-3]|
                  6(?:
                    [0-47-9]|
                    5[01346-9]
                  )
                )
              )|
              3(?:
                [29]|
                7(?:
                  [017-9]|
                  6[6-8]
                )
              )|
              49|
              51|
              6(?:
                [0-24]|
                36[23]|
                5(?:
                  [0-389]|
                  5[23]
                )|
                6(?:
                  [01]|
                  9[178]
                )|
                72|
                9[0145]
              )|
              7[0-468]|
              8[68]
            )|
            9(?:
              4[15]|
              5[138]|
              6[1-3]|
              7[156]|
              8[189]|
              9(?:
                [1289]|
                3(?:
                  31|
                  4[357]
                )|
                4[0178]
              )
            )|
            (?:
              223|
              8699
            )[014-9]|
            (?:
              25[0468]|
              422|
              838
            )[01]|
            (?:
              48|
              829(?:
                2|
                66
              )|
              9[23]
            )[1-9]|
            (?:
              47[59]|
              59[89]|
              8(?:
                68|
                9
              )
            )[019]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '
            [14]|
            [289][2-9]|
            5[3-9]|
            7[2-4679]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '0077',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'leading_digits' => '008',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '800',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'leading_digits' => '[257-9]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{3})(\\d{3,4})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{4})(\\d{4,5})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{5})(\\d{5,6})'
                },
                {
                  'format' => '$1-$2-$3',
                  'intl_format' => 'NA',
                  'pattern' => '(\\d{4})(\\d{6})(\\d{6,7})'
                }
              ];

my $validators = {
                'fixed_line' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'geographic' => '
          (?:
            1(?:
              1[235-8]|
              2[3-6]|
              3[3-9]|
              4[2-6]|
              [58][2-8]|
              6[2-7]|
              7[2-9]|
              9[1-9]
            )|
            (?:
              2[2-9]|
              [36][1-9]
            )\\d|
            4(?:
              [2-578]\\d|
              6[02-8]|
              9[2-59]
            )|
            5(?:
              [2-589]\\d|
              6[1-9]|
              7[2-8]
            )|
            7(?:
              [25-9]\\d|
              3[4-9]|
              4[02-9]
            )|
            8(?:
              [2679]\\d|
              3[2-9]|
              4[5-9]|
              5[1-9]|
              8[03-9]
            )|
            9(?:
              [2-58]\\d|
              [679][1-9]
            )
          )\\d{6}
        ',
                'mobile' => '[7-9]0[1-9]\\d{7}',
                'pager' => '20\\d{8}',
                'personal_number' => '60\\d{7}',
                'specialrate' => '(990\\d{6})|(570\\d{6})',
                'toll_free' => '
          00777(?:
            [01]|
            5\\d
          )\\d\\d|
          (?:
            00(?:
              7778|
              882[1245]
            )|
            (?:
              120|
              800\\d
            )\\d\\d
          )\\d{4}|
          00(?:
            37|
            66|
            78
          )\\d{6,13}
        ',
                'voip' => '50[1-9]\\d{7}'
              };
my %areanames = ();
$areanames{en} = {"811464", "Shizunai\,\ Hokkaido",
"812474", "Ishikawa\,\ Fukushima",
"818559", "Kawamoto\,\ Shimane",
"819737", "Kusu\,\ Oita",
"812577", "Muika\,\ Niigata",
"817468", "Kamikitayama\,\ Nara",
"812475", "Ishikawa\,\ Fukushima",
"812248", "Ogawara\,\ Miyagi",
"811465", "Shizunai\,\ Hokkaido",
"817230", "Neyagawa\,\ Osaka",
"812780", "Maebashi\,\ Gunma",
"818557", "Kawamoto\,\ Shimane",
"815768", "Gero\,\ Gifu",
"819808", "Yaeyama\ District\,\ Okinawa",
"814282", "Ome\,\ Tokyo",
"81857", "Tottori\,\ Tottori",
"8112392", "Yubari\,\ Hokkaido",
"8126171", "Omachi\,\ Nagano",
"812998", "Itako\,\ Ibaraki",
"811953", "Ninohe\,\ Iwate",
"81465", "Odawara\,\ Kanagawa",
"8183768", "Shimonoseki\,\ Yamaguchi",
"81591", "Tsu\,\ Mie",
"812386", "Nagai\,\ Yamagata",
"81828", "Hiroshima\,\ Hiroshima",
"811656", "Bifuka\,\ Hokkaido",
"818652", "Kurashiki\,\ Okayama",
"81462", "Atsugi\,\ Kanagawa",
"812832", "Sano\,\ Tochigi",
"817613", "Komatsu\,\ Ishikawa",
"818666", "Ibara\,\ Okayama",
"8183767", "Shimonoseki\,\ Yamaguchi",
"812672", "Komoro\,\ Nagano",
"8153966", "Hamamatsu\,\ Shizuoka",
"817737", "Maizuru\,\ Kyoto",
"81478", "Sawara\,\ Chiba",
"81252", "Niigata\,\ Niigata",
"81988", "Naha\,\ Okinawa",
"811868", "Takanosu\,\ Akita",
"812878", "Nasukarasuyama\,\ Tochigi",
"8126174", "Omachi\,\ Nagano",
"817353", "Shingu\,\ Fukuoka",
"818567", "Tsuwano\,\ Shimane",
"81466", "Fujisawa\,\ Kanagawa",
"815583", "Shimoda\,\ Shizuoka",
"811559", "Obihiro\,\ Hokkaido",
"818464", "Takehara\,\ Hiroshima",
"812937", "Mito\,\ Ibaraki",
"817912", "Aioi\,\ Hyogo",
"814755", "Togane\,\ Chiba",
"811454", "Mukawa\,\ Hokkaido",
"818953", "Uwajima\,\ Ehime",
"8199331", "Kagoshima\,\ Kagoshima",
"81893", "Ozu\,\ Ehime",
"812939", "Mito\,\ Ibaraki",
"814754", "Mobara\,\ Chiba",
"81157", "Kitami\,\ Hokkaido",
"814286", "Sagamihara\,\ Kanagawa",
"817903", "Fukusaki\,\ Hyogo",
"818514", "Ama\,\ Shimane",
"811455", "Mukawa\,\ Hokkaido",
"815393", "Hamamatsu\,\ Shizuoka",
"812836", "Sano\,\ Tochigi",
"812487", "Sukagawa\,\ Fukushima",
"812585", "Nagaoka\,\ Niigata",
"819825", "Hyuga\,\ Miyazaki",
"811652", "Shibetsu\,\ Hokkaido",
"812893", "Utsunomiya\,\ Tochigi",
"818656", "Kasaoka\,\ Okayama",
"812584", "Nagaoka\,\ Niigata",
"811858", "Noshiro\,\ Akita",
"812382", "Yonezawa\,\ Yamagata",
"811527", "Bihoro\,\ Hokkaido",
"815974", "Owase\,\ Mie",
"8199343", "Kagoshima\,\ Kagoshima",
"819824", "Nobeoka\,\ Miyazaki",
"812489", "Sukagawa\,\ Fukushima",
"812697", "Iiyama\,\ Nagano",
"81848", "Onomichi\,\ Hiroshima",
"81933", "Kitakyushu\,\ Fukuoka",
"818662", "Takahashi\,\ Okayama",
"8168", "Osaka\,\ Osaka",
"812676", "Saku\,\ Nagano",
"818563", "Masuda\,\ Shimane",
"81737", "Yuasa\,\ Wakayama",
"817357", "Kushimoto\,\ Wakayama",
"812996", "Itako\,\ Ibaraki",
"817452", "Yamatotakada\,\ Nara",
"812933", "Takahagi\,\ Ibaraki",
"815766", "Gero\,\ Gifu",
"8153979", "Hamamatsu\,\ Shizuoka",
"81486", "Urawa\,\ Saitama",
"812246", "Ogawara\,\ Miyagi",
"81834", "Tokuyama\,\ Yamaguchi",
"818206", "Yanai\,\ Yamaguchi",
"817466", "Totsukawa\,\ Nara",
"815752", "Sekigahara\,\ Gifu",
"818957", "Misho\,\ Ehime",
"812235", "Sendai\,\ Miyagi",
"81729", "Yao\,\ Osaka",
"811553", "Obihiro\,\ Hokkaido",
"812234", "Sendai\,\ Miyagi",
"8182943", "Hiroshima\,\ Hiroshima",
"8112398", "Kuriyama\,\ Hokkaido",
"812483", "Shirakawa\,\ Fukushima",
"811866", "Takanosu\,\ Akita",
"812876", "Kuroiso\,\ Tochigi",
"8166", "Osaka\,\ Osaka",
"819784", "Bungotakada\,\ Oita",
"812897", "Kanuma\,\ Tochigi",
"81551", "Nirasaki\,\ Yamanashi",
"81929", "Fukuoka\,\ Fukuoka",
"811523", "Shari\,\ Hokkaido",
"81776", "Fukui\,\ Fukui",
"818668", "Ibara\,\ Okayama",
"819785", "Bungotakada\,\ Oita",
"812899", "Kanuma\,\ Tochigi",
"812551", "Joetsu\,\ Niigata",
"8112397", "Kuriyama\,\ Hokkaido",
"81546", "Shizuoka\,\ Shizuoka",
"811658", "Kamikawa\,\ Hokkaido",
"81937", "Kitakyushu\,\ Fukuoka",
"812693", "Nakano\,\ Nagano",
"811852", "Oga\,\ Akita",
"812388", "Nagai\,\ Yamagata",
"81292", "Mito\,\ Ibaraki",
"819802", "Minamidaito\,\ Okinawa",
"815762", "Gero\,\ Gifu",
"817456", "Yamatotakada\,\ Nara",
"81485", "Kumagaya\,\ Saitama",
"814288", "Ome\,\ Tokyo",
"819733", "Hita\,\ Oita",
"814702", "Tateyama\,\ Chiba",
"812992", "Ishioka\,\ Ibaraki",
"81975", "Oita\,\ Oita",
"811563", "Honbetsu\,\ Hokkaido",
"812573", "Kashiwazaki\,\ Niigata",
"8144", "Kawasaki\,\ Kanagawa",
"815983", "Matsusaka\,\ Mie",
"81853", "Izumo\,\ Shimane",
"817367", "Iwade\,\ Wakayama",
"81542", "Shizuoka\,\ Shizuoka",
"818553", "Hamada\,\ Shimane",
"819664", "Hitoyoshi\,\ Kumamoto",
"818202", "Yanai\,\ Yamaguchi",
"812242", "Shiroishi\,\ Miyagi",
"811957", "Iwate\,\ Iwate",
"81134", "Otaru\,\ Hokkaido",
"818240", "Higashi\-ku\,\ Hiroshima",
"819665", "Hitoyoshi\,\ Kumamoto",
"81545", "Fuji\,\ Shizuoka",
"812678", "Saku\,\ Nagano",
"812872", "Otawara\,\ Tochigi",
"811862", "Kazuno\,\ Akita",
"81420", "Tokorozawa\,\ Saitama",
"817617", "Kaga\,\ Ishikawa",
"81482", "Kawaguchi\,\ Saitama",
"811856", "Noshiro\,\ Akita",
"81775", "Otsu\,\ Shiga",
"817733", "Fukuchiyama\,\ Kyoto",
"81949", "Nogata\,\ Fukuoka",
"812838", "Sano\,\ Tochigi",
"819575", "Isahaya\,\ Nagasaki",
"81779", "Ono\,\ Gifu",
"819433", "Yame\,\ Fukuoka",
"818698", "Bizen\,\ Okayama",
"818383", "Hagi\,\ Yamaguchi",
"81568", "Kasugai\,\ Aichi",
"81926", "Fukuoka\,\ Fukuoka",
"819574", "Isahaya\,\ Nagasaki",
"811877", "Omagari\,\ Akita",
"819726", "Usuki\,\ Oita",
"815367", "Shitara\,\ Aichi",
"81742", "Nara\,\ Nara",
"818892", "Sakawa\,\ Kochi",
"812746", "Tomioka\,\ Gunma",
"812890", "Utsunomiya\,\ Tochigi",
"81886", "Tokushima\,\ Tokushima",
"81434", "Chiba\,\ Chiba",
"81572", "Tajimi\,\ Gifu",
"814281", "Sagamihara\,\ Kanagawa",
"81549", "Shizuoka\,\ Shizuoka",
"8186996", "Seto\,\ Okayama",
"819686", "Tamana\,\ Kumamoto",
"817686", "Noto\,\ Ishikawa",
"811976", "Kitakami\,\ Iwate",
"818544", "Kisuki\,\ Shimane",
"815733", "Ena\,\ Gifu",
"818972", "Niihama\,\ Ehime",
"818593", "Yonago\,\ Tottori",
"811532", "Nemuro\,\ Hokkaido",
"818545", "Kisuki\,\ Shimane",
"81942", "Kurume\,\ Fukuoka",
"817942", "Kakogawa\,\ Hyogo",
"8178", "Kobe\,\ Hyogo",
"81726", "Ibaraki\,\ Osaka",
"81244", "Hobara\,\ Fukushima",
"8124196", "Yanaizu\,\ Fukushima",
"817496", "Nagahama\,\ Shiga",
"81182", "Yokote\,\ Akita",
"81489", "Soka\,\ Saitama",
"81979", "Nakatsu\,\ Oita",
"812742", "Fujioka\,\ Gunma",
"81263", "Matsumoto\,\ Nagano",
"812653", "Iida\,\ Nagano",
"818896", "Susaki\,\ Kochi",
"819935", "Kaseda\,\ Kagoshima",
"818833", "Kamojima\,\ Tokushima",
"819722", "Saiki\,\ Oita",
"819946", "Kanoya\,\ Kagoshima",
"81885", "Komatsushima\,\ Tokushima",
"812859", "Oyama\,\ Tochigi",
"819934", "Ibusuki\,\ Kagoshima",
"81722", "Sakai\,\ Osaka",
"818879", "Muroto\,\ Kochi",
"819682", "Yamaga\,\ Kumamoto",
"817485", "Yokaichi\,\ Shiga",
"81946", "Amagi\,\ Fukuoka",
"81537", "Kakegawa\,\ Shizuoka",
"8182920", "Hatsukaichi\,\ Hiroshima",
"8186552", "Kurashiki\,\ Okayama",
"81594", "Kuwana\,\ Mie",
"819233", "Maebaru\,\ Fukuoka",
"812857", "Mooka\,\ Tochigi",
"817484", "Yokaichi\,\ Shiga",
"81925", "Fukuoka\,\ Fukuoka",
"814240", "Kokubunji\,\ Tokyo",
"81725", "Izumi\,\ Osaka",
"811536", "Akkeshi\,\ Hokkaido",
"811545", "Kushiro\,\ Hokkaido",
"812783", "Numata\,\ Gunma",
"818249", "Higashi\-ku\,\ Hiroshima",
"812962", "Shimodate\,\ Ibaraki",
"811972", "Mizusawa\,\ Iwate",
"811544", "Kushiro\,\ Hokkaido",
"818976", "Niihama\,\ Ehime",
"817682", "Wajima\,\ Ishikawa",
"81922", "Fukuoka\,\ Fukuoka",
"818247", "Shobara\,\ Hiroshima",
"812956", "Hitachi\-Omiya\,\ Ibaraki",
"817492", "Hikone\,\ Shiga",
"811938", "Miyako\,\ Iwate",
"817946", "Miki\,\ Hyogo",
"817722", "Miyazu\,\ Kyoto",
"812657", "Ina\,\ Nagano",
"81166", "Asahikawa\,\ Hokkaido",
"819688", "Tamana\,\ Kumamoto",
"8153973", "Hamamatsu\,\ Shizuoka",
"8125481", "Murakami\,\ Niigata",
"819975", "Naze\,\ Kagoshima",
"818873", "Aki\,\ Kochi",
"8112390", "Yubari\,\ Hokkaido",
"819542", "Takeo\,\ Saga",
"818679", "Niimi\,\ Okayama",
"819974", "Yakushima\,\ Kagoshima",
"811754", "Mutsu\,\ Aomori",
"812748", "Tomioka\,\ Gunma",
"819728", "Usuki\,\ Oita",
"812659", "Ina\,\ Nagano",
"818677", "Niimi\,\ Okayama",
"81533", "Toyohashi\,\ Aichi",
"818696", "Bizen\,\ Okayama",
"812853", "Oyama\,\ Tochigi",
"818944", "Yawatahama\,\ Ehime",
"812566", "Sanjo\,\ Niigata",
"814794", "Choshi\,\ Chiba",
"8198291", "Nobeoka\,\ Miyazaki",
"818374", "Nagato\,\ Yamaguchi",
"812787", "Numata\,\ Gunma",
"817498", "Nagahama\,\ Shiga",
"814795", "Choshi\,\ Chiba",
"818375", "Mine\,\ Yamaguchi",
"81862", "Okayama\,\ Okayama",
"818945", "Yawatahama\,\ Ehime",
"811932", "Kamaishi\,\ Iwate",
"8112395", "Kuriyama\,\ Hokkaido",
"812789", "Maebashi\,\ Gunma",
"818243", "Higashi\-ku\,\ Hiroshima",
"812416", "Tajima\,\ Fukushima",
"817239", "Neyagawa\,\ Osaka",
"818295", "Hatsukaichi\,\ Hiroshima",
"812552", "Joetsu\,\ Niigata",
"812968", "Kasama\,\ Ibaraki",
"811978", "Kitakami\,\ Iwate",
"81878", "Takamatsu\,\ Kagawa",
"817688", "Noto\,\ Ishikawa",
"818294", "Hatsukaichi\,\ Hiroshima",
"819546", "Kashima\,\ Saga",
"819437", "Tanushimaru\,\ Fukuoka",
"818387", "Tamagawa\,\ Yamaguchi",
"812615", "Omachi\,\ Nagano",
"811873", "Kakunodate\,\ Akita",
"815363", "Shinshiro\,\ Aichi",
"814701", "Kamogawa\,\ Chiba",
"812614", "Omachi\,\ Nagano",
"818692", "Oku\,\ Okayama",
"81493", "Higashimatsuyama\,\ Saitama",
"8125484", "Murakami\,\ Niigata",
"817704", "Tsuruga\,\ Fukui",
"819948", "Shibushi\,\ Kagoshima",
"81554", "Otsuki\,\ Yamanashi",
"817705", "Obama\,\ Fukui",
"817948", "Miki\,\ Hyogo",
"811945", "Kuji\,\ Iwate",
"81162", "Wakkanai\,\ Hokkaido",
"811936", "Miyako\,\ Iwate",
"815737", "Nakatsugawa\,\ Gifu",
"812930", "Mito\,\ Ibaraki",
"811375", "Yakumo\,\ Hokkaido",
"811374", "Mori\,\ Hokkaido",
"811944", "Iwaizumi\,\ Iwate",
"812562", "Sanjo\,\ Niigata",
"81259", "Sado\,\ Niigata",
"818685", "Tsuyama\,\ Okayama",
"81178", "Hachinohe\,\ Aomori",
"812556", "Itoigawa\,\ Niigata",
"818978", "Hakata\,\ Ehime",
"8198294", "Nobeoka\,\ Miyazaki",
"818684", "Tsuyama\,\ Okayama",
"812412", "Kitakata\,\ Fukushima",
"8186995", "Seto\,\ Okayama",
"817712", "Kameoka\,\ Kyoto",
"81423", "Kokubunji\,\ Tokyo",
"811875", "Kakunodate\,\ Akita",
"815958", "Kameyama\,\ Mie",
"817672", "Hakui\,\ Ishikawa",
"819596", "Fukue\,\ Nagasaki",
"812613", "Omachi\,\ Nagano",
"811874", "Kakunodate\,\ Akita",
"819577", "Shimabara\,\ Nagasaki",
"811982", "Hanamaki\,\ Iwate",
"817703", "Tsuruga\,\ Fukui",
"811634", "Hamatonbetsu\,\ Hokkaido",
"81559", "Numazu\,\ Shizuoka",
"818588", "Koge\,\ Tottori",
"811635", "Hamatonbetsu\,\ Hokkaido",
"811646", "Haboro\,\ Hokkaido",
"812640", "Nagano\,\ Nagano",
"818547", "Kakeya\,\ Shimane",
"8153968", "Hamamatsu\,\ Shizuoka",
"818493", "Onomichi\,\ Hiroshima",
"811337", "Ishikari\,\ Hokkaido",
"81721", "Tondabayashi\,\ Osaka",
"811943", "Iwaizumi\,\ Iwate",
"817998", "Tsuna\,\ Hyogo",
"81464", "Atsugi\,\ Kanagawa",
"812230", "Sendai\,\ Miyagi",
"8128798", "Otawara\,\ Tochigi",
"817475", "Shimonoseki\,\ Yamaguchi",
"811236", "Chitose\,\ Hokkaido",
"8183766", "Shimonoseki\,\ Yamaguchi",
"8153967", "Hamamatsu\,\ Shizuoka",
"81288", "Imabari\,\ Ehime",
"818683", "Tsuyama\,\ Okayama",
"818398", "Ogori\,\ Yamaguchi",
"81538", "Iwata\,\ Shizuoka",
"81952", "Saga\,\ Saga",
"811986", "Tono\,\ Iwate",
"818874", "Aki\,\ Kochi",
"819592", "Oseto\,\ Nagasaki",
"817676", "Nanao\,\ Ishikawa",
"815566", "Minobu\,\ Yamanashi",
"819937", "Kaseda\,\ Kagoshima",
"817716", "Sonobe\,\ Kyoto",
"812855", "Oyama\,\ Tochigi",
"811753", "Mutsu\,\ Aomori",
"811588", "Okoppe\,\ Hokkaido",
"812798", "Naganohara\,\ Gunma",
"81956", "Sasebo\,\ Nagasaki",
"817487", "Minakuchi\,\ Shiga",
"812854", "Oyama\,\ Tochigi",
"8198293", "Nobeoka\,\ Miyazaki",
"81567", "Tsushima\,\ Aichi",
"818943", "Yawatahama\,\ Ehime",
"814793", "Choshi\,\ Chiba",
"818373", "Nagato\,\ Yamaguchi",
"811547", "Shiranuka\,\ Hokkaido",
"811398", "Kumaishi\,\ Hokkaido",
"818244", "Miyoshi\,\ Hiroshima",
"8125483", "Murakami\,\ Niigata",
"819676", "Takamori\,\ Kumamoto",
"811549", "Kushiro\,\ Hokkaido",
"818293", "Hatsukaichi\,\ Hiroshima",
"81583", "Gifu\,\ Gifu",
"81233", "Shinjo\,\ Yamagata",
"811232", "Chitose\,\ Hokkaido",
"818478", "Tojo\,\ Hiroshima",
"818245", "Miyoshi\,\ Hiroshima",
"8153971", "Hamamatsu\,\ Shizuoka",
"818834", "Kamojima\,\ Tokushima",
"81792", "Himeji\,\ Hyogo",
"812654", "Iida\,\ Nagano",
"812792", "Shibukawa\,\ Gunma",
"818586", "Kurayoshi\,\ Tottori",
"811582", "Monbetsu\,\ Hokkaido",
"819977", "Setouchi\,\ Kagoshima",
"818835", "Mima\,\ Tokushima",
"819933", "Ibusuki\,\ Kagoshima",
"812655", "Iida\,\ Nagano",
"81930", "Yukuhashi\,\ Fukuoka",
"818675", "Kuse\,\ Okayama",
"81177", "Aomori\,\ Aomori",
"819598", "Fukue\,\ Nagasaki",
"81276", "Ota\,\ Gunma",
"81832", "Shimonoseki\,\ Yamaguchi",
"811757", "Noheji\,\ Aomori",
"817483", "Yokaichi\,\ Shiga",
"818674", "Kuse\,\ Okayama",
"819979", "Tokunoshima\,\ Kagoshima",
"812784", "Numata\,\ Gunma",
"811392", "Kikonai\,\ Hokkaido",
"814776", "Funabashi\,\ Chiba",
"8186698", "Kurashiki\,\ Okayama",
"818377", "Shimonoseki\,\ Yamaguchi",
"814797", "Yokaichiba\,\ Chiba",
"81563", "Nishio\,\ Aichi",
"818947", "Uwajima\,\ Ehime",
"815742", "Minokamo\,\ Gifu",
"81835", "Hofu\,\ Yamaguchi",
"812785", "Numata\,\ Gunma",
"811238", "Kuriyama\,\ Hokkaido",
"811543", "Kushiro\,\ Hokkaido",
"818299", "Hiroshima\,\ Hiroshima",
"8186697", "Kurashiki\,\ Okayama",
"818949", "Uwajima\,\ Ehime",
"817996", "Tsuna\,\ Hyogo",
"8112396", "Kuriyama\,\ Hokkaido",
"818297", "Hatsukaichi\,\ Hiroshima",
"81992", "Kagoshima\,\ Kagoshima",
"81587", "Ichinomiya\,\ Aichi",
"81294", "Hitachiota\,\ Ibaraki",
"812580", "Tokamachi\,\ Niigata",
"819434", "Yame\,\ Fukuoka",
"818842", "Anan\,\ Tokushima",
"818384", "Hagi\,\ Yamaguchi",
"812796", "Shibukawa\,\ Gunma",
"818582", "Kurayoshi\,\ Tottori",
"81427", "Sagamihara\,\ Kanagawa",
"811586", "Nakayubetsu\,\ Hokkaido",
"81774", "Uji\,\ Kyoto",
"819573", "Isahaya\,\ Nagasaki",
"818385", "Hagi\,\ Yamaguchi",
"819435", "Yame\,\ Fukuoka",
"81544", "Fujinomiya\,\ Shizuoka",
"817718", "Sonobe\,\ Kyoto",
"817707", "Obama\,\ Fukui",
"81877", "Marugame\,\ Kagawa",
"817678", "Nanao\,\ Ishikawa",
"81439", "Kisarazu\,\ Chiba",
"812619", "Omachi\,\ Nagano",
"818543", "Yasugi\,\ Shimane",
"818476", "Fuchu\,\ Hiroshima",
"815734", "Ena\,\ Gifu",
"818595", "Yonago\,\ Tottori",
"81268", "Ueda\,\ Nagano",
"815735", "Ena\,\ Gifu",
"815746", "Minokamo\,\ Gifu",
"811947", "Kuji\,\ Iwate",
"818689", "Okayama\,\ Okayama",
"811333", "Tobetsu\,\ Hokkaido",
"811377", "Yakumo\,\ Hokkaido",
"811396", "Esashi\,\ Hokkaido",
"814772", "Ichikawa\,\ Chiba",
"818594", "Yonago\,\ Tottori",
"81272", "Maebashi\,\ Gunma",
"81484", "Kawaguchi\,\ Saitama",
"817992", "Sumoto\,\ Hyogo",
"81249", "Koriyama\,\ Fukushima",
"8126179", "Omachi\,\ Nagano",
"818687", "Mimasaka\,\ Okayama",
"819734", "Hita\,\ Oita",
"815985", "Matsusaka\,\ Mie",
"817952", "Nishiwaki\,\ Hyogo",
"812477", "Miharu\,\ Fukushima",
"812575", "Tokamachi\,\ Niigata",
"81245", "Fukushima\,\ Fukushima",
"815984", "Matsusaka\,\ Mie",
"819735", "Hita\,\ Oita",
"819746", "Taketa\,\ Oita",
"811362", "Kutchan\,\ Hokkaido",
"812372", "Murayama\,\ Yamagata",
"81226", "Kesennuma\,\ Miyagi",
"8186998", "Seto\,\ Okayama",
"818366", "Ube\,\ Yamaguchi",
"81744", "Yamatotakada\,\ Nara",
"811564", "Kamishihoro\,\ Hokkaido",
"812574", "Kashiwazaki\,\ Niigata",
"819663", "Hitoyoshi\,\ Kumamoto",
"818290", "Hiroshima\,\ Hiroshima",
"81432", "Chiba\,\ Chiba",
"811356", "Iwanai\,\ Hokkaido",
"818554", "Hamada\,\ Shimane",
"818555", "Gotsu\,\ Shimane",
"8186997", "Seto\,\ Okayama",
"818797", "Tonosho\,\ Kagawa",
"815992", "Toba\,\ Mie",
"819966", "Izumi\,\ Kagoshima",
"8153965", "Hamamatsu\,\ Shizuoka",
"81944", "Setaka\,\ Fukuoka",
"8124197", "Yanaizu\,\ Fukushima",
"817735", "Fukuchiyama\,\ Kyoto",
"81242", "Aizuwakamatsu\,\ Fukushima",
"81184", "Yurihonjo\,\ Akita",
"819952", "Okuchi\,\ Kagoshima",
"81596", "Ise\,\ Mie",
"814297", "Hanno\,\ Saitama",
"817734", "Fukuchiyama\,\ Kyoto",
"818564", "Masuda\,\ Shimane",
"812935", "Mito\,\ Ibaraki",
"812376", "Sagae\,\ Yamagata",
"81827", "Iwakuni\,\ Yamaguchi",
"811366", "Suttsu\,\ Hokkaido",
"818362", "Ube\,\ Yamaguchi",
"81963", "Kumamoto\,\ Kumamoto",
"819742", "Mie\,\ Oita",
"818565", "Masuda\,\ Shimane",
"817956", "Sanda\,\ Hyogo",
"8198299", "Hyuga\,\ Miyazaki",
"818467", "Mima\,\ Tokushima",
"812934", "Takahagi\,\ Ibaraki",
"8188099", "Tosashimizu\,\ Kochi",
"818490", "Onomichi\,\ Hiroshima",
"81246", "Iwaki\,\ Fukushima",
"811555", "Obihiro\,\ Hokkaido",
"817962", "Toyooka\,\ Hyogo",
"818680", "Okayama\,\ Okayama",
"811554", "Obihiro\,\ Hokkaido",
"812233", "Iwanuma\,\ Miyagi",
"81987", "Nichinan\,\ Miyazaki",
"81225", "Ishinomaki\,\ Miyagi",
"81592", "Tsu\,\ Mie",
"811352", "Yoichi\,\ Hokkaido",
"814757", "Togane\,\ Chiba",
"81839", "Yamaguchi\,\ Yamaguchi",
"814220", "Kokubunji\,\ Tokyo",
"8182941", "Hiroshima\,\ Hiroshima",
"819783", "Bungotakada\,\ Oita",
"811525", "Abashiri\,\ Hokkaido",
"812484", "Shirakawa\,\ Fukushima",
"819827", "Takachiho\,\ Miyazaki",
"815977", "Kumano\,\ Mie",
"811524", "Abashiri\,\ Hokkaido",
"81222", "Sendai\,\ Miyagi",
"819558", "Karatsu\,\ Saga",
"818807", "Sukumo\,\ Kochi",
"819962", "Satsumasendai\,\ Kagoshima",
"81924", "Fukuoka\,\ Fukuoka",
"812587", "Nagaoka\,\ Niigata",
"8125489", "Tsugawa\,\ Niigata",
"815996", "Ago\,\ Mie",
"812485", "Shirakawa\,\ Fukushima",
"819956", "Kajiki\,\ Kagoshima",
"812695", "Nakano\,\ Nagano",
"81436", "Ichihara\,\ Chiba",
"81280", "Koga\,\ Ibaraki",
"81763", "Fukuno\,\ Toyama",
"812589", "Nagaoka\,\ Niigata",
"812911", "Hokota\,\ Ibaraki",
"815979", "Kumano\,\ Mie",
"812694", "Nakano\,\ Nagano",
"817354", "Shingu\,\ Fukuoka",
"81823", "Kure\,\ Hiroshima",
"817968", "Hamasaka\,\ Hyogo",
"815585", "Shimoda\,\ Shizuoka",
"818463", "Takehara\,\ Hiroshima",
"812542", "Shibata\,\ Niigata",
"817355", "Shingu\,\ Fukuoka",
"815584", "Shimoda\,\ Shizuoka",
"812239", "Sendai\,\ Miyagi",
"818954", "Uwajima\,\ Ehime",
"811453", "Hayakita\,\ Hokkaido",
"817905", "Fukusaki\,\ Hyogo",
"818368", "Ube\,\ Yamaguchi",
"81143", "Muroran\,\ Hokkaido",
"81983", "Takanabe\,\ Miyazaki",
"818955", "Uwajima\,\ Ehime",
"817904", "Fukusaki\,\ Hyogo",
"812237", "Sendai\,\ Miyagi",
"81473", "Ichikawa\,\ Chiba",
"8163", "Osaka\,\ Osaka",
"814753", "Mobara\,\ Chiba",
"812894", "Utsunomiya\,\ Tochigi",
"819787", "Kunisaki\,\ Oita",
"815394", "Hamamatsu\,\ Shizuoka",
"812649", "Nagano\,\ Nagano",
"812895", "Utsunomiya\,\ Tochigi",
"819823", "Nobeoka\,\ Miyazaki",
"81864", "Kurashiki\,\ Okayama",
"8111", "Sapporo\,\ Hokkaido",
"81260", "Anan\,\ Nagano",
"811736", "Goshogawara\,\ Aomori",
"815973", "Owase\,\ Mie",
"812583", "Nagaoka\,\ Niigata",
"815395", "Hamamatsu\,\ Shizuoka",
"812647", "Nagano\,\ Nagano",
"819789", "Kitsuki\,\ Oita",
"8186992", "Bizen\,\ Okayama",
"819968", "Izumi\,\ Kagoshima",
"819552", "Imari\,\ Saga",
"812546", "Murakami\,\ Niigata",
"811463", "Urakawa\,\ Hokkaido",
"812473", "Ishikawa\,\ Fukushima",
"8145", "Yokohama\,\ Kanagawa",
"819667", "Minamata\,\ Kumamoto",
"811955", "Ninohe\,\ Iwate",
"818263", "Kake\,\ Hiroshima",
"81938", "Kitakyushu\,\ Fukuoka",
"812378", "Sagae\,\ Yamagata",
"81552", "Kofu\,\ Yamanashi",
"811954", "Ninohe\,\ Iwate",
"81738", "Gobo\,\ Wakayama",
"811732", "Goshogawara\,\ Aomori",
"814771", "Ichikawa\,\ Chiba",
"818391", "Ogori\,\ Yamaguchi",
"8126173", "Omachi\,\ Nagano",
"81555", "Fujiyoshida\,\ Yamanashi",
"815998", "Ago\,\ Mie",
"81898", "Imabari\,\ Ehime",
"819556", "Karatsu\,\ Saga",
"817614", "Komatsu\,\ Ishikawa",
"817615", "Komatsu\,\ Ishikawa",
"812675", "Saku\,\ Nagano",
"81582", "Gifu\,\ Gifu",
"81934", "Kitakyushu\,\ Fukuoka",
"819957", "Kajiki\,\ Kagoshima",
"815999", "Tsu\,\ Mie",
"812674", "Komoro\,\ Nagano",
"818654", "Kamogata\,\ Okayama",
"812834", "Utsunomiya\,\ Tochigi",
"818655", "Kamogata\,\ Okayama",
"819826", "Hyuga\,\ Miyazaki",
"811733", "Goshogawara\,\ Aomori",
"815997", "Ago\,\ Mie",
"812586", "Nagaoka\,\ Niigata",
"81426", "Hachioji\,\ Tokyo",
"818806", "Sukumo\,\ Kochi",
"812835", "Sano\,\ Tochigi",
"814285", "Sagamihara\,\ Kanagawa",
"814284", "Tachikawa\,\ Tokyo",
"81172", "Hirosaki\,\ Aomori",
"818262", "Kake\,\ Hiroshima",
"817959", "Sanda\,\ Hyogo",
"81989", "Naha\,\ Okinawa",
"814756", "Togane\,\ Chiba",
"812377", "Sagae\,\ Yamagata",
"811367", "Suttsu\,\ Hokkaido",
"81235", "Tsuruoka\,\ Yamagata",
"81585", "Ibigawa\,\ Gifu",
"81734", "Wakayama\,\ Wakayama",
"818466", "Mima\,\ Tokushima",
"811462", "Urakawa\,\ Hokkaido",
"812472", "Ishikawa\,\ Fukushima",
"81797", "Nishinomiya\,\ Hyogo",
"819668", "Minamata\,\ Kumamoto",
"819553", "Imari\,\ Saga",
"818664", "Takahashi\,\ Okayama",
"81425", "Tachikawa\,\ Tokyo",
"819788", "Kunisaki\,\ Oita",
"818665", "Takahashi\,\ Okayama",
"8147957", "Yokaichiba\,\ Chiba",
"81277", "Kiryu\,\ Gunma",
"81176", "Towada\,\ Aomori",
"819967", "Izumi\,\ Kagoshima",
"812384", "Yonezawa\,\ Yamagata",
"813", "Tokyo",
"812582", "Nagaoka\,\ Niigata",
"818796", "Tonosho\,\ Kagawa",
"819822", "Nobeoka\,\ Miyazaki",
"815972", "Owase\,\ Mie",
"811655", "Nayoro\,\ Hokkaido",
"81875", "Kan\'onji\,\ Kagawa",
"811541", "Teshikaga\,\ Hokkaido",
"8153975", "Hamamatsu\,\ Shizuoka",
"812385", "Yonezawa\,\ Yamagata",
"812648", "Nagano\,\ Nagano",
"811654", "Nayoro\,\ Hokkaido",
"814752", "Mobara\,\ Chiba",
"8152", "Nagoya\,\ Aichi",
"81586", "Ichinomiya\,\ Aichi",
"818512", "Nishigo\,\ Fukushima",
"81236", "Yamagata\,\ Yamagata",
"811357", "Iwanai\,\ Hokkaido",
"81480", "Kuki\,\ Saitama",
"81849", "Fukuyama\,\ Hiroshima",
"818369", "Ube\,\ Yamaguchi",
"811452", "Hayakita\,\ Hokkaido",
"8186994", "Seto\,\ Okayama",
"8112393", "Yubari\,\ Hokkaido",
"812238", "Sendai\,\ Miyagi",
"818462", "Takehara\,\ Hiroshima",
"817914", "Aioi\,\ Hyogo",
"811466", "Erimo\,\ Hokkaido",
"812543", "Shibata\,\ Niigata",
"812476", "Miharu\,\ Fukushima",
"819747", "Taketa\,\ Oita",
"814770", "Ichikawa\,\ Chiba",
"817969", "Hamasaka\,\ Hyogo",
"817915", "Aioi\,\ Hyogo",
"8153970", "Hamamatsu\,\ Shizuoka",
"818367", "Ube\,\ Yamaguchi",
"819557", "Karatsu\,\ Saga",
"818808", "Tosashimizu\,\ Kochi",
"811854", "Oga\,\ Akita",
"812588", "Nagaoka\,\ Niigata",
"815978", "Kumano\,\ Mie",
"819828", "Takachiho\,\ Miyazaki",
"81728", "Neyagawa\,\ Osaka",
"811855", "Noshiro\,\ Akita",
"81273", "Takasaki\,\ Gunma",
"819963", "Satsumasendai\,\ Kagoshima",
"8188096", "Tosashimizu\,\ Kochi",
"81281", "Utsunomiya\,\ Tochigi",
"81531", "Tahara\,\ Aichi",
"8198296", "Hyuga\,\ Miyazaki",
"819782", "Bungotakada\,\ Oita",
"819666", "Minamata\,\ Kumamoto",
"812549", "Tsugawa\,\ Niigata",
"811353", "Yoichi\,\ Hokkaido",
"815755", "Sekigahara\,\ Gifu",
"812232", "Iwanuma\,\ Miyagi",
"8199347", "Kagoshima\,\ Kagoshima",
"8164", "Osaka\,\ Osaka",
"81888", "Kochi\,\ Kochi",
"815754", "Sekigahara\,\ Gifu",
"817963", "Toyooka\,\ Hyogo",
"81250", "Niitsu\,\ Niigata",
"814758", "Togane\,\ Chiba",
"81928", "Fukuoka\,\ Fukuoka",
"812547", "Murakami\,\ Niigata",
"817454", "Yamatotakada\,\ Nara",
"8125486", "Tsugawa\,\ Niigata",
"81460", "Odawara\,\ Kanagawa",
"819743", "Mie\,\ Oita",
"818363", "Ube\,\ Yamaguchi",
"817455", "Yamatotakada\,\ Nara",
"81566", "Kariya\,\ Aichi",
"812646", "Nagano\,\ Nagano",
"819953", "Okuchi\,\ Kagoshima",
"818798", "Tonosho\,\ Kagawa",
"81578", "Kamioka\,\ Akita",
"814298", "Hanno\,\ Saitama",
"819786", "Kitsuki\,\ Oita",
"811864", "Odate\,\ Akita",
"812874", "Otawara\,\ Tochigi",
"812875", "Otawara\,\ Tochigi",
"811865", "Odate\,\ Akita",
"815993", "Toba\,\ Mie",
"818204", "Yanai\,\ Yamaguchi",
"812244", "Shiroishi\,\ Miyagi",
"817464", "Yoshino\,\ Nara",
"81188", "Akita\,\ Akita",
"818205", "Yanai\,\ Yamaguchi",
"812245", "Ogawara\,\ Miyagi",
"817465", "Yoshino\,\ Nara",
"81565", "Toyota\,\ Aichi",
"812478", "Miharu\,\ Fukushima",
"81948", "Iizuka\,\ Fukuoka",
"812236", "Sendai\,\ Miyagi",
"81833", "Kudamatsu\,\ Yamaguchi",
"819662", "Hitoyoshi\,\ Kumamoto",
"819805", "Nago\,\ Okinawa",
"815765", "Gero\,\ Gifu",
"812373", "Murayama\,\ Yamagata",
"811363", "Kutchan\,\ Hokkaido",
"81969", "Amakusa\,\ Kumamoto",
"814705", "Tateyama\,\ Chiba",
"8162", "Osaka\,\ Osaka",
"812995", "Ishioka\,\ Ibaraki",
"81793", "Himeji\,\ Hyogo",
"819804", "Nago\,\ Okinawa",
"817953", "Nishiwaki\,\ Hyogo",
"815764", "Gero\,\ Gifu",
"812994", "Ishioka\,\ Ibaraki",
"8182942", "Hiroshima\,\ Hiroshima",
"814704", "Tateyama\,\ Chiba",
"817993", "Sumoto\,\ Hyogo",
"81762", "Kanazawa\,\ Ishikawa",
"817945", "Kakogawa\,\ Hyogo",
"811378", "Imakane\,\ Hokkaido",
"81965", "Yatsushiro\,\ Kumamoto",
"814291", "Hanno\,\ Saitama",
"81548", "Haibara\,\ Shizuoka",
"817944", "Kakogawa\,\ Hyogo",
"812955", "Hitachi\-Omiya\,\ Ibaraki",
"81569", "Handa\,\ Aichi",
"81778", "Takefu\,\ Fukui",
"818688", "Mimasaka\,\ Okayama",
"811332", "Tobetsu\,\ Hokkaido",
"811534", "Nakashibetsu\,\ Hokkaido",
"818975", "Niihama\,\ Ehime",
"818542", "Yasugi\,\ Shimane",
"819679", "Takamori\,\ Kumamoto",
"811535", "Akkeshi\,\ Hokkaido",
"818974", "Niihama\,\ Ehime",
"811546", "Kushiro\,\ Hokkaido",
"81191", "Ichinoseki\,\ Iwate",
"812618", "Omachi\,\ Nagano",
"81593", "Yokkaichi\,\ Mie",
"81488", "Urawa\,\ Saitama",
"817486", "Minakuchi\,\ Shiga",
"8126176", "Omachi\,\ Nagano",
"819572", "Isahaya\,\ Nagasaki",
"819944", "Kanoya\,\ Kagoshima",
"811987", "Tono\,\ Iwate",
"81765", "Uozu\,\ Toyama",
"817677", "Nanao\,\ Ishikawa",
"818894", "Susaki\,\ Kochi",
"8186553", "Kurashiki\,\ Okayama",
"818583", "Kurayoshi\,\ Tottori",
"819936", "Kaseda\,\ Kagoshima",
"81962", "Kumamoto\,\ Kumamoto",
"819945", "Kanoya\,\ Kagoshima",
"818843", "Anan\,\ Tokushima",
"818895", "Susaki\,\ Kochi",
"817717", "Sonobe\,\ Kyoto",
"811237", "Kuriyama\,\ Hokkaido",
"817724", "Miyazu\,\ Kyoto",
"817495", "Nagahama\,\ Shiga",
"818378", "Shimonoseki\,\ Yamaguchi",
"814798", "Yokaichiba\,\ Chiba",
"81243", "Nihonmatsu\,\ Fukushima",
"818948", "Uwajima\,\ Ehime",
"817725", "Miyazu\,\ Kyoto",
"812917", "Mito\,\ Ibaraki",
"817494", "Hikone\,\ Shiga",
"8147955", "Yokaichiba\,\ Chiba",
"811974", "Mizusawa\,\ Iwate",
"818546", "Kakeya\,\ Shimane",
"812964", "Shimodate\,\ Ibaraki",
"811542", "Kushiro\,\ Hokkaido",
"818298", "Hatsukaichi\,\ Hiroshima",
"817684", "Wajima\,\ Ishikawa",
"8153978", "Hamamatsu\,\ Shizuoka",
"812965", "Shimodate\,\ Ibaraki",
"811975", "Mizusawa\,\ Iwate",
"815743", "Minokamo\,\ Gifu",
"8153964", "Hamamatsu\,\ Shizuoka",
"811336", "Ishikari\,\ Hokkaido",
"811393", "Matsumae\,\ Hokkaido",
"817685", "Wajima\,\ Ishikawa",
"81557", "Ito\,\ Shizuoka",
"819685", "Tamana\,\ Kumamoto",
"8112399", "Kuriyama\,\ Hokkaido",
"81766", "Takaoka\,\ Toyama",
"817482", "Yokaichi\,\ Shiga",
"819978", "Tokunoshima\,\ Kagoshima",
"81298", "Tsuchiura\,\ Ibaraki",
"819684", "Yamaga\,\ Kumamoto",
"811647", "Haboro\,\ Hokkaido",
"819599", "Oseto\,\ Nagasaki",
"81433", "Chiba\,\ Chiba",
"8167", "Osaka\,\ Osaka",
"812745", "Fujioka\,\ Gunma",
"8147950", "Yokaichiba\,\ Chiba",
"819932", "Ibusuki\,\ Kagoshima",
"819725", "Saiki\,\ Oita",
"812793", "Shibukawa\,\ Gunma",
"811583", "Monbetsu\,\ Hokkaido",
"819597", "Fukue\,\ Nagasaki",
"812744", "Fujioka\,\ Gunma",
"819576", "Shimabara\,\ Nagasaki",
"819724", "Saiki\,\ Oita",
"81986", "Miyakonojo\,\ Miyazaki",
"81125", "Takikawa\,\ Hokkaido",
"812554", "Joetsu\,\ Niigata",
"811548", "Teshikaga\,\ Hokkaido",
"811233", "Chitose\,\ Hokkaido",
"818479", "Tojo\,\ Hiroshima",
"81476", "Narita\,\ Chiba",
"818292", "Hiroshima\,\ Hiroshima",
"812555", "Itoigawa\,\ Niigata",
"812913", "Hokota\,\ Ibaraki",
"8186691", "Kurashiki\,\ Okayama",
"818686", "Tsuyama\,\ Okayama",
"818477", "Tojo\,\ Hiroshima",
"811934", "Kamaishi\,\ Iwate",
"81845", "Innoshima\,\ Hiroshima",
"817950", "Sanda\,\ Hyogo",
"814792", "Choshi\,\ Chiba",
"81740", "Imazu\,\ Shiga",
"811376", "Yakumo\,\ Hokkaido",
"818372", "Nagato\,\ Yamaguchi",
"811946", "Kuji\,\ Iwate",
"818942", "Yawatahama\,\ Ehime",
"811935", "Kamaishi\,\ Iwate",
"811397", "Okushiri\,\ Hokkaido",
"812799", "Naganohara\,\ Gunma",
"817706", "Obama\,\ Fukui",
"811589", "Okoppe\,\ Hokkaido",
"81553", "Yamanashi\,\ Yamanashi",
"819938", "Kaseda\,\ Kagoshima",
"81940", "Munakata\,\ Fukuoka",
"811752", "Mutsu\,\ Aomori",
"81494", "Chichibu\,\ Saitama",
"81429", "Tokorozawa\,\ Saitama",
"811587", "Nakayubetsu\,\ Hokkaido",
"812797", "Shibukawa\,\ Gunma",
"817488", "Minakuchi\,\ Shiga",
"819544", "Takeo\,\ Saga",
"8199345", "Kagoshima\,\ Kagoshima",
"819593", "Oseto\,\ Nagasaki",
"812616", "Omachi\,\ Nagano",
"817997", "Tsuna\,\ Hyogo",
"818682", "Tsuyama\,\ Okayama",
"812414", "Yanaizu\,\ Fukushima",
"818296", "Hiroshima\,\ Hiroshima",
"812415", "Yanaizu\,\ Fukushima",
"81825", "Hiroshima\,\ Hiroshima",
"818397", "Ogori\,\ Yamaguchi",
"814777", "Funabashi\,\ Chiba",
"818360", "Ogori\,\ Yamaguchi",
"811942", "Iwaizumi\,\ Iwate",
"818946", "Uwajima\,\ Ehime",
"812564", "Sanjo\,\ Niigata",
"811372", "Shikabe\,\ Hokkaido",
"814796", "Yokaichiba\,\ Chiba",
"81985", "Miyazaki\,\ Miyazaki",
"818376", "Mine\,\ Yamaguchi",
"81126", "Iwamizawa\,\ Hokkaido",
"81227", "Sendai\,\ Miyagi",
"812565", "Sanjo\,\ Niigata",
"818695", "Seto\,\ Okayama",
"819578", "Shimabara\,\ Nagasaki",
"81179", "Sannohe\,\ Aomori",
"8153972", "Hamamatsu\,\ Shizuoka",
"81284", "Ashikaga\,\ Tochigi",
"81534", "Hamamatsu\,\ Shizuoka",
"811756", "Noheji\,\ Aomori",
"818694", "Okayama\,\ Okayama",
"81142", "Date\,\ Hokkaido",
"817702", "Tsuruga\,\ Fukui",
"815959", "Kameyama\,\ Mie",
"811983", "Hanamaki\,\ Iwate",
"81468", "Yokosuka\,\ Kanagawa",
"817673", "Hakui\,\ Ishikawa",
"812612", "Omachi\,\ Nagano",
"819976", "Naze\,\ Kagoshima",
"818587", "Koge\,\ Tottori",
"817713", "Kameoka\,\ Kyoto",
"81822", "Hiroshima\,\ Hiroshima",
"81196", "Morioka\,\ Iwate",
"8161", "Osaka\,\ Osaka",
"812957", "Daigo\,\ Ibaraki",
"81234", "Sakata\,\ Yamagata",
"818246", "Miyoshi\,\ Hiroshima",
"812413", "Kitakata\,\ Fukushima",
"81584", "Ogaki\,\ Gifu",
"81932", "Kitakyushu\,\ Fukuoka",
"817947", "Miki\,\ Hyogo",
"815738", "Nakatsugawa\,\ Gifu",
"811537", "Nakashibetsu\,\ Hokkaido",
"812563", "Sanjo\,\ Niigata",
"8126170", "Omachi\,\ Nagano",
"8125482", "Murakami\,\ Niigata",
"818977", "Hakata\,\ Ehime",
"817949", "Kakogawa\,\ Hyogo",
"81892", "Kumakogen\,\ Ehime",
"811632", "Teshio\,\ Hokkaido",
"81174", "Kanita\,\ Aomori",
"819438", "Tanushimaru\,\ Fukuoka",
"818693", "Oku\,\ Okayama",
"818388", "Tamagawa\,\ Yamaguchi",
"812856", "Mooka\,\ Tochigi",
"817674", "Hakui\,\ Ishikawa",
"8126175", "Omachi\,\ Nagano",
"815362", "Shinshiro\,\ Aichi",
"817715", "Kameoka\,\ Kyoto",
"811984", "Hanamaki\,\ Iwate",
"819947", "Shibushi\,\ Kagoshima",
"81935", "Kitakyushu\,\ Fukuoka",
"817714", "Kameoka\,\ Kyoto",
"817675", "Nanao\,\ Ishikawa",
"8198292", "Nobeoka\,\ Miyazaki",
"812571", "Muika\,\ Niigata",
"81253", "Niigata\,\ Niigata",
"812553", "Joetsu\,\ Niigata",
"811234", "Chitose\,\ Hokkaido",
"81977", "Beppu\,\ Oita",
"817497", "Nagahama\,\ Shiga",
"812788", "Maebashi\,\ Gunma",
"817476", "Shimonoseki\,\ Yamaguchi",
"812914", "Hokota\,\ Ibaraki",
"817238", "Neyagawa\,\ Osaka",
"818242", "Higashi\-ku\,\ Hiroshima",
"811235", "Yubari\,\ Hokkaido",
"81896", "Iyomishima\,\ Ehime",
"81487", "Urawa\,\ Saitama",
"817687", "Noto\,\ Ishikawa",
"81463", "Hiratsuka\,\ Kanagawa",
"814700", "Kamogawa\,\ Chiba",
"812967", "Kasama\,\ Ibaraki",
"811977", "Kitakami\,\ Iwate",
"811933", "Kamaishi\,\ Iwate",
"81936", "Kitakyushu\,\ Fukuoka",
"812852", "Oyama\,\ Tochigi",
"81270", "Isesaki\,\ Gunma",
"811645", "Rumoi\,\ Hokkaido",
"81192", "Ofunato\,\ Iwate",
"81547", "Shimada\,\ Shizuoka",
"812658", "Ina\,\ Nagano",
"811644", "Rumoi\,\ Hokkaido",
"819687", "Tamana\,\ Kumamoto",
"819543", "Takeo\,\ Saga",
"818678", "Niimi\,\ Okayama",
"811876", "Omagari\,\ Akita",
"819727", "Usuki\,\ Oita",
"818872", "Muroto\,\ Kochi",
"812747", "Tomioka\,\ Gunma",
"815366", "Shitara\,\ Aichi",
"811939", "Miyako\,\ Iwate",
"814280", "Tachikawa\,\ Tokyo",
"817723", "Miyazu\,\ Kyoto",
"8198298", "Hyuga\,\ Miyazaki",
"817493", "Hikone\,\ Shiga",
"8188098", "Tosashimizu\,\ Kochi",
"812559", "Yasuzuka\,\ Niigata",
"817683", "Wajima\,\ Ishikawa",
"81467", "Fujisawa\,\ Kanagawa",
"811395", "Esashi\,\ Hokkaido",
"818474", "Fuchu\,\ Hiroshima",
"815736", "Nakatsugawa\,\ Gifu",
"812963", "Shimodate\,\ Ibaraki",
"811937", "Miyako\,\ Iwate",
"811973", "Mizusawa\,\ Iwate",
"815745", "Minokamo\,\ Gifu",
"811394", "Matsumae\,\ Hokkaido",
"812782", "Numata\,\ Gunma",
"818596", "Yonago\,\ Tottori",
"81471", "Kashiwa\,\ Chiba",
"8198297", "Hyuga\,\ Miyazaki",
"818475", "Fuchu\,\ Hiroshima",
"818248", "Shobara\,\ Hiroshima",
"815744", "Minokamo\,\ Gifu",
"8188097", "Tosashimizu\,\ Kochi",
"819232", "Maebaru\,\ Fukuoka",
"81950", "Hirado\,\ Nagasaki",
"819683", "Yamaga\,\ Kumamoto",
"8125488", "Tsugawa\,\ Niigata",
"81543", "Shizuoka\,\ Shizuoka",
"81852", "Matsue\,\ Shimane",
"812858", "Mooka\,\ Tochigi",
"819547", "Kashima\,\ Saga",
"812794", "Shibukawa\,\ Gunma",
"811584", "Engaru\,\ Hokkaido",
"812830", "Utsunomiya\,\ Tochigi",
"812795", "Shibukawa\,\ Gunma",
"811585", "Engaru\,\ Hokkaido",
"818832", "Kamojima\,\ Tokushima",
"819723", "Saiki\,\ Oita",
"812652", "Iida\,\ Nagano",
"812743", "Fujioka\,\ Gunma",
"8125487", "Tsugawa\,\ Niigata",
"817994", "Sumoto\,\ Hyogo",
"81438", "Kisarazu\,\ Chiba",
"817943", "Kakogawa\,\ Hyogo",
"817995", "Sumoto\,\ Hyogo",
"8186999", "Seto\,\ Okayama",
"811533", "Nemuro\,\ Hokkaido",
"812786", "Numata\,\ Gunma",
"818592", "Yonago\,\ Tottori",
"812419", "Tajima\,\ Fukushima",
"815732", "Ena\,\ Gifu",
"818973", "Niihama\,\ Ehime",
"81564", "Okazaki\,\ Aichi",
"814775", "Funabashi\,\ Chiba",
"815368", "Shitara\,\ Aichi",
"811878", "Omagari\,\ Akita",
"818660", "Seto\,\ Okayama",
"818676", "Kuse\,\ Okayama",
"8175", "Kyoto\,\ Kyoto",
"818697", "Bizen\,\ Okayama",
"812656", "Ina\,\ Nagano",
"818893", "Sakawa\,\ Kochi",
"818836", "Mima\,\ Tokushima",
"819943", "Kanoya\,\ Kagoshima",
"818585", "Kurayoshi\,\ Tottori",
"818584", "Kurayoshi\,\ Tottori",
"818382", "Hagi\,\ Yamaguchi",
"819432", "Yame\,\ Fukuoka",
"818844", "Anan\,\ Tokushima",
"819954", "Kajiki\,\ Kagoshima",
"81138", "Hakodate\,\ Hokkaido",
"817732", "Fukuchiyama\,\ Kyoto",
"81764", "Toyama\,\ Toyama",
"814998", "Ogasawara\,\ Tokyo",
"812839", "Sano\,\ Tochigi",
"819955", "Kajiki\,\ Kagoshima",
"812696", "Iiyama\,\ Nagano",
"812677", "Saku\,\ Nagano",
"81923", "Fukuoka\,\ Fukuoka",
"815995", "Ago\,\ Mie",
"812486", "Sukagawa\,\ Fukushima",
"812837", "Sano\,\ Tochigi",
"812873", "Otawara\,\ Tochigi",
"811863", "Kazuno\,\ Akita",
"818657", "Kasaoka\,\ Okayama",
"812679", "Saku\,\ Nagano",
"815994", "Ago\,\ Mie",
"811526", "Abashiri\,\ Hokkaido",
"817618", "Kaga\,\ Ishikawa",
"8169", "Osaka\,\ Osaka",
"818203", "Yanai\,\ Yamaguchi",
"817463", "Yoshino\,\ Nara",
"812243", "Shiroishi\,\ Miyagi",
"811556", "Obihiro\,\ Hokkaido",
"818552", "Hamada\,\ Shimane",
"81723", "Sakai\,\ Osaka",
"812550", "Yasuzuka\,\ Niigata",
"814287", "Ome\,\ Tokyo",
"815982", "Matsusaka\,\ Mie",
"811958", "Iwate\,\ Iwate",
"817955", "Sanda\,\ Hyogo",
"812572", "Kashiwazaki\,\ Niigata",
"811562", "Honbetsu\,\ Hokkaido",
"811364", "Kutchan\,\ Hokkaido",
"812374", "Murayama\,\ Yamagata",
"812993", "Ishioka\,\ Ibaraki",
"819732", "Hita\,\ Oita",
"814289", "Ome\,\ Tokyo",
"814703", "Tateyama\,\ Chiba",
"812375", "Murayama\,\ Yamagata",
"817368", "Iwade\,\ Wakayama",
"811365", "Kutchan\,\ Hokkaido",
"8126178", "Omachi\,\ Nagano",
"81262", "Nagano\,\ Nagano",
"819803", "Nago\,\ Okinawa",
"817954", "Nishiwaki\,\ Hyogo",
"812936", "Mito\,\ Ibaraki",
"815763", "Gero\,\ Gifu",
"8153976", "Hamamatsu\,\ Shizuoka",
"812389", "Yonezawa\,\ Yamagata",
"818667", "Ibara\,\ Okayama",
"811853", "Oga\,\ Akita",
"812692", "Nakano\,\ Nagano",
"81183", "Yuzawa\,\ Akita",
"818690", "Okayama\,\ Okayama",
"81550", "Gotenba\,\ Shizuoka",
"812898", "Kanuma\,\ Tochigi",
"817736", "Maizuru\,\ Kyoto",
"815398", "Hamamatsu\,\ Shizuoka",
"811522", "Shari\,\ Hokkaido",
"818669", "Soja\,\ Okayama",
"812387", "Nagai\,\ Yamagata",
"819964", "Satsumasendai\,\ Kagoshima",
"81266", "Suwa\,\ Nagano",
"81167", "Furano\,\ Hokkaido",
"81798", "Nishinomiya\,\ Hyogo",
"819965", "Satsumasendai\,\ Kagoshima",
"812482", "Shirakawa\,\ Fukushima",
"811354", "Yoichi\,\ Hokkaido",
"811552", "Obihiro\,\ Hokkaido",
"81998", "Kagoshima\,\ Kagoshima",
"818556", "Gotsu\,\ Shimane",
"817965", "Toyooka\,\ Hyogo",
"815753", "Sekigahara\,\ Gifu",
"817964", "Toyooka\,\ Hyogo",
"812932", "Takahagi\,\ Ibaraki",
"817453", "Yamatotakada\,\ Nara",
"81743", "Nara\,\ Nara",
"818365", "Ube\,\ Yamaguchi",
"812560", "Itoigawa\,\ Niigata",
"818364", "Ube\,\ Yamaguchi",
"818562", "Masuda\,\ Shimane",
"818958", "Misho\,\ Ehime",
"812576", "Tokamachi\,\ Niigata",
"815986", "Matsusaka\,\ Mie",
"819744", "Mie\,\ Oita",
"8188095", "Tosashimizu\,\ Kochi",
"818663", "Soja\,\ Okayama",
"817616", "Komatsu\,\ Ishikawa",
"811528", "Bihoro\,\ Hokkaido",
"8125480", "Murakami\,\ Niigata",
"81286", "Utsunomiya\,\ Tochigi",
"8198295", "Hyuga\,\ Miyazaki",
"811857", "Noshiro\,\ Akita",
"819554", "Imari\,\ Saga",
"8126172", "Omachi\,\ Nagano",
"8112391", "Yubari\,\ Hokkaido",
"819555", "Karatsu\,\ Saga",
"812488", "Sukagawa\,\ Fukushima",
"81947", "Tagawa\,\ Fukuoka",
"812698", "Iiyama\,\ Nagano",
"812383", "Yonezawa\,\ Yamagata",
"812892", "Utsunomiya\,\ Tochigi",
"811653", "Shibetsu\,\ Hokkaido",
"819940", "Shibushi\,\ Kagoshima",
"81495", "Honjo\,\ Saitama",
"815392", "Hamamatsu\,\ Shizuoka",
"8125485", "Tsugawa\,\ Niigata",
"817902", "Fukusaki\,\ Hyogo",
"812938", "Mito\,\ Ibaraki",
"8198290", "Nobeoka\,\ Miyazaki",
"81561", "Seto\,\ Aichi",
"817940", "Kakogawa\,\ Hyogo",
"817366", "Iwade\,\ Wakayama",
"8165", "Osaka\,\ Osaka",
"81577", "Takayama\,\ Gifu",
"818952", "Uwajima\,\ Ehime",
"818568", "Tsuwano\,\ Shimane",
"811956", "Iwate\,\ Iwate",
"81492", "Kawagoe\,\ Saitama",
"81199", "Morioka\,\ Iwate",
"81124", "Ashibetsu\,\ Hokkaido",
"817457", "Yamatotakada\,\ Nara",
"812544", "Shibata\,\ Niigata",
"811558", "Hiroo\,\ Hokkaido",
"815582", "Shimoda\,\ Shizuoka",
"812545", "Murakami\,\ Niigata",
"817352", "Shingu\,\ Fukuoka",
"812879", "Nasukarasuyama\,\ Tochigi",
"811869", "Odate\,\ Akita",
"817612", "Komatsu\,\ Ishikawa",
"81939", "Kitakyushu\,\ Fukuoka",
"812673", "Komoro\,\ Nagano",
"812877", "Kuroiso\,\ Tochigi",
"811867", "Takanosu\,\ Akita",
"812833", "Utsunomiya\,\ Tochigi",
"81927", "Fukuoka\,\ Fukuoka",
"81863", "Tamano\,\ Okayama",
"817738", "Maizuru\,\ Kyoto",
"81535", "Hamamatsu\,\ Shizuoka",
"811735", "Goshogawara\,\ Aomori",
"812896", "Kanuma\,\ Tochigi",
"8186993", "Bizen\,\ Okayama",
"8112394", "Yubari\,\ Hokkaido",
"811734", "Goshogawara\,\ Aomori",
"81899", "Matsuyama\,\ Ehime",
"81474", "Funabashi\,\ Chiba",
"81282", "Tochigi\,\ Tochigi",
"818956", "Uwajima\,\ Ehime",
"81532", "Toyohashi\,\ Aichi",
"812578", "Muika\,\ Niigata",
"812247", "Ogawara\,\ Miyagi",
"81958", "Nagasaki\,\ Nagasaki",
"811952", "Ninohe\,\ Iwate",
"81984", "Kobayashi\,\ Miyazaki",
"8153969", "Hamamatsu\,\ Shizuoka",
"819809", "Yaeyama\ District\,\ Okinawa",
"815769", "Shokawa\,\ Gifu",
"819738", "Kusu\,\ Oita",
"814283", "Ome\,\ Tokyo",
"81727", "Ikeda\,\ Osaka",
"81144", "Tomakomai\,\ Hokkaido",
"814709", "Kamogawa\,\ Chiba",
"812999", "Itako\,\ Ibaraki",
"81739", "Tanabe\,\ Wakayama",
"817356", "Kushimoto\,\ Wakayama",
"815586", "Shimoda\,\ Shizuoka",
"812997", "Itako\,\ Ibaraki",
"818558", "Kawamoto\,\ Shimane",
"815767", "Gero\,\ Gifu",};
$areanames{ja} = {"812563", "三条",
"818977", "伯方",
"8161", "大阪",
"81196", "盛岡",
"819674", "熊本一の宮",
"815564", "鰍沢青柳",
"815362", "新城",
"81935", "北九州",
"819947", "志布志",
"817675", "七尾",
"817714", "亀岡",
"812571", "六日町",
"8198292", "延岡",
"819949", "大根占",
"81174", "蟹田",
"812856", "真岡",
"818693", "邑久",
"81463", "平塚",
"812967", "笠間",
"81487", "浦和",
"811235", "夕張",
"817238", "寝屋川",
"818242", "東広島",
"817476", "下市",
"819543", "武雄",
"81424", "武蔵野三鷹",
"818872", "室戸",
"811876", "大曲",
"819727", "臼杵",
"819594", "有川",
"812747", "富岡",
"811645", "留萌",
"81192", "大船渡",
"81270", "伊勢崎",
"811636", "北見枝幸",
"811551", "十勝池田",
"819687", "玉名",
"812658", "伊那",
"81467", "藤沢",
"811395", "江差",
"812963", "下館",
"818474", "府中",
"812782", "沼田",
"8188097", "土佐清水",
"815744", "美濃加茂",
"814280", "立川",
"8188098", "土佐清水",
"812794", "渋川",
"819547", "鹿島",
"812858", "真岡",
"819723", "佐伯",
"818832", "鴨島",
"811585", "遠軽",
"812743", "藤岡",
"8125487", "津川",
"819232", "前原",
"818672", "福渡",
"81950", "平戸",
"8125488", "津川",
"819683", "山鹿",
"812567", "巻",
"818592", "米子",
"818973", "新居浜",
"815732", "恵那",
"814775", "船橋",
"812569", "巻",
"81438", "木更津",
"8186999", "岡山瀬戸",
"817995", "洲本",
"818893", "佐川",
"812656", "伊那",
"819943", "鹿屋",
"811638", "利尻礼文",
"818382", "萩",
"818844", "阿南",
"819432", "八女",
"818584", "倉吉",
"811878", "大曲",
"815955", "上野",
"818697", "備前",
"812873", "大田原",
"812837", "佐野",
"815994", "阿児",
"812679", "佐久",
"811526", "網走",
"81138", "函館",
"814998", "小笠原",
"812839", "佐野",
"81764", "富山",
"819955", "加治木",
"812677", "佐久",
"815982", "松阪",
"812374", "村山",
"812572", "柏崎",
"814703", "館山",
"819732", "日田",
"812993", "石岡",
"815763", "下呂",
"817954", "西脇",
"817368", "岩出",
"811365", "倶知安",
"812243", "白石",
"81723", "堺",
"812550", "安塚",
"8126177", "長野",
"819964", "川内",
"812387", "長井",
"818669", "総社",
"81167", "富良野",
"812482", "白河",
"81798", "西宮",
"818667", "井原",
"812389", "米沢",
"81183", "湯沢",
"811853", "男鹿",
"812692", "中野",
"817736", "舞鶴",
"81550", "御殿場",
"81743", "奈良",
"817453", "大和高田",
"812932", "高萩",
"817917", "竜野",
"818958", "御荘",
"811566", "十勝清水",
"818562", "益田",
"818364", "宇部",
"819744", "三重",
"81581", "高富",
"817965", "豊岡",
"818556", "江津",
"811552", "帯広",
"811354", "余市",
"812383", "米沢",
"811653", "士別",
"812892", "宇都宮",
"814996", "八丈島",
"815392", "浜松",
"811528", "美幌",
"818663", "総社",
"8188095", "土佐清水",
"811857", "能代",
"8112391", "夕張",
"819555", "唐津",
"812544", "新発田",
"817457", "大和高田",
"812972", "水海道",
"81124", "芦別",
"815582", "下田",
"817352", "新宮",
"817366", "岩出",
"81240", "磐城富岡",
"817940", "加古川",
"81561", "瀬戸",
"8198290", "延岡",
"8125485", "津川",
"817902", "福崎",
"817459", "大和榛原",
"81199", "盛岡",
"81492", "川越",
"812833", "宇都宮",
"812877", "黒磯",
"81535", "浜松",
"817738", "舞鶴",
"811735", "五所川原",
"8186993", "備前",
"812879", "烏山",
"812673", "小諸",
"817612", "小松",
"81739", "田辺",
"812997", "潮来",
"814707", "大原",
"81220", "迫",
"818558", "川本",
"815767", "下呂",
"81474", "船橋",
"811952", "二戸",
"812247", "大河原",
"818956", "宇和島",
"815769", "荘川",
"812999", "潮来",
"814709", "鴨川",
"81727", "池田",
"81144", "苫小牧",
"818654", "鴨方",
"819826", "日向",
"811733", "五所川原",
"812835", "佐野",
"812586", "長岡",
"812675", "佐久",
"819957", "加治木",
"81934", "北九州",
"81582", "岐阜",
"811367", "寿都",
"811462", "浦河",
"818466", "木江",
"819668", "水俣",
"811456", "門別富川",
"814284", "立川",
"814756", "東金",
"81989", "那覇",
"818796", "土庄",
"813", "東京",
"818802", "窪川",
"811655", "名寄",
"812385", "米沢",
"811541", "弟子屈",
"812648", "長野",
"819553", "伊万里",
"81425", "立川",
"81277", "桐生",
"818665", "高梁",
"8147957", "八日市場",
"819788", "国東",
"812476", "三春",
"812238", "仙台",
"8112393", "夕張",
"817969", "浜坂",
"817915", "相生",
"81586", "一宮",
"81480", "久喜",
"81236", "山形",
"818266", "千代田",
"818512", "西郷",
"81849", "福山",
"817967", "八鹿",
"8188096", "土佐清水",
"812588", "長岡",
"819557", "唐津",
"815978", "熊野",
"819828", "高千穂",
"811855", "能代",
"81273", "高崎",
"814758", "東金",
"81928", "福岡",
"81460", "小田原",
"8125486", "津川",
"81566", "刈谷",
"817455", "大和高田",
"819666", "水俣",
"8164", "大阪",
"8199347", "鹿児島",
"817963", "豊岡",
"81888", "高知",
"815754", "関",
"819786", "杵築",
"811864", "大館",
"81562", "尾張横須賀",
"811737", "鰺ケ沢",
"812875", "大田原",
"812646", "長野",
"819953", "大口",
"81578", "神岡",
"818798", "土庄",
"81969", "天草",
"811363", "倶知安",
"815765", "下呂",
"812995", "石岡",
"8162", "大阪",
"814705", "館山",
"819804", "名護",
"818268", "千代田",
"817464", "吉野",
"818204", "柳井",
"81948", "飯塚",
"812236", "仙台",
"81833", "下松",
"812245", "大河原",
"812478", "三春",
"818688", "美作",
"81569", "半田",
"818975", "新居浜",
"811534", "中標津",
"811332", "当別",
"81191", "一関",
"817993", "洲本",
"81548", "榛原",
"814291", "飯能",
"817944", "加古川",
"811987", "遠野",
"817677", "七尾",
"81765", "魚津",
"81962", "熊本",
"819945", "鹿屋",
"819936", "加世田",
"818895", "須崎",
"815953", "上野",
"81593", "四日市",
"811542", "釧路",
"811974", "水沢",
"818546", "掛合",
"8147955", "八日市場",
"817684", "輪島",
"818298", "廿日市",
"812965", "下館",
"811393", "松前",
"817724", "宮津",
"811237", "栗山",
"8153977", "天竜",
"812917", "水戸",
"818948", "宇和",
"81243", "二本松",
"818378", "下関",
"817494", "彦根",
"812745", "藤岡",
"811583", "紋別",
"819725", "佐伯",
"819576", "島原",
"8112399", "栗山",
"819685", "玉名",
"81557", "伊東",
"81298", "土浦",
"819978", "徳之島",
"817482", "八日市",
"811647", "羽幌",
"8167", "大阪",
"817950", "三田",
"811934", "釜石",
"81740", "今津",
"814792", "銚子",
"811397", "奥尻",
"811233", "千歳",
"812554", "上越",
"81125", "滝川",
"81986", "都城",
"8186691", "倉敷",
"812913", "鉾田",
"818686", "津山",
"8199345", "鹿児島",
"811587", "中湧別",
"81553", "山梨",
"811589", "興部",
"817706", "小浜",
"819938", "加世田",
"811643", "石狩深川",
"814777", "船橋",
"818376", "美祢",
"81227", "仙台",
"811372", "鹿部",
"818946", "宇和",
"818360", "小郡",
"811942", "岩泉",
"812565", "三条",
"817997", "津名",
"812414", "柳津",
"818296", "広島",
"814222", "武蔵野三鷹",
"818548", "石見大田",
"815959", "亀山",
"811983", "花巻",
"812612", "大町",
"817673", "羽咋",
"819976", "名瀬",
"81822", "広島",
"81284", "足利",
"819578", "島原",
"818695", "岡山瀬戸",
"811756", "野辺地",
"815957", "上野",
"81534", "浜松",
"817703", "敦賀",
"811646", "羽幌",
"811635", "浜頓別",
"817712", "亀岡",
"811875", "角館",
"81423", "国分寺",
"815958", "亀山",
"815562", "鰍沢青柳",
"819577", "島原",
"811236", "千歳",
"817475", "下市",
"818549", "石見大田",
"819672", "熊本一の宮",
"818683", "津山",
"818547", "掛合",
"818493", "尾道",
"8153974", "天竜",
"81464", "厚木",
"817998", "津名",
"812855", "小山",
"811753", "むつ",
"811588", "興部",
"8198293", "延岡",
"818874", "安芸",
"811986", "遠野",
"819592", "大瀬戸",
"817676", "七尾",
"819937", "加世田",
"819973", "種子島",
"811398", "熊石",
"818244", "三次",
"818293", "廿日市",
"818373", "長門",
"818943", "八幡浜",
"81930", "行橋",
"811757", "野辺地",
"815956", "上野",
"81177", "青森",
"819979", "徳之島",
"818674", "久世",
"818834", "鴨島",
"81792", "姫路",
"811648", "焼尻",
"819933", "指宿",
"819977", "瀬戸内",
"812792", "渋川",
"812655", "飯田",
"817996", "津名",
"818949", "宇和",
"818297", "廿日市",
"814776", "船橋",
"812784", "沼田",
"815742", "美濃加茂",
"81835", "防府",
"818947", "宇和",
"818377", "下関",
"818299", "広島",
"818472", "甲山",
"811238", "栗山",
"817707", "小浜",
"817678", "七尾",
"81439", "木更津",
"811586", "中湧別",
"81427", "相模原",
"818582", "倉吉",
"818842", "阿南",
"818384", "萩",
"819434", "八女",
"81774", "宇治",
"819573", "諫早",
"81484", "川口",
"818687", "美作",
"815734", "恵那",
"818543", "安来",
"818689", "岡山",
"818594", "米子",
"811396", "江差",
"81432", "千葉",
"819663", "人吉",
"818267", "千代田",
"818555", "江津",
"817966", "八鹿",
"819734", "日田",
"81245", "福島",
"817952", "西脇",
"812477", "三春",
"815984", "松阪",
"812574", "柏崎",
"81744", "大和高田",
"812372", "村山",
"8124197", "柳津",
"811738", "鰺ケ沢",
"817735", "福知山",
"81184", "本荘",
"815992", "鳥羽",
"818797", "土庄",
"811457", "門別富川",
"81724", "岸和田貝塚",
"811352", "余市",
"81225", "石巻",
"812233", "岩沼",
"811554", "帯広",
"814220", "国分寺",
"814757", "東金",
"818362", "宇部",
"811366", "寿都",
"818564", "益田",
"819742", "三重",
"812934", "高萩",
"8198299", "日向",
"818467", "木江",
"812643", "木曾福島",
"81280", "古河",
"81436", "市原",
"819956", "加治木",
"812589", "長岡",
"81763", "福野",
"812694", "中野",
"815979", "熊野",
"811525", "網走",
"819783", "豊後高田",
"812484", "白河",
"815977", "熊野",
"819827", "高千穂",
"812587", "長岡",
"819962", "川内",
"819558", "唐津",
"81143", "室蘭",
"811453", "早来",
"818955", "宇和島",
"812237", "仙台",
"817904", "福崎",
"814753", "茂原",
"81473", "市川",
"817968", "浜坂",
"817354", "新宮",
"812542", "新発田",
"812974", "水海道",
"818463", "竹原",
"812239", "仙台",
"815584", "下田",
"812647", "長野",
"819789", "杵築",
"8186992", "備前",
"819787", "国東",
"812894", "宇都宮",
"815394", "浜松",
"812649", "長野",
"81260", "阿南町",
"811736", "五所川原",
"8111", "札幌",
"815973", "尾鷲",
"819823", "延岡",
"812583", "長岡",
"819667", "水俣",
"818263", "加計",
"811954", "二戸",
"817365", "和歌山橋本",
"812473", "石川",
"819556", "唐津",
"817614", "小松",
"818793", "三本松",
"81738", "御坊",
"818391", "小郡",
"81555", "吉田",
"817363", "和歌山橋本",
"81857", "鳥取",
"814282", "青梅",
"818557", "川本",
"815768", "下呂",
"812998", "潮来",
"8112392", "夕張",
"814708", "大原",
"818265", "安芸吉田",
"81465", "小田原",
"817916", "竜野",
"811464", "静内",
"818559", "川本",
"812475", "石川",
"812248", "大河原",
"811567", "十勝清水",
"812780", "前橋",
"818666", "井原",
"81252", "新潟",
"817737", "舞鶴",
"812878", "烏山",
"81988", "那覇",
"812386", "長井",
"81828", "広島",
"818652", "倉敷",
"811656", "美深",
"818795", "三本松",
"814755", "東金",
"81893", "大洲",
"8199331", "鹿児島",
"818953", "宇和島",
"818514", "海士",
"817458", "大和榛原",
"811455", "鵡川",
"819912", "中之島",
"819204", "郷ノ浦",
"81933", "北九州",
"81848", "尾道",
"812676", "佐久",
"8168", "大阪",
"812585", "長岡",
"812836", "佐野",
"819825", "日向",
"811858", "能代",
"818804", "土佐中村",
"811527", "美幌",
"818957", "御荘",
"812235", "仙台",
"812246", "大河原",
"81834", "徳山",
"815752", "関",
"814706", "大原",
"812996", "潮来",
"815766", "下呂",
"812551", "上越",
"811658", "上川",
"81546", "静岡",
"812388", "長井",
"81937", "北九州",
"81292", "水戸",
"812645", "木曾福島",
"8166", "大阪",
"812876", "黒磯",
"81929", "福岡",
"818668", "井原",
"819785", "豊後高田",
"811523", "斜里",
"818553", "浜田",
"81542", "静岡",
"817367", "岩出",
"81853", "出雲",
"818240", "東広島",
"818202", "柳井",
"819665", "人吉",
"81485", "熊谷",
"817456", "大和高田",
"819802", "南大東",
"811563", "本別",
"8144", "川崎",
"811856", "能代",
"81949", "直方",
"817733", "福知山",
"81775", "大津",
"812838", "佐野",
"812678", "佐久",
"81420", "所沢",
"811862", "鹿角",
"81886", "徳島",
"811637", "北見枝幸",
"81572", "多治見",
"81549", "静岡",
"814281", "相模原",
"819686", "玉名",
"81568", "春日井",
"818698", "備前",
"819575", "諫早",
"811639", "利尻礼文",
"819726", "臼杵",
"811877", "大曲",
"81926", "福岡",
"812890", "宇都宮",
"812746", "富岡",
"81942", "久留米",
"8124196", "柳津",
"81244", "原町",
"817942", "加古川",
"8178", "神戸",
"81979", "中津",
"812568", "巻",
"818545", "木次",
"811532", "根室",
"81946", "甘木",
"81594", "桑名",
"81537", "掛川",
"817484", "八日市",
"812857", "真岡",
"818896", "須崎",
"812653", "飯田",
"81263", "松本",
"819946", "鹿屋",
"819935", "加世田",
"812859", "小山",
"817492", "彦根",
"817722", "宮津",
"81725", "和泉",
"818976", "新居浜",
"811544", "釧路",
"811972", "水沢",
"81922", "福岡",
"817682", "輪島",
"812748", "富岡",
"819728", "臼杵",
"812659", "伊那",
"81533", "豊橋",
"812853", "小山",
"818696", "備前",
"819688", "玉名",
"812657", "伊那",
"819975", "名瀬",
"8112390", "夕張",
"818295", "廿日市",
"817239", "寝屋川",
"812968", "笠間",
"812552", "上越",
"81878", "高松",
"814794", "銚子",
"8198291", "延岡",
"812570", "小出",
"812566", "三条",
"818945", "八幡浜",
"811932", "釜石",
"81862", "岡山",
"818375", "美祢",
"8125484", "村上",
"819948", "志布志",
"817705", "小浜",
"81554", "大月",
"819546", "鹿島",
"811873", "角館",
"812614", "大町",
"8188094", "窪川",
"814224", "武蔵野三鷹",
"818685", "津山",
"81259", "佐渡",
"818978", "伯方",
"812412", "喜多方",
"817473", "五条",
"812930", "水戸",
"811944", "岩泉",
"811374", "森",
"811537", "中標津",
"8125482", "村上",
"817949", "加古川",
"818246", "三次",
"812413", "喜多方",
"81234", "酒田",
"812957", "大子",
"817472", "五条",
"81932", "北九州",
"818598", "根雨",
"81584", "大垣",
"819675", "熊本一の宮",
"811539", "根室標津",
"815738", "中津川",
"817947", "三木",
"817715", "亀岡",
"817674", "羽咋",
"818876", "土佐山田",
"811984", "花巻",
"8188092", "窪川",
"815565", "鰍沢青柳",
"81892", "久万",
"811632", "天塩",
"819438", "田主丸",
"818388", "田万川",
"814700", "鴨川",
"817687", "能都",
"811977", "北上",
"811933", "釜石",
"811234", "千歳",
"817727", "峰山",
"812553", "上越",
"81253", "新潟",
"812788", "前橋",
"817497", "長浜",
"81977", "別府",
"81896", "伊予三島",
"812914", "鉾田",
"818678", "新見",
"819595", "有川",
"815366", "設楽",
"812852", "小山",
"81936", "北九州",
"818838", "阿波池田",
"811644", "留萌",
"81547", "島田",
"817683", "輪島",
"812559", "安塚",
"815745", "美濃加茂",
"815736", "中津川",
"811973", "水沢",
"811937", "宮古",
"8198297", "日向",
"81471", "柏",
"818596", "米子",
"811394", "松前",
"818248", "庄原",
"818475", "府中",
"811939", "宮古",
"817723", "宮津",
"812557", "新井",
"8198298", "日向",
"817493", "彦根",
"811584", "遠軽",
"81228", "築館",
"812795", "渋川",
"812830", "宇都宮",
"812652", "飯田",
"818878", "嶺北",
"81852", "松江",
"81543", "静岡",
"811533", "根室",
"812419", "田島",
"812786", "沼田",
"81564", "岡崎",
"812417", "会津山口",
"817994", "洲本",
"817943", "加古川",
"8153963", "天竜",
"818585", "倉吉",
"818845", "丹生谷",
"818836", "脇町",
"815954", "上野",
"815368", "設楽",
"818676", "久世",
"818660", "岡山瀬戸",
"8175", "京都",
"811863", "鹿角",
"81923", "福岡",
"815995", "阿児",
"812486", "須賀川",
"818657", "笠岡",
"817618", "加賀",
"819954", "加治木",
"817732", "福知山",
"812696", "飯山",
"811364", "倶知安",
"811562", "本別",
"811958", "岩手",
"817955", "三田",
"81964", "松橋",
"814289", "青梅",
"812936", "水戸",
"81262", "長野",
"819803", "名護",
"812375", "村山",
"8169", "大阪",
"818203", "柳井",
"817463", "吉野",
"814287", "青梅",
"818552", "浜田",
"811556", "帯広",
"811522", "斜里",
"81266", "諏訪",
"819965", "川内",
"818690", "岡山",
"812898", "鹿沼",
"815398", "浜松",
"818365", "宇部",
"817908", "播磨山崎",
"812576", "十日町",
"812560", "糸魚川",
"815986", "松阪",
"812978", "竜ケ崎",
"81998", "鹿児島",
"815588", "修善寺大仁",
"817964", "豊岡",
"815753", "関",
"812698", "飯山",
"819940", "志布志",
"81495", "本庄",
"817616", "小松",
"819554", "伊万里",
"81286", "宇都宮",
"8198295", "日向",
"8125480", "村上",
"81947", "田川",
"812488", "須賀川",
"819913", "硫黄島",
"811558", "広尾",
"812545", "村上",
"812938", "水戸",
"8165", "大阪",
"8188090", "窪川",
"818568", "津和野",
"811956", "岩手",
"815757", "郡上八幡",
"818952", "宇和島",
"81577", "高山",
"81927", "福岡",
"815396", "浜松",
"811867", "鷹巣",
"814992", "伊豆大島",
"812896", "鹿沼",
"81863", "玉野",
"811734", "五所川原",
"8112394", "夕張",
"811869", "大館",
"81939", "北九州",
"817356", "串本",
"815586", "下田",
"819807", "沖縄宮古",
"812976", "竜ケ崎",
"81282", "栃木",
"815988", "三瀬谷",
"81899", "松山",
"81984", "小林",
"81958", "長崎",
"818207", "久賀",
"81532", "豊橋",
"812578", "六日町",
"819738", "玖珠",
"819809", "八重山",
"817906", "播磨山崎",
"817362", "和歌山橋本",
"814283", "青梅",
"812834", "宇都宮",
"818655", "鴨方",
"818806", "宿毛",
"818792", "三本松",
"81426", "八王子",
"815997", "阿児",
"812674", "小諸",
"815999", "津",
"81235", "鶴岡",
"812377", "寒河江",
"81585", "揖斐川",
"81797", "西宮",
"817957", "丹波柏原",
"812472", "石川",
"81734", "和歌山",
"814285", "相模原",
"818262", "加計",
"81172", "弘前",
"817959", "三田",
"812582", "長岡",
"819967", "出水",
"812384", "米沢",
"81875", "観音寺",
"815972", "尾鷲",
"819822", "延岡",
"811654", "名寄",
"819969", "中甑",
"818664", "高梁",
"81176", "十和田",
"8186994", "岡山瀬戸",
"817914", "相生",
"812543", "新発田",
"811466", "えりも",
"818462", "竹原",
"814770", "市川",
"819747", "竹田",
"818367", "宇部",
"8152", "名古屋",
"814752", "茂原",
"811357", "岩内",
"818369", "宇部",
"811452", "早来",
"819963", "川内",
"81281", "宇都宮",
"819208", "対馬佐賀",
"819782", "豊後高田",
"8198296", "日向",
"81531", "田原",
"818808", "土佐清水",
"811854", "男鹿",
"81728", "寝屋川",
"812642", "木曾福島",
"817454", "大和高田",
"812547", "村上",
"819743", "三重",
"818363", "宇部",
"812549", "津川",
"812232", "岩沼",
"815755", "関",
"811353", "余市",
"81250", "新津",
"814298", "飯能",
"812874", "大田原",
"815993", "鳥羽",
"811865", "大館",
"812373", "村山",
"819805", "名護",
"815764", "下呂",
"817953", "西脇",
"81793", "姫路",
"8182942", "広島",
"814704", "館山",
"812994", "石岡",
"81188", "秋田",
"812244", "白石",
"818205", "柳井",
"817465", "吉野",
"81565", "豊田",
"819662", "人吉",
"81778", "武生",
"814228", "武蔵野三鷹",
"811546", "釧路",
"818974", "新居浜",
"819679", "高森",
"818542", "安来",
"811535", "厚岸",
"811378", "今金",
"81762", "金沢",
"817945", "加古川",
"81965", "八代",
"819677", "矢部",
"812955", "常陸大宮",
"8153961", "天竜",
"819944", "鹿屋",
"819572", "諫早",
"818894", "須崎",
"818843", "阿南",
"8186553", "倉敷",
"818583", "倉吉",
"817717", "園部",
"812618", "大町",
"817486", "水口",
"81488", "浦和",
"818473", "甲山",
"812964", "下館",
"811336", "石狩",
"815743", "美濃加茂",
"811975", "水沢",
"817685", "輪島",
"817495", "長浜",
"817725", "宮津",
"814798", "八日市場",
"812793", "渋川",
"8147950", "八日市場",
"819932", "指宿",
"812744", "藤岡",
"819597", "福江",
"819724", "佐伯",
"81766", "高岡",
"819684", "山鹿",
"819599", "大瀬戸",
"81433", "千葉",
"81845", "因島",
"818477", "東城",
"818942", "八幡浜",
"811935", "釜石",
"811946", "久慈",
"815747", "美濃白川",
"818372", "長門",
"811376", "八雲",
"811548", "弟子屈",
"814226", "武蔵野三鷹",
"81476", "成田",
"818292", "広島",
"818479", "東城",
"812555", "糸魚川",
"81429", "所沢",
"819972", "種子島",
"819544", "武雄",
"817488", "水口",
"812797", "渋川",
"812616", "大町",
"819593", "大瀬戸",
"812799", "長野原",
"81940", "宗像",
"811752", "むつ",
"81494", "秩父",
"818397", "小郡",
"81985", "宮崎",
"81126", "岩見沢",
"814796", "八日市場",
"812564", "三条",
"818682", "津山",
"817960", "八鹿",
"819673", "熊本一の宮",
"81825", "広島",
"812415", "柳津",
"815563", "鰍沢青柳",
"81468", "横須賀",
"818587", "郡家",
"818847", "牟岐",
"817713", "亀岡",
"81179", "三戸",
"818694", "岡山",
"817702", "敦賀",
"81142", "伊達",
"811634", "浜頓別",
"818588", "郡家",
"81559", "沼津",
"818848", "牟岐",
"812640", "長野",
"8186995", "岡山瀬戸",
"812613", "大町",
"817672", "羽咋",
"819596", "福江",
"811982", "花巻",
"811874", "角館",
"8128798", "大田原",
"812230", "仙台",
"814223", "武蔵野三鷹",
"8183766", "下関",
"81288", "今市",
"817474", "五条",
"81952", "佐賀",
"81538", "磐田",
"818398", "小郡",
"811943", "岩泉",
"81721", "富田林",
"811337", "石狩",
"811642", "石狩深川",
"812854", "小山",
"8188093", "窪川",
"81956", "佐世保",
"817487", "水口",
"812798", "長野原",
"815566", "身延",
"818875", "土佐山田",
"817716", "園部",
"815748", "美濃白川",
"811549", "釧路",
"81583", "岐阜",
"819676", "高森",
"8125483", "村上",
"818478", "東城",
"818245", "三次",
"811232", "千歳",
"81233", "新庄",
"814793", "銚子",
"81567", "津島",
"811547", "白糠",
"8153962", "天竜",
"81832", "下関",
"819598", "福江",
"81276", "太田",
"818675", "久世",
"817483", "八日市",
"812654", "飯田",
"818846", "丹生谷",
"818835", "脇町",
"811582", "紋別",
"818586", "倉吉",
"8186697", "倉敷",
"8112396", "栗山",
"81992", "鹿児島",
"81587", "一宮",
"81294", "常陸太田",
"81229", "古川",
"8186698", "倉敷",
"811392", "木古内",
"81563", "西尾",
"814797", "八日市場",
"812785", "沼田",
"811543", "釧路",
"817718", "園部",
"81544", "富士宮",
"81877", "丸亀",
"815952", "上野",
"812619", "大町",
"812796", "渋川",
"812580", "十日町",
"812617", "大町",
"818385", "萩",
"819435", "八女",
"81272", "前橋",
"814227", "武蔵野三鷹",
"81249", "郡山",
"817992", "洲本",
"818476", "府中",
"814229", "武蔵野三鷹",
"819678", "矢部",
"818595", "米子",
"81268", "上田",
"811377", "八雲",
"811333", "当別",
"811947", "久慈",
"815746", "美濃加茂",
"815735", "恵那",
"814772", "市川",
"818290", "広島",
"818554", "浜田",
"811356", "岩内",
"8186997", "岡山瀬戸",
"815985", "松阪",
"812575", "十日町",
"819746", "竹田",
"819735", "日田",
"811564", "上士幌",
"8153960", "天竜",
"8186998", "岡山瀬戸",
"818366", "宇部",
"81226", "気仙沼",
"811362", "倶知安",
"81944", "瀬高",
"81242", "会津若松",
"819952", "大口",
"817734", "福知山",
"814297", "飯能",
"81596", "伊勢",
"819966", "出水",
"817962", "豊岡",
"811555", "帯広",
"81246", "いわき",
"818680", "岡山",
"81987", "日南",
"81592", "津",
"81839", "山口",
"812376", "寒河江",
"81827", "岩国",
"812935", "水戸",
"81963", "熊本",
"818565", "益田",
"817956", "三田",
"818490", "尾道",
"8188099", "土佐清水",
"812695", "中野",
"812911", "鉾田",
"8182941", "広島",
"81222", "仙台",
"811524", "網走",
"812485", "白河",
"815996", "阿児",
"81924", "福岡",
"8125489", "津川",
"818807", "宿毛",
"818368", "宇部",
"817905", "福崎",
"818954", "宇和島",
"81983", "高鍋",
"8163", "大阪",
"812975", "水海道",
"81823", "呉",
"815585", "下田",
"817355", "新宮",
"819552", "伊万里",
"819968", "出水",
"81864", "倉敷",
"812895", "宇都宮",
"815395", "浜松",
"818803", "土佐中村",
"817364", "和歌山橋本",
"817958", "丹波柏原",
"811955", "二戸",
"81552", "甲府",
"812378", "寒河江",
"81938", "北九州",
"812546", "村上",
"811463", "浦河",
"8145", "横浜",
"81898", "今治",
"815998", "阿児",
"817615", "小松",
"814771", "市川",
"811732", "五所川原",
"814994", "三宅",
"818264", "安芸吉田",
"819808", "八重山",
"811953", "二戸",
"812579", "小出",
"812474", "石川",
"819737", "玖珠",
"817230", "寝屋川",
"818208", "久賀",
"811465", "静内",
"817468", "上北山",
"812577", "六日町",
"815987", "三瀬谷",
"812672", "小諸",
"8183767", "下関",
"817613", "小松",
"81478", "佐原",
"811868", "鷹巣",
"81591", "津",
"8183768", "下関",
"818794", "三本松",
"812832", "佐野",
"81462", "厚木",
"811454", "鵡川",
"814754", "茂原",
"812939", "水戸",
"811557", "十勝池田",
"817903", "福崎",
"814286", "相模原",
"81157", "北見",
"818567", "津和野",
"815758", "郡上八幡",
"817353", "新宮",
"815583", "下田",
"811559", "帯広",
"81466", "藤沢",
"817912", "相生",
"812973", "水海道",
"818464", "竹原",
"812937", "水戸",
"812489", "須賀川",
"819205", "厳原",
"812697", "飯山",
"818662", "高梁",
"812487", "須賀川",
"815393", "浜松",
"818805", "土佐中村",
"818656", "笠岡",
"812893", "宇都宮",
"811652", "士別",
"812382", "米沢",
"812584", "長岡",
"815974", "尾鷲",
"8199343", "鹿児島",
"819824", "延岡",
"818206", "柳井",
"817466", "十津川",
"81486", "浦和",
"812979", "竜ケ崎",
"81729", "八尾",
"8182943", "広島",
"817907", "播磨山崎",
"812234", "仙台",
"815589", "修善寺大仁",
"811553", "帯広",
"817357", "串本",
"818563", "益田",
"81737", "湯浅",
"815587", "修善寺大仁",
"812977", "竜ケ崎",
"817452", "大和高田",
"812933", "高萩",
"819806", "沖縄宮古",
"8112397", "栗山",
"812899", "鹿沼",
"815399", "天竜",
"812644", "木曾福島",
"811852", "男鹿",
"812693", "中野",
"815397", "浜松",
"811866", "鷹巣",
"812483", "白河",
"8112398", "栗山",
"81551", "韮崎",
"819784", "豊後高田",
"812897", "鹿沼",
"81776", "福井",
"819664", "人吉",
"81134", "小樽",
"815756", "郡上八幡",
"812242", "白石",
"811957", "岩手",
"814288", "青梅",
"815762", "下呂",
"81975", "大分",
"812992", "石岡",
"814702", "館山",
"819733", "日田",
"812573", "柏崎",
"815983", "松阪",
"81482", "川口",
"817617", "加賀",
"81545", "富士",
"812872", "大田原",
"81434", "千葉",
"8186996", "岡山瀬戸",
"818383", "萩",
"819433", "八女",
"81779", "大野",
"819942", "大根占",
"819574", "諫早",
"818892", "佐川",
"81742", "奈良",
"815367", "設楽",
"81726", "茨木",
"817726", "峰山",
"81489", "草加",
"81182", "横手",
"817496", "長浜",
"817686", "能都",
"818972", "新居浜",
"815733", "恵那",
"818544", "木次",
"811976", "北上",
"818593", "米子",
"812418", "会津山口",
"819682", "山鹿",
"818879", "室戸",
"81722", "堺",
"817485", "八日市",
"818673", "福渡",
"8182920", "廿日市",
"8186552", "倉敷",
"81925", "福岡",
"814240", "国分寺",
"819233", "前原",
"812742", "藤岡",
"81885", "小松島",
"819722", "佐伯",
"818877", "嶺北",
"818833", "鴨島",
"819934", "指宿",
"812956", "常陸大宮",
"818247", "庄原",
"817946", "三木",
"811938", "宮古",
"811545", "釧路",
"811536", "厚岸",
"818249", "東広島",
"812783", "沼田",
"812558", "新井",
"812962", "下館",
"811754", "むつ",
"818677", "新見",
"81166", "旭川",
"818837", "阿波池田",
"818873", "安芸",
"8125481", "村上",
"819974", "屋久島",
"819542", "武雄",
"818679", "新見",
"818243", "東広島",
"812416", "田島",
"812789", "前橋",
"811978", "北上",
"818294", "廿日市",
"817688", "能都",
"818374", "長門",
"818944", "八幡浜",
"812787", "沼田",
"8188091", "窪川",
"817498", "長浜",
"817728", "峰山",
"814795", "銚子",
"8112395", "栗山",
"81493", "東松山",
"818692", "邑久",
"817704", "敦賀",
"819437", "田主丸",
"818387", "田万川",
"812615", "大町",
"814701", "鴨川",
"815363", "新城",
"81178", "八戸",
"8198294", "延岡",
"812556", "糸魚川",
"818684", "津山",
"814225", "武蔵野三鷹",
"811538", "根室標津",
"811375", "八雲",
"815737", "中津川",
"811936", "宮古",
"811945", "久慈",
"817948", "三木",
"81162", "稚内",
"818597", "根雨",
"812562", "三条",};

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+81|\D)//g;
      my $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;